<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\RateLimiter;

class LoginController extends Controller
{
    public function signin(Request $request)
    {
        $key = 'login-attempts:' . $request->ip();

        if (RateLimiter::tooManyAttempts($key, 5)) {
            return redirect()->back()->withErrors([
                'error' => 'Too many login attempts. Please try again in ' . RateLimiter::availableIn($key) . ' seconds.'
            ])->with('openLoginModal', true);
        }

        $credentials = $request->validate([
            'email' => 'required|email|max:255',
            'password' => 'required|string|min:8',
        ]);

        if (!Auth::attempt($credentials)) {
            RateLimiter::hit($key);
            return redirect()->back()->withErrors([
                'error' => 'These credentials do not match our records.',
            ])->with('openLoginModal', true);
        }

        $user = Auth::user();

        // Check if user is active
        if ($user->status !== 'active') {
            Auth::logout();
            return redirect()->back()->withErrors([
                'error' => 'Your account is banned due to a violation.',
            ])->with('openLoginModal', true);
        }

        $user->update([
            'last_login_ip' => $request->ip(),
        ]);

        $request->session()->regenerate();

        RateLimiter::clear($key);
        return redirect()->intended(route('earnings.index'));
    }

}
