<?php

namespace App\Http\Controllers\Postback\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Setting;
use App\Models\Track;
use App\Models\ReferralLog;

class ApiCallbackController extends Controller
{
    public function index(Request $request, $network_name, $secret_key)
    {
        $networks = [
            'ogads' => 'qK8pR$5vZ2yX9',
            'adgatemedia' => 'mN3&cW6$zQ1lV8',
            'notik' => 'xd8pR$5v15dcyX9'
        ];

        if (empty($networks[$network_name]) || $networks[$network_name] !== $secret_key) {
            return response(
                empty($networks[$network_name]) ? 'Invalid network name.' : 'Invalid secret key for the network.',
                empty($networks[$network_name]) ? 400 : 403
            );
        }

        $rateKey = $network_name === 'ogads' ? 'ogads_rate' : ($network_name == 'notik') ? 'notik' : 'adgate_rate';
        $rate = Setting::getValue($rateKey);

        $payout = $request->input('payout') ?? 0;
        $reward = $payout * $rate;
        $offerName = $request->input('of_name') ?? 'N/A';
        $offerId = filter_var($request->input('of_id'), FILTER_VALIDATE_INT) ?: 0;
        $uid = $request->input('uid');
        $ip = $request->input('ip') ?? '0.0.0.0';
        $country = $request->input('country') ?? 'N/A';
        $status = $request->input('status') ?? 0;
        $transactionId = $request->input('tx_id') ?: 'MTX_' . time() . '_' . rand(1000, 9999);

        $status = $this->determineStatus($request->input('status'), $payout, $reward);
        if (
            Track::where([
                ['partners', $network_name],
                ['transaction_id', $transactionId],
                ['uid', $uid],
                ['status', $status]
            ])->exists()
        ) {
            return response('Transaction ID already exists for this user', 400);
        }

        $user = User::where('uid', $uid)->first() ?? abort(404, 'User not found.');

        $perc = ReferralCommission();

        $bonusAmount = $reward * ($perc / 100);

        if ($user->invited_by && $perc > 0 && $perc <= 100) {
            $invitedByUser = User::find($user->invited_by);
            $invitedByUser->increment('balance', $bonusAmount);
            ReferralLog::create([
                'referrer_id' => $user->invited_by,
                'user_id' => $user->id,
                'earnings' => $bonusAmount,
                'offer_id' => $offerId,
            ]);
        }

        $status == 1 ? $user->increment('balance', $reward) : ($status == 2 ? $user->decrement('balance', $reward) : null);

        $country = $country ?? ($ip != '0.0.0.0' ? getCountryCode($ip) : null);

        Track::create([
            'offer_id' => $offerId,
            'offer_name' => $offerName,
            'transaction_id' => $transactionId,
            'reward' => $reward,
            'payout' => $payout,
            'ip' => $ip,
            'country' => $country,
            'status' => $status,
            'uid' => $uid,
            'partners' => $network_name,
        ]);

        return response('OK', 200);
    }

    private function determineStatus($status, $payout, $reward)
    {
        if (is_null($status)) {
            if ($payout > 0 || $reward > 0) {
                return 1;
            } elseif ($payout < 0 || $reward < 0) {
                return 2;
            } else {
                return null;
            }
        } else {
            if (in_array($status, [1, 'approved', 'completed', 'COMPLETE'])) {
                return 1;
            } elseif (in_array($status, [2, 0, 'rejected', 'RECONCILIATION'])) {
                return 2;
            } else {
                return null;
            }
        }
    }
}
