<?php


namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Models\Offer;


class FetchNotikOffers
{

    public function get()
    {
        if (!isNotikApiEnabled()) {
            return false;
        }

        $setting = loadSettings();

        $app_id     = $setting['notik_app_id'];
        $pub_id     = $setting['notik_pub_id'];
        $api_key    = $setting['notik_api_key'];
        $rate       = $setting['notik_rate'];

        $endpoint   = "https://notik.me/api/v2/get-offers/all?";
        $params     = [
            'api_key'   => $api_key,
            'pub_id'    => $pub_id,
            'app_id'    => $app_id
        ];

        return $this->fetch($endpoint . http_build_query($params), $rate);
    }


    private function fetch($url, $rate)
    {
        set_time_limit(-1);

        $offers     = [];
        $request    = Http::withoutVerifying()->timeout(3)->retry(1, 3)->get($url);
        $response   = $request->json();
        if ($response && isset($response['offers']) && isset($response['offers']['data'])) {
            $this->store($response['offers']['data'], $rate);
            while ($response['offers']['next_page_url']) {
                $next   = Http::withoutVerifying()->timeout(3)->retry(1, 3)->get($response['offers']['next_page_url']);
                $return = $next->json();
                if ($return && isset($return['offers']) && isset($return['offers']['data'])) {
                    $offers[] = $this->store($return['offers']['data'], $rate);
                }

                sleep(60);
            }
        } else {
            dd($request);
            return "Fails to fetch ";
        }
        return $offers;
    }

    private function store($offers, $rate)
    {
        if ($offers && is_array($offers)) {
            foreach ($offers as $offer) {

                if (isset($offer['events'])) {
                    $events = array_map(function ($event) use ($rate) {
                        return [
                            'id' => $event['id'],
                            'name' => $event['name'],
                            'payout' => $event['payout'] * $rate
                        ];
                    }, $offer['events'] ?? []);
                } else {
                    $events = [];
                }


                Offer::updateOrCreate([
                    'offer_id' => $offer['offer_id'],
                    'partner' => 'notik'
                ], [
                    'name'          => htmlspecialchars_decode($offer['name'] ?? '', ENT_QUOTES),
                    'description'   => htmlspecialchars_decode($offer['description1'] ?? '', ENT_QUOTES),
                    'creative'      => $offer['image_url'],
                    'event'         => json_encode($events),
                    'payout'        => $offer['payout'] * $rate,
                    'link'          => $offer['click_url'],
                    'countries'     => isset($offer['country_code']) ? implode(', ', $offer['country_code']) : "-",
                    'device'        => isset($offer['devices']) ? implode(', ', $offer['devices']) : "-",
                ]);
            }
        }
    }
}
