<!DOCTYPE html>
<html lang="en">

<head>
    @include($activeTemplate . '.partials.header')
    
    @yield('styles')
</head>

<body>
    <div class="preloader">
        <div class="spinner"></div>
    </div>

    <!-- Top Navigation Bar -->
    @include($activeTemplate . '.partials.menus.top-bar')


    @if (session('success') || session('error'))
        @include($activeTemplate . '.partials.alerts.alerts')
    @endif

    @yield('content')

    <!-- Cookie Bar -->
    <div class="cookie-bar">
        <div class="cookie-container">
            <div class="d-flex align-items-center">
                <img src="{{ asset('assets/' . $activeTemplate . '/images/cookie.png') }}" alt="Cookie" class="me-2" />
                <span class="text-white fw-semibold">We use cookies!</span>
            </div>
            <div class="cookie-content my-3">
                <p class="text-white fw-medium">
                    This site uses cookies to enhance your browsing experience and analyze site traffic. By continuing
                    to use this site, you agree to our use of cookies as outlined in our
                    <a href="{{ route('privacy.policy') }}" class="text-decoration-underline text-white">Privacy
                        Policy</a>.
                </p>
            </div>
            <div class="row flex-column flex-md-row">
                <div class="col mb-3 mb-md-0">
                    <button class="cookie-btn accept" id="acceptCookies">Accept all</button>
                </div>
                <div class="col mb-3 mb-md-0">
                    <button class="cookie-btn reject" id="rejectCookies">Reject all</button>
                </div>
            </div>
        </div>
    </div>

    @guest
        <!-- Modal Auth -->
        @include($activeTemplate . '.partials.modals.auth')
        @include($activeTemplate . '.partials.modals.forgot')
    @endguest

    <!-- JavaScript files -->
    <script src="{{ asset('assets/' . $activeTemplate . '/js/bootstrap.bundle.min.js') }}?v={{ config('app.version') }}">
    </script>
    <script src="{{ asset('assets/' . $activeTemplate . '/js/custom.min.js') }}?v={{ config('app.version') }}"></script>

    @guest
        <script>
            function selectCreateAccountTab() {
                document.getElementById("login-tab").classList.remove("active");
                document.getElementById("login").classList.remove("show", "active");

                document.getElementById("create-account-tab").classList.add("active");
                document.getElementById("create-account").classList.add("show", "active");
            }

            document.getElementById("authModal").addEventListener("hide.bs.modal", function() {
                document.getElementById("login-tab").classList.add("active");
                document.getElementById("login").classList.add("show", "active");

                document.getElementById("create-account-tab").classList.remove("active");
                document.getElementById("create-account").classList.remove("show", "active");
            });

            document.addEventListener('DOMContentLoaded', function() {
                // Check if the login modal should be opened
                @if (session('openLoginModal'))
                    var loginModal = new bootstrap.Modal(document.getElementById('authModal'));
                    loginModal.show();
                @endif

                // Check if the registration modal should be opened
                @if (session('openRegisterModal'))
                    selectCreateAccountTab();
                @endif

                // Check if the forgot password modal should be opened
                @if (session('openForgotModal'))
                    var forgotModal = new bootstrap.Modal(document.getElementById('forgotModal'));
                    forgotModal.show();
                @endif
            });


            document.addEventListener("DOMContentLoaded", function() {
                const token = "{{ isset($token) ? $token : '' }}";
                if (token) {
                    includeResetModal();
                }
            });

            function includeResetModal() {
                const modalContainer = document.createElement('div');
                modalContainer.innerHTML = `@include($activeTemplate . '.partials.modals.reset')`;
                document.body.appendChild(modalContainer);

                const modal = modalContainer.firstChild; // Assuming the first child is the modal
                modal.style.display = 'block';
                modal.classList.add('show');

                // Close modal when clicking outside of it
                window.onclick = function(event) {
                    if (event.target === modal) {
                        closeModal(modal);
                    }
                };
            }

            function closeModal(modal) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                modal.remove();
            }
        </script>
    @endguest

    @if (isCaptchaEnabled())
        {!! NoCaptcha::renderJs() !!}
    @endif

    @if (googleAnalyticsKey())
        <!-- Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ googleAnalyticsKey() }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());

            gtag('config', '{{ googleAnalyticsKey() }}');
        </script>
    @endif

    @yield('scripts')
</body>

</html>
