<button class="api-offers-card swiper-slide mb-2" data-bs-toggle="modal" data-bs-target="#ApiModal"
    data-name="{{ $name }}" data-creative="{{ $creative }}" data-payout="{{ number_format($payout, 2) }}"
    data-device="{{ $device }}" data-requirements="{{ $requirements }}" data-link="{{ $link }}"
    data-description="{{ $description }}" data-event='@json($event)'>
    <div class="row align-items-center">
        <div class="col-auto">
            <img src="{{ $creative }}" alt="{{ $name }}" class="img-fluid" />
        </div>
        <div class="col">
            <p class="mb-0 fw-semibold">
                {{ strlen($name) > 10 ? substr($name, 0, 10) . '...' : $name }}</p>
            <small class="d-flex justify-content-start align-items-center mb-2 fs-13">Game</small>
            <div class="d-flex justify-content-between align-items-center">
                @php
                    $formattedPayout = number_format($payout, 2);
                    [$integerPart, $decimalPart] = explode('.', $formattedPayout);
                @endphp
                <div class="cpi fs-13">{{ siteSymbol() . $integerPart }}.<span>{{ $decimalPart }}</span></div>
                <div class="system d-flex align-items-center justify-content-center ms-3">
                    <img src="{{ asset('assets/' . $activeTemplate . '/images/icons/' . ($device ?: 'desktop') . '.svg') }}"
                        alt="{{ $device ?: 'desktop' }}" />
                </div>
            </div>
        </div>
    </div>
</button>
