@extends($activeTemplate . '.layouts.blank')
@section('styles')
    
    <link rel="stylesheet" href="{{ asset('/assets/templates/garnet/home/css/style.css') }}">
@endsection
@section('title', 'Earn Offer')

@section('content')
    {{-- Start Header Section --}}
    <div class="header">
        
        <div class="container">
            <div class="row align-items-center min-vh-100">
                <div class="col-lg-6 header-text">
                    <h1 class="poppins-bold mb-4">Get paid for <br>
                        <span class="typed-text"></span>
                    </h1>
                    <p class="poppins-regular mb-4">Make up to $50/hr completing simple tasks</p>
                    <div class="d-flex gap-3">
                        <a href="#" class="btn btn-primary brand-bg poppins-medium"  data-bs-toggle="modal" data-bs-target="#authModal"
                        onclick="selectCreateAccountTab()" >Sign Up Free</a>
                        <a href="#" class="btn btn-outline-light poppins-medium"  data-bs-toggle="modal"
                        data-bs-target="#authModal">Login</a>
                    </div>
                </div>
                <div class="col-lg-6 header-image">
                    <img src="{{ asset('/assets/templates/garnet/home/images/hero-apps.svg') }}" alt="Apps"
                        class="img-fluid">
                </div>
            </div>
        </div>
    </div>

    {{-- Start Statistics Section --}}
    <section class="statistics py-5">
        <div class="container">
            <div class="row text-center">
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-1 p-4 rounded-lg">
                        <h3 class="poppins-bold">17m 12s</h3>
                        <p class="poppins-medium">Average Withdrawal Time</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-2 p-4 rounded-lg">
    <h3 class="poppins-bold">$<span id="average-earnings">42.81</span></h3>
    <p class="poppins-medium">Average Daily Earnings</p>
</div>

<script>
    function getRandomEarnings() {
        const min = 42.00; // সর্বনিম্ন মান
        const max = 142.00; // সর্বোচ্চ মান

        // র্যান্ডম দশমিকযুক্ত সংখ্যা তৈরি করা
        return (Math.random() * (max - min) + min).toFixed(2);
    }

    function updateDailyEarnings() {
        const storedDate = localStorage.getItem("earningsDate");
        const storedValue = localStorage.getItem("earningsValue");
        const today = new Date().toISOString().split("T")[0]; // আজকের তারিখ (YYYY-MM-DD)

        if (storedDate !== today) {
            // নতুন দিন শুরু হয়েছে, তাই নতুন মান তৈরি করা হবে
            const newValue = getRandomEarnings();
            localStorage.setItem("earningsDate", today);
            localStorage.setItem("earningsValue", newValue);
            document.getElementById("average-earnings").innerText = newValue;
        } else {
            // আগের দিনের মান দেখানো হবে
            document.getElementById("average-earnings").innerText = storedValue;
        }
    }

    updateDailyEarnings();
</script>

                </div>
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-3 p-4 rounded-lg">
    <h3 class="poppins-bold">$<span id="paid-out-value">50,000</span>+</h3>
    <p class="poppins-medium">Paid Out Yesterday</p>
</div>

<script>
    function getDynamicValue() {
        const min = 17;  // দিনের শুরুর ন্যূনতম মান
        const max = 142; // দিনের শেষে সর্বোচ্চ মান

        const now = new Date();
        const startOfDay = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0); // রাত ১২টা
        const endOfDay = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 23, 59, 59); // রাত ১১:৫৯

        const elapsedTime = now - startOfDay; // দিনের কতটুকু সময় পেরিয়েছে
        const totalDayTime = endOfDay - startOfDay; // পুরো দিনের সময়

        // ধাপে ধাপে বৃদ্ধি করার জন্য একটি ডাইনামিক গণনা
        const dynamicValue = Math.floor(min + ((max - min) * (elapsedTime / totalDayTime)));

        return dynamicValue;
    }

    function updatePaidOutValue() {
        const value = getDynamicValue();
        document.getElementById("paid-out-value").innerText = value;
    }

    updatePaidOutValue(); // প্রথমবার কল করা
    setInterval(updatePaidOutValue, 60000); // প্রতি ১ মিনিট পর আপডেট হবে
</script>

                </div>
            </div>
        </div>
    </section>

    {{-- Start How It Works Section --}}
    <section class="how-it-works">
        <div class="container">
            <h2 class="poppins-bold">How to earn free cash within minutes?</h2>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="step-box">
                        <div class="step-number">1</div>
                        <h4 class="poppins-semibold">Choose an offer</h4>
                        <p class="poppins-regular">Browse through hundreds of high-paying offers and pick what interests you
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="step-box">
                        <div class="step-number">2</div>
                        <h4 class="poppins-semibold">Complete tasks</h4>
                        <p class="poppins-regular">Follow the instructions and complete the offer requirements</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="step-box">
                        <div class="step-number">3</div>
                        <h4 class="poppins-semibold">Get paid instantly</h4>
                        <p class="poppins-regular">Receive your reward immediately after completion</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Start Features Section --}}
    <section class="features py-5">
        <div class="container">
            <h2 class="text-center poppins-bold mb-5">Best ways to earn</h2>
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="feature-box gradient-4 p-4 rounded-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" class="feature-icon"
                            viewBox="0 0 640 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path fill="#ffffff"
                                d="M480.1 96H160a160 160 0 1 0 114.2 272h91.5A160 160 0 1 0 480.1 96zM248 268a12 12 0 0 1 -12 12h-52v52a12 12 0 0 1 -12 12h-24a12 12 0 0 1 -12-12v-52H84a12 12 0 0 1 -12-12v-24a12 12 0 0 1 12-12h52v-52a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v52h52a12 12 0 0 1 12 12zm216 76a40 40 0 1 1 40-40 40 40 0 0 1 -40 40zm64-96a40 40 0 1 1 40-40 40 40 0 0 1 -40 40z" />
                        </svg>

                        <div>
                            <h4 class="poppins-semibold">Play games</h4>
                            <p class="poppins-regular">$5.50 - $120</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="feature-box gradient-5 p-4 rounded-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" class="feature-icon"
                            viewBox="0 0 384 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path fill="#ffffff"
                                d="M336 64h-80c0-35.3-28.7-64-64-64s-64 28.7-64 64H48C21.5 64 0 85.5 0 112v352c0 26.5 21.5 48 48 48h288c26.5 0 48-21.5 48-48V112c0-26.5-21.5-48-48-48zM96 424c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0-96c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0-96c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm96-192c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zm128 368c0 4.4-3.6 8-8 8H168c-4.4 0-8-3.6-8-8v-16c0-4.4 3.6-8 8-8h144c4.4 0 8 3.6 8 8v16zm0-96c0 4.4-3.6 8-8 8H168c-4.4 0-8-3.6-8-8v-16c0-4.4 3.6-8 8-8h144c4.4 0 8 3.6 8 8v16zm0-96c0 4.4-3.6 8-8 8H168c-4.4 0-8-3.6-8-8v-16c0-4.4 3.6-8 8-8h144c4.4 0 8 3.6 8 8v16z" />
                        </svg>

                        <div>
                            <h4 class="poppins-semibold">Take surveys</h4>
                            <p class="poppins-regular">$1.00 - $75</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="feature-box gradient-6 p-4 rounded-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" class="feature-icon"
                            viewBox="0 0 320 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.-->
                            <path fill="#ffffff"
                                d="M272 0H48C21.5 0 0 21.5 0 48v416c0 26.5 21.5 48 48 48h224c26.5 0 48-21.5 48-48V48c0-26.5-21.5-48-48-48zM160 480c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm112-108c0 6.6-5.4 12-12 12H60c-6.6 0-12-5.4-12-12V60c0-6.6 5.4-12 12-12h200c6.6 0 12 5.4 12 12v312z" />
                        </svg>
                        <div>
                            <h4 class="poppins-semibold">Test apps</h4>
                            <p class="poppins-regular">$1.00</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    {{-- Start CTA Section --}}
    <section class="cta py-5 dark-bg">
        <div class="container text-center">
            <h2 class="poppins-bold mb-4">Ready to start earning?</h2>
            <p class="poppins-regular mb-4">Join thousands of users who earn daily with EarnOffer</p>
            <a href="#" class="btn btn-lg btn-primary brand-bg poppins-medium"  data-bs-toggle="modal" data-bs-target="#authModal"
            onclick="selectCreateAccountTab()">Get Started Now</a>
        </div>
    </section>

    {{-- Start Partners Section --}}
    <section class="partners py-5">
        <div class="container">
            <div class="splide">
                <h2 class="text-center poppins-bold mb-5" id="carousel-heading">Trusted by leading brands</h2>
                <div class="row align-items-center splide__track">
                    <div class="splide__list">


                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/adbreakmedia.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/admentum.svg') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/adrevmedia.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/adswedmedia.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/ayetstudios.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/monlix.svg') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/notik.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/og-ads.svg') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/revlum.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/timewall.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                        <div class="col splide__slide partner-logo">
                            <img src="{{ asset('/assets/templates/garnet/home/images/partners/upwall.png') }}"
                                alt="Partner" height="45" width="127">
                        </div>
                    </div>
                    <!-- Add more partner logos as needed -->
                </div>
            </div>
        </div>
    </section>
    
    {{-- Start Statistics Section --}}
    <section class="statistics py-5">
        <div class="container">
            <div class="row text-center">
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-1 p-4 rounded-lg">
                        <h3 class="poppins-bold">{{ number_format($totalUsers) }}</h3>
                        <p class="poppins-medium">Total Users</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-2 p-4 rounded-lg">
                        <h3 class="poppins-bold">{{ number_format($totalOffers) }}</h3>
                        <p class="poppins-medium">Total Offers</p>
                    </div>
                </div>
                <div class="col-lg-4 mb-4">
                    <div class="stat-box gradient-3 p-4 rounded-lg">
                        <h3 class="poppins-bold">${{ number_format($totalPaid) }}+</h3>
                        <p class="poppins-medium">Total Paid</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Start Footer Section --}}
    <div class="footer dark-bg py-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <h5 class="poppins-bold mb-4">@include($activeTemplate . '.partials.logo')</h5>
                    <p class="poppins-regular">The best platform to earn money online by completing simple tasks, playing
                        games, and taking surveys.</p>
                </div>
                <div class="col-lg-4 mb-4">
                    <h5 class="poppins-bold mb-4">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="{{ route('privacy.policy') }}" class="poppins-regular">Privacy Policy</a></li>
                        <li><a href="{{ route('terms.of.use') }}" class="poppins-regular">Terms of Services</a></li>
                        <li><a href="#" class="poppins-regular" data-bs-toggle="modal"
                                data-bs-target="#authModal">Login</a></li>
                        <li><a href="#" class="poppins-regular" data-bs-toggle="modal" data-bs-target="#authModal"
                                onclick="selectCreateAccountTab()">Register</a></li>
                    </ul>
                </div>
                <div class="col-lg-4 mb-4">

                    <a target="_blank" rel="noopener" class="chakra-link css-q3lqpv"
                        href="https://www.trustpilot.com/review/lootdollar.com">
                        <div class="css-sx2oz1">
                            <div class="css-1lcr50o">See our 4 reviews on</div>
                            <div class="css-16esi0s">
                                <img alt="trustpilot logo" width="94"
                                    src="/assets/templates/garnet/home/images/icons/trustpilot.svg"
                                    style="color: transparent;">

                                <img alt="trustpilot rating" width="120" height="22"
                                    src="/assets/templates/garnet/home/images/icons/stars.webp"
                                    style="color: transparent;">

                            </div>
                        </div>
                    </a>

                    <h5 class="poppins-bold my-4">Follow Us</h5>
                    <ul class="list-unstyled d-flex align-items-center justify-content-start gap-2">
                        <li>
                            <a href="https://t.me/lootdollar_official" target="_blank">
                                <img src="{{ asset('assets/' . $activeTemplate . '/images/icons/telegram.svg') }}"
                                    alt="Telegram" height="25" width="25" />
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="copyright text-center pt-4 mt-4">
            <p class="poppins-regular">&copy; 2024 EarnOffer. All rights reserved.</p>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('/assets/templates/garnet/home/js/main.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/typed.js@2.0.12"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var typed = new Typed('.typed-text', {
                strings: ['testing apps', 'testing games', 'testing surveys'],
                typeSpeed: 50,
                backSpeed: 30,
                loop: true,
                backDelay: 2000,
                startDelay: 1000
            });
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var splide = new Splide('.splide', {
                type: 'loop', // or 'loop'
                perPage: 8, // Default items per view
                arrows: false, // Hide navigation
                pagination: false, // Hide dots
                breakpoints: {
                    1024: {
                        perPage: 4
                    }, // Tablet
                    768: {
                        perPage: 2
                    }, // Mobile
                }
            });
            splide.mount();
        });
    </script>

@endsection
