<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\Postback\CallbackController;
use App\Http\Controllers\Postback\Api\ApiCallbackController;
use App\Services\FetchNotikOffers;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\CashoutController;
use App\Http\Controllers\Dashboard\AffiliateController;
use App\Http\Controllers\Dashboard\ProfileController;


Route::get('/artisan', function(){
   Artisan::call('app:distribute-leaderboard');
   Artisan::call('FetchOffers:cron');
});

// Public routes
Route::middleware('guest')->get('/', [DashboardController::class, 'index'])->name('home');
Route::get('/r/{referral_code}', [SiteController::class, 'referralCode'])->name('referral.code');
Route::get('/privacy-policy', [SiteController::class, 'privacy'])->name('privacy.policy');
Route::get('/terms-of-use', [SiteController::class, 'terms'])->name('terms.of.use');

Route::get('/site-statists', [SiteController::class, 'getSiteStatists'])->name('site.statists');

// Postback routes
Route::match(['get', 'post'], '/callback/{param_secret}/{network_slug}', [CallbackController::class, 'index'])
    ->name('postback.callback');
    
// API Notik fetch Offers APIroutes
Route::get('/api/fetch/notik', [FetchNotikOffers::class, 'get'])->name('api.notik.fetch.offer');

// API Offers Postback routes
Route::get('/callback/api/{network_name}/{secret_key}', [ApiCallbackController::class, 'index'])->name('api.postback.callback');

// Authenticated routes
Route::middleware(['auth', 'active', 'auto_ban_country_change', 'auto_vpn_ban'])->group(function () {
    Route::get('/earn', [DashboardController::class, 'index'])->name('earnings.index');

    Route::get('/cashout', [CashoutController::class, 'index'])->name('cashout.index');
    Route::post('/cashout', [CashoutController::class, 'store']);
    Route::get('/affiliates', [AffiliateController::class, 'index'])->name('affiliates.index');

    Route::get('/profile', [ProfileController::class, 'index'])->name('profile.show');
    Route::put('/profile', [ProfileController::class, 'edit']);

    Route::get('/leaderboard', [DashboardController::class, 'leaderboard'])->name('leaderboard.index');

    Route::get('/checkBalanceIncrease', [DashboardController::class, 'checkBalanceIncrease'])->name('checkBalanceIncrease');

});

