<!DOCTYPE html>
<html lang="en">

<head>
    <?php echo $__env->make($activeTemplate . '.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body>
    <div class="preloader">
        <div class="spinner"></div>
    </div>

    <!-- Top Navigation Bar -->
    <?php echo $__env->make($activeTemplate . '.partials.menus.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php if(session('success') || session('error')): ?>
        <?php echo $__env->make($activeTemplate . '.partials.alerts.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Cookie Bar -->
    <div class="cookie-bar">
        <div class="cookie-container">
            <div class="d-flex align-items-center">
                <img src="<?php echo e(asset('assets/' . $activeTemplate . '/images/cookie.png')); ?>" alt="Cookie" class="me-2" />
                <span class="text-white fw-semibold">We use cookies!</span>
            </div>
            <div class="cookie-content my-3">
                <p class="text-white fw-medium">
                    This site uses cookies to enhance your browsing experience and analyze site traffic. By continuing
                    to use this site, you agree to our use of cookies as outlined in our
                    <a href="<?php echo e(route('privacy.policy')); ?>" class="text-decoration-underline text-white">Privacy
                        Policy</a>.
                </p>
            </div>
            <div class="row flex-column flex-md-row">
                <div class="col mb-3 mb-md-0">
                    <button class="cookie-btn accept" id="acceptCookies">Accept all</button>
                </div>
                <div class="col mb-3 mb-md-0">
                    <button class="cookie-btn reject" id="rejectCookies">Reject all</button>
                </div>
            </div>
        </div>
    </div>

    <?php if(auth()->guard()->guest()): ?>
        <!-- Modal Auth -->
        <?php echo $__env->make($activeTemplate . '.partials.modals.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make($activeTemplate . '.partials.modals.forgot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- JavaScript files -->
    <script src="<?php echo e(asset('assets/' . $activeTemplate . '/js/bootstrap.bundle.min.js')); ?>?v=<?php echo e(config('app.version')); ?>">
    </script>
    <script src="<?php echo e(asset('assets/' . $activeTemplate . '/js/custom.min.js')); ?>?v=<?php echo e(config('app.version')); ?>"></script>

    <?php if(auth()->guard()->guest()): ?>
        <script>
            function selectCreateAccountTab() {
                document.getElementById("login-tab").classList.remove("active");
                document.getElementById("login").classList.remove("show", "active");

                document.getElementById("create-account-tab").classList.add("active");
                document.getElementById("create-account").classList.add("show", "active");
            }

            document.getElementById("authModal").addEventListener("hide.bs.modal", function() {
                document.getElementById("login-tab").classList.add("active");
                document.getElementById("login").classList.add("show", "active");

                document.getElementById("create-account-tab").classList.remove("active");
                document.getElementById("create-account").classList.remove("show", "active");
            });

            document.addEventListener('DOMContentLoaded', function() {
                // Check if the login modal should be opened
                <?php if(session('openLoginModal')): ?>
                    var loginModal = new bootstrap.Modal(document.getElementById('authModal'));
                    loginModal.show();
                <?php endif; ?>

                // Check if the registration modal should be opened
                <?php if(session('openRegisterModal')): ?>
                    selectCreateAccountTab();
                <?php endif; ?>

                // Check if the forgot password modal should be opened
                <?php if(session('openForgotModal')): ?>
                    var forgotModal = new bootstrap.Modal(document.getElementById('forgotModal'));
                    forgotModal.show();
                <?php endif; ?>
            });


            document.addEventListener("DOMContentLoaded", function() {
                const token = "<?php echo e(isset($token) ? $token : ''); ?>";
                if (token) {
                    includeResetModal();
                }
            });

            function includeResetModal() {
                const modalContainer = document.createElement('div');
                modalContainer.innerHTML = `<?php echo $__env->make($activeTemplate . '.partials.modals.reset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;
                document.body.appendChild(modalContainer);

                const modal = modalContainer.firstChild; // Assuming the first child is the modal
                modal.style.display = 'block';
                modal.classList.add('show');

                // Close modal when clicking outside of it
                window.onclick = function(event) {
                    if (event.target === modal) {
                        closeModal(modal);
                    }
                };
            }

            function closeModal(modal) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                modal.remove();
            }
        </script>
    <?php endif; ?>

    <?php if(isCaptchaEnabled()): ?>
        <?php echo NoCaptcha::renderJs(); ?>

    <?php endif; ?>

    <?php if(googleAnalyticsKey()): ?>
        <!-- Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(googleAnalyticsKey()); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());

            gtag('config', '<?php echo e(googleAnalyticsKey()); ?>');
        </script>
    <?php endif; ?>

    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/templates/garnet/layouts/blank.blade.php ENDPATH**/ ?>