
<?php $__env->startSection('title', 'Add Network'); ?>


<?php $__env->startSection('content'); ?>
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="card px-0">
                    <div class="col-12">
                        <form method="POST" action="<?php echo e(route('admin.network.store')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="card-header bg-dark-lt h3 text-dark bold pt-2 pb-2">
                                Add a Network
                            </div>
                            <div class="card-body">

                                <div class="alert alert-info bg-azure-lt text-black" role="alert">
                                    <span class="fw-bold me-2 text-black">Allowed Macros:</span>
                                    <span class="text-nowrap me-2 text-black">For User ID, use: <span
                                            class="text-danger">[uid]</span>
                                        please add it in the
                                        offerwall URL</span>
                                </div>

                                <div class="row">
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Network name:</label>
                                        <input type="text" class="form-control" name="network_name"
                                            placeholder="Enter network name" value="<?php echo e(old('network_name')); ?>" required />
                                        <?php $__errorArgs = ['network_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col col-lg-6 col-md-5 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Web offerwall URL:</label>
                                        <input type="text" class="form-control" name="offerwall_url"
                                            placeholder="Enter web offerwall URL" value="<?php echo e(old('offerwall_url')); ?>"
                                            required />
                                        <?php $__errorArgs = ['offerwall_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Offerwall description:</label>
                                        <input type="text" class="form-control" name="network_description"
                                            placeholder="Enter offerwall description"
                                            value="<?php echo e(old('network_description')); ?>" />
                                        <?php $__errorArgs = ['network_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <div class="form-label">Network logo:</div>
                                        <input type="file" class="form-control" name="network_image" />
                                        <?php $__errorArgs = ['network_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label for="network-rating" class="form-label">Network Rating</label>
                                        <select id="network-rating" class="form-select" name="network_rating">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?>

                                                    Star<?php echo e($i > 1 ? 's' : ''); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Select Offer Type</label>
                                        <div class="form-selectgroup">
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="network_type" value="offer"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('type', 'offer') == 'offer' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Offer</span>
                                            </label>
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="network_type" value="survey"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('type') == 'survey' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Survey</span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Offerwall availability</label>
                                        <div class="form-selectgroup">
                                            <label class="form-selectgroup-item text-no-wrap">
                                                <input type="radio" name="network_status" value="1"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('network_status', '1') == '1' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Enable</span>
                                            </label>
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="network_status" value="0"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('network_status') == '0' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Disable</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="hr-text mt-4 mb-3 text-blue hr-text-left bold">
                                    Postback Setup
                                </div>
                                <div class="row">
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Postback method:</label>
                                        <div class="form-selectgroup">
                                            <label class="form-selectgroup-item text-no-wrap">
                                                <input type="radio" name="postback_method" value="GET"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('postback_method', 'GET') == 'GET' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">GET</span>
                                            </label>
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="postback_method" value="POST"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('postback_method') == 'POST' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">POST</span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameters visible in URL?</label>
                                        <div class="form-selectgroup">
                                            <label class="form-selectgroup-item text-no-wrap">
                                                <input type="radio" name="param_url_visibility" value="1"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('param_url_visibility', '1') == '1' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Visible</span>
                                            </label>
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="param_url_visibility" value="0"
                                                    class="form-selectgroup-input"
                                                    <?php echo e(old('param_url_visibility') == '0' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Hidden</span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Who will manage exchange rate?</label>
                                        <div class="form-selectgroup">
                                            <label class="form-selectgroup-item text-no-wrap">
                                                <input type="radio" name="postback_exchange" value="backend"
                                                    class="form-selectgroup-input" onclick="toggleExchangeRateInput(true)"
                                                    <?php echo e(old('postback_exchange') == 'backend' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Backend</span>
                                            </label>
                                            <label class="form-selectgroup-item">
                                                <input type="radio" name="postback_exchange" value="adnetwork"
                                                    class="form-selectgroup-input"
                                                    onclick="toggleExchangeRateInput(false)"
                                                    <?php echo e(old('postback_exchange', 'adnetwork') == 'adnetwork' ? 'checked' : ''); ?> />
                                                <span class="form-selectgroup-label">Ad Network</span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3" id="exchangeRateInput"
                                        style="<?php echo e(old('postback_exchange') == 'backend' ? '' : 'display: none'); ?>">
                                        <label class="form-label">Custom Exchange Rate:</label>
                                        <input type="text" class="form-control" name="param_custom_rate"
                                            placeholder="0.5" value="<?php echo e(old('param_custom_rate')); ?>" />
                                    </div>


                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3" id="amountRate">
                                        <label class="form-label text-truncate">Parameter for <span
                                                class="text-dark bold">Reward Amount:</span></label>
                                        <input type="text" class="form-control" name="param_amount"
                                            placeholder="{amount}" value="<?php echo e(old('param_amount')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label text-truncate">Parameter for <span
                                                class="text-dark bold">Payout Amount:</span><small class="text-info"> If
                                                Present</small></label>
                                        <input type="text" class="form-control" name="param_payout"
                                            placeholder="{payout}" value="<?php echo e(old('param_payout')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">User
                                                ID:</span></label>
                                        <input type="text" class="form-control" name="param_user_id"
                                            placeholder="{user_id}" value="<?php echo e(old('param_user_id')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">Offer
                                                ID:</span><small class="text-info"> If
                                                Present</small></label>
                                        <input type="text" class="form-control" name="param_offer_id"
                                            placeholder="{of_id}" value="<?php echo e(old('param_offer_id')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">Offer
                                                Name:</span><small class="text-info"> If
                                                Present</small></label>
                                        <input type="text" class="form-control" name="param_offer_name"
                                            placeholder="{of_name}" value="<?php echo e(old('param_offer_name')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">Transaction
                                                ID:</span><small class="text-info"> If Present</small></label>
                                        <input type="text" class="form-control" name="param_tx_id"
                                            placeholder="{transaction}" value="<?php echo e(old('param_tx_id')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">IP
                                                address:</span><small class="text-danger"> Optional</small></label>
                                        <input type="text" class="form-control" name="param_ip" placeholder="{ip}"
                                            value="<?php echo e(old('param_ip')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">Country
                                                :</span><small class="text-danger"> Optional</small></label>
                                        <input type="text" class="form-control" name="param_country"
                                            placeholder="{country}" value="<?php echo e(old('param_country')); ?>" />
                                    </div>
                                    <div class="col col-lg-3 col-md-4 col-sm-6 col-12 mb-3">
                                        <label class="form-label">Parameter for <span class="text-dark bold">Status
                                                :</span><small class="text-danger"> Optional</small></label>
                                        <input type="text" class="form-control" name="param_status"
                                            placeholder="{status}" value="<?php echo e(old('param_status')); ?>" />
                                    </div>

                                </div>
                                <div class="d-flex flex-row-reverse mt-4">
                                    <button type="submit" class="btn btn-dark">Add Network</button>
                                    <a href="<?php echo e(route('admin.network.add')); ?>" class="btn btn-white me-4">Cancel</a>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function toggleExchangeRateInput(show) {
            const exchangeRateInput = document.getElementById("exchangeRateInput");
            const amountRateInput = document.getElementById("amountRate");

            if (show) {
                exchangeRateInput.style.display = "block";
                amountRateInput.style.display = "none";
            } else {
                exchangeRateInput.style.display = "none";
                amountRateInput.style.display = "block";
            }
        }

        const adNetworkRadio = document.querySelector('input[name="postback_exchange"][value="adnetwork"]');
        toggleExchangeRateInput(!adNetworkRadio.checked);
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/admin/networks/new-network.blade.php ENDPATH**/ ?>