
<?php $__env->startSection('title', 'History'); ?>


<?php $__env->startSection('content'); ?>
    <div class="page-body">
        <div class="container-xl">
            <div class="row">

                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Activities History</h3>
                        </div>
                        <div class="card-body border-bottom py-3">
                            <div class="d-flex">
                                <div class="text-secondary">
                                    Show
                                    <div class="mx-2 d-inline-block">
                                        <form method="GET">
                                            <input type="number" name="perPage" class="form-control form-control-sm"
                                                id="paginationInput" value="<?php echo e($historys->perPage()); ?>"
                                                aria-label="withdraw count">
                                            <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
                                        </form>
                                    </div>
                                    entries
                                </div>
                                <div class="ms-auto text-secondary">
                                    Search:
                                    <div class="ms-2 d-inline-block">
                                        <form method="GET">
                                            <input type="text" name="search" class="form-control form-control-sm"
                                                aria-label="Search withdraw" placeholder="Search..."
                                                value="<?php echo e(request('search')); ?>">
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">

                            <table class="table card-table table-vcenter text-nowrap datatable">
                                <thead>
                                    <th>user id</th>
                                    <th>Offer ID</th>
                                    <th>Offer Name</th>
                                    <th>Reward</th>
                                    <th>Payout</th>
                                    <th>From</th>
                                    <th>IP</th>
                                    <th>Country</th>
                                    <th>Trx ID</th>
                                    <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $historys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><a href="<?php echo e(route('admin.members.info', ['uid' => $history->uid])); ?>"
                                                    target="_blank"><?php echo e($history->uid); ?></a></td>
                                            <td><?php echo e($history->offer_id); ?></td>
                                            <td class="text-secondary">
                                                <?php echo e($history->offer_name); ?>

                                            </td>
                                            <td class="text-secondary">
                                                $ <?php echo e($history->reward); ?>

                                            </td>
                                            <td class="text-secondary">
                                                $ <?php echo e($history->payout); ?>

                                            </td>
                                            <td class="text-secondary text-capitalize">
                                                <?php echo e($history->partners); ?>

                                            </td>
                                            <td class="text-secondary">
                                                <?php echo e($history->ip); ?>

                                            </td>
                                            <td class="<?php echo e($history->country ? 'text-secondary' : 'text-danger'); ?>">
                                                <?php echo e($history->country ?? 'N/A'); ?>

                                            </td>

                                            <td class="text-secondary">
                                                <?php echo e($history->transaction_id ?? 'N/A'); ?>

                                            </td>
                                            <td class="text-secondary">
                                                <?php echo e($history->created_at); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>
                        <?php echo $__env->make('components.admin.pagination', ['paginator' => $historys], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/admin/history.blade.php ENDPATH**/ ?>