
<?php $__env->startSection('title', 'Gateway'); ?>


<?php $__env->startSection('content'); ?>
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <h2 class="page-title">Gateway Setup</h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <div class="row">
                <div class="col-xl-4 col-md-5 col-sm-12">
                    <?php if (isset($component)) { $__componentOriginal07ddb047ae3451301e07dda88a33c35d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal07ddb047ae3451301e07dda88a33c35d = $attributes; } ?>
<?php $component = App\View\Components\Admin\Alert::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Admin\Alert::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal07ddb047ae3451301e07dda88a33c35d)): ?>
<?php $attributes = $__attributesOriginal07ddb047ae3451301e07dda88a33c35d; ?>
<?php unset($__attributesOriginal07ddb047ae3451301e07dda88a33c35d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal07ddb047ae3451301e07dda88a33c35d)): ?>
<?php $component = $__componentOriginal07ddb047ae3451301e07dda88a33c35d; ?>
<?php unset($__componentOriginal07ddb047ae3451301e07dda88a33c35d); ?>
<?php endif; ?>
                    <form method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card">
                            <div class="card-header bg-dark-lt pt-3 pb-2">
                                <h4 class="text-dark">Add Withdrawal Category</h4>
                            </div>
                            <div class="card-body pt-2 row">
                                <div class="mb-3">
                                    <label class="form-label">Gift category name</label>
                                    <input type="text" class="form-control" name="name" placeholder="Amazon Gift Card"
                                        value="<?php echo e(old('name')); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Withdrawal Type</label>
                                    <select class="form-select" name="withdrawal_type">
                                        <option value="cash" <?php echo e(old('withdrawal_type') == 'cash' ? 'selected' : ''); ?>>
                                            Cash</option>
                                        <option value="gift_card"
                                            <?php echo e(old('withdrawal_type') == 'gift_card' ? 'selected' : ''); ?>>Gift Card
                                        </option>
                                        <option value="skins" <?php echo e(old('withdrawal_type') == 'skins' ? 'selected' : ''); ?>>
                                            Skins</option>
                                    </select>
                                    <small class="form-text text-muted">Please select the withdrawal type.</small>
                                </div>

                                <div class="mb-3">
                                    <div class="form-label">Item image</div>
                                    <input type="file" class="form-control" name="cover" accept="image/*">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Gift Background</label>
                                    <input type="text" class="form-control w-100" name="bg_color"
                                        placeholder="Enter your linear gradient CSS here">
                                    <small class="form-text text-muted">
                                        You can generate a linear gradient <a href="https://cssgradient.io/"
                                            target="_blank">here</a> and paste it.
                                    </small>
                                </div>

                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-dark">Add this item</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-lg-8 col-md-7 col-sm-12">
                    <div class="row">
                        <?php $__currentLoopData = $withdrawalsCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-md-6 col-sm-12 mb-3">
                                <div class="card">
                                    <a href="<?php echo e(route('admin.gateways.items.add', $categorie->id)); ?>"
                                        class="d-block border-bottom" style="background: <?php echo e($categorie->bg_color); ?>">
                                        <img src="<?php echo e(url($categorie->cover)); ?>" class="fixed-img-height w-100 card-img-top"
                                            style="max-height: 100%; height: 170px; object-fit: contain;">
                                    </a>
                                    <div class="card-body">
                                        <button class="btn btn-primary w-100 mb-2" data-bs-toggle="modal"
                                            data-bs-target="#modal-edit-<?php echo e($categorie->id); ?>">
                                            Edit
                                        </button>
                                        <button class="btn btn-danger w-100" data-bs-toggle="modal"
                                            data-bs-target="#modal-delete-<?php echo e($categorie->id); ?>">
                                            Delete
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Edit Modal -->
                            <div class="modal modal-blur fade" id="modal-edit-<?php echo e($categorie->id); ?>" tabindex="-1"
                                role="dialog" aria-hidden="true">
                                <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit <?php echo e($categorie->name); ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <form method="post" action="<?php echo e(route('admin.gateways.update', $categorie->id)); ?>"
                                            enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="modal-body">

                                                <div class="mb-3">
                                                    <label class="form-label">Gift category name</label>
                                                    <input type="text" class="form-control" name="name"
                                                        placeholder="Amazon Gift Card"
                                                        value="<?php echo e(old('name', $categorie->name)); ?>">
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label">Withdrawal Type</label>
                                                    <select class="form-select" name="withdrawal_type">
                                                        <option value="cash"
                                                            <?php echo e(old('withdrawal_type', $categorie->withdrawal_type) == 'cash' ? 'selected' : ''); ?>>
                                                            Cash</option>
                                                        <option value="gift_card"
                                                            <?php echo e(old('withdrawal_type', $categorie->withdrawal_type) == 'gift_card' ? 'selected' : ''); ?>>
                                                            Gift Card</option>
                                                        <option value="skins"
                                                            <?php echo e(old('withdrawal_type', $categorie->withdrawal_type) == 'skins' ? 'selected' : ''); ?>>
                                                            Skins</option>
                                                    </select>
                                                </div>

                                                <div class="mb-3">
                                                    <div class="form-label">Item image</div>
                                                    <input type="file" class="form-control" name="cover"
                                                        accept="image/*">
                                                </div>
                                                <div class="mb-3">
                                                    <div class="form-label">Reward Image <span
                                                            class="text-red">(Optional)</span></div>
                                                    <input type="file" class="form-control" name="reward_img"
                                                        accept="image/*">
                                                    <small class="form-text text-muted">This image will be used for email
                                                        rewards.</small>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Gift Background</label>
                                                    <input type="text" class="form-control w-100" name="bg_color"
                                                        placeholder="Enter your linear gradient CSS here"
                                                        value="<?php echo e($categorie->bg_color); ?>">
                                                    <small class="form-text text-muted">
                                                        You can generate a linear gradient <a
                                                            href="https://cssgradient.io/" target="_blank">here</a> and
                                                        paste it.
                                                    </small>
                                                </div>
                                            </div>

                                            <div class="modal-footer">
                                                <a href="#" class="btn btn-link link-secondary"
                                                    data-bs-dismiss="modal">
                                                    Cancel
                                                </a>
                                                <button type="submit" class="btn btn-primary ms-auto">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                                        height="24" viewBox="0 0 24 24" stroke-width="2"
                                                        stroke="currentColor" fill="none" stroke-linecap="round"
                                                        stroke-linejoin="round">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                        <path d="M12 5v14" />
                                                        <path d="M5 12h14" />
                                                    </svg>
                                                    Update category
                                                </button>
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>

                            <!-- Delete Modal -->
                            <div class="modal modal-blur fade" id="modal-delete-<?php echo e($categorie->id); ?>" tabindex="-1"
                                role="dialog" aria-hidden="true">
                                <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
                                    <div class="modal-content">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                        <div class="modal-status bg-danger"></div>
                                        <div class="modal-body text-center py-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon mb-2 text-danger icon-lg"
                                                width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                                stroke="currentColor" fill="none" stroke-linecap="round"
                                                stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M10.24 3.957l-8.422 14.06a1.989 1.989 0 0 0 1.7 2.983h16.845a1.989 1.989 0 0 0 1.7 -2.983l-8.423 -14.06a1.989 1.989 0 0 0 -3.4 0z" />
                                                <path d="M12 9v4" />
                                                <path d="M12 17h.01" />
                                            </svg>
                                            <h3>Are you sure?</h3>
                                            <div class="text-secondary"> Do you really want to delete the
                                                <?php echo e($categorie->name); ?> category and all related items?
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <div class="w-100">
                                                <div class="row">
                                                    <div class="col">
                                                        <form method="post"
                                                            action="<?php echo e(route('admin.categories.destroy', $categorie->id)); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('delete'); ?>
                                                            <button type="submit" class="btn btn-danger w-100"
                                                                data-bs-dismiss="modal">
                                                                Delete
                                                            </button>
                                                        </form>
                                                    </div>
                                                    <div class="col"><a href="#" class="btn w-100"
                                                            data-bs-dismiss="modal">
                                                            Cancel
                                                        </a></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u987726886/domains/lootdollar.com/public_html/core/resources/views/admin/gateways.blade.php ENDPATH**/ ?>