SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


DROP TABLE IF EXISTS `admins`;
CREATE TABLE `admins` (
  `id` bigint UNSIGNED NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `admins` VALUES
(1, 'Md Rahul Hossen Rudro', 'hansal2022@gmail.com', '$2y$12$MfZPtFy7nzb9drOYWtpF4.6nNeBirE.xMKCQvPTxhGK1Tv0EToMbS', 'wE559KeWNgrIAidZJd3MsfuvCfCsL2WdMOM6Dd2yf8q1ACV4iKJsZ3CPHidL', '2025-02-16 12:06:44', '2025-02-24 15:37:19'),
(2, 'Admin', 'alexsalimyt@gmail.com', '$2y$12$I3snrKjLm4u5ZBLmsKSrIeNxKTidv7oqGqtt6I/9vMkDbLAFPM.Ha', NULL, '2025-02-16 12:06:44', '2025-02-16 12:06:44'),
(3, 'Rahul', 'rahulhossen856@gmail.com', '$2y$12$hwKRgcJ8sq.LKM5thNE.leeNr0o3R863KCSF7XXj/4G9vDobYFOnG', 'tACFB9bUHnGXNg27idzyDIodfNYKzQ4PLhe9wKJr3WTnwdjApDDsu0CcXDpK', '2025-02-16 12:06:44', '2025-02-16 12:06:44');

DROP TABLE IF EXISTS `admin_password_reset_tokens`;
CREATE TABLE `admin_password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `cache` VALUES
('login-attempts:2401:1900:aa:773c::1', 'i:1;', 1740466817),
('login-attempts:2401:1900:aa:773c::1:timer', 'i:1740466817;', 1740466817),
('login-attempts:93.175.200.225', 'i:1;', 1740506812),
('login-attempts:93.175.200.225:timer', 'i:1740506812;', 1740506812);

DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint UNSIGNED NOT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint UNSIGNED NOT NULL,
  `reserved_at` int UNSIGNED DEFAULT NULL,
  `available_at` int UNSIGNED NOT NULL,
  `created_at` int UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `leaderboard_settings`;
CREATE TABLE `leaderboard_settings` (
  `id` bigint UNSIGNED NOT NULL,
  `total_prize` decimal(10,2) NOT NULL,
  `number_of_users` int NOT NULL,
  `duration` enum('daily','weekly','monthly') COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `top_ranks_prizes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `distribution_method` enum('linear','exponential') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'linear',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `leaderboard_settings` VALUES
(1, 50.00, 1, 'daily', 1, '\"[\\\"5\\\",\\\"5\\\"]\"', 'exponential', '2024-12-18 19:49:54', '2025-02-24 22:29:54');

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int UNSIGNED NOT NULL,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `migrations` VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2024_10_01_084555_tracks_table', 1),
(5, '2024_10_01_084613_admins_table', 1),
(6, '2024_10_01_084900_terms_of_service_managements_table', 1),
(7, '2024_10_01_084922_networks_table', 1),
(8, '2024_10_01_084957_referral_logs_table', 1),
(9, '2024_10_01_085031_settings_table', 1),
(10, '2024_10_01_085407_create_withdrawals_categories_table', 1),
(11, '2024_10_01_085415_create_withdrawals_histories_table', 1),
(12, '2024_10_01_085422_create_withdrawals_sub_categories_table', 1),
(13, '2024_10_07_182747_create_offers_table', 2),
(14, '2024_10_10_194651_create_leaderboard_settings_table', 3);

DROP TABLE IF EXISTS `networks`;
CREATE TABLE `networks` (
  `id` bigint UNSIGNED NOT NULL,
  `network_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `network_slug` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `network_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `network_description` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `network_rating` int NOT NULL,
  `network_type` enum('offer','survey') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'offer',
  `offerwall_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `postback_method` enum('GET','POST') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'GET',
  `network_status` int NOT NULL DEFAULT '1',
  `param_url_visibility` int NOT NULL DEFAULT '1',
  `param_secret` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `param_amount` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_payout` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_custom_rate` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_user_id` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `param_offer_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_tx_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_offer_name` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_ip` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_country` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `param_status` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `networks` VALUES
(1, 'wannads', 'wannads', 'assets/images/networks/67bc94dfe6394.png', 'Popular', 4, 'survey', 'https://earn.wannads.com/wall?apiKey=oooooo&userId=[uid]', 'GET', 1, 1, 'ucdGt56BeR', '{reward}', '{payout}', NULL, '{user_id}', '{offer_id}', '{transaction_id}', '{offer_name}', '{ip}', NULL, '{status}', '2025-02-24 15:48:47', '2025-02-24 22:08:34'),
(2, 'adswedmedia', 'adswedmedia', 'assets/images/networks/67bcd35937e54.png', 'Hot', 1, 'offer', 'https://adswedmedia.com/offer/Mezv8ehm/[uid]', 'GET', 1, 1, 'y25TDoTkcc', 'A', 'P', NULL, 'U', NULL, NULL, NULL, NULL, NULL, NULL, '2025-02-24 18:17:22', '2025-02-24 20:15:21');

DROP TABLE IF EXISTS `offers`;
CREATE TABLE `offers` (
  `id` bigint UNSIGNED NOT NULL,
  `offer_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `requirements` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payout` decimal(8,2) NOT NULL,
  `link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `creative` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `countries` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `event` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `device` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `partner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `offers` VALUES
(1, 'ROM-AfTB7J', 'Research On Mobile Survey - AU', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IlQxcDM3TGZDcEJzNURLSTEySmlUYkE9PSIsInZhbHVlIjoiMkU3SDNsVnA2bmdHdm4xNWNvQTFWL2VQQ2xGUmxtTzVmUHBEckh2cm43N2o4MFNlVnVNQ2VlV3ZGc2tXZTdYNmZMNTk2MXNkSUFMVFVJYVlrbFRyazhsMmRMSzFRTndHU2FGTmFJeW9wSytKWEhJelp2OXJNYUVJaENOeWNUK0RnR3FCOVlZVVBzQjhMb0xlWitCTmt1d0hsa0c5eUtXQytBZnd6ODRhNjZuQlVUTmR0aVhlSmUwaEcrNFIxUEwrcHp5aHBMWnpVeE5PMnkrTDVrSzJ0djV6WXg5TThqdmZ6RXRnR2QydHA4SXhIWnZrTWNqRFpuMVdZUFBQWWc5aGRUaW1kVGtFejB5dG14NXM0MzhvdTMrR2N3bVNCMVdYclRvb0Qxb2lxK2VJOTJ6dDZkazV6Y1lUUXozUXZ5Y0RjYkJpWWd3VG5iL0VsdTkvZWdBR2hoWmNCSlhYOTV6YXBsRC92dDQzVEJ2OHkyYzViUWd0L1JZYjdvUmplUklaS3lGaWpja2FxeE1QUmJtR1NSb25kdz09IiwibWFjIjoiYjhiMTUxMTljOGYyNjI3YjY4ODFjMjNkYzM1ZjMzMGM4OThiYjY4NjA4ZDAzZTQ0MDFhYmE4YTc1OTQ5ZmZiNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:10:58'),
(2, 'ROM-1Vk0uu', 'Research On Mobile Survey - BR', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IkVHRWZueFJQWUwxSEQzWk14RFQxMGc9PSIsInZhbHVlIjoicFh3b3lZU3RTZkVtSldweE81VHJjNVJzelZLYytKMUVaSVJVbmdHTEJxNitUdjBNV2dsQTBKWmd2cUlDeWZpL0grZDI1MHhVUkRIVzRVZzlQOGY4elhYUWl1RUVLTnpmOW9kSldSNFRaeUk0c1JROE00WEsxTUtod1ZpOGhvcC81L242dklOWHZXRFJSVVppYkJsL1NGUnBvMnpPTW9zKzY1ZUVtRlZzRHVjOGtRQm9iVnQxcW9CVldMVUVJMzVVOUxhVlFKNlRDeE51SlRUcDF2NHR2bmtQTk9YaDdXQUg0aUJIQm5vZHNGUExBaHVWZTY3eVNzcDJ1a000OTdiUkpXeUFyZlRIN0dWSkJDV3llSUR5RVd4dlE2c29lZDBlRlhYelhqcWhEOHB2Q3h6NUdIWmNMSitaSGJGaXVVTU12YTVkOFlXSmxtcVpHUkQrR0xTYTFmb2lHZmt6SUdCWkdXUHFlamlPbTBuL3lla2xnd1RPSi8wUEVnbXNHSjNkeGlwWXZpbXduTW5kUWFudVF2OTQzZz09IiwibWFjIjoiMjQ0MWU2MmQ4NWY3ZmM0MmU0ODFlMDA3NmNiZDM4ZmJlOTYwMDlkNWEyMWJiNDBkOWZjZWY2MzllNjQyMjhiNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:10:59'),
(3, 'ROM-c5bbIQ', 'Research On Mobile Survey - CN', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IkwvbHhpdm50Ly9ZMDhtRzNuWlpMeXc9PSIsInZhbHVlIjoid0oxcHIzdTR1MDd3aXdEVXAxdzI4MTZoUFN4akV6ZHdleEJ4OXdWTHBLbFdBOEhRNHE3WlA1aVAvQ2dPWUZEdXFpS2haRkIwcjNoV1FCR2FIYkxPN1ZVT2plOTQ5b2ZYcXpPbmwwYVFBc1ZIbmJTNmJxZGUxcFNndkhSYnRGWmVrb0FSWmVrOW5nV3V0R2pnM09DZytoVWc2UGxLWTZ4d216UHJ5eGlWSEYzM1V4K3V2M2JmODJYR2ZVSDlmOGFEWklQWnBPNWlRdVhsSEdtY3hRUkgrOHZqQ0l3QksyWVJFbEc5d1I2c0E5d25QdmY4c01GS0F5K2FDTHE2N3hYYjNhWVVGNldtY1pYV3ZxR2Q5YTFWVFR1d2FIK3REZENQdWNnSjZQZ0twa0NLL2dvVzNIOGFObjYvQ2xqWU80eWRENHJQaEhyS055L0JDNU15OENxbWxoelBVOW1nMytaU0JGc1RMSm5LSHhwWkdOYUd5N3NHUXV2cjF6TkgxYXI0TFlIRWIzRG1saDBnQ2NWQ0E0MXdWUT09IiwibWFjIjoiYjg4ZjFkY2M5YWIxZGE5ODcxY2I5ZjNhOTQ3YjIxYTAxMDI0Zjk4ODhmNzQ1NDE2MGRiMTYyOTIyM2FiMDAxZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CN', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:10:59'),
(4, 'ROM-YK5Bay', 'Research On Mobile Survey - DE', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IjIweitFSm5CQ0JnSkhJL1B6ekV0dmc9PSIsInZhbHVlIjoiSXRKVGg5MVJWM0NXbFVSRmovQktqYkIwcFZLekt1dW4wdWNqY0RVZmViTzErYUFCVVhEdmRIUzlrWnNLZlZ1Z3VJbEkybEt3b0pOYVUwbUJ5ZEFlTHlGNGo0L1FsNWRVTGFncTJoQ3hxUU5vMTd5YVpJdFpJMHplV2s0Q3BOYzFxSU01aHd6bEdCQUd1bW40WDlIT01kendoREo3SFdTRVd1dXZvQS9odkk4NHlKd2ZFOENUQUhlSGl2UmdkZzhIZStJRDkvTFNPUmNQRkc3WDJKWjI3amF0ci9yWDlWYmkxZlFqMGJnWk1hVVFBb1lUUzR1N3Y4eGlKeXF4WklWZldjdXFuNFkzSWdCZ0krdS85dFlpNldQWmJYbVNFSG1BSU1PdW81QXB4K1Z1bElTVUEzc25MMzNWUlk3cGkyNnhjMEpUeDdlQ0pKMXprNzNidS9CK2dENWZXMlBxVGVGdUNPN2FGdEdkeURMMFFvVDNvcmU4Mmg4MENaZWtvdkFYcHNnamZaWlc2ZkF2ZjFXUlExL0RPdz09IiwibWFjIjoiZTA1YjE3NmI4ZDFiZDYxNDcwZWFkODMwYWZiYzkxM2U2MTEyMTZjYTZmNmNjYjI4OGU3MTRkMjY3ZmMzZjg4MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:10:59'),
(5, 'ROM-UlPwq4', 'Research On Mobile Survey - GB', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6ImhIYm5RL2ZTb3NEUHh1Yi9tbEtvRVE9PSIsInZhbHVlIjoiWk9iUnp0MllwRGZFa3REUUgrR0wxN0wvVlN1V2orQUlEWFRwUzF4YVI5Znc2bEZlT3VqV3M1Z0ZaOUVaYUs1ZUhOOUdTek5nNFNLSi8xZG9DS2FTOS8zR0UvRXZQdWlCZGxSYzNPeDhwbjdMWnZYUUErVGNNVHFkeEQzeW0wbGVydExxZW51dU42eTR6a0dDUHZDMVgyKzQvRG9hN1ZoSnhrVjV4WUdidUlEdGVmU0VNMk12bjlzL0FqenVNSloxTlcxcHp1amplRGtCYUZhemRZdXdqY0NGbDEwRVE3TXdyVHlGTXRPRGZyNEhablBmaHByU3orQTRMNFlhcWNQY2wvR0JmRUd1S3N2clpwVWdmcXh3NjRERkYwSk1WVEJWZjNaOWZ0dFdKNVZNWld6bEdSYjAzcEVUdkNhc2FvaWV2WmcrNHZwVUp1U3N5REdoZ3lnTE1idlozcGtISjMvQ3QzWTFKc29ZMmVSNGU3REV2UVE1NFBVRENUempRcDZsQi80WHhYbERqdU1TNVprTlpLbnovUT09IiwibWFjIjoiZjdiZjkxNDcyMmUwOTg2ODAxYTg3ZTI3ZjlhOGQ3NDFkNjZlZjA1YmQzMTY3OGUzZTQ5YjhmZTRkNzAzNmQ2OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(6, 'ROM-2LnBo2', 'Research On Mobile Survey - HK', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6ImtnSDU2aE9jdmhXdmgwNUlGRGVLeWc9PSIsInZhbHVlIjoiWGdKM3dBNVhjaGFRRVY3K3YvU0FOWW4xSSsyU1FENi81dzhGUS9ZQ1lwL2ZzZTlCZ3d0a0N4aGhqVGpERy9LUzNiNEhpVWlPZVJRcEswVEU3Y01zMGJhd0lYSUtpOVY2a2xQb2E1d1Y0RnJpdjltUFpZcnhITFB5aHcxdEZramVnY3p0R25nUU42d0E4Nzh3V3E2bUxiY1U3MEp0TzlmbHZXckthUjhxT3dhY0ZRYkJiVXEvREVBaUh3N1VObk1zc01uVDNCb1BaYXFkd0FJWE9VTEpYNmpTVytEQzUrWHVvRXlhZlBvOG55K2swMnV2b3RJVjBRRjJ0NytSZ0pVN1ptNzcyT2JtMVp6eElLZ0lma2dnYm5SOU9LT3B6UDdQZTlhcEVFOW5DUm13TUUzbU15a1QrVjhySzd2QmZDU1JIbEtXMGdVMTdCZ1IvN3d0a0tONS9iVWpXd0RscGU0N0FQYitTc2FwVVZJS09DRXlUM0duSjhobEF5UGpMcUsrYytTOE9mbndmajhmSjM1d0x0YWZnUT09IiwibWFjIjoiYjViM2EwNjQ1MDllZjE1ZGUxYjE4YjljODRjNTA0NmMyNWE5YzkxM2Y3ZTdiMTNlYmY2ZjNkZGVmZTI4MDg4NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(7, 'ROM-M9fcGJ', 'Research On Mobile Survey - IN', '', NULL, 0.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImxGY1ZZbXR6S2x0Qm5hM3JTZmxsZUE9PSIsInZhbHVlIjoiQ1R3WWl5MHBFS1FYdWtRNE54c083SHNLVkVLUXB4MVV4YlcxaGFqZnpDdzY4ZytGcWNZUzFtNFpsb2NrUjFmZ2tBcVVNYTZwQVhSbkNUWUREaFJqOWFoUDNUZnZwQUVKb21YRzRyQTQ2TCsra1QreWhpNnQ3aC8xNFRONHN2MFNya204dVlSTW9MUU9HaTJGMXoxRlpOZ1NKeWdieUNvTVNIWm9XaWp5UEMrZ1hQbHhIVjRISDI2SW1aMGtncWxDaExETGdrSXhvMFJ4MjBEREtxWW5IdVI1c2ljQTlPMmRWVG1qSEpES3g5bVdON1k1ZFBJQ3pOajVuME9ZdGw5VVVNVnZTMFdEODg4UDc2RENzVVBDWEd1T05PalpFUXdFcW9ONU51UjRTeExLVlg0NkRxZnZuWFJnbDJzM1krcFFIVXdJM3FhK255aXFvKy9ydnMybFJKQVNDV2RkdmdXMm51dDVQeWZDUDBZWGJFdks1TXNEbGdrRS85NHp3amhtc1NmWlNVSnBFMTBuSXJwMUZnamdVdz09IiwibWFjIjoiYWE1ODg5OGIzYmQyN2E4YThjNzY3MGE1Y2IzYjQ1M2Y4ZmMwNjg1ZjcwYzJmMTUyOWQzOTg5MGVhODI2MjAwZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(8, 'ROM-NCSy7i', 'Research On Mobile Survey - MX', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IndsTWhaRFIrQlpmS3BOdE5ZTGJJUVE9PSIsInZhbHVlIjoib2FIRU1WcHZPTk5hMGRQUXBVOU9kMUhjUGI2djd0NGpBUzBNL3h1M0MrVXlIK2p6V0J5WDBsb3lqNFlOVDFSdWovVEoxOVlRSThuazZTbVFkZmVOZ3pnT2ducWY5VTc0eU9IeCtRRmluQWxzNDRDL2Z4ZkJ6VXJBb05GeVEzbXduc29PdFA2MWZBazhSb1B3SjRsZ09vUGY1Vm8zbTNMRG9ZVTBmRjBydWQ5dVdBb1I4L1Z5ZXJkcXpQTjE5aUgxbHpzVmJZOEZGajlTeHBKajEvL3BZYlMxeCt3RXhIM2F5WFEwTm14WHRyZWZ5WXdoOTRBa0tOS0ZGTnFkQWE3bzhDeGRqaUJEcmc2NWtSWnlwcGttVVZWaG5FOUdTQkpoQTFVTmJBTTlDOFZiRjZuTWhZdVNMV2xqa3VpYXU1NTBxc0NSaTd1YmF5emJWVGp5T2hvYWJVOWJJeWNKQTlhQ0s5YnJlUWlFdlBsTEgvRVYzRDYrbXE4K3FzYU1FZUlpUTNtV2pqYU04NUpBUU05elE0VEtkdz09IiwibWFjIjoiNmI4OGM4ODFhYzIyNWNhMjYzNWU0ZmVlMjI1NGU1MDhkMzk1MTA1YTU0YzUxMjljOGIwNWNjOTNkMTQ4ZGUyNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(9, 'ROM-Z7s9V0', 'Research On Mobile Survey - NL', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6Im0rZ0VhQmd5aHZaYWMwdGpxZ1M0bWc9PSIsInZhbHVlIjoiL3VFWTMxVHNNejB1cVc0YVVqcis0ellaSzVZeFdWMVlwM2tDb0wvR2g4S1RBMmlIVzZvejdMTzlXK3FHcXdlWUdVVzllRGlSM243ZFFva3AyMWxka2RVZWZGRFVOOFJHTWoxaDhSNHlvWitwYXRpTnhHd0dSZmN4VmFWTTlUYUs0UytmTW9xKzhtSjBHalJzcCt0Rm1iM0tvNy8xY2Jtd2FQMU1WSTkrWWljcDNMaUhMVTdUajlxQTFkN0J2UFlVZzJ3QkpNRXUwSG5aOG92RFdiOVZXdkFNbTFwQVhaemR6V2l1YVhBZE9VL28wR05TU3I2YVRYaks3ZUJLWnVGcDcvZ1J5N2tndG1hQzI2YXNTUkJxTVJJbWZjM3BZVzJSUm9oOUtNSTdaTmU5YUphQm5uSERJYU4vTnU2Y3kvN2JWeFFKRld1RXZ4NU9XU3hId1lDUURlV29CNnFacXE1cFZXWWs4UFkrajBYQnd1NEswY1JYUmVBRnBJaFV3RU9CZC8rRG1BVEZIS0x5Lzk2cTBoNGt3QT09IiwibWFjIjoiNmM5MmMzNzA0NzYwMjBlNmE2MDBjNDA2OGYxNmQ0YTczYzA4MDdjZDgwODlhMjAyZjVlODk1ZWExMDA3ZjViYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NL', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(10, 'ROM-o5UVM4', 'Research On Mobile Survey - NP', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6Im83Z2RZb1JhUWJOekhBUzdQd3pMQ3c9PSIsInZhbHVlIjoiOU1iWnRHTVpMK0F2eG9MVGpXaEt0YUxqQ3ZCSG1QdlY1VFJGZDB3UWU5dmo2S0tqVWU4OExOVDN5aVBTb2pKSGFIYlhjOVJkNDRORUdJdEVkZFlxdmVyWEdLVVBpUHZFbG1PZDBPUC9YTVp0Q0FFaW9EWXpmdGIyazJ2WDI4Ti81YnF3UWhxV2R6bnhmaEZyOGpXcldiNktGTmxNeFJNR0xFQ3YvSXR0aElmaEhIU0x0QWdvQzdrWnFYRG5IU3cwMzJZaFRQOFd2RXdmYzVNT1RqL1M3U3dEazE5S2x1TXJNZncyeHAyNnVIK2oyOFVmaTBBbFZBZWFNajZ0YmNKUWdSYzJybEJHL2NmQnpEeXp5KzNiTVRWV2NDT0U5TXZTMjM5M0hvZVhFem45RnNUa2dkSnFKVDV4c1NHVmpQNzlpSGFMbGNWMGthRWwzQWRoMURSNXg4dHRMSHY0OVJvQWlBd3JUWEZCQUY5elVBbXEyY0ovQmw2cFA1NFdwaXJFM0lTaDBoejdlU3BKQVd2Sk1Vbmxhdz09IiwibWFjIjoiMjc4ZDA1NjBiYmMzNDNjMTg0NjcyYjVjMTM5ZDBjZTllNjhiYTc5NzhmNjBjZDUzZTAwNTA3MTM2YWY0ZTQ1YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NP', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(11, 'ROM-GDRJUj', 'Research On Mobile Survey - PK', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IjBqdGxGblBMcTZ2TmVVSW9LYnZFekE9PSIsInZhbHVlIjoiRWFoQk0vUkFmNHBZdnRBNEhZTG8yMWFIMnpUdUowdjhqcnN3MXRJRHZ5UnZWb1RpbjBaWVJaZFo5b0xCa0cydUltMzU0N1JkdHRNZXFTbmZ0cXZxMDdLRCtpQnlJZFlTdFAvaUhtM1A0bEp2STZCTXBBRk5sbXlZZHJBK2JQUTVySVlVNFY0blRtdTlxdXhxeE9vZjZGeEtIUEJ1TE9yekY2ajYvZ1MzQ0xaZis4VGJPMVhtTGtOQTMraThoNmRBbnZRSURjUVVvM2xxWndENU9IVjVQY3VyWlJ1U2tzMFVaWXVabmdjajBnSXRjWjBNV1JwbGNKR0tzbkxBK3dlenRiQUhuUHRxZUE2Ni9sL2lxdWxUYmFiRnFZOW9Vd3pqK1UwcXpzZmVhcUpXNTRkVHpma01ldXVCdUdHZWdxK3IzNk5tOXUzdUVkZXJxQ2lSdnM3dEs3MDF2WUhMNnlUaHFEeTlBek1kaHdhQXk0UlZDeWpYSW5mOFVvaCtCUC9iR0UwVytWd1lETDl5V09kb2pkZFZndz09IiwibWFjIjoiMDBjY2ZkZmEzN2ZhZmJlMWYzNDJlZThmNzhlNTQxMzAyMWU5NjM0OGRlNzUyNTk3YTdiNTgyYjA0ZTc4MzkzMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PK', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(12, 'ROM-k1T3Aq', 'Research On Mobile Survey - PT', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IjNRMnAvYjVEd3pZZjlMeHl2a3Z0b2c9PSIsInZhbHVlIjoiNHpYYjhpOWdnWUxnVFlLWU5yVGdNbUoydEVvU2doeTVRcVp5L05SSThCdDZXaDF1L0lTeFVoci9CYUY0Tnhla29QTnlib3dPMFlDSWlzMXdnRlVLOFRBeHVBNkloemtGSHR1c0VxZGRXcGl0dVBhcUlPWGsrdXFoVlY1cGl0cjBsVlpuZ1BuN0lUV0k3RG53WW53bThQY0JRQ3NiaHlSRUdNRlEwaDFyeG05NjYyV09BZjJ2d0JzbCsxQzJyQmNDMEQyVkRlK2tZK0tmbEc5Y0JZMWFZRktsNnAwb3h2V0pDbWV1QVpFL0p2cHZ4WkNGZG8rT1gwUW5TdVlDR08rZTRsa3l5NkRVK0N3bHVFelBFL0VOTk02Sjh0TFByNWFnVFRrYUNSU0FZVVI1RWtLbzFabHFxblV5cDBqaW0xRHIwdkYzSFNjNmphaEVwdUNWYjY1cnNRbExIZXJMa2tiSFFjcU02RU9jZitwOWJ3M3FTMThCR0JWNW1HTDhiTVZzbTdNb3lubkwzNEJpdk9zUXQvcW9FQT09IiwibWFjIjoiMzI0ZTBiYjI0ZmQ2YTEwNTlmN2RiZWIwYzNlMzJhNTE1Yjg4NzY1ZjU5ZWZhNjNjMjQzODEyZjNmZGY0NWExMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(13, 'ROM-SwrOLY', 'Research On Mobile Survey - US', '', NULL, 0.53, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5qQ1JVdUI5VDdQWkhrUFFuRjdJUEE9PSIsInZhbHVlIjoiSXFKRnUydDA2cXpRWXdMSG9RSml6QzlMaHhPaFZWUlI1L3R4RDlJTDZmOGU3STY2dEE2dFZxZzlHYjlLNHl4cnBCZ3k4UGZiMmRGQmZjUkdROE1rbHpOMG9WcU1oRzU4UXl0T0hIc2JwNVkzTFlhV3c2Nmc1OXhjVlZra3JrUUlTMXp1V2E2WVNLQWlyQ2J6dHJqN2dWVDF2dk90aVFTUldabVpqOVgzZ3dzMHE0TGpOY1Z1OWdTNi9vbEYrRW40LzdFaDNsWno3UXprUVgzaWpEdWlRUmdwdXRPRnM0QVZKOFZaVlZaZFIwMCtFSGk4aEo3NEhqNVREdTNEUkpwZVpZaDdNRG5JMHVPN214M3daUW9mL0VNTEtmOUo1WXlRb3R0a0VnLzZFVkR6a3JwUmg5cnA0OGJXQjZsUE1EV2ExOHJubFVEQnZuWFV4UnJkWlB1MFdDR1JwS0oxdTFaYS9uNWRWSmFETUFGazNyTUtpdHF5NjdiQzUyWWJTZitRWTNTaGRNazJvTVNsNm1RWGtXRFdBUT09IiwibWFjIjoiMjYyNTZhYWIzNGI3ZTkyNTI3OTIxYjQwYWNkYmVjZDgyOWIzMDZhYzMzNmVkODJhOThkYjA4Njk5MmU5OGM0NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(14, 'ROM-oE02SI', 'Research On Mobile Survey - VE', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9TR2J5azhrM1d6N0t1d1piRXI2d2c9PSIsInZhbHVlIjoiM1QrQ2FkSmw4VmdUYm5QeSswWUcyUkltT2lOUlpNeXB1K2RDc0ZTRTZvNDV0S3dYL2ovcmhGNnpzc1Ftclh0eVV0WWlsTEU2ZjIwclBqMlNhcm1pVGozL3hQUys4d2lBemZVemxCeTdpd3ZENzBpaDNQVlJEemxVcHJMaGhqZkcyL2p3b2x4MnFxNXR6NHkvME1SZStQUlUrWDQrZ0VDM0lSeHhQeVRwS1AzVXZuanM2RTd0cFlpOG1PZXROUzV5YWFQU25LZVRmMHA0eTdIb2l5d1JKTUV0Nm1kQ2FxR2cyV3c4YzgzNCtwMkR4SVpHVkxFbVg1elRDNTJoMTdZTjZ2dDU0MHN4Nk1lNkttdnRyVDZhanVVYmNQNERJaGN1RHl4elJaN1h5VHhzRnJzczl4NDdZYnhPZXNCUmkyRHhxTm9LekYwSkwzWWY4UlcvTUJ5THB2bzFadldUY3B0dW1SQlYzK3RvczdVcnpCcGgzV3Ewa3pseWRuZDdYWldSMzRualcwZ1MyajRmMDE4UmwwRU1Kdz09IiwibWFjIjoiZGJhZDlhMTBmMDk2YWQxZTQ5ZGI2NzVkMmNlNTg4N2Q2YWM2OGI1ZmVjMGRiMTc0NzIzMTdlMDcyMDljNTI0OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'VE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(15, 'ROM-VHAsE7', 'Research On Mobile Survey - AE', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IndiTzVhclBPNTJaWFRtaW5RVWhrV0E9PSIsInZhbHVlIjoiN1hDdUFNbW9DN2kvZy9QK0RvcXZuc0RLWm1maldBcXNMVVlMOXViSEJtbGFKelZmSVpuR0t0OHY5UTRiNDdZT05xM3BDanNZa2ZoTXkvL2trZzF6MzdEYW1NNXE1N0o0Tyt2dVBrbzBobkUzK3V0UFVZdk5SU01vSEdReFdNY1ZsUnZIL25FV2pRZk0zWmNLcXJibzdyajZEZ29CbjhpUCt4Q3BueWlrUzgvM0JEbG9LMm5RcXZKM0VjTFU0OEZlbUpLLzNOdlBSUkljWVJ4anRJbC9UcXd4UzFOdlQrWXVSZ3RwQ3U2RmtsL0NKUjNka0JPR1Rjc2hrQVhpUmN5S1VQRGtIcjB6dTd2WldVN3BhZnBVdmpJWDQ5QW5EakFTeTlwSWRYTFV5TXRGelBsV2liWXlVaGlyWm5TNzkwNUYwYzNkb1Fhak83S01wYUJuQ3hDclB5SEhaYUt0MG55VDFXSThLdFF5dk02ODZSNzRtNytTakxoZzBIWWVYdVJuZ21QNE9KQ2NWU1kydzZlTzFPREVLdz09IiwibWFjIjoiMGU5ODcwMGMwY2VkY2QxOWVlYTRmZmY4NTE1N2JjOWRmNjI3ZjViNDEzZTI2N2IwMGI4MDcwNmRiZjA5ZmU5NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(16, 'ROM-xSRkZH', 'Research On Mobile Survey - AR', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6ImZpRzRIMk42WHlUdDVMMUhMSW1PaEE9PSIsInZhbHVlIjoiU2lxTU1QaEFOakhUY0Mrb2puVUdYU0EyWWhPYVpUU3FaRWRPbzRTaTFTTVY5cG9DTzVlRWMyZWRMVUtBaUwzK1A1OEp4TDNKem5uNG15U2dNY05vZG5GTjE5ZFhkV2lyNWV5ZHNmbDRtUkt6T2VIUG9nazd6YlVJYU10QTB0Vi9IbUxPdGN1blFlcXJHc3lLNG9paWRTbDJYM1pUL2VURDFhVndoYjluejdneGJVVE5FSW9JeW94NkFxUEhTOEY0Y2hQeUR4Y25DQjQvWndFN1lScHkxenhaN1VyNmlvSHU0QU9rNGxtbFJndDJzUSszRHgySEp6Nm0xWjlxUTA5cTZCRDhOU0xWSlBFZHlVa1ZUUmRlaWdHMlhlWnhYZGtiRExEWm9ZejVBSVgySnAySGdJY3d2WFhZeEQ2SnR6N2J0NmxoY3FCNEhId1g1M3p5QzF4dkZ4Wlc5WitJVjNEcFNIamNiMkh1RWdNMUxuUkl1andwTkRrVWVZQmdVQjE5R1ZpNXIvMW1FU29mZ3Y0T1NFaURTdz09IiwibWFjIjoiYjQxMzI0MGE0NmEyMDQyNDU4ZDA0ZjQwMzI5MDExMGYxOTFjNmUxOTBhOTBmMzRmZDIyOGEyMDQ1NWI4NDQ2NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(17, 'ROM-CUImAH', 'Research On Mobile Survey - AT', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6IkNtSVUxNGtrdGZ3VnBYRUxPeVAyN1E9PSIsInZhbHVlIjoiZHBzb3B0TENobHU3aEdodzVLNzBQbjBkTGRxbllLZEIyTlZUdDA4ZnNFWk1KQmphb3BsRDRJa1FGTmtDdHcySkhWMjQ1OTdUVU9wdGM4MkplR1pIdkpIeWFpZUM0RklqR25oVlZoUXFjN0YwdVhXc0s1WGxBbEdQRjdNVm9SQXpEMDR6YVZFUUpueTRMUjhnbzZIbW1nVjE2NDBOTlY2UXkyMWFNMnhxOWxyYUV2T3c1R3Fnb1pDMjhhME03MlA2NGx6NDBtQXhLT2JZeW16QTZzV3h0dVUvelRXNllCWnBzdFdoNkhDSVJVRjBuL1RtR3l3NDdZaTYyVkVFSTVXYkxyWGdRL2RQM1Y1WkJkb2JRK0JQTlVscmdRS0hHTk1IMHNHZ3RQRVdQRHdFbW93UzlTR0FCR0VxVENtMTVndlMvUEJLbERmdHJVbDJQUHBMMEw5T0I4eE1yYWV4Z01iR3Azdm43azVreU9nSEQ0SnY0bHhVc2Rmb1Z6Si9UN3I1LzYzOWZ4OFJxWVY5cGYrOGh5OG1QUT09IiwibWFjIjoiNzI0NjI1ZDZhMzM0YzJkZDVlZGIxYjA2ZTBjY2Y4YjM5M2I5YmYyMDFhNjVhY2FkYzBkMzQ5OTZjYjI4ODc4YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(18, 'ROM-WtJqMN', 'Research On Mobile Survey - BD', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6IkVZbnNBZEtXOEJFa0xPTkF3L2o4M2c9PSIsInZhbHVlIjoiYTdVQ2U5NXhvQlF0SHk4c3cxazhyanFCRHhTczdpMWpCdlpiSWhPall1VWV0SVl0ZEZVaWI5ek4xS3lMOWxqaFFOeHBXOGtyREdob2xDbVFBcURDN3pOdW8zU2Q2K3h6aEp6VkhHVEVXK1VSdTFWbWplMjZiZ2s3RHI2OVV1byt0ZTkzS0drTGNKcVJtaGhORTNUOTF3N1ZUSjQyY2IvVURITzB2dkRHSFdkaDFpME1CL1g5cjExRnd6bnJNdFluaG1XMTc3MU9hYWxKZ0J3VlV0aUloUDFXOWdCamFnU0lsWDBQaTFHSUpxdkN6NE4wVWFHNHpDc3pPRlVrcEZsSG9tQXk3dXpvU082QmtwTEo5ZE5IRjdzUU9ZM2tmSlFad0Y5c25aZEM1emxpUDY5bzQ5eENsSHdOd3VNK2ZXL2NqNElQdExsajk1REZIRTlMNTBsS3dhM2hsY1hVcWs1UnRnVis3R1loMUpZZDhuL2ttNmFFR1hqSllFVHpCL0p3VGxWaXo5WXBoUlFuS0tLVHdOOE5Mdz09IiwibWFjIjoiYjVkMDc3Mjk2MTRiYmI5NTNjN2ViNDY2YTVkZjcwMzVjOTQ0MDA2OTFjYjlmNTVmY2JlOTJhMDYxODRhMDQ1OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BD', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(19, 'ROM-fezUgZ', 'Research On Mobile Survey - BE', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6InNiWEdLc0lRQ2ZNalBEN3F1YURTakE9PSIsInZhbHVlIjoiYklxS2dROXczVFREUEErQ05Nbm1VRElZcVlxdkh1N1lpR1Y0dXpoVWVoam11RXlvcUxZWVMwb1FIdWR4V29QQ3dVa1lVWE1WTUZsczcyZVZTWXV6NXJ6QTRDVW9NN0pteXpnT0NpdUVrd3JsOFcyeVB5bTF4Vm9aS1I1bU1TWWFBRi9OeXFIOVJzRzJQQlZoelNubUpvVEwzdzAxOEwyR1E3K3plbldHaCtFaXBva3RadmFQdG1vRVAyREM5VDZBTDlid2JaeUpPeEFqa294TzJZeE9kSUhtbWhKUi9JNVZLS0FMMXNIM0pCQWVBeG9pb1Nud3k0blZjTmNzUkdUNWtpTjdmMGRQMjFNVVN4akVZUWlObXdkWUZzWFhySFhNdzNqZ0kxZTJvQnlmL0J4Q0xwRnRaSTFVejE4bVJOZG9LbHEvNWpHZWRsUkE4WHpCMlJiNlV4anh6eng5RkRVRWJEMzBSSXZJUzZXRHJ2UHFFcFIzbzVTcXQwZHRLTHl0emtGelZGcnZlTU1vOEhDWmFwbktsUT09IiwibWFjIjoiMjljMWQ0NmIzZmUyN2I5YWI0OTBkNmI2NTY2NjNhMTQyZDZlY2QxYWY5M2I0MTEyMTIxMDgzMmQ0ZjU3N2YxNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(20, 'ROM-gwbxN4', 'Research On Mobile Survey - BG', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5tVS8xTDdob3U4aWVsUHpoN2hMWlE9PSIsInZhbHVlIjoiWFNMMzVRN3lrSzF4TjY0bUVhNVJTdGJoL0RDRmVTeFdKYjhWNXdocFdoYStIdlZTUzJOVXBaaFVpbXpNMlRIVnpsbWQzc2xqd3YyMExyKzNSNjlVUFlSOUpuQ2ZWK1E3ZDRnRWFFeG1ycFFoSDdUNEE1eWdMdHNMTFdTWmV1c2xIejF0SjJtTEZ1U0VjT0xWTHRhT05ZeDk2WjFTTjVZSkdCRXh1aHNFeDF4OHNCMEV5OWpkK3A5Wld6OUc3b3g1S3p4VVRrMGpaT3hsTS8wMWZaakxiYyttaFVla01PZDlJQmFwcC9aOVE5cTBHVThUM2VaY1JVMmE4c3Y2MWJLRnkrQi8xL0lqQk9JdDJyZUJ5RzdSSjRuZVhsbFh5WlRGUVFCU3ZnMXRGTkoxc0thYUV4RHhETk92Z09LNmJvRWpyTEhwa0U1VUpva3NVb2RjOERsdEM2TThTbGIzZ3hjY3NxZ3RHS2xVdEI3eUIyT2ZlM1FBRFhXaldYTkViM1lRYnJwQWdjejJ4dWxXNmg0UlZOMnBYUT09IiwibWFjIjoiZjZkYmI1MzdhYmM4MTIzNzI0OWY1ZTE0Y2Q0ZWJmMGNiOTY2Yzc2N2FhYjlmYTFmYzNlYmU1M2M4ZGQwMDQ5NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BG', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(21, 'ROM-RVhT3d', 'Research On Mobile Survey - BY', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IktBdXJ0Z1FKRFRJeXBYcklpQUtiVnc9PSIsInZhbHVlIjoicFpvc1htZ1llMnNYbitEeUErejJpbDNOVFFJVHNzU1FwY2JPNEVWK2RKaS94UENrMk54NURFVTB5T09USjBYVUt6T1NaZzNFY2sweEc0OUY4dE1lZWpIVHJ3MzVrbWtZV3JDR0dtZklmcjlhVGVVbmlsVzhWQ0VzaUx3YVN6VFBBN0o0T0dsMkRrdGQyR1Z1VmJRbTVIOXNDam1mRTl4SzdlQ09BaWQ0Y1U2ZEZpam00ck5odnVYc0tVbXVsZFQ0U2Jaa0xOa0NQVW9MQ0d5QXJ2blZ1R2tvaFVMWmJBbmdzK1lyaG9qNDFSc1ZGL1owUTdkWDUxL3BTQnhaZGZUZXFCQndxSUd3UkFmUmw5S2gyck9DOWNBcmYvM09RczgvcXFDWWhsV0lVa3dnRkMweGVWVUsxZjIvRlZxSlFrNTZ3dU5VTnpjU1ZmcHhYaURZN3oxR3JKVnlMU1U4dG5LY29oV3VFeU1qMGFRVXdDeFZYVG5TVURsZFVlSUJ5dTZaWTB1VkV1N1h4WnUyNkNBS1JDNHVyZz09IiwibWFjIjoiYmRhYzUxNjZmMDAwNzEwY2U3MzY2M2ZiOThmZjY3OGM2NTZlYTk0ZjRlMTFmODk5NmM1NjQ4ZGZhMjZkMjdjYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BY', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(22, 'ROM-sRUkLR', 'Research On Mobile Survey - CA', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IjZ5QlJ1bWhWaTRQTThkVFNld2JzT0E9PSIsInZhbHVlIjoidzZrOHJoSUNWbithZDRpei93TkhlSUxNSTlERy9aR3I1aXBsRWpwV3RNUEtjZ3RNNUgwUFhsMWEwb0IxTDVYQkprU2pzejlyWDNNc1libnhESmZ2a3RQeXpNQStVbEdGVGxKZTA0TFNFb0tpa2JLeUpFb2kwUlNOTWVGWVhUa1B4YzZoWkExaDdzN2VKY0Rad0k4SXFSUU9lSmI2WHFxanJiR2tzdmU4QWxDNFpWUnBZRkxVaDdNNm1KS3hrRjRQbGF0S0w0Z2YrWlBVUHBlNXBkdDNWcWFhUktkNHM5SGJ5c0Z0d05MNVJxbk5nVlpqTlNaRDR3cVBrRUNxc3M0RExrSXBvcWIwOTJyRHcwWjdnQklLYmdHVlBZSExIVFJLMURpMUVHZnBpVnY0RnF5aytXK3g1VlpjbXM5THh6bzliaS9mYTh0TWhjWEg2OFdObEd1MTlwZDIwcFpDY0M5TWZMWmFBK0pod2dMSk5abWQrTnF3aWc0a2QvTlN5Zkh2akNUdGZOWUZWQVc2QWNweFpndkl2Zz09IiwibWFjIjoiNDI4MGM4MmE2NjA1Nzc2ZjVmYWRiZDJhM2E4MjYyNzhhMzZkODRhZDVlMWQzMTdiYTZiMzk1ZjFlMjUxNTlmYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(23, 'ROM-FzwH5U', 'Research On Mobile Survey - CH', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6ImoyaVMvejhBdERKYTZXb0tDWTVtY3c9PSIsInZhbHVlIjoiK3JyZ3ZnVDJ0cFlJQ05HdFZiUVNNMU11bjFYdlV5a1E4YnBMYXh0UUdnSjRjWU9KTFpMTEFuZkxmM2tEMlEveXZ1clduTXJqMlNJRUxZZHRiRmtlNjZPS3FEaTVqWjJHYzBwZHptRDBLSVQ4MjlmZUhWeDBNUkNEZFZ2aHUwQkdmcXp4VTdmYjhoS1IyUElqblRDSmZNaVhIUWFPbzJaUlNDNHZlTXZnYUdNd0FIaVV5NEt5U3RnSDVSd2JSbHRGRHlLYXRDamF0RlFJS1BROXR3eEtZanQySHk1a3dzTmhJYUdwWUVuZnNTN0oxVmJhbmxjNlg3Yi9lZVF1R3VvMzd4Nlo0Tk4wS0lwR3NkWXNTZG5UUTJKZDRTZ3lJa3JaUHROZWs2MkF3VWMydG1zMXBnZldQc1NlTW9xRzRhVFpkSkU1ZndyczQ0OVpsNHl0d25IN2k4RlBoengrUERaTUkzU204VGpybGR5NTBHb216SGRjaGQxNzhEaHlBeHN4dkRRM0tmZ0lwbnJ3a1g2OFJyc0RYUT09IiwibWFjIjoiM2I0NGJlOGJkYThkODI3ZDI2NTZiNmE5YWVhNjJmOTk2YzdkY2I1NzJmODMwMTM1MTUzZTgwYTcyM2ZkNmQyZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(24, 'ROM-6kdLFp', 'Research On Mobile Survey - CL', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IlBPVDlZcHlWY0QwS2tCb29MYkZKakE9PSIsInZhbHVlIjoiQXU3YXlKOU5IelJhajF2RHlHMUlTZ3ovcGJxODM3bnZURUZRcmo5dVZ2S0dPNk13MGpSVzc4MWZNNU5MTkdYams5YU1XbVpadXlYYTdyeDE3TkQ2YW5yZTNycUYwUVgyL0N5TWdONCtadDdiSjIzTEVuKzNwUnpwVXNSa2pYN21ucTdNaVRmMGVyeWR1SWpJbjdwNzE4VkM1SDFlOGZ6WklGVzlmY0FoM2JGK05xL1k5Q0FyZkxUOU44dFBRclh5ZkFMc0tmQ21keXVIOGxWVk92RUJleDhFZFk3ZTlqbU96MEpkazFFVzNXaVRMbUlJa1FTRU5MYzcvekpYSU1ERU9VQXlBWTY1TS8rYXFBQ2hTT0pJUXRRYk9neFdEWDk0MXVXUzA2TXZ0bTh1VDNiSFhiSUFGbWxEbVNRYjczR0hBZmN0bDZQZ0ZjSlN6ZVg4YVVLb0JpeE5PWTkzNHZSaEs5Y2hCUndTT3g4K0Z5ZE9xdHZ5WFd2ZDVoakkvM2gxcHpPbUhSN2VyOUQzQlhtUUZlNGhkUT09IiwibWFjIjoiYzVjNmVmNDE4ZDlhN2I3NTgyMWExNGQxM2IxYzA0YmE4NDc0MzM5OWQyNmMwZmJkZjA3M2VhNDQxNjg1MGE2YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(25, 'ROM-wZFY5O', 'Research On Mobile Survey - CO', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IkZ2eXExWWJzcTFEeXFURXdKVnV5V3c9PSIsInZhbHVlIjoiQUhuMGdXSlcxSGtVQkxBa0lxSG5IMTRjaG52NFNuYS9adk1CWFVTWGJKRSs0b0IrQW81MStzR2pKWlByaTMwQ0crVmpKUUI2cmxwMW95T2gxbmMwQ0dSUldZLys5WWhlNHJLUVdXNnpsUkpZMmlnaFJ5eGxkdTdpaWtDYTNVZWE1Uy83WGVvQU9Gc1Y2bXpVOHRwb1NuQVBiekVuZFppYVNUbS95R3dRRmd2SDE3TjY1aTlEK2sySGFWanh4V05MODJkUGszUjJXMU5lUENXYzNVVzIwSVBQRHlDTGhNdTVYclI3cWNZZlZTaWo5aWczbUtGRzVSZVV1azdsN3JTQkVBRlJiaWxoaEE3eEtydTFPQ1BFK3JYdjcxbDJLNmNXZEJHU0FxL08rVElJU0JBS0ZvcXFVeStRVVN3ME5Dc09NdnNJOTgzRXdidGtDZVZmMW5JVTFSaCtjYzBxd1JBZE9ZOUJDLys1TDNxcTVRMjF3VGw3OWNlWllzNU9rbENrQkRZWkVMYzRVQ2ZDY2xtWjlybjNSUT09IiwibWFjIjoiY2EyYTQ0YTExYjgyM2ZjMmJiYzU0ZTA2YTI3MjUzNGI3OTJlNTgyZDU5ZjQzMWY0OWExYmY4NjM3M2Y2ODIyMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(26, 'ROM-jn7MJw', 'Research On Mobile Survey - CZ', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6InBTa3FxeW52NWNqeUg0cm90QUVUaEE9PSIsInZhbHVlIjoidnVmK0pMTGx2ZkFVQXBiQ1plVnEydFkzTU9Bb2VRVnlqRndYaW14Um1KUkk0U3BiSXUySk9BZHVvdnBqZldHSkhPVTVFUVFsOXgvdnJJTkQ3ZWJjUGZBb09Ub2NtMGRBZlFkN3NTMkw0NmxkRlNmR0gwMHJsVys4WkRwYVdqNEs2dXUrRi95YU5odDBaUXY3Y1JMczQxK1pYZEdjR0xCZ1ZWK2duSkZYdE5HVUp6eHp3c2I4WnBYZnhDUEdjUWsrNVBlcDJxakhLNi81NmpKYkwyRmkxZzRzUzlpRllGSXpyVUZ3K1JQU2VtL2YxVVJ1V2g3SElLR2VLQXY3aXUrK1czbklJVk5BU2lCSDYvZ0plS3VGNTNscmV1c0p6dUFyRWR2RkM5Vm94WFg1NnJWajBlVG9HTTZNV3N6d2F4ZktXQUFZUGhtWWtkanlsNGtUSlZxVWpsbU5IdDVOVDF4ZnBCU0NKL0pFR3hyU2dRQ2pTK0NOdnZhM21veFBhWkZhOHpOdEsyRGw2Wmd1TFBpUUpTOG4xZz09IiwibWFjIjoiOTYwNWM1Yzc1NzEzZGVmMjg2NGRhMmEyNThkZDY5ZTBiMzc3OWI4NjJlOWIyZTU3NWQzYzk5ODkwYjRkZWNjZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(27, 'ROM-Echtd8', 'Research On Mobile Survey - DK', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6ImYyN2xQajlScXRXbDAycjg3bE1XT1E9PSIsInZhbHVlIjoiRnJtZ1JmS2drdEhDeStKOUxlRDhreHdFRmx5d2pvZGxBVmJySGh6TTRpZC9lclVENStVNUtHOS9kQzhDdFpUTVJaRWNKN3RUbEVJa0JCVUxtQzZ3VnVYWmZDSFUvd0lvYVJuWnRDa2xnQUdhWnQyeXVEd2N2bWdjRldxNU5PNzcrcE1aTnZWVjJvb1EyUlRQRFlFb21jUWFPNEpwVkhtQU1BVVZEb1lzT25zUGdndEtjanlQVkZlRDVHbU94bTZCZjVVOThrR2tJUVVPRXdSYUNMYnBTSjNsa3BaWGg4UnZpWEVCZktZL1FMQVlmK1cvaUVtVXBiOVNndTdtYkF4eVNONVZFRitiSzY2WnRaKzhYYS9tU21odDdYbjNJaDNqVUxsamdWbjlnTTBGQVNnN3FUYVEzQWpybno4ZHNyUDhRc3BQK2VmK2kvNEJoWDMwTEFKWDZySTVhWmlMZmkrb1ZMZ0Y3L25FaU5qc0NjQjJ5WElyWlptMGRpRGJqOWhRNG1NeitTTHhvaC9KMWMwUTZtblpzUT09IiwibWFjIjoiZGEzZWEwNjMxNTBkNzViMDYxZGUzN2Q5MGI4ZTg2MzI5NzI3NmQxMmYzMDNlYzkyYWMyMjM1NjllNDk4Mjg1ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(28, 'ROM-zYC9wL', 'Research On Mobile Survey - DO', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6Ii9Yajk5RmxvUTRQcWNTUE5ISkN2U2c9PSIsInZhbHVlIjoiZ21pTDJVRE9pQ3B5TlBpV0Y2MkFMeXBHenZuRWJnL2M3c3lpbWtSRUlXYTA3WUJhaGpNWUs1ZFVncTRwMHR0Smo0QnhoNUpGK1Q5a2Q4RmhXM1dUdXIxUlBoakQrOFlCVUpERzRYaWR3VGNkZENib3NKSDFETU0rVUFzTFlNWE52d0FBNDI4b1JBWDNsL3VEZ01ybUdENnNTRkFpODUyeERjazBrbWFwYVptWGdSQjcrOU83OU1tR1dwK1oxV04zckttUi9ZWDhkZTRyVlkyL0w4TW9aYVFpcytTeWFkVGFNQjlPZVhpMjhSRkZBZmNqSUFTeHAwdElyRHByZkprcXJ2UitaNTl3UjYrQ1U0YzIyRG9TYXZqdnJKNmNMUDYrbHNRRmljQ0Z3T09iVi9FU2FHVCtDYUR4elMwRmM1YmY5eHBTN1JrdGJYUC9EVm52ZjU0b1FTWjlIM3F2WWZVZ1lZZFB1SWNjNDJ2UEdJc3EwcUVRdW84b0UxMWtkSTM0bHVUUytGNmY5ZG0zbzVUTkxsSll3Zz09IiwibWFjIjoiZjQ4ODE0NzNkNWEyYTc5ZTUxMTA1MWQ2ZTJkNGVkNmRmY2I5N2Y3NTkwYTViNTQ1NWM5NDc1Y2JlMjc2MDRkMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DO', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(29, 'ROM-M4xtws', 'Research On Mobile Survey - DZ', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IlRxUzRwbDBqTytQOU9sbUUxaE0rOFE9PSIsInZhbHVlIjoibloweDR4N1hybnpaZE9kWEJQNFpzbUkzSkZIb0xrdnJwVEdvQU4rRUxXMGNtRzlIRnVWaGozR2JZVWYyUThGemg5bXJhNlFHTGsvZzBpbU5iOWUzWisxUjVMQnFNU0svNkZTZ3ozd3JleHIrV1NwbElFK0NiTTQzVlc5SmsvM0tsSThDcWltMnBHdG85SkJyVkxFUlQwd0tIUUE1ZEpZN2M2UUd6cXdrY3F3dWZUWWpqcGhQYmdiTmFiWFplbDU5UDN2bmUyMTVmcWFPRW42MnBvY2UxMGt3ajdjWG5NejBkSmE1T1BYelF0Wm1RVTFPVjcxbm05UWdRbTRXbkV2UVlIYnVXOEpyWlFKR1dvQmNReFZpYytUNWJaRyt3QWVwcTc2YVdPVnBKZ2w3bGxzU0VodVZUSzdXdUxqcmtHVlFzeFBxYlI4MmR2TDExbVcvbHQxV201L0dLMHpEYmZFM3VGbUlselJqRTlXdk83TVFqQVdmdFRucVIxME1Nai90cGp0bXJIME1zazBoYmUrUndjWE5RUT09IiwibWFjIjoiZjczNWMxMjcwYTNhNDhlOWEyNGQ3Y2VjY2NmOTFlZjY4MWRkOWRiMGMxMmJkNDY3MTY5YmRlYTNmYzc2YzFkNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DZ', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(30, 'ROM-8owR4x', 'Research On Mobile Survey - EC', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6InpnMUxTbkJ0RUlHdGZFMHZ0SURHTWc9PSIsInZhbHVlIjoiNXkxOVVpMTI2QnlNMERLWm45enNKWm9IRExSL1ZBZ0JEZThxbDh4MEF3L0pBUytsNVRZbVd5NWRrR3RtRTZRZjV0Q3VvZzYxbHJMM2puSWpBZVUzU1kwZTFxRXkyRHR1dTNSVjNGbUVkMXRPVUt6UlBEUHNscCs4YXJSbEJYeU04Nzc4eVRZZitTSncreTR5NnRCbkpMcnNuSFhQTUNsNjBFcjFzQjBxdC9WdnpGNm5vanFqaHRUS2t6UnVUUmVmaDRscU0vTG95NFBSaFZKWlQ2UWt6eTdoN3g2MDl0bVg0UEo1US9EZVhQa3dqSVhEOFB6N0FsMTIrZDliNXlpQUYvNXBQVXRaTWozZCtEVUQvSjMxWWg5MTJVdC9mWkt4NFR5M2xTTlBTNW1ab2IzMGMvMklwM2dmdElyS085YThGTTFtWmprbGpIS3hhd1VZQTBuaDN2UmRmUFJPRHVPaEYwVE8zc3BjZUpmcit6eXhHR2IxWSsxdUlCT2xGWWpiclFtb2o2K1dZNjZKOVJrUVVzUW5qUT09IiwibWFjIjoiNmVkZjg0OWZjZGVjMzNiNTY2MDU4ZDViMzM1N2Y5ZjMxNzU1YWZkY2M2ZTFkNGU2ODlhZGI5YTNjYmY1MDY2ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(31, 'ROM-1cMjHK', 'Research On Mobile Survey - EE', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IjFOd0tjeldwelFHYnJFUEczd29pQ1E9PSIsInZhbHVlIjoidXI2M0ZzWWdnZFpoZENremQycTNCcUpLS1lQSDAydzFUQlNOdC9uZ2piVk54ckNNbkZTakdSYUh0TzRRTVA0OFRuZ0dZZVlyMUZkekhrNU9VMmlIYnFqOXZocVRESCtGRFdlZEhRNDNsamxrMmhIUk1SZWtSQ1RpYkxyOGprdi96N0xzRVVKWjh5dnZ6ZUJEdC9MSFBNcE1Pc3JJYlBTUWV0Q0FWTHBBU1BzOFNvd2cwT09ZWmJDMmZhY3k5UURsNnVRVGdMZkhOVUFEUjFuT0VuVXRvc0kyWER2cEY0T0YvK3huVThRdS9wTzN3MDk4ODdzQVh3WmIrcHpyVTk3NW90T1VyNVBlN0tzYkEwY01xVURnbkNhNG01MitPWm9RbnFyVjY2TEtSQ3hJbm5ONDIrWHhWUXFWTGRzZUtXNFAwVUtGTjJlYnZHQ2ZhUVFySGh2RWtHSkZETlVQSVJQZXRmeU9sNjZqOWh5MEwwOFpmVDN3UzhOcHZwVTlPK2lUNXZ0dkMrMmlsc251Y2ZaOTBmVjBndz09IiwibWFjIjoiZGRjMzI4NTA5NzllM2YxMDBhOTgzN2YzNDljODFmY2YxZmJhOTI3ODM1N2FiODJmYjlmNDczN2ExNzc0NzgzZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(32, 'ROM-MVNxf0', 'Research On Mobile Survey - EG', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IkNQVmtuYjI1VlV3OWE1R3VLTXQrMnc9PSIsInZhbHVlIjoiVGVnZG5mdG9sLzFIU2ZxK0tZZkZsZU85YkVWRE1IdDFTVkJBUVVITVBNTWZ4ekxuYWU4TXhEMm5QQXltSURIclJ0K21pN3RoajRhRFF2RzV4UU85bFBTQUF3Zmxqd3hXMjFIemppVVFTZnFFaGR3ajZJNjBMRUJ5NitNVzVDYjlvV2hHc2IwdS9EZG9TcE5sejhPayt4U0QvbmUreFNJaXVxWjVCNit5cFFQVUo1QXBSYXM4SDZpbUE0aW5aM0pKZ2VqNTdtSFVZb0d5WVRSbDRJZHpSQjF2N1MwR2dqdEdUVGNYMkRtbmJYc2QzUUpMQ2NOQlVtbGxyZVRyUSs5MkNxMjA0UU5jYTVlRmlQYWxXcDBwbnpjZXk4MDRsbndtY0Q2SlM2RHZ2ZVNpWVhEVW8wN2oyOW90R0hMVVUyRXlGa3l0ZGVCOCs0a0pkc3ZUZzY2Tkd5eE12TVRmeGdlei9ITnl3eDJLTUswN01qRDlNeWt6VFVKc2pIVHZQQ3lrTS9ReEVTSGM5Qk10RDZaUG0vdmVlUT09IiwibWFjIjoiZTFjMGY3NGQxMTQ0MzAzMjIwYTMzNGM2MWIxYjBmZTA2ZGI1NDUxNzZjNzcwMmVlM2ZkY2I2N2JhMjYzMjE5OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EG', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(33, 'ROM-1Wc4EC', 'Research On Mobile Survey - ES', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ikp0SG9FSC9JYzYvUFMvcU1manBYbWc9PSIsInZhbHVlIjoibjExMDVGdSt4aitZclpMQzQ0TUYxQURVUUNHMnU3alRCdER2MkFEMW1zMTU0bDNBMGIvcGM0dlZ6TU8wOWNqOTdNOFpzcFlsNWpjTkk3aWlTTE56RklMQmFrMllKVkZBQWx2azlITWRTK3JPRTNOd3g4ekkrZGszdDUzcytIbnRmR1FmYXBWcWRqYWY3UHBOOFFMd1ZrUE8vTHl2L2w0ZnV2MlJoZjVtK1l6dVNpVHUwRFgzdklWLzQzUU5rTmZHblVVcHNPcTJrWThTRXlMQW1zdHRWTkl3R2V4RjhLUWNPa3RTYnRYSk1OcEE1OUZMcWhxSXJTUUJnR0lTK1dseGc3NGlqUUdsd05BVk5IaVZMZWZ0NHlDTFhyb3BHSnR6WTg4OXNCQ0IzbjlnNjZvQlVSaTBZdVA1ZnlTaUM3YkhJNXVkMnlaY2Q4OWtXQ2RtQVpXb0cyclM5MFhYZ1pUQXJKZlNhMTdJcmJjK0I1SDNMZG1lUjJoa083cjFhSHYzRWxjZkxoWVdaL2FHZERJdzFmakN4dz09IiwibWFjIjoiOTg0OGI1YzljZTFhNTQ0MzAwOWY4Y2Q5NTFiM2M3Mzc3MDA4MmU0ZWZkZDc4N2IyZjAwYWY1YTVlNGUwMDliOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(34, 'ROM-YttTU9', 'Research On Mobile Survey - FI', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IkxWY1FLaXFraWY2NTFGN1d0dFhrZWc9PSIsInZhbHVlIjoiT0t3ejFaRi9RaUpIdVJWa2Naejdvc2ROU0MyNS9qUjYvVGVtY3drV1E5NWpwb2Fnb25jSFhla1RnR1lSWGtZd3NwdGduMXNMWGg3V3dkU0ZMMTlDMzdNc0JVMEU4Z0t1MXdqQ1lrdXNickM1SWJxU1pwM3ZRRTJ0OTFWQVZ6NDNzdE9pclFxbTl1TnE1OXU1TTEyNzJvVWswNUlUSVRJSVh5Wmd6Nlh4ZGY0eWIrWlRiWXFFWStMb3A1R3I2V2pKQXhlY0p3ZW5nQVRXWTZITi9VaHAxN2FtR3FYc3dpV1poRXdweURnc3hZVWcyUUhiSnlGL2I0b3k0TDRXdVRPQnd1MTFmQTU5QjUyTjgwL1puSUFETFBQMlhZZFpJNjg3SDVPV3V0TE1NYWZzV0NKcDJIVkp4RGUxcjlkZTBNeXk2WmlOVmhKZjN4OVFldnQ1VjBsd1dYNEpKdEVUNmp5WTNCbzJMZklBZFFqZXZBdzU1M2NTY2t4NTdwWVBzREhiZ0FIQmlucjZ4cWZ4Y3lqeFY2RktWdz09IiwibWFjIjoiMDE1ZThiM2IwN2YyMjBmNGExYWM3OTU3MDRjYTg1ZDMwYWMxMmRkNDdjYmZlNzZjMGU2ZjQ3MjNhNmMzNjUxOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(35, 'ROM-Uo4qaq', 'Research On Mobile Survey - FR', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IjdqWkhhUzNkSE96ai81bUpvOGY5Snc9PSIsInZhbHVlIjoiRkJscUZTM254VDRCb1FocHNsUnVpMUlTck55azBZZ2JkamV2c2NVV29LSk81dFFoZGoyRzZuNndMbzRkMzdBZ0lGc1VJSkwraENEcUZDWUEvempvam5wZUc0MTdPVTJ1OVg3bmIraTlCQlliaGdCd0RoMDZmeFhSRUVCMWRjbURJSjdENVc3NjlCeUFYNEhMckYwcFFadVBhTU1SQnAvMlhCSUc1QkRMUnRVcTdzTXAwU3h4eVFvSUozNlF0a3Nnb2ZpVUpwWjNrSFY4RWh5NDhCWFRTUVlYK3d0eXYvMG1RcUUzeHQwU0gxMlFRRCtJT0VIZ1lTMk1Lc2JNeW8wNThoNnlHaUJUVEp1aHVxeHVrOU81QnZtWkN4WnBqakNtaTRtMHFrc1YrbFR1SlAyZXBVd21oVEdUb2VRbkVmYVMyL3R5WG9MclpMOVBWVWhvV2hLMjA4ZWdjZmxtVlhhM2NUZEVTaTI4SmVpYmo2bW9LSFpaWDdrVytrWXpxK1UxNUpoamw5aXJobytIUVlQZW9Ia0liQT09IiwibWFjIjoiYWNmM2RkNGFlNDEyZjYwYjViMWVmNGFhMGRiZGQwYWNkOTZmNDliM2Q4MzYwZDVjMWMxMDVjZWU2Nzk0MzkxOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(36, 'ROM-V40rA3', 'Research On Mobile Survey - GE', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjZJbWFsRnNZY0NIQS9OZVJuQnhaYVE9PSIsInZhbHVlIjoicGd3alJ5YUhwR0ZCNGs1Vk96UURMMHVScjg3b1l4VHorVEtGUUh4ajg0SVhDOVcvSFFuSWZsRWNpR0tCRXY5cFEvc1lkZ0RINGU1NlJ1MFJxYi9VYkZrcFhtVkxIVkRLV3lnOFk0Q2ttdWVmUkdtVkN5SkNtVHc2S1FLVlRJdUJFU0craXlSLzJNWmIvOXNPN1c3MjhiTUpodExSMFc1TkpLVDlOU21hQURUakltMFMxK1lGbkxpS2FZcnZxM2N4dzl4dTlVTDVQNUYyaTAyejlrWWdERFV4SjlQWEhSL05HS0tsUkxTUWZHY3B4LzV2OVd6RFZKZXZUTHFwbnV4WVpKbWdKSlR2RWxWcFlhRThpc3JKT3B4U1lTemMxV0lvR01rTjA4ZUIxQTFrOE5FdjFtOXE0TkxJM3l6L1dSQTF5Q0EwK2lXVWoxQllIY0NrRC9oVTNDUE1CZlVFRjZEZWNRVWgxNUwxTUh5eDR1d2N3SXZHM1diN2NkZ1NiWVFQbEtZcjdHc1NCOHpVRXpJbzdjTUxFdz09IiwibWFjIjoiZmE5OGYzMjQ0NWQ2YzFkYjNmMjY0MmJiZjQ4NmEyZDhiZTkzOTVmZTBjZDI5NWU5NjZmNDJkOTk2NGNlZDNjMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(37, 'ROM-a6yjLC', 'Research On Mobile Survey - GH', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IjBOci9IRG5YcTd2K0JhNHlWeFpVeEE9PSIsInZhbHVlIjoiVjZ3WnNxUmJRMmF4cXRMUElEL2hxclFGVFdHQWZ5R2tabnR6WnlQU2Z2SWViTGEyTWxzRzlraXpEUmNhT3Yvckd2S3hGNm1xQzBldnB5ckcvTUhjc1BpNWcvWGtwUzNWSktGR08xYnpGWCtSLzhNSndtWkZESUNVb3BuMFZyUlp2aFRLcmRGUUtUNmRRRTlUYmI0NlFZclVxUVhCY1ltNnQwZ1NCR01MaWdicGN5eU15ZHlrWXZPWktENUJOTkNzeWNCV0lyazYyNkRIQXBtYjlpNnVTRlhnOGI5L1R5Q0srY2lkaVVIS0g3enhRbUtMT0cwRXJ1MnpOeERCS05QQW9PTERid3oza0doZUpkNlBIVm5MMkc1TGpwY09FdktzdmMycS9pUlJIYkFLY3pDVWE3Q2FPVHFGcGwyQzZldDB5YVFjY20xQkNBMXJvM1BwS08vNzduRlBPV1Z3SFNDb3J2WkdPQTJBTmF6dEI0bDl2UWV0Z0c0RVY5NGJMT2NWMjlFUjBvaUFBNjY3aTBjcXJBMU85UT09IiwibWFjIjoiZDhmNjM3ODJjMGNiMWNkMmVlMjJmMjI0OTQ2ZWY5NTFlNDUyZjJlZDk2ZjNiNzFmNGQ1NjY4ZDJjZGFkYTI4OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GH', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(38, 'ROM-HxMqg6', 'Research On Mobile Survey - GR', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IlppNWt3THdjYUozNzFQaUdiN2Y0VkE9PSIsInZhbHVlIjoiazdCcHk0alUyVFNyUFRMam11WTQ2NjRmNDBjWmlndlRMak5hZWNtcXlVazRVRzhKU0k2VENXaDgzakEzVlJsZWZCS1VQbTI2S0tyZ0t6STJCRGVJbDA0Ri9xUXlDOEZTUnhiWWFYWk9JNmlhZUQ5dGhwS2NVZG5HRDdPUStOMTBQZS9pVElBTXR0WGU2YnpmNUhIS2g2YmxQUldiMTdmekN0L0h1UGVTd214K2Z2aFA2M0c1eUdnbXN4c1QxaTRrbTFvdzhJaTQ1ZC81NXp0R01mUTRwZHczS20xR3BkOUtDOWZYNnQrbWVVZ2RzNzBhRjIzSkVvckswbGxiNWZSaXBrcUt5MXRJZmNxSEdHZDdXNU9qci8yR0lnMHdxUi9HNG4wZXFacFB0alZVSnpZaDR4aEdOeVlhVVhybzNFSUpmLy9TaXFOeVZHM09RY0JwS0N2ZGp5eGY4cXYyQ0pxUGsrbXJRUWp4QXF4UUk2VGYyT0N6TjJuY0s3SkpRMTl5MFd5dTQ5dk9rbktKMXY5M3pjNnhBUT09IiwibWFjIjoiMjdhNTQ1NjFmZjA2ZTVjY2FkYjMwYzIzZTEzNzgxZTZiM2VkM2FkOGFhYmVkN2IyMWQ2MTg1YWIwM2Y1YmNjMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(39, 'ROM-zjKgRR', 'Research On Mobile Survey - HR', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6IlpSZ0ZKejJxelFQSTNSSUNVYkY5V3c9PSIsInZhbHVlIjoiRDBuUjl2RjhqeWJiZlFSTEJRQlBoTHZ0d0lhS2RuSVNJL3FUQlhrYVoyN2lXZzFiY3FzSXJzdHRvRG9iMTVsVW5xSFdmTW1yMGhXRnhEKzROVC9Kbi9UMUxkZUdlNTV3QUVxejJ3MTFJYW5QY2VHeThlM1lKUmZFa0VsUzRzR0YzMGJkTDRJWHI4bkRpUzA4enNhU2pTTWdUczJTb0VZSW9ZMEUyYndsQ3NtcmFLV0dUTzc1WFVVYWNQV2JkYUp3dWxZYVhlQjdham9admdBK0lBUVlrM3RUMGZpY3dtUVM4cG1FbUVTckRKQSs4SEFTU2pieWFDM0hQejljdmJPY3FMSXNZdVJDUGhTU0VDVmxzWS96d2R5QytUeXllNklEOVdEbXpNVng2RkdYR2gxbndoU1NIYlhxUU8xTFJSZ1NxSVhkV0hBQW4xc1BxUFhHZUZqRkMzOGhEcDQ3aEJONnpWbE5rdDhXUlQvV0ZVSHV6MVdacVM3ZDBlN3k4UWJHOVN6aVUxMi9LZlc3SVFacFBYeWRpZz09IiwibWFjIjoiYzVjYjQxZDQwM2VhZmEyZTRkODMzOGZkNzg5M2ZhZGVhZmMwODE5NDFmMjhkMjUwNjhmMTNkYjU5MDU5ODAxNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(40, 'ROM-02I3rs', 'Research On Mobile Survey - HU', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6InRVQWZoZ2dwb3FVc01BZGFaZ3NoVGc9PSIsInZhbHVlIjoiYTdjamkxOXVaOWE5bGJxWkZRaHdDVjl3bUljZEFTMW9Ud1dWT3BnTGxYRmFUc3oxK2dSTGVJdjdvenBPMFZnRUNWN1FIc20xSTZJbTNMQVcrcjhBRUFPQ0JleFpmU3R0dzVuMjBrOWNiZm80QnZmOUVqYlE4QTF5N2pZOWtiTzVIQWZ2V2lrVXd1cm0zV2VoU2JCUkZ1VWNGMHFQYW5vUnN5K0dWaWZDWEh2WUpSY3FNZ2ttNnVtUzdCZ2FjSlJZUFlZNnZiNE0xS1FIMWRVL2h6YWZGeEFoczJqQzRpckFhaUljNUNWelNDbHBhbkE3VjNyOUxmaWE4RUd5SXFISlBBMVJvbXcvV3dBY2NxMG1oamxyNEx0TzVyai9oMDZhU2FocENqUldneW1VbHFYWjZ6Qlh2d082L0EzVisxVytrWEtmSWN4NTdSazJETmFOMGdRU3VsbjdFYW1md0NOWitjemttRWlNYjQrNTYyNTFSRVV6TUdQMVBiYzlZZG9BYVNuN2cxTlIwREpQQXVLZnlsdmpLQT09IiwibWFjIjoiOTUzZDBkNDI3YzFkMzU0MGViZTUyOTc3MzIxOTI2Y2ExMWJkMGJiMzkzMTdlNmJhYzk4M2U3NGNiNmQzYWIxYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HU', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(41, 'ROM-HiFM0b', 'Research On Mobile Survey - ID', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6InBoeHpJM2Vha01yV0hVeUVwZFlCOVE9PSIsInZhbHVlIjoiWmhOaFBaR21tejhiaGVCa01sQ2orUGdKWDI1aWRKZ2g4b3lpTW9SOW84dXhUYTJHTVhtK2NyZnlpVnJXbzJ1QnYwT0VSUlQ5WTdPdHcrSkQ1VjR2MFNUcy9iK0lBZXl6K25aQVF0MEszVGJSTTZCZHVmR0lkRjFNbGZhTkJ1UXlxM1NtZE55eFN3ejhEYU5XQ2ZDUldBNllLSjhOU2FHd0EzZkwwdzJuNCtyeVJCMDNmditOWFhibDVST1c3UFNmOG4xSk9saXphWk1VWWNtVTFBNkpBLzVwb2Q0cFkybEE3OU1SN2NySmt4SHFFVU90aFVtQXVQdXFkZVoyUlN4eW8xclNNZVAzekcveTNIanJ4aHBkM2RTRHR0dGc4VlVWbS9hVEFkdGdXTFJ2RFZZRCtkS3JVTGVoQVdicGY0MzBqUWlnc0RxNmQ1ajFqcG4wdEZnbU4rTlZZVTloTXZBMERJU2ZMR05ZUFM4R08yeVg2WWNSNVArSG5PckpyZlpBT0pBaFIxMTlycndJMjlhc2JXVy9jZz09IiwibWFjIjoiNDE4YjkzMzk3ZTVkYWI5OTZkNWIxZDMzMjFjOWVmMmMyNzAxMDEyN2EyYzZmOGM1NTZmYjFjOTA4YjU4YzZkNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(42, 'ROM-4Pq4y4', 'Research On Mobile Survey - IE', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6InFxYTlNUVlNcEZKb1NBYStTVHVNckE9PSIsInZhbHVlIjoiOVp3VGtLZlRoVFNINXcxSitWM2ovYUdTTzBTWURzWEFWdk9Jb3NUZjkreFZSSTFEYXgxR216UFdZZDFGUSsrSGg0aTFCeVpsRktWV0c2cmJLaUhEcGVDSDY0ZGt1YnFTTHRVb2tpS0t3MEFsU3dQSjBkc0lQbS9sdFUxM3BNU2hjeThMb3lrTG5mQTZrSXFIazFaRXNHOFFWYTd6bHdtODQrMUJRTlBpd2dGNm1ESDBlam9nMTluN1ZOVGNNZkV1NXBNTGJXdHRYUHlLLzFEekFpWGowTjJJdWpwWUJ2ZDRHN1loM2lHVHdBN2loTXdhWUpFY1JaQm5EMzZGeFFFdllNb1FkYVdtMXc3U2FuQ3Y4elNMa0pid2JMUDV3b01laUNhOUxSYXExRVE2cTZkaEJUWkVicWRTQ2krcU5VRDZNMzBrS1VxdFdMcHU0d0x5KzlaTUluS2NCU0lLNHdSYTdtSE5zRGFtWEFRTkNnZHRYTlF5WHc2QWQ1UmhUWTUvK1ZpYmJyLytndXc2Q0dGUWxTSi82Zz09IiwibWFjIjoiZTA1MjYwYTg4MDAzMzYyMTZkODI3M2YzNTkzMGM3MmY1ZTM0MzNhNzUwMmU3Mzc1NGEyMGM2NDE4ZDg1YTM0NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:00'),
(43, 'ROM-DLPsiE', 'Research On Mobile Survey - IL', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6InF6WWJpMkNXWFc0ajNFYWZqT1JlY0E9PSIsInZhbHVlIjoiWGNHbmFISTlIdGpVTHM0cXNyUXhIRWdrby93SGVNTjZkVmk1NlRHNGZYMFI5aU1rOVpiZmV4djlLTWlnY1JLQVZnR29YSUdJdHh5bHcwd2h1dUs4K3RaK1JLcEhETFBWOG5DZXpWdHoxRUsrQjlYSWtwM3RtWjdlY1FCLzZ1akE3RzM0Rks1UnN6Z2NyVk5XKzNQRWZaaHRVZGZXc3hNMHhtanFOSlY1QlJQVngwVGV0RGRYbmRrZ1crc0RyZHZoNzBkNHNoY2JwamRYMk8rQW1LVHJ0WTFHNkh1amozRWg2aHlSY2hKQ1NpTk5mTlMwNjdieGdUVFc3bldtVFJSNndPeE5LWDJVa3lYbWtnZCtZS1RHN1BVTnRIMnprS1drZXdWUXVCZ3RTZzRoM0E3Z0g1WEFiSW53MlBXMHpyaFlSUmNLblFqR2ZuU29ZTmdaQkRmSk0wRVRlb3NDbnIxSmZUMHd5UDVOQ241eVFYQldYendOdzJadmFLZ2hJVlFvQU5DTy9QWXJDOXJOa0ttbE04M2xQdz09IiwibWFjIjoiZGUzZDBlNDFiZjU2MmYyNTU4MThlNWNjZDNhNTdiYTYxNWNjMjBjZGY5NzkzNjE3MDdlZjE2OGM2MWY2NWI4YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IL', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(44, 'ROM-Zt2qDc', 'Research On Mobile Survey - IQ', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6ImoyM0lXTzFJR01TL2dzaG1nU1lJWlE9PSIsInZhbHVlIjoiNG92SmxmTDF1WEJvRkhqYml6RmdkeWtBbkY5SmVRVkxUa3FWNWMwVmlvaHNCa0tiRFE3UUlCcCtqSWNaNHhoNUdpK3dLU2orQ2VQbUtMcy9yeUZDSytSMm1VWUtoRENiY0pMNzc4aTY0U25ja3FscXhpNXdvZVQ5RXZNVm1FWG00VStHZlBnSXRqM21mcnRvdUUwazZrZi9JNzZiSXdiZDBLTlJXNEhQMkxFT0VEN2prcm81MHJIRDloZ3JlZ0d3NlZNcFBoUmk3SDVlajlES01PUTJHLzBSdjFaODdxUnludlhKUkhsS2hhZWhkelZvMFdMRzlSRkNaaEhUaC9ZS3ZVbzlGR1JGYzhCZXVzWGlhMUl5M09wQ0hyR1psTk15bDZTbnh4MzNVay94RHE2cVFUMEdDM21KTitWQzFYTm5rMlNWTnEzKzljWWIrV0N3NFpmRkF1enpFR00yZWdqbGN4bFBoaTgrRFY3ZDBrUk9HelJtdTI0OHhwdkZiSmlqY1ZmWVNaUjJSOVk4Q2ZDamRFTFZyUT09IiwibWFjIjoiMDk5ZjcyMGVlNGJjNjE4YjRkMWZmYzUzYjJjZjI3M2Q1OTVlY2E1Njg1MmVmMjgxZjNlMjNlYjU0MWE4YWUxNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IQ', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(45, 'ROM-SqND0L', 'Research On Mobile Survey - IR', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IkFpamltSXJEMENnU1duKzlnb3Zrbmc9PSIsInZhbHVlIjoiUGMxTHpPOHgxbS9JV3VYNmgwaFc0Y2tzVml1aGZsTkplZ3g3U0xTRXNqM29MamZZcVhkSDNJZXM0NmxSSHJjTmdhZHYzNXkyMUVHVHB2NzhTTVBadWpOMCsvc3RDZ1YvRWdSSTZYSDdWRlRWT2lHM2dSVGRERVRuci9Iam40VHp2Mk40QlIvU3hjK1o3ZktrSkNIVFhEbTUzYlp5S1I2N1dwZXVDZmNhZDUxM3YvdFdFbGhGbDQwMlRDdDRQUDBncU0xMmhzV21WMUplUllRN0grN3JpVVp4M3ZDMU5jR0ppUVJwSWkyV0VycS8rcWsyODAzMHNOQ0FUdHdIeTJyMlV2bGdWOXlCSi9sUGUzazRHWllLY20vQmpEYmZNYkwxQS84M2pJaGV2aUo1d3crRGhIODFvUDZNeE1xTUlQN0hQQmJVVWR5SjRPMWZ0cXFhWnZQMUEwbEtlWmR5RzZuNFhwVUwvdXdtMzcyNXNqYW00ZnBucUhMaFpkaWM3QnovVFl1R1YzZEY0aFBNc28vR25TODRoQT09IiwibWFjIjoiMjNkNjQwYTk5MGE4YjFmY2E5OTliMDhhZmU1MTdkMTZkMWExNTRhNmYzZjQ1ZGQyNWVhMDQwMjlmZTFjNTM3MSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(46, 'ROM-DaLZVL', 'Research On Mobile Survey - IT', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IlZRQ096TlhCWUVhRkZiaVozYU5Jc1E9PSIsInZhbHVlIjoiRVMyaWVJOGZZa2JIK3dFTS9LM0g0aFEveE9TNG5VMCs2M2g3VURoYXBxVnpVTzgrOWQzZTl5WHVDU2x2WDlSbjVQZVB1blllL1JhY0RwUE1tdzJ6ekFZSzVOVmV1SjhhQ3A4K2c1ZmxaMXd3K0JoY0NpejE1c2tNZ1hZd0Y3SEFPcVh2dW5FWFY1a1JYWUhjN0Y1YjNBZU55eG00cEExZjBycXlxZUEwMzNXU0J1TnVhdXBtSjRwaHpSZ0ZzRUE0ZFYrMkJzeG1NejY3dUN0Vi9CRndVTm1ENC9HeEZvVi9wNGg5RFRDNi8yRkxCRVhGUG1sOWd0b05zK1ZlNmRBR0RkTEdyc3dnaHBBUHlkdDRscUh0eTBLZ0dVc2V6QksyL1JIYWprQ1ZCaS9GK2pabFN2WWY3d2hoTmdJR0FQYTk0bUdRSDNHc0U5U1NHMnZxVnZML1ZqVGxmcWtsT204bGNjZ1Fmc3NQbzFvc09KM05rVFlORGdZSEMwUzBMUGN4WkZnaEFPZEl0Wm1aSEFpTlVXSVF3dz09IiwibWFjIjoiM2VkYWQ3OWMxZmUxZWE0NjFmZmNiYWRjZjE2MWQ0NDVjODM4NDFjM2M5NzNiM2M1NzE3NjhkNjljNDkxOWU1OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(47, 'ROM-RMmSMR', 'Research On Mobile Survey - JO', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IjBOb3dhcmxBaU9YRStOYWorRVJsV1E9PSIsInZhbHVlIjoiODlpVDhzR1ZBSWtZSWE0WFNjb2pEcVFWT0dscUNHdmNZRWtpNTdmWStJNFJ0ZCthRnR2S1UxTWk3TVB5RTkwYnJCUWZFZkxVY25mNkx3NkFtK25YSWt4K1pxbjQyWitYNURsNVZvUm9qZXNlM3BBUERpUHFjRk5IN1gvZWZIVG5Yc0k1dkk5QnhPNWdCK01kZDBJZzdGSnR2YWZtVTB0bGNFdUR3ZHRXL0lVR3h2RjFTV0dLd0xFZU8wRXhWd2VFTHZTSHZHRzB2YTUyV0ZXamo5bzRVUU5SblF2UVI1RDMwS1pKOXA4Y1JSNG4yb1pNWkkxTVRzWkhnS2pIeElxbUxCbE5BVWJuamQ5eEZmMjIxWjZGK00ydnJyUVFBa0NtN0lwTzJJb2VwMEwvY1dUWEZBdk9FVm1aNjBseXJIdGozWEVhVENTaWFwV2VSQjA4SlEyRm10SGxPOURkOVZDSm1MaDVXNW1ZbUllZ2YxRGlDeHZmYjM1MUlEYnFFMHhMM3BIQzZUQStZQ2JYNGlkY1Q2KzRKdz09IiwibWFjIjoiZGQ0MmM0MTNjYTkwMmYwNDM3ZTI3MWNlNGE1ZDM4YTBhODczMTdlOTcyMDA1OGVkYjg0MDc3N2YzYzZkMjU0ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JO', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(48, 'ROM-Wub2E7', 'Research On Mobile Survey - JP', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6ImhKeVlLWmFPSll6bWNzWGozRHBDdEE9PSIsInZhbHVlIjoiZE51dlpLb1ZuVnd5QlNaczVaZmZaM2dPV09uQW5RYWxYM091NVVFUFU2N3dGUTRmb1VaZk5valRJT0VXOXNaT3N6NnAya3JEQUNpbnR2VTJTQlQ0cjV5ME0rZ29Sc3hoZEtYT1lKWXVNamFzNUFaKytjU0ZhNGxmM09RTTVPWlY2NldaNHM5Q2tsNG1XNTNvTVdTMXZ3TTFrZll5eGRRcmpMQ3lVK3JkUnpIemx2cmNoTjg0ZGxTR0dFaWFhZWRsL2hUU0N4QkxyMDZZcmlNYWJmOTd5MTE1Vk91Ui9DVHZFRm92TFowVjc4QTRwS055ODdMRFZlNTlmUnBEaXNFK2lWL1UySThqeExLVDJrMW5YUHkzUmhlTmV0N3VxdlFQYm0vM0hGUkFmTWhYUk4vSDA0NVE1MUlDbzhYZ2J6eUpsalRZa200Z0hzYVZta0dXZm9hSW1LRUY5Z0hKU3hubFEyMlJhMzBPZ1lKN1MwYW5FNGNCWGl4RmdYQW1NbFNtemZIMnpOZWFyWGtNOFNoQ3BPTlo2QT09IiwibWFjIjoiMmRiNzlkMTQ1YTFmYTE3ZTAzZTNhNzgyMDg5NzliOWYwYTgzYjAyZDA2NGIwZGFiNTM4NjRjMzlhYjE4Mzk5MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(49, 'ROM-DSjZgu', 'Research On Mobile Survey - KE', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IldZaUFSWmRybkxYSG5HOExCZTRndXc9PSIsInZhbHVlIjoiTVRyVTY5em01RHhnSXdrNi95QjR0SHBycDhQSDRKS2hONnVJenRoelI5S0FoVk5mVURkamhtcVpINkp6Y1dzZG5FNit0dDUycGlGU1RuUjA0dUhzMFdRM3R6QnVBK0VJTFFxYitoV3ZFOE9qQjI5ZnZZeHpsQ2hoWnoyVnZwYjZnamo3djUzWW9ZRTNzOGJreXZNclFuaWtWOGFwcCt1S1N3eTFmdEluYm84anJndHpBb3lCZGR4dzBJbnRlVGJXOGhZY0NjMGlDZ2JJcWNXYjRGbEJhWldYQmdEUzJEcnhjVU5ESHA2R1NPOEl3OEdoVHM2NldXam5TeURoYXpkL0tLMUtlOEJlWDJwSEl2akdJK1VrYkN4Z1c5QytGY2pUVU1FNE8rejFKUXAreUU3NjNpVkh1VGdVa1ZYdDliWnMvaVY3a1MvS083UTJhdjJtU2xvazRFK0h6Qm1RQ0RHUUJVZkp6ZDhDdnVOa2N4UjVqQ3J2c243QUN0eXBDYVlkYWFxSkNqRUJwZG9KeUdDdmR5SWcwQT09IiwibWFjIjoiNjg0ZDc5ZjI1YmE2M2JmYmVhMDgyYWNjODk2Y2FkYmJmZDdmZDhhOTFmYTk4OWUwN2NkMzY1ZDM2ZGE3YzA4YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KE', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(50, 'ROM-cIgRAv', 'Research On Mobile Survey - KR', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IkRUL2JrdDJOdlpDQ0M0TEQvZGlpNXc9PSIsInZhbHVlIjoiVlV5b1VxQzlxdE1vWmh6OXF2VFkzNmpRL1RVL3lyZFRwM2wzTlFaL3pZMGhNL2JjSXlQOGhpYk9teEV2TTJmOXMzSXNQVEYrOVZKcHcxN0loVzc2R2dqeUN4OE5DMjR0ZTFPcjBXenRTaDN4czIzZmZORWpRWFY0eWVOUzJXWHdFYUl1SmtUMXhqbjdMREVUUnJkSXk2aEdLWExPaVlRMW1sYmdzNDJHUFpoaGJyWm5uQ0RrcEk5aWVISXVzelJYSXJZRWVtaVMybWtFMVBWcUJ4TnB2SWU2TFM3ZzdCdFNFbmllL0tiL29BNHRzT1UybEh0UlowTVB3UlpMOFVyTW84aGwwMExCQTU1RktKV1M0dlFBL0RMcG5zVm5EeDFBcThDSkgwZkZhTXpTSTJBeXNqc2JYdEJydGNONGcyb2g5QnFjcVBvY1BvK25QVncyRnExUnNXZEZzMDNpZXVobEwyNGFNVHgrUkFQb2N5UjgyRHdPQWxkQ0ZkUExkdnk5RmtDOXZpTEh5cHVUSDRFWXRYWHR3Zz09IiwibWFjIjoiNTc5ZjI0MmQwY2UzNTZkMDEyZDU2YTY3MWQ5NmQ5NTc3NTM4ZDUzZDVjMDZkYjlmMmQ4Mzk1YWJhMzcwM2I5MiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KR', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(51, 'ROM-JcNNin', 'Research On Mobile Survey - KW', '', NULL, 0.30, 'https://notik.me/api-redirect?token=eyJpdiI6IlF3WWpXQ1QxZXg4cG92eGdhR3V1WWc9PSIsInZhbHVlIjoiMEJEYmJ5elFrWStCTi9SR2ZyZ1l5dkZjbDNJeHdLVS94bXVnNi9hR01RMCtEVnVXbENocUZkSzdvcTVUQk9PQXNsMENqTk9lZWVsWHFWN2d4cmMvdWFzN1ZmSmlTelVVZFdNbVRtbCt1SUJrcjRaVlY0NHZrYXpxbHV1bWp0cktSNERuaVpUYlZNdmY5eE1PbUY1NWxSaHh6bGVsank2QXBCb0tzMDNMTFBncHhhbm1VcGNkMU1BVFJjT3hZc0sxcVNLYXBYNmNTWEcxRUQySi9OUnVCZXVBM0I2MHVzZjVSZHZocGtoamxQWXcyRFN5ditkOXJYR24weThmL21BRG9zbEJyNW9NczdQdUx2SDFSM1RGczE2TndZbmJ4MUQ5L3J5ZEplZ3psdElJbThyUlNYbVVrWDFMeFQ3eUFyMHpSaVRKa0VlQXFlbTFHK1U1ZThNSEZHZDNUN1FxU1ljc1pLYjFiZ3RsaTdEMGxRVUo1MGh4U00zQU9Wbmx6ZlFHbUJkaWloT2I4OWxsSmt4VWlmZHZrZz09IiwibWFjIjoiMjkyOTBhNTM4NzJkYWVhZjY0ZjM0YjkzMTcxOTE0YTFmM2IwYTQzODMzZTFmZjJlZWUwMzgwZmZhZmRlYWIzMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KW', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(52, 'ROM-KJ16Zm', 'Research On Mobile Survey - KZ', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjhHTzkvZkpRZ1ZtMy94ZmhMUmZWZ1E9PSIsInZhbHVlIjoielBkb25OeWlYdzZmV3JnWlppYjFFUWN1cmJzOFh0UkY5dkJIdFdNWFBTWURmS2VtZVEzZ1JqK0J4R2NoL21saGtrdGVQelg1WXFaVFV6akttdmhFKzJRcFpZdmVzQUNmaHd5NXE2Zm51VWRMTVdGcU9MS0VmU1daREhrNS9wdXNaaVhKOFJYa2tKTzcxRmNmOC9oKzY5d0ZmSFVvTnJJdFdaODlMTlR6T3M1M3dweTFHeHpJVjJhcHZKZTg1QUxxWWZjempBZHlNaVlCMFphOE83ZGt1YXRWLzBhYlhWTWs4LzVsVElYQWdrdW52TU96SlV5K2FwWHhFYXppaFdpSHZkMXZaUkgxdXpndHlVU24vWVcxRUl2SytMaXF1M2E2NS9FWFdxZ3pkZ3ByWWxzelUrNjVSOTQySHdEN3paUzRmMG1pMUp6b0xIZENSaFhoNGdIYjh5L3gySk5EQ1dsWDJsQm9ESFpBc2JKeFJ0V1g2V3dsUkVlanpGL2tWblZibjlSbGFrRGE4THhabmNEWXZTOVRVQT09IiwibWFjIjoiNzM5YWRiYjUxOGNlMTY1YjM1MThiY2UzYzk1YjQ0MGIxODJiZmYwNzhmMTkwZDk4OGNmMjk5NWZmNTVkNGJiYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KZ', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(53, 'ROM-NE4Hvm', 'Research On Mobile Survey - LB', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6ImdGL1dwdXVlcURtdCtnWjFUVTdKRWc9PSIsInZhbHVlIjoiNFZoOTVaaUkrbGVrVDZpV09uRU5yTlJ5VUFNZmIzcU1sRlhtWTBSeEt0YUtuVk1vYmN4c2xhTHpERUtCSmJMdTUwS05sRHZ5NDNyaEJlR2ZJVUhsUytOTlMyTGhGUDgxMmpRMzVGZ2RBS3Z1Zk1rOEl1SWhBUU1QeUFqWnR0Zm9TcUE3WHdPbkcyYVI4RUNCU0pSa3NBaHdkQlBJcXZYTy9OV3ZESzNGUmJHdEVMSGhkYVpndEhZMnlUeFltcmhlNHp3dG9tUGYvYkh5QnpKNm0wK3hhZ3plOEV6d1JuSmRPblp0cFB2SFlFMzE5V3RGSEt5MkY3dXZCaDZHTC9aK09hVzRDdVU1RnFHYWM4Ky8zNEpvVmgyajk0UExsZGlCOThCK0hQcnc2K0J2b0FCVlJqcXVnU1JtZGdTSm0xWUxOZzdaMWo2KzE4ZU1JbFVMeUp2dVQ5LzErODhLRnNpNEhzVFdrc2RqWWpxVXRINENPRUNzMUhjNUJneXRvc3BLTGN0RXU0b2FNb0hZSEtGTVJzMVVUUT09IiwibWFjIjoiNGVhY2EyOWZiZmE5NzA2ZjU4MDExOGMyZDVkOWZhZmZlNTFiNDhiNjJiNmExMjI1MjgxZTM1OTg0OTU1YWZlMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LB', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01');
INSERT INTO `offers` VALUES
(54, 'ROM-7x7LMX', 'Research On Mobile Survey - LK', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6InVvRmNRcXFTZ3lXL2dvTi90a3ZJSmc9PSIsInZhbHVlIjoiNGliWTBRemE1dGxpOU82cHhYVkJraCtiZzJvVDlpRFZRSENnSWFTQVZmalljbGNmL3MvdmpoMVRZZlZrMkx2SFhkNzk0Y3dzYWNTS0x6OVFLdUN1aldSMXdsR2luVWlCYjhYczZqZWFyVVpLaDRKVmhTanJ3Wmx6T1p5SG55MWVjSURodEtxNlBYNFBBVC9QN1pSeGtpMXhCM2RHZVpmL29NN2NXWFlJQThNdEJvU0laNzRjZmgzazduaG1idDNZM05rS0ZLaUVvSGVvcXh6UTJwR2ducTA2Q05CbitjRmRBc2xLOTBxQ1lGSjdSb1FZZ1JjSlJrOXBReFg2dEtGR0pVMU05Z2d3T3htQ0RLMXRGTkJKOU1DeGhaZnFzbEhZeVE1bmdvbVRzL2kyL0wycW5PQXE1NjFQakJIV0pGc0NmSW05V3JMY3VjNHVVTDl1c25qZm55UGliY2NHNEtNKzEzbm9MeCt4V3FmTVQ1Y1JxQzhYL2haYXNmQmNpTmU5TzRkN0JCVnM4eC9HV1NTQkdab0tpQT09IiwibWFjIjoiYjk5ZGVjZmVjOTFmYjQ0Y2MyOTRiMzM5MzE5OTMzMzM1MTU2YThjMzkwYTMxN2NlMDM5Mzc3N2UyNzE2ZmRiNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LK', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(55, 'ROM-lLNZ5H', 'Research On Mobile Survey - LT', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IlpjRkVUeTREcVVDUHE4Z2JVcmlqQ1E9PSIsInZhbHVlIjoiTWNCV1QwNFZDQjZQV2UwczhTdm5STVZOeFVFaXZpS1MxVlBEUm4xQytrMjZCOVZDcDFYMXM4emJUc29xMjVkQnBqL0hudy82QnlmSHpLN2tZRGRlMVR6czVYVVRuWG9zQUZEM0xrbzlLN3JBeGpSR1dqZXBUeEhtN3hxcC9zMW4zOGthc1pLVWEyY092bGxiU2I5dDcwdW92QUs3Yks4Vzc1ZER6d0VZM3hsbTVhcVdXa3BzNEVyZGlkcURPNDVYY2tHZkFwWWZHaDlXS0hxMDlVZ0hyZ0tmTTVYMVZIaUorKzRtc2RVT2dVTXZYWXRTTzZzR2ZOMFhmL2FCZHZmNnpvc3N0VTJuS09JbW51ZWV6S2pYS0JCQnVEVWJMWjlOYWkrT2xtNW9HVzBoWkVXK0lUTFdEU3JVR052VzhQV3pCMzcrQmpMYUFPcVFHVFNhZUsrcnRtVGk2WTFEeXZ1TTVuMlJDRWZUTGJHT0JZS2M4dGtnbzJCU3cvZjZXQ1lTaUNBUHR6WDlTaGJsUURWNkV4bUhsUT09IiwibWFjIjoiNDUyMmQ5NTNjZTNhODgyMjZjMjA2ZjE3M2YyZWE3MWM2YWQzOTZjMjFiNmM5ZjY5MzEzODFlYjMwZDVmNDRmYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LT', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(56, 'ROM-gZ1Nc1', 'Research On Mobile Survey - LU', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ilh3VXEvcWNmcTF2a1hRMWdhTUFpRUE9PSIsInZhbHVlIjoib3R6a3FiZ3B2Qm9mMjNtaVprd1UwQUtlNDg3M3dlaFFNUXdObHo5VU16RVlOTE1kcnl0bDdPTklkYjJJMm8va3IzWVQ3d3dRTDIzVmtSNlBXZ05FZXRIY3E5ci9hR2drdmx3cExMb3lSNnRscEJUY3FZUjhrZmk1TnBjODNEbHlaY0lGWFhIdkt1MmFITkpvVTdKcXg1Qy92SkdVK2JoSzluNkQzYU1nb3cwMVVNQjJ1Zi9NSGdNbGJ5Wmh6Z0c1c2YzaFRQdUcxZG82SmtQWDBaYTA2Z1AyTC9yZllxeUs3dEk5aGxsZnNZZ0N2TUhndGxqbHhleGRGbW9nc2ZxbGN4MDRUaVpGaUowMHV1UlJRb0kyNUJ3VXVmR0s4Vkl6aFpjR2EycXludm04TWxhaUFkWEZQeDJsYzR2NFFTaDF3UFVvblB0TDI4RmltSEs3elE3RjFGU3hUR0pqa2NWN2lZc1hLSXVLbVNjZ3ZqNTk0UGN6ZEtTRlJRRHk4KzZ0WnoyR0gyL3FoRjFveWMrRldpL1hvQT09IiwibWFjIjoiMGQ2NDVkOTliY2QwZGI0NTA3YmQxMjZiMDhkMjJhNGYwMDdkODExZTNmZjM3ZTNlOWRiOTNiNzAzOWRiZjU4YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LU', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(57, 'ROM-RnKbns', 'Research On Mobile Survey - LV', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IlRaaVhBelFSWFpBSjU1aEQ4QVlRbEE9PSIsInZhbHVlIjoiVE9yNWVKaVVOd2UralJ1S3pVdTBvRDhLVkRacWlMWk1wQWp6NFpnU05JTmJSOXFsOWlhVGNVeWJnVXlRYWc4ZTk1VlRzUkxiSFg5WmhlbWE1RmcvQlJybkk0aVl0WmpHNGdBR3grVHArNEhBNk5NQ25BZFVtdmVkbkxZeHJ2L3E3cXNjODR3dHJJZDZWTmlXZm5Od3ZFb1VBd0hSYWdTOVNtdSs2MmtDWXhndXhyTEpneXlWWEpnaEJtMnZrRGRKVXR6K2pEMG9TZzRTMW15T0Mrd3MySCthQmo2Nzcram5YNmF5Yld2bTFJQjZIZ04wejZwTUZvQ2ZKTDVCbFdxZkhIdk16c0dKMkN4NFRITXJaQ3VGQnZxeCtxT0hYVlZUbjVnUVZ0UDBkT200UXRXTjNRd1lGYkdJZk1RNEp3SzNqZjdzMGVSTHgxdFM2amx1QkpRVFRxTjJEZ1BYYUpRR3l3RmpIM3NEYm41ZHdIdUVNWExnZzFMaWQzZk1ZWEhxRnJhWHZ2bldSRkp3QXJocUF0WExTZz09IiwibWFjIjoiZWExY2I0NjM2ZjMzZjczNDEyNmE4NDJhOWJmMDdkZGZjMzZiYTg2MGM3NmJjZDdiM2E3YzY3MTdjMmEzYzY4NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LV', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(58, 'ROM-rBYlhJ', 'Research On Mobile Survey - MA', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6ImpVMU5QOHFKbWQ4VXJPVnZrZXczeHc9PSIsInZhbHVlIjoiMS9GdzJvTkQwUEFEYlJXZDRrVUk3WG1XbzZ1OTZzVWZWVGViRGVjeU9LVmo4SXlPdFVoSFE3ZUpENWppakJiZkRuWGhjU2V1WmtDTnNaZGhKbHVSYlRid1FQWjFpZFF3dEhWd3NidDhwVi8rVnprRFNrU2FjZWdTMlZPRVdBYkQvRjhpcEplWkpzcnZyTTMrSDVRZFl5QkgwYkpMNmJKSGtOSW5kbGN4SXM4bUJXS3EwWEtpOWdQdFNCYjc1WERvZDhleS9DVHJYeW1ZWHV5ZXRMRFg5WTQ2dnJ2SG9xVWNObG8rOE5nZWJoTHZEUWcxdjUrNGNTUmRsWEJKY215cDIvR2Nib1RuUzg3eGF0K1lMWnZuS1k1UkRNMGQ2aXY2d1ZrTXRvakNRS2hBMzZFSjFSUTltQjFPTnVpcFl6TGMrQ09wMmN5czRjOUJsTWlmRU9DcWdweEo0ZGpkY1VOS3NxMElVMEZWZmtYbjFOKzFEaDEvYitCRDMyS1lWSWRmTlpMTFFWN21maGY1WnFyd3crZDlXZz09IiwibWFjIjoiZGQzYjI5OTg1ZGU1YmM1MGI0N2ZiYWZiYjZkNzM5YTE0NDExODAzODc1N2E5NGZjNDEzMjFmOTExNDMyYzhkMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MA', '[]', 'all', 'notik', '2025-02-26 13:08:29', '2025-02-26 13:11:01'),
(59, 'ROM-ytdeHE', 'Research On Mobile Survey - MY', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IkVWSDNPOERiMTRQekJZY1JsK3BHWWc9PSIsInZhbHVlIjoiek54T0pramlLNlc4am16ekxpdyt6TFNsQkZSNk01YUN4SVF1RUVjcllFMFNjUjc3VGt6ZGJMVDJpZ1lDcVI1bXdqWkRERXplUHlpYzRobVV4VElFMVl4UWFnakttUEJjWlNtcDZiSU9INjV1SndsTkpXd3VqaStQNHY5VW9yMlVPSkNNMVJacXNaTnc5SDFFUkFWbXN6WDZsYmFUY1Fha3l4UUFQd0RBaDZndXI1VmZnOGVHQTk4YVZ0NTd2UmdLQlZPSDkrUU8zQzM3ZTRMMXBUYjNGOE9IWE16Z2Q3VXNWdnl5dzE2UnVMQVo3empob2o2MzhsLzBQVk5IendYbFA3b0ZsUHc5MU1UMEh0S1Bta012NUVHNUtEd2VPVDFDK1gyeFBVbGlGcDJtVmoydjBEaTJPcUw3SzVMMnNtdWVnV3hnaHdvbHBDYmtkRGVScm90aHdZeHg2UVJWMVYyblZLekxUbStRTmpWcVljUkk2V1c1UXBNZ3cxQkRBMmQ5Sk5rNHUyMHkxUGZKNXcvN0toL1ZUQT09IiwibWFjIjoiYjdmYTlmYWM1Njk3Y2NjNzM1ODk5YmZlNzIyOWJkOTcyNjg5NTA2NThiOWVmZDE1OTRlNGMxYzYxZjIzODlmNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MY', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(60, 'ROM-kLqgD6', 'Research On Mobile Survey - NG', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6InlpMDl2ZTY0dE13bG4wZ05zalRkRkE9PSIsInZhbHVlIjoiOUpnQlhZZTY3b24zQlpIczlOdjVObUVBTExCL1c5RHlRTGxOQm5xZXB1cGZTT3VkWVkxbm9VNzIrVUcxUlFObmg3YVgzVk0vVW91OE53YndnM1EweUVndFNwTUtpRlNBMzdNT2E5ZHkxNngzUHQra1hTSGhRTVJXOGFkdGVjUGJGOFdlRi9pTFBwT1EyMHhKNmpLbWlCMXI4aExuYlRSREVYR1QwUmluc1B5bDJSWkhFRHhTYkNHNzJRdjhubVZDY3JZSUQyVmE0L0hrOHVFcFN5WlkzczVSNW9hTXZoazdBaWtDU0t1enF6WVJ0RTNSQzNQN3M1eGFaV2wvcVVGZ2MrYUMwTkUxTTlwYml2Q2llRXd4dVVqcVBsems2M0doUEw5TEdvQzMzT2IwUFR5OUNOdXl0ODhFZlEweVlvU1RaTHVOOHdiU2VUbm0yalptbXozd0p5N1J3SERnby9TS282Zk9ZUzkySGJzUVEwbk8yN3lCRytyTGdSQjdEaE5EZkhzMWxYaXpkSkRTV2JKT2IyM0pOQT09IiwibWFjIjoiNTI2YTk3MzlhMjcxYjVjNDFlYzFhZmE0NDNiNjE0YWFjNmQ0MThiYTNjMWM0NzcwM2FhZjVkZmIwZmZmMDI4NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NG', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(61, 'ROM-uxQWdh', 'Research On Mobile Survey - NO', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IlVZWjk0NDhpRDdUcGRnTk8yN3dYWnc9PSIsInZhbHVlIjoia3ExZVNaemRPMzYzbDlRN1F5SnBFcTJsQkR6QXl3NVg2elM2T01LUzB5ZXZ6d2xMbWVsb2gzMGFxTXQwTFZnc1QwdE9XWVh5dGplNUhTcG5jQmhlOUpkUFN6VkFIVTN6bU5YL0Q0QkVwRUNXbjVuRWV1Z3d4UUFWSVZiYTFPOW14dlFadlhYdlM4WTJnT0tDbi9DSFFuVUJ2K3cxOFJGV21IRk1zRnNqYi9wZHJPRGxMNnpEWmlDdG1iQ3ovYkVpZ0UvOWJKWVlQTFBOUWhOYm9lcVBDSUdjV2RKK3libFlsMGZTR0RTN0h1SHNzdDJ3Z2VKV2VLdVE0ZkhpQ0JtVm5uY3BDNERnV2l2Z1NjRVRWN1FkQW4vQzg0MEpOSzdEQXNoZDYvdDArQ1JhNHBQTUMzTmo0a0NUaklJWW4vcDdKcjV6K2Y4ckllTzNOVkwwQVovd3krMG1aMjY4WS8yUHRvYWg4cGhLdHhwWWlCL25uenNmNDlKK052bUFVNzRvZ010Si9LZ010ZncxU1hKMzAxNVJnZz09IiwibWFjIjoiZmVkYzNkMDA4NmM5YjIyZTIxZWNhMjA4ZmM1YzRkYmY0N2M1YmZhNDI2ZjNkMWIxNjI1ZTU0YjFiNDAzZGI5NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(62, 'ROM-GEtyzG', 'Research On Mobile Survey - NZ', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IkxqM0xIZEpmN1NaRW5lZVhVTXNsT1E9PSIsInZhbHVlIjoiTU1tTXVROUY2c1lUMkhKV0ltT2ZRa2pPeHNYdUlCK040TkoxSDRLUmlpNUc1MFZFRG1WMWpNOFIvWU5XcmloZndqRVJvREkvNENCYkU5QzVIa25iWGp0ZHM3QnZNSjhBYUtGaGU5YmtzdkJWREFBNkJNclVNMHNzMmRDRExJVWUyVnc4UTNmcXppSWNqdWx4RnU1SnZPSzFHdEN0a0t2SWwzckM1UU5vQVZmSXQ4NHY2ak5ucVNpbzF6M1BRc1dVL2I0NEFjUTVPT2hlNkNhb0QxcmlxTWh1akFtbmNUd21ZNXE1aXMxM2VpVnVMVE5CVkFsaFhrc09UTW5ncDZ3MGdOSnpLalZQVlZtME1EdnArS2dMQzZnRWdMMzBoT2szV2ZkRk5XaDNoVnBPVXh0WVV0VG9tTEprSFJFTE5VOXh0U0VsaE00VmxIZDhodThFN1BTMjVaSDR5SG5HblNtUnM5LzcxaTZTZ0hJNG9TaWNpazg3MjArcklpNHkzZnA3MUFXMDFreER6a1N0eUFwdVRtaWdydz09IiwibWFjIjoiMWM1NzIxNTNkOTQ5OTFjZjkwZTE4NGZmNGEzMzQ3MTBjZTA4YjIyNDZjM2U0NTJiNGUwN2EzOWE2M2Q1NDRiYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(63, 'ROM-Y3j3xq', 'Research On Mobile Survey - OM', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Im5XMW9UUFhWTzlxbDVRN3IrRzJkc2c9PSIsInZhbHVlIjoiVTJXV2tGV2poUDVTV2VpbW42a1FtTkg5L2taRDV4RHVNZ3NmUnVtT3hldVJuZmRKQ3dwd3l5VUc2bVZlaTJRRnBlR1VLVUV5Q2hFem1yMWE2b2J5RStwcVh5aXd4ODJ6eW9aL2w4YS9tcWR0NkFwMFptNnk2bGIrdXdBTDRJVVo0bjRvNEl1T0NvRzBjRFVSSFVVNlJ0eG0vUWx2SUR3Z2xISlByUmhxeXpocUtyZThQUFAyTnN5VEE0aDNyUHovNVVIU0dXRnFveXJub29KaTFLT3BPeXJjek1QUGJRbXVUbmxFb3N6cExjM2s1YjI1M2lxRHZlWTFDWlBIT0VLcjBSQjFmVmJLem1USGdNeDFzNWs2SHEzdGt1Z084bUtHT3JXZWV5Uy9adWp5VmtNeWFoYkdwa1NuSFdHK3Z3RnNrZVI2WkVqeDBIcE9aZmVEdkpCQTJUdDBpK0ZUcUhlbXJaaDZIS3hUVUlCQ1NKQTg4WEtGRDZmREFiRWM5WjNKektSdXFxUG5HS29ESXFtL3JFMG5pdz09IiwibWFjIjoiMTA0ZDdmNDk2MjlkYjc3ZTllNmY1MDhkNzg4MmE0ZDc4OThmOTMzZjdjOTI4YzAwOThkZTMxODExYTA0NThlZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'OM', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(64, 'ROM-qbZMTQ', 'Research On Mobile Survey - PA', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6Ild3SEwzNjZSQS9Fd3BhSFU2OWd0WlE9PSIsInZhbHVlIjoiR3Z1ZkNGTzdoUkZVbkM0ZlBrVGVaUHAxblBSdzJSalhYRjFPRnRXUnBKeGlDOVRoK3RhR2R6M2VrNkY4dTNXbHJ3dVFMWmxFdENSS3pxbjdhYm5Takg5YWlEMVFWMlB5MEcrN1lMTHRuNVkvaytkeElBZEFpVHdndzdLc2ZsWEd6NE82SzFmWXluZmtxUzVvWGRvdTZ4ZEk3YmFUK0psNjBtd3FGY2p0UEVETi9iTWJnMHJtQWFtcGlyUGo0dmExLzN3K25YQkt5SFg5SG5YWXQzUzhnaERMTnRNRk1ITy8zMHZIRkd3T2hPamdkS1pETnBuMGk3OXBYYk9yUDZYOGxHdHZhelFrS3BZaUNIQlh6Z2dNMUhsVmovcFhubXFreExuZDNqZGJpRkhWUlFDRFltZTNOazhBc0duL0pmL2ZrZjRYU1hGU3hJMURJVHdmVTlCaVlhQ0xmYWZab1hKcEltQm1UTzk4K1dzQXRCRlBsTzVDeTN5NXNTc0liS3hxd3JTYjU3TXY2cVBQeVhWcXBwdm9QZz09IiwibWFjIjoiYzY5NGViMjNjMzdkMGM5ODhjY2YzNmRiZTU2YzMxNTcyMDhmZDRjZmJiMWM0ZGNiMDQ1ODI4YTI4OGQxMTEwZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(65, 'ROM-OgxaEg', 'Research On Mobile Survey - PE', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6Ikw4ckpIZEhwYjFoVGNNaThPNEFDNlE9PSIsInZhbHVlIjoicmRHMFppdzhWQUs2dDZGMXV4M002MDhPNEFkVExJLzlGL0NQMWZqZjY2R0RicUpqQmJiRTVkTkVSK2RmNmJuNmR2dk5Wa0s0M21NV0IvUjNFMEc0aEZCV29BNTU2YkphOURXV09PaE9GODlIT054bVFvWVZRRDVEUmxhaGMrb3poQ3ZDSTY3dkYrbnNVSHAra1I2a2E4NytnUW5PMzcxSFJiZkRMWTZvZVhlTWxLNE9WOGNmM1NSNWVZemhQSmxlYXR3NHpIanF3V0Y5RHdyYXgrakJxSU0yR1NTQk16NnVudEUzV2U1RnlDUHpVOEdMUUZpQ3kwMnFDV3grTmd0eVBKMy9MNmFBL1dvbTRkQkZHOGt0NHZNd3p1TXZsTTRJM1pJcVE4REdENFhyL3ZKVWRBODFnNEs3TWNNL2pMSDJRZ21kUzZ2Rk5QbXNPVTU2RU5pZUl5S3N2MVNURTIvWFRsTnVFYWNtYk5ZMzVMSUo4enV4eXZzN2J3c0hMMjZqeEZOWHRVNlluUldoaUhSVEVmNFNXZz09IiwibWFjIjoiY2IwNDIxNThmMzZhZTdiZmNjMzE3YWJjNGMwYmIzNjZjNzkyODc5Yjg3OTQ3ZTM3ZTIyZTU2N2NmMGY1MzliMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PE', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(66, 'ROM-6tFRfa', 'Research On Mobile Survey - PH', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6ImY3Y1d3VWoxWERacWVRV1dQMkhrQmc9PSIsInZhbHVlIjoiQWltdFpvVWExMDlLbXd3SmM3MUd4Y3hKN0hXWTFYUDlUNHd5Qm56Z0JzNHVGWEh6ZGF0SytCYVpSWUdTbUNSaVFJa0dObHo5VnB4UTkwU1g2Mnl0VW10QTJZWHkycHAyWnYrb1BmQTU5VXJUT1FuV0dFbndvUEkvNTdUZkJGczBOdlBKbVVpc1pWOWhJaEpFM3g0TkNIUHdYeUI5Z1ZEc1pycVdGNGJscDBGQzNra3pOOWsyWmI4dk1nN1dCV2tIOVlnNCtQaDVuVmZRMGNwY1ducTFRVEhHZWdyVExBVFcremxkbmY2MU5YazNmTmRCRGdQNzhCWmVjbG9DOEE5QW9sQnVZdGRUTGpKNUNUK2dnVXVtd0tTeEZNVS84Q3UrT2xSMDArK3NXazdoU2VyN3dGTytHQjBZMHNyQjlvb0RaSjIzOWhpcCsxT0NLODdsTTc1OEUwVk02V2hNYW1ad093bTFHaGZYTkwzRGhFK0xKYkdLejBLUWNJVmRTTWJhUEVFcVZrSlMrUmN2VDNNZ1hBeFZEZz09IiwibWFjIjoiMzEzMzFjNmQ5MDU4NzYzYjQ1NjYyNDhjNGUwNDhkNTFhOGI4YTY3ZmZkNTViNDdiNDNjYTVhY2E0NTg5ZTY2MSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PH', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(67, 'ROM-u2nFpF', 'Research On Mobile Survey - PL', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5xZkprYThuWkU1UmlVV1UrZC8wdEE9PSIsInZhbHVlIjoiQ0VqcVZETkxWMjJmL0J2eFFZWERoUWlDZHNLMmNaTnNXQm4vZXFnNTFJbFRHU0RBaGc5TEZKd0hTV29WZ0R4b25DVG1XakljTHZjSXBDaFBMOTVYaDQ3UEgvbllWWTdPM20ram9vaDB0c0czK1hGVVhZbnptalFleVArc0V6QStVQjBEWkc2dEhsTW9IakZ2ODBCVjJKVHRTeFB4bTdKOVJRSXRHdjAxczhPYzZSclpNWnpDYWc1UTBVOWgrOFZSTlA0elNwVFZveHJNMW1TcXQ2K29kV0x2MzA4ZUNBc0RjVS9lQkJsOHdzNmNmVEJPeVBYRThoUVNLOU1Bd3pHWEUzZUYxTGVtcW45TWg1clVrU2JMeHhBK2tja3V1T3ZQV2VsdWtnZ29ZY1VCUHNoQ2xBSk5xN2pDaUFYZXBLWWtidlplK3BZYlFqbW1HMUdKSCtXYmRsVTUrajBWek9kdjc1aHQxakNjQzJMWU92SGk1S1krQVNCRHFiQ3FmRzhOQnFWYUt5ZEs0Y2t3N1BBQVJnSFVqQT09IiwibWFjIjoiMmJjNDI4ZjcxZjZmZGMyMGY4MGExODcyMDVjZDM2OTExMDhiNzU3MzkzNWQ0MjllNmRjMDc1N2YwNDFkYWUxOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(68, 'ROM-r7k1Rp', 'Research On Mobile Survey - QA', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IldNWmVYeWxNeTdWelVDY0VzTzdqNHc9PSIsInZhbHVlIjoicGxEUVQyc2J5SVJFZi9KdzZJTXZLZWRGN0VSY0tkVy9DVkRsbm9RK0tPRXpKMFBkcU41d3VxY1NqdHpZRGdXNjk0Wi81a0N3dXlMRGFiek0rZGJGcW8rdlphREdXYjNsWmdnUXdGczQwdlUxUFl4Y2R0ZTVEaGs1Y0VUclVjZzl3anp2c1lUZTBmZTBGam82QWE3SnJ2ZlZ5RFdhOFh2SHY5TThqbGVuYVhmL0hKSFpnRUIyT2xqVE5jbEN5cWwxdWJKb1NFVXI5V3ZNcGJqenZhZFhDMkEvVUV0b2ZVYmVzelZZNUx3SlhkcW5rU1hGRjh2SVNBVlZ4bUZhcUg0aUFSTlpxeXBtaUlxRWpUaEpKTDMxa0xQZE1ObzV3aGJoQXBrTkdlODFLSXY2cjE4V2RSYUVqdndLSkk4SWd2VTlCd05SZ0s0aklXODJ4akxkV09MaStDbklVckRaMzQwK2cyMnVYbzhHSGRuMFBxcFl0TGFVc2lnOWIxSTYrMGxuL3J4U0J5WVNBOUs0citDTDRORTA5QT09IiwibWFjIjoiNzdiYTJiZjJiMzliMzE4NWViNGM5NTc0MWIzOTgyMDNmMzZmNjNhOGJlZTMxZmM2NDIzZGRhMGZlNzczMzRhMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'QA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(69, 'ROM-fGx8xZ', 'Research On Mobile Survey - RO', '', NULL, 0.26, 'https://notik.me/api-redirect?token=eyJpdiI6IkQ4Tng0Z1BQM0xOQWVvRHh0akczcFE9PSIsInZhbHVlIjoiTEYwMkI1Z3JYS01CVERiZVJJVnhXdmtoZHJRSlBZbXJsazJRa3lDUXpGZ0ViMFNDdU92VWVuQnJDV1VJbTNGRjB5aDRZbUpOdm5LbDRFZzhvY0EzVDVJZktkYVlidnJxK3NGNExhOUdmbGF4a2g0SHZnbUFtU05wY0d6Z0V3aWVXU0JXVG95Q0pjYTZhVFBteDlBMkdPaFZuMmZoN2Zha2E4aVYzTDNqd1djWWNGUnhndkRZT1FNWThCQ3RqU1lVeXRaWUR2VXd2VkxtRTU0NlY3K0NBSUJTYm1xSjZIYkVleFh5RFEvSUxPclNWT1ZIVy9iSzZUU3pqNzk1TjkyMms5dzB2QnhhZkZhQ25ENU5od09lZ2pBa0grYW13eFUrWVJtM2hrUjJpUDNKclhzc3Jna2JuRzZhMWFVbkZhV0R5bFBGU09xVStOYkRyMDRIRXZlZmNmcGdVM1dJZmxLaTNnUFBXNmdHVlIyYWk4bmxBQzJJRDVVR3VIVG9NN2lCc2dWaXZpUGxFVU9RZk1oZXRpY0xFZz09IiwibWFjIjoiYTk1NWMwMjExMjUwOGFjYTM3ZWNlYmYwYjk2ODA2ZWJmODU3ZGQ0MmUwNTRkZjBmNzFhMjY0M2E5ZmU2YjU3MiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RO', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(70, 'ROM-JrSKeO', 'Research On Mobile Survey - RS', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IkZxVFFvRk12VUVWQVdLdllvdWlVaHc9PSIsInZhbHVlIjoiY00wQ2xLNTQ2dWJCWENoNm9GWGVGRE1LUitIN0czRm4wVzZGTUVFTzVrdXZrMmw1VHIwVE05UmtVRi84c1NvRmcwRnBxQ01vQ2E2ZTNiY3NTemlWdUR4ak45K1prV0RUVzgvL0lrZ2J1ejFpL0QzOVZnVlpYcXZsTTdXZytWUVpBMHhzZ2FrSmFYVWpvQnZuZG1qNVcyNlhjbjBQUHE0MDF6enRpOFQ3MzJrYmpmTkJLL3h1a0tBRnVNSWN5dExMLytrNVFBaXNneTNuMDAxc2V1YWp1WHdGVUUxYmpjUUd4SnJlenVJWHpLM1dzTHUzUnE4czJBSWpqZUxDRERUU2J2dUF6dzBxY2NVMGlvdjNzM3gwSUc1M0hFeWduY2xScFRqc1dYNXc5Mi8yTURKSitPZ1hOSGRWZ2F4NHRuaE9JK0lWUzhiOVBBR2MrVldqWitQOTFFdTQvOXRlSXJ6cjc3OHhVZU1neVNOYTQ1cUhSQld6alZnMmxWSVd2NGpBNGxiZ0hISUxYci9qd3RSQTBUS0FSZz09IiwibWFjIjoiOGYzNzlhMjgyNTRlZDU3MzUzMjA3NjE0MTc1NzdmMjcyNWFhOTRlZTYxNjIwNzRmY2ZhNDRlYmU3MWEyNDEyOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RS', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(71, 'ROM-NfY112', 'Research On Mobile Survey - RU', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6Imo0dUI2Q2grOVdrNUdpY1lBYXljb0E9PSIsInZhbHVlIjoiYytOVDFXVzJ6UjEyOENEc1JxeDZDUUVrVXhDWGkwRjRkTEhiaWtxbnU3K2RBMmQ3NCtkb3pMaEV6WWZHbHh2cVB4azV3VzJUdWlDMFFEMVpKS3dnZlNBOXdtV0pMaitIY3FlN0w1VGhNV0RIbTduSGhWL2ZKbnRMQ0xuREVIbCtLWStkTFplcjNHdHNwSkZpaUo4WUtuRFV0YjBFelFLNkFvdHpYWUZzdk9PREtLQUNMZXo5clU0UldGVG1hUW5YYWJ1R3hXclhlY3VoTlNLM3lGclFZVGd4NDBPNDVZKzhGdlhJYXV5b0RHZitLcEdFZXp5andEYnZuRGdDd0tIR3B2d1d4bk1USEV3cVZnTEdPMDZKem0zQ09ZM0p2TnpuZzVxQnNsTTN0c1JkUlYvMkVUMi9yZ3JpOWRTbklOQjN3dytIYTE2c1JNU2NiZ2tQK1A2U0ljZHVSTFRtVC9hdUtjbTRIUzFSUmpzei9vWWV4Z0owbVlpQkdJT0JINUR0Q1FSc0Yxb0U4VytabmgvWm5yQzYyQT09IiwibWFjIjoiODVhNmExZTdlMDM5NTk5N2Q1ZmRhYjc0NGQ4NGQ2YjdmNWU1ZDAzY2IxYjIzNDhlMjNhOWRhNWFmMWNjMmFmNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RU', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(72, 'ROM-4WbtTd', 'Research On Mobile Survey - SA', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IlhkVE5wQ1dwTTlHemU5YVZjR2pGOVE9PSIsInZhbHVlIjoiZjB5KzdFajZEODlUL1R3S0lwYXVtOGJoZ0VJVHZQQVErcEd6eUJsemZOendYL2V5WU5FNDBXTGU2dFR5VHQyZzBCVDlaT2JtQ1RoTjhxSEt1aGRDREl2SHBxS1N0VXFsbE5UVHkxVnhMRDVJcnkyeHlCQ1RmM3NWV0xFbDZsaldWRDlaSTVtMThuN2F2UG80bnhxVjl3T0hSTFo0bXpmaC9WZU5PSEVZRXZya25JRExHaTRtMGlEdUd0cVJpV011b3ZoeXlBWk5YUTR1K3hXK1dRV01YQjF5TFpLWVVONWNvWTlCaGYwb0YvRnh3TDBvbmx0RnZMbmJnSTlBMmxqbUNaNmRXamdRSC9iWHJ0NXhldjV1KytKSHZXMG95YWxtTElwR3dQWHZmUWVVSld3NnEzOGFWSlpYelQ1Q2tqRUw2dWV1cDY2RCszejlsV1Q2ck1YQzJ5MGtrTVJOR0EyMmFrOGJkQVNTdkI4cVlmYTd0aWUzN0tOVGtaQldXQ25pc013UHV3RGhtTEZHYi8zL3EwVEwrUT09IiwibWFjIjoiZDEyYTYyYzI2MjM4MzQwZmE1ZjE5YWUyNmQ0ZWM4Zjg5YzhlNGJiNGYyOWIzN2ZmMjM1N2NjNzA1MWQyMjIxOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(73, 'ROM-6qXHzi', 'Research On Mobile Survey - SE', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IkVYQm9KbC9wak5ZcktveUpJTXJJM3c9PSIsInZhbHVlIjoiVDA3SHZ1RUl6Zmp2M2FWdTgxR0lOV2EzemhINGEwSTVUWlAvSWVxR3d4eTlYTi9Bc1g0dUN2dU1lUG9UTUVNNkE5Q0Iwb2ptUkJVNERGU05hbmtYOXQ4ZnJ6ZnR2bFcrOGtxS21tTHdSVm0xVDVlWWUySkpTMFNPaU00TlpFVHhuWFpJQ3QvRFJsd0xFUHB6K3ErVHJKV0tDSlJ0L2NkckNZc1R0YkRkcWZNajB0a1pzMnlZbk9vK2NYMUJsYms4bjYzM3pGYWd6Y2NZcTZXeGNGZVQ5MXRNVWZlODNDTmlwM0RCYThPNzNPdno2ck5UNkJKby9lQzVLK3lRMGlhalpnRFIxSnVJamlyZytwazd1WjVNVENobWJXMXE0QktRc1B4T01palJwUnFBUjVqbzIyaVY1Q2N3VlR0Q3BoMktLcElRNVBMKzlRNW5PMzYyMldVSCs0S3BKcDh6c1Rsb0VqUWNIYnBpcmlaSTFSZG9FMkJnYzZRVkFEY3VZT0Fqb2hTSUY2NnVGdU8xbVFsbWcxSzNWdz09IiwibWFjIjoiYzY4MzZjOTNiYTg0OTM1NjRkNDkyNGUzOTU0M2UyNjMyMjg1OGFmNmZlYzQ1Y2Q1ZjdiODJhOTViMzQyNzg3OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(74, 'ROM-OmdKYM', 'Research On Mobile Survey - SG', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6Ik53WUVKZGEzQ2hNd3BCRjlIVk1BVnc9PSIsInZhbHVlIjoidERzUDRCMkZEV0VEdllaV2FxMXFlR2liNEhicHgzNUw3VDdOczNWcDdWMEM4WVpOU2VhMDlZV0p4SzdmYlFLQStNYTRLTHVuMXFzMU9FbUEzcHZhbld4ekcvT3VGdVh0VjBaQU9lS0ZqTm41Z09LdzJrZ2NlSUFoRnBzb0o5ODdINkhSUTBRWEtkRkxtZFZKVkdjck92N01rRlRVTUNBaDFJUnpvWElzYkVFU3poSnByYXc4VDlIRmZod25hKzVtK0M2K2owQ0cwaThMWEZRczRUek1FQUhlRTRLaTdmRWM5V3lrRitKTTc2RURMdGFYcWVuYlJxNjJvRWtkYlIzam4wTDlpS1p3QnRpc0F3UXJpaUlTUlJnQWRCMzBsb2xjRjJTYSsrVDMyeGdGcWtwN1JkcE1ZMWdPMmFwSjJDK3gyWlczK3FEVEZRZTlwZDFLN1NaTUJaNnVldFBTSmErcTE4QkE5Qm00Nk9odXFGVmtFTHVJNHNGWVhQSFh2cFdGWjFadmI3ZjRnMDJ2VWx3T3FpRFNudz09IiwibWFjIjoiOGE2NzAwZThmMTFmZWQzZmY3YzRlYzdlYzJiYzQ4NjEwYTAyNjE2MjBiYWQ4Y2MyZjBkNzhiODg4MWUxNjNlMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SG', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(75, 'ROM-Fg0DNM', 'Research On Mobile Survey - SI', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6InA2Tlpyd005bFRVWFAycGhndnNKVHc9PSIsInZhbHVlIjoiaHdLR3RJSVp5RlpCUHhscWVkdERaMkFCQW51MUNZTjYwbis1aWJXcmxPN3dnTkV2a2wvdmt4VVVYS3A0QWpwWWhhcVNMbkRrRGVJdkhwaGxpVkE3QkZsNHVsWSs1OGFxbnNPMVhYUWd1ai9UQXgwTnAzUWx3cm1Lc1haU2VMM0U4bTN2QmxEQXYxZTVObUxpTUxHYWlyeFhkc2pMTHNuQUx0ak5PczMyZnBQVDNmY1dHNG9yU0dUQ3l5Rzh0cGp6WWRkSnBQQlZnNkNzc0dSVWVMVStjYkZLeEc5YmVMTXV5N3VJN3ZQaytXY0plY0p6enVQcFh5aWRodlBOWkVzcjUxeU9nZ0ZDN20vdnRGQVQrb0loOG9KMXc4MkgxQUY1SHpmOEI5bExDVFp3K0xlUzYxbThXK3Fzb1hqSVh6UXJhdDI1aUxzb3hsVWNkYkFOYUM1Q2svcTNveGJjeVI2dTVBZUVLRkExVEpIYjdSZ1ZVRGRTQ1VBcmwyNGd2MHIzR1JhRGp6MlYvNFA0L3lOQUxDcjFHQT09IiwibWFjIjoiZmEwOTMxNGM1MTk3ZDEwMTAxZTA1ZDA2ZjJmOTYzZjgwOTljZmZjODJmYmM0YzFlZTExM2U4ZTdiN2IxOWQ1YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SI', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(76, 'ROM-OyoPTn', 'Research On Mobile Survey - SK', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IkYzQmlCV0dDbDdGYzNwU2t1S09HL3c9PSIsInZhbHVlIjoiYkFLNG1iZXdXNWtab0xkaXp0TENNSlBoSmdVYjhnSnpnRW9veU1rbjVuQzVoMVRZdGxiVGU5a0hKdmFuZEM4Tldva2V4VXFBMnE5d0NBQ1NZdFVHUC9ZYUtrYVJ3WDZPQmJnYStMaGZxRzVyNGc2U1NEZGJ0VjVXb25oV01vdDVnd0VYVjk4OUp2MHM1d3c3bWNCVXFXdFphNDgrSXZVdVEraVQ4cFk1bHQ2TWE5NXBmek9LSmFWRVI5M3JKU2dFNmVvU3BRYlU1a0wwUEIzaFdMSlliejBxZGRQRjd2aHYzT1NnY2FGQlFjR1FZMDB3TlA2VkVGejNmUDJmS0x3OW15Ukt0OW9Zdkk1K2luaXIzYkFkL3lGT3FUdHZWT2p5MENpdFRYMEk5a2owdFU0NzFRMEpweVdZL1UzRHZpcURsYzVndUNNM3JDNWR4L1FkRGM5UnFEQ25vUWVpaStsWEpxOHdFUzVsK3pVRUJlYWpzczFzYUdkcHFlVFc3dUh4c3Q5ZmR0dnVEMFliMW1CMWd2TWNYdz09IiwibWFjIjoiYWIwNmQ5M2Q4ZTdiOGU2OGY4Y2RjM2M2MDRiMWYyYzlhNTNmYTRkZjE5MjFkNzBiOWI3OTJhODc1ODlkMzg1NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SK', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(77, 'ROM-ZDdJ6s', 'Research On Mobile Survey - TH', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IjRiUDdLaDZoTFlIR29RWkVYcTY5M1E9PSIsInZhbHVlIjoiTkpYNEUzQUJGa1BrODBQU1BQb3dxajArM2tyaWV4eEJ4OFdEMTlrYlZFeCtYZDRwQldCMVJSZDdWL1hIZGhoZDJZQWFaUy9DMDN3WUd4VmFsYzdVSGVuR05oMDBwQVRnWlhFbTBwa0draG5kK1RmMm1EaGJkMWRsU3VVK1Vsd29vbWdWd0hQQ0JnNzZubTNwbVZLcmNUN3dtbjhhMkhxTk9rQVVqNFY4Y2ZDWVNKWEFZVk9zOEFpT1NFRDJjNiszbG5uRG53SGFsZCtYTHp5T2ZDWU9rNjN6Nm1LdzZpREsxeW1vLzAxa20xUWtWc0ZKbnBvK3Z1ZzdESUtnVkE1T09nRmpuMjd2bmRVd21Pb3o5KzVRWkdxd1BuSVIraVV4VWVYeVYxTDMyRXZuWWtGVkxQNmVLRW5RWG5DT3o2ZTJ5cmdWcHNQN0FXMzNwbTYyWFptY3dyNEcrSUpmdEE3KzdEZmhGUUVGODVJb0VJb3JHUGNQcGZsR25EMEFrVW5RRjJOd3NjNnNiLzZjS0tiRUxpYmV3dz09IiwibWFjIjoiMWJhZTU3ZTNlN2ExMTBmNTdmMDAwYTVlZmRmY2E5ZmVjZTgwNTE3NTk0NDc1YTY1NWMyMTk5MGE2YzliNzUyNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TH', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(78, 'ROM-B9meWE', 'Research On Mobile Survey - TR', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6Ijd0dXVRVWd0SG9WcUVIY3FoQWZjREE9PSIsInZhbHVlIjoiRGMvMEFUb1pXNHZIZlpGOVQ3TkVYcXY5RzBKNFRBMXZpUkZiYXh2d01UNW5WcFRGNGtpTkxUU3FnQnRDTFhGVnROQ2FDMHo1cjJvTm9pdm5KT1NsOCtWUXpzTEUvMzA0bXA4QVY2QXNyK1Q3aEJTUllKcHh5MisxZmJDUHdvWEdVdUlGNnJQYkd6emEwTmdIWjE2cG8ra2dBSGthdVJGbUk1M1ZyVHZQUFZhRFVXVnpEUnN2Y3BXUE91YXpmcWppc3FPTU9pRnB4Z0JCUk9SandEVm1NZ1gyVWZDUmp2V3hmRXVPano5KzB1MHF4ejBIVUVTZ1VuVWE0WmJhSHczRTJSdzRMWUo4WkdXYWFaNDYrUU0xZnZhSlo1b216WlZ6TytFcDI0OUxpWGxNYkE0TDdwOEF5dmxmbG9EOWUrYWVXWmtDWDJRNXFvdkx0TkluSFkwZU9KT1JtUlo2N082S2RNSWtvWXo3cFN2RUErRDFwMHRFVjZ6ckNQZkxYUis0TjFyRFdjNmliRmRrNFlzTGFGR3c2Zz09IiwibWFjIjoiZWZkMDE3Yjg1ODYxY2NjYWMxNzUwYWM5YTA3YzY5Y2JjZGE4MjBiNzMxNTMyNzY4OGU3MjdhNmYwZDU2YzU2NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TR', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(79, 'ROM-ghEY2o', 'Research On Mobile Survey - TW', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlF5YzcrUVVXM29nQS9GakkxUTRCM0E9PSIsInZhbHVlIjoiVXZSN3I4NHNuaUtGWktJVmhCTEttVzhERlY5bFhpbW0ram1DTDlINEh5M1ZuNktnQ2tvdVlVc211OG1GaSs5MnVGZlpzM0tLTGd2VTZDNi9lL1RYYUNNdEVxL0FPVzBLRHJTZ1gxbFFWUFRkaUUweVZ4blpXZmY3RXlma3lRdkJCQTFmZ3lpMUJON3lCeXBOMzh2OHdqNE13aXlSdnRXTGFzQ0dmYm9RcjhVWU9XanEzMEFnb3diZTVZR0N5dlg3TTNZS2JUVVVLcVZYME9ISzYwaTlVZm0zSDFCb21MUTR2WXpFYWhOeWFGMEx1RUZnTWUrdklwd2R0c2tMaUZPQVFQbElSTVNMeVJDQUd2U2psOXQ0OTc1UUYzUDFjYWJ0M3E3bEdxWk53K3h1enRsVDFZY0MwSzlndDFZd0hvRjJBQmdKQ0VDbFNXdTUwZjNQL1pjY01Kems0VC95M0RPa09JK1o2eWJaQTZQdHlaazFwdFFvQWppVmJrZ1VCb0EvVVRsK1pLOVY5RnNONC8veVVPNkg2Zz09IiwibWFjIjoiOTI2MDAyOTUxZjUwNTllNDg0YThmOWI2YWYwMzg2OTM0MWQ4NjhmYTllZGMxMjE0ZjYxNTIyOTk5NGI4YjVhZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TW', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(80, 'ROM-mg45xn', 'Research On Mobile Survey - UA', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6ImlVZXA5ZktBRnFRL2tkanlKMDd0NHc9PSIsInZhbHVlIjoidHFFSjJqRitoQXhUWi81c1F1UnBubEtyWFBPZmFKcDlXejhjM3o3UzlReERvWmRINHExT3Erb05uVHJqRzQ4MEk1UmRLRVlNbjY4U29kZ3FGVHdZeFdyL1N3SGVCRm9TbVM3WSs3Z3BlOXp3eWE0N0lNakhyODVyeFp3cFpLczU4eEF5dWdkeTNkZmRtRjJjQWE5aERWd1pPRDdTSEExckJJMjJzYXkrTndEa05qS3dMRmxHR0xhckZZUU5WK2tMQXBBb2sweThTbDNKeUpvclltV2dMUnZLaWxPS1hqNlpjSW5NZVJFbmFlYUM5dW1lTytWQ1Eyd01lNFFkaCtlcWdWdUVuSFAwWWVONkdSSVM2U0IyanJ2TFE4M0N2d3VVNEwxbVIrKzIrYWdLd3AvRjdKakVTdW1IeEp1bDFtRnVmQXhQZ0ZhWFJrUnZXTm9OdVpkanhOY0NCNG12am8vWGkvV01ORUNBSWFoL0EvQWRXUmUveTN5aUdUTXJXOXFNdDR2Q2NMZFdETVJHSEsrRDZ3aUwxdz09IiwibWFjIjoiMDkxY2U2NmViNjFjMWQ3ZjliMGIzYWI0MTk3NWFlOWFhNTQ4MDkzMjI5ZTcwYzVmOWNhOTQwNWI4YjlkNThlYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'UA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(81, 'ROM-P2oSB8', 'Research On Mobile Survey - VN', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IlFFbDlpTDJDZjM3SUtRUVp5dkdvekE9PSIsInZhbHVlIjoiSngrQ3MxVkt6TERHYWxRN0JaS2I3S2ljK2xadVk1eFdJWEUxQ0lLaXJtMCt3cUZ5NytGTGNGNUw4VC9JZXpuVGxubVhsWm5NNVhnSHFPZG1NOWdnN3JnR2lqdTNyYnJCdFBPUWM4cnlQeDFTRVNLcTAzSldKOWZlSFdiTFBxeVVEMTJTazltZnp0bGNPelgxZEF2R1ZTdnBDMU5mZDNzMnRNOFdWVElWdXplR2RQVG1pT09QdUpnQWhOemJpelZFSnFGYlN3bnlPS2t6TWVqclZsT0R0N0hnaC92RGxjZ3BCSUovR0hJMUtlSk5ncW01VkdUb0VrVW4vQXBDRTQxQlVISERqTnpKRmJqbWRneDV0NlVIdk5zbmt3bFN6ejN6NTVSeUw4Ymp6eExOMjAvb0dxeEpHQTc4eXlqaEVMRnNwc0laWkhJb2c3TCttNjFKOEppYzYwZk1HREwyQkJBcFQwaVdCQjh4RkpPQW5wRnRNcHc3TzZYTHZqeGVDRDd5ekdJTHYxT0wzY1E2dkFlMy9Za0RQdz09IiwibWFjIjoiOTIzN2QyYzQxNDQzYjNkY2ZhY2FkMzk0NWJkMzE4ODg4Y2ZlY2NlYWZhODRlY2RhMDY5NDdhNjA4NDk2N2U0OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'VN', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(82, 'ROM-V6nTCN', 'Research On Mobile Survey - ZA', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6ImJtU3BIVVJNUGpSK2k5emRaVWVaanc9PSIsInZhbHVlIjoiQ3VmNDdiTUZ3QXp1UWhONFQwUC9yRmxFYk5kbmRPcGt0Q1BMSldtS2dCYnlVcVpvQmM0YmpEajhxL3JKU2ZKWEtGMzFFMGl5MFZjdEZGcTlDVDdFTmhQSGowdGxieWVBOGw1ak5NUngrcFBGNThHMUtxYkxvUCt6RDBQSy9abVEvcUM5RDkrUFRlRDgxdmRma05KcDdvWS9hRC8zNjQ1azdyMzQ2YlJEVC9MWXJ1Tk9OZkRWb1JIaFhCUlBBM0RwMjJRVnkzZXFTR3RSc0h6QWV0MW8wZU81RVlrMUkwU2xSZVUzMjh1QnVVdVpMYUNxQWpySW9jdnpjeUY3TXlWZnNJVHhUTUlJR2JvaU1aVFVFZW1vRnhvK1dVU2NIbm5sM1JwWmJ0RElYMDM4cVo4K3NHVkMvdkVvTWx1SVpqcGdrcm9MY0l5T1p3bkZxb0JkMjA0NmNQb01NcWtGaTV0elk5SDErME9MUXhObi9YVC9CWUlBRHJaTkwvb0xseno0MWszKzVKbnV2RnRWZmJOcFloZWxvQT09IiwibWFjIjoiY2EyYmUxYWVjMWJjMDViNTUyNWU4OGY0MGRhMGUyZDY1NDAxOWE3MDU3ZWExZDczMDExOTZmN2E2Y2QxZjNhMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ZA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(83, 'ROM-M7fcJJ', 'Research On Mobile Survey - BH', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6Im81ZCtGRjErd1grVDBIcW9UN1RjWnc9PSIsInZhbHVlIjoia3dpZFIyTnFqeDRQK3hMRW9yM2JoVXNLejhCK3hLdXk4b0Z2b1N1aXJDOHRtNkVLK1hJZWtSZWxseENaQmYwVjQvbDRmWWVHSlJqVERaMndXcHZTcE9JM3A3Q2FhNmhGS0xwSWcxdDRLU2QxdXI4L2IwVi94b3Y1VkxEU0FLNnd6Y3VDWG9zTyttQnhJb3QxVTlqRy9iS0JPMWZIdG8rb1VaQnBrMUtmT05oRU1YdC9nWnJuSDVTbXBlS1FGMjJLZGRLRFR3VEMvbElXZ2tDVjlHaG9EeDliMDc4MFVpNXBxZG1WWEpLTWFOSjdQeEF5cC85ZStwQjExZkl2emZYTWRoTVNEOTU2d3lGNkkvbUpSMXRncm5yY3hVNkQwZHlKUGU3bFM2eUpDVmZNWDJHYnl3WFlDS1F5bEh3MnJPNzRKdTFRYjQ4TVBUemdxTGJkV3Nmak00T3BpUXZvbVkvN1U0NDZCU05OZjNaQ0RtQ2x6RU4vMGc3NnBCb3JOTFZVczVJajVvYWNSY1JzK0hnaTNNTTdLUT09IiwibWFjIjoiOTc0OTMyOTcwMTU1YjIyNmNmNjAzZWI1YmM3MzNkNmI4ZTJkMmE0ZjUwNzk2ZTI1ZGY3NzkxNDkxOTFlMDA0YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BH', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(84, 'ROM-c2aaIQ', 'Research On Mobile Survey - CR', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6Iit5MU0zUjZMams1R2MydHdacWZUMVE9PSIsInZhbHVlIjoic3hNVU8xaEQ0akZ3cG42UlNzQ1ZuR2VHNVMwUFdiai9ua1lzSU56STdxU29vekxZWTJKRitFTXJkK0h3ZkVEa1FBbTErL1J6WU4rMjR4QUFGSFVnOThxbGtKK0pWdnpMSkNyR0FLZGpBZzh6OGNnQkN6a1ZiRjkraFpHMmRDQU5lMUhkK09JNjhybVlLbjBkNG1yNGRPRzgzcWlpdjRGTGh1OTJpSzB5WEdaMWpmZGxMRWw3eWR4em95WTQ4U1lyWTFRWm1QZUdJdHpzVGszWmljcklVR3hzaTdpMzZ5cnZDVWZpYUpRQ08wRFErMlIreVI0WTJvS01mazlISXN0VkUrYVloVGFGZGtTSFBsWlh4NXVEaGN5M2ZpL3UrUXdiK1REdm9pOERYT0tjUC9JMFZLa0dEUGgybWM5ajIzMHZXd0JLTjZwa3J6M0ZTRkRXdTRiMUh0dDlRbFMwNkhVWk5lU1hEOFQrTGVvNGt1cXdIL09ScXRkcXMrNWU3bkwyS0hJSnYxZXdhYzUzdVhMWWtYb3drZz09IiwibWFjIjoiOTViMzdkZTNhNDc3NDQxYWYxYWMyMGZiZGYzMDM5YjE3OTc2NzcwOGQ4ZTEzZjJlNjFmOGQ5NzdhNTAwMTcyMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CR', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(85, 'ROM-V40raw', 'Research On Mobile Survey - CY', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6ImVGb2hHZlF6UExUSUNZdkpnTjFBNGc9PSIsInZhbHVlIjoiZVFvQStvN1J4TWxRUFJ4aU1tUm5RRDdWM0ZhaTNLc25PbGpyVW5SSXJ6SXY2SjJsQUNEenFkb1dqbjdRVDdkUWY1UmV2UWVucm8vOWI4eFRzYWI5bTBUam5TQkIyb1BYN3c0VlpPNEJBdWpsUmhkd1FxL2EzR0xMVUhON1Q0cUFsaklMR1EwM3lkM2JHMkFKbWRoYXFNUXdRT21LaEVucmVLbWlqSjZycTYxM09HWElaajhJU1ZZWGJtbWdoWjVzcWxHb3BOYWlYeWtNY09kNmZqb1pFWkY0S0p4dVFSaGV1MFQvdGFCNWh2Q3hESGRZV09BMS9xR2JxelZNbVRjUTRzVXZCRjY5dUNncGxrSCtScHJ4MWVwcDF3cDRVQy9Va2hnSTNvWFI4S2FvUFVKejRRN3YwbUY1S1JpVXd0cW0weVNKaDhOWkNDOFNCYTNYRFhCbUpDWEZoTlBoZmx6Q0NKSzNxSzRoUUx4bXFvOGhKNHZwa01OVzhvYzQ4YnJhTC9OZUtnT1hhaXVSM05IOW14YURWUT09IiwibWFjIjoiNzJmNzVjZjQzNjU1YmQzNGEzNzE3Y2YwOWYyZDZkYzRlNzlkMzI2YmQ2NDgxYjJkZjdmMDE4NDg2N2M0MGJlOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CY', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(86, 'ROM-xSR2kH', 'Research On Mobile Survey - GT', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IkZ3WHVTMWppbkNDdnVLQ3RDcHdtSWc9PSIsInZhbHVlIjoiSkJyZU42NEtkU0ZBTzB0bVMwTktBMG0zb3JhKzc2c1Z0bmVPNmdpMWVXckJDVGthWUw3OHlCU0Q1L2FhTDV6TXhZeHE5cVdjRGNkS1MyaXVlSHptTjdkTWUzRXptdG0vNjRzZjlnT2pHbVJkMC9MbWlHNUNpdit5c2VhRnBiOHhkVkJKMndUenNJaEFiRzI4VWp6RHowZFdkNXZoVXZjcng2WGIwT2tLb3Q2V3NkVmZ2MTdXbVVSR1RSVTFWckNjQnRYdW5SSi9rZEJaSFFsZnNtL0E5UHlnbno3WEc5WTYzL0YySDQ2eU9kQmhERjJrWExjOG9HQXVhYVlpUHU3Nm52dmlkQzlaV2Y1RUNxVDZKcnlBUjdjbHQwZGY3ck1BdlNkV0RuVnhNbGhaY2o4MHFQTVFaajZYVzNHRnVkbE1rWm9QaTRWbzlFUm1JeGVkRXdLUFROYVA5WG5yMmNaRUE3ZmN3THltZkdHK0JpcmQ2Nnk3d2taTnc1SEF3b3o4by9hMEMvaXZRZWVRMmcyVnRxVG8zZz09IiwibWFjIjoiNjcwNjZiYmIyNDc1OGM3MWM5N2NiNGY4ZTY0OWVlYzM5YWVmMjU4MDRjY2Y3ZDg0MDY3MDQ0ODJjN2Y2YTE3OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GT', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(87, 'ROM-R9KBn5', 'Research On Mobile Survey - IS', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IkMwc1ZaRmcxUG5Fdkd0VmRoOVNqc2c9PSIsInZhbHVlIjoiQWxXNWNwK3lNNnZ5L1dRbkQzaGpuWWFFeFFBMnR2eWMvb1RncjNlSHZmdkYyTk56c2FRR1BkcVlZNE5WbTNvSDBhZjNZb25uR3czaWpSL3Y2ZVFhK0VFZitOMXpLeHBrWXhlOU1BaXkzb0dRb09Tc0tVMkVzemFhLzJrbU52VmJ1MjcrWDAvK1pZWnh1ek1xOFppcUN6R3dBY2RvbkpmcGRtOW1Cc1BUeXhLU3pUUHpBTi9EZzZ3dWZoV0o4WXZKQTFJRzFJVHVGb1Z6ejdJcmcwc2x0d1Vhdm9abDFNSWxGVUcreStQZWZlMlpCbzRsMEovaTJBRW9TcEtpMCtzY0RkcEZQSGtPRWRJUU84djY1S2J1TkhqdU1IS3kyTmVVcUdqaGo1ZTU5NjBNL3RBRGl3bFBHVktwcW1GL2s1RHZ1MFdpc1p5MGZnRmNzOUJBYksycWNORnZQRGh0SVNPeWdxV0I4c005SHJ0bzUyaXFjRDM2VGFhWTBuWVdZa3ZmQ1VleVA3WlhqRFRqc2FYNTRvelFoZz09IiwibWFjIjoiOTU2OWVhZjQxMWRhMTFlNDg4ZDExYWY4MDU3M2Y0MTNiYTc3MWZiMzc4OWNlYTAwYzAyYzU1Y2FhNGRjYzE3ZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IS', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(88, 'ROM-CH1mAu', 'Research On Mobile Survey - MT', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6Ii8rZW1qUjhCalU1SE5FYVVXaEYwUGc9PSIsInZhbHVlIjoidC8wS1dTQTN1RGpVVkNNbzRKbitjeGw1QUYydHZzclZxeHl4V3NDWGQ1bU9DNEpiRjlQQ0lBcjNLazl4a256Y0lmVjdyL0FyY3BmSCtOTml1dXFIb0ZCYSt0dWJySDVTQmJZQ0FrYyt4Q09KQXVVR084MEcxZmRQcjhDSFg0a2krWDJoa2RrWTJvU3MwQWxQWGpzUHpDbkNtUUlucEdlekttQzgxekpTVlprUVl3Vmxrd3gvN3ZLdzdjTVoyeHV1Wk5sVFlTUTcwREk4RHhrVW5xTjB3bHF2cFRzWTJxYXpOL3ZkY25SRm45aWFzTmJmSVJ0QzZZZmFlRk9sVHdkMDEwK1hzTXU5Y1ZnUGZiYzhsb3FNQ1UwOFVOWEdHMy9USENzUUwwcm5CWmZKZW1zakN3ZFBFajFmeUdDTDVpdHExSGR6M0JqSllQbHZPYjMreDk1amZLZWJCVUJTZzg1MmdRWGlTdUNITTB2THBhNlBzRThIZStFbXl3YXFiN2htU3Y5aGQ3UmJLOVdWMjg4TEp3TUhDZz09IiwibWFjIjoiYTZmNzFmZDZmNDFhYzNhZWJhNjg5MTM2MWNiODM2MjY2MjRmNjZmYmIwMDA1ODJmNDJjM2NjNmQ3NWU3MTVmNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MT', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(89, 'ROM-cu1tLn', 'Research On Mobile Survey - BA', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6InI4UDNkWDJXSlFVMnMvNkZTVkRHY3c9PSIsInZhbHVlIjoicHFSbStkZnIwSXRHaFVodEViVURuaHB0N2lvanVBSlp4Yk0xMkVYZURoR29wNHlCYXNCMkVUalFRWkt4dUFrYVRMY1dqa1JIZ2I1cE5GVmtZRzA5OEgyNzBPdjhLVXYrM1lMOWpsanBzZnJicmMzSDNiSXEyYU1aVElZNERJS3hhRjl0UDIvcFJ6NnBEZ2ZzZVVrWXoxMGNlaHdhQk9aYkFQd3NQbEpQaE1FZXJraC9VS0hxaHJhSnF2RXBxYTJaeWZ2U1lpZm13dGJOU1lqWXUxamROMnJwUUNHenE1R2VzdHBIK0lvZjNWbGFJTlE1MkpJNE9sT0UvS3NwZ294YjI4RjM1b3IrNWFVemM3ckh3M3ZIdHpXZTFrSWVnNWRINU5WMnlqQmJ4VXZKZnFVdTEzMzU4c29YZDVrV0x3c2ZPZWI1UU5PY0R2ajI3Uk52RElTOEFIeU5OMFRRenpUQXpnNDF4NHBTSU9uN0xKQ1laZVR0S1loQWU1Mmk5WGFYOHg1ckgrbFdyejJuT0xMeG5vY0c2UT09IiwibWFjIjoiMzAzM2UxNTkzMGYzOWVmZTRmZTZmNmMzODk0ZDBlM2I3ZjA2NjU4YzlhM2I2YjA5OWI4MjAxZDcyNDZlZGI5OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(90, 'ROM-YYavc0', 'Research On Mobile Survey - KG', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6InRzRW9VWXVScXdUTlExREpuMm1CZ3c9PSIsInZhbHVlIjoiTldqeFZORmg5T0hPT1hJaGtPVVFqait2U083S1poNU1MOW12RWRyTitqL1daaUQwVUZmamtxSGt3bVB3Q0NBSzhBeXloMnlickViN0hVU04vTytwQ21kYTh6Znh3ajM0N1NUQ0lwREpNT0lzR0pzcnlNRjlPZzYyR1g0VEduL3ZRbnZ3RjU3YWNoN2NnWS80ZnRyUXdNTm1YK1RQVStEbWpIRUdJTkdzMUFhY1hnaHlIc3dYcWI2WnFiNVVkL3hNRmkweFhVQ2g4U2RkS0RYNFBoNzhWZU5KeFB4MksxZ0Y3cUJqV2t3WmMyajlScXhMT05UZVZZK2wrZDlzTDAzTFRmN0Z2KzVIZHZkMUJ6eEFSVUI1VkNKN2Z5ZGZLdlVpSUNOdzN4WnB0TklMdHBMRjEwdmdDZWwwendTVHJuSkx4bVFHTkNjeFhhb3VnZGp1SlMwVWthVHgxMXdvNlhFV3I5Z2xXeDVad0dQaU9WWnpFUHVSVS8wTEVuSHZxckxrRjdRS3RySkg3a3djcnFEZm45cndzUT09IiwibWFjIjoiM2Q3ZDdhMjhmY2I3YWU2NjJlMWU1ZWY0ZjNiYjkzNzRlMGY3ZTUwNjRiYjI3NmE3OThkMTgzM2FiMzI5ZWQ1NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KG', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(91, 'ROM-QJRgOd', 'Research On Mobile Survey - MD', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6IjlKZUpHVFIycUNIaXNhU1Fld0Z2emc9PSIsInZhbHVlIjoicHlIcXlSNHVLbUhDUFRYS2dDL0N6WjZVK0o3bjE4WER6dHNBRXQ2MWVzUUlpQmFldnB2cXlpNVVpbkErWXJINUtNOEUrYXNZZWxJT1M5dW9hcS80a0NrbVVhbFJQb3JmblpMb0ViSG81RW5YOXpmaTVCZlozWUU3S2l5blN1R2EwMFdwczlIZ2ZJTWhnN01pTnJBLzZnOHZvc0FCSkFmQktFUis2MjI2bXlXRkZyZm41NWlHY05hb0RFQ3RTc1dWN1IzOXhpMkhzeitCMWZkcXZWR2paVnYwVW5yTjlHRTNTU2FaY2ZnMURXdGx2bUtnZEswVCtPaFVnbUJPMldVYklNbzFBUGQ3QnVBdzlONUdqendQTU5oRS9VeC8yZDZIdTBQOHR6Z1Z4QzFFOVMxTmlxNVJHMkJUSDhOUDlMUnhtemlHTDRnYWhnOUFoMUgrZHZMTkR1djh4MEZCeW9NTHRXSXI4aUpuSHE5NVQyWFhtdFB4ZmhxMnFQMkR4cjRwZ0xkakFOLzZNeHdnUThEMW95RHlyZz09IiwibWFjIjoiYjg3ZDM0YjUxZjY4M2UyMTE0NzU0ZWY2NzcxMzgyNDU4ZTA3ZDI2YmMwMTRmYTg3YmI4OTdmY2JmNzUyNGIyNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MD', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(92, 'ROM-5RoucD', 'Research On Mobile Survey - MK', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6InV1NkJYSXpnSWJiQjRRK05aai9UTUE9PSIsInZhbHVlIjoib1ZOWGtGTEtWbXZLbGJEMFp1V3JUVFhGK3QxbndiMGROMUV6OXBQbkRYU3VGZHFSRzFMT3UyOVBDc3l2NTYxT3E4QnpLZVZoUTdKUU94QlV3dDV1cXE5VnJtM2tTNzVSOWhPRWdDVlJQWHZZWWF4bDdySFlIUGJJcHNoRm9pOVVoNGgzbTcvY21XS0k0aE1rcjhmcENJVlNmVXh0dk5kTnE5clRyclRKdWFubExLaVJEMzNld3hLWm85cWF2aE5tRGZ1Ukp6K0VyNUJNcVJNdzNJUlNXMStsZkNzUzVha3g5U1RvV1dQaEJaQlNmYWcxeWJjbGoyZlp5WHB3Y0xCby9ySWN5SjIxeGF1UE9teGRDeHY1L1pmaU1OQy9hRVBNbzRGTXdWUTV2YjlralFua3gvU0ZxdTRVWGI0TVk1SWRvS1lEWXFpMENCS2dYZm8yRlpwQ2VVZDRwVm1Wc01SYzB5MHhIbXk1dXZWK3ZCc2xNUm1talVOcngxMW0vRWNpSTJNZXFlL0FzdDQzM1FjSk1EeHh0QT09IiwibWFjIjoiZDVlMDZhZDMzMTg0NTNlYjQ3ZGUyNjhhNDM4MzM1Zjg2NjU2ZmQzNGNhMTRkZGE1YjM2ODZkM2NhM2QwZTUyNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MK', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(93, 'ROM-oBvwnI', 'Research On Mobile Survey - TJ', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6IkRhKzBKb2k4dGs0OXB6blFuMnlkSUE9PSIsInZhbHVlIjoicWVKRGdaT0V2d2dWNldqb3hPbWhqQjRCTldGOUtrWWliVHhMcFU3K0F5c3lqOUdTMzY0akJTbUZwV1hwNVlPaHpBaklnUlBibWtoL2tNbkQvUHZjV1ppZ29mUUVsbWVIQkc1c3hnKzQzdnBCOWU0cXlidWZRV1c5Z2FHUktMYU1yV1plQzhnVUl2VzlNQTJzTm91VVN2ek5oNDhUWTNzKzhWL2Y1QnVFN3M1VWdsTmhzQllLWkR3L3h3T202aEhKM2lTVitZWDRjNENKUnBpdWhnZ0ZlcElGV2xXVkc4T09Oak9WZkI4Ym9XZXZ2NkFOQWUrZFJsb2N5WFNUMFBYcU9MR2pCOUlLU083VGFTQUpubWZHZ3AyY0g0UUZacVRWSVpLQ01yWlorNzUvNlBEMTFNL1J1cWViV1FnaEtCQTMyUDRkYzRTVUtFVVpHRjhQMkdZcGFGajV3bHMrcHdvRktFam5hRERzM3JxQi8xYVI5eVJmd29SamtEYTRnWGc0WFVTeXRvQzJGTWNzRy9ObU94RmcvZz09IiwibWFjIjoiOTdjN2I4OTYzODVmZjQ5MTcwMjAxM2ExYmQ1MTFhNDQyY2RiNmUwODRjY2UxN2FjYjhiNzg1NDg3NTk5MDJmOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TJ', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(94, 'ROM-a2w4uu', 'Research On Mobile Survey - XK', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6IjFvRHNSQWZGd1daK0Y5MlNxMzArQ0E9PSIsInZhbHVlIjoiR1djSXBUMXB5YlgxS1pEckpQZk42M0RuQnplWFZhODFRajhLQ01VRkFPQjZRQm5WamU2ZktQcjBybUl0MG00cURtN292RFNGYVpwelFRK3FZQ1ZBZWZTR1MvSis0MVJtS2pEVng1MnpPMU5ESjkvQ0tkelZiSGUrMndDOEhYbVlFN3UxZ3hYVFNlUXY3UzFPZnpXc1FYZ1NyMmxmQUdNSFBGcU0xVWxvMjdMbzZsYkFCQ25uT2R4d0RYK2VkaS9FZWNtaXlOdHRkaDFnWHFqZHJWbmFFaStKeHpPV2psTFRjMXFJTGUreXVUSEh0c0I1dUlrRjNRSzR2azI1N1NLUHNyQ2VLazd2c0c1MHhFR2lvam83UmhrUmdtTy9wQ3ZFZEJIV0JyamVyS3crV0lqTTIzR0hpTjR2NnMvckFDRklNekFqdzM3NVpta1p5dVVaTjNGNVhEdDVMeHZaRXR0andBK0o2enpuYUJET2dCaENBTGxKblRpcFV0em5pUGlpL1BxZDhIRW1qaFl5enkxMXN0aG1qZz09IiwibWFjIjoiYmEyNmFiOTQwODE4OTIyZmUzYjM0OTA5YWRiYWZiMmRmOTJiMzU0ZjI5MzRkNzRmOWJhM2UzZTFmZTFiOGI4NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'XK', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(95, 'TW-20230330', 'TimeWall Offer', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImpNOGRhUlYyMy9PVVBYRzJKRkFaQmc9PSIsInZhbHVlIjoiWW9iVUxndmpRMlpyVXdOMVBYVW1DUkp4c094Q3FaWFkzaFo0cjlxdDBwTE1hSGEyMm0ySVA4SHVVeWNPY3Z0MEFKckFMTFMvNkRuUzY4cktXeGNhZk4wK0ZHOFUxZ3BDYk02cm0vNm9RRTNkaEhQWFVrMEJZT0dla2xuSm53VndXazVnSHUzZTRObk1ZTkJ4SjBoMkxySkhuWXJHSEdCejhOdWYzT3cybGR3QkYzcUFHL3MwaXE2SFdKTUFIdURadm1GQk9rWU9qMzdlbmFpSjFWNFI0d24rTUxGbGY5Rm5PZm1xZkVUU0RZWi9xTGlCQUUvbHNDQXg3N3k1alpMUiIsIm1hYyI6IjgwNjcyOTU4OTVkMGFjYjg5YTY2YmU5OTRmODg3OGQ3MzRjNzNiZWI5YjBkZGU5YmUzNjVkZDgxYjlhNWY4MDYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(96, 'ROM-789fc5', 'Research On Mobile Survey Router', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IlRmWC80aUpyUDlCcnVWbDNnYW1kMGc9PSIsInZhbHVlIjoieW01Tnh4Q1htQXM5Smd5Q211bERxZFJIckVnV01GWHIwc215OHJZYnA0dG5KYXZudnAzZHltcXl6NEZPQUhsZWFrcTVqb2VSMFJhNjdjcEtza1c5a1kxWVBUQ0ZlU3JtbjNyYW9YVUQwR0QweWNucFBrN3lPRHNMQkxHVjAvN2tHSWg2NWRHNDZqc3RiS05YZ05FY0U5ZCttS2JFa1FkTDlKRDZCem80MkRJaExPV1dxZmk5MGhqaFlsWGFEQ0o3YmRXSnZjYVltaDUxSnJ5TUpVWEE1aFpLdTVYdkZIV25UUVhYakpVUTVPVVlPemNGdWIvTnFtUHExbS9uQzZycm5BMGVCK25XeVA2cTlmL0NnOEdRYkRzSVZUZE12OS9PSW1CYjVCRE4xZ1pTMTZFU3l2TU9xemVlb3d3enh0dWtsTTY0Z21MbHlyKzlpbFlVT3Z1bEJBbFV5VDNyMXI1aGV0OXE5RXE0N0x6USthc0FMbGxqMHFJQ2U5bDNjSWwzclh5K2xsVEF0eklGUGgzQUR1QmNkSGwraWpvMjJnT3VhTGZNbUlWbm5DMD0iLCJtYWMiOiJmMDM1NDEyOWM2Y2ZjMzViNTMzZTk2YTQ3YjI0Yjc0YTJiYTExMTc3ZTE3YjgzNWRiZmRjNGZhMzk1NTFkNzQyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(97, 'f9de51efb8f412e1', 'PointsBet Sportsbook & Casino', '', NULL, 22.50, 'https://notik.me/api-redirect?token=eyJpdiI6ImFlcXlMbjVMc0ZXU1crK3lvQWRXZXc9PSIsInZhbHVlIjoiSTFEWWxqQUdQaEt1STNxWkpCSjR3ZWZzNnllNlMxazA2aXNwMmh4Y2I5NFkvMkRMTUZ2ZnpOejEwVmxiUVVRbXMxZkVIY0VTUkdCakdHUEx4SWY1c1k1elpSSW9XalphYVViRnU1UEQ5NnN0akF3bUMraEVqbEN4aEljd0pIWkdqVVFobFU4a3VOWTlzNTB5cXd3YWwrcGFmWndqeWRweHV3dndZaHI2T3BjR1RQMWVKR3JuV0QyWjJNVC9iOE52WUl2d0o5ZldBcU52UC9DM1pwQ244RmhnUnB3THhvcVFWSmQxL2JvbFFxelpFenFYa1l0T2tCTnhEaEovOU44OTBwNnl4WTNkcktybHhQV0RvZ293MlJsalhrdkxGRUhpYUtKK2gySmN5QndDNzBQSXNDSjV2aDh6cUxkQ2pQbHI0Z2U1ZGVmenhZMmFRU2E3dGFZdHdtelNaWWdkSkZkSC9ENHFJTmVNZnM2bUM2ZFJ2bFNkaEYrTFhNa1crM1JFWlYzZ1FvZkp2Nk9PMzlvRldvTEZKQT09IiwibWFjIjoiMzlkYTcwNjhmNzM0MjYxNGIxMjE0ZTM3Yjc4M2EyY2JlMWJlZDI1MWIxZDczMGUzODNhOTI4MTFhNDY5NWZlYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(98, '35314387', 'BitLabs Survey Router', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6ImNieHA0TWN6YWozenByM2ordVhVY3c9PSIsInZhbHVlIjoidnBsYk9zaFFmTHJVelJ4VVBXOGcrZVVMd3RjK2lWWGNtUDZNWjVHUmlzT3ljb3grK3QxNC9rR05sMTRXSDlnNjFuMmdISFIrdTE4WmYyY1dhcjFGMEpib1ZKY1NEdXdFam9IMVozdW85d3FUcnZ1SUNDcW9leVhPZTEyZGZmQ0xnOVhZUmJrRmdxYUpvMnA4YVRsUk1QclRPbTRnNEdrYmJYbERuYzVlbFd3d000Sit0bHk2ZXNnb2RVcEpQbUNERnU4UmIwV1UyejdBNVlWblVHNStFTUNQMnVVa2lMV04xK2JqcDRHWGJDT0FaYmdXUGlUWEpjYTdCYzU1TGRCNWg0ME1BV0U5akV6dzdSamlhclh0S1BZZHBNVDh3ejVUWC9NYXlmQnV1U1MwT2JHSjIwOFdlWTFTUzJpbWkyU2xyWmVNd01SK3ZLM0dPNW9IdVFsZDd0QXRTTnA1dG0xaG9qeXhiMnIvUW1BPSIsIm1hYyI6IjQxYWRjNDgxY2M0ZGZmNmY5YjVmNWQ5N2M3ODQxOTcwODRiOTA3Y2FhODk0YzMyODYzZTM5YTE0ZWE5NjVhODAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(99, '2586624-IWokOlxS3u7vTjau', 'Scrambly Web', '', NULL, 6.00, 'https://notik.me/api-redirect?token=eyJpdiI6IlB4empGT3E3QzN5Tk5LOG1VaGRiMHc9PSIsInZhbHVlIjoiRDhaUEdQQlR3dGExVkVPNXU0Rkk1RWYxSVlZWHFKTWJ3cXZFbk5qVkw2T21oSk1Kd3JhMXZEem1yTlM2UzdrWm5XUjhoYXB1TXB4ajdYWkgva1NPSUtwL2hlUjlteDNmNHBjdWNBRXk0NmpVWXJCbVN0VTRTWWovWmlWVXYzUWpCOE1VV290aXFXMVNTSWZEVk1WYkxXNmRYWkprMytsbk5BbkRvZnJUcWd6Y0kzRGtacHlTcHNkeFluSTliTnZweTQyZ29DOFlBcm1YQ3VKT0JrSW5nRjBVeEwzbVBLU04zc1R4cHREcHc3R0Z5cGpNaHFIbUptZVBJNzhGNDFuMlJ1YjRoMHd0SkNOdUJRQUNBUTBGOVpFNk9hQmI5akNVeEdCWERLUm1YS0psVVVZRDdzd2F0dVVCUnBTVjJmV0IiLCJtYWMiOiI5MDY0ZTk4MmQ3ODk0NDhlNWNmNGQwZDg0MDkyMTI4MzQ1YWMzMDBjYmI5Zjk2NzdjNDliZDJhZGQyZDA2ZThhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(100, '2599535-IWokOlxS3u7vTjau', 'Bubble Boxes - Classic Match', '', NULL, 0.68, 'https://notik.me/api-redirect?token=eyJpdiI6InZWTFIzb2M1SUdJUEFtRlJzTjc2Snc9PSIsInZhbHVlIjoibnZiWVBwRktuYnpqZW1saXIxSDU5aGs3RThHaXdaTnJoNzJKZ0IwbTZmcDQxUHNoVzhYdG9BUzdtVUlIUE03Y0dod3FWbWRmVlVGOXVVQlJXenhQQ3c5Ylp5WXZZRk5VaUJkMUVHSjVuelVXTit2TWxFYlJzYm5Kdk9aRzdtbjRaL0ZadWUxaTRqSWV3dUFTa0JKUlFDancxRFI1Mk9FV1RXQlgxR25MLzljRnhPdGZ2bE5mNElvb1VnRlFCVjAvQnh5eHllREJkTXFiNS9aZzlzSUl6cjdzNmw3bW9QVDhRczh3QzNiTnRMTTZrWTgwL0E2YW5mM0c0a1IwdURzVWtidE9yWkVTeTRLL1dYWEdjQ2MxNmhrNit6ZVVRTHN5dC95VGtpRjZIRXRGOW1IenoxODBrV2FHTjFFem1lZ2VtdXBPM3dsYlNMT1B5UTUvb2VKSmVRPT0iLCJtYWMiOiI0MjgxZWU4NTE0ZDVmNjZlYTU1MDljMDg1MjdiN2I3YThjMjMxNzkyOGMwNTY4ZGMyYzA0MTU2MDE2MzIwODc3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(101, '2599933-IWokOlxS3u7vTjau', 'AppGift', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6InBnQmZGQ3l3YkpNN3JmVEd1VTVUR1E9PSIsInZhbHVlIjoici9ycm95RVY3WU9NcGkrS3djUy9iZDc1SXZndSt6YTlLVnIwVDg1eWNtazR2bVN1U29qNEZnK3NsQytvUEVOVy9qZU5qa2Jka3BKL2dvSTRzMDZFbTFQUVZoTmFlUy9zMGpUZ3lPNndueldnditINHdSUjNxYk93VVlIMmREbFBqd1BTWlNVYSsvdXlRNzMxb1BZZ1d3R3E0M0xtZ3dsb0dnZjJyOVBRVEdWRThGc053aCtTT1dYSWpYNTJKMWVlbEJXekhDLy9SN09WeEY5SGZGdzlIT3M0RUd2bGVMMTErVDByNlZ5NHg0WHZPUmpRR0dBME05VmNTRGlWWmE3bFdSTE5rdHplRUluTHlOT1E1eHhZaDJCRmpnYjZ4U1lhKzJIc094RExzTkVKM2gwVHJnL0Fkd1FGdmJnKzZBQlQiLCJtYWMiOiI0M2MwMjU5MDc4Yjg3NjQ4ODYxOWI0ZGJiMzgxMDk3YzVkODM5MmExNjU3NzE0YzMyMTYwNWUzNzI0YTE1ZmRkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR, DE, IT, ES, GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(102, '2600403-IWokOlxS3u7vTjau', 'Bubble Boxes - Classic Match', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6InYybzJFVVhMQjY5MktnMXFsZU43OVE9PSIsInZhbHVlIjoiL09jM0hwS0tYYUxwcG9rMWI4TEl3M2JaejJKNkt6eDVVdFkvVkMvR054dGMreTBLRWNScWFxMXo1eGViTGJaUHBlTC85RjhOWG1zc2UzTHNpN0N1YUlFS2JHTGZWS3Uvci9PSUhiamFtNXpPL3B1N0lqYVpFQ0xGSEJCRzl4K2dhQ2FVUTY3SjJKU2IxU20yemExVURIcmhBTzJESWdnSkc2aTR6a0N1Yy9zNWo5d1ZhSkxGeUdwZUQ5VWNycXR1TWxuWVRXVDVYa2VXTTBuVVhiUllmQjhiOFBFY3JIQlNhWm9tMHZoa2RGM1JjL2ZCK0I4dmtJbUNiN1VtWnc2TjhCakkzd2VqTVJoWHh6RE9BVUVDQ2VIQU9xRzVPMUViTzc1anRrcTdtMXNPWDF4NDRBNTkrU3FSbkJvTXFPUEc1MU1jL1QxNE9vSFRhUmtUSDFqY0xRPT0iLCJtYWMiOiJiNTJjZWVhN2NhMDc4ZDE5Nzg2NDA2YjE5YzAwNDRmNDRhMDNkNDA5NWZmYTEzYWQ5YTZmZTRiN2JkYjQwYjY3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RU', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(103, '122659-E7nlASr9iwTZgV23', 'Hide N\' Seek 3D', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IkoyYUQwejJEckJTaTlydG8vdjA2MEE9PSIsInZhbHVlIjoiYTI4dHZ6UWRuUjMreWczT09JUUROYWFiUGtLek55OHRBYTlqak1mbHhaOThscnU3SWNEVGFGQ2s3S3dWbU4rOEdRUGs0MEZuWE1LOGpJTEd4NGRQY3JyNmk1aUpWeHRHTUJoekhTKzgxNzRVY09oUWF0MExkelFkb1lJdXlIUlJJa3BPZC9BR0kyUjdjVnA0d1BNVXZlUlFOcUhEdG9wYW02SUFUZFIrOVN2TW5EeFlLMVpyUndWMDdnbTZGWDl4TnBkTlAweTFtSERPVzloMk1KTjFUT0ZNMXJuSGwrWXF2TTFIbEVsVHRKbllqZDNqMFRodG90TDZxRHQvdU11ZkxnaFRHcHFEdjVyM1A5NlJEVGJFRSs2c0l5blo3cXJwakV5amZFVENKZWhxa2djbW1RdW9TN1V3clAwNTNFZTF2MFpqSWR1RWVUendjSURXeFdkYUlsN0VadXpOMlczNTYvbXJVbVFCOVM4SlUvM0JacnhCNC9hVkpWdVNjK1NQTm5IeFA0RWNXMTRzakZwSDRWV3RiQT09IiwibWFjIjoiOTk1Mzk0YzU1MTNlYmI3MTM0NDM1Y2JhNWUyYzMzNTRmNmU5Y2M2MzhkZmVkYTZlMzU5NTg1YjAyZDYzYTA4YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(104, '121729-E7nlASr9iwTZgV23', 'Monster Squad Rush', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IkhUUFl4YTF3OC82YURod1BtVFdKYkE9PSIsInZhbHVlIjoidkUrSDcwbkRvczhGV3pSSkVHRmVVSlRudjN3MXRQbVc4clMvNDhJNDM2VHgxaTU4Q3hzM0ppazBCV0dhZnR3dGlZZ1JRSzJzQ1NVYVFZaDhMVUozOVRiS09Od0VsWHl3NXVHaG5yaURqWDAyS0phdUZHSXRVUVZYTVAzcDZ5aTY5VDhxWHR4ZVo0VEltUTlxTVo5S3NqU0p6WlZWREZtYWN1U3BVMFJTUG45T3pDWnZkTVlKQWMyaVpUV0hDbE5GZ3JTeDl1QmJsU1RqNk9NalVkd1R5YUh2T2hiYXhFK3pFVk1tL0QyZlZneVYzUXI5TmVBRGZRMXFjWkhCZlZGQnJGaElWUDZ5K0RkZklCZUNaVWRLcE5mSnFTdkZKd0RBUjRkQWVsOWJTSzRZSzRhT3duVk0wYUJiM2ZJc1JVZ2lMZUFQUDVBSURHSWVXZytlTG5nZlRmanlMUFlzWHdHOWVtaDNIWjlpK0JpcFZtUVRLUGRQMkJER2YrMVQ5YllYMVhDZWU5WnZubWhIT2hSeHY5UDhFdz09IiwibWFjIjoiYjhhY2E1MjEwMmM4MDYyYTlmMDAwYTQ2NjE3MTFiMWI0YjQ3NWE5MzAyMGMyMzc5YzdhMWUwYWZkNjk0NjI5ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(105, '121706-E7nlASr9iwTZgV23', 'Text And Drive!', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6IlhTOUhGZ1NMSzdUNzVrR1N6bk5xMHc9PSIsInZhbHVlIjoiWG9yYWJJb08wYllveitzcjJhUEczRXhwQlNhVk55dG9JMkhwazV2SDM3QzZDQkprb0RRWm90ekM4WVd0N3QwR0ZVYU9aM3pseWpCSG15cXpJemxaZkRJRjByS1NvSWRzSXFZOUZrRXo1Z2lUc0kwWnF2OGY3WklXVEcyeisvZTl0VEJ2NTdyVmgvRGFhL0p1QzZRWE1JQVg3cWFFQld5a21vSXFrY1BLZVNqQy9yUzJqNmN4VnVpTWl5ak9xTXJUOXFPM2VMZVJhYUJEdWtMVGRDdllwdTlVUndwdm9hSWQxMjFGZERkNG1VNmJLRFFORkR2QTdPOE9yRnd0Zk9GMnNFSU16YmVYaUgvWkwxeFBoV2VKem1EL3d0MHZyKy8rSXcyYjBibWduNWlSUTBnR1pDKzNReHpyMklKWlBnUlQvdkFKUHl2blZ0NVM5UDdSV2JRZWJaYVlQNFFsRVJKVHI2TFd0K0lZTWFtM1dwNUcvVmgxK3FnYm1laE9ISjVqSktvYlp1bWVwdUY4eTUzQ1pNL0VJUT09IiwibWFjIjoiZWRlMGQ0MzM3OTUyOTkwYTE1YjdkNmMyMGNhYTk5OWMzNzZjMWU4ZjkzMmYwMjA5MjhlYzI2N2U4YzYwZmZmNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(106, '121301-E7nlASr9iwTZgV23', 'Doll Dress Up: Sweet Girl', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6IllzUjg4TmYweS9DSzBuWXp4TW80U0E9PSIsInZhbHVlIjoidkE3K3NoT1hLYTVyc0ZlbVFXRlYraXAxcGt6Sjg0RXJWbGo0RGJsNWpNbWNOYm9aandUSzk2Yy9TdVZTaFovendmQjhVK29nSVA5T05IdXZxcTF1N3ZiVlpuY1ZUQ3JKYjREWnZnT1M4Q3RpZ3R2Y0FnVXRrVG4zYWI4V0JUS0h2cHZ3eWFpcTNSYjhzZG54bkRZYjZudDJ4QkFCalBhanRYV3BVRjhTSjNGWTlRQU1VcWNiMlpmcDVzOTVQNXFoSVVPN2E0LzlaOVFGcEI4b3FuODUxNnZhS00zMXMwZHJBS0laRlN2ZVcvTWFKR1FiSEtGM0hob1plV1N2VVZtTDVnWmtXUUMrSW1YYW1xY0haSERVUUdvY2NQeUdYUjdXNUFZYVpnUk5OSzlWeHFHdXpBN0lET0ZzVUVVbmRNSll3blY3NEt4R2E0R0ZoTzhqVzFhZC8rNlJIY2oxMmpTSjlYVlI2dzVFb1ZkMmx4OE5PTHcwenV0WktSZjBndXJIL2pnQlNLZlBVQ3N1aXFWYXh3SEhKdz09IiwibWFjIjoiZTY1YTJiZGUxNzA5ZTJhNWJkZjZhN2YxMDgwMmE4YzNhNWQ1MzU0N2Y5NTA5NjA0ODczOTRiNTViZjFjMzk1YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01');
INSERT INTO `offers` VALUES
(107, '121299-E7nlASr9iwTZgV23', 'Doll Dress Up: Sweet Girl', '', NULL, 0.51, 'https://notik.me/api-redirect?token=eyJpdiI6Ik8vZGkxanNnNUFVWkE3MG1DMHNnd3c9PSIsInZhbHVlIjoiZkU4SUJhQkFnZFFMMkRkVVJxb21ac2dQVzFQSDkvNzNkenVJZnlKQVZCTEc1NHhYYWhXbFJ4aCthVSsxMVFVRE50T0N0eEVlWUx4dERiOGYzQzVOaFZiTWR0VzRSTzdmcVRPNGtxZGk1RWV0aWd2TWgrTnEyZDdwQ0JkQUdTVFdDbURqcnQvcStkQXVqWDdlT2tRU0RvUGJwYTB5NXZOQ0tLd1lTbUI2eW9FN1VPTkNwUk1JSkZXU3hRb3VFcTR6Ymhnck1HdEhxSWUyWCtORy9HejdLQ0pkNytvVlM5eTRMcHI4MjBOakhubk1EaXc4Z28yVklvWTZna3JNc1pEbmdtRGZrOUtqVFhYMGJWSjdOZ3I3WGcvMmc4L0VSRlVXWmoxSlF0TkwvU21uYzNKdTN4TzhkNTkxNWJ2ajJsYmZyS3grLzJnaGlqWUdmTExKb25PUTBSNytzd1RuS1V4dGx6Qnp6Qk5RcjFwVTlhaUY4SVEwRlA2UDlmSWRXVHNmQzZRSUEyaGJtampFMmRTRGVWcG8vdz09IiwibWFjIjoiMDIxNWMzNDE5ODc2ODUyMzUwZWI2OGE5Yjc3OTA2M2I1M2I5YWQ0YzQwYzQ2MTk3ZmJhZjMwZDY2MmJmNGVjMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(108, '121266-E7nlASr9iwTZgV23', 'Fantastic Bricks', '', NULL, 0.91, 'https://notik.me/api-redirect?token=eyJpdiI6ImROT3M0bDBDSE85VDlEN0FOM1VHRHc9PSIsInZhbHVlIjoiZFgvWFZBczBSdTM2dm50SW5oeVk5MWZPWlRYT2F0L2JOUnJoSjd5ZWpDUlBsdmY3TEpGdmxpSDBadEQ5c291eWdHeERqTFlCdk1NbjJrUjUwOHhvTjhaekxlVUJIZXlGVzl5VllYNjZGRGFuVHRIN1A5dTJZY2VtNVRvd2xDakZ5bmpnL2laYzhCV2pVRjlWV1AwNWVMeWpFcVNrdkF5bXlsaFVCVEVkV3k5VTJkUWE2TmFhMHBpMWVtT3JibzlwQnBheHM2UXFxZ0daV1VWdnErWUtCankrRjh0T2tDTzJiSDZCYmxodUo4RlNKTTVZckdQZWVLNG95bCtRVUhnWlFERmxaME16SzJTUzNnNjRJYUh4MTYrRXkvdnVyVlJlK3J0YkkyYm1DbWc3OG1yQ3YrZWRLVS90MHZKT2JRditNWFVMNWxCZWk1MjBsMkNTZVpmZzg4SkdqWTRRMk5UNEJHdlNWSXQxbVpXTlpLbU1FTElQR09zMVB6RHIwUm9hTGZEUFpoaU1LY2k2OEhzcmZJcGZ2UT09IiwibWFjIjoiODcyZWU2ZTc2YjNiNGQyMmQxMTM1NzAxMjE3MjI5NzkwMmY2NTM5NGJhNmI4ZWVjZGJlYzRkZjUwNjUxZGY2MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(109, '121042-E7nlASr9iwTZgV23', 'Parking Jam: Car Parking Games', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6Ik94a21kd2ErQStaZEZ3SjBLVXQzQ3c9PSIsInZhbHVlIjoicjE2QXNOQ2xNTFFMK1BGN2ExQ1R2YVZQdk9teFRUWW5JMFUwYUhZamFYSmdRK0szS0ZpMHBhbEpISWxQTVprT29kVlR1VllmS29rd1MvRVkvazdzYmtzTFU3b25LVW5GN2RuQkVtNU8raGpMbGxUWmtIWXovejNETU4rMG9UTzZyMUQzWi9mck52bDNZNXpBak03cFVJdndSSVM0NXNZWUE0Q0F3U2Q4aytuRTF6V3h6KzF4eWNHMXJtTWEzUFQxNVhaZWREWTlqZDJObU5BYVZVUlhvbnJPSjdvWkovOFluK0tpTFlLUmNiTWdKTzhHWm5tYWtGeG5FeldLcktZZVg3TlVWMUN5MEhWY1Zlc29MK2dqOXVxUlBGdkp3cmMwZWlkRnB5U0owbkhEWVMzTUZEeXZCMlJRVFU3OUpoUWxvN0R5OCtrRENaRGFVSEZ3Mjl1b3JtLzdsOEhpMi9rNUZlNjhBN3JQODc0eHhqRlB6OFprdG5kMGNqaTRKQXE0dHNIaTY4Mk9STHR5a2svd2xGL2xkTGthM0ZmUW9DTHhKNEhxVk5tRlRnRT0iLCJtYWMiOiIwNDcxOTk5MzY2ZDA5MTJiNDYzNjc2NGFiMTRmNzdiYjkxYzZiOTllZTE3YjFhMWVkZTY3OTNmM2VhMTg5NTNiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(110, '121032-E7nlASr9iwTZgV23', 'Guess Their Answer', '', NULL, 0.63, 'https://notik.me/api-redirect?token=eyJpdiI6IlRDNE4yZjVWaFlXVnIrdE4wMS9kTmc9PSIsInZhbHVlIjoiU2oyM3pqQXQ5bElMK2dKVHUvQnN4N2Y5dmJVdG1ja1FJQnFDZXE2aFBZTCtLcjIwalcraCtkSzJPWUcxOUlDTGZ4aUJTZnp5MnZvSTYyY21pOGxlREFmY0NGdWx2V1k1a3hVREQ3bnpvTXpWY1k2cTdiemNzU25aTDVXV0ZVQXFwSTdBdDBOaXhuaStOWkx5RUZJSzgzQjc1TDVNVUpaWEpJQ1V4SStjeVpYYXZYWHlvaHYwVWs3TTdDZlY2UUNEVTQ2UTZhK0ozM09QRWJnbElRcjczK212emd5VXREbkNyaTdMLyt3QTZoSjd4b090d1c4RVBRc2FSeEdkaURVZnJQaVJha3p5TW9qK01wK3BLNGlCV0NCVDRFR1cyZnZJRlI0WVpySHdOL09Wb2kzU25xc0NVaCtqdGZEa1p2d3E1S2JZT3VPWEJCRXJBNElWVEI5NmpvT1dFZDFHcExqWkRtc2src0FlZ3lJbVRWTCtRdmlDaXgxSkZQYUIxM211ZzE1Qjljd3M4eXZlajFmc0J4SUNsUT09IiwibWFjIjoiMWUzN2YxMWZiMGJkMzljMGZlYTg1ZjY0MjBhODUxMjExNWFhYTM3YTFmOWNiOTQxZGFjY2Q1MjdlYzhlM2MyOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(111, '120949-E7nlASr9iwTZgV23', 'Parking Jam: Car Parking Games', '', NULL, 0.54, 'https://notik.me/api-redirect?token=eyJpdiI6ImxjajUxb1hrbUNBQWUydW12MWlGVVE9PSIsInZhbHVlIjoiN2pLMjhjamx5Smt1bkVMWlhDYzVsYXl2UC9PSFJqeGUxa2ZLdG8va2RaS3I3M3dtYWZFeXBQTUJ5T0VHY2tZdVFkbGZCZ2dvaGJUWFlTZ0lPVm9ZZGtXakYxWHlrUHNHalljbllsSmNNb1Nwcm9BUEZ5SlptOENmV2JtckxTU3hqYVBvV0NMTk1SaHpJUjZwd2VJU3V6WVNiT2JMMVNjNFNmMTFCOS9oUU5GL015WmFTRUxYVGVZUGVHY2ZxMUtTNnBvYUxwWFU3S1JlQlIwN1FpUWtTNFBEQUI5TFdWVW52VlF1bkxYWjg0U1pXY016R3FJckNmbnZuditHMTZob1ZIVk1MMll1M1E2WjNwWnJVU3VlSlZydEhJR3BYa0I1OW52Qk9xN2ZySUdST2pPUlpmYnRnYlA4UFZjSTRFNE9LOWNNc1E2OUhwcnJ4cUFwWWFHMUxSYWJNcm81cWduc0poV0dhUXRpT0V0Rmx1Rm1SRTZZSzhwU3lLSDIzMlZxdGtIdUM2c2NXclAzQ1ZGcXVOdS9yalhicXF0eGs4c09KbXo2aDVBcmpLWT0iLCJtYWMiOiI3ZDVhNjM4MDIyZTdjMDRjN2RhMTdmYzkxNzM4ZGViM2Y3ODFhMmYzNmE0ODkzZTcyMDE5YmU1YjVhMjA4NzVlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(112, '120779-E7nlASr9iwTZgV23', 'Cornhole League', '', NULL, 0.53, 'https://notik.me/api-redirect?token=eyJpdiI6ImRxWGFwR01QdHQzRjZWU2JJSHI2Q1E9PSIsInZhbHVlIjoiNzZGcnl6WFpyUEhEU081VVVETkVuOGZ5bzV5Y1pOZXpEWXhQNmpIaXE5VDl2c0hEWGVoSUJsSTJxYjZUc2NiZFRlWjFHNXp4RTJTSmN1TUxXbW5wL1hDOExBNzc1a1pWVk1qMzRaNWdHcDI0Mk1CemUyd01LTnVma3pKMTViaWJOK0N0Z0dHa05SUnZ0dUkzWjhaMXNZK2pyemtqRS9yWXBZRS8wZi9yNUxEZVNWdUlEUlRlUkJPblhwc1E1NXk3VnhWcW96YmxuZG9Wa21Rak92RTBYZHZvRStXOVVUbnVJQ2c1TzZiY2poanREQTFsZ2UvUVBDVXZDYnZDaHNUTDNkd01iU0FQL2RlR3A0MVhvcDBlamkzdjQrdzVhRUh0K0NGako1elorSGJ6VzAvL1VWSW1JUUtIRnZ6K2Q0MDgvMGV4MGoySlBsWTM2RE8yQ0dTMi9EZjB5aDhqN1V4bjdldTJWUU1WZEpmOW14T3pXTE5PT3p5Q3M4SmtZc3BUOUx1QnREcklLNkMxaitsUW8rSmRQZz09IiwibWFjIjoiY2MxMDU4Y2NiNzFhNDdhMjhlYzZmMGUyNmQ0YTMzNjBlNDNjYTcwZjlmOTAzMWNkYjA4NzgzYTdkYWRjMzBlZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(113, '120778-E7nlASr9iwTZgV23', 'Cornhole League', '', NULL, 0.45, 'https://notik.me/api-redirect?token=eyJpdiI6IjRsSTBuaXFPTGVMa0F0dDM3WFZOelE9PSIsInZhbHVlIjoiSzNNZmlwQWdqR1BuQlNFUXErREs3NG9VR2hUclA1WVdwWEVqajBTdW00VERlQktRTG5lVXI2TzNqbDIrTEhiNStsRThSdWt5ckhFbjZXU3dlSWxtQmk3d0pJb2VERlFVZENCMEhndDAwT00xMEJOcm00bnF3cjNaREE3elRPb2I3SjVEYyt4Y2tpdTZZV051Z3dpVlZuZ0VjTTVyMEczUUloKzR3RUcvRkZkd1BiSkJ6emtZbE1yVEFZSytRLzNoRTBRN3RUSEtHQnEzeEp3Q2tYc2FueHdsbUl4TGNJb0J6R05VYng3eUE0eThWNTRWQkpXZ2FFNnRNMnQ5c1pLRENqOTNXUTlOY0xlMjNUa1FKUEI5VVFOVWZiUk1JaTFEOFY5bG9Xcmt6NXRobVR1ZXZLVWFLaWtPY2pYbzk0L3RxK2JDYk04VWVXSU1UQXZZWDNrdW9sQ3k0bXVQeXFJMlRkaW9reTlMN1FEVGlpOExBbGszQVkzMTNaV2RnakpFNG1wclFBQnBhM2cyejF3ZmdJU3JOdz09IiwibWFjIjoiN2I2NjIxNjliOWIwZjZkMWYwODBjNThiMDVlZGVkOWY3N2ZjODk5MDJkZDBlN2RjMGU4OWUzN2U2NTJkMWY0NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(114, '120700-E7nlASr9iwTZgV23', 'Color Water Sort Puzzle Games', '', NULL, 0.17, 'https://notik.me/api-redirect?token=eyJpdiI6InNWSVJKazhPa1paUFZsNmtaY3BuS0E9PSIsInZhbHVlIjoiRjFPOERuaUpkcnA1VUJacHdBS3Z0a1pEVTJ1bThXenIrcWlKSFlQaW9aUlRvcGxVbUVpVE5JSGFSaDdvSXJUdHhIN1JQVVVXMCtGTG1VNnhIVkV2N2NRMVFOWDdrdHA1Rkx0cUE3SkRxMTFQVUQzYlVTSWEvMnJYdzE4UEpPczE2Y0dwcm1oQ0NpcGZsUEZGbXExRFl4TS9Ed0c5dGhDaUcrWDdOTkJsbE9ZUklhV2c5anJhUFZWK2hTUEpUdlV6MmR1U09mcFU5VWZBVk85TE5veHAzUHRuUkczeDcrcDRLZ1FqY0FkTHhJbVp1OGRrNk1LTmJKY3NMMTZrTXA2U21PVzFTYVdTZXRoYlZsaVl3SjV6MWlIWVJMWFJpMzErc0E1WWZiQ084Q3BYSHdNRGpzTDJtTzlIMkltNHBMN0ZZUEZtOXhYQnNJN0hqaTgyQWx2eXZOenBSczh0SUFXTTdQMVI2RGxGRWxDOGxJTnk3TzROYzNmUHpUTW1zZGQrNVA3amkreG5Fb0t4TEd2YmxtUjhMb2pTTTJlSzZmNkpTWFNUNnorWjRyST0iLCJtYWMiOiJkMjA2NzFhNzVjMzBhNDg4M2RlNDYxMzc0OGNjZDM2NmE1MGFkNjY1MjMzMGM1Y2FiZWMyOTkzM2I5MTAyYjNkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:01'),
(115, '120699-E7nlASr9iwTZgV23', 'Color Water Sort Puzzle Games', '', NULL, 0.64, 'https://notik.me/api-redirect?token=eyJpdiI6IlRNVXM3R3B6Tk5zQkFMazNMK3ZKSnc9PSIsInZhbHVlIjoieTZCVEVEVC9wSG1ZRG5TLzExVU5vVTREY2hycDdsTFhWd1pwdWEwaUVCaW1vNlhZMFJ6UlgzUVRLM0JFc2JZT3pDalhrc2RIbUdtRjFDdWk1VGdldkxyVHZsZEUvSnpST2JCN3A5Yzd2N0RSbWNjN1dyYmlSVWVwUUJ6c2V2dGFGbVlQR3d2aFVKc2xPak0xQlBFcjY2YWRqL1YxQ3UxakJaQmgrbHVWdnhJM2JlVC9LNmRsY1k0dWNtN1loc1U4dnJ5WFNkTHpNeHdQWWRnb3lXVTJhVVBDVnUxOUpIV1Z3eGt4bzQ2OWIwcGx0bVlzYlBEWG5SNHl4Z0J4N1BVUWExVjVRcDNRSWVhMVpJdGpEMGVDVUt1U0pNdm5lMnVmNTIwNzF0OGt2OFhFVDZRalpSa1FtZVNsYmhCMGJBQkNuTm95TFFXcnlSNmhsWjQ4dGxBMFFWUHQ3UC9IWms2OW1tUml5Y1F6V0JlTlYxTzhxdlZRSVRtQWExc3NneWF6UldhZFEyN1FkSVM4YmQweUJ3bTFHSkI4dWI1cVJaUGhvellOc0pvckF2WT0iLCJtYWMiOiI5MWY0OWYwMjI1N2Y1ZjcxMWY4ZTQ4NjIzM2FlODFhZTQ3MDVkOTQ5ZWYzMGFhN2NjMjk4YzU3NjViNzQxMmM1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(116, '120698-E7nlASr9iwTZgV23', 'Color Water Sort Puzzle Games', '', NULL, 0.54, 'https://notik.me/api-redirect?token=eyJpdiI6ImxqVExVMjc5anJYV3FUeXdPSmFvemc9PSIsInZhbHVlIjoiS2kwZGNvWDNLa2Q5U3o1NHAxZVJ4czZaODZRVXd4U1dhYWZ0L050TzM1L3ZzZnFRTWs1cHBudVhEUUZMYktycGEvc2VuUEF0MGVuMWF4eDJHOXB1NGNhSndCZW9KOWphOWFuOEorM1VxWGk0UStZb3pyejhVRmpZQnVYbVUzVlY5U0RlRFpOMHJ1YUN3OXVxMDNlZ3dZT0k5R2REWStkTkluUlJqbjB6ZzR2UnRpV3lFNm5VTG5xM2tNbk5YOU1wZUh4OStoaU5OdE1BZ2J6Q2wxMEhSKzI3d1VaRktGenZGMkhFYkV5dkpXR0llOUMrcEs5N3FvMVg1NS9lb0dDaURtd2QzdkxGUERFQVdmWnJ1NUl4ZlVVcHRaczJWZEtyMXo0blZzQllkbHE0WWUvRGlxUzBXNlZ3UmdmYy9MQmw0SXhKVUR6bjc1TGxsT09DU1hhR0UrK2NHQ3NiWjZxQWhmMzFSZ0g5dUx3c3BUbUZIblY2bmhSUzZtYmZZN0NHUzEyNGc2SmxEL0UyczBGMnZOdjFGdGtaOTZlZ3VPYWlkT3Z5WDZtaVNXOD0iLCJtYWMiOiJkM2JlODMyNmU0NzQxOTQ3NzljOWE0YTM2YzJjYzUwZDNhMTQyNjA0YTQ1ZTQ0MDhmNmI5ZmE2MTNiYzBkMGRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'tablet, mobile', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(117, '628032_0-WU4O19ugcV0tSQcU', 'Science Sprint - Android -', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6InY5WVlyM1ZwR0dXZ1h2Vmc0OVZNb0E9PSIsInZhbHVlIjoicjFmYStpYzNFa1BVU0llS2dKQkVJTW5haFlhZDJJZnlWMXlWWTdKeC9JUnd4UFFkYlBOSEZ2eWxGeHJ3NDVBM0ZGTGVGaWFpT2FoMjhLbWVEeVBGWGRVb1BmRTgxRlBwUllodktQNlhCR2o4eWZpWlZlemxMRmNqNDd1TStWdHhaOWpXTVBGUWVFQnJjU1BoZW9LK2lVdWRpdHVudmNaYVIySzdwN1Q5dlhyU0w1UEVpazFsRzVEeE5LVHZpdm94TTVJYXZFVkRPYjB6cUtseFB6TE5VL1Z4SWtob1ovWkxRM0Z6bUIxa2dBT1VuUDRqYUYwUW9xTTVlWStUQVNxeFRMOFZZMlMwNWxMMEtock0xTGdpbEVBZzFyMncrZnNDeTZoaDFyT0RpRGNYZlMwMFl6YkQvK2pyRm1HWFlUWThMZVdMU0xWNTVBSnAvOURaZmFEcjNMRGplbEpuM29QNTAreUdvUVVQNDNHTSttc2p0aUV3TEVDVDBidksvTXlwenRyT2hzOGEzRmdhWU1ESFVXWGYvMEJwb1NDbnVHWUhrbzFHQnRLR0M5SHZCYW1vK05CZ3RrK0hxNXV5ODdDWTVUL2QyTHkzdktsU29mdkVweTQwMGtRTXIxTmNUczFHZ283cUEva09TYmxZMkNLbUdWaXozbThSWEJESjFKSVciLCJtYWMiOiIyMGUzMzdhOGE0YmM4NzFhMmEzM2E0YmYwNzZiNWE0N2NmZjQ2MWRmZWI5MjgyNDFhOWM1ODgyYzAyYzZiNDljIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(118, '628554_0-WU4O19ugcV0tSQcU', 'Craftsy Classes - Trial  - USA', '', NULL, 2.10, 'https://notik.me/api-redirect?token=eyJpdiI6IkcvT1RQdTVOdUlzTEVXYWo1Z2RQYkE9PSIsInZhbHVlIjoieEdobFRzdllDSmwvUFRvK0c5dHBrS0M3bGlaTlN5dGp4NG5Fd3FzNzMrZDJoN1hNd1VSWk9FNXhSVUh2dmRoMmpMRzBCT0l6WXp3VlJEemh4anlUL0UzU056SXBXRFZjWHhyRk1rYjJzaGh2blFKUGJvM0hjT3RqOHhmckRHaWRLRzhHWHRtZEJvMmtZWU1QeUxrS3NZdGRtNVhFbkd1WmVSVUNlOTU1M3VxMG81SFpSYlJ2N1lTQ1BIbkxPbUEwaG1NNE9OZVMzaVV1NGpqRkNGUWdWVUVyVnM5amF2RkZZSHBlcDJMMENzSmZrNWJ5ZDUxZ1JKclcrcEdxMGRGSVV0UzlqQnNxTGxabllEU3BPNDBOYUNld2xtV1ZQUEJZZUNIUDRnKzhQUjB1bGU0NXpMODNpMkJnZHBGNlBHMUZMUmdueXNBMVFTMTcybld3SXNLNDZMVUcvNVBxRmdFSzJOQlFMSWlBUHliZUQxS285VVF5TWV3alVzTUt3dDRmRExwdFhUS095akdQenRPalQ4b1JQNUY2TUdKM3pka3hmcU0vZTBXcUN3SExaSVlpSHZyTmh0OWNtT2RpbHBPNXZWU1BEVkJDTUkvenpXOVU2dnl1NFMzTnZGQUhUdUFMYTVUZUhiakFCRTJ4cEhkeGVJOTl5RVNEZm5rVEVWQzgiLCJtYWMiOiJhMjU3MDZkYTgyYzczMWRjYmFhMmVjMGMyMzlmZGU2N2I3ZmU2MWIxNjIzMjUyOGVkMDQ1ZWFkMDM0OTE0NzJiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(119, '628563_0-WU4O19ugcV0tSQcU', 'Tata CLiQ Online Shopping - Android Install & Open - India', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6ImJtT1MxeHRIWXB6TTNtVWJpNW1Camc9PSIsInZhbHVlIjoiT0FkM0tmaUJMd2dVQk9KZjl1QmFLNXM5VExIaUtyS3JXOEYvYXRvVjNTZFBQQ3NYSjNFbzE5MWxvMmgzRHhlbTQwN1JlWnd0eDZJVStwSXJ4RjRENHFvNEY5T2xPckxXd282ZWlzRTZDODhSaDkzVVNHN1dYK3BDOXo0b0xyMzh2WmN5cGkreWdIY3pGb2JlUUZBRGJjUkkwMzlZNGNuK25oc1NIaEpTdUp0ZTZwdmRDOXJtVzluVUczU214Q3VSRUxodnlnVXRKWTdRRi93ZVNUOVQ2M0d5NW8zYk9KdVI2ZWhlMXVHMjN6VW9JWEZKWksycWllQzF5TzZ4eHZkTkNEOGJaU2g3RUZiMnhkbkZYOXcxYWFRbzFIdlI3SXNhSjdMRFhoMjVWL3UwU0JjN25TdTY4cjM3a25mVXUzRUdtUEI0S0Y0OWFlQVVSZ20ycW1QWmU3V2gzbWljL1BPWmJMMEFWRy9sb04vNndQcmsyK0c2SWpqQW5uZEgzRG5SRzBvTEwzMzdaMDJEM0JsOTVPNmlmc0ZDNTVGT01QdzJhRThIZVJ3M0FQZ0VzSWVCMFRMUzBQUGwydWtFQmx2SkJFRjRUOVA4am55OU10NmsrdDVKWUpwY21EZHFiMVo4TWxEblIrckxyUFVoZUYrdlRoeUxuWU1UOU5uTFBuemtzdTNkSDdhcU5xc1dlT0JDWkpMRnY2RnoyR1hLcXMrVFRtcEpISS8xcFdjPSIsIm1hYyI6Ijc5OTIyMmJiOTE4OGZkM2VhMzA2NmQ4ZWFlNWZmOGZlYWIwM2E1M2FhZTM4Yzc4YzBjNzNjN2JkNDYxMzZhZWYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(120, '628920_0-WU4O19ugcV0tSQcU', 'WW', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjZUVUNzcTAzeitUSHF0SzIzNmREdGc9PSIsInZhbHVlIjoiaUUwdnRMaURqdkh0SFFkNlh4bE9YbmpnNVFYQllpMGRSQnpPbFJUQmg5OGYwamRNTjU5WTBXc2kwVEt0dk5hR2QxZUFjRGhWcktLNTNHdVBXaFlpZFhmUVhKMk9IbnlEeFR2RE1HTmNTYy9tcXdpcXFrYm9pTkZpZGJhZUE2cno1aHhId0ZaWmhHcktzcUpoK21LVEdESm1MdzdPV0V2RE5IcTdXSFVBcnU2MnVVUkdBN2RySEFiclRJRGJCTzVkOGJvZGM5Vy82blNRTERnRU40Q3E3dzBiUGhSZVhtd3RlS2VJU2tMR2FPNnVpN3ZJTGwxb2FHVnM5TUpwYzNJVUxheUdidEEvaDFxMzZUbm8zb1VGNHlhY29uaEhIVnBJQnhQN2xzUXZONmxUangxTURJU09SWW40YmVXV1BBZWF5VTgrQWMxbktsb0FzaWFiSDZRY09FNll6VlZhOFJoTlBjQ2lIZkFhUG1qWFlzd2ExbXJIaFRhNGYwVXo5UFdrV3EwMk16RHE2UFFwby9xRGxlQWR1T3ZZaUFDQWR4Yyt1ODd4alVjdU9uYkVzZ3JMekJjN0M1c1VPVVZaeGRHN1kwQ2w0SjJvNFpTcStrUndabXE5U1laclJVS3ltdXNkZHFJb0lOUW1pMGc9IiwibWFjIjoiNzFlNGQ4MGJjZGQ3YzlmM2QyZGE5NjRhNDZhNTc5ZWUxYTE4NDQ0MzUxZjM0NzlhZjA3Mzc3MzZhNDg3Y2UwMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(121, '113865-C9lRP9r0SR6haQk1', 'ES - Avenida Consumo: Samsung S24', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6IndXWlhyWllsM1hUUGZma2pnVHhKcWc9PSIsInZhbHVlIjoibTBnR1cwSGRqZTRvdHBNVmtEUVZ3RUJESC9wR2JHVDltdlBwM1FRVkUxRnVzRUF4dVBkeVZVQzBnR3NZNS9rT011THhFS3JNc3ZyeC91bGQ4bGd3MjMvZUpFY1hJcXF0WHRuaWZ5U3JrT2xsZ0pKUW5KTkl4VmVTcUNZOE5Yd1B2cHpUeXVBQmdMRVg0UXNsdUYxRXZMckdqK2F3QkxmVkRUVGhPcTNERjZLTldzTHpOWnBqejFiT0pNSWUyZlduVGg0ZUl4QktLS3U1UDJQMkdSWDlCajVIYlN4c3hGQlYydVloZnd5a2pXYVZ3RUk2WXRRNWp2R3JPeGtsVFpQRTJtM2ZDaFpMZzVQeEQxSUFYTm9ZeDg4a0tqN25BRTM2ZUsrRll6REl0eVlqNjg0WEVWWm10TVNobmZ1S3pjc0MrRlJkTzdLTDEzVGJlbVk5WVdTZWp3PT0iLCJtYWMiOiI5NWI3OTRmMzFhNTIzN2JiNWMyNWIyMGFjNmMwYTMzYTVmMDVjNTQ2YzlhZDM0YjdlNjA5YTZiYTQ4ZTM5NDM1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(122, 'BLMR-20105247', 'Magic Receipts', '', NULL, 2.00, 'https://notik.me/api-redirect?token=eyJpdiI6ImtET0F1L2szVlo3Zmw2cURwVWc0Q2c9PSIsInZhbHVlIjoiN1ZaTzNtdDV5THlMOTh0enV1MFFBSi9yMm95aE5VSjZiZEZTWEVUM2V4cTlXWlIwekM5a1V5cUJRTG1nTUZwN29WODg4M3hET0VmYVd1akZCQlRrN21mRkJsUUduTXNBaWlLUXlFdFpkeU5xTm4yOEZudzRaaENBT1ZrR2ZWYTNVMHBrK1EwUlFrNDNOWEJUQTczSjROUXkzUkd5YThJSHVJenpMOUdrenBXMW9CMG1jUjBOOUJjWHRxZExkSVBLUjc3OTVKaHdjRlYzUWdobU1QaGd5V2RtclJmdjlvQ25LSkQ1Vy9FdkNmU3FIdlZYVGdMb2RYWHd1SFg2MkZkUkJwUG9iSGVsalIrODl6QnJockwxQnc9PSIsIm1hYyI6ImE3YzZmOTAwMWViNDhmYTE3NWRjNGVkZjNhNjYxMGJjZWFmNDdlYTAxMTliZjY1NzYzNjQ2M2IzMTc1MWQ5MDYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(123, '115384-C9lRP9r0SR6haQk1', 'IsurveyWorld - First Survey - Mexico', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjRCM2w5SUkxemdOeGlJMmZMU0NGV2c9PSIsInZhbHVlIjoiOXRmZlk2b3NONk5xbktyQUllejhvTWxvVmw5UmZuTUtWQytsS3hhc3ZNWURHNmdjcjBRd3pGRjFaY3lqeHVPbEZyL3lObU1nNnZ1MmVWUVo0bFAzYzZZbjkyOUhRK3oxWVg5UmNlT1hMVmpGcWJtM3QrcGhneXNQZTZzTnZMeHpiZDcrNVUyWUk2dHZ0WlkzeStoOTd3UzJqTlZja2VTL0Q2RGxlYXJNZXByOXhaWEJhdmQ5TzFqckIrWWYzV24wVUtMWjJ6UWhsait0czU2ck5Kck1QQm96UDExc2lZNlY1V2ZGbXVoNmRxQVVnQWhRVDRhREp2aGI5L0VtdC9iRm1WNHpoNU9hVWdlaSttZjNQMjJrajBvK1orN2R5UytLTHp6ZGdhbUFQTlNqOHhkUHFWRnBtYlhZZmhMTU9TeXdsS2pleXZWS0hzK1V5STVJYWY4cDhRPT0iLCJtYWMiOiJiODI3OTEzNjNmNjllNTIzYTcyNjgyY2ExN2FjMTA5NWJkNGY1MTA0YWNlMjg1NDI1MDFlNzY0MDBkZWFiM2U5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:08:30', '2025-02-26 13:11:02'),
(124, 'foF8B1717472376', 'GrabPoints - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IlpDUXdrQ0lNVCtnQnNnSHQ3S1l5MWc9PSIsInZhbHVlIjoidlZKbUZtTlZ2eDZZZnRwcnpxUDhDVU8xN2NPeEhOdTJuS2pJS3lnQmt1S1JiU0FzV3NPM1lhdkpGc1lHY29VQ1RiK3A3TERwNHVBb0RTalRvdk5WeCttZ00xNzNTN0trbTBHODlKdnc2V2FlRFlheTA3RGVQUmJKZFQvYzAzMjYvbEFrb3RYbWhNZTFnNUFFSFJkdTdoTWJyNXZUUDdnakRmWEQ2eWcwUGN0SjhEQTlrU1FuRW5saUVYVkNGcEJTb0tQSnlMbXdUOGM3L2ZHUnQ5LzJhVUE1VmFpWEN4Q2lxT2lMSWs2dTRlNythNjgwNjFWemExelQ1cFliVTN0ZWFzVE5BSStZeExOWDF0cmduRkFqaHN0UkpxSldhNVQ5ODNONjByMjlQRjlrelN1MngwOTlpalZGN09JSDN3Wk9Dek11aVFqbnJMVEN6UTM0WEtIY0hjcE9SWHBhVmRxMHBHWHFsNG5QaE1wdjFTWUs3WW9VczRPSkxrUUJUdzVwIiwibWFjIjoiY2EyOWYyZjA2ODcyNmNkZjhmZGQwMmFlYjEwMWQ0MmY5NWRiMTYwNWIxNjc3ZThhNzQwYzQ3OWM2Yzc5NmMxNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AF, AL, DZ, AS, AD, AO, AI, AQ, AG, AR, AM, AW, AZ, BS, BH, BD, BB, BY, BZ, BJ, BM, BT, BO, BQ, BA, BW, BV, BR, IO, BN, BF, BI, CV, KH, CM, KY, CF, TD, CL, CN, CX, CC, CO, KM, CD, CG, CK, CR, CU, CW, CY, CZ, CI, DJ, DM, DO, EC, EG, SV, GQ, ER, EE, SZ, ET, FK, FO, FJ, GF, PF, TF, GA, GM, GE, GH, GI, GL, GD, GP, GU, GT, GG, GN, GW, GY, HT, HM, VA, HN, IS, IN, ID, IR, IM, JM, JP, JE, JO, KZ, KE, KI, KR, KW, KG, LA, LV, LB, LS, LR, LY, LI, LT, LU, MO, MG, MW, MY, MV, ML, MT, MH, MQ, MR, MU, YT, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NC, NI, NE, NG, NU, NF, MP, OM, PK, PW, PS, PA, PG, PY, PE, PH, PN, PR, QA, MK, RO, RU, RW, RE, BL, SH, KN, LC, MF, PM, VC, WS, SM, ST, SN, RS, SC, SL, SX, SB, SO, GS, SS, LK, SD, SR, SJ, TJ, TZ, TH, TL, TG, TK, TO, TT, TN, TR, TM, TC, TV, UG, UA, UY, UZ, VU, VE, VN, VG, VI, WF, EH, YE, ZM, ZW', '[]', 'all', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(125, 'EY8mp1717472371', 'ZoomBucks - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjlRdnBKRlVYL2s2bHBnZU1BMFgyNXc9PSIsInZhbHVlIjoiSHBtUUdtMkErejdhTEQ5Z2p6eFZTZGNNWUViMUw1djNMMjA4RHJmOU8vRnIvQWtlRzhRS0JUeWIrYk5xZXZrTmJzRDRWMERUdEJ0YlA0SDB3ZkVySUJFRTVIWTdHbXM3bzJLYTkxQVc3VEdrZEhEZ0pNZVlGRWkzbHNob1ZpSTNNSUdJYkIwNDZjYWtKQW5ETEo2YlpvUTNWbmpUajhFczVtVndXa3JuLzZNVXFlVlJTdzR1aWpwNWtmZlltNXR6dVY1U1laVE9yelBvemt1TmlOZXdkcWVzZlZQUTJzQ0xoWFl5OTZVZU9EOExlMzNhS2ZrQjJZZUJNb0V4MURRT3JNZ3F5ZnVKaERwMHdjcEMzSHNFaXJPb3piWHd0NVppNFJ2akNHQU1xVFRYWDltL2kzbXNxVW1OcXF4TWdXUDZIaDNXOWxRL0g4eUw1anVPSzc3d09WejBvQ21XK2w1a2xZdk5XT1BEMTJTZWg1VnkrQkttT2t5ZG81VDZDZFgrIiwibWFjIjoiOTE2ODhhYmYwMDY0NjNmOGFhNjFkYTQ2MjIyNGVlYzk0ZGQyYWYzNzJjMTlmZWIxN2RlNjcwNzBiOWZhYTk0OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AF, AL, DZ, AS, AD, AO, AI, AQ, AG, AR, AM, AW, AZ, BS, BH, BD, BB, BY, BZ, BJ, BM, BT, BO, BQ, BA, BW, BV, BR, IO, BN, BF, BI, CV, KH, CM, KY, CF, TD, CL, CN, CX, CC, CO, KM, CD, CG, CK, CR, CU, CW, CY, CZ, CI, DJ, DM, DO, EC, EG, SV, GQ, ER, EE, SZ, ET, FK, FO, FJ, GF, PF, TF, GA, GM, GE, GH, GI, GL, GD, GP, GU, GT, GG, GN, GW, GY, HT, HM, VA, HN, IS, IN, ID, IR, IM, JM, JP, JE, JO, KZ, KE, KI, KR, KW, KG, LA, LV, LB, LS, LR, LY, LI, LT, LU, MO, MG, MW, MY, MV, ML, MT, MH, MQ, MR, MU, YT, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NC, NI, NE, NG, NU, NF, MP, OM, PK, PW, PS, PA, PG, PY, PE, PH, PN, PR, QA, MK, RO, RU, RW, RE, BL, SH, KN, LC, MF, PM, VC, WS, SM, ST, SN, RS, SC, SL, SX, SB, SO, GS, SS, LK, SD, SR, SJ, TJ, TZ, TH, TL, TG, TK, TO, TT, TN, TR, TM, TC, TV, UG, UA, UY, UZ, VU, VE, VN, VG, VI, WF, EH, YE, ZM, ZW', '[]', 'desktop', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(126, 'gsQ201717472295', 'ZoomBucks - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IkQrTmFjWi9GQW9Jd3JPOUQzY0lUQWc9PSIsInZhbHVlIjoiTTlhdmpPMjlZQ2hKNE1DVi9yLzhQTzdiMmVwOURkeThRTzBZRjNMbDZ2NU53SnBSK295K2YwOUlsK0V0YUhDR3U3cUVvYUpab1BzOCsxRyt2SytqRUZlU3NHK1RlVlRrVUZiSndzQWRGZHB4b0hnMTBWZnJCUlVqUTV0NStmSUd4QkU1SjRFeUUzcUV4UnlhemZueXJQdHdBWC9lSmRyWi9rUWR3cTBkQk84dFNJT3NEY3pNbFVIWWJ3K1ExbXFVNkZWVHdhb0ZIU0hvaURLY2xnTURZQWFMdFhDWGdEaldXYmREZTk0TTdic1FZdG9WckxEZzZOd3NGZWF4TnZIZWtxcmduWFM4NkFBMG55QmhXR0Q0QmJMZDhiVDNXTEZkT21wUG84amhSSWlsQ0wwRDhHMSt1cjg1WFl5enpGcUhtaG5FWVQxQi91TWZqb0Q2TVk4c1RoTzg5MDE1WEd4T3AvUi8rWm1xamNUcVhPeXJxd2dIbEZONmxQbWNDMlJxIiwibWFjIjoiYzQ5NjEwZjkyZWE3ZTEwNWIxNWYwN2RhNDM5ZTI4MThmZDE2MjRjOGUyMzcyMmM3ZTliMDBiOWIwZmExZjBiMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, BE, DK, FI, FR, DE, GR, HU, IE, IL, IT, NL, NZ, NO, PL, PT, SA, SG, ZA, ES, SE, CH, TW, AE', '[]', 'all', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(127, 'KVcwL1717472291', 'GrabPoints - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjZXMjVoSzRJcWlmYXo5NHRmM005VGc9PSIsInZhbHVlIjoiM3VXcGFSREtxMlZDQTQzYkdPZG8rLy96SkhiQ0pPdFh0N3E0RytlWGNZOHh0VHE3SXR6bjRrMWxYdTI2MC9RcERuM3JjQkJXSUIraGM2dlNGazd4dTlUcGhHVllpZXJOaWpBMHMzNFhkbktnbnJaV1RycVRZaGJ6M3crQlpGL3BUUGU0Ylk4RkFJS0orVFhBdEFBNXVERk9OR2JFK1FzWVpoc2lka3V2ZXh5KzVEWk1xbEN1SkN4RnRqaVBCRG0xL2orWk8yVmw5cmp3MFd6a2FXeFVWcy9BWXprZWhYQ2lqU1NBYmtKd3cvdmxzTHZ0K3QvNFNxVndhSGJiakpYWVFvNWp6aS9SMXdHM1JVN2ZaRkpGc1lNZ0tzSSsva1cyaVZIZWI3Z0JvaWlIUDF3VjlBUmJqa1JrTGh0TjZSMDlqK0NHNk1CK3hRendYRmVjaTBrZ3dZNkREdDh1dUMrRGxFUTFKVGtXNkFWdXBBWUNQellraEFDNk82bGgvWTNkIiwibWFjIjoiZWYyNTdhMWQ4ODkxNTFiY2ViYmU1NmFmYTc5ZTgwMGE4M2U0MGY3ZDk1NDIwMTFkNWJiNzg1N2MyYTVlZTM2YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, BE, DK, FI, FR, DE, GR, HU, IE, IL, IT, NL, NZ, NO, PL, PT, SA, SG, ZA, ES, SE, CH, TW, AE', '[]', 'all', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(128, 'auBFk1717471788', 'GrabPoints - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IlZHZmg2TWVNSU5HWDZLc2IzZ0kzb3c9PSIsInZhbHVlIjoic2JPM2JQOGtLSnlLSWN0UFpSdDNOZHVzNkNYdDNGV1c3WDJJTHhDbW5VbWlTMWNXVzhKVFFQRDE4ZGNjekVWSkpFSVZTbEFPSUVhanhtb3dvVGExdlE2aEtFY0NqanB1TkltRnFLbU5Sd09hUjFySFIrb1d0b0VMUGlJcVh1ZWNKem1WWE5LS0R5djB1emwyMzVZbzRaNVVOeXRvMXFNQzJQenFnWUt6RlFOWVhmZ0ZRMGNaMm1JM2E5ckJhL09QTVVNcllWRFM5eG1GVXQrNWE1S29qZlhKWi9jSEFSYkJhOElmMEtsbGl4T0YyMWhPeFJBcmRaRmE1eC9Xd0l1NGd5WFhablpsSTNidC9nRFNXRm5pRmxqam94ZlRPV2Iwc1pKN1ZsZjUrNnozaU9sZkNBemYwVXMxM1UxWHJiUnJ1UXdiNnVyVHFkL250UXppTFE5dFhXZUtEV09nalBhdVIwMktoei9yR0Y2M1kxWmh1MTZVa2RlYkRHa3VJb3pmIiwibWFjIjoiMTk1ZWRhOTg0MWUxNjk1YTkwYTE3MzBhY2RlNDkzNzc4MDVhOTA5NTU0MzY2NTUxNDlkYzI3OTY5YWY5Yjg5NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, GB, US', '[]', 'desktop', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(129, 'TloYT1717470834', 'ZoomBucks - Complete Offers & Get Paid', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IlVQSklRWjAyTFRMZytNdEVuVDRiQ3c9PSIsInZhbHVlIjoiRWdYWXVkNlBVM2hMRXM5Q1VSM0FCeFgrTDdjaDhGKzFCdWhzbUVVMERrelJFOXU0bThoOXoxQ2RuQ3RSV05ULzVqSjR1VmRwSFcvbXhtMjdlWEUwNzBwaU13STJITTMrV0dYd01KcDNEMnN6VmJPM015QmNmcGN1MndPUWhKK3pNVmlaZU9Pb2pJOW5Jcks3ZXlOcjBIYkV2TDljTUVFa3pGQnhWbWRwdUp1MlQ5UHZFSTdaaW9aNTVoMW13alZWTmtReDFvVm9XSlR0MXNhcE4zTkVkaFYrZVZHRWwvdmhEeXAzWDl6NXRpSzlid2U5VnJEWkxsaktWYm1MZitBdEpQT1NYOHBmOWMzWXVwVkhmbVEwaU9IWUpSZFJUdmZsWHZCUVd5aUpOdHo2K05OMmRTTEs3UlZ1aHpLTUd5Q3FQdFhGYk1Ca1I4TzBnUk1qTkcwMHE0R3BpS0IvUEtuQlFEN2U1OEpPUzBPUW11V1ZFbXlRWGNUMklBTkc1OEFNIiwibWFjIjoiMjgxNjJjOTA5NzRkZDAyODY3MmU4M2Q4N2NiYjRjZjNmYjI1ZDg2YjdiMDkwOWRmNzVkZWU2NzU5MjI1ODkzOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, GB, US', '[]', 'all', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(130, '2608112-IWokOlxS3u7vTjau', 'Idle Food Bar: Olivia & Oliver', '', NULL, 1.68, 'https://notik.me/api-redirect?token=eyJpdiI6Ikd3dzc4T3pPdWl6YlNVankwMkpKUmc9PSIsInZhbHVlIjoiVktndGVpcWFuWDAvTFhXTmczNmVPN2dVTmp2Y0IzZ1FPRW1sa0I3bzNyYnRMWGx0UUVoVUM2czFBajQ5Z3o3aXdzaGltb2lpUWJzbHdiMTMvbFdsMWlTSXY5alRFQk1WRnJLVHhMMzUvQS9sendJb1RGM3lHOEF5cXlNVndoc201elBndSt3ZHZUdmxNUkhwcUVsVDNQdmcyd1dmSWF2REdSaGJ6SU51bzJKZWl1TWpPQ3R2L3lsVmNXZ2VJVm1Dc0hBc04wYWo4c3ZBUEVKT2ZoTFRRUkc3c01wd1prR3h5S085TmxHSjM3VWNQcjk1Y1lpUGFQc3hhWm9McCtMNHdHQXZ3Uzd0OGdOandmWWt0Nnpva2JtS0wyNlNhaFlKNVhiR2VaVUd1a0I2dk1IT01hRUpGOGNyMkx3L04yaXhzNTlFN2ViVDBNSGpjWmFuTWJpTnhnPT0iLCJtYWMiOiJlMTY1M2FlMjg5OTVhNGU2MDUzMzkyNjhlMDNiNjUxMDA2ZjBiNTRhNGExMWE0OGVlYWVmMjYwYjE5NzI4Y2M1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[{\"id\":74387,\"name\":\"1_map5_level7_end_act\",\"payout\":1.6},{\"id\":74389,\"name\":\"Purchase\",\"payout\":0.08}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(131, '2608114-IWokOlxS3u7vTjau', 'Idle Food Bar: Olivia & Oliver', '', NULL, 1.60, 'https://notik.me/api-redirect?token=eyJpdiI6IlU5VlQxUFE1c1hRaDV2ckZ0NlNCUHc9PSIsInZhbHVlIjoiWUEwSzdNRVFDMTNZWFZvdDd3bnkzbGo1Sk1wU2dIMFhvY2lCZ0taMElsTmMxVFRyM2MvTWc4YkFpSXRrRmE3UzlvRWpRb2ttdEhaRlZXSHY0LzRwVmlpRGxnNlZYZXVHL2pWcm1JZzY2OHF4OHh2bEhVVE8vQmhYeXhmV0JHdWQ1aEtGaTc3azJucTNheWxhdG0wY3RsNFpkQ3VRdGRDeEhFb2pRdTA5ZXV1VytVSTdZeTFyNldjbjF6Uk1GMnNxYjZpV0RpMUlpYkFWeVZySEN1QkY4ZlRBaW5xT2I2SmpIUkQ0dUtZcldVNEYzc1FoeFR4ZUpabFJ4YWZCcEM0Tit5WGhBdmFpZGtxRjEyazl0MTZENXJ3YUtETlNtMXFtVjVmYnlSSC9MektwSERteStFZXFKMEw3S3RUOWtKWlY0bGE2R2luWWZ4N3gvSFhiZ2ZKMVR3PT0iLCJtYWMiOiJkMzIxYWUxYjYwMWE4MDg5NGY3ZjBjOWRmZmE0MjFmMDlhMDM1MTgyNjZmZDJiMDljMTIxMTQ4OTQwZTgwZGU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, TW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(132, '2608251-IWokOlxS3u7vTjau', 'Idle Food Bar: Idle Games', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjBXTmtnRzRPZVNYU2E4cmNuS1dGY2c9PSIsInZhbHVlIjoiZHF3S1RVTm1JS0VNS2RDOTdjckMrTGZwcS9INUpiRnFHc1puZnp3bm1qb1lScmtNYmZHSC9pZ3FtaEZHb21QN1doaVNNWEI5TUZTQXQ4aWEzTWVEKzcxbk9xKzVrZk1WMndBVzVCanlBL3BHV1RXL3JneFU5azRLZ2JONXdaMFVxVmNkL1JuK2hMdW9ZZWdzNDZzOVYybi9iWEJhWGk0Y2pSRi9IR2YzblBhSVRoS1orcVhaVmpMSXRwZVpKelZaYXJIODBRRUVFQ2Nic0I5cTdnK3Y1RkpHU0VSTlhTcTJ5YjUwUXZtK0pKOFBrekRjVjc2a2p1RmlFbWN4Z0NCTmFkMXVpcEZUbEdndXVBckdVRUJ3eVZlNjR0TkUrRXV6b0xsRjYzQ2J5bTRickJXaXlWeTNZcUhsUHhaczdUY2RTeE5rUlRySk5waGdFc2k3R0NsdmlBPT0iLCJtYWMiOiJkMjM5ZTExZDRmY2NiMzQ5YjY0Zjg2OWE0ZjE0MTg0Mjc2MjQ2MTM2ODcxOTZmMTM3ZGI3N2YwMTQ4NDU3Yjk3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, TW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(133, '109704-C9lRP9r0SR6haQk1', 'Amazon Prime Video', '', NULL, 0.36, 'https://notik.me/api-redirect?token=eyJpdiI6IkRlUE95NU5RQWFjdkhmNGlGL0krV1E9PSIsInZhbHVlIjoiTmdqb1JMUEtmV1YxN2RKVlFRZW5sN0E3UWdaV20xSTVidTBpdmsvMlVDWmJoVkJMZ1VkRGlUMW9jU3BPY3JQd016bHE5Ukl2NHd6V1J5cWE3MStWYjY3Wkw2T2FZY3VPSGFjSW5COXVFR25jSkxNYkFyRDd5T01KQVJBQ0lnYjl1UDdONE0xVDFKQ2RxdDVlZS9JdHZqSytTSUZXblJicXZaS3BydFptbDJ5ZEtLQ1pLVmppNkpaQUVOSXNhbFB2N01JVVZrR2UzdlRMSGpMeHhwKzFORy9iUjZ6eXFpR0FTWXloaHhXb0RRTmV4YURkZ0JtekRxaC9VcXEwUS9VWTRKUGk4alhpaHJUbzJWVnl1RXBHSmt2OHk2NWNuNEFvSGNkMWZXMDFGbk90QnQySG0yZE9KOVhZd0V4emFMM3MiLCJtYWMiOiJlOTEzYjg3Mjg2ZDMzZDk2Nzk1ZTg4OGY0OWQ4Y2M0MjEzN2I2MDI3MTc4Nzc1OTk3MDg4ZGEyNmM2YmI4M2FjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, AU, CL, MX, NZ', '[]', 'all', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(134, '2607994-IWokOlxS3u7vTjau', 'Idle Food Bar: Idle Games', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6Iml3T0NLZnFpaXRzMkpuNVQxUkxPUkE9PSIsInZhbHVlIjoicHJrMWNPd25vQWRkMFJoNS9udHI1SGlQRlV3bFVsaHdGVzZOUXBramR5bS9zNjdwVlh0YUdZY0FCclZHNDhTUWJOalhtbXBuVThNMHcvSVlXcGRQL2lOOW52MUVUY25QRmJrai81anVjbG81R1dmd24wZHgxcTlIOFEreU41ejgrMVFUREtCb2RQWkxHL1ErNVZFMUZXOW5VNHR5TEI0YVVoVlNqOTBDbU84NFFxajRMS3NXWjBBbzBzbzE4V1cxWDFKZzBFMTBLTzlRcER2SXAzYjRrYnJoa3hjQ1U2QzZBRnpEVTV3Smw0N3VyaVJlSUppSzd3dTBVTXF1cm10N0tMRXhrNDJGREZSWGxPQklBc1dsTHlZQWY4ZW5xOFRQN25GcDJsb3RVWWtBdkloQ2pyN0dvZXdlTE9BMEFjaTZCMFVMNm8zQTJtWTBSUGltUVg0WllnPT0iLCJtYWMiOiI4YjViNzgzMzM3OGU3YzY2YmU3Nzk2MGIwMmM4YzU1MGNjNDE2MWNlMjQzMjc1ZjllOGY0OTRkZTU0MGIwZmMyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[{\"id\":75062,\"name\":\"1_level7_end_act\",\"payout\":0},{\"id\":73315,\"name\":\"1_MAP5_LEVEL7_END_ACT\",\"payout\":0.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:46', '2025-02-26 13:11:02'),
(135, '120213-C9lRP9r0SR6haQk1', 'Craftsy Classes - desktop/mobile - US', '', NULL, 1.13, 'https://notik.me/api-redirect?token=eyJpdiI6ImQ3cHpQOVltVGV4SHBITGFVdHE0L0E9PSIsInZhbHVlIjoiOWZtN0V0TmVZSjZEdUdMTUJ2cllORWNyV1VvTW1meGpQREMxaEJRdVZ1VU42UE9GbDMvY0lJUFBoQmFremg0YU1ZOFdCMFBKTG5qNzdsUnYyQ25mVDhRVEtwQzdUZFZocklENCtWakk0RUpLTC9UdVdFWE9yV25aVFJVcytuSVdjNWdoZjNTY2h0Rng5T2E2YUNxMXdST0lXZWFjSXJWNmh1WERZQzE4K1NKMnNHQWUyNGlEUUdPNTViNmxPWURYQXR0TTNlY0lCUkVvVkxZN0hUcE1vKzJJbEJkVkZMMmRSV1JVakh0MERBaGRDUzNWK05zWlV2eHpZR0VQU0VFRjh4bWFGL2c2ZUN5d1ZJWnU3cVBUNVIvN2wxSjVVR2lJQWo0SWFPRElxWUhDV3pvOTJQa2JDN1pDM0craWN5VGt0NDZFcVdJVWk3UEp4UFZIMDhpVXVnPT0iLCJtYWMiOiI0MWMzMjEzYTU4OWE2NmM1OTVkZjA3MWE4OTQzMTljZjkyMzQ0NDU0M2FhYjVkNDJlZGNlNzQ3ZmI4OTljNGZmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(136, '631500_0-WU4O19ugcV0tSQcU', 'Betinia Casino SE', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6InR1aFlsRGpPWnJWdlpqaGdhbTNpV0E9PSIsInZhbHVlIjoiaUVQSDAxbmFyalg1VG9VVTQ5MUNKK0tsQUpGOUtINUVXK1BEb1VRVWQ5V3JEejZ0QUd3Zy9XWXVsbmMwbzBkZTZ3bm83OWh5TGZ6elFYTkNpOVhaWHhNMUprekt2UmFFYzVTS0YydDNDUnFDM2c2ZVhyQ2F4SDdzUVdUYjBYOHUvM2NmRTRHWStFbDI2WmhlUVZCOGlPbDA4Mkt2RDRaUk1FVk5hMXdjK2RSWWp3TlhyRXpWYnRtVVFVbWM5c0FFNG5taGtzRUFtVzlMS0xRbG5MUEY4VHo5TmQyakxSREdIZkdLZjlMdk10eWFUbyt3dExrWnZ3aVdjMTRyUmJlUmpXVHVzUXpKSnV4RUJxT2RjZnZyUGtxSUZDMGRnT3htRC9BR0JPWHBVSSt5RzNCRVJzNXh5a0t0YkttZnVPNlV3VjdOaUFWVzZBSzQwSWl4QkF1QjExUXg5Y1R6M3J3Nlh3STU5R2tUeWFSTE9tMUxkdUx5K2V3WU00LzNOdmp0NlBVYlFlTmhVWVdUREttZnBoYVNneWpVZTJ1Mitpb3Bja1JYTzBSZ3h2dEFyMWJCbzBMQVlHVk9DRnlIRUFiSnVpZldGQkRRRTd6NlJRNVp3aFdWdzZkb3NNUUU1aElKR3JhaHpZSEIzbnUwdGV2TGUzdUVnWWdmSFAxRHQyUDAiLCJtYWMiOiI5YmUyMmI1OGZmNmU0NGQ0OGJjNjE1NDI1M2U2YTNlZGJmYjA5M2JkODI2ODUxMzZlOWQ4Nzc2MzE1ODRjMTFkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(137, '7004-1FrkhNskoLgFZvYy', 'Test Achats 2023', '', NULL, 9.01, 'https://notik.me/api-redirect?token=eyJpdiI6InhmaVptTFF2S1NUOTNETStQbHdkbXc9PSIsInZhbHVlIjoibDBRVDFOU2pvQ2c2WXNpMFNUTTEySVpYWjFUdVhQUW1EQkRIVm04M3VXajRZWDRvVmN1NHJEeEhKUkFvWFZHMGxvbVlqZUtjMURkdW5taVFQVmpmNHcyT1hGc0syVmNLQU9LcmtoVmd5UnNjdEJvTkFzZHNKV1F2UnQ1eGJob0lIT2lmUFkyQ0Z4bGh5SWFaeHgyOG9aQVo2NTJCNzkzQ1BJUjBDbVJnOUs1ZytjTW95VEdkRGN4SEQ1QVZHb2MvUVVyVEFDaUZlZ1pBT0hBWmo5V0ZMd1Ywbm1CQzh6ZzB3R2hiZWFDb2xjQ1NJTzU3N1lrWkpmL1NIbjZmNGtZUmRYZWFNKzBDSkhSUjZ4OXpuVHFVYVdNTmdVRTlsYWZvU3IwSWhiSU5QR21OOGJKeS9ZQ0o1TzJGUGxaRVh4K2lpc2VpN1Z0dk8ycmxtY0pqRDZZNW0wczlxbW9LcFpCRlY0WWNZelRtd1EwTng2M0YyeVdNcWhuZ3FCV25GNW9FdFhGdzlscVFkR0dSWmQ3YkI2alY0M3VRdG5FaS9DekVxMTJWRFZRanFkMS9iNVdlQnNGOGM4d0RQL3h5Nk8rYUNma3VwSHNqQW9oTUI0eFl0bXNOTy84ckk1WXdLek5rSHRnK3QxYjdoKzkwdHY4d20xVHVxRUdmU0YxZmp1M3QiLCJtYWMiOiIyZDFkYmQyODhkNjM4Y2QwM2NmZTRlNDFkOThiNzdiMWY3OTQ5YjQ1MTY4N2M4YWYxMGQ2MmQwMmY5ZmY0NDBkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(138, '7215-1FrkhNskoLgFZvYy', 'Test Achats 2023', '', NULL, 9.01, 'https://notik.me/api-redirect?token=eyJpdiI6IjVnQmVMVmxtWkxyUEMvb0ZVcWZ1RWc9PSIsInZhbHVlIjoibmdmNnh0RXRjalFzdHJHRituUUUwaG85Vk1TVU1PSytGV285YXpOWUZocjNJUEhRZ1NTNmt6eGdCdi92NG5DRVhTWnNhdWZITTA2U29PVnNIUUdlSjhoNy80cnZvNzQ1bTBxYWNaYU1MK2xBdlZkVnJ5b2tYeHNIL05yUE56QlczVTJUcGExSnZtaVlhNmZ0N0RrZGVHT3pYSjdEaGdyR1MzdTNGQ0ExOTVITzdkZzFSbWlXUE1aNTg0WmljTlovWkxhZU92Q3piT0picW5JY1ZhOTJ0SzdyN1VQTTZyc1hrWFo5cGFVMTY5eHhjRU9wWGVrUldTSjRJMnJ4Z0huZTRyV2Q2U09uODgraUVsRFc5MHBtMnE4aVUxVk1wNFNQb0cwbVVubTBiU1IvVUFNR3V0UVhsRkZxQVEvR3Qwc1FvL01NUm12SG9IKzdCZktEVDhFdXBzMlZTRyt0ZXVFbTd4a3NlU3o3cUUxbVZOUWduaGs3OVNGL21XUVNaMUt6WHF0YjhMOXEyUUZuaHN0SVlhdEtGOE5ORm8rd3VSUFBaeGxZUzRQWVJONG5PdE5UVk0yVzJtU2ZhU240WndpWHhYeExMcnMyalA4MTlwK0dHaWg4QkQ2ZWxtMGxmNUdiNjJ4WmN1R21sbE5kUytCVFRhM09mZWwvSWN5RGQ4RXgiLCJtYWMiOiIxOTUzNTBjZTkyYWI1OTQwODE1NzcwYzNmOGI3OWUzZmIyNGQ3MTM5ZDQ4ZTRhOGNmMzcxNzc5ZTVlZjY5ZmI1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(139, '9585-1FrkhNskoLgFZvYy', 'Max [CPA]', '', NULL, 1.33, 'https://notik.me/api-redirect?token=eyJpdiI6IlRIZDZvZU93T0pqanE4aCtkY0lDMXc9PSIsInZhbHVlIjoiUXBLQ0NJYVpoS20yVDdEbHFlczVYYzVtMjdMTjlEQS9Fc0krazVGWkNHeGFidldYS2pkcDFVbStacUVIMHA4ZTlTLzBSdWljN053Zll5S1M1UGZwVVZJLzlxajVGRmNDcitsaTFCRXpGSnBlWDlQV2F5K1VuazBVQzRYcWhCWi9FK1lVeE1Cbk5wQUgwR0NoSVdNUU83NjNMTkhwWEUzQUdDaXJRdElxRkZ2Y1RLUnM1TEVRbFc0ZXJlRkNWUnpFSkZIbmZXWWpFQVQwdzZKVUdoWkFqMkQ0bXc2cFhDVitPMlVlZDFGVUtuak9jMmZ0b3dvZTJCbHVGWDhEZjBnYnZuZS9NVTNDSDJYR0ptbm5LdXVTbXd1dC9FbGxUalF5eHlGNWxRVFVsT2t0bjlXY2NYV0E5d1M0UzhaZ3Nocm1VcjgyUklyZXg4b20zckdObVBTUCtjcnlKS2dEa24veFkxcmRYcHFSQzJrZ3hITWUyTnNkNHVVcmswUjJrS3BVY3JrTjNiR0p0bzlFTXZQMVB5QWJCblZKbHRkTmVvUW5pa2pDUi9LSmczV0t2YUNGbkI1Zk5ydWQ1cGs0MmJQYTJRRnFkczBrUDI4aHJvK0duSytqRVFSbDhmVkpCeWpORllhOXBKZVVEZVE9IiwibWFjIjoiNGQ4OGY3OWJhNmM5NWRhY2YwYmMyODg1MTM5NzRiZGQzY2VmZTNhN2ZkNTcyYzRiNGRkMGVhNGE4ZmM3NWM4ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(140, '9830-1FrkhNskoLgFZvYy', 'Max [CPA]', '', NULL, 1.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlFuOWRGTzViV01ZQXBqcXZYQkdTVVE9PSIsInZhbHVlIjoibGNBdS91MzRXdTY1bVMxZS9KSGZwelhSMHJnMkVuWTlBN3lwY2ZyUnBXUUFISXdxdFB1Rmg3dG45WmU1UitGeVFXRXhpckVQL0Y2amlUYkpwWU5vOEtTeSs3MFBnTGJqWWk0V2ZmbEZza0d2bjZ3M1hnRHRWRHlMYnBFY1dlTUtWUDBvK0pWUDZnOEpWbk9KS0F3d0ZuOGZPdzZjdldzR1N5SW1pdE95ODV6bXFQTmtQZ3hrQTQvUWlGNWthUEtROVJVWHlRZGt4NGRnUjVodWZvRkF1ajVnM0ZBTU9FcmhRbFhjZmM3VDU5OGo2U0R2OXFNMWdRRDA5Zm9IZm1KOU51L0ozdGFXTFMvREZEQ2V0dkNld0hDN3ZpME8vblgrWmM1Ymp4aW5FVHZCa2lKRmRKUzZQTGVSZjhQUFdQc0hqanNPWmJZTFc5WnVKazhsZ0pHMVhjRmtlNE5ZT2RGc3IxZ3JCdG44aXhJclkvejBqTU16c1YxaU1kOUdhcnVacEN0anJNUjVOVlY1bFhkczZkQjlyaHUxV1R0N3h1NmdGdmpDak85dnZGTmZtRDJyeHVtakYwc085Z3BTTEJWWlcwa0Z1YjJVZnJrK0xCeE0xN2RBS0RWamI0cGlZL05INGdSTGtUYUwwUWc9IiwibWFjIjoiMmFjZmJkYzgxMDRmOTI5M2RmOGNmOTUxYThiZTZlYWI3MTM3NjllY2VhM2M5OTViZjA1ZDQ1YWMzNzQ1MDVhMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(141, '9584-1FrkhNskoLgFZvYy', 'Max [CPA]', '', NULL, 1.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjlmdVcxa2M2T2V3NTROUmtjclplSEE9PSIsInZhbHVlIjoieEUwREV0SEtmVUZ1TllRVGZCdTdPZkdTaDBBZUJZYzZYQm8vWGlQdjFOWXhtdGFkbE9jTjNDNWNPT0dPVUZFWGFwUnBiQ09sR0hVRXZKVk5KdHEwS3BKWnNnTmlQL3N2TFBXejRJZ01tNzVHRHo3MTZQcW82RnVBZVFoa0gvamxLSjJYdTNiUDBZcWdvc0EzTGdQYldqekNnNGF0NzZOa2xiSFBNeVlmaVQ0U1c4YjhvdmlOV0VlWDA1dWVmQ3Zla0ZYOHRSMnVWRDhqM05jT0psTFZBYW9GTTBzOVdyN25KYjBpZkcvdmRLbEhORW1heDV2VmtxeCt5UjRUWjR6ajF6RGNDYTVPd2ZmdjZPQnU1dlg4SjJxWXJjWWR5dXI0TkkvYytmZXlrVUczTFhYNXdZRTZBTFRzV2dxZWN4Zyt2UlprNiszR2VWa21Wa1NwOEVFTXltaGEwdXI5VmZmR084blQ5VFJFQWl5VWhNNGlVcnQ5OThCM0RqNUJBa0dJZERTT1VRaVBSRzFrMGg0a1d4bmh5VmJLTHRuRDIwQWVSeEMxSzBqZU45R3g2R00ybFloYmVMems2azEwTkxFZWlqQjhEU2hYVjY1UXdPWGl6Nk4yTlRGU0dIR3M5L0NoMXpPUXB3RnJPa1U9IiwibWFjIjoiMmRiNGNmY2E3ZmFlNDdkMGExYWY1MDQ4ZTMyYWU3Y2Q2NGRiZTk3MzRjOWUwYTk0M2IyZmQ4MmZhNGI3Mzg1ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(142, '9205-1FrkhNskoLgFZvYy', 'Max [CPA]', '', NULL, 1.06, 'https://notik.me/api-redirect?token=eyJpdiI6IldseUZ2eGoyTXNNTVgrbFJUSTBtWFE9PSIsInZhbHVlIjoibElEOXFVNjJ0MkRhQnY1ekVsRTgzelpNc0w2UmgyNW9pK3VJNFArKytva2pNbjc5S0s1ME5FZVNtcHo5MEt2QzUxV0o5VEJBYkJ2VWhFNUpibXZRL2l5MkgvK2I2aGE0T1czR3RpbW8raGMydG9wOHJacnFOT1lHL0RZd2d4dVRCVUEwZDIwSGJYVkxETGwxSzZJR213VUZrWUdlTVpNd05WOHpocG1IUHlyM2xaYWRxRHB6WFBaUGpyZnJJbG5qQTF1VmwxWDF6QS9vWm8yMmd0em1VNUs1RjQzSmQ4a05FS1lTcG5oVE5vczZXdUhqK2l3dVBkNk5Db29sZDB0ZCsyQ1YvbGtKdjBDTEtXMTJ5VHE4VGQvYzNjYzVrM2t3TlVOVEFVVFNnaFFhc0NNZHRROWJxcHkzNXdqS1RjNjNqNDN1Q1h6THB5WmtHSUoxRVY1TjJqRmxmNGUyRVFPSlNOcVA2Q1R2cERDem5OVTYxamxtREZmUXdhVDk3OTk3SVdPbWJERmlxUVQxblVSVndoYVJhQjQ2ZDNBTjd0WERlQy9yMWZGb05NbEQ2ZE9SQkdhUERycTUxSDJjSEpsUzZXNFpWaTE2SjE3RThlUmw4RHA0TXgxcFpDSFRIRDZVTms4MnhnSE5ucUU9IiwibWFjIjoiNWQyMWMyZDE1YjVhMzc1Y2M5NGM3ZjQ2ZGQxMzc1ZWQ3M2NlMDFhYmE5YzJjMjY4NTUxNDE2NWJlMjZiZDBhMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(143, '9652-1FrkhNskoLgFZvYy', 'DECO PROTeste 2025 (Multigift) [CPA]', '', NULL, 8.48, 'https://notik.me/api-redirect?token=eyJpdiI6Ikd1cmdBWGtINXF2OHZzVzdCU2RrQkE9PSIsInZhbHVlIjoiWWxFMHk1TEFVTE41MVY0Q0RoRUQra3hlUnk3dnBrVkpubnk3T2ExbTY2aitPNDQ3UXZhbUpWL1dXOEZCVDhCNlpnSmdGem5GRUFpaEdLV0p4VzZWK1ZLTGdmRkJJaXN1WGhBN3FMdC9wTFpZaTRqQXBNSkJIT0ZGOTV3VkF3WDdpa1MzRVVYS3I2V05CUzFqOW1JUlp1ZldCSmZTSGZhWjREczIvenFNSjBBZEgxbmttL0V3MmVlWnVCWHN2SE9tZmF2bVZ0MlVBRFhhUVd6cUtPTklqL0ozc2RQd01scm1kVFFqRXFuYmc5WWx0QmNSc2pGYkVMdEFwZEltbmhMM3V3TVJhb2ZFMDQ0SWZTcXNIMGEvUVNrUzhPVThrRDlmQnlCQXpESXZ0Q21jVzY1bk5PL2NRZngyRDdIV2cyTXF1K0V2Tm9ENm1aTVpVekhwVDQ5Mm5DNmdWYjY2V1VsMUYwWDRIcFZTTUhib1Q2WmxpN2dDQVdkcFRjVmhqYWdyc3NwUGJjc05KQk5NdC83OHRlM0ZkZ0hKZk1sNnVjelVwK05GbEZvQ3dtWXBFTHJmeVhPZll5UFJaUWFiUkJSQnd0U0RwS2pGdTBmWUE4V0ZId2xSNDczU3lxak4rRXQ5OWdvdDhKOUV2MnVrVHJFUWprVlFnaUdVZU1lQ2Y2SWtJTmNlOXJ6bHR2WVRGUXJIK3hGMCt3PT0iLCJtYWMiOiJhNGU2ZmJkNjg3OTJhZmM4MmY5MmY1MGY5MzllZGU4NDcxNzA1Y2E4MGVhNjEzZTQxZDY3YzVhZmZkODcxMDkyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(144, '9586-1FrkhNskoLgFZvYy', 'Max [CPA]', '', NULL, 1.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImdxcS83TW12WmtQODJ1b0ZsaFZ0RFE9PSIsInZhbHVlIjoiWmF0bUwyS3pOMm1YY1I4VUxpbEh4RE9HSDRDcnp5NXcxcVZ3bWVpa28xOHYzQnZaQWM0K2hiMVZHdFlURjdMSEovSENjMEJuQVdmdVlCR3RVRFdyWkMwZlE4RExqY1krZ2VFeWRVdnZVTGYvUm5KZnRMckNOZWJPbGxFL0VYSDBmVlpNY0VmdUhFdHM1M0x6ZzVnMlYwdHFVSFBFZW9DYnlaOGd0RWszMndSRENiTUgrRzd2cm9BNE9LMm1Ddk4zQWozQVB2ZVQvYnNqdDdoUXFTc3I2MW5Nc0VTZlJIZlhDL1YrNnhzY25uejdubVFad2pIZjlPZEM0R3RaUWw0K2JYZjRwQWdTM245cTAwcWxuY0VJdjFacjh6NWdrZ3pNdk9rT1lUbnNrWDBub3IvK3ExZ0UvWWdqcmFRRkVwMGZlMCtVZGtrcjI1RTh2ZUp5enlFZ0F5OExMbWxmeVd4THBmRFdrQkxpcHlTODhTL2ZYWFlIM0hzMWdNQXZHVHgwZmtiQ3Z5ZEJrdEI2RnJYbTNjRFNrbTZsU2VET0h1bFBhclZjVUJ2a2VwYTNTeFZIaW9OV0R3cUpGU1ZzUHlLd09PdEtMcWlybk5kazVMZENNZVBMMDRCTVdlSEpmODhZakFwbEt3N2hZTDQ9IiwibWFjIjoiMDI4MTljNjhkYzNlZjQzY2M2MjZhMDJlZTE4MTY4YzZlYzQ5MjIyMWNiMTkxNjM5ZDE3Zjk5MWE0MWI4NTc0MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(145, '75550-GUnmyA5cWJy79Kcm', 'Play Regal', '', NULL, 16.80, 'https://notik.me/api-redirect?token=eyJpdiI6Im5RcS84c3NiK2dYN1RncjFFYVFkVkE9PSIsInZhbHVlIjoickJ2UW5iU25RVzN5Y1Z0N3dHSzNZVXlvU1FYTU9mNXMwdnZoaTcxeVVJUXUyRVNMWUdudHlzTkpSZ2VtL0JxTy9yenh4dHlUSjBtdURCSFhEd1NVdDFDMzB5TkZzTHg0NHAySWR1N0MwY1RKbWhEWnlLSWM2aVlPUzcwMTZQNDFxR2dRcjBJSFZhOGRLZHFiL251NmZBMWFYMzFobnBBbnE3RnBEL29oWVQ0aG8zTmROQnZ5eUhtcUVmT01PdHM4V1F4QnFOMktXUEZBYUR6Ry81OTk3Y0N0VnlRcnBzdTZEOGVXTzNsU0ovellTdlcxeEVVMDNFeUlJTWJLZXpEdHhJVVptemtPdEY4cFhTTTlZKzdlcWQ2UFlrZ0Q4SzQvSDdTQTJNTEI3ZHM9IiwibWFjIjoiZjFkYzU5YmI0YzU1OGU2Y2JmMzNlMzVjMmVmMDZlNzY1Nzk4YTFmYmQyMGUwYWNhMjhlZmQ1M2Y2ZTI3ZGQwMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT, CH, NO, FI, CA, BE, NZ, ZA, LU, GR, IE, GB, NL, SE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(146, '75553-GUnmyA5cWJy79Kcm', 'Unique Casino', '', NULL, 16.80, 'https://notik.me/api-redirect?token=eyJpdiI6IklKYi9SYVg2VW9EUGoyS1JScCtLNlE9PSIsInZhbHVlIjoiMy90TklKTFBSQnBvbXQ1TEcwN05Ka3NYWmlvUDlKbEQwc3p5UlB1R1lFYkdXanNSeERTbGVNKzRKMzQ1WEZFbENpQ1ZkTlgxanYvNXJ1Szd2dTJCdCt1eCtlQkErTUxOOEFuaWJWWmJtdXVTTzVzdFJ0Tnd4eTdzYXZFUkxmTy9aRWFNQXFSWGhPQm03QjgzekdnS3ZmNlMzYWc5eS8vN3c5bWN0LzY0ZGVleHk1WHh6R2ZTNWR3NFdzamtoZE14T0xkYnVqa0FqakR3QmI1alVEMjF3SmVyRHRZUFNyMGM4VE9RUHpHTVk5enZqQVdGQ1IveVdMenlZZHJzcW5zZ0RSUzdtMnQyWnJIUUVobWk1eldacVVUWThvWU9RSHRlckRqZ29CY2pEQlE9IiwibWFjIjoiMDcyNDRhZmMzODcwM2ZjYWQ3YTIyMzhkZGUwMjRlYjI3MTM3NTk4MDMwNmM4MjU4ZWEyMWNmODNjZmI4MTdiOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT, CH, NO, FI, CA, NZ, ZA, LU, GR, IE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(147, '75551-GUnmyA5cWJy79Kcm', 'MaChance', '', NULL, 16.80, 'https://notik.me/api-redirect?token=eyJpdiI6Im53QkVTOGgySHhibmNUb3ljY1pPR2c9PSIsInZhbHVlIjoiQW1TY3p5djlhUXk2ZzcrVngydzN3eTdxekkxM21salNRb0J3SnJIMFQ0Nm1kZlcwOFh4SEJMaGpURnY2MElCVDNST1pqQzBTSm9IUytPK2RFVUNGdUZIZVNuQjM5TzZYZlRYblEzNTNqUnhnZUZSbUtubHpkQ1R4YmxsNExVZTJqUzNMMStSdE8xcnl5VEVkZk5WVUUzNGhOTFljVmVKOUhvQ0REWi92Q1QwZElMY2VaZGZsS2FZVUV5a1lUeUNWRXJWaHlIMEExRzU4SW16NGMwQ2F0aDJYOThOVGc2d2Z3NmtkbjBKZGM1MzV1dzd0aWhRSm5FcWZwZFJzWStIZks0clNwYkkvNTRlbDRyR0QyOUVHdU5YWDJJalRDSjhtenVNakF0Q2hFdWc9IiwibWFjIjoiNDc1ZDY0ZDUxOTMwOTkxOTE1YjNmZDA5MTkwOWI5MmNmZWM1ZmQwZWZlZTRkNDdiYzU5MDE5OWJjODc1OWM5ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT, CH, NO, FI, CA, NZ, ZA, LU, GR, IE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(148, '75546-GUnmyA5cWJy79Kcm', 'Play Regal', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6IjIybjJBRWJ5b1A2UGZTL2dxd0xiQkE9PSIsInZhbHVlIjoiZ3hlcllBVUhWNXZ0Rno4Y0d1T3BxTGc3MmlIM3B5Q3ZNQ2tWenliVW80WWxqQkgzN0pZL3BrZlIrelNYekZBUytGNDNyVG5SR1R6a0ZFTERxM243cHcyRlA5WHRTR1FTNTFBYzdrS2d0dDhIbXVhNnJHUGJkSWJBU3FDR2ltMVJHQ2RrN3BSelprang3S1BFWFJLK0NzblhjOG4rYjE2Y1lrckNzOUhOakdTcGdnYkZoQmQ2NGZvMXNUTjJwZXRrZ25mcjhhbFMwenRiZnVXTDlrN3p4cjRDOHZvd25BNlpLcjIzM1p6SkhuK2ttVFBkZGprNVgzc1h1NStaTE5uK1pwbWFiTGlkZTcrQVo5V2dSZThOMGFLcUNadFJZVDJtVGc1Z1JyWVE4NWc9IiwibWFjIjoiNjQwM2U0NmRlYWFlNjMyY2RjNjM1ZTZkYjE4OWI0NDY5NDk1ZDNkY2JiYTUwOWM1YjVjMTgzNjJmN2FmOGJjMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT, RO, PL, CZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(149, '75549-GUnmyA5cWJy79Kcm', 'VegasPlus', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6IkZXRTRya2duNmZLd2pRZnpXamNkWmc9PSIsInZhbHVlIjoiQ1NUQ1NES25pN2JJRFBDZ3NtTGRKVDJ3b0JDUnYrdG84a0tTUHZNZUdrbzhaVlY3YUd1dTAzdWJIS1ZQbnE5dnIzTTBGQllrditXN1NGeWVGYTJXZzBnZlNGWElqYjNoWUFjS1ovVVdCeWlEQXNWWTM5RkYxV09SRzVqUUpqeEp0bzlkS2ZkUHovZjFhNWNQY0xKZ0dYTlNoU0JuQ05YUjBNMmV6V1pjWGwzaWYzWit4Skk1NURMOU0rRzlxTWhRNjJtL0xZclJwTVRQNmhUdGpjVHd5bUJlenFmM25acnhKQWY3cWJDMWszcURlM0tNcXhhbUl2VFBpR1JRZHNsTVloWm1EMC9ucW5ZU2pNOFY3MjRkci9Ya3FQWEM3VjlLRFh0dEpTVlBZOW89IiwibWFjIjoiMWNmMjY2NGFjODRmNzdhNDJjODQ1MTZiZTk5ODAyNzBhOTExNzdmNGNkZmVjYWMyYjAwOTk2YWY5OTVkOTg2YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT, RO, PL, CZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(150, '75548-GUnmyA5cWJy79Kcm', 'Unique Casino', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6InpqcUJXMWIyY1pSZWowK2RDSWRnV0E9PSIsInZhbHVlIjoiWklkZnUvMCtuRUtGcnRsVnF5WVZSbXpNcUlCdFBQQ1MzWVg3NDc2N01DMHl3QUsyaU1YRUZCeGNCVVUybnkxTzMrdk82VW9OTE9iRHptNHBKNENOSWorK2liSnd1bXpqUVNnT0Z4Y29CZVJTelpRdzAxVjQ2RDJ5aU4rYzduM1I0RDQ3TTlnNjRpcmZENnZEaVpkbVZaQ2hSRnlkV3FDRk5mME9tSEhrRG51blV6S2VBNFBDN3lmc2J3T2xyRXdFWnNOWHZDZnBZSnJJZ3NkRk5zYzJVckF4S3dtNWxpS2V2bGZ6d0J0QkhNZzhCa3Bvc2pXeGluaEc4d3A4SElvTm1NV1hyclpOUzV5YWd0QUxvcHlVVHk2SEU1NllyaVdFdDRQeFp5MVpaTjg9IiwibWFjIjoiMjlkYzZmZDI1YTEyYjA3NmEzZmI2OGY1OWRlYjEwODM5Y2QzNDJkZWJjZDU5NWNmY2FiM2I4YjJlZTExZDdmNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT, RO, PL, CZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(151, '75547-GUnmyA5cWJy79Kcm', 'MaChance', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6IllqeTdjQzVnSWZlWGJHTXBqT3BZbHc9PSIsInZhbHVlIjoiYmRoRWdacFJTazNIV2h5K25BaEJqSzN6Q1Z2YytSQjdKalV4ZVpCcE8vc1h2ZUhZMm40UXFpZHlMY1NCSEh3N25IeTlhTXJPUk5hT2Q4dUNzRmFlZjhnTFZYaXRHNG84ZHJRbVRQeFA0bXZpWUtGOHNVTHJQWEFSWUV5K2g4NmRKRGxrQUtmSTFWU1FXcVBHcktZdmF3WTVvMDVBek5aU3YzM3pZZStyMlJVU0w0R1VCSzRvTWRtOElSNnJhMnRka29ZK1JWSk1URXZSTUdsT0wxeHAxUlNXNitDOWh6dGxrUWQyMlArR2ZOVUxDVzRNZm9kRzNERWgySVkzQ0lKYjF1dW45TUptYm9yVEdCYW41VFFGcHkzdVRWVFZpeXVnTUgxS1I2WkpmaFU9IiwibWFjIjoiNDMwNTk2ZGFmNjRkMTNkY2IwZDBmMWI0MGQwOWE0MmVjOWVjOGEzYjE5ODAxMTBjMTY0ZjUyY2VjN2M2YWQzNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT, RO, PL, CZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(152, '22434-Q0Fm7OXUFNcX72x6', 'Mobrog FR', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlB5akZZTm1qbmg0M1FFelQ1cFc5SGc9PSIsInZhbHVlIjoiYmRVeVFvUFN0dW8zNW9rdUZydlBkUHMyOEIxUHhYMGx4cnpDbkRkVk5BQnd4TjBURFE3Uk9jMlZHcGcrajNackIxWk85bmlZNUVHOWJiTVVIQWt1dXpxRzEya0lBdTFjTzNCcGVjb1RXdVdTQWp2YndLRHg4ckJQamhSZnU0d0V1amxmdlQ0WExBcmZUNXhMVmxrcE5Qa0FHdWNBQVAwaERRSkhoV1RtdnJ6aEcyeDN1NTRKVjZ2aHBtS29xcDRtTlM4MHVmS3R0V1BnWThtNnZHcVA0aklJbC9jZTZVdG9NMzY3dUZYcDlkMXQrL0hPaitaZTEzckRYN0xNYVNrbmt2TEZ0d1k5dmRnUkFTWGo5RTdiK2t1NXdaTGtOa1RvWGVrUC9RMlFSNkN4WExHSjgxQnJsVUMvRjlITnRiYjJuSmJIQWxjYzd1bjMwQnAzTThjQjlJSmszYkZEdUNLMmVIaEp5YXpydlNIRy93akNPVVN6SjQ1TGRWMmY1T0wyRkp6UjAzYVoyOHJQZFgyTHpnUDR2T0s2SEt0dnVYdFlEY3lQdXErMnVOY0FqOVhHZ0dncUpQeEpjT01tc2EzaXBrc1AyWkZCSW5sNUZtcUVCZDVHQjFGTWF4VnhXVVE5dGxHVTExZlBsbWVPSnJFdkFRanlQaWRBZ3pPb0pwYmIiLCJtYWMiOiI2YmM3ODQxYTQwNGY5YjA0NjdlYzMzMGEzMTc1ZmIzM2RmYjUwYTY4MDA2ZDQ0ZmVlMmQwZDk5MWJhY2VjMTFjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(153, '57316-jj8oFgHP3Fbq8oqf', 'AppKarma Rewards & Gift Cards', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlBBWE93aTNCRnN3UkpJMGtmTHZ1ZWc9PSIsInZhbHVlIjoiTENjK0VzQ3dhMTdkRFJNVk1Jc25aM0thVVdhbGI1dEx2djRoV0p4eWF0dHFHampVQ2pUVi9XTVVrQkVVZExZRVBXYWlQWkNjL252L0VLaGZMdjBFVWhQZll2YzNvQUlIbHNYZTJsRmJ4SEdxaHR1ckEwbTN0NzhqTzNCUzc0S2had1dUWVZCTGx6ckl6d3FrSUIzWVdrU1p0ZTBoR1I0eWdROUQzTWZ1eVQrcjNLZWtiTWNra3VhODQxTUFyNnltK09RYzBsTnRxN3BkR2RhTGUxL204NllwdmkzU2FBY25EUGJhYVVoajc3YlFINmF2Zmpkdy8rV04waU0rdVk3M2NlRi80T0lYRmExNDlXSExSTnNSaTNTMk5oYzJyY3UxSmhZdWptYlE0NVhFeVpXcU53WGtSeTVnSXBJNGQ3b1FvQWRJTThIQ1VIUGtSdnhMeFpHcHRNZWVPZXlDeGNoZU9SRlFmMWtEZ0xBPSIsIm1hYyI6IjA5MjdkYTBkYTgyYjVjMGJlYTExYzhmNmUxZTJkMjhlZGQwM2JkYjBhYjc0YjFmZjNiMDE1YWZhM2ZjZjlmNWMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(154, '57327-jj8oFgHP3Fbq8oqf', 'AppKarma Rewards & Gift Cards', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImgxbkRTM1ZxMTR0cyt4cEJCdG5Fd2c9PSIsInZhbHVlIjoiODFRWnF3eTlza29mWnlrY3paZkV6dnpacXJpdmw2MWlBMVpiY0l1dlNkZHpQREV4bS9WUUtWYkVFUGtRNStQd0htaTVaMWlDOXEwOThDVGxGWHNmSUE4N3Q0eGZNcEFvSjhXMytTOWYyRCt2eDFJdGJkRitHalBaWWJ0S1dOWjM3b09ISUFkdWpGTHNCUS9uZ1kxVTFHOWpBNm0yUURZOGdaSjZEY0R2OXhNbnI5UGd5NER4UFhQeGtXQkwza1dOazBpSWV6MWI2TDVGcDA1a0grVWlzOVV2K2lzSmRPNG01OVBSZlVpYTAvSmoweUhUNjZuOFpKOFFjVHE2RHEvaSt5eHp0S05sMDJlUEhWem1kc0dBRUFYaTVoRnNYanVWWWtXaU9CRnVRREtCWDZyUEEzYWdTQTgyVEZ2cDcrQUREaHU3enUyU2kxbUE2WGZLTWJ5ejlwNlJxVXJsZ2JKdGRXTDhJWlZ1R2FJPSIsIm1hYyI6IjYxNjkyYjBjYTJlZWZlMDUwZTZkYmQ0MjRkYzMyNjM4ODI1ODFiYmQ0ZGJiNzQ4NThiMGUyZmI5ZGIxYzViMmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, CH, DK, SE, NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(155, '56455-jj8oFgHP3Fbq8oqf', 'Credit Card Rewards', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IkZEWDlxTEFPYUNYdW9abmtsSWVvelE9PSIsInZhbHVlIjoiS3JYQXJabmlpOEorbDQ3K2w4cnhxNEpocHBIenNNR1VtYStCdXNZZ21tL251cXAyeGtoK2hvMXNTMVIvZ0s0Vm9CdjJYVzNlczgrZTNjbUZReFZjSVhXK2txL0J4NHhIaExRYXpFRGlHbTNTSXl2NUFhNU9vMjNUSVB0R2xtVThvbm5QckljQ0lpaEJsa1doS2lEOUppL0NUN05ERW9NV1VRbXptRGtuSnBFSjc1ZWZ2bFVSQ1JvOFpHVUNqQmhib0NtNjVmVVYyS2RRSC8rQ0JwNGd5R1RpVVVYUVUrNWdRVHNNL1ZTZkYvcGxaKytTbDIveUF0SXpMYkRJM0FZMU1HdWkya3VXeUZsejdydmVGMEEyYlZnclV0V1FOdUYrVDB1d0VzN3F0dzFDYnQxVTdUMUdFdlI5TmUyZjdIalBEYUFXRVI3ZXlmaVdBZlpCMTBudGR3PT0iLCJtYWMiOiI5NDcyODE2ZDQ0Nzc2ZmJiNDU3OTJiNzhiMTgyZDNkMTQ5MGMyOTJkNjU4ODFmNmIzMmMzNzE2NWM4MDg4OTM0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(156, '57123-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 1.40, 'https://notik.me/api-redirect?token=eyJpdiI6IllYOVFTMTJvSHE0bHJwdE0zdDNzWVE9PSIsInZhbHVlIjoidGRxdEJCOEVZdk43bjUvaXhxR2ExbU8raXUvZXBBWFhLdzBLSDB6YnRETTlYYmhUTmJxdEt6aEVxejY2NlVDWHAreldwNEMwdFlGQ052bThFWXFWeGNEeURPZnEyQk9NM2tNN0poOEEvS2EzaGtJOUtZM3M3Y2h1TVZkSldYNm9neFVtYUpMN1hSL0FzVUZhNkt0NjBEaUF6WjhUK0hiWnlnbk9JbHB0OUJ0WFVWeXIrVm1tN3FyaTVWZzZZaU9wclJkTGVqTThuOVBOdHExVzIzSU9HRDZrWkQycnVCTWRtSFVIMkNDNTJDV082ME5mVnMyd0JOTlJkd2dBV0FwTjFGVUFpdThuN1B1ei9BSlU1czM0NGpEejZKV1E1TnBsTEloV3dYVWxoa2pBeU8wd3lNcDFKb3l4TWNoVVlSVjIrWHhEd0VId3RodC9ORDVHMXo1RjFlL1BSQnlhY2NkV2V1UHRUeDZEbzhrPSIsIm1hYyI6IjVkNWY4Y2I3NmRlZjc0NWQyOTg4MTg1ZDI1ODg0NmI3M2JhZWM2OWUyZGY1ZTViOGNmYjVkMWZjZDRhNTRhM2IiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02');
INSERT INTO `offers` VALUES
(157, '35278-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6ImVncW52R0kzcmtkNVlTbVNuODVONnc9PSIsInZhbHVlIjoiRHZra0ZvUzBFMkJUc1dVTy9yRXhPdDErQThFT1NwRDQ5V09nTmc0aTJUckUybklObzBWM0t0blNWdHRUOFYwNzY0VmdJZHNzOTBkQXUrUzRxRUJ2UlBZbTdKTUJoM01GdHdENmZMb3I5Tkd6OU1KWjJYRmlVajJHbjNHRjNqRmxRaFpSeTRRblF3M0FmcGphT05RazdKYTZtM2xOejNzNG5XbjJoK2t2bUlpL1VaVW54ZWhkYkYzUS9xbmxzWXl0S3BNajFDN08rbzltbjVpUHYyQ3gzaDJQbTNyVFoxRjFMdDRxdGhrMTZTaGR3MmpId1JVNTd0YzNrdUoySG5PY1pseDhFR1BQbU1vY1JlekFnOFJ6OFczT1FMeEU4OEJMZ2dZeGREN0NJYXhJVTVJd0pTeGtnTlplamtXQkJmbWlYYjFSVG05WS9mWkN2TU9pOGg4bTlBPT0iLCJtYWMiOiIyYjNlYjVhYTc1MTYxNmVkZjdhMDllMjE5MjVmMTVlMTUwYTRhMmFkZGYxMmE2NWE5OGRhNWE1MjQyMmM5ZWU5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, CN', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(158, '34156-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IlRHdm1rTUd5VHE4SXR2VzBjd0ZUd3c9PSIsInZhbHVlIjoiaWtuSGlFb0NhM3Bsb01TVWRoMkZRRUppNGd3WkZBMG5wUWZ4UG5ZYitNdnp0UWFpbThZUFUxMW5INW9lOEtNVVNZS0M0YjdBcVZjOG5TNUJmQ2puYUc4KzB5QVY1V09XM2VJYm0yY3l3MkoyMXJxLzhURE0xUk8weS9WSTh6QmdPU3pMR0F3MFQzU2VGSE9iTU9IZGN1MzZ2cjdlVnoxNTJSOHRXcXd3VGF0ZllQUjF1cjNTSmxqME5RamdxWnE0M3dhNGswOUZld2c0ZFg0YjZPbjhXL1dPSVpxQktZa3RvYmNWTHhCZTlmNGdjbDlENDVTdVc2a0pnb3lQN1lXUkxoODdmamE5eHpmQnJyZ013eVl0OFlTanplUlJWUWFHdFdzWEpPZXFDN3grLzg2QzIrSC9vVkJWZy9RdWxrYmcreFNxcnJiK2k0bENDd3dIdVdubUtBPT0iLCJtYWMiOiJlOWUzYjE4ZWYwMDY1NmViNzQ3OTcxOGZkMDllZTJiZjU3ZTViN2MwNzhkMDI0OTAxZTNhMzI1M2VmZTU2ZWQ2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB, US, CA, DE, AU', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(159, '35272-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6ImxXMUlucXgycVh6NGdZdFo2KzFaTWc9PSIsInZhbHVlIjoiaWhja3JmRU91Yk8zTGVWdjBRZTdjZjZ2QWxra3J1VDFxOVBlSnRkQjFndVk5YjMzL3NKNng4eStvRzl6ZERpQ1ZqYmNRUzBiSHJBOEFQNEFHVlY5dVg0dExibmdiQnBqcmZSK28wYU9ScXRML1pFemFHMWxTWVBTMVQ0ZEpiY0xXNFZwaGNIL3BrMnlKK0lRUW1mdjd5WUk0VUxhQ0o5MUh3bldiU29OazY4dW1xL2dXNloxWEFJUkJsdXY1Yk1jcjRXdm9rcXFxS2grb0tUc3BnUURkRmJTdFIxK2JtTk5yd1IybkVHT0V6T0lhN2ZWK1I3MWowOTA0MGpaSEtSNHpJZUUwZysxVlVqQmN3QUxURmxLT0twNkw5TGZZTkwrYkFtZmhqRXlVQXRPUjdibHdDUXY2MFc4NXhrWElrNHBVcm5WN1RHcG5pRlFVSU9hcGtDVnpRPT0iLCJtYWMiOiJjMjY3YjlkNjczMzY0ZjlhNjdjYWZlNzIwYmVhNmExZDgwOGQ2OTRkYjljMzliMzBhZGE0MjRjYzY1MjU4ZjA3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, FR, PL, IT, NL', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(160, '56885-jj8oFgHP3Fbq8oqf', 'PlayStation 5', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6IlNHQUoxWEdhZUVMaVF5WFE3MlRReWc9PSIsInZhbHVlIjoiTEVRZVV4RVNGTmpMMFF4QlAzbjJFN0xRWFNWSkFBMjcwbEhhOVBWcHZLd1NhVlUwaVNQanNkMVpYN0pZUVdTeFpON1p0c2M0YStxRGhyWkxHU2VUSm1qUjg0cHpWS3Nwd2M0NCt4Z2lSN0VMZmNnRG1jZms1VlRuY1hvcFZaS3BNb2Z5MHBoSG5ZanVtSnR6SDV1U0tYMDdUSU5BQVNHMFVncjRWTG5xd202SmM1MXd2K2p4UUY2YktuVjdIM2dIWXVxdGFIZmFwek45Sm1PK3JaTkhlNFpycWo5TU9hMHd5eHE3WEc4WnJRZE80aGlKVDlpbTVoMVpaR1M1N004UlU5UUtrNDAzZkcvdndyRDduWXpTL1BxOVJTY1ZJbktvQmVmRXdBSGIvbHBRZFBoS2VXNHNBU25YMVFNSkdKajIrZy8rNG1zdkZtMGFjcjlrdG82QllRPT0iLCJtYWMiOiJiYTRlMjBiZDYyOTI3MTMxMGM3ZWRiYjI5ZGEwYjBkMzAwZTRiMGZjMWE0ZWUzMjkwOTIyZjY4ZTVmZDZjYzNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(161, '55819-jj8oFgHP3Fbq8oqf', 'Pinyada', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6IlhZUDNDVFR4QkRKUjgyYmxsbSsyY3c9PSIsInZhbHVlIjoiVUp6dFFZdTBHemQ5VjdJOVl3TTZVekQ5cUlNQXFsanorQythZ2ZhNW12cUtDSUNxZGNOWWhkL1Zlempnc3lWaXZHM0o0dmZZUWE1bllIVGFiM3hBQ2xTZ2FLN1FnZVFyLzY4MDJFbjVjdndBOHhWVkw1M1BySkFEc0lrNThrZjdBb3dTS0w5cnMvcEd6Yngzc3M1am8xeURhb0lhdFZFYnUrdFJhQW43eVFmM2ZwVjBPaXc5QUNVa1llS3BTVkNpcjJhS1ZpNGV4bGh5RzdpcDIwLzV1cXpoU3hWVHJnd29RM0xiUjQvOVYzN05qV28xQk9qMzFQb2FHaDZIcE1tZE1vQ2lJTVJNS2pOL2Q2bm5QWHNLa0NINnpwTUhnNDJubTNSMmxjS1l0SklNREdqQXpqN3o0Nmc5TllCR1VBL20iLCJtYWMiOiI2NmU4N2Q0ZTQzMGFiZTRjYmE1ZmUyZjBhYTAzZTQ3M2Y1Y2JjN2Q1ZjNjYWEyNjNjNzkyYWY5NjcxNmI0ODNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(162, '35275-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6Ik13azdBaFpZaTJ4TVdaRHZqRVF2MlE9PSIsInZhbHVlIjoiRDMzRVN6TzJZNFlrRE5xOFRoS01GSVZOTERIaCticUhBM1JUOGZPRGFBR2VNNzJtTnFtUnAwQ3BDK1FkaVdMT05xeXRPem5pU3d0djEranhDWnBrMGdFWjEzaEZEcEtmZno4SVRqTzNDT3orRWFGcTZ0L2wrMWhaWHBPQllCSkZCNm5iZ09UaW1vZlNSWC9QTDIzc2tyOHJMSHZuaG9QM2VybWRHMUpoYmloemFxZURmTGwxK29sWERxWk1ScDNiV2xuNVFUTWRPUHBWUFFEUEZyMHFmS051bWp3T011dDlsSDNmL1h4U1JkdzlTc294U0FWeGtoWVI2TDRzVlFucHVRTkxNMnJHaHRTRXpIRkxpdEFjdXNjK3hzdStrZ0pRdnlrSWpseFdWalMxR2FMdFVWeVNVWm9EVjNBMFVTQmFDT3FVYUlFU2ZIUTFPZS8vRlB4Rjd3PT0iLCJtYWMiOiI5NWI1YjljNzQ3ODU4YzI1NmIwNDNkZWFhMWI2ODExMzY2MWEzMzRkNmI3M2QxNjk0MmE4MjgwOGYxOGIzZDNiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, AT, NZ, SE, FI, DK, NO', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(163, '49866-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.08, 'https://notik.me/api-redirect?token=eyJpdiI6IkpVU1NGNm1DT3Q2WGtpL2lieFZjdnc9PSIsInZhbHVlIjoiM3cvdGRnRWE4ckd5bmQrc2VhbUtkZFl2ZkRNeDJ2RGdlS1NPUzd0VUlCMmMzVUJLTmJnQjd5bi9UUlhjY2JsamphaGQ5TTNUUCtNeVFQMTBEWnhyY3hXeGJIY09BZDc2MmlyMW5kRnpRd1ZDTk9DcmMyaVFRblFSOHgwUFpYTGQ2RUdjTWVGckRWMmE1M1lsUDdvWFpRSWpVQUl6cUZvUnBaMjkzMnRSQ2tLVTc4amdiNU9JQzR3ZVBNUFRQaGtyOXdMVTFyaTBSWXFNSjY4YXVCazZNQVBEUnlwWHBhYTdHRWRzNFlQdVhZaklMWEY5VVVuMVdrak5ralEzVFVOREtpYzc5aDR3RHpHSUN5R2d1VEhBSVFvRHFlakFqUTNQejhuTlRqL2V1MXhCOU85SEJpRTRvczJoYW1MVmFad0RXYmZlNWRPNndUajJCZEFWK3Y3UEt3PT0iLCJtYWMiOiJhNGQyZTM5OWEyMGE5ZTcwMzViMTAwZjBhNjJmNzRkMDUyNTUxZmM3Mzc1N2RkYTEyYjRkM2Y5NzJkMDNlMjFkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(164, '49874-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.92, 'https://notik.me/api-redirect?token=eyJpdiI6IjlZeEdQejhrS0xJV0ZnY3JIRk1hT1E9PSIsInZhbHVlIjoia0h6anhjZmg3c1ljOTdQM0lxcFRVdi8wSmEvc3MzNmZqTkthRys2dE5tcUF6N2ZPaDF2cUNDSHJMUTAvWHpmdHJlbXFmYnVteDZnbVNyRzlBSkY0MWFLRUNYaXl1Mk5wekIxQ1lMSnRWNzRWdGxER2ozWTVrREhWTHpXTHQ0ZlBoWVV4MFZtMm9teU9ZKzZSN1VlS3ZZT0QwS1dTdGR5Yjk0bm93SVU0VVg5b0p5dkJKUzhRaTU4TXlFbHJIVlhLWTRuOGFvZTRFOFpRODNHMG5UUC9kYjZoeDEzd1BOaHVpQ1krVS9FNVhuWUluOVNhVHZPRzBuSHBvUTRGRkF4TTV5OWN4My9FU1piMWpzQ1NDa1E3cHIzc2RjSyt0czVhSm1ON3JMVE5CbG51d1hXT09tem9PVjBHcUNmUWtjZjBHMTlLV2Z2R2phWEh1amZLdWdLMkZBPT0iLCJtYWMiOiI4YjM5ZWE5OGNhYTQ0OTllZWM0ZjliMzlkNmFmOWYzYzk2ZGM0NWM5OGEyN2I3ZGU5MTk4NGRmYzFkYWViMjMwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(165, '49875-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.64, 'https://notik.me/api-redirect?token=eyJpdiI6Ikt3N2V0akx2RXFlTnR3VGVBeDlud1E9PSIsInZhbHVlIjoiQ1RwM081TUJJcnBwa2ZhSzJRc3hjZUZtTmZtSGdRdHlGOW5XVXd5V0ZpbUdWUFBYUklrb05uN3pIWFJpc3Erc1Q3cytyU3pLQms5WFh4YUxHWWhGUlZscDNUVXpCbEFQdHQrenBlVUZ1eGl5WjlCL0RZcmYvcDBsMVZ5bU11WlJiSVJFSDVJQXZrOFlqQmcrQm1XZVVmVlg2M1Jvd2pEUlhOcnFqcHFyVlVJSEVWWjNOdFpNS3RxTG9abElQU2VWWklieUVOR09TSzJTeHFQcGlwT1pQTFU5eDV5Rk84azJTQjR4b1ZmNnZRWXRsNmxVclVPRVdWZy9yTUIvdlJaZXFSZ05xRkduNFJWYTlwNUNzMWxxWUp4ZHg1WjZhbm4vU3FaQ0xIU3dobmJMc2twb1BnZ0lMcGFMUGFTUDByK3JIL0pvYnVqT2RTeGdrRVBkM2tzZ3F3PT0iLCJtYWMiOiJlZmUyMDFkODU3NTU5NzQ4YWVjNGVlZWM2OGE4ZjJkOTI0ODljZGQwNzdjYjY2ZmFlOWEyZmM4ZjY3ODYxYzgxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(166, '49876-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.36, 'https://notik.me/api-redirect?token=eyJpdiI6Im1SY2RqMU14ZDZuOVRKY2wzRHVlMkE9PSIsInZhbHVlIjoiVWxHNWQrUkpKNlZpbXBCeVlPS0JwdDdCOHhTaUFJdW11NWRDVndzaUhsNWx0WEJUZGF6U2g5b3A2bDZBRlZmOUFCcXAxSWdCbjJ1bFB5RnFaRjIxQkRBSnNnMDlhK1lvU01Ic3lBMkYrQm9TalBGMDVIZlA5dWwrOUJFMDhmTkh6VkVXUDQ5QStqRlI5QTRiQk5jODhSNG9EdHJNLzFyYlZxbmJiQXFxL0cxSllwYTA0RGliWklhRkR0dmJ1YzFqSkVGSnovdlhVOFg4ZkZCSVNLcUpzMzdpQjBGWVptYW02NXc2UWlYaGZxSUtJd01UdVRyNG15Y3lRQVprVWdwV0tVSFhVVmxaL3dRNmxBUWJMaUdZc2FkcWZ0NTZmSDFhdCt3WDdsTFN5UFJmVzhDWkZWOFVaQnIwenJXZDFKaTBvcitxdVdmWExOWDJLUE5rM0lHRzdRPT0iLCJtYWMiOiI5YTZkMGU5MmJlZmRiNDdjYjg2NTRmZjU3NDI5ZDE1MzQ0OTM1ZTYwMWNmMjczYzcwZGIzOTRlZTc0YTBhYmFiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(167, '49877-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6Im9pZkxDRFp2WVJIMEZWNlFBZlJ1cmc9PSIsInZhbHVlIjoiNTNEVTlUbHhkL3B1Q3hidmc4T0RsUTlzdWJBcmNGcEJEY0FpcmlFM0E5cHZIOTlFcFhvc0wxRGE1UG5RdC80bkEvczVQV3RLYTBaWjNtYWl5NW1EeDF1WEVTUWxuQk9JVzFwaXBTL0NKelVYYlFCWVhxSXhoR00vVjZUdjFYVDU2UlNnN2MxTmZTbStBZFQ4V0k4azRsZ3FhT21GalQvczhCL0VWeXNOS0MzSWxNUXFUbDh0a2RxVitKY1gvV0F5RWF3MnMwYmljUXFNL2dFSEZ5ZWUvMmo1SS90Q0FmZjNjWDhvZmtXT2h2TW9qMm5hUDVUQUg0WUJvell6VmFLT2l3YjNTZVorOXc2WlNoWmR3YzRmZm5KMWZpd3VSSFdNbWVPQitXYkdBekp5dUdBYjlETFAvRUZyN3JtSjdObTQ5WDd0TGNnSGhFUkVvdFkvdk9VbTRRPT0iLCJtYWMiOiJiMjMyMmVmYTU3NDJmMjE2NDk1NmYxNjQzZTQ1OWNjZDVlNzgwY2RkN2IzZjBiMjRiNDJjN2M0MWQ5ZTJlMjA0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(168, '49879-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6InVyR0lrSWVuNndRSHV2d0tzZG1kNnc9PSIsInZhbHVlIjoiOEhSNGVQcC9Ia0VDclpOVGRjWTJ5eDdza2I4RGFsSldaY0tUb3REWWhnR08xSEFDV2pSNGNEdkVWb2NMSGFOWjNwQi85ZGJFbkhwVEJEdDBibmN1YjRVeERYZ3lXcytHZmdJd1cxNDZxS2dUSnNYdDk1ejlrOFBoLy9CQ3oxS0ROTDNPZGExRXFiOGF4cUowaGtaVG1pUkJDS29XSVhYOCt0MzdwSUF6OWRkZCthNXVLejNTaHhZZHNPaGdVK3J5V3RjR0prMkFLeXNyUnAva0IrL0g0Z0pJazhLSFFib2hEalBhenROcDRVYjFoYWRubGNLQlRiNUlnV0V1ZWRyQlZoMWhQRXlSQUVqMk5XcmxRcDkwejNDVTlJRTRrU2FJL1UrYVFvRTdXR3ZqOUIyMk1OOWVPNnlQc2JQczFVdkdvbUZMczVYS084Tzc1MUZtYmZCeWhBPT0iLCJtYWMiOiJkMDY1MzNmZjRhZDAyY2NjOTU0YTQ4ZWY5ZTZlNTk5M2RlNWZjZmZhYjQzZWRiN2ZmNjU1ODU3MjkxOWY3YmY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(169, '49880-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 5.04, 'https://notik.me/api-redirect?token=eyJpdiI6IjVFZXhYMDBnUmREOExGbmhKWll4Ync9PSIsInZhbHVlIjoiWW9jL0VwT0JHWWxwUHFocENJOHd6TnFwcnpXUWszRjU3M2ZWdndXUU1DeUVvTFk0Vkw4NmhsR1g5OEo3WjlRN0ExWExFaDBPbzAyUDRKdWhXWkpGN2FwVHpZc1h0WTBValZ1cFFlUHdpbkd6QWJPVnlzUWMwZ3BoR1EvbURtTlpYZjY4OVl5WFhSa043MjBWa2YvTnkweDMwVDcwSGhMMmgxNnlWZTU3WE15d1pLa1JrWmZ5Vi9Mc2g2OVdLWDhmZDhHL29mMFMvSXBVWWozSmNqK3pNbnBLbXlKdUllVmFaSWl0QlpUUE9BKzhVVjZEaFVXdm9tRXVhdU82TG9TbERzMlJ0WEQ5dldHMEtkdlE5REhCUXd4SGxOT3dVZnJING9tMUs3TUxuK0JpY2NVLzI5WFo0NVRmcFlUbmJvQW9haVFaS1o4OW9zbXVjeXlWdjZwcTRaR0RaZitwczdBelRtUUhEMU1nS1RZPSIsIm1hYyI6ImYzOTU0NWQxM2ZmOGQ2MzJjZWU2NjA3YWVlMzc3ZGRmODBiOWFkZTAzNGUyODhmODU5OWM1MDlhZmJiNTU1ZWMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(170, '49881-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlBEV0xLelNLM2Y0dkV4OEJUZGtqSFE9PSIsInZhbHVlIjoiS0VuSm10Nyt6MUFXS2k5ZzVyZTNjOEFWVVAwYTc3S3k1djliYnVoZjZWNlgrREJmYWQvWUNkWFlxcFdVK0pPWk1UaEhUMGg2TlZ3Nit3dXdGOWRJVzZONlVRTnFQbXZHV3NVNjFNUzM2ZURDVGdWQlVySlFlWUVFWldCOTl4NVdZZWtGN0s3QUxTZi9jeHQzWUhoQ1NTTWp2MmFpUm1SZmNxdDQ4VFlWdXFsTVZIS1orVC81aHQ5UzlVaG5MaUZ4cnZ4amhKTWpDa0xYZ3JwNFNTMUhXL0hrRE1wRzdOdS9GRG8zUE8zNjhVWGdKL3kyem9pNzBNZEM3K3JSNE5jR3JzcDk4UFd3cms1R0R0a2YxUENBMlFFTUdUc3UzczJ0Ukx4czZaNysxSU5uN0l1NG5QNVhiN2Vuems3U0hqWWRoL1FsUzI0UHQyS05pelFYMHNiVFZRPT0iLCJtYWMiOiJmZjAxMjRhODE2NTYyM2M0NDQxNTdkYjk1ZWRkZDE5YjRlNDgwNTUxOGUxN2Y1OWI2OTQ1MjBjYjI5NmU2ZDc0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(171, '49889-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.92, 'https://notik.me/api-redirect?token=eyJpdiI6InBzbkIxZjkzUitsSXRUNkZQNU1ZbHc9PSIsInZhbHVlIjoiVG1vTEx6L2tDMEREQ2g5Nm1JM0tGM3c3N0JKTG1SRHNGK2R5azlXUVhwNm5KV2g0V0xLQTh4M2FPQ0dOVFAyazY5TFJkUHBUenZXdk5iMHFncmpvQjl3VnJ6Q2J4TUk0YzFtM1k5S2gyelRhOFM4QXU4V3c1dXNXU1pvVWNnK0laOHZqTmliU21MMVRjUzNBeVlteU42b0VnSS93NjdKVmxSZFE1VWhuODM3cG1KNUF5clJITkJ3cG85ZUVKVTAxOXU4bEJaMEJVSVZwYUpVcXhXKzNwZ2FyaFBhK3c0NWtMMnZScFRVMW5FODc2YzJyT3E4YW40empvcmFhOFhncGIrSkplRHd6YWpEKzM1d2lqbVB2YzZuTmJhUUlWK3IxSCtPZzJzTkVOTlFkcXNHWEpMSmFxUmlzQVVNbzNuRlpCb2ROS3hnRml6clVvcE1OdU56Vkp3PT0iLCJtYWMiOiI3ZGQ0MmIyMzMzMTg2MDg1N2E5Yzg3NDFjYWI3N2MxOGUyMDk0MzIzYjczNTAwNWY0YjYzY2FjN2NkZDNhZmUzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(172, '49891-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 3.92, 'https://notik.me/api-redirect?token=eyJpdiI6InNWZUN5OXFnYk5JbnhoUk9jdlNqcWc9PSIsInZhbHVlIjoiUWM2NktIaTd1akdwUnFlcWFaSXhhdkJkbTdWL2t3YnpqcjdmeWVlL2pRNnpQVURWTHZOejFOWndRQ3VGL2tPTGp1S29Yd3lKMXIrY1g2Vkx4Z3BaQ1liem95bXNzUmo0elkvZk5lV1dxc2pxSnlaa1Z3SWcrZUNLc2FuTmh3NjIwdjlDQzhCUThuU2xsVjVuRVFHRjd5VDdQOENUZnJSMHorOSs5K3JYZmNCcHdDSEMwRUVWcW1EL3ZSdE5DMHBRak1OY1MzbW1jeC9GVW5pRnFRc21IbUx1YmdFbTFyU3F1Q3ZSRzBtT1FhTU16NzNnOVRYT3FZajNjZDZZM1FjVlg3U2VFSWF5bVViREE1NDY4U0VRS2xrUXZtMEZ3RC9takpmOXZEQUlBcG45ek9KTWwrcE1CTjh3TUxOZU00OUxnUU1qdGF5aWtMeHEzUmE3RGJiSTd3PT0iLCJtYWMiOiJlNWIwMjc0OTEyZWE2ZTM1MGU0NDU3OTQ2YWE3ZjUxODZlZmMzYWIwNjAyZjUwMTczOWFmNTE0MDBhNTdmNmQ4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(173, '49896-jj8oFgHP3Fbq8oqf', 'Pagazani Rewarded Panel', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImdRRi9PUGI1SVBMcm5tOEx1WTZXcmc9PSIsInZhbHVlIjoiWTkxbmZkd0ZOVEVWSUROY1ptVEQxRmhvQmlwcXVJMzBTaS9UOUNkcnczdU54RnNJZXZrdHFqZ2dXdFJmR3FOWEFETWlBUk1LWndKeitIR2xnakZmNXNGcXFpL2JZSDlkcHJKQncrSEExdTVWUTVkK2VIaDlkY0lFVXVnZ3lBbk1oTFZKbUNadjlpTXNyM3hpc0taZUlMY3BObXk4Q0JURkZXc00vZVFZVHdHSGpzTUpLVEdpaE14WkZQK3Z2TSs4RXVRbGNHUFlOL3pjUlJKWWQvc3BpcUhJWkZxSzlwTkxGaWFPL1poeGJkcVNaM2x3NHFYeFFkRUFZMWJ6VjVOQjRDSzd2eGhiRzBXcUo5aEJKbzVMYnBDNGZxN29UV2ZKSU14SUhRUDNsMnppL0dsTzdMVGVuN00vSWJPTUJzcnZGNzg2aTRUcmMxVFFXY3h4OHVVMmxBPT0iLCJtYWMiOiJkOTEzNDIzNWE3Nzg1MmU2NWQ1MTdjM2RjMGEzY2M1NjQ3Y2ZjM2E4OTA3YWE0YjdmNDI2OGE1NTc4MjRiZTk4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(174, '15-1086034-PFzYpcfUMD0IDl5E', 'eSurvey router', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IkV3UlROTUFIWlRsUmt1WVhXb0FiK0E9PSIsInZhbHVlIjoiaTZxbkhLd3hCZEVYK0dMaExwcjhVYmpQaXZJRy9sb0xaUG1SYzd6R3ErQjBBSTVQMHBMemo5QzNjeE1ONnlqL1FNWlorY01sOUNob1FsL2ZTVlJGMVJBdi9sMDI2Z05TaU9jR0JoT0FVc3JYU2p6dGRwSEp4VFNMWC9zVWxRMHBpeERlSTQwWDQxOHBBS2VmUk9jOTNqL2xwenc5YWQ0NlprT2dLd1pJZzR1SlZ1dE1NNlpOaFBkYnc5QU9qblY3RVBFaDZaVkJlYXRWVzZydWpTYUp5OUU1TytzT0IwWXQyWDAvaHQ4Zld4Mkc2anRwaHFvcXEzSG9PclFtcnhCQkRCQXdUNnlOUGU3QUpxTm9wR2R2c0o4SVN6K0lTM2V6V0VCZ0ZweU9Dc2s3bnlvMTN0U3FXVHltVStXT1lrWWpWZC9rZDU4V0g5ejNKZEFpWjNOTUpVT1pMOXh1ZE1TYi9QNUU4cERtZGRnPSIsIm1hYyI6IjNkYTUxMWFmZTNlOTNiZWRjMDNlNGYzMWE0YjUwNWMwNzcxNzMyOTI2OWVlNGM1OTc1ZjFiMzZiM2I3ZmNkNjYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(175, '15-1086314-PFzYpcfUMD0IDl5E', 'TunnelBear', '', NULL, 1.47, 'https://notik.me/api-redirect?token=eyJpdiI6Ikh3QTNCTnU1bVdVckFLZ2ROYm01UWc9PSIsInZhbHVlIjoieGZJUWlBWkNvWlBaN3FYNUFpWk5PTTVMNXYyNFAvMGxPZVg2bW5OSHByOHRMZlFPZGJMUjZ4N25maWpiY2t0aHE0b3BlUGZWS1VFVWlkTnpGcG82OE9sM2ZUSk5ZakpCckFzNWRteDFLbkcycENSZFNwcjhwMUlUTWNlVzNscWUwQ2Y2di80OGxUMDlvWUc5dnJtRGF1Q0FhRnEweEZjTG0zaEN5OWlGbjYwU2M2NmNHR2w4aFdjOGNRaXJBbi9sMVNaWTFDWkM1bWd3THVqSi9PVHBtNnBUMWJxMHd4TVZmbTVFV1BuamhFRFNZY1FINWd6Um12NHBnRTZjcHZwYnRjaFN5QzdSdFVmbk9qYmNnL0ZDN3NXK0JTeXVhbi9NRThkRGFMUUk0RmpvYVdQVWE0WnVpMHhmOVB2b3pXVXJENEhrd1ZrdHh5cXdQc2M5c3VEUS84K2owSkdyZWtYSlYwNVFGOEduY1FNPSIsIm1hYyI6ImEwZDYwZTIxZjUzZDliZWU0MTFlNTMwMTkzYTkxZTcyYzMzNmZlYjc0ZmVhNTZjNGFhODQxMmQ2YzU1YjAwN2MiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(176, '15-1088388-PFzYpcfUMD0IDl5E', 'Collective Cause', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IkVSenVQMHZqdzJXWWdZdGE4ZHQ1T2c9PSIsInZhbHVlIjoieEg2aEFlV2pBZDdHdXh1R2V5T2pLNmxXdjM3aU43TERXMnNMVFh3S1J3Mjk4MGtiTHZROFpLUlFRRW8yOFFESWVkUzVIMDcyak4wanpaZzdweGZlVFFycVlPajduWk5iMm1taHZpaE1IMkJXckdqQUwxcXpyQ3NtVXRlTUpha0tmOEtkalppUmcydjdoZXljNExKNDRoaXpBMGQxSVRIckNtU0NXUEEveWF1RElucEU3ZnBoMW0zZkphK29RcmxoaldEclEwOEtaVHVFaHlKUGtRQldGZ0FTNjZRV1hWUTZlTm1FZzE2TCtheXhiZmpYMEJPWVJkOHlDZmxCbEZidXh0aTdOYzJQUjJJTVY5QmJDNXlsY0dPWTZadWRpN2IrdDBQWDZ2eGpFNG9mallNbGJmLzVKWW9EbjU5SE9wdFhkK3ZMWHBmT0V4cEs5OVg3Nm5VZWpJZ2ZTRUdFSTNGVUpMMVcwWExmNERzPSIsIm1hYyI6Ijk4ODcyYmNhNDAyYTdmYWQxNWJkYjg1OTVmYWI3MDMwNjk4ZmY1Yzc4YzIzMWJlYTcwOWVlOTM2NzdkNTZjMjMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(177, '101-999-PFzYpcfUMD0IDl5E', 'Cheddar.tv - Watch Videos', '', NULL, 0.00, 'https://notik.me/api-redirect?token=eyJpdiI6IlJ5ZjFVSkpFMW1qbEJqUFZsdkIwVkE9PSIsInZhbHVlIjoiaVhFRVhHNExsQkJFYXIvZHU4NlFpZ1lnMXRpQ1R0Sk5ySUJMMlE4UmdrVUZhMzNBTDJSc0xJS3JvTDFzM3RCejVkSE5RYU1ZRkRvdHFHLzFTYktXN1N3QUtZY2wxa0tqNnVweU5GUmIxNmJrMjFOTlJtV2hBdEcycDR1Q1BRbjJDbjgxcVJsUHRmTnFCaHJGZDRRdTh4UmVwY3g0bkE2MnlMZ2NwcVAwTXFPeENHTUhJemRyOVpYa3JJNG1lSUVVMi94VktJQWFNY0VSN2N2NEdDSXpIN3RXMlJOUG00WnBVeVhRK3BHaE5GV3lqZW0ydVNCZ1hReFJuUmI4dVQzbzBkSFhyWlZBeWlZYURvUXh6TjhwM3VrV3Y1K0NzbWdERzFwYllDdWZ0ZWtEby9WTFEwSThkNHlBcE5Lc3pVTkN1bk9RNVNadXR3SEFGU2RPZFJCa1ZwS1h2RkdReEFxVXNxTGYwWUtMRlZvdmE5N2pkMm5IbWhydDlHN0grY1RLIiwibWFjIjoiMjJhZjM3OGQ5M2EwOTlkNThhNzc4ZWYyODE5OGNiNzBkODQ2OTlhMTY1YTA3OWZkMWU3NzJkYzM2NWNmOTE0YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, GB, AU, NZ, NL, DE, NO, IE, DK, SE, RO, PT, PL, MT, LV, LU, LT, IT, HU, HR, GR, FR, FI, ES, EE, BE, AT, UA, BR, MX, JP, SG, CO, TH, PE, PH, KR, AR', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(178, '35-123655-PFzYpcfUMD0IDl5E', 'Cornhole League - Board Games', '', NULL, 0.59, 'https://notik.me/api-redirect?token=eyJpdiI6InVJRmtPUXgrQ1h0T08yaHBhSUI2Qnc9PSIsInZhbHVlIjoiRTNoUGJCNnNOb2NkYWNLb2hEc21VeDNieDRUTzZLSE43ODFzdWp3b3AzbFdSaUc3K1dzL2JTTmJ3UnNUWDNYeko2V3hYcUtISmVkREgwNVJXeDB6bEw4aU9kaTlqbngyUzhyL25ySFh5ZU10VThlUVlPVGVseFVXbm1NYzY2b1E0a25JUUZjeng0MkErclVXa0ZVbmdpaDZkclNReUNhYlEzUmRiRWNiQk1jUDhLcHl5dHRqRU1iaVVVTHhtdGUydUhHVUlHcHlVb010Q3pNUldKTkdhaEhTamZYNnpTNUxEYnFteG5xcU9GMWRVTEhhWXoyYnNPWUZmWXRFN0lBVW9zRFRvVndXc0JGbWhzeklPRXNQYTZtZnN0SThNTjNRdGF6dlRnNnIyMjhGWVJDdit4Nm1SaUlyTHVsamt5Vy9NcVpOM05tTE1nQ09Tald0QjBwUG5yV2UwdkczZXJMUE1XRENhWk1nL2U5UWIydWpjSnZwVmhZZTA1eDkzdnRnIiwibWFjIjoiMmY0NmQyMDQ0ZWM0YzAwM2Q5OGE5NmQ4YWFkZGYyOTc0YzM0NzNlYzdlNTAwZWVmYTdjZWFlOTYyYjhlNjRhNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(179, '55818-jj8oFgHP3Fbq8oqf', 'Pinyada', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6Ilp1RlJ0SWU2dEtObTRLY3I3akNjZlE9PSIsInZhbHVlIjoiS2g3V05RdDhCUWIzdXRPa0lQVkJVU0p6NHRyYzU1WEh2VEJuNUQzVFJYdFJwY0Rnb0pOLzA5R1JIZU9TVjMvN2NJTWRFcjUwdC8waDhDVkZ4MmZTTi8vYUFhbG1CSkRjSjFrekVva3lFMHp0bUJhRCtGU3VVRVQ0dk5uSWxtOE9VSHRWRTRMTDBkUmFTNHFmSTl5ZkFxb1ltdTFOOFBDdDBVUlJRZXFudGo2R3Iwb0VnZVVnU1dVTmxRQ0tsTlZqRHhlMGYvS1NYWFc5ajFFcGUvNEpMMStNanJKN2dLb1BESDBwcG5RVmFvOE8xK2hsTmh3YlltWEp1NjdVWUkvL3hBSDdKUEVab3N0WkQzNnlJUTl5T3FXSEJOVlJhb0Rib2ovVnV0TURJb2NZVE8xcGtLUlJ5cHd2b1lhWGlEQjgiLCJtYWMiOiI3MTZmMzZhYzZlNTI1YjBlMjA5ZTUxOGVjYjJlZGRkOGFhOTVlYzEyNTA3ZWU0YjE3Y2YzNWEwNWY5NDUwY2U0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(180, '57125-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 0.98, 'https://notik.me/api-redirect?token=eyJpdiI6IjFVRW0ySlpGTHB3UCtkYnFJdFhpcVE9PSIsInZhbHVlIjoiV1pxdERMTjBmUXpvWi9nWWg3Yiswd0hoLzRMWDhVbExKdW5Uc3llSzNqZXZNSWxVYVUxSWxOUEo3dFZjNGVrVDhuZCsrYW03a3Vhai9BaXM2b01ZZXF2VklQSFc4YURITXdCdG03d2ZOSEwzS2tGMXZ0bWVUNFlTUFAvaU50YTJlMTIrVUdBbUxya3BSR2NVVUpaVjJQUVNrOFQvbi9yQXJuOUJzNXRmY1RhQnkxY1J5QmFNRGFTZmhDbDBGYXh3VVRKSnBjUmN4RWJhYXhUV0wzMWp3dE1CbmlobmRiN09SVE9BbmdneWlIcXpRb09KUUsyUno3MjV4cWJadDBFWXJkalpDQjFkQlRVdTRkOXpHL0R0MFdXc0l2UTE1bzlFRWduN0VnWDFHZFdQUWNDTGozUzFDTUhZUFFGbEFSU0huQzhDMkwwbW93cjlVcGp0WDM5Rmgyb0V1OURmaGFLeGIra1VsVG5zbHZvPSIsIm1hYyI6ImQ3OGYwNGI3OWE1MGIyMTRlODNmMDg5MzdkYmM1NTZlYzZmODc3NDMwMzljZTMwZDA1MmQ5ZjQ0YzEzNjVkMGQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(181, '57131-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6Im9MOFZkeUZDSzRkQ0ZPbWpwZGNQcUE9PSIsInZhbHVlIjoid0pLcDBQSzBkUmVZZS9Bc2xwRkJzYVpJTE5kU2xJN0N2L2RyeE9tSytORmdmaks0Q0FOTWtZWVZ0Z1pJazlVQXg2ai8zR29WZk9wSUZxckZCeWJVZGREZFV2aEpLazgzbU9qbEhFZktCVW5ZZDZXZW5LS09pajQxZ3hMckdZQVRBa3FjZmdCVUs4a3RyWlBnM1lja2ZCYlpQYUxZQkJYOFU0YktVSUx2NXdycHRaM3dRVENyZERqMmpkV3NDWWI0V0Q2bzE4djVDY3o4S3c5T0k3bkhrcGZ5YjZ4eDdFbmt2QUxtcGxvcElCS0xDSTkzQUozM3Rndzh1MUc4M0plSWgzZ2EzSkY0M3BXaFpaaUNRbkVzTkROYUlMNG1EZWlwbUVpWENlR1NiVEJobE42MUlxcXB4SWsvV2pwbHNNRktqUEhaR29ldk5yampQNUZzRGU3RHlISHliV1czWWVvbisvOVBwTCs4UXQwPSIsIm1hYyI6ImJjYTQ3YmNmYjgxYzI3ZWIzZmYxMTU4ZmY5NzY4MWI4YjM3NDY5OTRhN2MxNDU2MTY3NGY4NjM3N2E3YmUzNzgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(182, '57151-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjNiQllUN3ZwY2VTa25oNHNoRkZPUkE9PSIsInZhbHVlIjoiVEkwNkVDL2FCbXh2Z1VvOXFxNXdOV1JidTBPcTlJSjNTTlZsVXUrQVVXQmljSHhEZ0ZjVjJZNjhCN3BoeER6U014YXdFTzFxWG1WRjkwdEp1QS9uNHBwRGtPQ2w3KzJCL054T1pqbm1hcDhPM090aXIySVdpempRMVdiaWRtL0hZYVVjOFIyaG1UM3RqQUdIUXBKY0d2Y2crVjFTN0NvdnVON2JDZ0VuZHFyM29WM2ZzeVVHNjJBaVZucE9ZYXVqeFlLUkMxYjZHdWE3aXY4TysyNGFUR2hyL1VHZVA5dURnWG1IM2FzTnM3K2NBamRQN2NnU2hta2E1V0ZGb2FIeTBVRi9XdFlxMFU0aUkxeWN3aWt3MHorbWxQMmFEZlV5VzNsa2F2dGtFMVFZa052Q2FmQ3VYZlF5cnJRQ0hQVCs2Q3dKYnBlQ3ZNTTV5ZHArdEVIcS8zM014ZDlGbXFyZnNGdjBQRUxFQmk4PSIsIm1hYyI6ImU2MWZiNzlkYTE1YzY5NWY3NTc3NzkyZDI3ZDAzOWUyZDFhNTgzZGUxYWM0OGQ2OTA5Njc2ZTA0OWJjMTFlZmUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(183, '57461-jj8oFgHP3Fbq8oqf', 'AppKarma Rewards & Gift Cards', '', NULL, 2.31, 'https://notik.me/api-redirect?token=eyJpdiI6InF0L2Y3UlBWUzhaRFZoRlBCYmEyNmc9PSIsInZhbHVlIjoiZUxtTW4xR3YrR1dwUFVFaE02Q0VVd2pLM1RjMyt5cHZkdThnbjVlN0ZMLzJQbFg0L24zUmFoUkErRVEyNU5DM2pzbEl3QlF0V3g3ZFd0SUF3MnU1ZXRmeGZMQ1VDVysvWTUvbmV2amxGNmdyUlBNdXpmZkVGTGJRWFNFWldkRzY0ZXVaekNyZC9ZU3d5R3hyMmpDSW1mTktLT3dUL2dTcFpMbnYreXRycjZSL0RrUUJzMUs4RC9YUlhFOWRCRURNNGg4ZlJvYXJmTXRmVXdwekUxYys4Tkp6UkZRNk0wdUtXRGNRWnQvd3gycFNlMUVUVWRBT2hxTmpKM3hneUg5UlJVT0Q2bmVURGcxa1hlTlY4cUpKd2hPc3hSZDVWZ0xrUGhWMDZKd2Vmd3dFUkQ3T0NyZHUrUUxLV0RpVG1oenc3ZFp0OUtYcHNmNEVTc1dnOXZxZG9QTUhleVhueXNvcUtFY1gwY0Y4UTBnPSIsIm1hYyI6ImJhZWVhYTNkODNjNTY2YTdkNjg2ODc5N2I1NzNiODlmZjc3Njg1NzE0ZmUxNTEzMmViNzQyYzIzYTIwYzRlZGIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(184, '59120-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IktRSFFZL1NLQnBzYVBuaVdsQVBHNkE9PSIsInZhbHVlIjoiYkdaNDBRTjRmb0dxeTBNRXlGYnlCRjY5ajR6eFRIK3NDVkVsdmcwNzFHditrK3hsOEovTGtURndyY21NTUZXUHo2Y3lJZEZJZ0gvZXdWaTlPSHNaU3RWL2R3NlJWOUJzOCt4cmNVaFgrNUdnNDJyNU90eFlnalJGd2JNdTFsRjVHR1VlY1dvb3ovbmNaeHZrNjBNV2djKzhrMHg2RFlwdzE3WDJHY2ljOEk4aXc0RXFuR21NUmc4QzUrM3A2ZkhpNUZvdHZONTVObE1XTUNVSzFJcTBYcDFCamJoNjFRSkxUcWJocCtSb2kzVHI3Q1ZzcS9pMDdzZ2VWcnZmZVptU1V3TUF6Y1dXcWdCd3ZlZXp0NHdKcmFlaUdDcnoyVVlaNVM0ZUFRUHk0NHA1MDdmZ1JDWEEvNDRuLzMwem9BZ1FYM3V4eFM4NDRFZkdkR2hUZjJySzdBKzNTZ016TG5NYzYwd01leXo0OW0wPSIsIm1hYyI6IjNkN2VlNGExYWFhN2NjZDUxM2M1MGU0ZDFkMmY1NzI3MWQ0ODk5Nzk1YTYyZWUxNGU4OGQ1OWFjN2JhNzY4ZjIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, SG, TW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(185, '59123-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 0.17, 'https://notik.me/api-redirect?token=eyJpdiI6InFBZnRGbG85amdoMFR4NXkrMXA4K1E9PSIsInZhbHVlIjoiMzFiS1UzMzFua0RpeG5CMUJNaFdObnhnUnFZaGpBaUh6Mk81bkQ4djA0NnJEU1dOVFRjakFvRnJyUTVXZ3VSbDRBVHZCS3JOMlM5THFBbjhwUlJLdW5DYVJGSUVwQUpuNVM3aGcyV3JFK2xQVHN0NGozQ2sxOHhGajhSSmdoWmNYbUxTcFZGaXR0WE9JUnJWM2RnM2JWZTJySmtNN1hlK0pYa3dIZzJKUkcyNDBsNThDVnN0K0tCbmhEbm5XeEdNVllxR2krTUVsVEkxVnhmTitTMVEwL3lNR3RlckZxdnMxWXorVUM0YU12VDdEYmVrNHVsbnA2UXpIZkNZcmZDQ2FGZzdQcGljeVczcWxJN1FqKzJCN0RhMldrdnV3Q3g5czd4TmFlQ2ptbU5FL3ZXanFSME0vK2ZjZmxQaTZOeUJFcTg4bTJ1UENoWnk5UlRuSElFaWczN2RINkVSY21IOE5HenlsdVRjUS80PSIsIm1hYyI6IjVmZmU0OTg5M2ZjNWFlZjdkOGYxNDQ2NjJlM2JhMjJiYmMwMTBlNWFmNGJmYjFjZjk2NzczNDRkMTU4MDQwOGEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MY', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(186, '59134-jj8oFgHP3Fbq8oqf', 'CashKarma Surveys & Rewards', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IlQwS01PSSttNkdMNjlWUHFIZW1OM3c9PSIsInZhbHVlIjoiVnNMRmorREZaSHVXMHpWQnZJckhEeHV3YW92S1R2am5hTUQwaW4yZm95eGJndnVBeE9KTm94dUt1bERaTjRmMUN4L0RnOU5oVUN5TEt4MjhpcXRvYU01a2ZBNkVITUxwTWNhS1lJNk5BOTNsNVNWVVJIdnhsdDNZU2tZU215YTZPNGl3YlF6N3RlZUc1OVRxTGhDeS95a2pCcm56V3J2QlpoTUFLTG1xc1RJV2RoWUFkUjZncGZpcnpnaU9VWEFnVVZKRStWdDVYdjNXTm9KRjNTWGtJTFJOVjh1TGVIRUJRSEZ6OS94eTA3Y2ZKMHZHWjYzYktqd0NUMnRFQ3BIU0dXN2RjS2dnVW5xU2svaGRVZjc2MDlDeURVV0I5UXpTdmUwdXlXeUxab3FZcUVpSUVPbVd4cmtHNXk0SklhRDlrc3lScE9QMHRIc2dsTEJSaWtUbHNpcERJenBTT1ZTR0dlMTNwc1l2U0swPSIsIm1hYyI6IjE4NTNmZThjZjMxODAzOTNmYzlmNmU0YWFmZWJjYzAzOGY0YTA4NzcyNzI5NDU5NWE5NWQ2M2NkOGI4Y2Y3YzkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, BR, ID, IL, IN, MX, PH, PR, ZA, SA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(187, '35-123381-PFzYpcfUMD0IDl5E', 'Car Parking Jam 3D: Move it!', '', NULL, 0.55, 'https://notik.me/api-redirect?token=eyJpdiI6IlQrcEpoNVgvUGkzQXRxM3NvZFYvNUE9PSIsInZhbHVlIjoiR0ZvTUx4aUM4MVBTcFZUY1ZvbDRFRTFJNHBiYlBMdWM3cmYvM2I0ci9SRHpPTVRaL2VHM2Q5NTZLZHBiS2dFSXc0bk1BNFM3N1V3akJpSFBlTUFDUUN0M3Erc2xUYTJxS2dlRHZ0VDIzZWU0SkZrcmZEWEZFYjdoR1g1WTdqNHBBd05DUHM2OVczZlE1QmVvNWNHazZmd004eHYvN3hGUENzSEdqazNqMkpvN0ZCcXdwM1hVTXB1bnhwTE5ONmhzL1cwR3FiTXNSV2duYS9PRFdWZGo1YjNmOEpRL09ERlY2MmZRUlY4YzlFZkdXMGw2Y2NqMC9ZK0V0LzByVk5QRHBvekR4UXAzaEErQmhkVTArNEtiWU5FdkZ2eVUzeVdkRmZDMWlzREs2RHpTVjdvTTFZQUxYYzBBRnZTRTBObG54KzV3Sy9CQU1ST2IrVThrdHZ0L2xFMm4rbWhZaGdGSTNZc3ZGQWV3bldEcEwraW5uUFduSElOZGk2NlVEZitvIiwibWFjIjoiMDk0MGY0NjMyZTAyMmIwZjE0OWIxYmNiZGNiZmEwYzc2YThlNzkwNWE4ZDFjODZkMTg1OWFiYjhhNjU1ZGM3MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(188, '13-384932-PFzYpcfUMD0IDl5E', 'Clicker Hunter : Idle RPG', '', NULL, 1.10, 'https://notik.me/api-redirect?token=eyJpdiI6Iml3Y1Y4RXMzOGtiWFJFKzkvRVdPTUE9PSIsInZhbHVlIjoiRW9qcDZkbVkyRVlJU2I3d3l6cGl5ZHNhK3FoQ2RKYlc2eUJDc3kxLzJKZ0dUWTF4Q2w1bHdreUxoT1NBem9BNGpycExvYUtqQ2VxK0FBSlFKRWJTQXh1VTd3WE1BVG1aOWtDTmxCMGNGSnNJblYyVkU5SjR2QmlXVEoxbnRrS3BzZW9HMmFERGFZL2Z4eGlzSVdWa1ZSYXI3UWc5UGpDZThqdDZ0c1NNVVNBVVhQM1V3TVYxQ1NTb1JyVnZZUUxGRmhlZDdsQ1BEdFl3aHROMnFKUVFNbDdNTDc5bitNWlExR21uZ1Z3MTRjMmhKeFRZUW5IVk1sSHJ3c1IxTC93MnYzOSs4V3k5d0JKOEQzRkZleHJmTWxGa0tZbWF2MFVhd1BFdWV4VHhuamUwQlk5QnAyV3NwOEV3emNWMGlUV2pnODdUN1JuM3ZSQU5wamxMZzBxcUYxaXYyTWtpSVlzWk11L0dac3BiZ1g2SEUxemRYalFmY2R2UGw1bldDM1RLIiwibWFjIjoiNDNkYTViYTJiOWU1YmVkYmYzOTJlZWFjNGNiMDA1ODZlYjYzZmYyOWU5NzcyNDExNzg2ODNkMGJhYzA3OTllMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NL, GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(189, '13-403247-PFzYpcfUMD0IDl5E', 'Super Brain: Memory Game', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6Inc0VlFQY1BlVG1jSXR6ZUtxenVZNHc9PSIsInZhbHVlIjoiMDZHTVZpaS85emNYTUVJa1plY05PQ2NXb01oVUpiV0pzSXlubkR3T0Q0VnFUNjdBOE9WUStQaWlGbFdxUlRORXNxZmZXbUJRbWFlN2ZUNDdwYlVCZFpCeU5ZdEQwM052czIyWGFPR2xqYUZiaUhuNWRYM3F6emliTWx4RjhCd1d5YW42d3FCczJrMytzY0tLZE1HTG1PMXdMYWluV09vSXAxZmJmMGRqQ243V1Blay9YQjJ3UDlBUUpIK3Z3LyswMmtaL3hyRmh5VWwvWGh1Qk8ybGRZVHZZcFBWcCs0d3U4bFB4dEhkZjRLMVBieWdVdmNuZzlDUW1FNGs4Q0hMUnZ6MWdZZjhxRlh5RWVwT1BCRy96UnRGUTR3ZmM3Qy9CYXM2dkU3dVgwa0Y4QnNYdWszeW1mQm0zZjdqbk1xWWkxV1l6VDJoK0JpaUlzSExTTERMcDFMYWs1TGRWQytHWGJEdXY1T2VJS3ZzT0kwMGYxb0dZWm4ramZzZ2RvbmxMIiwibWFjIjoiNjFjNzI4OWFkZWQ3MDE4YmMyZjIwY2Y0YzQ4YWNlODE1Yjc2NGQ5OWZiYjMzODJlMzg3YWYyYzBhNzY5ZGFlMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(190, '13-403250-PFzYpcfUMD0IDl5E', 'Super Brain: Memory Game', '', NULL, 0.46, 'https://notik.me/api-redirect?token=eyJpdiI6InBYVFZ4dVRpNTZZbW5vUGtmb1JQNHc9PSIsInZhbHVlIjoiZWJRdkRPWjl0YmVSTHZQUE4ycU9LRzRwN3BsMjcyak1kQk56elRSN2poNkdES1FSdVhOSVdGeDBjN3REUUIvQS9ucUpRUWxSV1RWMVA0OFdkVEVTSHYzaC93c2pURXFEajlzVlhUeWdKQUFCaTJBM0dUaktBMitCenJ3VXFsWTArMUk0UDhuTDYwZTdVYXJaZDhLVGdqeDRDNFpBRmJVSzNZYmNzaFY0L0JBSXNYRHNBdC9KYTJFcTdJV05FTFlMaVBpT243MDYyMjY3NEd6R0tPZm5mejRCNnlOdWVVbkQ5UUE2SWs3TlZOaWpIaStvWDNiWmlwRjVCM2JDOE5PWlhXclJwTzRDWXNXeHpXMEFDb3VlOERzMkpoTmg5ZkpSakt2U00rMDZabU5WSFpROHdkbjRqNGlRWkdkS0tNUStTQ3VLajZjKzVVNXNCVHdmT1VQUzVnUmE5eUY0Q3puY3VubHFnNXZmYjJHVlA5dlBWTU9XYUx1b3Q4V1A1YWQ2IiwibWFjIjoiMmMyMGI5MDBjZDQ5MWUyNzdkODczZDI5ZWJjMzljZjM1OTU0ODM0NTZiNDExMTM5ODlkOGMxZjkzM2NkN2U1ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:02'),
(191, '13-403253-PFzYpcfUMD0IDl5E', 'Super Brain: Memory Game', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6ImNLdmRDVnR3QmxIM1lmcDI5R0hDOGc9PSIsInZhbHVlIjoibkhkR3NuZFQzR0E4L0RjaFRaeHBmZ1hMMEtLb21uYVZhYUpjUTI3N0RJKzNkUWNuWjJJMDFmZytKNnExTE9rcnZYamFUQjNZd0lJR1RuRlM2bWp6NWNncjJkSkdVY3pUbXF2NXZ5alA1eHI2MkVNdXlYajNJR2NJZVpNc1NJblFrVE5QWitXejVmdHRXZGFuS1ZVcjhjQVp0TU9FdTFxbjBIcXFWSWVoTGRtVlhsVmh3RjNDZ09zcG1HSERFZDhBZlZRMXBZVUdMbzhLSGtZZGlvNEo4QzZPOGdaZEZRNzFXNVZOVTFabXNWTlp4Ymd1ZFcvZlFlVU40Q1FacUw5RFpLWEh6SGZRNU5CZTc3a2tYd3liRDFEQmtkVUlHdUk0TWxxY2xIUEhjSnN4cUZjTjErN2NNVnBJL2RTdUNmWWZoamlhZ3ZpRkNBK0lhTTJnY3FYaVRQd3dxbDA1Y3BDRStBQ0dWbkdHTExlNmI4cFhOWGZTbTI3ZjRRalRhTWhlIiwibWFjIjoiYzM4OTU5MTM3Y2ExZGJjZWNhNTFiMjA5N2IxODAxYmI1YzIwOTdjZmI3OTJmYWZhOGQ5NDg4OTU3ODRlZDliNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MV', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(192, '13-353393-PFzYpcfUMD0IDl5E', 'Swypatune - digital talent contest platform', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImJkcmNMZUxJdUQycnh5YWY1WlZobmc9PSIsInZhbHVlIjoiSDU4R29XV3UzV2pUdS83dFBLTkx1SnltRGtjMG1NUWFRVXJuY3p5bE5YK1FEc21MUGYrYzRDRkdyT3hqT0ZObksrbE9SWStGNzhvVzJBL2VrV2tGN0wzRmNJRStpbmx5RlNRTEJnNEQ3dU9rUGhPMEhsQTUyWUt3dUJiNXZBMmZUQXkycTdZcEJTbGFIb052N0RLRmV3YVM0eVJHYkVFa3I5YThXbGlaMklJZGNyOHltT0xBNmZ1ZzhiTnJhdGJTOVZnUVZlaVlUL1FnMVZZbkhuQkpXM1BZbVU3VXhnU1Rpem0wbEZabkdodG8ySU1Da2VzT01XeG5hUWhDWDR4V1hJTS85UlhzQWxkZm8xSE9LTnNXSFlYS1hhL2hqRjBKRlVGblVmNzI1Vk1pNDV0T2pGYzFoRXRKZWNKVEtTSlV0bXFrWXVFQ0FSTjN5bFpRdmlnelZxWnB4RkVjZ1RjTHBIUml3elpPaEZpT3Q5MGRMT0F1SE5EalJvN3pMTERuN29tWmJxQjFwRWt0Mk5EZ0dRMUFqUT09IiwibWFjIjoiM2I4ZTQ4YTNmYmQzNzllYzY4ZWJlZjM3Njc1ODNiZDRlOWVhMTU3NzQ1OGU3MDE3ZWMyZGMyMTA3MGQ1NDQ5ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NG', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(193, '19-55819-PFzYpcfUMD0IDl5E', 'Pinyada', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IkRhY2U1MXhqUFlaenNqQXdYNWl5b0E9PSIsInZhbHVlIjoiYXpQTnlIR2ZXNlRBWlp1cjFNbWh1dFpUL01iajlodG9WQW9DYlVuZjNIMmFudktrVHJ1ZVBRcjB3Q0FLdzRlbXNKdkszbVcrZDg4MThmS2Q1RXhMa3gyYlRaZzcwTzBQY1d1VmZCYlc4YzYrRU1qSVVsalNuMTRLRzBUR2oyVHVhcjFpbTBYUUw3SGFpOGx6dHJ2cDNUd2pLenBaSklhRkJ3bG45Njh2S25rS2dCeWk0T08zNWIzdjhrM3BtY200RGI2Qm9HcUNTdkdLYUxDNDNDMklDeTRHZWpua2lJK1R0U3pBSHg5TTA1VGIycW01WE9nUTV2VzY5R25oemxqTXNxbnNjcjdNdEJ1aVlVZEM2a0FtTG5RSnZ0OFBBQzhMcDcyQ1JQVmVIbkV3NUxOcmVYemdOemZVTEFCbU9EYVpYKy9aazgvZW8vQXhXWi9vRFV4bEVCQVIxeS9nT0UwazNMNUJ1NU5LeGZJPSIsIm1hYyI6Ijg3YzBhOGUzNzlmZjkxMWJmNTE1ZGJhYjc3ZDE3YzYyOTg4MjJmNjA4NDQ0NWFkZGVjODY3MzIwZTM5ZWZhNDkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(194, '13-714026-PFzYpcfUMD0IDl5E', 'VVVGamers', '', NULL, 0.86, 'https://notik.me/api-redirect?token=eyJpdiI6InhaeEJqcHY5Ly9nSFMrcUhZdzlsOHc9PSIsInZhbHVlIjoieU5kQkczK2hvNngzSmFRQkU1ZHBMOWxCTmNacnlFLzZxMS91blkrTkRzaW5ncE1TQkdoRWRzV0MvWHFBUi95VkNUZkJVdHNYZytXMFJVK2NPNlRuaGNhNW43UVNRVHcyeG1KQ0RSTGxtSWJkbmxYMERXTG02ODRSZEtMaEIxU2k4K05ZV2V6T0JMMVMrYWE5UjhBYzc0WUlXOVFrYm9ubEllSUdtM3RGckcxb3lFb243SjJmNjYxNE9UM1Y5TjBURU9zRHBSL1Z1Q1RJcGVVaGpJbVNBL0pMd3M5VlZQd3V4N0lidThqYkpwRjBsZWJsYWN5L3JYUk5jaWZHenVwMTloNzZuekNhOEduYUlQOHJtSURYRXI0b29LZGJOOElwdzVyT214cVdZSG1wclJEV3Brb3BMQUZ0S3ErZXd6MTRuUkZOMG9yK2NpcEpJSXc3T3h5ZWxkQjJRZWUwRE1IZytUb09MSFc0WmJvPSIsIm1hYyI6IjU2NDFjMzJjODZlZDE5NGUzODk0NDM5NDk5OTc4NGI0ZTE0NzJhYmQ0NDZlMGQyZTc4YjdiMzNjMWVmNGZlMzIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, CY, EE, FI, IE, LU, MT', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(195, '59-19600531-PFzYpcfUMD0IDl5E', 'Swagbucks', '', NULL, 5.00, 'https://notik.me/api-redirect?token=eyJpdiI6IktJdEFzMzBWNysvWVkyZFNRN0p2aXc9PSIsInZhbHVlIjoiZFA2dEwxTDhsRVZWU1dlbzBSbXp2ajdxaVM4TmtOTWRFZGJSUGdWTS91M0pCUGRidFZPTVRURkVsZURSa2JTcjVKTUdRV0V4MC9uczVSMkJrZzhKekMvcE40SXo2aHV1L3VMd3dZb3FwVmhrdGtvQnRXYUdJRG91YnV2UjlZTm5GS2taeHRRTVl1anNMMjBIeHFwQW1YYkhEcGtGMDROeTNhL0k4OCtQTUhpYUFpYkh2MVZlaS9oM2MrRUk1L2Jma0t5VzBKZXBEVXVvVmVlczQ3Nk5aaUJkYzlJL2lJNGdOWWtJVDNLU1pjUVNHMFI3ZGl5S1J5Z2ZyVms0Z2lSVDlTUVJOckVXZDRDeEM2bVlPVzRUZGVhbTM5WXZEWlkwcUROYjhKelFqNXlvMVUvaUQ5enRYL1pLMmJFRDR0d1dWbHdodTVPMTJjcmpQYUFJbWIxWDZVZXoveFdBVkdPR3BwSm14SU1meEZVPSIsIm1hYyI6IjM1ZDA0MDQ5MWQyYzQ4NjIxYTFjYWUyZTdlYjAzMDlhN2I5YjUzZmE3OGVjMmNkNjllMWI1ODQzNzYzOGIxYjEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(196, '19-56664-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 2.14, 'https://notik.me/api-redirect?token=eyJpdiI6IkxZWktyTEVMRjFnZFBBTWFMS3gwV2c9PSIsInZhbHVlIjoiejU5a2R4LzNkZnNiM254dVNCTDc1TzczZzlKbDgwWW90MUE4OVNFY2ZhS1VtdVhyUStNWHR1aUlheUpNZERWU29IcE9hQkJuQlY5S2doa2h1WU1XcG5ib2QyVUlYa1N6eW80RHNpZzhRZXBBVnRVNG1KWUtMQ01zeVFHNDVMVW9qWDJEU0ZWQU80VC9vWDZJVlM3Sy83QkJvMWpXeDdteDZuTHVUMWJTY1U5ZzZOeGYxaFFIOGgxaDd3WTUyTGtlK3BJend4ZUxYbU5vbzN2enc4NjlTZlg2ejFxZmh1eUxjNmg5NmJCSjdqY3pETVVMOVA1a3h1Nnk2TUNQd2NFWVZ4T1BzUUErR3gzcGFCcHNOSDQwaDQrZVpJczJsVHFZREUxZ3VzSjNUN3c3NWRQUmFXYUdtSDk3UnNuK3hZUE4wQ3g2c1BTMUU3YVBMckJUKzNnZFF4aHVRZElCbDRuMUhiN0l5OG5rdENnNm8wcnZLNnhEZzZMcnhXWnFSbnlIIiwibWFjIjoiZDJjMzU3MTQwNmYwM2MzNGExZmQ1ZjQ1OTk4NDA3ZGYzMTMzZmE4ZTUyNGY2N2RmYmY1ZDNmYTcyODQ3MGNjNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(197, '15-1088390-PFzYpcfUMD0IDl5E', 'Quiz of the Week 2023', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6IkIwUVE2cE02cVhwenBFSnBuWXhJb2c9PSIsInZhbHVlIjoiTUJpSDRxd3YzcTVqUzdOTHRmNHBWTnpiNEd5WTZSN0hEcXBJaTloaEpEcVkrZllHbTlOZGtzREIrNUoreXVxN3R3ZWhTNE13TElFL25GSEVSVkZBaC9rT1Y1Vkcyc1lHc25Ga2N2Y1dmTG1abUozUWxkSEp3OEc5Y0syMVJrU0VZME8vTlJPVDA5WXY0K1E4Vm0yZ0ZEWXNaNWJ1UVhmSnVsNEdNTnZoQ2cxSFZoRlJGRlQ1NTJKSUtVeC9IZGFiQm1NZXlEUm1oVHZVMysyT1l4YlNXVFNZeW9GWVU4MWhWVnRkOVNqVk5lU0F2TkVTa252ZyttOEJWeWpxQzVHbVZvbkUvMjRrcm5CRlZidkVUeG96blJVSXlWT2hkd01ZQ1BUSUtMUUNXWGJnZXdxUkNHZXdaS3ZpMHQvd2VpRHZvc3ZnU2hKZVp4eXJrekVDekx4WU5GNC9pS0FJcTZFNDVPaSs1V2hySitxVkVGT1MzRGRTei9ZdTFLT08wM0hvIiwibWFjIjoiY2Y3MmQxOWU2N2I4OGY5OWRhOTFlYjgxYmY1YzE3ZjFjNGQwODM0MzE5ZjQ2NGFkY2U1M2EwZjhiOTE1MzhkNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, CA, DK, FI, FR, DE, IT, KR, LU, NZ, PR, SA, ES, CH, AE, GB, US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(198, '15-1088391-PFzYpcfUMD0IDl5E', 'Math Quiz 2023', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6InRiTnlvY3AyK1FOaGpkMEN5S2dINWc9PSIsInZhbHVlIjoiMWpTRFU5ZGpZNFFEbUVhQ09INm5xczNZMUo0NzNDVHRCMkFoZ0xOaFFwaGZiOUkvQmoyT280cmVtWi9DUUo3YlVTZVUzaVJWMWl4czlCWmtyYyt0WjByM0pzNkVYamZDalRqTFhSMGZFVVE1cHE0dFloZFpicVNuWnRyckJOamd2NURONDRNejlNNHE3c0dsUDB6MFJmMXlITWxiVExJNUY4M0MxQmdmOWU5UDdIQ1NBbW5WeHJRcnhHUEF3N0xVYTNNUTlQY0pnaFVRZWNubWRjS28vWXFtTXMzWFNJd052Q3kxVGlFL1lYNi9BSHZZTmFGR1FyeCtuWWVpVGRxR2grd0wyM2o3MnVhZEI2akx6VnEweXMwREM0d2EyR0VlcnZSQnNoZEhnODF3RlVHamVmM0wyeHZOeDlyOE1aQTVBT3Z4aFlTN2puUmNnL2t4SW84aUExVno4UUdhb3h0LzNDNE1kTnZGMVQwPSIsIm1hYyI6IjZiMDE3YWZkNzg4MTY3Y2EyOTgxZWNlMmQ5OTJkM2RlOTFlNzU4Njg1Nzg1ZDA4NWE0NzljYWQ3OWFlYWY4YmUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, CA, FI, FR, DE, IE, IL, KR, LU, MX, NZ, OM, PL, PT, SA, SG, ES, CH, TW, TH, AE, US', '[]', 'all', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(199, '13-398323-PFzYpcfUMD0IDl5E', 'Connect Master - Pair Matching', '', NULL, 0.77, 'https://notik.me/api-redirect?token=eyJpdiI6IlJFS1VEZEFGQ1g4T3RWMHZ0akNvcnc9PSIsInZhbHVlIjoiWDFCeWZDRFJUUExtNkMyMm5kOUN5Y0ZsT0RQNTcweWMzcDRDL1FSQnJMdy9TSDJWVVJkWGI1amhYQWVYTGs0K0I1VytCam9ML3ZycEtsdVdycmRaTUZaOUQ4WkVWMzVQclpxVEhLTFl3WjYyZG13WVBrOS9uZU00MllwK2phSDU1cDkxK1I3SVBjR0FmRWxhVG5VT0x4dW5OL0gvRGxoeUFsaHc0RExlbFhZTXdLK3RySHpqU2NTL2RmSnhRL2txak5JZXJXTnpNSGhDU2p3dmtROGZnZGRvazdXYTUrbVp2alpIQ0I4OUoxQjQ1QjM4aHdVVVJMVm05R09WTXdINXZYVWVLOC95K2c5ditJdFIwcnZ2azF3dU1tZjZJakFEM2U4Qis2VHVYQ0ZpanJnekFzVlkrWk1kcjY4Zmc5eHBuT0RoSDk4ckZmYmlSTnBuMWxUUEdiUVEvNnNHQXVGZU9YTnd6cXFHYmlaRWR6RnpGbisxTmJDUjVrUFJxcEQ0IiwibWFjIjoiZGJjZGMwNTcxOTgwOTMwNTgzMzNiZDVhYzczZDA0ZmFlYTRjMGE1MTljZGE4NDIxZDI5NTkyNDg1ZTJlMjQ2ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(200, '59-19607158-PFzYpcfUMD0IDl5E', 'Trump\'s Empire: idle game', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6Ik03OFd2ZzNSQk9pemFRaEczbmNDR2c9PSIsInZhbHVlIjoiWXM3SGlMTUVQWVF3VXhybm4ycG16K2piQTl0SVpacTBEeFdHOGxHZU9rYkZtcE9GZ3REV1Z1Q0cwT3UrT2MyVkdwYWh3OFdFVjJSK0kwQTh1NHErUlNWWnlwTVJYaEZMZjVKQ0t6MExmYlVWNEZpdmlPMFFOek1zNnJNaGcrY1ZPRUI2K0UrQWhUa3l2N3hjQkh0eVVkdGFWM0xBeElLbzRYZm41cFM0V2lyeHZDZ2NUc3htR3B6S2N0cnJJTnYxaEZxajF6T0FHN1NZRWVUVTRnSlVBN1cyZUwxZFNHU1QvTjlWWVdGTDdkN0wwRndjdk5IRm5DN2oxZUVQSHdHNHY3TzR5UjJzRitrZFZJMmowcXZxbnh1cVVKS1ArdFkrVmdmVDBBOEQxeW9TTHRVMlp1aDVURDA2YnJ3QWtzMGFldVNRaERzN3hNWmdzRVpBaFBqRWtORmY3SjVGa1E4ZnI5MlY2WEUwR3Q4MHYxTExjSk1YQXZ5QlJUa1ZPanVvIiwibWFjIjoiZGRmNGQ2NTE2MDI3M2ViNjA4Y2VkMDdhNDdmNmI5OTA3MzBhYzE4YjFiODU1YWE1MjUzYmRhNTVlZDA0MjgxZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AR, AS, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JO, KE, KG, KH, KI, KM, KN, KP, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(201, '59-19639392-PFzYpcfUMD0IDl5E', 'Berry Factory Tycoon', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6IlAwKy80TktlZGN1SkFXYnp6OXVMTFE9PSIsInZhbHVlIjoiMzRRd1I2NCtQNUVxT2hxaTAwbUVOVnBPQThyNDdIYVEwQXNDV3A1MU5sbHpFdzJQeHZIVHh5Z05QQVRHZ0xsUHowaGFaZ3p5T3dMM1RIUjJXOGFlaWZUeVFZUHA3RUY4eHVvNEovKzdVWDllQzNEM3dFQXpDRVpkcUxSMnJ6eUE4MVFQK3JiVVZodXdBYzRDS2ltbjRBMnlLR0hVZE1LYTgweVlJYy94R2E3SGsyUngrRkNkNkdrM25JWDRiUFB2ZG5mWk5ydm04VFNlU3NmMkd4Q3pQVkR4WEg4WlNGYzEzUDVwOHNrUmtlWUsxdjE0Z21IdmwvM2hnbnBGUUtkZmpVQXhtVTNtT0grMytsYTV1eU0reHlyZkxlMWU2WmFyeDdrRklPWkU5VGcwME42VWV1Y09ORG9kVTBLeEU1bjhBWm5EYXFnbFNnYTJaUnQ2a1h5enFCaFJFWWZEOUF6ZndsUXdVeVZMaGk4dmtBM3dVa09KNFNmR0tEUkVOS3F2IiwibWFjIjoiN2RjYTRiN2JiOTA3OTA3NzJhYzE5MzBiZTU0ZDQyY2U2ZTM4NWVmNmYzYmY0MmU1YzIyZThhZmYxMzhmNDQ1NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AR, AS, AW, AX, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BL, BM, BN, BO, BQ, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CU, CV, CW, CX, CY, CZ, DJ, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GD, GE, GF, GG, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IM, IO, IS, IT, JE, JM, JO, KE, KG, KH, KI, KM, KN, KP, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MF, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NR, NU, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, SS, ST, SV, SX, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(202, '59-19639393-PFzYpcfUMD0IDl5E', 'Berry Factory Tycoon', '', NULL, 0.19, 'https://notik.me/api-redirect?token=eyJpdiI6ImE5dmp0YzNCQlF6RjF5NG9DZlF2VXc9PSIsInZhbHVlIjoieDF3Wkt1VWpCdUQvRzBLUTFtMjVueDdFT3JFdDhqQ0pWcUU2cHA4TllBNjdmNTNSMGFNZUJxeGF0dTVBOGN5MFAvb2NzaUs1ZGR3c0h1aGh1U0FxVlFaU0ErbHAydHg4RGV2RUFpNjVGOG1EMHdVcGFhUXd3NHRlQjYyeXVaU1QxY1RLY0tkVVVQNS82OE1HV1hHa1dVbmR0dnFZRWJUN1k0bjBERm9GVUFZUzAzWGdUN1pjVGROeHB0RXBDYUtFNHZZaHRpb3c1cHV0KzV1Q3krS0ZWQWVRc3lNcFluMkV3NXRNT20xM2lvTnpycmJNVXBKaUhlT2V0aWlMcHVPNnBmOXMvS2dSc2pRZW5uQmxvQ3dmQ2J3dWJkUHRjVWltTTI0MGtOMURJbGNZT3A5UjBmbEdWVy9SaTFTQjl1YWtvNTBkVWYzUnMrQzJiZllyUGdHT0ZWaDZremdNeUJtTzZIMjk3UndXb1JYNFVZb2tlMDVFZFJBVGZoM0NLOGovIiwibWFjIjoiOGRkYmUwNWUwZGY3MDljMTdhOTVjMzU3N2IwYjYwNDljYTczZTU5YTViZjlhNjQ0YzNjYmM4ZDcwMDkwMGNiYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AR, AS, AW, AX, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BL, BM, BN, BO, BQ, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CU, CV, CW, CX, CY, CZ, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GD, GE, GF, GG, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IM, IO, IS, IT, JE, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MF, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, SS, ST, SV, SX, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(203, '19-56667-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 2.06, 'https://notik.me/api-redirect?token=eyJpdiI6InB2S0Y0Q2tkaC9aRzh4RFlpTTlURHc9PSIsInZhbHVlIjoiRjQ3NFdobDRscmZseTM1cnpwNStKZHpGSEZGZlRjNEcwdVhnL2FvZFB3Zm5COUtlTElhNEpQbmg5ZEwwNHlpcndxaEd1QTNaT3ZCQUlVNU9nSU45amd6eVh3L1ZHQkNsc1hIaTJlT0o3REdPZ2xPcWk0Y0RyYWswa1ZCZDNjekFEbGZ4NUdTckhNZGNmOU85ZFgvYzZHN3RicnFxajVxVkVOOHAwQXRDK3ptU2RkaVNNYUZ3OHdrV0hIYS9US2x0UUFjMXQwVmsvUEgzdDZqV3BKZzNIdGJhNGtOdTBqbTkvNnM1aVNHb09ZSVZ5V01nREFxSk1rZzg0U2VEOVVRQkQ3N3hQK3hpbGFhVUt3OXY2ODBJNFFqVVB2TlpVRUdFMHpjcVh2YlljU2R4TkhuVFhkVWxoSmhGK2lVUEVTWkFJUTk1MSt6NEhhZXg1WVNHdjBhamlUNnJuaFNOaHo0bU9RaWNYWWc0QnVaRHcvWjdqcFpXUk4xcmVWUC90R1N1IiwibWFjIjoiYjBlMGUxNDU1ZDhkYTU3YzU2MWVmYTQ2OGIxYjg2ZTFjZGRmNTQ5YWU0NjU2YzhjYjc4MmRjZDU0OGIxYjAxMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(204, '19-57316-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 1.72, 'https://notik.me/api-redirect?token=eyJpdiI6IkJpRGJhbDV4ckFEL3FhVERQeElEQXc9PSIsInZhbHVlIjoieEpsSm40UXNRS0xJZ2IrKzFYYzlqOE05VFhPWVZmeXFVc1ZoU0grbGQxT3VVWW5oZ09yamdLbXZtRno5N0wwTHJ0VFF3WlRwMGlpcmJzMlZiTEFYZ1ZhQlhtcThBNHNMS1p1bC9na0xVZXpZY3NvSkp4azJma2RNRjFmV2ZBTHJ4UXBQdytRdk9icksvb1lRRlRSVkNTbzVMUkYvT0pMVEpjTjFuMmlpQmxjM2FjMEZWbUx3aWtxMUc0dmlpd0h4UUxFOFNtUnY2THUxdEpMd3lDL1VVOEtvcERRb3JYUkc5WnlkRXAySWt1Yy9PdUxIUkoyMlE2WWpTa0VPbU9tTnk0UG1QN29CeE1IbkJPazdWbHhrVE1BT3d0RStzZmpvNGNqTkI1K3A2UGJucVIwNVl3ZXRQSmROdFU0OXc5LzVYNGZrLzUzT2g3aHRPM2FhYmI4ZlhBK2IyQk0vWDVvOGtMR3R5cXZhdkRiRy9xd3Nac1Q1R0hUR0FRaEhiNzY1IiwibWFjIjoiOTBlNTY0M2I4OGY1OGI5YjdjYTZkNWQ5ZWQyYTFjYzE5YWRhOTMyYjA1OTUwYjJjMzYzNDYwZTJhZTI0ODQ1NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(205, '19-56665-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 1.72, 'https://notik.me/api-redirect?token=eyJpdiI6InQ3UU40eVg4QWxoMlMyUTRKZE05bkE9PSIsInZhbHVlIjoiWWVjZytic2tGMVdKREhlbmhnb0QvV3ZFOTlLMmRPUzNwbUpOMUFFU3BFTmd2QU4waDBkbUN4bHNnaS81YnV5RmVnUUFuekViU0h6dTdJcGZCK2lkZ2JDMEVWN2dUSlI1R2JSc2t0VVcwVFR3aXQ4dzdrUHlhS0V6UEE4T2w0OTFGTEFZWkc3czh0di9JS2hURHFqUGdsMkRsYTkzWVdrdDdrN1o3eTl4clJ0em52SFVZN1lmWHMvMEZHaUUrdllsSEIxNm9Rd21vTE9iY1U0OUpYbGI1TEswdUl3TUpLZkxmTG5jWjQya2pwQ0xhYkYwbW9UcmJjcWFKUU9hYmdtR0pTdHhkY0pWOHpQSzEwbTRza2NhTEtyYThNM2tsUWZ2aVRQNkd1aDEzRHFkVnI4elpvUTZXM3pUYWt6NkphWVIrMTd1OTRJQTBYN09adjF1ekhaOUZqVXA4YVcyUXhoWEF6L3V2TjNvRDFZbndORGl4N0xRSVIxMzhFK0FvS2xvIiwibWFjIjoiNmFlMmM0NWRlNjJiMjAzOTkxZDNjOTJlMzE4OTQ0YjIzZTdmM2E5NTFhMzdhZjU4YWZmYjNlMWFhYWE4MzY1NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(206, '19-57327-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 1.72, 'https://notik.me/api-redirect?token=eyJpdiI6IkNKVGtya3laZXdwSCtQemZmRFJyTHc9PSIsInZhbHVlIjoiTFpBZTAxMEtPaGFUc2VxOEEwT2h0cHpxaFJ0RTlnNjhHd2x0US9WREZreEJacC9nV3g2Y1Z6YlFWSWlnTE01WklCR3l1UHlWdlBBSkVQcFBWNkw3cGRWVTNFd20rbTgrdFJyY3FOY05ZeTZESm0yTVpiV3Z6c01jK1Z3M2JsWDJhVnJPMnlnMENHSStGYk9LV2FBK2Q3SmF5ZldwREtKQVVHY2VRUTdqbXE1Y1I2WDh3a1hTUWdHdlJDT2x4cnhiczNZVDRrSE9nbVBMOUFKa2pFcDU2SmVIUmhUSG9FcyswK09LRFRHUG12eVZseXlvMVV5eE1hVXhyelpLQURmemFrS3JZcWtyU3BsdldmWkpUZ3N3UXd1ZHI2aUZIRytoT3hCTTdtMWwzMkVZUldoU2xlTVFzYUZrTEFtWlpZRUhPeWkwbG5wU1VBZGplN3ZvR2c2Y2F0UjBiMElGZVFrMEp2RURZd3pJNis4aklIN1RGSVJMOWJxOVA3RnM5Z3N3IiwibWFjIjoiNGViNjE0NzRkYzZiYjBiNTI2MDM4YzUxYzljZTk2OTNmZGU5ODBhMTM3Y2E4YzdjZjg5MGJlMzdiNThhNTZiMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, CH, DK, SE, NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(207, '19-57461-PFzYpcfUMD0IDl5E', 'appKarma Rewards & Gift Cards', '', NULL, 1.42, 'https://notik.me/api-redirect?token=eyJpdiI6ImFKUEZCOVFrS3djZ1R5VElnOSt5YXc9PSIsInZhbHVlIjoiMjBtQXJSVUcrcXRuMEg1REN0amhadFJMNWxWa3FRekRDVUlremdPNk1XMkpxd01VSzltZGNESjY0UlBFRE5ZUWtCNVgvMFJKTVBIdkFPNkxIM1BQL0VWenZ1ZUZSeUVvRXRndnRkcVZqc0l2NGE3NEpCdVFqRGROZkV6eUVNclJEQTdrZHUzcXBBUlAxUnhYekdnT3VCKzN0TFVnd1ZsRnYySE94WTMwOXZNakhFb3VZY0kvL2xNSWdkZkVKZXpteUwwUTRqOVA4dzlBTnBUL004WGRtUi8vYzMwb1lYNTNIaThVY0RFMmJqTGZod08wbThRT0NKNmMzdFY3d05nSlRzcVp2Rnp3TldCa2lRZ3VmLzRITkFkbDAxdisrNWE0TDZaU0ltSkFyWVhPM3hhZVA0Y043bk5BdlA2SDdvTlVINkl6Y3NnejE4SXhzeEcyZURObUtYQTBxYUxQL04wNGQwbkh4NE00S0QvNUxKMDN3TFZLZU1GL0twbEx1RUQrIiwibWFjIjoiZjNlNTYxODQxNDM0M2IzNGYyN2MwOGM4YzQ3OTczMmNiMzkyNTU2MzU1MGQ4NTRkMmFjMTA1OTU4OWViODdjMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(208, '52-475307-PFzYpcfUMD0IDl5E', '888 Casino: Real Money Games', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImlETTRBRjhpUjNqQyt6MTIrQnkyVnc9PSIsInZhbHVlIjoiMlBLRVg0WGU0V0IyS3FkS2dwaWFQK0lWeHkwRm9hdDlKNkYzTzQ4T1RPZU9vZHJ2cWEvQlhMR1ZvazJyTHJTL2pwMGlZMDlaT2JEQXIvemNJb0Jkdks5TVVKVm03cFBaeTJCSnZrcEpqT3N3cFNYTkhXYW8wM25uMDhoQnUrU3JjMXRqTm5Nd29oSm01UmFwYVNhY0RUcHB2ei9zMWwrRXIyRkJ2UTUxM0ZUamdHUEpwVXp1RjZZWHZaYTV0NkxFZlRjcGZ1UmdtMDl0QjJjZ2xIakJRUU41WmxxWTUzOXZYV2lCSUFKOWU5VExaTnRCZm1FTUhwTmQ4b2VIQ0VxOUxmMExaZWlxbEhhUTdZV3Y5b1V5UmlGS3pXOVZqajhMNm10aVczZmdOeFZWcHRvN2R6T09ybG9oY3FZeUJ2RHZtb3Yrd0VjSVNiL3FrQkxBWFF1c1dpYUNDNk0xOUlaL3ZWaXJqa0swdEV1OTVEbzhYTXZOTzlEN25iN1V3bU10IiwibWFjIjoiNGU4MmYyMmI3N2Y1YjVjM2ZmNDQwYWVhZThjMjNkYjAzM2Q5YzJkM2I3OGM1ZDkwODBhMWZiMzkwYzM1MTljNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03');
INSERT INTO `offers` VALUES
(209, '19-59986-PFzYpcfUMD0IDl5E', 'Hungry Shredder', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6ImdiQUhQajhNRVdSOTgxdGxJTFNmcFE9PSIsInZhbHVlIjoiNG1lTXJDTzZ0S1pJQ2RkUkcwUGhDMi9IK2dLemJIQ2lNTWxEbisxMG95NmxUVmpzamp5SWpoLzVwb2o1S2VEZXY4MXlkbzd3U2sxdmlVaStYeDZ0TGovVFhpdGJ6TFF1Z2VxUHo3bGk3eDZHdmJUVFg0NHppcEtycTBQbjYwWDdMTUh2eVB2SnphWWNKVW1jWVhGQjdHTUpWTVlGU2hNQVVRRFJJOGpZam5TbzlSejZmYXM4UkRnQzNOOHZieEovL2pFenBDVUtsWTdGeThPVU9yZTdWMHIxK05Yc1JrOWtxWWRZTjNBRXhXR0Z0THdvSDZ5MkdjQ3djQ2UzaXNSclVSeEd4d0NLeHk5cjZMT0tXbEx2M3JMRjVaSkt6aDhpblp6dXEvWDdqSGpRTTA3bC94bStxVjMzUENrQVZadlcyVDRwc0lldDE1dmVqODJ3SlZKQUE0MnpuYURQV2ZDYm1kdllyUWVib2ZNPSIsIm1hYyI6IjViMTQxMjAwMDYxZjY1YjBkMTY3MzEwZGNiYTIwMTVjMGIxZmY3ODBkZDY5ZjBjZWMxODU3NTA2YjVlYTU1MTEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:47', '2025-02-26 13:11:03'),
(210, '59-19601443-PFzYpcfUMD0IDl5E', 'Climb the mountain', '', NULL, 0.46, 'https://notik.me/api-redirect?token=eyJpdiI6IjAyR2QyaUpzYXd6S3libFZ2S012WUE9PSIsInZhbHVlIjoiYThRSnNBVTluWG5NQ1kwTmxaNnk5U1RES0ZKYnR0M054cVExL2J1NXZsbk9WR21VODB5bmprNXR6Z3p0TDFOdStnTXVscFkrRVhsV0ptV0JaRVphdGpxUzRCZkJ3OCtINldGVnlkYzQ3c2c2NnFOMENJYjkvbzdOR0FNalFTaFJja2pxeG1xSDJMZzUvZE5RRTczRGlBc1cvT3FCRzlya1lDcXBHOU9sS0V6SUh3d2t1T3pmY3A1SHNaS0NPelZqaXVNSGl1ZFlxZmtRaVNuazRyc0JXUzlUenZUSzZLcEkrNy9ubUZSSk5qRmJLMXlQU0R2aWlhdmFqWmliNzl3eVJJVlRqcFpKcXduNkthbjFOLytXQm1XOW4wRm40bjl2eVBWdU5haHE3Y2NmTk1BUXJSZWhjaEtkSWMreUNkQmo4Y0d1S3hpYXVSa2FqRDBZN2YrUWFxdmsrM2JxeFYyVWc5Vm5kdTJ6ZEZFVkcvSHdZSSs1K2lSaXIvR0xWS0ZYIiwibWFjIjoiZjE3ODQxZmFkMDE2NzM4ZDViNGE5NDBiOGVjNjI1MGY4ZWI2MWM5NDJlMDc1YzA0OGQ1YmQ3ZDA5ZWRlYTRlMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BS, BT, BV, BW, BY, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, IE, IL, IN, IO, IS, IT, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MC, MD, ME, MG, MH, MK, ML, MM, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TT, TV, TW, TZ, UG, UM, US, UY, UZ, VA, VC, VG, VI, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(211, '59-19632819-PFzYpcfUMD0IDl5E', 'X-O Arena', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IjRkTWNHZDVDREFiY2h1d0xGbXdWOHc9PSIsInZhbHVlIjoiNHZOcWJjTEJ1NXlLTW1HNis0MUNLODZCTzNCMUxBZjlERmt1eGtXRUtFYTViaU9HbGFtTERtaDZHaU0zQ2ZDbDdBKzQ0dmpET1R2QkJYWkJhSitHNTVRNkd2RXVTZWcrN1B2WGlSVSttS3ozbEFyZTArTUE1WnRxZlpiclhpQ3pQdGtVVTY2L3lOR0p0YlM2SDhlR1lQOC9sOHFLNW0xTEVra2ltdXluZE9tZnZDQlRyVFRVeTNRVzdoZUV2NElWV2toTWNmeDBlUFlYYmlOOEdaVlVIckRtYU55cWVyemx3SGpHcisvRUZZeno0OWFycWJxRHVvMlZrRXZFdklWVU9jeVhteDY2MUdHVkNpWjR0RHAvUmlsbHFiNllHb29CR2pJUmRjWExPSWdpdUFvMDFHT2g5d2tiUnkyVHBxWXN2ejgxdkJYTjA5WS81VVczUlFPM0dYM1pFSUt2TmFoODR5NkZiSXdJdjBRPSIsIm1hYyI6ImI3OTRhNDA2NmVhZDVmY2RiMWNlYWM4NDZkNTFiNDc2MTRlNjNiOTQ5NDhiZmE1MzY4MjUzMzQyM2I0OTk0MDUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(212, '35-125042-PFzYpcfUMD0IDl5E', 'No Deposit Bonus - Guide', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9ydGlSd3FXcXFobE5XcGU2NjdzQVE9PSIsInZhbHVlIjoiK28rSFRzQ3dLVDBDTkorNFdtMXpaNDFhUHpEUTBUTWc0Sk9rT052TzRodnU3STY0RVZSNHN4QjNrSEZEUWNKUmFHUFBzdDR0cm51dnBsTWsyRHc5SURjSDRXMC9LWWY2ZkJWVSszdEZuZUhnZDNwak9NY3BSTkNGQU1VTWx1SmNDL2hudHhLWHlzNnFKSzhLTVBBaEdkSGxqczEveHJHeG1YUDlFZzdHUnh0c053ZGxkR0FucXFqa2lkVkozYUQzNit2WWorcm9JY1owN3pSaHlrbFdCODAxUWhtNmxHRS9TU3JZRVd4dVV3Sm84V01RUnRtV0ZLOWRIUU9GUGZ3NzNETmdUNkpXcEw3MGNNM1pCcHNGR1Z4Um1MM0hOd1JUcTNoZlFwWXhVUEdvanp6dHZpdmYwb2RJenJTVmRDSkNPTkpIY2ZjS2tZMjZZT2d4bGhscUp1MmFDUVRyNUtRcUhaM2hYQXVudjMrZGtDQ3E1d2luQ0dtSnk3UU05Ym5zIiwibWFjIjoiNDYyZDg4N2YyMGNlNjdhNjlkNjc0MDRmMWQ2NTc4ZmZhMGM0M2Q2ZWNlMWJjNWI2NWNlOWQwM2FhYzVhNjkxYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(213, '59-19639396-PFzYpcfUMD0IDl5E', 'Berry Factory Tycoon', '', NULL, 0.76, 'https://notik.me/api-redirect?token=eyJpdiI6IjhJU0xMTmVXUmtGWEpMWTA4ZXM0Q3c9PSIsInZhbHVlIjoiYXlEOFUvMWZsd2NLWUgremVVYW05M0t0M24yNHlaaXBQRWRQK1NZQUluWldNVmNucGJtZE1mUnNGdHVXeUJKU3RuZlYxUEsvSC80S0tGNUhNZXNYbEVCVFJLUEdkdk00djgwRlhIOWVVdE9mbE1uL25CSFFqMWd4OFpzZUE2VndzRWczMFROMHQxOTdCbXNLVnQvSUxkN3pROTRCamt1M1dQbW5NY2pTWWVQRm5kdTk5SUs4QlVGVFEvQkZLdHB5MlNESEJrR1ExSFJiWjljekJCOTZITmM4L0M2UmdlSVhDa0d0T041ZjdGNXdLSHBsQ1FJZGFsUXlIaStDc1Y0NFczZ2pHNjZFU3dPN2NMSzg3b2JwenFkazRiUzFhSDVLR0RYaU1BNTdVVTgzbmM2ZkI0NC9GWTRJNndNUFhVSENWZ2dFVTQyS0QzcTRuY3d1R3hsTHhnTURlOGZOTDVENmZpZk1rTit6VDYxRTcyVkJndUdwbGdxaWJJeFR0VGk3IiwibWFjIjoiYmU4NDk0MjY5M2IxMGI1YmQyYzViZTY1MTMwNmZiY2M1YmY1NjU2OWM1ZTg0NDFkODE2MWJkOThjZWZkNGMxZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, CA, CH, DE, DK, GB, JP, KR, NO, NZ, SE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(214, '59-19590289-PFzYpcfUMD0IDl5E', 'Diamond City: Idle Tycoon', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6Ii9xUkxFVHlhYW8zVis5am56NVpxWlE9PSIsInZhbHVlIjoiSFZ1cFI3eEpUdm9qV3FXeWNwU3RpcDJiWGNJSnpIeGFaMDlQenNTSzNzTHkzUU1BbytnS0dJOCtsZjRiNUlhaDV4VW1tcFR5dld5SVRBVEppSzZaN2oyY3FxK3IxK0RicVhiQjMvMmJKZEZKSjZHUjJOM0lrNitWZW1uQzd0T3Nxd1hyUUJDcG5OcngwenF0ZjZ6Q3duUzdoWkY3cytRMTNtcDR2K3ZjcVcvRG1YWVpObkhTS0J4dDlVZVcxMFBTZDhkWEhMWFhaWmRqZzFrWW5MR2VRcXhmT1k0dEFyaGJzTWNzcWxyck5nbTdDTDZwVjYxNXVPbnNvRzk2WVU1S1RUTXd2SkxGTVl6Ym5vTkVTREhuU0NlM2t5WmpCRkRESmUyS2tvQVdsendtenJISGtGRnNXZTd6SERULzVESzgwc1V0eXZlWnlkM1dWOHpjUG5JRkxtU2VUWFYySzRNbXZQK01mc3FoYTdqWjVOTDJIVWk3NTdQNEFUcFdmVWxRIiwibWFjIjoiZTE0NjJlNTNjNWFkZmMxOGY2YzA0ZjU5M2I0Y2E0MjkwMDJhOWE0NmQ4MWY2NDI4MWRhYTMxYjA2YzhjZTVmZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BY, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, ID, IE, IL, IO, IQ, IR, IS, IT, JM, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TT, TV, TW, TZ, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(215, '35-125523-PFzYpcfUMD0IDl5E', 'Drift 2 Drag', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6InJ2bzVJdkhtdXZBSERaQTJtRElKY2c9PSIsInZhbHVlIjoib3dQTnBzUHpwMXloZ0djK3lyZTYycDV0VGdnK1c5SFlxRHBhZk5wZmlOb0RTbXFVOUZHNU9vbm5KZUVkNnI5TVg4cFBkQzltVG5FOFQ5UEdTUmI2VTlWWlFIcXAvSXdLRTcrSW9XMVJYNHZEZkNMdXppLzJaRlEzQjFBRlhTaHdtOGVoczhIQytKT3NRRCtQK2xJZXI3R3pzNzN6dGY5UHU5UFl0Qm1POUNQaEtOR3BqaDJmVGlyWXRWTXc3QzZ4NXp0b3AybWEvUUtTUmpQTi9DVDRqRktyVEUrMUpRdHBCZFl3dStVK3BqLzF6bW43ZTk0NCsxbm5DNnBjbERYMkhFL29hZ1UxMzMyT0UvT2U2OVArTGUxQzRJUTREOXpkQXFFNUpzOXJRQzNzTDFnN2pENWxRTUo2QWVrSEo1c3BoWDkrVTFoRXVyUTVseG9pT2UzbDZSTFJHTWxOa2ZXZFJGWkN0NEE3dURrPSIsIm1hYyI6ImY1NWU2Zjg0OTIwYWFiNzgxMDk0YTc5NzJhMTVhODQwMjk2M2M2YWU5YWI0NDg4MTEwMTZmMWU4Y2E0YjAwZWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RU', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(216, '59-19607155-PFzYpcfUMD0IDl5E', 'Trump\'s Empire: Idle game', '', NULL, 0.13, 'https://notik.me/api-redirect?token=eyJpdiI6InRhaUk1MjZmalpCU2xWSlZucnlqOGc9PSIsInZhbHVlIjoicWxWcjN2d2pHWnBhYlZ2clFvYlpwemxsM0xURXAraVFhMStMWnlCRWIzL0xjYW91cDcvbis1dzRzczV0K3dPMWhzdThoelR6Z08rN3FXQWwvNXRsTHRUR21lNnliNGhtdE80RHM4NzRhTkdGNzBpcmZEQWVoalNHYzFzd3JvQVkrTmJXYWxkbTJhTVRhR2NNSVJVVTl2Z3hVenA2OG82Vk1LUXAveFkwN2NyWFRWc3lGL1NSMEozM0NLalRnZmFrTlp4ZWdqSXJqbGZIdk92azkyWG9sZDBPRDg2OE1CL0FMQklMOVFxcmtRQ1l5dFA3N2J5OURHSjhqMUtvRUxQYlBWck9WSW9YRnFYdzBNRDlCcVpXWDRyODdWaDAzZ3JsdXVsWmZLcnVXN2RXdWhsOWk2aEVBMndGaGlxdkwyRGd1dEJZa3c1d05tWldVTEJYMENYeHRGaGpDdUFLMFNZanpKb1JMb09uT0lSUHBCVXVUcytNMnVvcWVlT3l6WkpyIiwibWFjIjoiM2NkMGI5Yzg1MTJhMzhkM2E5ODE1NDlmN2IzZjQxNTE4ODBiNzVmYzRhZjk3ZWZjYWJiODgyNTU5YTNiNWYxYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AO, AQ, AS, AT, AU, AW, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JO, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(217, '237711-euMJk6uxkZa7CT1I', 'Hearthstone: Heroes of Warcraf iPhone App', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6IlhTVHd4a3BlcDRDYVMra3hIVTJmTnc9PSIsInZhbHVlIjoicXh2aVpuVjlGZjIweDk0d2hvb0JoM0trVlhzZkh2NFJoRXZhbU5Lck9RZy9RdVk2R296cUVESHBOMjd6SzMxUm11VFdTMk1nMFhNR2xUQTFTOERyY0xORU1HQVVEcFV0WkFhcWlxa25qVVVoUFROcjVkR3RaWUhtc2Zwby9ueVU2RFZRUklWckt0b2hvY056UlVxNlZjaHFpS3RYWWowMFVWVGY3NlliSVVPQ1ZOc2NiamFkUGtpaU1nMVRtb2ljSjZhZzVtNitLNVBwZVg0OWtGOWduK08yd3ErUm55TGtmSkU4Z0NOSjNWRzY4bkJ1VForRUh0RkM0dk90ckk4K1dhamNUaVBOd2dZb3E1Q1JvRzFtVDVZd1dIWkNoZWlwTnFLSlJRNlhWSVN3cEpiRys1bTJoUWJDdC9HcE9PUEJUc1hZRXQ1QnhVTmFxYkJVamt2aUdJcS82ZGw4Mzhod28xTDllc0gra3NNPSIsIm1hYyI6IjAyNjAzMDNiY2RkY2I0ZDFjZTQ0MTg1OGUzMTA2NDJjYThhY2E3YThlYzgyOWYxZjNjNTFmMGU0MTBjMmM4Y2IiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(218, '5139722-euMJk6uxkZa7CT1I', 'Fortnite Game Guide', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6IkcwUnV4VEQ0RzVIV3JJUGl5NDdmMXc9PSIsInZhbHVlIjoiYko5Zlg3cXM2NjNKUDNMZFBIYzROdXIyVDkyVXZVWTZ3QXNiYUJ0K1pUYXlnS2h2SDV1NjdOM0RvK00zYmI3QnNPWEdCbm1CZXJ2SkRqRzI2eUZlQk9ibzYwdGVrdlk5NDlSNkw4OUlrZURad0hKQ1B1NWdrbHNUaW41T0IrWlF3d1I4Vkg1dnpsZ0lnaitQODZ2OXk1OFJ2L3lzUmxiVGxNT0IwalZ1cjY2aHd1c2RkT2xWbGZUWlo5c285ZGtIK2E1QVZCK2F1RktpT084WHNJTmN3SW9TZHpZejljSGpGT25yRGJWWTFOQ2NuTFlWNGF6SWVycnFmWjEyMG9HcFIrWUx6blJUSU9VMEdMRFhIdVJPc1ZaWmtORVIvaXhqRmcxckhEa0ZNZzdPNUk0amFjeVhhVXNvM3NJQ050c284a1lmeFdSSUlObExTb0FUenhlUk5RPT0iLCJtYWMiOiJkMWNlMjYyYjdmN2Y5MWIzNDZkMTI4NjYyZTZjNjA2NGQ5NGVhNGI0YjA3MzM3NTZiOTc2ODE2Yzg5YzVmNTNkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(219, '5350614-euMJk6uxkZa7CT1I', 'Fun Color Test! (Quiz)', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImZsSENTYzJEckpTWkU1WFVDeWVLOXc9PSIsInZhbHVlIjoiWjgyRWMyMy9PVWN1NG1oaThTdVk2alVYRk9DSzBOeGptUWZGbHpZYUxsalpzTlZndFp3TVlYbExDUWx1bmhpREE4SXFTNFhhUXlBa24xTjgvc1k0RG5PajVIMENmU0xmZmhWM2c3WXlwWCtBYU15azhFOHlOV3h4QzJZUFF5QUluT3ZINjhHU2ZxYk5ORDlVU2lhQVQzZEltZFUwNGh5SzFWVGtpMUJxNzZTbEIzZ0lvTGtIdFFJNHZ6bksvUTZzNUVwYStJSzVzbXRDZW1RR1hESHZBcWNDN3ovSTgvbDZEMGpnN0t2anloTEF1WUdwOE5hSU1CUlFPYTdzbkdUR0M0aktQRFo2dFZ3dUxVZWlpdTIrQ0RIZHJrRFpWR0I3NkRhaGNwd3d5NE5uZzBjbTR5eFVIVFNoQkhURUpNSVdBazBYYVduWDd5eTNCYnM3UGUra0l3PT0iLCJtYWMiOiJlNzdkZWE0MjcwZjRkNmQzNmQ2YmQzNWFjNTIyM2E3N2JhZTVmNzVmYWZmOGYyODIxMTAxYzIxM2M0YTQzYjExIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'mobile', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(220, '5629466-euMJk6uxkZa7CT1I', 'The 7th Grade Math Quiz', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6Ijh3d25vOStDYXR3SFNQL0NEMTNSaEE9PSIsInZhbHVlIjoiQmZSdFl2WDBFbkJwN2FVSkczTStwMDlrTm93WSs4cnRjTklmcXVZRVJjMzJjRXFOa09SaE8vVlRzR2ttcWdUbXZjRmJ5NkwzUTYrTlU4M2h4OW1sL3hWNGV0V2FPcS9rc080amxPZHQ5TTB5eWtlaFVpM3VZUi85YkNTZEFTL3dEK3ExeWxrbkNma2xZNVRLWW9takdYMFRiSG1ENFdEOUo4UFl6TWF2TllHZ0k2aTBlNCtCZGN0SXJYYmIrS2QreFBTRkJqTkFxVzBoT2VQNHZnV2ZUMmNmMnZzeGdYSFZNc001dEZhREZieEJjRE9vcEhuMkZNOUgzeUxBUmJHSktFMXFPeWhUK1NPc2JPeTRINlcxMGFyYzRaejZTTlhxUy9hUmtQVFpXakdiRjF6TGNKNHFTazREa2xoaU1MaHZXNUUycENTeTdvbURMMU9YUTBYck5nPT0iLCJtYWMiOiIwNmY4NDU0ZDkyN2Y1NTZmYTgzOTQwNWZhOTFkYjBkNDEwMmE1NTRiYWIwYmM5ZDJiZjAwYjFhM2FiOTlmZjY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AD, AF, AG, AI, AL, AM, CW, AO, AQ, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BZ, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, FJ, FK, FM, FO, SX, GA, GB, GD, GE, GF, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, IE, IO, IQ, IR, IS, IT, JM, JO, KE, KG, KH, KI, KM, KN, KP, KR, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MZ, NA, NC, NE, NF, NI, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SO, ST, SV, SY, SZ, TC, TD, TF, TG, TJ, TK, TM, TN, TO, TL, TR, TT, TV, TW, TZ, UG, UM, US, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, XK, YE, YT, RS, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[]', 'mobile', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(221, '5905682-euMJk6uxkZa7CT1I', 'Block Puzzle (iOS)', '', NULL, 0.83, 'https://notik.me/api-redirect?token=eyJpdiI6IjFIRXlmcWlIdFhIYmlvMHgwNTRnQUE9PSIsInZhbHVlIjoiR3o5SVdHSFF0WVRmLzgrMGJkbVNJQnk1dk44azRXSVVrR3IvcC8wM3ZvNmQ4WHlXSnpDeVJLeFVYZmMzSzZicmhrcGtUVmxHMmsrb2NmK2VZRDZzeHNSQ0xuZjlxbVl1K2NDTlZwUFluV3pkQU1XRnpvNjk2SUMvVmpwOXVMR2VyUCs0VTZUOEdFMUhrdWhETnJDbzdBMkwzdlR3VnMzQjdCZGFRUmxmY05pdHlwVklWTDNNaDhlUU8vcW1EUWxGdFdZejJsUWNxbHNidGxDb0ptSkNmMWpoVnI1WTNIVEJWS2szZHJmUkNEVkxLeEFTOUxNdFEyQVE5ZDUwak1yL2ZkTzg3RFB6MjZwelJManV0RGYwcVVKVjhOM3IyWGkyaUo5dW11blMrR1BtbDdqd1FPaUxOZ2d3eDZBM055dkcvRVV1T2NkZUMrWGNGcTRYemQvOUhnPT0iLCJtYWMiOiIyZTUyODYxNzA2YjFlZjUwZGY4MmUzMjYzYTI4YjMwMzk5NGFjZTMxY2NiYTkyNTU1NDhkYTVlNDNlOWJmODZhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(222, '5905744-euMJk6uxkZa7CT1I', 'Atmosfy (iOS)', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IlRDREpmc2RXV2tMdzhxN3BUS2lka2c9PSIsInZhbHVlIjoiMFJaL3p4TitHODQ4bGtxWExMck9LKzJzYXF1VHozY0hnNVBVT21QWnlIdDFTQzEvNVM5bkxEZTgyK3VPSFBjMDU4MktxNmEySmFrbHNiL3UxemtmRUFOT1hoQjRpeTJUbEQ2Ry81OVpFbHdJc3Erang3bW1kNzc0Wk9nUUdmM2RJUGk3b25lZnlDeDlmcFlySUR4WHRHbVdMcDl5Y3BLVUlOazQ0Z3FKUXQ1aFpxeU5vL3ZDMXlxdEpzdmU4VkpENnJkeWErTFMvNW1ubXBuc0hoaVdETzFQL3RWdnVTNU1ha0Y1TElWLzFTdWU2Vk9JMi9FdmkvNFQ2cEJxVlc5VEFXMzJzb2Z1cmVjZ0E5NEdZZTJaeGVuVC9CZjVTaHMvTE5nSlVRRzVnL2ZkR1ZwZ2gxbmJCYk5Bci9sQUhMMTRwU0RBTXNJcTVpdUtvRkZvblNYNlZ3PT0iLCJtYWMiOiI5MDc5ZWRjNzg0YTk2ZjQ5NDhiMmM0ZmY4NDRiNGM5MDNhYTJiOTA0MGU1ODNhODliZWE2MmZiMmYwN2NiYzc1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(223, '5915459-euMJk6uxkZa7CT1I', 'Bruce Bet Casino', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6IlRDRlp4dW5VV0lYVHUvNk1PbFErR1E9PSIsInZhbHVlIjoiTGl3Z0pjRWk4SHI0Nkp1dlpEU09kalpQR21GRG1ZWXpJeEo2WTh4VmdQMnJCRHdZeHBGSy9ZSDd3SklSbVlDNnF2QzdsTlNwYmJobkl4OTBWUTVoVW14UWp2YkxNSHR2YVk5LzlPeVNiNHkyVnEvd01NVHduOHBGaWlqbG9odTZmMExVOVhBbjhlSmxoR2R1bzRzUlpCMDUwTE1LbnVkTEcrTHB2Z1Arenh2b3NJK3k4RFZKdUxrejkxTUFCckVjNHF2QjhJREhMVjUrd2grYklQUnZuUDBDbkl4MG9hOVZiTXRJd1VGTGxDdEhmZ3FCYTV0TnJ2R0MvMXlKNGs2QmswSmZQRmx0ZnE5ZG5wb3dMYWozeUVJMU9XR1BkVUJPNFJFRHliakhxV3FXbU9iNTFJaWh3OWw3VjByNXd3S3VSMnZ4bjhMOTIrNHZGLzZUQVpUN0lBPT0iLCJtYWMiOiI3Y2IzNGNiZDRlOGY2YWYyZGZhYjQ4NDMyZWY5OGM2MjJiMzljMTA2YWNhN2RiZjUyODZmNzI1YTlhZTljODRiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IE', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(224, '5924590-euMJk6uxkZa7CT1I', 'Catalyse research(Router)', '', NULL, 0.29, 'https://notik.me/api-redirect?token=eyJpdiI6InhmQzRyUzdqeEczUkhGcnhrblhieEE9PSIsInZhbHVlIjoiY1pTUHNFZTRSTitFWkJVcGlSaEFoZUtQR01mTEp6cFdsRkdmNm5VRC9GYmlzMXlhQjVGQ2J3ckFnREdvbU5hRmplK2dXSmIwdk1sT241TG9aa2FIKzVhK0oxTnNhaHBlV1ZMOUsvdkNCK0lkeC91NnBOS2JHa3ZKZENxdkQyRnM1bm55bldrUnAwU1RtRTZ6SjFMMGlhU21kbzlUcENXNXFvWURmN1N4bjUvN1lpVWp3OWZab2JkUDNGR1ZNemU4cmsxWFd2ZEtkdTFFWFNVeDVlblAzUVY1Unk1Z0FEQmszODRjTEgvWkNLVzlSYWZzQmdaSW5xNXhzcW1pZDR4U0ZnazVHZ2k4eHk5eGtPcy9CNW1KbUxoV0htUkZESGljS2JvVkFaaFliUkFxQWwveCsvTk5ZNU5pUWNkWHJSSGg0MXF6Q05NcDA3QkFjODN3dy9sQ0J3PT0iLCJtYWMiOiI3YTU4ZjZjMDEyZTc3NWRiZTVjNjA2MDhhMDFiMjVlZWJmNTEyNzIxYzJjOTE5ZDFmODgxMGQxNzJlOGY3MWZlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(225, '5924616-euMJk6uxkZa7CT1I', 'Catalyse research(Router)', '', NULL, 0.19, 'https://notik.me/api-redirect?token=eyJpdiI6IitMYmsybk1WR001dk1GRVlPVVJzeVE9PSIsInZhbHVlIjoiengwZ1FlZTN0WitOQXhnS3E5UDdOYWxpRGFadS9haThnb200ak02OEUwenBheFYvS3kwTENPWWF3Z3pHM1liUjI0QnRyTk5LUll1TTltSDJtUlBVZG9sQnJobTNYcWJPUnlKQk1EaW84ZkJWVzRYRW16d2dTSFVwQTZYUjc4YzlLNFlhdldVZEpwWTkzYmFOSk1iYkdubVM1OWovbnI2YlI4VElpa1BWOW54OC8wRlBGeStpTWRNR3BSeGdhRDRvdDIybzQrSHNhZll5endnY08xam1aYmI3QXFiby81YkxUSmt3YUxFaUZvcU5KbzMzcGp2d2dDN1RCNXBNZUhqMWFINm1VQUJKMU1lKytTekF3TEVwYllQYnNHeTc2VW1XWE0zK0NCWkZsZTBxRUszR09CbDFrL0VFRUE1WGgyM0xIbTRkYjVDNFU5all5VEZZN04zNHdRPT0iLCJtYWMiOiJlYzQ1NzYyMThlMzI1ODA3N2IyMDU2YWQ1MzlkNGUyMDIwN2EwOWZjOTY4ZTZlYWI4YmVmN2NlNDJiYmI4ZjcxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AR, AT, BE, BR, CH, CL, CO, CZ, DK, ES, FI, HK, HU, ID, IE, IN, IT, MX, MY, NL, NO, NZ, PH, PL, PT, RU, SE, SI, TH, TR, VN, ZA, FR', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(226, '5929942-euMJk6uxkZa7CT1I', 'Grab A Toy (GAT) (Android)', '', NULL, 17.64, 'https://notik.me/api-redirect?token=eyJpdiI6InlPZXVMc2RkWExIMmJTUzQ5YUZJY1E9PSIsInZhbHVlIjoiOFREZy9TblRFclh1Z2N1VDNoU05sZjdmSk5YOUpLejA2Y3d3eWhZdWx1bDcxT3laOVhoMzduVHBJc3RLR0xqK1Z0Yk5YMXlFeHBwbFBRT0pyUy9MZHZhMjNzdUs4OTZKUEdORWdtd1ZIYjMvUitWMVlFeTdyM0dtbmdWOVdmUUR5eEJYY2xMR0tDWmJXcU81clI5UUNjVStTeWRXUE82RC9ZdENUV3lLOVZ4cDc1Q0VrbHlxR2M0Nk1tVjM0ZndsdlVWSmN2b3hQYlcvcVVSOUI2SDBhZDVsMnU1V1pvNVdTNmpaV1FCTW1MQ0VEZ3VpS1ArVU9vejZmR0tvWmEyM2Jmc09hMWpWQ3ZsQmFFSlFhR0V4SEtPeFRIK003Z0VEcFRDcVBXRDQyNE1MM0V4SjBoSDRudjJ6ZEdseGJOREZRUjBHU1h3Nkh1Zm55c05OK011Tm82ZUU2eFUxbkwrT1YzejFRMDZaTUVvPSIsIm1hYyI6ImUwNDE2N2MxZGIzYTc0M2M3OWZkZWM0ZDZhMTk2ZjA0OWY4YWY0OTA4OWQwYTNhZDBiOWJkYjE0OGU5MzdiNTAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":893,\"name\":\"Gat Player Reached 100 Distance Level\",\"payout\":0.0625},{\"id\":894,\"name\":\"Gat Player Reached 500 Distance Level\",\"payout\":0.676},{\"id\":895,\"name\":\"Gat Player Reached 700 Distance Level\",\"payout\":2.6},{\"id\":896,\"name\":\"Gat Player Reached 900 Distance Level\",\"payout\":3.9},{\"id\":897,\"name\":\"Gat Player Reached 1000 Distance Level\",\"payout\":10.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(227, '5929944-euMJk6uxkZa7CT1I', 'Grab A Toy (GAT) (Android)', '', NULL, 9.72, 'https://notik.me/api-redirect?token=eyJpdiI6InM5b3VWd1k3NWJtTnhSVFNWVldRL1E9PSIsInZhbHVlIjoibWJrSTRabExLZDBjV1diaUNROHFCZTVXclVyM3l2WnViK3NhS3UzdWxWYmR3TzJENTBLY1VhcHR1QXkvKzkxS3VwYW1hcXRMeHBlS3dKRmFySllHdHZubTkwbmZlaFA5ZDM4OHFrTnoxanAwNHNTSTM3VExwc2I0Wm9WSkhKRG5aZXhVeTE3VkRTZWozNndKMjFIdm1Wb09CWVdPS3dqV1FWWC9KUENrZ2F2S09yQ2tsT2pmSkQ2YkhNRlkwQUxneWtoanF2SlR6NU5PR2NhbmU2NFYrek1rS1hCVnFreHdPejYxVVpsTDdUdlN5MzRVL2htbGdMOEREZHlCZzlYanpxQ0paYVBQcmdqRlU2eTN6cmxmMlN0OUh3bXVkY215bHZ5eEtDWWxkK3ZBeU5XNk0reC9sSXJmL3NyNXFzNHo5Q1Nhd3BreVkzR0psRHVjZGNxVWJQTUpueTd5d3d4akZJcmNkQ1QwODdFPSIsIm1hYyI6IjNiY2Q3MDkwYjFjZjVjMjI5YmNjOTg3YWMyMGEyYmMwYmY1MjBjMzFlMDA5NjY2OTliMzdlMTc1YjU4MDE5NmIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BR, ES, MX, TR', '[{\"id\":893,\"name\":\"Gat Player Reached 100 Distance Level\",\"payout\":0.021},{\"id\":894,\"name\":\"Gat Player Reached 500 Distance Level\",\"payout\":0.2705},{\"id\":895,\"name\":\"Gat Player Reached 700 Distance Level\",\"payout\":1.859},{\"id\":896,\"name\":\"Gat Player Reached 900 Distance Level\",\"payout\":1.976},{\"id\":897,\"name\":\"Gat Player Reached 1000 Distance Level\",\"payout\":5.59}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(228, '5933119-euMJk6uxkZa7CT1I', 'Magnet Miner (Android)', '', NULL, 12.79, 'https://notik.me/api-redirect?token=eyJpdiI6ImN1Z3M3clZMRk90WnVxMitYTkw0K3c9PSIsInZhbHVlIjoiSnYxNnRZVEo4R2tCYnp6MzBFeU5qTGJVVzlzc3pobVllOEpXNW96S1Y1Q01mQ3ZpeDJsUXNCYWlmdlovdXQ0aHFXWDIyd2pDeXdpSGdjOXhQS3duaEJpQlpKZ3cvbmFyRkFrdjl2cmtkY29IRFdRcXlDcGRHc1hpNSs2Q2U4dUxIWjQwaXlVTDdzdWk1L0xEb1BGWjFVbWhXMEE1MW9hTXpYbm5ua2lPc1Bpa2VFRXdyaDVMWE0xSlhTNVFCM3o3TVJHT2NYQlJqUEFGZThDZ3ZZZDE0cW1WeC9WSGIzRDNESWN4ZjJrZXU3cWVMeno5Rk54WWdCb2hFanFtUy9ObDlwZnlrOWlOblNZUVR5LzdqclR2T1ZWWnRqcHVDN2UzVXZMZHlsQklGeXB4czBWUVkxcG9kSk4zWnMzY2MyWjdDWC9jMmc4RnVLa0x2Z1c3bFhVVCtRPT0iLCJtYWMiOiIxZDAwMjgxYTkzMmUxNzYxNzZjNmM0NmE1ZDU0N2EzZmQ1YjdkOWJmOTBkNmMxNWVlMjNmNDJmMjYzNmVmN2Y3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":903,\"name\":\"Depth Reached 100\",\"payout\":0.052},{\"id\":904,\"name\":\"Depth Reached 550\\t\",\"payout\":0.52},{\"id\":905,\"name\":\"Depth Reached 700\\t\",\"payout\":1.82},{\"id\":906,\"name\":\"Depth Reached 900\\t\",\"payout\":2.4},{\"id\":907,\"name\":\"Depth Reached 1200\\t\",\"payout\":8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(229, '5933671-euMJk6uxkZa7CT1I', 'Sky Plunger (Android)', '', NULL, 9.27, 'https://notik.me/api-redirect?token=eyJpdiI6ImUza2Q4OUo0K1lJY1kxSmRCVVNHQWc9PSIsInZhbHVlIjoiK2Eva3M4aHlINXQvZTJtem91Vkp2WjFoUHNGNTNwZ1ozOGpubjNsRHVISVhVRERIaVIyQXgwRlBGTFloTzNlV200aHFINVBnWG5GMGVkZVU2Qkk1VEZwQ0hyM29tRFFoRDg5Wm9EOGVETlRBZWVyOXduR0c4YkxCU0xsanJmWHdYSnplYk5mZG5aam1pWkloZkJVR3diSHhpTG9XeG5nMkdzclFCTk5yTFJsMDlDOVV5R1loU0JHU0NVcUNNNEpHTEJUSHkydlFNSVhJM0pEQmhwdFNOWXkzU1BKRVZNVG5vTFBBMnpUdXNjSFY4TWllYzdFdHFhdUhvaXAzaXFBYXJQK2tFOWsreHovYnRFTHFYR0luT240REFoOWpwYkdXVUJ1bFZwNU9nSzJ2WmtsakhUYnQ4ZDBWU2xUV2E5QmhqZldjNzlkOExLZFRGOTFPT2xoWmhRPT0iLCJtYWMiOiI5OGVhY2Y2ZThhZDRhODQ2YjYxNjYxNGFiOWQ5YzU4ZTQ5YzI0YTc2YWZjNTUxZDE0MjI1NDM1M2M5Y2I4NjE0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":916,\"name\":\"Player Reached 300 Height\\t\",\"payout\":0.078},{\"id\":918,\"name\":\"Player Reached 550 Height\\t\",\"payout\":0.39},{\"id\":920,\"name\":\"Player Reached 800 Height\\t\",\"payout\":1.8},{\"id\":922,\"name\":\"Player Reached 1200 Height\\t\",\"payout\":7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(230, '5933682-euMJk6uxkZa7CT1I', 'The Parachute (Android)', '', NULL, 10.40, 'https://notik.me/api-redirect?token=eyJpdiI6Ijg4Y0tVcjVoU3Eydm9rQjdndWI0NGc9PSIsInZhbHVlIjoiTm1IVDB1Y1lWT1d0Y3N1dFk3NEp4eGpRcjJwc0hVd2dkOFdXUlRJZjdzUkp2NHcyQUxOQTRSUE9Ga1ZvU1EvK1BGUUdaSnNxOHMvdUZxN2N6V3JnVWJlUXNOM250M3dGb0J5RCsrQ1NnVWV0QzVTcUdOWTh6d1VxdXFTc21xaElOTHhqM2hnYjN0VU1XRytuNXhVamNteWlNaHE5clJMSVRMY1h2Mi82Q3pTTVBLdy9CNzlFNVUxcFlxR3dVN2FZU1d2N2tNbUZwR1pnaDRrbWgxckF1SE8wN0RXU01YQ3U2L3ZzSE1GblBvYmN4alFGYzJnamJUZlkzc3ZOM3NPeFpqRzFaL1VYYytndWNqdWUwOTlKOWdkYTVHS3ZCNjFxYWNkRHdhUlJKaVRadU53TXg4TVB6RHdNelh1ejRBcGVrTXVEKzhqMG13QWQ4QnhSRXZ0NVl3PT0iLCJtYWMiOiI3Y2IyYTVhMTE5M2NkN2E4M2Y1NjRiZGQ4YThmMThhYjU3Njc4ZmRjOWM3OTg3NzMwYWFjNWRjMjRjNjk3NzlmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, AU, ES, FI, FR, IT, NZ', '[{\"id\":915,\"name\":\"Player Reached 250 Height\",\"payout\":0.029},{\"id\":917,\"name\":\"Player Reached 400 Height\\t\",\"payout\":0.19},{\"id\":919,\"name\":\"Player Reached 700 Height\\t\",\"payout\":1.539},{\"id\":921,\"name\":\"Player Reached 900 Height\\t\",\"payout\":2.73},{\"id\":922,\"name\":\"Player Reached 1200 Height\\t\",\"payout\":5.916}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(231, '5940855-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6Inp4RXRiYzZLQUhiYVF0cGhLbkZYUkE9PSIsInZhbHVlIjoiMFlhR2E4ZkFTQk1INDh0dnIxSEpJTldhYjBmWTdNQmRRSFJueEZFNkQyc3JJb1RLKzRsNzFNOE1GUDdPcW1MWlJ5SnRsNHhsNW5EMkh6bFFsMHU5aGlobnRDNlNBKzRzYjVoK0kxWkVPTStGcjJENVZuS0pEVVdBRFdVaEZrcnBPM2pQMTdxblowTDNwaFVOQlZFeUJpMDdQQklBWlpnM3JvL0V2QnR5QTlhSkdMZzVHQmRNakxWSDljK2Fab09JVDlManpmUk9DOTFVZitPcHpUUE5XZ2pyN3ZlTlg3R1lNRnkxMjhNNlJWby9ENGl3ZE9qQ0lUa09kV2JwZ1Q5RWd6eWo5STVsN0FqaXhqUmlUeVNCRTJZd2FFNUxmTzg0VkRhcHlVREduQU9OK3BvUzZMZWhyZU13WUgvcUhWL2ZvbklnRk56eUMrSVVhdDVOMnhCb2pnPT0iLCJtYWMiOiI3NDQzOGNlYmE1YWM3ODA0ODAzYTI1NjY0YjE1NGZhYmE2OTlhYmFiMDg5NmMwZjcwYzQzMGZhZGFkNTk2NmE4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LU', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(232, '5940856-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6IldabXluSGx4ZG1GSW1sMWJBQkQ2OGc9PSIsInZhbHVlIjoiQnk4L014NFJVS3F5L3ErMHJOWUFUblFEWHMzYzdsREJlL3JjRGFsajJHWmtFT0x0aEd6OTloMW1kUER0aGkrY2lWaCtHZkdiUkljWUNkT1BFUG54ZzBXOVBwZTJYVnhXczJERmgyQmhoTjVhSkZPUW9LLzBJSkZlbURvVzdTSWdBNFM1eGZScU84cGlab2kzbzVNK0NBZkwrYWpJbXRiN2tKcEltRnpDMU1ybStqb1pPT0oyVCt1VkxIZ283enIzdUtkSEx1NHR0cTRpZkFWQXFqZ1YzUld0dlhweGo0YU51ODJhd0J2ZzR0TlJhYkN0aFN2dEFmdnc4eDR2NUcxWGxyWG5RSHZVR2VwNEhaK25QSnd1U2lPdVVrQlgyd2RSckt1RS84dHZGVHNvQ0F2VW9xWm1tTlpLNWRacGZrSUxodGdUUDhuWThIVlU3SXF3c0lCejZnPT0iLCJtYWMiOiJjMDkxYTUzM2RjOTY4ZTQ1NDg4MDJlNWI3MTRhNjhkZWIyOGJhNjdkYzg2MjNlNTAzNWQ2MTMyYWRkMWRmYWI1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(233, '5940857-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6Ims4SzE4NzVoc01SbmVhNzBWTVh6N0E9PSIsInZhbHVlIjoiOXl6ODRpSzkxN3RDbFM3cFZUZmZ5dkF6dlMvc2lPMk56OFNWSmMzUzlZM2ZTcEpGZ3JMWVgwbXRRS1RsZlZUYVEzOHpzRm5FcFdYWm9sZC9GRC9qYWwxWnVHQk1OSFpnMFNVRkJUbzBSV3lqQjN3WmxYNTBqTENKQ2dMbFZBQmVyQkQ2VzJ0RHRYb2xsQ3ErYWNsUDBLR1hKSERMb0NnMEpmN2FWaTNHWkswY2lVOS9QcUJBMHJIZFZKcnNGSE5tUmNLYlBUMEk2YXY3bThTYVRwVHM3cmNuTzZCV1JadTFqanBFRmxISXdaeEJMalY1TE9sYjJpUFdKd3N3eWd0Wm5URFFuS1I2ZndPaG5aNEJ2M0w2cW9EcUMyeHdlVER0VkxLa01ybFF3SG00N3JOKzVXLzUxZ0JCKzBSR0VlWVZiZ0ZNWEZPUThWWDN6ZWsxNWtoRmx3PT0iLCJtYWMiOiJmM2M3MWVkZjBkMmNlNjU2ZjFmOTI4MzlhODlkMWVjNWJjNTcxNDk1NGRkNGRjMTkyZjAzZDdjOWQ5Yjc4OTRjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IE', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(234, '5940858-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6IktIeWw2R1Z2VEhaamNqVUNsOVNaRlE9PSIsInZhbHVlIjoic0FHOENCcWMyQWx1MVhOQUVhUzA5Tm1rQUFBTGlDT0hscDVjbkVoTngwR05mT2EweGtmaHZlMGNFbkpaZ1BDbWxtNG1tUzNZMTVkN0NFajEyMUR1NWpzWGRjb0xzd250b2NVNGduUnFRb0ZVZ2I0eURUWUZmc3J4ZVhOVU5RVEJRR3dJMUFCTlYvRHdOR3lFU3lYQU40TFlkTnNpZ0xnWGo2T2l3STlLUXNKZy9lT0NkcGxmTmZkQ284OUtqcllLSENML2xWS1U5WFpNaDY0NVNseEt0N2hkUm1sOXlVOWFlb240aDdrUXl6U3ZqMW5DVVE2eGVYL3loQmNqZWJHUGt0N1VwSDRkTUxZaDFZQVczQVN2UTJ0dk5TbGcyN1lqb1c3V3ovZUx2Ri9CVVpIZjRib0FOazc5OEFnS1dxbUpMM29zNkFVY015MExYSWVPa1FhRGtnPT0iLCJtYWMiOiJhMzJjN2YwYjIzYTIzOGUyMTI0OWIzOTVjYTU2MGRlYWJhNGNkYmM4ZTZhYzEwYWZkYmViMDQ4YzI1YWY1Y2UzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(235, '5940859-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6IkpnaDZrOHNpVnlFN2wzK0IrdmkrWWc9PSIsInZhbHVlIjoiSUJGcFRKVkpGQ2ZCTTRqRnJDeWl6dVZtYjFUeGo5ZHNEbGU3dC9nQkdoZlZqcm9XczNPajQvWjUrbU9YRTlMUmpoODVITlJPdjU4RkM2MTQyKzMxRTErVFg1K3h5eTF6NHVKKzN4Z1NBV2dyTUh2UUJaYlNUeFd4SVBZRzZvcmJSaWloV3lTOThkMlc3MmIreUhQM0FTSC9uOXh4L1RVekJicG1kK0dvRFNmNENhNmFGYkZPWUJtcWlUcG0xRTcrSTVRMmU2bkkxVVE0cFV2Y3BHSWNZZnRQdlNqQlFLc2FVSGNTSHRLVE4rTWkzS1U4TTg5Y3lhSHpQSldZOXErNmQzNURzMzZSVC9LMGcwTGdKU1hMa0VrZmF5TlR5b084d012UjNoNTZrWEhsbXZ5dmk4WCtMR2E4TGU5NVhybWp1TnlVQSsyT1VxWmdEOEVxOWtzYVpRPT0iLCJtYWMiOiI4MGM5YTg4YjU3ODI0MGMxNDI5NDIxOTI5ODViYmU0YWQ3YTQzMjJhNDQ1MWFjM2RiOTI1YWEyM2VkNGEyNWY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(236, '5945991-euMJk6uxkZa7CT1I', 'Spin the Lucky Wheel (Quiz)', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6ImwzenVCNm1iUDNxTW5pK2tTNEwvUEE9PSIsInZhbHVlIjoiSk1ESE9kU05XYnZsTSs4UmpXUllNNXYwN2d6WVNzU1JuQlRyVkxsdHRGeDZ4NU8zU0lkY0lERmJoQkltZDQza3ZGeTB0ZW44bEIxODJrR3JsVm1RdEdmNmtMOGZjeXFzWTRiK0ROT0lFcUQrOGFwUCsrYldzUWlpWWhOQ2VyMjZUK25ZNW81UU51b2g0Rk1DeTJxeExuTzBGYzFLZVlHcG5Jc2JnUGtGOU5LblZEQVF6TFcyRTRLcEtrQ0NDaExVSms4a3hjeTJ2bGh3ay81L1VZdzJ5RXF4WU94MjUvM0FzeTVMS1R1VFlJdWNlcjdoZUdzUjlhT2szUjFtOWVGTGNMWTZzQjdGOHVaR1VQZzJsOC9qQzE4cUNwclNMUlZiVzlvNkpZWXpIMlZnN1d2Z3NZMFU1WkJYaHFRdExHWml4dENlOC9ZMGJhaE05NlRGMlRjNjFjRThDdDdiZEZ0Y2FvZk1iMThycUs0PSIsIm1hYyI6ImYzZjg1NDE5NjNkNzJmNWQzMWFiNzMwNjdhMzE3N2Q3NmZhMjJhMjBmZmE1NjdhN2I3N2NlYTczZWM1YTlhZTkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AD, AE, AF, AG, AI, AM, CW, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, SX, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LR, LS, LT, LU, LV, MA, MC, MD, MG, MH, MK, ML, MM, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SO, SR, ST, SV, SZ, TC, TD, TF, TG, TH, TJ, TK, TM, TN, TO, TL, TR, TT, TV, TW, TZ, UG, UM, US, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, XK, YE, YT, RS, ZA, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[]', 'mobile', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(237, '5945992-euMJk6uxkZa7CT1I', 'Easy Peasy Lemon Squeezy Quiz', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6ImFmSmhFbU1yUVdyZzJoMG5LVTlXcVE9PSIsInZhbHVlIjoiaTNRb0c4dkU3dGswU284Y1d3Z3dWMm41ek0wMWpjWUJ1dlNHK2tWQnc4MW9YNUZVOHRuZzZHa281YjFDQUdiQWFUQlR0eG91TmJXY0MyK21sMVNHQUcrYmlHcXFQSXNCK0l5Y0RMZEExS1BVZjJVNjRxZEo2ZFV2ZTYzTnVUMzZQalVZMGZjc3R4T2RWNTRhOXdtR0toK3hBNENWVW5DNXNDZlZ4Z1NMUnhLNjI4WHF1Q05oMDhFMm5kUVd3RzlEYmI4SnNlY2ZQbE5lbU5mcjdqcTJqdUdDeDUzRkRWV1BBcmNGbnd0ZHduTnhzaExOcWo0K1p1VnRCWjBLYVpqOUVVQ0lIZUtEZU04MHZ2RU5hYlRmVVlaZms5R3hLcE9MMm9LQzdTSDl2MmxnMWh2WGFVYTBJYVJJWTRERVdtNDY3NG1oMWJabTdXOE5teXgyVFo1K21jcklSQzRQQ2M4RkdWa3pIWnFuWmlRPSIsIm1hYyI6ImFmM2RhMjFmYWQwMGU3OTg0ZjViY2RkYzViY2ZmOGE1OWIyNzU5NzZhMjkzZjFmYzY4NTgxYzNmNzhkMzZiYTUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AD, AE, AF, AG, AI, AL, AM, CW, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, SX, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LR, LS, LT, LU, LV, MA, MC, MD, MG, MH, MK, ML, MM, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PT, PW, PY, QA, RE, RO, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SO, SR, ST, SV, SZ, TC, TD, TF, TG, TH, TJ, TK, TM, TN, TO, TL, TR, TT, TV, TW, TZ, UG, UM, US, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, XK, YE, YT, RS, ZA, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[]', 'mobile', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(238, '5945993-euMJk6uxkZa7CT1I', 'Big Five Test!', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IldFWGVrMTJhRGwvRCs3RlZlWFd3V1E9PSIsInZhbHVlIjoiRCtreWtrMGVyZ2Nzd3FXU0d4bFFwanQ3Y2MwKzVPSHBlSTlOUzByQ2s3R0J1am5GS0kxSWRlUnlRdVdKQzRtdzJBNUdnYWtRSy8wTDdEYThmVC95eFpvc1dVMkNYMTVyd3FOWmdLWENJY1A3M20rSGpPQ2ozQWw1dDBjdTB4NWI4ZEdiNFRSc0F2WS93QmhJSnNEYlBNYUp6RlAyK0cyQkNJR3VrWDRMMXhGaUZ0L0VoRGVUb1NYZGVJZE9FVnRBaW4vWkxHTlR1NG5YdGM2WDNpeFJvbnMwYnQvU21oUCthUlQ1cWJycFZNeDdHb2ZML0NTOUdlaTJXUzRNZ2RjOVZIeStheGZ3YUJYNHR6cDJKRHBWcUNwMS90OTVFUXF1UXB4ZTZWQzljNGVGNEd6MnpBMTJNekJ5eXpKcHpBLzhmYU04b3BkVTdzd3pycmNKbyt3YnhBPT0iLCJtYWMiOiIxNzgyNWNmMGY2N2ViMWU4MDdhMzA5MTQyZmVlMzYwMmM1OTcxZWM1NjY2YWY4YTFkMWU3ZWQzYTA3ZTU0OTFhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(239, '5945994-euMJk6uxkZa7CT1I', 'Math with Blocks Quiz', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6Ik0wR0lzeTd2K2dtb3NITDFtZnRtMnc9PSIsInZhbHVlIjoieEF6VmJqemN0YVFiUVFOcVB3VXhKQkZjZWpITnBhbzBqMUJGWFRuYXlUK0YzcnZaR3Q2YzQvcmlZOFBkTm5Oa2M3VmFTN09rSHJNbE5jVDlYbGtvc2Ntb1JOMlVLSHYvNVRheGVQVE5RdnI2V0dPc0ZMcmJ1VDBvY1QycTFyNGNUZWV4WGhua3piaWhoSGxSZHF0S2Y3VC9yVWVnY0VpZzBnSVFHdkUrK1lVcUJsZzVtVlJ3UFh4ZWx2cXg0MVR6NkZZNUpubnJ5cXY0RzZnSVM3dk9qeHc4ZmFRbDlJbFFSNVRtVkNxZkZXVTBBK3l3bTdaMEN4ajMwdHdOb0dEaXJCQXlIeTA4OXlDaTJKNXBEYVNhTlovaHNkNzRiM0N5RnJhSGdGRklidkx1U2hvWEt6MHZpcTBWOFRzaFZmYWw2M2N0Z0luZE9NdWplWFFob2FQK0l3PT0iLCJtYWMiOiJlM2Y1OWIwYTllM2QxZjQ4YTdmNGI4MmQ5MmM4ZmEzNjk5YTZiYmRiOTNlY2NkMmQ4Y2QzZjA3MTg3ZjVhZjYxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'all', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(240, '5948987-euMJk6uxkZa7CT1I', 'The Clubhouse Casino', '', NULL, 20.00, 'https://notik.me/api-redirect?token=eyJpdiI6IjlzT1h3Rjl5QUpuaGZ1eGJCaFMwemc9PSIsInZhbHVlIjoiTEF0aXhNT3VXZjhFbDM4ampaRk9CWnNQYTdJTUMzcEhXWDVnRU84ZFhOaHNWdVZoMXpDU093ajVLUXBLQm56a1FKVFJPMVZQb0xlWkFKNmJOL3NrdTMzbXVsZnZFYWxkdVJwVG9ac05JK2hpRzFLV3g5bDYrTm52OFlqZ0Juc2tHY3hiTDdPcWl4ckVhdElwY0R3K0J5Sm1Ub09tZGRXM0hGaUM3SFFzMTFwUE95azY4UHZjQ0Y5UWh3WTZ1cVJONDBEeXJXQ3JDM2NHWDNwMTBGbXl4M0NYTFU1cVNLYU9GK3JCSzRhQWF4U0l4MEFXYlZVazZwSzU2MjF6cEFSVnZ1SlZwOVE0dS9vN1M3aTJGeUpxY2oxMndTbVlldk5yY2pJampUeDRVaXNUTjl2REQrVlR1NVpUSGNYaDFjSkVsbC9MeVFFQmswUC9qdDNwMStONmlBPT0iLCJtYWMiOiI5OTI1NGNkYzUwNjJiZjYxNzNhNDYyYzE1OWI0NjYwYWY2MWUxYWE0YWFmMzZiZTZhNzMwZTNjNzYyYTY2MjM4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(241, '5951977-euMJk6uxkZa7CT1I', 'MAX (Android)', '', NULL, 1.60, 'https://notik.me/api-redirect?token=eyJpdiI6Ijl6Zmx6bnJMazdlY2t1cDBFY1RPRkE9PSIsInZhbHVlIjoiaDB2d0o5bUNLQ2t1eUs2cUVjM0lzdUlSZnM4OWJERzAyN085L1VxelYvcmNBUVBWaFJrdWVSQ295dGdGZDhjdlQ2cUYwdUY4SU5QcENMdVVEUXNXRVRnUytPT3pJQWdDSzJ6em8xS2ZnVDJvQ1c2d0JmYmQxQndmditaR0NycXZPV3lPbmdOQnA5empiYjFjZXpzdjU1NGFjNjE2STVMRWZBeWtGS29OVFhTWmUrVFd0MHZzN3RIYnNVODgrOUhHUVlaUEd0cUVNT1V1TDV6NEhPMUVWTkxqWHoyMlJPcXhxbFhpRjhQWDdpcThYTHh4SEx5ckFORU1LVG12OG4xQUFXcmc0WjBOMGR3cURoNS85Mlp0aytQZ2ZIMU12WGxBS2E2RFRvYmxQRmVvMWRhMzJIcENmMnhucEUrS0xISGwiLCJtYWMiOiIzYjU3MzNkYzczOTkzZGEzNTU4OTM1ZGQ2MDg3MTI2Y2UxOTViNGE5YmI3ODRjYjNlNmZhYmZkYmNhMTlhZDM2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(242, '5952354-euMJk6uxkZa7CT1I', 'Garden Gnome (Android)', '', NULL, 14.13, 'https://notik.me/api-redirect?token=eyJpdiI6IlpKMkZFbnJxQUVYZUQ0VVN1UGlrVVE9PSIsInZhbHVlIjoiQ3piL0lNdFZCY3Nud3pyUWNITkswRSswQnRLNHNPeWdyOGtNcFpna2dWeUlOM0d3Qm1hQy8rUzdvbHRiVWVsSlhBVTFJOW9lME9QM09jU2VyU3ArcE5BNk9xbDdpUjJ4aVZGd1dVVzlKdk9hSVBOV2ZBZ05HRnBOK1YyNkY1YWpJVytENDN0SXRxSHJRc2wyZVBCalRNU0NSb1l4dmZzTXBaRkdqR004SE1Hdkp4T3VBaHd3cVI5TzBXVFN0cWtiaEg5U3JpZ0tOcHFxS2pHRllBVHFIWVpURkx1eE1USVZVYkJYN0QrLzlrTFZMajFPQ1dNRldXY2hwaExsckJPM1oyT3Yxb2VYd1JUejZUakY4cE9icDhNM0dKNHNHUVJNMWlLK1A4OWFjdUlaVFQ4Q3h4TFBMbVc2cUxGT3lmdi9nVmtPTHVLZXRUejhUenFDS2ZhUkh3PT0iLCJtYWMiOiJkMTJkMTkyNmY1MDFkODAxYTQ3Mzg0MmNjMDk4YjNiYTk1NDM1NTc4ZjEyN2Q4M2Q5YmM3ZWQxNzlkOTNhYzkwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, GB, JP, KR', '[{\"id\":3897,\"name\":\"GGN Player Reached 150 Height Level\",\"payout\":0.0705},{\"id\":3898,\"name\":\"GGN Player Reached 400 Height Level\\t\",\"payout\":0.156},{\"id\":3899,\"name\":\"GGN Player Reached 600 Height Level\\t\",\"payout\":1.95},{\"id\":3900,\"name\":\"GGN Player Reached 900 Height Level\\t\",\"payout\":3.93},{\"id\":3901,\"name\":\"GGN Player Reached 1200 Height Level\\t\",\"payout\":8.022}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(243, '5952355-euMJk6uxkZa7CT1I', 'Garden Gnome (Android)', '', NULL, 8.48, 'https://notik.me/api-redirect?token=eyJpdiI6InBGRG9VOFVVdkJKWFo4S2lFdVl1TWc9PSIsInZhbHVlIjoiMzhpTlZIRlNwQTZWcDFDb3JPUWhtZG1mUHh5dE1OU09HajBKQjBHbGVQRGVxbW9QaERRbWdvRE9YVG9WS1RCU1UydjhpajdJNTAxNDg5MXBjZFg3UVdGR2hsL040NldJTlA2am5hV0N0OFBSajk1N1FZQjNpNlhQUlVHdkZ3VVF2NHFCd1lSY20xVGFTamFWc0N0aTNRQ05hTFVnSGE1emJ5ODgrdnJoWkcvRm1NcUZrUHBFRmJYVjZnNGU2ZTVZWjNwM21XR2FJQUdPNCtuOXZhUGJTRi9pQmlTSCtMMjg1SVpadjRmRUZacDd6QXVwWjhRanFHZ3RFZ1FDWHNUZXJJaUZoMmNlc2N3NDFRTHpUY1k3dytkWVcxQTFMS2VCeEtKMDMrZlVNMXJDdzRReGFJTW1vNWRuYWZteGNPanJWYWRoUVRML3ZxbzdiS2xUZFFFMGlRPT0iLCJtYWMiOiI0NjkzNzU2YTkyOGIwOGMxYWZhMjYwNjQzOTc2NzYxYzI1MjNmM2Y3Y2ViOTBhOTQ3MmI0MDIwZGQwMjJkYjY1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, AU, ES, FI, IT, NZ', '[{\"id\":3897,\"name\":\"GGN Player Reached 150 Height Level\",\"payout\":0.0415},{\"id\":3898,\"name\":\"GGN Player Reached 400 Height Level\\t\",\"payout\":0.0935},{\"id\":3899,\"name\":\"GGN Player Reached 600 Height Level\\t\",\"payout\":1.17},{\"id\":3900,\"name\":\"GGN Player Reached 900 Height Level\\t\",\"payout\":2.358},{\"id\":3901,\"name\":\"GGN Player Reached 1200 Height Level\\t\",\"payout\":4.814}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(244, '5952356-euMJk6uxkZa7CT1I', 'Garden Gnome (Android)', '', NULL, 5.51, 'https://notik.me/api-redirect?token=eyJpdiI6IlJ3TFFRMjdiaEUrVTFDK2JUUTZqc2c9PSIsInZhbHVlIjoiWEpJcXpYaTRBSVdqN0huc3NhYU1lYTdVMjh1emR6eXBYRU5kTWlqWHpudXNhaE1CVnBVSHBiUzhhSk1DbnpYbGd0eHo4dFd0d3Y1dGdzZTBRMlpoRnhIKzlYa0daVlJYR0JoZnhUK2dmUEdtQkZPVTQybGVBWUFzWHJIU3VZTEUzc08xUTVjSUxFZkV5R1VhbklLRkExdzRwcEFWdllLYWlhcUJXS051QlRBL0U1VG50Y2hGZm9mbHhaaWtqdkc4R1BHNkUxRkdhbkw5ekZQeVJEZkZqTUVFVG5lcnphS1l1cy9zak1HRXRrZHcwTm9VTDk1V29rcCtGc1dsVDk4NkY5ODYxMG9oR3hxeENPZEtlS1FaV1pDS2RkYi9Vb3E3cXpQaVYrS2VzZXFuN3kyM1lYUnpPN0NIaTVtREVJdS8zK1UyNHVkMXpiaWNIZWVxM1ZkZlNRPT0iLCJtYWMiOiI4MjU0MjE5MjRmYzg4NWYyNTMwZDdkOGI5MmM4ZGYyNjI4YWQ5ZGFjZDg5NjMxZjcxMDlkYTIwMWUwM2JhM2YwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BR, MX, TR', '[{\"id\":3897,\"name\":\"GGN Player Reached 150 Height Level\",\"payout\":0.026},{\"id\":3898,\"name\":\"GGN Player Reached 400 Height Level\\t\",\"payout\":0.057},{\"id\":3899,\"name\":\"GGN Player Reached 600 Height Level\\t\",\"payout\":0.702},{\"id\":3900,\"name\":\"GGN Player Reached 900 Height Level\\t\",\"payout\":1.8385},{\"id\":3901,\"name\":\"GGN Player Reached 1200 Height Level\\t\",\"payout\":2.888}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(245, '5952357-euMJk6uxkZa7CT1I', 'Garden Gnome (Android)', '', NULL, 3.31, 'https://notik.me/api-redirect?token=eyJpdiI6Imo5MjRSYldRYUQ2MnV5aVZ1MEN2d0E9PSIsInZhbHVlIjoiLzU2TDF0c0RUTGVtb2NKRnBGNTBLWmkzUWhENWIzUzdNcldWZXNGVktHaDV6LzljV3M3V2xKaUxNKzhLNVV0S1kxSkdrQzAyZG95MkU1SzZ3bTRFeVRTRnVJeUpGaWxyS01ZYmJBQlRPTzNLa2hCdTFxdlBINlZYRjRzQVpQSDREbjFpK2pHOWRoZy9YTTcrekVXRmFLUUVlb0VWYWRyRU5OZ2FHbVA3ZFlhQzM1N0JDMnZkdm1tUTRRYmdUUGhMT1JjSGc2bEpBaXh5V2Vhc2hwdkIwQkFRaFBIN0NwNFR2VFdLVDNLTjhrWUF4Ykh0eXhaRVp5QXRtRTdMM3hZcEpyYy95dVlmS0VjYVFMdk1PZGVXZmpvSnB5WUZEVW9wbUdHUURVbVVBODlNa25kbWNKQ0RuclNJQVdaUmVwNU4za1BhQ21FZzBNZzI4VWp3NkFvM1ZRPT0iLCJtYWMiOiIwODY3ZjdhYjlmZTcxNTVlMjliOTMxNDc5ZjU2MmRjZDEyM2MxYzY1YjhiZmE5YWVkZTM2NmM5MjYwMTUxY2I3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AD, AF, AG, AI, AL, AM, CW, AO, AQ, AS, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, ET, FJ, FK, FM, FO, FR, SX, GA, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, JM, JO, KE, KG, KH, KI, KM, KN, KP, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TM, TN, TO, TL, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, XK, YE, YT, RS, ZA, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[{\"id\":3897,\"name\":\"GGN Player Reached 150 Height Level\",\"payout\":0.0155},{\"id\":3898,\"name\":\"GGN Player Reached 400 Height Level\\t\",\"payout\":0.034},{\"id\":3899,\"name\":\"GGN Player Reached 600 Height Level\\t\",\"payout\":0.421},{\"id\":3900,\"name\":\"GGN Player Reached 900 Height Level\\t\",\"payout\":1.1025},{\"id\":3901,\"name\":\"GGN Player Reached 1200 Height Level\\t\",\"payout\":1.732}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(246, '1126576-lZ2kToJFfVYWxuk6', 'Smash Party', '', NULL, 31.45, 'https://notik.me/api-redirect?token=eyJpdiI6IndHZUcrTHNKbHYwWjFid0ZjU1A3VXc9PSIsInZhbHVlIjoiM0VyaW8xdUhoRm94OG1OTCt1RnVqbUFhM1RXTEFVZ0tIeitBRjdIWTJhcS9ES0c4MmVpS2t0UlJ3c0hTNU5mY0dmVGJsSFdmTldxREowN2xBV1F4OGZBQnlPUkZOcGVBV3BUc2ZvT0lSYWZ4bnVYOWExQUdOY21rdTg3Tzl6TVJRYXZ0QkpxUXR3L1hUa0xUN2ZibTlldDljaGRmcTRYRGRBdmdTUEdtVmJ3TGFUTWtBNkVVdjdGMmZTSnN1SFBxT0tYT3VTN0pLekxqNXFuZFZCeUN2clY1d3BFd3VPa2g4anNDczQ2SjlHMjhxTVcvWkFSTWxKTGNYSThyeU12YkVzNjR2NzVxcDFFQ2o1bUc0aW1qK3c9PSIsIm1hYyI6IjkxYmNjMTM3OGQ5NWZiNWEzMGQ5OTNjYWZlMWM1NzMxZjljNGQzNDE3ZmRjYWM0MDliMWNmZDc0N2ZmZDlkNjkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"05fc84b0-ead4-11ee-baff-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"05fca59e-ead4-11ee-a5cd-069eb31df495\",\"name\":\"World 1\",\"payout\":0.028},{\"id\":\"05fcae40-ead4-11ee-94bc-069eb31df495\",\"name\":\"World 2\",\"payout\":0.06},{\"id\":\"05fcb6e2-ead4-11ee-84a7-069eb31df495\",\"name\":\"World 3\",\"payout\":0},{\"id\":\"05fcbebc-ead4-11ee-aa12-069eb31df495\",\"name\":\"World 4\",\"payout\":0.12},{\"id\":\"05fcc68c-ead4-11ee-a4fe-069eb31df495\",\"name\":\"World 5\",\"payout\":0.376},{\"id\":\"05fcce66-ead4-11ee-bc80-069eb31df495\",\"name\":\"World 6\",\"payout\":0.6},{\"id\":\"05fcd668-ead4-11ee-aaa8-069eb31df495\",\"name\":\"World 7\",\"payout\":0.912},{\"id\":\"05fcde9c-ead4-11ee-b3e4-069eb31df495\",\"name\":\"World 8\",\"payout\":3.84},{\"id\":\"05fce702-ead4-11ee-a172-069eb31df495\",\"name\":\"Hard World 8\",\"payout\":6},{\"id\":\"05fcef7c-ead4-11ee-a7e4-069eb31df495\",\"name\":\"Complete Game\",\"payout\":19.2},{\"id\":\"05fcf864-ead4-11ee-a9d9-069eb31df495\",\"name\":\"Purchase Value Pack\",\"payout\":0.312},{\"id\":\"1ae8bcac-e31e-11ef-b85a-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(247, '979956-lZ2kToJFfVYWxuk6', 'TriPeaks Solitaire Deluxe 2', '', NULL, 4.51, 'https://notik.me/api-redirect?token=eyJpdiI6InFNK3U3M092UE5Jc3dIQ24vOGpqU1E9PSIsInZhbHVlIjoiK1d5VWFma2JmMVFoOWcvZG1rVk1tMHdxeE9uWUlFRi9hNlpBS2taRFV2UmhqaC80dTF0SWZTNy8xakFpY1M3b2p2Z1FFcitvVm5Tbzk0dWloS0hvemV3TURyRTlHS3FtZ2hIc0xwcElucHRyRHcvRWhGT01KbWFWRnhPN3NHWUE3aXpGWVFIVFZlZzhrRXpmVGFIYU5yZk1CRjZseElPY0k2UWViZkIwV0NrQmJQSmJBdXdzS3k2VHFqT0FMTWZyMElnNHBYUXRBTVQ0dHludEJ3RE4wR0ZOWkdXQXFTVnhHRi9vRnF1SVdZNWxQL1piSUNqdFIwOVlZbjRBdGkyZTE1WEUwc3B6UWFpOE9qWXNGcnJaT2xrT1hkeHpIYUVIYmlGTHRoUnh5LzQ9IiwibWFjIjoiZWMwMmI2NjljM2VlOTFlNjE3N2ZhYzY1ZDhiNGY2NThjY2UxMGQxNzJhYjMzOTI1YTRiODdhMjc1OGJmNDMwYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE', '[{\"id\":\"375786fa-a415-11ee-9e2f-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"375790a0-a415-11ee-a365-069eb31df495\",\"name\":\"Reach Level 11\",\"payout\":0.192},{\"id\":\"375797e4-a415-11ee-abb7-069eb31df495\",\"name\":\"Reach Level 26\",\"payout\":0.72},{\"id\":\"3757a02c-a415-11ee-919e-069eb31df495\",\"name\":\"Reach Level 51\",\"payout\":1.2},{\"id\":\"3757a766-a415-11ee-905e-069eb31df495\",\"name\":\"Reach Level 76\",\"payout\":2.4},{\"id\":\"465c116c-e329-11ef-834a-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(248, '1157682-lZ2kToJFfVYWxuk6', 'Survivor Island', '', NULL, 13.00, 'https://notik.me/api-redirect?token=eyJpdiI6IjFGaW1wOWYrSk12WGo5bjh0Q2tKQ0E9PSIsInZhbHVlIjoiSUhFOVBrb2tkSFNmUnBQd0JnY2lDcUQvL3F6UWE4R1pXc3o1alVMcWZKY28rRUFFQXN1ZHR2QWJ4K1Avdis0Yk80RVpPVzN6UFpsbXFETW1JMkRIV0s5R0ZlMUYxMTlSNkE2eU8zRlpudWRNV3U0UXRKMkRUNXZXSTZjOWNCbzNUZFNpem1SNmZpcjU1WU82dTV3UjNKRm1USkZ5NElMVGMvaXBjaXFVeW1NNHBTVEpWcisxcVhkdFpZNTNzVEhwNjZZTDlmWjNGQ0xnTEdoeXlWQmMvR0hqR0QrWWpwNjJjdTljcVBhQjNzWlVxejExWmtGUU5XYURHbEhsbUZkc08zNjZCK3oyMENYVmFwVlg2Z1dZQ1E9PSIsIm1hYyI6IjMyZTU2ODczNzY1MTVhOWZjNjM2YjZkNGFmMzA5NjBjYjczMjYzZTlmM2E4MDc2MDU2MDc1Zjc2YWM0MmIxZmMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"99677fb4-2384-11ef-bdb6-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"99678950-2384-11ef-8c46-069eb31df495\",\"name\":\"Unlock Ship Level 4 in Mist Island\",\"payout\":0.2},{\"id\":\"996790ee-2384-11ef-aa57-069eb31df495\",\"name\":\"Unlock Ship Level 8 in Mist Island\",\"payout\":0.8},{\"id\":\"99679864-2384-11ef-98bd-069eb31df495\",\"name\":\"Unlock Ship Level 3 in Ice Island\",\"payout\":0.8},{\"id\":\"99679ff8-2384-11ef-9180-069eb31df495\",\"name\":\"Unlock Ship Level 9 in Ice Island\",\"payout\":3.2},{\"id\":\"9967a796-2384-11ef-83dc-069eb31df495\",\"name\":\"Unlock Ship Level 8 in Sandstorm Island\",\"payout\":8},{\"id\":\"41a49db8-e317-11ef-80d3-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(249, '1156325-lZ2kToJFfVYWxuk6', 'Legendary Hero Classic Slots', '', NULL, 38.20, 'https://notik.me/api-redirect?token=eyJpdiI6IndBVFZlcEpONFNtTHlkTmo1cklETFE9PSIsInZhbHVlIjoicExJdjFCZCtMbDgwVG1BNlBvVDNRaExiWk41ckZ6Z2Vkb3JzbWZwYS8yZXk2VGZIVXZJZUtSRlI0dXlleERkeW9ldHZkMlorcnJOWlEyTHc4dXZBTU95Ulh6SmwxUUQwQTluMGF6MWFmcTl0bE5hbFVHRlQzZHBsNDhQQ2FyYk5vMUtKVThIelN1WGRjdUtOLzNwcmVBRzU5RjZkOGxkbEgvRURGNDArOTdGMjFpNXZBM0w3cE1FWE5xWkttU3VhTHE0WnFCUUtnSWoyWXZtRVRPai9maVIzNG9rTXVzYkk4VnZ3MzB4dlRXU1N0ZlBUS0c1a2MvUDA1T0dCTmdtMnI4YzRwdU80TFBXNnJ6S0RaWVdmMkcwZGlFQ3hocWxYMmNZbmMyME1qUmM9IiwibWFjIjoiNjZhZjUzM2YwNGNjNGQ3OWMwNTcyNzFmNTU4YTFkZDJhMmM0MDk2MGIzN2FmYzVlNGFjYzE3ZDMzNTA3NTEzNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"208b7dec-0184-11ef-af8c-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"208b8954-0184-11ef-bfc4-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":0.2},{\"id\":\"208b917e-0184-11ef-9d0a-069eb31df495\",\"name\":\"Reach Level 100\",\"payout\":0.4},{\"id\":\"208b9930-0184-11ef-a72e-069eb31df495\",\"name\":\"Purchase Mission Pass\",\"payout\":0.4},{\"id\":\"208ba0f6-0184-11ef-9b03-069eb31df495\",\"name\":\"Reach Level 200\",\"payout\":1.2},{\"id\":\"208ba8c6-0184-11ef-a71e-069eb31df495\",\"name\":\"Reach Level 500\",\"payout\":3.2},{\"id\":\"02f14638-cf90-11ef-83be-069eb31df495\",\"name\":\"Accumulated Purchase $9.99\",\"payout\":3.6},{\"id\":\"729a616a-a149-11ef-a1ce-069eb31df495\",\"name\":\"Reach Level 800\",\"payout\":9.6},{\"id\":\"208bb0b4-0184-11ef-82b9-069eb31df495\",\"name\":\"Reach Level 1000\",\"payout\":5.6},{\"id\":\"208bb8c0-0184-11ef-af99-069eb31df495\",\"name\":\"Reach Level 2000\",\"payout\":14},{\"id\":\"3a81a016-e2ff-11ef-9a39-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03');
INSERT INTO `offers` VALUES
(250, '698522-lZ2kToJFfVYWxuk6', 'Earn Money Playing Games', '', NULL, 41.00, 'https://notik.me/api-redirect?token=eyJpdiI6IlFzaHMxZmUxTHo2VmdOL25HMkIwbHc9PSIsInZhbHVlIjoiTkJvQkYvWllLTnBTWXBpakZPNGhqamtUOVFxcmtvcmpxSHNYYks1RnBHQnhhblorS2JaNk1hRnlnNE1rZ0I1djNMOS9DZHdLZVlWc3lnTnc2R25NazFicGZKOXZ2elNDbGU1cU4xN2VJYTVhY3AwWk9MN1BWSEZmbE9JaUNwZGtyNXNlWkJ4bUV3cXR6eFZmMFhSOW1XY2diL2p2QTlRbmxhazdmZzFEOVVyR1JiUitNTHphdmJHWSttcGxUKzl1SmJTWmthZzhnRExMaFF1NDlIOHpTSGVraHBqT0NUbzVUWDNWY1M3YjNSUU53QXJKeUpuWXhxRHVldVI5T2lIZWtSUFlweCtTQUVWMUxOMWpmaVBmVGJGWkNTZDN3anJPWTdrNTIrc3BIU2c9IiwibWFjIjoiMzkzYzYyYWZmNTM4ZDc3NjcwY2ZmYjQ2N2ViOGFkODhlNDgzNDI4MjQ2YWE2ZDE1MWRlNjhjYzdiNzYyNDFiZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"30e56b3f-a11c-42f7-8cf1-007cc99dbd9a\",\"name\":\"Start 3 Offers.\",\"payout\":1.4},{\"id\":\"ef6f7db5-d027-4644-b565-8db5c78e46f2\",\"name\":\"Sign Up And Confirm Email\",\"payout\":0.4},{\"id\":\"60d80654-a47b-48f1-9e5f-a4739e7b234d\",\"name\":\"Make your first withdrawal of 2000 coins or more ($2.00+).\",\"payout\":16.8},{\"id\":\"777e4583-b82e-4b4f-bd22-cc40228a82cd\",\"name\":\"Withdraw an additional 10,000 coins.\",\"payout\":22.4}]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(251, '1157853-lZ2kToJFfVYWxuk6', 'Paramount+', '', NULL, 1.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjJrWVFCT1dCalF0azRnWTNkdUVDK3c9PSIsInZhbHVlIjoic1U4M090eTVlK0VWQnViWmY3K0M2K3dPdXNRSi9iZmJRZHhVR3NmNm5LMTBHdDhscHdkTkpmOTA3MkR2UXl0aFF1amV6cnRsbG1Pak5xeHRyMGNYc05PbXpjU3AvSW5BZmxJaVpDcENXTTd1cWYxN0pwOTlVMEEvYzU0NmhqVUI0OEJTY2lzZXpYSXVYK0VNSUpWMlpxWmpZaW51L3hwanNwdmp1SzMzUmh5WFd4WjQ2V1VWUXp6VkZUME5ud1lUMGc4eHpFaWNnTWpjbVA1bTFrWTlZcUpqQkZxQWVzSHIrVWg5L3JMMnJVMkhiQmtlc0p5KzNsY1NLamdCVGdnRUhjbFdqWG4rNkRZR2FUd0FUOHViS1E9PSIsIm1hYyI6IjlhM2NhN2ZmNzFlNmFiMzA0YTg0YTJkODBkODQ4ODFhZjNmN2I5MDUxOTAyNjg4NjRjYzYxODY5NDA5ZjlkNjEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(252, '1150397-lZ2kToJFfVYWxuk6', 'Monopoly GO!', '', NULL, 98.80, 'https://notik.me/api-redirect?token=eyJpdiI6IjhPdmpkVGFnaThac3lEMW5JSTAzWkE9PSIsInZhbHVlIjoiT1RuMUF5ZkVZdEtCdENqcVorY2hlZG1HbUhsNGFXdFE3RjdIL2MyL1JZOURGYkRHcXArMG9vM28wdEpQUXRQc0JFNWVkSGlOblFDcHhCNUg0aU02WXE1STZWRjJLeFoyVmEyVXZweUNBckJDdUFNUzVHZ3hrOURXSlBiSEtwTEVWVWNVcWhwZWovRGhYYUhFZmtpd21rMEVLOGtuK2tKRUlyaERrY29LZWxFTjBDaytQWlFXSkZxK3VWWTBubzdUTFpFSkNBOFpVZTNpVms2a1g3bkgrR0VEVVhjbUVMVXNGR1lGYTFSTldVaVNqaG13MHo3VmtCQkJmV2NXdzBreEhpKzhJOExHSFdiTDE5Szg1K1JEYWc9PSIsIm1hYyI6IjBiODU5OWIwYTZmYzMzYWM3NGE2ZmRjMDVlMjhlNzk3ZTUxMDdiNjkyZDA5ZTZmMmQ2MjU5N2JhNmVlOGRlNmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'OM, QA, SA, AE', '[{\"id\":\"1c7ca7c8-f859-11ee-88f4-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"1c7cc0dc-f859-11ee-a4ad-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 19 within 2 days\",\"payout\":2.2},{\"id\":\"1c7cda22-f859-11ee-9811-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 101 within 8 days\",\"payout\":18},{\"id\":\"1c7cb1a0-f859-11ee-a1c0-069eb31df495\",\"name\":\"Reach Board 5\",\"payout\":0.2},{\"id\":\"1c7cb95c-f859-11ee-97c4-069eb31df495\",\"name\":\"Reach Board 12\",\"payout\":0.4},{\"id\":\"1c7cc9f6-f859-11ee-84f6-069eb31df495\",\"name\":\"Reach Board 42\",\"payout\":1},{\"id\":\"1c7cd1d0-f859-11ee-b854-069eb31df495\",\"name\":\"Reach Board 71\",\"payout\":2.2},{\"id\":\"9cb0cf36-0eee-11ef-a057-069eb31df495\",\"name\":\"Reach Board 126\",\"payout\":4},{\"id\":\"9cb10a14-0eee-11ef-bc0e-069eb31df495\",\"name\":\"Reach Board 176\",\"payout\":6},{\"id\":\"9cb13106-0eee-11ef-8d24-069eb31df495\",\"name\":\"Reach Board 251\",\"payout\":22},{\"id\":\"9cb15a00-0eee-11ef-b825-069eb31df495\",\"name\":\"Reach Board 301\",\"payout\":42},{\"id\":\"a2bda446-1248-11ef-baf8-069eb31df495\",\"name\":\"Make Your First Purchase\",\"payout\":0.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(253, '1156324-lZ2kToJFfVYWxuk6', 'Legendary Hero Classic Slots', '', NULL, 35.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlR6MnhyZmw4cU9EWEJsM0ZZeThMTkE9PSIsInZhbHVlIjoiTjRobXBUYTFHNi9nVjhZMGJhOWV6ckFwaUxFL2hCdGtPbi9wWmNMSTlpTnZIVi81MVVsS3g5SWtsT3c3SnlRS1NkUnhmaTR0OEtsU3JlYWR2WWJNaW4yZnJnZnRSYyttZzEvUHhEUXo4UUYzeUw5UGRnYnNFTmxHNWNPZ2ZWNVp0eUdhVHlCY0hDREpadTRkOVo1MHhvOUYyTWFvSlZMaHVXbTV3R0RDazJ2Ym9kdGxJZVZyczRMckJYbkQrL29lNnNVTW9CaC9BZU0xRzJJK1l0dUJ5bHQrS1lxbDl2ZFFvSURsdG9Uc3FrbUVRc0puZnpqd2Rrd2F3Y3NtQ1hURVZ2ODQ3LzJUa1dyOXlVM1o5eWxEdW56czFldXlkMUN5eTRnQXJaVmdMdkk9IiwibWFjIjoiZDFhM2M2MWIxOWIxODNlZjQ4ZmI5YjFlZTAxZDFlOTljODBjOTVhYjU2NWY2NjkxNTEzMzBlZDNkOWQ3ZjY0MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"fbf55ea8-0183-11ef-8c97-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"fbf56768-0183-11ef-a5ca-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":0.2},{\"id\":\"fbf56f1a-0183-11ef-9b01-069eb31df495\",\"name\":\"Reach Level 100\",\"payout\":0.4},{\"id\":\"fbf57690-0183-11ef-b42d-069eb31df495\",\"name\":\"Purchase Mission Pass\",\"payout\":0.4},{\"id\":\"fbf57e2e-0183-11ef-93d3-069eb31df495\",\"name\":\"Reach Level 200\",\"payout\":1.2},{\"id\":\"fbf585e0-0183-11ef-a150-069eb31df495\",\"name\":\"Reach Level 500\",\"payout\":3.2},{\"id\":\"ba7c91a0-cf8f-11ef-9ed0-069eb31df495\",\"name\":\"Accumulated Purchase $9.99\",\"payout\":3.6},{\"id\":\"7172ee38-a149-11ef-8f6b-069eb31df495\",\"name\":\"Reach Level 800\",\"payout\":4.8},{\"id\":\"fbf58dc4-0183-11ef-a625-069eb31df495\",\"name\":\"Reach Level 1000\",\"payout\":5.6},{\"id\":\"fbf59634-0183-11ef-88e5-069eb31df495\",\"name\":\"Reach Level 2000\",\"payout\":16},{\"id\":\"399c8be8-e2ff-11ef-b175-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(254, '1132572-lZ2kToJFfVYWxuk6', 'Paramount+', '', NULL, 1.20, 'https://notik.me/api-redirect?token=eyJpdiI6IndBRTFRSnUrN1NtQ3FGOVNyNU8ySkE9PSIsInZhbHVlIjoidEZsaFcvQ1BQWmtXV3RLQVJJR3BzMEI2YTFDUnJub2dGWVoxRjU0dlF0YkVaZGd4QlNWbENGQjhvd1NMM2czYWh2dlA2R09BNlNwdHh4OUJVTHA0QzVNUDZWQ1BIMC92UTlvcFN6amw3V3Nob1kweWMzVVpmaiswYitIYVNzMFhpaUQvdjZHVW1EOXl2N3ZETkRBdlYvZGNyMlY5M1dTenZTNC9HT3FDV3BmNUhXRGVJdkxtbVg0QjNqdXdqNXllV05zZHV2bUg4K3BDUEljSWpzWkgwV1BXdVRQMDNVakI2Q3gybUdMWDh3MDcyUkZwdjlRTzhtNXUrSUxncmY3T0daN25hYXo0c05qVWdMeTBrOWRwekE9PSIsIm1hYyI6ImFmMGM0YWUzYzBiYjI5MWFiODlmNTk1NjJjMGM5NzJiYjQ4ZTVmMjljMmRjYmIzY2NhNWNjOTlmYzQ5ZTAxMmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(255, '1157852-lZ2kToJFfVYWxuk6', 'Discovery+', '', NULL, 1.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjJlQ3ZjTyt5Z0NlRkQrcXUveTl5L2c9PSIsInZhbHVlIjoialFsRHkrZHdNcEZ6Z0hFVTFRVWpUUDBMTFFFNENMNGpSVFZrTUE3T0VGNlpJejlkcWs3TVhkcWltR0FEeWEyYk04a2JEMkh6a3FCTkpTbVg2Q0xEcUVEZ1huR0JvODNVTitsTUhWRGFaeDBGY1NKVVdYc1ZUSHh0bXZXUXJOS0RkYTlxZDVBOEdoOSs4OUZUT0R3TlZzMVNQMHVpaEdONUhmT25pam9BNEFkWFptRjZDUnRRR3VDQXdPOVBFM2cyRDBMNytlekE3OXk4THhxczM3K1ZzeFNWZ01LbW9qd2xWZ3RtUmtNNHlkeGFaQ29rTTFZODRHZVRrU1lZRURUNXlYblhUY3VaNjdPMFlTMnhJbG4vWnc9PSIsIm1hYyI6ImZhMjRkYmJiMjBlOWU4ZjU4MjhiZDc2MmNjNTVhNWY4OWY0ZjVjNWM1MzlmZWMwY2Y4OGY4Y2YyNDA3MTQxZTAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(256, '1166139-lZ2kToJFfVYWxuk6', 'Scrambly', '', NULL, 6.48, 'https://notik.me/api-redirect?token=eyJpdiI6ImZXd216bVh2RTcxVHpicUtLRTNRV3c9PSIsInZhbHVlIjoiKzhlYTByVklnQjk4WE4zYjJNK1daa1gzN0c3QU02aHVqa2R2MXRLT2tDUm44cm9raFhIaHhhSjlUOFFJM3hSYmFpSVloZC8wY2NlOTFqYTdqYzNPVkJGc29EYXllbkVlQVFNUlhBcXdRakhnVWtaRXFFczdrV294L29GbTJkckM4SmRQWm14RXJzTjlIUVFuZWgzWVh1Q1BmcGJiUEdIak5CekNMV0lJNXlGN09maEUwem8rZWh0WVoraFhUVDJQTXAvRU1ORU9mV0Q1a3FvOVNJY1ErOCtDWTVDMHNQSTg2VFpGV0RlbE9DbjdHb0lQYWMzb0M3REYybHMzY0RmQ0paaTV4T1VOUXpJTEhoZlh4OXFOZGc9PSIsIm1hYyI6IjBjNzRhMjk4NGMyNzJlMTVkZThjNjU0ZmJmNmJiYTRmZTRmZjZmN2ViYTgwMTNkOWY5MTdhMTMxMWQ4YTQ4ZTgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"e572319c-2f3c-11ef-b9bd-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"e5723a66-2f3c-11ef-a1e8-069eb31df495\",\"name\":\"Sign Up\",\"payout\":0.96},{\"id\":\"e5724218-2f3c-11ef-a8ab-069eb31df495\",\"name\":\"First Withdrawal\",\"payout\":1.92},{\"id\":\"e5724998-2f3c-11ef-977a-069eb31df495\",\"name\":\"Second Withdrawal\",\"payout\":3.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(257, '1157460-lZ2kToJFfVYWxuk6', 'Stamps.com', '', NULL, 1.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImliT1lOSTBIbE14WDA5MW1QQXNtMEE9PSIsInZhbHVlIjoiN1ZTbVNZcHB5aGNvTVZDZFFiVlQ1ZkFXNnVlSk1Ra0xTWnVXNFEwaENBM2krSnJFMHFmUFdjS2tKTDRZNU9wand6RzhNMHVyOU9XUEFqK3BwV2k1N2x1Nkd1ZjlqaGNWZmxaaHhCR1hxZ2pFV3NIM3BDbFdPZ1hDV0Z4OXJBd1YwSjd4OHdEaHR6WlE1dVM4QVdJL0ZZWkxZczVUZFFNNXI0djcreUJHYXJMdVNES2tHMXMxejQ3Y1dHWXJZQm5SVjkxZXY0S3FOeCsyc3hzaDNyNmZpM2dRa3ZKcHNkZGVoSkhNdnBEeklRajMrdm83S0U4Vjh4N1o2UncyZGZpNzlhUFJQVW5BaU9ZMDFza1o0bXpGMFE9PSIsIm1hYyI6IjhiN2FjNzZiNzU5OTczNTI3MTljYjVmZDgyMmNkOTNkZTEzYmJhNWNlZDczZDUyZmJkMzZiNGZiODRjMmJlOWYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(258, '808545-lZ2kToJFfVYWxuk6', 'Monopoly Go!', '', NULL, 104.58, 'https://notik.me/api-redirect?token=eyJpdiI6Ikh2RjEwaXY4Q1UyRFJzei8xdmtCK1E9PSIsInZhbHVlIjoiVnh0dW5tRENpZGZ2ay9UZUJjRmJRZ0FBdVdadUtVM0c2ZWZBZ3Q2Z1VlTDBWR2I5bkQvL24zZ2NnMS85Z2dJWVRxbTlISEw4ZW1vNWVlUU9qNlE1YVNoZ0FQU2szQWx6VXNRVlZyYStWWEZsNGZxdSt3Z1VQbktibDVwelBORWpRaFVLMW04dHlIQmhaQW9RMllyVG1scjJCZWQvQm1nL0FuVHhXRGZ1KzdQOVUzeTlWbDRubCtrb0UyK2xBeDJJMzczMjRpV0k5c0IrdVU3Tkp5VHFUaUdQZk1DSXQ0YldhZ2ZZQ0J2MFZNL01BakRWT3dMTzlabkEwWEErd2hjdFM5ZFlDUTVGVkhUZUE5aGgrcWJDbFZqajhqbUVtNTNpQ2VVU1hmd0Y3YU09IiwibWFjIjoiODgwNmUyMDVlNjRmYWQ2YjI4OGM1ZjhjOGY0NzcwYWMyN2EzZjViNmYwMjU3MjQzYjIxOGMzOGIzYTI3NjUxOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, FO, FI, FR, MT, MC, NL, NO, SM, SJ, AX, IM', '[{\"id\":\"5c3214e8-7a6e-11ee-86da-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"5c324242-7a6e-11ee-8bcc-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 19 within 2 days\",\"payout\":1.228},{\"id\":\"5c3257a0-7a6e-11ee-b4c5-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 101 within 8 days\",\"payout\":19.536},{\"id\":\"5c323338-7a6e-11ee-97d0-069eb31df495\",\"name\":\"Reach Board 5\",\"payout\":0.424},{\"id\":\"5c323b44-7a6e-11ee-b220-069eb31df495\",\"name\":\"Reach Board 12\",\"payout\":0.82},{\"id\":\"5c32494a-7a6e-11ee-be20-069eb31df495\",\"name\":\"Reach Board 42\",\"payout\":1.964},{\"id\":\"5c32505c-7a6e-11ee-8882-069eb31df495\",\"name\":\"Reach Board 71\",\"payout\":5.004},{\"id\":\"021db8fa-0c9e-11ef-8149-069eb31df495\",\"name\":\"Reach Board 126\",\"payout\":4.8},{\"id\":\"021df5f4-0c9e-11ef-b68d-069eb31df495\",\"name\":\"Reach Board 176\",\"payout\":6.4},{\"id\":\"021e231c-0c9e-11ef-a18c-069eb31df495\",\"name\":\"Reach Board 251\",\"payout\":22},{\"id\":\"021e4e28-0c9e-11ef-a8db-069eb31df495\",\"name\":\"Reach Board 301\",\"payout\":42},{\"id\":\"a8ef98ca-dda9-11ee-b807-069eb31df495\",\"name\":\"Any Purchase (1 per day, max 5 total)\",\"payout\":0.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(259, '698523-lZ2kToJFfVYWxuk6', 'Complete offers | Withdraw $2.00', '', NULL, 29.40, 'https://notik.me/api-redirect?token=eyJpdiI6IkFOYzRUdXBvbU9TYUk1Umo2SkVMVFE9PSIsInZhbHVlIjoicUtUWjhqenNoVXJNaVRrYzBqbDNsdmhhamwrZklFNTE2UWV5aXZWZzRXekxyTzlGcUc4VGdkZmN3M0F1QmloMW80bGQrc0lwRzM4OG1Sa1FzOXRzSGl3M2ZHejY0Q3NxV0ZQS0daTHloN0ZmNlNJTjN5Y2taaE5zYnB6M3BFenhjaTd1MHFuOVZ0eEV3dTRMaHFtQy82bXFWVFZNWS9WZjFRaHVaTFZCK3AvSUZ2eVhZeENVaU9vcnlGNDVIZzA1bkNIVy9WLzc4UjNJSDNZeWZqME1TbU9yNFJZenNDcGZLcEhaUTU0bTVXZ1ZBN29UczhGN1pTUzFtVEVoM3kxLzFPWnRFelA0Y3NqQ3JxVlAwYXNpWmlSL2Q2ZndmYUpqZ2ZKRUVuOVkveHc9IiwibWFjIjoiNGVmM2MzYzMzOThhMmJlZDE1MWIxZTQxOWMwM2IzNDNhZGViYmNmMWQ5MzA5M2QwNzMxNWNiMDkxNjc2ZjI3MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, AT, FR, DE, IT, JP, KR, NL, CH, GB', '[{\"id\":\"550ff9fd-b4bf-48e6-8c51-564718c906df\",\"name\":\"Start 3 Offers.\",\"payout\":1.4},{\"id\":\"edef1e7f-e805-4b23-9b21-13ba4f33dce7\",\"name\":\"Make your first withdrawal of 2000 coins or more ($2.00+).\",\"payout\":11.2},{\"id\":\"1719ec2e-ded7-4656-9057-05904a164824\",\"name\":\"Withdraw an additional 10,000 coins.\",\"payout\":16.8}]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(260, '1078419-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 8.59, 'https://notik.me/api-redirect?token=eyJpdiI6Im9xNHM2WnZQYVN0bTdQV05aZFlaQ1E9PSIsInZhbHVlIjoiZWRydkhqdnU5NFlYYmtDak13aVA2YWtoVGJ2NE5uWHlXZGRnMVdjZWZhWjFVTzBjNW9vN1lLNGFVVndpWTZMVU4vdjNPWGpJanEvSDBQdEY3WFdueloxejNkVTloa21EcmtXN3R2Umlpc3I5cEFXV040aUxkWS92NXJvcW9leWR1alVCV3A2M3R5Q0s2cUNVSVI4Z2ZHQ3FOdUMxYW5wZDdXZnFmS2g5Y3JWd0NKL05oNTlCb3dOSXhCZ2Jybll0OGpnRTBJYzluRFpLK2s1TWhraW8rRU9YV1hreU4ySU1XZ2lHVnM0bFBTVFUzWW5FTlcwMkVMdmpQNmxxaGE4b1o4K2Z1QU9QN0IrMFJvQTVGMEdwbW1CRSt4T0o2VG9VZnNsRXpINklIZXc9IiwibWFjIjoiN2Q3NTE4MzA0NzExOThiMWY0NGVhNTIzZmIwYTM0MTQyOTNjNzRkZWU4N2MwZDc5MjI4MWE3YmI5YzlmYmQ3NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ, GB', '[{\"id\":\"612809c7-5693-4438-944a-14ccaf5819ca\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"0c52bc3c-6b6f-4288-aa4e-a32a337dd775\",\"name\":\"Reach Level 50\",\"payout\":0.12},{\"id\":\"5ba41608-92d2-43cf-9cb2-208f4f2af691\",\"name\":\"Reach Level 100\",\"payout\":0.152},{\"id\":\"ed83f14e-5638-4c38-8e53-750ed3660cad\",\"name\":\"Reach Level 250\",\"payout\":0.56},{\"id\":\"69d38202-375a-4b03-8830-bb0b62ab370c\",\"name\":\"Reach Level 500\",\"payout\":1.12},{\"id\":\"ca113197-1ae9-42e6-8a66-a1a85288ddf3\",\"name\":\"Reach Level 1,000\",\"payout\":2.24},{\"id\":\"c5e9fd49-3d4e-426f-8cc6-4b354d4c0c51\",\"name\":\"Reach Level 2,000\",\"payout\":4.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(261, '828843-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 5.96, 'https://notik.me/api-redirect?token=eyJpdiI6InhwY0Z0VXdsMTNPeUphUDFwMXMvOGc9PSIsInZhbHVlIjoiUU14MDZvYXdjTVRqRWt5RUZSSjlWS0c4WXpIY0hRd1daZXFVQzE0YVNOckFweDVsWU9LV24xM3dldEUyMmdxQVQ2dmR0b0d1NnVNTXUzRFdoeEtvbEt4alZxVGU1QzRDc25OaEpvWW9WRllLNFdYYkszWUZzbUJEKzdNMW4zNkhoY1JNeHZQL2dRUVc5bWNqelpPdzNnMEJqclF5V2JZQkI1Um8zT1d4VHg2RGhMRHdITjY0Z0FmcVhqci9YMFJMOXBOUnZtZjMxd3JwTnB4NW1oOFZ3WlZ5bmZjSytJUDkxV0duZEdreG44Ym43OUZyWC8vckd3RXJCWFpsaGtKY1c0ODAwaEI0M3FNVDc0aWdHMmNIaitVczJHTUFNSjdnNlBPQzJ4eHJCRlU9IiwibWFjIjoiMTZiYjBmNGU2NDI5ZjFlY2Y3YjhiYWM4N2VkYjIzYjlhY2E0M2Q3MTA1OTVmNjVmZGQ0MjliZGI5MmU2Y2JhNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"9fa112ef-0f20-4009-9002-9a2967b5fb66\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"52ba0c34-c932-466c-9cae-6227b7a1dd2b\",\"name\":\"Reach Level 50\",\"payout\":0.2},{\"id\":\"f10eabc0-15c4-4f0a-940c-54a38a7dc6e7\",\"name\":\"Reach Level 100\",\"payout\":0.24},{\"id\":\"0ec8b4d9-93b3-43c7-8295-041e157ba05d\",\"name\":\"Reach Level 250\",\"payout\":0.7},{\"id\":\"e6a769dc-909d-4c56-8b63-07809f14726a\",\"name\":\"Reach Level 500\",\"payout\":1.54},{\"id\":\"b67106d8-b7b4-447d-8bdd-75ce15b9d13d\",\"name\":\"Reach Level 1,000\",\"payout\":3},{\"id\":\"d2e397b4-060c-470e-a3b7-0564ddf8291f\",\"name\":\"Make a Purchase\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(262, '1150379-lZ2kToJFfVYWxuk6', 'Bingo Holiday', '', NULL, 14.86, 'https://notik.me/api-redirect?token=eyJpdiI6IlBKTzM0dlF4WkNtMjRzZ1dEaiswN1E9PSIsInZhbHVlIjoiMThnZ0NQbnVtd3FYTjFPeE84aUNnMkpBdVI4MXJiS0ZwQzg5Q1hkNFNNN00wMGtlalNYU0o3YlE3ekNJRkVWVThCN1BHcVVHSFpkL0hzZzAyb0I3MDBuWnZjWU92QzZjOWZXQ0c0S2d2cXQ2ekdKaFZFRlpiWnNPRmtMYVlFd0J1Mmt5dXBFSldQSTFwZHBJdExMUkhDdGtaMG5IQVp4Q0tUeHFiMEYxQkM2RlRjaytHVnJ4cHdIcHdyRnZDbEFoeG9walpyYnVwdFhEU1d2RklSMUdSejVyWkxPeUxhZkpwOEw3d3R1R3E3UklVTC9iR2RqdUhlV2lOQUFCSzIvTVBsSkZMUmxkeGp3aTdyWGlzSnRRUUdSZkJWVnhLV1ZnR3B5Qm1sOVVNQjg9IiwibWFjIjoiNmM4ODc2ZGI0ZDk1Yjk5NzM5NDcwMGMzYWY4ODc2YWEwNzkxMzUxZTI0MTEyOWYzZWJkYmE4ZGU0ZjBmMzY4ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, DE, GB', '[{\"id\":\"0e1b3534-f820-11ee-957e-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"0e1b5578-f820-11ee-9931-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.192},{\"id\":\"0e1b5ef6-f820-11ee-b774-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.384},{\"id\":\"0e1b66c6-f820-11ee-909d-069eb31df495\",\"name\":\"Purchase Any $4.99 Package\",\"payout\":1.44},{\"id\":\"0e1b6e6e-f820-11ee-b5c5-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":1.56},{\"id\":\"0e1b7896-f820-11ee-9696-069eb31df495\",\"name\":\"Reach Level 40\",\"payout\":2.88},{\"id\":\"0e1b8138-f820-11ee-aecb-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":8.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(263, '1157829-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 13.16, 'https://notik.me/api-redirect?token=eyJpdiI6IkFHL1QvOEU4MFdLdXQ4NGI0STAweWc9PSIsInZhbHVlIjoiS3VaKzlkMmlPT3pVRkZsZHpCTzkxQ21SNnd0VllXTFBjVkJqaitIbk9OUmkrYmI2cHRQcXZaajQ0ZEE4VXpETXRCd0pjZXFzNHg3eXBNL00wZGRON3pSdDNlbitsZ3BUQy9TNDNUcXNkTDF6ZnAwM2dpazJ1WXFha0VsbFExUGx6ZjRkNXZib3dYYytyMWxwblY5Y3p5NDIvckZRTGF4K1ZjNXB3QVZHMjFiWXJmY2ovNTB3NkFxampPUjJldUJFVDdSenFzblFjV0FSTTZMYTdBK3lucjVqYkpzc2hNajNHOUo0aXBFUnc0S1JzeEFpellUeFl3K0hndDF0UzhZMFJrYzk3SVFnaGI2MytKL0N4aXc4clJnREVlQmVRT0lvWXdHVU1RNWZWelE9IiwibWFjIjoiNzU1OWVmMDI0OTE1Y2MzNGFjYjQ1NmNkZGNhMzk2ZmExYWE3YmFlNWQ0NjI5YjgxYzIwOGNkYzA3ZjcwM2I4ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"12366375-ef39-458f-a8e2-0ddd13e78bf7\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"6049ae3d-7463-4b10-ba2b-7f117d84a211\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.08},{\"id\":\"21b4c448-a504-4694-979f-d4a1a1bdbeec\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.4},{\"id\":\"f8fada24-adcd-4035-b978-2ebdeac96929\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.9},{\"id\":\"7ee1b1cb-a86a-4c2b-a4d8-a389e33e7649\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.7},{\"id\":\"82f2b675-b8f4-42c9-a6b2-7d71c54e6495\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.36},{\"id\":\"6983b696-eff5-45b5-821a-531107294451\",\"name\":\"Complete Hidden Level 200\",\"payout\":6.72}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(264, '1157655-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 1.04, 'https://notik.me/api-redirect?token=eyJpdiI6IkhyaFExN3lBcFJrQmpoNzRPckxyRFE9PSIsInZhbHVlIjoiQWdETGRpK3B0OTFPTHlVdWNQUDYvMml5YXJHZnNob3o2SW55MnlzQjloRFVVdzR1SzFpenY4RDlWTCtLMGhSTDd0WStncTVnaVBieUhUTWR5bFRXZkVWRUYrcW95YlYvVEFWMklSbXRjUlpQWThna2N2YzJGK0ozQ2x6VzVBTWVQbDBTdzRXZGRtbGUraTN2MUNOczh3RmFvRTJWcUh4UythdnN3WUlQbUlvNEF5b3RiL3lpQzVmd2ZpMW1aWXFpUTh0Y3k3M0ZnSVpKTjJhQktHdzh6ekdWa29xZE02U1JxWWNxWVZLOWUyN0lQR1NUaXlnSE5WaU5QcU15UXNWWnpDbjA3UTlpNnhRbGRlRkZsaDJzOGR2bm1DTjd5RUcwNVZxQkxvU0p2Ulk9IiwibWFjIjoiOGI3MjgzMDJkMmU0NjBhOWM5NGFjNWQ1ZTJkMjBkN2IwM2EyZjA2ZGJhMmI0OGQyMWI2ZGIwYmY2MDg0OGEwZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, GB', '[{\"id\":\"514a7cb4-22c0-11ef-b9d2-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"514a9e2e-22c0-11ef-9746-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.04},{\"id\":\"514aa6da-22c0-11ef-9221-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.06},{\"id\":\"514aae78-22c0-11ef-8b78-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.08},{\"id\":\"514ab602-22c0-11ef-ab74-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.14},{\"id\":\"514abdbe-22c0-11ef-b896-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.24},{\"id\":\"514ac58e-22c0-11ef-9001-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.48},{\"id\":\"59a0bc56-e319-11ef-b48d-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:03'),
(265, '1157793-lZ2kToJFfVYWxuk6', 'Amazon Prime Video ES', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6IkgwMkROZG1NM0xpSElRY01PM2xoRlE9PSIsInZhbHVlIjoicEJlMkNZRWdyQW1BTDI4Nllwc214NWRkbU5tcStIdWhpOXhpWmRSUEpvU3ZDZUw4RUxkcHRLU0lPLzRvR2dNR3dOQUpRK0M1cS95Ym1EQ2tvUm9nTDArMHJKU204WW02MW5OcTlCQkpydGJuQUg5dlZjaTFnSlIrdTQyR3p1d1FrUThBZEpqNEQxQk5DWFpBS1NOaEU2TlNZTzN2cUc3WHJvditlZWNhSEZjaEJFSmRlQVNKVjBkekZwQ3V2ckUvSWNzRGN0Zjl3aDllcGsvYk5BV09QVktGeWhPWW5DTXZkdE5aMFdpY0xqWExjc3Z3d3JlNFdPc2JjNmYxcWpWMU15Z0lUNEZrRGRhVWp5aGkya2todEhRWEVzUEFuUWEycUE5K1RWbDdnR0k9IiwibWFjIjoiZTc3YjgxNzI5OGRhZGFmZGIxODMxMmE2NTNhZWZjYTM0NDk4ZTBhZTA3MTUyM2M1ZGNkM2VmZWU5MTU0ZDAzMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(266, '1157851-lZ2kToJFfVYWxuk6', 'Paramount+', '', NULL, 1.20, 'https://notik.me/api-redirect?token=eyJpdiI6Ijc5dXpsKzFZMEYvUkx4NDBZV2NSY0E9PSIsInZhbHVlIjoiNGtKcDBrMkNMNlVEMlVWbnlNVzFvdlFNMnlrMWc2ZlBaK3A4K0U2dkVjZW8yMkx5VG80aGZaY0haNWFSVEZvQWxmMHh0aTladjBGSDd6cVd4MUlKZGY3S3VZMDZNTzRQN1lremZNTWRNWmRCYlZpak91bVhqdDE5WkdGSmtnUFl6K0QrVS83YkpsOUd1Q2VYQlEvQVBLUUhYeEpqemJneEJuNUVYWDgxRVRMckdsbVZtVmFpLzNaVlpTeXZkajVYQVBZVTgrMnV3OVM1V3hiUS9TUUlIM1RURUlmS0FnODZGWnJRSS80TEJtMUlFczZBMUJYTUJ2QUpZNjVrSHJFL0kxcWYrYytjQWlDVUtYbS92aUpkZ3c9PSIsIm1hYyI6IjQyZTZlZTdhNjNiYzJjODI1NTRkYmNkZjQ0MjdiN2E3NTBiNDRjMDk0OWJhMGQyY2IxODE1NGNlYzgwMGViZjYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(267, '943156-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 25.53, 'https://notik.me/api-redirect?token=eyJpdiI6IjVwa0Nub2hLa0xzMy9JelZBQmdUVEE9PSIsInZhbHVlIjoiVWhUbW9tTXU3OXMwS1hvVG13V0U1VGUvY05PVElQTWU1L09RWHhXWVpnVUFZSGx6dFVYS3htNDRaT1pXN0MzVEtoK1hGV2xkTy9yRGtPU0MxNzNuZFliclN5bnpyYzhPM3JTc095NXR0cGQzSTBSVVpYSnRJU2w2cTU5dUFELzVXekVpMjZuWmp0b3BTUmV2ZCtLVE5ocktxamg0ZExyK2VuOXc4TnN3dXp6ZFdVb2tBd2FQMFRFMlZRQUU0cWRPb3NiN0F0RGN6eFlJUXBWRGhkMzRsMVNOc2FUcE9HYlIrRzNIWWQ1MHZ4STdZZWNLeEpoZFhnSEFNVzA2VVRiS2J3eGF3M2RHS3JwMnhkTDJOY0xOM3pCelA2aDZUS0JWakwwZTFvT2dLRk09IiwibWFjIjoiOWE3NmM4MjVjMWE3ZTE5MWJmNDM1YzcwZWFiNWI5OWY1ZjQ3MzY5OGYyNGFhOWRhYjVkMDRiNmNjYTNkMTA4ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"889c89c0-03cd-4911-9c8a-2bdc4dd7387f\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"79ad75dd-db50-41ab-af5a-cbb3e2168f6e\",\"name\":\"Reach Step 25\",\"payout\":0.336},{\"id\":\"4df0f2fe-4d95-4dcf-8002-031f8c9d9924\",\"name\":\"Reach Step 50\",\"payout\":0.44},{\"id\":\"deb1c0ae-4dd6-4332-9f3c-7f026ee3ad87\",\"name\":\"Reach Step 100\",\"payout\":0.752},{\"id\":\"3756cf69-5242-486a-822c-3cf52e738efe\",\"name\":\"Reach Step 250\",\"payout\":3.2},{\"id\":\"fb363536-a504-41ec-b421-f7aa1d876fc0\",\"name\":\"Reach Step 500\",\"payout\":6.8},{\"id\":\"13a6f994-9218-4f3a-b64f-6b40a1b28e0e\",\"name\":\"Reach Step 1000\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(268, '1157832-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 13.26, 'https://notik.me/api-redirect?token=eyJpdiI6IjhZQktubUJuOXc0MWI3aU5vUkU2WGc9PSIsInZhbHVlIjoiVTdBcW41amF1bTYxbk8xQTNXS290aTBXZEEvQTBIVWp0RVlPVk41QlJ6cUp5M29JZ2pxS0x2YU1aSVM5eGcwR241QTBkVkh1M0w2RUR5RnZqRGJiVGZuc0l5cjVSbmU2NEVDdGpNdm9hcFZRRzNGNG1aU2VhekdRZzM3RFB5SDFPTmd4WGhQUUZGcHJBd3lkTWhGOG5HUHREV1JiTk1VQWc3ek02RG42RGdaQ0FLSGdqQ0p3dWkvYWFmQ0ZsVEd6YzB6VVZDMHgvOERHWVJrajU1Q290RlNmR2RCUU5TTkVIWHlma2VLbG1MTVgyMGhVbldjc0VBUzI1bG96TG93Q0N3RGRGKzlCclQ1TXVCRFhuYWpzSDh5VW85QW10T1VVVHFYdEVaQisrdDg9IiwibWFjIjoiODQwYTEzNzU2YzkxYWFmODNhNGNjMTVhYjNjZGU5NzdkMWU2NDE2OGI1NmU5YmVkODdhNGM5OGVlMDQ0YTU4OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, KR', '[{\"id\":\"4aad805b-4939-4e21-b08e-e8716192ae64\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"5188019c-05c7-421d-aafb-c22e46e8987f\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.4},{\"id\":\"c854816a-8cbf-4d79-bc66-83c95360cf6a\",\"name\":\"Complete Hidden Level 25\",\"payout\":1},{\"id\":\"9cbad54f-cb79-4334-bdc0-4b776d9d33cc\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.7},{\"id\":\"f3ce7272-9a87-4236-a2d0-8ea576cf349b\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.36},{\"id\":\"5fafc561-ad12-43e6-9765-2efa4e60918c\",\"name\":\"Complete Hidden Level 200\",\"payout\":6.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(269, '1157814-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 13.35, 'https://notik.me/api-redirect?token=eyJpdiI6IjN6V2lHaTdVWWF3c00wcmNWUndVM0E9PSIsInZhbHVlIjoiRnM5ZGlqVXVNYTVHUVVOT1hPMkdTQzRkS1JmaS9qajF3a2ltQnhDTHhkdjQ3WFZmaWFOSm96Wk5KVDNYMTFDWXNuWUlyTW05cFo0VndSUDhJd00rSVdrVExUUUExN3BwSGhKbVp1WVBkNGZpMjhuRUExbU1ZanpkQ01wendSUXRBMEVWQmJzZDhEZ0hyT2N6TThsZG9rWFJVYlpSSExlUXFJVm5iWGdvbE51UERIa21FclNHVHgrOFN1ZEMrRUhxVjR2c2l3VGhmNHc0SThUMjkzdVR0d3d2UFpXTmlwM2dIMnhkWStjVFlpZFBpcTRHWEFoOTZUNGd1ZmtSN1oxYVZ6Q3ZRNXgyRzlLaGptZ2xGVjU3ejhrUG0zTGExVy9WQS9IbXlXVGVmUXR1N2wxRWIwYzQ0ZS9nMVJlSlFZRUwiLCJtYWMiOiI1ZWVhZjM4MTJhNzJhNzM4MGYyNGUyMjkxYmQzNGY3YTQxOWNjYWYwYTQ2MmRmNTk1NDRiM2FmZWY5ZDA2NWVmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"4176d653-162e-4227-8a61-3daa0dc6adab\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"ed479a58-b2b4-4a22-84d4-e691c7462889\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.088},{\"id\":\"5d8b4ea5-d6d5-4de9-af92-16153dafd6f7\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.4},{\"id\":\"2aefce08-f6cc-4142-88c3-884256912b7a\",\"name\":\"Complete Hidden Level 25\",\"payout\":1},{\"id\":\"ed9be9cc-715f-4458-9b32-5ceee3fd096d\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.7},{\"id\":\"e12e6db0-d719-4c68-a5fb-890de7c17bac\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.36},{\"id\":\"9d48b5c0-2253-443c-803b-d6633fb34c69\",\"name\":\"Complete Hidden Level 200\",\"payout\":6.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(270, '414028-lZ2kToJFfVYWxuk6', 'Up Level Rewards - Walmart', '', NULL, 10.80, 'https://notik.me/api-redirect?token=eyJpdiI6InVUTHpJc2RCSmVhZEpMRXlmNHh1VlE9PSIsInZhbHVlIjoicE0xM1VnamdISW1TWHkzQkxzVXIyby80YldPSEZSR29kZFFEU2lYSFlhMmJoTVJvNk9tTEM1YThwT1Fxc0Z6ZjFZcXRwNUhVTGtzZm5qVE5PcGNwS0hMNkdFYUk3V1hSSll3V2lCMTkvTjJJSm1VNmE3WW9FUUF3UUxBRFJFdnBLbDNqVnIzTklMK21Hdko4TGFQSHJ3cFY1cVlGZ2FyWkpWQy9hN0R3bVhtalRxM01RSWwveHRUbnoxcmFxN2J5UFRiR1hzdHVueUtHQkRkcElwejFVMjRlekFicW1xYnZMNU1QM2JLeldBbFd4M2dqT1FYNDR1SVhqVFZXblNsVkpKZitmMkFocThEelNPQmVmL0wrYi9EWFFUQnhQK3B3N2dsRm43ZnVZTHc9IiwibWFjIjoiZGU0ZGRhYzczMmU0YjY5OGJhZWRlNzlhMGNmOTgxYTk4ZTQzMzc2ODkyODE3YTUyYThlNTBhNjQxZDU4MDk2MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"2187e730-bd1a-11ed-b01f-06a99418fcc3\",\"name\":\"Walmart $1000 Gift Card Level 1\",\"payout\":4.8},{\"id\":\"dc6de066-beba-11ee-81c7-069eb31df495\",\"name\":\"Walmart $1000 Gift Card Level 2\",\"payout\":6}]', 'all', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(271, '1162231-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 11.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjdDY21ET3JldGx0a0hYcmhOa0NrbkE9PSIsInZhbHVlIjoiMXZWTWJERHoxK2RoaHVTd2xYRy9CTnVFUVAvdGFMNVAxM0JHUW1lclplM1pFYTRxNWdYKzEzN3dNYlU0SHRrVWN2YTJwM241NGZCWExmb2xERytmd3dWMTdLRVhhb0x5RE5vNkhyWGY3N1VSbEFOK2hPL2s2M3YyLzVhSGdZL2lzcFJHMWRPbFdGSHlOM2QvYVMzaE11RU1PbW96cDExb05tYTlhb0hWdGcvRFpDK2VkWlBoZ01rUTJFVGY4TFFSb1I4anJUVTBkb3NKWEFkS3AyZWUxS0tPT0tabFhwRG9aUk9wYzJvNFFXVW1DS2ZBbVlvK0pYNjJSMU41cGtjNjIwaTZRNFVHakVZRWFRcXROUlpOWjI1bi83c3pDRnd0Z0hHTzYvRDYxaDg9IiwibWFjIjoiNTIzZjY5ZWVhNWU3ZTJjNzFmNTcxNWIyNzgzZTlhNjRhZTk1YTRlMjYxMzliM2UwMjI2NGJmZTUzMTk5NTgzNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ, SG, GB', '[{\"id\":\"36f8ee78-6495-431e-8e0b-ea19d87c0ca0\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"7ffb8640-19b7-455f-9c7d-081f9e6aa681\",\"name\":\"Complete Level 50\",\"payout\":0.1},{\"id\":\"c38e6076-c462-441e-a567-0a47b69a8e19\",\"name\":\"Complete Level 100\",\"payout\":0.14},{\"id\":\"9101d5c7-7fc5-411b-a54c-a2f3aeb31558\",\"name\":\"Complete Level 250\",\"payout\":0.56},{\"id\":\"a2b96c54-0e8d-4830-b398-6c82653cc332\",\"name\":\"Complete Level 500\",\"payout\":1.8},{\"id\":\"7a08686b-0785-4816-b262-4f2cd61e2504\",\"name\":\"Complete Level 1000\",\"payout\":2.8},{\"id\":\"e703de0f-16ed-4abc-860c-6de3a15925c6\",\"name\":\"Complete Level 2000\",\"payout\":5.6},{\"id\":\"0f6a5d9f-e90c-4ab6-918d-9452049d229c\",\"name\":\"Make any Purchase\",\"payout\":0.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(272, '882768-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 17.52, 'https://notik.me/api-redirect?token=eyJpdiI6IlBYTDg0V1NYNmdxS3FGcGRhZ2dhSFE9PSIsInZhbHVlIjoiYlRtMlNzUU5hb0RiQjBEd2dza1RpTXRPRjZRcjQ3Q1FJeGpEUWs3Y2pkM1BGb2V2dEZadmRVbmZibEhWWVptSjlEU0pqamFZZ08rc3BQanp6WnJha2U1Zmd6elFTa0JVU29NSkk2aUhVZ2Z0amNpYzQyVXVqeU1mT2VXdmxaSUEwM1RsUEhYY1NrZ2pvR21taHk1c2wwMmVhVzlzOXdWMk9HNmpFd2J2cFJPNlZOeTdlNkM3Q2tnOGQ4N2x1aXkxdjltQ25FYnJLMmRGbHpkN21tYXFKR3gzL0FpdWpFRG5GQlpycnFGczc1YlNiMGlaaXd1WkNWNVU4WiszZkkzTWgwU3FjVjVKTW1HVXhBTzkrZWh5UngzV05aYnZ4aWNEVjNQZlhSODhKRHc9IiwibWFjIjoiY2I1ZWE3YjczODE4MDEwNWZiNTc1NTU2YjU1ZjIzYTYxYTJlMWU1ZjZiNTgyNGI0MWUyMmFjMTNmM2ZhMzJmZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"ec03e39c-9111-4bca-86bb-0caf38abd13c\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"bfb45378-6b06-4704-8cb7-a31e18fad8d7\",\"name\":\"Complete Level 50\",\"payout\":0.28},{\"id\":\"6ecdb746-41e4-4a5b-973a-287ab25bbb61\",\"name\":\"Complete Level 100\",\"payout\":0.44},{\"id\":\"67d3c262-8faa-4357-94f5-f344fb48fcfb\",\"name\":\"Complete Level 250\",\"payout\":0.84},{\"id\":\"c1a16c77-b085-4393-ae74-25da31f2129c\",\"name\":\"Complete Level 500\",\"payout\":3.08},{\"id\":\"3bafc8c8-91a5-4e9d-883b-c41fbabe08f4\",\"name\":\"Complete Level 1000\",\"payout\":4.2},{\"id\":\"0f24c1f4-2e7e-4476-b786-9484a563fc8d\",\"name\":\"Complete Level 2000\",\"payout\":8.4},{\"id\":\"f95e9270-63f8-44b9-b459-40531da1439b\",\"name\":\"Make Any Purchase!\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(273, '943173-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 10.98, 'https://notik.me/api-redirect?token=eyJpdiI6IkswbHFaQkplc3ZTeG1RdWdBZWluVVE9PSIsInZhbHVlIjoiZndHdVk4TUJVdy9NQW5zdHFpdnh0aW9FSlZxYWZtVjlQT1d0MjdweFE5Y2tJd2p6Nmt4TTVUTTFKckM2UU05VXYyTm5ySkorczA3RVpsOFdpRHBwQW84cEtUUFQ4ZDByVGFpYjlSWit6RXRUMzU0bjVDNHUwMnY3c2hGUVJwek1kRS9STmc3K0thbWhaTm1PR3Q3NFZCSnA1TGdqYjRMWlBYQ2ZTQzN6UVpkVUcwdGg5OHJFSmJHNXF2Y1BwNy9qQUFwbHRGRm0wSFljd0RpNXRqOFdpUmFTUlB3VFU2Mm9EYzRIZjJKMTU0NHI1ZWlYL3AwOTltd2xVWUdodXUyZGFMZnFKNE92UWFZTjlISUJjdFROZkVPN2UrRTEyQk5wb21qNlVWaGtzeG89IiwibWFjIjoiYzU3ZjNmNTVlZjEzOTc3MmJmM2ZhZTA1MjcxZTQ4OGJkODJkZmMxNGMwNzAyYzM2ZTk4MzVkMTliYjY3ZjFhYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"b7335bb6-8d42-45ca-bfb2-539f2ad9aa3e\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"6440245c-5b47-4e6b-91ba-906f20a784a6\",\"name\":\"Reach Step 25\",\"payout\":0.152},{\"id\":\"dba3ecee-497a-4416-b1d4-d249e56a9e1d\",\"name\":\"Reach Step 50\",\"payout\":0.168},{\"id\":\"147119f9-755b-4b1b-b676-48ea0325d0d0\",\"name\":\"Reach Step 100\",\"payout\":0.38},{\"id\":\"48613d53-dbc2-4bdf-b1d4-0de91ce43012\",\"name\":\"Reach Step 250\",\"payout\":1.26},{\"id\":\"35c9d10b-1862-4140-8734-3b064acc30aa\",\"name\":\"Reach Step 500\",\"payout\":3.024},{\"id\":\"67219792-2a26-434d-8680-bbcae0322f9c\",\"name\":\"Reach Step 1000\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(274, '1156211-lZ2kToJFfVYWxuk6', 'Slots of Vegas', '', NULL, 16.58, 'https://notik.me/api-redirect?token=eyJpdiI6IjFXTHdReVpuNy9OZHpBOUhISFYvckE9PSIsInZhbHVlIjoidXg4NUoxeTJ1NzRyMTVkTGdlcjJqSU9YV2F4dkdGWUdZQUtXMUFSUkZlSmdBY1o0WnNlNmdOOE0xYVdLSVJod3hlRmdUaTJGU3YvZUF2NEZPOHRYQkdSNWtQYmQ1Mk1Wdk9JbEV4MytwRmxaUzRyTzIwdHIxRXJBdTkvajh4UFhWRHNqQy9uVnMvbFdoejZTd1FMNnhiRFBaR1lmVnMzWmJmdDJRWGxxZXI4QlVYaEhZWUNoVVVNeGlWNFNsYjdkeWJKWEZUMnRRZ3ZMb3Z6eGIzcC9MOHB2eW5EMlRYcU9QYVZuMURsS2VTay9xUnpoRGZuR0FYcS9ydnZwdloyd00rdFVLYUZHTENBYUdYT2I3MmdBcTQwRStuR0RDcnlIcGFBM2JiM3hyREE9IiwibWFjIjoiMDczYmIwYjVlZjI4MTBiMTQzMDMyMGVhNWQ0NWJmNTZlZGIxNmYzZTM5YzI4MzUwOGFiODJlYzgzZjE4ZDRlYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU', '[{\"id\":\"eb3a173e-fdb9-11ee-96f5-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"eb3a1fd6-fdb9-11ee-81bd-069eb31df495\",\"name\":\"Reach Level 16\",\"payout\":0.08},{\"id\":\"eb3a27f6-fdb9-11ee-84e7-069eb31df495\",\"name\":\"Reach Level 28\",\"payout\":0.3},{\"id\":\"eb3a2f80-fdb9-11ee-8629-069eb31df495\",\"name\":\"Reach Level 36\",\"payout\":1},{\"id\":\"eb3a37d2-fdb9-11ee-904e-069eb31df495\",\"name\":\"Reach Level 42\",\"payout\":2},{\"id\":\"eb3a3f8e-fdb9-11ee-b987-069eb31df495\",\"name\":\"Reach Level 48\",\"payout\":2.8},{\"id\":\"eb3a4768-fdb9-11ee-8944-069eb31df495\",\"name\":\"Reach Level 54\",\"payout\":3.2},{\"id\":\"eb3a4f56-fdb9-11ee-8d37-069eb31df495\",\"name\":\"Reach Level 60\",\"payout\":6},{\"id\":\"eb3a578a-fdb9-11ee-b26b-069eb31df495\",\"name\":\"Purchase Any $4.99 Package\",\"payout\":1.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(275, '1157421-lZ2kToJFfVYWxuk6', 'Bingo Holiday', '', NULL, 10.56, 'https://notik.me/api-redirect?token=eyJpdiI6Ijg2M01vN3A2c2FrZmJrNFBiL2I4TXc9PSIsInZhbHVlIjoiekJUQlNiSGl3MTJOSnhlSXE0YklFMFFWazJYU0t5VVkyYXdFaEVhY2tDVC9pczBUWFRHOGFXZlFROThCQXNZdVIzSUFtMU5ZM1lyeG5SZm9DU2FPTkxkbHdMc0NGN25Mb21mT3lqUUtVN2tkdDRHMEU4WnZjZFk1aGhCN254SGJQeFM4ZWVUVEFqcGdhRVEyc21kS3hzeVA0Z0xZZDUyTWgrZFh0U2VDL1AwM1hmVUQ5dE93ZXM4UWZlc0lWSHVuc2o0UGpCb2t5WlJKeWNURFZ6eDUrMDdiZ0p4aWllTFhlZnNHbSt3bjVoUnNDZ1VJRzhXMWlxa1ZlR1JYMU4rUE1NbUdqOVk0TEhWOGtlRUNYQVlqR2ovY24vdWVjQ3htV2gyOUwrR1dtM2s9IiwibWFjIjoiMjMzMmJlN2IyMTE4OGU0NDliNDFjNmQ5ZTQyZDkwOTk4YjJiZTgwOTEwNjVhMTkwNTljZTdiMDZlNzRkZmU0YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"a2c37d66-1d11-11ef-90cf-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"a2c39ddc-1d11-11ef-8c79-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.12},{\"id\":\"a2c3a6ce-1d11-11ef-b874-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.24},{\"id\":\"a2c3ae80-1d11-11ef-8b60-069eb31df495\",\"name\":\"Purchase Any $4.99 Package\",\"payout\":1.2},{\"id\":\"a2c3b632-1d11-11ef-9745-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":1},{\"id\":\"a2c3bec0-1d11-11ef-aae5-069eb31df495\",\"name\":\"Reach Level 40\",\"payout\":2},{\"id\":\"a2c3c6b8-1d11-11ef-bd63-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(276, '808550-lZ2kToJFfVYWxuk6', 'Monopoly Go!', '', NULL, 96.65, 'https://notik.me/api-redirect?token=eyJpdiI6InhZOTBIMWpSUzdIcmFwa3dTNC94NUE9PSIsInZhbHVlIjoiTHlTWEg2dUtiWjE2Q2lOWUgrOEZZNFdYV0d4Ymt0QndrV0p6b3phWndvLzhsZ2Jhc1lEZ2YvQkV0SnJHSTNSUEhpUE1wNzE2Yk40RFpzT1VhUjE2djFDbStPbXUwZzNIYjkvb3lOelRncmRvZEs2VHJEeml5WjJtSkJadHI2YjlMaWdybkh2dWZ1c0VOeUFVcVJtRXFUQjJYSjlKaXZZZGV6Q3FxUzJrTDZwalJjV3pLeG5RM2hYWTBoR2sweUQrRWxyY0N6SCszTWdJSUh1Tm1IdlRKWGR6WEF2amhUbkZ2L09OclhoZndYZUZPSExwZ0QwMkxXa0REUE9WRHcvb3JSQm04NGU5c2lpTXhtcDhGNmR1anVnQWxJMkVqdlVhRWdGZzdQTDdSOGM9IiwibWFjIjoiZjllYzlhZjNkYmI4ZWNhMWFjNzdhY2UyNDcxZDg1MWVlNDU2NWU5MzlkMGVjYTBmMmJiOGRjYjcwNTZjYjYwMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[{\"id\":\"b0b1976e-7a6e-11ee-a869-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b0b1c496-7a6e-11ee-ab79-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 19 within 2 days\",\"payout\":2.2},{\"id\":\"b0b1dada-7a6e-11ee-aefd-069eb31df495\",\"name\":\"*BONUS REWARD: Reach Board 101 within 8 days\",\"payout\":18},{\"id\":\"b0b1b5b4-7a6e-11ee-8261-069eb31df495\",\"name\":\"Reach Board 5\",\"payout\":0.02},{\"id\":\"b0b1bd98-7a6e-11ee-9d22-069eb31df495\",\"name\":\"Reach Board 12\",\"payout\":0.032},{\"id\":\"b0b1cb94-7a6e-11ee-8c81-069eb31df495\",\"name\":\"Reach Board 42\",\"payout\":1},{\"id\":\"b0b1d29c-7a6e-11ee-8992-069eb31df495\",\"name\":\"Reach Board 71\",\"payout\":2.2},{\"id\":\"6f67ec62-0c91-11ef-b451-069eb31df495\",\"name\":\"Reach Board 126\",\"payout\":2},{\"id\":\"6f67b26a-0c91-11ef-a2a4-069eb31df495\",\"name\":\"Reach Board 176\",\"payout\":6.4},{\"id\":\"6f68150c-0c91-11ef-acac-069eb31df495\",\"name\":\"Reach Board 251\",\"payout\":22},{\"id\":\"6f68411c-0c91-11ef-afb2-069eb31df495\",\"name\":\"Reach Board 301\",\"payout\":42},{\"id\":\"4ae77b5e-ddad-11ee-8ef9-069eb31df495\",\"name\":\"Any Purchase (1 per day, max 5 total)\",\"payout\":0.8},{\"id\":\"49a26da8-df23-11ef-9e35-069eb31df495\",\"name\":\"Earn when you play at least 2 minutes daily!\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(277, '870567-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 4.00, 'https://notik.me/api-redirect?token=eyJpdiI6IjJXek83ZGZiY0JEekNXTkdDaFRKZVE9PSIsInZhbHVlIjoia1poelRNaExOL1BjQVdhYWtHWnZFYjREeWNmWjBEN1h4ajJXL3dsNFI4M1gxclBOcUVDOGsreHh6ZHlZSWVFSjZKNjRESkZKMkNLb0tZcmwrSUYyQzdiZjZseEVEbFhNSTlObHZrTzBnK1NXeWJ0UjJDQkQ1SnNrNFNFZVoxc08yS3Y2VE5OTGlOQytzbkZJVFdTSlJwbjV5NUFLQ3VwSkdhVGZ5YU9iSUErOXBibFhmRG9XcU1ObXBVclFZcFlML0ZyQjZiRkJIRWFwR1NXK3FjcldCQjliUERRQWw1RmVPSTJNK2Q1cCtPemV1Qk5QRU1qUFRTNkZDeGxkdFFCa1Z4d1BBSHRXWmFROFY2OWdtdDhMblV2bUdwc0dMQ2dHWGxsdVRTZk5qb2s9IiwibWFjIjoiMjI2MDY3NGIzMmMzMzgzYWJkZWI5OTk1NWQ2YzJhMzNmNzMzMDdiMDgyODkxZWQzYTJhZWEzNGI2OTNlMmIxZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"ffb8850b-4197-4702-81e4-ca48c361a92a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ab4784a9-8541-4973-8478-9b9290b7132d\",\"name\":\"Reach Level 50\",\"payout\":0.16},{\"id\":\"59e29709-4d71-4c1d-b686-969c8f75cd77\",\"name\":\"Reach Level 100\",\"payout\":0.176},{\"id\":\"09f59f25-3ce6-47d3-955a-abef7cf64c87\",\"name\":\"Reach Level 250\",\"payout\":0.56},{\"id\":\"18202453-bdbf-4334-a68b-6e44b50d1340\",\"name\":\"Reach Level 500\",\"payout\":1.02},{\"id\":\"5880bfe0-432e-41d3-b69e-a1f385676bb2\",\"name\":\"Reach Level 750\",\"payout\":2.08}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:48', '2025-02-26 13:11:04'),
(278, '899803-lZ2kToJFfVYWxuk6', 'Number Match', '', NULL, 4.84, 'https://notik.me/api-redirect?token=eyJpdiI6IkhGSjB5Sk8yN29rdHI0SnFTTFp6MkE9PSIsInZhbHVlIjoiOFFnNDMwMSt3NThpQ1VoeHIwWmFnbzhqTzdlQnBUSnJWQ0ZFSkpla21Ia1J4SjRlT0FIYTdoSXZiWDhWcTUxd1RKZDYvTzJCeUNheDVTZWREb1MzRXdtdEQwazBpalE1bTRhK2VTb1pwVE40OTB5bUlrSGEzZkVhelY0LzFZRGZ4WmRqQy9iUXlVbXc0c2YwRnZpNXlHOTdpUVRmSjdmaVRHazVtaGJOSU5Ib21qZTJkSkNMYXl1N1VXd2t1dm5PRDdaSUdyRmY1TjNGdXRLaktsemREbHc3c0U5QmdSRGpkRW9VdVBNZXdLREpzNm83d2RLeVJNb0M2M2tqSDdvd0NUWUNPTis1aUxYTUl5TFkrSlJtdkE9PSIsIm1hYyI6ImFhY2MxN2U5Y2Q3ODA0MzExNDNjZDRjY2JmY2Y1NjI2ZmRiYzZiMmNmMjhmYzRhOTI4OWY5ZWQ5OTk5OThjYWIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"2c1a0126-92d3-11ee-82b3-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"2c1a24b2-92d3-11ee-a190-069eb31df495\",\"name\":\"Reach Level 51\",\"payout\":0.2},{\"id\":\"2c1a2e26-92d3-11ee-91a4-069eb31df495\",\"name\":\"Reach Level 101\",\"payout\":0.228},{\"id\":\"2c1a3646-92d3-11ee-a069-069eb31df495\",\"name\":\"Reach Level 251\",\"payout\":0.672},{\"id\":\"2c1a3e48-92d3-11ee-9b80-069eb31df495\",\"name\":\"Reach Level 501\",\"payout\":1.344},{\"id\":\"2c1a4618-92d3-11ee-a8b6-069eb31df495\",\"name\":\"Reach Level 751\",\"payout\":2.4},{\"id\":\"bdbc5516-e327-11ef-bd83-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(279, '1003126-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 8.09, 'https://notik.me/api-redirect?token=eyJpdiI6ImxrMlNqbVpiaVVNclFuQUVjaTZrSkE9PSIsInZhbHVlIjoic0UwUTVuajU5dVRpcXVaMXZlWFoyRUpZZk5VdkdXV1FBUWo1TFpRTFhHN1FGeWF2Ujhrc0p5YnA4c0lnMDdNOTl5QnJJMHVpWk94N0tCcUdnU2ZVUkZCRVE0eXUxOFR5dStHRHN2RzFBd1FyR1pLajFIdjN0b05KWDVreExPclJ6SlY3Z3RRU0NBd3p0dW9IL0NQSmNpaStnRmp4cUpHQ0M5aHVuZm8vWTM2RXYrK0diTnpyOGx2dnl1ZlBrQmhJMVAwZTRrd2hOM3M1TmlGOGVPbUJUZkZFOEM4QXAvOUxWT2pBN2dKMTVMN0ZZelo1REhUY1IxTnY0d1oyQmViZC9PclVpb1RtSFJ4VlMycnoyaEhVYkpwaUtIYUZrYThyN0w4bkJnbjVkM2Y4S3JTcktVOE9sM2ZXOVFoa0RiZFEiLCJtYWMiOiIxMTFhN2FmZDQyNTg3MTdmNTU5YWIwNmEwYjkwNTg1OTU2YTZiMDJmODNkZGVhNjJmMTI4YWZmM2JhNWU2ZDg2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, NO', '[{\"id\":\"aebce6d4-ccf0-4155-9025-b4b4cd7282ab\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"280f6bd2-c0fa-42a8-96da-415ba050719a\",\"name\":\"Complete Level 50\",\"payout\":0.14},{\"id\":\"8195713c-5e63-4c35-8246-1282ec940604\",\"name\":\"Complete Level 100\",\"payout\":0.14},{\"id\":\"beed44a2-f916-450d-9b51-75138fad90fb\",\"name\":\"Complete Level 250\",\"payout\":0.38},{\"id\":\"99188d38-9cb2-4f4f-92db-f21659f27a20\",\"name\":\"Complete Level 500\",\"payout\":1.232},{\"id\":\"318b120f-ceba-49f6-8abb-3f8c7058f890\",\"name\":\"Complete Level 1000\",\"payout\":2},{\"id\":\"1a343f73-296f-472e-afa8-43d5f65a2a56\",\"name\":\"Complete Level 2000\",\"payout\":4.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(280, '1157813-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 15.70, 'https://notik.me/api-redirect?token=eyJpdiI6ImtwWnZ6b3ZrblRaZU9mRlhuaVErUXc9PSIsInZhbHVlIjoibURIY0ZLZFNjNDFhM2taN1krMXd5MDlZeDZsZHFiMU1jTGJqdjg0cHhVQjFldzczWnV3UWowdS95UGo2clFWTTk0MlpwSnJWNmhLWDRndDhDUkY3YlVJREJzMUxqL3ZlSDRhY2k2dG1zYnFtQXBtUGdlVG5CYWs3Y213V1VNdnVudXlGbzd0VXZOU0NJRi9QYjdlWlNZVm02Zk5nbVlkS0JzUzhZdnIxTU0xTFR3Q0lWUW95a3BWMDBESWVGYkVBTkcrdXpXRDlkR1p6eDBIYUNWSkY2dDZtNlE1bzJ6R21oUGxISVRlZFZTS0FzeElsb01xcGdKS2pNNnI2ak1hcTYvSWRXK1lTZ2xkMDltWkYvRlZIVnhraHhkMnViR05ITzRDMDNCd0xvR2c9IiwibWFjIjoiZWJhYzExZDZjZGZjOTk4YTFmMWQwNjc3ZWE0MDBmZjMxMmMyOTAwYzU2ZjA4ZGM4NDFmNjdkNTAzNDJlOTYyYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"ace0033e-3cc5-4dcc-a8e9-b7fb95efc3cc\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"26642ae8-0e6d-46e2-8145-78e685694827\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.12},{\"id\":\"96f731c7-9e3c-435f-8fbc-19b05b9ef76a\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.5},{\"id\":\"b64f45e4-efbd-48b7-a019-b82703283ef2\",\"name\":\"Complete Hidden Level 25\",\"payout\":1.2},{\"id\":\"780f0189-d305-480e-acfd-a8354f4135d0\",\"name\":\"Complete Hidden Level 50\",\"payout\":2.08},{\"id\":\"0752ba42-fc16-48a8-8b2b-c6de6a44292a\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.8},{\"id\":\"3bf15783-386e-4640-996c-651da71ccb6f\",\"name\":\"Complete Hidden Level 200\",\"payout\":8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(281, '1157828-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 15.12, 'https://notik.me/api-redirect?token=eyJpdiI6InUxTXp2czdyTmFiK3ZpbjdmNXpXRGc9PSIsInZhbHVlIjoiKy9ybFI0RzdnRFZBbEFrRFcvTEVCQlpVOFJhc1FHVk80dzhpcC9GaU93TDl3aDdtSDR6MVJKZHJoSmp3YkF3c1V6UWJZWFd0ODN6enhPTkxPcmlwNnhvZDN4cm93WkoySERDR0FlTVd2cks3WGU1QjFsSjB2SWZTaUpVR2t5UkUwSkRIN2R2eWhFTHZnR2U5MzJoNk9GUE5hSXVWMlpsczhBWW40STRHVFBON2NTRUJjYUsva0xnMWF2MDk3ME1ZK0xzNk5paU02Um5ySC9OOHNsa2NVS3prak9PY2tMR0tJVVI3V3lPVkFoSmUzNjlwVG00eFBwd0RJcTVMRUlnbUQ2Q243RDNOSHVkR0Roa2diZHp2LzJBSndIczQ3VUJoMERDNnYxdkk0Vkk9IiwibWFjIjoiN2U3Y2M0NzllNDZjYWRjYWIwNmU0YTc0MjI4MzEwOThhN2E0ZjliNmFhOWMwZDljOGFiZGJlMGVhOWUyMGEyOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"4c9b8dea-ecc4-4d3c-9937-03f64071e2ef\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"7a8c6f25-088d-48dd-bf80-0b84957246ab\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.08},{\"id\":\"8319de4f-d8c1-4eec-82de-7cc6cbf3ae65\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.56},{\"id\":\"d74583a1-fd37-466c-b1dd-1610cbde9478\",\"name\":\"Complete Hidden Level 25\",\"payout\":1.2},{\"id\":\"fae13f49-b0fa-42e5-8fbf-734c82435509\",\"name\":\"Complete Hidden Level 50\",\"payout\":2.08},{\"id\":\"e5459fd0-5fb2-4180-a663-0b9481f97d6f\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.6},{\"id\":\"e81ca04d-6250-445b-ad7c-42841b949788\",\"name\":\"Complete Hidden Level 200\",\"payout\":7.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(282, '1157659-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlA0amFxbUN2TWVVeTIwbkNoTGg4aUE9PSIsInZhbHVlIjoiMHpFYnp1aFA1Z0tTR0pCclhxY1ZiZUdCZ2pQcUxma3RpYXRRYjlUd3Evb0RNT1BSQkR4b2p1YWE2R0R5S2V1UUlmaEZRbmNxYXhsRzFWVGM2Nlh5d0Qrdk9DUE9TMzJDM0d1UDQ3cjRKK2xzVTZmTmJsa3NwL0lwZHdxdytxTmFnc1FWazZQZmRlM0x5T0ZjMWVwZ2t1cHZnaUZWS0NCcnpKaUtKVHJsN0tqVXJUOG9UV0pSS09rR2pZMXk4ZmZGcmhRN0t6TlNLZytnZFQyalpvQzFvOXo2Tk9WMnJOWTJ3QVVnS3lsRHJIL1JyVy9ZS3RiaHlOTU1YZHUxa0JxakhldjBpaExvaVgrMCtsUU5FemxFT2FCcmtpMFpsZVRhV0VIb3EvTEd3MEU9IiwibWFjIjoiMDhhMjQ3Yzg4YjFkNDAxYmUzMTA5Zjg4ZTFjMjMzYzFjZGJlYmU1OGU2ZDg4OTM5M2I0ZTg3M2NhMzY4ZWE2ZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[{\"id\":\"86cbbdc8-22c3-11ef-9170-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"86cbddf8-22c3-11ef-bb8c-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.02},{\"id\":\"86cbe6cc-22c3-11ef-84da-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.04},{\"id\":\"86cbee9c-22c3-11ef-a0fe-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.04},{\"id\":\"86cbf66c-22c3-11ef-be8f-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.1},{\"id\":\"86cbfe3c-22c3-11ef-9447-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.2},{\"id\":\"86cc0620-22c3-11ef-a00d-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.4},{\"id\":\"f0586442-e318-11ef-b554-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(283, '1157660-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5sVmRSOUFNMXZJQjZjNXB1blBZVEE9PSIsInZhbHVlIjoiUStkM1VWajRaaXp6TEZ6N0Q4NWZYOE5xNVRDeTFhMUdZWVNhZXRmNGw2czM0eEhQNXc3S2xpTlFTZlkrK2kwRjI4dm5aM3BlSDRjU0NLWlRxTnkzUjZoZjg5SC9kOEY3Sms5WGk1dVpJVUpObFh6ZkxYay9rUGhwaDdKYzdHbk5iNWdTSmNrUUY3cDhkNUMxY3hNc2FxS0UzdXJScE04OTdqVUFtcXpaZTQrSTVNTDVBd0djSmhyOVI1R016cDcyczNyVmQvV2NvWnhvWGV6N3Zqc0FnWmF4cHFIL2pHTmhKejBTcjBqYnR6TUZtK0tyakxucHV6Ym9QVE0zREVIcnlMTWo1QUhKQ0JKOHUvSllTOWluV29sWCtzelJEeGJEZWRJdHhtSE01K2s9IiwibWFjIjoiYWUyM2E5OTZlODkwZDM3ZDlkZTEwZGVkODcxNjBmMmI2N2NmZGEyNzZiZjAwZDI2OGVlOWI1NmIwZDhlNDU0OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[{\"id\":\"8727c000-22c3-11ef-9f5a-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"8727d004-22c3-11ef-9068-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.02},{\"id\":\"8727d838-22c3-11ef-9ad8-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.04},{\"id\":\"8727dfd6-22c3-11ef-8e2f-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.04},{\"id\":\"8727e788-22c3-11ef-86a1-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.1},{\"id\":\"8727ef58-22c3-11ef-93f6-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.2},{\"id\":\"8727f73c-22c3-11ef-828b-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.4},{\"id\":\"85e40a08-e318-11ef-9cd5-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(284, '1157739-lZ2kToJFfVYWxuk6', 'Prize Grab Target', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6Ik93K3pLZW1UZ04yRjdTNHFOQ3pFOXc9PSIsInZhbHVlIjoiZmpmYlJpb2FSMS85R2Fxa2REWGdZMnFBWmc2T2RoSnVaWVNsRE50bjhSS2orakpQdkRlMklRekxCcGllWnhkSDQwMEw3MURadUI3V2dwZEdqRHdQODZmZWxLaWVpZ2JuYWhsSTQ5T2VUMkxWU2RGbmRYWHM0MjhzT2RYSHVoMCtwRVpraStFMG0xUE52MEFZUlVRL3poOHE5M2puVEJFU0pCcDhJa3hsaWJwUjlqY2NMaDZSQjdQVzNuWFQweDJNZjAxQVRwQ0YxaWdnRFp1Y2JGVVRhNFV1REZGNENzenlCSWhYNlBqbHplMjBrVUk5TGhSblJwd2gwQU52SlRVRjM5V3NMNUd3MDR0MiszVS9YaWxlUXRDUUtoUHNiRXZ3VlhhTDU0d2lZZ1E9IiwibWFjIjoiZGRmYzc4MTQ0NTVlMTY5ZWZmNzI5NGQ2ZGViZDgzNjQwMjYxZDYyNzI5YTUyZDliYzdlNDE0MDU2YjJiMjc1NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(285, '1162811-lZ2kToJFfVYWxuk6', 'Army Tycoon', '', NULL, 0.96, 'https://notik.me/api-redirect?token=eyJpdiI6Ink2QmFDL2ZoUWVQd3pNZ0Z1eE04NlE9PSIsInZhbHVlIjoiQjdhTVNqSzRsUnRsekMwV1pZN1B6dEF5MkdlcDdpcTM4OE9iYWYvYUlmQ3VKdTJ6cGJhY2phMXdQNStyYXNqdXhVYzBYNENPMzU3RUgwWStPdGdrTTRQcTZNRGtOZDlBK01MeDNEVEtsdVFXR0lLTThVdWxMc01Qa3ZJc3pBMk1xTzBaQXNqWm9qeWNESDM5a2tHOTdGVzBHTTVScjZlRzJhLzJscWhJMTFRRDF6bGtweGdxd0k3OEdhT3ZHcG9qTW1ISmx3RS8ySkVETURrTEN3NFBNajIxV1RtQldaNFJXQnlVRjhqTFBEcjB2NVRoWGF1WTBSRnZUVE1wbUJUVllGVWc3MXdWKzRUa2FTQ2prWmNNRFE9PSIsIm1hYyI6ImRkYWE2ZjUxODRiYzEwNzYxN2Y2MGU3NjllOWMzNTQ3MjRjNGIzYWQ3YTI4Njc0Y2FkMTM2NDQwZWVjMWFhNjIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"f31b21d8-2d79-11ef-ada4-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"f31b2aca-2d79-11ef-92a8-069eb31df495\",\"name\":\"Unlock Artillery Course\",\"payout\":0.06},{\"id\":\"f31b3510-2d79-11ef-8c90-069eb31df495\",\"name\":\"Unlock Tank Course\",\"payout\":0.1},{\"id\":\"f31b3ce0-2d79-11ef-9a96-069eb31df495\",\"name\":\"Unlock Indoor Shooting Range\",\"payout\":0.32},{\"id\":\"f31b447e-2d79-11ef-ad8e-069eb31df495\",\"name\":\"Unlock Helicopter Course\",\"payout\":0.48},{\"id\":\"d631a2b2-e323-11ef-b946-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04');
INSERT INTO `offers` VALUES
(286, '675067-lZ2kToJFfVYWxuk6', 'Flying Rafts', '', NULL, 3.72, 'https://notik.me/api-redirect?token=eyJpdiI6IktaNmorMnZHSisxY1JZcnpseDlLNnc9PSIsInZhbHVlIjoiZDg4Vmt6NXpnR09WZ1NlWXBMMWo1NldmZlVFMGhLdmJ0TTM4VGJTVUJLWlN6M2JUdzczWEZ2ZlYwMjlQeUUxL1NoaXE1K3FUdllSQThKNHNId3pseFlHZENoZXp2K0FGQzdEckxQdEVYVFRCa3lUYmx3VGdXRE0xMEMwZkhJN3RLcyt1cE10bHJTMDNPYWo3Y2EzWld3a245RWZCK1I0c0lJRnFWaWl5YlJaTHF5NWVvbGpzaEZseEVPZzNUUEtyem0rdVdMOUlqaDFyR05jRUN1NWh6aUp6a1hQc0tHcGZCTzJUakNHWXVzZVRtSW9wRHRxUk9rVVlaTVZjUkVDbVdaaWVqa01FZ0NYRG1SbGptNWRZckE9PSIsIm1hYyI6ImFhMmI1MDk3MDE2OGEyNjk3MTVjMTVjMWM3OWNjMTE2ZTU1OTZjYjA2MjQ2YThiOGVmODNjNGYwY2E0YzZlNGIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"8a464268-4c0c-11ee-bbca-069eb31df495\",\"name\":\"Install\",\"payout\":0.12},{\"id\":\"8a464b78-4c0c-11ee-bb1c-069eb31df495\",\"name\":\"Collect 10,000 Gems\",\"payout\":3.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(287, '696461-lZ2kToJFfVYWxuk6', 'Blast Friends: Match 3 Puzzle', '', NULL, 14.78, 'https://notik.me/api-redirect?token=eyJpdiI6ImtIWFFHZnNDaU0wMWhIWTZqN1VxRFE9PSIsInZhbHVlIjoiN1VqYS8rak9BOXE2MVVKZFRjODJPS3ZqRDh2VTIydkVqYnJKUVhEVThoTENTYjRlcXR4MzZTbGFlOWREYXZJRk1vT0tBWlJLcERQeGpVdzlLMzNDRHZlL1dZaEVMM3lDUTlqMmdhU28yemJ3OXRNQ0RtbDZMS2tKN0gxZjltdUI1YlR0U1dLSFNxNUNZeVlWMlRvMVd6Y25HQVhPWVEzWFVoYlFHUFI5SHpvcmNFQ005bk9tRG5EeG1Tb1kxNlBodDVQODZRMUVpMDMzeTFkL2pPQXBDOWtUbXNsUW9Jcnp5OUl3WkV1WkZxQnhZMWVyUVBRUDMyNVZuZ2tOWENwaWZzdTZ3U0J6dFc4cTlCb0dlTHZRNGg4eDAwWTlMSjlROEVHbU5OaHlEUGM9IiwibWFjIjoiYjBkNDkwZTEyYzlmMjVlMWYwNzQ4NzQ2OTkwMGEwNTQyOTRhMTk2ZDBlNzE5NmFjNzc1ODgwODVhN2Y5ODk3ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"c116983a-e37d-4ae6-9a8b-f8f573330e24\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"e634ba9b-95dc-4a0f-a75a-d27f68dc8b95\",\"name\":\"Reach Level 50\",\"payout\":0.2},{\"id\":\"33ba4549-12d7-4843-8883-b694aaffa6f0\",\"name\":\"Reach Level 100\",\"payout\":0.42},{\"id\":\"848ce44e-5a5a-487f-bd66-2698e71f6464\",\"name\":\"Reach Level 200\",\"payout\":1.12},{\"id\":\"3f1ff6db-2845-4a53-83be-e39b8fdbd362\",\"name\":\"Reach Level 500\",\"payout\":2.24},{\"id\":\"eb8e8819-c980-4c2e-92d6-9fc507b0e791\",\"name\":\"Reach Level 1,000\",\"payout\":3.8},{\"id\":\"ce2c7ea0-720b-409f-8575-740116fec2b2\",\"name\":\"Reach Level 2,000\",\"payout\":7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(288, '1147310-lZ2kToJFfVYWxuk6', 'Super Slime', '', NULL, 2.15, 'https://notik.me/api-redirect?token=eyJpdiI6IjMxTzRvcEJBa1FMYUkza0NxTGo3aVE9PSIsInZhbHVlIjoia29IR3RmNVhGNVlVQU5YeGZCeGpiUG1zc2lwLzA1eHB4Tkk2Rm9RaUhaemsxbUpqdFU3MFhPaC9ldDVUcmNGSS93NU93OGkzK0ZKbDU1ai9MNmlaZFpJZ2xRNTFxQXN3anJvbGJxbGR6d0ZoK2FBV1ozSk9YOEo3eE9SOFpEOE9haTNMSUwvVkNnckY0TzFmSWEwT2NVVXAxYlk1ZkdBSnFjOTZpd2E2SUNLUWcvY2dSaGRpc1loS1lla2tWb2RuclhoRGZQT0hCcVFZdGNUK3orekxjcnNhem1xdWo1ZStMb09hWFNvWWJWd0R4S3RuNnFlaDFWMXowNXVXbnVaSldubEhJdDFDdFNwVlBlVGpDOWJySmc9PSIsIm1hYyI6IjAwOTUzZmRhOWM0Y2QxODQ2NTQ4NjA0ZjZmODljMzg3ZWQ0Y2E2NGUyMGZjM2JjM2E0MGQwMzM0NGNiZWIzNjAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"e5369414-f5e1-11ee-b265-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"e5369e00-f5e1-11ee-93c7-069eb31df495\",\"name\":\"Stage 10\",\"payout\":0.016},{\"id\":\"e536a5da-f5e1-11ee-af6c-069eb31df495\",\"name\":\"Stage 30\",\"payout\":0.408},{\"id\":\"e536ad82-f5e1-11ee-91ad-069eb31df495\",\"name\":\"Stage 50\",\"payout\":0.648},{\"id\":\"e536b53e-f5e1-11ee-8158-069eb31df495\",\"name\":\"Stage 100\",\"payout\":1.08},{\"id\":\"0f5d9ce4-e31a-11ef-baee-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(289, '1156260-lZ2kToJFfVYWxuk6', 'Clubillion', '', NULL, 91.36, 'https://notik.me/api-redirect?token=eyJpdiI6IkZZd0NmazdHdW8rZmsyenVDbDVlZVE9PSIsInZhbHVlIjoiZUwza2NoNnVCck5TcWtIampYMllQeWVpWHVkM2k1UkhJMmNoRjRPSTdlWUFuaTVRdU11WTFOQVRKQU5UR3ZaeVJTRzh3OWYrTWNLNkd1V1FGbnNia2FKVmtRVE5DTmJaZ2o2NHE3VnRoWjBOa2plTGxpZmgzUjJnMHhuZERlUEIrelVzaTZSbjcwcEtoSWl2dUVvMzNRMDJrdVN2Rm1raEIrSUxGTE4vTWxEVERHaHkzM3NxOFlIcmkwbVFlZUFtMEJIVllnVjlWZ1RET2JESy8waDhROGFhR0VrL2lHUnlPZnhiMDU2L294dFZJREZCc3ZUaE1MOEdtdDZZOGVILzBmWGwxelpTa3p3L3l0T2lNYTVxRGc9PSIsIm1hYyI6ImJjNWFhZDQ0ZDg3MjljZTY3MTE4YjFjOWE4MzI4NjEyNTkyNmExYmYwNmNmOWI3YThmODFkOWZhOGQ1M2RhNmIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"5767fa28-fe84-11ee-ae3b-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"57680ba8-fe84-11ee-a0b5-069eb31df495\",\"name\":\"Reach Level 100\",\"payout\":0.8},{\"id\":\"57681a80-fe84-11ee-9129-069eb31df495\",\"name\":\"Reach Level 400\",\"payout\":1.92},{\"id\":\"576828cc-fe84-11ee-b722-069eb31df495\",\"name\":\"Reach Level 800\",\"payout\":9.6},{\"id\":\"57683768-fe84-11ee-a1a5-069eb31df495\",\"name\":\"Reach Level 1200\",\"payout\":16},{\"id\":\"5768462c-fe84-11ee-825d-069eb31df495\",\"name\":\"Reach Level 2000\",\"payout\":22.4},{\"id\":\"576855e0-fe84-11ee-8782-069eb31df495\",\"name\":\"Reach Level 3000\",\"payout\":32},{\"id\":\"57686724-fe84-11ee-b3f4-069eb31df495\",\"name\":\"Purchase Mission Pass\",\"payout\":0.64},{\"id\":\"5768773c-fe84-11ee-b2dc-069eb31df495\",\"name\":\"Accumulated Purchase $19.99+\",\"payout\":8},{\"id\":\"da1b6670-e322-11ef-8f82-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(290, '671367-lZ2kToJFfVYWxuk6', 'PrizeGrab: CashApp Sweepstakes', '', NULL, 0.72, 'https://notik.me/api-redirect?token=eyJpdiI6IlNNeXR3c0dyM3dFVTlIQ1dncXkwWGc9PSIsInZhbHVlIjoiM0x3Q1Qyb3NYOW1wL1JiUG93QzdNdmhhR1JReXlUWVBzOEpmZFo1M253Y1EvVFY1NU9tU09PcFJMTFNFTkFsdGF0N0hsNGgvZmFWZ1F5YXJjK3BmaVR2Zk1SQVpJaTVueHFoS01rcHQ1WVFSaFUyazh4UmhCa2FYVHhmOHJXSTZZZzBsdWJJMUhzTis5TnVKaE1EbDJLdzdWUjdrMEZBS29Md0Zrb2pxZGdCc0twRFlZSExrd3JwS0E1d1lPTXcySzZ6UnVoMkZjYStRMnZ4Ri9Gc3gyRG9lcVV0ZW9Hb3RyR1B1dW0yaGdDT1QzakxJUU9xcFd3djM5TGo0Tk5KZndDRU9ZVGZQZnNveVNmNVcwYkVSRC9aeU45aGg5MW5YVE1zaE5wb2hiWEE9IiwibWFjIjoiYmE3MzA3NTI4NGVmM2MwZDJkZWQ1NWQzMDFlMjA0MjkyNzk3ZDcwYzQzNjM5OWRlOTRmNjY3MDQ0ZjU0YmJhZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(291, '677657-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6Im0weHppbnlraTlaUWk4QUgrTFV6YlE9PSIsInZhbHVlIjoiZUJucm9yQ2psSGNWQit1WXh6VkdaMkZtcktEQSsrZVBqaFQ5dXRSYmVBWjE1VUk1c1VBN1Z4QnBlNmZaM2s1Q2h0ZmIreDhBb3FQQmdnRG04bzZZQUxZSVV0VVo2Ym4zcmFDWjU4N3NYK0pOYlVNa0kzYTdBSjlRVHVZMXhJemx0RzR3YTRvSld4WlNtMDZZK1lqOXlmNGtGUyt4cEE5M1dsYVI0Z3NJWXZrcG05TTE3V1A0blN5aUsrbmNHeXFOczR5SVhXY0Z0VEdyQW9yZEJWRkQzZmVZb2g2MmxVNkRFSm1ubnV5RjFGbSt5d09Ga1hid2h1U2RRMlN4S2VsRG1qdTdYSmFNQkhaL2s0VHhGdGJnYktEQzVhZjhlcFh0ZW05T0c0RjdBUWM9IiwibWFjIjoiMDMxM2E2NTA0YTQwYzI2MzQ2MmFjZDVjOTllMGU0NDY4NWM4MWZmMjIzMWQyMTAyNGZlMTY2MzM1ODE5YjZmMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"87b81920-a710-42bc-992c-39938e052f06\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"c0305000-54e4-4a9a-91fa-8c7933de1bf2\",\"name\":\"Reach Level 100\",\"payout\":0.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(292, '674087-lZ2kToJFfVYWxuk6', 'Go Toy', '', NULL, 13.72, 'https://notik.me/api-redirect?token=eyJpdiI6InR2SFJ0Y2h2aTlaQks2OGd3dnY2Rnc9PSIsInZhbHVlIjoiM2xVVFJCTWYzU3VZRTFYY051ZXJuSllERGo0emZHV2xaVWRwbDU4NG1IZmpvakxseTdQcFZaR2s4QnZodmd3dXU0R1lyUUhGbVpQTzU1WmhBeXpDcU85UDdpTThqYU1wZkx2NlBuSFpvRnFNUXhQSGI4amp3dmtaWDZiU0ZBUVlsbWFDb0doYlFZZk5tZE9QQ05qYUtmbHAwTDJINVJ1cUhKQkhNNWttajZJMHpZQVdhaGYxczBtekpuWWNNNW4rZks4QVZGT1Rzekdnd2FPM2lRd0pNSGJ6M0JtNjZ5ZHh3ZnpKbWJWb2lCVzNiY3ZZN05GUHlqKzVsdG95ZUpDN21Db01VWDIrbUJhQThpNzVHbFFtZHc9PSIsIm1hYyI6ImMwMjcwZGRjNzk4MTlkOWI4OWFmZTA0ZjBkMGRmOWNhMzFiMzQxZmZiYTVjMzIxZTkwNTFkMTM1OTZhN2U4ODAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"d5731524-4129-11ee-ae55-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"d57336da-4129-11ee-9396-069eb31df495\",\"name\":\"Reach Depth 300\",\"payout\":0.12},{\"id\":\"d573404e-4129-11ee-b9da-069eb31df495\",\"name\":\"Reach Depth 1,000\",\"payout\":3.6},{\"id\":\"d57348b4-4129-11ee-94e0-069eb31df495\",\"name\":\"Reach Depth 5,000\",\"payout\":10},{\"id\":\"416155fe-e014-11ef-824e-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(293, '696471-lZ2kToJFfVYWxuk6', 'Blast Friends: Match 3 Puzzle', '', NULL, 10.11, 'https://notik.me/api-redirect?token=eyJpdiI6Ik0reEY5MkxPaEZXNThFdjZEdWorQnc9PSIsInZhbHVlIjoiV2JtdDJGTWFkT2hEYnJ0Vld0SGNNalR2WW5WRldHbnc2L2F4MnA3aDJlb0p6REd5YjhlZ0M1V3kzdTJaWGZoWVI0TFVPU25WNHlHVmhpY1lmK2ZGUEdGdmV5Q0lYVzNJUVpoY2drQTluaHhtY3RoQklQNGRVOUVZN2k0UzVMT3BxZ05lMzIxalFEOGkzMGVkbmh0V2pQd0JPcWd5Wlp1U2VFMHNZdjNvMy9HVUhBeHlJeWVVdnpTRE8xQXdXa1FVYUlNcmMrMVdlblNqTlFKTEZkZHBQTWFvbk5DMlh5ZEkrZERPR0xZaTQ1TWQxblZtUitUbHV2WU1zVmVPUndweW9lU1llQTNiYk5RQ29sV2s4WXk4YWRXd0w4OTBoRVlpMUFzNHZ5RzFhb3c9IiwibWFjIjoiZjUwMGIwZjhmYjRhZjUwMzNhMDc4ODZiMzRhNGIyMWM0ODJiYjAwOTQxMTMyMTAyMzFjMDJiYmM1NWMxMGYwZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"562605bb-026c-4202-b16a-78472d51fb6b\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"67cc8361-0cc0-4255-bea2-1efa1f638833\",\"name\":\"Reach Level 50\",\"payout\":0.252},{\"id\":\"7e8385cd-7b1a-44eb-8651-0b0bc2ed1413\",\"name\":\"Reach Level 100\",\"payout\":0.336},{\"id\":\"89de2dcd-c764-4066-84ec-8c47a26660c1\",\"name\":\"Reach Level 200\",\"payout\":0.66},{\"id\":\"23de42bb-0ad3-4654-89b4-b59ec4d817e0\",\"name\":\"Reach Level 500\",\"payout\":1.4},{\"id\":\"fecf2a55-d648-4699-a88a-b8a5293273f1\",\"name\":\"Reach Level 1,000\",\"payout\":2.66},{\"id\":\"c23a39e4-f455-4733-bb8c-84e536a15b25\",\"name\":\"Reach Level 2,000\",\"payout\":4.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(294, '1156212-lZ2kToJFfVYWxuk6', 'Slots of Vegas', '', NULL, 16.58, 'https://notik.me/api-redirect?token=eyJpdiI6IlF2ejJ0bFZoSHV3TWJ3RlpNTDEvdHc9PSIsInZhbHVlIjoiL1Q2SzRnMThMRFpSaWdwRHQ0R3VBaEEzWjhDbDlIbk92MzRIVkhHUzNLeHVUdm5RNEJQaUkxZFF1bFF3cDljV2oyOEF3Z01iZXVGVjhWYVFYS2pPY1lTb1FiLzRiMDFUaUVQelRGVnZ3NWxJOGRMWlpmV0JMQlQ1S1pLVXNmMlVmUzQyU0gwT2JTVktIanBYWVlwTnM4UTBqcE0zY2RUbyt4ZjFRd3V3MVNCeW9qQS9jMkF6WFBYWFlGbkNGRFoxVXdsWWZRYStxQmhSdnJ1OVVZelRqMEEvNjF4MmpwMHpnVU1KZFQwUForWTdGUzBVUFBBTitKTFEzOEo4Y21hblpMYnRabEpmbzluV01CenZDc0hQVCs4dUNKQml4MzVHeEpwODdQdU9MZ2M9IiwibWFjIjoiNTZhOTBkMzBlNzM0MjBiM2RmZGZhNDRjMjNhODIyNTIwNTY3Nzc4NDJjOTc1ODU0MDYzYjQ3ZTQzNThiN2ZjZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU', '[{\"id\":\"ebd21340-fdb9-11ee-bf38-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"ebd21d4a-fdb9-11ee-bf44-069eb31df495\",\"name\":\"Reach Level 16\",\"payout\":0.08},{\"id\":\"ebd225ba-fdb9-11ee-a72f-069eb31df495\",\"name\":\"Reach Level 28\",\"payout\":0.3},{\"id\":\"ebd22ed4-fdb9-11ee-ac6f-069eb31df495\",\"name\":\"Reach Level 36\",\"payout\":1},{\"id\":\"ebd236b8-fdb9-11ee-bdd7-069eb31df495\",\"name\":\"Reach Level 42\",\"payout\":2},{\"id\":\"ebd23e88-fdb9-11ee-865d-069eb31df495\",\"name\":\"Reach Level 48\",\"payout\":2.8},{\"id\":\"ebd24676-fdb9-11ee-b721-069eb31df495\",\"name\":\"Reach Level 54\",\"payout\":3.2},{\"id\":\"ebd24e78-fdb9-11ee-ae8a-069eb31df495\",\"name\":\"Reach Level 60\",\"payout\":6},{\"id\":\"ebd25698-fdb9-11ee-900c-069eb31df495\",\"name\":\"Purchase Any $4.99 Package\",\"payout\":1.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(295, '1157431-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 1.28, 'https://notik.me/api-redirect?token=eyJpdiI6ImRBT2svSjRIOWNacFE5bDhuU1ZOMnc9PSIsInZhbHVlIjoiV0VoUmpjclpNZzl2MlJZMVNleDB0MlhOQndieUZ5dThLbFo5SXp3WlhTMnVKZU9zb1pOajZuOE5WS0J3UTZaVWlFLzc3ZFN3cE85OG5jZWlvL0ZKWWtkNkM5Mi8waTcvRW1uYjRTUkY0dnRmSXQ4NTUxQ3JrUllZME1BbHRxWlArc2NyY29jRVNrcU5WWTRQU1A3MHM0dmZhUDNyMWJIWGNTOHlRVitydXJjRVFCTGV2M3UyQ0FxZTNJeC9iZUFWVlFrbHo0MXAwQ05FS3VteXpHMXJRejh2WmsxMWlTQTZGVkJlcW5udHdmUDJPN0ZhNDZrSXJUQnZKUnAxQlVGUFJjYVJCbzZTY1Y2UHZUeEx6clMySkM2UUQ0NmlrQTFwN2VWZDJBZzhZaW89IiwibWFjIjoiYjliNjk4OTc3YjdjMjAyNWY0Y2M5ZWMwMWZmYzQxOGRiZWE4YTU4YzJiODU1MGY4YjRmZmNkYjFhOTk1NzI4YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"7d57b24c-1d96-11ef-ae45-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"7d57d4d4-1d96-11ef-9b8e-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.04},{\"id\":\"7d57dda8-1d96-11ef-9ff9-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.08},{\"id\":\"7d57e532-1d96-11ef-8640-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.1},{\"id\":\"7d57ecbc-1d96-11ef-9908-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.16},{\"id\":\"7d57f46e-1d96-11ef-b899-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.3},{\"id\":\"7d57fc34-1d96-11ef-8797-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.6},{\"id\":\"a422cac6-e319-11ef-a811-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(296, '1183777-lZ2kToJFfVYWxuk6', 'Super Car Escape', '', NULL, 1.41, 'https://notik.me/api-redirect?token=eyJpdiI6IlNnRGVsSVQ3WERjRlE4eDdHWk5OL3c9PSIsInZhbHVlIjoiejZpeFM1eFhFV2NnVkU5akhjUmMxa2Q4WCtxWERLMW1HcUw4aHFkdjFHNFJvQXUxWDc4Q0dqb1dBd0pLQStRQy9mWHBQR1hOdlhqVVp6bkZvN1FWYnlYaHlvSktaOGpINzBLV0VjYUhIYlYwOHAxZCtvNjlFRk5MVHkyMHJiRWxjN2ZiOUdqRmhJOW1HWWFCSVZWRE9Mek84UXV6MUY0VHBqOU8wcHhhSDZESjVpbFJIbDJJL2RDZW0zRCtWU09JK016eWN1WXdzUGtiUFdQK2l6Zy9YbVR1OVYxaGhtTG5tOVF4Wm5RMjJYSWp0RzNQSHgrYXg3TW4xenIzS2Qyc3RLWVpvazdxZG5wNmg2SllsRXNtMjFkMFFRV2E3N24vZ1JYV1ZweHZTUUk9IiwibWFjIjoiOWI0MDEzOGUwYmZhMWY4NWQ5NWY1NGUxMjAxOGM2Yjc3NmY4OGJmNjYxYTJhZDM1NzgzODgyNzBjYWIxMzA5NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, CY, CZ, DK, EE, FI, FR, IE, IL, IT, LV, PT, SA, SG, ES, AE', '[{\"id\":\"bdd6f25a-6cf2-48e7-9dfd-8e2a83f9964f\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"b34e9a78-2332-4509-9926-adce0ee17ee3\",\"name\":\"Complete Level 10\",\"payout\":0.168},{\"id\":\"99e2f73b-6024-482a-98d0-b16967dae672\",\"name\":\"Complete Level 100\",\"payout\":0.24},{\"id\":\"77a51379-fcdd-4d63-b617-702440d3f0a2\",\"name\":\"Complete Level 250\",\"payout\":1}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(297, '677664-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.70, 'https://notik.me/api-redirect?token=eyJpdiI6Ild1Nkdaa1dVUnFwUzZSRDFCMjBMQXc9PSIsInZhbHVlIjoiMGM1NVNTRmNBNUtxdjVmajYveERHR3RJMEZFbVIrVnFrM1lheklsWnVnUmJyTmQ3ektySWZrenNPN296WVFLcjNlaE9jODg5c0V2VlAvaU56aGRHR3BGVWhocnRSY3FwSnZwNXc5YlVDb1dQbitaWG9qVjIxUVlBeGJqQXgyOTlKWk5SMFBHc2xLdnBsZ2RrUmphQVNnaEVkWUJqNnV2RGxISTVPQm5tYi9DMlIrN0VkdFBQRFI5NkYrakMrcnp5YUpsMndHeDNjb0pRbkJYaDRrNnFkbTd4OTdtZGgyb0w0b0hVWlhQZ3lOSGo3VTdoOXhCZk5NNHBpMlhvZlExT1VNMzdXL2lJVTAxYjI1V0pWZnc1eDI5ZXExTFlyV3hsMHNUMGJvcXQwSDQ9IiwibWFjIjoiMzY0ZjU4MzliMjY3ZTM5YjIyN2FjZWVjMGY5NWI3YjhiMmQ0YmMxOGU5Y2U3OGJjODE4MjgzZTRjZWY0ZjQ5MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"7d0e6d2c-15a8-4b46-9097-88d33f1558f1\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"e76a3b34-e6fb-47c3-add4-5deac2a99fc8\",\"name\":\"Reach Level 100\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(298, '828726-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 15.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlRDL0IvRkpmZnJrK2kwWEV1N0VjdGc9PSIsInZhbHVlIjoiS2l0L21DTGNmTWJ0SGdKQ1docDltV24yLzNqUUpTTFJrenJZWUhRV0ozSUlUazdqekJJNkVzWGpKV2ZGTlNXU1I4RTZCd1VJcW5sT01FY0JzRTlnVlVDcStOT3dlTTRTMHBOMS93R1VVcUsrN0hOVWJTQUVwL0Zzb3VTbUY3SlNMTXk2VVBHbHZONGN4YlBIUWhJUnFvbkJaQ0FPa0VxQm9DYVlwb00rZCtMaFE5eEF2VWpvemE1bXFrVisramMvZ1NhWWYrbVQveHdkaWQrd2Q5Q3BicHdyUlVhMHFkZWo2ekVya3pCSGdGOE5Ya3RaVHp0Zldpc3dkUzdLSXcwUFVwaGhhVE5NL3RnSjM1M1g0bGJIdTdJalZUVmFlSmZqU3dJc0NhRzIraDQ9IiwibWFjIjoiMTk3MGQ2Y2IwOGVlYjE2NGRmODRkZjU4NTcyNjBjODk2MDFmYzgzZGJhNDc5NWJhNjdjNDM4MmNhM2E1ZjRhYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"2bb5546a-5a4e-4904-ad0b-94a1b24736e7\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"96b5a82e-60a2-4b72-ad6d-7f40d0dcf137\",\"name\":\"Reach Level 50\",\"payout\":0.5},{\"id\":\"d6eb0439-58aa-4b4b-9929-5e13df25b09f\",\"name\":\"Reach Level 100\",\"payout\":0.56},{\"id\":\"5297a8ca-1790-4be0-a38b-e09c65888a4b\",\"name\":\"Reach Level 250\",\"payout\":1.8},{\"id\":\"1fdca6ea-66da-4328-827f-3707b67ba304\",\"name\":\"Reach Level 500\",\"payout\":3.8},{\"id\":\"80705f49-49ed-4fa9-afb0-ff26c2f81b68\",\"name\":\"Reach Level 750\",\"payout\":8.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(299, '933719-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 32.18, 'https://notik.me/api-redirect?token=eyJpdiI6IkxxUk42ckFnaUxUOTBvb1RwZ1hObXc9PSIsInZhbHVlIjoiUzNOODhIT1d4Nk5VR0xqWFJnVDBsNFVZZSs3aHRrNXlUVW81YkJ1LzJUL2ZjT2M5ZzgyY1VsaVpsQytseUlDSU5jd1FsS01ZVng4Vkw4bmJGRGZnbk9FelRyUnUzNkNDaC9BejhXRHhHMTBEWlBLRnd0cEpkcE5YUGZmbElvaGgveUkveVozNHBMUEdYSzUrd2tuV2t4R1cwb1JPdGpIWWxDTTN0YzA3eUlhZmVLTHIzajFnOXcwclg4d1hWRmdxTldZV2doQVl3eGpXa0J3NmI2amRuaWxOOC84RDUza0gya01ZcmVKbURBaXNSaWt3STUrTjVMclgvM2pJN1Jidi9hY3ZkUVBLdnB0YUdUNC8rQXBGbEI5dWZNNVU1WmxhWEtzbXRKUFlPQVU9IiwibWFjIjoiNjgzYjI0OWEzYTE0NzNiZGVjZTU5NmE3NGEzM2RiMWUxZjAwMWUyMmYwZTZlNzJkOGE4OGQ3MmVhMTQ0ZDAyNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"d2571395-a142-4c5b-bf69-a45383b35296\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"23e33c3e-e257-4291-af47-407c530197d0\",\"name\":\"Reach Step 25\",\"payout\":0.4},{\"id\":\"f541f32c-e4db-4163-bc14-c3a9d5825b40\",\"name\":\"Reach Step 50\",\"payout\":0.5},{\"id\":\"bf0240cb-f16d-4df5-853a-377c15b8b499\",\"name\":\"Reach Step 100\",\"payout\":1},{\"id\":\"98b38e71-5e19-4eac-acf0-2587782b1f70\",\"name\":\"Reach Step 250\",\"payout\":3.6},{\"id\":\"00f1a77f-91ef-479c-a8bc-2f6b5aeb3a1e\",\"name\":\"Reach Step 500\",\"payout\":8.8},{\"id\":\"ac05bf9e-b583-4fbb-ab99-f6ed8fb78825\",\"name\":\"Reach Step 1000\",\"payout\":17.6},{\"id\":\"c2cd8e62-cd09-4dd2-a731-717d90aa4af9\",\"name\":\"Make a purchase\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(300, '1157816-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 12.52, 'https://notik.me/api-redirect?token=eyJpdiI6InA4WnhSRVl4cG1wd2NNZm80ZXNCMnc9PSIsInZhbHVlIjoiRXlqUXVXajFQZWhLWTAzSHA3L0NkcFZCaTdoRjMycDBVaU5tN1lDVjlIY0t6dzBhbjBKb1pTUUpmZXUrZ29XQmFBUFNCa3NYcUFQbkFObEdyZ2RiOUIrbmlVREhQRVgydlJ4QWJoNnRaL2VBakpEYUhTRjZNdDNjR0VvZ2p1ZHNDSzdIRXlaN2xGMEZ3RjFvZ3ZhNXNFNjJ4SVlJQTN0c0JIdk82bG5ESjZXTEJGak9TNW9mS3BRQ1ByZDZvUHo2dEtVZFJvdi93R2o4eTR6NEZ1SE5VcDZOWFE5dGNXNWRnT3NtU1MydU5Hb3FkeHJLcDV5M21aTGFVSXV6ZS9CY2dlZjZDOTdHMllaMFZTMndLVGRZckZOblVpS3BnTFdSeDNmRlBXY2I1Y1U9IiwibWFjIjoiY2YxY2JmZDRlMDY2YTZkNTQ4NzIzYTc4NDM3MjU3NjgyYmUzOTkxMjAwMzFhOWY2MWQ0ZGIxY2EwMzY5ZDJmMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE', '[{\"id\":\"2470a4ac-a601-412c-a120-04171853a8b6\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"ef3281d4-01f6-4a51-833e-5a43a9074cb3\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.08},{\"id\":\"cfbb0f97-2086-4b2d-9b05-dfd6b6658b08\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.44},{\"id\":\"1314c91a-b75f-4e4e-b327-b705adfcfbd0\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.88},{\"id\":\"010365cc-c747-455c-9b08-c0bff8473b30\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.76},{\"id\":\"56b7d912-2532-4f18-be6b-aafabc25eb07\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.36},{\"id\":\"e3d0e23c-18cc-4766-94fc-bec72d388fc5\",\"name\":\"Complete Hidden Level 200\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(301, '720134-lZ2kToJFfVYWxuk6', 'PineCone Research', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjlFbVZUa25ITVQyVWxOTEYrQzN1MEE9PSIsInZhbHVlIjoiUnc0TGlnU2V5ZEJUSmhBcUZOZ3NiYWg1K1JsWGcwKzhFbHR4M1BCSS9SMExFYWlnVzRlTTA0a0hjR2xKOXlsNWZFREpqS3ZtYkRvM1Z3M1hlQkJ2MTZXeWpXYWtaeTVZaUxLM0YrSHJVMjJ6MWJubUJrS1gyRXdCQUFBS0ZHTkRaVFZGd0dNUXVOZFJTT0Q1UTF3Y1FJRmRWZkFtNEtsSHprbytrSEl0QjJXSG1hMDV3eEd1eW1jdkU3UnpKa2FWdThFUnJmN0o2ZXlBeVZFS2FtV0ZiME1KVThZWGpPNjA1di9tZUtaQ212TXJZZStOdmdPSVVkbnpHVTd2UHRDbFFtMFdncW9rWmJ0TFQyQS9mSFoyNWc9PSIsIm1hYyI6Ijg3MGYzYTk4OGViMzM2Zjc5MWQxOWY0NDhiNTRjN2ExNDlhNzAxNjIyYzI4Zjg4YzlmNTlkZWQ0ZDQ2ZTc0ZjgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(302, '885262-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 5.71, 'https://notik.me/api-redirect?token=eyJpdiI6IkhpZlpwQ3hKUG03ci9jN3lZdms2V1E9PSIsInZhbHVlIjoiVHprR2ZyQUUwQjROVU5XclZjTGFSaTM2K0FoOFZwVDNmZVl1Y2JHNWx4NXR6SzRwRm14UHdXS0Z4TkNSUXZWMmhZSGZjQnlGNG5aZXhKRXRPZjdSWFBUNGdBY3NMWG03WXdIb2RCNlQ0UzhabWdNaDdrbU5iK3dLeXc2dWVwOUQ2UERiRGNXNVpmaDVkK0psQjdQeGpsTU5PM2k0QjM3Q25ZN2NlaDRwR2RxQlQ0cGhhSVZFOHBLUndSTEY2WllKeHJMa1JDT2paZHlaUjNVRnByM28xOHVFVVdTRExITVpaeHQ1bkdvL2JYbTNmdDQ4N1pEeW9TWS9lZE5zSTE1SklHejFERVFDSXRoTjY0alIzTjNlYlhseVh3WTZaWGdJRGJ6L1k0S1NaUWc9IiwibWFjIjoiYWZhNGU5MTliNWJmNzgwZDk0MjU1NGIxZDNiYzkwODI5MmVjMWQwYzFkZGEzYmNjM2Y3ZjYzZDdjYTljODI4MiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"f5d6fb4b-3639-4be6-8824-3be20e87ba4f\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f992356e-6cc1-4ad2-bbea-b40ab7892522\",\"name\":\"Reach Level 50\",\"payout\":0.168},{\"id\":\"f14ea91a-b07b-4cee-bb19-247e61815429\",\"name\":\"Reach Level 100\",\"payout\":0.224},{\"id\":\"35a1091e-66b5-42ba-a8b5-5cab2d401add\",\"name\":\"Reach Level 250\",\"payout\":0.84},{\"id\":\"974a9779-3876-47ff-a7f2-b9cba5e47890\",\"name\":\"Reach Level 500\",\"payout\":1.68},{\"id\":\"0df5e338-192b-41ce-bf8d-7e5b8805d518\",\"name\":\"Reach Level 1,000\",\"payout\":2.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(303, '1012464-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 19.60, 'https://notik.me/api-redirect?token=eyJpdiI6IkQyZnNjem8vbStSdUtlNi9PQkU1Qmc9PSIsInZhbHVlIjoiMm95Z3RlcDBtMFdndHZ2a0w2M0hiQjdoeGxsK3B4bi9uM1F4bjdsSFozckYxc2VGb2lYOWhxY28zZGtyaTAwTGFqS2lnQi9pNE9Lc1h5VlRTYVorT1hGM2FNMmhzNnVNVHczS3ZwRTBwbW9vYUNRMFlqM0tYeXptc0NxRmo5ODRlRkRpclo5dVUxb1dqZHRlbWNBVVNPeURKelBVTFFXWGlSRjdZd2pEdlZOaXVObXpqVEJ4SGVkdlp6SVRuMzlDOTJPYXJZR0x3RnEvT3ZkRTR2KzZoMXJ4NjNFM0FqRkNCSHpzMW5Mb0ZGVVhEcTNSMEluZktGRW5RNGNKUW0wMmx6Wi8vT3NTYzZjVkVyUWljSVRXbVRZYTZtYmNrS1E0TGZla2pQUHk3d0U9IiwibWFjIjoiYWFkZDQ5OTQ0Mjc2NjAyM2ZkMGRiODc0ODYyZGQ0NDkxYzY1N2Y5MTNiODQ4NDc2MDU2YjMxNDRhZGRkYzNiNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"bb37e83c-6b86-415b-ac5a-f908b61a06e3\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"a9c5c064-de49-482e-adf3-cdf114a213d8\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"7533a42e-4dcf-49d0-b5e0-cc7669446a83\",\"name\":\"Reach 500 Meters\",\"payout\":0.4},{\"id\":\"de85dd5d-370c-4fa4-83ca-a753705e4a35\",\"name\":\"Reach 700 Meters\",\"payout\":2},{\"id\":\"ab637a69-c377-46ce-99af-6dad51233099\",\"name\":\"Reach 900 Meters\",\"payout\":3.2},{\"id\":\"b0d4d786-5447-4187-84a0-fc21cc56f293\",\"name\":\"Reach 1,000 Meters\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(304, '1085921-lZ2kToJFfVYWxuk6', 'Amazon Prime Video', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6InJwR1JDbjc3S1NTT2tjNnhLQnMzYlE9PSIsInZhbHVlIjoiUUt0QjNnR2ZQSjI4bDUxQ2cyamNkR1Zud0VYUGRIVmd6ZFRmb1ZKMUkzaFI2SWluakZ5bWxkNzBVemlsbzBzcjd1Tk1vMXYrNXdjTEVxY0JRMlc1b0Y3ZStBY2Jjc0tOSkFOQjh3elovVkxEQTQvVGp5T3VwS3VLbEVGM05nVXV0MFdKN0Y0QWlUbXRuRy85L3V2cE5MeWxGeHN3M3Q5bEY4K0hCanE4YnQva2gvdFMvaEpaVzFnaG4vb1VFaUUrOEJiUVRjaU1adUYwZTFGaVNhM1U2QVlDd0tGSC9zT24vRTNQQ2ZZL2liTVRzTUNDaXF0UEdkRFZFcjlML2lYcmczbit6YUxQdERueUl3V1k1dEs2ZHd4UXN0blpOVExrUTFQaGVKU3NKWjA9IiwibWFjIjoiZmUyYjI3MWQzMmUzMjc2MzFiODc4Nzk5MjE2MmM0OWJhNGYyZmEyMzk3YmJhM2VlODQzZGZmYjI3ZjQxNjA3NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, AU, CL, MX, NZ', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(305, '1104075-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 23.33, 'https://notik.me/api-redirect?token=eyJpdiI6IlRxb1BiMnhNbkQycUNveWN3ODdNU3c9PSIsInZhbHVlIjoiU3NKbmtPS01iY2phQTcvdnV1bzNUaHk1WUJ0UllTaktGSk5BWm1CZVRZR0lwNE50bFFnbnQvbnc3R2tNcHdldVF6MEpabW1mQkNHUWptdjhlQ0ZaeE5adDNUSk1aQTAxdC8ySVJ6UENkWmJ3UGh6eWwvWEpSQVdIS1lSNU9JcE5LSFVhNjh5aE0yZWlGSDZFcTRZcXZnWDVBbTNVRUozQXNHcUNvWVlCeDcwUzhZejVOTUZiV3BOam13azl3MTVucXYxNW4xalVDSytOc0VrUU5XNFFoV0F3Yk5vMjNKbWl6dzNqZll4SU9DT29SOThDYXRWckFZczN5NHZIMWNpN0Mya2R1OUdtRmVEcUgyK2M3RUs1Y0tLVFA2amQrdDFhTXBKSHJ3a3cvUFE9IiwibWFjIjoiOWQwMjQxM2JjYjRlZTZiMTRmMjZjMzQyZDBkNTliNjAyMTkzZjc1YjQwZjJhM2VmZjJkNTM5NmExN2FlMjhlNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"1c7053b4-ded9-4938-90bb-26695a5fe422\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"a65fefd7-daf6-4dd3-b354-f27831ed239c\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"c7d9f0aa-7b37-4954-9987-c6f96466e081\",\"name\":\"Reach 500 Meters\",\"payout\":0.32},{\"id\":\"969211dd-9615-43db-b935-873262fadda4\",\"name\":\"Reach 700 Meters\",\"payout\":2.6},{\"id\":\"f7986f4e-3654-4d62-b51d-183acf34222c\",\"name\":\"Reach 900 Meters\",\"payout\":4.4},{\"id\":\"ba7f4b0a-8c25-409b-b05c-c7ae91245cb9\",\"name\":\"Reach 1,000 Meters\",\"payout\":16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(306, '1156693-lZ2kToJFfVYWxuk6', 'Sea Block 1010', '', NULL, 188.52, 'https://notik.me/api-redirect?token=eyJpdiI6ImNsaXYydHVmcHpndDNuSHd4M25ER1E9PSIsInZhbHVlIjoiS2NKb3QrdVprWHBISjZWR2QxSlptckZMY2tRUkJZTUdoSFp1MTlkbWVaQXhXYUkwZHFuYmhBWEpxMEtyQ1VOZE1QSVNEd3FNMHRpSDZLVjRtN3VxaVkwU0ZOSFU1TWxGdlBoMFJSam02d2d5R0hWUWJidlFKb09uZ3BNRHZ0MXBJN25yZ1ZTdmpUWXdpaEVFbXV5WEpHcEJtS25xSy9HZExZcEpGYVdFa0VYalVGY1p3Y3JTZG80ZldJeWM5Q0dsSFo3YnZuSVBmQVM0KzdOQXA4N1JQUjIzUW55ajI2TGdRTHR3Qlo5OURoK1dMYTA1M1dJa01INnFJMkJrcGc4alNYNzlodVovSGlTK2hCcVVxTEgvZjBCU2EzSjcweS9lSzN4Ri9mYlF6aDg9IiwibWFjIjoiM2RlZTcxMWE4ZGNlZjBiYTJiZmFlN2M1NzJkZGFhMmFiMDQ1ZmVjNDgzOTEwNjk4ODE1Mjg2NmFlNDdhMWM1MiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"2d81ec94-0c05-11ef-a16b-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"2d820e4a-0c05-11ef-8cde-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.12},{\"id\":\"2d82170a-0c05-11ef-8c47-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.24},{\"id\":\"2d821eb2-0c05-11ef-b45d-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.96},{\"id\":\"2d82265a-0c05-11ef-a816-069eb31df495\",\"name\":\"Level 15\",\"payout\":2.4},{\"id\":\"2d822e0c-0c05-11ef-8d56-069eb31df495\",\"name\":\"Level 20\",\"payout\":9.6},{\"id\":\"2d8235e6-0c05-11ef-a402-069eb31df495\",\"name\":\"Level 25\",\"payout\":19.2},{\"id\":\"2d823df2-0c05-11ef-ad50-069eb31df495\",\"name\":\"Level 30\",\"payout\":36},{\"id\":\"2d824612-0c05-11ef-a570-069eb31df495\",\"name\":\"Level 40\",\"payout\":120}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(307, '1273916-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.93, 'https://notik.me/api-redirect?token=eyJpdiI6InY5RjNjZGxrTnc3cnZtRzFFQ1dHUWc9PSIsInZhbHVlIjoiQTdZSFBFY0RTaWdESVVwNWpoUDB1Wk0zcC90UVhlRGFCUC9uUHRzZ1dPYkJublROVTJpTFNxZWx2eCtGa1RTUjlIQ0lVUzlqU2NtZ0NYMEwxS1BPbW1wV2UwRW03NHFiZjI5ekw5Umk0K1RvVm9vQU4zaE1hK25YeTluV1RwTllYUlAvM3Bxck5nRGpkM3BnT3lnVFlYaVpTNDdaRU1CZkNXV3FmeDBxNVNJVzdXc1VGZk9JaW5meUh3TkduOWdUR1dSS0FaMkJLN2RTVVhEWk5NK1QzTE54MmpRMFNZWVZ1ZG1hSER3R2hWQUIwNFcwTmliYVV6RTUvemJqNWI5eUx0eU4rSG9LTE5PMEtzaSs5Z2NzUElYaGRVdm1pZGs0dDNZajJsYWd6U0k9IiwibWFjIjoiYzVkZjJlN2Y4ZTdiOWFiZTNhODIyM2ViOWJkMTRkY2Y5OTZhYmZlMzI3MWUwNDk2NmZlMmI3MjAxNTg4M2RlYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"485ca498-ee28-4fc9-b9e4-868a9c376c32\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"a6d56a18-0811-4b72-83db-8e26b5b70ae4\",\"name\":\"Reach Level 20\",\"payout\":0.012},{\"id\":\"88f162e3-8ea5-4203-ba43-04758550cc33\",\"name\":\"Reach Level 50\",\"payout\":0.112},{\"id\":\"88a0415b-06f1-4f7e-bb3a-d8c3135f420f\",\"name\":\"Reach Level 100\",\"payout\":0.208},{\"id\":\"bd760e3b-1151-4aaa-b675-ca46a1f33137\",\"name\":\"Reach Level 300\",\"payout\":0.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(308, '669844-lZ2kToJFfVYWxuk6', '1 Minute Quiz', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6InpqV1VKMUtPaGt3OFh1STJyTTZoVmc9PSIsInZhbHVlIjoic2dLNjVWdGtaQjd5cmowVllXeW5EZGEzUm8vQVhPNC9QNi85akgybjVmVlZoZ25lbWNYbmJnZjRudDBCNWM0dWRvQTd1QXJuS09YbzVtUGVhdWx5ODFKUmtpVlVyS2VZdU9DWjJLTGR4Wm85U1ZtZ2ZDcTBWT1liUUJya3ZZSGYvR0FZTm9pYUx1YnJNbjRiSUIvUnNUTWIxY1dBRnpsaWxaUkRZbGsrWUlsRk52QzBwckVPOVIyVnN4OEVqVTAvUHpiaS95dFZBOHhrNE41OE1CODUzRnZMUWlTcHk5K01YQ0N5a3YwWXlZbnVCOFBKMk1ucXJWZVhyRStNNFpMbnZBM1RPVys1WVBGNDlKRVNaZWNPTHc9PSIsIm1hYyI6ImM5YTQ2ODhlMGExODE1ZmJhYzY4NTcxZTU2Njg1YjM3ODAwZjc3NmU2MDdlNGNjODQ1NWIxYmNlMjdlYTVmYTQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(309, '1126592-lZ2kToJFfVYWxuk6', 'Smash Party', '', NULL, 24.64, 'https://notik.me/api-redirect?token=eyJpdiI6ImZYNGJ0c2pvWHpUempCcy9CZk9CSEE9PSIsInZhbHVlIjoiYm1jOHRDbEpHMmhOZ0VLWmkvNWNWSm1KSUszb0lhUC83eExScENWWEo5RXVnN1ZEcDh4ME9WbUp6cFFRNFNhVk5hR2p5RTI4OW5DZUUwdUxVSjZvcXJJMk1mZHdKa2NiNndCVUdRM1A3bmlMRWl3Um1aclA1cDVRQXRTTzkvemRUR1FkV0hPMlBuT3hxbDVKSTVLR09NcVFhUVNSY1pTWkhCNHpQcnpWbEw0VHczcDRHejBGcXAyNzdiMkt1ektNb0MzdmsvUzVGR0xwY1FzYzhyVDFiYWp1ZnJxOVdvR0xHOUtpazEvaTRCRXZyYjBEUWVHTWxNQmRVN0x6ZUJ6Uk5IRFlVZ0N3bXp6bzYydlBRcFFzblE9PSIsIm1hYyI6ImJhNzRhNWVlNTA2MTQ1ZmU4ODA5NWIyMDQxNTc1MGJhY2U0ZjAyMTg1Yzk2NDY0OWU2Nzg3YzdhYzI3NThkMzIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, IT, NZ, CH, GB', '[{\"id\":\"47f68946-ead5-11ee-94e8-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"47f6ab24-ead5-11ee-8680-069eb31df495\",\"name\":\"World 2\",\"payout\":0.024},{\"id\":\"47f6b40c-ead5-11ee-8c0a-069eb31df495\",\"name\":\"World 3\",\"payout\":0.036},{\"id\":\"47f6bbaa-ead5-11ee-b439-069eb31df495\",\"name\":\"World 4\",\"payout\":0.048},{\"id\":\"76e17982-fb6f-11ee-ac01-069eb31df495\",\"name\":\"World 5\",\"payout\":0.24},{\"id\":\"47f6c35c-ead5-11ee-9bf9-069eb31df495\",\"name\":\"World 6\",\"payout\":0.48},{\"id\":\"47f6caf0-ead5-11ee-81a4-069eb31df495\",\"name\":\"World 8\",\"payout\":1.92},{\"id\":\"47f6d34c-ead5-11ee-95f7-069eb31df495\",\"name\":\"Hard World 8\",\"payout\":4.728},{\"id\":\"47f6db76-ead5-11ee-b686-069eb31df495\",\"name\":\"Complete Game\",\"payout\":16.8},{\"id\":\"17e73bcc-eded-11ee-a0e6-069eb31df495\",\"name\":\"Purchase\",\"payout\":0.36},{\"id\":\"b17f16f8-e31d-11ef-8677-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(310, '1156263-lZ2kToJFfVYWxuk6', 'Sea Block 1010', '', NULL, 188.12, 'https://notik.me/api-redirect?token=eyJpdiI6IkJmYXlHSzhOc2FUREM3MkpaUzRlWWc9PSIsInZhbHVlIjoiejRVYXlzRm4xWmh0b2o1b1RhTjBlaTQ1UHBRS2tCNDNsdzVoMWxwTy91Q2IwelM3T2NZVjRrVmtlSDVheHY4M0dwNjRlcENxNC9oZWlwb3BsOVBsbGpDekZnek1qb2Q4SjFSd3BvMnJaelNnSVNhMFp2ZldMNWVvZ0t5MXBtK1EwcDhXb2YzR3BCS1k5Ykk2bEhHR2ZTUkhwdDdUakViSXNrR2gyald6ZWtPTlpuOExGMGhuZDZZemNwVy9IV3E0RjRydUdkMVNBeXdSNDdVMkdYd3dzREZpVTA2cnlhdjRuZUZuSTJwdW54TzhTTEo1SDlhSHhwclVUUENPcHlkMjZSYjNDaFVxek5JL1VEbTlCUGFOTzdhN2hOeFgvUGE3Y0V6VnpaMTBvSkE9IiwibWFjIjoiYmY0NTAwYWEwMmQ2NjZhNThiNTYzZDAwMmQyYjc5NGUxYjJkYzg2NDk5OWMzOTI4YjEzYTcwZDhlZDc0ZGVjNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"668c8de8-fe8e-11ee-81b0-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"668cae36-fe8e-11ee-b1a1-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.12},{\"id\":\"668cb6ce-fe8e-11ee-84cd-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.24},{\"id\":\"668cbe8a-fe8e-11ee-848d-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.96},{\"id\":\"668cc61e-fe8e-11ee-969f-069eb31df495\",\"name\":\"Level 15\",\"payout\":2},{\"id\":\"668ccde4-fe8e-11ee-a44b-069eb31df495\",\"name\":\"Level 20\",\"payout\":9.6},{\"id\":\"668cd726-fe8e-11ee-aacb-069eb31df495\",\"name\":\"Level 25\",\"payout\":19.2},{\"id\":\"668cdf3c-fe8e-11ee-995d-069eb31df495\",\"name\":\"Level 30\",\"payout\":36},{\"id\":\"668ce75c-fe8e-11ee-8960-069eb31df495\",\"name\":\"Level 40\",\"payout\":120}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(311, '409271-lZ2kToJFfVYWxuk6', 'Rewards Giant - McDonalds', '', NULL, 4.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImdPYkg4SEt3VWkyejk0ak9sdDJqYXc9PSIsInZhbHVlIjoiZVRSTXlXWHlWeTVlc1NaK3RidzAwMHVLbnNWb3V6YzVOS3hpN3l6WFRXSVluWDFYU1p2Q1U3WU9FKzJ6Q0M2Um5vNWdFb0tEMlhxb2JkbnJMMzMyU2pqVy9FYkJyUzl3Y3JPSFBBeVN3YTJjOWU1aCtLRkl3eEVrR2tpN1VZOWEyM1dzSGM5VnhUTkI4ellIN25qZVNMVmpPajM5RXhaMmhWNGsyUzg2Y0wxWDFQTWU3TlUrQW1wQ2ZDZm5OWTNPL2ZGcEQ0ZXVYeGxEY0hkNGowWkZXQ2wyekV6czFLNWtZZ0o5RnV0ZHZwbjNuTzV2YUp2V0lES0FOV0kyYWhDRHlBa01PaXNLRk5IUWN3L1N6bVR3MWkvUHVRNU45WWFWNWx1cVB1VkNvK2c9IiwibWFjIjoiYWEwZjY4OWMwZjU5ZGNmM2E1ZTAxNDdjMWExMDdjMmQ0NDFiMzFmYTkxMjg0MDVlNGQ3NzRkZDdjMWYxYWI4NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(312, '674760-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 261.77, 'https://notik.me/api-redirect?token=eyJpdiI6IjNjRzJQMFNiemRiSzk4dkZ5TkpLWGc9PSIsInZhbHVlIjoiclpTSWRNVGdqUWxwR01NRkxFb2E2cHZVcVNQZjBnOUhNeEQwQ1dQd1NaMHpFZzU4c1NvZkE4YW02aHpqWm9NWmRuWjZpWjB5cjRpY1c4bFNPandWWDNYSXhDNU1admkyTjVmRDBtNTJRUThnWDErdFlWV2NidzJta0VucFJEcDVwL2Q2VWdsMm91VithNXdxMlN0QXlGZGVqVkJCZlRjMmlNbEl5VGRhTklLQVpNUHNOdTlpdU9PMDZQZ3ZGTUEvME43ZXE2VjF0bmxlRXdRVElVUldpRmRWS1l3MGpWTmZvUElkZytIeFZNc2Y2VGVKYTVvTUVUSi8yWTc2NXdaRW5HeGdBUStuT3FGampMclhNb1hTajkxOWY5ZWY4eHVGSU9Sc3hrSFZYUE09IiwibWFjIjoiOGRkZGIwNjczMmE2Mzc5MDVkNDQxMWFlNzgwOThiNDBhMTI4Yzg5ZWZmYmE4ODVlMzExMWU3ZDNkM2E3YjhiNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"fe39f1e8-170c-47cf-ade5-f4c8982c5428\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"da5cf9f3-8974-48b4-9865-fa8967529c33\",\"name\":\"Reach 100 Meters\",\"payout\":0.012},{\"id\":\"68ab7483-393c-4194-b7f3-073bd5ac6c33\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"ae2e89d9-9735-4489-a1be-6b31d525838f\",\"name\":\"Reach 550 Meters\",\"payout\":0.14},{\"id\":\"6853981b-9b20-439d-8e4c-6d4c9bd3bb5c\",\"name\":\"Reach 600 Meters\",\"payout\":1.2},{\"id\":\"0c9c6fcb-3019-4b79-bcf5-c6f5c9761a95\",\"name\":\"Reach 700 Meters\",\"payout\":2.4},{\"id\":\"04bc6493-13a6-40a4-9ebb-c520d791822d\",\"name\":\"Reach 900 Meters\",\"payout\":14},{\"id\":\"75765fdb-a95e-4b80-8de3-21d90e971ae6\",\"name\":\"Reach 1,000 Meters\",\"payout\":28},{\"id\":\"dc7aa79c-af5d-49b5-8382-8535864eb995\",\"name\":\"Reach 2,000 Meters\",\"payout\":56},{\"id\":\"7807a7ec-cc05-4d09-afc3-6cf3c110df2b\",\"name\":\"Reach 5000 Meters\",\"payout\":160}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(313, '885270-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 8.15, 'https://notik.me/api-redirect?token=eyJpdiI6IlI0SzN1SlNsS0xIT0U2SEpzbTlQQUE9PSIsInZhbHVlIjoiMlV1blRXc1hERzFFTWcrQWZiR3B3MXl1RHVUYlFwQVp3cktnM254VXlYWVFPbUJad3EvQ2JKL1pMTC9hU1VHVjFMTVM2OHhyZDhwSHpKaDBNUjRVUDJ3Wkw2ZC9mQjUycHdEN0RKRmltbDRoeFExVkdsV1drRHplcEdjTlJ2YnlXdEdIbkNmb1NkbTFGckVicVM1VWdwS2NNTzRyODh4azR3K2l0YkFKWWtqeEZ1a01mODRoZGM1NkJ5TVM0aGtWU0hSVWQrOWNycVNTNnBFVFlWMGZibEtudjkwWmRYRnVvRmt2d01WRzhUZ1pDdWpxNzFSYUY0VkphUThjaytaUUNxcGtoSitETGhZUlpGUnJ4QWMxd0Y0em92ODdQekpsQXd2cXdkQ1hKSE09IiwibWFjIjoiM2Q0MTNhNWU5NTVlNzI0MWJmODkwYjYyMGFhYjA2ZDY5YzYxZDU2Y2I0MzMxMDFjMWRiOWY0YWFkMTNjYjUwMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ, GB', '[{\"id\":\"5cd47392-045e-4539-9d11-723566aa1114\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"c13d24f5-baf2-45fc-8015-ed189911310e\",\"name\":\"Reach Level 50\",\"payout\":0.14},{\"id\":\"79649b1d-5fa5-46c7-9ae5-076c45ede1e2\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"e0870a3a-dd86-4bc3-a5a1-79be7bf64b0e\",\"name\":\"Reach Level 250\",\"payout\":0.48},{\"id\":\"beb2328b-3e60-4741-8aca-97f4f64f50cb\",\"name\":\"Reach Level 500\",\"payout\":1.12},{\"id\":\"5d1dcf8d-1674-4ef1-955e-4ef67523e13b\",\"name\":\"Reach Level 1,000\",\"payout\":2.24},{\"id\":\"742359c5-9b2c-4362-a8f9-81b1ddae302d\",\"name\":\"Reach Level 2,000\",\"payout\":4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(314, '1273864-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 1.33, 'https://notik.me/api-redirect?token=eyJpdiI6IjJHRHNxTEw5Ly9lSFFNSXdaVmpTVlE9PSIsInZhbHVlIjoiV0JoNDNubWRPdHBZTXNuUmJrZXVwalRrOVhrcnR3dlNBejZjY2kvekF1T1ZnU3VCeTA2MHlCekR6WnN0VUtpZ01rNXIwcXI4VjlKZzB0TlErRHRWaEMxWXA4OS8yY0kvUnlkalJjaDdhYjRiaGpWeUZBdFd3aHJwWE5KNFRvbkYrcVRYSXpnMUVjUFpKZDJRRHNrblB0Z2ErOUVrQmRFYlNpK3FhTTBySndERWVyVTVkQ1BweVJjYkVzUXIwd2cyT3AwZEFRbXZhbTVOTjM1YzB4SHl2NTg4WnpNeUk0U1BBMDI3eHBTN1NYSzU2aTc0QWF1S1ZWR0tmbkk4ZW1pc085RTI1SEhTOUpSbEVjVUxOYW1VcVRQQ0FyaU81OERBRmZwbE9XUUdXUm89IiwibWFjIjoiZGMyNGI0Y2UwNmQxN2FhMjQ0MGYzMjA5MzRlZjI0YjNlOWUwODJlYzA2MjA4MWYyM2YyNzlhOWUwN2Y5YWVmYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"f1226728-5ad7-4ef0-8793-6c6f1e7dfa44\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"47737524-f828-419f-9bef-ab6c0d9093bc\",\"name\":\"Reach Level 20\",\"payout\":0.04},{\"id\":\"b56ac19a-c1af-469e-98de-64f0dd327b1a\",\"name\":\"Reach Level 50\",\"payout\":0.196},{\"id\":\"e077cd59-11ad-4c8a-9732-4a7902ac77ea\",\"name\":\"Reach Level 100\",\"payout\":0.252},{\"id\":\"4f27e74a-c163-46c5-8563-6b406fffe017\",\"name\":\"Reach Level 300\",\"payout\":0.84}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(315, '414027-lZ2kToJFfVYWxuk6', 'Up Level Rewards - Taco Bell', '', NULL, 4.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImNvMERoemJSU0gvb3VrMzRmTXJuY3c9PSIsInZhbHVlIjoiQ3k2blErdmhkT1dseXZKY29QRXVESFBSbU9DZG15SzRsblAwK3FOakJJdGp4ZmFOQ0NxOC9ERDg5REFtTGxHWmdOVS9heUw1ZjRPNTFiY1F0c09LVWNJSWJlWUFwNXg3WGtZTDAwNnVtS1VTUnMzNlR6MEFObE1qMWxMNHFKaUdFcmthek1WcXBlVXVBdytkMUoyaUhqLzBTWk5LbzJuWTBOK2tFNmV5MHFhZFR6T2E1N0NHOHNZY21Ub1VReS9STkJGajAwVGlVSU9xeTZ6aHQ5MDhyMU84cGRqVjludEh1U1JlVHF3Zm5ZL3NNNmIrM2dzMi8wUFBaWittSFdDWkZoU0tQbVJXU3FKMlZ5R0dWbUk5bzBUc3Vua2VNY0JxanhYNUJ1R21sNHc9IiwibWFjIjoiZGFkYjgxMzI1ZmQ0MjkzZDNkZjAwYWYyMWZkZjg2NTg0ZDRmNzQxMDVlZWNlNDkyNTZiNDQ0NGU3NWI2Y2E3MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(316, '1126693-lZ2kToJFfVYWxuk6', 'Lucky Bingo', '', NULL, 27.80, 'https://notik.me/api-redirect?token=eyJpdiI6InYxVlR3OXNlZXZwaGpKbHI1cTBkZXc9PSIsInZhbHVlIjoiYmdrMWVrcWxHVTJ1TGJDVnZUTy9DMW5Tb0NwVUNYd05pM01HNUxZdkcvWXFadk1TdXhGRWFicUtJU3ZCdEdCeXhueFZJbURWMFhDYW5OTzdmTWZkNHMwNkhzalRWeFJUWmcvOTRGaHhjdnlydlNrdk9vT2FpMFdlUG9zeEN3cWtKaVEwL3pPdVBmVEtlL3BHRWhhTDdoWXJtQWc4ZC9IUnczWExyQ2Q0TkxnV1BrSkVWdDNSVjVCdDV5U29kWVVKbEZxLytoYWw3Rjg3Ri9JdjdMMld6c3RaVXoyemhzUlVnSUdmeWtTVFp0VDdFSTRhSjNZTW55VXdtcGwxOUdhSTBwRDBMT2NITjQvcGIwcmlRbnU2ZFE9PSIsIm1hYyI6Ijk2NDJlOWEwMDk5MWQ0NjFhYjUyNzg3NjVlM2I5ZmU4YzZhM2QyYjhjZDc4ZjhhMGU0ODcwYmI0YTc0ZTU4YjUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"ff13cec0-eae1-11ee-bb15-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"ff13f21a-eae1-11ee-8e04-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.04},{\"id\":\"ff13fbac-eae1-11ee-bb4c-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.16},{\"id\":\"ff14034a-eae1-11ee-9d00-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":1.2},{\"id\":\"ff140c0a-eae1-11ee-9ead-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":5.2},{\"id\":\"ff1413d0-eae1-11ee-8cdb-069eb31df495\",\"name\":\"Reach Level 70\",\"payout\":20},{\"id\":\"ff141baa-eae1-11ee-bde4-069eb31df495\",\"name\":\"Purchase any $4.99 Package\",\"payout\":1.2},{\"id\":\"c1619a08-37ad-11ef-8a93-069eb31df495\",\"name\":\"Purchase\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(317, '1162233-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 8.04, 'https://notik.me/api-redirect?token=eyJpdiI6InFBVWlUcW1ENldzbCs3bFl6NW9wT2c9PSIsInZhbHVlIjoiRFBDUXhHVW4rOVdSNU05WEUySUVWaFE5THJ3MGU1V1Q1SzBRcWRKakR3UnIvZUJKUHBNZUpJbU1KL01oVXRNd09BTzZRY0xPeituSXdMRWJENk4wOFZIMHpOM3BobUk3aUVjUnpRUEwxcSt0VTIvRW54MWR0OXI4ZloyV0JMc3JvdzEzTHlsdDY4UTZRb3FSdm5rTmQ0TDlBNHlUM1N0U0M3RWlwdWNtcmhnRUdoR0FaR3Brb291TXFvMzc1R2RDWWZBKzJuRU8yREJFQUxFKzVQZmZDWm5GaG9jd2oxRDI1U1YrSjlWbjBzQmpOT1dndEZIQmltWXNmZDdrbjNyNUVFb21CZEQ0WmppOFRnMUdMSXdsd0pCOFlrTnRSN0pPYmdyVXlDVzJWWTQ9IiwibWFjIjoiMGVhZTU2ODM4YjFmZjFhZDIzNTlkMjA1M2Q0YzRmNGYwODA1YzQzMmFlODFlNTcwZmVjMzJiNjczZTFjZjNhNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, NL, NO, SE', '[{\"id\":\"d4692693-451d-4554-9394-76115b2041b0\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"fb154023-4137-4792-86e9-d4e497c4a1e8\",\"name\":\"Complete Level 50\",\"payout\":0.14},{\"id\":\"a98a8f59-7182-4b6c-9490-f8a683a5cdcb\",\"name\":\"Complete Level 100\",\"payout\":0.14},{\"id\":\"1b886e8f-e157-4ca1-93c9-539c8c25403a\",\"name\":\"Complete Level 250\",\"payout\":0.36},{\"id\":\"bef44ed0-19a5-4489-b517-b9ade016dcce\",\"name\":\"Complete Level 500\",\"payout\":1.2},{\"id\":\"9d3cf525-19d8-40d8-8c33-77a63d4dd654\",\"name\":\"Complete Level 1000\",\"payout\":2},{\"id\":\"72cf5d56-b15e-43c0-871e-59eba0b35492\",\"name\":\"Complete Level 2000\",\"payout\":4},{\"id\":\"bad7539c-3c94-4bbc-a8a5-e650880ae507\",\"name\":\"Make any Purchase\",\"payout\":0.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(318, '672966-lZ2kToJFfVYWxuk6', 'Wild Fish', '', NULL, 78.90, 'https://notik.me/api-redirect?token=eyJpdiI6IlhKM1FwMVF6WExVNm5aUG8rdWhjK3c9PSIsInZhbHVlIjoiN3pUU1NWQjRuSzlhOThjOFJDcnliT0hmSE1oTWsxV3RwZlEzYk1DdkwzaG1CdzVYdFVzeTlTYTJBUVdadWRUTVptTlpnVER6dnlaRzZqOTFTYzJLeTFBRlNQdmtCbkNBLzhMTHk5V1QvSzJ2ZlRldHE0N056MHV2OG5CSldKYXFMbFhnOWZJbENPQ3BYY0hYWlRDZm1NSFNUenQ5a3JsL2dtUHRvR0xxSERiNlU3NFJUNTdXdTU1b1pvaGR2SVBURFkxZDEvL0xYL0VwandqRGlHR296S05oUzFQbTYxNmg0U2tyUjhKb0FuWlZIWHVXYlpqVFpYZ2lRTkFIOGhtRFN0OThBVkpDWW81L21oN1dBa0dzR0E9PSIsIm1hYyI6ImM2YWY2NGI4OGMwNTJjNzYzYTdhMTZmNTdkMDE4M2IyNGVhN2Q1M2Q5NzJhNTQxZmI2NzgzODMzNzhhMzI1MGQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"a15fce0b-350d-4e3c-b265-863b7f379939\",\"name\":\"Play Wild Fish !\",\"payout\":0},{\"id\":\"4a0004f7-ddec-4a57-9bed-af1879718936\",\"name\":\"Reach 100 Meters!\",\"payout\":0.004},{\"id\":\"ff086389-c50e-4d91-9908-7295efb632a8\",\"name\":\"Reach 200 Meters!\",\"payout\":0.1},{\"id\":\"38888a49-5e5a-448c-9be3-d77e063b20d2\",\"name\":\"Reach 400 Meters!\",\"payout\":2.8},{\"id\":\"5793f6f3-eed1-4785-871d-a504282cea8b\",\"name\":\"Reach 1,200 Meters!\",\"payout\":8.8},{\"id\":\"a6a6cd4d-8cf3-4d37-8c84-c7e0e366c6bf\",\"name\":\"Reach 5,000 Meters!\",\"payout\":16.4},{\"id\":\"054d97ea-a992-4beb-a1e2-960552341421\",\"name\":\"Reach 10,000 Meters!\",\"payout\":50.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(319, '672967-lZ2kToJFfVYWxuk6', 'Wild Fish', '', NULL, 54.10, 'https://notik.me/api-redirect?token=eyJpdiI6IlRpS0cyUkJuSTk1Z1FjRjF1K0NickE9PSIsInZhbHVlIjoiaVBmM3VvZFZXSUN0NjIzbzMvcG5oaU5nUDFsM0JWT0NxWXo3UEd3KzcxYVdIemg4dG13R0xrYnhld1JjVVRrUGJ1dUlUY0lYRFMvL3Yvb2hiY2UxemJzbHhJNUQ1c2Zwb1R0WjlrUWxnSUVqVHZHdTlvSm1pR0xrTmZ2L1ZwdnVaQnJ6MEsybXB0U0xxeFhuN0ZZRnIyRjZtWlZQMGpqNlQ5TElybWsxbEVsZHRMYmE3UW83bE54ampSNXZBTUVXYkxEVFFxUjRLaEFmQk5uZ1p2aVpQZDFSTU1BM2dxNzFsbFJZbXFMMXlBYlJiUVNVaklkR1ppNGNiOWk4aXV0UG5GUS9Uck9IVjlueTc4cXZGdXRIQmc9PSIsIm1hYyI6ImRhZjg3N2I2YjlmYWMwNWE5MjNkNGNiMmU5MWFmYjY4ZWYzZTQ1NTdkMDZiMzFlYTdjOTgzMzg4Y2JhMzgyMDQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"b0c8b9f9-0165-4b22-9253-7c514e8376c8\",\"name\":\"Play Wild Fish !\",\"payout\":0},{\"id\":\"7b218227-63e0-429a-ab54-aad35b7af3b5\",\"name\":\"Reach 100 Meters!\",\"payout\":0.004},{\"id\":\"5acbd802-79c9-42d5-bc67-641c4ec62c22\",\"name\":\"Reach 200 Meters!\",\"payout\":0.06},{\"id\":\"56f6b49b-18bd-42bd-a681-df4e6f9fd18c\",\"name\":\"Reach 400 Meters!\",\"payout\":1.64},{\"id\":\"4a89ce6e-46e8-4954-9acd-fcf33b934f46\",\"name\":\"Reach 1,200 Meters!\",\"payout\":5.6},{\"id\":\"0248c15a-0cfc-4e68-bdba-9230c7d6a371\",\"name\":\"Reach 5,000 Meters!\",\"payout\":10.8},{\"id\":\"f3cb5c4e-becd-497e-877b-263cde0870c1\",\"name\":\"Reach 10,000 Meters!\",\"payout\":36}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(320, '677674-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1yTmdveGlicGE1U0xYZk1vREViOWc9PSIsInZhbHVlIjoiZVFVR1hvWjhqQlRpclNDd3NNSlMrQUx2YVV6WktQLy84aU9PaVdaclp6WDZrNlJwSVlOSDR5aXVPYTRpRnNnN3dMSVlVY2JFZTNaWnpVM202MkVSdVQvbmFaOUNubWVxdlBpWjMzQkExWFRxbllUM2l2VmFaMXBiRDlNVXBUTmVlS2NtazFZdUZJK2NnQlg0K2RhZnFNcWlFamFxdXZXak4rejgvbHlxb28waTU1VmhEQ09EK2I3MG83cG0xckNRWkxlRmJGR1RKdFVXTTl1dEZFWkhGQlBaQWtJTXhCYWkxSnRzaHpWdHdlTmxpS2hLQ1c5NDQyTnVVYzEzMlpZL1QwYW14RlJobGNHaUFyQUVoNGlSdkFaclNMcFhVRTZIeExqaTBjWmxXU1k9IiwibWFjIjoiOGQzNWQxNjI0NTU4ODgzMTAzYTAxNWI0MjZlMDkzYmQ3MmIzODdlYmUzOTMwYzkzN2U3ZDVhMzhkNDg3MzI0OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, HK, IE, NL, NO, SE, TW', '[{\"id\":\"58b148ad-63b4-4ea1-9f87-0c9c8d16b56a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"027b76ca-4caa-4cb0-84f1-44411abc1f56\",\"name\":\"Reach Level 100\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(321, '409052-lZ2kToJFfVYWxuk6', 'CashBaron: Play to Earn Money', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlRiMWRML0Nybk1nYWprdFc0WGZCQnc9PSIsInZhbHVlIjoiM3FKYXRVVHJLc3dRZW1zNnJoZlRndTMyaFdyUTN1MEh5UGd3ZzBic0pyd3hzc0NxOEEzL015MzBKVWlQc1BLa2gzMUR5aGhHQko0V1EwSTVndXFlMlRad0RURGh5K3U3bzVFdnFKNzJmMlNtb3creWkwSEdJVHMraUJJdWlBZ3YvN3Z5TDNOaHpENVlCQjdCdmNFV3ZwclljclJ4MytnbEkveGdCZmJYdmtiVDllaXduS24yUDVxNVdFUmNzQmNEOEJOdUx2Mm4wRU9TL2RyVGJ5a2dOYnlDQjNyTWF1ODdpd1VXdTR2azN2YzdreWxmeTJJeGp1RDVYa3ZMQzQrVWkwellBK20xYjVZdUpDNmE5Z0ZlcDFGM0VmQ1BRZmFYSmMwVnVUTnZCdFU9IiwibWFjIjoiMGM2ZDU4MTEzMzdiNjY0Zjc2NmI2NjVlNzQ0ZDU5MjAwOTI0NTMyMDBiMjA0ZDJhNWUyMjcwOWRlNGI4N2MzMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, DE, GB', '[{\"id\":\"73252b8a-6277-4df8-b5a4-43258e6f6af4\",\"name\":\"Open CashBaron: Play to Earn Money\",\"payout\":0},{\"id\":\"521c051a-d71f-4d89-a57c-fc16df726a9a\",\"name\":\"Complete First Survey\",\"payout\":0.32}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(322, '696474-lZ2kToJFfVYWxuk6', 'Blast Friends: Match 3 Puzzle', '', NULL, 8.55, 'https://notik.me/api-redirect?token=eyJpdiI6Ikx4Mng1OGEyemgxNDNEa25adjB4YkE9PSIsInZhbHVlIjoiRmU0VWF2dTNlVHQ1eS9KRDFHcUpOZVJFVTVFK3FIV2txUk1vUzJVZTN6YXYrd2xncFQ0NCtNWWxXcjJ3Znp1cFV4SmNkVTdYdFJRdmtYd3NTdVBHVmdDTmwxaHlVS21JNVlzN3ZPTXBxUWMzMEdyL0ZmTmdoMGYvdjZKb3NiMEgvbE92eGF5U0RqNDUxSGpPVmtUUk8xc3JleVpzcUs1OHNPbzZMZEFmVDZDQW1lR05MSGl5UXZZRlcydVR3dUhSRXhHS3NVYUN6Z1lMQytiSC81dzgzSUJxVG53MWhMRi9RSHFFQUltR0FIUXFDZWQ2cXhsY1VTOUkrcUFQdndOamk3VnUvaXhudDArRzdkWlhxaGM5d25SYzcraTVMNnppSGxhLzlRNy9OdlE9IiwibWFjIjoiMDc4NDI1ZjlhZmIyNTEzMzQ5MmEyN2JlMjYwODYxZmJhYzFkMzIzZDZhMzM2MzY3Mjk4YWU5M2RmZmQ1NWRkMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"f3fa7540-0a9f-4215-b3fd-dd66684350ed\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"2eb5dce8-7cdf-4247-b161-0f2d5a3f1a25\",\"name\":\"Reach Level 50\",\"payout\":0.16},{\"id\":\"a350df6f-6a7c-4c59-8541-63ec11c4ee4b\",\"name\":\"Reach Level 100\",\"payout\":0.208},{\"id\":\"18997d23-3eec-4886-a6b3-f68e79860e32\",\"name\":\"Reach Level 200\",\"payout\":0.34},{\"id\":\"e89901e4-0938-415b-8957-e8bc4e6d97cb\",\"name\":\"Reach Level 500\",\"payout\":1.4},{\"id\":\"5759fda4-3c98-4216-8098-b9d68f9b6c3c\",\"name\":\"Reach Level 1,000\",\"payout\":2.24},{\"id\":\"c8493133-27ba-4fdf-bc8a-bb022d9d6266\",\"name\":\"Reach Level 2,000\",\"payout\":4.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04');
INSERT INTO `offers` VALUES
(323, '943177-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 10.61, 'https://notik.me/api-redirect?token=eyJpdiI6IktnckNjdXBlV0d0UWtrRTlTd25HM1E9PSIsInZhbHVlIjoibmNqWDZhcUxhUVc5cGVUV1FHL2tIc3BRc1hmNVkxOUpjdks5azdvL3czTjdldjU1UDRIQWhUYkthTk5Kd1BMVjBlOGJRNUNYNlhRZVlMTWRXVi8xS3ZJbS9ObEpwTGt4d09KNHdBR2ZaSWhTczRHRStoeHVudUVVTFFtb2hDNHZiL1cyRjZoVis4dEROUmptdDZoL0QzWGN1U3RFa1BVMzRabk91RUl1VU5QTGFQK0l0ckpPMWh5VjFNWEVuUDNGQThhSkErTGZmYUhVZGYzem9hMWpnQkhTL1dDQTArUVI5NWpkVlFVUXQzcS9SL3N2bVI5WHRMMUF4NnV2c2h1ZEtOMmxiclcyR21DZGI4U3dMU1NQMHUzQ2xnSXRBeFg0dFJnUWpyaTdsaEU9IiwibWFjIjoiNGM5ODE1YmFiZjNmZjc1MDI0MGUzZjAzMDJkNTJiMmY5Yjg5MGViMTc0ZTk5ZGYxNGM1ZTk1OWY0N2ZiOWQyNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, IE, NL, NO, SA, SE, AE', '[{\"id\":\"2d75af0d-b71d-45bb-b54b-e7a355fc952f\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"1b73bc81-ac17-4af4-9069-b539624e1f24\",\"name\":\"Reach Step 25\",\"payout\":0.168},{\"id\":\"f2aefba1-e08f-464e-a819-cf43263d0091\",\"name\":\"Reach Step 50\",\"payout\":0.224},{\"id\":\"7573cb09-e23e-403e-ba62-1a8de2a2edc2\",\"name\":\"Reach Step 100\",\"payout\":0.42},{\"id\":\"f48c47f2-532a-49f9-bfcf-a8ba0452b444\",\"name\":\"Reach Step 250\",\"payout\":1.12},{\"id\":\"47f1c4ac-14fb-459b-a64e-fe83dc1c520a\",\"name\":\"Reach Step 500\",\"payout\":2.4},{\"id\":\"60c62218-6ddd-4704-b57c-2ba9b898963e\",\"name\":\"Reach Step 1000\",\"payout\":6},{\"id\":\"8ac99fca-e0d1-4469-a5c8-b5a5525491dd\",\"name\":\"Make any purchase\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(324, '1071268-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 234.67, 'https://notik.me/api-redirect?token=eyJpdiI6InpDRGRGbEJYa3pYR1hHWTUwd1NyUFE9PSIsInZhbHVlIjoibzEvdm1GbXFCRGhGU1BZeFUrQnVSeXBBNk1YZk9PY2VTcTZVZlF6cnNQTnJ1VExjbGllRklwUjZxNTdmQU1yYTlBaFZ5aHRaZHlYYzM3VFpXN2E5SDFxMW1HWEU2Y2lCQWtpbU9rS3JyWDRaNExwMEhocGdRMmNSOU1ma081NjZWZldTL1cxWG56YVJKam9LR3Q3Q2NWZ2xPbkZFQzZDSCtuaWV2ekUwVVdXL0E0VVA2M3EraWRZQTNrUU1XVGlpd3BIbHUybWdUb0VteVc2bEh1VDhKNWUrK251ZVlVaXhsY1RKck1scmlvOE5ZV1BtdDhDM0xrSyt3RVVFbmRkWldjZkp0b1QyNURxMXlkaVozRlNqcy9HZ3RXWmQ4Y0tDcmdKc0RZeFhFdmc9IiwibWFjIjoiNmI4OTYxZWVlOWQ2Njc0MjQ4OWRiOTllYzI1ODRjMzFiZGU5Y2RmMDVhNWUyMDg5NGZkNTI2YTYxMmQzMGNiZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, KR, GB', '[{\"id\":\"30fd777d-ddfc-407d-baad-74cecd1397a6\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"669960bf-f113-4a19-ad2a-371152af0d10\",\"name\":\"Reach 100 Meters\",\"payout\":0.02},{\"id\":\"e0d02748-03a8-4379-985e-f2615f384fcd\",\"name\":\"Reach 300 Meters\",\"payout\":0.048},{\"id\":\"6fdd31d9-b15d-4d94-b234-10b9419e4cf3\",\"name\":\"Reach 550 Meters\",\"payout\":0.4},{\"id\":\"4978b43b-bb95-48fc-92f3-c802378ccc35\",\"name\":\"Reach 700 Meters\",\"payout\":2.2},{\"id\":\"7cb0dc99-d503-43e2-9b0f-071d05416381\",\"name\":\"Reach 900 Meters\",\"payout\":10},{\"id\":\"f4336e86-8c90-4184-861a-f1ee91db9b5c\",\"name\":\"Reach 1,200 Meters\",\"payout\":22},{\"id\":\"ee07a6e9-0fc0-487e-b370-7beb7daaa3de\",\"name\":\"Reach 2000 Meters\",\"payout\":40},{\"id\":\"2064a142-5e0c-4482-99d9-b7fdb3c421b4\",\"name\":\"Reach 5000 Meters\",\"payout\":160}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(325, '1157820-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 6.81, 'https://notik.me/api-redirect?token=eyJpdiI6IlNqZ045MHNoak5XRUQwdGRZMFEyS3c9PSIsInZhbHVlIjoiVWZSM29RaVZuQ3dKTFhPZWJDcnpYYnN1dVZucFNpcERHT3hDYktUbm4vY2ZVeFdSUnFzUjlXSkFxUEgxLzl2cVRxV29NcDY5QktML2hVWnJJVUYzZUdhMWdCSG5iRGtSZFZYL0FWL2ljNmgyMjQ0VWlXdUg3OVFQcy9HK0ltM3pQNDBmTCt6RGlYWFNiZzdqOE9jODJodzUxZ1dJNmI4UGZLMldIWHE3RGRLRU5hb1JWckw2ejJhVCtIV1dsc0VZS3p2UlBRTnRNSkNXenlWQWhBSkRQT2NCUjl6QXgzWGQyTnl4SmlJNlJWTU1HdGpSYmFXNDlGTkExTzJzblBHeGU2MmtaWGFzZndpKzZQb0JoTUxCUnlqeVVWS0tlUXFVSjNkeUtkM29sN009IiwibWFjIjoiMDc5Y2IwNjQ4Mjc1YTFkMTkxZjBmOTg0OGViZjRiZmVjYzljZGVhNjkwNjIyMjNmNzJjYTdkOWY5YjJkNDc0YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IS, IE, IT, QA, SA, SI, ES, AE', '[{\"id\":\"384d1eb9-9577-4a01-82b6-82a8e1cd8665\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"b2e343f4-66a4-4249-8fb0-d9cb61d3a7c1\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.2},{\"id\":\"574a8e5c-9aa9-49bc-9a1c-0ee3aa281bf7\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.44},{\"id\":\"f9672688-fecb-467c-a6d0-9e8287f86198\",\"name\":\"Complete Hidden Level 50\",\"payout\":0.888},{\"id\":\"bee00d70-d2f6-4c3d-8565-eb43fc5ae65a\",\"name\":\"Complete Hidden Level 100\",\"payout\":1.68},{\"id\":\"1a2cae56-19c1-48bb-a40d-9d7e17d06942\",\"name\":\"Complete Hidden Level 200\",\"payout\":3.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(326, '1256862-lZ2kToJFfVYWxuk6', 'Mafia City', '', NULL, 177.44, 'https://notik.me/api-redirect?token=eyJpdiI6IlJoV3F5cjUwZEZIR1RNQm5ubHQ4YVE9PSIsInZhbHVlIjoiNXZjd0hZemhJMzhRUGFPcG0vTU1RcE42dUNEVjhaTnlHWE9KU0FSQkhoZDRXRkpzQXhuVVZDUHB4dVlZSXlud3ZVTXZNWnM0UUFWWTJKYmZ5b3UxNG14aHpmaTBoai9nVWlYWEtHL24rY3RrWi9uNXAydXdMM2JIZVRmODduRnJobnZVaTJmNnRhd0RrVmQrL1lvN3JDZzN0eG9vVitiSnk2Vm1DRGRvVC9FMWNFRHQzclBXM01PM21RRnFlZHFidHdoVm44aXFwajg2NWJ5cGJ2SkFvOG54Z3BRR3gydVQ2bEVxMzFhUThGaE9GREVCcWlXWW12U2R6UnE0aWk1OElsWDFDQ0ZCT2xpMVljNEd4NStWdkE9PSIsIm1hYyI6ImM3MDg5ZWM3ZTUzMzRkY2VlMjcxZjI3ODRhNDEwNGYxMjA5YzMxNWQyMDEzMGMyOWU1OGFmZmZmMmZlZDgyMzQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[{\"id\":\"72e0f490-3fba-11ef-8f7b-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"72e0ff3a-3fba-11ef-9a05-069eb31df495\",\"name\":\"Atteindre Niveau du Chef Niv.5\",\"payout\":0.16},{\"id\":\"72e107c8-3fba-11ef-a583-069eb31df495\",\"name\":\"Atteindre Niveau du Chef Niv.10\",\"payout\":0.32},{\"id\":\"72e11024-3fba-11ef-b5b0-069eb31df495\",\"name\":\"Atteindre Niveau du Chef Niv.35\",\"payout\":1.6},{\"id\":\"72e118a8-3fba-11ef-a8ce-069eb31df495\",\"name\":\"Obtenir 1 H\\u00e9ros 3 \\u00c9toiles sous 7 jours.\",\"payout\":0.96},{\"id\":\"72e1217c-3fba-11ef-acdb-069eb31df495\",\"name\":\"Obtenir 1 H\\u00e9ros 5 \\u00c9toiles sous 7 jours.\",\"payout\":8},{\"id\":\"72e12a8c-3fba-11ef-b572-069eb31df495\",\"name\":\"Obtenir 2 H\\u00e9ros 5 \\u00c9toiles sous 14 jours.\",\"payout\":0},{\"id\":\"72e133ce-3fba-11ef-9cbc-069eb31df495\",\"name\":\"Obtenir 2 \\u00c9quipements de Tuerie Dor\\u00e9\",\"payout\":32},{\"id\":\"72e13d4c-3fba-11ef-ad1c-069eb31df495\",\"name\":\"Obtenir 1 \\u00c9quipement Dominant Dor\\u00e9\",\"payout\":38.4},{\"id\":\"72e14738-3fba-11ef-afbf-069eb31df495\",\"name\":\"Obtenir 1 \\u00c9quipement du Parrain Ultime Dor\\u00e9\",\"payout\":96},{\"id\":\"2461b6c8-dfed-11ef-93e4-069eb31df495\",\"name\":\"Gagnez chaque jour de jeu\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(327, '809036-lZ2kToJFfVYWxuk6', 'River Dash', '', NULL, 33.68, 'https://notik.me/api-redirect?token=eyJpdiI6IkVhaVEzL0hEZFVlTEhiU3p5Y2RCZ0E9PSIsInZhbHVlIjoiaUxjczBKUGx3RnhWSllJUE11V3FmT3o3czFNWXYxTTFxT25yZ1lXN3pVZW5XTVJLbGZNSTZ1Z0ZqaEIrQmdzaHNKTHB0M1lkSG5zZXZ5SHdjSjA4YTBYRWI3ZWd5dFdoNFNvZzI5enJKZHZ2WXlmZWloRlZXcldRdWlSUm5BaU43czhZVFZ3a2FHdStqbkVpTWxRZU9qSk5BVWR2RUxlZGk4YlNhajVTM3ZDODIxU1BiNURoWjRwR3NPTENCcE5DdzdwNlNXb2wzOEJDbkR2Ly96WTA3ZXhIMGoxcjJiYlRVQmtaR0VHOHk4SGZXREFZTE9nTFlSdjcrMjA1M0poVTVRRExyUHNrb0xTZUl5bFg2ZzA4OHc9PSIsIm1hYyI6IjNiOTRiMjQzODdlNjQ3MzkwMjgyYTljMGIwMGI0ZWRkMzE2ODM1YzJkM2UxZGQ3NjZmZjBhNTZkMzdiZTJiODYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"ff2fee28-39d8-40f5-8f0d-e49caa3b2782\",\"name\":\"Play River Dash !\",\"payout\":0},{\"id\":\"c47d0f67-c190-4b91-a3aa-15ae996a113c\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"2aee50fb-eb02-4225-b415-13353649f2bf\",\"name\":\"Reach 300 Meters\",\"payout\":0.16},{\"id\":\"1141e5dd-598b-4e94-853d-83014b92e589\",\"name\":\"Reach 600 Meters\",\"payout\":0.72},{\"id\":\"902211d4-2c67-464f-aaff-28b0c1ec132b\",\"name\":\"Reach 1,000 Meters\",\"payout\":5.2},{\"id\":\"762cd8ee-00cf-45f6-bc09-e408e2dea423\",\"name\":\"Reach 5,000 Meters\",\"payout\":27.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(328, '943184-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 6.12, 'https://notik.me/api-redirect?token=eyJpdiI6InI4UzlyT1Z5bDhQcm51UW5Sc0VsaEE9PSIsInZhbHVlIjoiWmFGK3QzRXcrc2wvNjltNXN5MW5kUWNGUVFPcVcyQ08yb0FkQjJjMkRlMzkyQklEV3JuaExyenluMHFqMXBTcXVCZnlISXgydVgwTy9zL0JYWEUwRjNXdG9zdTMzb3NRREh1Smp3aXA1Qy8yUFZ3R0gzb0UrYURSSkoyVWhRRm9maWQ2SUlrRDFNeSttY2ZDd2tFK0taQy9TTHlTeE5lTDgza0lxaGZvYmwxVVc2aG5BcDhPdnA4SlJkU0tzWW1yRG9tRFJEeXNsMnJmUjlHTTU1eDArWTN6Q2NuQXlabG5XRkk5cDFuOHhmV0J2SHEyTmNtbkszOStqSkU0N3QwbzlGSVdzaVNyMFN5WHZpandLa1lkZVI3ZWl0SVZOWjA1TkhjaUdpL0dDK1U9IiwibWFjIjoiZTA1ODhmNjAyZGYzNzQ0NTBhNzQ4MjM1MWFmZTFjNDhiNzgxNzNhMWVkMGRkYWVmYmE2OTJkNjMzOWMyZmRlZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"e0d72e64-391d-4d3e-8882-278fdda1cd13\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"913f1a5f-044f-4556-ad03-5807dc4da362\",\"name\":\"Reach Step 25\",\"payout\":0.06},{\"id\":\"7b6fc576-c021-4564-9c25-d7eaefc34db4\",\"name\":\"Reach Step 50\",\"payout\":0.112},{\"id\":\"441ab9de-8f3e-4d6e-9545-2c517366249a\",\"name\":\"Reach Step 100\",\"payout\":0.224},{\"id\":\"8a598ce9-cf3f-48b2-aa29-6c4c5315f6f3\",\"name\":\"Reach Step 250\",\"payout\":0.64},{\"id\":\"240d8db1-51eb-4ed7-81c2-e764d034a053\",\"name\":\"Reach Step 500\",\"payout\":1.68},{\"id\":\"92019648-d5c4-4972-9f4b-e6297169425e\",\"name\":\"Reach Step 1000\",\"payout\":3.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(329, '1012459-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 23.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlVCNzV0RHdqZVpreGVvcUdSOElKL0E9PSIsInZhbHVlIjoiZy9FaFBmNUNrOEd3NW54RUg0a2VrMVMvNGlMSWZnVXk4NFNUeVlUS3Y2Q3luRzdtU04zT3daSGROMmVZZGM2V3JKYURCVmM4cCtmZ2JaSTlUWGZZVWJpcXdTT2lxRFg5WUZqcjVodkZtQS9xdEZ1TE9yL0RwSHZFYzJvK2I4dENsQW9UZTJicjNIQmkyOFBQd0ljZGM1eFFyckMrY2tkOWQxQjA2S3NNNDFRbStKRDZWZXRmUEY3RExHK0txNjVsMjJXcVZ3YmxWQUxUVlkzOUd4NDJDTlRvcHBEZ0I5WFErS3NETXg4bXlCejUxRUlIMmJOMDFXZWJvS0FEQkNBa1NJSVA0Y0hBbUpnbkJHajA5bUozb3V3RWtNMHJRTGwrNlZlQ3lZQ2tZSTQ9IiwibWFjIjoiNGMwYmYwZWZhNTUxOWYxYzU0NWVlNTM4Mzc3YTUxNThlMzczNGEyYzk3M2MxNWUxMWJlYThiNjQyNTM1ZmIxZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"8a86ce8b-c845-4dbf-a541-51ec8a3578c4\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"901f09cd-5c51-4f9d-b8b8-8a58f1206356\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"d76ef94b-bc34-4101-b359-4425dbe9f77a\",\"name\":\"Reach 500 Meters\",\"payout\":0.32},{\"id\":\"08ee46e2-e88e-4d05-86fc-75d48ab08d09\",\"name\":\"Reach 700 Meters\",\"payout\":2.6},{\"id\":\"f4f1f135-d0c4-42ec-bdb9-b9cfc9e8f226\",\"name\":\"Reach 900 Meters\",\"payout\":4.4},{\"id\":\"7d317add-9543-482c-b427-bd1df856fd0f\",\"name\":\"Reach 1,000 Meters\",\"payout\":16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(330, '1272721-lZ2kToJFfVYWxuk6', 'Legendary Hero Bingo', '', NULL, 60.88, 'https://notik.me/api-redirect?token=eyJpdiI6Im9tZUdOejZaVmtwekdIUVdhclF5OFE9PSIsInZhbHVlIjoiU0UzTEljM3BwbTF0eEJVZno1aTIvL1VqRDNpZ2cwc0xxS1piYlV3S3BWTTZEdyt6STVtUkpPZ0NXdEVYS2VzWHcvVm1KeWI1SFptbnRCREtkS2pSOVUvam44U081TkZYR2lyK21WSko2aFprWllwZ01WWG1tTFNJV1R1bnREblZFaWNWbTR1YjFvNzZsVlplYlVlZjhVVzVQZk1HZit6U3FxYzdCQjhjd294cFBsMFRYdDRTVDRIM2MwSXpYSVNVRCtDNnAza3l3MUtleEtLQnhSaW03OTAyL1I2ek1wWWJHUDFNQ09WNGdaRWhNNEJZYVZwb2JheURLQTFlRm95SXhMNDZ1Vmd4ejlmNTY0K2NxZGdwM25XOHh0cHIzY09JcEYrbDBmSjk0U2c9IiwibWFjIjoiNmI0YTQ2ZDlhZDU5NjdiNTA0MzQ2MjZjYjQ3OTRhMzQ5ZjlhYzRkMDk1ZWRjZWQ5NjlmYjNiYzM0MzU3YjcxNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"8825d0ee-42b9-11ef-9e28-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"8825d9f4-42b9-11ef-a0d6-069eb31df495\",\"name\":\"Reach level 10\",\"payout\":0.32},{\"id\":\"8825e34a-42b9-11ef-bf65-069eb31df495\",\"name\":\"Reach level 30\",\"payout\":1.12},{\"id\":\"8825ebc4-42b9-11ef-9b9b-069eb31df495\",\"name\":\"Purchase Any $9.99 Package\",\"payout\":2.4},{\"id\":\"8825f45c-42b9-11ef-aba8-069eb31df495\",\"name\":\"Reach level 40\",\"payout\":3.84},{\"id\":\"8825fd1c-42b9-11ef-9ffb-069eb31df495\",\"name\":\"Reach level 50\",\"payout\":8.4},{\"id\":\"88260622-42b9-11ef-8efc-069eb31df495\",\"name\":\"Reach level 60\",\"payout\":16},{\"id\":\"88260f6e-42b9-11ef-8335-069eb31df495\",\"name\":\"Reach level 70\",\"payout\":28.8},{\"id\":\"f2120936-e247-11ef-8247-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(331, '1273927-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.66, 'https://notik.me/api-redirect?token=eyJpdiI6IjFNSVhidWhTaTNNQzNqamN6elQyWnc9PSIsInZhbHVlIjoiTWpSSVlXUUVJa2JmaVd0WkRFdEJPQjRxejFnWVFzdThqWkhxQk52S3hEdzAyREtyT3JsUk1aRXVLd1BxRTRVT1NRbFZnbURrUkY3Q21md2lENWRpSUxNS0haZkZ5cTRxM3JHVXdra0cya1BEL1lYUGI4OVI5Q1FUR0NHUnVWVE94OWhLWnJzK3plWGVXeUd3TjIvbVdNMzd1NTlaL3MyRUd4eHYzb0JUSUlWK0ZCYk01M3BqZkMvK3NXcmNjZTd1elhnajRuQXZ1a2xmaDlkTGI0UFJFemxDamV2Vy9PbzZoT3FPbkQxQUx6MVNiQXFwQjU5bjcvRmc5M1AyYWNucGVCaDRKRTE5b0I1bDVnMGJpa0JFcDRoZU1qb3p3c2V6ek5DS3JHT1E0RWc9IiwibWFjIjoiMGI1YTAwZTNkMDEwZGMwNjNjZDdkYjdlYTc5Y2M0OGQwMzIyODAyYzAwYTJmMDFhYWUzZTM2NDIyMmM0YjYwNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR, SG', '[{\"id\":\"a0495a4d-a837-4620-b3e9-e62cb285230b\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"30ac3d1b-55ca-46bc-8c03-98637c49b893\",\"name\":\"Reach Level 50\",\"payout\":0.08},{\"id\":\"36a96cb1-a368-401b-9014-4ebca0e233ad\",\"name\":\"Reach Level 100\",\"payout\":0.12},{\"id\":\"a3d0fdd9-fbbb-4b3e-b7db-5d6087138105\",\"name\":\"Reach Level 300\",\"payout\":0.46}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(332, '677665-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6Ik44WGVaeDNycC9UcGRJeSttM3hyQlE9PSIsInZhbHVlIjoicGpqS1hIMEJ0ejBvM3pWUmNtVmsrZGJjUHIzTE1ybWptcnFXYzB4bThmektvRGYweS9rdXFhZXBwa0dXZ2JBZHRIWFRSNWFCditMVTJQdGVnMXdwYStMQ2IyWjRjZzZnSnJVK1RUV0NJeWt1a0xsVUl1TkZ0SGxScURjYlBYTTcxWnVtaUYra3N2ODNKVERlQTVWMnU2UG9VSVFsZi9pdHJKY2JFUmRPZGhVVjZmQ0hmL3psUVNRbU5PaXZFYmk5TFBCTld1SmI2OEs0bkk0TlRRS2tvL3VIK1dORE1Zd0hEK29Fc1pKVUVDSVBFLzc4c3haZy9TQWVDV1FlbitQLzFQWkJjaFFQZVBja3ArS2h3Vk8rWWFmQUJtNnhrMnZIa3VMZFpMOUZNZzA9IiwibWFjIjoiNTcwMDJhMzI4NGQ1OGRhMmUyMWFmNjVkNWJmNGE3NjVjZDA5MmNlMTQ2NzUxOTFhZDczNTNhNDFmMGMyMWQzNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"a6d6a931-f790-4b61-9c71-ecc11e061df2\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"d45b08d4-d69c-4f65-8466-6fc5742324d6\",\"name\":\"Reach Level 100\",\"payout\":0.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(333, '677677-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6InZxaE5HbzhNWGRnanRNWm9LZU1Ra3c9PSIsInZhbHVlIjoiRm1Xc0wrQ1NCcjlDdjUzcW1LU01LLzQvTGlxM3MzU0RXU3RtdG5aRDg3SmtwdnZvQ1g0Y0lKMUliNCs3ZmdQR0tRVXNPUFNyRmhPdG5FOGhoOWpuMFhobnlmRGFlQVVOUUtxRTB5dTlYS2d5cUJMOFN0ejk2SWp0dWFCRituV2NPN0ZLa1R3ai81WHlDczVqdHVvZFVIUWducWdiMWdNSC9xQ0IwdHBTRllKeWhqVjh1Nzd4VmNtdFJaSUltU1RFZkIyd3FvdTlmQndnZ05sNmNiUE0zdThjeWJzOTZtSjZFQUJDOXhYTEdaUEFQMnluSktDdGVhYTFuZzk0MHdBeFlqTEVtWlBUWFFBVHFkc09hMTQvb2xPMDMwNmViZXphdm8yNy9FV1lldm89IiwibWFjIjoiOTNiM2JhYWMzZTRkZDc0NWRjMGI3Zjc5ODRlNzRlY2I4Njg3ODVhMjViOGJkOGY3ZGQ5NTdlMTA3OWNhZmVkZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IS, IT, QA, SA, SI, ES, AE', '[{\"id\":\"81227ceb-2e06-477e-af7f-e2e04f1abde2\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ed1e702a-e232-43c1-8eff-86ed4474983e\",\"name\":\"Reach Level 100\",\"payout\":0.336}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(334, '725761-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 2.49, 'https://notik.me/api-redirect?token=eyJpdiI6Inp3NXR0b0theGNOMTRncUJFdlF3bVE9PSIsInZhbHVlIjoib2lxTmdQK2pCRkY0TjdFNGdJZ3RHcnl2NDJPUVlFdUd4SERFWkZDdHFrcFA5d2RZcDhpcG15NTluV1g4ckxaYThvWXFldnM2VFlXV2RJenpwWER0Nm9vMlpDVElMaTZhTkVReFFrRjllQ0VKclcwcTJMOTJrUjdic2xITDFqMmE3Y2hlbHVxMnYzVXlDbjIzSXI0SEJzVS9OeGdLSVl1UGpsRFdIZTdoOVRYU1Ivc0tHWUkwTGFsRldHU1VNd2hSMnRJbjJJb2FHeWZ5V2pUZHI0a2tHOHBqQTY0aGd5SFo1clNDaFNlNjdYdzljblZZQ2dodWp3MXhBcENoY1crdnVXci9WWjYrUTkxS1UvY3RKaVBpV2tCdnFHUE1KZjhMbjE3TEhTdHE5SlE9IiwibWFjIjoiNzVhYjkzYTgwOTVmODJkYmIyZjc0YWQ1NGUwMDc0YWIzZmU1YjFhMWFkNmYwODI5YWIxZGEzMTM4ODY0YTUxZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PH', '[{\"id\":\"dc475360-af7e-491a-b2d9-15fb4a1d0e06\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"af2fa8d8-baf0-42ff-8671-7f0cfbd2d1a4\",\"name\":\"Complete Level 50\",\"payout\":0.04},{\"id\":\"b91afdbd-7e2e-42ac-b9fe-83f1fc54cd48\",\"name\":\"Complete Level 100\",\"payout\":0.048},{\"id\":\"ad4d61c6-6431-4bf3-a01f-917f43e7f28a\",\"name\":\"Complete Level 250\",\"payout\":0.14},{\"id\":\"d96cc6c0-080f-4440-8cef-17b3b9979117\",\"name\":\"Complete Level 500\",\"payout\":0.4},{\"id\":\"9bd5cf8e-c0df-49b0-8fe2-2913754691be\",\"name\":\"Complete Level 1000\",\"payout\":0.6},{\"id\":\"dcec6702-2806-498e-8c89-f7c5cfdd3c5d\",\"name\":\"Complete Level 2000\",\"payout\":1.26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(335, '828749-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 4.37, 'https://notik.me/api-redirect?token=eyJpdiI6IjI1RHRBR1UyOFNkMHdQMnc3ZkI4aGc9PSIsInZhbHVlIjoiSUVHNkZpbnFMcU5wN0lWUjIzRWJBbEVmMm1uVk9TV2QweVZ3QVhrRFR6aEhKS2Nub0phWVFkME5ROTY5UkJMeStxQ2hzTlFLVCtoY2VXcUpPQ2hmbWdiS1Q1ZHBTY3hrbVMySk9xUjZDbFJYWFlQWjZ3akxmRmxYaU5jTE92U2g3dTg1dDJwRi94WjdmWDZtT2lsV2tIdEp0Znp3NUJMRG5wRnIwVEdlNHZLUFFSQjFpampGTjF5VVlmOEMrd0RFL3UxZE9Zdm04dC9la2s1ZmVvajVyNE9VTmhzeS9KYmh0MHhRRElYUEdORTI3YkJ5YlVyWTJtcU5EU0hGVU5UMXppaHQ1M3U2c00wL1FnYnk1UE1NRG1TWStESVJiNlFBbGhqdjV4UXdrSGM9IiwibWFjIjoiMWY2YmI3NzBiOTJlM2VkMGRkNTY3MGU3NjMzZjg4MWZlYmE5Y2RhNmNlOWEzODZkMzRmMWMxMDJlODQxNjE2MSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"4bf74f2b-8943-4ff5-8f76-7821ea0d8616\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"cea11027-4298-44db-a9d3-68c444628510\",\"name\":\"Reach Level 50\",\"payout\":0.14},{\"id\":\"7937e951-1631-4797-9a2c-ed203bed4c6b\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"2f48dad5-3f94-48b4-a2fe-2df07c1c754e\",\"name\":\"Reach Level 250\",\"payout\":0.576},{\"id\":\"625f29ac-3ddc-4e48-83b0-6e3137c2da7c\",\"name\":\"Reach Level 500\",\"payout\":1.148},{\"id\":\"c8f9d234-f46d-4f62-8b90-a61aaee7eb85\",\"name\":\"Reach Level 750\",\"payout\":2.34}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(336, '870182-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 7.02, 'https://notik.me/api-redirect?token=eyJpdiI6Imc0SzE5NUIxdlJ3L0I4TklVOVE3K1E9PSIsInZhbHVlIjoiQVhZOXpTWHhIUEtyVEpDYUdMaytLZjdzYmNDZUdiTE9DMDZ1SGdFRHhreFZVM0dEWXR2aFN3cUVHT3hnRWxrdTMvSXlXenlhMmlzYXFIRTB3ODc1QTZYajkzcVo2SlI2NEdxM3NFT05sd0JNdGhiTnZ4NUdjc0VoNzJXWHp2aERzSE5QcTA4MDYxR056SnN5RGd4VEtMeU50TndmdDErZDg5U1k5QWZBUHRrb3h2ZkNHY0w3Q1AvbkszY3NGK3Y5N1MzRXBsaHArTzhrNDRCSERHNk9jbzRuWC8rT016d0VrT0R6MndSTUdpcGMvaWxaSzRmNllsQm53enZaSWZvRmt5S0Jrd0M1QXpqVVlvK1E0eDVUTkZKZUJ0NEUzWlRpWWduZkNnSVc0NkU9IiwibWFjIjoiYmY4ZDBmZDFkNjkxMDQ3OWYyYjRhOTY3NzI0M2E4ZjgwMGJhZjBiODY1ZjlhMjczNDgzYzBhZjc5YzE3NGRiMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, SG', '[{\"id\":\"5cb2bae8-2bd9-4e6e-8a8a-95e1240743e9\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"9270a993-20e2-4848-97f9-31ee3561fb62\",\"name\":\"Reach Level 50\",\"payout\":0.252},{\"id\":\"9ae7a027-260e-4add-b444-40268cf14470\",\"name\":\"Reach Level 100\",\"payout\":0.28},{\"id\":\"e0c36748-f28a-4627-80cd-a049a0d8b708\",\"name\":\"Reach Level 250\",\"payout\":0.868},{\"id\":\"bc32c44a-5b3e-4667-9b34-390573a940f2\",\"name\":\"Reach Level 500\",\"payout\":1.82},{\"id\":\"97e662c6-dd13-44b7-80c3-eb8b97cae4d5\",\"name\":\"Reach Level 750\",\"payout\":3.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(337, '870185-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 6.62, 'https://notik.me/api-redirect?token=eyJpdiI6IkVpYnN0TmVlT3ozcm9Wak1ReDFyUFE9PSIsInZhbHVlIjoidVczZVlmSXBpUHVDZ1hLLzlzbnF2RnhINFIzTy8xRVgwbFdoM2F1dzk2cHplN0dXMzRXSURLcTA0citvTnZWeVpRaWVLSjc3UUYyWW1sQVlRSjRXaVNjcUFUOFBsMFR3cXA1dy9zOEJtRWxiSit0TU5ROGxXNFNKb1B6OGhjUFBrUFEzMGEvNU1PenRZamxwTXZYSUkxSGo0UEM2eWdyS25GTldjNkE3bUplWitWY0FJTWhYTEY1MEVhdFVYdkxOOE9scGQ2Y1p4RHVsR2h5aS9qVmhlNU1CdXFabXZxWGREUHpkSmI1TFlPWFlNVHI2cXROMDZWSVNQWFVTK1FQSFlkZTFuOS9ud1Rkbll0ZFUvZHovRDJpaU5YWmlDZUVKcDlxZHoyd2p1ekU9IiwibWFjIjoiZjM5MGJkYTUwNDhlMTlkOTcxY2JjMzBmNWQ3Y2M0NTJjOGNmZmYyZGMwM2MzNDk5ZDcyOWU2NzE0NTY3Njc0MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"f98f96b1-3556-4aa6-9463-da0f07b3c765\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"5c982c65-542a-4eb7-a802-3e7b5d3ffa26\",\"name\":\"Reach Level 50\",\"payout\":0.252},{\"id\":\"42170569-6457-4ab0-87c9-5e3bb011b99f\",\"name\":\"Reach Level 100\",\"payout\":0.28},{\"id\":\"1ef9c33a-ffc1-4da3-9be2-bb86b4a2a25f\",\"name\":\"Reach Level 250\",\"payout\":0.868},{\"id\":\"9a8bb2b8-7b2b-4b72-93f5-62031d493239\",\"name\":\"Reach Level 500\",\"payout\":1.82},{\"id\":\"7447ae42-9771-4f2c-a35e-f2659b90ecb0\",\"name\":\"Reach Level 750\",\"payout\":3.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(338, '1056208-lZ2kToJFfVYWxuk6', 'Instant Lucky Wheel', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6ImJ0dTloYUFjbmQxQ05VYU4zTDZiWGc9PSIsInZhbHVlIjoiTVNTdTNxSWpaWENsMzd1d3RkZThEaXdZL25YeUNNeTMxd3UvTjBnY3ZZcElNZGdHWTJvUU5DWGg5R2VNYVZ1N21hODVUTGFNdzdpcEtsYW9SSmF4ZExVangwRFpnM1ZTUXg4b3lsT1l6dnR2Z0dWVTVtSXdmUzZNUUJkSnc2N2pudmxsZDllbmFNK2xEUUZVWU45YnVsRWkzT2lvREhiMUlUNzBCZEZBUHFlWEpFUFFJbTJ5WXpnTWNycjNHOER2cHNNZkUvdVVmS1Y3R1hYdFlGd2tiZStCaXF1YUx6VVVTSnBLN2pydHgrWFg5bmdSR1IvMlRJNUpVZlB4R0pyOGp5d1M3K1pNTzRPWFRXTnQ1OVc2bEZiU2gzOTZ6b04vRllNdGN3RFowSFE9IiwibWFjIjoiNjYzZWQ4MjM3ZGFmODgxMTdjMzgzYzYwODMxODMwOTJiNzc1YThlNmVhNzIyZmQyNzAzZDEwMDdkYzcwOWE3MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(339, '1071265-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 29.08, 'https://notik.me/api-redirect?token=eyJpdiI6IlVkUDJpL2x3cmp0anZUYVprVVBSNUE9PSIsInZhbHVlIjoia1BPNGVmNlM5dFFCTTJrckQyZ3JscHY0QVZrN0lMcVhmek1jeUVnenpzY2JCMFF0KzhoMTQ0N3cxc1JqcGNpN211L3R2c0NRM0ROdjI2MHFUQWFCQkJDb3VmVEM5b3AvenFQbnhOTExRMGFLWWliS2NXWmdmQjhvTENKYVFjUWxwaFAwUHJjT1dHTDNSRVo5V1U5aWIzMk9zcDl1S3NOQ09mUTFLclFZSWRaWkNxUGxZR2FHbmJHUGZ1NXk2bWszcE5JdHZaQVFFUDZtNGkrUm8zeXA5UzdFcDU5OEpyK21KUDVOdDFOZk9yL3JUWUdpaTkya2FkazIvUkRhenRGYnhZSXpqUzVtOVYrdDhOTUxxVmtZVm1lL1puWElmN21ic01jeVg5bXByR2M9IiwibWFjIjoiMGRlYjU2MzE4OWJjMGMxYmYxMWI0NGI2YjhiYTAzNDkxODQwYjYzYWE2OTRhZTc4NDhiOTYzMWI1OWI4MTFlYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"7d2f455f-38f6-4299-a2a5-6ae8d260c8d9\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"450c1581-a71f-4fa4-8a7b-1d4a61cfb8e4\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"eef5dba4-8b2a-40d1-9aab-e5c8912e6b37\",\"name\":\"Reach 550 Meters\",\"payout\":0.48},{\"id\":\"8af767de-8157-49c3-9ee6-b072818f791f\",\"name\":\"Reach 700 Meters\",\"payout\":3.2},{\"id\":\"dba32062-11c6-4c6d-ad89-3749f34be6cd\",\"name\":\"Reach 900 Meters\",\"payout\":5.4},{\"id\":\"d7703122-d30c-4d53-b9dd-5bbad18944c5\",\"name\":\"Reach 1,200 Meters\",\"payout\":20}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:04'),
(340, '1126597-lZ2kToJFfVYWxuk6', 'Smash Party', '', NULL, 16.95, 'https://notik.me/api-redirect?token=eyJpdiI6IitvMVpGQ3Bpb1hUU3lHUk5uTVVBN3c9PSIsInZhbHVlIjoiWkRBaEhKeldITTRuZUQ0eFhJVkljUjBZc1M4VW03Rmd4alNpOW94UGQxclNNbHZyRVhPRXhLVVdobXNQcVpVSnNHWW1ycjVrR1ptcXNsbWZYRlU4dHo2OFNXMjBOV3FlRnBzWjE5WnVBOFNUT015TXZTcGUzTmUvY2s0U1hpQkEwS29tS1lqL1htajVEdnV3U0Y5V3BDZ2UyU0xQbUZBOGhpV0x0TWdmMnNVcDdjaktOQjVwTkRyT05TdExkdXRUa0xBR2MxZVhIQ01xWUtqY2FtVE1pa3FVOWJNczA3MEdTOEdMWlN2U1YrUjBDOUhsVXY2Q2J4QjRKK0JDMTBFOW85cnhHcE9Ed1hWZUhSaHlNcWZRdGc9PSIsIm1hYyI6ImYyNDA2NDY2NzA1ZjU0OWM3NmUxNjgwZjZkYjExNjM3OGRlNmFhZTFiNTk2MjQ0ODdhZWZiOGIwOGYzNjBhZTMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, HK, KR, SG, TW', '[{\"id\":\"b2d63946-ead5-11ee-a978-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b2d65a66-ead5-11ee-b2be-069eb31df495\",\"name\":\"World 1\",\"payout\":0.016},{\"id\":\"b2d66330-ead5-11ee-96b2-069eb31df495\",\"name\":\"World 2\",\"payout\":0.02},{\"id\":\"b2d66b0a-ead5-11ee-a1c6-069eb31df495\",\"name\":\"World 3\",\"payout\":0.04},{\"id\":\"b2d673a2-ead5-11ee-bf77-069eb31df495\",\"name\":\"World 4\",\"payout\":0.052},{\"id\":\"b2d67b90-ead5-11ee-9374-069eb31df495\",\"name\":\"World 5\",\"payout\":0.128},{\"id\":\"b2d6837e-ead5-11ee-8f52-069eb31df495\",\"name\":\"World 6\",\"payout\":0.256},{\"id\":\"b2d68b9e-ead5-11ee-9c8e-069eb31df495\",\"name\":\"World 7\",\"payout\":0.388},{\"id\":\"b2d693be-ead5-11ee-8aad-069eb31df495\",\"name\":\"World 8\",\"payout\":1.656},{\"id\":\"b2d69c38-ead5-11ee-a6ee-069eb31df495\",\"name\":\"Hard World 8\",\"payout\":2.584},{\"id\":\"b2d6a4a8-ead5-11ee-a052-069eb31df495\",\"name\":\"Complete Game\",\"payout\":11.424},{\"id\":\"8869b2c2-edec-11ee-935a-069eb31df495\",\"name\":\"Purchase\",\"payout\":0.384},{\"id\":\"2032b588-e31d-11ef-a53b-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(341, '1141254-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 3.09, 'https://notik.me/api-redirect?token=eyJpdiI6IjFFM0FaZmUwZVBvNzg5Q3lLMmVZNVE9PSIsInZhbHVlIjoiM1JJMTV3YnM3QkdrREZ6NFJEM1Q2cTRlbHU2d3JSZlBQTFdaaEZZaTFlVFpCYnVFTTZQZ1hFRTJjbDV5a0czbTExSDlWbmVYVGZyRWRYdnNCQkRxaHowaFArNm9SMXFmUWZPQXJQVUpHV0pxQmlLN1YvdUtBTndkbmhlUXU0aDJobjBKZ1d2bkRrRm1KTDI2Y3lpS1VEUldSeENXak4xR2R0QkY2N3JDYm5kcUw4SElVd0xJMjlXQi9nRHpTd1JVVGgxaE1rdDVJdnhnYjQrcm5HbnlVdXJwd2tDaUVuRkphSWIzMzM3TXVDWERWMldWS0d2RDRVK0R6RDJ5SmRKMDV5TTgxbFh3SzhSVE1aWnZzcjJKdXNiQ3o5emQ0d21CMXV2V2MyRkVYdW89IiwibWFjIjoiZjMzZWQ0ZjMzYTg2MDE4NTAzOGFhZDBlY2I1Y2VmZjU0NjEwZjg5NGY1ZTAxOGViNjhmYzZjNWYyNGFiNWMxNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, MY, PT', '[{\"id\":\"28ca399d-6507-4c6e-bdc6-1b5cb104672c\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"758c8918-3a66-4b01-8e22-30ac7ea68954\",\"name\":\"Reach Step 50\",\"payout\":0.032},{\"id\":\"0114243d-0532-4c9d-afab-6a19f0b7cc0d\",\"name\":\"Reach Step 100\",\"payout\":0.12},{\"id\":\"ef90fddb-95bf-403e-814d-dbf595f38409\",\"name\":\"Reach Step 250\",\"payout\":0.336},{\"id\":\"8cc3cf29-07d0-4205-b739-21ba5a0f1089\",\"name\":\"Reach Step 500\",\"payout\":0.84},{\"id\":\"30445c8b-87ce-4562-929b-32fb105d8725\",\"name\":\"Reach Step 1000\",\"payout\":1.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(342, '1157656-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 1.04, 'https://notik.me/api-redirect?token=eyJpdiI6ImZIeXgyZUp2a1haMWlRamQwTVpyMHc9PSIsInZhbHVlIjoiZ2d0SXdmRmhPMVNRTmQ0TGNzY0cxWGFYMzdiLzNCZ01JWTZvUzhRY1lWdzB3cjArVWsyekRHMFRPanJTWG42cnJ2YVlsR3FRdzZDK3VXODdDcEh3UlkvUzI5aWhIbHVOUks3eEEwMEZ4TXlsODIwWjl1YVk5c05ZYVpuRTlpbER1NnlqeDRuZ1R6Rk51aW1XUUJ2WDlrVklLUUlSUTZaUHB0Z1o1OWZVcEpkdTVha3kzcE56bE1ZeDUyNzIyWFYzNGZGTUlMcE9MQW5xdDdKbnk5MkhMcVFPK3VtT09RMU94UVpjeDNwWnAzUTFiejhKdGVaUURwUFpZRkVIeVcwM0FpZUFQalpJOEpkZC9rMTBlU0p6cTVhNlY1TVJWRDNmaVo1VnBXejdNTXc9IiwibWFjIjoiMmMzMGY3Zjk4M2Q2MmUzYTRhYjNhOTZiNzU2MzFlOTJkMzZjMzZmZGUyM2JkMDkyZGUzZTg0ZDgzMjQ0YTI1NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, GB', '[{\"id\":\"53267ed4-22c0-11ef-8c94-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"5326894c-22c0-11ef-ac33-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.04},{\"id\":\"53269108-22c0-11ef-bf9b-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.06},{\"id\":\"5326989c-22c0-11ef-bc6f-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.08},{\"id\":\"5326a030-22c0-11ef-a99b-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.14},{\"id\":\"5326a7d8-22c0-11ef-9079-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.24},{\"id\":\"5326af9e-22c0-11ef-b3a6-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.48},{\"id\":\"f2586b7a-e318-11ef-96e6-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(343, '1273915-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 1.33, 'https://notik.me/api-redirect?token=eyJpdiI6IjZyZDAvVmFrTFVDdFlvQ1BSV1gyNGc9PSIsInZhbHVlIjoiRG9RVmhSSlR0aTI3eUFjSDNxNDJhWXVHR09HWDBhSzJoekZJbDhwSThlcDFFMndEdlVSOC9qemVhNS9QejZnWm96N29iZVlERHhwaVFHc2lwRjFMamFKQ1VMRURmb2U2ZVRRTEJjOVNJcStDdkNOK2xWczZNL0VrOUNTWm5ZblNKZ0ZIbmgxOEF1UW9pZjE5WkZMRW9CUWJtdzIvVkl3aVFodEl0RjRoMGRmSjM1MVNYMUQ5Q2VVZDZROERWWFdzMm83WElpZXAxSG96NkxDV1JBdURqODIrQ21XTFpFS3VSZG5xRjhXZEJ6Q2FoM1hTMmZzdHVlMjhCUTV1WEpCelVta1Q1RzI0cHVVN0k0a2t1UVlMZ1oyeG5jWjcvdS9OZ2dVODc2YWFXT1E9IiwibWFjIjoiZmRlMjNjZDk5ZDhlZDVmYjlkOTViNDA1NTg1NDZkM2UzZjQyZjA2MmM5NmNmMjY5Y2ZjMzg4NmZiYTU1NGFmYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"cbc8b94b-a663-4fff-9ec6-877da44be75e\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"64231cb9-ffb8-43b5-bd12-76a2d4f8d677\",\"name\":\"Reach Level 20\",\"payout\":0.04},{\"id\":\"7d8be4f4-643a-4eec-9e36-24c089077166\",\"name\":\"Reach Level 50\",\"payout\":0.196},{\"id\":\"e3b0f3d6-5f9a-4738-87c4-3211cf546731\",\"name\":\"Reach Level 100\",\"payout\":0.252},{\"id\":\"61d1ddad-1d67-4108-967f-a66e38809e05\",\"name\":\"Reach Level 300\",\"payout\":0.84}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(344, '672795-lZ2kToJFfVYWxuk6', 'Chaos Cruiser', '', NULL, 70.30, 'https://notik.me/api-redirect?token=eyJpdiI6IitXb2hGNnJ3S3NlZ0RSMHhGb0U3Tmc9PSIsInZhbHVlIjoiRE1PYUR4djdzcm1pRXdRYlUwSUJ1alV0ZmgzSkR5UzlDYlFIK0cwK0VJUTRSZUdEVHEwemxFTXcvU00wSGU4RHFuQmxBcXN6TmdkNTMyRSs1UkwzUTJQelFEKzkzSE11RDBmVFRJT1o2NENnc1hKdWE3K3RmVEl3YkpnMFc2Yzc4ek9OaG52UzhDbEIvMi9UbzdnMzhFMjFvanBiV2lmeDREV1BxRGdKYnhWRS8wSXYwRGxnSWpPbDl1KytnQUhlcHE0cmc1Z3hQbER6V1k0cG9IYWNlbHFsYUtUWlBTODNFbjFYbER5a1BudzlQM0VkVEdTRy80ZlBMamtFaVhqejJkdUlhVlFiL1JEUGJTTUV2YXBEdlE9PSIsIm1hYyI6IjQwNzU3ZDI0MGIxODIzMzY5NWQ5YTUxYmNjZTM0MWVkMjg2ZmUyYWYxNDg3YWQyZjdjMmE3ZjUxMDZlZGY3NzEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"7bd4542a-e827-456e-93d2-072b412fea55\",\"name\":\"Play Chaos Cruiser!\",\"payout\":0},{\"id\":\"942845a3-994e-42f8-97db-caae6fafb0f6\",\"name\":\"Reach 100 meters of distance level\",\"payout\":0.04},{\"id\":\"66a675e3-6495-4996-a63f-0cfdd5878733\",\"name\":\"Reach 200 meters of distance level\",\"payout\":0.14},{\"id\":\"b8883301-949d-49ec-b809-492ebfccfeb7\",\"name\":\"Reach 400 meters of distance level\",\"payout\":0.84},{\"id\":\"5da499e8-5f2f-4736-ae5e-ea8f9c0db7de\",\"name\":\"Reach 700 meters of distance level\",\"payout\":4.88},{\"id\":\"8b877f33-4478-40c7-8b1d-7ecbf89e81d6\",\"name\":\"Reach 1,000 meters of distance level\",\"payout\":27.2},{\"id\":\"fcc5490c-5cee-4fc0-b537-063ed7c0be8d\",\"name\":\"Reach 2,000 meters of distance level\",\"payout\":37.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(345, '672961-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 95.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjduL1dlL29TVmhVSlZFeldxTjFsT0E9PSIsInZhbHVlIjoiSzArSFF2V1duQzJEWUdWRHE0SjdGZU5ibW41TXJwK1AwbWtvTlFOaTJXVEs1NDFrdGF0Zmx3elBKZ25EWjNTdlZCU0tsMlBwYmRwRVYreGM2MG5Rc0hqOTNra1gvVVZWWXczWDZDeUVpZHd2UGVMcS9WN2xBaGdlRmptSC9WaGp6MUMrTkp3NUo0ai9yMGcvcnBOSm4xbTdmOUNrVVI3R2x0WGJTMjV3Tlh0Q2RVbis5elVRa0lSV0Z3TzRGSjBMZnJ0cGJVMU1DNHZ2cW9tdnlvaVIxYWdNRUxDbnFKeHAwY1dQeWdMbUVaQ3VnUGl1Z0NOYTJldHYxY1UrUmxKQ2JmUkRObG1mbEwxcDFqbUZUYXNnS1E9PSIsIm1hYyI6IjdlOWZlZmMyYTYwYzkyNDBkZmEzZjIxODAxYjg1ZjQ1Yjk3NzU2OWNlNmFhNWVmZjIyYTE2ODBmMDlhN2U4ZWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"cd6ffe31-a5d9-44b4-b300-e1a389f699a2\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"b6655dcf-0599-4188-8628-30f54584608e\",\"name\":\"Reach 100 Meters\",\"payout\":0.02},{\"id\":\"5110f6ab-c62f-4d68-8aa6-0a6edf625d73\",\"name\":\"Reach 500 Meters\",\"payout\":0.2},{\"id\":\"a3944324-bdac-49cd-8a38-c08ae8a8de23\",\"name\":\"Reach 1,000 Meters\",\"payout\":17.64},{\"id\":\"24995753-e391-47a5-91a6-6042c973fba0\",\"name\":\"Reach 2,000 Meters\",\"payout\":30.32},{\"id\":\"4f31bd46-25a8-4ebd-9d8b-99e0e32cf652\",\"name\":\"Reach 5,000 Meters\",\"payout\":46.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(346, '672976-lZ2kToJFfVYWxuk6', 'Escape From Dreamland', '', NULL, 11.28, 'https://notik.me/api-redirect?token=eyJpdiI6IkVMU1lpUy9lOTJ3MHQ5RHMyQ2JxaUE9PSIsInZhbHVlIjoiTHM5UzhTRUxHaCt3cC9Mek1aK1JVWktpTEEySUV3Q3RUTm5odXQ4ZzZTc3dSUU4waXFxaGdza3Z1dG02bXAwKzdGNklhUU9VQ0RBMVFTSjNwa09SMDhLREFGUm5pYytwYldTblBMZUtTMDRGMWpBRjFjQUc1UHBpdlVGdlMyMVd1VnAxQ2laS1ZNYThEUEhhbDFUblJQdlRMRUg2YzB5RHBHNFhxVHpFdVFJQldVVm45S3QySXBHdzFxM2tsYlhZYnpnVGdCdXZ2Tm55UE81TEVRYWdSZWJIcDRndk93cVVHbXJLSEhhTjAwRDYxSlJzZ0l4ZVB6ampIYzR4eFpucWpyazcwZmZKRk1Kek5Vd3pGVkdNd1dXMmpRMGVqM01CUENkdVpDY1hObkk9IiwibWFjIjoiZmRlY2JhZTMyYjRhMjMxZmYwYjU2YWQyODRmNWQzNWMwMDkzMGEwYTA5NTQ3NjBiZjdlMmM1MzA5ZTIwZTgzZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, FR, DE, JP, KR, GB', '[{\"id\":\"e147df55-995c-47c9-9cda-3acfe11985aa\",\"name\":\"Play Escape From Dreamland !\",\"payout\":0},{\"id\":\"dd9d3456-1167-4e14-b158-0eb6b28add3f\",\"name\":\"Reach Level 10\",\"payout\":0.004},{\"id\":\"07231f89-b3d8-4096-a5a5-9e11044c3300\",\"name\":\"Reach Level 20\",\"payout\":0.24},{\"id\":\"68f5fce3-4d1b-4157-8117-dcccb1cc3e79\",\"name\":\"Reach Level 50\",\"payout\":1.44},{\"id\":\"998312b6-abb3-405d-ab0c-08458f3fbde2\",\"name\":\"Reach Level 100\",\"payout\":9.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(347, '677660-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6Ims5YXhLS3g0c2VYQVowTGVTUjAreFE9PSIsInZhbHVlIjoiRnpZZFcrQ1pjQU1wNjF3TndlTTBCM1psM0pwOHlibHhpdlZPWHVxcFpsaUpoNmlIQkpnTy96cVIrTUNodkdSU1ZBU2EvbzJvak9oZjYwcm9DV2JVM1ZaQldGWU5QTjBRY252VkVMaEdYZ1B2UEpFUmw2MW51cG40eVl5SjN3L1ZzeFgyZmppTkF4SE9KRlFHRjdJclJtSElDcnVrMGVmUWxJTitFRktHRFdtOTBabkpFM2NyU1Q2cXV1ajFnSmNBMlFNNThMNDVtUkk4Z01ZUEd3NC9oOU90WitIcjlLNWRNTm1VdDFzVFhsMklEWkwzcE5TdFphNDhqZWp1V2hIb2pRWHFBd1dYNDQ4bURHemtCSUhtazluemQwTjhORCtCZ3hTbml4QVYwazA9IiwibWFjIjoiMmNkMDg1N2MwYmM0MWNhOTY4MjlhMTgxZDRiOTExN2FjNTRhOGEzMjgzYmM4OTMzYTIzOGE3NDU4MGMyMThlMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ, SG, GB', '[{\"id\":\"3997af0a-ec56-4de3-993e-bd709932a75e\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"0206253b-56be-4999-98a1-f631766dda93\",\"name\":\"Reach Level 100\",\"payout\":0.48}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(348, '809078-lZ2kToJFfVYWxuk6', 'River Dash', '', NULL, 14.44, 'https://notik.me/api-redirect?token=eyJpdiI6IjNhcWd3YkRkMUk0ZzJsL3Faa2ZkVUE9PSIsInZhbHVlIjoieEFidksvTG9KU2VPdnI2ZklpY045OEtLdy9IbXNtdXRVOUU4K1ovY0VvWW1HSmlHWFNlOVVrNGUvdVcybVhxMnNZdHpxdExTNlVKa0NzR29udUk4elBXSExuMko5citKcm1PTU1zSmRySlhMK1g0bm55M0tsWnc2NGMrYUpxV045Ly9UTFphME12M0pmc016bWFiOXR6WHU5RDVPdUgwZUZnNUhNZndiL1JJSnIvMzM4Y2RBckF3ejJBOG5NbEgxak5mc1p0MzJIODNyQ3RyR3ZSRklaRU9FZUFtSnlReWttcjdqRXNvdXVtdHRaYUV4b1pCL1M5L0V3NUZGZWhJbk90azhMYW5hSlFjWER4SzRDSUlMelE9PSIsIm1hYyI6ImFiMjQ1YmRkYmFhODA2ZjAyMWJiNjU1OGUwNjJhOTAzOTM3OTU3ZDE3NTc4OWQxMTYzMjM5MzcwMmNiYmE4YWEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, FR, IT, NZ, ES, AE', '[{\"id\":\"27c0833f-f086-4dd7-82f1-af9fbfbbfbac\",\"name\":\"Play River Dash !\",\"payout\":0},{\"id\":\"394fe73d-fa7c-4b5b-ad37-a4c1309688ae\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"753fdacd-ff91-423f-970a-1ec95ceb4382\",\"name\":\"Reach 300 Meters\",\"payout\":0.04},{\"id\":\"5e40382a-5763-49fc-b1a3-f822465d47b0\",\"name\":\"Reach 600 Meters\",\"payout\":0.2},{\"id\":\"6defdc8a-0252-4a69-bff6-49f46f7b6a8e\",\"name\":\"Reach 1,000 Meters\",\"payout\":2},{\"id\":\"a759b21d-4169-49f7-9e15-0353db9415b3\",\"name\":\"Reach 5,000 Meters\",\"payout\":12.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(349, '870188-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 4.97, 'https://notik.me/api-redirect?token=eyJpdiI6InM0Tm1wRnJXLzJ3dXYvb2ZsQXFBcEE9PSIsInZhbHVlIjoiR0FJS1JpVjBvUEs2eWViaXJXNXVndXVqVit0SDRFdmJvdnI0blBTSDZhNHBlMG1SVG81bWo3dk1qZVZ6Z0s4b0k4L3F2UnJjb0RBUGI4bEgzKzdvcE1uaXVlL25MN0ovb24rY25mY1dNQzMrdVRlYVJaYmU0Yk5hK0VHanlTZ2ZtVWFvbkVXY2RGTlBRR1Brdmt5ZzJ1M1JrNXZuWkRTOHhVTldmZG5ueXFTZit0S0pKME5BeG96Q2hrSmRBb2NCUEMzVDJsZXdMQVFCUkVzNDVYemYveURnRW0xNkgyRE0xM0pUeTVTclAyWDJsRkdEL1VibWsvTW96Y1NvdDkyRkI1d2ZRRmZTVFVKN1JaUkdaRjd3VEhEMGJucFBzRHdIL25SS0tZV0Jhc2s9IiwibWFjIjoiZDdhMjM1ZTgxODhmYjNjNGMyNGI2ODUwOTQ4ZTk4YjZmMzBjNDVlNjMzNjgyMDAzYWZlMTlmMTgzZTFiYmYwYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, IE, NL, NO, SA, SE, AE', '[{\"id\":\"f0603fde-3514-4afd-b91f-ec0da20f0d28\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"82493622-49fc-4bb8-a017-6284c7c9f5cb\",\"name\":\"Reach Level 50\",\"payout\":0.18},{\"id\":\"f0c7bbc6-f487-454c-a700-60df73773786\",\"name\":\"Reach Level 100\",\"payout\":0.208},{\"id\":\"1ee76953-8f9e-4339-a15b-2cacd2f4d5f7\",\"name\":\"Reach Level 250\",\"payout\":0.66},{\"id\":\"91d00f74-db71-451f-9adb-ff2df328d812\",\"name\":\"Reach Level 500\",\"payout\":1.3},{\"id\":\"e9052735-4311-4a7d-b99a-67fec42954fc\",\"name\":\"Reach Level 750\",\"payout\":2.62}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(350, '870197-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 3.32, 'https://notik.me/api-redirect?token=eyJpdiI6InJXNTk2eVJlOFhxZm5tN044SjE4UHc9PSIsInZhbHVlIjoiQWJvb1RjSUxYQy8wZ1IvU2FRNmRlNnFyRE5lZ2xjR21icnl6anFsa2F3ekI3QUVFZFJqeS9vKzhqUDUvcWs4VmhEakhNaWluVSs1L0Y0RlVqeWtYb0hqcVVSMG1qalZxRWI5ZW50MjNWRXN1azh1R0tPbVk5dXY2dzZoV1lWZHcvTzU1S1gyQkdzMGNQZUE4SzJHK2ljZSsrM1A3ZlVmdEQzSFZwRFQ5V0lsdXdHeGFiYy9TaWthdlFRT2preTgyQkUrRkQ1WFRqVEk5a0RORzNHZ0cvZStmT1FOYXZHWW9nQ09uS01MM1A0WlB3V2t4MlRoWTRMSk03NFk4dHBJNXR1Qk9lYzRVNWd1Wk56NGVtMzgvaWtqT21BMncrNC9xUUdCdGd2T1gzKzg9IiwibWFjIjoiODJkNDUxMTQ2NTRmZGY3OWEyNTVkZGFlYzMzMDYzNjZjMjM3NTIzYTk2MDBjZWY3YWIzNzFjYjQyYjJjN2Q0ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI, IS, IE, IT, KW, QA, ZA, ES', '[{\"id\":\"a2b5bece-31d8-46b5-80dc-79c91b95707a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"4fa6bf2d-1386-430c-a85e-e47a80890147\",\"name\":\"Reach Level 50\",\"payout\":0.088},{\"id\":\"30f8f4d9-85f6-42de-b3e0-1f25e97c1241\",\"name\":\"Reach Level 100\",\"payout\":0.14},{\"id\":\"30a762f8-6e9d-492c-8199-9f898c446518\",\"name\":\"Reach Level 250\",\"payout\":0.42},{\"id\":\"8d793dcf-628d-4edb-9dce-74e4a81f9fcb\",\"name\":\"Reach Level 500\",\"payout\":0.868},{\"id\":\"6a079259-3ad0-4209-91ed-486f09df7fdf\",\"name\":\"Reach Level 750\",\"payout\":1.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:49', '2025-02-26 13:11:05'),
(351, '870570-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 3.29, 'https://notik.me/api-redirect?token=eyJpdiI6Ii90Y0RacktJREpDTEpvMWpIUVZCMlE9PSIsInZhbHVlIjoiUlYrb3hPUm40Wk41S1VwMENvR2VYNlpJOTVlT1R4ME5uMld4K1R0Y3RQSGRuUHNVT0locjBtZ05ROWRXZjJkWElReWl6aXdmOHd6UXZmN2FTL3krU2hXSzFZWGt4bndiL1lCOEo0WnNQNXIvQlRwREkwRnBraThPVDJmSURhWTNCdGlUSG56SkhDZFJlUzlJbko3bnduRjh1L1kxMWxDMkZJTkNpbXlrUGVmazBLN2d5TXVRZng4emI1U0llMlNwTjdNSk1Tc0Irb0U2MG5xU2k5UCsyTkRUVHlORE1oNkN4U2dqYzU3S2U2Q1ptYjgrR3lzdDJsTnpaM2s4WU5WNFRzMmRJNStPK1Vab1h6YVFsU0lSb2JTcklteC94NDNjTWI2ZjJJdThzTW89IiwibWFjIjoiNjU5OWI3MDIyZTA4NzkwZjc1ZmM3YjkxYzRlOGYyNTVmN2ZkMDkyZmM5YjNkN2M3NGE5Y2UzNDNiODFmYmNhMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI, IS, IE, IT, KW, QA, ZA, ES', '[{\"id\":\"d80b36da-f43e-4c81-9844-d65af00a52ec\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"3edd3eee-da8c-4eaa-90a9-5ff05b3f3c0f\",\"name\":\"Reach Level 50\",\"payout\":0.084},{\"id\":\"c093a0fc-de6c-40ed-a070-b4d346b77eb2\",\"name\":\"Reach Level 100\",\"payout\":0.12},{\"id\":\"1d0d1fca-248d-48f2-be5f-61660c32e015\",\"name\":\"Reach Level 250\",\"payout\":0.42},{\"id\":\"87e6cdac-c8a5-4dbf-adf7-ced3f2be1419\",\"name\":\"Reach Level 500\",\"payout\":0.868},{\"id\":\"fc649ec0-e8d8-41d5-8269-d4648987c27c\",\"name\":\"Reach Level 750\",\"payout\":1.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(352, '885276-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 3.21, 'https://notik.me/api-redirect?token=eyJpdiI6InZvUUNER29kemxwR1FnTGZOSVovWUE9PSIsInZhbHVlIjoiRDdkaUJEcXdydEV6L0NVejd1aEovcGRwcXk5T2RMUHVSUWY4NmliRjc2alBrYnFwSjNCQUFEM1Y5UWNJUTFQUUF2M1ZvdE92OGdKUlB6MmhOVlV6TnJuOVJwWW5NS2NwN0F4bGc4cWpOTjdEUUxlMStsN2NlMGx2bzRmZTZpKzlHOTV0L0ZXNmZVWmRDZEt2TWg4NmR2K1k3Tmh0Q3dYL292R0RwclVaczFEdkZEdjY0TDBQTGkwLzlHa3Jqanl4MmJDZ1o4K08vYVJrK3gzMVk5eVcxODllT1g1ZmxoTjFpVEkrdlRSTTJBR256T3RIZkNNaHc1Q3J6MVdrM3JrYmZVU2Fzd0p1Z3pSNGdvN2xTb0Z5QWdUL1ViZzNFR3BlR3lrZzU3WmJqTkk9IiwibWFjIjoiNGIyMmUzYzBkMzJiYzE2ZWFiODIzYjA5Mzc2MWEyMWIxYzIzYWI0NTRmM2IxNzdmMTI4ZjAwYWQ5NjgxZmMzMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, FI, IS, ZA', '[{\"id\":\"be88a509-c729-4bba-9502-76cae4329e29\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"08b8c88d-5934-4c73-a8b7-ed47ebf6fe4a\",\"name\":\"Reach Level 50\",\"payout\":0.048},{\"id\":\"629a641e-6404-464a-ab00-081280d2e251\",\"name\":\"Reach Level 100\",\"payout\":0.06},{\"id\":\"d043269a-14de-459d-963a-3415dfb6b9e8\",\"name\":\"Reach Level 250\",\"payout\":0.224},{\"id\":\"a9f206d8-54b6-4d22-bc24-7813f3a4b884\",\"name\":\"Reach Level 500\",\"payout\":0.48},{\"id\":\"a3366d92-767c-4ceb-8fa2-2cbfced6cdcd\",\"name\":\"Reach Level 1,000\",\"payout\":0.8},{\"id\":\"d7282203-f833-4608-8add-35fec67fc7e7\",\"name\":\"Reach Level 2,000\",\"payout\":1.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(353, '885279-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 0.74, 'https://notik.me/api-redirect?token=eyJpdiI6ImthS3dtZWtTdHVsTVJyb3Q2eStjYUE9PSIsInZhbHVlIjoibEtLemlTekw3SllhTy9zUjdjakRQRzhHWmtyT1l3WHo4eVI2ZGc5NjcxRVVRWEVqakhCYyt5OFBYaVBjU01RTEFvL3Z6MFgwOU5lTEk4enhQbjlXa2pFVVpyalNYaVpLUUtVR0M1Y2VRQU4zd2NYUmUzMnpvOGlyL2tlU0pJdW1zMExHZnYrVm1pUmxrNHRvT2V5UjdyL3g2dEpzR25JbXdNejRuLzM1WkxadjE5ZVV4K2RjdlZ2Sm52dmdlZTBHbTA4V0diUHBMUXQwVVZtTUQ3eGR0a0prR0hOODhsb2VVMnd2d3ZqK3RzNHQrTGVCQW8wMWNaWEdxa0ZyL0RQQzFkN0owNW1Ra2pWaVVvZ0NKVktmNk85NDIzQWEvYVk2NWN2ekJzMW5YSjA9IiwibWFjIjoiYWExZTFkM2EyMDc0ZjY4NjliY2IwZTgxYmI0ODNhZTVlYWZkNzA1MjQ5MzE4OWM5OTE5NTVjNDFhZDBkNGZkMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AF, AL, DZ, AS, AD, AO, AI, AQ, AG, AR, AM, AW, AU, AT, AZ, BS, BH, BD, BB, BY, BE, BZ, BJ, BM, BT, BO, BA, BW, BV, BR, IO, BN, BG, BF, BI, KH, CM, CV, KY, CF, TD, CL, CN, CX, CC, CO, KM, CG, CK, CR, HR, CU, CY, CZ, DK, DJ, DM, DO, TL, EC, EG, SV, GQ, ER, EE, ET, FK, FO, FJ, FI, FR, GF, PF, TF, GA, GM, GE, DE, GH, GI, GR, GL, GD, GP, GU, GT, GN, GW, GY, HT, HM, HN, HK, HU, IS, IN, ID, IR, IQ, IE, IL, IT, CI, JM, JP, JO, KZ, KE, KI, KP, KR, XK, KW, KG, LA, LV, LB, LS, LR, LY, LI, LT, LU, MO, MK, MG, MW, MY, MV, ML, MT, MH, MQ, MR, MU, YT, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NC, NZ, NI, NE, NG, NU, NF, MP, NO, OM, PK, PW, PA, PG, PY, PE, PH, PN, PL, PT, PR, QA, RE, RO, RU, RW, KN, LC, VC, WS, SM, ST, SA, SN, RS, SC, SL, SG, SK, SI, SB, SO, ZA, GS, ES, LK, SH, PM, SD, SR, SJ, SZ, SE, CH, SY, TW, TJ, TZ, TH, TG, TK, TO, TT, TN, TR, TM, TC, TV, UG, UA, AE, GB, UM, UY, UZ, VU, VA, VE, VN, VG, VI, WF, EH, YE, CS, CD, ZM, ZW, AX, BL, BQ, CW, GG, IM, JE, MF, PS, SS, SX', '[{\"id\":\"56042ba1-b67f-498e-926e-270d0169bac8\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f1b6cc1f-1076-4474-9f0a-16c4f03cba5c\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"a2754308-e616-4d90-8f38-bde281eb5fa8\",\"name\":\"Reach Level 250\",\"payout\":0.044},{\"id\":\"af248daf-dd16-4a08-ae65-991013af710f\",\"name\":\"Reach Level 500\",\"payout\":0.1},{\"id\":\"b91dc57e-6ecd-4400-91b3-dc5d8e00163f\",\"name\":\"Reach Level 1,000\",\"payout\":0.196},{\"id\":\"0c7040c2-8454-4e42-b347-6e73dc2c44ca\",\"name\":\"Reach Level 2,000\",\"payout\":0.38}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(354, '896625-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 30.99, 'https://notik.me/api-redirect?token=eyJpdiI6ImFKOTZwR2YwMDYrV1Y2cXlTbEdrQ3c9PSIsInZhbHVlIjoiUHBMNFgrM3BYYWVxdFZTd2FkREoyWXdReForbEt0ZkluMmhsSzNmbHBtdEhhZGRhdjROTEJIdHdKbUwrMmxEczViOUtVTFhUSUU4VVJEUWNLR3YxT0JiMnVQM1dwSzRkY01xaGdod3grS2tXTVZkTmFkWHZ3TXpabmUrUUJYNnF3SFB4RTh0UEVSdXFlR2FaUEhmZHRhKzlPNDZDTVBnUExXNGtScUY3K252WjlvU0k4ejRjN2NWaWhobkk4MmcydzVldnhNaXJmWHhqbzRndERsWjQ3NW80R0lqNTA3R0xVR2FQNzltMW1nUkEwRjBFYktVcTc2VFNyL2Y1alBpOURwWjVYRnk0Y1pRZm9NZ3NwdlRYMGc9PSIsIm1hYyI6IjQ0ZDllNzRhY2M3OGFjM2JkN2IwOGNlZDhiNzljMDVmNDE4M2U1Y2UwY2MwNDFiNDEwNTBjZTE3OTE2ZDJhYTIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"a1f8272d-9966-402c-a4d8-49c630e08948\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"9976b530-042b-4dac-833a-b93570bbf1e0\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"4e9aeb87-7612-48e3-9e4f-82a63a51d20b\",\"name\":\"Reach 300 Meters\",\"payout\":0.14},{\"id\":\"51af047f-4f08-451a-97bb-4d4dbdc96361\",\"name\":\"Reach 500 Meters\",\"payout\":0.44},{\"id\":\"104bd2b9-955e-49db-8612-675866209fdb\",\"name\":\"Reach 1,000 Meters\",\"payout\":4.4},{\"id\":\"88bc8ef0-dfba-4984-be1c-ac0f22cf1b9c\",\"name\":\"Reach 2,000 Meters\",\"payout\":26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(355, '896906-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 30.99, 'https://notik.me/api-redirect?token=eyJpdiI6InIyd0FQTVFwUUx6Ymw0QWhIOWFIclE9PSIsInZhbHVlIjoiZUl5UnJRWmpZL3gzVkFVSHBNeTJDaTc2MFJ4YUUyRHRlV0FXcEZJeDB2bGdJTEphcmlqNUd6MWtubndnOWNJWUdWNXVEZ0xIU0dHUWlkd0EvUmVXYUpoajJEY3RrVW5kWC9IK1RqS1FJR2ZIeUhvNzBpWDlCQVZIMVhQYWJZZnNpQm9GL0hiSFNTWDRjM0ZNNnhyRklwMkxlazBYMFRmc0Y5RnM2T0RUbkJLRXVmT0I2WVpQMEsvVDl2c2ZvbzlhUUhPUVdPL3lraFRyc0FmR1ZObG5IdHd3ZEhQS21teVJwU2EzRDZQeXlKVWttSFNOZFdiK0VHQVdmOWxBUUpQUzZjSW5wcTN6bGlJQUE0QTYxcFVlZFE9PSIsIm1hYyI6ImM5NDdkYjgxNzc1MjljM2I0YzVhMzFkOGE1MjZkMWZjMmVhNmFmYzYwZGU2YzRjMTc0ZGIxNGNhOTM2NjQxYzUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, JP, KR, GB', '[{\"id\":\"2854d33c-b71f-4caa-9fdf-dd800bbe20ef\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"582abbf0-1b95-4fe2-8c73-4b86d0506b99\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"1ff82a77-ffe8-46c7-9c2e-cd2d57415056\",\"name\":\"Reach 300 Meters\",\"payout\":0.14},{\"id\":\"44c92ec7-c930-4473-8e3b-c5989c7c6aa7\",\"name\":\"Reach 500 Meters\",\"payout\":0.44},{\"id\":\"27dabcc4-3d83-4fcd-9722-369f38a31f79\",\"name\":\"Reach 1,000 Meters\",\"payout\":4.4},{\"id\":\"f12d7c2b-4d70-403c-9772-db1e4c89b112\",\"name\":\"Reach 2,000 Meters\",\"payout\":26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(356, '933720-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 10.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ik4xZmlNZ2VYK0NpbUJqQ1E4U0xPeEE9PSIsInZhbHVlIjoiVFhwL0FFci9wTmREY3VpclBJdjY1SUlKQk9CL01leUpJK1A5bEdPZG1DLzBESWJSWHlja0JibXowekJ3T3BBUktZTEJBMU9yVENKYjlWQnVDMDhtM2dpYXJBWUprdkxOUG43cjhSdytBNDRtQ3pVNnA5K0tSSnY3cnlaakpjcGtheXdWcmRGek5iVzRzNmd6NDFPY0dSRC9pYWZQOXc5dWhqWXNNSWE3akJ1QmR3c1VVdXJ3R1lDWlZ4UG1PUktVeXJIaTRISnI1bkFmNmVsbFJ5L0tkMGplZXJ2alFVK2d6WnUwb2hKNUw4REpxWDQ2WW8wSVpVL1BtMnRHYzNSR2FxRmxhazFSTGpIR2M5UEFoRmVVZktuWmNYOTU1T3VZOE9OUWpGUU1ZSFE9IiwibWFjIjoiMDFmZTkzZTg0ZGMyNGE1ZDE2ZDk3ZmM1YjNiNjY2ZjBhYzJmNjQ1ODQyYTYzYWFiMWQ2YWRhOGI2MWM3MTlmMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"d11ca934-2d89-4bfc-bb2c-95ecb4c43079\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"949a59ae-d48e-4907-a8ae-3f0700271fb1\",\"name\":\"Reach Step 25\",\"payout\":0.14},{\"id\":\"d0152f57-0453-42ed-b3ab-b2ae7271e6ad\",\"name\":\"Reach Step 50\",\"payout\":0.196},{\"id\":\"3c77bc03-a71f-4038-a3bb-338ac144fc01\",\"name\":\"Reach Step 100\",\"payout\":0.42},{\"id\":\"9dc5a3c1-c426-40b0-acbe-f255e1c846f5\",\"name\":\"Reach Step 250\",\"payout\":1.12},{\"id\":\"660c8eca-3df6-4a63-a6fc-e0477fb9058f\",\"name\":\"Reach Step 500\",\"payout\":2.8},{\"id\":\"57bcff7a-bdbf-485d-a68c-cd8d8130e9af\",\"name\":\"Reach Step 1000\",\"payout\":5.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05');
INSERT INTO `offers` VALUES
(357, '1012469-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 15.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlYzcjFvS0k1T1dUT0owakdnVXpucmc9PSIsInZhbHVlIjoiNW8xUUhlK09UNG1NM2lHd2tvWXAvRHhkWjdiMCtpM1hvZUJURks5emRTeTZ5dzY1eEdqY0MvMnZYd1hmaXZUYVVubEJsbjN2NlEwdU1PSkxXSE9rV0VZYmJYQ2k0UmQ3OEs1ZEpqVHQ0VjRoVWRxMFJOSE1Qa1Y5QWhVU09BY3lnVzlWK1NKeSt5dGswOVFuYmhqS3BnaWtQMHgyTlB6cnl1dE1NYnhBeXFTZEFENWR2MjAvU0I1c1dwdXRFU256aC9BaXdMUlhhRmgwenFrVUdIZ2JXblZwUmxLT01RNUM3NnMyVmkwWE0xYXd1dkNmR21lb0krZDMyOVloU20rbjNXOEVpSHFydzhhOGNOTTlRT3NQVnc0d3pzblJhbksxTC9Cc1h3WlBrWTQ9IiwibWFjIjoiNzAyNTA4N2QxNjMzZDg0Y2Q2ZmRlZjM0MDFmMWYwYmExMTc1NTEzMmMyNTc3MjQ4YWRlMTgzMzg0M2E5OTM1ZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"97618a61-6287-47f2-9e93-35d70317c620\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"b2692687-c355-4b43-a1f1-98136631aaf6\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"052abb70-3b7a-4380-87ac-d1a556b53362\",\"name\":\"Reach 500 Meters\",\"payout\":0.12},{\"id\":\"1a7a7941-7ce7-429d-9ac1-14bdad506040\",\"name\":\"Reach 700 Meters\",\"payout\":1.6},{\"id\":\"0a995f64-74aa-4f60-8ac4-0a667024bbaf\",\"name\":\"Reach 900 Meters\",\"payout\":2.4},{\"id\":\"1952a187-a9f3-469b-9830-b7c29971c116\",\"name\":\"Reach 1,000 Meters\",\"payout\":11.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(358, '1035953-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 16.55, 'https://notik.me/api-redirect?token=eyJpdiI6IlpWY2VpclhiQmgxeEZTbExoa1FmR1E9PSIsInZhbHVlIjoiTTNDU2tFVEJPaWZ1UkNQNFdvWktxdVRyN3FMeElMb3hnMy9xVmx2UWJrTkVaQy9CdWRGYWJiSm5BRlJjUDhyVnBPOEljK3N1U3NycnVlOWxyaW5nZDZzdm5ScTd1Y05XRDJ3enJ3OUVibXFVcWk4MVk4anltNmhsWU9sQnRBNVRUb1B3RjBiUmZ2RUg5akE3aXdVbktvMjlySEFwNmErOGtMc2JodUlPRGtYcHFSL1docCtvZkc0MjgwaWJrN2JMdUpGYUFhK1h0d0JMemowN2ZuNUpQSDg0MzRoQnEycFJCb2FIeC9md25RaC9GOEpGVXZpWnlsdWVJWTg3RU5tU0hsbUc2T0tFMTRzY3JTa2E2VTkwY1E9PSIsIm1hYyI6Ijk0OTQ0ZjlkY2E1NzUzMjgzMTMwYmRiNzM2YWI5NWNlNmRkYjIyMDczOGJkMzZlZmNlN2QyMWQzYzUxYTkyMDYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"ddbab19b-0afc-46fc-8c45-95ea2839b3f3\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"1c78db1a-8205-4f36-b153-7ffc17730397\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"8a77749e-9086-43f0-90c9-83cdeb0492d9\",\"name\":\"Reach 300 Meters\",\"payout\":0.14},{\"id\":\"79d70c63-ef39-4b80-ab59-a9a5abce4e1c\",\"name\":\"Reach 600 Meters\",\"payout\":1.6},{\"id\":\"041498fc-67e6-453e-9898-d5e78e6dd27e\",\"name\":\"Reach 900 Meters\",\"payout\":2.8},{\"id\":\"7d8d2dc3-87b8-4b38-8ebc-58060994eaf2\",\"name\":\"Reach 1,500 Meters\",\"payout\":12}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(359, '1041639-lZ2kToJFfVYWxuk6', 'Iron Dome', '', NULL, 8.26, 'https://notik.me/api-redirect?token=eyJpdiI6InRvVStvWG9FZTdxN2Z6UGxyMExJa3c9PSIsInZhbHVlIjoiV0hyRFZwY2FuQ3F4VVpFUDcrQzFiem83ejU2MzJjYmd3RkJHSmtxV2pFdFNoc3dXeHV2SFNadHpKbkJwTVovSDVsOHBna2czVkt2cVJoekRTVHVHcCtzT3ptaGtPMktSNmVKVmU3V0Rva3hpZFdYOXp6M3FGdEJMdFZwTGJ3UWlTVHZCMkhXV1Y1V2dxaWczSk91cXUzbnVXVHF5L3Z0cTdldHYranR3R3hvVUNpdThHOGlTU25BVVVsUzVzTXpGUlNicXZpMHZpemNmMCtVMnMvNVdXR083VTZzQ25mZVZTbzk2U2dmQTRMbExwMC95a0Fya0NFb2ppcjNiUTZhOXI4akxpb09tRTFRclkxbitmTHRST3c9PSIsIm1hYyI6ImM3NGMzMDM3MDhiNjNjNmVlMTQxODMxNDM3MWYxNGQxOGQ4OTY3ZmIwYmU3ODQ1YTc5ZDgzZmZlOTg3OWE3OWIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MX, NI, PA, PY, PE, PR, UY, VE', '[{\"id\":\"2b3acc22-757b-42e5-bc89-7f3745ae3a55\",\"name\":\"Play Iron Dome!\",\"payout\":0},{\"id\":\"bca1aeb5-7940-47f5-9fd2-73c2cf9fbf7c\",\"name\":\"Alcanza el nivel 10\",\"payout\":0.004},{\"id\":\"90c15cb5-de82-468c-a593-11c233a8842e\",\"name\":\"Alcanza el nivel 30\",\"payout\":0.02},{\"id\":\"61ae925b-4e9d-4081-9189-cfda152477bf\",\"name\":\"Alcanza el nivel 50\",\"payout\":0.4},{\"id\":\"0e5c6244-6e3a-488c-ae62-e018644f6862\",\"name\":\"Alcanza el nivel 100\",\"payout\":0.64},{\"id\":\"ad202d0b-4f02-42d4-9694-4b4b45f0118c\",\"name\":\"Alcanza el nivel 150\",\"payout\":7.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(360, '1071277-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 15.03, 'https://notik.me/api-redirect?token=eyJpdiI6Ii90ZGdjR2RkNmdmZUkzQS93SzBLVkE9PSIsInZhbHVlIjoiQkhRZkN0OUtmSWNST0M0d3YvVmU5ZHpwWVZidEU1aENuSVNYekRYMG90aTlpMllONXpVQmJjcFpVb21DRVJOVFVENXk2YkQ3MzJWMllhVW5XOVJIayt0QmFQRlFUZTRVelR1UzJmMkgwOTZsTDA5bjJ5dTVoTFhxS0dkTitwRFRTSS9TUHlDQ3lYRnh1Ni9hRmVVdWFOSFQxRnBnN2pSY3h4MWR1dWtxVXlYejE4WlhaRTlkOWlQOU9nQ0gvT096YlZad2FIK0lySnFxRUUveS9VRzBYMGdLc25TQWRPVU1LT0RuZUNTQ3ptam1BcHEvV1BwQWZBRnZVNzBCN1Y3Zy9wQ3ozMUg3RUtBaU43cGpZS3k5Q1E4ZzczMHZCT2l1SVdTek9xSHlGUmM9IiwibWFjIjoiMzA1MzUwY2Y3M2FjYjE5ZmVlNmQ3NzJkMTA3NzExMjM3OTI4Y2FlMjQ3ZDM2YmUzYzg3ZTYxMTdkMzFlZTU4NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"faaaa3e1-bafa-45c5-ad4a-5ab561d09260\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"ae213411-0f7b-49b6-9840-1d514bd8ca4e\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"ee3b054e-821d-4389-b11e-d6eef688d91e\",\"name\":\"Reach 550 Meters\",\"payout\":0.02},{\"id\":\"1ca44463-0b59-4687-942a-e7406d35bd14\",\"name\":\"Reach 700 Meters\",\"payout\":1.4},{\"id\":\"100c8f6b-4a1f-4a3a-91a8-5648e258df13\",\"name\":\"Reach 900 Meters\",\"payout\":2.4},{\"id\":\"68e76123-2d5a-4883-ad1f-92d1a374dd5a\",\"name\":\"Reach 1,200 Meters\",\"payout\":11.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(361, '1086203-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 31.97, 'https://notik.me/api-redirect?token=eyJpdiI6IjN1Q3VUME4zajlGZHhZeG1qcURlbkE9PSIsInZhbHVlIjoiOURJcjlzcTdZbUl2R0hraUlhb0dLT1RDUTlJeGlXTU1rbzdES3FCbHpGVkdKU1g1SkVwcFhTd1BtSGl2VXBnMGJNL0lZSFlMN2oxdnJTVE5nNWdlVWhSVHVnUTFMNlJVVGZqZEtyTCtCNlQ5TUhuOHhPMmNjNHp4VktJWGlQRTF2ZGlMQTRkMkJEUWNmZE9mVWRLb0RLbDh3TnB1eDI4aURVY2crUnE0MUVpMXhtcFU4K0krWWFwUDdBM0dSSTdwQ28wVU4vcDZKVTJMWGJxNW01bFlyRlhOR0FkZFBuTzZMaFJiNmZvRUt6NVNYY2t0YmdvSmhrZW5PSE1xYnBwMmZhNFNKM0tLbDFyRDJqMlVkZFdKRjRadk1pUStkQnpTaFF4cFJYS3p5UFk9IiwibWFjIjoiMzFiZmZlYjliOTE2MzdlNGJjMzljZDcxOWE0ZWJkZDA5ZTM0ZWRlZmZkODc3ZWNkODRmMDRmYThjNWI2ZTA2MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"0e69be9d-5dd0-451d-a77c-75400e3e5894\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"37f427c2-e349-4939-ac24-4ce3dfd59ddc\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"e64400aa-9d00-4c70-a972-201726bb43d8\",\"name\":\"Reach 550 Meters\",\"payout\":0.04},{\"id\":\"73888745-1c20-45f3-a32b-291a1dae15ae\",\"name\":\"Reach 1,000 Meters\",\"payout\":2.72},{\"id\":\"33945230-f604-4cbb-8479-2e0b47dae296\",\"name\":\"Reach 2,000 Meters\",\"payout\":10.8},{\"id\":\"282f3bd7-67f2-4480-92a9-aa9eb60c50e1\",\"name\":\"Reach 5,000 Meters\",\"payout\":18.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(362, '1157183-lZ2kToJFfVYWxuk6', 'Save with Coupons', '', NULL, 0.01, 'https://notik.me/api-redirect?token=eyJpdiI6IndQb3dScGdLTmo2OTVFMVVuWHNGcmc9PSIsInZhbHVlIjoiSFA2TmE4cFlSVXVCVUZHNFNXYkZEWXc4NFNKR2lYbVk4U2pvaU1DL0FEdk5kckRneFNDVDBnQ1lCQUdEOXJYSEFvd3lPME5ERzRja2JNWC9kemtiMXFhUytMejVyZG9MRHZjZDZ3aEh1b2lidDU5azVWVEY2L2djeVRHT29wKzJXVU10RWRidldXNHFPeWlqajZnL1hYN3pSZFRNZGdJK2g3U3J2Ulh2dzlDZFJIQ3pZQW00bmZOSUF4eFFvenBHYytCc0hXQ1VsVGlWWGt5ZHhid0ptM3d5RUNLVDFGR3VzWEIzaE9WdXVMY05jbzBSMk55RW1ET2RLYjBaUW1FN1kzWkNXQ2svZGJjNTBxRWMxdkZxM1hWT0twdWVRT2p1WHNwTm5yUkloa0k9IiwibWFjIjoiYzA5NTQzMDc5ZmM2NGI3MmNhMTI3NWI5NDZjMjU0ZDcyMjhmMmI1NzhkYzgxMTBiMzY1OGU2OGU0MmYwNmNiNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(363, '1157821-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 5.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImNNalcxdnZLOHgrWmZ6MFNCYWlKdnc9PSIsInZhbHVlIjoiWVIwSk9FaUhoMWdxMTl1azNyaCs2aDFMV0lyWk5IcDNKbWZpZVhnTkhiZ1ZqT1VjczJES21rbHJsUnFkbVJ3dk1kMWhmVXBQbCt6UHFNTkpNYmU0aG5XUytCaVBhUVNibWJCanZhQkhsbHU5MjFjUlM5OFY3ZnkvMFYwNHJrcStvMU9QSjE2emlsZEVhWG1vUWpPa2ZzdnlibkNSUVBvRmw0UXY1RjAxWmFxK0pCaEZSdWQzSTBoUXFLNUZxdUtqUmx3c05pNE5acjZpbTZyMk83U1JqOGdpdDlCdFYzVFBQOTlnRDB1WHB1dnJvVS9vTjh2TFliL1RvK3JMQXZxMi9mcy8zMzlZWVd5anY3eTFnUFdCc2lReFNTbFpuSDJmU01reS9yYnBVdFk9IiwibWFjIjoiOTcyMWRkYmQwYjRmNDg4NmY5NzEyNmUzOTQ3ZmE2YWU3NTc3YWVhOWFjMzdmMjAzNmIyMTE5YTNkN2QwNzI0YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX, PT', '[{\"id\":\"3ed503a3-bf82-479c-b790-a0ec565a155a\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"1fa73a40-8ab7-4bb5-99a6-222913fc35bc\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.14},{\"id\":\"a1471b0b-9baf-4cc6-8a49-f19a1fe69279\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.32},{\"id\":\"a6615982-c518-48d9-8105-abf2b4cfea6d\",\"name\":\"Complete Hidden Level 50\",\"payout\":0.6},{\"id\":\"56a818ae-96e9-4de7-b933-47a85cf6a9b6\",\"name\":\"Complete Hidden Level 100\",\"payout\":1.4},{\"id\":\"d13cd66c-4144-4f23-a4e8-49fd39b7c59e\",\"name\":\"Complete Hidden Level 200\",\"payout\":2.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(364, '1157834-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 8.70, 'https://notik.me/api-redirect?token=eyJpdiI6InNzNWNzRzE3bkoyTU5rRkVIUkxySUE9PSIsInZhbHVlIjoiM29IK0c5bW9yL1krSVRzUTRQYk5hdUlzTDZseWxhdjJTNVVuT3IzR0FKN0tLdDgwNk90MnhVUXg3MElqWlhGT2w0S1BtdVJ4MzZISnZaZDEzSnBGK203aHdhbWhoSERqQno5cUZUUTN2R1c0UFZ2NlJxeUh6S01NM3hjOXZlTUhrRU5pTEEzSTJKZ2djSVl3c3hSTFpubzVRWXZCcy9zVmtuY3lZUElhL0dGU2RUTkI5OTR4VkxuM2JTdHdHWVE3S2p6bEtuQTFEZXlQcDZvNXJjYTBWcldIVnlCWXlPRC9iSEpGT3phNDg2bm03bjV6YTdTTlNjOEhVbkt6dy9TS0RMeGZiRk44emwyZk9wNVJFN3pYaGI1YkJDZlZqVy9ha25DeW1CelZBekFwdVZHSUVRcldQSFRHRldlLzdaaTkiLCJtYWMiOiJhZDE2ZWJiNDA2ZGFlZjQ0NDEwZmUwNjZiZWJkMmYwNDZiNmVkODc4NTBiYjViNmVlNTJhZGIyYzdiZTQ5ODg4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, HK, NL, NO, SE, TW', '[{\"id\":\"fe411b8c-1b52-4a6f-b0f5-3535f4c83773\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"57b56035-e74f-4f7d-93a9-ff0a3655f212\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.236},{\"id\":\"77b22c95-a185-4220-9fab-9fb4d9d8221c\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.56},{\"id\":\"52d99199-e321-4d0a-9497-3332786c65d0\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.26},{\"id\":\"07a951ec-4870-44d7-9ea4-7d762a429bf3\",\"name\":\"Complete Hidden Level 100\",\"payout\":2.24},{\"id\":\"f89e320f-04bf-4c5f-9e0a-ce4489a1323c\",\"name\":\"Complete Hidden Level 200\",\"payout\":4.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(365, '1157837-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 4.10, 'https://notik.me/api-redirect?token=eyJpdiI6Im5YNS9CbXJyMHhRNEJTZGF4Y0pkL2c9PSIsInZhbHVlIjoiOVhoOWVHTHdRZXY3SEg2SkI2Uk0wQVdnd3c0eUpFWjFMSXB5MWlFMWJCWDNyWGRTWDc1L2ZFd2tGY2s2VUZEaU5xaU1pN28rcG1IclU4UXJoN0NCS09jZzNyQkpuMndyYjNxQ3h1d2pBcUZxRFcvWkZSdm5Ya1orY0sySFNkOFNBM1dBMDQ2WGhnbkw0TVhJR1J1TU5iSkFnZkdqL2t0VXBjTmhHdHZ6dzV0QTJtUkFZRFVHV0ZIRitFOVMzVGMyZHovM3Y2ZmRVUFJJREFmWEIzYVlFOEI0azROTmJ0Q3RTL1NPZGh5K1lsZ0FzTmFrOWlYVGhEbWp5eWp6ZmhQSXN6OHNhank0amUvQmZMMXhWdjVHeFJwSkQwN1hLOG5MTVhGNjBibE15WWM9IiwibWFjIjoiNjcyY2UxZWZjYjFhYWRhNzY2NGUzYjZlZTY4ZWUzNzVlYzQ5YzMwNWIyZDRlNDg5NTllZWViMWI4ZDg4ODI4MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[{\"id\":\"f4e3d2ed-87da-4f96-a5bf-56baa2975506\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"2e90fd7e-86a2-434e-a180-01c9220ea85a\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.12},{\"id\":\"fb9c9a17-bc34-4e66-a5a4-ddb4c9a02ce4\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.28},{\"id\":\"3eec9e3c-98a6-4e05-8a0d-1ef5f5745b13\",\"name\":\"Complete Hidden Level 50\",\"payout\":0.5},{\"id\":\"b2ea33b7-b260-41fa-a5e1-76dfbed296f0\",\"name\":\"Complete Hidden Level 100\",\"payout\":1},{\"id\":\"5e23619f-bdf8-4a34-8158-6485cffa4f96\",\"name\":\"Complete Hidden Level 200\",\"payout\":2.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(366, '1162238-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 4.26, 'https://notik.me/api-redirect?token=eyJpdiI6IkRoRS8wSGdqOWE3cE42T3JPR0JvcXc9PSIsInZhbHVlIjoidU1lM3RwVStVM1ZoSEJSYVlUZXdqQ2Q3elMwVVFDelVmc0dYTlBmL1crQWVWRXhVK0lMRGpYaGxoemI1V09LZWtZRG83R0FDbEdreUJBZDA4R0twTGlEWVJNYmRTaTk2NGsxbUZxTWpWcjlpY1dWMEY4bDNzemRocklIeTF4RWUwencvcldUblBZNUdzaDVPZ3NwMEpBQ3c4Z0xDVXZFdjZYalp0T1hFeVJ2Z1NwT2IxZlZlMVdENXplNUpGa1NmU29LdWE0KzFIVFRPZTU4b1oyMTFUOEtNYys0QlUxM1JaSll6NnRZcjhPY0lzdkRya2g1ajVBalk5SW9nYVhOV2FYdlRBNWt2WkJ2b0NJWFc0aURyTi9TRlJtMTJlRU9sT0tlWm9OY0tSeFk9IiwibWFjIjoiMDdiZmNiNjQwZjM5ZjFmYjUzNDIzMzgzY2JhNDEzOTFjNzk2NmMyNmIxZjk0MGYzZGM0MzRhOTRhYjUwMjI2YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"b04af830-028e-445a-8d1e-b11fd404d64c\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"723916c8-bc48-4902-b910-b6e6f396fa6f\",\"name\":\"Complete Level 100\",\"payout\":0.08},{\"id\":\"5b6297ba-e6c0-407a-a445-f6476c7c3646\",\"name\":\"Complete Level 250\",\"payout\":0.224},{\"id\":\"c42068a2-7dae-4e12-b975-bdaa74b7d380\",\"name\":\"Complete Level 500\",\"payout\":0.6},{\"id\":\"5b365c83-50f3-4483-a99b-85bfb0c22aa1\",\"name\":\"Complete Level 1000\",\"payout\":1.12},{\"id\":\"904f6b20-11c4-4a2b-be93-f5a4afcb0fb7\",\"name\":\"Complete Level 2000\",\"payout\":2.24}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(367, '1273937-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.27, 'https://notik.me/api-redirect?token=eyJpdiI6Im5mb3NHWDJmcnBZZGt2dnNRbVpuelE9PSIsInZhbHVlIjoiai9KVGpvdmthcGlrenJUK1BZMUNIT1RUaVV2NjlzMEtYOHdST1YvcktObVhZT1p2ampRWTVSaXdLbFNQUmRSUVA3dnU2blNJOFhGajdRS01IVTRNZGJHOUVTdnpiMHRDWHczcHhmTFNENFJEZGRZMnFDWVI2bFlmKzJrZlFYRTNuZFo5OVZUR2Fyb0dGcEJ2T1FENkFPSVV5S2FjUVNRVDQ3My9PM3lsbTZxOTlLd1psa1ZzVk5kU3VWaElRdzd4U3hWMmxvOWcvVVl6SmVscXdOd1VmSVNMNmtWVlA3dFNqWlpUWkx2TXNOYnBLdHNhaEwwMUpnczVnTXcvS2xITFFuQmFCZ2dPSTNsSlIvdmNmV1FXQlhSOURxdGszdWNuT255RHc2RGxCQ3c9IiwibWFjIjoiOTg2NDc2YTE5NGQyMTEyNjRhOTcxYjhlNjBiMDIxZjljMGM2MTFmNjA1MjliM2UyYWQ1ZmI5MDQ3MzYwMjI3YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"9dbfcc5c-ca5e-46e2-9bab-c16874b77a17\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"84114a3f-984b-4b16-b5b4-6abe5e503856\",\"name\":\"Reach Level 50\",\"payout\":0.032},{\"id\":\"af212b62-79f3-42e0-a16b-0d9d931b97b9\",\"name\":\"Reach Level 100\",\"payout\":0.056},{\"id\":\"86453565-d714-4ea9-9354-61dc4d375291\",\"name\":\"Reach Level 300\",\"payout\":0.18}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(368, '1273945-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6IlJOb0Y0d1JkWWFvb0FLeFBiTk5Rd1E9PSIsInZhbHVlIjoialJpUk42K0VWclNWRnB0dDlUY0VSYWZxNzlYTmdNSFZiOUdTcFJ4dTVEOWZtMGc5NEI3ajNrZXgvYjRPTEFKOXRnUkZZakJSaTJNVys0T3V2MWVrRFA4cm1sVnJ4Z2dKVzA2bVFoUU8rZEdDeVVVbHY0ckxDR2ZXSml6NDVKNE1WeGd5UmpFRnkrakhLay84Zkc2cGR1Z05keDZwazN3RGtCTzdITGRWazRrTSs2cFlFMGlEOU94SXVBVmxRRzBmTVhPWXVFVWt5VEZHRXlTVWtvRWNVMXUvMEI2MXhSY0pBK3FsMFMwM05kOU1aTitmOStpbW0vbzAwOWVHRW4yODMyT29iTG9LUjRia2lQa00vUVVQWU0rRkhmV0RVcHF3a1JnbTM4ZTBVNVk9IiwibWFjIjoiYjE4MjU1OTY2MDFmZDQ3MTVkYmM4MTJlNTI1MmQ1ZjA2MGEyZjQzMzNhN2RlNTg1YTNkOTY5ZDEyOTJjODQ4NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[{\"id\":\"766e45b5-c569-48d1-9337-a5c1d0e65db2\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"48239c91-027a-40c6-ae19-921cfe86d00b\",\"name\":\"Reach Level 50\",\"payout\":0.02},{\"id\":\"92f27b8c-5a95-43c7-9817-2c8b895f3a82\",\"name\":\"Reach Level 100\",\"payout\":0.032},{\"id\":\"6f0e69b4-b7fb-4544-abc8-db60a806fbba\",\"name\":\"Reach Level 300\",\"payout\":0.112}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(369, '398323-lZ2kToJFfVYWxuk6', 'Connect Master - Pair Matching', '', NULL, 1.26, 'https://notik.me/api-redirect?token=eyJpdiI6InZjWjdGQlBNem96WU9waGdZV3piNEE9PSIsInZhbHVlIjoiRGhXUUliOW1CVWw3Q2YxQXBHR3VkaDlZZnQxUEcxTHdkWFhaSEZuWDlYU01sR3huR1hFZ2k1OWN3NS9ldmtyN3ZKcU1HNmNzZEF3VVdXczNMb25zdXNJTkNldWprcEczZWNpdURTcjdyRklJSWxtbExiczZualMvUlBLRXZMZU5TNml6bGptc3llRWpVRHQ3M1JGa0Rnd3h3Z3M5eW9yMnpjMG9jNE1IUW5zYnphSmIwYkFTa0VOY2RtZkVwakFwcFZ2ZlN2N2FLTmlUUi9ZdURNcm1EQkVrYjVTMFNPaVFJUGlmcFQ3Z0N5SkxoODgyNzZ6N3N6RlRYUnpWWGdaOVJza2lhbGFzUGJ0TVpLZnFTSm9Pc2hKSGFyc3RvdTlCQVpEMVAvNU9ZSXM9IiwibWFjIjoiNWM2MzZmNWRjNjA4YTRjZWExYmZlNmU4YjIyNDhlZmZlNjU2MDk2ZjQ5ZWU4ZTZjYjEyZDQxMDNhZDI5OWI1OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[{\"id\":\"4c4c7446-db2c-4ef3-9b6d-87fed3aa3590\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"1306831d-4d6a-415e-b2f9-449981892378\",\"name\":\"Win 50 &quot;Duel&quot; Games!\",\"payout\":1.26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(370, '403247-lZ2kToJFfVYWxuk6', 'Super Brain: Memory Game', '', NULL, 0.15, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1tUWwzSUNvM3B3SlhuUngzMGhmT1E9PSIsInZhbHVlIjoiQW94c0JIL2FTblhDelBBbFBzb0FBTSthZUUrQ0xFWlFEVjBqWWEycXM3Zmx5cVc2WTk1RmMrWGszODlXOTVjcVIwcEs1RFpRMUZ4UUFKQlZyenhSYjhvejZER3BJU3cwdHFEaHRYMml6ZXpKUzlLcTdDNnArVUtabWp1QjVzRFpZZi9jajhhbGZNMmFjTGZBbE5Ka3ZFWVd1UjQyeXJrMUkrUExzRW9qK1FsUnBDbmpyNmJySXdLQVdCaDFJMlhHbm1uVnZSQUh1WGZZWWRHdHVYSUtNOVpWeDZ0Uk1FR0Fzem1YWk5rR0FNRmlMdjAvaDhIbHFtM2xWaVA4MThFTnRwK09mNTYyMEtqY3hmalQxZFA0eCtra2JMNCtvVnI2UkhXVXdBV3MzcGs9IiwibWFjIjoiZjEwY2EzNWVjOWY2NmNlM2RmMDFiMDZhYTNlNzAxYjg3MGFmNTZhYmRkYTlkMmFiOWU2OGRiMTk5NzFkYzBiYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(371, '403250-lZ2kToJFfVYWxuk6', 'Super Brain: Memory Game', '', NULL, 0.75, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1lWHFPeHUzYW5FeGJSak5XWGh6TkE9PSIsInZhbHVlIjoib1BYdVZnQndsUW1iTU1wekQyMmF3b1hMVEkvVU1ydklieFpGYXNDLzVHNGI4c2JNRFg0RUxZaUcrS0FaS3FrbTErNldrQjJOSGFZU050SlJ0aWI0elpXWUNteHNvbENtR09taURmaWdWOFJ0dDhSVVpZUmNkQlZNR3Rjem81RXZsSWJrM0N5TjVqOEtqZjA3RFk1U3E5UERxSlRjZG5HNWk5TVJUWExucmY3SEVnUU8zZ0ttZE45OUd0eW1pZUdpYVI2d2hMNEltNTZpeVQycStGYUFDU3ozVXYrZVpCRDVHdFlQZHFoSnY5SVpDcHRxbU9IRzAzYzlSR1pvVVVESUZOTkJtVk12NUlSNUxoaXBjN1JxODFZN2lwOWEvVytRZGU0UngxdG85MTA9IiwibWFjIjoiM2RhNmI3ZTlhYjQ5NzVjZjU5OWFjNGYwNzY2MGNkYzZlYTNhYmMzOThhMDExZTg5MTAyZWVkZWM4NDc2ZmEwZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(372, '403253-lZ2kToJFfVYWxuk6', 'Super Brain: Memory Game', '', NULL, 0.22, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1qYnhUaUZNdnQzc1V2R1lNazcxQ1E9PSIsInZhbHVlIjoid2hVYnZyRzNQQ0hrQlBSb2s3Ym1rTW5pWnpZNitpdmtOZ0hOV29ITWhKaWlsOUhJVDYybEhsNUVJMHd2TUtXNFFKVmVKVU5FR3hLa3p5UldFbWovZEdRS0Fqc3F5SW9sOGtaUlpVYngyU2x6QnFjcnMyZW5TRHFkL0RBNDB3bHl5N2dIbzJZMFd3WVFxYloyL3NZQjc3VUpNT2drTlhpTlZhbUx0dU1URkM3ejYxWXNXQU9DakRKYzdOMlIxSEs1R2NPa2ZNRklCTW1la3ZSbmwweVJvc0M0T1UzcndBeEpDUk9iNHl5WEROQkNaUHRHWlY5S2dhclFUSVJrd0NtUjlBVzZiOENRK2hIUjBjZUE0clhVaWMzN2owNldDVlpoM0VoNW82Ym9ncFU9IiwibWFjIjoiZDYzMGMyNTIxZmNhNDc5N2ViNjM0YmQzY2ZhZGQxYmQ1MjMwZTNiZWM4NTQwODMzMjZjYWRiYzg5MTI4NGJkZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MV', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(373, '407183-lZ2kToJFfVYWxuk6', 'care.com', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6InNPOGtjdnk3ZFNnSCttUDNhK2p3Qnc9PSIsInZhbHVlIjoiZmtyREhuZXU2TFJETG50MkhFbWJaWHRhVEJ6UlhyVlVVZld0WTlQT1VMOEpabmN0ejBQUUpNZCt4TGRNWWJEL0p4d1R5MmNubndDSzdaMnpDcDNJdG9QdGVHRGxkK3lDWmdNcTVLeGVkTnpsWnhEMUU2bkJDeURKYUJVV1lPeXRTZkNFbFNTek5rZnhmcklJaElYdmdOQ2p5WGhrdlhQQkprWW9HYTM2R25GK0hncE42S0V1T2NzMHY5b01WY0tWakVERm5abUFkbFJyTFUyUENMOW9JV0NYOEk1d2U3R2pJc0kwQWRXb1p1V09SWks0NDRVVllMdWpPWjZ1aERKVVBlVGZ1ZHhlZXA0NXdIclpuL25JcHc9PSIsIm1hYyI6ImRhNTBlZmRjNmExNWQ5NjFlOTY4MjQzM2Q3ZGY5NjBhOTQ3MDdlMjcyZWMzMTdhZDYxZjk3NjM0NTE2YmQwMmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"138a0991-b7ba-42d4-8668-94b248f2401b\",\"name\":\"Register For Free.\",\"payout\":0},{\"id\":\"4f669a9b-325d-49ef-a0a2-0241b518feca\",\"name\":\"Purchase A Premium Subscription.\",\"payout\":2.4}]', 'all', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(374, '409270-lZ2kToJFfVYWxuk6', 'Rewards Giant - Asda', '', NULL, 4.20, 'https://notik.me/api-redirect?token=eyJpdiI6IndUZkFkeHpkdDhWMmpGR3p5KzZGbVE9PSIsInZhbHVlIjoiZWZQTDQ3b1NBMXNqcVo2UE5qUWl0dkgxUzgrUEh3QlMzbkNLTk05MVpTSGZLc2pQNGtRMHgwbmhtVEFQaXdRYzhqaHVEMm5XOGxsL2NnV2c4OUpGaUNTMzRlcUIvYkdTQXdvcnJVc00zU3FGSkJtc0NISys1YmZSRzN6Y0lqTG5jdnh5ZHY0aU9lcDZkOUQ2MG9vMFVQNTh6MmFYeVlhcmNqZ2RPczdKUXpQNGRac3I4Q0J1V0JPMThGVldJYWU2a3k2bndWWGVXTnljakhLa24rVG1sUmhZcWMrK0hzNmxNbmlQak9qdG5OL2QyMG1XUXZXVHZXT09jYnZEZWpGa3VwU0Jlb3hPK0ZhWFlpL3lYRDNsSHd4LzlmaHNTZTBzTTN5VWo5dDQvOFU9IiwibWFjIjoiMGI3MDYxNWJlNzkzNzA3MDhiNTRlNmI2ZTViOTA5M2YwN2I3MDM0ZTczMDRhYjYzM2E3OTVlYmRkNzdjZTFhZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'all', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(375, '669449-lZ2kToJFfVYWxuk6', 'Blocker', '', NULL, 4.48, 'https://notik.me/api-redirect?token=eyJpdiI6IjZvQzdCRVlCVUhpS1lNQkdWVmNPWXc9PSIsInZhbHVlIjoiaVM0TDZlMHF1QlYwdWUxV3hFdWJHOXVqMVA2aHRabm9HUmdHSFF6SzFRbUd4Mm9BMmRxUUVBN0RTVEZEcXpRZFQ2LzhzS240WHY1Y2Q1WmFPUllyS0NqSFhaR0ZvaXlqN1p5RnNHam9rbUhhRmhVNVZ3NFcyOFljSFpaaDNiUEsyRm9jTGpxZnJVSktIcWpmUUhjTXRtS3BtRjczUHZCRkZlVmhDMXZPYW14eXlBaG5yQWRXNG5vMzRIM05pdUJwSU9IdDZ4VGlvTGY2OVVLTzlIMENNa3VUMmdaRCtBUjdKS2dXTFdZY2w4USs5dzdLQUJzV0loK3EwTXpvVnpVRytFUm9kL0tHQ1ZCK1M0TjlsK3V6eGc9PSIsIm1hYyI6ImI2ZGFhNDY5NWY3ZjQzZmE0MjU4ZDE5Y2Y2NTFiYmE1MmYzMDNlY2YxYTgzZmE2MjkxM2E1Y2ZiMDM2ZjRkZmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, FR, DE, JP, GB', '[{\"id\":\"faf037a2-bcbb-43c0-9590-7bd14a557e18\",\"name\":\"Play Blocker !\",\"payout\":0},{\"id\":\"b44418d2-067c-4717-9539-564f3145f3fe\",\"name\":\"Reach 20 Blocks\",\"payout\":0.004},{\"id\":\"d0f767af-fd91-4e74-afbc-8825c06fc77e\",\"name\":\"Reach 30 Blocks\",\"payout\":0.12},{\"id\":\"3a145823-1e16-4129-b124-22251a5d269b\",\"name\":\"Reach 50 Blocks\",\"payout\":0.36},{\"id\":\"4a36003d-c775-4e30-9e2e-802a7c69861d\",\"name\":\"Reach 200 Blocks\",\"payout\":4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(376, '670870-lZ2kToJFfVYWxuk6', 'Space Debris', '', NULL, 16.30, 'https://notik.me/api-redirect?token=eyJpdiI6IkQwalpNZm5DdzJ2cGt6VThMdXZBaHc9PSIsInZhbHVlIjoiU2d0YWlkSHpoNCtHVExEZjlDMWxsTndTYmpwWFp4TFBOdXRXWWdjZjg3VXhSTnRQODU4V2gvOHg3cTcrQXdjSXo5WVN3a2ZiZUdabDNNQmt1SXJvN21PS01Fa2tpN2tBYTUvRWRPWkhpcmNXUUFHQVVVVDNWYnErWVB0N0ZsUm5kTWpHUFJ4RncxZUdZb0t0ZjI3WGY3Tzhvb3FlSW9qWVVOM29YVEJkTDhUN25VMkFKZ2JMMXUzM2V3U2dMMDRuajlCWTFVQUNob0VXa2lPTllKYXpWSGtOTFNpOVZCOHlCTFM0M1NUamozYTNpN3oyOXM2TlNyMWNUU3JiaEp1RU05Mk1kYXRxWlN3NmVjNmRXZVAxS1E9PSIsIm1hYyI6ImE0NTIwODVkNTdmYjkyMzQ1YzlhYWJhN2E0OWFhMzM3OGQ1ZTdjYWFjMzFiZGFjMmJhOWVhYTMwY2Q1ZDFhNTkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, FR, DE, KR, GB', '[{\"id\":\"b37f5604-3a73-4baf-82b3-606f2c145245\",\"name\":\"Play Space Debris !\",\"payout\":0},{\"id\":\"14481b63-9215-4dd8-8add-fe4b38d5316d\",\"name\":\"Reach 800 Meters\",\"payout\":0.04},{\"id\":\"d2a1597c-e3ad-43dd-82f0-1733f2ca0a37\",\"name\":\"Reach 1,200 Meters\",\"payout\":0.34},{\"id\":\"5e144e5d-5871-4e01-a1c8-8708144aa81d\",\"name\":\"Reach 4,000 Meters\",\"payout\":3.52},{\"id\":\"3d01bb6b-8ea4-42e8-94a9-b5f1a01f231f\",\"name\":\"Reach 5,000 Meters\",\"payout\":12.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(377, '670876-lZ2kToJFfVYWxuk6', 'Space Debris', '', NULL, 19.42, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1ibVMzM2VzMjk1bmU4RzYxelg5VlE9PSIsInZhbHVlIjoidUlFLzAzVU9Zb0ZGUHVVa2Z3clV2MEZvWW5mazV0SXVJdlNwVGtPL20waE9KVjV5WDBBYWFHclNqOXVhN2tuS0c4dmF3UVRqemtHR1EwRUtpV2x6WXFOWElZS0hpOXRqSllTM0tDbW5qZUowMUxGb1NpUDlHd0tHaU5sbUYwM0RPRzlTaGNlYXVGVGVqM3ZKWnBJaVJWSGppd2V6ZVcvNU9GZm5oS29YbUR4OCtiUVc4RWptZVY2UnRISnRjNEJVTnFSQVRPTU5rMjNGVTY4RXZ4NlgrY1llTmdVTlEyOFl0VVhUSTNRTVU3RlNKYmVaR1dVdVBHQ3lBSnZCT25PZ1ZHblY0TE9SNGlTOUM4TE9hWkJFUEE9PSIsIm1hYyI6IjE3NTUyYTlhMjIzODVlNjRhNzkwODc3NTJhY2VhNGE5OTg4NjA2NTU1ZmNkMWEwNTNmOTc4YTcyNTk5MjFlOTciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, FR, DE, KR, GB', '[{\"id\":\"8f95d27f-30e1-4eae-a2af-395903f62757\",\"name\":\"Play Space Debris !\",\"payout\":0},{\"id\":\"50f09933-f0c3-4202-b546-e3e8de792d19\",\"name\":\"Reach 200 Meters\",\"payout\":0.004},{\"id\":\"5185ed0d-45d2-4e3a-8ecb-77980bd3d678\",\"name\":\"Reach 800 Meters\",\"payout\":0.16},{\"id\":\"6a2f68a5-14ee-40d2-aa3b-0b73f317bae1\",\"name\":\"Reach 1,500 Meters\",\"payout\":0.34},{\"id\":\"2f230bdc-4fe1-41a7-9180-b7c373c0d4b9\",\"name\":\"Reach 3,000 Meters\",\"payout\":3.12},{\"id\":\"375abfbb-54a0-4fde-9038-f2d7510b1a6b\",\"name\":\"Reach 5,000 Meters\",\"payout\":15.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(378, '670877-lZ2kToJFfVYWxuk6', 'Space Debris', '', NULL, 14.48, 'https://notik.me/api-redirect?token=eyJpdiI6IjhaUFpTcXVyTEtLS0pjUENEa0Vmd0E9PSIsInZhbHVlIjoiTUw0VFhxSHBDMUZEUXJCalAyQ0RkaWdWamJJN3BycDJwSkEvWlhueWRMT0taQjdxb0FuRkEyV1dsbkNYUTFTaUw4Y3EzdUJuY1ZoazhmNDhmeUZvRXBUelo1eXZ4RjVxeGJOZHVGbWJvQnRnR3JwSWVRZlNoNkJ1ZjQ5cTJxbkdHQ2hqSlFnS3MvNloxRXFGeU0xYmFWQW5NV0QzaW1Ec293VXY4OXBad01LbXdrM2YxSytzbVBYZEQvcUl1dEZoaUc5bDFTMlgrN0MrNVZ6elJaR1pFUVlLR3NtVkVMMzBWdkNBWTRLSXBxR05sSXp4RXBNQkhVRWwyOHJIWjdQMDdjTkx6c3lGSVFqV0paZG0zTXlLWHc9PSIsIm1hYyI6ImQ1ZGE1Y2MwOTU3N2ZiM2Y3ZjI1MGI4MDc1NDhhMGRiM2U4MWM1NjNmNjc5MTM5ZWJjODdiNWIyOGUwMzlhY2QiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, CL, CO, CR, CU, DO, EC, SV, GT, HN, MX, NI, PA, PY, PE, PR, UY, VE', '[{\"id\":\"faac5bca-42cd-44c5-aa6f-2720263b0c81\",\"name\":\"Jugar Space Debris !\",\"payout\":0},{\"id\":\"c511c698-a990-46be-8843-5d73768b0d63\",\"name\":\"Alcanzar 200 Metros\",\"payout\":0.004},{\"id\":\"0f13919e-24f1-46a6-b566-f7b50e845c0a\",\"name\":\"Alcanzar 800 Metros\",\"payout\":0.08},{\"id\":\"a02de8c2-de7c-4753-b98b-ed326a3b4ad5\",\"name\":\"Alcanzar 1500 Metros\",\"payout\":0.2},{\"id\":\"5745b697-28a2-4640-8d11-febccddab7ce\",\"name\":\"Alcanzar 3000 Metros\",\"payout\":2.2},{\"id\":\"7823bd02-5c9d-4492-8916-cc65807f8770\",\"name\":\"Alcanzar 5000 Metros\",\"payout\":12}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(379, '670882-lZ2kToJFfVYWxuk6', 'Space Debris', '', NULL, 16.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImZzcGdJTm5NVjc5eVVRcTZXMExxSEE9PSIsInZhbHVlIjoiZjhsWW9xWjhrNGlYcVV4QW0zTkR3ampOdHNWRTl3dkt4ZCtUMkZPcFdTZ2VuYW9IK0w1SExDR0hPSmNEeElKMGVtQnhwQVJmN0dWNVhTd3lVT1B3Vi9semU3WnZ5ZEQ0M09DSCtsdXJqWHhmR29MelMvc0VETXowMWw3VmRTeFBaRnhXdUhCaXBhL3JHOGd1d25KblZYYy9yMGN5MlNob1Bsem9vY1Z4TWwxelNkQytPQ2x4dC9aYjdsRjBJZURUMURvKzJzUHlqYzJsREMzb3dHWnpnUmpQNVJKRUhqaXJ3dTI2RTRiOGdGcUJiSURTcTBTRCs4Nk1odFczcEN4Wm1VZENDVzU3UjNNWjNVbTVhS2czcmc9PSIsIm1hYyI6ImEzMzkyNTYyMTlkMjg0MmVlYjAxOWEzZDE5YzA4ZGMxZmMzOWE2ZTY4OGYwMDJhZjI0N2E2MTRhMmQ5YzA0ZTkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, FR, DE, KR, GB', '[{\"id\":\"8272e2e4-2de2-4708-b7ad-be59696cfbb7\",\"name\":\"Play Space Debris !\",\"payout\":0},{\"id\":\"e2c99d48-63bb-4032-af11-461159375be1\",\"name\":\"Reach 200 Meters\",\"payout\":0.004},{\"id\":\"c049df6b-e920-4844-83d3-8f4ca184f94d\",\"name\":\"Reach 800 Meters\",\"payout\":0.04},{\"id\":\"37f5996c-61d8-4bfe-bb01-86ac4dad244d\",\"name\":\"Reach 1,500 Meters\",\"payout\":0.36},{\"id\":\"70b97533-280c-4f2a-a3f4-47df72326371\",\"name\":\"Reach 5,000 Meters\",\"payout\":15.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(380, '672796-lZ2kToJFfVYWxuk6', 'Chaos Cruiser', '', NULL, 57.07, 'https://notik.me/api-redirect?token=eyJpdiI6InpQbkNFQkVrWW02bzAyU0RUU0FRQXc9PSIsInZhbHVlIjoiMkplaG5OR3dRMHQyRVFodHdQMG1hb2tuNTRlVHRIeTByUFVJQ2xHQVJyeEEvOW1ETWxNdDNPd3Bod0RzaFNqOTBBNWdCQWJzaUw5YzBuVE93b1VEZklIb2hGb245V2ZVWWwrTkt2UlZiYXRuVlhHYkUxVFk3VEhIblplTlVXNFNCRklwd2lnREpMajV3TS9TYVNmd3poTGlybXNES3hYcW0yMkd1aHNWUnlJU0ZZcFRIWTRkWk10cUZDVDVoYkovdzhpZHpGc3hlZmI0Z25zbmVYbTk1bFY5U2ZkZWRKSXdQVUVNOVhLVGI5Y2htYUVBYzhnbEN6Vkh3TElNMU9FYTZ6V0ovN3VybWUwSVVSQSthSkJ6SWJmUkRVU0szZXZRS2xaTE9qd0VJdTg9IiwibWFjIjoiZTkzMjcxZDA1ZjIzNThlZjA0OWY4N2RiYzNiYmJmYWFhZDNhY2Y5YzljZmFjNzhkNzdjNDUxNTQ0YjI0MWM3MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, JP, GB', '[{\"id\":\"4aa864fc-e090-47ed-ab2b-e044467912af\",\"name\":\"Play Chaos Cruiser!\",\"payout\":0},{\"id\":\"bebfa426-0f83-4d23-9b1d-9ae3f6bf86ea\",\"name\":\"Reach 100 meters of distance level\",\"payout\":0.012},{\"id\":\"89f1dbd5-89d1-4536-a240-ee9f646b595b\",\"name\":\"Reach 200 meters of distance level\",\"payout\":0.14},{\"id\":\"bb80132f-bcc4-4398-82ba-001ba7434d97\",\"name\":\"Reach 400 meters of distance level\",\"payout\":0.72},{\"id\":\"8a1088b5-cf49-420e-b4a6-635b7a320b9c\",\"name\":\"Reach 700 meters of distance level\",\"payout\":4.2},{\"id\":\"e4974438-9174-4315-8c34-7ee41d1a7bcc\",\"name\":\"Reach 1,000 meters of distance level\",\"payout\":21.6},{\"id\":\"f49b8add-0bde-45d6-b052-c7645773b5c2\",\"name\":\"Reach 2,000 meters of distance level\",\"payout\":30.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(381, '672798-lZ2kToJFfVYWxuk6', 'Chaos Cruiser', '', NULL, 17.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImVNTktEVi9UVWUvdlVodWZhZnpuVGc9PSIsInZhbHVlIjoiQnBDdFdoc1NIbm5DKzhjOWNlSGdWaTJQVnYwRGg5a3JOZmtQVTY2WlMwUS9pQytva25ybnVNdlRCa3pQWU1IQ3J4L0dPdXRvWU43S1VpbWVuVGJNWXlSK1hRQ0ZYY0xzTmI4ck55NExMTGxQZk1CZzA1Y050cUF4elhLcEYyZHlxSExkNUtqL1EvRnZ5dVJjMFR4SmwzbllpSUVvcVlyV2hadTdaL2pGUHI5ZmVucFBNQ2Q3ZkRtQlZJWWZtK2Z0MFVkWGkySFYzZDR4QURhYVQzb21Kc3MxRHBvZk5FcTJJZlE2ckxaaVMyaUdiYnFCVmFDTGorbTFiTWJaSm1LVGtZK3M5cDM3TS9MYVBFYkl3TjlHVWc9PSIsIm1hYyI6Ijk3ZDUzNGZhMmQxZDY1ODQxYzQ0NjAzMmM4MWFkY2EyMTNjMzYwMDMwYjdkOWI3NzVkMTc2ZGM1NDY5YTQzYTMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, AU, AT, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, FI, FR, GT, HN, IT, MX, NZ, NI, PA, PY, PE, PR, ES, AE, UY, VE', '[{\"id\":\"45daee80-af1f-4bc1-9518-b1d541560f14\",\"name\":\"Play Chaos Cruiser!\",\"payout\":0},{\"id\":\"53fd96e0-a735-4f80-ae7f-afc3b5c9e814\",\"name\":\"Reach 100 meters of distance level\",\"payout\":0.004},{\"id\":\"9b3c6db2-b906-4bd3-bf91-b9fe73c1da38\",\"name\":\"Reach 200 meters of distance level\",\"payout\":0.08},{\"id\":\"111c469e-5f1f-43e0-a470-fb651da0cc18\",\"name\":\"Reach 400 meters of distance level\",\"payout\":0.16},{\"id\":\"017cacc5-795e-473f-bc48-4f2e04ebf2de\",\"name\":\"Reach 700 meters of distance level\",\"payout\":1.36},{\"id\":\"2acfe956-c602-4b40-8f32-719f4027b1d8\",\"name\":\"Reach 1,000 meters of distance level\",\"payout\":5.4},{\"id\":\"33b2d667-47b0-4f2a-a8ce-e16eb59b9e9c\",\"name\":\"Reach 2,000 meters of distance level\",\"payout\":10.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(382, '672906-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 6.59, 'https://notik.me/api-redirect?token=eyJpdiI6IlhrY2p3VGN0NXpOL1pyejVTVDBMYVE9PSIsInZhbHVlIjoic1ZoWkdJQWtqQmFwN0xLYVFqeEJLbDRxcjhGYlFHbVhXUTM2QlRXUGpyNDErc1JhSkdpS0tsTElacGNSblhISGxCVmRYMndJMng1cVhuNkVFYmtoWEtRQlU5VXlVRWdaVmRMQkpFZGdIeld1QTViZVFZUVh3L2hRNGtXclM2WEJtbFplQ0pKeUl2TmFUdlk2T2ZFenZacXZNNkRsY0M2Z0trT1pCK05lTVZMa2N2cXFHZEdSN2QwV3lzdy9VR3NDekRUSm1OODVLa2ZxTllZWEhLWEhtd0Nwb3poaUJpczVXRE9CTCtqTG9kV25kR200clJQSjNoN25MZURGZW03eFY0YUtVSnl2Q1VMcDM5RDFlNFlVT0h4Q1lTRkZOc2JlTFdEa1Brck1YcDA9IiwibWFjIjoiNTkzNTYyYzUxZGM4NTUwNzQwZTM1NjkyZWI1ZGUyNTI2MGMyZDk0ODk2YjRiZjIyNjQxM2EwN2JmYzM4Y2U1ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, KR', '[{\"id\":\"7ca0e7d6-962f-4c32-ab58-c0bfce84423e\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"70a9ec18-553d-4b3d-9031-1b743a22d8fe\",\"name\":\"Reach Level 50\",\"payout\":0.28},{\"id\":\"c7f83ad1-a365-4d76-879f-0461b2e02cda\",\"name\":\"Reach Level 100\",\"payout\":0.34},{\"id\":\"b092521f-724b-4a6e-a83e-2b19b9cfabb5\",\"name\":\"Reach Level 250\",\"payout\":0.888},{\"id\":\"7c605433-03e9-477c-8f93-9585c2e72329\",\"name\":\"Reach Level 500\",\"payout\":1.68},{\"id\":\"b69cb2b2-af98-4539-bb08-30beb4176c74\",\"name\":\"Reach Level 1,000\",\"payout\":3.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(383, '672908-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 5.54, 'https://notik.me/api-redirect?token=eyJpdiI6IkEzZDlRd3BqRXpNYkEySTIyMlpqR3c9PSIsInZhbHVlIjoieEVkdTlUNmYwYUNBQjM4cG5iVkpuRnFmNTI0MXhHU0I1anpva1RjWW9ZS0lUS2FYNEd0Q1lvVEtqejNycTVPOXJxNFdYWFZnc3dtaEVrb1F4QlluellaQUZFQTd3cy9uM2p2VDF4YnNoaTA4Q1RjVmRiZDJUM294UEF6VHRrR01tajdLV0NaSXdyV2VaejdwUU8vc1lETWdKb0pwZEFXTm93U01BWXRUSTRmcXdQNDE1S3JwNnZtclB3MGVFQXhScDZGZ3ozUEtBYjZxWWt4Q1AvWGFBUTF2bkppQTk5bWV2amdXQ01rMVE3RTIyT1pyUVF1TTNSVzZPMVlTTmlrdGdVbHQ3N0VnZi9tU05qWktJMTVIM0pJNEVGRTJkakJURkgvVXY5K3lxdTA9IiwibWFjIjoiMzMzNDFjNjRiZGEzOWM1NjdkNTNmZWU1MGZkN2NiZmMwYjgyZjJmMzQ3ODFjNzRjODY5MWRhNTIyMTViNDhlZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"e72cdd53-3409-4e89-9475-9d7cc86cecd8\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"2960385c-ac51-4bba-81be-5de3f6f726de\",\"name\":\"Reach Level 50\",\"payout\":0.224},{\"id\":\"ce4d24ef-069a-444b-b3b8-f317331705e8\",\"name\":\"Reach Level 100\",\"payout\":0.28},{\"id\":\"8e7b4ac2-33d6-45a5-b2d4-1a7a6b4a8858\",\"name\":\"Reach Level 250\",\"payout\":0.84},{\"id\":\"fcc13e78-07c6-41c0-8565-4255fcdd358d\",\"name\":\"Reach Level 500\",\"payout\":1.4},{\"id\":\"e7e55629-9e1e-4453-af5e-f434c71187f4\",\"name\":\"Reach Level 1,000\",\"payout\":2.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(384, '672911-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 3.65, 'https://notik.me/api-redirect?token=eyJpdiI6IkM1VGVRdjJJbWlzTGR0MHpDQSs0blE9PSIsInZhbHVlIjoiNXBxTXpTYjUvRmRxZmpiNVdNSnBjTC96clBDUll1cFlOYkFqbWE5ZEVqMUdRYVRZeFQ3MlRaelRiYlJpaGxqVXdBck5CdkJncmQyVG1yeS9PY0xhYWdZQ3EwR2J2eFQ2bFVMRTV6dFNDejNxVTJtQmhZMkkycGV3cFdSbjNjSVJKTDVBQ2kzc1dnSThkWkxCUzRBMGVVZGRjMCsvak1tbG5EU1czcWxRNlduTVUvNE9zanZEd0xYa2xqZWhVbkVFMk9DcVk5K2piQk0wT3pTbTg4NkZ4VE9wQ1VackFqN1hzRXRHVXcwMnNTemh5dWgyRCtxQWxUbzg3SjRZbVA0d1F1QnN2a1JTU0NmSVBrTVMyWmZRWFJOanpNREhXcElEejNCMFJ0K0lMbWs9IiwibWFjIjoiMjMwZmRhZTJlOTAwNWMwMmY4YTNlNDllMmU5NjA3OGQyYjI1ODE4ZTUwZWIxMTVjM2I0ODRjY2U1YzdjZDU5MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"370d7ad8-33fc-4c46-9ceb-212baf6481bf\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"c9b85bc2-1461-4894-86cb-cfd28d4f54d2\",\"name\":\"Reach Level 50\",\"payout\":0.152},{\"id\":\"0524d7aa-794b-48cf-9194-1850a5d36b8a\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"00b13cb2-6e3b-478a-b117-b2b094f967c6\",\"name\":\"Reach Level 250\",\"payout\":0.48},{\"id\":\"8f077230-73c6-4e83-ac74-6694013c8980\",\"name\":\"Reach Level 500\",\"payout\":0.888},{\"id\":\"2ba5ca7c-dacf-4e84-9295-72641524a4b8\",\"name\":\"Reach Level 1,000\",\"payout\":1.96}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(385, '672914-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 0.53, 'https://notik.me/api-redirect?token=eyJpdiI6IlM5NmdLZU05RlZHajg1V2pMQm1TcEE9PSIsInZhbHVlIjoiR2RUb2M4YTZhMDhEMElMZHhDa21DN29MWFZ3RG8wcUpyeW5Qbk1BQ2FpbVNSMytQZDhvSGx1TGkyMlZwQkEzSndha0JJYnZhL0g5RWswL2Zja2ppeXFGSkRmbUZyQkk5b21LYjBPaURQMzdhampYeXh2RXN0cndZZ0xJQ2RzSzVjVnZhbDlFMGVDNTdyM0hvdTdDTmhCZmhIVlZkUDB1aVFzSFZGaGp4VkIxUTByM282MXdQM2lqVWxqdUMvNlduTUJGMjRvK052SEdiYVBMUWJZc2c0TEw2SWNnRHJaWXAzWDQwdnI3a2pmTFphdXhiWXk4SFl2cFRDa1p3dyttTFlhSGNsN1hpZVU5U3FUdVYzRTZkbzZLZ1B0ZHQxNzlxS0VmMHN6WjQxYkk9IiwibWFjIjoiZmFhOGVkMGJmZmU5NDYyZmQ3NDgxOTMzOGEzMWE1N2UyMWI2ZDEwYmU4ZjQzOWY4YTE5MzNmMjI1YmJkZGM1NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EG, PH, TR, UA, VN', '[{\"id\":\"02acba91-a88d-42a5-b1ca-9318672d386a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"00c74cae-d9fc-4f91-b149-d3be3d38e8be\",\"name\":\"Reach Level 100\",\"payout\":0.04},{\"id\":\"19add6a6-0642-4815-b028-6c60366c4286\",\"name\":\"Reach Level 250\",\"payout\":0.072},{\"id\":\"3e1a7127-27b2-42d2-af7d-1d9b4be64d51\",\"name\":\"Reach Level 500\",\"payout\":0.14},{\"id\":\"1fd64513-bfd3-4d01-9eac-7e10c9fff375\",\"name\":\"Reach Level 1,000\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(386, '672915-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 0.54, 'https://notik.me/api-redirect?token=eyJpdiI6InNiZkI2S2wrUUR6cDBaV1hFcThjNlE9PSIsInZhbHVlIjoiSjRienprMCtUb0lqLzNoUWZ4MGFSTG00K1NrOWZnbGdvZGdXaHRHWFdyU2VoYTZ6YjdSaW5EbytsK01ENWI3YkxxeEZTZDhtcDNjUkRZNkRzanRSYnVqZTlCR2U1bi8zaWpXR21ZYk9VaGJlYllEUXJnbEQ2S0ViY0x6Tkd6OVlnSzFrMkR3M1ljYUYwSnkrR1hyUy9kb2FpbmFHb1ZNUEY2ZlVoS2dJR2hXODJSdHdXOGozVlltMGZDay9JT3RlVDBFa2NBSXJQZzBZMEYyM2xXeWlVa3BEU2g3UGVJYlpQZ0d2T0lTMnhmNXEybURCbHZ4OTdjNVpxMndSc0o5WmlBbnVMMTAwdlJLdnFYcVNZOFFOaTFZMzRTLzJJcjFJdVVuR2ZkMzFTdkk9IiwibWFjIjoiZDg5NTk5ODQwN2Q5MTUwNTZlZDMxMWVlMDE1ZWFlMDBkNzU3MjRiNGE4ZWRhOGM5YTY3MDFkODBlYzJlZDc3MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"5a48db76-5bed-4cd6-96d6-855c4b7b495b\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"d00911d9-6683-424c-b957-c0319807e171\",\"name\":\"Reach Level 100\",\"payout\":0.028},{\"id\":\"623b0258-3032-4bcb-88ed-b4c6fbcd02dc\",\"name\":\"Reach Level 250\",\"payout\":0.068},{\"id\":\"db1e9714-75a8-47ce-9442-2bd72428c08a\",\"name\":\"Reach Level 500\",\"payout\":0.14},{\"id\":\"313c0617-060b-4a42-88f6-d4a68d9161d9\",\"name\":\"Reach Level 1,000\",\"payout\":0.3}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(387, '672962-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 56.84, 'https://notik.me/api-redirect?token=eyJpdiI6IlRTMkZzaTNiUU9MNTg0Q25EbXBpTGc9PSIsInZhbHVlIjoiMUVIS3BnVFlqTk00Ly8rejU2dStLR3JOWW1va0xiZ2k1Uk9qMDBIT2J4ZHNsWXhKUndWUU1NbGVMc0VUWDN0UFJWNEJoUTlEd1VzUmVZTkZLSUk0RGprbTdzQzhiWXZpOXV2bkNiNTlhWUl0UzdPUGNzUEJlZ2F1aU9QelRPL3Z4b05jMmU0MmQxL29KMG5UL1pKbnpZbVoxaU9CejhiS1FRcjU5Ujh4NlhFR0JRVno2QTFVNGxPQi9TaUo4TERZYjNMVy9UTHpvS3lodUdvTmszUThjN0VDczBWOEt0R3MrbWtOUHhYTkRDKzFRZnhQeUN4cnFQSDg3RnIxNnovT1ZkOU9ZZmxUWVQ0TEEydHpMNmh6SFE9PSIsIm1hYyI6IjNhMjA4MDBkNzE2YzRhY2NiOGU1YmQzY2ZiMjA0OWQzOTY1M2QwZjgzMjNhMWJlOTAwYzQ4ZTJhM2Q0YjMzMTQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"6cc276b8-954f-4dc2-bc70-5fa9629d1b37\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"0a2f8c46-43e2-44eb-ba3c-5c2d43fbd5fe\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"c2a62686-5ab5-4618-b977-393fe72d10ff\",\"name\":\"Reach 500 Meters\",\"payout\":0.04},{\"id\":\"711d8ecc-e334-445b-b40d-8dbf1bbf5662\",\"name\":\"Reach 1,000 Meters\",\"payout\":11.6},{\"id\":\"1749fea1-5a0b-42d0-8fa7-5da61473e16c\",\"name\":\"Reach 2,000 Meters\",\"payout\":15.2},{\"id\":\"5d2f5e0f-dafc-4319-a4e2-0ae3b125793e\",\"name\":\"Reach 5,000 Meters\",\"payout\":30}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(388, '672963-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 53.30, 'https://notik.me/api-redirect?token=eyJpdiI6IlZjbzltdW1hTXFiZ0pDeklHRk9Sa3c9PSIsInZhbHVlIjoiT1VWQ3BCMDZ4cTdWR2NyS0NpMEtmc1R5YVBReTRPSGxWK2w5ZE5KTEdRaUV3ajF3REpzazNpODRxRXN1Y2Q3SEtLWGNIUytiV1pucitFeVdVVUJCQnVQOGdMV0tDc1hBb01nVkNhRUpJZFhrMWhDMStsVlFqcmFSUGNKVFhJb2ZhTy9tVkY1M0xBa3VncThlSDg3UkhMOG9lTUovcXpZU3ZZWG9DREUwMmZKZ09oSktSdXkyQTJlbDdzZWJzYll6a0prZm9yQjBhK01OdGpzekNYRk1KeXIrWmtoN3dSWmZLbWduTHR5L05YMU1nWjZYNTBZdEQ3a3JLbWlaWUFxU0tKeWtjRnJaUUdPOTE4NWVXZ1g3L3c9PSIsIm1hYyI6IjI2YTk1OGQ1NmUwNWE3MzA1YTVkN2Q2YzE5Mjk0NGQ2MWM0MGM4YzNkN2FhNDU5NzM1ZDc5NzE5ZTgwZTE1NzMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"0b39ce60-625f-4c14-8bda-42006ad50867\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"66098108-d617-4a4a-86c1-eb4b1cca7ff0\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"e1928fe6-c044-4b59-9f34-6b31da5227d4\",\"name\":\"Reach 500 Meters\",\"payout\":0.1},{\"id\":\"dc058b34-ddd8-47f9-b2fa-a1a0173d78f4\",\"name\":\"Reach 1,000 Meters\",\"payout\":10},{\"id\":\"d2710021-0733-4875-aa3f-3f48f5b09b58\",\"name\":\"Reach 2,000 Meters\",\"payout\":13.2},{\"id\":\"31a38e83-a11a-4c9f-b161-8b4875dbd1a9\",\"name\":\"Reach 5,000 Meters\",\"payout\":30}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(389, '672964-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 25.22, 'https://notik.me/api-redirect?token=eyJpdiI6IjNPZG9XQ0U1N0ROTmlCVW5QdnA2MHc9PSIsInZhbHVlIjoiWE9HRWR4Qi9mbWlEZlNnU01TR0dBZXpldHk0eDVjK3F1cC9UWTZkTEhoMWNybVJZL2NyL3lZbjgzUSt5VVBFSzBZdHpnZFl3TytYaHdMVS80QVhwWXdOLzhidXpBK3pJRXhMY283azYvaVRmbHc4MHZrZUJvVXhINm95SDZrVTQyWGtrQVhZMEl0T3M4bU83VUJ2NmNMdU9HTmFWQzNrRzBlbVVSRElLUjRmRkRVa2JoN2dNWnpzOG15eCtpSC8rNlZBOE5OamVtc1FYZUtYYW11TXI1NHRLVkFacDJBd3FoZ3AwQkRwRHBkV1N2WkdOc3RTdVFpbUFhQUVMVTNEbStXVmZuVjEyUmpHZ0VlZDViY1RkbVE9PSIsIm1hYyI6IjllNzAzM2FkYTM2NzNjNzUzZjg5MWNiNmEyMmVlZDIzMjExZDhhNjNiZGMxOTM4NTY5ZTkyZDcxZmYwZDgyOWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MY, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"d174490c-3532-4a1c-a13e-2757bbd7506e\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"d23d8d4d-1436-4b2b-b0b7-fe2101ca62e9\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"2b19bdd6-7121-4acd-89d8-414b994b16b5\",\"name\":\"Reach 500 Meters\",\"payout\":0.02},{\"id\":\"0b0373c0-0159-4bb4-a0af-8c5a131ac650\",\"name\":\"Reach 1,000 Meters\",\"payout\":2.8},{\"id\":\"a8faa4d0-895c-43e1-a68f-230377c987a9\",\"name\":\"Reach 2,000 Meters\",\"payout\":4},{\"id\":\"292f5f7a-3ba9-4e22-8578-932bf440278a\",\"name\":\"Reach 5,000 Meters\",\"payout\":18.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(390, '672969-lZ2kToJFfVYWxuk6', 'Wild Fish', '', NULL, 24.42, 'https://notik.me/api-redirect?token=eyJpdiI6Imp2QlA1L243MFVSUXBPQzJYczFVWWc9PSIsInZhbHVlIjoiVGdvQmdibDVhaFRScG1VRFo1cjFuQlUyNDRlVjdVS2U2UC9YSlQwU1djUXZqa0NNYkY4TUVTa1pBdGZaZVBwUWcwNGtLa0hhUkFPa3dzYi9OMHFXVjhJcyt1YUNWQ1pIOUVJQU5UL3RRbnNmVVBOaVFqZTc2ZU1Ba3M0UFB6STNrNjhTaldsZmxtdzBSV0l6bmtXVmxSbkxsSkdCaFhoMjM5dmR5ejFGd1F4T0U0QXprNlhCYno2SG9KZkJld0xJeEFhekR3dk4zb2MyZTlzR2lrbTU2aFlueUZLNGJUdFlqY3AyTTFNWkVYS3EvcUtsajNPWEF3bG9jcm5hcGRlTmIzTk1STTZNRjcrL0szV29Yc09FV0E9PSIsIm1hYyI6ImQ0ZWYwZWEwNzc4YzlhNDU4MjgwYWIwMzc4MzQzMjUyZDllNThkYWQ2YjIxNTZkMzdmZDEzNzY5MDIzNjNjZjMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MY, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"79ea1063-f8c8-4ca6-8a69-e1e2957db455\",\"name\":\"Play Wild Fish !\",\"payout\":0},{\"id\":\"9160ade2-b2cf-4b59-b1af-218b105a0705\",\"name\":\"Reach 100 Meters!\",\"payout\":0.004},{\"id\":\"1b2e1d7f-611b-4082-8f71-00ed280f37ac\",\"name\":\"Reach 200 Meters!\",\"payout\":0.02},{\"id\":\"f9cdc3f2-4746-431f-bf8b-01f3fe79bcb0\",\"name\":\"Reach 400 Meters!\",\"payout\":0.4},{\"id\":\"3b13bdc2-559a-45df-ac9b-b140d302e9a4\",\"name\":\"Reach 1,200 Meters!\",\"payout\":1},{\"id\":\"d3a8b085-0425-4856-99c4-77aae8db67be\",\"name\":\"Reach 5,000 Meters!\",\"payout\":4},{\"id\":\"0aedf32c-b0e1-4d50-b823-76671f908290\",\"name\":\"Reach 10,000 Meters!\",\"payout\":19}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(391, '674063-lZ2kToJFfVYWxuk6', 'Egg Catcher', '', NULL, 8.66, 'https://notik.me/api-redirect?token=eyJpdiI6ImYxd2hWdFJ1dmtiMERwY1Q2N294TFE9PSIsInZhbHVlIjoiT1RSK2VhSHVlQndIODd4SVJUMnhERXZsYXFaS2VZcGt0ZHJpdHZkSHRLbnhrcUhRQWZaTWdxSWppcDErdHowd1dGT2owLytZRXBYRE9vUGZKcHF6YytoeEVoMlVwc2gxbThkYTN4SjBiNHRpK2tKTHMrbkRyMDk3VkhXMVFwRlBLdlpPUXlnemQ3cld5WksreW9MRW5qU2xMaFMyZnpScjBLS0VWNkhQTmdkL0d1NkxFWGt1UUNmeUNhbXI2ZDRidk1kMVp4TTJYS1U1cFFQSzlDYU51ZnhiTnFIV211d3VtZUM1ODd3ZTk3dU80emN6NjZ0TGg4a3crMlFhdFMxb3A1bVd5QVgwa1BvbmlGL0Y4dmw4dHc9PSIsIm1hYyI6IjkzMzZmY2FjNWQxOTFjNWJmOTUyZTc2NDUxMjQ2YmY3NDc2ZmJmODljNmRmYjU0MzlkNjk3OTc4NTIyY2UwYmEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MY, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"43769165-d0e0-4ac0-ae48-7e3ce35dd8da\",\"name\":\"Play Egg Catcher!\",\"payout\":0},{\"id\":\"e0079f29-6e4b-4493-9580-a9fd06d7d879\",\"name\":\"Reach Level 20\",\"payout\":0.004},{\"id\":\"609298cb-c6aa-43d4-852d-a36d9c0bfbe8\",\"name\":\"Reach Level 30\",\"payout\":0.004},{\"id\":\"6f35e03e-718e-47fc-ab15-34dd0e03834a\",\"name\":\"Reach Level 50\",\"payout\":0.012},{\"id\":\"b50ce298-5cf5-4981-852a-fc544a705b00\",\"name\":\"Reach Level 100\",\"payout\":0.24},{\"id\":\"5ae6e77a-daaf-4fc6-a8ec-f601319499b7\",\"name\":\"Reach Level 500\",\"payout\":8.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(392, '674761-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 234.66, 'https://notik.me/api-redirect?token=eyJpdiI6Im44NVo4cXZOWnRjVHpMdi9wNEE4dUE9PSIsInZhbHVlIjoiQzUyVzl0TXVNUHdRM01Rb2dDd3lwN3FzRmI3cWc5bTlDUUc1TEVKTVBHWXJxVHNRZmJqb043N3FoYXMyUC8wVG5aWWpjd29hckhodU94Z2VoS0VtRXdWWVBjbElkbE8za0dCNnBoSU5Cc0NCNWFSMDdNLzR2c1IraWN5WlRBVzhWaU1mbE1SWGdCWUtQOUp4SUVldHgwYTRjeU1ZTk14VFQ2ZVFaMTdyTFlSMlpMREpROXI2OVFBOE83YXRsL0xXMkVnM2JjKzZaRWN5dmNTOU1ETzZFUXprTDNPL3lZTUJaek5EYVR1SWp2Y3dBbDhYZnRKeUprSWhtenVES3BuREwyRzV5OC9JZGpiNlh0emh5N3I4RFE9PSIsIm1hYyI6IjhhZDAyOWM2ZTc0NTBjYjUxMWVkMDhkNzgyZjBjYTMzNzk5M2RlM2UwYThlZDgzOTI3NTdkMDgxZjEyOTc3NWMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"959248c3-4f8e-4c80-8afa-cea113635e26\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"baacc74f-53c8-464a-bab5-3b65e2c0491d\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"2fe39e1b-de78-4adc-bd32-5ed20f091e63\",\"name\":\"Reach 300 Meters\",\"payout\":0.06},{\"id\":\"3f2e3100-58f6-4e70-8b82-2657824bb94d\",\"name\":\"Reach 550 Meters\",\"payout\":0.4},{\"id\":\"e23d1dbc-30f6-4e45-94cd-7baaee377b79\",\"name\":\"Reach 700 Meters\",\"payout\":2.2},{\"id\":\"0b05fce3-164c-48f8-80f5-e55411534f0b\",\"name\":\"Reach 900 Meters\",\"payout\":10},{\"id\":\"3b9ae3ed-d8da-4405-aa36-c237736bbbbb\",\"name\":\"Reach 1,000 Meters\",\"payout\":22},{\"id\":\"3f22eb54-e9b7-4b26-8982-94173e1fb953\",\"name\":\"Reach 2,000 Meters\",\"payout\":40},{\"id\":\"621d89ce-fced-4490-a20f-40c25e91b7e4\",\"name\":\"Reach 5,000 Meters\",\"payout\":160}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(393, '674762-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 190.68, 'https://notik.me/api-redirect?token=eyJpdiI6Ikd4dDZRNDRycS9FRUEwR3dGNytWTVE9PSIsInZhbHVlIjoiR09Qc0djU0VJV3VMRDQzdUpvUGUrWVUwd3BDUnYxbzFMbVJsV0ZGWWpwaVQ3TE5JbzhNWTFjT0owZjBkMG5KK0paOGtpVDBjV0NRRGVoYTdtQUtTaExpRmR0NXl5bSs2Q1l6dFlnZVlmVVdnY2tUOVFhMnJtNXM1SVBFM2pUYU9EYTMzWnNDU0pjbks0bFR6NVhDMUxQMmtvSkgrbTZsMmxEaUROcDdHSFRSK3JTakJ4ZmZtZEhEZ0JRdFFnR09hNzZQZEY5RkplYS9RUmhxTnBYTk04OUh5SGtaRW90K0hMQ1lVSDdTOFJZdVpFQ1FSNDdhS2NLRkJnMWlEMkROeDlsc0xUZThUUHhNY1JBZXBETnc5R0E9PSIsIm1hYyI6ImM1ZTZlZDU5Y2UwZDIyNmJkN2RiNmJmZjU1MjcwNjY5ZmMzNDU1NDkwYjBhNzhiNTE0NWJiNjIyZGEzZTkyZTIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, IT, NL, NZ, SG, ES, CH, AE', '[{\"id\":\"9414b369-0f50-45e7-a814-a5266bbff1be\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"a9fe3ccb-6d9b-4999-afd8-f3b73122d06c\",\"name\":\"Reach 100 Meters\",\"payout\":0.02},{\"id\":\"9a216e6b-daa2-4146-9d00-a7c5c3589c94\",\"name\":\"Reach 300 Meters\",\"payout\":0.06},{\"id\":\"6b1be7bf-b6a3-4989-9b8d-e96f1e079587\",\"name\":\"Reach 550 Meters\",\"payout\":0.2},{\"id\":\"2bd94023-1684-4a5b-9f71-6620141ee698\",\"name\":\"Reach 700 Meters\",\"payout\":1.4},{\"id\":\"79dd299f-19c3-4b31-9dd7-4dafed356679\",\"name\":\"Reach 900 Meters\",\"payout\":9},{\"id\":\"5033fe8f-6c3c-4966-8c83-580b480babd7\",\"name\":\"Reach 1,000 Meters\",\"payout\":20},{\"id\":\"efb61ae3-9c12-411a-852d-25e5c4ca21d1\",\"name\":\"Reach 2,000 Meters\",\"payout\":40},{\"id\":\"df9b6999-df95-48e6-8a45-3e1d7fb0f036\",\"name\":\"Reach 5,000 Meters\",\"payout\":120}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05');
INSERT INTO `offers` VALUES
(394, '674763-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 149.31, 'https://notik.me/api-redirect?token=eyJpdiI6IkpURlVodFQ1SUZUdXE0aFZyVExpbVE9PSIsInZhbHVlIjoiTEd2T2VhOWU4b3ErSzZhTnhBTSt4UHIvN2hMWDQvZE9VRk9uNlFwcDdOT0RVZUxVMElnV1hpN01PTEQwNGVnYlQvUHZqVnFWc29KNkkyN3J2YVRqS0dUL2dGN1lKOVRuVG9iUnNHeDgzaDZmSHpFdkpOaURCVUJCdDZwUFRMS05sMnNNVjRZclQvQkZCQ21YOUUvTE1uajl0dWI2WmIzN1VrR1R5N3lQWXlHbFZqL3d4L1ljdlk1dHJwbmNuQ1dkcjhMRUI3cVphcStDQ0VXZU5QeWZkZXAwcGptU09yZkJOQ0V2OFg3MFJhaENTNmVRSSs0Nm9wSE10bUJrR0x3RkRvbDUza2lKQVBBMStleURUVU1Bc1J4ZDlpUE9CdCt4cGZlb1hJYndqV2M9IiwibWFjIjoiMDQyMjAxMTY3YmY2ZmYxZmU5MmMyMzVlZmYzYTA1YzNlNDliNDYyYjhiZGRiZTNmOGY2N2RjMTIyYmEzNzU3ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DO, EC, SV, GT, HN, MX, NI, PA, PY, PE, PH, PR, TR, UY, VE', '[{\"id\":\"1599dea2-d5ec-4848-96f3-5776515e537f\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"e790cfa9-f7d3-47f1-b340-0d3fdbb99d58\",\"name\":\"Reach 100 Meters\",\"payout\":0.012},{\"id\":\"da182e75-da1f-4358-a99b-994c6af75091\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"e6a07d61-6431-4fff-9abf-97c396745b78\",\"name\":\"Reach 550 Meters\",\"payout\":0.08},{\"id\":\"f077c73e-6a1d-469f-a013-26a31433f4bb\",\"name\":\"Reach 700 Meters\",\"payout\":1.2},{\"id\":\"84facee6-8fe2-4d1b-8a66-7835390df034\",\"name\":\"Reach 900 Meters\",\"payout\":6},{\"id\":\"4745ec2f-04a8-44ef-a555-112481e0cf27\",\"name\":\"Reach 1,000 Meters\",\"payout\":14},{\"id\":\"3d0ca1e7-2d40-4e40-b0af-46fa33ed6c71\",\"name\":\"Reach 2,000 Meters\",\"payout\":28},{\"id\":\"3f551e38-ea11-4728-bcb7-4fdd5a6b5e5d\",\"name\":\"Reach 5,000 Meters\",\"payout\":100}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(395, '674834-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 1.04, 'https://notik.me/api-redirect?token=eyJpdiI6IlpGWXV5RTd2dzJwNDdWWkFCTkl6WUE9PSIsInZhbHVlIjoicmt2dXJ2ekdMUDcvUjFISkg0VkFVemI3ODB5Mll0Q0NiQ3R2STFkK2pPd2NwV1MvTmVhR3FFTm1ndE0rK1habkNKc3JYWkJsM0tCZ09SbStWQVNSR0NHU2tqbkd4VUZ2REo2Qlk3MURkeHNkMDdJSWczeCtTMnljQVpaMVR2aEgxSFpObHIwam5DYTN5bkNHb09VRWVwellFRXZ4QUVIUHdZUUE1S0IwcTRCdk82YTZUOEdVbng4Y1NXNCtvazZXanVqMlJmYU9CT21va0Y4ZWt1YkRnd1A0bzJxOUd2NEJQdHoxUFEwcCsxYUNLMk9naDhYbENyNjA1VXdJS3pXZnBEakFBZWFBMTdKbzIzbnFMQ1pXWUJNOEFnTVIxajVxaEN5YlU1WXljVmc9IiwibWFjIjoiMzIzODZjYzM4OWEyMGVhYTQyNjlmN2Y0MDEzZGY0NjMxZjAyMjkxMDI4OTBlMzhlYzRjMjA2MGIyNGFmZmI2OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"9b0d8c84-6141-43c0-aedb-612cef9d17a8\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"85294517-a220-47b7-b973-c0e963f435a1\",\"name\":\"Complete Level 100\",\"payout\":0.016},{\"id\":\"b3f55095-a549-4d4e-941f-37eb4080833a\",\"name\":\"Complete Level 250\",\"payout\":0.04},{\"id\":\"48062f93-5282-4eca-83a1-de94dd639c2f\",\"name\":\"Complete Level 500\",\"payout\":0.14},{\"id\":\"aa3bec56-a5aa-400c-bc46-2bf5a21edbce\",\"name\":\"Complete Level 1000\",\"payout\":0.28},{\"id\":\"1f71f84a-86bd-426d-b6ce-929b2e20695c\",\"name\":\"Complete Level 2000\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(396, '675363-lZ2kToJFfVYWxuk6', '2248: Number Puzzle Game', '', NULL, 8.36, 'https://notik.me/api-redirect?token=eyJpdiI6IjR4bzJhWDBKcU9ETkxmd2NoNlJSRmc9PSIsInZhbHVlIjoiMitweDJ4ZEtpTk5aZ3ZDSlFFNmVFeDIzYjdqaWRrYnlad3ViR1BBOHhYYVdPb3A4U0NzcVJGak9XcnRZaG81N1hJQ1dhVDJkRWlaNU1FMFd2VUM1SEI1S2I5WmFEZGNXS3hBaUR1NWRPZHIwSDBhMDVDY0RZWHBORXp3bUtvZDhaMmc1eVVJV2hBb2Nyd1k5SGJnZjZMNS9XSGZaTjBYUklBVXZCVUkyVk1kMGlFVzZPbGJ3Z3kxbnlhaEZyNFJqdmtqcEswcTJFcWJZK1pmWHVrbk85VS9NUVNjRHJXTnphRngweTk2Z0d0L205YlpKd2dXRTUyVjdocmFlLzljUm9NQnlWRDRnVkk4S2Z5VVpveWZKWnA3RXN5TjdacjhObmR1ZUJGaXJvR1U9IiwibWFjIjoiZDViNzczZjMwNzA2ODA4NzllYjNiYzhiYzllZDBmNGJhY2MyOWU4MTg1ZGQ2ZTI2YTlkYmM5ZmQxMzZlOGRiOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, SG', '[{\"id\":\"9c1ac1bf-b531-442b-9b09-04f9ac9fe8e3\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"2d7aeeb2-fb41-4fe9-9ecc-ddb0db2908a5\",\"name\":\"Reach Step 25\",\"payout\":0.208},{\"id\":\"1f20322c-35ee-4614-a16d-391e5acd3499\",\"name\":\"Reach Step 50\",\"payout\":0.42},{\"id\":\"0e790026-c1e8-4438-9089-b787ff9d737f\",\"name\":\"Reach Step 100\",\"payout\":0.888},{\"id\":\"c97b4d9c-a39a-45dc-a1d1-d1d33c052ab1\",\"name\":\"Reach Step 200\",\"payout\":1.988},{\"id\":\"db66572e-d43f-48f8-95e4-72b1739b6141\",\"name\":\"Reach Step 400\",\"payout\":4.856}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(397, '677662-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.78, 'https://notik.me/api-redirect?token=eyJpdiI6ImRPRUlpRVNXVjdCbGhTV3FnQitkTHc9PSIsInZhbHVlIjoiektXWTNIcGFPSUs2NUxoL0srZ0NQUEFtRjdvZTJsMEhkZTJBUDRLQ1FSWWtNbDhqTkl0ZVRSc3FybDRSbUVWNklGL2F4U2EyWUM4Yit2TGZXYnhtdFFnM3g0eTNVcm53VDF0VEVTVGh1anUyM0lMNC9DR0Y4cnZjZFJJU3h6NnlZbGJaQzlqNnpDWFBNNEhQZ2c2STlTZXdOelRQVzlkekJRMFZ6Q2ZWRkJZdjlaQklITU00aDRjaG9ad0FYQzE0TFlmZWxlYUNxb3VuV2Z3VjBZd2dBK1QzeFF4TmVaejJaR1R3SVJwQzVyQVo4SDlGbE9VbjBzS25DN05IRUN1bDg2WXBmdEd0Vi9VRm5HOWFJTDRML0hIQzJQaDZNSEFCdlFsak5MdWVXWFU9IiwibWFjIjoiYjA1ZWZiNWYzYzI0MmRhNTFhNjJjMjBjODdiZTFjMjBmNjdhMjNkZTRmZGNlNjFhNTA0Y2UwNDZiNTE1ZDUzMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, KR', '[{\"id\":\"b76dd6f6-0df7-474c-896a-afdd9dcf9785\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ebea06f8-33e4-43c4-875a-2fa0711aa671\",\"name\":\"Reach Level 100\",\"payout\":0.78}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(398, '696489-lZ2kToJFfVYWxuk6', 'Blast Friends: Match 3 Puzzle', '', NULL, 1.00, 'https://notik.me/api-redirect?token=eyJpdiI6IkF4YWc0bnlpeGhpTVlWSUdHV1pRWnc9PSIsInZhbHVlIjoiV1ptdGJFaGxqbzZYUGNyZXhWOE8zTGIxd2Q0RVpMOCtoSnlwalZTQkNmYTlFcjBSOFF6T25GdUFGaU04TG5SQ2pYU1lvbTdldTIzQjk5SzFMeno0ZnNIOHZrZ1BYSUorNy9aSzd5UGhwNms0QWVTYUdxRzFzd3BIbGFKWDZYeEVmclFFbjVobXlMU1YxaWZJQTcxanhuRVd3S1l0MFE2WDIxbG9iY1lmdzM1RzI1bjcxaXFxTzF6a25mVW9ab0E0cTduSStWOENJTTNrNjdZVTl5QWY4SnZiLzduYlVqMlVhTHNKQlJTekRUMDdMUzBOOGJxK3ZjdUs1a2ZoYzFuS1hHNUZOY1pmRm9uQWlQQTVKc2orZC8wK3NNUkg2dEZpOFcwRSsvNWpsNmM9IiwibWFjIjoiZmQwZGE2ZGRkOTg0NzMyN2FiN2YxYTg4NTAxZTlmZWFiODQ0M2RjNzBiODkzZmQ3MTkzN2UyMmYwM2U2MTcwNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, CO, CR, CZ, DM, SV, GT, HU, PA, PY, PE, PL, PR, ZA, UY', '[{\"id\":\"36cc00fa-8847-461a-ad29-478d9078d2e3\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"2dcbf452-20d0-485a-9cad-e0b1f9a51cae\",\"name\":\"Reach Level 50\",\"payout\":0.02},{\"id\":\"d3e95c6e-35eb-40e0-918d-3222d79cf1c3\",\"name\":\"Reach Level 100\",\"payout\":0.028},{\"id\":\"e4d45ba8-8bbd-4a12-8643-e77273806bdf\",\"name\":\"Reach Level 200\",\"payout\":0.056},{\"id\":\"0aded65f-06fe-4d39-93fd-a59f8067fe6b\",\"name\":\"Reach Level 500\",\"payout\":0.14},{\"id\":\"32dc32a9-b0e3-4836-b586-a8f837b6523a\",\"name\":\"Reach Level 1,000\",\"payout\":0.28},{\"id\":\"a98ed4af-fbbc-4613-a52f-a78ca368ade9\",\"name\":\"Reach Level 2,000\",\"payout\":0.48}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(399, '696494-lZ2kToJFfVYWxuk6', 'Blast Friends: Match 3 Puzzle', '', NULL, 0.65, 'https://notik.me/api-redirect?token=eyJpdiI6IkFkUU81c003Y3BpeG1ENGgybnJWeUE9PSIsInZhbHVlIjoiUDE5RmxiamRWdks3YWRKK3VYUi9uSWxNSS82ZkRVcVRaMEJkT3ppQUxTSFRRckw0SWZxNTdGRFNtNnRLVDFROWFBNytQSDFlbHJZbmJNbnFnTm1tUUUrTzJiVDc3ZlNCajc4VGFJRVFrblpaVXpHRlBEblJmcjh3N2dNSTROTzQ3NEFKR0ZJZURWVW1URUdWVk9QQXVSQjF3NThrYUxmSU0xYmVPeFMvdGhsN0RISXZKK0FUVW45M3hDdGp6aGxSWnI4eGNackd5UEFvZ1drUHE4UmVabXdmRFN0WDhzNDdvaTd6WmJHRGsyYVFnWVJMMGJ3dlpoYnZsc01jUWhyd3JyZ2NqdytSOGpCMXYyRFRpdzIwSjcrMUtGOVNJTHZYRC9sQ2VnSjZHVDg9IiwibWFjIjoiNWEzNDA4ZDViNTBjNjgxZmYyYjUxNWFiYWZjODVhMjFhYjUxMmNiMjZlODhhNGFhYjRlODE0NmRkYTM4YzA2NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC, ID, PH, TR, VN', '[{\"id\":\"7849c446-cc1a-40b2-88e5-0970534fd8c7\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"7a17f578-2b8c-4b6d-8be5-54e28d8dea07\",\"name\":\"Reach Level 50\",\"payout\":0.012},{\"id\":\"7a6786ad-4994-4c6c-a8e3-cbe4e60bc5f9\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"344ec5a8-e28c-4cc0-bcc6-cd682f65fb88\",\"name\":\"Reach Level 200\",\"payout\":0.04},{\"id\":\"dffa17e7-0931-433e-ac30-4db9c5990498\",\"name\":\"Reach Level 500\",\"payout\":0.08},{\"id\":\"b7ee9541-f3d0-49bd-8356-ee21acb2058e\",\"name\":\"Reach Level 1,000\",\"payout\":0.168},{\"id\":\"d7d3b58d-433e-4cc2-8815-9b93d0e833ba\",\"name\":\"Reach Level 2,000\",\"payout\":0.336}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(400, '714026-lZ2kToJFfVYWxuk6', 'VVVGamers', '', NULL, 1.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlpQVTlJU0cvMUlPQTNlMi9RdmFFYnc9PSIsInZhbHVlIjoiSFlTR2RyWUxmM21mWHg5OVBSMGJhSVpaZys2aWxxeGdjdnpwb2p5aUQxUm8vU2JDVXQ4d0Q5QUFOQURRT3luOVR5Qy9rS1dmcldiaEF3aldCZmlvZVFoUFQxSDhxYTIrVzZRdXl6dmQyemJhQ0kxQVhVVnllZUIvaHpCWW16WGREd0QzdEJXWGZ5ZHRLS29TQXBNeE9jMEkwSmw4aWIrU3RFRXRiQVNmK3hocS84K0dOMkFwdldmUFdiS2kzMmpxaHY3ek5URXRVekNlMUQyY3hFUTRMTmExcVpGN3JCZnFNMExEemZPWTc2ajJmdEM1MERZb0MrT3kwOGRuWjljd2hmaXM3WE5WSHJlS2Q2cjYrMHdPdlE9PSIsIm1hYyI6ImI3YTFmMjBkNmVjZjg4NzRlNTFmY2ZjM2ZlYjIzOTI3ZjU2Zjk2MGZkMGU2ZWIwOTUzNzkzYjMxM2Y4NDVjNDUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, CY, EE, FI, IE, LU, MT', '[]', 'all', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(401, '749865-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 2.90, 'https://notik.me/api-redirect?token=eyJpdiI6InZYSFlaRUVYeFdnc0VDR1d3Y3QzL1E9PSIsInZhbHVlIjoiOUl0Rkc5dTRVelN2eUNwUnFqMVVnL1FSNXp5SjVpTUh3S2ZWNGhTUHhXVGZYQlBXNFUxcTVQYkE0a0lvNXZtNXFvWFk3UmFHUFU5c05OVjkreTBQeC9rUndjMHVpMWVic1FPZkgvOHJ1YkQrWk5Pblp6cmppMFplbFF0Y3BkczVGdU1yeUVqWW5ZdnNWNzIxR2hiY3ZsZFNpR2xjTE9mTGsyUy9iMXpRV3RiN2V5NXh4M0F0dFlNVkZlVE8wcENOZjh0WnZQcnZFNUtnQVpWaHhnZ0tsTDRoTzZDZjFhSlpuSzBNMmFYQSs0emJHbSt2ZWsrVTVKempEd3NJRVlYNndCTEFHTndXT01UUmRzcWtWVWtNMkFFc3Mra1ZhSDJ0V29PUFNhcndVMzA9IiwibWFjIjoiOGQ3OGE5ZWUyYTI1ZDYzYzQ4ZGZjMjhiZWNiY2Q1NjI4ZjU4ZjcyZWIzZmQzYWZhNTcyYzljNTYwZmI5M2RjNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AL, DZ, AS, AD, AO, AI, AQ, AG, AR, AM, AW, AT, AZ, BS, BH, BD, BB, BY, BE, BZ, BJ, BM, BT, BO, BA, BW, BV, IO, BN, BG, BF, BI, CM, CV, KY, CF, TD, CL, CN, CX, CC, KM, CG, CK, CR, HR, CU, CY, CZ, DJ, DM, DO, TL, EC, EG, SV, GQ, ER, EE, ET, FK, FO, FJ, FR, GF, PF, TF, GA, GM, GE, DE, GI, GR, GL, GD, GP, GU, GT, GN, GW, GY, HT, HM, HN, HK, HU, IS, IL, CI, JM, JP, JO, KE, KI, KP, KR, XK, KW, KG, LA, LV, LB, LS, LR, LY, LI, LT, LU, MO, MK, MG, MW, MY, MV, ML, MT, MH, MQ, MR, MU, YT, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NC, NZ, NI, NE, NU, NF, MP, OM, PK, PW, PA, PG, PY, PE, PN, PL, PT, PR, QA, RE, RO, RW, KN, LC, VC, WS, SM, ST, SA, SN, RS, SC, SL, SG, SK, SI, SB, SO, GS, ES, LK, SH, PM, SD, SR, SJ, SZ, CH, SY, TW, TJ, TZ, TH, TG, TK, TO, TT, TN, TR, TM, TC, TV, UG, AE, UM, UY, UZ, VU, VA, VE, VG, VI, WF, EH, YE, CS, CD, ZM, ZW, AX, BL, BQ, CW, GG, IM, JE, MF, PS, SS, SX', '[{\"id\":\"c064d22f-6bed-4882-a5ab-5dbfafbf75fb\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"933c4ad4-73bc-4026-93c5-3a97ca791372\",\"name\":\"Complete Level 100\",\"payout\":0.036},{\"id\":\"7496705c-8370-4143-8278-493d086c5c60\",\"name\":\"Complete Level 250\",\"payout\":0.14},{\"id\":\"6db9ab8d-68df-494a-8965-efde1132a4ed\",\"name\":\"Complete Level 500\",\"payout\":0.56},{\"id\":\"955b0fe9-07fb-4e9e-87fd-c42580d5de3b\",\"name\":\"Complete Level 1000\",\"payout\":0.76},{\"id\":\"123c8ebf-f1d0-478f-a14c-774054ec669d\",\"name\":\"Complete Level 2000\",\"payout\":1.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(402, '809139-lZ2kToJFfVYWxuk6', 'River Dash', '', NULL, 11.14, 'https://notik.me/api-redirect?token=eyJpdiI6InpPdnpVaXdIRmRYZ2VRNHAxVWNuWXc9PSIsInZhbHVlIjoiN2svU0tHK2NqSlNjem5nOWRKK3l1YkxLUUhUYmtjTE95SzNrSGNYajk4SllhMFZpcWRHY2RZMnVrZGFGMmNtZlN1Q0ZJeGhTOGc0N3FtQUMxVDlnd1lVL1E2RGloZ1ZFait0Uk1DR3dYL0JPbXV3SUM2eTBKTzQrbDlHdG1rTkRFdCtLdWVUcGpFUHJDNnJhUnMxMEQyalFzQ0MrWmIvd2R3ckNRcUFEMUdDVE5QNjRlWklGVXhIYThDV0l2SzIwUWRqTC91QUhXTFplSVNkcGxGdEQ5V0VrVzRSYWJ4MlVDRXJra1FXVTRDVzZTcHlmNXJsYVZIN29QOSs3NWJnWCsrcFFCbzk1UThiVzU5aFM1N2RtcGc9PSIsIm1hYyI6IjFlMzBlOTY3MjFjMDAwZjc0YjU3MmZlOWMwNjk5ZmJlODZiNzIyYmE4OGRhMmQ5NmQxNTdiMWFjMTBhYzRjMTMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DM, DO, EC, SV, GT, HN, MY, MX, NO, PA, PY, PE, PL, PR, CH, TR, UY, VE, VN', '[{\"id\":\"066d9f9f-827e-47a0-9507-692b8b005d6a\",\"name\":\"Play River Dash !\",\"payout\":0},{\"id\":\"7845aea3-3554-43db-9fa0-c0e22719468e\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"b5b039bd-7803-431c-bd00-65358c47f3bd\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"411a471d-6f29-4702-a7e0-fb2f355e3957\",\"name\":\"Reach 600 Meters\",\"payout\":0.12},{\"id\":\"6aa50ac7-c48c-41b8-89b4-a6f9db5f5526\",\"name\":\"Reach 1,000 Meters\",\"payout\":1.2},{\"id\":\"561f38f2-5758-484d-9514-ac5c8599526c\",\"name\":\"Reach 5,000 Meters\",\"payout\":9.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(403, '822859-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 255.76, 'https://notik.me/api-redirect?token=eyJpdiI6Iml5S0JCQkdRNTBBV3BWWGw4NG5HVEE9PSIsInZhbHVlIjoiakRSMGVnczBXNDVzZDQ2MnlnNDUzekhSdzZVSy9naTVReThNYlRWakFGdjUvaUs5czd6ZGc1Z2RoT1NWSG15cmlTMFZvMzFQV0tjNlpobFRWWnQ4L3VQMEZIQUs4Wm1TTExoRERUV2dqV1ViRS9nSWJaQTNmWHVrenpucVN2aTJUakRtTUthN2x5WFRFWTZJNys0YzZuREowdGs5T3FBK1RXeFNGblphRXk4Z3dySnJQck5jdW5JRzRPVXljay9uLzVIS0dqa09tZXB4RVQ3U2lPd2NacC94dTlla1IvY21FYnRkRmttWU5rNm9UMm5mUjJ3aUxKSHpkaU5ZZXF4a29KQUNLUWphTDZ1L1JucXlJVGlLZVE9PSIsIm1hYyI6ImI1NjMzNjkyNzg3MDM2MTc0NGI4ZDg0YzU3Mzg2ZTk0ZDkwYjYyNDA2ZDI3NTc2Y2I2NjlmNzY4YjBkOTc4ZDEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"8668f379-2b85-471e-b964-55278411c1b4\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"1630b24a-4a9e-41b1-84d5-a5063e6c4f41\",\"name\":\"Reach 100 Meters\",\"payout\":0.02},{\"id\":\"98e099ad-e1ed-4095-913e-a22ee688ddb2\",\"name\":\"Reach 550 Meters\",\"payout\":0.14},{\"id\":\"cea8e0c7-2a3a-4630-b32b-69a666492308\",\"name\":\"Reach 700 Meters\",\"payout\":1.6},{\"id\":\"d0e89329-e45d-4fd4-9c2a-185e414e2085\",\"name\":\"Reach 1,000 Meters\",\"payout\":14},{\"id\":\"20850882-3ea1-46ef-bb3c-eee0caa6b02c\",\"name\":\"Reach 2,000 Meters\",\"payout\":40},{\"id\":\"fad1abb9-025c-4ef3-a66f-a66e47acc7c4\",\"name\":\"Reach 5,000 Meters\",\"payout\":200}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(404, '822874-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 200.51, 'https://notik.me/api-redirect?token=eyJpdiI6InRwUm5SVlVLaVF4NU1vbncrUVJOcFE9PSIsInZhbHVlIjoiSU9UMU5pbmN3aVJnb05mcEtMakJzbUc4V1F5WlhMUDB4SjFraHFCQmxYTzhBZ2wycXc3dkEyd2NFN1pLc2M3ZU56TDMyZ3F0eUQwVVByZUx6NDE5OXVVKzNab1d3b0IwOTZBNjJBcjI4emVPVGZON3ZqNDNjVEZNZVVqSGtMYS9pRlBGNzVva0RiSTBId2dQc3NLV2E3N0VyYlMrK1c3MkFZUkxJWjNSN1hyR05tUnc1SVJJS21KbHBJNUtOMHFNbm5Vejd0T05vWW45ZVVnL0FoeC82Kzl1OVBIOFdPZ1hwd2Y5Q0tpZm0wN1NlWEVLV0JXSVoyNzBSZHJ6eWxuaXFNNmJVUFU5L1NhRGRKMTVZNUE5SXRmOC9ILzROcUhZVjNnaEJHZVRKQzA9IiwibWFjIjoiYzRiYWViMjBiMjYyMWJhZTk5NmI1MzdhMzY4NjcxZWU1MTk0MDEwNmNlYmRkY2IzNTlkYmViNjY2Y2JkMzg5ZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[{\"id\":\"f2c4aeba-b95f-4345-8a3d-68d0fb79bea4\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"01c28854-4cf4-4374-8350-89dd37f5162a\",\"name\":\"Reach 100 Meters\",\"payout\":0.012},{\"id\":\"c575f37a-8f76-4682-9ff7-a578ce04627e\",\"name\":\"Reach 550 Meters\",\"payout\":0.1},{\"id\":\"dfb86b4d-20d8-4c6f-a472-f4345f9315a3\",\"name\":\"Reach 700 Meters\",\"payout\":1.2},{\"id\":\"a645e90f-c9ab-45d9-8511-c337efac7ec4\",\"name\":\"Reach 1,000 Meters\",\"payout\":7.2},{\"id\":\"baec26cf-1894-4b8e-b063-a16cd85a330d\",\"name\":\"Reach 2,000 Meters\",\"payout\":32},{\"id\":\"c69bc0c2-9ab8-48e0-bcec-40ec2f32eb5f\",\"name\":\"Reach 5,000 Meters\",\"payout\":160}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(405, '822884-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 170.91, 'https://notik.me/api-redirect?token=eyJpdiI6Ill3cWxKYTU0Q1FjK28vNDMyeEp3bmc9PSIsInZhbHVlIjoiT1lPWSsyNWw5NVpKQ3VadDNhM1YvV2NtWDlabTBiallqb1JnMXVVc01rQ1lwU0c0OERHOUFQNjcxWmJlN0k3a0NJM1RMWTVQVy9xL2J2RGZ1dktTZVNSQW0xSDJNWWVhSENjOTJOOThaZHl4eUtFY2lIekZLeFYyTnVYYWxnd3AxVDdVbGhSaHFndHZxelFUeGEwcjZRQi9Fb3pTVUpQWjVJa1ZZZ0UrNmVKZjQvWER3eThsWGJVT1RZbkJJM1hjRmVPV3k2SUt1bWI4ZTJmczFBK1JidzB1dklPYXlTQzZjbm13WlFnbHd1UWQ3VDB6S0tXVXlJdloxeFF0ZGI1OE9RRmtHblJUOXNoU3dZZDRFQjI2VC9zZVk4c2hjaXFURGJDWGNZOTJQaTQ9IiwibWFjIjoiNGMyYjU4MWE0NWE4NzhlMzVlM2IxNWRmOWIyMGRiNTYyNzI3NDU2NjU5OWI5YWNkNDQ1M2RkZThjNjEwOWJmMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"b778196b-3d94-4160-b540-f2d4e315cbbd\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"19d7bcc6-28bc-4698-a430-57337b2d9f79\",\"name\":\"Reach 100 Meters\",\"payout\":0.012},{\"id\":\"45f3ce23-edd2-4b52-a5a1-570bd4cbd371\",\"name\":\"Reach 550 Meters\",\"payout\":0.1},{\"id\":\"be16c432-dc8b-4cf0-afb0-9bf512f2dd25\",\"name\":\"Reach 700 Meters\",\"payout\":0.8},{\"id\":\"3e61385c-e171-426b-953e-a409b7e7fb51\",\"name\":\"Reach 1,000 Meters\",\"payout\":6},{\"id\":\"7a6d4b8a-f86d-41ad-ab26-b1f97f17cc30\",\"name\":\"Reach 2,000 Meters\",\"payout\":24},{\"id\":\"37980775-b42a-4c95-a94d-caab705eb81d\",\"name\":\"Reach 5,000 Meters\",\"payout\":140}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(406, '823046-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 125.64, 'https://notik.me/api-redirect?token=eyJpdiI6IjNmOUlhaWd1aGxUZGkvY3R2Y21odlE9PSIsInZhbHVlIjoiSWt0ZG91WUVTR2c2NWFvNXlGL1NUUDYvSE1NMzQxblR2VG40NWcvcGdJRnhTd3RQb2F5ZGhuZnBGMEdSdnkwUnNZSXdiM0QrYk1VYkd4Zmh5dzFaMDcvZFBkeEVkZXpUTUsxWG9tRnNBNjFDc2daSVBLMGxWbXZYWUtrOVFDSHVTK0tXb21lUjBodlkyaGFvSEJtL3JWdHpkWGRFSkV6aThJZ0lHNncySFZkZVI3QWUya2NjbGsrQmJFczRUNHpDanI3WmsyUkVIZE16bjZrOERwVHdiaVpHQnd3cXA1TDFYV1YvNEwydDZYZkZrRkwyT3RMNTNNQy9rN0ErVEM1SDg1K1JWdXhKd3FlelNQYkdLbVdweUI2MWJzOC95bzZNTWUzWVBpd3lPa3c9IiwibWFjIjoiY2U0ZmI2ZjNkZDQ3ZWYwMjU1NGI5Zjc0MDU3OTEzMDhlZTM0Yjg5MjBmNzEyMGQyZGYxMDZlYzNjN2RmNWQyOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DM, DO, EC, SV, GT, HN, JM, MY, MX, NO, PA, PY, PE, PL, PR, CH, TR, UY, VE, VN', '[{\"id\":\"89c6b214-039f-4712-a8be-215252c40848\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"119df294-b1ab-4e1c-b20a-ff1bfc55204c\",\"name\":\"Reach 100 Meters\",\"payout\":0.012},{\"id\":\"6e1fced0-86b9-4300-880f-031ce6204d99\",\"name\":\"Reach 550 Meters\",\"payout\":0.072},{\"id\":\"1fc5410b-d166-4eb4-a8a8-e52d2b38d1ae\",\"name\":\"Reach 700 Meters\",\"payout\":0.76},{\"id\":\"a55991ee-94d3-47b9-946a-cbd099638feb\",\"name\":\"Reach 1,000 Meters\",\"payout\":4.8},{\"id\":\"082b32cf-8ca9-419f-84d5-517c6dded7cf\",\"name\":\"Reach 2,000 Meters\",\"payout\":20},{\"id\":\"5a1d08d2-52d7-4187-b859-b0a69c2131eb\",\"name\":\"Reach 5,000 Meters\",\"payout\":100}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(407, '828808-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 1.32, 'https://notik.me/api-redirect?token=eyJpdiI6Ii9RdGR4c3lJNE0wMEU0K1BSZ0hYeHc9PSIsInZhbHVlIjoiNEI2QjNhZHZOSlZ2WFYrYkEwaDVpM3k1MGVUV1p2Y09reFlUcTcyRHR2aW1yUDhaQXhXaWZnM2Rid1B5elpLZWpEMnozcVdRZkM5R1p5TEx0N0dLVVltNXM1QktxTTR6b1JKd1pOZjluNktVaVNlQmc0Mjc3TjgrS2tWSUNPTTdLRW9TK0lqMFZEUkFCSDJtUCtRTnB6blprZXE1S0ZlcDdieUZuaEV6S2F6MlRxR2RBa25veHRzY25ncGRuSDkxKzVpRzl6eWc0UFYyOGg0eDQvdm40bElJemdTUzZVR2twOTFxbXQ2bFlkKzBjMm9XRS9QVllGbXBmdUtFdG93ajlqK0RJV3V0YmhLc2xYY2R6L3BkQitHb0ZrUEZCMXFoZDlQMzBodWl1OWs9IiwibWFjIjoiMTEyZjUwNDg3OTNlZTdjM2MzZTlhZWY0ZGJjODczMmQyZTM1ZmQ4ZjAxM2Q0MzhlN2E0MTA4OThkZjUzZGY4NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, PT', '[{\"id\":\"5ccd0890-5b35-4a75-973b-57da54af377a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"9d8ba84d-1523-410e-a36f-bf12075b605f\",\"name\":\"Reach Level 100\",\"payout\":0.064},{\"id\":\"e4004893-ecc2-4395-b799-ae16d22e2236\",\"name\":\"Reach Level 250\",\"payout\":0.176},{\"id\":\"5fdb5b0e-64cd-4315-8d11-308c252a514f\",\"name\":\"Reach Level 500\",\"payout\":0.38},{\"id\":\"b8eee061-72f2-4ed3-a131-3d9156a6eccb\",\"name\":\"Reach Level 750\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(408, '828817-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 0.77, 'https://notik.me/api-redirect?token=eyJpdiI6IlZDNEhkeCtvTkIvVHNPa3dQSER2aEE9PSIsInZhbHVlIjoiWGlJNGREZ0RnTFN3eEJnUUFLTWRKbk9LYndNcmFoUzA5VU8vWFMwZW0rR2hHMGZXYk5MOTdRQU5MMTVYbXhObTFJdEJxNFF0aUJSTWYvZkIweXlycjNUc0QwVWlSUzZCZVJsQUdMT1F5UEl4MUZlZk5ldUY5TGxDYnp3QU1BQ2pFNEJuV1VQWUxGNk5PRlpVNDBBVVJyRXZkaXJCdTkycWxhWUFsY3VJTTdKR1UxdzFQVTdoVFBia0dUWTM1Y1BnSCt2V0ZqM1ppVFpvYlU3VFRWZWxJM3d4eXo4ZE1MMGdpTklkUWhMODFzM3o4SVdjRmwvSWg5MmtLL1NMUkEzeXlzWVNxZitLNk05Z09RQ1JYNGI1K3MvWG8xN3RTMHhMbFBoVnRMWWNxU0E9IiwibWFjIjoiYmZiN2I5ZDc3ZGI5ZWJkYTUwZDU4MTUyNmM4OWI0ZDA3YjZiMmRlNmU2MDQyMWE5MGJjYzI0ZDVlYmQyOWQ2NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BG, CO, DO, EG, SV, ID, KE, PA, PE, PH, RO', '[{\"id\":\"7bec390a-98ea-4d97-98f0-c030ecf2bdd4\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"d870355d-d195-4433-9612-1f17be2f23a9\",\"name\":\"Reach Level 100\",\"payout\":0.04},{\"id\":\"ae0a75fc-3f30-4545-b453-a8fdac41d603\",\"name\":\"Reach Level 250\",\"payout\":0.088},{\"id\":\"b1cb0a0f-15ff-4ae0-aaf0-4b3341f902b4\",\"name\":\"Reach Level 500\",\"payout\":0.18},{\"id\":\"09f2ba3f-a6da-477c-a5fe-5934fdae0797\",\"name\":\"Reach Level 750\",\"payout\":0.46}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(409, '828822-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 11.36, 'https://notik.me/api-redirect?token=eyJpdiI6ImVmL0RHbHlGY24zS0ZtWHdBdDQvd3c9PSIsInZhbHVlIjoiYWM2Z0hwN25DK051S0JIeEFoWCtPWHpxeTRpVHY3Y282Y0N1QzU4ZFVjNUlMSjM5SnZtYVBqVlQ4L2l4UEc4dm1EQ0c5ZE5GcHFaYXlaOVJ0ZktoSkhheVY4aXVVYnd5OHJHc3VXZDFhUmJEaGZyanVqOFRDTFJTQndjOTNIT281MzZLazhuNHFYMXhsTER4UUo2NkJ6Yk1tR2piZnFWTW8ycFhDdW90UndWeFdFa1lGRXVlK1FJOGpIRVlsQmdvMHRSK2Zjb1R0bmhBY1dLR3k2UzJCVTR6RXFySlRDbTlDb2FpL1lsL2RQNnNCbW9pYWFNeTRmckxBVmpCN3hHcERacERyaEJSWmF6dlhZRENvcTNxYldqQS9HTHJQc3F0N2todXlZQkZiTU09IiwibWFjIjoiMGQ0MTkwMWUxMDFmNDY1NGZmZTU5ODhiNDE0YzA3ZTdhZTlkNDRiYzM0ODBlODNkNjkzZGU3YjAzY2IzOTJiYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"e3c6f4fb-8c5e-4d6d-88e0-d8d965ce5910\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ad87d34c-5d87-4b76-8230-fc7a3acc8f25\",\"name\":\"Reach Level 50\",\"payout\":0.42},{\"id\":\"9c9ca633-37ea-4165-aeaf-6e9460be9f5d\",\"name\":\"Reach Level 100\",\"payout\":0.46},{\"id\":\"4a1bce3b-83b2-4838-b307-6432a3238f35\",\"name\":\"Reach Level 250\",\"payout\":1.4},{\"id\":\"f1023f33-dabd-4d1b-b2bc-2a3f626d2e27\",\"name\":\"Reach Level 500\",\"payout\":3.08},{\"id\":\"465d385b-4777-4fbc-b768-d831e6548915\",\"name\":\"Reach Level 750\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(410, '828829-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 3.03, 'https://notik.me/api-redirect?token=eyJpdiI6IitoNHhMSE0vdXV3TmJuSzd2bThmM1E9PSIsInZhbHVlIjoiY2RubDBZUEZheXRQbWV5eFZkd1RxZWlYWE1iZTNTK0g3dnc2alR6MmlhVU5tTFpIREJrdVgyNWp5RHppbTRHaGZ3KzdsbDFsQnNUY3FqemlUTDc1T3AvQXRKeEFYeVNCQ3pkV01jS0xybitLSng3Y2dLOVk5L084NEppMUpyRi9HTGtob040TDN0ek41N2JnVFR3TmlxNzZ5aWFWOGZKajMwdUVQdHV2QmpaVEIzRVFRb2NEOXRyNVVvcFNwVkdaaHduYkViRjk3Qm52Y0dNNlcvTzgyajdWU0hqVENlZjB5YzFyVWNKSHdWSlR2Ni84YkR1M05Gby9XcE5Fc09iY28xOWhzejJmaDZRaGY5QkhhaWxYeThqdExKWnNzNE92eTNkSjJueGdXWHM9IiwibWFjIjoiODY5ZTYxYmM4ZGVmNzQxOTdmZjViYjg2N2Q3MjFmMTM3MGE5MGE3YTRkNDU3NTU2ODc0NDQ5NjYwOWYwY2M3ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"19657f78-3ae7-4ed9-ac0b-bf93415b1aa3\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"9c1e9cba-3a04-4ad2-9a11-cabb56c6f4d8\",\"name\":\"Reach Level 50\",\"payout\":0.088},{\"id\":\"36bf9a29-2816-4efe-a92b-33d1c280746d\",\"name\":\"Reach Level 100\",\"payout\":0.1},{\"id\":\"d6623876-9434-4127-990e-2f698d883888\",\"name\":\"Reach Level 250\",\"payout\":0.38},{\"id\":\"e1d5393b-125f-4be1-a793-512f20b7af35\",\"name\":\"Reach Level 500\",\"payout\":0.764},{\"id\":\"c4d730ab-dbbf-4aef-8e04-f0bb7fcde8a3\",\"name\":\"Reach Level 750\",\"payout\":1.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(411, '828835-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 1.11, 'https://notik.me/api-redirect?token=eyJpdiI6Iko3c2k2WTc0aHMzNnNjdE5HZFhkTEE9PSIsInZhbHVlIjoidXAxbzhVQ01vTDdOSE8yTDdxdnF1NU5PV1NOR3FKRWxQWjIxZDcvZEpqK1UvS3JtVXpLcDVRcVkyLytVYTFBM2RHN0pSYkpjRGtXR1lpWVY2V2MvQW9KcTNuNzRaVjd5Z0RFQTdyQmxmeEk4WWc2V2xFZVBKZlJPeGRySVlJU0tyVzBGUmhyL1lJSUQzeTJxZUh2UEN6dVZiZDlYc3N2ZWx3VWNheWlCUkt1QmdXc3BNMWNSUjA2VU9VaThSankwMjVKMDZTb2xjVzZiV2lYRjAyUHhISVRLRE1yYk43YyttUUZzbUgrcXUxdDRmZ3YyV2hyUmtiRk1KcjRkakpMdTFBaGtYMnhSYTFJbHo2NXRmU0g5SnZ6ay9IY0lJbFNJcXV6bWVYNy9kYWc9IiwibWFjIjoiMTQ4MTQ1OTNjNmZhYjY3ODIxN2U3ODU4MzBhYmRmOGY4ZWFkZmU5ZWEwYzdhOWRiNWVkYWU4ZmMxOGNkZjlhOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, PT', '[{\"id\":\"14c31626-9067-4439-804e-f8258da78038\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"891a7a35-a541-4585-99d6-5146fda09107\",\"name\":\"Reach Level 100\",\"payout\":0.06},{\"id\":\"b1693451-387b-40c6-ac1c-0d1e0373a97f\",\"name\":\"Reach Level 250\",\"payout\":0.14},{\"id\":\"0e3dd8af-5235-4546-ae31-688dbdeab7e6\",\"name\":\"Reach Level 500\",\"payout\":0.308},{\"id\":\"4484d4f6-d471-485d-acd4-34734682004c\",\"name\":\"Reach Level 750\",\"payout\":0.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(412, '828840-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 0.58, 'https://notik.me/api-redirect?token=eyJpdiI6IlliMW14Z05VSjU2K2F1OEVWWm4rSWc9PSIsInZhbHVlIjoienladC80UHNkTkMvOUtJemd0NENIZVphYU9uN1RITFFWVUtjRlFpWUZGUTFyd1ZkQzBEdmhUM2pnc2hSZlZVR25LN1F4SE56VlRrU1FwU0RKSlYzUU5sVFRsRjFESUlxdWNMNjJlOThHejYrOXBjeEtjTTl6Si9GREVvUUE1ZXBLUjhJcjZJZElUcGZIRVBpT1RQdkhjOUU5T1RDSElkYkdrUHFzbW1MOERjNEYzb0NXY3NyUDBOVTUxUWhacm5tcnRZei9IN2k4d0FwTWRWY0NHYjJIOThndEVEbUNlZlRKUE0ycUZPZ3VnVXliYU1OWFBRSmRTRGxULzdzYkliYUZPSXdQekgxMWVadWpEUWp1Sy95bDZPVGVnbFZpd2FOUVBjRXRBa3IvZlU9IiwibWFjIjoiZmRkZWY0YTlmYzNkZWYyMTZlMzBmZTU0Y2JmY2I1OTc1ZTEzMmRiYmRlZTQ1ODQ4OTJlNmRkYzhlOGRiYmI4ZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BG, CO, DO, EG, SV, ID, KE, PA, PE, PH', '[{\"id\":\"36a576d9-e986-426a-b9df-288d66bd241e\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"add31d25-d418-48ec-b428-2969d6b2d314\",\"name\":\"Reach Level 100\",\"payout\":0.044},{\"id\":\"e09cec61-31d0-47cd-8420-e2aa100e549a\",\"name\":\"Reach Level 250\",\"payout\":0.068},{\"id\":\"9ec22432-57c1-4d96-9552-b36aa3c1adcd\",\"name\":\"Reach Level 500\",\"payout\":0.16},{\"id\":\"2fc62b44-87c0-45c3-812f-3291d6f9aef2\",\"name\":\"Reach Level 750\",\"payout\":0.308}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(413, '870202-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 1.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImdRYUNQN1laY2pJUDJjbGNnUXRMMXc9PSIsInZhbHVlIjoiMkM2eFc3UFF6QkViUjhIM1ZxOTdGZFRsQ0gwQTNoNDlWTjhVRkI3ZlRQU042MTlMQjR4NEJldjIzbnRXV1c4RkdOWGZyRnFETW1MWVlzYlo0dXo4cXg2eUFNTnFrbk51K2tlazZ2dEdKdVRkMHp3YUxiZExqVk1LcU1pQVZVVHBLNE5TekdCVFhreWNPUFllVFpZY1NQVEhtMlR0bkdvOXpCSU42c2VzMnFRNUYzZHVjR2t4bnk2ZWRaRG0zWE5jZmZjbGpUWDBJR1pIYUViMzk2a1NINm9mTVlFc0Jydlc3RGFIcCtNT2djR3NGWU1TU1hWNGdzWlZ6N2t4ekdSUWlCS21kNTU1V0V6RDJMK1I3WEVnSU5QcVdxRXVscy85TnhxajRRWjhLSnM9IiwibWFjIjoiNTMzZThjNDY1Mzc2MWI1ZmFjYWJhNWUwNDllMTg0ZWY5N2ExOGYwNDJlY2ViZTViYjQ5ZWE1YWVjYWNjZTRlNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL, TH', '[{\"id\":\"d249905b-3638-4052-a848-e8d7be838347\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"a907bb8c-6b3d-4ced-8bdb-4ae2b8709b1a\",\"name\":\"Reach Level 100\",\"payout\":0.052},{\"id\":\"d931fe04-ed2f-4583-8fef-6ef84e1b6fb7\",\"name\":\"Reach Level 250\",\"payout\":0.168},{\"id\":\"4a40c4a9-a22b-4ce5-acbc-c68ce3ce2073\",\"name\":\"Reach Level 500\",\"payout\":0.34},{\"id\":\"af2822d0-e078-4579-8142-9a4240cbb1c2\",\"name\":\"Reach Level 750\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(414, '870211-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 0.54, 'https://notik.me/api-redirect?token=eyJpdiI6InprbTlmZXJ0bEl2Z1BDT1dJZEFhM3c9PSIsInZhbHVlIjoiMWFrdnE3VDNkSlZSR2RiU0l6Qi8xSXkrV1VlT3ZUd3p3YVNmSTJGd3lReTNMcXV1UHFZbmZZUVI5SXA3ZWtjeFJBOGZSbThPOUVPenpjc0ZxeEQ3VEVxTzVCZXRPeUFiblJHOU1kL0MvSFdhdHRLWkJENnJlVEdhQWZ1Z1lVd2J1a1N0SElDWjk4L0dUWkQrRnI1YW0zUm9CUFc1NEFmMzZVNkpkRGFxaWpxT01EdDNBWXdCRjF4VFhDSW5iQWtFRXcya2hMZlp3cTNka0FmbFd6bzNZK1NZRkMxVjBEcG40RGpISXpTRlF0NHU1YXpSUm4zNWhhN2RScGMyazFoYkY5aDRVTWIyYlNPdzEzdDlKUDBQTjdCbzIvTXJjaEdBSEhtcHdHNTl4Sms9IiwibWFjIjoiYzkzZmE0OGNlMGI5OTlkNzM5YTUxNmE0NmY4YTM3MWM2MWExOTM2MWNhNDExYzhkMDFjNjg5MGUwNTg5MmIxMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC, EG, GR, HU, SI, TR, VE, VN', '[{\"id\":\"3c7d4c62-a965-454b-8603-f70902c34305\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"44bc7e96-87d1-4d80-9dfe-2c423a23809b\",\"name\":\"Reach Level 100\",\"payout\":0.032},{\"id\":\"5fd377bc-51cf-4c81-9440-37f1372c30a4\",\"name\":\"Reach Level 250\",\"payout\":0.068},{\"id\":\"4a232566-8685-4334-8304-b5d3eea7732b\",\"name\":\"Reach Level 500\",\"payout\":0.16},{\"id\":\"9efbbec5-f3ba-46b2-9c4a-88a0782a2588\",\"name\":\"Reach Level 750\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:05'),
(415, '870219-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 9.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlFWY2ZoZ2xpTUtFYVh0SllJZGJCZ1E9PSIsInZhbHVlIjoiOXloMEc4aURWL1BUeFJtaWhydGlzYVpkYnpxTnBKRStUM2pJbjFyVk9pSVBNVHgzdUNzSk9iZ05tNGdFWEo0aEY1L1UwMUFRYzB2dVI3aFpycGh0c1BkQUV2dkNTYVJ4bEt6NkNQUmJYT2RsN2E4Zzk3L2FPYnRIY3BiTCtFS2tiWG9hOS9JNmxsTFJvZDlENlEzK0NXamN0eURqdnBJbWlWbFNXVmMwbFZtemNER25PRGtxL2NMM3ZiVy9PVUhmTmhmclE5MEZremFrNXJ3SGpTeTByeFY3SndCbjZFdkFmSjJDbC9CZ2hXZCtRbm43UFBxRnZiTWNiRjF1dW1HNWFjNEFIVUdpK1orUUM5VDJveDFETGF5akI1K1h3UXpKWjA0UGtmWkF2UHM9IiwibWFjIjoiMWE0MmE5NzlmNjExZDVhYTc1NWRjYzZjZDY1OWUxNWU2ZWViY2YyZTgyMmU4N2EzNjA0MzRjMDQ4NzViNjc1NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"7bcc2cd7-3a25-408c-82fc-0e8a918424b2\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"777b7aa2-d0f4-4308-98aa-984f7e8844c8\",\"name\":\"Reach Level 50\",\"payout\":0.28},{\"id\":\"1c9d64f3-f27c-4b42-968d-1f76fea38e14\",\"name\":\"Reach Level 100\",\"payout\":0.42},{\"id\":\"76c87669-fd7b-461f-a989-c2019e232586\",\"name\":\"Reach Level 250\",\"payout\":1.3},{\"id\":\"2455157e-2504-40a9-9990-95e072c4b4a8\",\"name\":\"Reach Level 500\",\"payout\":2.6},{\"id\":\"fc8a0736-cfd0-4f24-9ef0-181b125efb24\",\"name\":\"Reach Level 750\",\"payout\":4.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:06'),
(416, '870222-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 6.98, 'https://notik.me/api-redirect?token=eyJpdiI6Ijl1bXpKdEpES3JFNGViVURHMS9hMWc9PSIsInZhbHVlIjoiVHpGSFkrV0JjRnpwWENzQ1l4bERQTW5JUHllTjkzak9QOWhJWTVpV1ZpcWk1TEg2UDdRV09DWDJLY05BOFQvTDlYQ1pGVWMvWmdDUWFoUjVkS0JzQmRzck05NmlLV21BTjFOSzBtWlhHajdhZm9HTmUyc21HUjkrSDRDcGhESkZ6ait5d1habTZaalhnMVpIb3l5TnRTdjVtaWFhVC9CRXhxWjJpRE1GVURlTHRvQ0o4WklEMHdhMzZqYUZzS0ptKzJadUxMSWt4YmFpVzNFUW9vUTh6dklVYnNjcm8yVUF0OEZTOWcvZEROK2psN21manFLWWtxUjI4OWdBSnRJKzBCMG1DRCthcCs5VVRjR1RpTU5ubGlvVXRKOEd2TlU0SjNSNWMyN3hrZnc9IiwibWFjIjoiMzRjYjU2MTAxODliYjZlNzAyYjY2YWIzODAzNjU0YWRhOWZmMDE4YmRjNWE5OGVmYTQ2ZDFmYzhjNmUyYjJmZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, SG', '[{\"id\":\"76cc44d1-d1ed-4450-a171-52cdb0ea405b\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"e7407145-ea30-4ed4-ae0f-85aa2182bc44\",\"name\":\"Reach Level 50\",\"payout\":0.24},{\"id\":\"cde03b78-4762-4790-a3f5-fdef330bfc79\",\"name\":\"Reach Level 100\",\"payout\":0.28},{\"id\":\"954ad671-0d99-4507-ba45-f6b1af19d829\",\"name\":\"Reach Level 250\",\"payout\":0.84},{\"id\":\"8730b4e9-dbbf-4802-bdc1-68c54bd03d3c\",\"name\":\"Reach Level 500\",\"payout\":1.82},{\"id\":\"5eb79293-6832-48c1-87b6-70227fd4e40f\",\"name\":\"Reach Level 750\",\"payout\":3.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:06'),
(417, '870225-lZ2kToJFfVYWxuk6', 'Number Match: Ten Crush Puzzle', '', NULL, 6.62, 'https://notik.me/api-redirect?token=eyJpdiI6IkRSOGhkNDhKNS8rL3orcEgreU5BZXc9PSIsInZhbHVlIjoiVlovSXVyU3NsTU1RWmtQRjlzQzhEQVlJZzJEdWRCNXJzSUxXRnpCWXl4ek8rbmxWcGpYUFpkUjQ0M3V0aVFSL2RSbkNnSEVWNXA5Vm1KbklRNXg5Q1doK1lFVEFiWC8rUWt5T0JobDN1WDNCbXR1U2hxdmU5ZDNlMjNmTzBCUHBsUlErZXV1ZWJKZTBLeTU3dUlVUUFnT1ZkdkgxSU0wSUNIdWVweUZsZlVWZ3VnWVM3VFRwb1c5V0ZRSDcvdHp3QWp1UkQyaFpYQ0xuYjRCYjkvSjB4ZUNoaW52aHQ5R1h4bDZIOUNDOUJYTkllSk1OTjJFVWdadG92L0JHdThBb1ZsTFJ3ZVdHWTBka3dVak5nODZCdFY1dmV6L1VVTENjNjhDRUdOZ08waEE9IiwibWFjIjoiYWY2NmY4MTA1MDQxYjUwOGQzZjhjYTRlMDNiOGU3MTRiNDlkNTMwNjMxMDBjYzgzN2IxMGExMzUyODVmMjBiYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"6f721258-9aaf-4aa1-8eb1-5666bc845076\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"a7823a57-14e9-4591-b02f-098ae4ca3925\",\"name\":\"Reach Level 50\",\"payout\":0.252},{\"id\":\"e4d898a0-2ef9-4426-8aea-db068daadd76\",\"name\":\"Reach Level 100\",\"payout\":0.28},{\"id\":\"bd7c8d02-1b94-4cf2-81d3-a84c8cbdc63c\",\"name\":\"Reach Level 250\",\"payout\":0.868},{\"id\":\"16048f1e-6831-4e5c-a016-f8e5d29b820c\",\"name\":\"Reach Level 500\",\"payout\":1.82},{\"id\":\"bb79c1e5-9041-47f6-839d-27eabc07f46a\",\"name\":\"Reach Level 750\",\"payout\":3.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:50', '2025-02-26 13:11:06'),
(418, '879337-lZ2kToJFfVYWxuk6', 'PokerStars Poker Real Money', '', NULL, 18.00, 'https://notik.me/api-redirect?token=eyJpdiI6Ik41eHBGajBzNHplUzRnKzFUaDhtTHc9PSIsInZhbHVlIjoiMWFhaVdDZ2ZLcFFVUERUVmZkNDNrQy9KL054eU1oaFdXdEhjTldqNEc0ZHhsek9pWkhBWWF4MGQ2T3BiVGtmNVA2L2tuMFB2ZGdCV0c5am5DZ1RUVmtKOUFtZGN6TUJWcXVjOVA1enhVSy9FYXM3M2RXNDB6MGc4eTEvVjJITkRhR1dpSkU4RmE0bDYva3ErMWZBL0lIcmNBMzhsK3hPTWxMWjNIN2VYNXlIOEJzYzlmbEdJNmRRWUROaWtlOTQ0cDlGcUVmVE95UDkzQ01za2QxU1RFdEFsYmdzbWo5TlVpNWFwL0ZZQVN5Sk8rWWdpZVUvbmVUTnEwOGJTMHcrb0t4RnYzMk14cVZBZWF1cEhldjNkdW5CdWhVOU44b0hpVXhRdzQyNHI1LzA9IiwibWFjIjoiNTBhNGEyZmYyN2UxMTQyNTNlMzMzNDg2MWMwZDVlNmNmMzk5Nzc5ZGE0ZTU5ZThmMTQ1MDg1YzU5YTcyZGRkMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(419, '885646-lZ2kToJFfVYWxuk6', 'TriPeaks Solitaire Deluxe 2', '', NULL, 11.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ik4xRUloZFlIZy9IQ2RBdFgzaFRpYnc9PSIsInZhbHVlIjoiQ3NTNk9rRmxNdE50eTNCYU1qc2xJOGo3ejZUSGpidFJ0N2ZKZmthdXVjNVZORlk0cDdGMDZSUDU2QTZJejYzWmlXb293a1ZHNFBramdlTmlDVFh1ZUMyaXFDSGVFWkxNRk9OWEdZdEgyRnpJVjlwcTdrYkRKWmJ0blpPMmJWcVFJWHo0cmJ6UFVBaE9oRk16Ylg4Q0NWblAwN0ZkTWZ6QnVYaXRLMDVMLy9oamNYUzF2MlhONDlOZHBvRUFEbC9vWjRDQ2VUVkE4U29ZNlVLeS9kaVVoVlhzbDdBdUJQSkJORy8xMzR1c3I5UGt3VndlQUIwcURhamtWTmFqNFVHbndHU29GczZjeGJvejBvbXpnOFZaQXN2SlR5RHRFZ3FCNkdjN3dqYk80RG89IiwibWFjIjoiMTE4MmI3NzJjMDA4N2Y5NTlmOTJhYzBlMTAxMzEzMjA3NzljMzNhMzUyZTg1NDhjYjgzNWU0ZTk0NmZkNWJmZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"9bc1cd5c-8efe-11ee-ac19-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"9bc1ec9c-8efe-11ee-9abd-069eb31df495\",\"name\":\"Reach level 11\",\"payout\":0.72},{\"id\":\"9bc1f4c6-8efe-11ee-a7fe-069eb31df495\",\"name\":\"Reach level 26\",\"payout\":2.4},{\"id\":\"9bc1fcc8-8efe-11ee-8f5c-069eb31df495\",\"name\":\"Reach level 51\",\"payout\":3.36},{\"id\":\"9bc203ee-8efe-11ee-922c-069eb31df495\",\"name\":\"Reach level 76\",\"payout\":4.8},{\"id\":\"9096edb0-e329-11ef-b55a-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(420, '896936-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 12.38, 'https://notik.me/api-redirect?token=eyJpdiI6IkVnd2kxaVJBWlRVczczUVcxdTgvL3c9PSIsInZhbHVlIjoiR0tkUzN4VWkvMFY4bmwvc0l0TE5qWDhPTUJ0WVNweHYxUFcwYjNCYUsyb2VQSnl0WVM3LzQ3eDFnOFRsZ3NiTlE1VVJ1eUVhZ3R1ZlhhN3Z1Ukl6cndoYmFXUXBBY0puV1ZyaFNmRXRhQTBNcWlrK2JDdlk5RExiQ0RYRjBPN1VOZWJSRjAyR3RBQ094NGJCbjF0ejFZeGFIZHpUQ1h2ajhFUnFHNUYxWkxiTS93ekFrTnIrTXd2ZXl2aWQ2TjdhRkM3YlRTYjdFcVp1NlVBNERNKzRud25EaHhFSm95RFJXYzRWK3RHL05PREVWd3VlVXZIeWhWOU5XTUR5YXZHeUg0dnZ0emRYd1NlL3lrMmxlNUdTTHc9PSIsIm1hYyI6ImExNTg5Mzc2ZWMzZTg2OTIzZjcyYzgzOWM0MDM2NTIyYTZiYmRhZDVkMTY4OGMxN2Q2NmRjNDliODc3N2U2MDUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, HR, CU, CZ, DM, DO, EC, SV, GR, GT, HN, HU, IL, JM, MY, MX, PA, PY, PE, PL, PT, PR, RO, SA, SK, TH, TR, UY, VE, VN', '[{\"id\":\"d52a198e-a67e-4da0-8fb5-43d788c498c2\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"8974d848-99f0-495c-b3fe-cafe7009544e\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"71bb15ca-eb54-4e5a-8400-7bf5ec4fe147\",\"name\":\"Reach 300 Meters\",\"payout\":0.04},{\"id\":\"b799268e-04bf-43b7-9999-5c5abaa73a0d\",\"name\":\"Reach 500 Meters\",\"payout\":0.14},{\"id\":\"ad39498b-82bf-4668-af4f-d574f43d93ef\",\"name\":\"Reach 1,000 Meters\",\"payout\":1.4},{\"id\":\"453719e3-7777-4b82-ba91-676f8cba49a5\",\"name\":\"Reach 2,000 Meters\",\"payout\":10.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(421, '933725-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 2.21, 'https://notik.me/api-redirect?token=eyJpdiI6InQ3RngxVHU3YTdjWnhsL2xMdFRRalE9PSIsInZhbHVlIjoianNDZE4vY2IyeFBScGtjcW80OWdQdlVyT0tOc01oWmZ4MFpVcFRaUzNOaUlFU1N3VTFwTzI5Zm85MkordEduanhhSjJCVnNwWUxYQnZBTk9XYnR0YkUveDlIMFZMNTZpRzY3c0pQWEd4OXIyd1hQNVJHZkJvUENxMldmSHNUaWd0OS9DZUxURVdScXdUT0o0cmxSYk9YcUVnWXZhZkxkRWV0OWtzTXJqRmxxekhMS0xPK3JmNVRVcHBIR0dTdDlqdFNaWW9XQ2orYVFpQ3FIQ1luOFlGMm5hUW1nRktrT2tRRjBhVXNUVXltM1k2d3dIQ3RRcGVkQ3hMY05ZWjA3L1RtSlBwaUI2WTJpc2hkWndGckpNd3B0YmNGNEtLZG1CN0tXeWhYc3VZRk09IiwibWFjIjoiNzU3MjFmOGE2MjA0ZjMyZjk2ZTU5NjgwOGMwYjhlNjFiZjg5OTg5OWJmMjY2YTkxYzBlY2E4ZDIyYTI5NjE2ZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL, CH', '[{\"id\":\"953ab4c5-c2de-4d3f-a140-9f905719c72a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"51a06f00-f4e8-4c49-97e7-b4a330fdc67d\",\"name\":\"Reach Step 50\",\"payout\":0.036},{\"id\":\"fc2e1d0f-07f4-4f80-aa84-930ff521c3d6\",\"name\":\"Reach Step 100\",\"payout\":0.06},{\"id\":\"49bc85d1-7fe7-45b1-aa23-85a8c673d91e\",\"name\":\"Reach Step 250\",\"payout\":0.252},{\"id\":\"b3ad054b-8c07-49a9-b3f3-06db7caa02fd\",\"name\":\"Reach Step 500\",\"payout\":0.6},{\"id\":\"3bb68ade-6e3b-4bd1-a67b-78bf950ce2b7\",\"name\":\"Reach Step 1000\",\"payout\":1.26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(422, '943210-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 1.41, 'https://notik.me/api-redirect?token=eyJpdiI6IjBiK3hVNjRIUHVwSnMxU3ZrZjkzM0E9PSIsInZhbHVlIjoiUExreC9BN1p0b3lkWmtCMTl6ZklldzlTbFErVDBxa3lTYmliNytXcUhkQlJ0NTZvS0M5aTVrZDNsNnNJWGp0MlpvQlBDQmJlRFQ3QWtOMWFrTDdVYkNHSjh4U2ZDT09Pa2JNR05zVW1ZaUtzcWdVK0tIamgvcWh6U3p3QkwvM3dTK3V3UlljcUYwV2NIK1Q0Q1NFVjcxYXNEZHFwTThhNlk3ZlE3UnM0dkZMRHNjMHhodUdrTHFGb2grZ3VhTTFrcmlUbmh3OVRQczRSRUtXSVJDdEswQXNSbjBzeVVCMUNHdTEwaG1VdVpxREk5ZUJaQTNZSWk0eHBZMnl2ZFF2cUZBSTUwSnZMbGlvUGlBY2grclVGY3R2VklISDNwY1l0elgwQmxKenE4Tms9IiwibWFjIjoiNDNlOWJhOGZiZmM1MTdmYjczOWQyZjVhMDNhM2VlNDM1ODhkYWQ1NDRkYTM2NTcxMmE1MWFjMGFjZjI2ZTI4ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC, EG, GR, HU, SI, TR, VE, VN', '[{\"id\":\"7c47249c-138b-4c85-ad80-f459ad23e944\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"adaf3bb3-2b66-4eec-ace7-bbcde9d503a6\",\"name\":\"Reach Step 50\",\"payout\":0.032},{\"id\":\"f09b8e22-341e-436b-aedf-e4c165e10b81\",\"name\":\"Reach Step 100\",\"payout\":0.048},{\"id\":\"2672077d-3cae-4618-9b9b-2d8974e50a87\",\"name\":\"Reach Step 250\",\"payout\":0.248},{\"id\":\"d9ef6497-d33b-4ec2-816b-0ce0e3065869\",\"name\":\"Reach Step 500\",\"payout\":0.38},{\"id\":\"5edebb8c-5399-4576-b80a-05ef3f641366\",\"name\":\"Reach Step 1000\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(423, '957299-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 4.20, 'https://notik.me/api-redirect?token=eyJpdiI6InZtTCtwbXJlM3RUb1BwbnA0YnJqUWc9PSIsInZhbHVlIjoiL05PZXNnZEY2S0pQSnZXVnJIV3QwUitFZ1BRSG56U0M3TmNoR3VXaGlwU1RmbnpHcWZrZDV0aEY4aUtrZ0xpT0IzVlBNbUVvQnJEVGYzV2NCWTM1VWNSMG5KOEQrNyswQWJhNnJPR0pFZGFhckg0UUtvNDFMU1BoRkpqZGJCSHdzVjNFWjl1bzVQRVh5S1ZLNXRGV3ZhdFlUQWJhQ2VqVTF4OVhkTWYweUM1SDZBMk1pNGJuY282SEFLSENRTnN6Z0d4RE9rcVZPenBlaFAzQWlraWNuNnQ5S0VveGdRSDNJREtrVFlWQXoyM05yaEs1N0RubW1uTEJsVnpoVFliejZ2Y0x3ZzBrVVIyNHYwV2VndmRja3dWblkxZkdUMzQ4NHQ5RHZHZG8rN009IiwibWFjIjoiYjQ2YjBjMjkyNmQxNTU1ZTA5MGEzYzQwNzdlYzIyYTMzMzRkZDE1ZjI4YTA1Mjg4MDBmOTZiNWRiNDJkZjJmZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"ae1d3ecc-17bb-49d6-b80c-94478cf7f466\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"35454c69-cb5f-451d-9425-4c751f9285e3\",\"name\":\"Reach Level 50\",\"payout\":0.14},{\"id\":\"491d72d4-9d80-428d-9203-3aeb7ccaaa24\",\"name\":\"Reach Level 100\",\"payout\":0.12},{\"id\":\"132b7ece-b98f-49f9-8c6b-69325efdf92f\",\"name\":\"Reach Level 250\",\"payout\":0.48},{\"id\":\"5ad17205-131f-4127-b1d4-ac5389e16427\",\"name\":\"Reach Level 500\",\"payout\":1.12},{\"id\":\"50ad343a-4986-4be1-804f-1e08076792c7\",\"name\":\"Reach Level 1,000\",\"payout\":2.34}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(424, '980184-lZ2kToJFfVYWxuk6', 'Pyramid Solitaire Deluxe 2', '', NULL, 11.28, 'https://notik.me/api-redirect?token=eyJpdiI6Ik95VlFidC83VlNrdU9WYnc2L3IxT3c9PSIsInZhbHVlIjoiM3RlMm04T1lVazNRTThXalBsQ2k3MDZzeXJHMFlUWkNzRG0xYXpaaHlZSTA2VXFFa1l2Si9lWkJEWlF1Sm9saCt0dXNVamFhcTc3YXJFS01oVWY0MHNWc0FWaFJKWXpyZzBNV0ZPZzlSd3dMbFp6MEVyeEZuMmRTUHFqc2E4UjgvaEM3RVRLSjQxUlBlbWVCaUpabVpJcmoxV0tDYlBHd3JPUlNBLzNZSGJMY3RMWXB6Y1Q2QWEvd1RUWTg4TVdlUTVzaTVCM2xaZ01ORzF6ZkxGWGlOR3MvdlJ1WmNNdmFTTUhFRWVjSWZqNE1NMVEyZzVTYTVCUVFDS211dEFUWkUrTmRsTlpFTXBqR1FVL3dabDc3bVNRbVZJTjYwd2hENVJXUGt2UWt2T009IiwibWFjIjoiNDI4ZTJkZTAzY2E2YjMyODkxNGVhZWE4OTA4MGI1YjVmYjJiNjdlNDRmY2M3MGFjZTk4YWRhMDM5MzgzYzhjYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"dcc93ea8-a424-11ee-9530-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"dcc94934-a424-11ee-9615-069eb31df495\",\"name\":\"Reach Level 11\",\"payout\":0.72},{\"id\":\"dcc950be-a424-11ee-a021-069eb31df495\",\"name\":\"Reach Level 26\",\"payout\":2.4},{\"id\":\"dcc957da-a424-11ee-b99f-069eb31df495\",\"name\":\"Reach Level 51\",\"payout\":3.6},{\"id\":\"dcc95f00-a424-11ee-90e7-069eb31df495\",\"name\":\"Reach Level 76\",\"payout\":4.56},{\"id\":\"2ff1e5ce-ddbf-11ef-a3ad-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(425, '1012401-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 29.72, 'https://notik.me/api-redirect?token=eyJpdiI6Iksrbk9pMGUxQVFlcEF4T2F0MzBFMXc9PSIsInZhbHVlIjoicHFBVld3dUttRytEWmlxQW1lTi9vZzUreVdWbzIxZFlXYkNQb2QzcVhxdzBGZVFZU1Z6NEhyVmdNalp1YzB3MHJQUmhTdXNXT2hxemJLczVUNWg4azF2dHlYeWl5U2ZPazlqRVpjay9nZlpyOEwwR0pHZFE5OWtRZFRpZXNGbFFxbnFkZVREeWptTFdIekU0MTVjcFNPdy8ycDBtWHNIWVdGOXA0WXk1b09aNHRsWVQvdkxPeDRmVVdsek1DU1pHb1NOM0lpTFZNM0FjM25WQ3RLRWhrdlZUajUrUnVvZld2NnNnNEhxUWVFWjZLUnpnMmZPNy9XbHBtZVc4aCtrOTZjOHNaRkhtVURoekxEODR5emErSHRETytYNnhMdFhRaHMzV1RYZVhKZU09IiwibWFjIjoiMjI0MjhjODEwMGYxODQxOTFmYzYxMzJiOTBhMmU5MDdlNjY3Mjc1YWMxNmMzNDIwMmQ2YWZiOWFjNGM0NDdiMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"57e9b803-3942-4e9d-b6c7-e8f768d6fa2e\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"db29fc26-50d7-4380-afcb-dd5fd985b6b0\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"1a8c150a-1778-427a-95b7-55cf551b2086\",\"name\":\"Reach 500 Meters\",\"payout\":0.32},{\"id\":\"f0fd54d0-10c4-4072-9dc5-488288a4de19\",\"name\":\"Reach 700 Meters\",\"payout\":3.4},{\"id\":\"dac3e86e-3762-464b-98e4-df21a626b25a\",\"name\":\"Reach 900 Meters\",\"payout\":6},{\"id\":\"e608316b-0d8f-4c40-a062-45abf63ea8c2\",\"name\":\"Reach 1,000 Meters\",\"payout\":20}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(426, '1031122-lZ2kToJFfVYWxuk6', 'Park Ultimate 3D', '', NULL, 10.49, 'https://notik.me/api-redirect?token=eyJpdiI6IndRZFhoN3Z5L3hyaTB2Z05VdHd1dmc9PSIsInZhbHVlIjoiT2hFeThvT3ViUW50b0hCZTBEcittZDlGbjFNL2NHSldQQ3Z3dFNURm53SFpJbUhIc0xZVmwwOWlxd0pIcXJUOU1QeWFMYnZ0ZjM2cmd4c2hHZWhJdEdxTVdXTThDQXpJNmplMXZzNFJGdS9qeVRBUXkrZnFVZHpiQmlXcnB6YkcyYVRNblZJV2oySlFvNkpPZ3BGbjR0Nkg5ZCs3a1ZTVE4rekpCbGgySCtEVzZGUWk5RVpteDAxdm9jWnluYStBZ1pSQVFSenFTNXN2R2krUWthY2xsNTE5NldWL0lFMFBIcXByUERUVTgwNUxrRG9aS0UyT0lOUTVLelMzWTlCZFZsWDMvdlZzSjM3V2pTQW9ZVnpLZ0Zjemt3MkVlTVFkUFhXMW04eHhXeTA9IiwibWFjIjoiNWY2YTE4MzczZDc2NjE4MjNjMTMyOTU1MTAyNGJkM2ZiZmZkYTYyN2ZhOWFjMmI3N2JlYmIyNmM3MWQ5NDdmMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"639b919c-b956-11ee-a445-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"639baa6a-b956-11ee-a75d-069eb31df495\",\"name\":\"Collect 2,000 Coins\",\"payout\":0.132},{\"id\":\"639bb230-b956-11ee-a3e1-069eb31df495\",\"name\":\"Collect 15,000 Coins\",\"payout\":0.756},{\"id\":\"639bba0a-b956-11ee-a866-069eb31df495\",\"name\":\"Collect 200,000 Coins\",\"payout\":9.6},{\"id\":\"1c9dc064-e324-11ef-9bc3-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(427, '1035971-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 12.43, 'https://notik.me/api-redirect?token=eyJpdiI6IkFKL2EvUW9ObWt5VXVYcDZCd216V1E9PSIsInZhbHVlIjoiRk1VZ1J1T1Yra3N4dDJGcjlGdVpDOS9DZHZ6eVIrNnRVRlB5NnkxVHozRkUzSTZQc1Z1d2tqS1AycHdjb3ZmdkhIZkVNV2t1Zjdta1VsNGVFZkhoZU56c3ZvdEZsbEdjMjc3b1R2NVI2QklVOVpBa2kzeFlzNE5LRlRBVmNLeHZzeXhLZ2E0dUdlWW1jS0R3Z0pKVVFrajVSalZneENLQnA1WWswVm82bzZNUzBLS1AvZ0ZnQll1YXlSNDkzbC9PU2Fwc3NwYjYyVGJhcVRHNU9PWFp3U05CZ1lxaGRHcmR4UW9idWNGaWdPbjRrMVBaN05YeEVRbzJaTThQWDgvaGhlYXJTbWt5VGd0eVhSeTdSZmIzOXc9PSIsIm1hYyI6IjkwNmI3MzU0YmRiMTA2OGMwNjNjYWRkNGU0MzBkMTczMGI3MjZkZmQ5NTdkNTFhZmI0Y2RlMGIyYjdjYzlmYzYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, JP, KR, GB', '[{\"id\":\"433a5e90-1ea8-4820-af9a-fbd4b2b75a4a\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"bff85dde-d32c-42e5-917d-b82c93c18ec1\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"248fbbe5-9afb-4070-acc7-8c6921c75fec\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"3bc894ec-c997-49ca-80b0-fcc7c9d1288e\",\"name\":\"Reach 600 Meters\",\"payout\":1.2},{\"id\":\"1803cde7-f073-4b16-af70-0101fee7a0ea\",\"name\":\"Reach 900 Meters\",\"payout\":2},{\"id\":\"d2f2a635-bd3e-4b8b-b2c5-4797cac04d36\",\"name\":\"Reach 1,500 Meters\",\"payout\":9.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(428, '1035977-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 5.63, 'https://notik.me/api-redirect?token=eyJpdiI6IlI3b2F4L092WTdQRm15elZkV3BzdHc9PSIsInZhbHVlIjoiVEZRTzEydjBYSnZLS0hCdExEWmVZSHVFQ1RyZEN4Vjc0Tkh3ZGQ1NUliTERjSzJKUThtRzFKL2sxajRxSGRGLy9yTWRsQjh4QUdlNTVEME5zeXlVQ0ZmQkg4cktveHE3TUdlL3hpWE1sckpMQmJqc21taFNxYWlySjdZMkc2clRQV0RsOTdiMXg0WWRTTWJidEsydTQ4WkxERmFnaDhRYnZrdGNXOGtUWGxPck8yaGUzRDcxOEJPSURTSHBKc1l0Y2lDQStnYkVTTGgyZ2JUdjA2U3pYdHNEb3h2VmRENHVxTk1EN0czdE9idmg0U29GcWRXV1F5VnVHMStsYTBKdGF6MTUyL2F2SlJNbHhuYnJ5MTRlV2c9PSIsIm1hYyI6IjVlZTNiYjNhMDY1Zjc1MjdhOTJmZjBjN2FjY2MzYTUyNGU2ZDYzODZlMGU1YWY1ZDQ4YTZjNDIwNGMzMDU0MmQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, FR, IT, NL, NZ, NO, SG, CH, AE', '[{\"id\":\"c6fe1cf9-6292-4954-bfef-85e127ef4651\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"df1982f3-2372-4434-9b23-44db608dc92b\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"963def98-1418-412a-827e-a8d44e12fdf7\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"9c7e7b2f-aeb1-42ac-ab27-fe06cab431d9\",\"name\":\"Reach 600 Meters\",\"payout\":0.8},{\"id\":\"df38338d-12c0-4a57-9ff0-63ab7c9b6ed6\",\"name\":\"Reach 900 Meters\",\"payout\":1.2},{\"id\":\"83d509ab-6b1f-42d4-8cc0-8a0fd00cc094\",\"name\":\"Reach 1,500 Meters\",\"payout\":3.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06');
INSERT INTO `offers` VALUES
(429, '1035984-lZ2kToJFfVYWxuk6', 'River Rush', '', NULL, 6.22, 'https://notik.me/api-redirect?token=eyJpdiI6Ikl3T3IzdUE4ZVBoc2tmU0twU0U2M3c9PSIsInZhbHVlIjoiZGVaaFZYMmFFNTVUdnB3d0ZwYlhLMmZRQ1lSTmtDdFBhS0Y0M0pMemhNT0ZlbmozRTdQWXU5WUZsMWh1Wm9vY2YwSWJuMWkyNWhmZ1ZtM0ZOMzN0KzlJUGdtak4yNkJCRGNEcXQ4TWppQ2xZa2ZyblJPMmZkWU0rR1NMb1BBZk0vdVF0cDNnejE2QlNmVXFMSlNETWdabmdUYzJpKzF3eEV2NkJuSGZ5bXE0NVI0RXNRSTVjdXBVdFR4OXdTdGQyUXZ5blE2TGQ3SkhiZUxKd21PdkxTTWVhYVFNbkFpMFVhNDlGSGdTNFNFSlYrMXl0a2pNYngwaWhmaFRkb2g2N2dCT1hLdnZVWGFuazYyb3I0ckVBTUE9PSIsIm1hYyI6IjIyOTM1NDdmZjc0NDVhOWUwOWU0ZGZmMGY1NmY5NjA2YjA4MTlmNTUwZGNjMTM3MzI2ZGMxYzhlZDM1ODk4Y2QiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, HR, CU, CZ, DM, DO, EC, SV, GR, GT, HN, HU, IL, JM, MY, MX, PA, PY, PE, PL, PT, PR, RO, SA, SK, TH, TR, UY, VE, VN', '[{\"id\":\"4a8566a2-a7d9-450d-bb44-831ef2400041\",\"name\":\"Play River Rush!\",\"payout\":0},{\"id\":\"0f1b59c1-027d-445d-a376-5cb15f06b621\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"6daf6e9d-0824-4595-92e9-f5bed7d4593c\",\"name\":\"Reach 300 Meters\",\"payout\":0.02},{\"id\":\"7ebb8d46-a7c0-4a76-9c33-16ce88ed3874\",\"name\":\"Reach 600 Meters\",\"payout\":0.72},{\"id\":\"33640d2f-f9af-4c8a-a57d-e1f36477bf80\",\"name\":\"Reach 900 Meters\",\"payout\":1.08},{\"id\":\"a00d586c-f233-4186-90df-eec34ef42fc1\",\"name\":\"Reach 1,500 Meters\",\"payout\":4.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(430, '1041621-lZ2kToJFfVYWxuk6', 'Iron Dome', '', NULL, 13.30, 'https://notik.me/api-redirect?token=eyJpdiI6IktFZDYvd256RytYY3hhMGtPM0lzTUE9PSIsInZhbHVlIjoiNTgxdjYzYXdRSGYzaUhnU3VuWG5xZUdTSmdTaDU2QjJNN3ZabGNQOXZaQjFnQk5BOFJRVmZLbGlJNmtmNWhPQWx5a1J1NEdydm44SmZSSnppQ3RlbnY3UWZTU1lZOFlka2VVUk8zb3h2Y3V6b3N6eEcrVmJCUGU3c1hHbS9hTXJadm8wMkpiVW9Jdi9FZWwwM1RCUWNVa3d0VnJGWHJpbFNldlRiVVJYdlYrMXFhb1NLYWZMZlpySG11OFh4bmtMMzJkcmJpWUI3UTFGUXVYL09wVnFiVlV1VEpqb3hCQ2xuSDl3NkYrcmRjcWpxbHNyTDdlczZSNlJwUXRPekZmRC9nTUVTZXJWTDR0MitUVlZhdzE5dGc9PSIsIm1hYyI6ImIxZmYwYWNmZDVmMWYzYWIwYTFmYjI1Y2ZkYjNjM2VkYjhkNjY4NjZmZWIzZjA0Y2Y0ZTM0ZjkwZTI1MWUxMmEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, JP, KR, GB', '[{\"id\":\"b80f0c44-16c5-4cee-a4f5-735965d0563b\",\"name\":\"Play Iron Dome!\",\"payout\":0},{\"id\":\"c4d9c7db-2449-43f8-b7c2-d9ffd80f8a86\",\"name\":\"Reach Level 10\",\"payout\":0.004},{\"id\":\"d478ef22-cca9-4240-9226-9d6ef329da8d\",\"name\":\"Reach Level 30\",\"payout\":0.02},{\"id\":\"7483a199-249d-4f72-942e-a2af1c06fbbb\",\"name\":\"Reach Level 50\",\"payout\":0.88},{\"id\":\"96091184-98bc-41eb-b022-0ff2dece6f1b\",\"name\":\"Reach Level 100\",\"payout\":1.6},{\"id\":\"45821d85-639e-4c03-9ec6-7744fec6a5fb\",\"name\":\"Reach Level 150\",\"payout\":10.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(431, '1045898-lZ2kToJFfVYWxuk6', '2248: Number Puzzle Game', '', NULL, 4.20, 'https://notik.me/api-redirect?token=eyJpdiI6Ii85N3FLZ0R4dWpYUnVFWk4wUHQwR1E9PSIsInZhbHVlIjoiRVVqcHNsMHlaclRhYVFHdUw1djNZbUw3RUtwZTNuRUVHdlQwT29WajlrcThXb2JHUVdDbUhlZTB1bjNsU2dYelVHekJzNk5wMFdoWmxybnAwVnBBUzdsSGdhRGFpNVVpVk1wcGRVdjVuTGFYZEpSYlFoNUdPVUhQUklVdUV0a1pWNGVNcXBtS1BmRXVjZFIyUGhXQjFuNGdFY2FPNlk4Qi9xcVlaTldmdTN1bUFONm5YK1Z5VTZkb1RtbXVoMGhxWUZOZlR0NStNOTlEZlkwRWxNSXhnZTlNeG9jYWV1d3lyNDQ3TmczQkk4cnNtTW9uL1dEL21EN3pGQjZGeEprWWFqVjJ6bGFpMDZyT250SHk5MGZjL3hObGhyVlNNYmlUT3JweXFDWnZ0OXc9IiwibWFjIjoiZDdhMTQ2OWIxOGFiNmMxZTIzMjA1NDE0OTNlMDY2ZjdmNjMyMmU3Y2VkMDE5ODZjYzYwMWEyMGE5MWU5YTE5MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, SG', '[{\"id\":\"189b6980-4dbd-453a-985d-5ef70dc6d4f5\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"a99a8f4b-4c8c-4dbd-b788-4a225c0be729\",\"name\":\"Reach Step 200\",\"payout\":4.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(432, '1062158-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 76.56, 'https://notik.me/api-redirect?token=eyJpdiI6Inl5eWplUmZvdW5IY2tWazhJeERXSXc9PSIsInZhbHVlIjoieUJDY3dVa2tkUTBOWHhEVEpqQzJ4Tm8wQWIrb0hFdFFnU1ExY2FLQW1JRXYrTHdQVU1lcDFTVUFLRDFGNmJsY1ZHTFJLLzZxQlg3TmYySjBCYkR4OG5MSFg1bjY4Q0tRVzk1T0FNYUNWa2dHZy9tcFA4MkRWMjFCVzc1bkFtOWRMRFlKVFFNVU9mczQ4aXU5UFJkVTUzWGs3dTdJR25CdkJ5YVJSanJZb1pwMTIzczMzRzdBd2tYanNlYmgrT2xpTEdjdmZzUTh3SVYvVW55VWd6MFU5eDNaYkx2blh5TWNHOUFHdXhuTmUrbzJPRGhxai9SZmVGSGNmT3Rpa0JpSTVjV1BMRkw4R1JoMHJ6cFZNT2dzYmc9PSIsIm1hYyI6ImVlM2YwOWNhYWNiMjliNzNmMzYyZWQ1YjJjNmRjNjdkOGIxNzMxMWQ4MDExMjZkMDdkMmNhN2Q1Yzk5MWIzZWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"5054c90b-0609-4200-aa06-ef694caa7dcd\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"ab7424f4-3a54-4abb-b927-bf84b4ed652a\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"c87d4f05-82bf-4ba4-be29-399dfedeaa5c\",\"name\":\"Reach 500 Meters\",\"payout\":0.08},{\"id\":\"7d6abfe8-9e96-4dc6-a423-4c71d804c4d8\",\"name\":\"Reach 1,000 Meters\",\"payout\":13.6},{\"id\":\"eee159e2-9fad-42bb-891a-b62ea194068a\",\"name\":\"Reach 2,000 Meters\",\"payout\":20},{\"id\":\"06a8e786-8b44-463b-8206-9501d54293d0\",\"name\":\"Reach 5,000 Meters\",\"payout\":42.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(433, '1062167-lZ2kToJFfVYWxuk6', 'Grab a Toy', '', NULL, 53.30, 'https://notik.me/api-redirect?token=eyJpdiI6InVRTzExelZzQ3dKdHdxalZ3cTJvZ3c9PSIsInZhbHVlIjoiakxEeXh4RmZhTlJuVHZlNTVpR0tsbitMR0VTZTFkVmhEZU1QZmFOSjRnR2lsMDNlL09ORFFIaWtNV01xcGxVMnIxY2w2YWZQMmJ2ZnRmc0xVa0h2RCtqWGZLWVZtTHZ1ODR0VEN1YzcyQ2xxeXRZQi9oMVAwY0J4cVlEQmVCZ3RSeUxIR21tVno1eEY3Q3Z1eEVUYlpyd0VHT2wrUm9ZY25sSTAvMng1bTVDMStMTjFVWERQT0Q0OTJScnhOQTMrdm43Yms5MTJYS3V5MzlQa0lPdmFSV0gvZGozT05mY25zSjhmZXpYN2VNZ1h5dmFIWk8yMXBwaGhsMUxSS3g4UlF3SFhBS01peGx1RjREVzZlN3lhZUE9PSIsIm1hYyI6ImFiMjBkZjk1MWQ1YTAxZWY0NDU5MzZhNzA5NGQyNjZmOGUxODVhZTgzZGZhMDFkZDAzMGQ5ZWRkNTdjMTdiNmMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"1399ee3e-08f0-414c-964e-3704ff6da6a5\",\"name\":\"Play Grab a Toy!\",\"payout\":0},{\"id\":\"9386dc8b-36a9-4aba-913e-b0dd1c34d5c1\",\"name\":\"Reach 100 Meters\",\"payout\":0.004},{\"id\":\"54840523-c4fc-4a98-aa3e-ecb0f0a50898\",\"name\":\"Reach 500 Meters\",\"payout\":0.1},{\"id\":\"89b8d64f-8367-4f13-8666-fd479fec57c2\",\"name\":\"Reach 1,000 Meters\",\"payout\":10},{\"id\":\"31fa4879-2c23-473b-bc69-798ace0efc91\",\"name\":\"Reach 2,000 Meters\",\"payout\":13.2},{\"id\":\"f1a345f6-36ec-45b3-9a39-90f89e0b9128\",\"name\":\"Reach 5,000 Meters\",\"payout\":30}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(434, '1071272-lZ2kToJFfVYWxuk6', 'Magnet Miner', '', NULL, 19.53, 'https://notik.me/api-redirect?token=eyJpdiI6IjhEdk4rYVBuS2tXUEhlVDZZc0hsbXc9PSIsInZhbHVlIjoiU3MreGVjQitnL3cycnpuVXlZYjZDOUhZcExPUmtsVGI3OGEwaTJnK2NBM09CWGNlT1YzVHFRYllUeDlOQ1dCRVV2STd0TEJZbXpXMHp4bkRIVEJsRGEwcWkxVFFtcXhxL1Nvb1FCVytlei92dDFseVRheHhMZERxMktGQUtvVzZSVVAvVlBBdTdvQnlUempXYWpsYUhjV1dPL0IyenpTK05MZGNJM3FRSE9Mam1TSU9mQ3crU1lXWnlaRjVCd0o5c1NNam9YbFJkaWdMSG10U2gvUmoxZVJpbFJlVXBqcjA5N2JTWmtyOGpQMEtRbDBKT0hCK0ZLTk1neXJqOHJjaloveERTSTJiRk1HTE1qOXhQeXZxZGJNUTI4c01MMHREZXBGUUtSQXZlSk09IiwibWFjIjoiMjJiYjJmY2FiZjgzZjk5OWEwOTBhYWRiNWEwNTFiZDVlMTk3NDgwNzM5NzJjOTJlYzA5NDE0ZTIxNDMxMmFhYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"2acaa1b5-023d-4c7c-a734-45cfe246592a\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"3908616b-c9ab-467d-9316-4a1efa0ee8ce\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"909253ea-8a72-4065-aad9-48f84d1578c2\",\"name\":\"Reach 550 Meters\",\"payout\":0.32},{\"id\":\"3797107b-4fd1-448f-9638-d3163d31cf39\",\"name\":\"Reach 700 Meters\",\"payout\":2},{\"id\":\"cd3bd743-da80-4610-aefe-b08ffb0a108d\",\"name\":\"Reach 900 Meters\",\"payout\":3.2},{\"id\":\"196f410c-7896-49c2-9424-c428105231b7\",\"name\":\"Reach 1,200 Meters\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(435, '1078422-lZ2kToJFfVYWxuk6', 'Logicross: Crossword Puzzle', '', NULL, 4.85, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9YWk8yL1FuZ21oaTFhN0t4Y1FwRHc9PSIsInZhbHVlIjoiTWl3NnhiekFJUHZOSERmeWV3L2N1TlNoclUwb3J2N1YraGNDWGtDc3ovZjNzK1Q3bVlWYTNqOGRaSi9OQ3VZSlhhRSt5d2pBN2lycDA3Y2hBQXJDVjdpYnJRN0E3MVdxd29xWk1LT2RMMm5sNGdPVFdDZk1mRUdWSnVaYVdhVVVRdXBrS2tvK3o1YVNuQm04SmRTSnFpK0wwOGZ1enFZRmZwb2hjaXNpRVBZTmVlbHlBUHY4aFdPTVFhT1U5cER6dmpzNHBWOGI3dFZ6amdNTWN2NWhPRmZES2JvVFlJNnEvT1FaQ2w2QnQrbXpPWkhYcE15cmREdy93c2IwWUVyUFdUUy83ZFhlTEhpRHp2UnhiM1VhQ09VWkRaaUhZT1pjQk44SEpOVE5sNzQ9IiwibWFjIjoiZjFkNjg1ODQ3YmQ4MTg0ZTE2ZGIxZDVhODZhNGM3NmIyNzg4MmUwNmU1NTQ0ZTJmYjQ1NTYzNmEwZjYzMzA0MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, IE, NL, NO, SE', '[{\"id\":\"7d42e3c4-a51b-449e-9af6-cc9a762a0294\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f060711c-1634-4b42-b768-7ce16448afb3\",\"name\":\"Reach Level 50\",\"payout\":0.068},{\"id\":\"f107afe8-f394-41d4-bf82-7589d8ccfc6e\",\"name\":\"Reach Level 100\",\"payout\":0.088},{\"id\":\"59dbca2a-4e34-488e-b246-c8b8e55d85fc\",\"name\":\"Reach Level 250\",\"payout\":0.336},{\"id\":\"848cade8-360b-4f4b-89d3-f76bb8890667\",\"name\":\"Reach Level 500\",\"payout\":0.64},{\"id\":\"b73c5575-2c9a-4ed8-9985-569fcfa1d57b\",\"name\":\"Reach Level 1,000\",\"payout\":1.2},{\"id\":\"9d34d8b0-52a8-47af-80be-a38c212a9f13\",\"name\":\"Reach Level 2,000\",\"payout\":2.52}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(436, '1086199-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 45.23, 'https://notik.me/api-redirect?token=eyJpdiI6IkZvenI2V1A3bWEyazhFYk9IdXovMXc9PSIsInZhbHVlIjoiQ3laM0hIWGswQ3VBK2c5TGpVMlMwRVR1dDA2ZHc4UTNhRkF0MjN6K0pEUjdTRkVwK3l5RE1HT3FTS29GcTlwWGcrRHYyczBkSkZYeGo1QjFMSURxSUREQ3haTG1vazBDZVY1QmlJOTdaK2pWai84WGZwNWFLemVRaGZDQmQ1Y244ekhQWGZJbEs0a1BIdjZDcGQzTVJLZjhlTDZ5dHN1QnlIeHVISUZFTmY3Ky93RURybzJaUTdiSzFzeFlReWNoZFNkZ1M0QmxPNkY2K2JVZjJxN2VxcVhOZk14WEF3WStsaHVIcEtTSzNFMnJIbTBIcnhlb3dLcnV1T2M2djU3TFdLWTJCNWZndkJsV3M1Z0twSXR6bGZhSDZSdUpocWZwYmdrSUptOVdNbDA9IiwibWFjIjoiMWUxNmE4NmU5M2NkNjBhMWNjNmY0YjQxMzRlZjBiNzlkYWM1MjhiZDI0YThiZjE4ZTE2ZWQ2MTYwYWRiYzNlZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"3d135290-9850-4ac6-b4b7-2f0faae4069b\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"2fc133d0-aa4f-4344-adbc-e01b8d599ead\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"188c2cfd-cdbe-4ae8-8371-c10c8448b513\",\"name\":\"Reach 550 Meters\",\"payout\":0.02},{\"id\":\"8173c962-87ca-4ac9-9f51-bac8b96bb02e\",\"name\":\"Reach 1,000 Meters\",\"payout\":4},{\"id\":\"dec33485-1f72-47c3-a90f-77db29352fe4\",\"name\":\"Reach 2,000 Meters\",\"payout\":15.2},{\"id\":\"ad513c77-d9d6-44f4-ac30-d1585475b50b\",\"name\":\"Reach 5,000 Meters\",\"payout\":26}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(437, '1086206-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 24.75, 'https://notik.me/api-redirect?token=eyJpdiI6IlVVOVBTbzRvRkpXTmduQnN6cis1Z2c9PSIsInZhbHVlIjoiem9JRUoweFYxYlVVaG9OVG5Gc2JYKzJ1cTM2QWsvaStaUm84OGxQZ2FFbWtlamxoRkRhUGo0NnBUSkZDWmNycGNtMzV6V09kZ0hFQjRneEJQT3Baenhldm9KQ3N2S2tyQk1ma1I3WnZUTmJuYVJHNER4N0FacnpoR3V3dXkwbmpFQTFaRHBlM2pQc0swWUtxdlFmeG94UDVhc3I2UzF5N2lBM0ZsSnJEdERQbHJjb0dvUUg5ejU0ckZCZUl6RFAxNEFLR2F6blhsVGxUUFY2MzI4c1J5N2lVaUV5M2F0SkF3UVZ5bkxBV01pVWdya1NZcVVYYTZCYytqYmZkZmgxcU5QTXZ2b1cyZHJSOFlleHZPalBLYkw0bTcxK1dLTkFoNVVFL0FPWitTbGs9IiwibWFjIjoiZjkzYWM0NmMyMTk0ZGViOGZhOWRjNjVlMDljN2Y5ZTFiM2ZlMGVlYWNiNDZjYzZkZjQ5ZjdmZDc4MTFhM2ZjOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"7bf943a7-f1c5-4885-91dc-d3dab974b707\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"4b1c77ff-cc50-4ed9-91d7-28c0af4a2b52\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"30df5109-e49a-4768-93b1-3afcd071519b\",\"name\":\"Reach 550 Meters\",\"payout\":0.02},{\"id\":\"45dfc449-9edd-43d9-a1ea-b6fbbbe5da76\",\"name\":\"Reach 1,000 Meters\",\"payout\":2.32},{\"id\":\"dc84cfd3-b127-47b6-85be-e03c968c33b7\",\"name\":\"Reach 2,000 Meters\",\"payout\":8.4},{\"id\":\"3c4643b0-d205-40fd-b33c-a7cd498b9e37\",\"name\":\"Reach 5,000 Meters\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(438, '1086235-lZ2kToJFfVYWxuk6', 'Wishing Well', '', NULL, 18.23, 'https://notik.me/api-redirect?token=eyJpdiI6Ijc4U2Z6K3FjWXFYV1ZpSlo4dlRYSGc9PSIsInZhbHVlIjoiWmFxdkNmbU1FNXFBMFAxRENaYTZrcERZZVhuRVUzTE04QzVrVnNaZ1BOOUFGcG9qbDdxdzF5M3VUV3ZHang1M1ZCb3F4emZJVURNUlpZMnFzZkhaYlNyVjNYVWREWXBuK3NHeWRDTjhrckFSMHZ6UXdvWFg3aDNRRUNuaGdEVW5VQ25sZWNMOWtGQisvVGZtbmdYaFZUWDI3L3IvR1BGcnVFUVBUMXFKOXc3cEpnVTVaTlNaQnF1TzFjTnVkSStwcFRFajJDOWxMaG5XV25FQmlBNEVuZ0hWVTFRZjNudDgrMk5wSGJzT21qUTRrQVU2K2ZhYUJ4YjA4U2FnOXhoL0cxRWZ4MmVDdjZVWkp0cFZkekE4c0Rnb0RubnFpMjBmOGtMMU8rZnk4T1k9IiwibWFjIjoiNDhhMzM5MTA2M2Q1NGFmMjIzM2YxODA3NDA1MzE1NTAwZjk1M2ZjMzQ4NTEzZDNlNjA5YjM2MmMyNzQ3MjRmOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BZ, BO, BR, CL, CO, CR, CU, DM, DO, EC, SV, GT, HN, JM, MY, MX, NO, PA, PY, PE, PL, PR, CH, TR, UY, VE, VN', '[{\"id\":\"e32f1be2-5dc4-4bc3-b926-048dcc6cf3d7\",\"name\":\"Play Wishing Well\",\"payout\":0},{\"id\":\"c39beac4-e552-4cfa-96b4-e15c6686cba6\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"8d3fcd70-c3b6-4a5d-b45a-b52a569903b3\",\"name\":\"Reach 550 Meters\",\"payout\":0.02},{\"id\":\"af53d46c-a6da-48b7-9408-2dc616b80285\",\"name\":\"Reach 1,000 Meters\",\"payout\":1},{\"id\":\"f968c026-1d96-46e6-8fc3-8afd285c2cd3\",\"name\":\"Reach 2,000 Meters\",\"payout\":6},{\"id\":\"a05d45b3-d14a-477d-8ca8-41fcb08cc06b\",\"name\":\"Reach 5,000 Meters\",\"payout\":11.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(439, '1104076-lZ2kToJFfVYWxuk6', 'Magnet Miner Winter Edition', '', NULL, 19.61, 'https://notik.me/api-redirect?token=eyJpdiI6ImVGTERDbWRuTFY5U2lhcTcyTmx2VGc9PSIsInZhbHVlIjoiOVd3T0cyajJ3MGhNUG9MN0pzOGZtSFR4OGl2dnd0dml4YVVTdUVhT1dtMVJReU5NU0RVZXNsZmZkRk9SWm90aHkvOUV1SXhQWVo4NGp5M3ZmWm9IMFlFNzQ5dzRrYk53SjZJWWQyTUMvZWIyN1FER2FKcC9oR1JHZEozTlVTTFhheldqNW4wczVTY0p3L3JMaXo1OWNlazVQT3d2T3hWb0UzUHpBVlVGTDFPWDRHR0Q3c2F1WmE5YmZHYzFGbVlUWDhjSzFDN1pmM2wxelp1UTZrNW1nTWNMTVVTbUJES09OVmRhSjhPODg2MEE4ejZ0Z2dnbWFjWXBEWXhUdjVkUEZTTFo2TmZnMC93NWNWZTNxUTA5dkIwWGxVTlQ5ZS9jTFBNdEdzMC9xZDQ9IiwibWFjIjoiY2Y2YWU5MDQ0NGQzYzhmZmEzZjJlNzUzZjY5ZDk0MzMyMDJmODQ3ZjljZTBhODZjOTFjNmE3OGZlZmI2MTliYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, IT, NZ, ES, AE', '[{\"id\":\"046b18d9-44a8-42c4-a32d-781c5ac583c8\",\"name\":\"Play Magnet Miner !\",\"payout\":0},{\"id\":\"458ddc94-e9e4-4737-b965-ff58aafce64d\",\"name\":\"Reach 100 Meters\",\"payout\":0.008},{\"id\":\"702ac91c-5dc1-476f-b1d4-5fe17263fba3\",\"name\":\"Reach 500 Meters\",\"payout\":0.4},{\"id\":\"8c66dcee-e46b-4d8b-85d7-63228e00f0d2\",\"name\":\"Reach 700 Meters\",\"payout\":2},{\"id\":\"0803ea01-d095-4697-95e6-daeb329533c8\",\"name\":\"Reach 900 Meters\",\"payout\":3.2},{\"id\":\"d03840fc-e4c7-4a61-8d9e-0f45b1e5235b\",\"name\":\"Reach 1,000 Meters\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(440, '1104111-lZ2kToJFfVYWxuk6', 'Weed Attack', '', NULL, 11.43, 'https://notik.me/api-redirect?token=eyJpdiI6Imx3ZjN0TjZYV0liT0RtV0l1WWR6aUE9PSIsInZhbHVlIjoidTUzcVBGeERxRHRvSC81TDUzekdhQytydEhLb2h1My9zM1pZRkFYZVI4aHZqcXJ2dy9HQlN1aWFIZzNGYWVNbGFsN0RhRVAzSi9NZU81UG0yVFg2NXVkYVFaekxXQmN4RXZHcjhTSkM1QVh6NGVLOEhRNzJSbkgzcWo3cGdRS2JDKzBCNG9RR2JNM1pKYUhuUWlsV21nR1VUUC90L0RkYW1FNmZhcEk3REV2OXFaQlJUVEFyNkRoRnltdW1UaytsRlVhNlQ5SDZjNE5CcUhCR1lxQUx0TEN1LzBaemRpWGZwRStpTnB2c2ZGTHZ3ekVzZS94U0U1bE52VDBoUnRVMXF2Rmd0ZjN3SUN1ZXNhSjRUOUpMZFE9PSIsIm1hYyI6ImM3YzllZmExNTc2YjcwY2MxNmZhZDc5ZmZiYjg0YmY4NzUzY2FlM2E3NDQ0NGIxNzk4NjhiMjhhNmRkZWZlMTUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[{\"id\":\"5979d2ea-b5c7-413a-88d5-6be25fd95571\",\"name\":\"Play Weed Attack!\",\"payout\":0},{\"id\":\"b860ba17-4d3b-40b1-b612-77b2cbfc2e4c\",\"name\":\"Reach 2 skins\",\"payout\":0.008},{\"id\":\"8d96d70e-c531-4596-b027-415cf3644a43\",\"name\":\"Reach 6 skins\",\"payout\":0.02},{\"id\":\"34d6afcd-809d-441d-8166-682212b71139\",\"name\":\"Reach 10 skins\",\"payout\":0.2},{\"id\":\"55a3fc73-3652-435a-b225-24190409452a\",\"name\":\"Reach 15 skins\",\"payout\":1.6},{\"id\":\"0a98e5fd-eaa4-4bf2-9286-cc1dee9727fa\",\"name\":\"Reach 19 skins\",\"payout\":9.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(441, '1104113-lZ2kToJFfVYWxuk6', 'Weed Attack', '', NULL, 9.31, 'https://notik.me/api-redirect?token=eyJpdiI6Ino0Q0Q1Uk9sQXUyalJjN2JBT0RRTlE9PSIsInZhbHVlIjoiejRFTlJsWmFSZGZMUEdiaVg0V2xvbVdIQUtPekg1K3VmL1hXczlqYXczVUFXVjZDZlFrdzhXc3lvTUpmR21BUmNyYUlESTlEWGVPK1g5MEV5cmZXTGNQbUFGZG1TMElGNXI5UHRrd2dDVGRpclVpRXMvRUVLTkFvdldCeDVONUFNaDBmcUxsM3Q3NkpnY0xhSjdSS2k1L1F0akRua08zK3k5RVdzMzhybWtqTUFhSkZ5eDkwSGkzd051aWtGYTI0WEplWllRWWRpOERCZ3lGSzFvY2M4MCtHMW5Pb3B3bHI4NFRXK241Y2hsc0tkMUtvREZTMmEvVzVnQ084S0xzS1JwK1E5clczT2tyemFuVXN4Z1N6bWc9PSIsIm1hYyI6Ijc0MWUyOTllMjJmYWJjZDg5ODBiNTNiYzJiMjA4MTA2ZDg2NWQzMjI4MGNmOWU2ZDAzMDU2M2I4NWMwMDk2OWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, FI, NZ', '[{\"id\":\"d01020ac-cfe7-40e6-b579-410c7d6dbc6b\",\"name\":\"Play Weed Attack!\",\"payout\":0},{\"id\":\"53deabc1-dc1d-4bf0-b35e-a3469329bf06\",\"name\":\"Reach 2 skins\",\"payout\":0.008},{\"id\":\"40e03ea8-e4c5-462c-a6c0-482b2165461a\",\"name\":\"Reach 6 skins\",\"payout\":0.02},{\"id\":\"c4f6760b-fc5e-48c0-a11f-d7989ac72e83\",\"name\":\"Reach 10 skins\",\"payout\":0.16},{\"id\":\"dbdde764-25e2-4e32-9916-e8d146d4a5a1\",\"name\":\"Reach 15 skins\",\"payout\":1.2},{\"id\":\"90600c92-826f-45fd-b161-b6b6a5d14b79\",\"name\":\"Reach 19 skins\",\"payout\":7.92}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(442, '1141242-lZ2kToJFfVYWxuk6', 'X2: Number Merge Puzzle 2048', '', NULL, 6.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlJFVE5LTzErenVBMTlXS2lvREY0M1E9PSIsInZhbHVlIjoibEQ3SWlTUlJ0YXZuVWRFcHgzSGdoa0l6N2JCczRTQkhHbW9ScnJDaVkxWDlMSW00OUUvNXpmZGxBMlVlUGgrYTI4UDdEZDBYaGE4ZnJhUGl1c1lXNTBicFRUOSsxbWYzalN6N1p6VExvTklSS2FxbnpOQ2w2dGtEY2lpZnlybjJ4RDc3OTE4ZTN4TVdjM2JlWnVTT0tpRktXaXJMS093L3pCT3lBTm1MQjlPOVJwNmV6SXIwaFB0eFBFd0NlS2FxWG5Ud3ZwY002UEVEd21aUHptL3ZRMTFuMkxLWWhBVlBGeDVXbFFZTFJEMEczVUt6bFZwRXJkVHU3OGdEdmFIQ1FyNHp6K0lQaGwydmM0eTArUks0YlBpTWZYdHY0M3ZneDV4aEdxMHUvVFU9IiwibWFjIjoiMTA1MjllODFmMDI0ZjNlYWEyZGU5OTk1OTJiMmUwZTBkYWJmNjFlMDNmZjEzNTk3ZWVhOWQzNGU2ZjEwMDU0YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"7bc5deb0-b0a8-4dd0-b7b2-b434eaa4da9a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"351ea266-6778-46e6-aa7c-7cdc27b1770d\",\"name\":\"Reach Step 50\",\"payout\":0.1},{\"id\":\"c14ffb1e-5d32-477f-a6f0-fc0dca342a56\",\"name\":\"Reach Step 100\",\"payout\":0.22},{\"id\":\"7179a0c8-93e6-4db3-b301-e2e2677bee5a\",\"name\":\"Reach Step 250\",\"payout\":0.7},{\"id\":\"7ed73a5a-f913-433e-b411-49be533c49e5\",\"name\":\"Reach Step 500\",\"payout\":1.68},{\"id\":\"ec4136ac-fa1b-49b0-aaf6-9869cb2f14f9\",\"name\":\"Reach Step 1000\",\"payout\":3.36}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(443, '1151659-lZ2kToJFfVYWxuk6', 'Bingo Holiday', '', NULL, 1.28, 'https://notik.me/api-redirect?token=eyJpdiI6InVrcHJtc1ZxczNGWkxPdHQyR1VOR0E9PSIsInZhbHVlIjoiV2R6Snl6NkVxdjZDRlJrdzdOenE2T3ZIWEhRL3JpRmR1bzdka2FvdW45dHFmN3RzQ1MrRTlKd3I0RUQ0Q0xMcGl1WWw4ekdUUzBYN1oxcTVXK01DY295MEhCbmh1b25SZk02YlJpa3RNeWhLamhtUklpeFg3ckk5ZUdUcnBaQjYrTFVVOFFrMnhhUGJqV2ROUjVqQ1lJY2dCWXN2bVBZSWkyZW9GY2NiWHNtK1ZHTENQcDhKVHFXUEJ6Rkd5MGRmYVhnTzg1eDNlQTlvbXdVZlVOUlNrZklxVFZpREl0RGRQdmUxeVRvL3Z5eVQ4SEI1QXlCSDdOYzJzc3lGN2hmdGFmaEFpNUlCcmxyTGkxOStpNjdsNkE9PSIsIm1hYyI6IjhlZTgzODdhMWNlZjY4NDMwZDg1NTA1YjcwMzBmNDZjNWIxNTg4N2ZjNWE1OGJjZjEzNzAzN2ZiMjVhM2I1MTIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MY, ZA', '[{\"id\":\"4bec4188-f905-11ee-92c7-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"4bec8314-f905-11ee-9c98-069eb31df495\",\"name\":\"Reach Level 40\",\"payout\":1.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(444, '1156259-lZ2kToJFfVYWxuk6', 'Clubillion Vegas Casino Slots', '', NULL, 91.36, 'https://notik.me/api-redirect?token=eyJpdiI6ImV2d1hzS2c1ZDVOWUZ0YVFCNDdneGc9PSIsInZhbHVlIjoiN0p3bDdrMUYyeG9RSjB6U21UTmxlWENuYjAzM0pwWHMydmpURVNJb25FVUhRbUNJYTFWdms1NjVGNXFpVUpPL3hPY2dPR2F3ZVMzaEFRRnZaWnd1ZWtDalNNSXNqbkNxU1g4OFh2WjRQeG9ydDRaNG1ndlZpN1pBU2sydHVQcHJpNC84dWlRazFYZmlTOHFMenhPdTFHRVZKekNhNTJybTRQRmVnSEVqVnVVNG81Y0V4RjFmYlhLNXhtMWFKLzcvU0dRMnNRdkE4UFhzNkZ0OTlCU0JvRnlDZkZrT0JTZTFVZjZRRTI5YTAvM1h1bjk3Q3pBSHBIV0h4RDc2ZUNlQU44TW5aR0lSamxHYlFIbVFMTlBPZ1Q5T1FwY2M5RUpzYUR2czk4Q052QXVPcVBOa0p2MzRrN1FwT3BrY2g2V28iLCJtYWMiOiJlZDlmNjBhYTQ0YmQ5Njg4ZjFmY2U1YTdmMDBhZGIyNTVkNGZjZDhmZGJiNTAwNjZlYWUxYjBhNWRmN2M3NjZjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"57029110-fe84-11ee-a935-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"570299a8-fe84-11ee-91de-069eb31df495\",\"name\":\"Reach Level 100\",\"payout\":0.8},{\"id\":\"5702a146-fe84-11ee-9f70-069eb31df495\",\"name\":\"Reach Level 400\",\"payout\":1.92},{\"id\":\"5702a8d0-fe84-11ee-a0f2-069eb31df495\",\"name\":\"Reach Level 800\",\"payout\":9.6},{\"id\":\"5702b0d2-fe84-11ee-a0cb-069eb31df495\",\"name\":\"Reach Level 1200\",\"payout\":16},{\"id\":\"5702b884-fe84-11ee-adb7-069eb31df495\",\"name\":\"Reach Level 2000\",\"payout\":22.4},{\"id\":\"5702c05e-fe84-11ee-a87c-069eb31df495\",\"name\":\"Reach Level 3000\",\"payout\":32},{\"id\":\"5702c860-fe84-11ee-8d1f-069eb31df495\",\"name\":\"Purchase Mission Pass\",\"payout\":0.64},{\"id\":\"5702d08a-fe84-11ee-9911-069eb31df495\",\"name\":\"Accumulated Purchase $19.99+\",\"payout\":8},{\"id\":\"aa0a1194-e2fe-11ef-9306-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(445, '1157817-lZ2kToJFfVYWxuk6', 'Woody Sort: Ball Sort Puzzle', '', NULL, 12.52, 'https://notik.me/api-redirect?token=eyJpdiI6ImpsUU9URkJLamhPNjBOOGNReEw1K0E9PSIsInZhbHVlIjoiSDJxSy9PVWVFSytUWG1wM2drRUh3OGxrUWNrekVLQm1EM01YaEZ5bmF3L2JIcng0ZW5sMDNXUU82VHJMVWFITXJtWHg1Sy9jRmcya0ZzSU9COU5RM0RaQTlydm84a3NOczFmdk4yQTRZb3d1eFhsL2ZNaC9CK2dMV3pSQUplSXBCTlZXMTBxU3pKVUNlaWdJWm9YZEZ1dE11ZkNzWTZxeEdHeGFGTDJ5WjNlS1dZVzRiZEFvMFlMeENrc3FQZjJtZjd4WWJNdE5GM1dEU0d2MHduMW9SaGVqNThFcVl3UWY2bW8rMHZrcVd0NzExQkx4V2c5Mk5BdnRXZ1BUSnY5M3JCaWtwbEZoYUl4aGhtN25vSGp4cHFKdnQvUWMxUjk2Z0IvT2Zub2tNeGs9IiwibWFjIjoiMjRiZWY3MjU4M2E4YzA0ZjRmMzQ1MjQ1OTA3MTBkNTQwOGJmYTJkNGVmZGQyMzg5NzA2NDc5YjRhOGUxOTgzMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, KR', '[{\"id\":\"d6313a0b-025b-42c4-af3b-5c07a26cee0c\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"00e61fcf-6cb7-4ade-9748-d9a39701ab58\",\"name\":\"Complete Hidden Level 1\",\"payout\":0.08},{\"id\":\"a5ac5f0b-a710-4d24-ad0a-202ade0c2ec8\",\"name\":\"Complete Hidden Level 10\",\"payout\":0.44},{\"id\":\"38e2225e-c808-4769-8273-856ccef58a7d\",\"name\":\"Complete Hidden Level 25\",\"payout\":0.88},{\"id\":\"37af2d44-c18e-4a11-8654-9ef16f1aec57\",\"name\":\"Complete Hidden Level 50\",\"payout\":1.76},{\"id\":\"e8340e22-4b4e-46ea-8a78-0b6df31c9d8d\",\"name\":\"Complete Hidden Level 100\",\"payout\":3.36},{\"id\":\"e98b4308-0310-4f58-831c-a3ee38035b2c\",\"name\":\"Complete Hidden Level 200\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(446, '1162240-lZ2kToJFfVYWxuk6', 'Word City: Connect Word Game', '', NULL, 2.73, 'https://notik.me/api-redirect?token=eyJpdiI6IjhscTlTUEVQekZ6b3ExRGhtd1pWVEE9PSIsInZhbHVlIjoiN01CSGUrdm40U1pWOHdiNkFmMWZZNi9YMFlqU0xjTFAzYkNrR1RhbzYvWlJicVBjdVpSU3dzQXQ1VnhpeVVweGlscHVPMEtldGo5ME5pdmlCbUNad29SWVhkcWx2S0J2REp3dWk5QlNJM0ZmTXIzcldQTTJaM2g3Q3JzaWhZVmhWWHk2NXB1WGQ0UFpRcEgrOUNJeG5rTUh2ZVB5L1gzL1hOc2x4YzE0WFhYakxwWU4zS25ITXVyRFFnNGllalpPVHZNVDUvVnB3eXV3TEE0am9uaUVDMFRJNEprdHVpT2RvNnBiNkFtOU9MbXpCbTdidG1LaXdJbmZ5aTc1RXk5U09WR0Q2N1NDNWY2WXlHR3o0VFZacTB5dll6WXdNQ2lybkZDamxhWlJqODA9IiwibWFjIjoiNTEzZDlmZmYzMzdmZWU5ZDZhZGFjOTJkZWE1MDVhMmYwMDdkY2I5ODg5YTk1ZGQ2NjdlMGI0ODRjOTQ0ZTI1MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TR', '[{\"id\":\"5b0eae57-c6f5-4e73-8ebb-0ed7ee14ffe3\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"81996174-90a5-46c0-9eec-dc5e4e25a1b2\",\"name\":\"Complete Level 50\",\"payout\":0.04},{\"id\":\"9e5ba8cd-bf3b-4ecd-ad4a-50bacf248ed3\",\"name\":\"Complete Level 100\",\"payout\":0.08},{\"id\":\"2417435b-ed45-410a-a93e-f5cf8c00ec50\",\"name\":\"Complete Level 250\",\"payout\":0.168},{\"id\":\"adcfaf11-ea2a-44a4-8085-dd7440981410\",\"name\":\"Complete Level 500\",\"payout\":0.34},{\"id\":\"bd702346-0b78-42ff-ab57-0cf1f4b62255\",\"name\":\"Complete Level 1000\",\"payout\":0.7},{\"id\":\"a55763ac-9d65-4334-94fa-cb1a96bcc478\",\"name\":\"Complete Level 2000\",\"payout\":1.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(447, '1162812-lZ2kToJFfVYWxuk6', 'Army Tycoon', '', NULL, 0.96, 'https://notik.me/api-redirect?token=eyJpdiI6IlR2bEF6bGR6NzRBeTRMTXVTRHl2TFE9PSIsInZhbHVlIjoiWUd2akdrQ1lmZi83TUVhMEs4Mkk3WG45SnNmbG9iNlBZMUgwWERQSVdtM3YzNUZYVk5IOHdWRXBobFFlVUhhZGpRWjlDTTdTOWNsNndrVGZhM2N0UjU4bW1TZ2o4ajZQc1h5YTBnbldCczRrNUZHdGx4TW01d0FVcnhSek96bGxBS09KY3JYb1JuUTZaWjB2NEN5L0NhNFhhNUpoaDRmQzhJTzNlNGt4U2dlYm5IOG44Z2FrUlc5WFRSNGNySUVmMVFnUVMxbEVjNEYydFV2dGRiQUxZUXVGNThRSlFHZVFOejVFMHprMzFtQnVUM1hONXV2ME5ERStsRndvTzNDSEh6K2dsOXdPTWovenk5V29rQWdndVE9PSIsIm1hYyI6IjdhMDhjNjQ5YTBiZmU2NDBhNmFmMGQ5OTUzYjE1MWQ1ODBlOTMxZDI0NjliMjAwMDdjYmRlOThlMWNkMzA3YzUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"f478eb46-2d79-11ef-824d-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"f478f500-2d79-11ef-a916-069eb31df495\",\"name\":\"Unlock Artillery Course\",\"payout\":0.06},{\"id\":\"f478fcb2-2d79-11ef-8ca3-069eb31df495\",\"name\":\"Unlock Tank Course\",\"payout\":0.1},{\"id\":\"f479043c-2d79-11ef-aec4-069eb31df495\",\"name\":\"Unlock Indoor Shooting Range\",\"payout\":0.32},{\"id\":\"f4790bbc-2d79-11ef-902c-069eb31df495\",\"name\":\"Unlock Helicopter Course\",\"payout\":0.48},{\"id\":\"abff9fb6-e324-11ef-bce0-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(448, '1165939-lZ2kToJFfVYWxuk6', 'Block Puzzle', '', NULL, 2.14, 'https://notik.me/api-redirect?token=eyJpdiI6Im5kdngya2kxZVVNTUtOQmFZSXBmeXc9PSIsInZhbHVlIjoidWsyTkVKYzE3bHFqRVA2RGZVeFRiZHlOYktHVXpJM25sbmNJNG1XejBEVlp0eWc2NnQ0aUIvaUhZU3YwMEpxNDRNU2xaMUtITjdQemI2MXFtdEt2d1NhNndOdkxmMVlXVXo5M1hOYk03djU3Y3c5cnRJTmNQMjlRRnlkTjJyVVpOVHJ5TS91Z3p2L3M2SW8zTnFpeUpSamNudFVScW05akFxbHhwYWJSQ0txQk5EL3VJQzdhSnhMenJHOHBZM1VSZlpJSnZCcUhiZ2g2VG1KbHRrRHdkVDJRWXNscmYrekJvQ1J4Q2w4bTRVYUpIYW9oQzEwUGwxYVRRTDhUSGhQcUxWSTM3NGpuS0RhRU1JRzBjemx2Wnc9PSIsIm1hYyI6ImI2ZDgwOTUyN2EzZWNjYTcxNWI5YjAxNjRkYTc2MDgzNzRiOWFhNzNmZTYyNWU0ZWNlMDMwMTJmNDM0ZTEzZGUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, FR, DE, JP, KR, NZ, SG, GB', '[{\"id\":\"92ed0dea-2f2b-11ef-99f4-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"92ed1862-2f2b-11ef-9751-069eb31df495\",\"name\":\"Score 7k\",\"payout\":0.02},{\"id\":\"92ed205a-2f2b-11ef-baf9-069eb31df495\",\"name\":\"Score 45k\",\"payout\":0.12},{\"id\":\"92ed2a5a-2f2b-11ef-b64d-069eb31df495\",\"name\":\"Score 400k\",\"payout\":2},{\"id\":\"7442b6c2-e2fb-11ef-a450-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(449, '1176609-lZ2kToJFfVYWxuk6', 'Lords Mobile: Tower Defense', '', NULL, 3.20, 'https://notik.me/api-redirect?token=eyJpdiI6Im95NGErbXB4YUNvUzcyRjlQY3NxOHc9PSIsInZhbHVlIjoiUndxL2NZNTNMa3dQaEgxU3ExcEVpVmx1d0lBRkdRSU5rYXAzVVhnb0NEVnhCVGlQR0JTdDlhellpUEtXblNpN3pvK3VDeTRTVWhtelFwYk4rVnpRZG1yMUJnaXBvVUtMdy9yTDJpNFlJYTVFd25PNlduSS9BMCtYdC9MWkRLTFQ3aGNLVFJ2UndhSVp0RlkwWUJRZWQzN1U5WUgyWktxWHBta2t5dUZ4R1phMWhKYXl4M2VVRWkzbU1uaTExQ2l6Zy9KNnhMUEtLc25wR1RwcE1RNGlXdDZqbTZUTTZCZjkwNmZYYXQ2RnN5ZjhmVWNEM29RSC9wOGhYSG5iQVZvR01jTWdxVmQxdkRPMkFWakkvTHo1VWplVkVVR3hBaDlRbkV5SnVFMVJteFk9IiwibWFjIjoiNWE0ZDc5YjEyNDNiM2VhYmZiYmFmODVhOGIzMDQ0NTEwMWZmZTAzNzY5NzdlMWJiMjA5MGYxNDJlZDFmNjRkMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, NZ, SG', '[{\"id\":\"401ad158-ac83-477b-88d6-80e3094e5cec\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"35fedaca-8e16-4960-b0f4-6329df7e6248\",\"name\":\"Hire 14 Heroes!\",\"payout\":3.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(450, '1273872-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 1.16, 'https://notik.me/api-redirect?token=eyJpdiI6InlsaW9LVjVTS2FsTUI0WlY2OTJlZ3c9PSIsInZhbHVlIjoiZkdudVBsNlBlRWg4MjRaeWlIMUJSS0RBK21hWU5URGNXbGdXelBmbFlWbzJGV201Q1R5VDRRd3hLZGRuelBoRDNmSXA1TUlyZEdhNUk0MTlNZWxUVG9GZHZjeXhwZkx1MlRrYWowZDFiSXd6cEl3OVBIRzBENDUvcFk5NERoS1ZSUENUeUhBbENvMk1nc0V3cklsRklTS0QyRjNMY3RLSVpIcklXd3pHbXA3emVSM1ZPZVVycnhzcXpvVXZTcy9sTVNCa1VibjhEWndZc29hYkx2UVovWDBaRVFDTHkvWFFxN3JJVTVhbmF6VDJnTmtiTmg0T28vcTJXK1V0ckh2NWtxQm4vOXZTOGg3S0FSMkEwNmtick1ZMHVPNFdrRi9oRkxFbVVRcmY1bm89IiwibWFjIjoiNWE3NjFiZjI5ODE5ZGY4NjRhNWE2MjJhYWMyMDE4ZDFmOGIwNzE1MmJkMzgzMzEzMzlhN2JhOTdhZTZlMzc3OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"983ec08d-0c5d-40c2-a4fc-11b15367cb40\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"d7b8f5cd-2411-48fa-a406-07de2ffe9940\",\"name\":\"Reach Level 50\",\"payout\":0.16},{\"id\":\"0a4221f1-e9fd-4964-b9ed-ebae155166dc\",\"name\":\"Reach Level 100\",\"payout\":0.3},{\"id\":\"e4e5b5d3-fda6-41b3-98c9-13419e500c0a\",\"name\":\"Reach Level 300\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(451, '1273873-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6InA5OFEveW1YbHlnSFkrMkxJbkZyaHc9PSIsInZhbHVlIjoiaVprdWt5dTVETFFHQmh4cm5MbDJwVno3RHBuZkZOMW83RjhoYVNlT09QVXVPaFdBVHFNRFpwU1RCNmh5a1pNM3VuR2x1OXgvaWcyZ0RKL0RheGdLTUsvOGNBSHlKT0RKL2tZczg0S2tZV3BSV3ZQOUgzQUNNTlRHaDNVOU5FSzVtU1NRUXo3YzZqZ3JjQkp1WnIwN3U4aHFPVmpmMXRlTll1eCtCN2ZnOU9WRFNtOG80SDVzam52ZnJKeDUxZUF1RjdadmRqZFc3WTJacFgxQjlJUTBvVklWWVZtaU1oWjUrenFnQ2t2M3ZIMm9wUlVuU3ZIRnkrdEtHK1hpOFpud01Vc1dHeXh2RzZhM3lxcGJGNlUwTGJCdUppdEk0ZnNSdmtZblhrcTVEcnM9IiwibWFjIjoiNmJmMTZmMDc4NWVlYzE5ODJiMzhlNjM0MzMxZDQ5OWEzZWFhNTVhZmI0NDU0ZWY3Y2Q2NzNmZDllZTQ4ZDgzNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, TW', '[{\"id\":\"47bfee29-22a6-46f3-9d3c-af6227bb9082\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"1b02f00b-62c2-4e72-84a1-038dd0ed977c\",\"name\":\"Reach Level 50\",\"payout\":0.112},{\"id\":\"e63cda35-5fc7-4834-b1ba-2aa4265fdcff\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"fc40184b-58dd-4e64-8dd4-4677cf400e26\",\"name\":\"Reach Level 300\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(452, '1273875-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6ImJOUHhQNVZSQmMwWGdYSWx0K3EzTHc9PSIsInZhbHVlIjoicGc4eHlESzcwd0RhTjJ6OWl0UnpKZFJPdmVYVTYxMTcrclZDTnZZU3hIL2V2YWQ2cFQzOVVHYzJ4Z3I5QTFLQ2s2amNvS1NSUFgzRGVUWFY2MXpjMGVaRlNjVVA1NFAxc3JZZDFoMHRxdTVQZzlMY0ZMVjdJNXgweHFKa3pSQVovbmQ3bzNpdXRKVkt4TW5MUDJuK3B5OHBGVDN5elAzRkdsSnBnNUNScFZ0SUpVTHVuM1JMUGhaZWxTUVVDb2pXUTEzcEpwRUpkUU1HWkZ5WUh2b2ZyZXowSlpaSGtEZnk2WllKbzhlbSs2SFl2STE3eHAwRUVMUGFiQTBsZUNhN3VlcW9ReWFRYS9sQWYzWjJnaksyNDh6TXQ0RXFYMWUyWXZwazhpV05LSzA9IiwibWFjIjoiMjFhZWIzNDlhNzBhZWViMDNkMDA1MTg1MjViNGEzZDAyYTNmZDhhZjA4MzY0M2I3YzFhMTlkNjA4YWU4ZGIwOCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR, SG', '[{\"id\":\"a62ea5c7-4995-4ff3-ae47-eb87274ebb27\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"4f224ca8-faf3-48c6-8840-cdb3b634f24b\",\"name\":\"Reach Level 50\",\"payout\":0.112},{\"id\":\"86b41934-e2ff-4b2b-a6ad-7ea1d0469d90\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"7d4f8b4d-56a5-4891-ae80-1ad5a37db216\",\"name\":\"Reach Level 300\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(453, '1273886-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.59, 'https://notik.me/api-redirect?token=eyJpdiI6ImwwaFFwQ2xNeXFFUkZFYndiQW1SR1E9PSIsInZhbHVlIjoibTVjLzdRcjBEM1B5a0dMUFdHWE0xeGp3bVE4YVhaOGxsdE9rcTA4RTFaM0Q4cXYxWk9rOHZUeVc2bFZkYVpqU2lHcjFMNkFPWWRvL21RTWlOSGZUZ215L2hPU2RML2t3d0JhQXZlL0tOMXZOK0JEVVp3bmlmd0RWcFVuNEgzRi9xWTBhb3JCRjlEVWEwOWxuOFErQi9JQXdZMGFUOE1JZFgyeUx1YnMxWDRtZFRia0tPc2FTeTBrK2Vzck11SXNjanhmbXRGejNXblA2MkRXZ2liRk1VT0NHQW5zM3FEV1BUWkdFZkpWRWE5WHROeFczU0VQNGphcTdnVVhsM0dBT25URXJmcUhIdVg2NXhySWE2ZG4vZ0ZYSHVkbjRrYkZxdnljcm5tNVNua1E9IiwibWFjIjoiYjFkYzQ5NDRiYzFkYmVkMGZiN2RkNmJlZmU5OWU0MjRhNzRmZjI0ZGI0ZmU2ZGVmYTlmN2E0NTA5ZWNmNmEyMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, IT, MY, PT, QA, ZA, ES', '[{\"id\":\"2125c324-bb25-4b32-9223-43b9ce1e9082\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"1be34424-dfc9-49e5-baf4-8c804fd6eda5\",\"name\":\"Reach Level 50\",\"payout\":0.084},{\"id\":\"73869bf4-ca8f-4879-bb2f-97a769380288\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"0ba4a189-087e-4492-a31c-78424b8eac7e\",\"name\":\"Reach Level 300\",\"payout\":0.336}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(454, '1273887-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.50, 'https://notik.me/api-redirect?token=eyJpdiI6ImgySVZnNWdxQ2pFMC9uNUwxVWEwOEE9PSIsInZhbHVlIjoiT0tsakdrZ3VaYjloL0lNWktQNzhnK1dxYmhNKy9Cd3l5Qkt4MEtyQ1pTaVl2bUJDMi9USDBUYUsvS0MxK2xXZkFacm1qbGk1T0VyVnRVb0FuckVKZDQ5REVETzB3c3NHdmhUKzN3eExGYnc0bWIySE40UkJ4enFZbEJUZmJubkdreURqVktrck1mR0JMWGVkTWxxaTUrVDFLTkFKL3ltMnpjc05kZTV1UC91WTJPY0RtTDVzMzJCeFpwRGlBZnlJU3pIZ05HU2lJZWhGdzROZ3NEQWt6L3RiRXNGY2dhMW1pQmY2NXMzN1F6UE1YUFF6bTJ1ZksrUlFBL0lVaDQwdzhpYzRrekVxMjY1L0Y3RDY4SGg1ZWw2Q2x1LzVqeFk2VjRpUkQ5UU9Wejg9IiwibWFjIjoiNGQ4Mjg1MThkYzdmNWNjZGYwOGNiM2U5YmM2M2RjNmY5MWM2ZGVkM2Y2NGIxODIwM2EyOTZlOTQxYTljNzI1MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"d9d5f21e-281a-446f-94cf-df48f479821e\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"8e04b528-b843-4d5f-98bf-4da8d6c4db25\",\"name\":\"Reach Level 50\",\"payout\":0.056},{\"id\":\"ddca9929-94f6-4593-b4e0-e09c9eb3cc1e\",\"name\":\"Reach Level 100\",\"payout\":0.12},{\"id\":\"6cb80bdd-b16a-4f1b-b286-83526a92f471\",\"name\":\"Reach Level 300\",\"payout\":0.32}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(455, '1273895-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6Imx4cVUwemJqMlF4ZlVSZWpRVDNNMmc9PSIsInZhbHVlIjoiWnFFeFR2bExWT1EvRTZWV0lhUEJSSkdhNHV6eGdvbkFKTVJmOERhQjVnQVJHbjBOQ0RiMnFEOUtpellaWWU5VGR6cFNTQ1VQbEFiTDlWSE1udTlEbW9ZQldjcnlEY3pMbFJjbjZPUDNKZ1IxdUJjVlNFTjNhWEtlQW5hWHAwc2xpY1g5SE1iMFg4ajY0ZFFiV09WZDNXSnNXUlIxWUJtSkNLdnZOQmxUTEIrbGdjREt1eU5jMDdnUDNqYllvY0pZYTBQcm95NjZNQzNjbEtqTllSYWtRRGlaMHdFU0x1b216dmUzc3NXa2NxeG8xbTljT0RDazBtQnAwblZ4RHhDbXFSRVJwK21yQ2NFbjMzOWVGZGlUcHNvYk1WRGRINHFsYWNxTDlQemRZZkE9IiwibWFjIjoiODYyMWYyYmI2YWMxZjhmMWUzNjYzYTAzYWViYjE5NmRiNDk0M2M4NmE4OGI5NmJiMzA5M2VlNGQxOTQzMjljNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[{\"id\":\"3188cde6-bd6a-423f-baab-64c02676e077\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"87ee0813-c4aa-4089-8f06-ce214beeb9b1\",\"name\":\"Reach Level 50\",\"payout\":0.04},{\"id\":\"cb7b7109-4129-4274-86e4-05df5ccc783c\",\"name\":\"Reach Level 100\",\"payout\":0.048},{\"id\":\"4f5afd64-affe-4c41-b1e6-ee4ae21aaeb8\",\"name\":\"Reach Level 300\",\"payout\":0.16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(456, '1273896-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.24, 'https://notik.me/api-redirect?token=eyJpdiI6Ikh6OEJuQ3Bsblh5ZGtCblBQN2RyV0E9PSIsInZhbHVlIjoiWHBUSE5uZWpqNjRTUS9yWUtTbFExU0dEZWtNejlVcll3SzJDYzd4OEhKNWFwM3FGS2FsWjlmN0hwcTZwSndiWFpHdHhnYjBreWpjR3REYS9nZWFTTzJwVndtTTFNeElpYlBKS1BHZ1ZlRnhHQlJSek5RQXJoeFh6S3N0NHlDOHZEOEMwdWZ4bHFmaVVnMTNnTUNTZHFibnJNc2JPNHc2dmV5RGkrT3NyV3lDenMxdEgxcXBWNmZRNHRxU0xXNVdrUnYwR2k1SVErUmx0S1FRQlhWMm9CeXc1dy9MeUZrcThwOHNJS09nMjY2KzRXSDJOUm5UMHV2Nk9sNG1SVnpKMzNmMXhYMURubytvbmFMSVNMR3VEQ2ZYM01UejRyWUEycnBSU1BnUG9mc0k9IiwibWFjIjoiMDM5Y2FjNjY0YzQ5Njg1MjQzMjMyYTM4ODU3NDA3NGMzYmQwYjk5YjVhZDk5ZDIxNWM1YzVlY2Y4ODc3ZmFhMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, CO, PE, PL, SI', '[{\"id\":\"a70980ac-94d8-41cd-a41a-6f09bb2052f1\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"1ebd0db7-ac02-404a-9bce-f1239566d0cf\",\"name\":\"Reach Level 50\",\"payout\":0.028},{\"id\":\"c96aee78-b120-41ed-8ee1-e6e7b45ea097\",\"name\":\"Reach Level 100\",\"payout\":0.048},{\"id\":\"f20b4d77-8f64-4bb4-8435-3eff0c00283e\",\"name\":\"Reach Level 300\",\"payout\":0.16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(457, '1273897-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6ImVUZlBJTGFOcnRXcWRLYlUyMjBEQUE9PSIsInZhbHVlIjoic3ozdncybml4dGdHS2s3aEZFU2Jmc1BueFk3SEpFMDBGZ0tOVFBmOUFNL09hc3JxYUdOenpqTU5SaUNiK3llY0dKSTBpdTZBM0d5Z0F3b2hrQjd0eWIvcThVZjFxRmZyR3cvUVFIRnlvU1FKdm9CRzkrRC82cTliWGdsZXZzR0NJeWVFcEJEK1N2UU0vOFdtbzhqRHgwWHF0NkZ5dkxnR0JYZ1VEVGczalVOdjdIWjZzMHdGdXZBZ0svTXdhUzVaRVhEVXRjWWVKMmZpUU84MUVPQ25NWjRWOCtNUERlV0NKYzkwQ3JRckx5bGRCYzdSSUp2bHRjMEZ1SldUczVNczU4VnZoQVdrNjhjUGM5RUJlSXR3Z2J4djVIMGNid1JvMUtIUm9QVnlmQlE9IiwibWFjIjoiNDhhMTE5YWEyM2I0ZDM3NTdhZGYxMjYzN2FiNzIxZmFjZmQ4N2JhNjU0MWZlMjc1NGUzYzU5NGExOTcxMmQzYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KE, TR, VN', '[{\"id\":\"bef9afb4-e480-4bc7-88a2-7b760ea49a9e\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"32bd35a2-7cbf-4011-8f12-a943fc8a7348\",\"name\":\"Reach Level 50\",\"payout\":0.02},{\"id\":\"cbea5ad9-7a22-421a-a950-918640eabbd5\",\"name\":\"Reach Level 100\",\"payout\":0.04},{\"id\":\"3ad6b540-0d14-4587-a97e-d71eff7abc1f\",\"name\":\"Reach Level 300\",\"payout\":0.12}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(458, '1273899-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImpVNnV5aklrOXhJMzk4VTBZWEN6VWc9PSIsInZhbHVlIjoiYUpIQTZ5S2Z1Mk11SWtFTThyWUhvc3ZQUC90dWlUNFUwV05pY25hY0tiSUF1K0Mxc01MZEJURTNUaW9OZFFDSkl2eWR5TFhUTFcvNy9DQm10bXY3WXBmdDRXaXY5emc1U0x5SFBsMzQ3SzBISDVLUHhNRGJNWkxzQldLZWlUQWh1VnA3aDRTVWUxcXVQMlc1MVRLSkxCL0xDVjh2SzNoL2NYRWhtMkduQ01xYW5Fa2dvT0ZWaVo2dnRXM09lOGk3aUhNRmxNU2RBb0FEY2FiN3pFS2RydFRUczViZDlBeERuL3JhbzNUR3J6L1kzTWdMTUNjNHl4Y1N4ZkFoTk9IbGNCVXpKUGNOenpOQXZFV0hhUTlWT2E4SHJpbGFYVDN6eFJXejBoTzhmbkU9IiwibWFjIjoiZTlkNzJjZGM2YTBkMjY1Njk0ZDdhMzUzNzc3ZDkwODk4ZWU2ZTBiZTdlYmEyYmUzMzA3MWRmNTEzMDc4NzVjYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EG, UA', '[{\"id\":\"8d092bd8-28d9-44e7-8993-bdb76b8a47af\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"1ef27a12-92e0-41ba-8e1b-9162e209d60f\",\"name\":\"Reach Level 50\",\"payout\":0.024},{\"id\":\"48053dfd-a7e3-4fff-8a86-8fedb2fed62f\",\"name\":\"Reach Level 100\",\"payout\":0.04},{\"id\":\"a13ea30d-4256-4a1d-b4ba-2b5d43ae6f68\",\"name\":\"Reach Level 300\",\"payout\":0.14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(459, '1273900-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6ImhBSmNsQTIxclBabWdES0lwMWNmbVE9PSIsInZhbHVlIjoiRWdwSUl2bGpsWldOOEpMaFRKSUo0N2l6T245eFNxbFJXWG9vWnI5TzhDL0lTaFpTb2QxaGN4K0l4RkhtU0pyajkwZ3Z5ai9lN0hZQUpEUTRjaEtFcWZZT0F6d1NTNFBoclowaWZrRjZjdUNWNGpnZ3IrZkFLZVg1Wm1EbXlDMlJhOUF1SGlCT2ZhWld5K2taYU93TnRNVE1hemFXdTVGNUxZYUVmdXloYldBNVgzbzlNdHVXVTVJQmZ1R05Wc0ovMGVwQ1ZKOTlHbEVaYVdodk1yUUZhM2lHZWt4Sm1leDRoOVpkRGo0SW9LWldSRmFua0x5MEloblFTWnBsTWsrOVdjaWNqSWFQenpTa2thUmxFRFh4NnFzMGRqcGFFSVFYaDBNdFdXaXR6bDQ9IiwibWFjIjoiNDkxZDVlMDg4ZjlhZTI3ZTViNDk1YjZkODJkNWViMTQ0MTQ3YzdkZWE5OWIwZTRmNTAwNDM3NDQwZDA0OGVkZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"f93a0896-5548-4866-b727-d82895fc8648\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"3c5c9381-1f00-4e7c-aaee-2034d518dca9\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"52f2b464-6c82-4006-896e-e558450215d8\",\"name\":\"Reach Level 300\",\"payout\":0.128}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(460, '1273924-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.72, 'https://notik.me/api-redirect?token=eyJpdiI6ImtBMXphRUdQTkxYTzVJVVFTdXgxL3c9PSIsInZhbHVlIjoid09wVEpJTFFOSEtnT0hqWDdXdXozVmVaY25MTWFBd1VVcTM0SGYxK3IwVkdvOHNwQU53VDhCRDIxYVNKcElxdlI0Yk1oSmF1Qk82a3dENVNONlFFanRPMnI2TzdkUWlZbEUzcWErM09RZDBoTkZMYkZXZlpGOFNWY2ZONGd5NlFnalV0bkFIMEFLN08zZmRFNUZBS25qMnZnSDQ3dzNuSm1mZzZ2dWNBMFVjQ3hxU1FMQm0yTmpqaW1LT3pKTTlrbXJEVnN6YWxNYU5DclVoRmFGcGZEMkRqUEIzRjhiRjF1QkEycFU3Zlozd2luc1REWklCRnZodWNPQUFtNFlxMUFqMkNHSndNclVNRnZQWWRYcmJ3YXBkUVdnS3J2OVFHbGtTUGNmV2d5cTA9IiwibWFjIjoiOTkwZWE3NDY5NDU0OWJjNzQzYjlkNWM3MGJkZmU1ZTg2ZmFlN2M2NjZhYmVhYWMxMWVkMDBlN2MwMGI3MWQzYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP, KR, TW', '[{\"id\":\"2e9b8f1e-5771-434d-8e4f-991717f7f8f4\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"987f6597-0823-4e8c-ae01-2df05f7d19f4\",\"name\":\"Reach Level 20\",\"payout\":0.016},{\"id\":\"b129b3ef-a6f4-47e1-84b9-64e4c7e9a727\",\"name\":\"Reach Level 50\",\"payout\":0.112},{\"id\":\"cec6fa81-f7e6-4c8d-9692-8f458aa87b5a\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"6bd736a8-3900-4a55-9d36-f4b76181b508\",\"name\":\"Reach Level 300\",\"payout\":0.42}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(461, '1273925-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.77, 'https://notik.me/api-redirect?token=eyJpdiI6IjFYdkZvRmwxa09ubDU2NUdIVUNDT2c9PSIsInZhbHVlIjoieVlRMjJaVnZsZTMvMXVwOXRvOERiVVNQTWU3NzVpOC9lakpPQmJBaDg1aVVxUzFCQjRVeGVXUXpFRjZ5SHJCTFJ2cFkzVCtjaGpCa25PSXdpRlZyRXk0LzhuMmpMS3liWWZCTHlPcUpPc204QjdVRWtSRHFjemw3eWhwTGdoTVF2ZU0vR043UEJKWTZac21DRGd1b09xUlh1OThDL1J4c2dZNjQ4b09SNjFKUGRJclp0MkRMSkRxS0lQdFRrUi9jVEk0c0pBUktPZnh5WjVOaEVzbmRQSTZPeGh1bDg5cmNaNlNQQ1R0aXNaRThmMmJSOW5VYlJEMUNEQlp4WVE3bm1lM3Z5UzZOa1gzakJEcUpGS1VpR0V0MFo2cHN3RzNNRnRsZS9EQ2xJNGs9IiwibWFjIjoiNTA2MjE0MzM0ODYxYzJiMjE2NDBkNWVhZjk4ZjliNWVmY2MyYWY3ZmYzMjY5M2UwZmVjZTVjYTQ4YjQ3ZTZjZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"b421910e-951c-46e7-9945-e00aaf12c1d0\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"bf64bc44-db08-4ea2-a183-8750211839e7\",\"name\":\"Reach Level 50\",\"payout\":0.1},{\"id\":\"b7d62006-f127-4e9c-b0ee-25f4e96b1a09\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"216dd1eb-58b2-4440-86f8-1f2215f46282\",\"name\":\"Reach Level 300\",\"payout\":0.5}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(462, '1273926-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.77, 'https://notik.me/api-redirect?token=eyJpdiI6IjgxdmVkalpBdVdvb0x6bnlITXZ0b3c9PSIsInZhbHVlIjoiZWUxby83d3huaDF4MkgwZ3I5L1lXa2tmVHhsL1lrOVlEOVF0dWQ0ZGdHZjgrQjdDakM0QXJIWDJaN0JqVlBYeFd6Y0haZ1dKVTdhTmE1RmhhbTd6ZThENXVBWVBkVXloK3ZjZ2VXUGhhUHJ4My9OdTZlbmdTenMwU3NwVnJZZ09pUHFGS2hWNFQ4NWdrSTd1QWo3T2poWEQ1emJLNG1VQy9tUmxGOGROM25ZM1d6NTROVGRkOUQrRUpEYWtrME9RU04rUVhEdVo0SXpidlRMOHZMUng5L2pzbTVxeGtyeWhEY0VkRnFXYU9JSzVxdVo0a25oa3BkVTMyczZzR3FNUHM3bS9rK1NGR3ZoRmVzVjNld1hGZS8rRDc3UlhhRlNDTzRSR2RVUlViOG89IiwibWFjIjoiZTEyYjI3NWVmOWExOTIxMzQ4MGJiYmNiOTgxNGI5OTE4NzRjM2Q4NTliZDVkNTliZWRjNzZmY2Q5YWE4NWVhZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"226e3dc6-69b6-4871-96e2-00bc30d00274\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"fd72e1dd-5118-407f-b333-c0286130bf63\",\"name\":\"Reach Level 50\",\"payout\":0.1},{\"id\":\"fcb63be9-7eea-4618-9224-be48a3f68a0e\",\"name\":\"Reach Level 100\",\"payout\":0.168},{\"id\":\"a81f2463-8146-4e80-98ef-2af62f54598b\",\"name\":\"Reach Level 300\",\"payout\":0.5}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(463, '1273928-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.89, 'https://notik.me/api-redirect?token=eyJpdiI6Im0zakZ2ZFM2aE9FUXJkaUQ5bEtjaGc9PSIsInZhbHVlIjoiUVZ0ZTRHQlZDcERnTkkzWW1Zd3Z5SlBjNjhScnRvaEhqQm1QckZBczMvQ3BZc0lCMWxCYW9jWTZscGNqQnpRSE5RbHFhamZIemhYeWY5RUxjbzRCSEdxdTFKcGo1RC9qUitxM0dOWmFjeG9JNmMyK1o2VWpqbS9aYmt1L3NlVXVQNG9vSGcrdFhFemt3SUF2dmFndXZZSkpVVlpCOXIvbVM4RDlQTEd0bFQ2OWdMVmpBdHhYNXpUY2dtTVcwUGRyekdtN3QwQTdCMnNkTEd1RFk2RWxuRXY5R0gvbnJYUzhISlJOUnozbnZVcWp3QzNwcGoxcGJKWUI2WVR6dVljMlQyNHgxTFVyNzVsbEhQYkU1cHBEcXlrOEpCUXhBMDVzc1p5b3U3bHBqd009IiwibWFjIjoiYWViZjM0MWQxOTYwYjlhY2Q1MzAwYWIyMDUxODU5N2YyMGZlNjZmODJkM2ZlZWQ4ZTM0ZmJkNTE0OTA3MzZjMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, NL, SE, AE', '[{\"id\":\"53d4744c-07bf-4ac2-acbc-863553fd9cb6\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"94580435-aadb-4acc-afd9-3b6eaa355d31\",\"name\":\"Reach Level 50\",\"payout\":0.12},{\"id\":\"c7bb2178-8eb9-4c64-83ff-2c7afdc28400\",\"name\":\"Reach Level 100\",\"payout\":0.208},{\"id\":\"563d8b0c-533b-4f65-a07c-d03a7e095157\",\"name\":\"Reach Level 300\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(464, '1273936-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6IitCcnIwQjhYeXNmOEJzOFEyL2Eya2c9PSIsInZhbHVlIjoiVDVrVTVDOHMxdHBYZlV6NnpDay9MdzRXcHhDY3l1WlZpRkdjUlgwRjlpNVA3TlF5WWZvV3BKYVc1ZWYxOHF2aGZSRzI2aytrUkRnNWRWMzdFNVRKRVhFa1FTajFMVTQwdEM4Z0xKRlk4STdqNTkwZk5CVHhlVEM2NlFnbmhUYjBlaUE5emM4TzNncU1xT1VFZTVhclFlWGljTmJPY2w3MXpjb1M3Q0Q5VUZrdUtOWkFxVUtMdmhDQ2VNMis4cGZjTG5CS3g5WG5JZ08yWHFmVlVnd05xVm9oS1BPbllsK2xOTEtnN3dGNmJWNmQ5UzA2SDlGOTdqYXY3NzhKR1c3cHZKaDA1ZTBhY1lpMjljVWhzNHM4QVBuR3g2K3o4blhKRFBRMDUzdlJoM2s9IiwibWFjIjoiODQ3YmU0ODg5NTEzNDgwOGQ0ZTExZjg1Yjg4ZWU1MmYyM2E4OGIyYTcxOWU0M2M0MzY2ZTA2OGVmMzVlMDA5MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, IT, MY, PT, QA, ZA, ES, TH', '[{\"id\":\"3886488e-46fe-409e-af9d-63d8bf46feae\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"a7333603-cdb8-48fc-8de5-11e674aa6784\",\"name\":\"Reach Level 50\",\"payout\":0.032},{\"id\":\"aaf5a5f2-83aa-4d94-b4d6-d2d37e5f6f1e\",\"name\":\"Reach Level 100\",\"payout\":0.056},{\"id\":\"5944b945-1ae4-42ca-b432-fc8f87ddadce\",\"name\":\"Reach Level 300\",\"payout\":0.14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(465, '1273946-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6IkNPR0xvbGxEUlZIaGo4Q1RTSXgrOVE9PSIsInZhbHVlIjoiVDBUejZycDNSZkpWRU9md0Q2ZnNZV3FTOHlnWG1zSW9od2ZmQmg4c1ExNGg4d0k0RzJ3UVh0MFhCV1BzL01OY05hK3liRVo1cmNqalVScUlOK1N2eEV3QmdYZkxmMit3aCtBdHVweEZWc3FXYkZxVmF4bWlRRWNxVnhkVVRDTkovSXlHNXBIamtxNk1QeGtVSEI2SXZwR29nWG45cUdyM3M0SGxiRDFLN1pWNnRiUnZuVnZTV29pVXMrbnNXUW9aVmdBYVdNdU1HVjdFWGVaYnQxSGQ1UE54bCtXdWlvMSt4L242c2ZwUGt6RGlrN0VNcXRTRHhHd2llQzdhZUdzczdMcUdMaEYzYlZmd2J0TllvRmw2cWhUcmtLTi9KMDRJQUgwUmQ3aTVibUU9IiwibWFjIjoiNGI4MDI4YjJhMjI0ZDM4MTk0YzE2ZWJhNjlkNjM2MzQ0ODQxMTJjYjE0ODVmZTM2M2YxMGY5MzkwMDhlN2Y5OSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, CO, PE, PL, SI', '[{\"id\":\"37f3c5ea-7335-4093-a15f-b793e2bcf91a\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"c8cc6144-f412-4adf-bc32-d749a2f31c7f\",\"name\":\"Reach Level 50\",\"payout\":0.008},{\"id\":\"6f1fa36b-ef31-42b7-b6cf-18aa987d0b2c\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"e7f1c05e-ef00-4869-8ce0-e0a71b6d1521\",\"name\":\"Reach Level 300\",\"payout\":0.112}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(466, '1273947-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6ImhkL3Q5MUhVa2ozTEFKNGdoUzFyQnc9PSIsInZhbHVlIjoiNTB3aGVWYmhpbmU3YlU5bytyRTJZVUNleUVUUnZqeENrM0pBRmI0L0o1RnRxUHJ1dS8wZ0pRNTcrQmVNamxsejNoRWFnUXlzUVYvckFUSDMxZHZ2bjNHT2IxZTBrQVFTYzJCK3M3ZjBsL0VlRkRsWnhuRGFOZ3pySHhDS2M5cG1LcFBKN1lKVXBwWjBVMHBLRE1uV1ZQOE8veUxOM0RjSGFOODVlbzVjeCtFc0xvOU9hQUY1QVI0N3ViYjF4RmxsNnlycU1UUkxHVWR6Q0MvN2dwMW1QaWxyc1dnUG44aHBuekVxb1dBREFIcEVWcWxzRGZMM2F3YlBOQ0VVWEZaRWZ2TDdwaWhNTEFkZDc3bmUyMU9STHBpeXFGZTUwWklxK1dQaS9YVHdxVFE9IiwibWFjIjoiOGVkYTRiMThlZTdhOTIyY2Y4ZjFhYzYzOTQ4MjRmZDFjNDhhN2M1NDg0ZTcxZjU5NzJkMmNjNjg1MDFiNzkyYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID, KE, NG, PH, TR, VN', '[{\"id\":\"7f8eb40b-9475-41be-9934-b57bbeeff4ee\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"f316f651-17b0-4683-8d02-d40d2f361f1b\",\"name\":\"Reach Level 50\",\"payout\":0.008},{\"id\":\"0d8095cb-35ca-42ac-b1d0-b8eed98a0475\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"d2a50097-a54c-4c52-9b4e-f27dea9cfe4e\",\"name\":\"Reach Level 300\",\"payout\":0.056}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06');
INSERT INTO `offers` VALUES
(467, '1273948-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6Imp0WWdUZjVRSVg1V24zb3U4Zndic1E9PSIsInZhbHVlIjoicUtwSmFpa2NXSSt5Mk4vTC9KVnJDT1JmUlp4VlZJT2ZYdE1SZ2Mzd1pISW5RaXVOaFJCSzAxNVdFdWQxVnF3MkM0eW8yYW4yZGJCODFXNC9tUDdEZE9SaFRTd3RwQXE1RnpZNkNuTHVxZ1QyM04wbzg1THlhZ0RkS2JNR0pMVSsxZGZaaVpNLzRMcnNVQ3hlQmZLNC92L0FXVDFGbXFtc0NRZFhrdFBqU3I1TCtBYnJCNSt4QXJjTFZucEFYQVZjL3lJcWlwdWJIeE56YTBzRTBWd0FXMDVSZ3NoYWFHN1VlWHVBRHJ0Zi9MVm9SbFlrUzY4OUpWempKRlkxOVVOV21jdnVYdkdmQWFkNGtDcjVRczlCRm1xQlBKTm85L3JYN3Y2a0tRanQrN1U9IiwibWFjIjoiYTI5OWMxMTFkZWU3OTU4YzgxNjNjNmM0NjZhMTU5YjZmYjdiOTZkOGFmMjc4OTM1NDQxYmM3NTNmOTE4ZjUxNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EG, UA', '[{\"id\":\"63594724-a99f-44d6-9cda-10b8b3d69c85\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"8884b05e-2fd0-4816-89e4-8de3fcfa319c\",\"name\":\"Reach Level 50\",\"payout\":0.008},{\"id\":\"59a1982e-2fb6-451b-8720-e7eb6fedff68\",\"name\":\"Reach Level 100\",\"payout\":0.016},{\"id\":\"1f342c5f-138c-4970-8efa-5d5ae8503c2d\",\"name\":\"Reach Level 300\",\"payout\":0.112}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(468, '1273949-lZ2kToJFfVYWxuk6', 'Brain Test 3: Tricky Quests', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6Ik54anhMSVZwOEJXQS8yMGlCNnFIQ3c9PSIsInZhbHVlIjoibWlMcDZYOFRBUExSZm9KSTRreGY1dkdVL1lOZTRySG5kZ3htY0dDaGdRd2d3cEtVUjVkUUNMQVNjWmgzUzA4V1ZSaUJEYnJodmdYM1Ntb1RITmFmVGpIQllOZWZmMGk1WitNdTdhMDhyZUZ0RVZWeXloY2l0ck5BMm12U1ppOVRPaDh6bDhTbm5LaHhMM2tEYTZ4dmJjMy9jb0FubHFxaVNacktZendQc1RGc0Q2T3ZLa3FiS0Fpdk9DdG5lM0dNRHdJMzY1SjBhUTJJeXZKMlpHS01yOTJBTi9RWlA4RG1pK09lTUExeGhWZVFsbVpKYlB3ckFWaWk4WmRWK0FPd0JzbUQwNWlGR1hBYzdDOXV6Nk81M0ltSU1Sb2crd1FNK3MvYVRrVm1XSEU9IiwibWFjIjoiMTMxYmFiNjczNWQ5OGVjOTNhZWMyOGNhOGVjZTc5MjUxODQwMmY0NWJlZjQ4MGQ2NTBmMWQ4ZWZhN2JlYzdmMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"b4923e4b-b140-4509-a197-f5439b71086f\",\"name\":\"Open the app\",\"payout\":0},{\"id\":\"7bcc96e9-cca5-4c31-bfd1-2bf282d26011\",\"name\":\"Reach Level 100\",\"payout\":0.012},{\"id\":\"f4c47b3d-8dde-4640-a938-482dd603c022\",\"name\":\"Reach Level 300\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(469, '2155_0-tRWsYX6ZmTJNcgXp', 'SG - Win Groceries Vouchers (SOI) [Responsive]', '', NULL, 0.44, 'https://notik.me/api-redirect?token=eyJpdiI6IktEK0trQlVuVWZTVFRQaEdVRWFVV0E9PSIsInZhbHVlIjoiOVlQeDdOU0NSRWpoSkpNUW94a2ljSlRZRENrUjhlR0kwVDFETVYyYXZaYndHTXZTekp1LzBhQzdwK2FVcXVteE13clRrSGZCOXI3T1RjSzZKSXhkemVMVElNWlgwRWRMV2xVSktOcW5NZzYyRXc4Nzc3Mm5TcDhKaWx2RGlDT205KysxamxFd3l2Q3FuamZ1WmFvQU1oTTB0QitaTENLdWk5MDh5V1ZqL1N4aGpRTU9CU2ZTME1XanE0YkFDRy85cnBTbC90TVMrVXZpdzg1d3E3YzFLaE1qVGV5dVZpa283U0NTNE5TZHF3RUNCTEpScThxUTN4ZUNHYUxndUYxUFFlaDhoeVBwb2hwOHBPNk1nUFh1eThyRHdTZTY0aDdNd3h3WkFNWXRnZ1JwNDE3MTdnbGtpQW9waHB3ZCt0dEFjWVVIUjhrQTVPTWFGNHlDZHBsS1Rkb01GMCs5UDF6VFNlVHFnVzlSeXVhQ1RUcisrNURsTlo4bkFRc21ndEl3UEJTa2tVR29FdFJrQ3lRVVpFZE9pb2IxY3hGMDk2bmthNnNzRVFBSEIwSlB0dCtmRHAzaThmclVheE92VEd0Y3l1ZjhnWTlNTVpqKytlMlBNbk1ZdkhSdWsxNjJza1dYaUNXT2F6SSt6TVVIU1hEWnEwRlFEcVVQS00rTjBlK1YiLCJtYWMiOiJmYTM4N2EzOGI2MTk4Yzg5ZWViMjNmYjRjMWQxN2U1YTA3ZDFhNDkwNDRmMDE5YjQxODQ2Y2JjZjIzY2FmZDk0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SG', '[]', 'all', 'notik', '2025-02-26 13:09:51', '2025-02-26 13:11:06'),
(470, '2382_0-tRWsYX6ZmTJNcgXp', 'SG - Win $1000 Prime Supermarket CNY Voucher (SOI) [Responsive]', '', NULL, 0.62, 'https://notik.me/api-redirect?token=eyJpdiI6ImY1OS8rMzd2amtBUmtVclh3ZGhOZUE9PSIsInZhbHVlIjoiVDYvQVZpTzRMNHRRODh1c3h0U0xoVG1sNDl2TXJGTlloY3RBWU1qMHppSG0wQ2JOaWpSMjd0RTRQdFNXRndKbHh1TmMyMUdSSEZJM2UreTdEandQclRpVkFaZmd0d1JGNnRlMi90VjdsQktDVFhVMU5YWi9MWitrMU5QZ0g0bzJSMExlUmdzTDA5R3czcVhGT1dwQ1R4MTlHSWFEZWsrb09oL3o4amVWRW1VTjI3R0M2NVdzeVY3SVFhdjFVc2hUMHhUQUxsUlE1cm8zeDJvWmRSd3lpNnlVYVFPQUd0cVMwZmlTYzFYVVJNQ3FmTTRTTlJFSG5XNnBGeGNxSnhianpqeFhjZkRLRVpnUmVIQWpVWmllVyszT1AyeENudkxPVC9sMXpmSmE5Nk5wcElhZnRVQVR4d0lYQWNFbWhjSWNtL0NSS0Jlb2hqbzlxTUk5Z1dhM3d4WU9jQjU2eWpscFNjU2RCYXRONkxSNnB0YURPcS95SW1OZ2RTREJLYlZMVEszYWRHaC9BemlhSDc1RHlkbUE2NEZpTzdNaGl2bjBxbTJEdFpqamhqN2JBTCtqLzVtYWNsM3A1ZzhtYUR6Y1RkUVNJbC9CTDlzTEVhaCswS25YYXN4UmljM1lnZ0lFYkRqMExPZHJpY3ZpUEZjNDVYMGFVVk82bXJjdmlZWHRJRloxR0w2dkRLc0dGNUdscjBNdTlGTWM5WnEycUtaOE1NQXRuVzN2MDJvPSIsIm1hYyI6ImM0YTMyZjU3OWM1M2NjMmVmNjI4MTk3YzFhNzI3N2RiZjhjNWY4OTE1YmFmMTMyOWJmNjg4MjllZWRkMTVkNmIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SG', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(471, '2691_0-tRWsYX6ZmTJNcgXp', 'Latam - Movies & Series Test (SOI) [Responsive]', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1ENU9iWmJpY0xMK2ErMzEyQlE2VHc9PSIsInZhbHVlIjoiS3J2SVFtZ2NKbXN6TUljMGdtY1Z0R1o5dlVkd1Q1RmtFcGNwdVo1bVZSWTRtc0JlOGUvZHhrcW1IS1ZyeE5NbEI3VHRsQnlBTjhDbDg1c3hsY3cvanpGaklHY3ZuSkVhQ2RMTk10STNFeTVtd3FBVFM5WFpuT0JpVGttL2RtNk1oaHdUSzVLRXdWNlRIUHM5TEUvaUhDbHZwYmw5T1JiUGxUT3pDcnpOTEZDcVFrekhlWHJCaEM5OTY0S21hNlU1bVlWbENYSzRvRzdPQmNMZklSUjEvWXY3S2hxS1lWZDlpTmhsK2ZXRjZLVktrTXlYdGtsSUJkV1lTWW5KNWRBMm9ZVmtqQlJYbm5YMEg0YnlLbm5CcU9hNTN0c2JIZjlDMko2Wm1ldk53aXNRM0NpUzBISVRoeDFGcEJWUEI3cWxkZUdnR2JwR1JWZmJNak8rcS9nZFdyaWxnOWVLR0RKZzNzdHVRS3FzN3dsM2ZKaWYyZWc5SE5XbnJJVG10QmlnZWlVTkR1N2ZUdE1MNDlrMVp0cVNmQmN6cEl1WTBBU3FWRUZsKzd1UE9ZY0labVpUWWZVSi9GZjdMR0RoRXM5YXhzQzVuTE1tWU9IMGlheUV4cFFuankycmFscSsxbHN3b0MzaWZMMVlUZGp5WTZSbldXbER2SkNZQ0dLWU9JRElVcVhLeEdNeitwWlJWUFRuUlpVSW5nPT0iLCJtYWMiOiJmOGZlNWUwODkwODc2NzA5MmI2Y2I2NzZiYjFjMzgyZDE3ZTBkZTUyY2UzNjE5ZTU2ZjYwNGZjY2FlM2VlZWY1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BO, BR, CL, CO, MX, PA, PY, VE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(472, '2754_0-tRWsYX6ZmTJNcgXp', 'MX - Win Uber Eats Giftcard (SOI) [Responsive]', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6ImtYeEJwRXp4WUFheTg1U3pRM0dQcmc9PSIsInZhbHVlIjoiWmxyWkp6cXZPakJSR1dRWGRuclNoOEJCVzRMQnpDc2MwNktYYkVEYnl3eWFNZXJ0NVU1YTF5RTFVVS94OTZDZUcwWVpuYXVmb29NWVlWdVMzTUVNVEROYnhYT2J0cmdNSlNsVTJabHNuTGk4ZXU3eW9Ga1ZidysrNUFXWHc4b0VyOTVETEwyZ1QwZ1YxTG5CeEpwVUZKcG9NaEFTTzB4Q3hmQnFCR0l5c080emZyYVFqamFxMlpvT1F0a1Q0NS9pMUFuV0ZhdC9TSkJoU3NvL2dacTFiTjZuV3pyVjNOQ1VZL0grSUpoSE5BQlM2V2JPWDk5eS94VVQ2V0dSUDk3SDNTYmZTQVZlcldQSXMzRGIrTVB2MXoxSEx1NS8ycG54L0VaYTJoYTBiMXRzaHc3NmlKWmc3UzZ0eEUrWXlGRWdtZmllMXRoUDlxMG5wT21YOVYvV2RaZldFcWhWSkZ4WjdvcnMyN0Rra05hc3hobmhJWTBSSG5KVGp1TTR4a2pwYzlOTVFFQnUvcjROYVpJZ3ZIeEJTNEQ1QkxheXNIaVBpYk04RFhMNE94Ymx2MENNLzUxMTBHbFU4ZEJPSU9qUDVSTEdJNm9lZDdYOHpOSGpUckcwV1BNU01seVQ2V1dnUVNnOFlVZ0U4SjZnZDRTRUJzMUdOTXdZVGdIUThMdlUiLCJtYWMiOiJmYmEwNjM0OWRjNWIyYzYyNTI5MTQyMWE5OWIxYTJjYzNlNDk5ZGUzZTc1MjlmZDc1M2YxYzQwMDYyOWY3NTNkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(473, '2755_0-tRWsYX6ZmTJNcgXp', 'MX - Win Coca-Cola Products (SOI) [Responsive]', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6ImtDSStPb28ycjJZMDZVWTIvK20wQ2c9PSIsInZhbHVlIjoiTEhjZ2M3QkM5OVZtK0lMajFmV2xyV1hPQTE4eXFrWTVsMEowV0JJcnBFMEFqUUUvZWFTSStiOWZiQjR4OGt3ZVFLYnhsOTR5SFpwYllsSFRvamFlbG0rc0RWbjN6aTgyYU9WcWpvbGFUd0FsT2JxeDBWOWxHYlRQNHdQNGZaWmlVM1JLWjhYRnhyTkZtZlBQZFlHa3dEU3NYazlpcTBuUDlocnZiVnJGOUJQVWFpMHBBWkN6SklUQ3RHd0NGam4rQ2J4RHltTjhralB4MmhDNU43d0N6ejllS0ZwMEIvbEh5dVYvQmRoSzUvWnVmWGRtempYWTc3NGllV3kvQ2d3cVExaFVQRXJ4azV6b1ZlUkUydFVOeDBoUVVFM2cxL29GQXZFMG5FN0VxNlZRK3BRN0dtaVIraU1QZHAvWE1ld1doMkF4ck9tWmxhMjVUMTZONU00RFluWHZlNVZFejJVaTFkUlFzSHB3ODZBWjV4Slp1UENiaUFmRDJvVmdWUXZOT0tFNVEwTk01R2Z1ODI0YzgvS2lsMFlmajhCNmwwOVZFQTBCOWFVajVCSEM1R2M1UFJDSWgzUkdOMmY5L25Md3BGNWJRemVLUkpLZlZyUm1HQjRES2hGTUZWT1FsNzJXRFZnOE5MNzdycE94NmdPQTU0T09mMUtubHg3RldveTUiLCJtYWMiOiIxOGUzYzU0MGRjYjY0N2MzODVhOGUxNDQ0ODljZTNhN2Y5NmMwZDlhYWUyYWQ2YzJiNmE5MGI3NWFiZTdhZGVkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(474, '2791_0-tRWsYX6ZmTJNcgXp', 'SG - Win a $500 Uniqlo Voucher! (SOI) [Responsive]', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IlM4Nk90WmZ5MnF1MFFVNno0ZGNEdFE9PSIsInZhbHVlIjoiZ1JleXdlVVpRcm1LajIxaVYvbXpJQndZV3Z0YkJqS2hSSzQxRXBJRFMvTkF2WFNxMS9qelNRRUdzekNnZU1FRUpHdU9PUDk2WmFaeWMvUFhvVlMvSjlHbFlmRnA1U1U3a0dBUjczblRWdnhUYllCN2QxRTdmL1lkOFBrank2R2FNdWxyd0wzeDVuSDB0N0FuMk9SOFYrandlWWk3Q0c5dmJONkcwS2VuRnRsSFQxbGUrc0MvcjVPY2NvTnpOa3p6eGtEZUZpZElmaU03eVIzdjZoTW1obmpLV2YyZWtMTEg5UVFMWUVZS0RIL01MYllCbmZ5alkvWkxSUzc1djV6Ump5dURTcVg3OXlQdnlhZ3hZUVM4RlBoS3FmZWN6cS9vV05BUG5JYWVEc0dEK1lUMWVxUGR1QmVCaG5ZVGFGeVdnU2R4SEYxWHc1WUsxbWEvamhTUlV3R3Vuem1pOHE3UHVPWEtsZElNSWF0aTlicWhZcnVtaCtxZlk5TTBQdkw4K0x3a1I2dVE2Y1VIM0VjQWhaU1dCSkJ6S0RXdDVPTmNsN3BkNDJoem1vM3VJZ2VBTitvNEwyVVo1eTlQbnc4UjJiMXhrLzNUQzVYMzFwcFJjY1NmREJpYzY0VGFmSk14TE51OUhxa2VzdTk4YVNnWjFmWTdTNjI5c1dYcFIwNHowQ1p3WEJWdGxwL0kvSVgzK0o4SW1nPT0iLCJtYWMiOiJjN2U2Y2IyYTVjYWY3YTg5MWUyOGE1NDgxYjlkM2RlMTBjMDE5NGU2OGIzMTcxYzg5NjE4MzAxMjI0OGUyOTNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SG', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(475, '3046_0-tRWsYX6ZmTJNcgXp', 'AU - DealClub', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlJkNWVjckExVXY4MWt2VVp6RFVnYmc9PSIsInZhbHVlIjoic3I5MkZZTnA4OXhaTkRJQUJmYmQ2SXU4MWgyWVdzNll3SC9RNnZYR3AwVEhRZVU5dkRDc1lqVXVSRE8zVC8wWHVrZ2d0WnM5T3pZdHMrcU9yaFFZN0h2WWFTemVWK1pZWC9CRndMVyt3VkRCS3pvaTNka1V5RmpQd1BxY3hrUUVqVzYzNkVuR1QvNzlQZzRuK0g0aUZuZFd3UUpjR3ZQNGozTm9CZFpWaDdRL1ZCQUJSVm54WHFidWVCZTBMRWNQVUM0dXBoY1lnVGtsSG05SlVBN3ZRNGIwZUNScXNSdzNNdGx1R0dvVEdYcGVsRHFWaDJTTGVPV3cvMk1oOTBONzB6QUVzSW9RalZJbG5aWWxlMWd6YkovZGpIQWhaQlBlOUFMcFhHOFIvTEFVVjBKcGFkc0JkeFNSOTBWSUZkWVAzMnI0NlBMVGdjSjdReVBrbGowNEthQWxRaksybFNZZWtwdDRVQXNhQlJwNGdJZzFNMDc0L0FPVnNLSXR1R2FKQ09kaE92bytEbFVKa0RoSHgrME11ZjN3V29YUlRpeko0TGRla0duVVlCNEM2aHovdEkwbFhnYWZjalBRalJVeWhxQ3ZlbENOK1dRR1A1UU5VNnRtK1E9PSIsIm1hYyI6IjRiMjNmZDJhYWM0NGI4NDY0YzM2MGExYTEwOGFlMmRkMGQ0YTYxYjZiMGRmYzYzZTQ1N2MwNjk3ZDY5NDg4N2QiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(476, '3053_0-tRWsYX6ZmTJNcgXp', 'FR - Back to School Giftcard!', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImJ5b2VSMi8rMXY3eGJoQ1dyTW8xMlE9PSIsInZhbHVlIjoiOTRXdVFJWGdlWktCWm1tdnV4Rlg1bEt6Y2lLcDd5aTk0eURIMld6UmxFUUlxY1RibVIyS2czYTg4QXZ4RjhXaHo5dlVmR21PRXlTNTlSRFg1VHp2cmxBTjkzRklKNDdsOHZiaXNuSDV6UWxIUXd3eHlsMWtRUkRya09nUFoxcFpLejNkQ3FBalBpS0dxL2w4cU9WcU9BT09tYmpoenRqYXk5UW9UNDJuUGppS1poZmR4WU00NVVjMlFXQmpOVWcyQ1RRTWQvd05EOWdRSjRtdVVmUkY5Y2Zobi9lUGpJMWRNUzhKWXFFcTJrQVViQ2ROUzVFZjZ3YTRWQlZ6OUFJd2VmdWlmRHM5bGhKYllvSGFZbDVkNk4wZGM0Y3ZmcjdDZGNRUVdYYXZLZGt5aDJPajd2YWJEcVZHNnVIenBod1NMRTVPSGx3RHZkUHdZQkRabnFTK2Q0bE5ZMTY0ZnhlSms4VktpTU1TaTNWdzZyRG5qNjh6b0MwN3BLTEdvZkdXZWJVUjlOaG9JQUM4Vm1rQlJnSTRSUUVPUFNraUN1TGo1YkVtdWVXTlR4WFBLTGxLUTNTUTF5WGpkTE9wRXNLMk5kTHpzRUlFcGRBOFAwbmd0YXowSG9XR3draTNVcGpIYzg2YzN1bld1aWs9IiwibWFjIjoiMjk2NGNlMDdlNWEyZmMyNTI2MmNmNWQ2ZDkyZGYyOGNiYmIxZjczNTM0MzJlNjE3YmU2NjE1MmE5ZWYwODg1MSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(477, '3054_0-tRWsYX6ZmTJNcgXp', 'MX - Samsung Giftcard!', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6IkkvVFo1NjJmOXVkOUYreVQ2UEkrUGc9PSIsInZhbHVlIjoiSW1qVmV5MHl5QndWNTdTVENBSDVsMXFWaGYxN2diaVlMdVEydDlzQys4TDFSYU9CYnR5b2ZpOFNVK21KNy9SQ01vUk5EdG1HMSs2eG1HWVArUW9XczBlSnMycEFydXZvMC9TNmVJaHhMdXpNUEtKU212OUEvVWk0MEJDNGN4bWRna2kvVVIrZWIvWFB3bzlkM3V1dzBma01XSjcwQkp2RTZOcUFhMGtwbVpHbVlQSnE2NkJBSER2clFjUEd1a1lCVFovUDZFYW52eDNVM0RTazZrbUxuWXZXcnF6bUloS2lleitocHBDMUQrTlJaMFl4ejJRazd0ZUpUaGxKNVVPekpRVjh4L05QeWhiaGdvWERFTDNjbVVHWDNjYW15NXp0aEdHK1o2Vll3RTE5Tk4vbWsxbG5oMDRuT1ZkLzlxRkxmMjRiOXRxZ3NDMVlrcXBOQ3FRbEZiNEhEOUtCdFVqWG1BT1BaaVlvZS9oeEY5Mlp5WHFlbGNMeldNOEd4N0JkeXk2Q1l1TXM5U3ZuR3cwdk5ZSGY3U0hjZGxTbGNyMVArZlZzc0xLM0cwY0JyNHJlQjhNNzNCWWM1Q09venY4eWRxVFpmaTM5SFJOYVFOT3Nsb20rV2d5NmtLZ1dtSHN6ZzlXWlhWUVkvWlE9IiwibWFjIjoiMDU2YWQxNjUyZDAyODRkNWUzNjc1MmIwNTk4ZWFiYmJlYjYwMGU0NzRmMzE5NzE2NzA2Y2VkMzYwNGRhNDRjYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(478, '3055_0-tRWsYX6ZmTJNcgXp', 'CO - Oferta del momento: Coca Cola', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6InlZQ0phYWdlNE5GRzVMMThibTFVbkE9PSIsInZhbHVlIjoid1J4bFVwdFVUTW1sS3V1WjFicytsREFQOXRoYWtwazlpVWJFTFh1U0dSNTJLK1JORnh5aVlzMUkwbGJxbWFVMFFianA5b2o0d0tYMUN0OTNPRmgva3FheFZRdlRoTERYUXpXdXAvWjF0NnZHQkp6aWFYd1dCK0d5Zkx5TlFHaFRvbGVRSFBaRDlRdDNVQ2k5bXpqbk9NcGVEbkt2a0tKVVFjT2xCQit5cGtVczgrMVdnbk9wMHlLWVl5WlliRUtvbXpzL1lOUTNWVFBrb2Y0aitDUG5Vb2YzVy9SRG03VHNBb2I5K1lZMkpUS05YY2VZSW1lejd6TnVubWp1THNkbEdrVDMzeS9KZlN2OVVUVEJXZkxqVVFaU0pQN2hSQmltanB3L0dleGU4MHhxQmFkOGd6dkNscE9TdlZUWUV5a2hXVTBiRDVteWpGSTNXaUtFcXhsYUFFeXNJK0VVbU1UOWNuNW5GRUE4YXM4ZWY0bXB3NWtQNi9PK0FsT0p5SmwyYTlqOUR2OG0yNS9EdHNDWWpQSUZSSExDYndGckRyTWVPVC9KV2hVWVNHV3pVQ0RmbE1CSVRPcnFVdjU2bGdqRnFVY05LNWlYVVdNdmw3VU90bEdBdFlIY0tDZ25lV0F2WVY4dTdTeG9wZ1FRVmsyZldTQUNxSCs0MlFtTUxrWGsiLCJtYWMiOiIyMTEzYjg0NTUyNjA1NDE2YWZkNjgzZWQxZGZiYWQ3MWUxZmQzYjIyMTNmM2E1ZWJmMjAwZWRkM2I5MmMyNDU4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(479, '3057_0-tRWsYX6ZmTJNcgXp', 'MX - Apple Watch Sweeps!', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6IlVydkxTN3hSOU03VjZ6a1YvQkw2dEE9PSIsInZhbHVlIjoidUUyRGZ0YmFFbUkxQ2ROcWRCNVVsbm1reDFCMmtWMUViKzlISVUvbHBnU3cxMHVKeERjRE9BRHRWQ25KN1NLMmJ5cHFwMmlLNFR5Y3lIOVhudGxWT1BLOHpNSUR6R0tWNG1FUDl1M1hxM0k4NjVEeUl3cXg4cFRnMVZHbll1dFZyRXEraldSczhLNkZDSkhYQVI2Y0puNXJsbWpWQUVEU2VQeG9DRC8zaGgxVk5LdnBHWi8zZUZBUEt6aFljNnJKUzdkY1pZZVloaEtOOWREWHdDN1R2WE5IdXNvbmxGTVdBWnViQ1d6MWljTmY3U0pjbEdxakxYYWZzaHorVUppNk5odXUxUUlZczBvem44NTRsN0lMN3V5Q0g4RG1JT0dvY1dGTFQ1cHMvOXNZZUwzZEtKOEhubHhmbnZqWXJKSXBmWTg4K3ZFelNTLzlEd3N3U0VuT0hPVTdXMzkzT2RTNHdQV3d1RkM4eFdCbjNWRnQ0STVIRmxBbVdkTGMybUtJUVNVRnFiemdQR2tGMEx1R1dkWk56dk1QZW9aRjhya1hXL3hNNitjM2t4VkFXWWdYQUFPZzJ1TDdRMmdVMzB6bVRiNGNtbTlqdXJ0cjVkUHlYVW5vTFpYdUxLMkZ4RmxCWk1FUUQzM0ZNalE9IiwibWFjIjoiMjhhMWE5Njg2YjE2YzA5NDg3ZDRjODViNWJhOWMyZWI2NDgwYWMyZTU0OTcwZGY1ODUzZmRjYTQ4ODM4YTk4MiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(480, '3126_0-tRWsYX6ZmTJNcgXp', 'DE - Ipsos iSay', '', NULL, 2.60, 'https://notik.me/api-redirect?token=eyJpdiI6IndtMUZpTytEZ2tzVXlSTHprRXlGU3c9PSIsInZhbHVlIjoiRFFORHBVSGhTT3BFNGlWdGNQM2NIUWh0RXFWQWlwWWErREIzZGVyRlpLdVA4ck56akRZT00wc3l2VjhyL0F6WkxDNmZyVTBsRmpIZFNocmczR29KWkNRL1dRdE9nMThKWHFWRUJuYk14d3dwSmI0ak04OHFhbVJPNWlQWm90U1NqeGc0a2JNZXRSQklCR252WVVUSDl4czRNTVFZckhDNms3VG8xSDd0R1pSNmhkR0Z4RzlsMVAyTzg0YVQrbFpQOUFuczBYWjdxWDgycmJOV2RiaTd2WUgveXBRRENwZUhpbVZBTUpQemxiUElJWmJpVm1VcnlpQkZPQmZhdVRuME1hK1NrV2ZyNG5CN3F2M3ZBTDUxcTJMSTRKNUEvQW8wZDhJT1c4Z3FZRnBJV1IzR2pySUZKV2pjNEVpUkVTVUJtZEVrMTB5MnFBSnBWTW1mTmlMWCtRamUxQ0QxcGR6NUhUZFk1eEFhOHRWMERmZysweFdBZmVDbHY2cDVFYTF6cVhwdGZnVTNlYjkzaitMZmphYWhLUjU3elF4T2xTOUV0YlRKSkdPTkMxYng0UC9xUllCVWd2enljUWpLSmtBM2RyN01DeW5yaGZVaWpQbmtYUStLdFE9PSIsIm1hYyI6IjNmM2Q3N2FlOTA0NzczZWMyMDY5MTA3ZjgxYmNhMzY5MjJiNjZlMDlhMDg4ZDY4NTJlNjljNjU0NWI0M2I3ZWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(481, '3127_0-tRWsYX6ZmTJNcgXp', 'NO - Ipsos iSay', '', NULL, 2.50, 'https://notik.me/api-redirect?token=eyJpdiI6InVSMjdvWVk3WHJWRlF0R3RDSlRYelE9PSIsInZhbHVlIjoiWEN3NnNsR2tMRDdmL0hwOGhuQ0NOV2krcWRxeGptME95djVwRG56czZaNEtndS9RTDNscTVMSVRqS08rcXNpZmp1RXVsbDNJTlRDK00rczZMZ0Y2OExXcWZiVW0xMU5sc1g1bFlrYlFaWEFLcS9yeHRxUTdnUDRrVmVNZGNQRVFhQWZ5cW1KVkZVMk40L2ZGQ3JCdGkrSitnZjFKeit2V0Fod1lOTGY0bXVSd096Q00ySGR0WVlnSkZ0c3JCaDFYSStqOHhueGxPemhFZWZmL1Naci8yLzBraUF5U3NKMWNmZlYyQzExVDcrUmo2Um5reUJLWC9nLy9qMWFqajNwTTZ3K0FVRUZCbVEzM3Q2OHdPT2c4NFp6OWs0dmh5amVuaE5Ecis1VnNNZ1Uwaytwb3FuOWRRUmhmbysvaHg3OTdTQkZFY3krd0twU05XaWwwdm1nY3RUMkJhMTNOVmxPbTZOQkFYTitzTzlnbThiaDNGTk9wRExuQ2xiSHlmMWh2MVJUcnRERkxUOCtOUVlnRlZzcE5WdER4MGl4a21TbFlYdG9OdU5KZ0F0ZEVFYys0SDExRkF5cU1xeVpLbjRJdTdNK3Azelo0RnBYRkhhNWpmVVY4YXc9PSIsIm1hYyI6IjVkZWIwMGExYmM2M2MxYmI3NGE2YTQ3YzQyZDI1ZDZmYzk1YjdhMjk4ODBmZmQyOWVlYjdjNjM0NDZjNzY0M2QiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:06'),
(482, '3145_0-tRWsYX6ZmTJNcgXp', 'ES - Calendarios de Adviento', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6IjhMOEVhOTlpZGo0d3hrcm53TzdtZnc9PSIsInZhbHVlIjoicko4T2JQK05ISFhKc0ljRmZqQ1pJNTBvOEJMNS8xUksxQXhROVNjNHd3ZDJjZnprTWZuYWNVV0VBSzB6VFl3NmRQVjlXUisrYzc0T0Y4K2pVdWtBVmNXc3kvYnBMVWNYbnFueW1UdFc1SmRIS1BsaWhkOUs2RFB2aFlGai83YTEyMXdBcXVmTEVtcHkvOVZ2QUtKb2I4MkVDRXlTSy9pcVY0UVQycFZZSWZORFZEMTdZY29pVkRTbU1TbERRRjVTRW50cksyUFNEVTVob3VSK09qWXRESlJWS0lPU2pqYThxejFDRkc5QmxYdDJ6WDB1TzJENHY4Tk5uNVpoa0JGT1h4bkl2TERuV0lIOXZiZ1hIN3F6V2MxYjhBd2RyK0diZHFiTnlBNVBKdXkxZzRJWXZFc0VNTXlLK3o2YWxSbzZCOVdwZGs1M2EvOS80ODhVOTBmY3NIWDY4dHJ2elFEc1pHa0FJNTRFTXd4T3RZTG9VdDJIK0VObVYydWc2SWZzZnBPVW11NmN1ZGN4M0cwYm5YVW1FMW8rN1BqQklnc1g2YXlYVzdWbG9vcy9ZaVRIbmpQSzB3TGRxS3M5b1lRL2VQNVZsTHhHV0RpTEJxZERvWmNOcjFkSk8rQ0RURUZCU0xZYUZveURudWs9IiwibWFjIjoiMzJkZWZlNjcwZGEwMjUyMGQ1MjRmYzZiYWViODVkNDZjODE2NDhmNTZlNmViODg4YzZiOTZmMTA3ZGZiOWFiZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(483, '3146_0-tRWsYX6ZmTJNcgXp', 'FR - Coachella Festival Voucher!', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6IkZwOUZnRUQzMXA5aGIvM0xMRVJxUkE9PSIsInZhbHVlIjoiQUszRXVKQ1VtZUdaek10bVM1azRzc2cycHYwMXJPaGtVYmNLWVdHdjRWbmUyRkc1eEdtMXdvdVRNbm1OOHRodlNMeE5pbG11RlZNUmZ1YW9TUVg3UlZlL2xDYUoweExyOFMvVlY1ZDdJSzk3bUtjUTBldHNMK0pXNzRqYkRncXVodm03RjBYQnJpQnNiVVpiMFhQOXR5RUdWSmU5QjQ0YXJMekplZklBaVE1Zks1ZEhZUmFQcU5XVGlpVlJTRTZsS01JSmFHVU11K1FMajh1enpZWmRSRGxac3VZbytZa1NWbEd5ZUpabS9iMFYxTzZYenhXUWJmdVpGS0E2YStjQktaRTBiR3NRYy9GY1pSM01sVmRKY0xDbTBvQ2VCQkhQeGZPR2VPVzdwMVp3d0tZM20wVXRFS1ZuR3V0ei9sREFROUN0TS9naVRQSDBHeERsdTJoL0lwLzdoeENNSG9oZTRjcTM0T3pwNUp4MmFMTmJoZ3VoYXZqOEhKcklPRnBwZlZ1eldFRWJ4U3ZybTYyVDUrL1BXcno2VkEybjBWQ3pTS0RtQXl0MkpKM2EwcTlEcU1IUG8zRHR3TXFnd0lTSFUrYkdjeWRhYzN6b2J2WS92QXhNSHdRMHpyVk96SUpqR0V0cktaaS9SMncrZlZ4S0hNS2IwbmxTSUJ2ZXhLWSsiLCJtYWMiOiJiNTM2ZjE4OGJmOTliZTIxMWVlZTg1YzIyZjhjM2IzYzZhY2RiNGRiYmUzOTIyMjkwZDgwMzEwZWEzY2I1YzY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(484, '3319_0-tRWsYX6ZmTJNcgXp', 'FR - Ipsos iSay', '', NULL, 2.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjVkQXZGSG04OXhMUUk4WE56ZUd4L2c9PSIsInZhbHVlIjoiUXM5Y3R0M2hKTm5IL3dzNmhFUUdlUzdmR1ltR0tRYXpQSnVCWXhlK2V4LzIrTkkrejVVQXJGbXJrWVpQNkFvSG81UXVPQlozZUVuaHQ3M28yVEExamgxblBTZnJGRXVMRTVrZ0FXSnR3SWNaQk9zd1J4ZXlXMGRJckdaeWJFQnBjRUJvRWFHcFRSOVVqQ3lxUDNyUFduSUVhdlEyU2IvYlo4LzYyMHhLS3M2T2VodnkwNk5xbENRU3ZIaHJheE5tWGtNeERtNnVRQ3VPb2MyK21xY0hkU3pDN0x4NzlkOExwajE2cjZpOFRCY2pWdlVSb0t2Q20zN1R0QzJCckhVc3BFWEF3NEk2ajBhQ0xjSjJoOTZTNmZUUmNLOSt0WE81VXpuTjJOUVliaXhHMU90MFhKdldqTmt1MFc4RVF2SktkSjZwQjhuNCsvaWdkNEo4bFdlUzlGSHZxWitoQmZzbXM0U2p4cmtDbVN0clgybFBsQmtTMG5kRk1mcUtaeVV5eTFpZElhdXcxcFlxTGs0a0FRakM4VVcyWk01SFlxUDhlblZIRGFiNGVsV2FEall0dW9iUjhRRnZPVTRwRis3b0pIdFpSZVNUK1VVSVhqbW85WTlZY0E9PSIsIm1hYyI6IjQ2NWY1N2UwNjgxZjJhYzVhM2FlNzEzZjY0Yzc3YjU4YmYwZjA1NTc0OTZkNTNmZDEzZjA3YjI3NzUwMWI1ZjciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(485, '3320_0-tRWsYX6ZmTJNcgXp', 'UK - Ipsos iSay', '', NULL, 1.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ik13UDkzcXh1NTB5MUlHd2ZmMVhmd1E9PSIsInZhbHVlIjoiV3VTMHVpNk1rMktFbHY4NW5OeGRQRzNsU2hzVC9wdFhoVVNMMkxNb1BjTDNuV0x1b0VVY2E5Q1dmWnljQk8xNkNFUjhHWEtyMmNCZG05Zmh0RlhibURVWHBnZkd3M2dCZzM2QkhoNFJlcUVWZ0JrUmNEOWpTeWR5a0VDM2ZXZG9YQXZ5QlRHbllMU3JZTkF0WXEvT09JLzc5c3VYMC9vdHJ0dFBMQ2REc1ZibE1WVGV6WmJFL2lVeS9qRUlRK2xKNk1Qc3VMTm05akZKS2llS3R4cGNiUFBPL0tjQkVsNmk2Um1MckUvNWx1WlZoWDVXUnpudWpLVTdsYndDQnJxTTRldlJSd0J3YUF6QWJqczB1ZzRnUFQxVy9mYjRYUGducy9nQVcrb1BqNU44STlUdStDeStFUzJaT2NPYng2T2xxL0tQUGhDdGVka21LTXdhTStSOHB6MFo0eVJRNEVxbm1iOGFWME9IYjc5c2NFMkFRanZOMnhwZkswcTkrSXdGeDcrOGJxZ0N0all5akt6cXhSUDB4dzRLdnRaK2c0L0xKWGxoYVV1cjBlT2s2ejJRaDN1amhWTFRiSklWT2s4VGNtNkNqWEcwdGtLa2J2RVBSbk1Mb2c9PSIsIm1hYyI6ImM3YzQwYmFmYTY2YWU1N2NhMzFjODM0MjNlZTBkY2Y4OWM2MmFmYmU4MWY0MzQ1YzlkOGE0YWVjYTYzODZmNGQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(486, '3457_0-tRWsYX6ZmTJNcgXp', 'CA - Ipsos iSay', '', NULL, 3.90, 'https://notik.me/api-redirect?token=eyJpdiI6Iml6NGxqVElETjZmejNnN0tQUlhzT3c9PSIsInZhbHVlIjoiYkFEaEtBSGUrK2xmekVlMXpjczREZmN2VEMxZ2RlenVsQXkyNHhsSTVoMmkxS29weU1CbXlUdTBTUURJcXpsUHU2RVl1UUdhUGpxSUhuRkpkUVNsWm9NN1I1L25JWXptKzlyUDVqMlIxMURxY2xVdWRJL3EyVDFTZ0tBT0x5WFdyUThROThaZmhFYXg3Z3R6bFNzajQ5ZVpJQWtyREpWMHg4S29NZGt5UUhsWjduNnN1UThUOTZLQitjMkhRN2NpYmwzcWovbUltQm9SZmhMNU1GZGNDelJQS081MkcrZ0FPK0dBMnFUNUtCVGtONzM4OEJaZzdwNHRKb01RTGF1Vk9HSWxTS2dQMDd5bHduMjR6SS9zaDhxUXFmMC9pWXNCNThiS01RQ0lZS0gzaDQ4YlZoMGVsdFBHOXJvTWxpQU1hRmgyYXUxNm42dktQd2lBZ2FrNDFtUDg1VTR1M3NXQUVuaEc5VUFXeHNPZTVTNWhpam02SVlxNENkV3BvWStXQU9zRXFPbXpHRFAxTzJpYWo0RlI4NlR5VytSTXFMNUwvQUNtd2NSenpFRUhPNExYQ2lvZnFuWU1zOGg2YjF5RzRqcnlpVStxMDdaNzJ6YlJDS1lZWFE9PSIsIm1hYyI6ImVjMjhhNGM5ZTE1YmE5Nzc5M2NhMjMyNDYyODM4M2ExZDEwY2U1Nzc4Y2ZjMGRlMjRjMjYyN2FhMjc2ODMzNzEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(487, '3458_0-tRWsYX6ZmTJNcgXp', 'CA - Ipsos iSay', '', NULL, 4.00, 'https://notik.me/api-redirect?token=eyJpdiI6IkFjVEFtRFVhWHVTNkN2OURCRkRBQWc9PSIsInZhbHVlIjoiQ3BQZlg3dkZkWml6MUpaQ2pFdUpRRTJWNUE3WTFqWE9RMk5jMUhWVzFiTlVVNlFaaGVpMm1nY2RnUVBOWVl6Mjl5N1c4K3ZDRkM1NVdRckhkTGx4TmpRNzltQUJUS1FxT1MzVS82MnNZQ3Q5cnVucTF1Q2tvdW9hRytoaUJmYjVCYzBXcEpmQkVsc2g4THpxOHFlb3M4RXNDcTJ1elV5N1puMG56cHFseXAveW1FNlc0NDc2alNFakNmZHEwUWRzamhxaHJVVm1CNjhYMHFNekVOaVcrK2NqTkhubDdYdTRmMFRXbWs4TEIwR0hHSFNOVExYOXlnaFpSL0NSaXJsVThFaHJyUTdxeUo3VHVvOTlZS3F4dDV5M2o4dTJRNnUxK3ZzUGFNVzQ1TEM5ZjdIWjlZU3RGckwvMEQyVi8rdFV0SXRnOEgrRnl6djEvSCtwTDNZT1BacHlVTmIvcnUxaG9zRyt0SUYvcCtUaGhNcDd1ZGNjR2dRZUNqOTAyQ08wL01UZ3Vya2Fhc0o5NnRWVUYrbHlpVmJEU0RBK3VHUlNKWnFRRVJXOUtRZHJaY2ZDS1pBV2t6dEMyc3BjNXR4bUsrdisvdEFHOC9EWm16YWpFNktVN1E9PSIsIm1hYyI6IjlkNjViNzIwNjU1YjNmMzcxMGI5YjY0YjYxMWZhYTNhYTUyOTdjNTFiYjczYmZiOTljYWJjNjcyOGY5NzI2MzMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(488, '3467_0-tRWsYX6ZmTJNcgXp', 'ES - Avenida Consumo: Samsung S24', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjVocVM2SDZaVFJMalJWdGFtVFYwWHc9PSIsInZhbHVlIjoiZmRxUk1Cb3ZkUjRBQy9qemorSEpwUlJIQkVCdTVVajZrOUlDYnNKQXc1RERNRzhpM1ViTitIcVFGWGVSSElhdy8vZHVHWU8wVXNwM1VTVy9Sa2wrTkV2OXVuNTlWaTBwUDVQK3ZMSm41RHFEeEtuTmZkM2JsNGhpKzVmbWFVclJVOGEvcnlZcXpQakc2aXdiOXlQR1dmYnJ6UXhOSlZmZXhWeEIwQ2V3bE5Ldkl5RkxSVEpuaUtPTGZJS21MOXBFUDF2SDRzdldGc1lCZE1pMG9oalRIaTBpWVc1YlRmUStsRFJUZlRPVUpHa2pXQzkyK2Eva0RyVUprYXhPNDNYcm1IQk5jbFZNTVI4YlZ3VHpIeGFrem16OTd3cy9DR1I4UkRMdTlRcWt1QXRQeEEvU3REalFRQ3dxR0VMYkZIQUlsanpRWDNUbDM2K2VQaFlkeTUrYUczTHArSFBUdTNDSUtaQkVLSkJ0Y1M2WTNXK0tiWHI3UCt1V1JEMkltaU95YU44eVpFb2Q3VG5lUnFJYmJtK2pQRVZuZFIrS2xKMUlCaGxqNVhBaTAxSUsyRnV6K1Jleldxd0NZWXlCMVFPSk5yb2o1dGRQTmthTE1mRFE0S2tIMkhCNWx5QnBjYlR2TERER3NrcUlSZFdHUnZCeWx0VnNkZkR6WmJrNmdLb0QiLCJtYWMiOiJjMjExY2M1MWJhNGE0NmYwMDRkMTA3YmFjNmRiYjdkNDcyMDkyMWZlMDBhZmE3YzNiOTUwMTFiOTA3NDE5ZDcwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(489, '3513_0-tRWsYX6ZmTJNcgXp', 'DE - Ipsos iSay', '', NULL, 3.40, 'https://notik.me/api-redirect?token=eyJpdiI6InplbzJIbVRueDVJRDdlOFBMKzVBTUE9PSIsInZhbHVlIjoiU2FsUXBpTmFaLzR6MStHNTFiMVE4bWx6UUg2cFU3OVd5NldzT0RHL1o1dkRXTXdZcmlPenEwKzN6Wm9ROTNTRTR1a05sV3ZnYURwNzFpZmVKZDBVVW9BQWQyYkQ5RENkYzNiandVSjBmcGJ1RnBkUEREQ05Wdkl1dk1vWXA5b2lMS1ZUVlFBeU9SNHBJU2FZT1Y5S1lPRncxQ1Z2MUd1TW9jODNydzJ5eC93RklWeVlVTVFzd1kwSFRwZ05RSkNuaGFEYzZXWFByVlhPNFZCOEU0emZzUGtxeGNZK0JFVzB1V0N2US9PbjlhRlMzdkxZNmFEYWZkNGJwN2QvK1Vkck53eDNZQUIxeXZEUUxza2dYa3RzMEczb3JDdHl4a2Y5cWJrVDNISEpJM256L1NrY0Y1aERHZk5EelNTUnhKTkF1ZUJaUXZubDZoTU51U2tSdjFIbi95VkFPTGdyV0NlLzZDYWFibGxwNlRSTlBOQVlDSGxBbWlLQkJidnc5czdLb0Q0anBJdmZ1aVFtaTYvUmo1cTJENkJCVHY1TGxsdWpyK2Q0b3VYdno3R29SZjFrRzgrZjhLWjVqTXZjbmxLYlRCTHE0dEpJMGJNNzFsUElZa2NwV3c9PSIsIm1hYyI6ImUzYjExNGYyMDJhNDI4MjJiZDY1NGQzZGMwM2MzZDhjNWNhODc2MTU5Y2I5MGM5N2IwZTAyNmVkZWY0NWI5NzMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(490, '3515_0-tRWsYX6ZmTJNcgXp', 'FR - Ipsos iSay', '', NULL, 2.50, 'https://notik.me/api-redirect?token=eyJpdiI6IlZvRG9Sbk5uWi91OXcvcDRoTFJtOFE9PSIsInZhbHVlIjoicDFVTEN2NDdEU3FPSGY5N09vVnZKMXNBb3dHNm1rQ3NwYk9CK1Zodjg3SHBGc2h1anNvVE1jTlZuSGNPMlkwcHc3OTUxMytoVFBINWtZcXVJSlVTRytybllEcnB1d0duVDBmcXpoeXJMaFc1eHJiQmZvZlVPWHArbk5OdE0zQnBHaEkyd205amJYN1VmZllrU3BKMnZMTDNBaFA3RmVJSy8rdjdtMnlCaiswUk5EL1N2ZCtwM2tQdlM1VDFGek9VZUhTczBZWGd5eVlsLzVocGlqSkM2R3puNzBzdDRXWDRCcy9ySFVSYXBoODRpUWJ0eEtQVnEwNy9wNC9KKytDMHJEMi9peityb1FWczNHZmo0WkNSTHZjMmRqQmRKTjR2TldEK0Z6OE5reHQ4bGoyakN4bVE2blQ4U3dZTGF6MDRhWUxXSktyU3ZKTmVaSGN4Yk5TQTFSL2p1eE1UQm9LRVRKSFJmTDNtblZmcjNtdCtZbk5IWjZCZ2pOcC9DWnBrMGxnRzgyRWVzTEN0bUZyZFgzTWRCdnAzVHNNOTlpQkJ1VEEwY1l5NHJWSGF3UDBnMER0NXFQUTJxd2JHclgzOVRmM01yTGxTa2cvTjZzalBrcG1TdFE9PSIsIm1hYyI6ImRhODg1OGVkZmNmZWZmNmZhMTZmYTBhZTQzOWRjMWNiMTk0MDcyN2QzNjcxNThhMDNkYzcxMmU3YTBmNWRiMTQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(491, '3518_0-tRWsYX6ZmTJNcgXp', 'CH - Ipsos iSay', '', NULL, 2.50, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1zZlRUZFh2UFpRTjhvSW8yeEZtM3c9PSIsInZhbHVlIjoicTBwWGI1c3RnRktxc0NrNUlnQzdXQjlRbHhNQ2RpUUc0SUNPb2R2cWVsMitkaUZhRE9KUUVTNVkyNFQ0QUJ1Znd2b2tsL3Q5NjlNbTdKemVjamp2L0Nnc09YSk5zdDR5eGNBbVdjbnFWVTVnbE9aVEsrRWgwL3BmcE9aK3FJRnlVM0FHTjgxR0RGT2pCRGpuVFRNNWoxTDJSRCtrSUhpM3ZBMmFvUVE5M083eWt0K2JQeGk2STF3UjV5SUJBekx6aDI1cDloWmhPdS9qdUI1K0MxUUFXaEZVeWZlQmFqLzRvUHZQbk9pelo4RTVOaEJzNjVRRnF0TlJoR1c1K2Q3akg5YVk4ZVlSNGYvaFR3MFFjNUF0ajYyajVnZ3NwZ3d4bDRteWxkRk02Q0piek1qOUNZeXNtY0l1TzdFWi9XMmRwZ3VtUXdRcEN4VEZzRi9jSmRlZU9qbEVRaTN4R2c1a09HSXVjdWxiRVExYlY3emlSR0hDbW9lV2lqcnM4NTFlNWlCanJCOUNPa3JDREw4cmoxa0gxZGFkVjJUdFNWQ3JYMXFsWFBzY053QndiRGVBOFFzdEJvK0VKdlFIQWhtS0xJM3lMUUNETGxDeFVYbk84NElCU3c9PSIsIm1hYyI6ImY0YTgzMWU5MTM3Mjk1NWFkMGE5NjgzZDRhY2NhMjYwMzU5NTk1OGNkZjBhMjIxZGY3ZmYyNjI3NzQ3NTc5NzYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(492, '3519_0-tRWsYX6ZmTJNcgXp', 'DE - Ipsos iSay', '', NULL, 3.40, 'https://notik.me/api-redirect?token=eyJpdiI6Ii92QnJmbTZsRVJ1RmxZQXRBbnVqRGc9PSIsInZhbHVlIjoiQldYSlJHVTJydkpRRVZrQkxPR2IybHkzRU81Nmc3M2VBOTI1V080b3lSUEVkcDl2QVExRjlhenN5SmJHZ0hhWUxJN21OanNGd0lzcWtvSkFLVmpEcmVHUnl2d29kT0d5Zks0M0V1dWsranNUWmVDRStkLzUrdEwxdmoxc0RIOEUrdDF4N0huQlR0RUZlOUhRVnA5bUJaMy9YYkVpOUlqVlVWLzhqM0NlNU1kNytDdnlzUGJQVG54bG9tOHFHMHYxUHMybnVENHBFcUtBbUplVlNiRVBHd3FydkM2d09MV0NqMFVrZkcwZ1NJZC9VMU5KQlFLVHltV2Vod0JuaFdBTk1TQlgza1dVZTUyVGJCZEcvRytybTM3WVJzdWw2UGNnNTJwbmwrTStUck5uL25xUGxTRU13dThKMTdySytGU0ZPdFZVT1Arc2RXS3RiSGdpRk9JdTJaMjRmMkROdCt5YXZwV3R4dmI1MnBsRGhiYVVFZnFyblZqL2FRUWE2UVIzemN2dUlsb2JuSUpjcjJkemQ4dC9SL2RMUWVxNDhVZEZIL2I4THFDTFdkVWl3RXFNTEYvTWM4aGo0RTBJMkNYT1BlZU8yeGdCM2VyNy9jU3pERFhYVFE9PSIsIm1hYyI6IjhkOTg1MmNiZjAxMjRlNjU2MDFlMjBmMGQ0NWRmZWQ0ZDE1YjYzMGQwZWExYjUwNmExNWIwODZhZjkyZDhjZjgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(493, '3521_0-tRWsYX6ZmTJNcgXp', 'NO - Ipsos iSay', '', NULL, 3.40, 'https://notik.me/api-redirect?token=eyJpdiI6Im54cmJ5TjBFMjFocFRYRkJLNGVkbXc9PSIsInZhbHVlIjoiNHppbXZlaU51RkNoTFRPL29sVERCWGEvdVJRZEw2UFRRNjFZVHl2MmN2Y1ZlelVKUUhVVktJbHAxR1NudytOWnVkZzJPMDcrbUVjdmRHelZRdW1FKzFhOVdMR2VORXUxNFpLMmI3Q1R6M2c5aWFSeUxtNjJqTGVGMWw3UEVlYUUxY1RUWDVLQ0hWTjBPN3puUVNvMmNuR1ZKeDZhREtad3ppbmxuRUhLamU3U1d5aUhzSnVhbVFLSHJzQWcwZVRpcms2UGpNR0pZY1YyLy9ZSmo0bkZWWWFSRVplbm1oM2Z5QzdzNE8wWFU4WHZRc2ZMRWVYM3ZndEN2ZW90Ny9LamEzVFVMQzFoR1Q3MFpOVlk4d2tXeFlLcnZBdXFSMUpwVTFKdGdGcUJwNlZzZlluY0k1Tm9zSHJ6SUhCMG90eVhFcktQL3ZwbndDb2puU241RFFJVitKenJTdzdsU0Q5eHlxK0Zhdi9GN0t4NTByTytTUVYxTk1yVGJOWDNaUlFuemE5d2N1dWF4UDVUQW0rMis0TURJWUNLM0FxejJkbG9HT1Y1bHdtbHlqUlo0cXBwRmVML1pxWVJMZFoxM2JZbTNYS203cFk5RUhZbGsycDhvN3dGd1E9PSIsIm1hYyI6IjhiNDM5MDYyZDc2YWVhZDk1MWZhOTFiM2Y4MjA2OTZkYjJmZjg4MzdjM2IxMjk3NWFiNjc0NTI2ZGY2NThhNWIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(494, '3523_0-tRWsYX6ZmTJNcgXp', 'FR - Ipsos iSay', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6ImN0UmsvMDI3M1BwMUxJYlJLTXBMN2c9PSIsInZhbHVlIjoibFJFQks5TDMyZEk1ZUpTQXlDbnplam83VjNRVTBkZzFjRFpsMDNpYkxlWGdmL3ozS2MycENFYS9ROXZoZjhEWVZscHlwblgwR1J3aDI1VWtWR0JpL254MS9rYm9Xa2hQZzNGdDNMVG0zdnh0a3g4dnUvcUNVTXVWOW9qYWtYbC9GVHJtWVRCRkFjMndwOTN1ZDAycVlKT1ZJaVIzZlBQUnJSTE5WL0hxUWVoRzJ4QXZWNFVqZnF4elAwYXVzZVltc25vRlZ2MlBOd1Z6T0JreEl0TTF0aWVzVDRPNXE1RzAvUVZWckx1dG93NWd1SkFpR09EVFlRTWo1VktkOFdkTkVjMGtPUmxjck9EVFlGVDdrZmZPeXBXanhUUWlyMEhVcDROV1NETU1WNDVqVVZveWwzLzkzRGsvYnVIMHY0Tk50S1F4VnZ1ckVVVFA2T242dExsN0IxZkx5RWpFUVRZYzVkeTF1NzZMdlhNaExEOFQrRjA2TlVUYlZoN1VVSVd5Y0E0emtPNk1Ub2I0WndwaEhMNnlmS0trcmVobVc3TDludDJXeTNhdDREbVJ1OTQwVi9EeUdnMmI3N05lZWI3bjlCSDRUMDJEeExEMUlQbCtZTjM3eEE9PSIsIm1hYyI6IjcyMmM3NTUxNGIyMjE0NmNhNTNkOGI3ZTRlMTA5ZmQxMzQwYjlmNTY2MjRkYTMyMzFjY2ViMzYzZDI3YTU0NTciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(495, '3526_0-tRWsYX6ZmTJNcgXp', 'CH - Ipsos iSay', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6IjExNkZDM0Nva1VmYW5tblhycVVBbmc9PSIsInZhbHVlIjoiakJPV3ZKTHhmUkJCYk1FMmxkN2Y2aUFUZTJ0Mnk0SnpBbGpJUjVFL2oxb0J3aWpzZzB4eGdkc2U0djBtSVlPUFZnWWNtRmhPbzZHUUlxQU5ndzFDNSs0YlFtb0ZTaUp6dkZIMzZJMkVqdDM2WExYcmhmZkZ0a2ZVWWgwbGxuTmxhUnhuSGR2cXJNS1VSSUxEWEhvMEpvbDg5Q25KU3IxQ1BsL09NT0VwNGc5UW82N2dvRVI3dExWRE1xbDVEakRFb3hMcEFXMmFIM0FDelZLc0srekxMUnJoSGRlOXpGTW92aEtZRys5WU53WWV3L2pUbUlKaGpNWjg5SDV0R0lMaFhteWdKYUc4cTJXRFo5b2ZpTUxnSmRPWjBmVnNKUk5pSUdVV0xCYUl1akVTUnNOWEs2NlRHUTV4c1pqdWVxRkNJQi9ZQk9RdHRkSWZUZTl6dHdJQ0RyeDR1eWg3enM0ZE0xSjk4MUR2TUxhVThmM2pMdkd1QWNvRUJUaHM3clRsb04zQnErckl0VERWRlNVTUxQK2NhUUlkQVY2Y2xxeTMyZHFCM3NaM3lhcnhxUGhBbVBzNFNtcFVaUG9OdHUyZE9FT3UzN3NlVHF1NWl1dnNRU0dvUmc9PSIsIm1hYyI6ImFiZDZhYmI0ZjQ3N2M3ZDEyZmQ5NGQ0ZWEyMzdmM2I1ZWViMWIzNzJkYmNjM2IwYWUzYjM5MzA1ODBkNTM1YTMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(496, '19639392-Gw2CpYHhjF69lDdJ', 'Berry Factory Tycoon - Android', '', NULL, 0.32, 'https://notik.me/api-redirect?token=eyJpdiI6IjRhOXlOSFdULzJXb2I2dDBwaVRnbXc9PSIsInZhbHVlIjoia1FvYkMzNm0rNzJ4WCsxeGFNbHJWcHo0ei9sZmp5Z2VBaENldDQ4WUpJcnhUc3gwUit0Qnh1Z0RXelNPNWJEc0xONFVxMnB6S3pSWVNnVENZVnlvazBCNzhqdTBKU054SkxJd1ZmZGpIU2lnWmk1UjV2Zk9YRDl5WEVTQ2NnUS9EUnBZenhRRTViUXBpYkZEMHJ6UFhDOWNMK1JhbE9wY24vQUNNNXJoZkVCVmpZbzZQaTRsTjRScjNFY1Y5NmkxSmM1V2VGV0lwZUpqQmNISzQwcVJRYWlFbjlLQkhySFYvZHV3WWVsRUpEZWhXRnBNZitoTVM4c0RjZkNOVkc4N1lrWkxPdDVYNU4yUWladlUrdE9yRmR1UVNmVituNlcxRjJTTjBLbk9ZSlowcWJPajJDRzU1OGVOZWxvMVJHTGpudUhMbUoxNlFoVExzbEc1MnFzaENRPT0iLCJtYWMiOiJlNjIxOTdjZTkyOWI1MjgxNzE4MDk2MDZkNjY0MDhlOGY2NTc4Y2ZjNGZmNDM2NWI0NDAxMjRhOWI0MWZmZjkyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AR, AS, AW, AX, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BL, BM, BN, BO, BQ, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CW, CX, CY, CZ, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GD, GE, GF, GG, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IM, IO, IS, IT, JE, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MF, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, SS, ST, SV, SX, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(497, '19639393-Gw2CpYHhjF69lDdJ', 'Berry Factory Tycoon - iOS', '', NULL, 0.27, 'https://notik.me/api-redirect?token=eyJpdiI6InRoOFo0WURlZzdIMGxob203UXBRU3c9PSIsInZhbHVlIjoicGpFN2FRSEFISXFUaFo0aXd6bTBFQmtuVWVyRVBHSFRseDdnUEFZVnB5TVh1M2lVUktJL1o4ZUhJL1dqL0M1S2E5QXl2ZlZsTlhxcExuWDRZWXg3L3NoNTg1b05PRDBmdkpFYmV1UXI1dzdrQmh5NURBVGoxczRNNDQyK21Nb3RaSUpJb1E4T1R2Q3c3YWt1eE9ielFJUGRod1RJRkFPSW5mbzk4WXRHNE9mbmdyN3VxM0xmckVxVytmVW5Sb2hKNHpRTDRTWU9ySFMxR2h4T1VRV25qU2grcVNXYlFUYlltNlkwMUx5S0hCcmZFOUpHZmxYS3ZuYzM1ZUZBdFhXQVBBd3hsN0R0cEZnZW5aNStMdEFrUFk1TlNNNXptbEhuT0tmNGlVTFZuQkZjdHlWQmx0WmlLM2dOTzhmNkdFZW9RWEM0TXVuZHJNRGpaR3dRZWF6TExRPT0iLCJtYWMiOiIxZDIzNzNiYjkwY2FjMDBmNWVhZjc0MmRkMWQ4YjRhMDgxMTAxNjQ2ZDNlZmIwNGM0ODBkMWY0Y2JhOWMzNjE5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AR, AS, AW, AX, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BL, BM, BN, BO, BQ, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CW, CX, CY, CZ, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GD, GE, GF, GG, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IM, IO, IS, IT, JE, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MF, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, SS, ST, SV, SX, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(498, '19607158-Gw2CpYHhjF69lDdJ', 'Donald\'s Empire - iOS', '', NULL, 0.30, 'https://notik.me/api-redirect?token=eyJpdiI6IkFCejMwdUMwK0FNY3lwSTEwTmdBSEE9PSIsInZhbHVlIjoiRXpkRFRVUXhTbGZ6VW1DWG9MQzh4UmhmZmdXYjB1M09UMTRTMSszRUhIbkpHYzdMK3pyRDVSZWw3cEdGWDNIVXFGMTVjSCtnYmhKWEo2UzVlVGhxU3pWV0N1Z1VKVkt1d3loL3pDVU9XaWdQMzhnSlBsWjV6bUQvTEc5WWs5cml6VHU2VXBwSnUvMFliTEdobUFkM3RVcjgyK0c3SloyZG5sVjc2NFg4VjVwYm9OOURaNVZ3ckExalZGVFJsNjBiYmJhbDJCNUNxc2lOR3F4L0djZHlzY29kOHJ1RVVEcFlkSmhoclQ1QVVXelNIQTRFbS9UcTU2YmJBSGxiYUlQMUZXOXVaRFNJbzJMOFhuaXFYTExHZ24xUkRCK3dVNzFKT25PTHJvS2hNUWdIRzV6UDNLaTdCWXFPYjVOUUZyaGUrUXorZzE4NFZpOGtJdWtaOU9MeEZBPT0iLCJtYWMiOiJjYTY2NDg0YmNkMTFhMWEyYTE3NjdjMTFhYzA0YTVlODM4YWJkNDI0MDZmYWJiNzhlMjNhZmY1ZTUzNjA3ZDE1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AR, AS, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(499, '19601443-Gw2CpYHhjF69lDdJ', 'Climb the Mountain - iOS', '', NULL, 0.65, 'https://notik.me/api-redirect?token=eyJpdiI6IlZxMlRITVA5c0F2RjUrdFY4NTRsRnc9PSIsInZhbHVlIjoidGFJRHpEQjJBd2dmTTlISHdGNWxHdm9ncE1oNDlKZkRHRHUzQ0JRVkQ3SCtjNm5TRy84SW5yeTFTa0h0R2M1TnFITWp3MjA0c0JXMGNqcmlRcTFLMVNJZWREQy84bk1ISmxvcXFHK2F5Q0lPcnRTU2VBY0doOU9rdkJYbGRMdHZwUlhLaWp2NVJOL0VwUHl3MVJ0YzRzZUhtUlRBck1PaTdYK2NuWW9sNFQ5cmFIa1o1c1RhdTZKcVhISEcyNFZzYmRMYWc2NzBXMElvRnFNcHJ1QllFdGdUY09nMjFmbG9sQWEwK0RqR2tmaFJma3dpcm1XdzdCYVROK1ZJdmRZYVFya29wNG0waVVRWVA2VmljNzVNRTNIa0kxQzJJQkZHTHRUcHFLZlVaZjY0dDkxMTBTSUN1aE9hTzNIUGNwbFgzejBnQ0lORU5zblorWFQyTTlwYXRRPT0iLCJtYWMiOiI3M2ZkYmVlYmJiYmYxMDRmMWZlYTA1OGFiZWY5YWMyNmJmZjNkNmU5YzlmOGViNTJiYWNhM2QyMDI3OWNlYjM1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BS, BT, BV, BW, BY, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, IE, IL, IN, IO, IS, IT, JM, JO, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MC, MD, ME, MG, MH, MK, ML, MM, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TT, TV, TW, TZ, UG, UM, US, UY, UZ, VA, VC, VG, VI, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(500, '19607155-Gw2CpYHhjF69lDdJ', 'Trump\'s Empire - Android', '', NULL, 0.19, 'https://notik.me/api-redirect?token=eyJpdiI6IkpMTWdsN2FrVm5PcTlHOFhwV0NUSXc9PSIsInZhbHVlIjoiVXI1L2YvVE9oL1RtU3kvOUtEMWtwNlZGbGhYZjh5QmdMOHFaTE5KL3VyRU5BYVVQRXpXUVpjRERPWWNUbHdvSXpucXFmc3h3NVpzWXJ3V3ZjbHVuTFZTVW5qdGR2Y0FkOFVZc2Y3ZmdwenQ2b3VCZnRJa3JZTEU0Z2ZyK2VGenExSklVQ3F4eUEwTkR6SWNwc0RUdXZob25pNEEwZ3R4ZjB2R0grNjk1b0dpVlpWWFpyek5ROFNkcHUyS0Z3TzZ0OXFyUGZBLzhySmZ3NWUvcDJYemFRVXZlUDJHblNXbHhWVHRCeXhGMmZMMTBUZnFabWVWV3l1UDg2NUo2UER3eU45dmMwS21XcWROZkkzZFhQQzZJWTI2WVl4M2NHUjNIRU9WaGU2SE43dXpYM1labEJaQmxNWXFTYnR6RjlUT1hjU0QyVzRXRUdSQllNMEwxc0o5TXdBPT0iLCJtYWMiOiI1NDkwZmU1MjQ4ZjYzNDAzYzA3OWI3NTJkNTQ5M2QyYTliYjBlZDA0MjMwZTY3NjJlN2UxODFhZGFlOTIxYTU4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AS, AT, AU, AW, AZ, BA, BB, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, EC, EE, EG, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JO, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RS, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(501, '19590289-Gw2CpYHhjF69lDdJ', 'Diamond City - iOS', '', NULL, 0.33, 'https://notik.me/api-redirect?token=eyJpdiI6IldIVGcwZWRiSEhmeWVzVEVYTkJtR0E9PSIsInZhbHVlIjoiY1VOTWJBV3pZeDI2VkhQQ1RSaXRvdXFwRldnQTkzbWFGN1FOZytEVHJTdytyV1V5WDQwQkwwMjJqVGRzUDFaODNrWVVHMHBaQzZtYnNnLzdvbTFpdDc1NFpyMUxwYTJzSzJCdXUzL0FtVEJWWDJCT3czbUV4UE9MS1RuY2hTVkFHQW1naFVZeml6dHcwNm83MDJMV0hLeEI2b015NlJ4WGtkYmdJc0U4VU5yYmRCOHZkWFc3ek41dEl6OG5MUjFQV1hJczZvd29xUDRubmJEOXpBMnZKaE4yNzlkK1pLL1RCSHdKak9DczZnd1pTemtJVE1Lck5acFpINm5NMmYwcFAwamYxU3Fxbk5FSlVKa2lsT2Nab29hR3lpWmpzaklzaklPcTN0SUR2b3dFcVFmN05PaE9qcXN4VDN2OGlweFMiLCJtYWMiOiI0NzhhMDQ5YmI4ZTY2ZjhmYzBiNTdmZTkzNTZkYjUzYzkyYjY3OWY1OTc4YWVlZDlkOGZhZTMzYzQ5ZTRjOWVjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ, AR, AS, AT, AU, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BR, BS, BT, BV, BW, BY, BZ, CA, CC, CD, CF, CG, CH, CI, CK, CL, CM, CN, CO, CR, CS, CU, CV, CX, CY, CZ, DE, DJ, DK, DM, DO, EC, EE, EH, ER, ES, ET, FI, FJ, FK, FM, FO, FR, GA, GB, GD, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, ID, IE, IL, IO, IQ, IR, IS, IT, JM, JP, KE, KG, KH, KI, KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, ME, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY, MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TL, TM, TN, TO, TT, TV, TW, TZ, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VU, WF, WS, YE, YT, ZA, ZM, ZW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(502, '5955876-euMJk6uxkZa7CT1I', 'Forest Cleaner (Android)', '', NULL, 18.01, 'https://notik.me/api-redirect?token=eyJpdiI6InlIamY5TEVHcDZDOWZHS2JNdm5zeVE9PSIsInZhbHVlIjoiYjdHcGxUQnZjeGV5TDBaa3V0MlUvMTRHUnlmb2J4aVFKWVRhR1hMNjV3dTNSVWprdEd5WDFUNlZIMFY5bldGeStyNW4zUy9xMkFiNTVYWWF0OU5UUHRyeEVEQldXV0NURTJOVXFnd3ZXZzNXM0xIazA1UzRDTEc0bWUzaU5saUh4WlN5WmM2T25SVjFXelFXcjNOTmluakZQbmtFdWZza0xMVjhxVStXUDUxc3hqZFkrcnhXdHRCcDIvNm9RK09lUXZxMHdZQUxkbUQyME1SbFhqNlRRcXY4Ylc1OGtZcithUEtQcFJkQmticngzaDk5UnkrckVBQldESWsvT2hKYVdRLysxOFRFTklxT1ZlQ1NtQ2JuUGI5Q1Z4dEpra2xiY3AzL25ZSmpBTnRHcmNHR2RVOGUwWWZuNnByMTROZWNuc0JRazRySUtWMGlYVXNIb2hrN21RPT0iLCJtYWMiOiI5NTRmNTQ4MTQzMTVjMGJkZGI5YTQ5YTEyYzYwMTMxZGZjM2E4MmM3YmNjNDRhYjczYzVmOTFhMTc4NjczYTExIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":5143,\"name\":\"FC Player Reached 200 Distance Level\",\"payout\":0.0845},{\"id\":5144,\"name\":\"FC Player Reached 500 Distance Level\",\"payout\":0.507},{\"id\":5145,\"name\":\"FC Player Reached 700 Distance Level\",\"payout\":3.12},{\"id\":5146,\"name\":\"FC Player Reached 900 Distance Level\",\"payout\":3.9},{\"id\":5147,\"name\":\"FC Player Reached 1000 Distance Level\",\"payout\":10.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(503, '5955878-euMJk6uxkZa7CT1I', 'Forest Cleaner (Android)', '', NULL, 16.42, 'https://notik.me/api-redirect?token=eyJpdiI6IlBpdjBTcDJFRGVLTnRWbFFoNGJ3VHc9PSIsInZhbHVlIjoicitTaDhneGxrc1g3dnlGZmVVTmhicXFpcUlraEJOS1hidmNxVTVDM1dFVWwxOUJTMXdoYXpSOXNTSXd1NUgzbUYyQXRtVmljK3Y3eGsvcmpoRGlxRWR4cXFzYWZvaDhNZkNJSDYwVnJuWTJJbnpDekhOdFFiMHMwMSs1NGlOYjVRdXE1bnI1alkzNXhSQ1lTU0tYdXRFRUtGdngrdmNCT2NNQ3BRblFwcUs0YndMaGY5cnhHNVJpUzRnbTdPQ2I2REhVdXQ1SHdha1RNYWQyMG10eGVrb1lOTUtQUlhLcCtkMDZXVi9FdVhCZDBWeUhKYjBIWThwY0QxK1V6V3Bmb2Z2cU9wblA3OG9tK1Z4VWdWNS80bkhQeUlRL2N5M280akpQakdkbTFTMkZoMG1ZMEVVVko5UVJyVERyTWduOStTK3ZZcnJiWGJwOTI3cDZxNHE4YkFnPT0iLCJtYWMiOiI0ZDI2YTVkYjlmOTY5MGUwZTQwMGNmNjY2ZDc2NTY1MTVjMjUwM2QxOTI5YWE4ZmU2MjY0YzQ5MDY4MWRmNjM3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, GB, JP, KR', '[{\"id\":5143,\"name\":\"FC Player Reached 200 Distance Level\",\"payout\":0.06},{\"id\":5144,\"name\":\"FC Player Reached 500 Distance Level\",\"payout\":0.36},{\"id\":5145,\"name\":\"FC Player Reached 700 Distance Level\",\"payout\":2.8},{\"id\":5146,\"name\":\"FC Player Reached 900 Distance Level\",\"payout\":3.6},{\"id\":5147,\"name\":\"FC Player Reached 1000 Distance Level\",\"payout\":9.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(504, '5955879-euMJk6uxkZa7CT1I', 'Forest Cleaner (Android)', '', NULL, 10.82, 'https://notik.me/api-redirect?token=eyJpdiI6IkNlZGVjOTZraTNqNWNmenFUdEc2R0E9PSIsInZhbHVlIjoic1cycGpiTER0STc3eTJNT003Uk1KS1hvMkRKOTJSL1djTHl1Smh4UkRaZStnMXNXUXlIV280Rko0UmpsWTc4Q1dSOERqWG1HMndrbHQzeXB0aVpGeDM2eXVKMXRSNitpa1dsbDJpc3NlQS93Y3dLODF1aDQ5Tk1xQ0ZBb3FjSnhUT2Q0WW5ZYWRDQVJLemQvT1dOSzdMVzQ0ZGROeFhHaGlWL2Z3bFJ4SE9md1Vuc3AwN2Z2MzNKR0lqWm51bDRFZmdWT1JQbWNSYlZpc253RUxtY3RBaUkzMEwrNFd1alM2RHFheUR4blpwckFsekRXMWh0N21aMTRlQ1ArcnVPR1pjRDVDdkdHOXJLTnVWeitHTWVIMm1aQ09kWWNUU0wzMUc4UlgxaHdhQVByNlplSWpzY0VIeUNxN1BMeFN1N25CRHRORFI4cnZ5WmI5dG1ia00ydVRBPT0iLCJtYWMiOiIzMDMwODdmMjI4ZGFmYjI2MGZkNjllYmJhM2E5NmM3OGRmMWZjYzFjZTU3MjhmZWU1OGU3MDBkOTg5ZWNiN2RiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, AU, ES, FI, IT, NZ', '[{\"id\":5143,\"name\":\"FC Player Reached 200 Distance Level\",\"payout\":0.0445},{\"id\":5144,\"name\":\"FC Player Reached 500 Distance Level\",\"payout\":0.2495},{\"id\":5145,\"name\":\"FC Player Reached 700 Distance Level\",\"payout\":1.9865},{\"id\":5146,\"name\":\"FC Player Reached 900 Distance Level\",\"payout\":1.912},{\"id\":5147,\"name\":\"FC Player Reached 1000 Distance Level\",\"payout\":6.625}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(505, '5955880-euMJk6uxkZa7CT1I', 'Forest Cleaner (Android)', '', NULL, 6.89, 'https://notik.me/api-redirect?token=eyJpdiI6IjVtYzYrVFR2SDRKMzdoY0p6ZFFNcEE9PSIsInZhbHVlIjoiTXNESTgwQm9JUkhCbUJyQ2o3RVl6bHFhanN5UHp2R0VtT1NmZUNmOVUzendTN0J5SFhvZTdvSGNVbXZ3YzhLdWVHTHBQZGNKdGxKUXpMa2xoYXc5YVhOMFF4UnZYTUFmcU9zd0loc0ZRcitVYlI0VGJRa0t1ck9helZCQm4ybzViMUhMUHVILzJXam9sMFZGWDRseHJiS3lYREc1d0pjREZqalhEdndLTUtQWFNaMUFmQkwzVTdQTElaZmswYmo0WURacVkzc1ZzS0FXaXkvMHVEWFRnT1ZCaDBSRWJjbUhUVUZsV29rbksrbWRIUXZDOVpIZmtWRG9kOThDdG8xRXlkQzZMQTdYZ215VVIvQkNrVG9YbndUNkR5SWp2YUVoUFc3cVpFNTJ4bzU5VW9rUmxNa3ltQzlPYkhkaUhQNzArdXI0bklkQ0dOb08yeHFWclNYS1FnPT0iLCJtYWMiOiI3OTdjOGEzYWVkYjMzZjc2MGY0MWQ4M2UzYWFhNmQ4NDA4MGFjM2IzMTFlODk2ZjE3NDcwZTdmMWNmNmY5YTM3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BR, CH, MX, MY, NO, PL, TR, VN', '[{\"id\":5143,\"name\":\"FC Player Reached 200 Distance Level\",\"payout\":0.0105},{\"id\":5144,\"name\":\"FC Player Reached 500 Distance Level\",\"payout\":0.177},{\"id\":5145,\"name\":\"FC Player Reached 700 Distance Level\",\"payout\":1.3935},{\"id\":5146,\"name\":\"FC Player Reached 900 Distance Level\",\"payout\":1.742},{\"id\":5147,\"name\":\"FC Player Reached 1000 Distance Level\",\"payout\":3.568}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(506, '5955884-euMJk6uxkZa7CT1I', 'Forest Cleaner (Android)', '', NULL, 4.82, 'https://notik.me/api-redirect?token=eyJpdiI6IlV0Rk9hRmxQaEtSdE9sY1kvYTdpL1E9PSIsInZhbHVlIjoieEx3ZUxWUWVmNEFRMW56YVJXdmRTbGc1aEpVSUVPZkNSOUxuVjNoZ09GZHd1cXBJWk81MWZOZWk2bmZobzFqZVZPN2IyaFp0d0xkUFhyL1p2a1REdUpjeVExS0p5Y1o0U1R1SFhYSWZucjdBSm1hNlBTOEEyNjY2NGs2a2pvYkIzMXlVOXJ3Nm1GMG84Q1BxbjhwZERQczZXZ2tWZUNYWEtNdGl2MlpCRVhURW9HdzhiZkdwSy9ISllGQW9Bc2Y4Z0RlVGVHL1NQZURKdmhXN2w3TXNkWEFKTkhnUklhV1BnNHRSdFlEdUdGekhubGxsdmlwNmxUNVJCdk9zQi96Z0dYL0RUNFBWRnRVeWxrN2txSTdvZjA1bnVFdGZwbFhiSXNCOHZSaUdRbUxCYTBGTU9NOENqdktZRHR3blcrK0xHTmxJOGlwbFRnUndVclpaeUV6eXdBPT0iLCJtYWMiOiIyM2U2NTcwYjZiODUwMTY5M2U0NTAzYzUzOTQ4MDBhY2E2MTBhODg0NDIyMmIwZmY4NTJiNzI5YTk1YjQwNTdhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AD, AF, AG, AI, AL, AM, CW, AO, AQ, AS, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DJ, DK, DM, DO, DZ, EC, EE, EG, EH, ER, ET, FJ, FK, FM, FO, FR, SX, GA, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, JM, JO, KE, KG, KH, KI, KM, KN, KP, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MZ, NA, NC, NE, NF, NG, NI, NL, NP, NR, NU, OM, PA, PE, PF, PG, PH, PK, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RU, RW, SA, SB, SC, SD, SE, SG, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TM, TN, TO, TL, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VU, WF, WS, XK, YE, YT, RS, ZA, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[{\"id\":5143,\"name\":\"FC Player Reached 200 Distance Level\",\"payout\":0.008},{\"id\":5144,\"name\":\"FC Player Reached 500 Distance Level\",\"payout\":0.1225},{\"id\":5145,\"name\":\"FC Player Reached 700 Distance Level\",\"payout\":0.9725},{\"id\":5146,\"name\":\"FC Player Reached 900 Distance Level\",\"payout\":1.2195},{\"id\":5147,\"name\":\"FC Player Reached 1000 Distance Level\",\"payout\":2.496}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07');
INSERT INTO `offers` VALUES
(507, '1280002-lZ2kToJFfVYWxuk6', 'BUFF.GAME', '', NULL, 0.64, 'https://notik.me/api-redirect?token=eyJpdiI6IlB2MXF5bU9vaWh4Y0s3U2hhOEpVL0E9PSIsInZhbHVlIjoiRE1qNElERS9Vam1sT2xvR1NDRG9YLzVvR1hrV0w4V3Bqa0tJN0xidDU3cElMcnltYStXbmVCL2FhU2xGRWRyOE11SXpaWDY0Qko5Y3JFQUJpYXJsTEMvYmZCeHJNWHlBc2hneHBVSE8rWU16aDQ5NlVNSGE1RFAzRHhJQnlGQmN2Smx0MWd0VVQvYnlGeDBzekI4eE03S1BwTjh5ZnIzWHVKL1RJU0doQk1OVXdud2FYdTVkQmROc3FGZTBxWVlCVjJIZGpiTWsxR1VIS3R0L2FpSUoxZGU3THl6cGVFSWE2Q29zRDdZUTJyWXQrbWNWUXBnUEM0N24xakJaVDhyL2pyeEJoaGkzNkR5TTcxcVNOcVFSU3c9PSIsIm1hYyI6ImNjOTY4MjQ0ZTE0NGFhMjUwMDliYmRmOThkMDhkYzM2ZDg1M2Y4M2I5OTdkMzUxOTcxZGRkMGFhNDY0M2NlNzciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, DE, MX, CH, GB', '[{\"id\":\"55b56a08-4466-11ef-afb2-069eb31df495\",\"name\":\"Registration\",\"payout\":0.04},{\"id\":\"55b574bc-4466-11ef-a7d2-069eb31df495\",\"name\":\"Paid Subscription\",\"payout\":0.6}]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(508, '475958-2XbuH9HCRPa2JpHn', 'Nutella - DE desktop', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6InNYbi90em9vOFdQQTF6SmRvRktOaGc9PSIsInZhbHVlIjoiWGZ3czk0bTkrNDNHaENiVkJJSTJYdDB5NmNaRDg2blJWOUFkU282ZGV1TkFWZXJHRGJXWHFJbEVsYTJjSHQ1TXpCeEhSTHZYWllGcHc2WEZaQnViR01hTkJSMGNyK1BaaGVBejN0RElZTEhvZWlwcXF2VXpCNFIzVURZTmhsRDVtN3J3cTdla0dTU1NRL0ZhaXZ3YXl5d01YRG1CR3dOSWVYTkxoYmRvUE5hcm4wQktRa3NPcEwwMU8zK0d5NktvamJPb21aS2VJbkpYVlVRaGltcFkxVTM3bk16UCtkNDNEK05zNnhhcjZObVFTc3N6YnZBZWl4QUZvRUM3MWtscDkwZ1J2T0tNUTM5UUpGVU1iZmRUeFNqNTVvWTF6Y1VqQis4b0o3SWRoWll1ZlRlRlZNN1hZNjZETHpQU0FDTFZMaDUxMHpaVkRtT3VCMXlTbERQMkg2a2k1VUNiYUNOdldVZUlvQUo5eG5SU2pNWEM1U2w0YVZ4b2VzUkFSekNpIiwibWFjIjoiNzY4MjA3Y2Y0M2YxZDYyMDM2ODlkZDZkNDA2OGY0MTNmMzFkMGUyYmZmYmU0ZTA2MmFmODlkNWQxMTU0NzU2YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(509, '475959-2XbuH9HCRPa2JpHn', 'Audible - Free Trial - AT, DE, CH - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjVPQmFxWEk5VVhGckhaNDFMZit2NUE9PSIsInZhbHVlIjoiQ2lNV1M1R3F3UURrUzhXQmR4cUxjOFMyUXJRV1ltZFU4ZEJrU1VKekI5K0c4QzE1WEpEKzhOeC9qWHkva0o5SU5LT0dzTDlkYW83N2ZOaUFqZElNV3QyTGFzR2lsc3I1WHgwbStnRHgwWmppdkU1eXF4OURhbFdYa2hZbE9CaVZlZjZ4RlpHOWdoVFIwblBaa0VtV3hLQ2dLTlZJeWhGMjl3NFR6TW9lZThCTFJUUmUzTldQWDkwdktCN05Hb1c1bG41RGlVWHBtNU5wUXZKdGg3MTIvZzNWRXltR25WakJjOW5pQWx3bkRYRkp4eFVnZEtGVFlualhQcDdMRGtBZjMzcWRhMEptMUhiZ29ScFhUZzBDMTlsdFMvb2g0ek9VSkZYOVp2cktBWmNub2VZOTRyRFkwNnVHRHZtSWFPZklQaVJYZkJQMXlXVFNlUjgzZzF5c0RaQjhMeHgrT0lXVVl4N2NJdnlURmE3VENGWmIwWVBQSWhmUWJEZnFoYnMzZStPRWRjNFJhNmE2aXpkSkU3aGFWazE5YmVTaUJjOW9qNXRKRlVScTE5az0iLCJtYWMiOiJlZDkwZDViYmJiYmJkNjUzZmYxODM2YjQ4ZGNkYWI1MDI5MzQ1MzNiNDE3OGNlMzVmZDhhODRlZTk2MjRiZDc5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(510, '475976-2XbuH9HCRPa2JpHn', 'Amazon Voucher 100€ -  Complete the form - DE - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6InB1QzRTZmYzeDJjU1l0eFlWMnlNR3c9PSIsInZhbHVlIjoiaUplTjRmN2ErMGthS3RhSmI4dWgvbCtJZS9za0EwUWsreW1ZVGVid3BvVXdINTZQalVEWlM1a1IwMVc2Wm1GNGl6MEpKaW1Xa3NLaHVBemVwM1RBUTVkdGxaK1NGM05KRFh2QjRsbE9nK3g3eVVlbEZyMmlpamEvVXQ5TFdpSk1jQVk2VjVyZVVCZy9Pd1IxZ3FkVUh5SUNOamdodk1uTTd2SFdMY1F6RmhlWVk5SUd6KzdaS0NsbEJYUmRlOVlYdm8xdDRyVW1rNmprRW9JTmJVQjk1T2luckNVNG54TjZCN0ZCME1NOUhMamp6QnJHUVFlZU5xQjZERkhjREhibEhDTXVBcGZ6c1ZvTEVtWThOSE1TeG9kS0FZc29nbVcwaTFQZ2tyeEhlSHRsSTl5d0V4TjBEam5mcm90KzcvQURsSDQwRkZWdVUvTEhDbkNZa20vam9jaTlHVUtRTCtNS1JkMk5FS3dtc3hxam5ONmxGaUx0dUNNeUtYdTVwR2M3blM1eFZwTjdtU3BJaWhNdGpkTHN6bFp3OWZqRWpnL2NjUmtNUmZ5U25FdUhxT3U1SE9obnR3b0FNdllEVHV0dyIsIm1hYyI6ImFkMDEwMTFkNDJhZDRmOTQ1Y2Q0ZmE2ZWY4MjAyYTE0N2M4MzRmZjZhNWY3ZmRiMWFiZDc3ZTg0NWE3ZGFkYzAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(511, '475977-2XbuH9HCRPa2JpHn', 'Media Markt Voucher 750€ - DE - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6ImRDUGo0RWh0dDZLOUtUaEQwQkVOdlE9PSIsInZhbHVlIjoicjlHbWlqMWJLSHVLREZCY0JTdm9uRzRrWTViV0twS2w4SUwyallRek9sYnNwVGRxWlR6bmpsWDNGNDh1WVpFSUhQN0o2VnZ5NjlnVmxUV1dSK1VyQWtTZHdDS2x2dzJId21nWkZpeU9LNzhKakU1RW9YN2pQMWhRbWVteWgwSzB1U3Jyay8vRDFvc0d5NGYzMk8zYVEvZE5TTFZYZWVMcy9IY0J1K2tHaWxNU0V5dlFFTUdDdkh1OU9Vc2lPL0tTSWdCY29nYmI2aHRkUnRKdW9GV2lIc1FNWVpEUytncW1PenU3Si9pd0ZSL1NBYjMwb1JzMFBEdHZvWGVmOG51dGFGMjhvaHlxSnhHMHNQTmdEUkU3Uzd6MlJ3Tm0wMG56UFMyMEN4WW41ZnQ1Rk5jZmowcTNDMUloOHZNZmEySWgzT29ueUlKM1hxQWtTTFlFb0dKUzR1NXUxRlR1Szg5TTJ2RkhvMDl6ZHhyeEZ6dlYzdHgydjRNeGxGWThHWUY5MkpML2FmYWpzZkxZMFdnZHhzOGNSYXg0MEFvaWpKVzR0VFpyZWhtbkM4RT0iLCJtYWMiOiJiOGUxMDRhNjJhMTgzNTUyNTQ1OTMwOGU0NzFiYTY1MzE4NmY3NGNjMThiMDNmYmJlNmFjZTU0ZDhlZmY3ODQ4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(512, '475978-2XbuH9HCRPa2JpHn', 'Gillette Product Tester - DE - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjdJSnhWcSt6YTd5TS8rdUVmL1dJOXc9PSIsInZhbHVlIjoiSFA0R2o5UlBTdlYwTTZ0eHpteUNGUDZYVDEvbTBDTnJmNFhuSHY0N2JId0laOGtlZWdPOXl5SU9yejlpaCtWMmFGOTdLb25GUXVxR2lhUzNkQWRNcmZNL1pDRmxHTDFHcFlzcXNjSk95Rk9uUGRMaU9SUkc2SGRBd0R6QmxOWUw2Z2NhNzE5VFFBR3MzWGR4bGtnNnZmU2ZqL0FaYUFTSlVWSDZYK1FMNjE1Y2pMR0pMeUFMUGEzdjBqVmxNbnl6VXd3cTNkYitUbGdUdXRlSys3VGV3cFlUUmZvOFdpZGJ0ZmtZZ0huRlBjM284ZWtxZnlhL2tBRDdHeEtHbm5rOFh5R1pmb25mZmRENkh5K2RzallNRm5aMlgraUhHTjZKRDBIcy9sejdXOTl0Y0RGODhCV3U3L1JrQm5XdWx4ZjdzTExycDBUYmFiUHkrSSt3ZVgwRVJWT1JjY1dKZlI2L0dOZjkyQkFYWll5cURrSCtWN040bi82cXBUTXdnajdDTjR2QWNwOEhST0xuVHlvc1JoRVUzQT09IiwibWFjIjoiYTQxMmUxNTAwMzQ1NzE1YjYxNWFhM2QwODI3ZjUxNjNiZTAxZDJiMjc4YTAwMWE3OGU3NDZiZmE2MzI1ZmIyNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(513, '475979-2XbuH9HCRPa2JpHn', 'Edeka Supermarket Voucher 500€ - DE - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IkEvKzQ0MHUxSHM0Sk1tVDhVUjZMNlE9PSIsInZhbHVlIjoicGZMRzJYQWxhUTlDRXF4eWhqakJLWVd5OUdycDlqalNhZUZuMHMwdE5kRldPSzk4TnJ5OEhSZEg5R3lnOTNmZ051elhGbVFNb3g5eXBBbkdqRjI1UU1QZ0JrWld6VXd2LzZ3Ym5ORXF1M3pqc2FDT0xVLzFjRTNQck82SkNjS0hid2UrNytIcDdCaWFYQnBYb20zdFV0RjN0ay9nY3NsV1NQc0JWTTBUMGR3U2lmMENUUnJ4V3BtSlNyUHN2WFMzekRvS1pUbDVNTzRyMS9Sc21JL3BBNWdjV01tamxjWUxEcG9RSVJ1UStxRVdDTjRlaFExMHZnbHR4UXFHTjhCb25IaG5rVUE0TWttSWJSYXl2NWhTcGZsald1endadXEzOTR3cHNJdEZvUUZaTVcxVUZBQWVnSm9WVnBHTjFxaVY1b2w3blJIWHBJM2p5VmUzdHV2V3ZYVlRteGNQUkRTQUYrMnpCU2JFenBXQ2Nsb1lPQjUyMG12SDB5MGQ4d2lFRTRzdmFhS2ZUTzc3aDZ5R1oycVdXMWNxbTl5dUwzMEE4azVORWd1YmM0UT0iLCJtYWMiOiJmODFlYWY3MzMwZTJmMjMwOTA4MDZiZmJhZjRiNTRhYTNiNTBhMDQyNDg3OWFjMGRiZjZlYWE2ZjA1Y2ZkOWY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(514, '475980-2XbuH9HCRPa2JpHn', 'Amazon Voucher 500€ - DE - incent', '', NULL, 0.60, 'https://notik.me/api-redirect?token=eyJpdiI6IjRKWkNIYStKODZ2ZlR2N0FwWlJ1VVE9PSIsInZhbHVlIjoiam9lTkRPSHczWFE3ZjlUaWVxUWd3QUJ0b0k3U0JlSks5SE9JMG85dmhVZEFIMEMzYTNoRGFhUDBNOGMzRFRzbzFGYWJzVmk4S2RxM21jc1p0Yk4zaHY4MVJtRDJlc3B3eTd0NWcxRXpvQU0yakRZOHVRRFFhMWpMT3RxVmVQVUpsSG1janpQT2xxeWxLUEo0NWhDMzllc1FzaVRyR3NwMFFFS0JvQjd1aDRFekVoUzJrd3ZLbU9HNlZJRGNSOXkxT1pweDJuaUxuRTYrWm9QYm5VQkhWTW13bDhMYytJaFlxVm1RbVJLb0FuS3A5M2t5UWVJTVRVWDBSbHkwSVNYd21NdU4xMGIzZ0h1MXpFeE1qMDFCdXRCcGk2Z3RJRnpaQTZuZjhMTnQwRlZSbjdXWnh1eG85MDBDYXk2UDVmdWlyM05JSnpwZFVXN1gzZ0k4T3BnbkNzNUdKeU50eC83c2czaVRHTXViK2x1eWJqeGZZR0NUSEFHMklpQkZibHpqRElGdzBISE5yS093bURnTlB3R2NwQT09IiwibWFjIjoiNjhkMmJlM2ViZGQxZTEzMzI0Y2M4MzNiNTQ4NjllMDMwMDQzYjdjYjM0YjlhYjM1ODE5ZThkZDc5MTQ1M2RjMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(515, 'ovr5mxl2gj', 'Pagazani Rewarded Panel', '', NULL, 0.78, 'https://notik.me/api-redirect?token=eyJpdiI6Im9WY0ZyOE9ybWR0WU83TXl1NHRwREE9PSIsInZhbHVlIjoiU0tPbnVHLzVDWm9tekl4MTJzMTgwL3hrNkRKVFFuYWhKckprRUJsa0h4WS9hbVhHM3IxOGhETGdGdW9zRVQraWh1djdoVWFsdjl6T0oxbVlpMGRCaHRYL3loL2FPSmVQM2hEV0tqTzVObXlmTkwxR2ViZk9TNFlGU3d3VDNNa2pJODZKWEYzMmVkUEhRN1pqWVJDVlVPTkthdkt1b3daQ2ZSVE5Ud1pycm9Gdk1hYnZvTXlVaFpMNmZXalcrRGRJay82Q1hUL0dSdUI4ank1K2Y5a3ZCTk5Md0szOUkvU3VVb0piQVE2VnNpNVY2QTRrVTR3eTNxYzd1aHR2NmJIZ0d1eHBVQkgvVXR6b1hWc0tXL2xSWHRKL3lIWVB5c3RoYWViclBSZXl2UU5zOVg4TzJRQ2J3d0dQekxKU1dVMnlyaGJhR2hJZkRWaW1sOXViYzBycjlRPT0iLCJtYWMiOiJiZDU2ODAwYjJhYzA5NjNiMTMxYjUwMjk3ODFiOTJhZmFlNmEwODlkZDExODA0NDc1NjhiZjNkZTViMGJmY2RkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, FR, IT, NL, PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(516, 'eoq5zorwv9', 'Pagazani Rewarded Panel', '', NULL, 0.78, 'https://notik.me/api-redirect?token=eyJpdiI6InJCN1ZYa3FMNjBYQnpkQ0ZhQ1VITVE9PSIsInZhbHVlIjoiV25CdGh1ZE9HVGtKd0xWZC91K1E4YTN1TXVNa2dhT1NaZ2NNekNQU1VXR1U0cU56bEdjS0NlSnAwVERVNEw0MDA5VmhadEdsUTlWTTVLdDZBUmI1UVMvU3FhQy9VaXdsSGpzUHRuc1ltWm1GWGZGUG1tUnNJbHJrZFZDK0o1d2xYcVM1WHozTXRHa00yYnhzZTE5aFlmcUFRYlphbkZLdVhJd1A0Mmo3Ni8vNUN0U3hScGxMY3lzWUVUSGRUUHFpbVpzQjhrbjlPK2tPcUI4UWVBdnM4MmQxcFY1SGEzMFZEY3JkK3Y5UXVuNGhnQXl6ZlJCMGZ2UG5iV1U3YThwdGd5K1lOQldVa2g2TTVnT0ZFaU5QbUZ1aFdHSUxhRWdScGd4UlpVT0xiTmRlbjVta3oxcFozWXNETzYwOWE4eEtPZFk1N3JtbTIxOHVSSzJuWEpwMVl3PT0iLCJtYWMiOiJmODdmMmJlNGQzODc4YTI2Y2ZkMDRlNjU2ZThjNDNjODAxMjMyY2U4Yjc0NjA0MGM1ZjBhNTdlOTY1OWQ0YmE5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CN, HK, JP', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(517, 'rx510ne267', 'VPN Browsing', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6IlhTNm9Wb1NLVW0vOWdENGdwcUk4ZWc9PSIsInZhbHVlIjoidFU2NlZaelJiY01WczUrTXVKRVRCTmVSWXJQdzZFaDRvc3dlOHNJYWZ2cE95MkpmcEhRZGZIVEU4cytlb1ZnK3ZFQ3hwMlMzaDJCZFJVRmdJZUx6aHM4blhNdVRRQmZaMHFhS0R1SXVDcE1nY2x5MXRCbklZRUhKRHdxODVnaHZqUWNrZXM5K21jS2ZZb0VYRkVXdDlaYklURzN4MlZ2OXk4Qkh1YWQ3YnZlR0hOS3ArR3NpWnU3S2RyNjV1WUR0ZkNjdDgwT2ZlVmJTbjVaMHhFbmtKMmRraHZMZGFPQ050RGhkRFVYdzZXMGZPcVJCZDRrOFFhUTFBbzQxeE9SME5td2dRakpNby9EUHZGNng3YVozMnRVcmZZOW85OHZoSUdJK0lmT0cxWFJGK3hMNGtmNW13NDlaK3BiQTZOMjl4dHhzY0ozVzhaQW5UNmlIWndMeG9BPT0iLCJtYWMiOiJiYmU5N2M1YjVmN2EwNDk1OWIwYTFmNzYzOGQ5ZTA3NTJiYmU3YjczYjlhMWRlYzdhZDFiYmYwYTY2YjgzZDdkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(518, 'vz5ln9r62p', 'Ipsos iSay', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6ImNUbVMrc0FadTFNb1l3TW5hazB2Y2c9PSIsInZhbHVlIjoibEFWbUlHOFBQbVBwR0hQWEhmdGkwNlZTUXkvYXlrNzFvNUsvSkN5LzQ2WG01RzFWUlBaQjVBZVFUK0lNQ0s1V3JHa05VSmxKYlByNTVCVGpvRytwQlRQRFlvaFBBam1NemFUZjhJQXpLMkNndkpLeDJ4WGhhN3Rwd05MczR0bkgwd2NZTUx5OTE3dVBZbHd2RXpMM3ozNkJGMEZSVGpBS0lDMlNJbmozMVlNMTZia1l6c2QwVnBXclpSdjlhS2d5YnNiWmlZZDdFREFvbURVeFFEb0FxaENFWGVlSGMweEFRbytxRDdoTDZJUXJkcmVNd1k4YTdZd2k1NzNUYzM5K0x6Nk56eUx2akJsS1Vkc2w5a09pS2dQMVVDeUlSZEJrQVV3RzBGT2g2RHdsMmN2NnNiNlEzQTdteStvMXlVaVJYb0dOTEZtaERoSGl6eWVOWm5CMWhnPT0iLCJtYWMiOiI5MTRiYmNlMDFkZjFmZDVjNTEyYjc1ZGE4NDIwMzdhMzRjZDAxYWE3MTdjZTc1YzMyZTlkM2M1ODg4YjdmOTAxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(519, '6pwjvyorwn', 'Ipsos iSay', '', NULL, 0.67, 'https://notik.me/api-redirect?token=eyJpdiI6Im90N1E5UHQwMlZpKzFmYWdLd3BSeXc9PSIsInZhbHVlIjoiYlhxUk9HRnhBZXEzazVLYVUvME1jcGROWUZUVEd5V3hIc0pUcHVuNVZxS1FyZFFLQjdxc1dDc25XcXlOcW4vNkJEcGd0blJ3dXh1b083Tm9kSEZERkVza2JkbDVFeTZDd0gvaWhxYUZVWkFHWE04RXM3aVd1TWxHRUdyS012K25VZmRnYUZVSnJDWWlEYzVBbUN5Q3NGTEZzWE5UZElQM2xKUVg1S05XTzF1NWdTN1d4M1FhRU5nUDQ1R3pmdFhLRnNZZ0ZkUUE5TC9zLzlTb1NOaWl0alhaQzE1K1IvKzlNclVPcUZJYUY5MDhXTit4bndrWkk5dzFwcTF5QTNYMDdibUorbnVORWlHK2VqbFdHa3dtZmxtVDFMeDhZbldWVUpPRm1NQ2tkL1BLWkI5bmVsSmt0SEJieWxYMGNwSVduR1Z5Y0NSM2JtM1J4ZGsyVW5nMS9BPT0iLCJtYWMiOiJmNTk4M2Q5NDM2OGM4ZDAyY2Q4YmI3MWI3MGJiODMyNjA4NmJiYTYyNjM3NWQ3NzdlYTFjM2VmMTQ5NTdlOTAxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(520, '3xwvn9k828', 'Ipsos iSay', '', NULL, 0.67, 'https://notik.me/api-redirect?token=eyJpdiI6IlBiTnhYYXFrTFlGWjVSQkM5c1FJSlE9PSIsInZhbHVlIjoiWW43UEJBbFhZdUJ0eERYWkhmS1N6dUhXcWRScWNHY3NCT1lzOGt5UU9nRmZkMmo3UnpOVkZXQTNSc3NWNGQ2TG9OYzJIZjNsQXFwR2ZnY1NkV01IT3kwVk0vRCtEWWl0UFIweWZ0bnJKRHFhem84dHBmV3VuQlNkcGp5dEtnT0drVU1PbHdHZXhPZGlUakE2TlZRc09DdHd2am04TytoVXJZeFVua0JUbHl5dDk5MGJzMExTTUZsVDZvbWlqV1FTRGdmWThRakVydzg2dWtqd3BtMDM1dFRHb2dXVVpwREY4VTNWZzRMd0FjT1Z4OFJnVC9nTS8vWDNIMm5sa1g4Q1ZiRGlsTTZjUCtncXNqNXJ4Y2FkZHNydXRzZFpTMTk0MmUzZ0J4b0NBaW9FTHEwbGVLTGZ2T2tMK3BLT2FiNTEyQ05hU0NTWWNJRUpuYTk4MTFRSTR3PT0iLCJtYWMiOiIyNTBlMjA0Yjc1YWNiNzgwY2U3ZGUyYjRmNGYzMDNlOTVmZjExNmY2NTZlY2U3OTcwODYwMzFkZTM0MmM1NDZiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SG', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(521, 'x6w33jdqwo', 'Ipsos iSay', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6Ik13WTA4MWdmRGY1bFJOckhCbFdnZmc9PSIsInZhbHVlIjoidFVUVEN2S3hYYWxnTW5VRWV2b1JlMzdFQXI3Mk1reW1GdmtNWHdQTnlsKzlTZ1A3NkpvQmlGc0VkU1h2Sk5OQnhrQ0Z1TDNQVXpjcnlweFNGVkFTVy83a09QZnRxMzJOWHppTlcvMzJIWUhYK3AxQ3RoMHd1OG9RK0dGYnVNT2RJQWx3R2NoYjlMVG5mWXQzbDNPWjhFdFpMZE9qQ00yUjlMWFZkb29lSEpVOHdIK1U1RlQxM24wSHZOanNDMVFQcmovdDNGcHAzbm9TbmZhdkRFR2RNK3BYZWlDdENaaGVXYzFZT01ZTE1sUzcxOTJrMXlMWkl3MDk5Uk0zVHU4T3ZhU2N2VkQ1MG54U3FEWHBLdkdjTFBHWk11cGNGMWVscEMwUFpjK1I3RnpRZzFjeEUwVjVLRjMyMVdndG1OWXM0YWE4amwvWHUwS1JyOVBlTk1wd3JBPT0iLCJtYWMiOiJmYjdiNjRhZDM0ZmViN2VhZjJmNGI1MGM1NjY3OWEwNDJjZDEwYjJiY2NiM2EyNDJkOTAzNDcyMDMxOWMwZTEwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(522, 'vr5mkev8wg', 'RocketGPT', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6InB2L0UvT051cCtPdXk2aVBUWWw4L2c9PSIsInZhbHVlIjoiMDBtTWdKdlBOVjFidHBkeW9WYjFVQ0lsaW9kTitzcnEzTWlsb1JDMnB6WlFNQitETFpzUm9NKzBnUCtZVk9HVEJOcGYvZGdGbDVXRTZjbWNjY0F2SHlaZnpRcEo2MVZUWVc4ZTIzdDF2bnFTbk84N1g4bzZwQ3BOUzVXNEEzNXZLblh5YnRnNVJucWZWNmdnZVI1UXV0Zi9kKzRrdmhEeXZqSTJxRW53L0J0ejF5YkM3M0FjejF1ZVBDTHo1UjR1N2x5THR2NFI0VnpLdVppOHY4RTV3aE94WDZyUDlvU00xQVBRVzVwd0V6TXVPVGRJSm4vZS9LMW1uTTZvWFdqV0VOL1JkMHVuckZPV3JPaGR2RWVuaS9qU1A3REZLa2YzYlNCRVJPK2RKYm9PQ3pXeGhRL2NxZmxOYWlPQTJBTlQiLCJtYWMiOiI0ZjA0YWQ0NmQxZWY4OGI0NTgwZjFkZjI1OTFlODgzM2E5ZDI3ZTNiYjkyZDM4Y2YxYTFiNjgzNmM5YmFjZmZiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, AT, AU, BR, CA, CL, CN, CO, DE, EG, ES, FI, FR, ID, IE, IN, IT, MX, NL, NO, PH, PL, PT, SA, SE, TR, TW, US, VE, VN', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(523, 'gq56djz9wl', 'Fighter Merge', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6InFCV2tyYlcraEI3MEl1VGlCVllLOEE9PSIsInZhbHVlIjoiWGlXajZZSGtSUUpQR2pSbzcvYjZJZnliQzFDVzVkd08wT1ovcnh0T3BJaVNFYytqR0NGNTdtREhKNmx3bGUrR3ZCdTN5Uzl2V1liOUFDc3AyeEQxVll6ZEZEU3luN0NVL1BrTFhxYjBlUVNxc1MyY2dRa3ZWZHNlUUVuc2VlKzNQWjNNMjY5MXZRT0FtaFRDZWJRcHRWSXZiUEZ2RzU5K09NU2tpQXJVbjhNR0hic3hXNzZzOXYxajlGZHNjR0tHbUZIRTJ5Wjg4TDh6NkwvYlpyR2N1RDdRSERvZWVzM0JhL2t5OHdsbmtDalQ1ajcwZ1IreUJLT3pWdEVRamVVQmJvYlNidHdYYXRqZndIK0xwSEJhY0NWdENvT3hWR0RYc1pSbitMV2h6M2M5SVBNUVNPQU13bXRHN0JZWVZzNFRWRWFNMUo2OXBLQlMxOWV1bUhTUlB3PT0iLCJtYWMiOiJmOTgwNDNhMGNjMzJjMThjNzcxNTNkMjBhMjAxNDRkZTM5NDg2OGQwMDk5ZjgzY2FhZjQ2MjNmNTNmMTNlZTBjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(524, 'j05pkpvlw4', 'Lays voucher', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6IjIvV3NzWUpnUzZzYjM3T0lGcndtOFE9PSIsInZhbHVlIjoiKzVzUVhHQzA2WjNHcW5XOExPN1lNSUM1RHlNUzgwRzNDU2dKb1hQWmpicThHWVhqNzIvNG40dHQyZ0dkL1VWVmpRV3dJTTZyTlliZGJueVA3UlcvVTRDMW9abVFhZmRIWWFtMEM2RXNiWmxmMUVkUVN0dDc0UEJIR1NJRHpjekJ5cUs5a212N1B2OTZtNG84VnFzS3hBZHVzWUkzaWwwMk00OWI5aFZwdThkOWhqZXQyR0xrbVUrT2ZRTkxsY3htK0lpR3JGRk0yWXVSOXpVOTJJamJucWFYbnhzeTZ1UWZ6OHY0c0VvRTc1VDdhNWo5SDQvWEdvSWp5ek5TMkpzaUFXenIxTHVuZ1BsblVpdnNwM28zaFBOT1FmTEQwbkwxOXJML1hLcGdQUlR2TlBIUmppVU43VGJoMEZPWlY2L0Q3RmR4dmM1Q0VDYWNjZlFPbXBCbkNRPT0iLCJtYWMiOiI1ZDA1YjY1ODQxMWM4NzQ5ZWE0MDE5NDk5NjM2YjY1OWVmODE4ZmMzMjc5ZjViOGUyN2I4NWUxMWFiM2E4ZjJjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(525, '6k2yy4xo2z', 'Win Coca-Cola Products', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6Ikd5SVZCN2pOcktFYUR3bDEwS21rQWc9PSIsInZhbHVlIjoicHhEUXJMcE02U0pWbW5LWFpSTW93cGhRQ0Q2Z0t0dnd1bTFXd1lKRnlScTkzbGxGMEVNcDVhM2Nzenp6NEQwRXNMVnluSGNlcTdoOTgvTE5iM0xqUHZ1U3dHUndPRGJnODFDREIvNDVYeExlZWtsSVpQTUsrWmRsUDRwaERZMTY1dnhyY3lnbndxZFpMdWlCWHFSbDNwVlNrdnV5VTBDem9iR0FQWW8xYmp3TzNlMDFWNlV1Nm81ZUF5RHhxdjZEa2lHR0R1ZEJjYWFzaEV0MzdvcWlNVmZYZlNab01hMkNjc2Zwd2hXSXpvUksrYkE0eldjV1ZCNnNDaUFtT1RYZFZvRGJDcS9PdDVWZVNXaEpoaVhsOWplVk04eUVkUGhNUjJ6c3AreXJXNEFhWjdjdE9vM2kvNDhOQkFhYWp6WTVUc0wwRFVrV1hTRm1vMU5TaGVpWGpRPT0iLCJtYWMiOiIwNDk2MzZmZWNiZTg1ZWRkY2VmMGIxMjM0N2ZkYzVhMTNiMDExNzdkZjQ0NzFjMWUyYjBhMzllYWNjZGZhMDk0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(526, 'xj5gg70l5m', 'Win Uber Eats Giftcard', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImtQSkNxNEJyUUpKUFdZNUVqcTczaWc9PSIsInZhbHVlIjoiWkNEU2VRZUZsU084MS9ubVlPcUpWY1g0ODRmSGpBUHNRR1I1R2xraFpWQWFiYk1aRTFyUnBLZUtsekkvTEtTOWJjbjVLakxVQ3pjUEh5NE5wbm9XNzA1d3dCSEgrdHpSdFZyUDllVFc5U3JWbWhzeHNGZE9RY2J1bXUzRnE4cXdsVWVpcXN3Ni9VRmJjSUhRNldlVlVNaXkwL3RUZnltOTd6SmJyejZTWmRFM3FPaGloZlZjMzhubDB4Y2FVQlhmWEhScjUrYUZ5bWpqWCtXRmdVaU5CbWtOTnhZNzlSQldiM1ErNHF1cm5ZR0NpRDF3Z0VOalRpTW03RmZ6UkhUTSs2bHE5eDJrSUl0YldUL25XT2JxaW9TcmlVMzJwbkNhaGMyZk0rTnZEUnpNZWp1MGYzbEo3dWs1RzJ3T3ZHY0pOdkVaTFBDeURUcFhPUlhvcFI3U0x3PT0iLCJtYWMiOiJiOTNjMjk3MWNkMGViMGU1MjY1NDkzNWJlZGFmYTQ2YjRmMDY0NmFmNTdmZmUzOTUxMTg5N2UwOTI2YTU1ZjZkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(527, '8dwkodzj2e', 'Content SpecOps', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6ImRRKzdUN0NJMzhrcU1ZZDRhdlFqdmc9PSIsInZhbHVlIjoiYzhLS20xRGtVZzBtR2NuWkpFWFlZdXIwaU1FQmF4WWZQMnRDK1FXS2MvV25zdEY1b3B6M2RhME5ZK2JoRldjLzNrQmZnQ2lXODNDaTlHbFBVK0NyNmdqdlJzL0xkL0wxRWFzcWhFRGtPenJ2YS9HSmpCQ3JHdjF0cFR0OXdtWUZPQXppbG90MkFjbDVQYnl0Nnc0NGU5N2FTbUVuWDFzT3B3MzFjQVg4QitieThxMDhGaW55T0luTkRGZEc4RG90M3NFZzFCWFgrRWNod3IwM3pBcEc5TmZDSHNjZFRFSTg5Ky8ra2tpd2E1QndIblF5cjV4ZFVMS3E2VHNnY1RWUnZDZU1pcDlDRGdvbGZSeXVsR3VURklPREJCaFhhcVoydmlpRElvSEVyd3BnZmIrbXFGWTd3ZVFzbGUxSEJsRG9QRE1HdUJNbnFaL1drZlI2NjNETG93PT0iLCJtYWMiOiIxOTliMDYxYjJmYWM0NmE1ODY4NjJkMjRkNTBjNmE4MWJiNzRiZDAyMDYwOTkzN2QwZGNmMmJmYmJhNGI4ZmI2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(528, 'kp5nd4n82m', 'Content Blue', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6InMzc2N4VUN3K3RJYmhKajZ1N1NNMHc9PSIsInZhbHVlIjoiVnJDMHMyWlhaTWo5R0R6a1dGYjNKazZ3bk1BSHcweVgvY2F1SjRMcXhqb3ZVZWhxWnRKQ01hY1hlNy9WU1dnUEg2RDB5bUhuN01OL2szYzVjUkhpbkgwU094eWVXREZXY3hKWENlUkpTZVJNdzNCV0lXdWtwZXE3TWxmTDNrcFF3VkJKSXgydzhBQjJqYUNiSVZlcUl6NjlEREhjbG1NZUpOTGFIL3hhQmVVbFhraG9wUjQzMWRMcnlkMlJPaVhRWURJWDFxSEp6YnZyR2RSS2t6Qk9oYzRqTzRNSU5QZG1jcGF3RDRlL016SXQvZG5qdklVeVM2eGU2cUNNYm15Z2N2dDh6TVFpNFB5Z2Q4enhnVDZCdlNwUWp4eitaRlh1SXBCZUUvVUhWVVJTVjBYMFhiZHFCKzNDeGV0L1I2VitYWHRrK252YmVpV1FUVFBwcUhPM1JnPT0iLCJtYWMiOiJlYzFlMWIxNzY0NmZlZWU1NGRhNWVkNmViZmVkNmIwYzQ4YzQzMDczY2RkNjEzOTI2NGZiYjZjOWNmYzZkNzJjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(529, 'qx29e6jewy', 'eSurvey router', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6Im5KeTF3VzNvS3JHYjBhRzNqY1haeHc9PSIsInZhbHVlIjoiNXhBRTlaRG5tRU55SGdSbzdYOGJhT3AwUDM4T2ZpVm5CdU9xSFpJWkpObE43dlg3cUFvVWE4ZU5iVzJuSStyV2pvM1FpenRjN2J4U3NRcjZJRkJuOFIwcjZEaG8zTnUzbkJrc1pxTTEvZ0lZbTRaL280dnNsVmJEd0xHYzVqdG1Eak1uN1BSSjlpNFV1cERBbnpVS05jRWpPL3pXSW9qU0JEM1pMRjVDUjBMbkZlUG05TFQ0THBQQVpXRWdtdmxJY215YVY4U01qL1lCTE9zOHpiOWM5Smg1ejRWYW51YlEzMnRWUU1xcE1TYTlvb05JMUt1QTZqY2EvTUlIVkwwZFJLQnFZQUkyckRpNW5KZ3RoUm1vaG9mNnhmdVVSdVJBc0IxQVQ3WHVJTUo1a2Z4R2V3VTRFcDhLamcrL2p6MzRCTnRKaGJoa1FJcEs0RnpsZ00xWmlBPT0iLCJtYWMiOiI0MTA0NWQxZDIwOTgwYmZhMzFmODdhMzJlZDIzOTk2NTcxZjljYWJiNWQ2YTZiNmQ0YzQ5MTg1NGFkMGI4YWRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(530, 'vz5lnx732p', 'Sports Quiz 23', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImVnRkNSUmJaZE5WUVZIZnJkT2tRRFE9PSIsInZhbHVlIjoiYmFBdUFFMzhRS0htSVN1ZmREZXJZd3J5VUlvN3BoMlRFUnd4aFRBaDNDd0h3ZUlmQXovK09GRUZQSFRKQkNRQm8vMjdxcm9lM29lZWpicXJ5TkFrMExjQ0N2MWo3K2h1cXpCczVkZEZTcE5qRGE3OWVZNGRBOVFXaXdNRktBalQxZmEyTDNpTnl3eHFqbnZjRFBMbk1EdTYxdCsyVEpHcnhNb0JiNVNYaVZpbzIrUkhPRDhheVhMUWZKZjF0bmx1enB2U1dVZzdoUy94SzQvQlNwM1A4b0VUczF4d3BselJRZjFJMzBheXlpYnRRQzBURjN4VXlMa3RUYTVDR0gwd2FsN1FBdm1rN0x4ZEM2LzFibnN1alRDYzI4KzBYYm16dFdTV09uT0l4eHZXT00ycFl2SGYyUUhiYnUxaWRaTUNVTXZPN29DR1lmblZVOXFRMlJPL1pBPT0iLCJtYWMiOiJhNzg5OWYxMTIyMTk1NDMyNDVmNTUzY2JlMzZmMzllODVhZjMwODQ2ZjlkNmU1NTc3YTc0Nzk3YzdkMGVkNjJiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(531, 'x6w33dngwo', 'Bingo Quizz', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6IkNudFdaMktBRjQ3ZHBpYXFxVDJOYXc9PSIsInZhbHVlIjoiVlBwSHk1MG5zYlVQbzloa21GLy9OS1AwYnllUzlWODZGalM1eVljbmM0SGFsNk55SmRkS1JGWTRaa3JoczJuVE12NVhiOU9DYnpxYmhwVVZRK2JJd1RrZEJDc0syMXRvU3RKOG9MTm9kTU5VRlQ0OXBPRmVYVmFvTnIrcVdOSkpWTGcxVXlrckpXNmlTdU9LL3pBSUVhU0ZCdWU5Q2Z4RjRvdjBGQk5rUHp6dFozUGZKV0pmcmhGU253K1BhaGtNVklHSm9TN1crZXp1MnNhRVNweG8wZ0I1Tm5LekJtazMrM0ZoQ3RaL1BMQ3Fvd0M3bVFaVWF0TUMxM2RaSjZQajhSNG01bURUZVQ2aG8wSVdlZFFIcVdPZDkzRVBOQ2VvVjBHWS9UTTFQTU52TXZzS1Q4WjM5UThaQUNub05XOTIrMXFPSzB6d0pBNnlwT1VtamNzbW5nPT0iLCJtYWMiOiJjMWY3NzgzNDMwMjk1YjhiYWZlZWE4MzliNDRmNzk1ODdiZjc1Nzk1ZmVhZGNhYWNjODMxZmM5ODYyZjk5OGUxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, NZ', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(532, 'xj5gg6105m', 'Content HD', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IndDZitJS3M4ajB4Y2VRK0ZZL1JUQ0E9PSIsInZhbHVlIjoiUEVyMnpycEY0TndhUzhNYVN2b3ZKNnBJaXQ1TmFaL3lBZ3haUmFCTHloSFhWcmJzYVowMmhHR084Q2JRTGJFcmdGczF1cXMrQ3FYYmU2cEsyS2tsQTU1SzAxejU3bFF5eUQ0Ty8wK3ZWTHBOaEhtYXFQSUxXNGZpaVVlVml2aXJ0WFVaNEwwb2xzczkzYU1ERklNMmRVL3AxOXBWUDlJc1V2TjRiTnd6NVBNSm1OVUtORlZPaThncklmVU8xWEZoMzB3dXZBNHVDbkJmM2NvdCtISTU2QzhVYXZoNjZKQkdDNjBTT1BVRVBsamtqSkUvVlZZZTF2WEZLaExwRFpCRVF4SDloNzBtT2lDaXhzWnhGaEQ1OUYvUWIvQzc1Q2d0WkR5REpmRHI3cDQ2dmZJZHAwUGhxVkN1aFZkVGp0djZQaFhvc09xWXpremsyVTRISWpRcHV3PT0iLCJtYWMiOiJlOWYyY2NjYzk5M2Y1ZmI5NWUwYTU0NDVkMTFjMmVlOGY3Zjc1ZmNiMjg5MGQ2MGVkZmVkYmRjYzIyMGYwMDhmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(533, 'xj5gqlg4wm', 'Apple Watch Sweeps', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6ImpiUHZwSXRBN1o4U2xEbXlQcmM1MlE9PSIsInZhbHVlIjoicmo5N1J0WkVrSVZ0N3BXQWMvN1FUcm80L2JENHN5RFAxRVZaWW95YStQNjhWMUttZzdteE1LQkdXOGlpZFFTMHk0Yng2ajBXa3RCSGlQeHF4ZmJVcWJJTE9RZVFrVm9jNTFFcjBwdm5NQ3djZ29NTS9RTEJwUmRVbHVqTWp5S3B0U2FoWlk2M21KUDVTR2NhbWxERDBKcGQ4dGRHY0dBNzM0bnhWUklYcU4wL2Mzd2JNc0ZsaVZjZU9qVHN1cVY3alk5UGtDbkxFWUw2RE54UGU4M0RCTG0xb3c0YkZqTVhFOTkveWpFTUs1UWROeENKZnFhQVByT3Ird053eGpGNWNZSVhuR21SQktkY3dmNHFmUmJ5bFQrYUpBSDNVbXRtQ1hyQzBXRDFJbGUxTTVab09oNGIvN3dUdXlIM3lXckU4Nk1oNFNxZWJPbXU0VGlkUjNNVnVBPT0iLCJtYWMiOiJhODNmOTllYjQ0ZDdjZTllY2VmNWJmZDFjYjAxMzkwYWMzMTMyZGQ0ZjljOTk2YjdjN2VhYjA5M2IxMTM1ZDY4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(534, 'vz5ldjn1wp', 'Oferta del momento: Coca Cola', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6InlsY21wa0J3NmlVcEk1Q0hGNm9LdkE9PSIsInZhbHVlIjoiZkFoOVpBWGdsSlp4QTRKTVRqcDA0M0xhTE1NRTUvTlQzYUZ1WHhZQjN4ek5rVzVyeTJOeVFTMlhNd0R2NW5NSW0zdlh4RTI0ZEtXWmhwbjFPekdZSWIrQjVySVpuRFk1cnNDOFRRbWFnL1dzYUxmN3UvZkc3V29MYVAvbmE2ZkNvSllHdUxvVkJLdDVhUXpBOUxrcTVXalZTOUNiSVBmNVlMN25sOW5nZkhuZzdqMkxZZnVoNjNLQjZyRXU1SkxlOWEvUmFQWXA2d05hVzMyRWtpMWdTOTBPZk5MNjkzT0Y1czRJSXY2OUlXb1p0eTRyU1hPckZiSWVzU0ZCa24zUllNVjNzTE8ycVNtMGo1aHhBMU9Fc01yWmd2WU9TK09aU09rZnZ5Q0s3c2RtNm5lNWZ3V0FTQWpZWkRDSTUveGlsNFNCTDkyTk5zalhIZExNQXkyY2o2V0ViTVVVcUkzeUM2Z3NjNE5qMi9ZPSIsIm1hYyI6IjIzOTJlMTIyNDRhMzY1ZmViMGYxMmQyMTEyMzdhNjYyM2U5MGU0MzcyNzBmZTlkOWNmNDdmNzVhNzRlNDJjY2YiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(535, 'zm2d3o0rwq', 'Back to School Giftcard!', '', NULL, 1.96, 'https://notik.me/api-redirect?token=eyJpdiI6IituVGY2c3QrdzRud0k0Qk1YeGxPa0E9PSIsInZhbHVlIjoieUV5KzVxWWswNDNDbVFweWVWTSsyaEdTNU9ib3Fnb1dvQlhuMkxGVGZWdmdSaUVwcmZCVE9GNjF3cmVOMUQ2bDI4QjNsS2t1dG1PWjUxb2htVzQrVUNPcTk5ZjAvVjFuTkdoc3QrMUN2Z1Vqczd5NlZKNnNYV3pRM0gxcmg0WFZTY2VCNGhWRW9Rbk1rMHI4cXlMNnV2VkUwd3lnbWRHSnNqSzkvVEFrL3BIbGxLelJMOUIxL2M4TmVROE4vR1dKQWFkdW9JTU5IR295MGNrZWdkcUJ5aXpGa1JIL3JDM3hrNmJVUFZZWkxXd3R4THZpaUk2QjBzTzQ5NEpURExtTTJsdWZFZ0ZtQlRZRVhldGFGZkFoTkFHVThvU3NVdHozSUtWTHZ0b3pjRmJJa0RZU3pwb1hYUWh5M1BmOTBzRlFRUG5Tc0J0dENVY21WQjUzMlIzQnJ3PT0iLCJtYWMiOiJjNDEwNWVkMTY5ODk4YWNhNTExZmFkYmEzZGUyZDVmNzcxZjEyZWU2NzRhOWM4YWMzNjcyYjZhYTQ4NTExMmEzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(536, 'vz5lnpg02p', 'JackpotCity Casino', '', NULL, 15.68, 'https://notik.me/api-redirect?token=eyJpdiI6IlBVOGJuNVVrK0JrZldXdER5MXl3dkE9PSIsInZhbHVlIjoiWk9FQUNoQ25XZjVJN1ZwVkU1SzJOSXNiUUJ0U3hqY0h1S2U0ZXM2WkR0YmJpTkJPZVB6YUgrUDF6cGhHZ0E5RHp2eGNXOS9yd2lNbXZmdXBYdEQyVi80SjhOcE9zRzFkN0JIbnBFOXRNMXRYbG9GU3B0cVd4dGRqYnJ3bmUrQkFtblhmcTRSbEFkMjhncWRXV1hIckxUbHNYQkxmMTdZNDV2YlY2K2RTMUFJU0NYZmZGeXJrWFYvcm00VVVYMTVOMW5FNGJScU5GNHpRQ2NKR09TTEdLMTB4cCtxeUhBakZaR0NnTzl3cG9vWGNRWnVMWUpUbkE5RW1YNXFiUTVCN3JiVVJTZ3I4NUdUaC9PQVdmRWIxN2lMVktHVG1iYXNaUWlreTU3amNVUjlycXJUV2EyNWhTOGpLdXIrZys3clRjaVRlSXNYYWpDbUt4WGpvSzB4QWx3PT0iLCJtYWMiOiI4ZmQxNmFlNDA0ZmY3ZGJhMmZiYWZjNmFkNjE5NDhlYzljOTY2NTFjYzM5ZjQzZWI2N2RmMWMwYzM1MTA3YzgzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(537, 'vm20rlrg27', 'Inbox Pays', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlFtT0IzT0J4SlVzbEVwWHZiOHBxVWc9PSIsInZhbHVlIjoidFVGS3VxN3Ura1BnMC9vTFhRNnJCRFgyVkxieW5ncjZoTkl6TzF3Yzk4Wm4yZTExNlNoVmt5OFIveGQreTlsY21WU0MxZ2tqWFFQTjN3YXpOdXZiSU1OYnBGTlA5QUZlcm94MWxSbjFDTERZTm1vM0E1VUNRNkdRK1JvT1drOGpNYThnUjVVMFpqdGw3QXlJMlgzVXJiMTQwWXJ0aytNWHdjTDAvaHBhaXdsbS84QnZFNXpWS0I4MXlyMzVzY04zM1BLSUljOEZwTDNBem5TSjdDelpYNnZubjc4VGlCa21YbXhwMmdabFAvWE43bmZQYkFXdXpKZEpJdEVZTHJ2YjN2ZVU4VnRjNTFlV1EvaEhmV21yNk9ZU25UcWdoT0VuOTk3ZkVCTkRHZ0JJUC85R2lvT3R1ekZaMG5kQlI5SmciLCJtYWMiOiJjOWY1YjAxNzZiNzNjZDM3NzI3MTVhZDJkYjVkNmRiMzFjOTBkNDg3YmU5NTBlZWNiMWM2OGU1OWRlNTU3ZTc1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(538, 'xr5ednn32n', 'MYAPPFREE', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Im1ybHE0WVoxaVZuNlFMSE1ua0lpZGc9PSIsInZhbHVlIjoiL1pwbW16VCtOSmRkWW0weWVCWkJhMnNIYVVZWDU5RkVUQzEva3RwTDJsWDFKUHhiMGtRRkNHeDhhcFFqak5kaFh1eVp6VVJYbFBmRGZnNVp1eU5qYStWcDdkVlU5QWtMMUZoTWI4QmphK1luc2RTM3RJQ1ZzOENFRE9hdTNnV0VYb0dJNEV6d3g2OUtwZllaUEJMVlpqNU9TbFZqbDZ4RWV1Z3dWMEFMTDl3WEcrOXNXQ2E4MUJvaGUwODYycVBWdGFjOGlaTDZVbExJVjVEYjA3U1JtOXpTZUp6dm9qd0ZPV2lzZXp1bnBpV085N0YxYjVnMUUvR3NLUVZVL1FFZTYzSG9rU2tURVg1OXpNK0s2ZHMzb1JCYmk5d1BaaUNlOHVtbGs0RkZHZzVzM1BQUEtBTTdLdXhiSXJlZWpxV2IiLCJtYWMiOiJlNGY5ZjVhOWJmMGUzODA4ZmMyMDk4ZDUyN2NhYjhlYjc4YTA2YTQ1ZjgxZTA0NGFkMzljMDE4ODY5MDg0YmU2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NL', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(539, 'y4w47ll6w0', 'MyAppFree', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6Ijh5Y1NXL2tBMnVHRG1PUkpGTTc5aUE9PSIsInZhbHVlIjoiQ1JWR0NrRXdBeW1KZEttQTdFcFlScTQ3SkpuOVlPMmJSVXpZdjROaUhjSGFLS1FubGNBaEp6UXorUnB2c0FOU3BLOHdGbFQ1VEFZOUNwQ3VlNjdyNHFFRWhJVFl2SDJuRWdYZVBCVXdydDJVYnNUSDU2TEVuelBLVVBXL0lxNHh0TDRqVU5Ec01KOS9lVTd2MWVZU1F4UXRjc2lhVDBrL1YwNmY0L3Q5Sm9WSHoyWXN1SUxJWGErL0xheDZzN1d4dWhIUU56eldJVHgzcjhPM3prWE1sSURZblBDdVduVmdCREVQVlN0YXBTTDkyOHVXSVlrNkZRZ3FHdkR6YnZTWGFFaU5pdWQ5ODRIUnpvNlRnQ1BYQnJjejJoSkpkdnlTSDF0T25vd0pRVGpLQmFyN250ODdEeFk3eEU5SXg4UDEiLCJtYWMiOiIyM2ViNDM0NDBlMDg1YWI3NDQ4MzJjMTZiZjFjMDgwYmFmMzNhOGZmNmU5MTJhMzFlMjQ4MDY5NDNiYjNlYmI2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(540, 'xj5gqgg4wm', 'MYAPPFREE', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IkkvRERPNXRyaEZvdDJBMFVpU043N2c9PSIsInZhbHVlIjoiVno2TXNJNUcxM25Pa1NSY1hRSTR3TXNOdlFYbGFGdGZNRURsNVFRNk1zQnM5RmxRZmFQV2pHRUV5NWQ1SEVLWTlaSGtLWTlsbEJVS0lrS2d0WUdNNVZyY0pCZzlicTZqdnJJdzJHZlhsR1JEOWFVVG92Q1kvUFRmOVBhSnQwVkRzMkVlb044NTZsVCt5QlNoVm9NS0RrcU0rUnpYTDFUMjUxUkhrUVg2S0JKUTVtVk5FTkxRM0F1ckVKSEZ1VXQ5eHhHQzcxM0pzelQrT0NGSFVYb09Zb3NIRytWdHYrT1VGTnR1UFJjcWhySnhyQVppVGNkbzViVnBjbkpnMnY4NWpvQTN4eGtYY1dPL0YwdGpGekJZeXhISGhpSXdyK3dwU2JPQ2J5NjBKRWxEOEdXSmp2N3RpTGdWZTl1Rm13UE0iLCJtYWMiOiIyYWFhMGE5NDlkYTk1ZWE5NzAwNmQzYmFlN2RiNzBkYWI1MTg3YzkxNzJjYWZjNjljMzdlYmZmYjE0YmIxYzlkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(541, '6pwjdvvpwn', 'MYAPPFREE', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IktFZVNCT1FOOXgyVTM1UWhUaG9ndnc9PSIsInZhbHVlIjoiZUpJSFVYcC9CVzdSYWRJZXUxUGYzVmc1SVhxV3JCV3AvRG9hQjdtQmhocUNBSW1TNFJRSU5jNG5tKzFTMGRDWHpKQmUwQ2VQSFRuREtKR1NGVy9tWDlod1Z3SnBYcVVoSlc3WFZCU0RtUENaUjJwYlJFNXJmbVU3Rzk2UGdQV3cvMnh3dDJKVFlqTVY1T3ZlUmV2cHBRVXlqK05mOWFQemVnRXJtcTJUNEt1M082Y0JDNnVMTDh4VUZ0czV6dzRXbFNnWCt4Vi91UzVjTzBOa2drdEsyR3pJQVo4ZzRhUGNqR3gvWW1FSUIzZXBpdDZkbXd2eWhiTFZiK2NTWVpCMzg5NFRsYTJtaENvQUtTZ3h2ZDNVYVBpcUlLeWZzSm9xdHlFdno1WXNiM0lkNFBpbnI2OHZaclpxRk5OcUhNRUUiLCJtYWMiOiI3ZTc1M2M2OTYwMTA1ZDhkOThhZGNlNjI2MGVhYTJmMzFiN2JlZDRlZTA0MDZhYjcxNWNlZGMyMzRiYmEyYzU3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'desktop', 'notik', '2025-02-26 13:09:52', '2025-02-26 13:11:07'),
(542, '3xwvrnn758', 'MYAPPFREE', '', NULL, 0.42, 'https://notik.me/api-redirect?token=eyJpdiI6IkZ1ZUxpMFRLbHRzYjlyRVM2RjRhNEE9PSIsInZhbHVlIjoiQ2o0dThkSFdJTFVSK3NFcUFOM3FEcnkvK3NUdUp2ZVJNZzlTbi9KNkxpb3hqbldhZFhrWWtlUVNoZFNvMktsYklRK3ZsWkxiM3dBUG16NzFvdHN0KzhQaVBrMy9WQ2QrRkdwNEVWTkJ0QmRMa1RCNXIrWlh0dG5WaG9MRnFxVlRPTzRuM2RxSXlZcjU1ZFRFT3F0cXFpQ3IzSkd6SEhLeXlWZ0tCUENjeEtSaFo0Yzl5VDlCd3NpZGRwYnNmQ2I3QUdaNyswakc2RDQ5VC8yQTFOUWg0YjFPdHVSNGYwamdpak9aQVU3cGJrdSt4UklRcndJTjVpNTBtSkN0Tms5bWxFdndPNHVUM1pSQkF0WlQ2YnNlMnN2Ym4yQlJ0Y0dMdng5MCtqN0NIUFgvUTA0L2poZE9GME1Eb05wNERDd1EiLCJtYWMiOiIyNzgzOTI0ODRkZjg3YmFjOTFlN2NkZWZlYTA2NzJjNDc0OTYyMmZiZWJhOGQyZjY5YzhjNjIzMjM3MzVlZWFlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:07'),
(543, 'jy2rojjv2q', 'MYAPPFREE', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6ImlxU1MycHV4WjNaU3VJM3BRSUtEd1E9PSIsInZhbHVlIjoiNlJzZXhMQ213cU1ROFBkaHc1UDJiVWVOdXJaa1FWa2VwcFo5WGhlNmVTUXVRdUVXbEVCY01iWVkzcjI3U3BqU0xSSWt3MTJQcTJ5SVRsS3NCTWtHV3RFM1JRb2RFSGo3OWtvdnlpUktGVEY2clVYT2U5YW9HMm9uNEJheitGbkxVa2lTd3pQNnZuN2MveVpsTjdoTWxucmVNWjRhYlhrUXlKSWxtVlpJeXVZNDlIZTVYcHNJbDhEbVBDSjNPQjhyaWNoY1hWVVdXTTlJZzdDSHRpRnNWTXl0ZTNrT1ZvNFZZZFY2a3d1cUkzRnVVUkNVdVRlN1lyRnhxeU9ySjE5TWZ6ckVvbWdGZVU1NmJCRWtrWGZ6RWwvM1RZUTEwZk1adUFndEE3OENUUXVSZjNCSXpOVXhFalFTN3Nvd2NCTjAiLCJtYWMiOiJlNGI4ZDE3YmEzYWVmYTQ3MzJiNzQ5ZTdjM2MzNjRkZDY0NmFlMGUxZWEwZDJjNDE1MDVjOTBlNGNiMzE5YmYwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GR', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:07'),
(544, 'k15ono3j2q', 'MyAppFree', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6IjUwWktVQ2NnSllab3dQYXdBVHA3akE9PSIsInZhbHVlIjoid2FicThoWjdSL2R6SUdiRGYyaVNpUDQ2QkxhaStyNmxLK09GQjVQb09BbXZ2dHRXTTFvTjZQL3lIcWdoSVN3U0RXemxEUm9HRS9aUkZOeUdJYUZndit5cnpiZ1kxWUZzeFArM3hQTEVpQW0vZHFxWFdram1ObVp5UDM0WWVQOURwbnlvaVBYcHE5bEN5VmwxRXJYeGErRzllOGZFTGJucXNqcnRucnpXQTFseTNiSjhSSHdTcHJrSHMxZTFScWFZOUQ0bEdwck1mWDk0TVVTSld3eGVLVTc2UHltaW1xZlpZWWdhazlxU0p2aVJKNDMrQXVCWnNLSnN6OS9hbkFoZStHYmNHd2krVXlxWXlFaUkybmtkM1h4UzNvenhQQXlzSmwvRXZmRWI2a3pZVkx1NmZvdDhKb2lxZ3hraFZ0bHMiLCJtYWMiOiI3MzhkZjFiZGU3M2EwMjcxNmU5NzcyODQ1YTExY2RjZjRmMzRiY2JmY2ZkMDdjY2VlNzM3Y2QzZDUxMTQ1N2E0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(545, '642qzko021', 'MYAPPFREE', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6Im5vaFpRakUzeXJ2ekNQS0R4cmxKbWc9PSIsInZhbHVlIjoiQ0JtS3dFTDAzaDJseXhZRlVNckp0YUhVSFdrWm5NYVdyaUo3SUJ6TUlYb0dVdHpNU1k3bko0VU1nNXFuZVdMelBoY2JTdEZGcEppMjlTSmwwS3NOUXVFcUNJdWFOZnpiQkVGeGlGdTJuQXpvOGgyeWt1T1l3aVFXWDZmSS9XNk82Mm9UVjNGNy9tWHpTU1AxeWY3TFpRUk5PNnRmOFJPckJXcHVTME5Cd1o4LytQWmw2NmNnQk5PcjNYdnJPOFRSb3huY3NkODk4Q1NBblZDRUN5MDlqTnZXNkEzSkxCd0NibjJzMnNyWXQ1d3JTSDRYcFJQNFZ2d2N5bWFNbVVGbVdxQ3I0ZVgvN2xqN09VMjlWckxIclVXVm5FMzIzRDlVeHh5clpBbHRxQmVPRnh0TE1SQzA5QnlrVjV4TlJkc2ciLCJtYWMiOiI3YzI4ZTI0ZGE1ZGViYWJiMDViYjAwNDAwZGJhZTc3NDY3ZmM5MzZiNTg2NmUzODg4NTY0OGY2ZjE0YjQ3NjQ2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(546, 'vz5ldjp1wp', 'myAppFree', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6InNGNkhEb1Mvd0k4Q2R0REVsckxjbWc9PSIsInZhbHVlIjoiNVlpK2RMQlNDSlRkd1ViZ2dTdld2VGFTYlBESVZUYUI4SE9lUkpFN0RXQ3RHeThQYmFnYjkvbXl6V2J5VHYzVncwNzhjNE1UbWZtMGFqd1dhMEVlYkV5TjVCWlc4ek56OEhzckMzWVM5SWUrZVN6TE9QSnViN0pvWkY3SDBvUWtadG5mQmFwSjBBb1dFMGlybUV6RE5uVStMR1NDWU1pTWh5N0JuR3pUQ1lrUkJ0WW1IdVd2dkY3MUdIRzAxbDB3Z25XbjNOSjQ4QU1RbnJKUmVSaFAraU0wWUIvSGkyTUhyU3hjV09aYTlmalJJcEhzMmg0L0UvNlVXdUNyTG1vTlRpOXRmejZmQ3pkWmU4Q05aQWZTZUNoZ2ZPUGRuWmN4bkoxWnlReER5WXExcCt4RmZFMFlUVUNhSS9oY3I5TnoiLCJtYWMiOiI5ZmY0NzQ1MDhiNGI1NTE0NmNkZjFmZWZkM2E0ZTM0MTFiZmM2ZjgxYjkyZTRkNDViNzYzYzJjYWY4OWRjNGViIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(547, '3xwvrnz758', 'EmmaMadchen', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6InFRZkQyLzBOUnlMeDVRVkVGM0tieWc9PSIsInZhbHVlIjoiVUo3WGcwRlR3NFIzaEZLWjgwRmhJT0ovRHZGL1BDRXRnSTF5SGJwRm5BYzRWcmtiUThMR2JySURrcjhCUjZvcGs2U1JpaEErU3Nid2tibElLV3dvOVNYSHo3NGlxNWFUQVprVGtrQVhzRjJkYnFJbjBkTjQvemlSM3ZMSFVOYWQ4Vll1VWJ3bVNEdUEwcWZ2VTlNQUJDYXVKVExyWEJYK2ZBZHdkV1EvWnRreVhyanBzdDQvN0FkZ2N6UTg4NFpEQzRPbTFncjQyMlhtdzd5MGlzUnkyaXhlWUt5OWJFQTNKS3E1REdsMVZSOUI2WWk4dzk5Y3dHdUpsdGpwRjAySVNFU1N1M0x3bUtxbnYySWJnQUx0Nnp4alIvRVU3em8yMUdQR21uNnB5UGg4VmVKSS85cVErWkpzYjVud2laNllkMWYwaFlUMjVQdU82WEhXZDVwdnJRPT0iLCJtYWMiOiJkYjRjMDBmZWMxNGU5MmMwY2Q0ODc1NWVjMzBkZTVmMzY5MTY0MTgxZjdkNWUyZmZhOTk2ZjExZDc3Y2IwNjFmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(548, 'vz5ldnj1wp', 'EmmaMadchen Dating Mainstream', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IjVaQzRhOUdNOEhJVXBHUG9va3JEWWc9PSIsInZhbHVlIjoiOVE3OC90WmVocFJLb3NFUGFMeG1kWGFybGpvRm5xWUczVnFZTGlYQTVTdDltMzdtbWNrUTJGRXNiLzV5djMySzFyMkhpOVN1Mjl0VEE2VWVWUWp6eXN2N1l2aHlRQzRXZHd5dDNUWEFiUlZBL2RBckdQOGlmTWplVVN6TG5acEF2MjFSNEJTSHMzNlFaSWk2aEhNY0hXaHZiTCthdXpwanF3OHRsQXBHclp5STNweXd5TEdSODhjbWdoTFpqM2hFTm5Sb1VyaHNPQ25KKzNHbkZhU1A4cHRMSzZQbm1BYzY4Vm5oSkFMUGl4Rmp3Y1NONGN6M0tjTTZIT1grNGUxV1o1TjBYMlBPeUdkWUplWEcvV1VMQW8xQjRRTzdnZWEyT2Q3OVhuak1ibFFCc0QramNEUldoQTNVWFR5MXRIeFZWMzd3RW1WeDhxdWFRNXFnTjJJQk5vWVVNODNFNlRPbXpoR2krK1l3eU1zPSIsIm1hYyI6IjA2MmY0ZGY5MDYyY2ZhOTVkMTI0MGM5OWNhYzYzYTc0ZGQ4YTM0ZDcwYzZiOTZkYTVmZDM5MDkwNzY3Y2U0MTgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(549, 'x6w30ydvwo', 'Robinhood: Stocks & Crypto', '', NULL, 9.81, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9ncmZjcGZFM056YkhxMHN6RU4zWnc9PSIsInZhbHVlIjoiUjJFSGZrR1gybTJLaFhpZ2VJdEo2MXBPc016TkpxNzdHRUdpazFEdEpzVjd1R3AvdTcyZ3A3RG5vT3pEd0MrdlZDUXdLc2I5SVZkODdoQkRvRXVNdjlXcHlic2dncW5RaFA5TmxEd0V1ZXRRRnJTVTNoWWN4VEVtaytvUHVGaDhvV2JaVVhJK0NFOEJvTzc5am5MZ2V6Qm1nbmwzSzBFYlo0K2thVnRMdm1MOUE5bUNDQTh5alRVZjZYSElQbU1LRW5ud3FFM2p1VmNVU2NYSGlWVmdxMWd0WW02UTI4ei90UENpVkVlWFB5dHFwRVVmR2dWNVVzWXR0cVN3dkg0V3hqQVZ6TmcrNDUySDEyb2piMUpQbmNycndNUGlYTXkyNVZVWVZmc1VIMUdYT2pIdkhHbnc4NTNIQVJZeWVuYkN3M3FCeFZLNFphdFIwZjBKRWFHbkY2Ky9TVWFLVVdjVTQ5b2EyeDR4VGJJPSIsIm1hYyI6ImM3MDI2MzA3NjRmN2VhNTNjMjA2OWY1YWU2OGQ1MmQ4MjBiMTZjZGMyZTYzODhiN2MxOTAzMjFiOTIxNjIzNTEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":8708,\"name\":\"Install Robinhood.\",\"payout\":0.012},{\"id\":8709,\"name\":\"Deposit $10\",\"payout\":2.8},{\"id\":13590,\"name\":\"Purchase Gold membership\",\"payout\":7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(550, 'vm201v8g57', 'eFax', '', NULL, 1.92, 'https://notik.me/api-redirect?token=eyJpdiI6InRJQlZ3VGI0WGF6OW5lS3VObkhqR0E9PSIsInZhbHVlIjoiaW55dkJaa0RadlNndVM1MVJ5eVVoWmRHV0FEOTVzTElzbXJ6NEQ4YnN3UUhvaXArQVZmZWlSUGRnc2lQclFBYzBEYk1QUFhkcXJpNHBycWZidmpXQ3BlL1hZMnIvUVJKeXF3a2JYV290SkNaSFN1WSsxaE5aUTY0U0d4NlVZRGl3U2tLbHhvelhFWkhzWVhkc3BwbFBoN1JQbDBHdkV6Z3MzTnpIek1NenJnQ3JQa0NENklXaDUvSDc2TnVQYW9ZaFVQRUNTRDhpdS9LWGRpNUtsUEVHV0plT3NoSlE2SGxkT2tIY0VEMmhIL2grN2F4ZDF5Y2tTaGVLMUx2SVExWkUybko5WmpFNFcwMHpXRTVSSkJxV2U3SWd2RWJUVjVONEU4NmJFWGhTTGRMSGNjaXE2dFpGMXkxcy9NM3dsWnciLCJtYWMiOiIyNjUzNzg1NzI2MWE1NzM1ZjExYWE0YTFiNjA2MTNmNzRjN2FjNmRkNTY1MjVkZWJhNzFkNDAwZDU4Y2NiZGExIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, US', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(551, 'kp5nnd7d5m', 'Merge Legends', '', NULL, 3.36, 'https://notik.me/api-redirect?token=eyJpdiI6IkJuSmNmZTZyZXZJaDRwSWV3QmtRTGc9PSIsInZhbHVlIjoiak0zUVFPNnJhbFBGbGM1ak80a0VIcVpHSGdHVEUwSVFXNnYwR2lPYjc1bnVybDRkeUVUenJGb2x5T3FVYlJRUHZKZ090MndKbEJldkhNc1hBOXNQeG9oeXYvUHZKOGdYOElzTHJUNktDOVlXYS9jcTlBeGdIa0N2aTRGMmRhenJSRE5IbVlTOGNDY0M1a2cxSzVPTkxnbHVBWFpuQjh0RmRPaXNUWUxvQ21NNGZnNUMzdlgvUjRDcElTbmU1R0NsQm80TVlGVjNzeURlYjFoeHhXakVWMjFMNnJpL016THczMS9IeDU5SWV0OEJqWTFkTHBCV1dyMHlLVDI4ak5ISWdtejBQM1RHZEoySFRvK2hnWUZkd3AwOGhwUHp5ajYzc1FiRUthaTVJclZPbDNHNTNiV3Y4eDBnZ1QrNk5Ud1ZxVzFmVWtITUNHL0dIMk9jV3hTVFFBPT0iLCJtYWMiOiI3ZjhmY2U2NDEzNGVkNmVlNDIyYzgxM2NhNGNkZTU5OTM1NWRiNzQ1ZWIwYzIyNmYwMTQwZTVlZDdiNmVjNDI2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(552, 'oq5zvv742v', 'Berry Factory Tycoon', '', NULL, 1.40, 'https://notik.me/api-redirect?token=eyJpdiI6Inp4RURZcjI2bWFERHhVc2lWbm9lUmc9PSIsInZhbHVlIjoiMWU3OHJUY25DMU8yNGpVK1EyMjNFSnV3bWJwcEdLQ2FqU3JKVDB3c0ZEWEpGbHBDVllrUStGWU5yeFFXcENaN3ZCWUgrSzFFL3F2VzBnR3JlVGdWYUlSVmFQVytPQWtjb3diZVRzTmlQNGVEbnRLWlJBS0VvbnMzemJsYzJUSWFybWFtVDNLYWtpeTByMzZjV2Z4cWVJVWhJRHh4UXlWRVFhU3h0U2NIekd6T256Q1RCWUZTWGxVRVM0ZXFsYVNYOUpFSGVjOHBMQjVSWUtzN2tpQkhqdmlFdmF3WURwZlFtblV3N2ZSMlJkcTc4QVZHQ2VXV3VJNDA0emFRdGRIdTBYYThXbHBCVTkzMXJOSHRHdXkyamdKKzEydFEzS3lPSGg0MUJ4UVNNVkdTb2J0aHNrQnR4V0lIMHRMcUIyQmd3cUZSVlY2MXpJNUhIMmRNU3dINm13PT0iLCJtYWMiOiI3OWU4ZDMxNGQ4MjMxN2FhZTY1MTVjZDAxZjNmNDllODVjYWE4MmZjZDEyMDljY2M2ZmQ1ZTBmMWFmMGM4MDlmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":8966,\"name\":\"Install the game\",\"payout\":0},{\"id\":8967,\"name\":\"\\ud83d\\udd27 Unlock Advanced Dessert Factory\",\"payout\":1.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(553, 'jg58mmn02r', 'Ipsos iSay', '', NULL, 1.26, 'https://notik.me/api-redirect?token=eyJpdiI6Ikl6Y2RtNlBGM21zRGFhQXRnbFRwQ2c9PSIsInZhbHVlIjoiWXBKbE5HS3hiRlhzVXc0dDRUckVlTWxHMDhtMk8xZXFzMjNsNXFES0NWS0h3ZFpxaWJkZXlSd211L1ZNZ0NnNnVBeGQwdzdMakJ1Yjg4YTF6cXJKUDIxK0U2eTM3dWNRY2J0ZE1wRjRCaHQ1Y3kxU2haNHkwOXFENzdlK0ZrL1pRcjJpVGptTTVtZkdtdzZqa0FneEVFWU9VSTdwdTBFUGJxK2NCRE83bFFqOVRqbzlZWjNjNmhVQVBFN2ZteFpLUjBrQkZqTmFET01TL3lPMnlKUTZlS1VUMEd3UlE3MEtsY2ZBekx6TTBYV2dHb3B6bXJlSkIrZUtpdm1QTWNVSERXMUpyMUtJKzUvYW14NDlJN0NVYmQ2cHU3NFhlZHpNRWwxaS90Q0k5Y1k5eXZ4Z3FTU2QyMHRmOFVYbXJrSStyc25TS3NjTUNqSEE4ZDE5eG5WY3pBPT0iLCJtYWMiOiI4YjI4ZWE4ODA1YmFkMzNhNzQyYmNjMWQxYThmOGM4ZGEwNTYzZDA4YmVlNTAxY2QzNTcxY2YzMTY4ZjEyMjg1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(554, 'vr5mddrv5g', 'Fun Donut Quiz 24', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6InVnQ29hcHlURGpndW4wL0o0NUh3UUE9PSIsInZhbHVlIjoiRTZVV0xKNURwcnNOMEVCSjIwTGdLUlNTeU1jWnE1dW81Ui82bHJSenRUM2xRb0k1cU5ib3dOdjh5R2YyWXpLa3JYaUl1MS9jOHBDM0Z1b0ZreGJPSmRQRHBYK3Jwb1AreGlHOFp0V0ozbzFZWkdpSFdSL3FuTVdBcmFUMllEbVdhbGdmaGsvdGNvV1UxM2JJMVlmYVBFZlVJcGJ3Z3QyeHg0Tmp0SmR2aEZGN1d1aHNhcTRMS3U5aDR0TUhMelRLWlB2dURmTUpINFoxMlppYjBzV3BybnhFVzRZb3p5Zm9XSkpKMUFraWJnK0dXRjRFYUxVSGtVRmVaR3pjU291Q2VDenNEeW5KRHJja3Ayajl2azZGQVlaZWpyRGRubEJaRTZFcTZRMEhkRFgyTjlXdlpVYitwNzBuc1RVdjQ3ZFpLSHlVVEpKc1FzMXdSVEtXam80VUJBPT0iLCJtYWMiOiI2ZTU2NzY0MDdhYjc5MGRlYWQ0OTAxNWE2NzU2ODBjZTNjZTY2NDc2OGU1NDA5NWE1NDM2ZDY4NDE5YTA3MmJlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, CA, CH, DK, FI, FR, GB, HK, NO, NZ, PR, SG, US, ZA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(555, '8dwkove42e', 'Proteste Trial', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6InFmL2dydXkyMGZVK3pVMWR1dzBKVnc9PSIsInZhbHVlIjoiNmhreFlGVHRicXRpd3BMOFVjYlo3MW5KOGVvL1VCSHR3THRvOThqMlFzUlJSQ0F1QzJha3pDamtYRFgrVzJPZ2hzSnlRNEJUSkdzem9KMDh1Z1Q0aDhqcVFtR0VUZXJ4czROOG1ZeUZaUkR6ZTNEajluclpLMWo5ZmFwb1JoSlArYlBzaE1QSmpTa2FaTFdQN1JtbVlZZEJuNFAxMmUxZG5NblZVTGx1NTdDYXRlUHB1YmU2ZVFObUZBQWdEelFTSis1dS9UVFBkUVNQSWRBNStYaXhMNmRmeHJaelR4U3EyRGxMRDZuQzEzVWFxcXBPV0JHSWZUTTBnUUpyQzVoMzE3dWN4TDhTQWFZVkcrUUc1ZWJFUHpvUXRwcThONnZadjNZUzhKRjJ6TVl1aXN2U2NtVndpK3FvZUxtNHcrdjJYUVpBZ0ZCOXRlSExWRzE0Ri90N3VRPT0iLCJtYWMiOiI1YTI2OGQxMjA5MzdmZGZiNjI4MWIxNmQyNGU3ZWVkOGNiOGM4MGY1MmI5MzE0N2I3NzE5MTM3MTI1MTJlOWZkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(556, 'y4w4lrq650', 'Offers2Cash, earn crypto and rewards!', '', NULL, 3.00, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9HcWZ5ZHFYc2dONjJYaWFvYmdtclE9PSIsInZhbHVlIjoiMmg3cFJwN2IwZXBySVVhVUJhSTRaK0s4eFNkckk5VVRmb3lYa1NXbEpqSFMyaWhoU05iWVJDQUN3V3hsNWgrcmlHME42NWZIWFk2b01aclpIZllSeFBNamFyb3dRQWpDdzZSQ0JWYUFhdTVnelpid2ZwN09CaDBVeGcxaHBKOG1Od2wya2o5KytJZGZmRGN6d1c1bHc3OXRCMGl5KzZxbUI2ZmhIVTNNQThBWFJMMjFBcGxRbGc5VHZNTnFsTjdQeGJlSnJJTTBldEppREZ4Q2czalVEN3UzV3FyMGpycWxqUys1cFFlYmdISkhaWU1tY25wQUZ4dkMyZWJKWXZUNG5oYjE3WU40eTMxMUN2dHZCdnZjRW8yc3FuS2NWU1BqaUNRQ0hsTVR4TGZPR1kzYzlVUUVVdkNKM3hFS1FScUl2alRWQjlNRFArSmo1SnppMlNjMDR5cmhkWHc0R3VBUDJUUDZWODJtckdNPSIsIm1hYyI6IjVlN2Y0ZmI1Mjg2NmM2ZGRkNTFkMzIyNDc5MjBmYzhlNjE0OTIxMDNiZjQzNmVhYWYxNTE3MTEzYTk4ZTdjOWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AM, AR, AT, AU, BA, BE, BG, BO, BR, BY, BZ, CA, CH, CL, CN, CO, CR, CU, CY, DE, DK, DO, EC, EE, EG, ES, FI, FR, GB, GF, GR, GT, HN, HR, HT, HU, ID, IE, IN, IS, IT, LT, LV, MD, ME, MK, MT, MX, MY, NE, NG, NI, NL, NO, NZ, PA, PE, PH, PL, PR, PT, PY, RO, RS, RU, SA, SE, SG, SI, SK, SV, TR, UA, US, UY, VE, VN', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(557, 'k15onndx2q', 'Calendarios de Adviento', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IkZNaWQvMkFvS1RQaDNJejNoMldSZ1E9PSIsInZhbHVlIjoiL3dEWE5GWHk2d20rOVRWaTNhVkJWaXFZVUZaVVJXUHZNUXlGcnRqMlY4RDFTbytUbWlvU3E4eU9QTy9mTm8zYm4vVFFHRU1DMDNtamhaS3NmcE5FZ0NUR3h4M2Nta0ZIRkhrb1pDSVRQb2oxSmt1Y1g5bnBRSjBOYjZjenUwOGR2SUVZUTA3eU5RdDQwb1h6d2h6UzNzQjZoUWtyMURJUTA5WURJeTI1UVJkZmhtTU1EbUIySk8zVlQ5YWZnY2VDN0ZQbkRkdWtvODFadldPRlhYcWgrMzhJRnZLU082UHlyRG85UDE0OUovZDNyMWVaRElYdCtmV0YyL3dCQklaR3hZRytPZ3FSdjNSRzh4ZVYxRnRKTlBRNUlEenI2S2pzV0hsYXFGdEJQV1hMTDJLQWVlYUIxeTdRVFZ6YmQ5MzhxU2ZleTFRVWVLTmNtS0hUZEZMRmJBPT0iLCJtYWMiOiJmY2IzZmM1MmIzOGI4YjAwMjBmODU0YmQ3Nzg2Y2YxOTRhYjcxNGUyMWY4YTE2YWVlOTNkYzdhMjIwYjNkNzFlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(558, 'xr5edd342n', 'Coachella Festival Voucher!', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IlRLRTZQcUtZcHdMWWFtdDI5VldPUUE9PSIsInZhbHVlIjoiM2NSay9CMEJicUw4U1A2dEdvbWRJRDM3ZGNjdXRKMzFoWVBOcVl3SzE5cUplNWNpRzQvRFhBTjZPNi9YRUdlN21sRU5wdEZKb21pd2ptVlN5dW50a2w5eHpBTXFOcElDRXFoRmFGRjdJOGZMWGs4T2Q3eEdWZ1ZYS0dxK0RzY0RiVlZTd2hlSDZDQ3lIcE9xSVJIbEI3Qno2eWFsaFZxUG9sRmN2YzdBeUJuYytWcGtoZkEyemRoQ2lMWmJ1blhTWTZSa1pBTkM4dzhKUTlFbm1kVkFhSkFpTUdkMktVa3NVcUxYc3JEZU92SFc2VUdCU0gvVTN1aVVJUldvazBsMy91a21vWStpdGJwQzFDci81bWhFM0tvZzI3RUo4NzE3TmRRakhlbzZsalBLSU5ibUpMZk5SNEpodUs0MmZLNUZqOUhDTUR2ZjRqVXJORWFJUGxMWkFtdGlLUmFHRUxYVERUc3ErbmJkY1JnPSIsIm1hYyI6ImM5NDkzODZlMTI0NTk0MTdjNmM0YTM4ODY0YWIzMWI5MTViMDFlNmMxZWRlMzgwYTY4MjAzMDFjNjlhZDQ5OWYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(559, 'qx2900gx2y', 'Crypto Miner Tycoon', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6IkxFZVlJWDJQSERqM2RVT1BXRzlMUHc9PSIsInZhbHVlIjoiemNWSkNKRkd0MkZCUzFUWVZESWFRakFYWHdSdU9yakJkOUMyVGtVUUdaTjNyWTJVNXo5V244UlZBcFU4UXJRNkdzUkNmVE9aM3JJdDZQK1ZWVlo1a2pyTWZOU2NSQVFKcWpQR0hlcVFWR3VFRUVxZTlHcE5wUmpkNHVwMmk3eThvMXI0dDdGaUE1VVdBa1JJVnNPR3R1VWU1bFB2K2s5SUE5VFErMVB3RTJqWXdkOWRPSVU0MTU2ZWQxdGZ5eFJMbVI0Z05IRlIzVk5NS2RPbjBwNnZPbnhaNFdWL0hraHhjZnAwbVkxZTVlaG9zWDVpNTB2ZytxNjZmbEQ1NnBXSUlrK2VKVWNsMUk1WDJQUFpZNGk1b1o4bnZkb0JZR2N1VnVCa1ZKRUh3RCtYSnRIUGV4dGM4ZmFraXhWRlFiS3NYS2l6ZWxwbFdVT1pqMVE0QTlpS3BBPT0iLCJtYWMiOiI4M2I3MWE0YTgwZWFhYzI5ZTcyYWM3MzM5OTYzOGQwZTNhMDFlZTAwZjFiMDliZjU5M2ZmNmNhNzcwYTlmNjdiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, ES, HK, IE, LU, SG, TW, HR, CZ, DK, EE, FI, LT, NO, SK, SI, KW, QA, SA, AE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(560, 'k15onn082q', 'Harvest Land', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IldhVjVsWFNjckZtZmhTYU9HWkxwdmc9PSIsInZhbHVlIjoiWmFaS1pMYnIxRjZwUkJzRlZHSERuS3BHNldIUVBtOVhCZy9uck5WbEtGVlBFMGpDRHAxQU8xb1Y3RFRLdTU3ZjJZNUszZXdVMUt5UncxNWw2ZlhpcnBFLzV0ZkMxVlBHYStIMjhBY2F5YnRCSzg5d3lTOXVuNjBSU1hOOFk5YjRwM2VHUkcrRlY4YTVCczZ3MUVYN1Y1cmNCeVY4bWJUQy9Ja3BwOU9obnFBUTF0MEdJWkFEUXVtV0FtbUV6TnJlWUJrS3V6YUEvM3l5U3lIWE9IRk1YTVNJbW54TVNYcXc1a2dNaDJoei9FbkpXRHVCdHJDWHcrRURmc0J6MGYzT1d6bEplZ2NiVkZ3SWxmRS80RitjYkdTRHhNSHgrU0JJQit4SkJqQXNpV2hQZDAzWHVHRlllbHU0UjdkYnk2dU42QU03TDBmNmM5R3gzS0E3c0RUT1l3PT0iLCJtYWMiOiJlYzYzOGQ5ZjA2YTk2MTAyZTgzYjM4YTJlNzU5MTdkMjFjNjAyMDQzNTdhYzZhZTViZjZkMTAyZDJkY2U2ZjU3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR, LU, NL', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(561, 'kp5nnn8y5m', 'Harvest Land', '', NULL, 1.26, 'https://notik.me/api-redirect?token=eyJpdiI6InZIM2dRTmR1aHRJbmd2NDl2b1NJNlE9PSIsInZhbHVlIjoiUnJpdFFBcFZYM2hZcUVOT1JUZHBCYlAzKzBTVnQvaGtIZmpWOHF1U2k1bXpLLzVlZ2hMRG1oTlN4YkgyWkFOU0FRTkgxbVh6R3NwM0U3cWdBWFM5SlZVUlozc0ZrSnhnZEkxUmo1MklwNkZQU2dqR3BUZjhDQTZ4Y3JXZzVSOENnOUtXbWgxNVJ4em8vZ01WTHRxSUtxZk4xNHlMMEkwNnkxbVROcnJUNVpvTHNZejVvdDZWL2VhUXMweTNCWHBJTjJFdUMwMC8vNE9iZGtjQTZuYmo2dnY0V3B4ejBkVGVsWUlaVkJZQXMvdkkwMmx2Ukd6K1R2Tmd3bERwd2ZvVzZOUnpjQ0s2Q1pWMXdpd2Jqb2x6eEpMbkIydzk2SFZYelk1Uy9XblVPT2lXWUVGYWNKMkd3aVFPKzNtZDl5ekNZOWpxcHNZTk1qdS9IdHBwQ3dCSjZBPT0iLCJtYWMiOiJiOWU5M2JlNzJlY2E4MTU2M2I2NTk2MTE0NTM5NWM5N2IxZGQ2NDY2ZDA3NmM3Y2Y0MjA5MTQyYjcyMzc4ZjcyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR, LU, NL', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(562, 'xj5gqkplwm', 'Color Test', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjV6VVN6ZUd6SW9iaXFBVmxEc0dLc3c9PSIsInZhbHVlIjoiSmZCL2xhRkFJL2VBMlFKQ2kzRTFZM2txK1ptZ2VtR0wyWWxsYWs4R1Btdm5mUjRrV2cxTW5zbUdrMHdOQTBqbGxXWFVBbVpYU0pxMGV3ZlkvUW0vWnd3MG1XR3NTZitQQW9kaGxpMEVqaTdWZk9ycXd1dTYyb3hRT0VQQzdYVVpiSjRXSTZwN1praWpGd0s5Qk9uV0Z6MHlNSk5qTXc2d0xFWS9OdGxVNGF5UGg3NnJleGwvRVJ4eHFRSFNWeVdyWTFYTExYWWxCVUdza2xlZmJpZFY1UGRScURwTE1LNjRKK2s1MkNHQmxLTXBkeHgzUHhRV1RNNXFyLzllWDRLbWxyVEdUOFU1Z0hiSmlXTlpYTzBGYVVXNEZRa2hDMU53cEV2SHMzUkNZUVU4QzZ6elF0WjJ1RE4xU0gwb3lPNkFycDdpWXJ3WTExY0F6TTYxd3JRZm13PT0iLCJtYWMiOiJjMzFmODBhMWY3NjQ1NmQxMWU5OTQ1N2IzZGNiMmE0YmQ4MTkxMzY2NDRiMmQ1MWYyNTdlMzkyYzIxZTE2YTQ5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, BE, CA, DE, DK, ES, GB, LU, NO, PR, US, ZA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08');
INSERT INTO `offers` VALUES
(563, 'y4w4780lw0', 'Angry Cupid 24', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6ImRoNEs4RFhxeXNzalZQQ2NvSlcvQ2c9PSIsInZhbHVlIjoiUC9YVjg1NUR4WlJEMTlGbXJXLzVRakpaWFZhL1l6WkdTTEdDTzFMMytvVDRaKzNPcVYwd0ZNQ282NTBoenF3VmZqeG1ibU5SRUlMQ0plN2k5b2NUWGdHS2tjY2VFT0xabWRLNVpsUk5RbmwzNDhLTTl5ODhpRmhXa2xQVmhzNzErejh2dUFxVkpCdGFsSXFGb3hMc0JZSldZOUlyMzZOaGx2UDc3TnZVb1ZqT2Nub1N4RnkvRnh6RnNMSDdnK2R0a1lvcVIraC85RTFGeHp4VnQ5OUtyd0JwNjRvUVRJblQ4NFIxY2xaNGIzN2x3SVBuREhaTyt5Q1ExWlM4ZS9pUm9ERjRCRmxJMW80M3BzVjQ2VXArNnhUekNOZWJFS1VoSXpiZUpjbTU4Rnh5eXZrUGk3NzFHRXRlTitieG53S093WDZmR05EWlpxdGpEWlYwaHJ3RjBnPT0iLCJtYWMiOiIwY2E1ZjBmYmE1Y2Y1OTc0ZDdmOGJmZGJiNmNkMTEwNzkzN2I4MzEwMGI5ZjBhYzg5MTYyZmQ4MDhiOTZmYzRjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, BE, CA, DE, DK, FR, GB, LU, NO, PR, US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(564, '6pwjddg8wn', 'Cognitive Ability', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IllhL2tVNzU3N0VPU1ArU05QOXRlL1E9PSIsInZhbHVlIjoibG1LQ2pKQkN6OGU0bXgvMTZiUEFGOWxTREhLRENUWnN3UnZPZVZCSEdrVHZFcGJ1Vjk1L2REZlZrZWxpM2s3SVdubTUvbzJLQVpNNkl0OWJsNHBLSnBpOHBSaC9tWW5sck9SS2JHTUtEUDR0QUovNk90dHZCUDRmNVNsOWNhTWVPQ1pCUWJ4VHJXVlY0NmhKZFRkTkVMOWg0ajQrUW1ZTW14amM3VkdzMXNyZTl0am1iK0hrOUxMSzRXQ3F4T3JhSEJJNVhTYU05YkJ3b0RPMHRJMWttUS9nQ2xHNkxuZkE1S1JYeStCYno1Q1IybzdSS1Zwd0JMSTBSQXRDaTVTOVFySVlqZjhLbm9JaFdud1l1cTJPVUtFank4U1JTSGpGVXpGT1FpR1FVaE5FTUE3RkxZSllub3M0Y0VyMWNVWFVwOW9lYVF1QThzd29oeWxNV1BVcFZBPT0iLCJtYWMiOiI3ZDYzY2Q1YWNjZDczYWM3MjFjZDczZTYwMjg2ZGEyNjAwNTZjMzBjOWI1YTAyY2ZhODAxZWI5NTg1MjA4OWU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, PT', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(565, 'vr5mdd165g', 'World Of Tanks', '', NULL, 1.84, 'https://notik.me/api-redirect?token=eyJpdiI6Ims2MitBRWY1UUFlajMyVStRWEZ0R2c9PSIsInZhbHVlIjoiWnNiY0FIeWJkNVpzbE9RU0JRYUJDOFVTQnhYWGVWRkFsVkR2VW15elZUQVplV3dhWk5LVXFJVFRVU2NlSU85ZkxjL3ovUnNIVGRKc0ZMQmgzdDhQeWgrVWJGTGFwNG85MUloS01kQXVxVzhVSU43OFVRYWNrdU5NbmFSM2NsWFRiTVhnSkhuVy9PbkhYbzdMbWtRNytnQ2VOK01TeVA1Mkl1K1p2QStrcHczVWlUbmRIeVkrQlZxNW1HU0RaYmRWZnZkZklKT3VPQzJiZ05DWHFpdzlvTytaZTRlcHdDTDh1TnJJc2w2cGRCWUdhUkx4WVVmSjh5ZVdLMWtvQVFqQU5ISXp6WldCU0VsbXM1QStmQjgxZ016cVhIUlZhRHdaeFp6V1FrdFBubUx0Zm5SNWxlK3VYdWhkVlpBRXZORHRSMUlXTUNXQWR0RXB0SnY5UDNuNEhnPT0iLCJtYWMiOiIxZTZhZjllNWEzNjg2Y2Y1MjQ4OGUzMTc3YTRlOWZiZTRjYTE5NDE0MzQ4NWU4NTQ1MzhlZDY2YWM3ZTQxMzU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, BE, BR, CA, CH, CZ, DE, DK, EG, ES, FI, FR, GB, GR, HU, IL, IN, IT, JP, KR, LT, LV, MY, NL, NO, NZ, PH, PL, PT, RO, SE, SG, TH, TR, TW, UA, US, UZ', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(566, 'y4w47mrlw0', 'OhMySpins', '', NULL, 12.40, 'https://notik.me/api-redirect?token=eyJpdiI6ImJzS1VJQy9vTUc1SnFVQlJZT2llQmc9PSIsInZhbHVlIjoidnhONE5vM0dWcmljckU0WkZnYmNsZng0VzBGVG10VEhJK3cyUjFqbVNSYStySUcyckFaVGQ3RXNLamZraGJWK2Y5WG1jbi9UYkVBQU1VRTlrS09qb3YrRlBlQ3hZa2Jzc2p1cXdLOWtScGJzTHZEeCtLT2ZhUmozOHc5REg2bmcwOW95R2xwVGJQZGZRTkx6eThNazJMbUU3T0srVHRtMTNIOC9tMm9Ebkk2SmV6ZHdXZmJGNThRVWc0MzkrVUp6VmpJMjJIK3lIcHB2cmNPcGNmVjQ3Q0ZXb1NOaDNZMGhDZ01mQkNWaU53V2FYNTNTanZGTmgvSXRoLzZDUEMycmhTWUIyS25WQTdLSFlMbkEzVk9MTGZadjA5YlJ0WEZaczJNUEd3RFZKWnU2WDR4b3dveGc0ZkJMK2N2WU9DL0wiLCJtYWMiOiJhMWNhMDVjNTE3ZGIzNTAzYWM0YTBmNzI2YzI0Yjk3ZWRlZjJjYWZhNmRmMDhiYjI5ZTVhYmEwZWY1NjQ2MWVlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, CA, CH, DE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(567, 'rx51q006w6', 'Ipsos iSay', '', NULL, 1.05, 'https://notik.me/api-redirect?token=eyJpdiI6InlkbjRWTzMxckd3b2w4M2ZTeTBFQUE9PSIsInZhbHVlIjoiakMxMnArRGJxaStmNXR2Nk9FcWNOMGRQVHNJRUszKzhsNFY5bDdpeVd3NWp5UElBNnV3d3czOXNwWlpsOENNYmMxbGQ1Vi9KdFJBenZIcUFVWTVCKytMVDUwbDlCS3RqT3JMZUgwcXJqRTlFaHJMN0tDMUordk1ZR21PWTkzU1lyeVg0aWNWNVJiLzIydzZweXVpekgxQk5Fb1ZGNzFURFYyQzVmT2hCNTdESlpNZE5jQVJndnBQeGdXd2hHQ0l0UzViTkVZYlY0YzNvbHZlMkFCTHdOdFFNejJvMEowU2tkUUZwL1h2d3lyYjE4MURFQWxvRmIwWmV0U3BCaXFwMXRlWlNhNkp2N1BwNUJmTWJ1blRWNy9TNTJzclVmd1E1OE1UeCt2T3B0ZnNSdzBEeWlleTNRSlRGa05tZUhxRDN4UlNhL0dsRHNWS0NjMjNuTnZ1NmdBPT0iLCJtYWMiOiI4MjlkODZkMmFjNjBiZWRiYzZlMzRjZDE2NzZjZTc5NWQzNzQ3Y2M1OTZjZmU1M2NkNmJlMjdjZDE2YWMyMmY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(568, 'j05pkqvew4', 'Career Survey', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6Ik12aTIvakdLeXpGNlZxQk5QM2xDOWc9PSIsInZhbHVlIjoiL0ZYaEVWYzNZWWlSQmhRbjFkTTRmUTltcjRJUytLbStJNEFvV0NDbldDOCtHZmRxQVBXbXNwRzNBQU9zbmVGSzZHZVpUTVVaVlhxanJTUFNPQXFDR1dUeW4rTk03RW1wVnVCaVBPNE16Tk9UY0RGdHNCUjJVWHJnWU4zWUd1bVgramk1eHpHN25jVjBvTU1BZ2E3RWZNVUxqUzJQMURkRjRzekc2YWhsTzUxdmpoRDBaV0ljTjBYbHhrbTR2TUdNaHFBdFdieGdodzcrb2lEUW5MMEFoRUxxcU5HN1hxb0k1UUJGM0g3RURjRm9BRndSbDJzK0R1ZGk2Vm53RjRsYW1EL1hlZnIzeDd3eGFhc21YaWRzNDVzMnU3UnRRQ3MxMnp5cDZId2lHdEEyRGg2ZmdzTnE1SEkzSGJGT1NheDBSN0I2eE1nN1FHenVzNUdaWDZlOEN3PT0iLCJtYWMiOiI5ZDhiYWM0ZjU2MDU2Yjk2NGZiMzIzNDU4Nzc0NmMxNGRlMzZkNGZkOTk5YTRjODA2ZjI3YzQ3ODUxNTViNTBmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, BG, HK, KR, LT, NZ, SE, SK', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(569, 'jy2rog932q', 'Content Red', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IngzUWplblZhU2p6ekRKbnMzOXZiakE9PSIsInZhbHVlIjoiZjJiNzh6Uzl5SjFndjBFSG5BdXpFeEFmQi9JR2lyZ0xidEJBZitNU1h3UXhyb1ltaWx3Yi9BcHlBMnB3WFhPaVBrcFZYcGZRL0EreVVEZ1IyYlBPS0U4dFFkL25jZUVHeXdkcE9uRjBWbk1lY3pjbkZxT2xjUms4dE5GU1lFTjd5OXNWTzBheEI0VWdXRllNUFpndDdiYlFveksxb2hYbXFjTlVKYnRSbitLVEVBUnl6ekY0bWRORXVVN2JJR3phVlhvRHczYWFWbWFxcSsyNE1kajh4Qy9MRlp4VnlLaXp3YzdkZzVIVE9HUUdseHRHZGlScmU5ajJqcXdtNVlmVnhRalhJNTdtRzlzSWRXMUtnR0VPTVlxajlubXJqMnBFVVNYYWFxNk94aXVnbmUvY0gybzBrNU5sdXRuMmd6dFFsRWpTWXcybi94YU9pS3d5N2RCNTNnPT0iLCJtYWMiOiJmNzgyMzcyMDY0ZjYzYjA1MzA1ZGU0YmI2YTBiM2VlZmQzZjE1NTZiOTZkZGZiNzU3OTc0YzhhNmI4ZmMzZTMxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(570, 'jg58mkeq2r', 'Content Red', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6Ikx6RHhsYXRxQk84WjhlLzRQUVJWZlE9PSIsInZhbHVlIjoiTzlSS2EvUXRlcTk4U2x1ZzV6NUR5U2VyUUVZQjRIc1JaTC82U1B5OU9WQ1VkazRHUjR5bGs0NEVrdFMvTlRWaHRSRmd1OGx1bmN4TWRiK2RIUTlXVGJQVGNua1FWZExSOXUwcUNEUHJSMTQwNlJDWjUxYXRwYXB3QUpuM3RvOXowMVVGUk5VNGV3OUt3dkJ3eXd6b1FSYWpYcythMHZVS200ZG0wNnpJUTNaSUZML2NFMHZWNms4U1VjQzBvVnlVaEhwUE1pU1hqb1BvTWhkRGlMYWpHYjVNeE5VdmZtOVU4ZUVUWlF2T2tqdmk1bndteWc2N0VkSmlTK3Ixc3ZiWHgvdDNBa2xJYzZnVTdPTlAwL0xrWUNtQk5HYTZucEpjb2JOZm1BVkREN3Bwbk1abmFxY29vZGd6VnpqS3pEWG5USTZaK043bmltR1ZJU21UUjJIbU9BPT0iLCJtYWMiOiIxN2FkMjViOGU5NjUyYTJmMGRmZDZiYzVkZDg1OWUzY2VmYjllMjgzOTMzN2YyMjFmYmNhZGNkNDgxMjZhY2MxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(571, '6pwjd3mrwn', 'BeamBurst', '', NULL, 0.24, 'https://notik.me/api-redirect?token=eyJpdiI6IklSKzlabThpcUJjeU9xbzhjMkx3RWc9PSIsInZhbHVlIjoiTnBNVEMxOXZHZ0h0bWJXLzlnZ2VyL1ZwM1psNXZnUFU1aS9HVEZTdVJ0dVZySkYxbUpid3BYcVdlM05RNlEraHl1azd0dEpTanp3SjFvMDRZTGdhMkw2L0NkQk1VZ2MvTlBDOXNJaFpyL0swS25WbGhwQWhPTjd4UEdLWU9tc3dkOStLUm5rci9nS09hTjJUVVJRM3QxWmVrUysyQVRhR1NkTUd1MWFCdElvRTlOMlJYc2xkb3Y1ZkpvZThrczJMV0F5WGgrOG5kZklSZWZxUFprSDhRTXg2b3RrV2J2dHMwNjdCdlhydS9Od0QzZkl5bm4ra0pOU3k1S2RtaGp1K0c2OGEweW54ejdFdzNQVGp1aGJBeXZFNTdVS2tjQ1Z3YzdqbXEyTTR1bCtibExtVDZmSnRqdXF5RUFYS29UaWciLCJtYWMiOiJhN2FiNjI1YzgwYWQ3MDkxZDVmNGNmMDNiZmExZmM2OTUzNmVlMzFmYmRkYWUyOWU2MTNjZTM2ZjAzNDc2ZTlkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(572, 'xj5gq8jzwm', 'BeamBurst', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImsxZkZRY3RnZUpYUDl5V2lHMFh0a0E9PSIsInZhbHVlIjoiM3dnckdmUWRucnp3YUlHMFppeWZEejN4ZWs3NmV4ZG45aGhCN2kxT0tWY0V5QWlDWm1xaWV0YkRsRkFIUDJJbmlRREtPMDlwc1N4MGZhOUUzUzI3NzM1bU1OdFR0K3lBRlAvT1FCbkdBL1pBaVE1NWZWS2RXYUwzQ3hCZnRZU3VKUHkxVXdWYlVRVS9HTmJCSTN0UEl5TXNjUFluUXVXUTcvTHdpZTNvMlVGRWFEOEd4VmNHS29ZNnA0cmlrNnpSQVhJZWh3R0hkdVQ3T3lpUllwcm5pcVBFcWtyZlV5NFZJYzE4b256T1lqdUd6RGJnRDVaS1BGOTZFRjd2Z1k2ZEcrb0VjRmJsZVlmNjR6aWszdk1yT2s0RVZXNU5KbmdOK3YwbnZzM0MwSERxelRUYTdIQWtkbURKNVV2UkxIWCtBYmdVQS82QXovdEVzVXB3VkxCYjV3PT0iLCJtYWMiOiJiY2VmOGYwZmI3YTY3ZmVhNTY1MGM0ZGU2YjI2MjU2MTZkMmI1NGNlNzhkYWU3NzhlZGYxYmIzMjQwMzQ1OTEzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE, ES, FI, FR, GB, IT, NL, PT, SE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(573, 'xj5gq84rwm', 'Futubull-Digitalized brokerage', '', NULL, 1.96, 'https://notik.me/api-redirect?token=eyJpdiI6ImhhQnE0VXVLTjNrSUN1TGFCbEdPY1E9PSIsInZhbHVlIjoiUTkyVFR4M0JVL1Joa3poK1M1WDFESitHUjNBeEV0TVNKWFVhWFVnY0tyeG5YeE5xWm1aaE1iQWkyN0c5TGgvZWR2bFBBbW9HdWJSME1MOGxZSFBucFFNd3l5bDc0QUNDcjhaV1RQc1ZxMWF2SnlQd3BBaFVTZXhRc1ZYWE5ZNklmV2NWS3JSTWVrbS9nSEQzY1J4ZFUvVm1Qb1YzbUQ4bEp0ZDcrQjFMT0F3QXF0aFJqSS9RdjV4N2h4MmVmNEliTFh2bDl1OWEwTkJFNURKL2JrdVYyL3R0Q0NiTjlBc281UGtRUTMyaGtseTRvcVlPcmM5SHpyRWkzM1FjRGRidjhlYWRlTnpyVG5sVml5OXVVWjBWclRGemVwdGs0ZnMzZjNKWWlWRm1BSmxLTW1mM0pMcjU5UmM5eVhQV0lMMkFONEoxMHgycVlpaUdaeGlzT0gwd21OaXVRWlk5eTA1UFFaNW9zK1NqcWNvPSIsIm1hYyI6Ijk4NDhmNjUxOTNlNTNlOTdjYjNiZGUyZTBhNDAxYjA0OGYxYjkyN2ZkZWEzMzI2MjUyOTRkNjNlZGM3MmVkODQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(574, 'y4w4741jw0', 'Gewinner Lenor Set worth €500', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IjFYSitiUEd6QjRadFpFQkh0Z21NM0E9PSIsInZhbHVlIjoiZStjWHVRMEJFN3A1bnU0RGl5eWNTQ1BBOFFoNXRFd3RBQ2JhaTBsbEZTV3Vwb2hLQm9qYTlNYUVTYlh4TE5ZV0xXNThGcC8xb0Q2YkxsNmlPaExoaTRpVGh0VGU5M3ZTOXR5WThseWlCaGljU25ZZEp1OWNFaWNhbUN3SHhZUE5NRnVnTVZLMXV3RGhyV2ZqMXhtd1RhZmxkd2l2ZUxvOThldnVjV29qdTJhL0gwYVF2aXZXc0F3Mzc2Um0wcWFIcTVsa1UxbUtBZHZWdFVyZmFFV1RQd1JlUGZoamtUcksyRTJGY2Z4b2Q2dlFuZlNDa3VkKzNQMG1mSExsZnB0c1h4NWdKZm82TDAxK010WVR2aEJCQ21LWlgyQU9sK1dWMytXVWQvREpLSG5xTFBmcFQ4bTdVeFdYbnMwWnBxRkZyOG1ZSDUxSnJRZjRRbDRyc3FyQ28zYmhXZExLWWs4dFlmRUY5YW5qa1BZPSIsIm1hYyI6ImZjZDBmNGZmNDUwMjM3ZDVhNWY4NjJiYWEzM2RkZjU3OWRjYmEyY2IxYTljYTQ2MTZhNGU3OTQ2NGUzNTVkNjciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(575, 'k3w7q8o42o', 'Brain Test: Tricky Puzzles', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6InN2Vjl0U0NwKzhpaXMvbW5DbE5NT0E9PSIsInZhbHVlIjoiaU5kV3NYTjIwUFM1QVZCVDNVOGVsbVo3Nzk0OFlIUnhIUWRvQ0syQnU2WWxzZHNMNUJNNmJ6YVJRV0pGU3VVcU1RbnlHVmJtUmExTXNZNWdISUtVcnJOdit0bmRQSWFWQmNFdmJwdXIrL3ROUEhobDgrT2NHcXFZRkhsT0hnazQrdmxPMURacHlIWC9PVXlLNzlOZmdpTzFac3hKMVFxQldONWJxcGg0Mkl3R1o5ZTFYS0lUc25pWFdpT09lRXdwaXA0SW1kWVN2c3ZVaGVBSjlIKzlFUng2eWoyaU1iQW1ZWVNrenh2YkZSTXRScldVKyswYnZnNUNXLys2MXZ5dlFkaGZMU1RrZFlockQ4RVhhdnNRazdQUXdvd2RPWEd5d1drU3J0Y09Da2VtNGFhdE1LNkNOTWtwbDlkTjM5T0syOHRHcDU1RGNkQ1VOUURma05VM0lDYUJVRGNNNFJ4d0xwUE1sYmpTZmFFPSIsIm1hYyI6ImM5NTYxNWJkNWU0NTRjZjZlMmIyZGNjMTU4MGIxZTZkNjdkMzFjZmE4NmU5Nzg3NmI5MTNlZjQ5MDYzODNjODEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(576, 'zm2d3l4owq', 'DealClub', '', NULL, 1.96, 'https://notik.me/api-redirect?token=eyJpdiI6Im5LL216OFpQbEtHRmU1UHVGcDJndlE9PSIsInZhbHVlIjoiYVd2QWkrTnBGYzVHYlVDcTFNQm9kSTBJamNncHVqK2xDZ3Vnb3hPd0RlV0FxTVpmWVl3NnpiWnFTaGQ5T0FKd3NJZFZZVUNlZHBsdGUvVEVMVmRrNWxHeHZ6UmNpNGI5aWxOZ2VnTWlBeE1KMFR1VWVhTmdBV3NPTGlHTm55OXVaTXdDU1BCY3N1NXBVVEYzczBWR2RTNGVHRk4vSm5JY25tNG1TcDVSbGtHbC9oS2xuTWNkaWVpWm1jK2FmK01NalR1Yyt3aWU1KzlzZzR5NTY4b1pwZGpKRkZrM0VSZVFGcGsvTDlMTWNXL202S1RNc3I5ZERmN0VhakE5S2ZKdE5sdE8zVUgzSzcyUGFFTXNDV0NidkMrTHpDUk5oM3hWeWdOQy8zRHV2YlRxMG1VS1o1UjRlNXRmMU41TjNNOXoiLCJtYWMiOiIzZDgwYWYyOTYzNGQzNjM5Njg5ZWU0ZGVhOTMyYTQyZjQyNmUwY2U2NmY1OGJiYTZjNjlkOWRhNTE2YmVlMmRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(577, '3xwvr6lk58', 'All Document Reader & Viewer', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImExVFhlL2ppdm1EWkUrbDZaVjNDdkE9PSIsInZhbHVlIjoiQUpyWFQ0cWFCY1phclo4ajlWSUdkK2lDa1Fua2o2cVJJYlBKVUhlSmk2NkpsWWY5dGFDV0ltM3BaRlFuaklXNFZlK1d3YzJnU0dsOVdrWWtvRkNHejZLZTdheHpBb3VIRUJWMVYxTUMvOWJ0bmZkUEZpY3NWREJpaTBxWnloZDdFRmJNYmlRYXY2T3BHRGF3NmtPZUdxK3dobDA0MldHSHhaZ252QlF1dzBjS0hoeUU3aXFCUlhVOHZZM1lKNmw0aXhxVmhzdGNPNW52cDhza3RnTERVVGtXYzY0d291cFcrSks2VHBpQ2FLTmZLbktQbGVGQ0pJYjdkWnFSNGVpVFJWV0dQcmdCcHd3S044cXhPNEFUUHNYSE13VWFBenU3RmI0dGZIYjQwNFZFS3RzZm5hU0xSQUIvbUlFT0VVSWVudzJSRHRkdUhJdlVqVlVId1ovRHFqVnA3RjBqNFptWHNJY2l6ekZHcjlnPSIsIm1hYyI6ImY5N2JlNzUwNDc4N2ExMjMxMDNlMTJiOWM1MDJkODM4NjcxNmU5MWYxZGFjOTYzYjIxNGEwYzcwODgxYmYwODYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(578, 'vr5mdp665g', 'Legendplay', '', NULL, 19.60, 'https://notik.me/api-redirect?token=eyJpdiI6InV0VXlQK3pmS0RhK1pSa2VibGVackE9PSIsInZhbHVlIjoiY3QvRTlpenFKaDlSU0d4RHpCSXhHaVp1bnlBZTh1dTlMNFJ4RzQrWXl6RXJmbVdpc2dOVEtVYUhhQnNEWEVyS3dmWEh4djFyd0MwTG5DQnY4REVScS9Va1dQSk4wV1JobmRQUHpZaGdQVmVUWmZ3QVo0U0lCU1NwTkZPWkcwdm1uMEVpd2hpNzlPQ0dsRHY1eXZVeUg4SVp2QXBjekNVdUE0VzJwa3FQUWh3eUlTalZFNEFDUkQzSG1MODdzbVJic2NIQTQzTTNYR0JpK09FZ3hudGxxa0xjbDJGZUx0NENRenpIb2hlRm5pcy9xdkdhVlFGSWxVakFnalBKeUtGb1RRTnA2VGh2WjJnMnNmMXBCRE5GOUxVWDIrcDBnV2JVL0FTTXlweDF4OC9TRE82aXVUSHR0Ym5BMUZhd2F6TGVoTC9STGdZbGhXcEVuWVQxaWtEN3JnPT0iLCJtYWMiOiI5NDRiNDlhZWE4MWRkNDYzMjYwZmVhNDRjYTY5NTBlZWEyOTllNGRkYjUxNjBmYWViY2MzNTQ0MjNmNDVlODljIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(579, 'j05p3ydv24', 'Merge Double Number Block', '', NULL, 0.27, 'https://notik.me/api-redirect?token=eyJpdiI6Ikw3a050SFR4VnluWC9abUp2b2hDTWc9PSIsInZhbHVlIjoiOTRVU3BCQXVSY3BjVW1ibzE3aXhwQlF5NEl2Z1Z6NmlSdnhTd1NoQ0U1dko0WjVpRW9pL2tvQ2wxUlY4UThabXcwSFJoNnh1OVN2VHFVc285ZEs5bWtmaWxYKzZSbVd4MDBDWVhXbEZ0dFFuRFJNbjBBUkpZaE5pMjQyRmtMQnRzbmpXNG9iRTlwbkt3MGhWNWNjTDJaYWtPZ1p0YTlVb2MvRmFISUdBUGJMTzY5UEtwdWg4WExaaUl2eXM0M2t1YzRoY2Z6d056Y00xaUZIQXZ5b1gySlk5dVBLaGVXYkhxVldOQTh3OVczenBBV3ZTTW1jdGhZRnVzbFhsMFhrRS9EVWNmUm51bjFnanZjUVR2WVc1bEZnMmxGUitWemZrZ2JRbHV6eG9Ba0tKdG4vR1o1VjVnSHN6TnpZYm03dkxickcxdStocFZzYjVVeVhDS2xZdGx6dGlHQzhMV3Z0YVpEQVI4amFROEZJPSIsIm1hYyI6ImFmOTY2YjJlMzM3ODM4YzcxYTUxNmMxZDcyODlhYzRiYmRlNGE0NzBiY2M0MWJlMjdhODVjN2IxMzA1OWVkNWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(580, '642qz4lq21', 'Download Azure', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6InM5UkFFZzNJUURxUjNBSUpFb1QyN2c9PSIsInZhbHVlIjoiUUllaXRZdENVQWxhY0k2L0pqbkxhTDNRN1ljUmtCcUcvVzk0STJwN2lEQzlpZEtOU2ZibWg2d1F6ajdHWlNCZzhMNTdaMmliaU14SXpsN3BjbGpLYlFhQ3FKZTRCSnBLVGp2Y0tJemdrbXdmbEZaYjlPRlR4eW5jUWdqL1RpeHliLzRCN2dpZWU2UWFUeGF3TGtkWktzL2V6TkJqeW96eEpVOVNQS0NHZDZFdTA4YjBXQXVVb1VMODQ5d01pUkZ1aC8yZjcyNlp3NDJ6YkZ5ZmJ6VEtoNUFQaDh2cmh0ZUhzeXU4NE5YUEtHTTB5SE9zSHRhZS9Cc2JFR3lNNlRLS2FDK3FWZzJ5U1htcFFZaTZRU1Q5VXpVMjh0L0R1aGRPb1o2cUpFWFRoMXNhdkdMWjZQSWRPYmp6L0JIUGd6aDBDZFlEVCtVSy9udjdDckNTd21IZkV3PT0iLCJtYWMiOiIyNTlkMDI5YmFmNDg5MDcyYWI3M2IwYTc1MDFmNzU4NGJjM2RlN2Q0NWNiYTcxYjk1NDAxMGU5NTEwYjUyNDJhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SI', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(581, 'y4w4ldky50', 'Spin4Cash', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6Ii9VK29YNlkwdzFOZ3JJUGJLTGJDWGc9PSIsInZhbHVlIjoiazZHTlBWMks1VWpsR0g3QzE0YTFIODJTWUVMZmZXL0g2UG52K09lT1RZc0QveU5Vajl1dXd0NjV0aUYzaGRTczZlbU9jT1dxODR0TnlFSi9HNlNzNnQ1cEtFV21rcUdkc01IemhGUm1lNFY4Y1VpaW04d21KYk40OVg3WE84OGZDNjBIRzRRVzFFdlZuQTUrRHpFQnozSkJSSzNsN2txVEZtVi9PZUJuZHdDMGV4Y3RMalBMT2JuY1hDSkxtMDFQaVl3Y1hlZ044TnNCODRaZGNaOGZ4aGFuUWV6V25Wa1lGUDJyenBZcUpmb1JSc3pueHJBRUh5dXF6YWlOSnZPYVBBVkFjSk1JcGRCSzdJT3V4UE9xOW5rcnFiQ1FrYTc5aEZibGVkWmJHUlN2d3J5L3lkajhWeitlUzZsV3NTYU1RcnpMQ2M2UlIzSGw5VUp1MFM5S2dRPT0iLCJtYWMiOiJhMmM4NWJiMDIxOTQ1ZTEwZjY0MTg1NzFkNjgyODNhOTZhNzNhMmQyZjQyNmJkMDZjZTE4OGQzYjI5YzY3ZjU3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(582, 'kp5nnpzl5m', 'Sampleeye', '', NULL, 0.13, 'https://notik.me/api-redirect?token=eyJpdiI6Ijd3bFVhcGNFWDlNTU5uVTF3UmhLTkE9PSIsInZhbHVlIjoiVGR6cytqeE5rdElJaVczRXpINVlhN1U3ZGtpbk0zSUQyR1IwK1pWZ24yYk5sOGZ6V3lMSHJiK1pkbjNOQTkwOGZuY1NYK3RwL1hmdTNmd2t1azQ1bmROcGVTanhkQU5CckdRU3dURGtVR2tpUzJMb05lbVhrQ01xRDdjWThnRVR6ZzUrNU5NT2EvbzdUT3N6UncycjM0d2ZiMXZSbElxdDA0VkpKTHpZZ1RHZUhXTGtWV25CY3p0T2dtakQ0V2pTajdEcEJhT1VZOHdlejhtaDNrdUVlVklLM2lLYlhESXY2RDZMeThTZ2lMNmlUZWU0VVQxdWJWakVSZFQ4STRqTE9IaVR0U2xwRFo4UEM0OFZxVUdTa3pmUkpUblN2ZVc5UWNsUWhMQzc2cUdNb2dJOTVzcElEYXVxcVVWRTk0WE43K2NMT2NyQlNpMlMyWkVSMTVackpRPT0iLCJtYWMiOiIwMGY2Zjc2N2U2NTc3ZmNhZTVhNjMxMzNhNjBiNjhhN2JhNmFkNmIxMWI1NjhiOTJjYzBhYjg5MmViYzcxMTFlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, AT, AU, BE, BR, CA, CH, CL, CO, CZ, DK, ES, FR, GB, HK, HU, IE, IN, IS, IT, MX, MY, NL, NO, NZ, PH, PL, PT, RU, SA, SE, SL, TH, TR, US, VN', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(583, '6pwjv4ogwn', 'Career Survey', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IjRuQzdreUw2M3VUY0tLL2x4bGhKdEE9PSIsInZhbHVlIjoiaks0NEhnRHd6bFdnN2s0aGpSd1VKRitaR0lzWWNLL2lqRC9GTWp4a3lObEIyTS90UnVoa2JjeDNiY0VTaUZLeXY1Rmg0UlNESTZnMnFYM3pZZlBKN2wrdk1zaHFrVXJJcUw3eG9mSlkzNmdpUzhpaFVYRTFDdFBSTUxYYU5rQVdsNm5ieXBacWZMMXlraWZsUFpFUmJzTlRwV2R4ZDl5ZW9mNUlQeGszQVRFNHRSMGNjNHdiWTdnbXBpaUc0Mm9qN3RXQWgxUllRYmdkaTZtS0dORmNvaUF3NjdNeVNqVzFYNEYxTjZBK2JiVjVQVUNOYlNZK1hQT09VL2NLSFBrRkU3V1F2TERCRG9HWDFPV3Q1Y3d6QXdHWjRhbWVnYzFSamx6aFAyTWNHVUxHdGNVMElCMkpBcllsL2J4UmwrTDI5WGo1bkdQYTVwZks2ejk5RkxwVHJ3PT0iLCJtYWMiOiIxMjRiMjdiNDI4MzE3NGRlOWJiYzEzMWNjMThhMTMwZDVkMzAwZTk0Y2U5M2UyNzU0Zjc2NDczZGQ3ZjIyMjAzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, CA, CH, FI, NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(584, 'xj5gq0m0wm', 'VulkanVegasCasino', '', NULL, 30.38, 'https://notik.me/api-redirect?token=eyJpdiI6IlVra201RHNQUVp1clBGYkZPZHdjT0E9PSIsInZhbHVlIjoiQmhjcHlTVDFMWDJ5bmpyMDJKQ21BT2phSVM1VWxhOFZuckU4NHpOeFJ0T2ZqSzMxZmp1UDRsKyt3aHJ2MWNwdFNiR2UvRUJiUnMxUHlPLzlFRVlrZnFkeG42aVJQcmd2QzUrNWlldHNpMlE2SGkzN21sZ01pamcyTHJNZy9ja3o3a25Jd3Z0SlFrUmIrS1ZJUGhXdmM3UXE1TTFtWnV0VUU3S1V6L0FUbVlneHJYTEdaQWZQcTF5eFZkNE1jNlpPbTFRd0FUVThQSnhQazV6akIvVW9Vb0xsMmM3ZGJCRDF2a25uWmNsdVZ0MGd6UmZJWDBkSFVKWGtJcnI1YWVTWWJSdkhNemhWcnJtM3VHWXZuTGhuckswT2x5RGJ2V0F1dDhER0MvUkcyeFlhVjRtNzlESnJhK0Evd0M0SmtibzVZaHJYZ3lsZ3o3a3QzNXZKcWd2bWhBPT0iLCJtYWMiOiJiNmI1MGZjNjYxZTBiMDVhOWI4YTc2N2FlMDlkNGU2ZjQ1MTMzYWE4MjlmNWUzZTc5Yzg0NmFkMWM3MWU4NGRmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(585, 'j05p376e24', 'Sea Block 1010', '', NULL, 0.68, 'https://notik.me/api-redirect?token=eyJpdiI6InBSa1lXZnVYT1RyTkZJMmNpUzlDMGc9PSIsInZhbHVlIjoiSThkQm83VndWOHRQZTU4TjVwWWg5YkxKTnh4WktkeFZpM05FNmtZMkNKOHplMEVQeEl6RDFBazZkKzJZbTBUQzl4dGliekhBK2ZHNDJBc0ZhUkFKWnoxQ1B3THpPaitiQjMwRVExOVUvd01ZMlc1RGZra0lGRkNXUWZqeWNoTGNZbFhOSTVYak5ibHJXeVY2M1E1a25zdlErUzJlU1JzLy9MU0F6QlhsOU1pZVc3TzlvaUt5eEJZc1BXL1JoRlpKNmZkWm5XdHROeGJoYUVjTUVoZkd4c2xLWUozaTBFQTNDMWlqQTNWU2lPSFJaODZaaFYydklDSy9SYUV3QnhudzU5TC9Ta0Q5ZS9nMkFpdnJiSG1zMnJIU3FoMGd1VHhRMFRsMXRET0F1aDFyUWF6SjhLTnBMZHkvU25UNDczZmhqNER0eGFZL0srandIYVJRU1lONG9BPT0iLCJtYWMiOiJiOWQxNWY5OTU1NGEyMWJhMjVmMTdlMzRiMmFlM2IzZGIzMjQ0ZWUzMjliODk3MDAyZTVhMGM1ZTY5ZjBhNjA0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(586, '3xwvrgp958', 'FreePrints - Photos Delivered', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6IlJTZFhrSnpQTTVrdlQzcGthRnVUbkE9PSIsInZhbHVlIjoiczNGQVRnMjY4N3pPTnozdDRXS1BvU1FSL2UrVmhPQVFORzVjMmQ3SEhrSFlnMlpEaVhZcVBaRFFCYTgySXNqb2h5SW5KSHRzOE1ZZGhDMlp1a09sNTJLa08rcjN2YWprSDVBUUxPeWo0b2JxbWVOR3BoenhscDZyY1FHTDVqekp4T0Yxa2tQL3pUdHV1UmpTYXA5cnhIaXE1cmNWcWtVSW9Id0NCclpwZ0hsV1hPZmEzTGxyVGdhTldtRy9OUGJMVDVnQ0JmdnBwcFI1aWtQbDhhaGd1OTVKVjcyV2FtYnRSUlg5bGZMNUV4K1hLa3Z0YzdGenlkZDNRTG5adTA5emhvbkx5ZTRiQVJjckpoR0ZyeUhBNVQvZUd0Q0s5b0RHcnVNOEE1bkVPK1R6MThtWUVZbnZUT283Y2pqRmRKRlNiVGFRelBaaFZhNnFNZXczODRoZnZ2R0FwYkV2cEdyMVBYTzBveFZNR1VzPSIsIm1hYyI6ImRmN2U4YTZlNDZhOTEyMjRjMjg3YjAyMTViNTgyYmM3NDEwMjBiYmUzMzQxYTA1ZWNhMjBhZTY1NDBlOGVhOGIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(587, 'rx51qjk6w6', 'Oferta del momento: Gasolina', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IjRGaFBxaVlUdVdscmNtU25JbG1LOWc9PSIsInZhbHVlIjoiVTg1emhyVVF2NnRsWCtGdUh1SHBmWllHNGkyYzY2cUgrQkhRM2hPRDR5VnRiRnBiN08rVzA4L2JRRXYzdnFDcmo0cnI3b2NVWjVJaWhCb2FtY1pHSnhwODl5dlI5NkVBeHIxcjY3MFBDZWpSUk0yY2tDb3drWkd4T0RGQXVMODhlMm5xRHAzdzBETzJXTnBvbFFJNUN0QTJqNmhyTFc4ZVc5T1duemtUMmMrMjdtMWFqaFVHQUtHbXltK0cwd21KSUNTNkpBUWlJWUVtWFo2Z3pnblFxWnVpaEU4V25LRjZVNzFKNnNEOEhRK3BHMEdsb1I1MytxU2hUVUdQS0NaU0REbWNhYVZvZFBoTys1cGl4bk5XakUwMnFaYmJOTUhUTFVzTllPTWl3N1R1Zlp3U2RhYTlGOEI1V1YrME5NRlFFQTYzbWQ4QmFKMTB0aVRsRERqa1hON1M4bElrZURyM3lqdi85TzFER1ZnPSIsIm1hYyI6IjMxYzBhMjE5OWJiYzI1OWNiM2VlZGFjMGVmNjM5OTQwYWY2ZDA3ZWNhZjJiNjFlMTQzOGNlMzNiM2NlYjMxZjAiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(588, '8dwkxlp42e', 'Oferta del momento: L\'Oréal Maquillaje', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IlhjNzNVMmRET2YrMU5GN1c1WTNkM1E9PSIsInZhbHVlIjoiallYS21oVlRxelZYb29KL0FKeUM1eWl2RUtwVW1SWDE1SDdBUWQ0bTFuWlpTenJyUGQveWI0TjhrRFNaWFRrT2tBNnRjMmgwcnJQV2JzZXVUajFOMlIyNENNN1VsSGhtZCt2T2VwOVRWQ0RlVjQ5UXdaV2Q2VERKc1ZQcU5pbHdXZVlIc3gyNnlldllKcXVKV2FSVE1kd3RJNjE5NjVXNlZhODF5MVpLcnBpSStZNVFQc1YzdWJyOEZJYUFmWVdzcGU0YjZrcnFRaERSSWNqTFlUY2FLVWFGWEN3ekJqejU1Q1djMGVEZlhhQlBSZ3ZNMk1FT1F3TzZ4TTlCRUFBZXlUdjIvZHZtd1A1cDdnVUpaYnZIbmJ3NlhPMjVscFlVM3B0ZFpMY2JxeTBjOWFhbnRQUTVpRXVieS8wOVdWWTNqOHpOeTdTUmpHeWNILzFFTjJCUWVwZVN6TWVoS0tIUmV0WXQ0MXZRejI4PSIsIm1hYyI6ImY2NzdmYmU1YTk5ZTg1N2M4ZjFjNDI3MjEyMzcwOTJjMjMxNGYyOWRkMTYwNDFlMjNiZTBlNDhjNWFjZjM5NjIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(589, 'k3w7q7yg2o', 'Wild Fish', '', NULL, 7.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjdQWU1rMGQzbnBPMkQrbUJUZFYza3c9PSIsInZhbHVlIjoiTllJRTJ6cyttUlhjN1FMbmVSTFhZSXU0VTZMTmNkSlNiTWFaSTVEUEVuOXNZV1M1Nm5IVjl4UnNmdnUwWnFWSStUcmFMY3pDUkNGWEtJUk9yalZFRllBY21VRzNjanBZZW1nQThDYTRHcDhvNzA4ZTFrVU5kVnlRbFlyS3pJemRRMHNrRUtHa1NJRWFrQmFNTThxRGRZUDdEcHdJWXBiZjBvODRnN2YxWHdFS3ZSVzRVZi94MkhPM1FJcTFBZFpGV2ZvUS9WeGk1WGE1L0pHMWtGaVZORlVMQXBVaHh5dW1VRytRMmVnTVpiRWJxYnQxcVlsOW5ZckMrbCtqWWo0N0M0TlpzODFjMzJWaDJBeDNGYjNpWkxjVUpCazdvcHRkbkI1S2djV2FKUjZOUjZ0eGcrMnc2dWVEYTNnZkE1TGE2QnFzZFpnWjFVNjZpTWJkUXJBQkpRPT0iLCJtYWMiOiJkYWM4YWMzNzQ4MjM2NTM0Yjk5N2U4MzJlMDljZGExY2JhY2E0NzJkOTk4NzM5MTIzNWU0NDBmOGEzZDIyNDFkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE, GB, CA, JP', '[{\"id\":12466,\"name\":\"wf_player_reached_100_linelevel\",\"payout\":0.036},{\"id\":12467,\"name\":\"wf_player_reached_200_linelevel\",\"payout\":0.056},{\"id\":13817,\"name\":\"wf_player_reached_400_linelevel\",\"payout\":0.084},{\"id\":12468,\"name\":\"wf_player_reached_700_linelevel\",\"payout\":0.352},{\"id\":12469,\"name\":\"wf_player_reached_900_linelevel\",\"payout\":0.712},{\"id\":12470,\"name\":\"wf_player_reached_1200_linelevel\",\"payout\":5.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(590, 'kp5nnlv85m', 'AliExpress: интернет-магазин', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6ImxmOFhNNVZKRVhHbG80RUdMUXhjRXc9PSIsInZhbHVlIjoibC9yWi9Ec21UbTZnZ3R0OC9DM0dMUmJXYlJEbWlrQ09mMFRMdE5pbGRVaGdtMEd6RDQ4U2taSG16QkduMXdKQXlSbm1idDRZNnJxVHlUYW1VQWRmN0hYTUVXcVc1Q0lmMkt0YkVjR3YwclpQM1l1c2R5L1hQZ1RjQVloTlVFT0s5YlFpMVgrK1ZraENKS1VUSnh6TFZXRUJ2dkdBTi9lSWRMRnRUb2M2Zk82QVR4RmVEMS93cXUyMzlzREZhc2d4ckRTQ0ZzanZMamdHcmZjWUthZlgrb3c5QWM2T3A5U1RXcHkwL3BadHVObFJmM3VDckdFRUt2WW94b3hGczVObHFmVWlSNWxGMnBraXpxK3ZNTWh1emYrRGw1UngzSFd0TnRMeWpvR2hVL1FLS3dyeDFRNXUwdFNjbE5ZbThoMXI0VlpsRFpDaDd6ZWo2Q0NCUEFlOURyWThVWWhpYjg0aWJHMnpndThhQnZwbStwbFdXQTQxNjRVaTNkZFFkdmpRIiwibWFjIjoiZmMxMTgyN2UzYmVmMjRmNTFmNGFlZWMyNzhmNDAxNDU1MmE5ZGMxYWNmZDVlZmQ0ZWRiMWYxN2Y5Y2IyNDUzMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RU', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(591, 'jy2ro16z2q', 'Lucky Cash Pusher Coin Games', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6IkErMGNGVGU3VEplcGdkL2Q0NEFxSWc9PSIsInZhbHVlIjoiNnJYTEVMM0pIS3ZOVUhCK2drZks4RE1PeDkwVUhaaFFrOUlTR2NoeitvVE85Z05CVTh5a1VORmFKQ24rV2JTd2JxVTJuYTV2VU1hR1N4KzI2T2djYTRFM0x1ckVGZTFtaVljQUtVQzREdzNuWTlTQjRLOFBFSXp4M2JHWDlLcmdLZUNJSWhUMGZkalVkcmVlNGRnb2diNHBKeXZSdlBaMm01Zmgrc3BkVlZ4TFhzQkNXR3NjSnRrZkg3QzRpRlJqc2I5WEZoQStvVDJRSmIvKzZ5Vy9NLzFoYTFDSUhSWVJpOVk5NHhtUFQzWnJzRXJzaGJoeDVzM0xLWkpmV0poNUx4Sml0R2JzU21iMlFGRXlWTjZCS3dBcXNZaGJCYmMrYVp0NytDajFTdnN6Y1lMK25vMm93WHlHYm1yNFhZZFp2ekd0SFoyQk5pYXlTOElnKy9lbEdvQUZZdDFnaktKSmFxdzlreU8reTg4PSIsIm1hYyI6IjRkNDIyN2VmYzM3YzRlNjgyMDRlYzYzOGM5NjdmNGI1ZjU1ZTgxNmE5NmFlZTA4ODBjYTRmMGQ1NmFiMzk0YzUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(592, 'rx51jx7567', 'Daily Survey', '', NULL, 0.24, 'https://notik.me/api-redirect?token=eyJpdiI6ImJPN09Oa201NTNJNHpLVFlxYlZidkE9PSIsInZhbHVlIjoieWxtamJVQTFBUm1WYWlFb0Q5VDJLZlp3WlByVHgrbnhvUVNRemZXZkhNVDhkZWc4R2NKV3VheVoyNnlCckdSWVBIQVBqK0JoaFFmTUkwVnJRTzFFM2taSjRPVUxiamFsd0M4Smh4WmRJbktudlJmbEhhSXh4RXZhcVRVRmk3dlM2WWVUeFU2MjY2dlBGU1dYTjhqQkZwS0JuS0YyYis5Uy8rNDZiaWVvUkNWRGt3VWpZNFVWc0YxSjJBL09JclRVQ3RsMFpxalVWRzZWWit3ZHhOOVBEVEg0ZGZMY2cxQkxlbFlpd1FYNFdaM1RFTU0vTVk4bTJkRlhKK2lqcUlyV0cxa1o5a01KK3dEVWN4NFl1STduMk1XYUVFSG9CMTBEcU1uMXFqZ2NrcFRwWEt2ODlUTlE3KzFJSGtJWk01ZGdmZFV6Y1VxT21XdTVRaEZ0U1pMQUhnPT0iLCJtYWMiOiJlM2Y0YzUwNDIyNWMzNzAzNzhjOTUwMTE5OWY0YTg3NjYyYjRlZjIzYTlhNDYxNWVmOTJhNjQzOWRhNGQzZWU3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AG, AR, AT, BD, BE, BG, BH, BO, BR, BS, CA, CH, CL, CN, CO, CR, CY, CZ, DO, EC', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(593, 'k3w7q6mg2o', 'Ipsos iSay', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6IlBsdlhqclY2R0lQbVkrcnZGRnhZZmc9PSIsInZhbHVlIjoiZE51UVdPb2gzczVOTDB0T3NsbC93bVZXS1FLZTRSdzhVcmFNb1Nvamxoc2NaVXBGV1BWYldoUlBOc2k5bFQ4NzhMb29YMTByNERVdEhWc1c3UTRqV0M1Q3dTK3BIZTU4NHlKazNHcWZxK0xaVzBZWVQyNUo5RjIvY1VXUnh1TWxaclIwZVlra1pyQnVtNVRtZXV4K1dSelJQdHRJV2c2ZGFudVpzTnFtUHM4Q0tzQjNCYzNHRHFsNVU3WXU1cWpoMzQ2TnpTeUJBNjB3KzNESkE2UDhiQUIyQWpsYmZjUEU5TkszNUt4d3lOQVhxV2YrSVNIM0RiZGV1VHFXb0xDRTlET3BNMTFVaHFuL1A0SSt5MEhkaTd6Q2FkQ01tdlY5QWMxRGVSNlNReEJkZ015RVFBM3lDV2QyZ1U0QjZTbDRwNnRuMFJyam4yYno4Tmc2cWtld3FRPT0iLCJtYWMiOiI0OGY2Njc2MjI2YzVhODY5ZDIzODkxYTg0NzlhMzIwYWUyMmE2OWQyNTM4ZmFjNWIyNTY0NDczY2NiYWQ2NjE4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(594, '8dwkx1402e', 'Ipsos iSay', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6Imtsa25naThDZ1NPTG8wL25ITEU4Znc9PSIsInZhbHVlIjoiMXAzMlQ5OHRDTjdjVUMxV3o3ekNHd2tkNFdyc0d6Z1RwTkRrcTFsRUZLK0VubDFvNVNtSHpPbkp1ZllnL1pWalR3YjV4NHNKYzFsUzhrMmZVWlkvSTlBLzVxY01DYUJ3cVB1dHczckQ0OFNWQjgwL21JZ3JoSkEwMjNIaHorbHMxaXk4ZnNQN0F4MWdMcitXNnRXajJicnFBck9naGpYMm43dGY4bHhWY0Fsd0JhNkJaaGptN3dVQytjYW1qNHgwdlgzZ0NQTjBTa1NoSlNGYkFqajExR3laVWR1OW5FanptQVFid2NtNmEwMVpWVFl5N0FFQkx4aWFCNEx3UEo4ZEl5emd4YWN6amtLVzVHR0xMNVNhS1FUMFd0Vjk3L2tuWlg5U1piTGUyVFI2b2YrN2hqQjhjYlZzQTBMUFBsZ1JTaVZtc0xJcjdnQkhkd0wxWUkzV3R3PT0iLCJtYWMiOiJkZTJkZjlmYzRhOWJiZjgyNzA2ZWJhMWUwYjg1MGQ3ZWQyY2NjZWU1ODVmNTdkZDE5MDRkZjkyMTE4ZmFmZWRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(595, '642qz1dn21', 'Cash Prizes Carnival Coin Game', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6Ii9EWE42NVRLaTlubTZJOW1NcDRPVWc9PSIsInZhbHVlIjoidXF1bUlHV0xtUXdOUXU2NWpnNlB3L2NVQlljMGlBM21oZmtHQTdNd2p6cENSY1N0V0hyR1Jhbk5OVUtnbXVmTjFVZWxrSzhzNG1IRnE1cjNJQXFXSlVvZHUzcjhaZ1lrVFRyek1udHpMYmN2OVB1eXJ3bGN3VGdYY0RLN2g2RW1ocnBDTGo3Y0dEclJnVzJ6dEhCaVZjQmNiMlp6U2U3bnczdkRFZ2YvSTlab0x6T0srdFdzT3JuTW03WFhvN09Cb3RseWVxYXkvS2pUWVYvejFYL0krOEJUZEhhRm5KNVRMd0gwVHBTVDdWaTc5djJSTlBja01VMVg1K0R0VktJK0JjalUzclRHZzBudmRNYmFMK0xTSVVpRGM4S0JEUGJoYnp2b1dITG9IWjJ2aXJ3VGs0RnVwcGgrbUV6OUtjSERKZ0dxdXk2U2srWG1ScERUMThZWURxNXRQTDZ2NU5rQ2Rqdk1TTERmT2RBPSIsIm1hYyI6ImExYTcwNzk1YWZiM2VhNzFjZDhhN2M2YjhmYjUxZmJiYTYwYzg1NGQwZGE5MDE5Y2ZkYmVjZDYyNjk1ZWZmOWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(596, 'xr5edz1q2n', 'BeamBurst', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6InVBREN5QnlYY1V2WXJLNXlnWEFHVVE9PSIsInZhbHVlIjoiY200RWhYb1dhV2ptMU5lNllVOW9wbU5nYVE0TUNkVVZITStWQUNBbUE2V2svclNVMW5scmk0anUvL3FhZWU2V21wN2pKR0l1b2NRZnZ1UmRoREZON0o5aEJpdVNweVlSOFZRcm93bkk1SC9zSmFiTE1nK1YrMkVKczFrak54cWZGbFRaNVllR1p2cWRqTTY1SUhHYzY4azV1OXJQamJoZ2lmQkJjZ05BYjRrYzBnelByMnJjMnNCVXprcFI5UktsY1JhSFBQdG9XcHh5dFZhalg4L0NoNVBVMWJuVks2aTdHU1A5d0hLZVZ6M0VMRGg0bG1HSTQ0WFkyenlDR1owR1ZsR3lBRmJCMzdsVDNTTm5abG12ZVhzaWVWOFpBakxxYnpHbnQ0R3RXRjY3V050d3JWUHQrb01rbEFiN1NKaFNYTWlXbXVDUXpYdVMwckR5QXFyNHdBPT0iLCJtYWMiOiJiZWRhN2E4MDk1ZTI3YTUyMTA1ZDlhNTNjMmIwZjE5MTlhZDlhMDMxYjU0NmZjNjIzZTRhYWI4ZGVhZjFlMzBjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(597, 'jy2rodj32q', 'Jow - easy recipes & groceries', '', NULL, 5.60, 'https://notik.me/api-redirect?token=eyJpdiI6Imw2YkcydnRCYkJqbS96MCszY0Myanc9PSIsInZhbHVlIjoiSTNIeml1U01jMHVFK0VCUithdWdTOCtGYnY4dEQydjNxSGdBRW9CRkR1QkdWNEZVakpnWi9oM25SdERUMWZJZWozdURET2FuTS9mMUZDcmZmR1VwY1dBQUUvMWFxbWlCV0dnSkZmY0JYNWJmYldNOHl3Y2phMkZEUXc3SlJiZzZBUC9Ka3d3SVU5UkRHMmx6Y0cvYkJIVFhESHVScEg0NzhDWCtXbjNhMk9MVlZwVDZwWVdGUUQ1YzJ2TE9ib2d5WmVPMHp2Vm9zSnl5L2FWRzVkNmU2RVFWY1ZQNmwya1ltM0IwN1BVNTRyU2ZKdmdWeFZTakhEVWpEOXcwV00rdkl6OHpaSHFabFlWVnMrSHJEWjFHa2xucWd6K2ZWdG5kOWtDV2FQckpDZkM4cWhFby8xRHFiWCs5VHpsWlRoWmFhdlgxQUFReEJXcFBOa2NLb09YeHZrR1lPTk9tR0lhdGxCNmF5R2F3dURNPSIsIm1hYyI6ImQwMzZmNmQwMDFkOWZkZTYyNzY1YTE3ZDYxNWUzN2I3ZGU5OWRjZTJlZjRiYjUxYjRkYTQ3MWNjY2YxZDRhYWUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(598, '3xwvd17w8v', 'Gana con Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6IkxoSzZnd2Z3dWtKTUxnL0xia0pMYmc9PSIsInZhbHVlIjoiS28vSUJ1MjRvcThFclFRbXJ2d2VXUHNPWWs1K0dsK2t2VmRlRGs2ZGlhYTVaVGdxVndIT01XTkNQZDlPYzhDUkFoT3Zwa0lHQTNZRzNjVXBGTE04MHFraThuYWU1TEJnTXVDemhpS3g4VjZEVWZhT1lwZ1hMVS9FbDBnVks2N1JaR0x4ZEp5RlMyZDIrWW50TnRRMlFYd1d2ZFRzOEQvaXZWNGt1Nm91VWJ0VkVkamRJYlNubkpIdmRUVFBpZ3hYeVZPdis5Tk9FTXh1UTFwQ0ZCTEhYbTlmUmNqUWpBb3l4MjNEYTdCUVJMRXRHTDJxTTBZbVlLdHRJSFo3M1FXQjVXQ0pNdm1mQmRrTmRLRVFRVWIxQ3lDNk5zRzROUGZHMStCR0p3WDd3c3U2YzRtSHl5cXhvb2JTOFc2OVh0VHFMSDBUNEkxTWR3emtIVEtuZ3d6K1NnPT0iLCJtYWMiOiIzNTYwZmM4MGVmMDVmM2M5Y2RkNDEwNzAzNjY2ZTYxYjI4YmQ4NjI1OTE5YjcwYjcwYzU4OGFmOWViMmZmMTU5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, CH, CL, CN, FI, IT, MX, NO, PT, SE', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(599, 'vm208gzw7d', 'Gana con Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6InRxT05KNHYzSzhxN2JUaEhEekNic0E9PSIsInZhbHVlIjoiVDZSelJLejdqVEttTi9TdEQ1WldQQnp0MU9BMFNKWVByQzZkK0FlczFxbFAzeVdndGdkeWt4TjR1ODdNb1paY1VOTWk3ckhUcnd2N0tGZTNmdjhURGx4aUVOT1U5dThFUkNMd2ZKaHF0MFlxaFRiMnU2UHhDSHViMkw2Zi9pcldKeUpKb2NwcnAySkUxOFpaS1QxMndub3BvdDB4bU8xMjJydENpOE1NdVJHNjQvUDkyUVpXNzN4bmwwRUVUaHJncVVPeGFDOUJiN0kweWNndmtQUVIxMW83MUk5NWZmK25rZTdrVnZlRm1XN3RJbkcrVThQY2JsMXU4OEFid3VyRE1uMExqNytEUW1vUUNYRXFXM1VXSVZXUE9vaEVRZUd2N1pNSi9TR203c0xBYmE2aEppaDA0MmNhOWFJZGZ2bnRORmpNK0ZVZERrbjNFdk9PQVdkN0dBPT0iLCJtYWMiOiIwNDU5ZGEzYmQ5N2MzYWZhYzg3NzhmOTJhOGZhZDkxNTczMzA0ODlmYTk3MTFlMDU3N2VlY2I4MmE1NWExMWFhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(600, 'jg58krm5rz', 'Gagnez avec Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6IkpmZzZtMnpPZXNBZ3ZseHRXdXF6U0E9PSIsInZhbHVlIjoiTHdPV21wTXcvaG1vdytRTERUeXpjVkl4UndqNEVodlB5OXVwVXV5NWVLK2VNam5nSk5jRnBaeFowcUVlaW9ManRqWWs3T3UwMytINUI2K1dhR0I0dmwxN05uNlN0WndVWENDSmtxZjZPNndNSmUyM1c5VXVuRWVRZ2dhalVCV21KVzY4ZVlSNHU1NlJRM2thSFRnaDR0ZEo0UytSTlk0L1VQTEdPZnpCbmtNTnB6REwwK2FDL2ZZdVNXeUNzOTNzZXM2NTJDOHMwNkRySjdPVEVPSTAxMjZGU2dvdlNqSW9FSVBIZ3ZPeW5QTjN3VkxzNEFveDUxN1Q2WmM1WFRyWmNURG8xaUYrVFN3R2JNYXB2MkVReWd2Q0UrOGs2bU82UE05eWF6UjNYbU90QWFlZi93Z1dWT1ZGeStrdkV0VUppK3QzKzJLNTNIRjAyTjNxQjRBZE1RPT0iLCJtYWMiOiJiY2ZjZjNiNGZhYTYxOTg3OGFlOTcyMmYxNmRiZTMwMTllNDMwZGZmNWUxZTYyNzhiNjI2OThkMjY0MmIwNTM4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(601, '642qg40w1o', 'Earn with Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6Inp5NEkwZHFrRlIwZFpRaFhXWGVnY0E9PSIsInZhbHVlIjoiRk9GRDhVTGs4V3FvSnAvdEtVRUs2SUQxU2VxVkhKWWpvcG83cHVxZ1ZPMTNnWG1CalA4eDQ0YzBSKzRVNTVqeEVoTkhqMVg1cTNqV1ByS1JwQWFiTGc3QWh6bkdXai95bENZd2V4eENwWjZtcGxwVXp3U1p5T3JNN0pSb29xRkE1ZHZJcUhYZGE3cDU2WnNkQ256WlhveGsyY0lWRFp1N2lHRDlENEs1UDc5a1lKaytCL2VRNDFPM1FKV2x4NDFkb296Uy9HY3JYUEFqTDZVeEhEZXNzMmVXd0VuaStOSTRUOGpIN1VBQmEvSGFRNnJIUWZxMGlTVFo5b2RWNDZUZ3AzN0hqOFNSSTFRSmNqUWZSWGZ6YzIvQW5PdGZZV09uV3NnZk05MGxhWnBvcWl2RmJEV0tJMFNzd1ZndUk4M3NrdFI5SE1OY1NxeUgwTzhMMmRaS1F3PT0iLCJtYWMiOiI5YTBhMzM2Mzc2ZjRjMzBkZDU5ZDEzMmM5NWM1YjMwYTk0YjA4MWMwYTQxMzhiMGQxZmRjNzhiY2MzZTA3ZjkyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(602, 'jy2rg4v5qe', 'Earn with Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6ImNzdWw4N0FZbVBNWm1SUFQrWVFLVVE9PSIsInZhbHVlIjoiS0xJaXJLQXRqZmgyaEp4ZUR1NHptNWdIZkxjbHlJZnJVYWtrRUxySFB4dEdKdzhMVWJxRlZTb1E4ZkhNbkNPcHZjbjFSeVJKQVNNTkd4ZTVxeGd3NjNVZjZpR3l2YkNnekZRaUt5RS80cEcyVklCT0ViZUx3YXB6RWluYSs0dThSNzE4cURIQ0RCeldnaEZHUUdTRW54ZGh5SU9ZQTU0cklnZmJKY084U0JCMUtQa1d5M0ZvU3JqNXNSWFRPbDIvZFJqdGhYYkRwQitKTTM2ZkhyY2UzcWU2U2MyVFc3T21oZ3Fnc2R4SzMwTHIxZnZXZWZtMlYxUFpIMGdwSHJkcjI1Q1k1N2xNSVlKQXFJMCtJN3d2M1BCcUE2WlNnOG1aQ0JmL1RZYTVCalh0RXUyZVIxUUlrbklUZ29qRUo1UlZjalhTcU5DRW9rekkyQkNDdEozdWJBPT0iLCJtYWMiOiJlNjdjZWQ5MjYzOWJlOWY3Mzc5ZTA2NTBjZmJjMmI5ODVmODY2MDE1MjMyNmZhNjA0ODNjYWY3Y2QyZDJhMjVlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(603, 'x6w3p4l2o7', 'Earn with Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1iNjFzYU80azdvaXI2M284aVZWM2c9PSIsInZhbHVlIjoiTVJ6WDBVVy9zUUZuUWRlQ2Q2NWwxTnE0SnBQQnltT0dGaXk0QTF4WGtuWWZsSE9RbHphR2tMMmx0VC9udVJnaEZaVUNQa1g2RkRKemRVeXo4NHV2cWkrOFRYV2NWNTYvTEt5djNvMDhacWJ0cGVLZnlaa21uMDRNWXRBS1Y3TGJROFpCZmpGRWFvSmNxc1JPbklKQTFiWWNEcEc5dW5SZ3p5Z01uMFB6L1RPUnpURkoyUDdkUkE1SGFueXVpN2hWTHhlRWFyaFhwQUo2bzVMSlQ0SkRaVy9rbEFtUCtjMnI0QTBXU2dZM3FPS1JqRHBaZWxwdE1yZUhqT0FzSzhCS241ZXNhempFNjVQdzNDdHB2UWt0WUx2LzQwbzI1VFJrZGF0Rkx0YzhvNHhiUmpBUVNQWklkNjlTT1dYUTRNS2NRR21MNXFkZmhiWkJOcVRmZjEvTEVnPT0iLCJtYWMiOiI5MDkzNmY2ZTQ4MjE1ZmEwNjJiYmMxMDJmYzFlY2ZlZWQ3MzhkNjQ2MGI3YzdhMTE5NjQ2ZDYzYTJjNjRkMmJlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(604, 'gq563q95lx', 'Earn with Swagbucks', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjdjTi84ck10bWRCNGxjT0c4L0Z2YVE9PSIsInZhbHVlIjoiSzRxcTBQeUJFVzJnaWc0SEtkSmtHS1VoRndBbENCS1oydGpsUnVvZnZVUXd6cGJmNTg0ZHNxcThWcmJLZmxZMkxSeUx6eDkyeTMyblhNcndES0N6UUJoU21tTWxtZmxsb1Y4SGd4bHo2MFlndHdzMmViL2R3bXpGR3JyMlpwNnNxK1VvMnZQWjZzYUczTzFlK2VVcUl1eG5CZ2UzOExlNjdCVG1OUU1UME9FM0d1Zm1pYVBhRXlZNzgweWhTbHZSUmZSQS8xWjY1SkhkOXJMQTFTYXdHK01LRVppcXA0cWpBTXA4c1dVUEI5SmlwbTBtdndBMzlUWGUwRk5SbUwxTTd5aWY1ZXlpVUVMc2wvVUY2MXpzT1MyVTJuN1ZRTnVnUXJlR1piUVJTWFJsMndON2d4c0JKMlE2UkRNMWFUMVlOZldzaDg2cjBZUWxaRjhFbmx2VUxBPT0iLCJtYWMiOiI5MDU5MTQxZWY3NmViNjAzYjQwOGRlOTI4YWMzMWE1MmIxMDU5MGFlZTAzNzhkZDkwMjQ3OThlNzI1NDE0MjIzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(605, 'qx29jvg5y9', 'Earn with Swagbucks', '', NULL, 6.00, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9mbUNpR3hOSkVMWkFmYWtqY1BncXc9PSIsInZhbHVlIjoicERHUWhGOUQvWE0rOHg5TnFsa3NkNDBlcnhwM21KTlRCaUlQVWFEQmM5SjNnSXRkVkpBWktQODhoamk1eVZ5TTVrZld4d0s5T2ZVNDh5RkJuT3pTTW9uMmxyUk53U1JQR1dXNUNEVmdENnlUMTJpUGhzWlo2R3JqM2VyOEFqSTM0eEs5RTZpMS9vWFRjTXVQcXkwNFlMR0ZwbmF1V3h4eUFYVkxmR1dLQ2h5dlZRemZiQUdjdlp3NTFHTysxQkt2SlNCWGk5aWZ3dUE5UmFMUGY4a0VZNysxK3JUUExwRXo5c3hMUUY2a2tqaUttM2tvc3VhZVdIRUNDYXk5NnYyME5hUjdkY1RGT3Z3Q2RaQ05VT1laZlp6cHF3bVRzdFNmV3JjNWdid0gvVk91blk1cG9kcTFXcTNWME50VFdWRGd2TkJhSU13dmw0RndrMXRiMnI2U3JBPT0iLCJtYWMiOiI1M2YyODQzZTA0MWE2YjNiY2MyNzJjMThmZjQ3YmU1MDFmYTJiOGM4MTdiODAxOTI0Y2YyNmI3ZTIwYTI1NDFhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(606, 'xr5elr3wn8', 'Earn with MyPoints', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjFWWm9TdGcrbVlrR1NEQXphY0s4OWc9PSIsInZhbHVlIjoiaG9JeEhDemV2SXNRQnJBKy9JZmt1eUIrT2ZVYmNrZXJkVFYybG9tVGh6MXIydVdLaFpPM0gvRXh0b0x0SVhWZWJQb1BLcmVRaWVQWFZoMStJNEZVMzRTVGlhQWEyWnNMZXFIWDJac0dsT1plaVloMzFRYytCb0FzNm14Nm1nbHhheHBzWm9UWmJXVGN5NFh0cWc2Y0NWRVRZbE1QcktJUnEwVXZhR1lQT0VoUE5DdERvQXJ3ZkNEZ1dQcU9IMGJIWDJIZWRYZ3dTOE9hUzlNMldxMHNPREFGWDdQZEg3UXFia0p4YzA0RHdLUDVFTHduTCt6QkVxMXZlZ29acEQvUmVCblZUU0hWOEd2QVo0YjhEOWVySU5wWjJSMFoxMG5ndEI4bnpqVDM1bWFLbGQ4ZS9nNXFPa0hXMG1DcWRRZGZsbkNUUmd4bGE5S041YkpMaWhHNXVBPT0iLCJtYWMiOiI0NjRmNGQ5OGMyZWM1Mjg5NzM1M2FhYjQ0MGUxZjI0YTM4ZWJhMDlmN2M3MjBmOTNmMzZmNGZmMjM1MzA4MTcxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(607, 'qx29099g2y', 'Spot the Donut 24', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlBkQ2cyT1FFTnNtMzhGMGQyTzdZTXc9PSIsInZhbHVlIjoiR2NoUkRvQzd0Z1B5bmxjTzYyazE1RXhqMnVWaGYzOUNrMmx6ZDRKMi9RTC9mbnZERWdheGVCY0x4TkNtYzIzU2xOV2VrRXpJakhPU0hWNEg2TlJ6WHBESWllekZkS05JWjdCeHZ0UVVXSFA2MTlBU0lhTk5iN0R1RDVFV2xLYVc1Unp6anJCUHNwbElQZE9JRWNBRW5aQlRyQ3ZzUUVPa2J0NVJQSEFkMkRkd05XcDNBVkliTHdtcTVvQkxBY24rNGZ5bG5vNGZ2dWljUElaeVlyRDF1Sk5WS2JPcU0wRnlMZy9vWm16b1FucGNPZG93QjRXblNJVTJjMmo2ZVFyWXIzQnlSMDVyZEhudUJOUmYrZ205b205SWpiVWd0c1FFUEpkbmp4aEFNTGR1Z1NoQWJwdHp2NjNxOXZGOTRzbWFxZ1g0UlhQQW5MM3VGeGNlOEdLRWt3PT0iLCJtYWMiOiJkYTA3OWZhNGFiOTRmNWFmZDRlMDQ5OGYyNDAwMDgwYzMxNzAzYTQ1Njg2NzEyMzQ2ZGNjYTE3MmE5ZjU1YTY4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, PT', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(608, 'xr5edmm32n', 'Quick Video Quiz 24', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImxiRzJXYzhCNmtWWTlzMkxUNGNtNEE9PSIsInZhbHVlIjoiVGlLUG1UTXNuY05RcVFiUWMzUE15Z21OM2ZMOFUvUXFocGdBd0ZqQkZ6b2V3QnBBdkEyak80OWh0S3hIQjNBMnRJRXFtaUJFTjVPd1ZvSit3Wmk3UlFYQnR2a3BGS0NHTmhkTU5oLzNlL0xYSmxnSGlCRlZqdXdmZmdFVGtvWjBOV0x2MW4yejYrbGc0cmxVYlVXa2RnOUxWKzdhZ3NoZTlQcjg1dm5acVNmczk0VmVYTlJHVzUzSFRubGlxa3Q0Z0pQWno2VExueXlPTmdkWEJseUxUTG5FcnlhalM2RC8vcy9NWDVieGJOdjRTVXVTK2YxV3pabVVNaEwrblY3dlQ0QURzTlIydWF1WGFIOXBtR1BadHg4UER3UkY4eU1kS21OVVl4cERGUGNTMFFRSXlVYkhsS3l3UjBZWDhicFlnMUR6SlptT1VCdzVaNlg1dmNWVWxBPT0iLCJtYWMiOiI4MGY4YWI5OTRkYzYyMjY4MWI3YzEwNTY1OGUzNWZjZWFjYzQyNjRlZjNhNTViYTMwNzQxMzMwZGJlZjhiZmUwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, AU, CA, CH, DE, DK, ES, FI, FR, IE, IT, LU, NO, NZ, SA, SE, SG, US', '[]', 'desktop', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(609, 'oq5zenr15v', 'Uber Eats: Food Delivery', '', NULL, 4.70, 'https://notik.me/api-redirect?token=eyJpdiI6InE4NGJTREg0YllLdVV0M3lhc1p0c3c9PSIsInZhbHVlIjoicW1iMmkxOFFQUEFNZkhWUzRDZzNRb2RsTnlXaUpYQ1JkZTkyazZUcUQ2QUVOb0puYU13RGRSRHBqQmZmWTFuaFBkK0xxSGxwbEVjTm1Wa21sRmVTTmJmNG05Q1JIZlduYzQ3VDlPMGVPVUxGdnhCYkdwRityb0g1eERDZ0hwMHNsSTdrMXFqTjc3bEcyRlFQOG13YjFKTDdJOUhORGt2ZlhyM3R1d1liaEQ5SzQxQURGSDMzbGpydGYzMVB4SGJaejNxbHFjNVFwblF1cHZtUmVlcUhtUThNUGFoWnpBQ3UvVmo0TnVDWTdKM0NLV1daQkZ0cHloT2x0R2lRakhQSVNFUkIwOFNkSlh2dUpGL1h6ZWZCK2ZQQVhOQjIyUjYrc3JqVk5ETFplVjZhY0xEQVdqRHpJcTNVSkRCQUZmcS8xNHFVOGRaVzJNMFJ3bWlpSjZrR2ZBPT0iLCJtYWMiOiI2NDYyMjg3ZmM5ODhmOWM1ZDhjM2Y0OTcwNzQzNGI0MmNkODBlNDk0YjA0MDk2NmI0YTIxY2QxMWY5ODFlOWE0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(610, '8dwkxqrq2e', 'SHEIN-Shopping Online', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IldZOEQ0WjcvRGQ0dng2STlEM1QvR2c9PSIsInZhbHVlIjoiUnpUaGhQYWllMUNYU1R0dWJWSzhZaEpGMzV2RDBXYkVSZ3BtMStldlMvOXhOT0h1Q3l1UG9NNGFsYjlySXFxT1BrUUI1V21ucmhVbUwyQkJ5WnhmRE5IR2hsY2hCVDNnYmppUWd2ZUhtNjU3ZXViSDc5Mzc1eUV3S3VDekVmUnpvR2UySUQvSWl0TlhWWnIyZVBGazluSlp6THExUXp0cXg0alhrTmN1ZUxWOTM3bVNrSlR4MDRxVG1KdHBrNThPSE42djZwOElXQ0VraCtiVUtrUlRDRzF3OHJzVTAvallCU3pxaFVCQytWVnlkdnZKbVJSSzZJbnZPbGl4c1ZHUFdtTnVLRUFSeWIrY3A3N1FTbkIxNnRtbzFBY0hZM1pRamJjeG9PSm1LL2JiSjVvWm9hRVRnUk12NG50b3lHS3R4UFZMM1l0VXI0bHoxU29MSnM5SWNBPT0iLCJtYWMiOiJhZmQyZGYxOWNmNWMwNWVjM2JhZThlMDEwOWI3ODVjNzQyODg2ODQ3NjI2ZGU1OGEwMTJjZDkwYWM3OTRkYTQxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:08'),
(611, 'k3w7q3jn2o', 'AppStation: Games & Rewards', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6Ijl4YXBYSWxVQ2ZpMjJDdStrLzNTTFE9PSIsInZhbHVlIjoidGhIaXJ6OXJMbURMY1dVaXgxbjdOUktNUElFQ0JHbVc2YmpTeGxJUFVEUjNqejRwM2VEQkdvUWRDSXhuYSt1VFhjQm1aZmNybmdiMEkyNUFxbkxFQUYrOTRtY3UwNFYzak9nend4aXZwRVJZNkFPUFZDd1J3MUJaZU1WZk1oOGJjMWVLc0x6U2RsWitFdlJLT0w2MEpOVm1vbVNld2hiclZRU09PNzJmU0toamloV3FqTzJDNXgxVjRBZU9kUmdXOFRlSTBiZzNJWXU3RWZSamk1NWxPT01hZTcweDBDMGtROFZteDhMK0x3Z2g1eUtDY0ZuWkFJRkZ5OTVjaVdQOVFQTlE2dGJOVlZwNTdFbTlVSExadTllWW9zNXhCU29nUnJDVEFqSUpYMzdnY293SHl5S0NSenN5VWhpZVlxRUI3UyszVjBPNk1KODNIcmRUK0FQU3l2SXgxTmszc0p0cTZML0lLYlFSc3ZNPSIsIm1hYyI6IjliMjRlMWI4OGI5YjMwOGQ2ZGUwOTc2ZTNiNmNkY2JhN2JjZWY0MzFjMjlkMjlkMmFiZWRhMjkzZjljYTA1OGYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(612, '6k2yyn3m2z', 'Naya Download', '', NULL, 4.88, 'https://notik.me/api-redirect?token=eyJpdiI6IkU5U05KQ1JWWXNKN2VZS0F1c3FtNkE9PSIsInZhbHVlIjoia05WK1J0NWYxNTQ2MHBWUUpXQlByek1MSWo0S1lRZjlwOEtZOTFuNWdURVVyZGM3emVRUE5zY1BUMmwveG9TTURqNGdZQ2l2YlkrMGsrMEk1WmorWnE5WVNZTUZibi85SG9aeUNnNmFZR01FZzdHVS9vR1VLTlA4STZjSzdiZnVvSEdIWDZVL2tQQjdqbnFhQlM2aW5ueGtWMngzbmtFL1dMeWNPVFppdWhSS0ZFM2pBTW02UWRYVy9XQkZVU1FVQ1JVTXdSZzU3V2lzNmsxMjdwbnkxY0pQV2F6WTJOdFpkMTJxSXJ2cjQ1dm01WVRRZkpYOWpLaUQxdmVJNGNSMmxRb1ZtVjV5MmxueUl4ZklFYkhsbFo4Z2p3cnBxYUZpNDdGM3RwNUN6OC96MG5JdytIMFpNcUJ5U1pCSVM2Tlcra0tpdnZMcWRCellzUFhlVm9Sc0pRPT0iLCJtYWMiOiJjOGY1YjZlZmEzOTcxODljMzdjMDg3MGNkNGY3ODg4NTFjOGIxMTkyODRlNTg3OTk3YTkxY2NkZGQ1MmFhYzgwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(613, 'zm2d319dwq', 'Ipsos iSay', '', NULL, 2.38, 'https://notik.me/api-redirect?token=eyJpdiI6Imt3UUR5RE92SlM1TEZYZlFjZDg0MFE9PSIsInZhbHVlIjoiZ04weTZKR21vVlpldnowbjJXTjM4OUpleFA4TVNsbCt3QVZEa0FPRCs3aHl6dlJTaExTbm5ESWEyRGw1ek5Mbko5MEtsUFBMOVJaT2FQakVUTm9TYzJmWDJBQkdzU3hVaTJaV2NSeGMzd3VmaVE1clJZaDRleUpNaFduM0l6azRMYlhCRzI2S3ZSN0tGSTdHWnpPUGNZcnZUdVVoUm95L2VoN2d2ZGRna2owQTE5SFh5Vi9WWlJxM3dwVzFOL1dGNHZIdXZMQkcvcUJwNGVSZjJiTEc1enJ0TzNZV2VFbjBNOUoyUlJEYW42WHhIMDZCSnI0SGw2aDR1SHM1a2ZhdW1XQ0srZStZK04wd1JKSGEyYmVQdVdDbktvSXY2UjRDWXZSK0lWL0JRVmRRdlNmU0xZZ2JLMG9TMXJJQnUvWXZ4RmxVRHB4aVk4SGxDSExvZGpQN3d3PT0iLCJtYWMiOiJjNDg1Mzk0ZTUyZDU0NDk1YTdkNzUyOTYxYTk0ZTI5ZDNiOTA4ZjA5ZDkxZDE5ZjQ4NTQyMjljMDdiZDU2OTMwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(614, 'zm2d31y1wq', 'Ipsos iSay', '', NULL, 1.68, 'https://notik.me/api-redirect?token=eyJpdiI6IkdCcjJYMVJiamNGYiswTnRJOEdIYkE9PSIsInZhbHVlIjoiM2NaTTdqSVdiYnFWMnFOamRnaHJNNE9XNGxuV1FLSjlEencvdHkvOVVZY1AwTFMrb0E0VFFueFgwbWxVaW9YZS9kV0lZejdVdk0rY1k1V24rcWQxTy91MXlHVGVKOWZIMGdNY0FxQ2JTRTFtMzl3aVo1Wm54eVIvdGNPeHVaVUZyOTdLWEtpSHd3bFNxSkU5aUZ0MURnVlRVdHlNUmcrZXViZzlWZFRrS0psTmVzMklrNm9PMzVKVlNuK1BwOEExWjMwSis2R3dTKzFzdTgvcUV5R2FxcWluSml3QlNsUUp1ZFpiSVc5OWE4MTB1WnFQeUVIZlIraU1jcEZSVnVycmVNZFJkMDZaZmNlQUxiLzEyeTVFQ1BUaWcyZDZpbGhWYWFHK1BUZmlpamhIQWpRY1FZSEkzQ2F1V09qKzE3d2dxOGtKTWJwNTZZWG9YZFhTaGFvNG1RPT0iLCJtYWMiOiJkYjc5MTgzM2EwMGMyZGY4YzU5YTQ0MmY4OTI4ZDBiZmU0YzliMmY3YzM2YTk3NzZkOTM5YmFlMmEwZmZmOGNhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(615, 'vywxeprm5q', 'Ipsos iSay', '', NULL, 1.68, 'https://notik.me/api-redirect?token=eyJpdiI6IjBQZ1hNRzhobnZZTTFQb2ZEQUh5OGc9PSIsInZhbHVlIjoiWXVkVlVGTG1OVzhkYXBaSG9wd1A3MU13Ry95UEVybzlsU3ZIb1dUeVVWdDlvdXYrMHhYT1dmMS8wY3gxZjVpbXk3L3JoWGZoVDRDK25DVldZWFU3VU1yLzh3TXoySTQxUTAzR0NQZ0d3NTFiaGt6dGVwVnpDMUpyRUU5bjNmUWcwOUNpMllUWXJhNi8veUxQb0lLd1Vqd29zdmQ4NnoxaXhFR1FmdmkrRHpqUnNORVB5OFlvK1duRGRvYmJpaGFTeUR3OHhEcVBRSlJkZGJRWThNY29vQjc4eG9JTTdQdW44aCtxaWF0QmlnSnlQeE1Nb05Rdno1bUZJWFJUbm1rcXJOMFJLSzhmdVNJTkpjTEZPeDdGbXlXc1dQQTJkZU13RWJteW1razJHNXkyUUZlYm1aV0N6bUhvanJDenpTY3dFeFZuZFQzcExIZytML1dtY2F3VGt3PT0iLCJtYWMiOiIxOGY2YzA1Mzc1YjQ0OGYzNWVlOGYyY2Q2MDQzYTM0OGZjNDMxYzcyMDc3YTNmNjVjMDc4NzQ2ZjJiMWY3YmVmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(616, 'vm20rp4g27', 'Ipsos iSay', '', NULL, 2.38, 'https://notik.me/api-redirect?token=eyJpdiI6Inh6VEpxeGNlVmc5Z1kwNE1YV1dEdHc9PSIsInZhbHVlIjoiL3Q0WE9iNTdqV3diWlQ1RjVXL2F2Ri9zOWRmNTJqSlAxeW9vYzB6WjJhalVFV2Y1c09qRDI0ajZlQndVREpIb3ZQTElnd01RNVJIYm1hbThkRlZnc2tsTEZIbFpETm5icCtuZjNuaWw0ZjgxZGJ5eHJQbGRCMWVNMWFBVlV5T0prYktOMDNYOWUwSkd6RVJZY0ZBM2UyUXNHeVRyS1BIeFNKSGdMdkI4REY2Ujlza1Q2SjNDdGpzdjR6WDFIcDFiN1AxbXRJMUh3dlVVUmdpUUFCaHljWnhFb0hCc250VC9zb01UNVM0TTI5QTRZNlFlRExvak56NFBSdUNMVW14WW1UT0hvQWptNXdPQjBoaHBnNU1ka2xKd2pnYnhHUTBNZ2QvYVFHaklWS0JidG9LRDdnZGp3TU14M25RSVVXNTVlRFZvN25nMlErT1NLTCtWdnNxS0hRPT0iLCJtYWMiOiI2ZmZkYzhiY2MzYjM5MDExNjNmZGExMDc5OWFhNTEyN2Q0MDMyMDExMDBmODYzZDFlNTdkMGNmZGMwZGFiOTc5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(617, 'jg58m1v02r', 'Ipsos iSay', '', NULL, 2.38, 'https://notik.me/api-redirect?token=eyJpdiI6ImVLRkRmT2RqOEJ4alBTWkNDM3EweWc9PSIsInZhbHVlIjoiNFZjL3l6alptTzFXeUJDQnRGMTJqVXVwb0d3Y3U0RGFueXFkMFM2aWtVQUNKdXRZUTB2TWsrQ1FjZjlvVVZkcS96bDVlbkVZa1ZYbERVMkZuY09UR0dXblE4cFZER1BUanRDeThRZ1lFVC9GQmxpK2dCTHdPVU5nSHJpZEU5Qk9Ma2JhSGlQQzZYYUcyUUNKckNBN1R4QkJGbmxQaG1VWkJjVy93cUplbFdscGFtaTNXRSsrS1dtaXUzQXZPdE0zdkk4Tzlra0hsSktNN3dkQUc1VG1LMTJxcldtaEtrdUdtZXI5MWM5akRSZk41Q0c4NGJkR3ZhY1FJTUpnV1RFMDdBOWNnNlVleGIzWHc4dVEwWHNFWmxHcGlIcC9CRGhEVzJ5dktsSW9nNHRwUlNOY09QaFBpa1NmOGNCc3ppbmJLY2FmTDQvOU1zTmZpcGx3aHRnSnFRPT0iLCJtYWMiOiI1MGRkNjFkOWYwOTJjNmIyMzA4MTc3NTAzMzA5MmI4ZGIzM2MzNjUyNzE0OTUzYmE4ZWU1M2RkYWRkNjc0YmUwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(618, '642qz8eg21', 'Ipsos iSay', '', NULL, 1.75, 'https://notik.me/api-redirect?token=eyJpdiI6IkJBcGpCQzhPdmtuMW4veVlLSnd5V3c9PSIsInZhbHVlIjoiVHhnSllNemFFbG5TcDZiZ1UzeTFpUmFJc2tuM3RxTnJEYVJxUVMxRFZUSVl3SFBtMU1xQlN0NjZIaFBrSnNZTWxBR3VWWmRZY3RtS2RjQ05nRzFxS1NCMGZJditFdlpUR24wTVhiVHRXbkVNbk0zQlVyZGlLVlZDbHZqaGgvanQ0QXVmSXlVeXJmRlphVStCK1ZreGNPMGJsaDQrYUNDTTErNTRJMjcrZlFDTWtGV2RlMDJZTVptUVpxSXZKZUMza2R0Lys0SjdhOTlZNDNoNlpLSHIzTmRlYmFQeU5lWG9NTTZmWWxnRjh6cmd2ZDM5dUQrdzhBc1ZvUXF1NjdqUGJrM2NLWVJaaTdQZS9YM1JSVHBDQWRNNkIwU3ZwTTQrZEthL21xWUZMamgzeXZVVWVUSFdmMlprS21jT1dub0R3NEVUd1FUNzhPQU9XRzJvWEFVUHZ3PT0iLCJtYWMiOiI1MGJjMzFiNTFhZWNjODlhYjA5NzZkMTE5MzRjZmUzOGRmYmRiMjVlOTRhNjdmMmQ0YzFkN2IzYmUwYjcwYWRkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(619, 'gq56r18r5l', 'Ipsos iSay', '', NULL, 1.75, 'https://notik.me/api-redirect?token=eyJpdiI6InU2MWNmTSt1dGYvd2YzTzhIYS82WHc9PSIsInZhbHVlIjoibytFMUxqQXBId1NOWVl1TTdzTStxbm85Vjl2TmRKVUZyYnZuSzZyRDR0N2o3YllvallDcjNSR2FVTnI2d0hLb3pHSGJreHBJUTdMeVhtSUJ3M2lLQmhnMndLS2czYzNTdmN2OUlzZjFTai9oTFdsdFNXd1gvR3lqbzBpK1RBN0hPVUhyT3NwWUJrbkNMcVg4enBHbzVNR1RRMDN5WFNNdTVreUxaVVpLbXRRUUNvNE5YQy9kaXpNT0xMVERZWDdWYkhWc1VlMC9sT0JvRGtLOVRsUEZMOWpHdHpvQU14QlJRcUJIUlAwWTFFNlVudndiN1VUd1pzNTRiSldTbWs0NGRtTGlJRU53N2Y1T1BvZUdhZndSSEZIcFhLVXFSYWZPZVd5QkRnNUcyVGx0SkI1U3hqL0pZei9UVmVaNVZZUHNrTnVaTWZUL05LK2FFUmxlVVhSK0tBPT0iLCJtYWMiOiJhMGE2ODY1ODk1MjNhOGY5ODBlZmUzOGU2ZDg0YjNhZmU5ODE3OGM2YzY0YTFmNTY4MjQyZjg3MTcwYmU3NjcwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09');
INSERT INTO `offers` VALUES
(620, 'xr5ed4kv2n', 'Ipsos iSay', '', NULL, 2.38, 'https://notik.me/api-redirect?token=eyJpdiI6InJHVVkwMVo4dzZlUXo3d1FHa01WdXc9PSIsInZhbHVlIjoiVHNQUzFOMDFHcXZPbkZOOW9hWnFjZlRsbjE0ZTB3MkJ1OFNHd21ETmJuVVlDZERjSGFqWjFiSDhQVjBlTjAzdGVzUWtQZ0tldTVLT3NuUGxUOCtCSkNDamZLVmhneGFYaE81bFc3TkhHdWVkcFBoalJzOUo0enNzTk1BL2ppNkg3U3A1L0I4c0NuQXBzWXNwdE1idmpjdmQrSWk2ZkFBYmxYWFdUVW5hUHJSQXh1TksrYktjUElFSzFtK2ZEM1JQQmlvQi9IaHYwNGd1T2wrck00N2l3UFFPd1BCQjRvY096TllhVFN0NjRibkdHbDNISG5aVFJ1bzhjNUVITklKNDRMUGErWkI3b09ncXVOeHJqMkl6b1hLQmIyZk40R0RJWWVhYU9nbThTMDc1cGI1bTEydGdsY2M4MUVnclY0MDBSQnQ1eGVtaGxoS3I3cnYwYitQcjlnPT0iLCJtYWMiOiJiZGFjZWE4NjIyN2NlM2I5N2VkYmFlZjc0MmUzYzJkZjQ5ZjdkNzUwZWYzZmM0MTFlMTRjZjk5ZGUwNTg3N2MzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:53', '2025-02-26 13:11:09'),
(621, 'vz5ld4v0wp', 'Content Temur', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6IitkazlBSk5BRnR5RFVhUFpwaE16U2c9PSIsInZhbHVlIjoieStmSGRwYmFmMWtjeWh2WnhPc0pLbXpJUS9zbXoxdGFHYnVueFo3a250R1djUHkvdFBHV0dKZ2g4aVZ0K3F5QnNWM0MzME5SWFVLaEc1Q1QzYTdkanFuT2VFY0xIbXVXQXI0M00zRUk3TTRTSktwRUZRWlQvLzVmTDV3QmU3bWxwbjFSeUx6SE0xNjZSMEZ4NG1KTUpCcHdQMC93OUFCc1lCUFpaaFdlcFlWbGg3SHdma0pCMExEcnRLVUN1RzZkR1dnWDBNRHNZNGJxWHJXWHpUZ0NrWjRBaXRGUlNRNkZOM1BUS0x1QW1GRHJpZk1GMjNIWE8xcmdoTzA2SXE4UWUvZURtZjYrV2pRZTFsU1FJN0RiblJ3N3FLdmZadFNNUVIvemhHRWxYang2YmZvV0trbkErcWdHZmFUamZ3Q1I0Q3ZPR2hPZWxtQW8rbDczTUswbFpBPT0iLCJtYWMiOiI1MzNiYzQ2MDY2MDhlNjEwNDQ5OTNlMzQ5MjMxNGMwYTNjMDZmN2ZmODZkMGQwZmE1Y2YzOGMzODgyM2U0ZmZhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(622, 'k3w7q3g42o', 'Content Red', '', NULL, 0.22, 'https://notik.me/api-redirect?token=eyJpdiI6IkhOSE44YkgxTlBxcHk3QUppeFA1ZUE9PSIsInZhbHVlIjoiUGRaVkNjYXJubjdBWVRBaGdKTElEWW8xV2NnTU41enFFNnA3YkliVVNzWE15YjhqMDErdVk2TUE4V1BIdStKSlVISGlGbmdYeVFkVFZGbGpxODJ0bzhWdmZpSjFMaUxvWWowNUZDYTlaU2JCdHRuU1VpTXUwUUlvNzI1MkNOWVptVUZrY0NMNk5pazlJZVcxNmJpTDJna2ErbDl0bEIrMlk0cERETy9iaTJkamhJZHBOMlJQY3dHRklxNkdDL2V0eUVwRDJkSmQxUDMvbVB3QkdvZ0FvSUF2WU83R1ZacnorVERRSWliVjJrTFRqRWhWQXFpcFZwY2RXVy9LM1JwMzVXVVFucUlWWEEvblIxV252WWR6SmRFRGFOL1RNLzFrZ0RLQWhlU09Nc25jQXRyOTRRMENnclRFMlFDYzhPdlRXcG5GeEZJQ1Y2cmFkTlkrelc4Nm5nPT0iLCJtYWMiOiJlOGU1MWRlZjk5ZThiNGNkZDQxNTg4ZDJjNGZhN2YwNDM3ZjYwYThkYTVhNzkwZDhmODhhMmQ5MWU1MDA3OGY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SA', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(623, '8dwkx70j2e', 'Content Temur', '', NULL, 0.17, 'https://notik.me/api-redirect?token=eyJpdiI6Ijg0QkxiR3lMYlJlUHlhQ2I4aTBuOVE9PSIsInZhbHVlIjoiM0NZd0xoZGlvbE9FMlczVFhYTTVDYkJoSVRaYnBneDNWM0laZHg5MmhjaGhQNkJnTFpIanhMdjI3cXdWdGJmdzBqamlxcE1UWm9OK1NNTk05TG5uaXpydnNaQVlTZkVXcTIxUFBlbTdvQWZLUlhpQXloZWN1TzBRMzBXY0VHY1FTQXBia2JFNXdrdFhyeDhtZy96blc0ckNnVlNSTFN3aUZPQnh3YTBMNTRScWs1TVlaNElUSXRLWHB6OUx2V1E4NDNOY1dMajZLS3BuMlVHYk0vZCtGK3VJbWxrMFFNTHJpcHZrUkhrbms4WmI2ZEZEVkJzblF4YkwrK1NrNGVTLzVGYlVESnU0aWJJd0hlLzZEYzdyeXVpMkN2WEtMN1dzOStrdzhuNm12QmZ0SGYzaDF0YS9IV25WcWVwSHY4R0tKZzJrZk02VzFtd3ErcGsxNzJZZmZnPT0iLCJtYWMiOiI4ODZlODZlZDExOWMxNzFmODQyNjg3YmQzYjM2YWY4M2E2OGVlOWQwYzhhY2EyNmM3MzkzNDAzNjQ3YWQzYzIyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'VN', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(624, 'jy2rx972qe', 'Audible', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6IjRvQjlYRmNLMWRlbWRLUS93dkkwUnc9PSIsInZhbHVlIjoiWGF4eWxyaDh1b2F3eWJNRHJjWmRJSFlxeDRlNDdkQU40a1RFSlFTdnZBd3FuU0RoNVk4alhpTGJRd2ZIaWlnMmRoaS80TzMwcVhQNlYwcSsvZENpeTlnOFk0WDEvRFJ5a3l5VENBTDhzM3UyeXFCN0orRzRSVk1JSkFiZ1RxRXFvdzhnRHV6NCs1WTRLeEY3UVVOV1F6c3RVSXBrWHZ6L0Vrc09iM1FDamM3UVdxS2ZTcGtDNTNseFdWcnVHK0hIVFpjZ2hWWDB1M1ZjNFpNV2xDWmkvWmxPTW5kZ1V1RW5KZWFKcXhkU3c1MXFKbVZDRjhhMW5KWFhvYWl2LzNPbm9ZZkRSNzdjZmo4cWNmeXNKSmZqTGJOd2xrd0xzMXdxWEU4Y01kZE1CbDBmZXlRVHYzWmZwQ3h3RE5NZ25LWXEiLCJtYWMiOiIwZjUyYWNmM2I2NzdkNTM0YWYxZDQ3NTMyMDBmODBhNTYzZjA2ZmEyYzNhYWM4NjNhM2Y4MDUzYzI5ZjBlNThjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(625, 'xr5expvwn8', 'Fiverr Marketplace', '', NULL, 1.75, 'https://notik.me/api-redirect?token=eyJpdiI6IjlYbVJQNE9NRTRKL3U1d1JlQUVNVkE9PSIsInZhbHVlIjoiRmZRMDNyOU9LQ0ZGMEtmUEpNaDhDUzYreW1mdS9pcTh4Y2JhdExrdHdsbWFKdHQybTMzNE1ydk1ud0RwcDZINkZ0R2F5VU1XQUhQNFI4aFBqaTk0bGRxWWJNV0EzRy9yaENuank1TS8vVGJCS2ZjUjg5cnBZMG5aMWExdUpzWU40SzJJLy9PU1hzS0t4N2JETnI0U2ZPd2xRc1RESmdFNGFSVUNUZ0UycjJhRU5CVnZsa0RJR1lLUWlmVnFmYnpHdU1ybi8yelh0RUMwWTFtVnE2d2J2cTBoU0xWYklZNXpsVVgxaTlUczBEZ01xUi9LaFl5VnZBajJQWUJJdTF5YlFva2JaYTVicTB4cHlXTFhzbFltYVdka2I5Z2lhTlFiNVBIbjBVZ3UxVVFIRXhEZkdTNFNNRGlJN0YvcVlSN1RaRXZjUzhDUnc4dXh5SDdSRktwaktnPT0iLCJtYWMiOiIwNTBhY2Q0NjMwMTViMmU0NDUwNmFlMjNmZTJlZmMwZThmYzVjNzI5YzM2YmUzY2FhZTQ2ZGE0Njg1ZmJlZmU3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, DE, ES, FR, GB, IT, US', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(626, 'vm20167y57', 'Ipsos iSay', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6InpFUDVuOVZmTHFnYi9vN1dEUENzT2c9PSIsInZhbHVlIjoieEk4WXBtNGtCampmWGRySXMyT1pyQUVyYXJqbUtrMnRXbTJ1dVpzc2IrZGlydDFqOUx3R04wTnhVQ0hENEJGTW5UZ0NuU3NVVjF3SXE3Z3JiRFlPR3pGbXo1WDVDWVp1TjlmSnUyZHZ0T1hXZFVWSWQwTlNaN1RUTW5qdGJvWXJqSFdxV3pSK0oxeFpVS1Fpck13Mmxzd3VuSG10eFJIeVk0K1BwR3FRNDRpWDd4ZzdyS3R3R2ZWTXBjNzJLVXRsZFdCeVM1amNCRSt4L1dFOFY1TFNRZ2ROZ1hZMmsyakx5QTFpRldQV01YcDU3cG90OEtXTVVEVy9tVkhPMXZpNTZ6bWtNcTdWRFlEQzJiQk96TGtBSWhneWhBQkxQamQzTWlNNjMwRE5QZHpJMHZCbFJOVkJmTU1uS0tadWl0Y25KcUdOWjl2WVU5emF4eDM1ZEVUMVV3PT0iLCJtYWMiOiIyNjQxZDlkMmEyNGMyMjdlMzM4ZGIzYzEzZDI4Mjc3NTgyN2YwMzA3MDIyMGZjYWNhOGI4YTg1NzYxODJiYjNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MY', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(627, '6k2yopvdwz', 'Audiobooks', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6IlhSeUhVSHFQckVmYW1qYm8rQzVzWmc9PSIsInZhbHVlIjoiYW9qcFUvZ3BDcnNSRnJESUd1RjVHYlZZMnBadFU5bjdHbzVYSFo1dE80dFdGRWNIVEU2bktGTEl4amlqaHdYeURoQ2J1MExKczI4ZGFJNHQ3U3Y5ZnVKcmhnTDliUzFHWGJRWGNpb2dZbEtWT1l3V0twNy9wZVk3MTVPcnZHMVYxZjlpenZPMUxKVnljWGVXcm12ckNPK2JrN3JwN0FGcFIrTHZjb2F6MXFLWk90NVpNcEdHQllZaEhjWEl6OXA4Qytad3lBSWREbFNTdXRicStLa05mVWM3REs5RmdBM3NpZFpsRGtTYnQ5RGFjQ2t3Yk5hcXZ6UG16SXZHZ1J3V2pHcjhTWCtUenBTSEFwTHBFbnFmS1RYVnp0RkovcFFIMTRiNnlrcWx6VDdnYzRJWjkwWjhzY3ZNRjFWL0xKNjZMQWZUZWp6WDR4aGlENEhqT2Y2cXNnPT0iLCJtYWMiOiI5NjdlZjJjYWNlNGE4MGQxYzJiZTE1OGE4MzFkNjA2MjhmNTZlZmE0YThiY2U2NjdhMjZhY2JkZmVmZWI1YTY0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(628, 'y4w47636w0', 'Hulu', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6ImpqbEZuSFF1Q3BwRTV6VE5nVXNwSkE9PSIsInZhbHVlIjoibEplMEx0Zjc4MXcvMUJETmlnOVQ2dnhGU2ZZWlRKUkdNM1dhUFlCY2o4M2dNNmVzZEhCUDR3WXMzVENXRHVxem9QSHdPSVl1ZDkwa2tvMStYWExESm9YTU9DSzFXeUZWSzI5YW9jMHFtZlgyUXRSUkRPN2lpWFFGSXQzZWVsT3dia1ZlRTBSbHRVd09MV1ZtditoN2FXZ1dKN3dON3JUeVBtZitvZlVqNitNTjNpSVlIUXdEUWdURzA5cWRLbWwyenJFZGd6TG9TOFBPbUNmbyt1TXV2T04yTDNLNGFDRGtxcWNLTWs1ZUpXN2gybzVEVm81NG1sWmM1cVkwZ0dRbU9MNERualU0U1FuYTFmM25RbTJwZ2dkVXEvQ2lVWW9mQlhaSDlTL0ZqSzlZYTMrcG1JMlpRS0dDUHR1RjZzQlIiLCJtYWMiOiIxODEwMDVhMzJkYjI0MTIwYzY5ODAzOGI3NjZjY2UzN2U1MjY0MDE2NjM4NTE1ZTUwMzU0MjY5YTM0MGUzNWM3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(629, 'k3w7qoyz2o', 'Cash Prizes Carnival Coin Game', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6IiszL3dxVlJORDZkcDVNUllzMmJIdVE9PSIsInZhbHVlIjoiRXl6Sk1MSllBK1JRN1l2alp6U2o4YTlWVkc0K0IyRVU3NEdFNmV0cXpkOFBXRWxBQ2hqWUM3N3NXZnVEaU5QbVRQai9haHRPdzAwZDJWR2hSdzFFLzZGblM3VVRRMU9qeDNlQ1ZCcHRXWVdpRzBRT3ZjZm9tN3kwMVhjcFRBcGhTWWY5aWtvT0NzN0phWkZBdTFPWW5WVGhFSmVqRG82bStYV1VRRUkwUVdUbkVzeUlxSDNnbVlNcEFHbG82cmo3UldhUFdqdVVXRzVQd3NGZDBCUHJPWlJDa0M3K0ZFWm12cDF6bE4xNTdmOHRSZU45ZzQ4dnBUUWJjcExxdUlsRE8rcE12SWdmcGdzM09BU2YyaVhxZGpjeWhYb2NubjROZ0JsaFR0aWMrOFZqWlovVnE5NGdnSm9pRExyQWYwWE41OVluRXFrU3JRY3JJVlVuWXpqUW5mRHBhQ251QnVaUzRIbEZUck1XalBVPSIsIm1hYyI6IjAyNWQzMmI2MjkzZWI3Mzg0NzlhNTAyYjc1Y2RlOTMwNGQyMDE0ZmQ1ODIxN2ZhMmRlYjA0MzJjMzZkZDhlZjkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(630, 'x6w30o6lwo', 'Coinbase', '', NULL, 1.96, 'https://notik.me/api-redirect?token=eyJpdiI6Ikg1djhmVDdwaHR6TmdnUmRNUGFRaVE9PSIsInZhbHVlIjoiemFwamxJb21PZGhuWmF3SzNkYkJkUlZRUjQ0eEd0NVlMa2hJSU5PSHhaOTg1d0lURTJJclMrNlhCRXM4QjF4TytjeXM3Y1ltMUNuZkkySjIya0VsNHZBdFJCVFpvbUZueC8rUzVqSlJvZXhiLzN2ZTRYd011Tmc0MFBZTzVWeHoyVEs0aHRTSzVqN0NGRVVwdDY4QTRkY0JIVzRPV1V6U1NwZzc5UHc0WUY0UlFIbXBYWGd1R3VMa3g2bno0L3VzK1gwNk53dnUxeGF1NlFjTjE3WmtCbVZBLzhyU0tXcWltK01OUnhRd3l0N0ZrYmUvc0xxTUh0ZkJENkpHamhybGtrQ1FjYWNCRFdFVTh5VmlMa0Myc0NVdzZ5QXVDbUR5aDV0TTBEbHh1R2RlSkFBU08wTGdQd2ZmQXBWWFN1N3kiLCJtYWMiOiI2MGY0NjYxY2IyODZjZjYxNWZhMGM3MDk4YzFkNjg5ODdjYTJhZjM0NTI3NWY3YmI4NTdlZDMzYThkMjk2YjljIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, HR, IL, ME, NL, RS', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(631, 'kp5nny3e5m', 'Moby', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6IkZVTVRuaVZWZFpWeTIxUE5yajdGRGc9PSIsInZhbHVlIjoid3llU1d1NFBxWXA2VmpRdU1rcGlnWlJORXRwbDJ3a3AxdkNIendDeHJ5UTZLblI5bVNHNWlpZDZTNEN6YkxoUXVOMDlSOFE2dUVlWHpiRnU1RFI0K3MrN3YxcHpxSVFNZUowQlBmR1c5bE0wckZJV1AxdjYyMGdZMWtlMmZBOERVdWlNYzZSODFTbFphV1FlYjBCcWtEcitYV3ByRkxYRnYxd3phZEhaVEtMVDI5S2xVQVV3QjlwOFBUZGtPSXJ5K2N2aFl2NVF6aDZ3T1BMOXNLbDFOZ2V3bFk3ZUhCVW5WSCtGajduWCt0M1d0b1hFYUJBYVRRV2hMQmtGSUZJRjZLWC94TTNpVTFkRk84NHBWbDQ0Rk4xczZjWm11M3JYQ3A0N29WdWVGWXQrMEMrME5NT0ZkUklpWTM4c0pYMU0iLCJtYWMiOiI1ZTQ1MzI0MDNkOGY1YjliZjc2YmE2MGM1MWZiYTEyOGZlZDA3MjliM2FkZmI3ZmJmODIwOGM2YjdmNmUzODA4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(632, '6pwjd70gwn', 'DrückGlück Online Spielothek', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IkxwbnpnV3dwMVRoaUttL0JTVDhYbEE9PSIsInZhbHVlIjoiVjlCc2gzSjJtUHMxT2xFbENaMUNSdUNySXgydlE3RGd4d0xUWEJsRGMvZXhlb0MzSjFqb201cUtvQ0YrVE91TUxaL0dUSWxEYWtUNTNNZWQrN3cwZ0xlVFRXajhHdS8rMFczRVFtdFNMTWZqaGtTVGQ2T25mdXc4R0VWcWhxdHVjN0VReWVDSmphMlc5OThRWVhWNFoyOHVsRXozOFlqbnZOb2Mzbkl3TGJrSnNGMHRoM1FkUHFlUnlxZUhvYTV1R0xSMkYxRmVQUitwWmMvRjdRUXB2RUVMdmE2Qnd0WDcva1JwWTBWLzFUT21sdi90dTFtS3VXalhNRjF6UFQyZnpLWHZPc3ZzRHdXaEdZNjIzUkVkMXhVdWdOZHpOaGxNeW13cEZNNnBpRTZTYy9vdFI0VTh2Zm95b3RnME9ZNEVLOTR0OEtJWUo0T3g2bXZtb2NXdFhTdkFrTEUrZkt5Vkp3SU1VSUhucGlVPSIsIm1hYyI6IjZjNTVlMWMzZmVkOGUzYTRhNDZiNDlmZjQ3MzYzNDE0YmQyMDY1M2VkMjk5OTY5YzRjMDZjZmFiZGQ4NmVmMGIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(633, 'x6w30o1kwo', 'Fishing Game Zone', '', NULL, 0.31, 'https://notik.me/api-redirect?token=eyJpdiI6IktRY2lpWm5LQ3NsTUs0ejg4VnQrSmc9PSIsInZhbHVlIjoibmFGdkFZdEpyU0MwU3FoOHlvOEJqMW5BUlJ0cm5JQlFrakVwc1N5MDljQ3E0VVU0cUpobktMd1RyUmJTcmsrVlVpZWEwOTlodmNFVkRhOGJnWlR6c2N3d2F0MDJUbE54K25qdXdzenovVnI5bnY4WXVOU1VZc2VsVVBHN1NkRzh1ZkNhZndpODh1VXBYdzViUHZNamhjaFAvTm9jSll4dUZCOUZMNDVwVmlXd0swcTlQTXQzR2EwcXMzckFKVnBZb1gya1VZa091eTJnTElyVmR2c0NIbU5ZL1VqK0NXcGRCejhYK2thdEEwRDRrdG5ycm44RUJ5ZVYvaFRNRDdKQi9xSlAvdTcrQnhmbElwdFk3SjEva0tWVFQ0bXBldGdBMlViZ3JJQXNQYWdrT2JQZkkwTDE4YmNnYi9zSU8vV1JnSGl5c052QndsZk8vQ2dPZ3BVQkR3PT0iLCJtYWMiOiI3YzM1ZTM0NTA2YTA3YzZiZGVjYWYzZGU1NzY2MmI0Mjc5ZTljMmE4MmU3NGEyMGMwY2E4YjdjN2NiYzcxMTc3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, TW', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(634, '642qzr0q21', 'Candy Crush Saga', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6InBlZ3lybVFpZjhSN0RRU0tibnBZL2c9PSIsInZhbHVlIjoicjlLbDMzL3grdUI1ZENIR0hZZDZBaVVkU1ZuY3pkek9XUkVkK0Y5Rnk1Q2IyQTI2SHIxdzhSSURKL3p2ZzZWR2JrYjIxSzlCaDFGVlVLSlJvYnpuWEliTXlLMW9obkVKVkpEZGpKcFdVcmR4OXhxQlZWZDBrSjB3b3hNWTQ5ekNqZ0xEeTh5b1VBbkZGcU52N1l1OTl6SGhUdzM2RnJibTRpYWx2eDBHNm4za0pyUTJXcktsTEhueEJ1V0xJZjJqTVlMSk1yTzhjWVRIZTlBd3p6bUg5bks5WFpzVGUwc2ZueFptRC96b3I4OUEyaGtmaWk0RE9GY2d1aFI4cHdLZ0RtVk9QZXQ3V3gxQWxlZ2EvSTRJbzhmTWdGdWp0anNvZy9abFhScjN3RC9PUkFyUWF0SVlSZm9aV2JWbHh3MVg2RU5EQk5iZTNkM2loSElCNmZiZHlRPT0iLCJtYWMiOiIyNDBkMGEyMmYyNjdhNTdkY2M0NTdlZGIzODVlZGU0YWM2MDNiNWRlYmNiYTA2MmFlMzUyNjY4YmZiZmQ0NjIzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(635, 'x6w30ep8wo', 'My opinion router', '', NULL, 0.13, 'https://notik.me/api-redirect?token=eyJpdiI6ImZrZkRLN3BmVGhncUZtY1FZcDlkT0E9PSIsInZhbHVlIjoiV1JLSzNzQ0psZlZTd3pObHBLNFF0dld2bzZwZWxtK2ZCVGxrL1FROU9rRC95UzJGYkNCZW1ZT3VuMmlnRHFENjBwcldxLzJTYi8xcFcvcXVzL3YrZnBUWm1RUlh1NDBURlBrWjdFbTAzdHhBV0I0YVVWSExQMjhwVXdWM2xTV3hLWGQvQU5WTWdlOFp3MllQWDJTcytmZGR6OFRpSEFVM3VEOEhST1ZIQW5uVEVraGxGTVM4R3FJbDBOZDF0bmYxUXJsbUtOMFlheUdBYkdlRkxVZEE2ZC9HOHM1R0JmZ2ZhanoveUlMeXpOUVJYN0NsVkozSmwwR0pWbEZDS1JtNEUzYlc3N1Q1OGIrZVNoVnM5MWFLdm0zekQxTjd3b0dZV0tYOWJ4L1MzUDc1a0duY0dPY2dycElVTXhlOXVnOWlwYmdsTDNpREd4Z2h3MGN1RW15Si9RPT0iLCJtYWMiOiIzNWQyYWRiN2U0MDZjZGI3NzUxM2QyNTFlOGQyNjgxMWJlNGE3MWJkNzgwOThhNTUwMDY3ODdkYTA5OTU2YWM2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(636, '6pwjd619wn', 'i24Slots', '', NULL, 15.68, 'https://notik.me/api-redirect?token=eyJpdiI6ImZIK01HNVJXYWZST1pKVTl3citiQ3c9PSIsInZhbHVlIjoiSTFGeVZQRmJUbk1NL3h4M0dZNS9tNHM2cTFvcWJJWDJoRHdnNzR5aElwd29XWUEvcTdPRTRuek9pVS94MWNwKzZaMy82NXZUdkc1d1RKRWY3cHdEcUF4YW5UNTI2aWx5bEdnV2dBMDZrQkwwMTk2NGxpc1FGcWsyZUk4Wk5rVFlPU0ZSUCtrNW5vVzNKQm1pbGF5bjJHMncwY2xubjZISFB4Qk1hNXZIcDBmUVFkMEx6TXRwUnRYcm5hYU9RNHlsSmJ0cGxyUlNDZld2YzZxOGJ3ck5xUENIbTgwa1pwOElMd0VDV29rbDZhTXpWeG9nazlxcm03cFh0a0l0b2Yxa1RHMExUM01TUjkyRTJEN1QySXloNGRhaXFLRDJMVlB2d3ZCSkdTbHNRd0VnbzEyK29qbHZYcHZja21BR3hUZ1R3UVY0Y09jMStrL1hYMmNiNXdxV3lnPT0iLCJtYWMiOiIwYTRhYTRlZTdkYjA4YjY0MWZiODBmMWExNTA1NDljOGE5ZjdhYzFmYmRjNTFiNzczNmQ4OGIxOGQ4MjYzN2UwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, CH, ES, FI, FR, GP, IT, MQ, NL, NO, RE', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(637, 'j05p361g24', 'Europe Fortune', '', NULL, 15.76, 'https://notik.me/api-redirect?token=eyJpdiI6IkVGQm53dGJqaG5uU1V5ZFlmVm5lbEE9PSIsInZhbHVlIjoidStldnREWFFFcFdad3k3UVJnQ3RvOW9PczBOanFmUlNDS2ExaUdjbVFSSGhEc1FSbXFtVTRURVdNTGUrSFdjQVRubDZNS1I0NE1oNjExSXZ0bHBVU2hqMjJ4NGM1L2ZwZmYzK0VyVDRXdW9TRDZKVVl2K3E1SmxYYUdET1pSQ1ZtTGxQU3JuY3ppSEF0NDdXNGFTQzNNV1hlSzh2VDdoSy9lZEZNN2t0ZFlsb1kxVURwUytoN0RSdnhyTHB6dGJZMkllNVJpMlNWbXlLVXpJcTVRMXhCdFpoalduMDAvcFQzYmpKbjA1TkwzdVhvdjI0VW9iak92SDF1OEtDRE0rbFUyOE1CV1pTYTRCS1U2SXVDT2FRdlc0TUl0eXFpVWNwS2RoREt6N05jcldld3NjZnU5RHhiaG5vRnNLakN2TDYvZlBzN00wM1VCYUFSZ3JEQW1RNlRnPT0iLCJtYWMiOiJmZjI5ZTNkMGVkMmM5MDA2NDI0ZjhmOTVmZGVmMDllZGU5NmVjYzZjMzMzZTIzYmY5NzhjYzRkMTBhNmU4YzU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, CH, ES, FI, FR, GP, IT, MQ, NL, NO, RE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(638, 'vz5ld61qwp', 'Royal Vincit', '', NULL, 15.68, 'https://notik.me/api-redirect?token=eyJpdiI6Ino4TlMwRzVjL2ZmWExmd0NEMFBqL1E9PSIsInZhbHVlIjoiY2orcTQxdGRzU3ZBaFdrWTV4VUpLS1AxR1drcExxNXordjBrQnZZM3lnaHR5dFEvYnFjOElPZitlQVZLd2syU2d6TWUyWHhjMGhDb3l5SDZnNS9HbDV0YnJ6blhBWFJPaURna215WmVZVDZ5a1lyT2drNE84V0pZT0VJQTgwNzJ2T2dPR0ZIYUw3RTVaOFZZcjh0Qk4zaCs2MlJDOUpMTWZZdWJkbGZnejMzZ2F0ZVZiZEhPNkt5Q0piRUIyYmsrUVRybTZ2WXkvQTBmaXNIMGx1ZHBDNEI5TEdjRGNER0c3RnJLRFVhREo0M1lHM0dJbnBHOXFISEthTzJndkdqMjY3WkFGTTFtR3l0WDB4T3hWc29BMUtwc2IwMGVNV01QMFlHdmV0eU4zOVArOUlTM2JCM0xBUXRicDE3UmpCcVJhTml1TjRvR1FXd1BpMkY5Vmh0OTF3PT0iLCJtYWMiOiJiMTk5ODYzOWE1ZWE1NDQzZmUzM2M5YzA3MmMxZDczZDE2ODE3ZjI3MzBlZGNkMmI0YTZkYjI2ZGVhMDhjYWVkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, CH, ES, FI, FR, GP, IT, MQ, NL, NO, RE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(639, '642qzr8021', 'Download Rakdos', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6IkJYVWVsa0pJN00yeTVzOEhxNzRoTFE9PSIsInZhbHVlIjoiTTBCY3E2RE1jMTNKeW1EbjM3REFzWUtaVzJqSEtZSTZ6NFRpUTFDT2M5aHFZVnloY2swbElIcUp3NktzWThSdFpMR1F4NHhYWjZtRXN3dkJYb1dEdmFyNVpZZWRoVVBrbmgrRHMxNHVtVGtZVjdOYUxETG1pOWV4S1JqbURobE9NVmV1Sm1QQndzLy9DOEg3dTJxVWVxeDVaNGtFU09QYVBNT2lZR3Q2Z2EzSlpSTjNXRVdMSkZNaTZNWDhEQkptcWNsYks0R2dkeDdxcHhabUxkYVhCYm5lRU03Nk96NHpURGI3dFcrb3h0aDZkc3NLQ1NuTkw0akRlSU50NTBDalYyWi9za0pvSThvNlJnOThHdkJ0eGQzd3dQbXZrTHpNTTZCbGM5UFMvamE1MkhtOTJ6MUJkSU5jdTltRnQ3SzFOUzk3b29HeEs4M0t1Q2M3UW9DUmFnPT0iLCJtYWMiOiIxY2Y1NWYxNzcxZDI4MjM2YjVjOWUwZjc2OWU2YTY3NjlmYzQ5MTQ4NzlhOGQzZGE3ZTQ3MDUzY2NjZWFhYjg5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SI', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(640, 'jy2roq0v2q', 'Download Indigo', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6IklETDA1YjFPTDRxNFg4bDVSY3RqWVE9PSIsInZhbHVlIjoiMHp3QlBrdTFIdXhXdTE3a0dKbEQvSEVTZGY3M3hYM01lN2pmTFZ2V1U2eGpSS0w4MlU2aXpVWHIrVkVBUDRtN3RwbFNRVEROY3ZpUUdLQVl4ZWsyUW5nM3VwRitqRGVuNkdxWm04dzNBaEtDQ3lmQyszZXFSdlBjUDJvOVZaU285L2ZMRE9xb1RHWDNtellZWmtOKythaVdXdHU4enQrZkJSUVRrUmFLbGZBMEZCYUxUNCsrc1luRit5bkVhSERXdWpjNVo3Wm1YNHREdHFKUDdzT2lFeG5ibEtWMXJsVzZhSVkzTVRqRnNuQ1ViOUhPOElKekhnNTU1ajFzMVpkekJkbEdtYlJDRUhBWm02R2xrcm9WbllXY0tZd0NXdWJVWCtSOXpWYmVRM1RiLytnK1MvYnZFVVlpOWxXN3V0WDNlUVFYcXNzVGlrd29nY3RyTlk3SzdnPT0iLCJtYWMiOiJiNzg4YjI1OTEyMzBmYzk5MmI4MzE4YjAyNTczNmZiYTI0OGVmMTVjYmJkMzYwNmUwNTYzYzhkYmIxNWZjOGM5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SI', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(641, 'jy2roqdz2q', 'Content Golgari', '', NULL, 5.32, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5wdVVsV1k3TkxsTEJjSWhJbXZxMUE9PSIsInZhbHVlIjoiS2JuakVlMXFucnFDYnU0dWpFcGc2UHE2T2lJTklzcWNIaHlhVWVKeUFNUnU3TVF6UlFoVVZUZ0kvT1JKQW5xUWJHMkl4dnBVdERPcWFBTnI3eW9idGYwNFhuM0wzdFRNZGkrdEozUmY2SVdnZjQ2ZE95dlZFV0lLbVFhSDRlM0YrSW1KcVpIbWJKUStlemRjRnlaNzFYS0w3S1h1K01XQ25mZjRVQWhIMlFNQ1JTcG1lZVN1WE51dW8rcWtWckFFbDc2ZzRMQm5rSHJIQlBSU01PSy92WUlUN3Y4RWViMEhPdlFLQjA0dkdYckovWDNkcTZIcHVKMG1Xd0l6b0pHQjRkejdHRG81NXNGZ2hGZXdBU0ZFaU1oblBoK3E4UzMzTEE4a1dmdnM4WGJ1Mm9haGtGTUNISG1vN1VUazRoc1VJRVN3cmRpYU9WTk9zalFSRi9KVitnPT0iLCJtYWMiOiJiNTg4YzU4MWFkYTFkMjJhNjE1MzRlNzIxYWJjNWUwNjJlY2NiNWExM2ExYzMzZTliMDVkMWNiZjUzYjE3ZmU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(642, '642qzrjx21', 'Games Insta', '', NULL, 5.32, 'https://notik.me/api-redirect?token=eyJpdiI6ImhiOHRlR1R0ejBOM1ZqOHZvVFk5T0E9PSIsInZhbHVlIjoiSE50T1pjOFhIdzZrZTVjR0pIeTdWb0lpNFFhR1dhcUVTdExCd3VBbXIyTVUwTTQrUHNQV3ZKY29jRW4xQTFka2ZHQXpldWJnZjZRa2hTRlNvY3gyYmg5VDhnKyt1MkI0bmZkdE1nbTRGWFphOGtZNmhHUy9QbWYwODBEWmk0Y1ZIckdKWGJVZFQySmpnTldpbWJocHNLYmRFSVVnb1h6aW94WC84S295czZZYzNQV1JJWUh6UUY2U01oSU02amRxcFdMc1g1Zk40ckUxcXczVEtjY2I5RFZTVEJLOVVkNUkwbzFXZjMrQlErUUtqSi9VWkp0Wk1ibCtTL2V6VUtMaS9FVnlGaDhBRXhnbHJsWEIzWnNPVEZwdlBBZXNnUHg5ME1CVDlxTnpuSkpId2dIeStKaXQ4azVHMnRMYW1Fa3lUdnJlYmdPUHFhQUFyQVdJaC9jRlBBPT0iLCJtYWMiOiIyNzFlMDExNDA2YTkxMTJiYjBiOTQ2N2YwNzVhZDA3NmZjYTZlMGJiYzRiZGU5Nzg4M2M2OTY4Yjg2ZDcwMDk5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(643, 'k15on6ek2q', 'Spinch Casino', '', NULL, 9.60, 'https://notik.me/api-redirect?token=eyJpdiI6InlQcC9VR0xvTWRrTlhkV1Y3SFJwUGc9PSIsInZhbHVlIjoiUTEvUTg4empZVWRsbkFqNGtYaFlRT1ZNcFpsendkMTFLSFZaOGR5SGVwUkhybU1PZy9DSEhDeTBER3BzblFQNmMzU0dOV211MUUwZ25obm15bXdIc2RZaXp6VGM5RzZvR09UbnlUbm9QbjFuRzh3dkNNSStvZ2puUWlrbmtkd3A3dEcyTXhtd3FRTUp6WmxzWVphWGtrdm8vVTVnRmF2TzJucTZnWkd0eTlEb3E1SmxBczVhRXpsaGdaQ1AyZE1EUDIrYXFicENrMzFBeVJRVEpRQ1A2MHYwSnk5TmJFWmJraWdGUUVvR3V0ZTA3MWdDSmcrNDZ0MS8rNTQ2UVZlN204QTdRU2tuQXdWZ2hKRWhLSDJGUDc1eGd1SFVzb09uMzVYa0FucmRJNkZVb1ZPWDhCVlVVS2pNK0tva0xNSXAzZGFad0RHUEZzNTIxSUtoK2RjdU9nPT0iLCJtYWMiOiI1YzVjZDBlM2UxNzUwODEzYTYyZTA5YTBkM2FlMGQ0NWIwODYzMTkwNjJmNWRkNzc2ZTVhNDUxMmZlNTYxYjZkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(644, 'xr5ed69v2n', 'Loki Casino', '', NULL, 9.60, 'https://notik.me/api-redirect?token=eyJpdiI6InNiSlRNeE9jc0tKc3ZSSmpRVlhEZWc9PSIsInZhbHVlIjoiNlV1bnVOdjNwcE5DOTFka1dxall6TUY4MWZJQloyM0Rpb3RzTndmTE1KUGdYdTZvOG5jOGpWUERwN2x4KzhhQmpObWUvcGNrUGNjY0wwcGc3YkNORnJ5MVZUYURIRm5obi9LQzNybEdlWXlMbUM4ai9jRTI2SUIxZWxGbVFucDNTMVZ0OVdtakEwRVpGRjh5SzcrY1FSNkNBTTZCakUwQ3Z2NHNycjFKRWZBQjFKYk40d21IdktWQlkwMVBOWXhlcW90OTNoVm1WcFNhYWFzS0w0OW0zZ2JBVTYzZXBBSndRU2ZLNDBYVVNBUTRxT1gzbjBEWnRGanBYTTRkRmY0Yng5cWJkU09iaFUvNSs1djlqRkJtZTRsZzY2RjR5WE83Q3lUNisrQjVQeTQycXQzRDVIazJha1BUMkZ3a0cyRmtYSWJiUllWNGtmb2hka3g0MzFBK0pBPT0iLCJtYWMiOiJmNjFjMWEyYzEwMWE4YzJjYmM4NzExMzQwNmU1MTdkZDBjMzUzZWQ2YjA1ZmNhMjU1MmY1ODI0ODU1YjdhYjc0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, NO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(645, 'vz5ld606wp', 'Content Down Blue', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6Ik55aEdPQ1ErTG14MTlzRXVzbzRCOFE9PSIsInZhbHVlIjoiTjVaUmZaanVMVDJTSmVPdkVNU3VySjRacTBqbkFaMTlLOS9ZL0dZSWlGdlE3OFgrb3V4R2xxYW9hc21ER010aDlZUFkvMmJWUy9zME9BRnN5S2hVU01XZ2h6VFpzbDM3QndUejdwM1hMc2pEZzVIQWIrbzJrbzd2MnZXd3hGYlAzSjBONWRJdFpFOUp6bk85bzZETlVHMEVwUGVlQWNMd1U4SzdVeWtXcXlZZ0ZIQzhMdXZPcGxvdytVVjdYV3pHWDVuMERTNVp5bTJOWVdBTDdTMUhuL2hXSmN0UmJCTDczcWxMbVJacUR5cFE3VFRuaWp2bjFaSkJGdEV6OFpmclA4ZmFnQ25OUXdWbkgralZUYzZjeEliVFV6OFdDNzBScWNlQmFPdFg1bDdZSytuWjFISWViMmlwRDFud012dzE5ZWJ1aDNvVHVkaXg3OER0amdna3Z3PT0iLCJtYWMiOiIyM2E2ZWUwOTM1YjY5ZjVlNDhiN2FmODVhMDE4Y2YzOWM5NjY0ZWZmZDRhNzY2M2MxZDcxODE2MTIyOWU0OThlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(646, 'j05p36jr24', 'Content Down Blue', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IjA3Ukp3MDdCMXZQTzJWN1MxeGhURVE9PSIsInZhbHVlIjoidXl6aElQVU52S21Hdk9iUUVaVXNkdTlyc1BRcENLVHJGRFllOWxZRVJZVUI4elNFRkdQT2VMVWc4MkJTRUJPUklRRkVsSldKRkl2cSt2MFViUFo4VGRJWFhGSUFKejVLWTlDd1hYUGEvRE9BRTJKalFuTFdyMHluWWxLQjdlOG9tRjMzRE9tbzdkNnFORTQ2c1VqaWYyOG5NMGV1MWpVZkJjK1hzNWF0T0Z5ajl3ZHF1c3NTNTB3N1dINWRwdi9IZkJxaTN6eHRGaTBjRGpDcVpkOUZueGtBa1o5UGZBT0VPVEZ6QjczckFjZ3l6Um52NENWMXhvejBpZ0pzVkhrZEFpZUJJQ1VRL0I1TDJGUi9ZUDkyRHV0Z0kxTklRNHNLV3RyS2diWExLUDVwZXdINlJpV2J2TUlCRUpVcC9iSVpkSlMxNmVXMVZhVk4zK2dlR0JPZG5BPT0iLCJtYWMiOiJjMjM0MjRjYmZhOTg0ZDQ3NjM2NjA4MzA0MzE3OTY1ZjdhNTc0N2Q0ZmMwMGU1ZWJhYTVmOGNmMDE2MGRlMGYyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'OM', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(647, 'x6w30elkwo', 'The Krazy Coupon Lady', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6Ik94ek1IY2VvQ0s1VHNLZDZCYzY3ZHc9PSIsInZhbHVlIjoieWxGV2d0alk4QlYydldXdGFkUVNiUnJ5SnBielcwK245cnhqNW1XZVJRUndiTWJMV2ZNVHFHNHk0bktIclNCRXN0RXdPRkI4RkN0eDQzblRkNVBjWjdlS3JUelByYVV1N3RERHdiRjgvTEhpdmRRRWc4UHEyRnRUeGVRSXJJcTBXRjFNeVc3bjJXRXc3Q0liZVFHdExBNUMxbjVPQ28vNU5XUGd6RHNONXByNGlMWEMxTHNHdTFSdDJzYTdYTVBHVEFpQ0hoNUFrM3NpU0M0V0VCaGpjTlBxZG00ZnorWGx2cEJwd1RXM0xObGE2a2JHaFU1V1RGNHNPdmtWTWFJZVZoNlBBVitmdVRwSnZaR0xjckdBdVJrTHZ4bWxLUlFuNWRWaEw3MjF5eE5rZDZGWnFEUmEwZ2hOSU1BRi9pV01KUmNHN2pKSVRJaHl6TG02ZVRhOXF3PT0iLCJtYWMiOiJmZjI4NmM2MWZkODg5NzBiOGQyMzdiYzQzOWFmNmFkZWVkZjM2ZmEyZGU2OTc2M2VjMTRkNGUwZDJhZTI2ZDM0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(648, 'jy2roq972q', 'Moneyman', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6IlR2WXRENVo2L21ydUJKSFhWTWROdnc9PSIsInZhbHVlIjoiQ1FINUZtTzJMYkRpdFJOd3hSbDA3L3VoYllEMEhOSG1mS1Z6ZlpETnAycXNZRzBEV2RZejAxdmxtMmliUWNwT2h0VjJhRG9aRDFTMjU2VkdZSTI2NzlsQk9Jc1QybVZ3K3RnSEpISzRtSjlhV3lmWmwyV0NnVnFkdFdjWFp5eDRJUEwxSnUyU0M1THFKSG1FSExZUUl6WEp2aFRHTWpORWd5ZVJhS2U5Sm9xVHB6cDN1aDNyeVJLZU5waUNQbzVKQW91UTY0aDdvRFhpTXVReTBkVHoyOFkyR1RsMEJ1Tlp3MjlRN25RNGE2TmNoZWdnbjRWQVBGNVcvSUhsdndEM3NwZ1ZuZk9xV0MwOFU4N1FMRlhsRGFwbTFpSHcyTmdMSmQzdVFwUHhIS0NtOE9RTjl0N3M2bTFCdkZTSitVOVUiLCJtYWMiOiI5MTc1M2Y4NDgxMTZjMWU2ODdmZGFmYjc1ZTEwZjdhNjlhMGRhNTFiMzBkNTA1N2UyMGUxM2M3ZTQ1ODNiYzk0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(649, 'vm20revd27', 'PineCone Research', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlN6TEFFaTYxR3hNM1J6a3I0ZjU0Nnc9PSIsInZhbHVlIjoiWjUxMVdsVEtlQjcyNjlPRjlUdEM2NVNqWlNFeWF1Y2VNdS9hTHRlUmUvYVBLRHVYd3JTTys0a3RZVmNlZm10VW1VMEJ2em54bDBmVGZidG5PNHVxL2tnQkE4aUlNckF6SVNDUmVBQVFBbFMybzI1K1FvNS9SL3AzR0pPWmlGVTE0ZVRMNWZSNTB3YnVwNncrNzJzdWZPNTFSN2xYa0NZK0FqcmhURXVEZlU1cWE3OGFiank4ZWN1QmVQUjh6UDdsbFhNS2dldHhDOFZFeU1KLysrVmx6KzJRK3lvcnFzUkc4eWNzTTlXRUJ6aWMvMjZwa245VE5iUnlUQ3lVSVJKNmFqSHVwRzI1RjZpaVI3ZG1iazJCMTZCakNUTVNHUm4wN3JzbUFSUCtxM2lBelRKbURUOERsSGlWa2laZnpsZmRRb3dHRkpSV3BtRFB1ZmpzcTE3MHh3PT0iLCJtYWMiOiJjOTBkMDljY2FmYTRhNGJjZGU3NTAzNmNkNDMxYTI2MDNjYmNlM2JlNGFjMDI0YzRjOWU4OTQyOTFlNWYxMzRmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(650, '6k2yo3yowz', 'cashKarma Surveys', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6InJSTkUyL29ud1BXL0RReVAwU3g3N2c9PSIsInZhbHVlIjoieVErUE14RmlxaVlTMjhkOTdNd1hXeXBwdlpLY0hCUDBDUFJwMFlSZTRJMjg5QitBUW5kNmRYd3daSGRZekpKeit4ekVxcWQ1YUJGcWkyTWxrd1JBSTRQYStSY0dOYVpVV25LVGhPOVN1cXBGYWZRT0I0UC9zcTdiRkhNM0hpdkpUMTVGUHRxNGNzd1Bzc1FiU0ZzcnpueHFXcWRIMnZtcVR1dk5aWjhkZ2dncjY5M1B0Q2lEZ2xqZ1FLWkYxR2JNVi8vR1JGT0YxVlo4T0JnT0FRQS9tazlhOTFwajFHckpscGF5REtoQWR6SzVZeThwUkdrMW1ISDVGRVA3UVF2N3dsM0c4UUExa2U3WElIOFZwaWFDUUVYNUp4aDhyQ2VsUGdMc0ZWeG4yKzIyQWFOeEJLUVk0dVUyQmMyQUFYaU8vOE56TFNIaGszTW9wYXU2b1RmSTRBPT0iLCJtYWMiOiI2YTlkNTZmZTJiNDIwNDUwMTZlMTg4MTk4NTVjYjI4NmM4MWEwYTkyZjZhYzJhN2E5OTA4MDk3ODI4OGFiNzI4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, IN, MX, PR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(651, '642qzvzq21', 'cashKarma Surveys', '', NULL, 4.01, 'https://notik.me/api-redirect?token=eyJpdiI6IkxxcXg5N1prUllWdVZlRGU3eDFsN1E9PSIsInZhbHVlIjoiQlZWL2wyMDZidmpsdDQxd3BRVEZMSjlhRGRVdjJBU2dCQUVMZ2d0TTVSVjNXQ3FJMUNGTUlnZWFSZU92L0wxSnlRV2hzMmtNNzRlei84M3BQZHRpaVV0QjlDNWdtZ1BmV1NMYW1tOEw2dUtNRXg2b1V4UHVzZHg1OXp2SGgyTlI2ZWwvOFJNNS9Ob2tHTHdiY1RNK1IrUFRDMGRoa00vL3RaR3huaVEyL0tXZVRzM3dVajBqc29Mb1FNcmpWME5laStzY1lrcXI5WjZQR0VmdFN2RlRTNjNjSWVQM0N5TjJJeGFSaktXU1ErbS9td0dJUnNyMU5VVzJ5WlQ1bWxCZUJoREtvQk9Zendkdm5TU3JKQTZHUlU5cjZQcFJxK1pjdjZKbysrQXYvVXJ1U3BSaXhQVytwWkFRMjVaMEhrWmY5dHlZai90dTdSWkErc0FQL3pNOXJRPT0iLCJtYWMiOiIzODFhOGY0YTdkMjI4MmM4M2NjMjBlOGEwYzg5ZDMyZjQ1MmE5YzdhZjNkNTU1NzNlZTYxYTQ1OGM1ZTQ2MDU1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HR, HU, PT, RO', '[{\"id\":15182,\"name\":\"points_800\",\"payout\":0.096},{\"id\":15183,\"name\":\"points_1100\",\"payout\":0.196},{\"id\":15184,\"name\":\"points_1600\",\"payout\":0.292},{\"id\":15185,\"name\":\"points_2300\",\"payout\":0.392},{\"id\":15186,\"name\":\"points_3200\",\"payout\":0.488},{\"id\":15187,\"name\":\"points_4700\",\"payout\":0.684},{\"id\":15188,\"name\":\"points_8700\",\"payout\":1.86}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(652, 'k15on8qp2q', 'cashKarma Surveys', '', NULL, 6.02, 'https://notik.me/api-redirect?token=eyJpdiI6IlZ5L3hlSTArdG9jZnVEUGlBR0ZiVVE9PSIsInZhbHVlIjoiajdESTJXWXRRZGdqUzZoVnJVdFAybWhpVEQyUkI4by9mRTF1aUlsRlRHbnNFWlhLUGliazZqMG1MS1NOTHBESG5qbHpOeDRKaGpwUkEzaU9UMjJzZm56bnViVXREaC9hN1YxUTBMOHVWTHF5WjZmYkg0ZWt3bUdRSXpUUEltOWZWM0Z6NlE3VzFoa0ovZTN0OUpoWlRLUXlTcFlYVDBKQ1lNek1aVkdqNDY5MisxWnlxTW16MkVrcWYvblJQekF4N3lUdzM1eTZ6VnA3M3Npb1Z0K1h5SGRDYnlQUHpVSGFsTnBOWTZVY3RaK0lPV3RSRndzUHQ2QjYvekFhTmpyMWVtYmo5Y1k3ZlIrWXpGTVVJL2lHOGc4L1ZpRmY2eHJGZmdqUC9XdDRYVGJWLzZUSUVnaDB4WHhxWDdxMDViSUYvU0FUU1MxbzI4STBjbFpEZkltTTd3PT0iLCJtYWMiOiI5M2M5NGUzNmNkOTNkMmE3ODA1NDBiMzJjNjM0YTU5ZjkzMjNlMjQyOWQxN2Q4ODkzZjM1M2RiNDVkMGM0OWY0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[{\"id\":15189,\"name\":\"points_800\",\"payout\":0.148},{\"id\":15190,\"name\":\"points_1100\",\"payout\":0.292},{\"id\":15191,\"name\":\"points_1600\",\"payout\":0.44},{\"id\":15192,\"name\":\"points_2300\",\"payout\":0.588},{\"id\":15193,\"name\":\"points_3200\",\"payout\":0.736},{\"id\":15194,\"name\":\"points_4700\",\"payout\":1.028},{\"id\":15195,\"name\":\"points_8700\",\"payout\":2.792}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(653, 'vz5ldyx6wp', 'BPerx - Bon Appetit', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6ImtzSTl0SzhPSE5rajdxQ1hDcDB5UUE9PSIsInZhbHVlIjoiSHRZTy9hL25mWE1wWFVJUlp5WDBrWnJ6cjRkQjdQSFdsVHV5dHVKZ3l5cUJadWZYYmJaVnQvcFRKbktnNUc5NUU5TFlDZXFOSjEvRjAzR1FiRTNDem5DamNOem1UenBiMWEwblR5Uk93dHd1aDJDRW1UZFJZNVR3REViWUFoOUlKOTJreUZnMFQzdDQ2WlFaSGlJOEFrcHhwZUdnK3ZacndiSm1JMFZ6dzA1N2xxckw4L2E1Umg1THZlY2VTL2xyVkVqYzR4eGczSmdycWI0eUVFb01Ec2xYbjVGV2RqelZtRFYxZ1VBQy9tanRMV0p5bmNLSldFdmRNWWU0YkVRTkJNMEVxTXhsaVFrUDRuK2RMN2pzaFowTXg0ZkdtZ2tkaG85OFZGUlA0ZjZJVGJibmJLZ2Fxamw2em9nZTJ1bVJ5NDFieUZMMlBhdENhb2oyblVsTUlnPT0iLCJtYWMiOiI2ZTc5OGQzZTVjYWYzMzQzOGViNGQ2MzI1NTk3MzVhOWYyMzBjZTY1MDIyNjhlNTM3NTc4MWNkOTg0YzUwYzQyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(654, 'jy2roxm72q', 'Quester Playtime', '', NULL, 0.58, 'https://notik.me/api-redirect?token=eyJpdiI6IjArZlZkSlVTWGhPV2VRUGwvUG9jMnc9PSIsInZhbHVlIjoiNVBwQllIaU94bmVqWFRIR2s1akNvTytEUFdoWDlRL1NwQzRRN1d0Ny8zbVNsZ25jVXYxV1BPejZaemdNeTFVODJDM01GUDdyV1JCbjByaDN2SEJxZklUUnRuYWlxSVlod3RFYnJwL0RETVVtenBQSHd2SW94M2UwMFpkNkJEN0YzMFJEaHcxSjA4SzcvZnpFcWJqendEejZJR3FscnJUTWJHY2c2ckJVS2RGQU11cXJua2V5Nyt6ZnJHQnVGUjNkVC9QTFhwYUtmanRkVGl4NjhyZWoyZnJJMVdGa1BYdGdmVGlnRmtBT1Y0V0tBN1h2N3lGRjdJVnZYRjAxUHlnNFc1aEdlUGdTYSs5YXl5MDhDcVhkS2NIbUJpeVBGSnRSQlQ1MnUvNWh3bWJENjRUOVdGV2VVcnZCQkxnYlV6c3VFWXdBK3gvSG9wRjNHZG41N05ic0pBPT0iLCJtYWMiOiJmNDdjYjc4YTQ0MjA5ZjRlZDNkODVhMzk1ZDY2YjhjMmM3NTA0OTliN2M0ZTJjZTg4NTM0MTE3YWFkNTZkZTFmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(655, '6pwjdgogwn', 'Content Games', '', NULL, 1.18, 'https://notik.me/api-redirect?token=eyJpdiI6IklNc1lRczZPM0NiN3RId0NJamZCTXc9PSIsInZhbHVlIjoiL0lRSzkxeUdwajF2NnVnTDkwZkdRVlllcjBCK0Z6S1Q3bEdpNFBQVGhPUDhJNDhoZlNsSXFxbDRMaVNodW1QVVU3SXNTb0NzUG5GaG9UN1c1NEJmVHN6QmlxN0NHSENEQy9JN3ZoL3lwZ3ZoQ1NMeE5xZ3NoT3I0QUgwSGhwdEpPcml4M0F6TjYySjZORExIVGV3Y0J6bkdCYlBNS1NMTEFmOHRLY2JzY0dnczNtK1hxbHVOanZuVndVMTNLU1V5czNTcFlBSnZFYnpDYTA4WDFBeDR1M2NxaldPaUVpTTUxNmpSZXl2cUdrMlV4UFRTcUdwR3FmdjJZd2xhQ3ZGZ3ZuUXo4Y2tacHNqR3YySGN3UWJDbjkyZmoyN3A2YWtNbkZhaTc2YVoyWWIyL1o4NE11b2s4YTBBREY5RXBkVHN4TFV4SkdpZUZ3VUE5OFp6WkNXbSt3PT0iLCJtYWMiOiI3NWJiODc0ZjIyNjkzNjc2NDQzZGVlZGIwMDdhMjcxMDQ5ZjUwYmY4ZDNhMzI4YmY1NzZkMmZmZTM2ZTBiZDZhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(656, '6pwjd6qrwn', 'Content Down Blue', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6InZkT1BmTlhlZHlZOHhmZTdHZDRlTmc9PSIsInZhbHVlIjoibTI2djVQNFRQSkQ5c2FGazkwanJYY3FLQXl3NmhjTk5MVDg2WEo1cnBycU1ib1J5SkJEY2tTalF5Nlk3dU94UmdLSWFhMkwxOGI2UHAzdm5heU5KdUg5WGdCREZsdG5DeE83MXN3NmJnSGxTZHIzb0IySXZWaXIzUFNtSlFGZHBRVzV4bTBYOVEzckhHSk5OM2dyNUdFSnhod2pZSW45b0dQUHNSenZFc2JiQ0R2UnQyRkQ4Nk11RmVvdjE3K1hvenowakphdUFkaHBqMVNqaXIyOXB3SjdoWGFlTFhOVUhCZmxVVUlNWEpUOHBxZ1lDb2llTDBzQ2tiK0YyZVdkc0prTGxIbkVyNXhnWlhaTmhzSGZ3RDlqL0lnRU8vZmZldmVqQ3ZFTkVRbUR4dW5rQUh3UzNxSEJmNVhialp2VUw1Mmx1OTdRT2E4dllkZURTbGtJN3F3PT0iLCJtYWMiOiJlNGUwOGI3NzRkMDY2ZjVmZTc5NTFlZmE5NzU4M2ZmMDJhOGY5MDdhMzE1YjdjNWI1ZDE3ODZjZmI3NmQ2MzJmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IQ', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(657, 'j05pkpgew4', 'Content White', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6InpCOE5leDVqSzBRaVNNZXF2UFlsS1E9PSIsInZhbHVlIjoiRHRIUGJ1Z3U3Nko3Rm9EcTB6YldVY0ljT1U3aVR1OS9GWjI0dFVsdDdhdEhxVWlQV0ovbDhmTVFCdnJCVzl3dFlPTDloQlNnaXhqRzhQVThQeVpid2IxN2xnVGFYbWl2dndEQldsUEFkMnJoR3g3a0FwdnlIbXRwQi84bWVlQS85VE1HMGpiekhjaXV0cU5Tbis1M09MUFRLd3J4RjZVcnJiSlEzSyttYU1wYU5tYmJ4RnFyNEN5aS9vSEFhdGpJUWd2UkdCeUlTNFYxc0VPcUFYZmEveEpwUlQ4UjR0azg1dUZVQ1M1Q01HaDR1Yml5SmJJRktsQjg3WEU5N3phdDk1SzVLOUtianFwU0dRd3VVYm5PREFGZzJ2YlBjbXl3OUJGTkpabWw0cmdhMnJDdFRJZzA1ckdEcmpGMlA5SmhrY3FVUm1kNkJXT2RFYmQ2azBYYzRnPT0iLCJtYWMiOiI1MDRiZGExNzFiMGQxY2FiZGY5YzFjNmRlY2RmYTczZGY5NDJmMDNkNWYyYTBhZDA3ZDVhMmVhYzM3MjdhY2E5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IQ', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(658, '8dwkxkzn2e', 'Garden Gnome', '', NULL, 0.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImU2RzY2OHlub3pITjBLbDVDaE1pWnc9PSIsInZhbHVlIjoiYXZWTktZSE91ZytKK2NYRGkyS2VkKzZ6MndETW1wNVJxNWlkM0loZHFmSEJuc1h1WmlhNzczQnVTQUZOR003bzdDVEVxVk1ZbjNuWk5BZnRGYUZjRVJ6OXRGc1VHOHFoY3VqTldYR3hQZzVYT0hWOGVjTlprK012UGxBU1B3OGdIS1FEWUN0bm1KOGcreWpkcURoQzhacmpxZUpCNFVjTUxGNC9qOGF4dXBIcmJnT2ExL21iWndQT3o0SGR5V0pnSjRNNnYyR1E2NDRyQzdLYjhXZkI5aXRwUDlFa3hKTU5XVC9OWnl1KzRMODRUMHUyMlZmWGlKMDVIRUtRY0hXWVgvdHZMSHhLUktxYzYxdTByZ003dnpuVi9xclN2TVZMTFgvL2xucjVHM0Q2WWtINGtzYTBXSFNyMnk5dlA5WmIyZUdaWVJEWWpCcDZ3cC9PYUVVdnhnPT0iLCJtYWMiOiJiZDM0MDE2NWUyMTkxNzlmZTBmOTQ4YWRiMjY5ZmZmYWU3ZWJmMjQ5MmUxMGQ5YTUyNzhhOWFhMGZhNzg1ZDZhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(659, 'k3w7qzp92o', 'Garden Gnome', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IlZjM3pxb2llNnVaZER5b000NGRTWlE9PSIsInZhbHVlIjoibnRzNlJ2eFlnRnJkWXZaYXlsQmwrUGs2aEY0N3FFcHdNcFJLM2F2VnZtKzY3dEh2aXN3eDNXeHlOcCtrcCtDNkxKdkkxV2IzQ3Q0dTVNemFyRkY1SmpQS3hzcFZrN09HT0RaL01Fb2JEekE5SERSZ1VBK1U2Y2o4UkEvOXp4TERMZDlQSlR3WHlmUG55aXZ6MjNZYnZIYkU2Q0Z2cmdXK2xMTmVJOXFXSmlNM0NCVFZMdER1YlE3NHdIbDZZVncxNUM4VUU4MERRTzhaMFNDRGVaejYxbGlOQ044bGo3MjN3eFZlMXB5MkVzZGJkMEVBSnFqZml5YVlMMjNuMlcvbXhURzJod2xhczIydWVOaW5IZ0JEVXQ3Tncrb1c5ajBDOTdzQmJxTVFTakdBMkUxRjdoQTNFcnVaT2ZySGVOUW1DTkgwMjFsZGNEQ2QySTd4VVQzeW5BPT0iLCJtYWMiOiJmMTExNzQ4ODY4MGQ4N2NkYzA2MTAzYzAyMjgxYmEzMGY4OTVjZTRjZjkwNGNhZjBiNGIyOGIxMGUyZjVmZDY4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, GB, FR, CA, DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(660, 'kp5nn9gg5m', 'Chaos Cruiser', '', NULL, 0.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImxYVXJRRkZCUTN0d0NqaEtHQ210MXc9PSIsInZhbHVlIjoiV0FBODU1ZVBMOWtXbEpwcERTYmtQOVJBSU80dEY3SWRXUnQ3c2hFaW5mTFBuRHgvVElMWWhvTkNBL294UmdoZ0ozaDdRLzJ0UEZtUWNyUmxvVDFVcHVtaE5lcVZxb1lockRtZzlUdUh1TXVTMGxNbjZXSGNIbGM5aDZJRVZTNUhyL0g0YytNYVBoVXhyN1dnNWZWR1lhR2tiUzVVdyt6ckpucnMrdkVaaWxCRElwNDVBMldVME9seHJzNEpCMDRTR1pNTjIyRS9jR1o1YlVUY2ZYRG8xMFA2bzZTd2xQcE81bm4xTUdzTTk5MTBvZVZuYnE5N05CczRjdjAyMDl3Uk1NWXcvRkhDNnJKam45eGxHVDFBU21rZitaQzRJT2twS0lVU3RZVTMvRHVMYk42clBZVHZ0SnpkVFNkRFZxWnFZaVBNWDgzZnhUcHRLZEFXeXZCbS9RPT0iLCJtYWMiOiI0YTBlYzE3MzIyYzg3MWEzZTZlM2QwN2I1MWJhNGM3MTVlNGEyYjNmMWZlMDliMmNjZmNiZGM0MjZmMDJkNmQwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(661, 'rx51qx04w6', 'Chaos Cruiser', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6InFyZlRaazZ2a2VROHhRTWJyS2RJRnc9PSIsInZhbHVlIjoiVi9jVGxBaFZvS3FwUVkyd0FkK1JQejBZWDgyK3lLc3laWGVmWkJjZ3p5WnZhbEdMRGlwaXlZUkZhY21Gd2xjNHpGL282TjFzY3IvdVhGU0ZoTk1jUEd6K0hoNzIzSXFPSHlKbm5mR0pKNG4vQ1A4RlE5Sjk4cnJlOElnWmR6eFd5SVFhTnc3MEovR1R3Z0MvTjVIVFBMTHhuc3gzZC91VE50eHltM3NMK2lxVmx3MmhyYUpONVd3U0s4WHg3SnRTeEZFWGJpT0Y3MTlKaUkxMFloNEZjME04NHgySmFUaFRXUDMvTmYrUjI3SDc3TCtzR3ZIa24yUlpscFlxN1pFUmFKTHo2UmIwYUpqeTZRVDZIV2hQdzQ4T3dqZld5N1cxZko0ZTRJbmVEYzBVZ1RHN1RhVmYvY3ZSdS8wSVBJbDFlUkIyN0dDM2dsS0IzeE9tT2ZEZ2d3PT0iLCJtYWMiOiIyMDNiNGM2YTBhYjM5ZjNmNzFkMGQwOTIyY2QyNzc3YzYzYjk5MWNlM2JjMzgzMWZmM2IxZDQzMTMyZTExNTc0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, DE, GB, FR, CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(662, '642qz9ge21', 'Garden Gnome', '', NULL, 6.61, 'https://notik.me/api-redirect?token=eyJpdiI6Ijk3am15eWVhTXBEVjVKL01TOE9UR0E9PSIsInZhbHVlIjoiUTZXcGxxV0pIQmhvWlVlenZEWXd1Nmk4MS9VUTBwZktrNzllSXlEYUkyVzZWaVhEZDBIT3pVUmltRnpicmxnNVRyVWpiY3JzVUNGN3dLWjFUKy8rT3lnZ1JnNkJLQTk3b3BlbzRsK0pBNm02a0YySG5DKytqbkJ5ZVR1bmZDS21MRGlVRk1Nd2wraXp2YndadjU0azFqNVpqLzdNaVdwTWhRUWUwZ3RhNmxBc3FUcUJoMnNzeEJVajFUQm54UmdxamtOY3gyS0ExbWlNSnB0eTFyZ3ZrTlNkY3MwK1Y5M3dBNzExemprdGR5WDJNWjhLdFVmV3hDbk9waDZiZytOcnZLQlpMZSt5NUIyMFFrZkY4Z1I2clZMVmdkcUZuWGVTNWc0VGFKd3Nad3k1K1V2bGdkNysyVStUV1RtVWk1N0h6eUdtMUtUSTVteDExZUhTc2tWU0FRPT0iLCJtYWMiOiJkZDE4MDA2NDY3MmZlNDc3YTQyNmY3MzJhYzI4N2JkMzAwZjVmNjM4MzE0NGFmZWZkYzFjZDNiZDg1NTNkMjFjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT, AT, AU, NZ, FI, AE', '[{\"id\":15491,\"name\":\"ggn_player_reached_100_heightlevel\",\"payout\":0.016},{\"id\":15492,\"name\":\"ggn_player_reached_300_heightlevel\",\"payout\":0.028},{\"id\":15493,\"name\":\"ggn_player_reached_550_heightlevel\",\"payout\":0.044},{\"id\":15494,\"name\":\"ggn_player_reached_800_heightlevel\",\"payout\":0.764},{\"id\":15495,\"name\":\"ggn_player_reached_1200_heightlevel\",\"payout\":5.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(663, 'kp5nn90l5m', 'Idle Food Bar: Olivia & Oliver', '', NULL, 0.90, 'https://notik.me/api-redirect?token=eyJpdiI6IlZhRGhFbDhIay95M0NKZUY5MUtqK0E9PSIsInZhbHVlIjoiYURBMXV1eTVwb0YxUmsvOGxtWGQ1cmZZUS9nYjBPaVU0dFVsdThGa3VoQzMvQ1hwZTFZV3FYN3A1bWFyc3k2V0JDTXJjdVhTdFBaZnFEQWpwZjMzNHlGenpCc0poWnJuZFlIOGR2OHRtME5jaHF0MkxWU2R1L1NqUnhSWk9yL0o2SS8yaFJTSkZpVVFRVDhteWc1SzJQMTI5ZytKTlg0eXRENGJFZDZFejVqcmM2d3JFYzJNR2ZXV3d1Z1hSWTJvY3NMcksrSitxejY5VHdTRDBia0pBbWRHTnRmcGswVlRTTXd4ZWtFQmtvc3NpRzZkQUpzQ3hBcU5nVkN0bUJDb1loaytSMWdzRGx0b3lKNWErUzl0ZXQxSTh0T1ZLamFNNlVmY014RTdpOHNCMzJjZ0RlL0t6elRMU0NtbUhJaUljcGlLNzNQS2FVaFZ5NVpqQ0JnV1MxajFCcmNwQlk1dUhnTU1kVjJiMkxNPSIsIm1hYyI6IjAzOTUwNzc5ZDViYThiYmVlOWY3MzJiODFmYjExNGEyZmUwZTA2ZTcyMDkxMjU0ZjA1NTQ3Y2E1NjhhM2E1YjgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, GB', '[{\"id\":15512,\"name\":\"Cashback for any In-app purchase\",\"payout\":0.056},{\"id\":15511,\"name\":\"Pass map4 Venice\",\"payout\":0.84}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(664, 'jg58mg9q2r', 'Hetal', '', NULL, 2.04, 'https://notik.me/api-redirect?token=eyJpdiI6ImUxOC9lc2l0anl2QmRDUmRKTko4WGc9PSIsInZhbHVlIjoiWUF2eUZ0UTNvaWMzZHRCYStpRnI0QU1kZGE5TE9FcUtFcXloSDlWS3pYWkhEc3o5cERINTZRUzRyUDJDSis5Y1FKRkJXeUx0eFF0UGxjRnZ4RFIyY1FERm1WTUpOay9MVGVvRVZxU1FzWW9WWGxZczdDZVkzZFlTcFQ3UWVhaG1DaTNvb1EwemxCQWp0bXZRZE9lOVVWbzNlczVnMm92U3dhT1EzWFh0VmxoSk1jUEsyUXlqMUx6QVFzSjhOblp6R3Q5NEhKVmQwMWRiWDRsM2F6VzZpWE8wTEplSzdndFRCUDYrWVJ2RGNPSWtpWmJJdzU5cmR6ZDFwWDk1Smo1b3hXaVF1TTdhRFdDK0tsWkV5L1pYamN4MmV4VUlhaUNyQ3FPWjMydkpOV1lia0pWK3dCZWRQSUNkeGJqTHNnckwiLCJtYWMiOiI3YThkYTU1YWM0YTU3NTM4M2Y1Njg5YTcxNDA1ZDVmOTViNDg1NmRkMWY1NWRiZjVlMThmNTRjYjg0M2RmMjcwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":15637,\"name\":\"Register with valid details.\",\"payout\":0.176},{\"id\":15638,\"name\":\"Make a 10min video while shopping showing shopping aisles. Users get an extra $10 in the app for uploading the video.\",\"payout\":1.86}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(665, 'xj5gqz40wm', 'Magnet Miner', '', NULL, 10.28, 'https://notik.me/api-redirect?token=eyJpdiI6ImdTQ3dDcW83bWx6YUg4L2wxenljVGc9PSIsInZhbHVlIjoiOEpQdDhNaDJGUnBuTTlQQ3VPbHN2WUU0d1dJY0tSeGxxdldsTm05Z1lScmhyWkNYb1ZONUdrU0V2WitLR1V6d2RhaFRyNytFV0YwME1YYnoyZGpNQVA5aHptZjR1MXJiQjFkbVdqeW9QdHZVSTJzTHBoY0wza2g1Qno4TVFFQ0piN2JDMzRHRmRBTEZZay91T29HN3FkNVFMckdadUM1WEFoRWFVNVNPTXRJcTVmcmUzT0huWGhOQVBJMS9FclBlcGt2dXFCQS9pWXVwMkw0dXVCZ29SYWJ2eWdiMmYyZnlvdWRYcVhNd01aREN5aXFWOHJqdlc5MVZiVk13VFJkdGdWR1NwZUx1S0NiMUNCK25BaVQwemo5TC9YT0VpVW90NnQ3UlpxRWZvaGtiVmdIZTFnVmhrclVJUTEreHg2aGRPeUZ4eGU5MkpyZXR2SlAzMUZYVnlRPT0iLCJtYWMiOiI3YzQ2NWZhMTRhNDU5MmJiMjA5YjdjMjFhNjk4OTQ2YzFkN2IwYjEwOWNlYjllYjU1NDAwNjFhODg4ZmM4MTgzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, DE, FR, CA, GB', '[{\"id\":15678,\"name\":\"depth_reached100\",\"payout\":0.04},{\"id\":15679,\"name\":\"depth_reached300\",\"payout\":0.044},{\"id\":15680,\"name\":\"depth_reached550\",\"payout\":0.196},{\"id\":15681,\"name\":\"depth_reached800\",\"payout\":1.176},{\"id\":15682,\"name\":\"depth_reached1000\",\"payout\":8.82}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(666, 'y4w47d1zw0', 'Hungry Shredder', '', NULL, 15.11, 'https://notik.me/api-redirect?token=eyJpdiI6IlRINXZNYmFwdDNVbERaQjQ1RVdxU1E9PSIsInZhbHVlIjoiY2xpVjl1OTRLc1cvQUxPSWpuVXp4enpLdWIzNlFjaTBkUGx5OHp0L1BxYkd6N0VnVzkwMGVjOTl4V0hZV1dWSW16dzd0S0w4dVNSTTY2Q09qNFkyZFRuNVJCMFBWeGNhZ1hwR05YZlVyUlFyUC9WdHkySWVWZGh1dUNBQ09INTQ3SkdWaVBlYVYvVzloQVduV29sZ1E2NmpkMkVPSUhzYTRFRmpOUnljU25CZm02ZjliVVRWSDY0dXlsQ3g1L2x6N3BmYzlLSFQxS0VuRFhjT3Eyd0c4UTR2b1EvTUlOWGFGdnJKbHZpbGc5dWMyQ3l2d0g5TTJvWjhMdEx2WmczTk1kUFpqdDZucnBUUmsxOTF2dDJmUFFtaUJZWjVRYlNpUFlqWmg2Qk5Kb25iaEcrVlhzZldmVVkvYTVwWmwvdXVYaUl2SUsyWWtWcUhHUlgyclZTajNRPT0iLCJtYWMiOiI3ZjAzOGM3MjdlZGNmZjk1ODhkZWMxMzQyNjE2NzA0NmI5MjUxMGY1NTY2YTIzMTM2ZmJjMmM3NWE0ZTM3Nzg0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":15683,\"name\":\"hs_player_reached_100_hight\",\"payout\":0.028},{\"id\":15684,\"name\":\"hs_player_reached_300_hight\",\"payout\":0.044},{\"id\":15685,\"name\":\"hs_player_reached_500_hight\",\"payout\":0.424},{\"id\":15686,\"name\":\"hs_player_reached_800_hight\",\"payout\":2.016},{\"id\":15687,\"name\":\"hs_player_reached_1000_hight\",\"payout\":12.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(667, '6k2yo9lmwz', 'Hungry Shredder', '', NULL, 10.28, 'https://notik.me/api-redirect?token=eyJpdiI6IlRTQkFMSUVTak13K3pXaTNqdHU3bHc9PSIsInZhbHVlIjoiN3d3aVBwZVM1NTE5V3ZXZUNIaHRWOW04MUpuRVpnVEZuWW5OUEFPWEVkR1ozSnZNcG5FbmxPd1Y5d2dRV3NWRVZpem91bFZhZVQ1aWtZR3pGVkZTY084Q0c4V0RGV1RJaWlKU01oZFovcXkzQ3VPdUtQbTFEclk1bnpKa1c3NDhBWEZCUC9qRFpkam1YU2lwMElKMW1sMmdHRFlEdWVKdnVjb3V5dGFiYVhiNGJQSjFiQmhEUnZNYTFiMlZiajZDNTJTT08xNE80SEo1T3AxS1k2V0d4TEdIVkZjZERmL0dXNzhiekw2OGg4NUtxUDEzZDZmTU1oOTBvejEvcngxbFhvMHh3ZkhZRFVkSnk1ZG5IaENadzVEK2JnK1c5LzV1bGc3WG5oYnkzaTFpSk5IMHNMbTArUS9TYmZad2VTMW9nL3cwakM0WHlEZnE4VzlaVGoxY0J3PT0iLCJtYWMiOiJjM2FhMTUyY2Q3NjIzZTI2ZjBkZTlhYmM1ZDFlMWI2NTE1MTQwMjZkZWM4MTQzNGIyYWFhMmYyYjljNGM5ZWYyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, DE, FR, CA, GB', '[{\"id\":15688,\"name\":\"hs_player_reached_100_hight\",\"payout\":0.04},{\"id\":15689,\"name\":\"hs_player_reached_300_hight\",\"payout\":0.044},{\"id\":15690,\"name\":\"hs_player_reached_500_hight\",\"payout\":0.196},{\"id\":15691,\"name\":\"hs_player_reached_800_hight\",\"payout\":1.176},{\"id\":15692,\"name\":\"hs_player_reached_1000_hight\",\"payout\":8.82}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(668, 'oq5zv9x02v', 'CloudFront', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IllyZ21nZGhQcmdvZnBYTkFOYXUxaHc9PSIsInZhbHVlIjoiSHlrL21TODV5cng2ZkRQRHdSa0F6MC9hcFVRaWVJM2ZzaVlDdjJPOUltcEt4eWJIUXJRRFkvN3lMTkVpT050WDh4Z1FTYlBKR3lhN3Fka0IyUS9kNzkvWEJKaGNIcWhod2xIVXNvRUVsWjViN2EzV2Z6SDVmZjBTaW1tV2s0cjhVU1FQQk1NQ3Q4T1QrbEpKVE81RUpUSDJnR1Y1dHhhZHkxVlZua0NzU2ZEK1BJcC93UUxjdUJZZWpPa1RTOTI3WjdLM0xseDJjdVozRThQNGRCV21qd01wVnlHS3J3dkJoNE1TNG4xTE5UTExVSmp1TXVXRjRHRU5xd0o1TjdHMWszWlRSaGJwU0FEeUZDL04rT1BXeE54RUkrak5wTGcwNFAydmg2akJ5eUwrMUlNRnY0YlJKdGpVVHZVU0ZacFhrVVVJMFBwVkozOHRnRmRLWGhVMUtRPT0iLCJtYWMiOiI2NmIxODZmZWY0YTYzZTMzMjNmZGNlZDQ0ZmIxOTRiYThjNmZjN2NhZGJkYjFmM2EzOTEwMmEzMjY1MzMzYjhmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(669, 'xj5gqzd0wm', 'CloudFront', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjV0U0ZEL0NhbVNJeGgrRGZXdmprUWc9PSIsInZhbHVlIjoieHpNcllWMHl6ZUd5MlU5ajRxcjFTZVpKUW1adVNmUTdSYXQwN1dJYWpXRTl1U3UwV094d0NsMnhNd1NnUUIzRkYxZ0s4bkllaFEwT2sweXdHNFltRHdCWkpkWkRrbHFNZ2hBdmN6Z0h0clpYL3pONjMwd2xoRnluTHkxeDZUb2NwSm9EbS9LM1BzY3J6cE9wWTNNdzB2K0JKUkx4b2hPWWQ2bkRqV3A1eXF6TjRBQk1jQk5FWW4wY3JkZjNBMXNabDRsRG9naEJudTl6em40Q09JMXlZOHVMQkNhZ2p3Z1M1NTZEYXNaRGhEemUwV3dRS090VkJOR1BSa2JPeDUzUDJQN3NaSUVYanFEZ0tZL3hXK0VaVHdpOWROTW85b3FHRWNiYTE3M1plVlFlYlFJMytjcXZMYkExMU5Vb2JidEY2OWFmQllxY0Ixd0haQVhXL3loMEt3PT0iLCJtYWMiOiJmODVkMzE2OGY3YjBiMTMyNjg5ZTU2ZjkxMDI2MDI1ZmVlMDgxZDk1OTk3YjBkOTYxZjczM2JkZmM0ZjhkMmJhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'RU', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(670, 'y4w47d3zw0', 'CloudFront', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IndLNmV2UjZiUlFRdS9laC80R2lsNVE9PSIsInZhbHVlIjoiRldoR0tXM1g3WWU0NVRFYjdoMVR1U3BMSThFNDdLd1U0b0ExeEJLeFBQeDRvS20vMHFJK1N1Q0cxT0thMHN6UEp3MkYzKzIwcW9jY3VNZWFMS2FiQTd5QldEVlFXcDMzNHlkSVFkTTh6RDh4ZE9vcW9LZjRkQUpGMEcweXJPNWRVSklmUVlhTFo5UEtkcUxUSXNlUzFYRlp4QnhjRGxUVjEzNkhSeTdkWCtxN1JvMHJPMkNlRUo2Si81SkY1YUdMaENCeWVIY1g5U0puVHZXbzBDNHhTZGNOd0FsZVJCVjVKZ1FrUEhCdi8ySDRmYWEzbUtJZGtXN0ZkV2ZFSEw1RHpVbmhHdjUxcURQb1JrV1l1ekY1UlBWaVNIWUxBM2N1cjZaV3ZlNmFuVHoxQ2o4cG5Vb3VkNWovU0VpVzNhRnNnK2FUNGZpckl1TUlmVTFHMjVNUFNBPT0iLCJtYWMiOiI3YzAwYTI4MjZkMGRkYmE2MWVlNzRiOTZkNGFiMWU1YjIzZDI1MWU2OWY1N2I4OWI0NWY1ODAzNzhkMGI3ZWY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(671, 'j05p39jr24', 'Idle Food Bar: Olivia & Oliver', '', NULL, 1.18, 'https://notik.me/api-redirect?token=eyJpdiI6ImxJSEFvZTNycTlhWkkybEhucmRCUnc9PSIsInZhbHVlIjoiaVlnbE94ZjdrdTRNQytLWDFqTEs2OWxFNUdqbE5XeHRGNEJITHd4VTJ6TVlqZ0hKRE1NSXpUTDVaVlFEaVoxZks0eU5YWHozVzFubHI3eHNlM0o3aUtYbHFDejBPZkVETDlQTEQvRnlFTjNzMlU4dGdPS2Mxbk9mY2NBOXlseXpYbE1waDZPVmxOTkxCS3NIZGY1NGYyeXgrVERaN0JnQndmOUhkemlPTVRLSTN2Y2w4TFRaMDNvTGNsQlAyWjI3bWNnQzZXeVp2QXVPdnBCQUJlMDNGWnFBTGdLSzdUVm0xOWdlN1F5emNKMEZMc0dNMVdaQ3hDejUvUFpnSEJxMUVYcE8rWUU1a052YW9DUVp0azJvbzRlQzA0WlpqdWVQNnpHb2ozQjZiK2FzODJyTzk5Vncram5JUk84eTdUdWtrNHBpSDQzaGQ3UnZEcU0rckozR2F1WXhiQzM4NDI4dytpcHU1V3VaSlRzPSIsIm1hYyI6ImY3YTJhYzRjMDAxMTA4MGI2ZjJmMDBmNzM0ZTRhZTE0ODUwNGRiMThkMjY2N2FiNzdmMWQ2ZjQxMzA2NTFjNjciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[{\"id\":15868,\"name\":\"Cashback f\\u00fcr jeden In-App-Kauf\",\"payout\":0.056},{\"id\":15867,\"name\":\"Passkarte5 ShangHai\",\"payout\":1.12}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(672, 'k3w7qzdg2o', 'Wild Fish', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IkphZ0hRaTM3QzRiM2hlZHlFbm82UXc9PSIsInZhbHVlIjoiam52YVpJRE5ZYWpkdnQzeVRxdTAvVFNXdXkvYUZURHR5N2krWUJLTXdUV2IreDZUS201MFlaWUdTeSs2VVlMTm93VGRWVFVkMTQrYTlINmlFK0Rsa2JLc0tUYjV5UFBFZEhFQk9Kby9pcm9IM3hRY2VMSU56aDBMbTNwSmF0aUtQZWtMb3ZQcDUybkE2V1FpYmFNWVVjRTcyUGtnTGxTVTNYUHlIeDhCaEVkTmRGcnhsN0FwSnhDOXNDR05jNWdVU1RsSjhuYnBEZ0g1NEZRRkdEdnZyR2JEMUgwOE8zVjRxN0hhVVAyL3h1Z3NxVVNaSGZDOFcyaE5TWnF0c2NVdnZsS3ZDT25scjFoT2tkOFh0WjViOXdlai8wMmFoTFFxQkdHRWo3eFVWeG9RTXRJU2t5cG83ejhOME8xVUkvZ3dUVnVjS292QlJ0bjZVREZkU2U2YUFnPT0iLCJtYWMiOiJmMmYwYjQ2ZTY5Njg5Y2RiNjlkNzU3ZTU2MDZmMTA2MTczNGQwYjJiYmI3YzQ4ZDk4YjMxZWVlYzMyNzM0MTNlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(673, 'vr5md9q15g', 'AliExpress', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlphTm14cU5NTDF1YkdaTVUyR25SQ2c9PSIsInZhbHVlIjoic3dEa25MMUd4d3ZkdGdmOXd6dGUzSDdjV2lYZDF3SzJxV3hjRTBxSnVzMXd4MFMra0lERURnd0I2ak5QSGxLeTNWMGtXbjhvSkpaelhEd01TM1ZCYWc1VG9nbjBUR1hZWHRKNUhJUFl2amJwampJV290bzkvdDQvNTFXN3hYOUF4MlRLdVRJOHBYU21Wd1JMTGx2eE9BVXRRTlhXY1FRc0h5RUI4Z2N0YjNWZnVtOXd3UUgzYTJTbWxLQmhKLy9nMWlkRm9RcEVDSmFsTFMwSzlaVHQ1Zmd2MlpNbEIxbEMrSTlSdWRrMDVjdEtWcWdYbzRJRmhXRkM3U0xGYTZHOFlsUUZ3Nm9hODVSSUViN29BVlB0UXFZaGNLY0YwTE9xK1hXNUZZWGFmUFBTZjluMHplbzYvWVFEU2szcEFjc3lwd3NsNEppMUY2N2Q5WkIyS1Z2Z3VBPT0iLCJtYWMiOiI0MjJiYmU4YWQ3ODZmNGU0NjViZWVjYjNkNjA3YTg2ZjFmZjA3N2UyYjAzYTlmMTg2OTQyNmM0ZGY1MzQ5OTRiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(674, '642qzgkx21', 'FinanceGoal Millionaire 2024', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IjZnWlIxY0RWdktHTGVSQjg1dU1OeXc9PSIsInZhbHVlIjoiTU5rR1JiQXF6Vmlkbk4rQ1dxTUE3MTIvVkdaMUVCYmp6STVNOGJIZmUrV0pyTEhsa1BFVXpibE9SY0laeTZvRHp5VUNkbmlobDBkUWdGcmU5clFkdmNSM2NVRTZ6MkUwMDJJOXcvRUY5alEwVU1nbzhlZ2hvNWVrZm5oMFQ2UDlmY1FGbmpCYW5OM3dUUEhxOHdkSnJHc1R4UlplMXJ3YzFlSFVWeG11dEJaRTI3T0dqZGNDU3RIQkZldEI4Tmc1Ym45bkZPQXFpbU9kWExRSnRGOW9aWFM0NlJXcDVoMzEzb3h5SjJXYWM5TkVHeXREVXpUVWk2YlFicWFRamZoek1HQ2pSazVvTStFVGtZV0pIZWNtRno1MWw3bUFBdTlZQ0RteTJ0Uk1XNTBPUzFNa3dQVFFFQ0dQbG9BZ2UxSTNKd2NxaDRiWFQrdm14SkwwM1hIVlc2ekNCVm10V3FBZTVhK255Mk9oVHhZPSIsIm1hYyI6IjNmMzI5YzNlMjA5MDcwZDQwYjkzNjJhOGExYzkzMzFlNmIxYTAzM2VjZjU5MWUyODQxODRiYzJkNTRiZWZlZTgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BG, CH, DE, DK, FI, JP, MY, SE, SK, TW', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09');
INSERT INTO `offers` VALUES
(675, 'x6w30xokwo', 'Samsung Galaxy A53', '', NULL, 0.02, 'https://notik.me/api-redirect?token=eyJpdiI6Im16UUE2MXhqNGFhYkxrNHpjQkxGQVE9PSIsInZhbHVlIjoiNlRjblE5MDBIUU9BYnBWdXBpKzVsUkNnZnQxODUzYUt2dW9FVXFkRGNnUlRuTHJyaTFoUlo5b1lqVWp3WUxQZ0tyeDVyamNQM3lkMFNSVmE0Rk40eFBVZjZuUC81d2Znb1hNcTZsM21SN0VxR0U3ZDU1MmgyNktycC9mQi82ZGJPL25zQTlPVE8wa0hGYmhxN3Y1eFJVaUsvMFhTZ3NoS0hjVko5ZWNBbE9EOHNabnJxbzlqTlJnZTlqeDVCb3JFM2VEa3NWTkkrdm9CbDZadjFhOFhmMGJ5L1BxZlVjNDZ1WFQ4NTh4bWY3TGtKak5XZm5Zd2xDMm1xc2hkOWZmSmtHc0ZNdFE2dHpLK2VXSG1aL0xjN3RENkI0YnZRZk1TM01BR0M1Nk1OVVBmNDVaTm1OTzlwb1JZK3cwKzQzYW9tQnhnK1ZLZjZESU9tNTVhSWpVVE53PT0iLCJtYWMiOiI4MTFiODNiNWVmYzRiNTk2ZDM4MTc2NDVjY2M5MTNmZDhjNmM4Y2Y4YTRjZmU0YjU0NzI5OWExOGNiMDlmMjdhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, CL, ID, KE, MX, NG, PE, PH, TH, VN, ZA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:09'),
(676, '6k2yo3grwz', 'iPhone 15 Pro Max', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IkxCM1JuSzZkUzFTZnorejBmeS94b2c9PSIsInZhbHVlIjoic2lZZkpUSndRL0E0bXJlZkpxaU5ZdHlrMUtkR2xDMWRQQ2Q4VDBOaWF5Z1NsV1JMaCsvVkNrWDBWMkdDRFpoSkx6aXhWNzlXRDdOQTR4ajNhdnh0NS9uNkM5L3RlRWdrUkNJUVpENWNlczdSanRKNzJkVXB6Qlg5SUFxRlg2QkxGZ0tSWHgyNEVJMTJ1MmdBakpOUkNIaG8wa043OHVOTHlLZGVLS0s4VHpYTzZzR3NQOFZWbFJ5R2t2TFdiNW9VcFo2OFA5anZyNGJpNjl2M2JNenUrbnhVU004eWFNaW5WeEJ2R3FIL0xxd2ZKZkpWYUtHS01KQkZBSFVTbGIzemd5MVM2SUNweFVTbHhpQzU2Z09oUzIvZngwTzZYV3h1cENjRVdMLzVJcWE5cGVodjNkWnplcGxuUGF0OXRmbmNTN2M2ZDNTMHY3NkF2RGNLYzlSU0pnPT0iLCJtYWMiOiI1MTAwNmI2MmJiODk0NDJmZWFiMWFhZTZlZmYzY2YwZDI3OTJkMjRhY2I1ZTgwYmQ4MDJlMWFjMDBjZGY3MmVhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CG, CL, GN, KE, MX, MY, MZ, NG, NZ, PE, PH, SG, TH, VN, ZA', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(677, 'vm20r3kd27', 'Flash Light Works', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IlErM3VuTS9jOVhTbUdYN1MycDFMaHc9PSIsInZhbHVlIjoiVmVVRFlFamJ4NWZEUWJiWWhwdFhYbU85UGJnZG1ObEZ4REwyOWhpUEVPeWFmQjNPUnM4ejhjUnNJcjNFN09sZk00RFpNbG5PenJFVyswUGNWZ0pSV2dSdFhCVFlMZnJLdDQ1MDhsbmdiVVQ5azZzY0k1RENCckJjeW9CZTJqaGtja0ovRnFPNmorZ20xRnQ1b2tGYTZSUjhUNFM1Zk5mbDJyaWVJYUl2U3Bsc2Jzd2lGU3JhMHgzUjc3NWk0UlNRWlFUdSs0OU9mRjFuMkJ0UlpwQnRyU3J0OXB1d3dLSGg1Q2xFSkx5VWlGcmxYZ2V0TmVTWmh2YllLTFZRT253Q0NmOTM4TlQ0L0R5YmVxckFUTkQvSnlpNWJ1TkRNdFdodkhnN1dHTUFIQjZrWFBkYXBJK1lLd2w4Y2dORnd4WTZERTB1SGpjYkc2K3h1M0NPSHFEWGNRPT0iLCJtYWMiOiJhYjZlYzcxN2I1MGZhNGJiZDM0YmQ0NWRjYTNlMTU4ZGUwNTUyMmY2MzNkMDE5OWRmMWU4MjE4MDMwN2MwZDA5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(678, 'j05p394e24', 'Craftsy Classes', '', NULL, 1.51, 'https://notik.me/api-redirect?token=eyJpdiI6IktCY0pvdWxsblBnUXhYenVoMThTbnc9PSIsInZhbHVlIjoiakpGTlZ3UjlsRUJoYm8vU2I5bEluWnBnUFJKWHBKNXFtOVY2RDBlNlMzYTZxMDIzWGV0UkswaWpNdUNLb2k2M0lZYVZVMDNDMzVIcEljSjc1RTN1ZVJWbXFmMk9xblNGVVoraDBSOXptQUNxVytDdkMzU2NLVTU3MjRkK2xPWnhTR3F0Rlp5RjIrRGUyN28vaERtdXBidlF6anhkbFdoR2VaSWlGSGxOVjI0U1h4Q09kZE5PckJVOFArSzcxcXJxeTUyLzFLcUtPTUZLbHoxQ3pYNGI1TmVMVFp2QWRrd2dGeTBVSWRyWGpKREgraFJob2F4NERZbUxwSGxHeFV4Vlp4bEdqOTlCTWJSL2xnNmx2dm5zZHRMaGlpRnEwQXJNTngrVzRkREMyZGtUemdzbWlZcW9NMGFWNDgyMTdBVnUrMURpSjY2T0lVVE51ejI3YU9VN0NnPT0iLCJtYWMiOiIwNDdkMWMzZmQ1OTNlYmE0MGQ4Mjg4YTQwZDY5NGY0YTJiYjEwNjEzZjYzMTAxNWE0MGJlNGZiZWQzZmJkZjdkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(679, 'jy2ro3972q', 'Hungry Shredder', '', NULL, 6.72, 'https://notik.me/api-redirect?token=eyJpdiI6IlFadWUzYnpIV010SUtueEFTY2lnekE9PSIsInZhbHVlIjoiQWJ4cko4clFkaThxRnZLTm0yN3hmNUI5WHM0M2NVNWpPVStvb0ZiL1c2STQrOEFYcDE2WldIaTVoYWh3VEVodGxkNGFHWXpUTG1mYkFjSkxLZ1dNakc5dFAyMmpoTUhJcHdJSXJIeE9udVdxanZNTGFiN0dHUElNS0tXZ2cxQzVPUUF2S3haQWkvM1RxNGVXdmhQanRxNHFjUUpjZHpSZzBYR0twU2p2ZmQ1dnkzVm55Y25pNHVKRkdDUkFkY3k1NHJXcXFKY3kyYXBPbkMrMjgwNEhoaFc2dVRBd3VrNE8yTGFBOWpCYm5qeTUvZHRVYXVXR3dmNG9GSU5DUlpVUGhBaTZORVN6dndGQmRyakJXSnZPZnpCRmc1SE9CYk9ZOE9zb2dRRWErS0ZMQU9Ub2FaWW1zSkpVSUtVak5tOUFtTXZ0b3NwVHh0ZTIvdlZtZGVvSnl3PT0iLCJtYWMiOiJmMWQzOTg4YWY1ZjYyMDFhMjAyZDUwN2U5MGMxZjg0NTBlNTI5NmJkNzYyNmU2YTNhNDc4NDJiOWFkZDg2ODY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES, IT, AT, AU, NZ, AE, FI', '[{\"id\":16020,\"name\":\"hs_player_reached_100_hight\",\"payout\":0.016},{\"id\":16021,\"name\":\"hs_player_reached_300_hight\",\"payout\":0.028},{\"id\":16022,\"name\":\"hs_player_reached_500_hight\",\"payout\":0.156},{\"id\":16023,\"name\":\"hs_player_reached_800_hight\",\"payout\":0.764},{\"id\":16024,\"name\":\"hs_player_reached_1000_hight\",\"payout\":5.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(680, 'k15one1x2q', 'Egg Catcher', '', NULL, 0.29, 'https://notik.me/api-redirect?token=eyJpdiI6IlB3eEhIeHptM0ZKUjZxSGxkYUhQdVE9PSIsInZhbHVlIjoiWkNIRGhwYnRxUWFmS1pXdU9OKzJ2Q1o5bzRjSEpBdk9maWoxWTF3MVVhNU9ROGYzVnFpQUZXN0NaOTJHeUw3Qm1XK1BzTnEvU2RHZ2FsRGNFV1g1b29GL0ticzRaMzBLaHBaOHc2c0xMRmt3dXltcHhHZDlZZHVhdE5WYnBJa2kxUUxSbTJkTDlib0VyYnI0eUt5c2R0RityRmhMQ2tHMzRaY2ZXYmdMVjkxNnM0REdKRUhrTXY5K0ZxSWhrYlhHY1cxN2VmSUdoQ3JpWFc1YmpFQjlwcEo5cSs3clUzRzRKWjladlU0MkdnNzMrUE84U0pDamIybVVESUsxNU9BRzkvdVVQRitXZFNUcEFQQ0NzbkVMU09maERyZ0RiYlVOKzVBMFVXWVZUVHd0SFlpak94RmZSYThsODUyUU5aNjVWVUxlQ2w4SlpPdklPN2l1SURnaHh3PT0iLCJtYWMiOiI0OGI0YTBjYzcwOWFiZWI4ZThlY2IwNDBhNTMyOWZjZGI0NzY1M2ZmNDllZjg3MmFhNzY4NzQxMDI0YzJkNmViIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP, FR, CA, GB, DE', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(681, 'xr5edkz42n', 'Sky Plunger', '', NULL, 0.45, 'https://notik.me/api-redirect?token=eyJpdiI6IjIyV3cvdXQxK2xYcDZTMEZiQm4yNWc9PSIsInZhbHVlIjoiNkw3Z3dhUXdVYXhVcWZlVUMzR2dsVGFVSG96akwrUjIrUlJ5V2pmRU9GY0ViWDk3Y2hkOUV1MUhaUUdOa1Z3d0dtVW1HSkRER2M5RzNTcDhLN293bkk4Z1ZSZXl1VDNFdjM3aFI3TG54eVA2QXlnd0o2N1pYdDVNcUhaaGtsMXFrR012U01JVmVBQlB5MWUyc1kvQmtmOUljZkg1R1ZkellSQXc0aVo3MmJyUEthVklzbXdYSUlYS3pvMWtRamYvc3lJZEZKVU5KYWlaaFk0d0FlYXdjRzdaSVFsOEV2cjdmdVBDaDlyejZ1NDdjZER2RWVsT014d1RYRVZPMDFwUnNSb1RvQzY2cW9MSG56ZHNGalBHU3psUHBFQ1VER0tnV1V4MnBXeXltU3RuVVp0R0F2c0JMaEJiV0IzQTFaakZsUU1rV0tVZnZzQmlyZXphZmVuYzBBPT0iLCJtYWMiOiI2NjY3YWE1NTYzY2NkYjQ4ZTg5YjFiOGQ0MWU1ZjdjN2JiNGVmMjBkMWZiZjU5MWMxNzViOGEzZmFiMGM2MDY1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(682, 'qx290x3o2y', 'Sky Plunger', '', NULL, 0.30, 'https://notik.me/api-redirect?token=eyJpdiI6InpyUFNETGNRMkhHSDdEdlpyY2ZZL2c9PSIsInZhbHVlIjoiSFU1aU10ZFpNMTFGNGpOQ0JlUEV5U0tiMG1OaVNYdzJyZXJBbzl4bXh0Y1Rxd09SdU5EVitwcGkxaFlrZldOVmVWL25GZXJPemNwMTZJdEQ4M0J2eTMxSThSRGlWcHpVbWRKTnhtbWJsZEZHQnFDR0Z2QUZ5eld6emtNVEpvK2hySmpjbXRrSVE4UmU4STBwc0hvbExLT25RS3RCZ2tiYmRVNzgyaXZjWnJRN2NqQWhSTGMrbjlrdkl2c1ZzaWlkZWJQWW83Tm9EZDhWVUlHcCswNk9ibWsrcU5hamt1Z2VVc3puVHVLcWp2OWJsZjc5WmczdG5UZGRRV2Npd2NwaXVqZjhoYUFhMXMvRWkvRGxMVlU5ZDh0TERtcFJ1RHdLN2dBYks4QzNpY1NpQzZkQTlXS29XNjFWMjh6KzZucDJ2K3NGa3QrK3ZFamVpaWE1RlFTMTFnPT0iLCJtYWMiOiI1OTY4MmNkYTFmYzNkMWEyMGY5YWNiZGIxY2M4MjMwYTVlYWFmZmI4NDlhZDA4OTViNGY0MDI5YjI1N2MxNmI5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR, JP, DE, CA, GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(683, 'oq5zv8jr2v', 'Content Maza', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IlZIcWhQK0p6eU1naU05cVVZbnR4Wmc9PSIsInZhbHVlIjoiSllmTStER1NBUkdMUHJjQlZwMWlQSFNYczBpVHkxVW9RakZCV2tnQlNJeHQ2OW01eEFxTG5Ya0NibURBUTltb3VsNFRWVTIrUWNhMldkaTk3TWlUcUtCVUJYaUZCNkxkUkNnZlR3NXhmeXNxZHFqeXpuVEFjcDlpczhvbXdHZkFCaTQzVkJKVnBhSU5NbnJyMHhVam15WlFZY250K1lJc1UzMk4xUUVpaHkzdjhmL0N0cDZqSlNndGNaNkZaQUd3alZHVUdPRmVPaTNMRy83Z2FqdURSczlnV2Qway92ekJGYmhjNEl6L290TUFPVklNLzJ1dUU5Yko3QjNtWXBHcHpTQmxoRnFPQlFMcjJDL1dqaWVPamozUzgvSFdPck5FcExGb05IdUhCQjB0c0JpM0hkSkJhbkxzc3dVdXp0VDNiZDVnNWJvaVY5bFJOSWZzZnVGdVFBPT0iLCJtYWMiOiIyYjUyMGE3ZmQzYjYwMmQyMDg1ZDcwODViOTQ5MjZmMzU1Zjk5M2E5MzIzMzZjNjQ2NzZiYmFkNjhiMDE4MzJjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(684, 'j05p3e1k24', 'Content Simic', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6ImlyeGc0WHhOOG9uR05iMlJDTGZXelE9PSIsInZhbHVlIjoicHRXOXRLaCs1aFhSZlB5L2VoZmVoN1crOVNCOURKM29Jd1VubHpLQzNCSitrK1VkWGRWOWhvUmZCWm9aL0w4L1ZsK1J2N05qQ2V0eDJuazByNUpoSjJDQlZHQ3NzKzN0dWtiMExlOXFpUEZsOGZSOHRjVWJXMVY3aVROelY0ajYvdEdoRDYzVG1JZHQwVzEvWm9veFNqaTgxcnZIenFQVk1aTG9OdmJha3VVQk42Q3gwQ3A0eTdIR0RGYkxGL3JWTHRJTW9tTFc2amhoNkJBVnRVWTRLNlFvYWZZK0NoU09FMlJsRzNYMGMrblV4d216WThXWTVMclZGT1A3aW9QRE1SbUg5SkR6Tm85RVdjbExWekFZSG1nSkFqbUs0SDgyQ3R5M2Q0RnVIUGFpc3FYdDhwZzFzbEQ0VnpiMWpuTHZnYWtWVW1tcE9KRG9UdEVtZ1A5eGFnPT0iLCJtYWMiOiI3NmFmYzRhYzEwMjg1MjNjNzA0MDk3ZjI5YTIwNDRiMzkxZmJiYTZkYzc5YTg5MjczY2RiZTZmY2MxM2RkZTRkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BA', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(685, '8dwkx9qq2e', '300 Free Spins', '', NULL, 0.13, 'https://notik.me/api-redirect?token=eyJpdiI6InpKTUxJRXJwRnNPbjNJOTg2YzZ1S2c9PSIsInZhbHVlIjoiS29CdXlobHdhd2dvQVptRmVRZ1JTaHNqR3VxOG1yc2pZd0FGZys2dmkwVE5aTmZyYnpicEpuczZFclM4RE91QVAvOHVKSVJTbzEvVlRFbklhTVk1eC9MQUFyWUpZTUZnLzBSenNYWFZZZ1N0Z25wSjk3WjltcGhYdlZOSEZMbTlJSkxDQmxzUDJ0SnlQVCtOTEpvOW94VlczOFhkNkxIU2tTS1NDTTR6RWJSVmQxVVBLZnBKT2RIZ0RFUmk4RkxZbGhqUExIdjFiVHZxNzhQU3lzUlAxVkJXUTU1c0pWb2FiRzRiaC80SkhOampaZCtGVkFsWnZaZE5SK2hkMzZqOVdDajRlVjh1Z0EvSmx2VEN1cEZ5VkdDUXJoYk1GR1hwRllkazh5K1hJMTUzb1dxVHlldUZzKzRaQ3VLTEZUTkU5cXNSWTlZbnZSb3dXNjc2czR0Z3VnPT0iLCJtYWMiOiI4YjFhYTczMjIzY2QwZjczZjljN2JhMzJiYzg3MWZjZDk2YTk0OGEzZjNhOGYzNTMyODJlNzkzOWRjYjkzNzRmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(686, 'vywxe6gm5q', 'Cryptomania —Trading Simulator', '', NULL, 0.16, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9qOGVJc0J6UUpYanFMWVY3T1FibVE9PSIsInZhbHVlIjoiYk5KNE4wcGtxbnNBRzJnRHNyandGTFhKWGg3ekc0UlZlaDNvYTY4Ri9RbGFkNnQxbzNrSEtVeTRUZFhRS2FySjI4Y1ZUUlFIOXlnQUhtUG45MzBrbHlIODBxbTBlYTl4ejF6WGlsVW5qb1F0QmVGN1p2Nk5WQzJLWWE2cFpaM0IrNHg0dnduM2pzaHE4ZlVQTGdTTFZMRERidFRUa1UvQzlGV1NyUThmZERiTEwzK21NUklnYVB5V3FRL0ZTSFhmOU9wbnkrRUhVdWswSFlBc3lzWk9QODE0bGZ2U0FLYTVyTkdyZ20rODlpeFpySHRuemt3NlR2cnkzRlFpMnVtcUdTUDBwU3ZxbVJ5d2xVTVdSQmJncUpzZmlaV2JnM3N2Zk16bEhFZ0FYTjh3Rnk0a2kvbDZJSndqSUpsVDRTbGVUWkw4SjJCWDRTMUxVNFJaV1pFQU1KRWgyT05zd25uWndSakZmeVBtMS9FPSIsIm1hYyI6IjUzZDQzNjE4NmFhNWJkODNkYjk5MGNjZTg3YjEyMGNkNTZlOGJjMzYxOTRlMzg3M2Q4MWI0ZGNlMGJiNzk0MGUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(687, 'vr5mde4d5g', 'Kikoff', '', NULL, 4.20, 'https://notik.me/api-redirect?token=eyJpdiI6Im9ra0ZhNGJ0NUpRWVVnNmxOV0dlS2c9PSIsInZhbHVlIjoianBlNzJhY2puTmE5eExLWXpNV1BwdHBUemJYd3VtWS9wMVlNMzRtNjl2eEtzY0JTaHpTVzYwWnFMMURISEFDanFNU0tTdmVZUjRiMm5vNHJQNE93UzhLMytaaitYYWwydE9POWxkM0swcWI1RmZSTHAzQU83cVpiMWtsdTEzWXIwVHg1Q04wOGpSNnU2N0E4VFJLdllDTnYzWXlXZU5GcUtMbXVmSENjNy9PUy9SZVc0UjI1MmJiUUkrMkFDRHpvN3p2UnYyWjhsQU50ZGNyUVBrNlFHYmU4MXA2ZmhQWlUwbWxKZnBsbVhvK2RxYUVXMFNCLzB0alBBWkZWNkNRc0lzZW5BaDA5RkkzSHZwRWhxVnBKeUFvbTFSbDQxeWpsUFBYenBNeWZqQjY5NDFMSzczOFZxMzRTL25DOUVFZTkiLCJtYWMiOiJlN2ZlM2JkMzZiYmM1Mjc5OWExMmNiNWE2ZWNkOWU2MDg0ZDY3YzVjYWQwNmVhNDY5NjU5NzNhMjE4YmUxNmVmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(688, 'qx290x1x2y', 'AVG', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6InVYcjhnc0g2T1lia0ZIbG5HUDdneEE9PSIsInZhbHVlIjoiZXg4ZTVBdzBySzUrTXNBdUEwYlFWWEhCenJjeXkrbVZMQkQxbWpTVGRYWGFKSm9LOE5NWUM3TG5OcDhUcTllR3FPUlJpQ2hyMlNnZmVMTXREVEpZVTVEMG5rNTNzNXZrdlVBOHg5U0Fhbmg1NENXSHpEMkkzL3J2bHpXeFNQR1JoRkxwZUNvTy9NOTE4aFN4bUFHZnQ3ZjQwR0x1MzNPU2I5a2NMaExjUlFzMUJEcG9xeWgrRmJsc29LdlEwRVh1cWJFOTR2aFRqaWRiSEhuSXA5MlZYWVY0L0hDRldmUHcvQmlnUks5am9NaFRkRzdiVzUvMWQyamZZNy9rQ2RlQUVjSEQyaGtWcTQ5ZmhmeFRBb1ZOVVo4NFN3RlVvS1plY04zNk5nTDVDZjVWdm92eStxb1FrVnZFRnNzWnptbjQiLCJtYWMiOiI3N2MzOTI5NGM0NmE5MzNmYTIwMjQ1MTcxODE3YzljZTkwYjJhMGQyNmE5MjNjN2E5ZTc2NGEyNmFhZjUzYWYxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(689, 'gq56r8105l', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6InN2RGN2T2kyRXFhMkgwL0k1aWRqTkE9PSIsInZhbHVlIjoiYjdRUHFTaVl3WEJyQSsvOEhRZ1BDRThmZmR4WkNZd0dka0p6TG1EVlFsaTlXcW0rRG9mRlBmSEJSdElmVytRYkpsNThnZjRmY0NmMExYMXpua1RGcFNOSnQxTUp2QW9lbFFRajdXMXd5R3pVc2d4TVc0dXJ3dC9YTDVCWUNEV2RYRUo0aEd0SlNMQnpSU0N1RFZNSXVHcUoyak1KSUpXYjdWTkxxOHJVUGliZXRDQjY1M2xOdHdQRXFrL1ZlM0lTdXFUUDlqcnlNaTFhd1QvTVgzRFBtSzJ2Z2l2OWd3S3phZmltQUJWSE83R1ViWFduQklwaDNleXFOb0MwT29ZeW45RWpUMzh2VXVpc1FMY2FQcytoOE51YmhRQktzSER3YTRIWWsvbXVqakJTdm1NbUN5STE5ZDlFc3hoMUxEQk4iLCJtYWMiOiJjMGJiNDAyMmZiZWY0NTZkNWQzZWFiZTAxODkzYTRjNjFjZTdhZDE0ZTAzNzBhNGY0ZTJkMjVlNTczYTVmOWJlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NL', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(690, 'x6w3076vwo', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6InRtM3pSSkkzeXEvUEhzZGZJci90N1E9PSIsInZhbHVlIjoiMDJSeUExRW5SVjdjYXFycEEwWUQvSlByaDZpZ01lVTdHMDN1UzdScXZiZHRxak9lMytxcE5vRXc0OWR1UERjQlRNQ0FpeURjeGJlQk9BdFpuT2pnMnljYkRtTWtyZ01TZ05OMTJHZ1FaVE5LaHpOUkJ3S01JWGRFQnBsNWFaM1MycGhBUTFSbmpad3FvZ2FUamYvcjV6TDg5TzhpTlY1V0dXM1V5ekxBYjR2bjJZWHZJZ09ybmZYbDdPMXV0dGdpaEs5WmJySkR4SkFDTzgrS2ZUS1JORUtOVG1wTlJGazVXV3F5NndmTVBvL3pHZ2FmOFZQa1pkZXFPUTRwQU5NdFk4ZTd4VTRHSjFacHpYZWxWZmFKT2VOUUc1VEhTZFMxODJNemtjOHYrOFRpemRPSEc1eElUSDhMdHVGbzlRalQiLCJtYWMiOiI4MTViNjI1ZjQ5M2Q2NTBlMjVlNzMxNzFhY2JhZjE5OGFjNGE3MGNmMGU5YTIwMzhiYTZiY2Q4YTg4MDk5ODUxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(691, 'jy2roe0z2q', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IldMUGl6d1NydUthaXFzWUIzTCttdnc9PSIsInZhbHVlIjoidklhU0ZoMktoaTFrbmYzSjU5RUV5RTRFN1FJa3MwcDVWcFZjMFRIbEhISjB6SEx3VVErWi9IRjYzRXNOUnkwV0tBNzc4MUlQWHdUZ2JrTngrUiswcFpkNnZzNkVhZFRWbGp3U205citSeUFvN25qc1BFZllrSUZ2OUU5bWErZzl1Y1B6L0NyUVBZN1g0S0ludnZvVWx3b3BoYi9kY0R0SUpKbDEzSFE1WitiL3dGYWgrTmFyT3NZWGVBeWxhUnBYalF2TzljeHBjbDN5UjBORlhlWkgxc3J6eWFkbHJ4UURPU21hTlZLSC9CeHlZL1RmbjJvSnNoek5md3lENDhDQUo2ZzVkM2dmVGEyakpOMkxlNXppcm95MGh6eDdwb0E0QXl2TWVEVG05UlpFYUhsUzNtOEtQbVFrZW9MMExxc0wiLCJtYWMiOiIzNTM3YmY5NDM5MTZlZDgxMDdmOWY5MzU5MjhhZWQzZmFhMDZiMGFjMTZjNDk1YTRmZjU0Y2NiMzFmZjllNzMyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(692, '642qze8x21', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6InZ3THpsaWhaYmYwKzV0eHVTdXJtOHc9PSIsInZhbHVlIjoiZUVKRGtuajVkdktqOGx2U2FpbzV5aFNoTG9SbmlRWnVUaTlOSVdjaVR6clp5aHpJQlVPbUhMb3lIdnJZQlg2WnFaMW1JVjhSZXNNS1ZqMGVrRDdKaEsvd0lWR20wc0tNV1VFYWFPQ3ZrR3VhcTh4eFpYMEswd2N4OTRqMXF2Qnd0Z3pJUG1qcnB0RHJzY1dWVXNRdm9kdEN2YS9JQnZicUFTVmU4Y2RraTA5OWFrejNDZFVpeGxlbjFSRGVnQ2h1bGZROEtTVGROWnRTWEE4OUo0VlM5MlFsd0NCaVNvSDBGOHFMTlZzWEdGcXJZZ0UreDZhMnkwL3p0QkdhQ0p6eUtoanNKdWVjaC92OENXb3F3TktGb3hVVnI0dklBTlJqV1dENmE5S1gyb0p5cnV1TWN5U21LNmY4MHI5MmI5M1YiLCJtYWMiOiJkOWQ1NTgxMzgyMTI0M2VkYmM1OWYzNmVhZTY5YmZmZTAwYWUzMTgyMGRlNzYwYzExMjc5YTUyYWJjYjU4YWE3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'desktop', 'notik', '2025-02-26 13:09:54', '2025-02-26 13:11:10'),
(693, 'jg58mv1q2r', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IjBSQzhkd29CZFJ2a05zTXF5bk1UcXc9PSIsInZhbHVlIjoiYWNxVTVEWVFkTXhZOHpTOEN5M3ZQemlJc042Y0EyQldXcGJXWlRvZHMzV1JBblFLZ1BjNForSmtBK0xIK3JUTFA3WmY1NkphcVg0TWc1OTk3TDBOWkxxYktaVTBPM0NrRnJ4YWVmbHRtQm9VM1hqTzZZenBvZ2pjVngvcHpQTUFicUNpbXB6TFpVRlRtem5vMWxzd2RuRjJTVitMTEJCdHJzUFBtUVdDM3hrSDNuL0M1OWtNYk1nY1Mra1VRbkJabFdVRmNxcjZoMUh1dUx1WEs1LzEzWkhQUXU3WGNpaFkxZTlPWmR2NW1SRk1WT3N4WkJEcWl4cS9UNkEvQk4vL1NHV3A2MUwzSHhLWTFtdGJFREhOWnpKb2FpaWhZSVV3TFZ0cFpaN0ZZMFJnV2NSYmVWcDRQeVVtdXJhQXhBWWEiLCJtYWMiOiJkMzA1MzY2N2M5ZjE1MzQ1NTcyMGVhZTIyZGZiZjY2NGFiNTk2MmFlNWQ1YzlmMWNhNjMyMTUxYTE5MWM3NWE3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(694, 'vm20r4pv27', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6ImE2dmk4QldpemxsTk9qM0pHZ3RhQWc9PSIsInZhbHVlIjoiUTZYMThpTXRjVFFzTnVsOWg4bGJ2SzBOVitWMk0xSDNVSUg3SGptUUthMk5FcnF0VzZJTkVxdXRvbkxCUC9XV094NENFZW5sZ09ob2FTd3dDODF0L01SK0JBOWtldkhRanU1aDhRT0sraDNyenB3L2pTWVE3MEltQVJUOVlyNElwYStIYnN6NlJ1djBIaHIwZ3JWVGpkUFBPVVVOS3FUSmdsN0piUm51WVUrOWxsRmxFVUJKdWptTU9QWHF2NHJxVkUreEY2R3RobFZFRURLNXRuNElBb0lDRkpFMStLNGM5NXFyVjdUWEJ6WVhZazZWUUEyRGJ1alZNdyt3Skc3cVprUUV5cm5BYldtMGtHOVpaY0F1V0ZuMUdoN2Q2NEVtQ0tmby9NVnVobkhDVUIreDYyZllGR3Z0eGJ1SzBwNkoiLCJtYWMiOiJiNTU0YzBlYTQ5NDhlN2IyZDM3Y2I1MzcyMzlhMmM1MzBlNWMwZmFlZjZlZWI3MGVjN2U3M2ZiN2NhZWJlZTVlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(695, '3xwvre3z58', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IjZOeXFXMkhNbnhTSnVzSU1PQTVaT1E9PSIsInZhbHVlIjoiZGowSEZuaVNFUndDS0RibEMrclpjMTM3OTBoNVR3b3ZsMHFuVzA3ZUtzQ1lBajNPaWlSRGs3SjZkcGZtT0t6TGlwOFpFaVNKVUdITFdncU9tbnJDL3Q3d2VSRFRwVk9NTVQrdVByb0Y5Y3lDTk00cHN2dlBYdzFmbEFZMk0zQXEzUmt1VW04bDBrZE9OMGJDSVo3SUFjUEJoUzEzN0FRVEJxR0dMQmN2VFY5ZlQ3QzcxMFpueGg4eEJkb1R5aldKMXNSM2cyemUxbmJFMU5oYWcyaHF6MzR2aW5BUTRWMGd3ZGNCYTUxbHAwbFQ3UlZIZEVZTCtJRkc5eFZ3aENuNTdFbktqVHRYV204dElPMmNON3FjQTVOVVl5YkdJL1BJQ0twZ0R2RFlyMW8zdlBEQ1B4d3J4NklCaHNGVWJCWjQiLCJtYWMiOiJkZDE2MTdjZTdmNzBkYzM3MDQ5OTAwNzk3ZjRjOGNmOWMxZjlmYWVjZGZiMmQ2YjQ5ZWQ2MTlhNjJhYmMxMGY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(696, 'vywxerd85q', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6InBkUVI4R3JXY254c1BBN25hMCtNK2c9PSIsInZhbHVlIjoiV0xsc0diTDYyYzVUak1oWmNQTjBKMEdRejRNcUhUUmJncGZ5a1YyN0hKek9xYzI0dnhudHNJcnJSenQyKytaaE0rbTI0TGZMYWo0ekk1NmgyMEU1NnhrSnF3UlBVNGtTMThZckNMaEl4V0U1ODZUblZXdUtpbmdJa0JqS3RScmxhN3Q5MDdGZFBhMHlkNzNUNFNOTEVERXo0dWpWMXpCWDFYVFkydWJsTmdaekh3K2k3UjZVeWNwaDlvd3M1N05uWlhGTEpzNzg3ekc3MUt6NUxNRFRRSG9nTU9TQzhWdUthK28yZU15M29Jd29PZkIvMldudFZuR1hBTWlRY1N6QzRMWWZjamhtcVpBeTdWQWdjM0pqaUlHdytIalJycGU5QlRMT1BzSWhSYVc2WE9CZUh1b2JzTXdQMnpwV3IyUDYiLCJtYWMiOiI2M2QyNWFiOTU3ZjY0NmNiYmI4Yzg1ZjRjNjA2ZGFhZWYwODQyMDAwNjc3NDEyMDVhMGY4Njk2ZDBjOTU0NTc5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(697, 'vr5mdeyd5g', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IlhUemRaVURQWnRGR09sbWxyUmFIOVE9PSIsInZhbHVlIjoiVWVWSEk5RTJJSDFxMlVOV2cxL0NZakJLaExGd1BmYkprVStWaVVsNk16a0VQOHNYOUF1RkdZSGdwNFJOMVJHMXRDbFMraloxeU9WNDFneTlPblVlZnA0L1NrWTBSSTVQdndmVnZiNk5HNnQzSW9CcjlXSXh3VWpJcnJaRWQ3dmV0U2FIamwvTUJtcmt0Nkw0bzdYNmJrV0FZNVlicmJjbjcxWFdVamxHOHdRNjVwYzZ0MWJ4NS9xbGdENGcySmZnbk4vN3dzdHpBdWVFMWtvdFJjZythRk9sSVliSDdBQmZtemVMaGpUdERQeEFwdUUxcTlLbHZ0ZGxOY2wwNXBPTW5yQ3RzdytrUE05dzVxZWVQamcrV0w2bkJqa204NXl1bzlORndlNHh5SCtFUmJRQklmcHhXeU5TWFA2eWpZLysiLCJtYWMiOiI2MzI5NTliMGI5YTRkYWVhNTI1YzQyNzgzNjI4OGJhOTM3ODRmNzk5ODc1YjUyMTVkYTY0MjU0ZDA1MmQ2ZWY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(698, '6pwjde79wn', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6ImhORVVHa0JacDR0dFRCY29KOStYS0E9PSIsInZhbHVlIjoiVXIwN0F2UXFjNlJtQ3dZUE9yUjZBTWNoc1RFVjBWazVSS0JzU2tXcExKQzVGUUc0eGQ2QzZYVm44TjVYbGdSU1E1S1YwYU5wK3NkYmFRWnBkbUd3M0hYZHdXcWNyMzFvT1Z2WXd3YVVab2JWYU1wU2tyVFoxSlpMOVJMYXdZcTZKR0pTcHFYT0FXc0VSRWpYRnZvUi9GQXRncE1hbFU3VjlKLzBTSzJJVTV5bEVlcExJT05IOEdCZndocEpIejBXaDhsK2lRSkwvbUg2MVQvaTJXOFhiNFgvcEFiSnBzS1AyMW0rU05DWVRrTEhEa05JdGRleENMZXAzejkraWxqVmVYc1k4clRnbWJBcFR6dkxDSDBCK0h1QjJJSVA2NDZybTR5cUVEOTFiQTFpaWt6bUx1dGFrN1oranUrR0dYVWMiLCJtYWMiOiI1YjM5N2I3MTJkNjAxZDVhY2FjOTE2ZGI0MmNlMzE5ZjYxOGFmMzY4MjA1OGM2NWJiZDQ0MDg1MGE4NWQyMTlmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(699, 'zm2d3yegwq', 'AVG', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6Ik81QWdIMWR4aDRST1oyeDVHU25uRHc9PSIsInZhbHVlIjoiS0FZL3Vod3R5d0tidGRRSjFuTFowc1lCaGo2VGVaeUFmOU5ZK1VVQk5KNllDR2R4S3hJQUg2WklGM0JlZFJKekJPOFp0K1NHVzNZUFYwbVltc25aajk3SE40WE9ta2k2TEZ3cC8rNXVBOVV1NWpPWWR6V0hCeE5ORTN5TWpsME9uY2VTRThPaFMxU2lVVWRGdDJ0RGxEVnlZeUE4dXh5UEw2elJKUnV4bXRSOHNtS1R5aGtDdFRJNHlLTDB0YVF5WXpJNnV1TCtqR2UxZ0hzdEEydGQ1eXMxKzNQWnI3TjRteHNTTjRPMm5SQ3BDTEt2VC90UENZcTByc054N1hYTTZadUdncjdvUWNzOGdyclliMUJaaTNJMzZzS3F1WkVlV00yTEtyYk1kZSszc2dQbDArVUpPZUVwN1FYQWxUK1AiLCJtYWMiOiI3ZWNiZjAyNzgxNTE3Nzc2ZGI5ODMxZDlmODU0MmQ3MWJlOWJhNDE0MzY5ZTFmOTljYzRkY2Q4MmIwYjhlYTI0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(700, 'vm20r8zz27', 'Samsung Galaxy A53', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6InlaR1dsWjl5elFvRk1yU1N3NTVUalE9PSIsInZhbHVlIjoiQlhscDNycWhWbDFaa0phcFlkQ1BLUkcxbysycXIyUTRya2lPQVRDRWxYeDEyenIzK3ZIYzZkdSs3WVBuTW03ejMyaE1TVHl4TUkrMEFBYldaNW9FamtXUEF0VW1tMUhsQ2M0NFVrOC9mMGJaTzg5cVU4cldiQ1p6YThuZHE5eG1YTURjSkIyR3VQV2ppWWV3MEFwc1V0Ukh5cnpLOUJXMzh0dFdwMnBBcjJuSHg2VWJSZEd5V2VhMFpETjJJVytVUUxnZFVESTNEb1hYR1R4dWJWVXJmL1NnYnhRMmxBSDBhTmZ3aVkxd2FrZEw1LzNIcWV4blRGRXhXcGNacVRzVjJmcy8zMUZTUGVQUSsvcnhiNFdYcHlmTDAwY0t6MXoxT3pkeHNXejVuUjF3UEVWM0k0RnVJcUMxUDdIMmFCTlg3dG5CQ1hrZ2pWa2t2alhlQ2ZrYkFBPT0iLCJtYWMiOiIzOGNjMDU3ODgyM2JkMDBmOTViMGU4MDRiZTk5YjNlZTA0MDQzOGQ3ODVlM2FjZDhmNTI2N2E5MWUyNmM5OWNlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(701, 'x6w30noqwo', 'Generic Prize', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IkhrK002dU9TaW9jNE1wbkxla0hWcHc9PSIsInZhbHVlIjoiVERhK0ZIRkF5Y1BCNTAwbTM2Q0NRWVBpb2pETnYrcFA5R2pzcnJyeWNRYzB2anZhRGtueFh6RFVmUUxJOURyOHNZOERZTkUxeEsreThQOFVTdTFHekR6RmhHbnl3UmJBQmV4c3hUSUFjYmNSQ3RsdWd2bm9EWGN3aHpVb3d1ekMrRUZzL1pBU25zZ0xXQlVhdzVheDl4RUs5blZENUxIY3FJR2lLbVI2T001aFIva09Jc00xMGIwRitiSTVDcTRscUpRbDBqd2FQSjJTdmtIblI3MkhXc2FySVZOSmhCUmxaMCtIc29nYWxON05PR2dKTEx3L3gvSWVMeG5TYnVMNFVScG9OdkFqMDM0UEsvamFMNXlmV09xaG5nc3JBRHVrUXZtV2VocmxYdTVkeG1OQTNTQkVMV3Bpb1ZjT09ZYUxLdUxiczMvaU43WXVuanhheGZvbm5BPT0iLCJtYWMiOiI5MThkODZmN2ViZjYwMmE1Y2ZmZTc3ZDRlZjNiMzhlYTc4ODFhNDNlY2EwMDIzN2Q3NzVlMjJjNmNjZTUxNGZiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, CL, ID, KE, MX, NG, PE, PH, TH, VN, ZA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(702, 'qx290xge2y', 'Mystery Box Prize', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IjBUUTVlWEVXemQ2Ykw5blgxV1V0cFE9PSIsInZhbHVlIjoic0Z3d3hRSXlGa1FjSjgxajk0Y0dHWTF2K3k1VEhNMjlGVFhJMDR6aFgxbDdrbWhOVGxueGRXYVJjYi9uRTQ0MlJ0RDRvUGJSUWVpZ3Q2U3YxYWRUb25vUzFiREw1SUJuN2F2YS9iVnc3eXRDNjR5L0xLV0ZDVVVrZTVIUk54LzRjYnJUZXRKZmt2UGV2L2FRRS9BZUdTK1Y1Q20xTWJOWmQ2VW96QTdickppQzdyN2wyT3YxZ3VldlRGRGdJakZmTkRuRmFkTXJjMkFOa2N2THVTZVpUMkJDdldDNVBRb1RlQk1SNjJDWjVDd0xUVmVONTR3Q3FYbUJQdkFIN29VeTJyUElNNXNpTSt0TjJjdTJGSHpmWnU4aWNERjdiZjg4QS80YllMN0hPaDFCZHFhMXo3RlBqbmhINU1lM3dLcEZ6M2xDWHZOVU1lck5PZ1Z5cjk2dWJBPT0iLCJtYWMiOiI4NDMxYjFlZDc0MTJlOTMyZjU4NTZiN2VhMDY0NDgwYmZiMWQwYTFjYTg2M2YyNDk0NDM2N2IxZmEzODY2OGRmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX, SG, TH, VN', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(703, 'jy2roem62q', 'Content Deep Blue', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6Imk1cGxGR2hrVVhjNHQzQXNybnpWdlE9PSIsInZhbHVlIjoiQWEyUmIyLzYwby9mOWdUc29xc3Y1TE9qaFlQMlFMREVpOTBJY0lHY1pTRDAzNEJ0Kzh2Qzl5N3psYlIvQmxiZklUYWdnbG5pa3FIcnE5bHRvYkZaeEEzZHA0Mjg1ZHE5Qkd6c2JEV3dtZVI2eUh3NVZYU0hzWWFIcy9LVEwvM1h1Y0lGbFhlY2VaQjFiTTNwYW1yd21sNVlmRVliTUM0OUNybkljK1c2RDVUc3R3YWp3M1llaEZ5YmUzdkQ3T2NyaUZ3Mis3VkNldDZpVXRsV3puNFF4azBwOGVYR1plc0NBaEE3OFRTaW1pSGRYUDFXQlFwTE54b3J6dnpHb3lya2RLSFQ4d20rMFlVeXdmaHYwREM1eFEwS00zZ1hTWjJoY2l3dnFHMFVJSGkveUxwOG4yNTJWb3NnNGZpMHFJcjlHTG80K2UweFF1SGZkd0VsTjY4ZU9nPT0iLCJtYWMiOiI4NTgzM2ZkZjc5NTIwZmYxMDMwNjc1YmJhMzcxMDI0YTM5Zjg2NzQ5MWU4MDcwMTQ0OGYyMzYxZDAzODA1NzE0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'OM', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(704, 'jg58mvz02r', 'Content Deep Blue', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IkwzSVlQTHFlM0ppM0I2bm5EampMUmc9PSIsInZhbHVlIjoiMHpDMy9aNkxtT0RCeVhQV3N6WkZiN3Z2QWdZZk5HQytDSmRtVkt1YVd3R3o3YUU0Qm52YVc5ZXlnaTFhaTdCQ2JQSU4xbkx6UGFVQ00zR2ZoTzJORWt4ZCtYWU53TGJXVEQxYTNZY01Ua3BVNkV1VHBLc3QraS9FbXJRbXhaeTlOaW1qN01icUpNM0lxOGY2c2NVdTF6RmVGRGphK045YkcyNjN4cXFSMXZpbThZTjhLK3pLc0xraStHNjBqUmRHOUlZZC90QnZGQTg0QmtiVGFFaE1SV2ZpcksxWmlVL3hIdjM5N3ZEUXkwY2pVdDdTNkE5WFlNTUxHRWh2Wi9wYnJBdDhsaEJvdXBhQlY3Zi9LQ2FNME50WlYvKzR4N1ZlTTUvTVNzT2IzRCt4TDY5cUFPYnoxa3Q0K2VwTWljRDk4U2tkZ3pGZXZab21TaVBDZUtkcS9BPT0iLCJtYWMiOiIwNDkxOGE5MTA3YjAzZDM4OTM2MzM3YTAyODM2M2RhMDIyN2ZhOGZiMTYxYjE4NzVhMmE0MWZlMjI2MTc2ZDg3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(705, '8dwko96q2e', 'Win Makita Voucher', '', NULL, 0.41, 'https://notik.me/api-redirect?token=eyJpdiI6IjRmNy93MjRLRnNRUElPOGEzSUhpdGc9PSIsInZhbHVlIjoiSUl4UUtwWGU5akJQQ0Y1dmljUVFGTGd1L0R5ZEU4SDlCbWQ1NkpvSnhGRG96RFp1eWpwRExBU0FKRW13eUJDS2YxSDg3M2RoWVY1b2diZEc1RUp5WndUUUpHYnlKMEhyR3dud3lvcFB4YkFtQXN2cEtUb0NNK0hEYlhJdTlPcU4wZ1pwem5YOWo5SlY3anBlUHc0K3FFOS8rcTFMWUR4aUR1YzdQRStuVUpKamQvM0w2NXBaRlFVRm1ZZllCN2p2eXJlVGV1Y21DVmR3NTZvVlFDbHRlSXdaWWFCVll2Y2k2T0syTDlrVFBvQUxlR0NTSkdCRGMyaE1HeTJvUFNiSWNQVlZtUkZKUU5SVzZYalFBajltU1dXRzdYY0V3bC9BTWJJQXMrREN4K1NHOVcveG5mbXlnOFVuTUk0WEFDNDdpb3RkNUNCS3I0aWJwV1owSDZMdStBPT0iLCJtYWMiOiIwMDI1MmM3MDQ2OGU2MzExZjUwMjA4YThhN2U0M2VhZjUzMjc1NDAwYmRmMzI3MmQ4YTZmOGI5ZmYxOGJhZTBhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(706, 'k3w7qjz92o', 'Test aankoop Multigift Summer', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6ImtJVitiQ2tFT1dodGoybEZCRi9JTkE9PSIsInZhbHVlIjoia2Q0MUFDRlhZRStiMnU4TUNSZGd5UjNodHlxSU1FcG9QUklFS21xRU4wMStqRU1CUFlqS21WMUZMWVNLZXR0WmsvbUtYdW4vV2MvSHJGSDJvRTNLb2xNeFliU08zVGpla1lCa2JyK2JSQzdHWk9zQ1Nud0ZyUmhFcndqMEV0MSttVnNIdzF6dytOYmJaMmM4Z295VTNVdmwzNjkrSHhXVnlWUWN1d0pRNXFFU0UxSk45NDlDZjNZWVJwV2NJeDhZbThGbkdLcjFrWTJFcm5MdnA3RHNQNVVydTg0L2IwSnRHYW9vSkNtakFqcEVKeDE2QS9rMFYzaEFheEFvbEhLNjdHMmFxZStSVFF4UU9ObVFnMGlmZjJKd245M3QvYkxOdFhKZ01pK0pJZXFmakdDa2lJbnlDOVppb21udFJLZUdRQTF6eHZqZFFFdkVrUVBYeU1mZW0vWkM0SXcxT05rK24rVFhwUHl6YWpRPSIsIm1hYyI6IjFkNWNhZTgyNjJlYWJhZTUyNjE3YjdlMzc2ZDJmODA4MmJmOTU0ZWU2OTA5YjNkMjkwN2NiMTAwYjA5MzE4NDYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(707, '8dwkxnkn2e', 'Testachats Multigift', '', NULL, 8.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlMrRlcyWlJFckRKdE9RQkM3RUhZQmc9PSIsInZhbHVlIjoia0l6ZHo4VkJoaGppWDV5emI1SHNkOU9qa3R6ekg5dG82Mnc2L2wxc0lUOURWcXZrd2p5dk4xdkN5dktXS2ZnVytERzJlZEk3a1J4dnBoRjhWdnNTemk4WkkrOEJ4Z09JeGp5MkwxOGhqWE1HS0xBZGFKdHJvOE8xeXRqbGhOV2lab2VsS2RHbCs3SDFhdnoyNWcyamJ0cTR4ZWZlcWFERk5hbkFlSE1UVTdyQk1Ic05SZGNBMW5RMXdKcFpZdmZTRHk0NDEwcm0rQXptaWxzL1BObll0WVkweGUzM0Z2cjJhT1JUVDZDbHI2MmdVQmx3TGtmdmpFWFNPSC9EVklvNkhOWTF1bENDTzJyNW56NllGVHVMUm9ubkx1MlVYS2JIaElHakE2eWRZd2Z4TmFCSFZ5dWhXdElmeml0Q0h1YlpiUGxxb2krQldyZENlWEl1R2dzcWNBPT0iLCJtYWMiOiJjZTMwOWViMTA4NTk0Y2IyYzdjYmJmZGY2MGJkNzkxNjZjMGY5ZGE5NjJiYjFhZTdhYWMyMWEzOThiN2MxNWQ0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(708, 'qx290k4z2y', 'Deco Proteste Multigift', '', NULL, 7.16, 'https://notik.me/api-redirect?token=eyJpdiI6InNUMkc4dnpBUnFEVjBDY3k4bW9LSUE9PSIsInZhbHVlIjoid0NyaklLc0tEVG10bE0rN05OSnJ1bmJTQkZ5UWhsck5LZUNRU2pwNDVwV3p2VEM5cHI1QktEM0F5QkQvWHJVVzZlQWhHemtLeDFYTjlmdmp0V2hvTEkyUysyN244WllTVW9LYjRjd2ZBQjJZSmswMUJWYkJmSTE3clFaTHdveHREZmptWWIwT0ZqYWd3ZnFBeklJREd5cDFNZWFpcjArdDdhMkIwTGhIcnoybXFqeTRpbk5OR0hPOEtJdkJmY3FOQXpOOTlEekluY0xPZDB4TytJUW9YNm5UeFpsVW5wUmw5SENuU0JoZUJ1M3B3YWozbVE3eERDVzE1MnhuZWJ0MUlmUXF6REtlbnF1aGRzR3U2QUQ4WDVJSVZGM0hHSWhjVkVYZmVYb3NMeG5QRkxBcjJrc29oOE5zKytlYU9xdFRzbCtNTDJjRXBjdWtTY2NQbklBNFlnPT0iLCJtYWMiOiI5ZWRhNDc2MzM3MjFiNmVhMDlkNmM3YTI4YWViZTk5YTc4YzA3OWRjZTNiZDcyZDc5MDMwOWE0YmY3NGUzYzAwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PT', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(709, 'j05p3jxv24', 'x', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6InJiUnp5M3VNL0J1b0hSdDlyRStjdmc9PSIsInZhbHVlIjoiaEVZMWdCb244dEh5OGFjTVpDK2c3eWF5blY5TFoxcXM3T0xMY1BLcXFONEhwcVhQelliUlh4SzhvL3RIYVFBclI4NVVFRDV1aFBNZjIrSEd5bWVaMk52Z2xmaGcvQ3JucUpaNzlvYmZjRXp0SEdrOWczSFl0WmllWU01L1Fxenp2blFtbDZmSkx4bnlERzZwd24ybE5Na3dpOG5iWmNmVHJSd0lwd3lNQXZ0M1ZUOUVoekhWZ3VIWjdERmlDZEtMMzNrMFVJWkJDL1dBZHZ4c0E5QzJ2VnVGMzlteENiZ1pwdXlQdS9NM2trR2Y1ZWQrZU1zRXY1c0RPcnVhNmVmcVU0RWZ0VXJxdkFvb3VpNnRjM2w5NlpSWDhjODdvWGUvdnd6REFtYXg2UldLdnNnYThRN0lpdDhiaDFSSDlGMWciLCJtYWMiOiI0NjI2NDY1MDIxMGE4ZjZjM2FlZWMzMjJmMTM0OTczYjcwYjZkYzhhZGQzY2U0NTVmZjhlZTU5OTFhODZkMThmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(710, '3xwvr46958', 'Movie Shows', '', NULL, 0.45, 'https://notik.me/api-redirect?token=eyJpdiI6Im5nMnp0Z01Dck9rOXhKdlBOV0dDMHc9PSIsInZhbHVlIjoiV2hQeVhVTmFmTTIyM293dExpenpKK01OWmdtRUdqQXB1eTl4cDNLQXZpUVA5QVgvZ2dnQncrWXZwM2Y2dFB6ZWZkQ1NJeVVVczE5cXVucThJN1lOMDJzdWdTejE1WFd3b0ZRV2VOU3FZR3o2MVRxcXV1V2ZjUVhkcDVqMGo0b3JFb0lKZm9HYWRUYkNKZTlFbFJQWWtGY0Frb0I2azVyUVBhQTJNdUNJUjVKejZialpVb0RQcE9GM01yTzR0ZjRKOGJFdHJXa1dBR2g2NENrNnVTRlZMNGhkemd6SGdRbFpJUTVJYWw3MTJ6bHVrZnE0Z2doTlgrWjJOcjhVaGVlZkdBSk04MWlSdk83MzV4WUQrVVliU2doZ0kyTG5yVVBZSkFRZHhwa05xR1dXRHkydHd2ZDZFKzVadTVzTlFLNVBDaEttN0UyaE5pVUp0U3dXWVhra2tnPT0iLCJtYWMiOiJmZTQxNDllNmE0OGQyZWI4YTg5ZGM4MDM5OWI4MmQ2YzYyNDRmZmQ3YzhkZTBjYzJlYzlkMmZkNTJjNmMxZGUxIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(711, 'k3w7q0e32o', 'Easy Surveys Short - Begin earning now with paid surveys!', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6IkhXaVdxbWQrQ3JQbkZiZU1mckFTQlE9PSIsInZhbHVlIjoiVDRLalk0cVdoQklRQ2lORXN4MlBzZEJYSERtYXVVWmdDbzFEcXF0c3VSOXhVSzNMVW1rY0lhNnhJTFVVOS9RcC8xSGt3aGhmWUExNkozWEFxd2k0OUVIUm9iYWlPQW80Sy9wUWdnanBhZkNaRTFxNHVaUzUrYlBrRHFoZmJtZndXQVAzUndRbVZKZkR4cSswbFlxaFc4UlN5a0xacHIwVzdoUjJBc0YwTEp5dXh3TjBZQWVKUnVFdkJWZ3FSRnVwM21EZDdZNHV4S3o1dzdKOEFFQ0MweVNlRWllZktxQkF1K3VwT1IrK0dNVlk1UCtaZGNFNjBLYVhXNkFGT0REdFUvamhGNjlOUno3SUdoaXlva2VGQWE5ejV2TkRDR2QvWXZmVVh1VDFCTUlQK0ZUaFhPaTZXb1FBTUVVeitYV3Q3dWJTNUZYTjRSSDRBZVo1UENHS1pMbllVN3BhRjhoOGEyeHVRd2txSzBITEtlSTJBbzBWZGhpVFowZ1o2SVBwIiwibWFjIjoiMmQzZGE0Y2MxOTdkOGZjZjc1YmI0YmMzZTZhM2M5NDk1NGRiMDI5NDNmZWUxODkxYTYwMGQ3MDZhZWNiZmVjNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AL, AR, AT, AU, BE, BG, BR, DE, EG, ES, FI, FR, GB, IE, IN, IT, JP, MX, MY, NL, NZ, PH, PL, SE, TR, TW, US, VN', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(712, 'x6w307mqwo', 'x', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IjY3L0lpS2Zyc2trZjQ4WUZ6RUJlOEE9PSIsInZhbHVlIjoiSHczZk1TK0JYNEVKRXJieTFRaGNMMFlSQlVrQTFhaUlhclYwajhLbSthcE5XMFhKOEVkejFIblVBSE5iTzIxZEpLWmVna281TEV3azhHUlRmWnp3QlNIWStncjBmOW9md0JKRjV0V2FyM2M3cWNMMVBpTE9YSEFTS05WTk44N1V2Y1Z0SmVyYlZGVFJhRnlIS2tpUTc4TnAvWEVodXlYV3JFb1A2ZW9Fc0hValcwdUFoaXplVkE4a0pjL2djSXljZnRhWS9XM0VGR3dMckt2MHRDU0hsKy9mdUpuQ0R2RlZBbHRUdTJCNERUSmM2dTV1VHVNbXI3NjNJak05c1ErQmQzM1ZpNE5HMWxzN0dhYjkxTHhGZ2dPeE5PQlA2YzJuQmZ1U1hmL1VCdm5XRU9yaHhSUXVvcXBQNFBiYmZ6dHYiLCJtYWMiOiJhNTliMWU5NjhlNjAwZGVhN2ZiYTk3ZjIyNzZmNzU5NDVkNmJiMzg4MWUzMjJiYzZiYzkwNWJiYzgyOWEyNTgzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AO', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(713, 'jg58mvm62r', 'UEFA Euro 2024 Survey', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6ImlvZ0hkTk84N3Z3NXQwZFhXZ09FNEE9PSIsInZhbHVlIjoiVDJjMlVvS052di9ESzVpSm5aUElyaVlMTkplNU03eVU0UGFCWE9Xd2JYTjZkRDNOSlhaVTZpeHE2Y2xlanNwMk5RQnJRbVdORUNwV1BOQmNtZ3RlcEE5ak10aStrVWlaazdDRldnNDU2czBoMTk2YU1nODI5WHlMMTdXODlJclVGWUhSWE5URzV0d2xDMjEvZkpKTEo5NVhEYXkwbGpjSjNVbjFmQXYzR2Y5TnU3TERqcFVURHZWZEZENFBQeUYvVlBWZXV2cGI3dVZGWTRDM2lNUCs2RTlSdVV0MjVGOUpsdzNsbXRxQlRJbENnL05GOXJTMUpPd1R3dVFGZGkwNlRVeXFWd09LNGJtOGlGNExET0U5WGVJQ3RpYzIrY0Y5VkYwVzJnTlZqeHR3aGhmQ1FvVUVlNVBCVS80a1Mvc1ErR1RyVjJ1UFJ2R1JDcW8rY1FWemFBPT0iLCJtYWMiOiJiODdjZGIzMjE5NWY2OGJhMTAxZGYyNGYxZDRkMTFmZmU3NjUyZTUwMzcxNzZmMTI1ODhhOGY0MDNkMDRmZjBiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, CA, CH, CZ, ES, FI, GB, IE, JP, KR, NO, NZ, SE, US', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(714, 'oq5zvn8x2v', 'Games 24', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6ImZPbGdpRDdPKzFhT05LOElmclZGeHc9PSIsInZhbHVlIjoiYmlQUUN5aGFrNGc1bTkrQTlkWlJQNFRTZDIvY0lvVTZITDlwbWhIcFQvZVY3WU96OG1TR3BVVTJPdGsySmZIcEcxY1FkS3A4RkNDZ2xBN1ViRkxjbTU5MXZTK3JsU25LalBzM0V4dlRnMVRmbEt5bVo4N2xjMFh4MmRIdVpsTUJtMFVBTG95N2svYlF5aktvMXRiL2toQU44TVhVMkFuY3FDN3pzbHpBRkFkdnFxcm5TOGRNMjFTSUFEWGlqSTh6c1N4Nko3TG1ITnhCMWd4U3RISWxUVXFtTXhtSjk2VXFoMmJsRkxVQXBUeEhlYThLYmFWYVlnTHYyOVhBa1ltdGNKVWpwREt6NkZHVzNKTXpMT0tYcm5OdC9pSTBCTnhjVDJ5U3V0ZDFIenZOTWdqK3pTRFh3blNLT0FCRXFZdkkiLCJtYWMiOiI4N2RjZGQzZmZmMTNkMmIyNjVlYTNhOGEwOThjN2UxNWMwYWEyOTBmNjc3NmVlYjU4YTE2NzFmNzc4ZDA5ZDZlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IQ', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(715, 'y4w47rprw0', 'Easy Surveys Long', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6IkFZYTZJRlFEdFphcUI3MERXNXRKQVE9PSIsInZhbHVlIjoibmVacjNOVEFtZEozbkRaQTZwWnowQzJtdFViREVMcHBjRU11aDhTaTd5amc0TDU1alAvVndDMFNHeHE4MHR0NFNFNzNVUy80Z1hzUGJzNXhHZm5CZXJhRE0rZ1U2dXRVdG0xeXJadHl3V2xHcW53bzlnNHNTVGx6Z1dKMjRuWC9TdWNWYTQ0T2k5YUZISDlEZk0rdkpZbWc5VUI5aElISlh0TTZwYTVUNHREZFZ6ZGNBem5wcFRkTUtLQUY0cncyZXhVWWR5SEZxN29QUGJjMFVCUm9kak9Ia3hUM2NFVVhCTlZXZVdaNkRJRVE3QzRyVXNjR2lwY1ZGUDBTbXR5NTU0REUyN0hSZ0h4MlA3YXFGTmJXdWp0Uk02MGtxNEJIaWI5eDNZQ1FuN2xGQVYrYVpNMjVVS1dpcnFEbVVVMWx0Zi9SUzQyR2hIUHFMbDhqYThIRlFRPT0iLCJtYWMiOiI3NDM0YTgzMmY0NmJkMjlmZTlmYTkzNWQzODY4NzE5YTdlODk1MTI5OWE3ZTNiMDJjN2FmNjY2MjJiMzEyMjZkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, BE, CA, CH, DE, DK, FI, FR, GB, IE, IT, NL, NO, SE, US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(716, '303015-ZPwVWfTSwLIJu0B9', 'OhMySpins', '', NULL, 9.45, 'https://notik.me/api-redirect?token=eyJpdiI6InV6YXZVVVJ6dlBJTWhCOEJ6SVgvUkE9PSIsInZhbHVlIjoiTmhFMGhiOU1CQWJmNUtCMnIrNEsrOGxqeS94NFBDZWU5akhVY29tRW5HOE84eGx1R09SZDFqTGErSnFHK0tZcjZlMVdsRGhlZzBZaEpEYjJCZzl2Q1FzdlFsSlAySHVvNFY1eTNqbnJlb3hzWE9hb3lXSW9QOUUrMmN3dW9hSEdDblZZeTFFYU9BZ3hzTEJvUml6VHRpdllZakJaUFNyNVUzeFlpVkRHRWphaGdBQmg4Wld1K0s4U2l5RUJvZXNtZnY2dVFHOEhVaEZVZUdGMDlMckI0Y0l6UzIyN3pQb1ZRZlNWSTFEcFJ5N2V0UVh0MzdnTkxkSVE4Zko1RE1oQ1FDVVpMa2FGY1ZIK2M2emZVSXhVTFhrMHFBWHMvalJwT1NuWEo1NUFSdGdtVHI1NXlicEhDa1hlZHJzYW5Rb2M3ZU1JMkJPcFMxRGdQaDl0aHdqZFdKdldNTFhOVi9OZ3Q1ai81R1B6MjRJTEdpc1V4czYyRGZrbWRJNDJBWHV5Rk9INm42eStqYk8vMVlYR3VXNXAwcWZ6M3dDQ1MvWWpUTnhVWjRPZjJzQWlrejYvNU9BU0tBbEhXNGFEbUNsOSIsIm1hYyI6ImM1YTUzMWMyNzFkNDI3NmI4NmY2NmNkMThlN2JjMDkxYzUxY2JiYmVhYjU2ZjNiYWUzYmYzYzk2ZGNmNTk5YmQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE, AT, CH, CA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(717, 'qeOrUVQUXxPHhNggJLgI8-ZPwVWfTSwLIJu0B9', 'GreatWin', '', NULL, 10.24, 'https://notik.me/api-redirect?token=eyJpdiI6IjBWOThHS3FxMEgzQmlvTmFiZE81S1E9PSIsInZhbHVlIjoiTEtoSTJ1bmVvcXRGN1lqWkNTS3VDREVjQjNXZndpd0Nsc2krSzFlMU43L00vb2pxUFk2OXBtTExRVkpWb3F3Y3FRZW5GRmpIMlJlZDJrYkZzS1hnL00yR0c4RzQzeERrZFpQYU5LUXFiWDRWM0JQWnNoSnU1UGVxTXhKUHBGaUdrYmxYbkplRHlWMjI0c1BkNEs2S09uK29RWUVDSWVrR1ZRV1piUWUvT0hzMlFUdWtRMHBMdmdsUEhZc3JBVjRabmlZMkFZS2xaM2NkOFF4T1lZTmU4a2FqaURlejF6VXp4MldVblY5ZkJjT2h4YzlKWHlBdHE0RzdPMlNydnFmdFo0S1hVc01QWEhpZm03Rk5uV0lBdU4rWjliRStwSmljdWN5bEJTWHlBVHJTWHdnRk8rN0RoOXBqa0F3OUZmcm1FTE1UUE9BUzZxUnZHbkxQaW1EdkdYaE0rSjM2TmxYcmlBODBiUFUwZDNxVHVTak1EVU5oRXh1MWhtWDd1K1RYOWJxVXhmdmd3V1dkM3VlaHJESklPV0ltdnZhVjRtVWVobWU2M3kraDc3R01LMVRzYWVwSWJjb3VkT3FjTEhUSWxzZzBqM0dYbXNGVSt3dGhSdFVUR0wrNVFOa0VTTmkxZ25XYlFBYU5kUGc9IiwibWFjIjoiY2I3MjBlYTI3MjVkMDAwNTIyYWNmOWU5ZDYyY2RiZmQ5NTdlNGMyNmVkMGExYTcwZTQwY2Y1NzVhZWQ0ZjVkNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE, AT, CH, CA', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(718, 'FG_ZPd1YeKDaix2D7gWXZ-ZPwVWfTSwLIJu0B9', 'PARIDIRECT.COM', '', NULL, 0.86, 'https://notik.me/api-redirect?token=eyJpdiI6ImtjbFgrRW5yNnVEOFlGSWp1c3F0U2c9PSIsInZhbHVlIjoiblJQdjdFcmxYQitJVE1neUd5VHYwSThEbENUTnpMTnM1ekJxYlE2OFcxYmpBWUhSblBCdzNIdWp4c2JvckZ3dmhPN2NHM2VUQlluOUVWbWlxSXdsT2FBYWw1d2k5TVZWYTJJZmZlWXJrT3JsRzl1aGk0REFXeFA0VFpqc1VZbUovdU9PMFpJdUhLNHlmTm04Qy9FMlFIcmNBOFAvMUNVR1BRNUZtaUhnaEROcHhhaUJxNE5GQURLK2F2bzUrN2tYRm5qWCtaMGFwakNiQnkxcHNVTGY3Q29jQ08xTEJDd0FGd2NOZ05NRUF1RGJ2L2U4SzVEaGxaWVppYzVxRzlOV2RaUVVlRERJYnV4N3NNMnZkTUJSQXFXY3BJNmhhdjZDdm13b2IvbnR2VWdGR2hoa2RJVFVRMkNTaGNHRUhkY29ma2tyWDdra2lVS212N1hDNHhVclNiSXlxTjJ2K3Z2NmUvWW9QejlKMEdES1kwSlRUdnZEaC9ZOVpBVXF4NzJnbko2aHkvUURUQkExdFg3c3ZWeExzSytsVEZYbnhLelJRdVZpZlVsRGJ3R2JSS1hEQ1VlN2xubFBaTGpkRWUwc0dsUVJSSUxHY3Q2ZmxmNFRzcnpRcUhvbmIzamtFK29jMnpSYlprenhocnc9IiwibWFjIjoiYzE1OTU0OGZiZDYxNjFlYjY5MjM5MWM5NjdjZTkwNTg0NzEzYzViNTUzYzZjMTAxMDIzOWRlNzRhZjI2NjdlYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CD, CG', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(719, 'UaFTS6cpeC0vMHQBLXFjv-ZPwVWfTSwLIJu0B9', 'RichePal.co - Complete Offers & Get Paid', '', NULL, 0.74, 'https://notik.me/api-redirect?token=eyJpdiI6Imo5dUtENkV6K1B1NE1EbFNOSlUwRXc9PSIsInZhbHVlIjoieTdCVXBWRXVSa25YekhBMkpsaWpOQzlsVkFJd0YxY0NmUWRBc2NmZ3UxUkRhcTR0S0lTM25DTFF0ZDB1RTBUb3Z1UjR1UWdIV2dBOEU0dGpkQzdzaHBCMzlaK3ZWaXJPaWNEbDdZSHRwNDRrUldnd3RXNVJPQVBrNE9BVFNTc21EN25Eb1ZHVFJLZzNFbFp3Q1picnVVbTdHWWg3UEgvaFVsa01la3lWY2xKR1NVV2lBczhpYVg5RmM4Y3Z6blVSdnQ0d2lZdG4xS0dQVmQxc1NYTzAybDEveGNuRDlLbWw2SjJJL0VYaWVzYjFRaDFMOEI2LzBFN0tjbHl0WkE4aXVCOTFFTDBoTjM4SVRCN0RRSGxxUWhwSnRsamNFcGduczRGTmJqdFVrbjhHb2oxdENPWlY2WlhZZUVra1pEVEJXQ205ZTYxa2s4UlJCc0E1NFVhK2JkYkR5NThrRjlWV0Y4cU9kWlc2RDhVR2hqTzZLUHQ5ZUR0SUlrbFV5bEF0T21TLzFYOFFaN2pHaTJGZWJGT2J6SUxXcnV2RWx4MkFTYlVzZEJTdkV3RkhoWkt4Z3hSSzhTRTYxb21GV2cwQWw0UXhsNFIxMzNuOGdkMW5NZmhFblp5cDRxT1ZwSDg2Z2krNTNjM2xVOEF2TytXL1FLVW0rdEV3aGxWUmxEZkdwMDlPeHArWDAzMWJCYWI4cDJZMlh3PT0iLCJtYWMiOiI2Zjc5NTNiYzZhMzQ5NmJhNDZjNjBmY2FjZDM2MGEyZGViNWQ4ZGQ0OGE2ODFkYzg4NTA3MjczOWQwMjE1YTk5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AD, AE, AG, AL, AT, BA, BB, BE, BG, BS, BY, BZ, CA, CH, CR, CU, CZ, DE, DK, DM, DO, EE, ES, FI, FR, GB, GD, GR, GT, HN, HR, HT, HU, IE, IS, IT, JM, KN, KR, KW, LC, LI, LT, LU, LV, MC, MD, ME, MK, MT, MX, NI, NL, NO, PA, PL, PT, RO, RS, RU, SA, SE, SI, SK, SM, SV, UA, US, VA, VC', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(720, '1467_0-MiSmb6BbsTg584VF', 'MDMExclusives', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImcwbDIyZ2NJODRHMWtjQkdKdTBha3c9PSIsInZhbHVlIjoiLzBTc29pTnNFQzgzck5Db25VQ280MFNxcUo0Z1ZxcnlsQWdWM0NmRHRsenUvRjMxaVhKOG5tendLOGlHM040ek1ZNSs2YkYrblF2KzR2bWk4Y0h2c2Z0a2JVdllqRFZZREwxVVRlVTh6QUZEcGJKM3hnYmtVMDNxWTJKc01vZ0pEdldPa0Z6a3EwWk5BUitLTFV2YjlXM2Nyb2JPbCt5djV5c0c4T2hrd3F6TzIzejZxTzNqZlNITHo4NVR6dmRSRVhHdmVFVHdFeTIxQ01UcTdqdmN6MzYydWxkeVdGRThMMElCUkRRajVpb09ZT0s2VUMyeFBvRUtRY3J2YTA1SXpsM2R3VUFMdWN1VytSVWpMVGoyWTNSY3Axem1CaDhHUW9hYmFGWU4xcWNBcXRUL1NoT0tRUjh5bEMrZWZOU0FaU2kySlhaVDU3ZGdkdmRQYkEzK29JZmdTRFF0bmlxemdDUEYzQVhYTHMzY0x2YWRyVFdvVXhTVnZITkxPZFQ4eWttK25Wajd4RDZ6RWNJWnBJZE95N3ZvbzJUaDAxZWpQbkNyUFI0VHFZTGlMTTJHbU9vVTY2cC9rcnM0NEMvZ1oydjZWU1padmJETFE5R0hNUkpKaGc9PSIsIm1hYyI6IjU1MjFhYTE4ZjczNzc5NWQyOWQwNTQ1MWVjODBlNGI5NTM0ZTIyYzg3ZGFjZjUxNTA3NzllNzJiNTllYjNhMDciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(721, '1468_0-MiSmb6BbsTg584VF', 'Everyday Winner Sweeps $500', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ik15ekxJVkhDSGM4YTVkWXZjOGV0MFE9PSIsInZhbHVlIjoiS2hUdU00V0pmUDh2YkcxZGt5T0k2TXU0bWtUWEw0NFVnbnpPSXBXQTM2VWNCU2d1Nk8xTTEwRG1YT2o3QVQ0aEFiSTRiZUdQRVhmN3dKYUo0b0x4Nk51dW9aOGZiYitrSnBJS1VzZGhYbHZ1anU2YTh1a0VMQ3djWWtrTDZPSlFhTkZtTFpDRFNwdDFuZVF0Y0dkSlFpbHpCejRlUGhtRGxoM1hEelhqci9zNTk2c1pHL2VqeVRZenNJMy9TOXd0UnI0bWZ1dnFFWWFGajNGT1BEei9tbkRjcEwrWnMzdDNZTXZ2ME9VZlBxMHRESlBCSGtqUzZJVVNDT3h1ZlIwSUcrWUp5b3lQTUhUUDRDK1Q4NjEwcElreHpGWXlVc2pqOE1XZVpLcWtoeUwyRlRBOUhwaHR2L1dNQWNnT3lxWUFxK05Uc1FGR0VlVzg5WS9iSUIvM0VXck9wMGRpai9UbTI4R2t4Zmp4YTBsTVFWUlNLZ1JyRHJlUEN1RzFYQ05mcFZ0NnRuT0s0S09seHp4RDhaa1QvTys0TDdmUEVjR254b0s1Q2xuOWVMOUJYU0gwaDlsY0F4aUNMbEp6dk9IZjVsYmlERGwvU0J6R1ZPcFA5MGZEVGVZME5iYWpVRXRFMGI0SHA2WW14QzQ9IiwibWFjIjoiNDhjODFmMGE1MTYwYzg0ZmE4NjdjNWYyYTdjMDQ2MWY2NTc1NzMzYzU1NjRmMmYyMDMxZWE4MTA1OGRhMDRhNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(722, '1913_0-MiSmb6BbsTg584VF', 'Everyday Winner Amazon $500 eGift Card', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImtKVHY1QjloYmwxUDRmcE0zUGFyZWc9PSIsInZhbHVlIjoic0FmTXpTdElISzlabTNMVktHWFV3OUJjNkdBTndTUzdSM1BHSUNCaHpVajVkemt2eUNDTGlYV1g5a0NEWFZ0RWlQRHY0Q2ovTzhobFpOZThxaUZuRGdoT1A2K2VHa2N1aloyYVNEelN1QjdYQW84cmRzRGtFVVltdzNjcUF2SGRhTE1OTnVqQ2xPL1BSVy9nZ1ZuR2RKd0lJbXpNdC9FL0lBSHFzWWlodTVHd2VGVkJsZWdkdFExQ3YzZzVDT1dJWEtTZW51cFlVZHdhd1dwdDYxZDFaU3hQUE9IQkF6b0sxQUdzWFFGa0pmaDJkT1NtVFMvYm1EVk90UnZpOWRnYk56K0NyZmhCL0NNUnlMWU9ud3pDRmMzbnlvMERQSXlVeEdISk80RU54bW9mcVVFSUlVckxGei9jaS9mRUo1QjVTUE5WVjRBTmd5WU44Rk1aRURJbVB3TmlmbGVKMXdRNHQvVTJONmxUakhweHlVYndHSWpvd09OQW45ZUsxRU5UVkVabXpEMm42aVdxNmpoRzVhNG1SVmZYWmowY1o2VDlxZTJEMXBBUXpNcjJyT0FhS3RLOVM2KzNLV1Y0NUJmMXlSRmVZajYrdVluM2h4RWpEWXd0dXU5dmJEMENRdTRSWE1zWW4yU3h0S093YkVvY0UxNExEeFpsV29Za21GZGIiLCJtYWMiOiIyZTI2OTUxMjdhN2JmYjJjMjViN2QxZjFjMWZjYmM1OGU2MjBhNzYzNzE4ZTc3MzlhYTU5NDljOWI5MzM5ZTVhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(723, '1914_0-MiSmb6BbsTg584VF', 'Everyday Winner Target $500 eGift Card', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5NYmlVSDNIMHlwUHhOVkJxYzZqcUE9PSIsInZhbHVlIjoiTk1nOFBUNzhsWXVvZmdvZmFyc2U0TStsOTNwaEEySXhNbEJicFZkdXJWWmZjcWZsU2R0bS95d0VkaFd5M0dxWGVvTmc1c1ZCZWk0bEFKZS94bDBrRGZuUGtvbG5mSVhLTHI3ZVJtS3haMCtSMGNXelVwQ0d4M0FyUVArTFlscy9NR3J3ZEY5cFhQZ2sxT0JpZUV2dllJeStmUEdqdUNvZW9tT3VibVB5aDhSRjhoL2d1WkNTT2tNeW1vbWVhR1lta2NiY2hpTTVyY0hLVE83dmRtKzdxY2Q2WTRVUDMwbGJJL0RuT1h2WGRua0NmU0RzRFBHYUIvYVF3MXZYVndNbFIyeGxNL1RMVTVHM2dRcnYwODBKZlJ3RE9hTDN1S21MTWVySytVUk1iZks0bjF6MGR2NGJjbTkrY0JGN250U0lpcmZqYll3NnkzQXRiY3NvazdaMjBNRCtFZlc5cnAwdDd6MkU4dG9qdS9nREJpcmVIR1Z3Q0JwOHBGNnAxMFNQd1VvdjRJV2o1TU9GR3VpV25vVWhnY3g1dE5GclZxaWd6T0VqR2taTS9KQjVic2kzeDZlaGNjRWZpRXlVS1dMWXgzcVBicFp6d3NMV3Z1elpBZnpweUcxNTlSTTA2RDhHK1FUZnNxaDRXUEVYZjNjRGh3aVFua2RvVGcyVDBpTWoiLCJtYWMiOiJlOGQ1ODY3MWUwNDM3YTIyZTFjMGQ4ZDM0ZjBkZWEwODJjMWYyZGIxZWU1ZTc4NDhmYWMzOGI2YzJjOTM2ODQ1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(724, '1915_0-MiSmb6BbsTg584VF', 'Everyday Winner Walmart $500 eGift Card', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6IkdEQ2ErUDRhNlJzTFJPSWdYYytpWmc9PSIsInZhbHVlIjoiQVM1UHVWN2dSK0VISkE2cjcyaktFUEJ3anh0bmJVUTV2dWtVRnBHcmwvRGIxTHRpaXZkbFEzREdod0ZqRUdBcUp2d3dNdTF4SWZrcmJQVHdhWnpFZDBSNmo2WXIvbXJVTDUzNElPY2NpQ29jcGFtNWl6QnBCZkFCL1U2YU5wZ0szdU1pSjAzQjBQZFhZV3hTSFkxQWxSR2kzTFFQanFxenVlSmdmRUMyRnRGanpKdnZRSGYwN04zVnpXankxRll2cGJ0TTZOWDFsUlRUbWF1ajdPbFlmL0xXcEZYUWI2UGpyZENzOUZQc0E2NkJseGtXemNibS9Yam8xZERSRnpVbHJuWVRFTWl6VjVTNU1HeTFwMm1MQ3hLbEhuQVZ1by9YQUNlN1UxQXl0dzRRajVxbDdiZ0N6L3FHekpQZGJPSkhRb3IzajJrbDFiS3J2TU01aFhZNVVzQXRaTWxBMW9RU3NwZXp1Vi9kV0RTWWt1aDMySlJFcnB5NitVcVR0NzlnOEtMNzhZWkd4Mm56T0lqQ1BnMVZJVjk4a21xMDhqSkV5V2RKTUNSR1paRytZUmZwYTVieEE3MXQrWWs1Y0U3VXNQeFRITlNkKzJiZm9HTk5Nejlqa2R0VGxONTcva2NDZ1l3ZzR3WUpIU2tWYXJqeVBWMUtOV3RMRFlFYmEwWnkiLCJtYWMiOiI5NjkyNDUzYjdjM2VjODk1YTFjNDQ1MWZiMjc0ZWVlOGJlZDk2ZDZhOTJmODE1MGU5ZjIwODNiZWFmOTQ3YzYzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(725, '1916_0-MiSmb6BbsTg584VF', 'Everyday Winner Visa $500 eGift Card', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ik10S3hpMG9nRkQydmtzMmpNRFJGcHc9PSIsInZhbHVlIjoiSERtWE42UXZkNFNqQzVJaW45c2pDR2JhQm9CdTJ3RmJGMi9OYUc0THEzcGFEbXMzK204OTZEMmZPQW9pWWtTekZSN2hVQVVyd2gxd21XRzJ5SWhOa1F1ZEoxbVBoZ0taMm91T0VJZVVOeVhSSS9waXVaRWFBOUdZb1Z2QWQ5eXdMVjlzNWEwT2RmZEFZWkI3YzZXL2JGZmRzcjBVNnh6MCtNZlh5OWRwT3M5c21YdysvcUZaRGthbzlNWDVkajlsazRWUWFRK01HUUtQZHc2NUdHYnlLRDZEek1hUXBkV0QrTTQvWUNzbDBmK0p4ZURFb1pHUU5VcVhJVHhGOTBsMDh4V1c4cEJhemZNREJIYTFOTElUTjhnbWp5Y1ZNQ3V4RFJSYjBFUWFmZytvVm1aa0ZvaVhnWm9qRnQ4NnRqVHZNS0tPakR4RlE3MWJpM2RzeGhodkRNZXpOWXZyLzRhWFdiM0hqRHgxYld3NUJQUG9pUEpmWGx4akRwanRGd0IxYU0zWWlaQzhIZ1dsQTB5eCsrbVdCbjI4RGRHSFVROTlPdDU1TldrRC81UFBaQUI0MEFvSkhFVmMzZysvR0lJbFMxa3NURnJFTENOQzZvNFZOK2R5WWl4akpBSkpSUFdjTjh3YVdWYjhEV1BwejFTREpTTjNQNXJuMVJYbVBpVHYiLCJtYWMiOiJhYjIyNGMyYjVmNDlmYmZkYWVjMDM3YzMxMzEyMzk1ODhkMDVjMzIyNWMzOWI5NWNmNGI5MWQxZTZkODY0MWRmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(726, '2073_0-MiSmb6BbsTg584VF', 'Panda Research', '', NULL, 0.88, 'https://notik.me/api-redirect?token=eyJpdiI6ImxwN09pVGVRL2I4N21kM3RVTkVyMHc9PSIsInZhbHVlIjoieHNiUFd3Y0VjcUdOTy90b0FkNi9ZVmJERkZtWXQvM01DQjFjdzMrVDR0Z01oSVBVS3AvTllJdUZzaFdjeVN6MXpMRHRrR0I2S0V4SHpmRnNQSXhOdHA5ellIYjFtVDZJTEtwd1BDTUplL2lzcGVXS1dmRmx6cVJJVnpjdzV5VG9FQVZJZnczTTA5bk1aVGpiVUUyVlBwK1JGZHdTbXV6Z3AwSW02RzViSnJZMUgzcGpxaXRsQmxENXlTYUhaQ2tzV1lIeVNRcloreTN3b0RDcThZNHNmYXNmQUZDTTl1akdTN05pbDA0Vk8ranYrdlJNQ3hnaisrcXZIZWZuMTlTMGlucXk3TVMzVEh0QjNpNHc0aHd6eTNNa1djMUIyYzI3NER5RmFoS2VSZU5BekRpaVFEYTBPMmVoWC9zS1lkWis5dVEyVnY0bUpkbXlySTZhaGRZVHJtNGl4RFFqdmZvSkhkYzE5U1JrK29vUFdCOGFQN0hzMXlXek1wdnE4WFRIekVLY1JxTmhRTWwwQWZZRXBIcWl6dTZHd2lTdFdadkJocmlqQ2FVNFovalZNUFZ5aE9wVzVGd05ZU3V2YWJqT0dUY0NFT3pHQm1KUXFwYmx6Z0N4T29BRm1zUGthOFR6ckdpZ2hEZzJCUFk9IiwibWFjIjoiZmZjOTcwMThhOTk3Y2Y2YTViODA2NDIzZWFlNjUxYWJjMDkwMmMyYjA2YmFlM2JmNmNmNTNhM2RhM2FiZTJiOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(727, '2917_0-MiSmb6BbsTg584VF', 'Conquestador', '', NULL, 18.00, 'https://notik.me/api-redirect?token=eyJpdiI6ImZkR09kalVsQlNyeWhTME1lWWdiU3c9PSIsInZhbHVlIjoibUpVSlpIcVYyUCtPdE9NMlhoYUwwc0l6K0N6c2ZTcHRCTG5nZzBJcFJCUkplb0pJRXNNVngrTjRlS1FFbDdkYXR5RW1XM29KYkFFRDl2S28wUWtNZzU2dlBHWXFVRUg2MUZnRE01eXJ1ZVdncGhyRStpajgwMTE3bCtLQTdGMWJVS1ViSEdCc3hGSUR2eGlGYXFSSHAvVWJpdzhQUTAzbXRLZWZ4UXJpOVpuYTNZakxPamdHUXR6cUZDWExnUmw1T3c0M084MXRNVllvZnYxMVg2U01IZHh1eEVMc3pXdGF3MDhhRXJabGRSUitlY1IxaFdLYXhBbUZ1R1NYOXZwbGRkRWh0cFpIWlIwK0FvdTgxNE9saDBBTVA3UERGNGwwekIxQXlTV3o2dFJiUE41aWJuSk1wRkw2clZNUm1RVWhmcXNRRE9RT2t0SWRsNCtyc3J0VXJFRlRZVjBTN0JrVU9iazhZdHNMaWF1cHF0TEVRMitDT3Jkc3FhVnhDT1ZsL1F5SjRwSTFDR2IrdHd6RTJwbGlYeWxZMHZERmdWT20vQUNoMXZoK0h2L0NmUUdkeE1FV3VuMlJpR0FsVVk5Q3FweTJldjJjSGJRU3hCUStQczg0RVE9PSIsIm1hYyI6IjNiZjNiY2JlYzI1M2IyZDIzYTA1YjY5MGRkNjllMDAyMjk4NDZkMzc3MWY0MzViYTZjMjhmMWRkZWM3ODMwZjYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, IE, JP, NZ', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(728, '3567_0-MiSmb6BbsTg584VF', 'Domino\'s', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6IkV5OXRTUXBmN1ZmUmpQQ3VtTlhTbXc9PSIsInZhbHVlIjoiUWNSS0xkTFVudFFBeGYyNXVTc1FxYjBQTy96U001aGNEUlc1V01xQXpJdG1TQ1FjTXVBM1hlV0ZQMTkwNHlmSUgwOFlXMmd4a29PZXFNaXZid2pjNU5QRmhSZVp5d3hjQzNXdWxMK0NMRFpHQ0l1TSttVlJiOHdBajZjeGdMRldVOWJkYWRpZlVWRll5bjVzMm0wdjk0OHFFRDBGdWJDSHlCK25SNlhoTDRJOEhSM1VEeWpEdDNUN1g4NmVFeFNja2l4eldWS1RTWWMyelU4YnRNeGxKTlA3aHNrR04rWTBIdHV2Ry9EMGlvK2xnWlpqWTFVRVhyZnNJLzBKeVlxS2ZRcDNWL0hYdVFzWnZmQlN1RCt4Ti9hc1V0OVBTdVdTNFVaN05HK21va0RHZFo1TzhVYTNhbDdockRNbmZMbjFxWjRSZkhiSkl6VjcyTXJiR3BId2ZUN0JKd1NxMGV0L1B4Y0tnUFlSREZjMXNxNnlCVlBxVmtrTEdPcXRDaytjUGpOWVdmdm0ySmdobHVGQUxaKzRqSlRndmZSd2tpdE91T3BjRjRERHZGUWxINllWNGE4WUVMaGRseUNNbExaQmhUdDFwWGgrVVgzeTM1N1p0TXlaNFE9PSIsIm1hYyI6Ijg0ZWQ5NzQyYWNiNGFlMTY1MWNmZDI5Y2UyNTAwMmY5ZmI0NjY2MDlmOWUyZTExYjAyOGQwOTIzY2JmNjdmNDEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10');
INSERT INTO `offers` VALUES
(729, '3764_0-MiSmb6BbsTg584VF', 'Prime Video Free Trial', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6IkVjYWNXYXFwK0VzclNKTGJNaDZRdXc9PSIsInZhbHVlIjoiU3BFQ0lqQUJNN0FRaTNjZTlIMVA5TFFpcWVwK1FvRkQwTUpRUjhhM1VqcnpiSmwyMjB4ZHpuRG5nY043QWFid29aQlh4elBwSUdWN29DeGxtUzZVelBOcDloUjhmcUdkeFcweWpVUGJYYXllaXlsMEluYVMxUnJVOExKQkt2S2JYelRCbUpvREtCZWJQVzBxK3laVm5WU05WazdRUXczdjFhYy9WZWpiWlcyM0ZoUlZuNm9pTThCbDlaMUVQclhCaWNXRFlUSDVaR2w0amg2NitaVEQ1bVgvZExBcWRBMEdyZXF6RHF4MmZVQ0ZCbGpRWVpMd2JvVXoySXJNY1ZLQkN6Zm1tY3grSnFrTmlPS1cxcHIvQlZUOUlKc2c1d1ZSNENFd3JKK1ZYSXArMm5BdUNPblpuQzhJQzRxV2U5aTREU3VnNmZVM24rKzV5ZlVSVGZCWEtpa2NiRklybVd1dXJ3bDNiU0ZLckxuZEJMVnc3V1Q3Snd4SzB4bG80Nnhhcmp5L2k4OVh2QzNBa1JQK1p3c0NOSzloSVNZNGQrc3c0bUMrRytENmxzeUJLSHdmU04vdzE0UGxBS2ZkMVBxbVFoZVlXQ0dNbWNIdW9DTDh6bUkyMzRwTmtYYStITXNVOXE4WXhTZ3ZUck09IiwibWFjIjoiZmVlZGU5ZTI4NWNjZWE5MzNhMmRkYTgyYTQ3MDI1Yjc0N2MxMzM0NGJkYTlhN2E0OWMwYTdiZjZkODAyNjQ2YSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, BR, CA, MX, NZ', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(730, '3764_1-MiSmb6BbsTg584VF', 'Prime Video Free Trial', '', NULL, 0.28, 'https://notik.me/api-redirect?token=eyJpdiI6IlBNdEI5eHlXQjJMUDkwSVhuVDB1alE9PSIsInZhbHVlIjoiMmpSbzg2Wlc2azBnbjQ5eGV2RlBjNmMrL1BoRHEyN2dpYm5QOXBYTkJLcjR6dmM4ZjNTYWVwRUFSK0IybGMxRWZKWU1zWGlIUitKMkU5eW5iTnZGcExWazBlV0U5NTI2STlqcDJsd1ZSeit0NHNhWm9HbjRYMDRPTVluQ0JaZEtJMHhOdlZLNTJqbHpscjdLR3lpVjQ4SWcyR2FFandNQnBiTlpWdnVYbHQxcWlScUJrV3p5aWRqeG5MM2dBdGc2VzU5ZXNBZHErY2JVTWpwWUxaaXovSFdLWFlvT3h3cmxselhJcHhWNnRTQlZQV1VLUUlyeVVVWlVUVGhqSDd1cUdZbC8vR3U2ZXMzY0xXRlFoNmkyQUR5bk4rRnB3UWNiVndNb2l6dHFFM3ZjSEtYbkdnell0dXpieWpxMkFNaU9oNzRqMGd2a0F6OUx3RlNwT0loamlPL0J5NHdtWnp3STFVa0V0bG9KSlp6UkpjWmswSG5CbUpWZ3l3b3lGQldqUG9JTW9Oc05KUkFVZXJRUjRjVXI4Q1NXOUJ3aStoOE43REpDOTlybFhReDc1eGdmV3YrOVRtQW8zdHN0WVlIVklSUVBobkw2TXZaL2YvY3pBeXk0OXc3eXZNeXN6eVVQZDhNczFiQnhFUFE9IiwibWFjIjoiMjgzMzUyZDE4YjZiYmEyNTMyOTgyODkzYzk1N2MzN2RjY2RhYmMwNGZlNTRkZDFmMDk1ZTExMTRmNDNiMWY4MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, CL, CO', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(731, '3778_0-MiSmb6BbsTg584VF', 'Victoria\'s Secret', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6Ikl2RkhPNHlYeDlScnd2UDhHMVIvRVE9PSIsInZhbHVlIjoidXBvUy91UisvVzE5VzdqM0Y4K3dWRmN0SkJrbEhVVHBZNWo0UEZYM2FPMlJKZUVEenpTeG9hcXdmVW9tQ0w4TWFabjZ2SnZwWnZORGZrTzUvNnJDWVZEM1kxcFg3VkFUMUZVdmR6OE8venJRaWkwM1Z5OUU5YThSNkRDOWQyNnBsVUZDOWtuN2daMzU1bHlPVzlWeE9SMjkvTVFFYUkycVNodFR2bmhnRzNudE51dENrL2VIZWUyS25YQWpQbFk0QXYwaUFoc1lLeDNOMXl2amhhaVJGWTJxK2ZCVHJlajJaRjJmSkFpZGkvKzlwYm9vT0g2ZmFrTnZKQlpVNVppV0JNTWRnTDdTN3RJNE8yYXBtcEtnWjNLWm9YS0l3ajJkSDArSzVwd0lGWEt6MVNFYVlpQUJCell1RHYvUXN4VjRsVUtGUldUbTZZZy8wZURaWmJnRDdDaWQ1UUFWQ0Q5cXcxSFRxRU1xT3dUbVkvcUtEelNkZ3ltdlcxYXFqMy8zVEx6ME5DZEtJenBBQklIclNRYlBUd0dOcEplMEFxa0tLWGtTNjZXZ0JIdFl0dlpJRWFhVVNBV05XQWUvRkZXdzE5OXFlK1duMVozTzBGdWpyL2lzUWxIekN0ZVhSYTFMTThVd0pBSFVkWW89IiwibWFjIjoiMWVmNzI2ZWVmZTVhNTU1OTFhY2Y1MzgyMTYwOWY3YjVlOTVlNWMyNTllYmJjMDQ3YmIwZGY3ZTc3N2JlM2IzNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(732, '3784_0-MiSmb6BbsTg584VF', 'Crunchyroll UK/DE/FR Free Trial incent', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6Iml3SWlSZXJRYXladEdDYm80WjhsakE9PSIsInZhbHVlIjoidzlJdVUvQ1U5ajAxcFduNWV6UkVtM2cxSmJIWEJTbGIxZkR0NFZ0NVY2TERkK3JZaTRDSDE0K1FOd0k3ZGRORmtmcXNwT2FEMHNOaVNCd1Q3MUlmNkJqQ1NEWXU3MEg2TFZrV1JKWERsM01iandtMkl5WlNpQy9aL2ZDaFloR21LS0xBMEVYZ2Z1dkdvK295YTNDeXFTUWI3RnM3dFIyazJYbU5sa0w4b3RCaGcrRGM4NjdEZVRDTHV1bUEwTEhiRXQzczhxbVl0bWNrNGNoa0tBbDExaG8yclFiSWJMV0pTTk16dEJRbm1HaHoza0F4YnNnL01VMUk2ZWtkNE93ZnVGbC9mYzQ1TUxuSlV1cWYzVGpjQUpVWEpVTk9iZjJpanFIMWs0N1U0RUQxcnQxdDNzUmpOSlFCeTVqUVRGVU92WFVwM0UzMVR0T29Id1gwZHhiSDBEUU5DZUJaTUVpY3kza2dLV0tiakNVVjZ1U3VCQUZ3S1pkWmlnM293djd5TTVnUnVzeXNublZqY2pGemJjUG1kK2QxTXp3M0tZbVdiWjdXWTZEY3hYZnl5aERIUWVuTENuQkxyTi9keFhKcnk1VUpWRDRjc1pqcGxMM3l4Y3R4OUtIMExkUER4KzBpYjBYRk5QOTRlV2VscEd0aWVKa2liZHlsVjMzWUpGWngiLCJtYWMiOiJhM2JmNDFmOTg1OWIzZjhlNzlhODFkMGRhMzI5ZDQ5ZDc5MzliZDY2YWY2NGNlYTg2NTYzNTNiODA2ZjhkOTQ2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR, DE, GB', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(733, '3801_0-MiSmb6BbsTg584VF', 'ILovesamples', '', NULL, 0.80, 'https://notik.me/api-redirect?token=eyJpdiI6IjNaa1pIUEFjMEF5MEV0OS9VdTdVaVE9PSIsInZhbHVlIjoiNXBCVW13MVhIeHJSL2xNbWUyZHVWYWh6YTRhSU5MMTZNNEV5UXF4TENmSVFjWXJOSkdrak9PYWU0a2I1STFhMFNjNmd2aTRGQi9OZmNqdEthbzhRM0lWelVSdURIUXIrOXhkQkY2NSsreVdVdHg5aGFOMktBYzBGaWtRQ3VvUFFiUEhYc3Q2dFk1aTNUZ0UzcGxzcHhKa0dUUHVjd1ZWeHhTNFdUdGpNemJDTld4a0lpWktENXA1dXhKbnhpakxSZDdjMC9OLzRQWVQrSVF4WWlUZXBVQTJGMUpXTTNwMDdoOVdFVklHZmJFZEZTZDJPTXZtV2hTc0twVjhVYnZycldEaTJQOHQ0UXc2UDJWclluS29ibC8vTjVsa1VVMEF6ZDlQSzBqWkVpc1NzZlMzVGo5VjV5QVZBb0krMG15c0RkZFZxY2NVREljT1AzOVlrL0l1TDlPOFA1d3hpK1dVY1I5RlR1MzRlc1ZjYUNJVmx4MHh4Zk5NK3hoOTIvdGFuNzVKMmtzZ1k5aDFZZlYyL1AzNDR5NWpBaXhRUmhwOXZwUXh2RFZlWG1GYnpON2RtN1lXMVFwT0dCbnhzZnA0WDZOK01HUThTckxzdUhpeDk2TjZ4VFE9PSIsIm1hYyI6Ijc0MzM1Zjk2ZDMxYzE0Y2ZiZDU0ODM5Y2FkZmZlMjUyMGVlNjhjM2E3NThmYjM5YjlhNjRhZmIyMDY5MDk5NjkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(734, '3883_0-MiSmb6BbsTg584VF', 'Social Catfish', '', NULL, 1.80, 'https://notik.me/api-redirect?token=eyJpdiI6IkVBQnN5dlFtYXFIbWQ1MGJqT1JuQmc9PSIsInZhbHVlIjoiUW5DaFdQdHdieWlDaXl4NHg1aEZVaFpzbE9UYjZlRDJqdTFUVlYzT0xlZkhTbktVUE5tVkhyZjZRbGdtM2VYSFArQkxLa282N1l2bkZUenZqQktieTFxeVgvS0tZYWZZcDVlb0RReUlQc0JsY2cvTVBTcDRFZHd5Um44a3A3T3pZalh5cERBVWpDUjdCaFczSTYvTVhRaFRGM1N0SHVuRWxRVVMvbVU3WkxEYVVFeERvU1ZBOHpoNFFtTEFiMEh6OG5XTGtPYVdPWDQrSWM3Tkd2Vk93bWlBbEUrQ3JSbTZlL1lFaFRjR1MrRnI5VDFwQlJtcFc1L1Vwd0JDNmVUVW0zU3FJRW5Damt6WXJ3bEM5REUreHU1dVBtSTdNUDBMVy9hUWVZVUE0blA1SjljTU1Da1hnNDBETWdaVXRuQ0JNbGtyWFYwaVdqa3Y0V2dTbWtYS2V1M1BNMnA5VHFyZUYwaUVzRlhBdWFlWWFKKzJxc0todUc3UDlFVHJLblBUQUVqNWpQeXB6ZURxQmRxV0tvU3ZCQXcyMVJxcm1xUFhWWWUzdGR3UC8vT3BXYXRNaXE0Rk1wZDRaaCtPZnRPOHFFSVlGSjNrOC9pTnROSkhFVlJYMHc9PSIsIm1hYyI6ImM3NDA3N2JhMzJkYTBmMjIyZTUwMDgxNzAwZGM5NjMxOTg3ZWJiMDlkNDkzYzRhODlhMWNmZTk0MWVjOGRmNjYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(735, '4139_0-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6ImJVWUZ0NS9MQUZ0VWRUNjByRjg3N0E9PSIsInZhbHVlIjoiUmZDWkZQOUY4UFF2bm9DckhPRWtYeXFCSDJ1YVdqd0dldE5sTXJpVUp6REZkK2Qzd2FLdUk5N0pIVTRVT2FScTQwVjU3RUdTV05iVkJ0cUNJN1hjVXJqdzVhTUpRakxBdWdTTmRIK2tZcVBVTUswVEZrdnJCaEVkNHppWWpSS1ZqS1Uyc3QxalRIeVJUK1RiakxmdzRlMzF2RWtuU0VLUGpvQ0VXN2EzZ0x0YU9aQktvWGxJa3hiVEN5N2lOSlVMZlpvK3BKS0NQMFRMejlaSVA5cHozZ1IrVDA4V1RWWG9WR0lMcGNOenlNUWowaWJBelIxNnN5bGJ1bklwMHdpbnIzY3pYcDlyMktIekdOTE8xTjNwbVREM1Uyc1dwc0FoVGltR0paUVBzcnZqZXBxMmlXVUdkYzZGRFlWaUJJb21GaFcyeXlkWWdRb3FJZ3U0Z3BNZDNRVyt5cFBtdlBvU3lobmRESjRBOGZXYnBaeVNjRS9jZ01zOTZMU25SWTNhM0hDUlM3WnA4dmZLS0wvdndsaXhGRFlOeEFIODAxTGVuYkYzY3ZvSGYzbEFBK01lMkJJUVdSWjRUN0ZqRFNXajFMOC96SURuVDdPS1hvdUVNOFJtS0E9PSIsIm1hYyI6ImE3NGMwZDM1OWFlNGY1ODMyMDViOTFkZDQyMDYyMWVjZDlmMzhjNWVhMWZiMjg3N2Q5NjI2M2JmYTAzYWRhZjEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(736, '4139_1-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IlJuV1Z4TkRXT3BXNGgxcHlNOFVnTWc9PSIsInZhbHVlIjoiTDFuZ0xmRzAzaWVmUzIydDlGN1ZyNDBheWh3UjJISGRxcmNLeU9sOG9xUklkdEI2YXh2Wit1Nkh0TDMyWU92TkFLam1CVWViaFlvK2RGcHlVQktYaUowWEVGemtLdjVlS2x3cXlkWjlFMGdPQmxrTXkzVVUwWEdPSVdvbzRrQWh1di84Z1JaTm1mWEk3RjF4c3BNQWp3ZVEzNFIyUkEwNVpWanJ6MkV3V3YrdTdQUzN4MFN0dGVsM1dtdXVjbEF1ZHIzSHRhNHQ4cjRlWFk1djRBV0xqalVsbXh1R1p2cmRTUXpsQzJFcm9NbjlSc0crWXdUUTgrYjV0KzVrQmJkOG1yZGF2QVZuaCt6OG9KNGFMMEZQMTkvWWhBRml4c3hQK3JFeEQ4TjYxajRiYThESEhwQzZhd0I3OXB4SFVWNUpFd0UzVnhNb3B4Nk5tc3B0MVdWU1RCSjRLQllNVE1Vckg2OC9YQllFTTZtZGx0akxVbFh5UURFaUtwcDNNNjBGTmpydVZpK0QraDd2dVB3R2gydThCOFNuV1IxeGZNSEUyWlFZa0NvVE91UUY4Qmpya1R4QXVVd3F3WnkrbTN6Uy9GVGdXTXM0NkJKeFFiRlFHMUhEaFE9PSIsIm1hYyI6IjEzYmRlOWU5ZmZlNTIwZDFiMzEwYWM0YjllNDRhMzNlYzZjMjAzM2EyMTI3Zjk1ZDFlZjg4Y2NkYTg0YzY1MmUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(737, '4139_2-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 5.60, 'https://notik.me/api-redirect?token=eyJpdiI6Ijh5YklNSTlRaFpoQm52ZVNnRG4wRkE9PSIsInZhbHVlIjoiamlCSTc1cGZ1b3JLYkpPWnhtZkdxMk9rTFRIZGFteWYvSmEwMDdCQURqUWQ1emxkbm4xbTRIdlk1TXoyRTdFZG12WFdEOCtkTjZNNEJuc1lTbUxrSjFhRVRmSXJZZUJKUXBSM1N1NG95VnNDUENjOWZiNEI4OHBFZWtDMU1RODVTcWV6UFBpclJ5WkU0MDJkcVpUMGpETEtNQXB2eHRFL3pVcEpEUDY4c3VsWi96T2VTOTNtMzJjWHVyYmFnUmpDWDU5UHByZFl4YU1CSHBkRWdaMGY2WndpbEFibTB3NmJmSzRnTlo2eVIxQkIwbnR0WUhRd3IzbzA1MHlLeVQrVEhmTjdqbFpXQ3pmMGhtSllSdXU3Njllay9rVXladTJkMnpBT1RWR3prOHVERUdDV0lkcGN1WjZZUUFqU0Rla0hLaUZsQ3ExL1ZQa0xFR3dhSGFENmo4NURFMXVKbG14NGljTzZBYnlCc2o5d2RpUkNNRmtXSjZPelRFU3BqU2dVRWoydWZhUHdVZ0J6Z2JOMWJwM2lKazlzWkJ5SXJVSHJsejdHUDRkQ0toV2xGYjN2LzlmbWR0V1QzcFpyUUN1T2E1dDRZdWIySCtkRW9KQUx2cWRMVFE9PSIsIm1hYyI6IjRmMzQzYTRkNjY4Nzk0ZjdhOTk2YTQ0MGU1MzY1MWFhNTk0OTgzOWZmMGQwOWM3ODExOGRhZjVmMjdkOGZiNWMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(738, '4139_3-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 16.80, 'https://notik.me/api-redirect?token=eyJpdiI6Ind4WHo1eS9BSU94Z2NSQlpmbzc0dWc9PSIsInZhbHVlIjoiakJUdXVOS3NvV2x5UWNkSEpNYjJacEJvSFR6WHNrc09YRDBlTVltQUJ6QkJ4Uzlodk8rNE9sb3FodlRLcmFpdEc5UGcvL0wrTHQ5QWh4UUJXbDZYb3AvNHRqeGRQc3N6SXV5cmgzM1R6NVN0WGk1ODNyK0hZQWZPeUEwa2ZuY1dGblpHMFNVNzZVRU1iazlEMllER0g3dFo5S1pma2pWK2Zpc1RZUzIxN0RObGx0SUF3M00wOXFWV1ZjaGhTVmoveXZvQUlOY0Nzc0NlRkhPMk5ZUmZ5aUR2d3Z3T04vbisrY285ejhkTzg5Y3J0MjNFZTF5SkxlZUtlZEN3cTBnV1cwb3RFcFBJT1B1b3NzTll2eTRMU2tGMjdINFBlQVRxaGNBNW1vdVRvaWZnd2loVkxaaEdoV3VEdmFmZmQxSW9NKzN0d2k2N0QzdzhSc1p6a01MOFh3UysveVJsUlMwTHQxUkZUaEFDdWc0WnBZOHdVdEU3eVVGUGVtUWRqbFZUem40a1pDR1FsMHRvRUNnOThVdFZwOXltbGlSeVBNMEVWcHk3ZHBkNUZVN2cyZUI4ZnA4aTdSeFFzbDdJc082TWJKcnY3bUFZRzQ5QVZyTzl0Si9leUE9PSIsIm1hYyI6ImRhMDdhNmEyYWRkNTNkZmQyN2MwMWJjOTFiM2NlNGYwYmJjMTU3Mzc3OWZlMmQ0MDE0ODg2NjNkMDc3MWFhMjMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:10'),
(739, '4139_4-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6ImcvQ2xUM1Bzc09mUkk3aS9KY21POWc9PSIsInZhbHVlIjoibWtmN1VrUlJrSkp5bGZtN3pSV0xwVXdWWWNTWWw3aW9UZHNmVEVoMm5JbXJMRmh1UGR2QnpBRlVURW1kUlpEbEF5dmRxYmhRQUpiNEh0WmpqVlUrTTBDWlljYmRQL0Fkdk9XZEFFeUlOTW1RaFB1R0NBMVZiOFJtSUdCcTF1bWdvbmxoWWxvVlZ1OTdUaFI0MkRZZ3BJOFFLR3VmWnhwL1VrRFZlSVNaTG5STnNERm9md0todFBlV1dNZWgwdnFNUWR4YmNubUtuamdqWVY0NGRTOFdVTlpVdmIwQlRmdHMrZEsyZnZuQ1cvUDVSdmQ2eHJXbWF5V2x3VHhnaFRPWGx3UTJjTXpUbE9xdlo4eDFKRzhRSU9zZGJrbW5TQW9JS1AyYXR6MEtSd3RUNm03MjlObUM1ZFJvRUNJallTMXVPS1c2MkxHOEdPYU9aeVArcjJQNlpJdjR5Ukh2SDErZmdPRjFQM0s4cnVaNE9DdGZXcjBGQ0RvM3ZaUW9RT3RUK2pGZ3pYcjd4d0ZDTXVxVm00NjJBTVJBWWhNWU5NL2RqQ0hFZDdaZXV0TGlZcHo2eFZMWVBuUlFocHYwMGJzOFdXS2JteGpGRWFTOWp0MTBqb1BYdFE9PSIsIm1hYyI6ImYyMjNmNDYxZWZkOTg4ZGRiYWJkNzFmOTFiYzgyMWQzNTBiYTNjMGM1ZTU3MzIzNjcwZDBhNTI5NWVhYjhiOTkiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(740, '4139_5-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.76, 'https://notik.me/api-redirect?token=eyJpdiI6IlZhdjNFdW1wSTFUR3c1ZVpHQmlNNUE9PSIsInZhbHVlIjoiT0lNNG16R1V6MnJqTEtNZHowUWFYWERJMjQ4MTBXWHF3UnVTU1FwS1gwY2tGY0xRUnMrNEtLZGI2dWNPbHBVUWtsRmczK01aNTJtdEpFd05SczhmQ09HenJoWnpnL2dMSVZBY082RnBvc29kTVpnTlVvdWJiZlRYMmYwK1VJeHlYeEMzWVkxVllEeC9LU0I5NzQrM0Z1UUhEeXNSSnBjcjNkYlFTQUV6RkRmeWgxWnJabHg3YUNZcExpYzY0dVc5dElYRUxpeURKZ1VKMEJkRWZWV3ZDa01PZWp2ZCtTaHBrajdSdklrVE1RQm1oWWtLSUhZRWdPS0lkU1E0VTdGWEcyV3JGSitINkRIRS95dXlNMmFDY01PRWlrNFhXUDh0cGV6OVVHUThpbTR6ancxbzZDWnJkdVlPRVhuaG00MWk1cEVoNFh4UUV1bWRaZUpRbmJUdG03ZVFlRllqQnFLdDZoVlV6UkMxUmwrbSswVDVMK0xlS3I2WFlOQnVIZXhEQ0FvdG4zRTEwdzQ3M0djTVcxZnIzSXh1WTNsQ3JUNlhaS0pwWUI0eE1FUGRXVGZJdm04RUNkOWw5Y21ubHBEWG9OaEs2VVN6WkNab1JqeElzL3JXTVE9PSIsIm1hYyI6IjliYTllYjY4OWMyMDEwYjQyYjVmYmVkOGZkOGEwYzgzMTBlYjNhOWY0MmViMGYxZjA2NzRkNjY4YTZjOGZhNmUiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(741, '4139_6-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 3.60, 'https://notik.me/api-redirect?token=eyJpdiI6IkdqTHY3QUZFOE9OZ3pwVEJDYTlnQWc9PSIsInZhbHVlIjoiVFE3WGR4MVdrdkdsYXY2VzdoeVdxUlVEaDVMSSt3bXozNUFBZmpaUHYyYVVybHpFa1k3aCtubnRQT2Ryb0NPWEJ3dHI0WTJqd1hTMW03d1RFVHJDUCtLZTk3R29ZZ2p4YzdyUWRsdWREYk9JQU9IT2pmajNXM3lxMzlJdkFwZ2s5MHpDS3N2amQ1VTNmczJHemZHVUc3b2lFOXd6aEpHM0xRSy9LUW8rNEVYOXNaSXBna01iTi95bkt4Zlh0dTI5SFJIZUJOazFXZlo4eGU1ZzE4YjNuUityTWxhNXJnT3VFTStWcEZod29ZVVdXYVJrNTNBRkZlV0tOUnUvODA3RFRuV1R1bEZVTkRZU3hObzNKUkxyRlFhOWFDa0JWdU53cUNudVpwZTh0TzQ4SEUzN1Q5blduM0M1ZTUrSi9WMFE3MFJydXFrNThkOFdKWnRQSDF5cWFNZE5vaXR4ZnJidDNiSnNyaVNnWi9tVkhueDNqb24ybWJMM1hSY01KeVhERGYwOU81MmZHQ1JYdUNKcmlpRFVmZGNpMXZjc1gxWGk4aXFiejFUdjM5QW5Nei80YUptRCtWZmJxa0I4VGJWZW1FNTZmM05ydmFRWlg5TExFc3hSQWc9PSIsIm1hYyI6IjU5YWY2ZDdmODRjMzhiOGQwMTJkYzdhNWQxMTlhYzA5ZDQ3MGIxMzY4ODgxZDQzMTM1YWIwYWI4NDYxNGViZDQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(742, '4139_7-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 10.80, 'https://notik.me/api-redirect?token=eyJpdiI6IlpNOEI3ZzRXWGJTVTJBTFlxZDZSY3c9PSIsInZhbHVlIjoidU41RkJNL0FWWGpTYmIvUDVpRmpxdWtRaDB1TG5pZml0eWJRK0hrT2QyU1hjM1ptLy9HVkw0WEkxT2lCSmJwdnZQbjJYVlg5eUF5YWp1U05tWW5DQVRZZ1h6M2hVMEd0ZURlZ0VCb1RzalFxMDdlWC9hNk0vZmI5dmU4ZmxPY05PaWpRSlZKWkRBck1BbHFaVnpqVWlLOU9Kd0tkU2x5NTBKOUc5bVh0b2JFUkp2Y2hYNUE4Z3IxeWdoc2MwcUNvb2FKYisvUyswL3Q2YTRTK3NrVXJKWWM2NjFaeWM0Ynkzc0NxT2cyQlNscS9FbGRERkxmZkF2UnhXdXErRS9GeGFLTEY4L2k5aHJoanhCL1IyMHpDTU9sZThLMC8rNHNtVUVqcW1ZK0cxYlN4c0FNVitoSlNrSWpJNng3R3g5QkJva1M5OFVuMWRmRjBoazBSQlJ3NkNCOVlLY0pMa0tmeFdxVGQ5eFdjbGZlUElyNHhRZzRNUUN5aElYWkNpVE00c2dLRHRWVTA2OTFFOFk2dk5aeU04MkZnR2RRemlNVmdkWWhDU0JZbEx1MisvZzZDMGxkVENtTW1UNWROMHpXTnVPOG9iVDFXNmp0VXBGM0RxUVpSV3c9PSIsIm1hYyI6ImQ1YTZlYWUyZDYyMDNmODgyOTFmNDA2MDBhM2Q2YjRmMjgwZDE1OGRmNThkNjkzM2ZkNzBjY2FjMzk2YmY1YTIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, FR, DE, JP, GB', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(743, '4139_8-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6Im1INEpwdjIyOCtiTm13ak5qa0wzK3c9PSIsInZhbHVlIjoibnAxTHQ5TEFsSGd2eXpmTEtwQXhXdXFmdmcxVzJ4Uk1DYW9WRElEV2FtdC8xdHNjRkRsMnVRb2VqOFFNdmFScEZtQ3oySm9KMTEzS3pxc2VnNkI1dzFHdUNodHRrS003L3hWMnFlNFZ4dFEyeTkxSUZ4QzZXMXBCU1pVa3BxK1lhKzdYSUoxSlRWcVQ2aWVZbEhLVk1abDd5L2NoTzU5Z1J3SkUxNlQyaEdrSXlIL0J2QzdFZHM5dHhXM1Q3eEJvRERHb24vNVFLd3UxdXVaNlVLdnBmc0pmWmNsRnkxWWJwQW5kYkFFeTFWQS9OOWEvVk50aFVUR2YyVGRXZ0JvV1ZIRkRmT0p4b3pjUGloV1Rmc1NzZmVONnZxOXdWRDZHb0JpeUl4a1dMdFlkMVdNd0JvN1ByczJOY1VnSHJCS05iamxQVUJBS1JmL0JmUjVFbERMV0JzTEZ0YTZ5QS82aERycTF5YTlSMU5vVTNWMW1rUlVKN0tNMXFYR3BvNWpQT2pLQzYxZXdjb0tNY09wbkFMSGIrQy9tTVRwNnFNQ2ttc1A2a2h4Y1FZdW4xVFkvMUQzb1dXWGhiM2s3N0ROV1FJQk9nbmx4TlNuVjRxOXpqZVlYYUE9PSIsIm1hYyI6IjZlYmI0NDYzNjAxMmJiNTUyZmJlMWMxNWFiMDVlYzBhMjdjYzhlYzgyMTVlOTdlNWMyOTc1YjYwYmU5M2JjNDIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, IT, NL, NZ, SG, ES, CH, AE', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(744, '4139_9-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.36, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1CQXJ4QjF2YURTVWZsYlV0S0VVNUE9PSIsInZhbHVlIjoic0ZkUW40OHBFZnltUE1QVnp2TzVnOHdyYUhmUVlBdnlzV0YwaTFKVFhCdTdQTUphOEp0QkZoUXk5RXdOUTg1UG9VRDg0bUlNNENOMzRYcVFsbWN3d3k0ZTBadkdackM4dThuZ2xycTJXcWk2aVpjTnR1WnJPSHZKSk5IVSsrRjJ3UDIzNEFLdUVyVGxnL1ZxU3BOQklWcVFBZFRrR01MbHZFNThLSHBaUE40anhpbHNTb3VsNW4reFFjdVNiS09jeTFtbXBOaWFnenFlUVhuUzNvUEJ3SktxSHFOZHhsVm5YUEZhTGhLSzFIRUtyY3NveGJTWDQwOXNmQmlLMTMxb1NUMlhESUFRVHgyU2F3Y1ByZWJtOTdWOExxbUxiYURhL1VQQTFaU0txRndpSS8zNVZhNks0dk1yV0FnUC9aWjBJeUwyQThuV1UvQ3R4UUQ5QjdrZkx5YVYvbWNvL2JvcVFSSXNRS09kYml2aE8xR1Y3bDlWeHBLNkpScFlxU093bkk4MlR6SWxMTzRRdUc2ZllLL3psOTZEUnZBZWJoWFNZRzh1Y1RvTWhNQlU2c2VMZG51QWl1TnZSZFB4eTUwS3l3WHo0SVUwd0FEakxFemdobzZYaFE9PSIsIm1hYyI6IjAzY2U3Y2RkYjIzYWU0MTY2ZmQxNzZmZGExZTZlODI0YzQ4ZjBhODgyYzVjMTdkOTYxMWVjZmI1ODk1OTRmMWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, IT, NL, NZ, SG, ES, CH, AE', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(745, '4139_10-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 2.40, 'https://notik.me/api-redirect?token=eyJpdiI6ImdtTmdsaUhacEhlNmhzZnNHOFdSWFE9PSIsInZhbHVlIjoic243N29sa3NqdEIyeVVieUFaOVMraTZaRk9TR0lZN01wQytuVTJLQmZ6WGFOY3dzZTR3aW9WamRHeDRVRWpPREJDVVh4bW9NNW01RFdhdUtJZWVoZ3JUSlJpdVZZc3BTR2JkZ1lsQkJveFJYZ0JLNHBuUzE3bWI4ck0xUTFJYWxjQldqTEs2Q1dFekp5UCt0L3VENVhrNXpJdTVhdDJYK28yVTNkZ1ZIaSt1TWE0VklyNHlnR3JjTW9UaUVTQTN3NDNrcVNTYkk3Y0xuZVc4VVVWT0VlRFdKQkVucDR5aXNoMDVDWTBjQlhmMGtkbVRSN2d6Q29XNTVZT3JMYTV2Y1JRcmJXekdSN2k2VmJwMkpFWDA4Wnh1cmZ0UzRNb2R3MlArNUxHeTdIczdnWmNJVElhbFJyTFhEbU5FdTJ4OUZIaHNVMmdKSkZad3lhb2NxWnVWZDNNbzc5QUhxSk9nczZMNTByakI3K3FDU0hSRWNCUFZNOVVqUE9UeUk4SFQ5eHVPZzZTYXNZUGh4VzRHbG9xNkJzZHlDcVJjNW5tQWo5c1ZBb0RWN25Rbm15QkVKUkdmdW1qVkF5b1U2ZkhpNEFZZnNLU1JTYzM0aURaQTZGZ3pXM1E9PSIsIm1hYyI6IjZmZTUxZGE2YzNjMzQwNjViOTY4YzMzMTg3MzE2YWJkMjMxYmQwMzkzZjAzZGNkNTM2MTY4Nzk4ZWEzYTAxYzEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, IT, NL, NZ, SG, ES, CH, AE', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(746, '4139_11-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6Ik5iS3d6S1dLUzNYamthMXE1NjBPSHc9PSIsInZhbHVlIjoiOFh3SmJ1aGQwUUsybmxMOWpoSGZMT1JkVHd5c1dqU1FSWThxS0tzQ1pyR09LK2svK2FIOTRBeE90dm1lUXhZSmQ2Rkt2Wk5EcVppanZYVS9xNGIzSXRnUHRlSUs0aVUvRDRldEVBZ2ZHemdtenVwL1hGSk5wRVgyWVFnT1Q4ajlJTDArd291NXFKSGpSUlBjbEl5cGlDdlhzbnoyK0hMcS9QRGprNXpjT0NMZjgxQ2kwelJTS2hUUTdwS0o5SHJWT0phMmFicmVvUGFJaEx4eXBDTUMzalJpNUs4TTlJcXlhSkdDYStETC9wQXM1UFVtUTAvMm5wL09adU9UUjBWZWdTb293UHd6cmlJSERBWEY0cXlabmpVRjVocnZ2VUdlVFFsRkRnTVRPY3hZSXM2QUU3VTBUc2lrdUtIa09aeENodm00T2k4cjN0KzVkWG9ZajE1eHZOY0F3S2I4RGV3bUtCYUVmeWxIRFc3cW5tTEdJZjh3UzdhclhKdnk4MENmUE90NUFFeE9JS0c4bm9qK3FBTjFXMmp1Y1d4UjJEMkRKU3BCbGl1aEdxVzZyNjFaVHlVdGtybnhzQVJwdW55Vi83ZlYrZjVtK2Q0UDE5bk1mRzIzZWc9PSIsIm1hYyI6IjFiNjMxNDUyMWRhZWMxYWJmMGFhNTY4ZjU2YmIyYTEzNGNkZjRlOGUwNzAwODY4YjIzMDJiYzg0ZTRkNmZkM2IiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, DK, FI, IT, NL, NZ, SG, ES, CH, AE', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(747, '4139_12-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjRMRWlHK0RUUm1wNnZBZDg2WHMvTGc9PSIsInZhbHVlIjoiSTJBTWNsTFZBL1M5MVpUZGJsOURxRm92aVA0UE1URTBQaHo5UVNDOEZoUWhCaElLVHZucWUrWmRzbEs3ZkZzZ2ticXpMQXlIdWlHWmlUdERoNUlsN2tQYnVXcWpjZFNhWnA1V2QvT1kvdXcrSU1DemZuNGFsUjk0Tjd1RTlDVm1ZdEhiRlljcVhvRUZ5Qlk0bHUyTWV6SjN3bWpLM1lwL2Qwa3o0ZXBEQTVjS3h5YXRxZ21BY3QyR0orUmJGRlc4SlR0T3JvSDI1eGJBdmpwOUZWRGVXSTAyRTVTZjBTRFV3eHFyM25QTGxFcStBSXVUWmJIUy9tSzdGMHNHOHJCTGE1Y3N3OEdqM0h6TThuSEphTUpWaDMyTlZVZmhheTlMUTRHenpLNTBMQXc4Mk5SNEFDTUJORm8rMVhUejFYVElQdC9LVlExZC9HQ0ZZU3RjeEEveE5MZ1VHTGNFNUVQWmdJZCtKY0tBdzgvSEpTSUJuK1JZcHhweStuSXRmM09xb1ZYMEhyTWpPQXRwUG5NYVpCeHNWNnEwdDJGb1o4NnJMU2tDSDV0RnArTXBDY3VORHlMQThLUTZmYTE3eHZiSk9zbWkxWlNDeEpNa29SMHh6Y25DTGc9PSIsIm1hYyI6ImQ5MDBmMWM4ZWFkMmFhMGEzZmUzODk0MTJiZGQ4NDM1YjEzMjViNzEzOTkyZTg0OWRmYjY5NWU5MWY2ZmE3NzEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, HR, CZ, GR, HU, IL, MY, MX, NO, PL, PT, RO, SA, SK, TH, TR', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(748, '4139_13-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 1.60, 'https://notik.me/api-redirect?token=eyJpdiI6IksrU1N3QlFoRk1YdGJ1L0pXTnRMZ1E9PSIsInZhbHVlIjoiTlEwVWkxSERqM01kM2Q1RWtxL1VUZTZ6aGUvMkg4cHVXci9xNEVaSDQ3RjdoL1ZLS0U1SFNlb284M09oaDBOeXA2SHFKM2NHMVd3WkF1OHBTeGliaHFJNWtKZGtuaWV5YzVwSk1VWUVuRStob2NCbzZmQUtJRDFobW5VdkVYMXRBR1g0QzRWZ0xrbGNWQWdUZG1aNFpVYk5ZVGwweG5NWUs5aEtmS2Z0Y09CNVpWZG5ITGpNakw1aW1ITnFaclcwTldxRzBXWi9pM1ZhVm1GNkg0bUxvc3lPM2VUUk9kMmdDWmpDOUlkZXZUYnZGMmtjRkpScCs4YkVpMnE1RDBwVHB2dmtDUmFyLzlQdXFiakhGTGd3UlBVak5ENWVaSW1YSzh0bHlaT1FwNkhzL0RoMTBCMHUrb2tSQXhoSjBUVkVVZXVtZXZIN0pXUnJ5Z2tpbUg5K1d2VnRXSW1RN0wvYkZaVndjNWI3U3RCQ1BUR001UnFEbTAvMlNPd1RvazhIUXJid2NBNi9YYi9pUG42b01wRzdhZDllakZjcllrb1VxRVJ3Unp4ZXZZejFCSUpxMmcvWHFsVGl0WjRXNzU1Z0M5SlVvekM1ZDA0OFp1N2l4VytFY2c9PSIsIm1hYyI6ImFmODc1NWMxZWI4YmJiYmNiOGFmMmU1YmE5ZjU1MTJhNWM1NTVmM2IwNDIwODU0NzFhYzgyYThkOTA5MTM1YWIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, HR, CZ, GR, HU, IL, MY, MX, NO, PL, PT, RO, SA, SK, TH, TR', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(749, '4139_15-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6ImhVYVJUa3J6dnBZdERDTURISmcwZVE9PSIsInZhbHVlIjoiT2ZPUDBvWVJVVzJZWUZiN0V5eFpOcVR1NVljbjFpVU1ob2o3TExqcCtld0xEWWdpYXRFemUrVWhoUU1lWkZZdUZDWmdweGJnZW04RGpoY1lsVlU1b1RIL1JDZW1OZG03SlgxOEVIdFd3dUxvOWVQcTQybkdncFpzQjhpZ2VFL3RqTnpCSXpoQlBycVVMeU9zV1pCYW5FbVI4NTVaT3JGNkx4R0lodzZ0SWlQc0JOV2xmOEtrUXQ3VzNvYTRjU2d0NzhlS0RDeHNlNzBhc0FBcVVpWUM1d0pISXBmTnZZbzN0c0JpYXpxTW5XdGZiaGVIeFgxK1N1OEJ5bVN6eUticzNWMFpuV0QyNlJ0Z3lDQ1B0ZG5KNGRGY094dFVpNmV2TVI3R0JrV0RIS25xWUVuZXJSL05tSlZUWTRQWC9Rcm9xdkdpMDZSK3lMSUdMVXVsTlBRaisxL0NxeUFjY3U4YVJYblZSMktDU3FUQTZVcE8yWlZsUzlDUlN2UnFMd1VtOFYyR0hnNXBxRmpEZ1JGWUw3YytmaGtMM0hqTHI0NWdDSC9JN2Vtd2JoMkNQRGV3MVNHcVRMNnRKMXFQYjdWaTVNOFNPK1NnSVVPdlFjY09BbStSOEE9PSIsIm1hYyI6IjJlYjM4MDllZTM4OWNlY2VkMGFjNWNmYTQwMTIwYzMxYTRlOGM0YjE5ZjBlMmQ0YjJlNzM5MjExMjRlMzMxMzgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, BR, CA, HR, CZ, DK, FI, FR, DE, GR, HU, IL, IT, JP, MY, MX, NL, NZ, NO, PL, PT, RO, SA, SG, SK, ES, CH, TH, TR, AE, GB, US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(750, '4139_16-MiSmb6BbsTg584VF', 'WildFish', '', NULL, 1.00, 'https://notik.me/api-redirect?token=eyJpdiI6IlZ1OEs1OUpycnJSSE5YM3dPRXZyakE9PSIsInZhbHVlIjoiSlBTV1IvS0xlclFoYUk5aWxQRDJiTWhweVMyM1h2d2xwcjZSYlQ4OWtudFRXWkFIS25XcXlrOC9mUXBhNjdBRno4MkN1eThidS9BUFRUQTh3NGRzU2FUUVN6bFVJc2U3RGFFaE9obk5Xb3dOQnNObGdpbWE5aSs3ZThYNTZJaTc3L3BJeUdnOHZWTTgxamtDUDNFYjc5SWVrMC9taHU1NTlyeGV4VXBSdEZwWXRoeEd1ZTd3UHdBZlZyYzRYSmFXZUNXNDVZU0Q0NC9rSkdXdFVKclA1YmhiYlArcjFEc3JPSkFJdFlBaHR1cGZxbWEzVEJXUkZGMEpRcHcrbENULzgyZmdjQmZEOWFiTEhLY24zZDh5aURLR09uRDR2SCtsMThoS3d2RVdxb2JhTFV2WUt5Szc0dE1qdUxOYThwQ3BaUzBmaVd1MmRRckp0d1JqdGhQRnJDL29vOXlMd1FLcHlTeWJMV3VQTy80Q1hzNjVqTU5CWmVYY3RGTEhhVytTYUpMaVBlMGNidTdxQlVHMlVpSmdqbDhVZ256K1NzYmd0TkxXZytGdzg4cEQrbkdrVW9lclNmaEpTVmExYmdUMXlBbk5xT1ZSdlhhOGUzVVROY0c5WFE9PSIsIm1hYyI6IjI0Y2IwMTE5NjdmNmJjYzEwYjNlNzJkZGY5MDE2NDkzYWNhYTllZDY5NDA5MzdjOTE4Yzg0MmI4ZWViZTgxMDQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, AT, BR, CA, HR, CZ, DK, FI, FR, DE, GR, HU, IL, IT, JP, MY, MX, NL, NZ, NO, PL, PT, RO, SA, SG, SK, ES, CH, TH, TR, AE, GB, US', '[]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(751, 'y4w47qq6w0', 'Red Clive', '', NULL, 0.44, 'https://notik.me/api-redirect?token=eyJpdiI6IittYnJITVlFaWV1WHBLTURwOGFldHc9PSIsInZhbHVlIjoiVEdkR0dUVVMwOURJN2hCbE9qVTB0aks0c1hVcEo4czVBelVlQS9OSEF2Z2VEOE80TjZnNVhQSWlKdFhIWUVEK2x5SjlFcml3Y3ROQmZvb25NTlJNdUxHcS9RYUErNEVGOWhEVitmZkVLL3BManFXeFNLWnUvV1dva09CbTYyVHo3WTc4VDRDRXhGcFFKWUdlbnZ3RWpmWjd6Y0xPQWlPK1dheUFaanZybldOL0JjRjhDc2lzRE55NkIrc1dmVmZUeitlTlAvWFFxSWJidExWNityVUpNOTNpZEhVTHozbkFiVEtkVVFVVmIzbGU2c0RxMWttV0NVK3pKOEVwZWwycndNRUsvdUdtUWpRMjBsTjhkaHlDdFlIR2VOS0lRMEVodjR3aHUycW5IbE8wdE9GVzZKbVNIcnhjbmU2bXIxdzEiLCJtYWMiOiI4MGRiMzMxYjk3YmZjN2U1ZGI1NjUzNzk0NzFkMjBkOWIwZTVkNTlhMTg2Mzg0MTg3NGNkZmNlY2FhMzU3N2FiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(752, '5931514-euMJk6uxkZa7CT1I', 'Wishing Well (Android)', '', NULL, 13.14, 'https://notik.me/api-redirect?token=eyJpdiI6IjBzWWlYb0JwdmVlQWZReExNb2Vra0E9PSIsInZhbHVlIjoiTEZ3ZGNsb1JXanVSK3YvbjdnTFo0THRQc0FlTUNLZ3BwTnA2WFcwOU9hVDZlTmw4eWRaSXN3Q1hmMVdzK3FWYkdzQko4ZlhJb0tjRUFURkd4U1V1dW9Ja2VtaFZpblp2cHNZTzMxL1B6ZkFIODdWWnFwSkJsUGFJRU9IS3NKTFN1V2lMZ3pTa0Z5b0ZhNHMzOEcvWFZRV2pMZVBvU0xvVzlKNXBiUlViV3J2VmZJeXp2bWdlYk84UEZ5NVh4M2xZUHVkVHVCQUhwMW9xMUN1Sk02c0I0MkNkbWR4Y2pXSFRTV2VabjU0Vnd0TmVUOXdMcnQxRzFPRzl5RTV2dkJFOFNBT3Q0TDNVUldaY1RTbzdKQXVVcHpSY0c5ZVVGL25iaWQvWjNObTRFanEzOHlENW1pN3RPTFRaWndMVmhJRVFma0l4RXYvOG1SVzRoYzV2VjE5WHZRPT0iLCJtYWMiOiI3ZjBiMWM4NWMzMTRkYTczZmZkMDgzZGE5MjI2NTEwOGY0NGZjODE0OGE2YmNiZTA3YTExMjVjMjBmODA1ZTg3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":898,\"name\":\"WW Player Reached 100_Depth Level\",\"payout\":0.026},{\"id\":899,\"name\":\"WW Player Reached 550_Depth Level\",\"payout\":0.312},{\"id\":900,\"name\":\"WW Player Reached 700_Depth Level\",\"payout\":1.8},{\"id\":901,\"name\":\"WW Player Reached 900_Depth Level\\t\",\"payout\":3},{\"id\":902,\"name\":\"WW Player Reached 1000_Depth Level\\t\",\"payout\":8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(753, '5931515-euMJk6uxkZa7CT1I', 'Wishing Well (Android)', '', NULL, 7.83, 'https://notik.me/api-redirect?token=eyJpdiI6IkxKYlNqakRxaE5PM3kwYXFsM2h1U2c9PSIsInZhbHVlIjoiUDNrTzE2VGFTWXV5NnBQOHhwYXlGY2RqcTFEcS9PWVFyY09DRnEwRm1QOEZqSU1zelhmTWwyTjJnaVpNR0prWnhvTC9xRmx4SStuMkswdjRHWjVUOWIrUitmQXZ5S0txQkV2YlNOcXUveUhMZXMrVEVnSGVBU2hhbjNKdmRRV3pKOEdIR1pUMTBxd1JENDhuSG5tWWdEQ3pqOFdUd2xheUJGVFhQNFRRKzBBK0pqY3ZPSHUvMWh6V0dhSnFtQm1vNTc0alFqMUR3SUZ0SWRsQ09QN01BWSthbmZuSEZ6Ymw1YVpjNUs1Z3QwcHVxQnplcTBpSnlIa1F0V2hyalhPMW0zTVRkL09tb2pvQkJpWW5EUEQ4NTVTckh5M2NCS0kxbmVIQXVyMlg2T2xmMzFXZ1NQeUdGSU5Qc1BZM013Y3ltZnpQa3RNUEVDcUk4MUZFbnp1NEhnPT0iLCJtYWMiOiJiZjU4N2QyOTVlYWMxNzUzNWEzZGQ1NzcyNjM4Mzg0ODdkZWZjODA0NDI4ZTE5OWIxY2Y2YWFmODFmMmU0YjNlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, DE, GB, JP, KR', '[{\"id\":898,\"name\":\"WW Player Reached 100_Depth Level\",\"payout\":0.018},{\"id\":899,\"name\":\"WW Player Reached 550_Depth Level\",\"payout\":0.208},{\"id\":900,\"name\":\"WW Player Reached 700_Depth Level\",\"payout\":1.2},{\"id\":901,\"name\":\"WW Player Reached 900_Depth Level\\t\",\"payout\":1.8},{\"id\":902,\"name\":\"WW Player Reached 1000_Depth Level\\t\",\"payout\":4.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(754, '5931517-euMJk6uxkZa7CT1I', 'Wishing Well (Android)', '', NULL, 2.90, 'https://notik.me/api-redirect?token=eyJpdiI6Ikl1eGtUOWhCUFBEdnZ5U0hIWnlIaUE9PSIsInZhbHVlIjoidzBORER5ajdVRG94S0R3Zm04RmUrbkd3RUIvZUc5ZTd4bTAycVNwRExSMlJIM2d0Z1kzQ3Uvemk4d1R3MG9KWVVYeWZ1V0V5TCs2cWlOOWl6TkJIdFhBRldUVFhsZVAvdFd2WUZhYm8zdW1iQVZKL3JsdThMNFNvQnhHZFJIa1FvQUorSDg3a1c1MEZSZUNDYzMzVCtyV2hHRklQVXpsc2svaXpja1hxMXpMSm5VTUxkWGF0cnFkbkhHTkdPTmc5MEVmcHozbTdJTlVrcTBxK3pmY1hZUnB5SUJwVkJMd2tpY2J1Ni93SGhHUjIvYVlBS1o0dWlEV3NqVDg3TE8xNW5tUFM3MmhyS3M5K05VVFJLTWd4MzFRcVowVzh1Q0draVZ1UkNMTm5rekwzNjdibDgxRmhGNnVHTjJwanFYOVJNTnFlemxJSTh2Vms2VHREcG1QNzl3PT0iLCJtYWMiOiI1ZjJhYWQwYzRjN2ZmYTNhNjlhOTc2YmRjMDMxNjhhODg1YmMyZTAxMTE4OWI2M2IyN2RiMzQzMGEwOTg0MDZkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AP, EU, AE, AF, AG, AI, AL, AM, CW, AO, AQ, AS, AT, AW, AZ, BA, BB, BD, BE, BF, BG, BH, BI, BJ, BM, BN, BO, BS, BT, BV, BW, BY, BZ, CC, CD, CF, CG, CI, CK, CL, CM, CN, CO, CR, CU, CV, CX, CY, CZ, DJ, DM, DO, DZ, EC, EE, EG, EH, ER, ET, FI, FJ, FK, FM, FO, FR, SX, GA, GD, GE, GF, GH, GI, GL, GM, GN, GP, GQ, GR, GS, GT, GU, GW, GY, HK, HM, HN, HR, HT, HU, ID, IE, IL, IN, IO, IQ, IR, IS, IT, JM, JO, KE, KG, KH, KI, KM, KN, KP, KW, KY, KZ, LA, LB, LC, LI, LK, LR, LS, LT, LU, LV, LY, MA, MC, MD, MG, MH, MK, ML, MM, MN, MO, MP, MQ, MR, MS, MT, MU, MV, MW, MY, MZ, NA, NC, NE, NF, NG, NI, NO, NP, NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK, PL, PM, PN, PR, PS, PT, PW, PY, QA, RE, RO, RU, RW, SA, SB, SC, SD, SE, SH, SI, SJ, SK, SL, SM, SN, SO, SR, ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ, TK, TM, TN, TO, TL, TT, TV, TW, TZ, UA, UG, UM, UY, UZ, VA, VC, VE, VG, VI, VN, VU, WF, WS, XK, YE, YT, RS, ZA, ZM, ME, ZW, A1, A2, O1, AX, GG, IM, JE, BL, MF, BQ, SS', '[{\"id\":898,\"name\":\"WW Player Reached 100_Depth Level\",\"payout\":0.005},{\"id\":899,\"name\":\"WW Player Reached 550_Depth Level\",\"payout\":0.091},{\"id\":900,\"name\":\"WW Player Reached 700_Depth Level\",\"payout\":0.4},{\"id\":901,\"name\":\"WW Player Reached 900_Depth Level\\t\",\"payout\":0.6},{\"id\":902,\"name\":\"WW Player Reached 1000_Depth Level\\t\",\"payout\":1.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(755, '5931516-euMJk6uxkZa7CT1I', 'Wishing Well (Android)', '', NULL, 4.69, 'https://notik.me/api-redirect?token=eyJpdiI6IkIxQnNIdFZXdE53K2tURzl3SzV4K3c9PSIsInZhbHVlIjoia3l2OVJFdjhSMHhCbjQvOGpnOE53Mk5FakZFZ2NodG9KSWhCd3NEWis0dHFvY1EwK3VQZWJwbTFWbURtT2o4cmZ1ckZqd2Zyc2NvUHhTMHVac3AxMndKRXRxZG5TT2JuYlNOL2MvbzA0UWpXR0RORE9MTFpWdmtTM0pRL1RydG13aHZnQTJhN1ZsdEg5NFFrbmRCSVI3cWt1ZXJZQ0VPcVd3REcySzg4QUNmVmdwbHJTaE5VQUxxa05VVU9CZ1BLb3UxRFMybGRVZVU1ZkRFZEZqenFxRCt1Q3JxWmZqc3J6Z0VrN2gyK1E5UitxZTl0MzdQZXljN3o0NThEaUQ2eEpINGpWOVhEbmNhYnpnQmwwSUt2TEFoUGZYWWtPSlhhYlZYcE5Gc3EvaVpJdktXNHRqYTV6K2hzUlo4Yk9FTThSazBJRzZhM21FYzJYUWQzV0FlK3J3PT0iLCJtYWMiOiIzZmFlZTM4Yjk0MTljN2JhNWQ5ZmViOGJlNDZmODBmMzVhN2Y0NTI4MTlkMDBmMDA2NGE3Njc1ZWEwZDI3YmI5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BR, CH, DK, ES, MX, NL, SG, TR', '[{\"id\":898,\"name\":\"WW Player Reached 100_Depth Level\",\"payout\":0.013},{\"id\":899,\"name\":\"WW Player Reached 550_Depth Level\",\"payout\":0.104},{\"id\":900,\"name\":\"WW Player Reached 700_Depth Level\",\"payout\":0.6},{\"id\":901,\"name\":\"WW Player Reached 900_Depth Level\\t\",\"payout\":1.17},{\"id\":902,\"name\":\"WW Player Reached 1000_Depth Level\\t\",\"payout\":2.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(756, '1302426-lZ2kToJFfVYWxuk6', 'BUFF.GAME', '', NULL, 2.47, 'https://notik.me/api-redirect?token=eyJpdiI6ImdPMCtVb1Fma1g3cjZrUVRIMTdHQ2c9PSIsInZhbHVlIjoiVVBKUTYyb3RwbE1PTHJVS1JKNmtGODBSODQycml6VS82Ync5bUxGbnlWMjJLYjRpVHIzOW1Belc4Zkk0RFlBWE5qbXV1YmZFQXZSTUxGcXFiRTlUdlRFSmE0UlA3aTlsUWNOSytOTkd6bTJ6N243U0U1MzgwYm15UGFEVFNsVllIbHZZVDZ1OHMrVkhkaWQxUWRoMlFkRGp2bDBLNmQvVnVxTVVMWW9zNHRpUEMyVXFIV0RDV3VNQ2NBc29OZmloWlYzcGVOeEFlc3loNjFRc1NCSWdOZHg0OWlLOGlhRWpaY1ZKOGhDM2Ewa2RjMDBKcDI1dkxnZmFLRE44ckpvYW5VRmttSTJDVU1ZSytrbkVOQ0xnUkE9PSIsIm1hYyI6ImE2ZTk4Mjk5NDQxMmQ4YzIxN2FjYjk2NTIwZDAxYzljMTI2Y2Y5NTI5ZTk4NmRkZWJiZThiMjBjNTExOWZkMDMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"3240d5e6-490f-11ef-838f-069eb31df495\",\"name\":\"Registration\",\"payout\":0.312},{\"id\":\"3240e0ae-490f-11ef-9692-069eb31df495\",\"name\":\"Purchase Subscription\",\"payout\":2.16}]', 'all', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(757, 'k15onmmj2q', 'Content Cobalt Blue', '', NULL, 0.39, 'https://notik.me/api-redirect?token=eyJpdiI6IjcrSTRxTU1KSGJnVEdCRzlhTUtoR0E9PSIsInZhbHVlIjoiZGx3amtMZzFUZkVEQnNxTDl0NWZYSnVnK0duUXlvNkRQVlZzcklRanlNcXFwL0VCeFN3NkNOT2FlWHZwQ2tZaGtIYWliM0IwZVNzcUphSFVMRy9SdVlHd3BmZ05SSzh5cDh1NmxCZm1HUDJJRUVScGdVbWlGNTEwdzFNWElVaDZzd1RYQ2d6NWZvSnBPRExHWmdJYlUxL1lsRFdtajRXK3VFbllEMGk3eWFoeGo3dWpuam9DUUludExET1diQ3Zpb2tRQi9kZVNKL29DTjFDdy9KMkk2MWNNZVdiZzQ4U0dqWnI5ZkY0N1NRY09HQVk2aFJQR1lzM09aZUVJTmFBeWhRcGZoM3hhODhnajM2c3cxcmFMWHRxVXNWL3lieE9PeFFMSE9ldFlRa3Q0dGZSYmZ1bTFGMDlFOFlza0pFaFc2QVQrSXFjdE9CQmVnY1JmOWw3YTd3PT0iLCJtYWMiOiJhYjQ0ZjhiNWY1ODk2OTU1MmY1MjQ4OGFlY2ExOTNlZTUyNzZiOGZlZjA3ZTA0MjRlNjg1N2NkNDI3YjdjMjZiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'OM', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(758, 'rx51q666w6', 'Content Cobalt Blue', '', NULL, 0.67, 'https://notik.me/api-redirect?token=eyJpdiI6IjJmWCtGMVFRVFRlcGtTa3ZTdEJHdnc9PSIsInZhbHVlIjoiNkgyK2F2Tk1yditwVDcrTE52cGxSdmhmMlFjODQ0K0tMTnc4Y2dMSmVtN0pDT0hyT2pVUzBjR3QxME1oT2h3V0xSR0Rva2h2VGtoNThHdVJZeEdWQWg0RjlmcmdGTmx2dWE5Z3ZoMEd2UVRRUzlGcDA1Q0ZMTklhYXcvN2Z0bU1qMEZ2eHB2RFFrTWh4SW5YdDIvb3p6M2lZcUxlaE8ycVNmWEZpS0t0WFFseWlrVDF0MHFVWTdFUmg5L2FkNnJSNmZQMXpUMDJ2Y3lVSTRLcjByWkxKdEFOYWcrUmttcENyUHFlV2FxL3IrcWJuY3BNTW8vbE1oSjFlQUl3WXJwUGx0WWU0aFE4R3BiN1llRktYUVdlVzVMMDF0b3p5QktyemFEK1pIRndMdjRLWFJER2YrSXV1YVo2aVdhQ2xQMW9RYk14N1h2a1BqN2pYNXJTekdJYmhnPT0iLCJtYWMiOiI1OTMxOWViNDM1OTk2OTdiNmY4YjkxNTk3MmU3ZWRhZjVjNzc5ZDA0NDlmYTE2ZDI5YmU1ZjkzY2MyNWU0NzM4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(759, 'kp5nnxxe5m', 'Content Cobalt Blue', '', NULL, 0.34, 'https://notik.me/api-redirect?token=eyJpdiI6IjBWc0dRMWlvQXFSSy94ZDRMaVVOUkE9PSIsInZhbHVlIjoidjYzQzlSNlRkSTBueWo0eUVJUkVNZFZnSWdtU2dLdXpTQUJqYS90NHBNUFRmVTlKbU1UQXc5NE03Z3ZmQXNWbyt5N1RVSFIyODJydzJuczZwZkFieWRtUnZaS2VoaG9yWkJqdkpWSWZ2RnAyb1FENHVHUkh4U3p1Ri94NjlJQjNwQUw2ODJkclIxdjZ4RDZHQ1piNlE5Tm9IdWtub0k1WUFNL3lKcm8wVEpNQmxVdFdaUVd1OFU3T0tJam9DZzhSc21FZCtOZFVETGd6TjYyNUV2UjR2Rmk5NDVwcXRKeWhDZHc1UmhjdGdISmJQZ2xzYjg3NmZtUVRna1NwNmtuR0k2STJrV2lIN0Y3RnZQT3pXT3BuY3BHMnhSNWZoVlVXRDdJbnhrUi9WTDUxdkFhSVRyakZkYkVRTHdJRVptS0FyTWZqaDN0VStFWlpaRkFBTFNiWVpnPT0iLCJtYWMiOiIxYWM1N2I0YjAxYzJlOGRlZDg1ZmM2ZGEyZDAxOTg2NDFiNjQxNjc1NmE2MWMxNjA3MDkzODJiZTlmZWM1NmJjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(760, '3M7nK230VLqGm7wKTSfbh-ZPwVWfTSwLIJu0B9', 'Night Hunter: Stealth Assassin', '', NULL, 1.40, 'https://notik.me/api-redirect?token=eyJpdiI6IkUwdHJXUThoZmJpM1lNK3lOVEg4cnc9PSIsInZhbHVlIjoiOVlDakNUWFBLbnNmbHFRTUxmbGoyWU9jZHVIRFM4cGFMVmsrOFpsM055TmxQMHgySi9wN2dEemlMOHZXN3dJZTRwQmF5OXR3VXNYbE5HMThFZmQ3NjNaNjQveE1jS3JHRG1XejZSVFgzOHRzQkE2ZzNMSlJIVWIvZ0JQQzNpa213QWc1eHZKVVphK3IzUy9wZ1dLWXpuMmV0cE9DeEhaU3NQTHgrcHZncVBXRUVGRWxVaGdGWDFTejFjaktBZW8xYzlieVJKRyt4Y05LcmVIS0crUjh6cDBGR0h5TUFlQ1pHdG9pTmVTUUZqYS9rZERwcDB0NmZ2bHhrc01aTDI4QmtER3VMYmIwRnVNajRuVUFkVjRMcjM2dVUvRHhmYmUycHdXQnpESFIxZkxMaW50MUJwMjREZzE0WkJMQnh2aCtwZDgvZ0xuY2RkbGk2SVdnaWd5RkdFNisrM3pVbCszYXVJNk9tWXlNOVl2Q2lUQ2ZoaTJncVE0RUVLcDNEUFIreG9ZSlBUUnlqSk05NEFBckhYZ05QUTFqVGlSTGNDa21EYm1DdEErZ3VxZG9rZko4ZGF6RG10dDcyK204c2ZwaUJYVDc3TGFOdE1tQm50NUwvU3lzNzMvMExtN2w0T0oySjk3K1E5anpleEUwZVZtNUZDRVp1Y2RlYzJ6ODlWSTgiLCJtYWMiOiJiM2NjYTVjZDgxNWNkYjRjOWY3MmM3OGY3MTdmODQwMDYxMWEyYzZkNTc2MmQzNDIzMzkxYWNjNjNiNGU4MzA4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, GB, DE, CA', '[{\"id\":\"20\",\"name\":\"Reach Level 20\",\"payout\":0.035},{\"id\":\"skin2\",\"name\":\"Unlock 2 New Skin\",\"payout\":0.07},{\"id\":\"skin5\",\"name\":\"Unlock Skeleton Skin\",\"payout\":0.175},{\"id\":\"credits100000\",\"name\":\"Collect 100k Brains\",\"payout\":0.35},{\"id\":\"purchase_no_ads\",\"name\":\"Subscribe to Remove Ads (optional)\",\"payout\":0.42},{\"id\":\"day14\",\"name\":\"Play the Game actively for 14 days\",\"payout\":0.35}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:55', '2025-02-26 13:11:11'),
(761, '5957492-euMJk6uxkZa7CT1I', 'Wild Fish (Android)', '', NULL, 9.12, 'https://notik.me/api-redirect?token=eyJpdiI6IkxuSXA3eTh1RUN1b01FalJJQlVxZHc9PSIsInZhbHVlIjoiQitWVXNVVUQ4M0tJSGt3N3JaRmVSN3hBQ1ltQlJFRVVNTGFmRmo4UlVNbjM0cEhiYzNVL1ZsVWlRdi9DSjRta1pMSjd2Vno4QUQxSUFXbmVhZjU0dFZIaHJVMW9DbC9qd3lTZzZFTE4ySWNFSkppVHdDUEVWNmM3UW9XcUFsR2dOanpPNElxU2M4K205Vzk0UHJPaGh5RjBiTm9FU0pSaklvajBDdFpPR2krQ1BsRHc2OFVzaldwajJBZ1VDMU52WWllM3pzaHI4bUJsYUtQNy9ZWURVVjhWN2FBaHRuWDBSaGl0aVpwNXZKZnhSTTU0diszRVhuUVoyTTJZSXg0VG1XMEJzNG1ITHQ1OUlzNWY3Tmd0ZkJhTEczZ2NCZDhTMGNiNk5KTUhhWHphQmFma3AzdXdFRUh5RmZ6ZytMRStsanFIVSsxOWZONlE0RnFyNUl0Y3pRPT0iLCJtYWMiOiIzZjRmNzA4YjQ3NzRkMTg5ZDQ4NWU0ODM3NmIzMjNmNjQyYWNjZWZjN2JmNTVhMzcxOWFkYjUyNDA2YjM0MzM1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, GB, JP, KR', '[{\"id\":5447,\"name\":\"WF Player Reached 150 - Line Level\",\"payout\":0.031},{\"id\":5448,\"name\":\"WF Player Reached 400 - Line Level \",\"payout\":0.3565},{\"id\":5449,\"name\":\"WF Player Reached 700 - Line Level \",\"payout\":2.366},{\"id\":5450,\"name\":\"WF Player Reached 1200 - Line Level \",\"payout\":6.37}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(762, '5957493-euMJk6uxkZa7CT1I', 'Wild Fish (Android)', '', NULL, 6.38, 'https://notik.me/api-redirect?token=eyJpdiI6IkJPTGF2dDRvSzdXRU1CS1V0Y1BtVWc9PSIsInZhbHVlIjoiWm54OUhFbUo5NU5jVjU1dG5CTFFYK2JFeW1KeWU5OUc0bHZCNnpCeVQ0bVZKK3IxQlBlU2kyVVNnc3hBb2tMcWlTbFJLRVdET2xFdlhkS0pldVlTbWtVK25tWjJQM2NGNXZmTUtKSE9ybnZNWmQvUWxZMlhwZjRXOGM4eW9mOVRqMk9BeXROMG9MWU1XSElRVVQ2UnZrZUx1bkc4Mk0yUU4xSStGRVBGSmwyNGJ2b3dnU3N3eXRkWUlIOUdsVkhZTk90bEQwcVp1ZmZIdmVyV2t0TmN5KzAxMlNJbldmM2hZOWRmRjlYYktPTU9VL1lFanpSNnRlNEZraWxYM2FGeTFKYlVlYm54Q1hDRi9jWEJUVzZNbWxQTFAyL3UxZUpza0xwMXp3RU8zMnNBL0ZnVTh4UE5tUWZJTmJJb0k5UVMyalpNSEFPUFVpL2JTMjNvTXhRbEpnPT0iLCJtYWMiOiI3Yzk2MzUwOTQyNWI1NTQ5MDE4ZDk2ZjUzZTZkYzczY2YwZGJhYmRmZDQ1YjU4NDVkM2U2YWVkYmFjODFjNzk3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AT, AU, ES, FI, IT, NZ', '[{\"id\":5447,\"name\":\"WF Player Reached 150 - Line Level\",\"payout\":0.0185},{\"id\":5448,\"name\":\"WF Player Reached 400 - Line Level \",\"payout\":0.2495},{\"id\":5449,\"name\":\"WF Player Reached 700 - Line Level \",\"payout\":1.656},{\"id\":5450,\"name\":\"WF Player Reached 1200 - Line Level \",\"payout\":4.46}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(763, 'jy2ropz62q', 'A', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IlRHMVhIM2RUZTFpNllsTy9lbHdWMXc9PSIsInZhbHVlIjoicm03OW5JOG9NdktCa2tRSm4rNENwM3JpRThKZUFnNi9zMU5vS3FERXAzdWFhc0UvNHhGQjRUcmN6bFU5TzRMejk4bDIwbGp6ZzNNTWxjOVJqeTFUdUNXakQwNTAzMEphdW1RdVM0RW5IMGo5YVRtZC9XRWZ5VUFqeTVVMlg2MnVwVHFQdU9FOERQQjN0QnlZemdLRDhNZjZCTVdMYm0xRklEY3Rub2NkQkM1UzZXRzJRQUtuN0JRS2psQjI3SnUrQ2w1NnZ5OXFRZC9jS2x2OVEwenZrZHhmUEZseEF0RG1IbDlxQzRVUzFvY1NLWVRVMkowek1MUmtoMGY1MGRNQkFwcmVBdTI5SytKUGtmWDc3UldyOEdaN1l0QkNqSGwvMllCbVk0OXJkdEZlMVM1aHNranRqNFpHZDFpclE0bDYiLCJtYWMiOiI0ZmJjMzA2ZjI2NTgwZGUwYmVkZDI3YTNmM2ZmMDFhMWQzN2M4YWNjMzM1YTE2YWQ3NmVlOGM2OTNlYTdjN2ExIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'VN', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(764, '1310149-lZ2kToJFfVYWxuk6', '2248: Number Puzzle Game', '', NULL, 1.89, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1MNGpCUjR6OWRxNEY5MzRWMzQvL3c9PSIsInZhbHVlIjoiNGtjR0VSZzN0bEs2VGxVNHZ0Y2QwbVdSQTl6WEpoZkxzNUR5SmxpOXVFTmFRNGZ1VmVDeFdMbi9BR2FHcC9ZVDlLZzh5U1J3VllITVhRYW1JZVBBUk0rZTAzUFgrWFRyYVNvcnROdjRuUUc5Z2ZIYnZic3R0bkNyblBSSDNiRGZtV2c5bWV5VUxpMHlVNC9Za08vSjA2Q2JCbkJYTDBqanpFdWRYWTZrYStzRUg0dnEvbG5ZTHAxbHBKSGtiVVJFZE5PSUIzWE5LRVBFcEJWTzEvLzJGbFBpZllwNXdFNkJnMHRrK3NVQjhFZk9YMitlaTNKNzFHTEp6WC9BdVpOdVhxbVRkc1VnUU5jR013N3BHdVBPNGdKOUlBZHVPZW5KUml5TU5QVEZZRXc9IiwibWFjIjoiYzI5N2M5MDc4MjY0YzFkYmY1MTI0NmM5ZmNkMTBkY2Y0NDE3ZGJiZTlhODhkNzAxMTAzYjI5NGZmMDAwZWVlMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, PL, TH', '[{\"id\":\"1b9d0b3a-53f9-4994-b00e-e48c4797c4d4\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"35f83a1e-eb12-4c8e-8313-85ec4884f1aa\",\"name\":\"Reach Step 50\",\"payout\":0.06},{\"id\":\"362099fb-3f50-4269-bbb5-04d03e4b50eb\",\"name\":\"Reach Step 100\",\"payout\":0.1},{\"id\":\"41b6780f-5ab4-4ed0-9b34-30e6ab1df991\",\"name\":\"Reach Step 250\",\"payout\":0.252},{\"id\":\"b1808f5f-bfdd-4660-a164-cb181add11fa\",\"name\":\"Reach Step 500\",\"payout\":0.48},{\"id\":\"3c595743-8c21-4078-98ff-345de9ed3302\",\"name\":\"Reach Step 1,000\",\"payout\":1}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(765, '1310195-lZ2kToJFfVYWxuk6', '2248: Number Puzzle Game', '', NULL, 14.64, 'https://notik.me/api-redirect?token=eyJpdiI6IjFZbnpLRUtmQit3aEdkN2pyT05WN1E9PSIsInZhbHVlIjoiQUdIV0phQ1lONytzT3NoMHBjTGhDT1VVc09vb1JVbWJ1MVlWdTJ1bnZLaXExOTVORTV3OWJrUXh1MjVEakEvR05HYWpHQ2d0MTlneFBSTEhzOW50b1hUVkliK2lWN2xNYXZjUzhLRnVzVFJWSlI3ZlBneTBFWlkzZU9QWFdOVXR4UW8vUU51bkprdERDL3ZBN1RIaWpSbEtpVEE4aTFXbWJvWk03Y251YTM1Qno5ZzZFL2dJMkNDSUUvU29DdW5uSnFZblFLVjBzWnFJS1NOU1Z3aW0rUUpmTW5sbHg0YzREcVFWMWFsaXBMRWFtWHViNHRCK3FNOEpLNU9tUHBhS1NXcGVUVWswRkZxUHUrRk1rQUFpUkd0ak5JbElqeE1MWkxKUThxZEJyRmc9IiwibWFjIjoiOTMxNGVmN2VjNjdmYWVmZGU2ZDYyYTZjMDdiZmU3MTZjOGI5NWRkNjY3ZWQ2MTQzNWNiZDVmNTkyZjQ4ZTc3NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"7f00560f-10d7-4175-9ed0-14fbb220537c\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"8692f584-6ff7-40fb-8ebc-d255f5323b70\",\"name\":\"Reach Step 50\",\"payout\":0.336},{\"id\":\"9c6387c5-b266-43e7-ade0-86993cd409e8\",\"name\":\"Reach Step 100\",\"payout\":0.62},{\"id\":\"7d2e57e7-0a09-4f2c-95a8-811dce39771c\",\"name\":\"Reach Step 250\",\"payout\":1.6},{\"id\":\"75cef456-bdb1-4347-bd19-4d3733a21127\",\"name\":\"Reach Step 500\",\"payout\":3.8},{\"id\":\"4164ab86-5a8b-4fbe-89a4-8991589aecfb\",\"name\":\"Reach Step 1,000\",\"payout\":8},{\"id\":\"97fdaa5f-42b8-4a16-b5fc-9decd8e8df3c\",\"name\":\"Make a purchase!\",\"payout\":0.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(766, 'xj5gq96zwm', 'Amazon Prime Video -', '', NULL, 1.04, 'https://notik.me/api-redirect?token=eyJpdiI6InlwckY2SlJWenJEcTBBcmpENTRSYUE9PSIsInZhbHVlIjoiRmJpSENJbmlZY2w2aVg3Z0c5OS80ZGdXMXYwSzdWbUZObnp5WG5IWStEVWlQOWsxTklyU3A4UHRKazQraitZQTZnMUl2TVYxa24vZ2ZGR2c5VnFvL203bFdvVkNOT3dhRzNqNkxnQ3hBdzVITVJQODN0ZE8rZ1c5eU54dnR0ZDIxZUtQaEk3TmhlY0pMTDQxaXp5VmlxODBWVFM0T2dSWmNQQzQ3Q01MZks0Y245NTZiRmdVeDNZbWdsbkZrMjZnbXN5L0JJQVpjLy9ncHpMR1QvM211d3FTRWNuZ20wdUM3QmJzdXlPV28yMTRxQ29pUFUrenRDUnFnR2JTNTFBTm5mcFhBcjRUbFE5OFMvWnhTTS9Bb0I1eVhjc21na1BGTW9SdHB2TXNja0l2VFhHT1NpYWtaQWlvTzBwcmxBbGZwTW1uWEdvNW4vWG9jUmJvZG5iN1JBPT0iLCJtYWMiOiI1YjQwNzNjYzM1YWVmZGRkMWNiMTNhNDVhNzVjZjU3NDgxNDg2NzJkMjgxNzdlYTQ2NjgyYzI1NzhmOTgxMjgzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, NZ', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(767, 'j05pk3xrw4', 'Deluxe Block Jewel', '', NULL, 2.50, 'https://notik.me/api-redirect?token=eyJpdiI6InFUWkFVaWQwb0Q2d0xLRHI1eUptL0E9PSIsInZhbHVlIjoid1BIMk5sOHgyWE5qSm9icCtCMUU2ZkNJd2ZSbGdadnByVWRqdW14WHFDUHgvNnp6MTJGZmFMME1DKzJ2ODhEeTlMSVNqcWE0Nk1XeC9ERE53OEpJaTJSd2VKUzRCbmNyaHM0NzdrYUlQQVc5T0lTdG51ZzRyWklYVW9zY095RDhFK1NsV3UvdXBuTmhYWFl3RTcxYmIvRi83UjdncFVhajNXM1J5Mk02YVo5MGN5VGlNTmZ2SlljM3JtSUpIaHJCNFE3WG5oS1NIdmRDWDMxeXhqTmVhTG5vcHgwMTU5RnVaOTNxNktHb0p4RnJqWnFIUndvczdlV1NCckIxSVdDZHZmTWQ3UE9adVhuNEd0N0hDQ25PRTFxRmdCRjRHY1N3T3A1V0NXTDlFK2FVa2JtNE5oWlp4MVRMUGY5UUU5clJOTVNRdnNRWFpoSjd3VFpGdThRcXR3PT0iLCJtYWMiOiJjNTdhNDBiNjk1YTFkOWQxYTUzMjMyYmJhNDVkZDZiNzQ3MTRjMDIwY2Q1MGVjNzAwZDg2Y2ExMmYyYTBlN2ZmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE, ES, FI, FR, IT, JP, KR, NO, SE, US', '[{\"id\":23426,\"name\":\"Reach Level 10\",\"payout\":0.176},{\"id\":23427,\"name\":\"Reach Level 15\",\"payout\":0.32},{\"id\":23428,\"name\":\"Reach Level 20\",\"payout\":0.728},{\"id\":23429,\"name\":\"Reach Level 25\",\"payout\":1.28}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(768, '631983_0-WU4O19ugcV0tSQcU', 'WEB - DE', '', NULL, 22.80, 'https://notik.me/api-redirect?token=eyJpdiI6IjM1Z3lBRHB1VHZiODM1dGkyQThhV1E9PSIsInZhbHVlIjoiWkl0SGZSOW5hQk9JaXNjU1ZWREFkbkJTM2N0MVJPTllPeEdFVnE5bjdibzlHeWpiSnp6dEpTeFFFWEhNZkpsUnFhUVV1ZHB3dGlYQTU3enA0RHJ6UEhDQkhhSVFFSnBMeHZqMDRDV3pETlRCaFlPK1p4aWlma2hndzJOclFsak5Jek1LUEx0WkIwUkpmSlM1T0hsVkVDY2VncG5ZQzZMUzkyY1ZKZERkRmdwSE44NjJwTnBZUFFNZWRHTTNQVXQzTmhTZmRjTEhEa0taUTdIdG4yTVdpbmMwVmJicHI3T0xhV1NaMGlWY3g3bkFhOGpUSE5TZG15UnBTa09zWnVwLytXTDNxaFVQS3FTQVBoRXVva1FlZUNtQllZTXhYdkgrTjRGc1h5MDRqK1YxK0dMR21IajgxL0dUd2trbG9kdC9vczlQNE0xMXBXaEFLTVBzUjhIOEkzei9LeklxT3Njc3hkcjhYSWgrclEweUl5L2llN3dValNNbDFZb3FycUxUcTlrcUwzUVFaVXIxOVZUUGNYZENRS0FRMzNkZFpHM0hFbUJhcmhkZDBXKzdXM0g3Zk1UbW4rRk9jMGozV2VHOGlGUDg4d1hiRWhDeU9KTmt4cWxFODNnUEV1RG9aZWJVWW4vZlZlU2ZSZDA9IiwibWFjIjoiOWQ1MDIxM2MxM2ZlMjRiNWU1NTU4ZTg5Y2EyMzNmOTI0MTk5ZDlhZGQzNGMzYTc2YTIxZWVhNzJhMmFkY2I3NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(769, '631985_0-WU4O19ugcV0tSQcU', 'US  (states NJ, MI, CO, TN, IL, WY, KS, IA, LA)', '', NULL, 34.00, 'https://notik.me/api-redirect?token=eyJpdiI6IlRmeGZPRktUbnlUU0NacXRJUFJlVXc9PSIsInZhbHVlIjoidE5ybTcxd3cxTUM1MmhBdnZRYllvNDdXOGJJSWg4dFhXanlJamFrTEFBbGdqdVFocEtnOWJrUDNoSUZjb1MvYlNLbEdoTld5UmlmbmgrWXBSSGFsWHRhbHJwYTl4Rm9tYUVxZUtrejJoTlVhVnFJYXB2cXRSWHQwK0tNVjU3RG5tNnp5U3FwY1grOWwxNTRROU82anZqckJTdzZqcEtTNWt3azBQUFMxQ1d0c25UNGYvMncyVnpvdkV5cXQ1b21yZWdRNmsyVFFSSjUrRUFCbUVmc0t3UWhMRWRDdEhhWE9BQTMzQ0hDM3BwNEZKejdVK3ZtZHRyMENYOW5ubTlUQ25sc3RaMzI3YXNackZIcTE1UUE3UTA4KzdJMHMwNWtURXlHYkR1Ty9XNUQxYTVGKzd5bXNkeUtLOU1XZmZhVWs5d284YVVKZjJpbS9YVnpIUWFhelVIZlNFUTRMQUdWSVNadjBTYURTVmFZWXh6bFdtVG1SNjV1eTI0QXppME1yWFlJTVBJOVFSMzNBR0VNMUU2N1JDUFA0dUNSSmIwdlNXVmpBOXA3dVE1RmtvS3lwWGxEdmtobGdGRU9nM21BSGY4R1NqbWpVTEs5NVB5TkRXVnQzWU10UDVOZ2pRbFV5NlM5alBTWFBBcjVCY2h5ZStNazNReEM5Ym0vaDNSZGQwVDlwWFQ1akxBY0FZZGhzbUNUTEp3PT0iLCJtYWMiOiJkNmU2NzYxNmFhZTY4M2U4OTY5OWM3OGRjMDkzMWYwYTAyNmFiYzU5NGEwYzkwNWUzMmM3MGMxYTI2NWU2NDE5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(770, '20680-Q0Fm7OXUFNcX72x6', 'Bébés et Mamans FR', '', NULL, 0.19, 'https://notik.me/api-redirect?token=eyJpdiI6IlQrdExjRDNkeFJPSlMxMmE5Yk1YSVE9PSIsInZhbHVlIjoiQWJ2WHhLemlXMnFKckFDRWQxMFQrYWhIcU8vUm9ZelRaajRwNnJwMG9qN2poMDVKTzRmVlcwSmpQTlhmTFNEcVB3R2dPSVRQNzE5eHhMaEs3RU00bC93OWxWNlBUc0pzQXRZL2FaWVZpUldJNHp0QnhXTkhVcSt0Mjg3QUxBRmtaeEVaNE9PMjhTbndET1FpNHREbUVMRjdvL3RhOXhOU1JzQU1QeVJDZlhjdFM0c0p6c2ZRVmJYN0ZVSWs0NmV2RHRRY3hkL1lmbmgvRFJwelovajQzbm1Tb1NpMU1DUGladE9UcHNTTW1lT1N6WE9SN3hWeUZjaDFQK2RubEI2SmJYTVVGTW9Dbm1MUXFwZmVHSVdJWGZmenU1WGh4SlNleGFZYkpPMHVISG1ZM1J6TUl0SjNzUWpWZnN3amhva1FvN1krVEZwd3RVclVLQXArY0w5UWVrRGRFUFRFUWUwNmJUdWkzVkJSa2NnTGVqVVRiZFBCVTVvTThIMWpVOUNkRmFoTHpTMWR5MjJNb05GaDNaczhQTytLNGMzajdMM0o0VmRzc3Bob3lYZ1I4UWRxcFNScEVDSmpHMXo5a2F0VEJUQ0srNGZuTVRmZUs1c0xVa0h1TVAwdC9uU0VnTzZPN3J6MkZONVFrZzZyVTZQcE1RSENoeGR1YytMSFdLYVZqUmdWRGVwdUFlb3MrOVZIQ0JlcTdBPT0iLCJtYWMiOiJiYTE0ZjZiNjIyYTUwMzQxNmNiMDBhYWJmNDk5ZmFjZTZmYTdjNDY4ODE3YmEyODkzMjY4NWEwMWI3MGFmNDBmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(771, 'vr5md9l65g', 'Search My Phone', '', NULL, 0.21, 'https://notik.me/api-redirect?token=eyJpdiI6IjdwamNOQUdheE5FMFZyOUN2RitkUXc9PSIsInZhbHVlIjoiYkRIK2F4bzEySGlCbW5aUjZLeVhrZnBnK2tRbi81Q1NwWjJJdVYzQ3QxVDIrVElxVkdoMnQxS1cybkZ3azFLcy9taGUrS3J3dEVhemcvdldKU0tZOUNUajFsRWZMK0xFY20ySXhmaXNkUnFBZ2dUZ1UrdDlLL3NBSEg4NFcyZjhjcS9WeitaSjZxaWlXcnNlNmErLzM2QnNPcmlMV3NuU1gxRmRJZGY2dGsxR2dGL2xmZGRHbDVxRkRYMGV2NVB5MlUxVTRoSEFaTHNMNml4bGM5eWlobWZMRXFRK1JuN2gwMXdsdG9VbGdaMHZ5OEFoY0pLSm5kcWpnOStmUGViRVBGZkgzM2hDcHBwMkRWc3NOVmN1TjU0Rk5XU2hrUVpmRVVKSXJvN1ZPLzl5ZEVra3JwZGlvRkEzZ2l4OGw0aklERFhrei9DSFkwQmdoYzVoZy9Ob3VnPT0iLCJtYWMiOiJjZmU2ZGQzZDFjY2IxNjg1MjlkN2FiMzg0NDI3ODRiNmFkMDExYjM5ODY0OTUzNWFhZTI0MmU1ZDEwM2RjMGJkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(772, '6k2yoneowz', 'Tic Tac Toe - 2 Player XO', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6Im5qQzlyTEI2SVExL043bnZMOGZiNkE9PSIsInZhbHVlIjoielowQ1hhU2ZQZ0xmdHgvVUVwaVlNYy85aG5EUG1PL1BxUVNMRzJLZ0lEYnNvbDFOeHZCbzlYSW9EYVo2UERiR2hxYmNpL3kwaC9EbGNweTYzUllzOURvYmZzRjY1emY1NGxCTHNyVUxrd0hkTHdHUU5INFVzMUVtYkwyUEt5OFFOOVVJYlYrN3pxRDRvMHVhZHRPa0Yvb2pmMGRmQU1rU2NYT3djTUNRL3lKNVZwakxZN0JFalRBNXpWbkE4VjVEYm9OWmZYVkw2YTUwOEdid1h3dzhCejVTRGk0VzZKQ3hqaktMa0pxQTJ4Njl5QzRPQjhLWndNNUhISG5ZeGFEMW9TWXJvVlkzVGhNOGtDL0VQLzFETXp2bU5Kc0lDcUEwTDk4TTAxWkk0ek1MRHZVdHpITmhUQXdmRExkQXFyWXZBTERCMHRGZDNMaldETlRqUkJwNS9nPT0iLCJtYWMiOiI2NjRjMDQ2OWI1NTE3OWUxMWI3ZTJjMjNkNjE3MDkyYTJiZTQwNmYyMjU2NDI0NTliZWI3OTdiNTEwNzAxMWVkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(773, '19-61066-PFzYpcfUMD0IDl5E', 'Hungry Shredder', '', NULL, 0.25, 'https://notik.me/api-redirect?token=eyJpdiI6IlhzQU14dTVFOVFueXlKL0pPdmg5VXc9PSIsInZhbHVlIjoiVlBnNDBoRXhCNTEzbGlHVGNpMXBKclV5dEx5SXVid1hnMUwyNzl6cngxNitqdEdkUHArRFdRZ1NjbS93L3pBalk4L3Bscm1Ham15Mnl3azdSUUpDcWxKT1pCRVU0alVHNkdUUnpHdXNEeVpSYk9aL2o0NmcyMXR3b2F2cGJjVnl0TDhQa0RrWlI5WjhGeXhuaDZEVU0vYjFPL3AxRElNQ1pKWkN6MlVXRHdHcU5MSjJ6MnRuc0JKN2tWZDBzMllsMnc3azhzMzFHTngvV2t2UmpnR0h5RkVuYUlxc0JXdXlwbEJ2Z1cwVDNsRFFFMDQxOUZPNzFVOXExWGZGZWdMMTFDdUNZL0RlWC9MNEFVT0xBK3hsUGlaZGQreTBDb0thdVhFd3VsMjRRZEtzUElHYkhlMG5MeEF0ZVpuUDNMcFljVkZwblpYaDhJRjlCU1JzZ0szT1BzUlM2Ym0yeXdWMk5iUUU3UnRrZmVJPSIsIm1hYyI6IjhjOTE0NzlmMGM3MzliMDU2YjYyNmNhNTYxYjJlZjBkNTM0YjdhMzRmNDkwODIwMzQ0NmQ5MmE0MWQ4OWEzMTQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR, DE, GB, CA, JP', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11');
INSERT INTO `offers` VALUES
(774, '677687-lZ2kToJFfVYWxuk6', 'Ball Sort: Color Sort Puzzle', '', NULL, 0.18, 'https://notik.me/api-redirect?token=eyJpdiI6IlpsSTE2b0d5ZGJLWUFrVEE0VFhRN0E9PSIsInZhbHVlIjoidUhORkc3blJ3N3k4eUJXT0w2SUl4RzdyazlEbGZrTko3RVRibFhHdWNPekgySkNtUm94cFBwTEY3c2FtTEhaMXlub3JPdUxMQTFyeVVaRjR2OG5OSURheXRtemRmckkyaG52bkIvNGY0bkQ0M3plM2p4MzlVdUovaHh2UUZZUTlWMWRxUXFVSFpOblIvVTVPcVdheFI5U2xvWU9nNUVPWmZjeUVBcjg2SW5RU0J1K0FRdkNORmJZWW53SWFYMFRNaFdXZFcwSFZxZjNHR1RucFNjWllCTitjRFIrajV5c1YrejVUSlk0dTErVmZWTW5OTGt5bGhkM0pKM3J4T3RTc3F0S0RiT3JaSGZxakJqazA0MmNwS2dVdmpnaE1lYXBBZnMzeE1nS1hXdnc9IiwibWFjIjoiNTQ2NmZmNjY5MGIxZDE2NGE4OThkM2JlODFjYjY0NDFjYTQzYjE5NmRjODJkY2ZhZmY0ZDMxZWRkZmQ5NjdhMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'UA, VN', '[{\"id\":\"81682544-ba1a-4c5a-8e8b-ac5040c0e0b3\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ecef7e90-9c36-47fa-a763-d95252e88621\",\"name\":\"Reach Level 100\",\"payout\":0.18}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(775, '1132130-lZ2kToJFfVYWxuk6', 'Lucky Bingo', '', NULL, 24.32, 'https://notik.me/api-redirect?token=eyJpdiI6IkdjQnFjb1ovOGlGWFhRait1NW9RWnc9PSIsInZhbHVlIjoibXBLbzZtYlpuUnhnV3R6alc1K1dTRWFuWjh6dDlVQmxMZitMZlZaYW1VSEVIRVMxa1hwYmo2U3lNdUJQVndxVDM4SzNkRWhnTEtEakZqcDlKK25nVkNXOVpiYTlPY0JYUkJtMTAySG85bnlNSVB5MDZubzc5dEZSK2NQSndvdFd4U3ZmTkJXZ1N6V00wUVA1alJ4SVdnOGhiam5Ta0lxR2hPelIxM2xVV0lUaVI5UWQ4dG5qQnJwbGZwNndwNFdjQXMxKzltZ2dsY2NCUnBQaXM4cEhCMDdyRG5HWmdyOG1Ybmp0TW9MaFJ3TTJrbXFJSnlEZ3VYUmxVdDN0WUFSVk1YYVlyNEZWRlltZnFpNDBDdHA1VkE9PSIsIm1hYyI6IjI3ZTliNTdmYjA2NDAwYmU0MmU3NjUxMGM3NmVlY2NlYjYyMTJiOGRmMDgwMDI3ZmVkN2YyNzRhZTg2MTk3YzIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, DE, GB', '[{\"id\":\"e899221e-edc8-11ee-82d9-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"e8992a84-edc8-11ee-8af0-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.032},{\"id\":\"e8993218-edc8-11ee-a1f2-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.128},{\"id\":\"e8993ab0-edc8-11ee-89fd-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":0.96},{\"id\":\"e899424e-edc8-11ee-aa0b-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":5.2},{\"id\":\"e89949f6-edc8-11ee-be40-069eb31df495\",\"name\":\"Reach Level 70\",\"payout\":16},{\"id\":\"e89951c6-edc8-11ee-ac83-069eb31df495\",\"name\":\"Purchase any $4.99 Package\",\"payout\":2},{\"id\":\"c2a3f3ac-37ad-11ef-8a1a-069eb31df495\",\"name\":\"Purchase\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(776, '6pwjd8p8wn', 'Games Bonus Pack', '', NULL, 1.18, 'https://notik.me/api-redirect?token=eyJpdiI6ImFiZWdyemdpVW5KeURQak56Wm1sbXc9PSIsInZhbHVlIjoiTVdNaHBtZmF4V0xjcDdibVJ3aDBoWVkrSnE1d2RXMkhUWmUrSDZ0eGhoVVFsOHBuM0h5ZHFFaTdPekxSWjRpQUhMaHNDNXVQNmRHYVFNUzJsSG9UR0VhcHU0WUdnd1NFaTFQNWRZZUs4UTFqelVycE9Ra3RqdEZXRDhMUEpqaGNKb25LV3hPTCs5WUlHZFRBZ2VYcUh2MG1QeXlGZW9aSzRGc25ia1dTSEN3bkVyR2EzZzVvNnhNM2MraW5PTnlhRGlpTnhTNFNuOFVIdDJ0NW9xN0kzZDNCbUFEWTV0bU5hNkJDYlZuTVJYR3E0b2tGdXFCQ3ZLMitVMGJjOTM0TEUwM3F3d0NkZ21HM1lVMkt4aXNpckpjakJKK29sUm5LTmNNMXhvM0FiWVMxc01LditRTTJMaS84Q2k2UUkzSkZuRjE4Y3J2UVJMZWFudmtpZWZaSml3PT0iLCJtYWMiOiI3MTIwNzhhM2IxYTk5ZWNhYTM1YTE4ZDliNzgyOGM5OWE0NDQ2NDkwZDNkNWQwYjdmYjI1ODM0ODM4MTc3YThlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(777, 'vr5mdxpv5g', 'Content Azorious Cloud', '', NULL, 0.56, 'https://notik.me/api-redirect?token=eyJpdiI6IkI5VDIwT2t3V0hBcUYxQ2cyWC9SZ1E9PSIsInZhbHVlIjoiYXJQUDdXaDlxRUhSNFpzMm9pWjRwMFAwemZ0eEdObjJMdExWWHZRb3BJV0kxTEFnZC9nZWZmZi9TZU1VaWVjV3Axb25TZWFzVUhlOU5Ub3ZOem16UW12dE5nb3FraGhpM1RFTFRuVHZRWit6eGJtMVppWWVMZnlTbGt2ZDY0U2FlLzdlZUZVWVEycml3ZU4vYU4rTVpDUTBHZWIzR0F3ckIydCtuUG5JR3pvbkMvOTlKTUN4aEhYVmZKTFlnL2RmWEtmbzFVWEVPaE9nemdPWlhTQksxWXZpc3kvZ3dpbysrZjljSnFsZ1YvOFJ6a1JVeW9jQ1NlM0MzUEhwWjdRMGpVYnVwQTJGai9qckhrZHpPK1EwOUZWaXc1d1hnRmsxWFo2NjFPaUw5SkRESWhGWUluZGovOGN0eUs2clBoOGpjS09QVXlwSzZvNkFzZDFxaldXNzFBPT0iLCJtYWMiOiJmMzA4MTU5NjliNzczNGFlN2ExNDc4ZWFlODZhZTUwYjIxNGU5N2E1ZGE2MjE4Y2E4NTNmZDk5OGQzMmUzZjY2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BA', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(778, 'vywxe7qr5q', 'Content Rakdos', '', NULL, 5.32, 'https://notik.me/api-redirect?token=eyJpdiI6IlRCT3BBbHRNcFk0OTB0M2FuajQ2NUE9PSIsInZhbHVlIjoiVWh6R2NiQXpCb1NlYTdjRWlWdTloWjFQR3UvMXFCUzhaMWU1eklIMnZoR3VjNmNjQnlHZkZpTzM2TnNXc0ZqVGF1ZEJrVS85SzViNjNVQW1NZUFrZjl6ZkJ3NWkyOXpDNVlHK3BiZ25xaEpycjhJQlVoeVNBV3JDaTZBLzN3SUliU1NYQVRPbmRMMlhlaWk5RjlPMTlzMG1ncEhnbXJMSStDb2dyWmJ0S1F5R1BDWFdqMi9IKzJ5TWNiaFcwa3B0U0hXelB6UGFMcGhycy9jRGEvcThSN3F0ZEd3Y1o2MHY5azZISGN1SktvczY5M2FnbGZDbjlqVFcwY044VXpoRGQ2Y0ltb0tyWVdSMHM0QWt1dHc4RjV3OU1nWXc2QURKY0N6eVBpYVFYaWd3SjIzaEhIUzBJbWxHSVpQb1pRVlFSWFM2YTZSVThCaHhJSVpvTEN6NWNRPT0iLCJtYWMiOiIzMTBmODcyYmNlZGU3YzE1ZjE3MzZmZGYwNGVlYzFiNmRhMzQxM2RkZDBkYjFhYmQxZjE1YTAyMzM3MDQ3OThkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(779, 'vm20rqgy27', 'Download Rocket', '', NULL, 2.24, 'https://notik.me/api-redirect?token=eyJpdiI6Im80OFo1N1ZsNWo1djEyWml1M1FkTlE9PSIsInZhbHVlIjoibUJSU1VzUmNqYXd3UFl1MlUrZDY1emlVYXBPak9wd0VOY2l1Q2VEcG9qQnJCU09oSTdQNURCR1loRXI3RlB4cHRIcTMrTFBwQVh5S2dRV09KMzdWTXdxaEx0VUpZS2QrQUVwdklKOWprRVFuQWM1ZGFwN2VlTU4zNmJmQ1pmMlpqU25Obmd2MTZGVW54eHFaVENtRm01c3RYcHN1V3hwcW91MFM0M2RlR1pIUVN3K0luUW53Z1dvakl1WWFiVHBhR2tzSGNKTS9zb05QUlFxYTFNMkdURU9ibHRsTmRVVFJBc1RjbjBBY2o1VG85czhMZVpDNVAvdFlQSjRwajZNTHQ2M2EvUlY0ZE9vazV1cjJmTWhselNxdnc4UlFNVER2RmR3MjRtenJDbHpkTXBpbVJFU2cvZkZ3TTZ1amZOb3pPS1RTT3dxZ21JbjFTSjBQU2Z1a1JnPT0iLCJtYWMiOiIxM2RkMGE5Y2RhYmQyYWIzOTdjNjkzNmJlZWZiODViZWQwNzU4ZDBlYjRkZTJjYTViMTdiMTQxMTRhY2NkZWNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SI', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(780, '632055_0-WU4O19ugcV0tSQcU', 'IsurveyWorld  - SOI  - Mexico', '', NULL, 0.26, 'https://notik.me/api-redirect?token=eyJpdiI6ImhDbXp3YXNPUmYxK3QrV1ZrTEVvRHc9PSIsInZhbHVlIjoiUEorU3lkNG51ZFZYcERXNjFwNmZVcGlMcjc4aXRmMjZ2djYvK0h2eVAwZEkycnJ0VnZlVFgxVmg0UWttRzBad0s4VkYwZ1lFMEJWQW5mWkR4azIzdEsyTjMyTms3OWNlb3VaWnliVEh5SjZBV1FKeDMwRzNkUVJXdUpyUWRtZHp1QTNaM290ZGZFeE4zNm1hWEZzQTJCTmhKNEJHVkNwVHl3Q2JyS1pMMXpXdW5FaTYwNXlaYVhXVTVPUzlBNGlVakNTNlR4WmNYL3lRWkhjZkJHY1NWSnhBTmN2ekhRMDFlSmZuWEY5OFo4OUJTWWY0Qit4YW1USjZBcDlTVUFmQkVFNFZBdzJBOHBWWU0yYmxuMW5TcldRbzNCakd0OGdFeDd3MVJkNmR2YlJvV0N5dnBhSnlNQXJvQVRmUW5JMjJ5UUliS1BsMHlPRXJoRXZLQWk5QmN4bzIzUCt4U1NiQWtsa2tzZERVUGR3S0ZPajk5aDFHSlRRcjZSdEViZHlxVDNjQmFMSFRxaU5kT0xFWnB3VFYvWmZLN1lMNERrcmRZSzloT0d6UVZ2a1lWSG84dkZ2TStocStQc1dLQ2JtWnZ6bjBUMlBtdUdIcGU3TG0vNWpkRG1VUFBVWjVxVWVGQVpES2U3Rkpwdkc5VzFubUpocjAyZlpoN2xxZkJGS0MiLCJtYWMiOiJjNDgxYTQ0NmQzMGEyMTFiY2ZjZTY0MTMxNTdjYTJmNzZiOTQyNGE0NDg3YTY5ZTc0ZGRjZDhlZTFmZGQzODEwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(781, '632056_0-WU4O19ugcV0tSQcU', 'IsurveyWorld  - SOI  - Chile', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6IndTSVRPNjFtV3ZBbTVxbXZVR1ppU2c9PSIsInZhbHVlIjoiNjBBWDNRRkdkWFVEdExReEdHbEFJUFRNUUdvL1JyMFZtc2ptY3UvaWdoNFo1K1g2L1RSL1F6UnFDMi95cUpGMEV1bXpTV1I5UWpCMFhzcStsaXZ0aEp2NFJ5amdWZ25QN2t1Z0c5MU9HMzVOQ29lbXN6dnk0aTN5cVZjVmgrdmUxM0NhVDRqb1pjejVCUGl1eDIyVjl2SmJweGJiZ1lFODRSSGxBNjdJbVRHeE9vTVgwVlVQNWN3TTlmaWsyQWJHcUhOcHZVd0xrL051YUFoWWRMbXRqNWRDcnVrSE8rTWIyT1lscnA3TEl6S1g5TzRuSUFubGJ6N1pmTUtleFkwTXRMQTBTUk5RNU9iemdXZG9yWGhJQ2FMa0lVVDU0WHBMV1BibDEyZ0EwVkpmNHUvK0taYkhjb3ZQdDFxS0EyM21RSDNNcVJlNEYxb3c3Z2YxdDdxMU8rczlyQnpBai9WdEdocmQ4bS83Rm9NTyt5WnZ2MS9MOWVONjZ1QWZkbVNNOEhhbS96aXlZRFhUc2VuZXFXT2l1RU5Zd0c1cHY2T2FZTzVHL0pLM3BPM0p2QkNwNklFVEFVdUNFRFBBVFR3WFBHWC9JVUt0WDdleXpRVXRybUdTL3o5c29rdE9UeWNubVhTd2dTYzNwd0g1Zkh1bm1pNHJ1NUZtMGYzbDJ4NVkiLCJtYWMiOiJiODNkOGUzOTMwMWVlYmVlNTI5NTIwZTVhZDViZDAxYzZiYWFlNDc0ZDMzNjQ5NGNhMDE3MDRkNmYxNWQxMTZlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(782, '1326718-lZ2kToJFfVYWxuk6', 'Blossom Block Blast', '', NULL, 4.92, 'https://notik.me/api-redirect?token=eyJpdiI6InhjbXNLTitSM0NNUDhpaWdxRVhva2c9PSIsInZhbHVlIjoiTHorU1hYUXRjT1N6SnliSHB6S2t6c2N0Y09nMUZqd1VVaE1IU0QxVmpReXVGQjloeFhhNElFVTNtSWlqMURrbGhhZHN3THRxVWlrekJjVU9ONnRkY1NyQUZNTWxvUTdkMWd5dmM1TjN5RTBjVHVGUGQrNlV6MSs4VnA3cEJqYXpJK1NEbVArQnZnYllLb2dZOG50NDQ5MjNKSG1PQ3Z6SWE0TTlkUnQ4aTM4TjVZSmE2NEVBc0tSeTNqcEg4VEIvNTZUNzFnR1BPeTB1QzYyTFE2d3dKTFhFNi9CVXZkcW9Oako5aXFsclhDY3ljeGZST1V3c3c2dXlaYXpGTkw2MkpxNnlqNDk2MlY1WmpCMENxRjhYNHErZERKRmtRcnhJSUhmWFNNdCtCZEk9IiwibWFjIjoiYzEzNDk4YzM3NDljNjk1MWMwNWNjZGE2NDc5MDg4NTE5NGQ2Y2JiM2FiNDBiMGNiMjUwYjE1ZDQ3MmEzNDBiMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, FR, DE, NL', '[{\"id\":\"b3ecc632-50ed-11ef-a2a4-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b3ece04a-50ed-11ef-ac89-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.004},{\"id\":\"b3ece96e-50ed-11ef-a283-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.04},{\"id\":\"b3ecf1e8-50ed-11ef-baa3-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.12},{\"id\":\"b3ecfa8a-50ed-11ef-afa0-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.24},{\"id\":\"b3ed0354-50ed-11ef-9de0-069eb31df495\",\"name\":\"Level 20\",\"payout\":0.32},{\"id\":\"b3ed0d90-50ed-11ef-8b96-069eb31df495\",\"name\":\"Level 25\",\"payout\":0.4},{\"id\":\"b3ed1772-50ed-11ef-97aa-069eb31df495\",\"name\":\"Level 30\",\"payout\":1},{\"id\":\"b3ed2136-50ed-11ef-a2d3-069eb31df495\",\"name\":\"Level 40\",\"payout\":2.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(783, 'DTgYknvsLEZE9le0MqUQi-ZPwVWfTSwLIJu0B9', 'War Thunder', '', NULL, 0.49, 'https://notik.me/api-redirect?token=eyJpdiI6IlFKOWJRSVBDcFBXazZaV25zaG51N1E9PSIsInZhbHVlIjoiVlQ2TGFwU01BTUgxTHU0dDRvUlptWUJ6UGdIbmZkb08wbmdaWGNPYUN6VjJBWkhTMncwbStFSG5sWUN6dGRUb0tOVDVndVpvMTNDdy8ySi81ZDRiVncySlJvV1FsZ1BXeUJHb0EveFVaWEx4UGluYUJqUGRoL2NNMmRTa3cwVzZjZjJrVm5QZlRuTjRsdm9JcTRqSk56ZWJ5bE5CUTZiTkR1bHhsN3pQN0hZcmc0anF3ZEwzY1VXOFE0U0I5MGcrQmFjbWJNUWg2NXpHcVVXQmNNazhKcG5xYnlXSmhVUnpwdmdQNUJQS3ZJWjhRSk1nNzdna0ZTbUE1WG5xSndQSHdKa2puUVNuNERXVm9UK1laLzAyR01lMkpCVkdHUUVjQVlLWGppeDdOQVN0TVJWMWt3ZVZUc3BhOU01MjBKOVRjWjdEdnlOSFh4SEE0eGVkbHFPYmJTSHVoWEl0UDdvQUxpbnM5UGJ1L3Z4bk5DVkZsU3Ywc1FYcHUyT3lpMFdzT3oyb1RzVjEvbkFqbWhmeHBGOG10Q2FxcHRTZWpoSXFpTEpPODN6Znk3bU96NG1NMklzSFNlOUpxV1JKRDl0Zzhlc3lMWm1SU3RkZDhJak9pUmt4dHRTY3FaQlFHb3lwWXczK1hJS2Yydlk9IiwibWFjIjoiYmQxZmE0NWVjZDIwOThkMWNjMDUzODk5NDI4OTNmZDVkNjQ1ZmMyNWRjMzk5NmZhMWNmOTI4Y2UxOGVkZDI0YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BY, KZ, RU, UZ, AM, UA, TJ, MD, KG, AZ', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(784, 'vywxe7j85q', 'World of Warships', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IkZNSTNobGZFaEJOdTZVaituK2JNS2c9PSIsInZhbHVlIjoiRjdvRnpCSHdyTlJ6Si95RDJEYVpmQ1J2elQxajRka0IrSG9mZStHM0NFVU5CQlgrS0J3MzVPdlZwcU1Na0RyVmFERWdGT2VIK0hxQkl1dWRMbjZmME4wL04xbTl0T3IxWnVBR21PbGRoTGNpWTFxOTU3NFY2YnBHZWRCZk5CZUNTQUhlM2U1U25SUi9PTVdKTFV0OU5jWW5zeTZYMnNreHhxalNaTmk2UWdhTE5pUmNQUVZFd2tLYWpFa2tGUHBXdnQ3VTdaTEVBbkhwM2c1SXZYQm4zZmZOcVNwU2dQRzlmWkpWM3NBU09oKzdKNVVRUk8rUmRtNml4OE1UeTZPbkpjWm41QVpBOVVhQ3Mrd0RYU1V6N3JYYktsZEMrRXFHN2VqaXh1ZjQ0N1RPTEZ2MGdHOGpDeXh1cFY5aXlLZ0pQbWhOaVBGVjNkelE2MzdHM1RJbzJ3PT0iLCJtYWMiOiI0MGJmN2MwMWI5OWI2ZTdiZGZhMmFlMjdmOGI0MzkzZTY2YjhmMzc5YmNmZTJhMDkyMjQ2MGU3NDFhZWE0ZTBhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE, AR, AT, BE, BG, BR, CA, CH, CL, CO, CZ, DE, EC, EE, ES, FI, FR, GB, GE, GR, HK, HR, HU, ID, IE, IL, IN, IT, JP, KR, KZ, LU, LV, MD, MX, MY, NL, NO, NZ, PE, PH, PL, PT, RO, RS, SE, SI, SK, TH, TR, TW, UA, US, UY', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(785, '1332902-lZ2kToJFfVYWxuk6', 'Sea Block 1010', '', NULL, 52.38, 'https://notik.me/api-redirect?token=eyJpdiI6IkpGTElRSmxEY09TclYyYUZmZWpmekE9PSIsInZhbHVlIjoiczRqazlRRGw0S2FiNk9FUVZ0SWhNa0c1VVJTYm4zKzlhSmRFaW84MUptaTlSR2wveW9Gd25KKzdseDgxRkVlVUNuWWdVZmxVL0ZqYWZWN3RFRnZYclY1aXQ1NG9ISzI4Y0FrZGdhRE1HYmR5VHBlS0kwOWJEYS8yZ0Vra0pQRE4xUU1DNEdBbHViRXVSWCt2OHlZNms1UWZqWTZyVlRqS2JxYUFYRnRFVEhaQllLSVhsNWtSbHhhOWlESFNCQzFuWFVFRGZFUXN1WG9OYkVEeWRHRVdIYWxXaS9sSUF1VVZweTZtQUMzVFpJcXVxRk00eEIwNUZuZ05LMXFrc2RqdmwwMnU0V3UvTzlnVnBSU0VYQ3dGYmxIbjJXcHpTMytZZlJBTHloYldKUlE9IiwibWFjIjoiZmRhOTVlYmE0OWIyN2U0OTg3MWUyZGFkN2Y1ZDE1NWIxNTk1YTU1NTM4YzVlZTdmNjNmODEwMTliMDIyMDQ2NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, FR, DE, NL', '[{\"id\":\"b0ed60a8-52e2-11ef-9df9-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b0ed6b02-52e2-11ef-91cf-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.032},{\"id\":\"b0ed7372-52e2-11ef-b432-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.128},{\"id\":\"b0ed7bf6-52e2-11ef-98c2-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.384},{\"id\":\"b0ed8466-52e2-11ef-b9ec-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.64},{\"id\":\"b0ed8d1c-52e2-11ef-bb45-069eb31df495\",\"name\":\"Level 20\",\"payout\":3.2},{\"id\":\"b0ed9816-52e2-11ef-b6fb-069eb31df495\",\"name\":\"Level 25\",\"payout\":6.4},{\"id\":\"b0eda16c-52e2-11ef-96b4-069eb31df495\",\"name\":\"Level 30\",\"payout\":16},{\"id\":\"b0edab76-52e2-11ef-8767-069eb31df495\",\"name\":\"Level 40\",\"payout\":25.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(786, '1332934-lZ2kToJFfVYWxuk6', 'Sea Block 1010', '', NULL, 3.36, 'https://notik.me/api-redirect?token=eyJpdiI6Ik1qWFFzcXR4SFZGc1Fjd21qUDZtREE9PSIsInZhbHVlIjoiNFpkaDNqVzQ4c25qM3lwa01iTVhCdTZWY2N2azFoM081ZEpMUHZCeGVzaTR0YXI1OTNOUm1VUnFDbTlMbDY3dS8wWE1ZcGo1LzVCWDRiR0djQk82SWd0NXN3NVpwUFI0Y2hsVUtReXA4TmsvaFc0dFEwd3FjZ250Tmhzczd6cUxJOTdrQ3phRE1YSXI5cEg4Yk9XM2dNV3RZdUp6ZkpRRGF1RHZIbEdMTTBINDBUdkJaTVNXZXFFMHhOQnZsOVVERXd1Z2QvU1MvYmJHQXZVUWp5NzhCOEF4bEt2OWR6cEJPS0xXTisvTlV2UEgvUk5PQ3IyYWdYZ0x3cVIyTEY2ZFN4VEZTT2xBaUVCcG9MVUdETExqZEE9PSIsIm1hYyI6IjQ2MDk2Y2UyZjg1ZjlhNGQ1NjYzZDcyZjIzOGRhY2RjYTU3NWJmNzIyZWM1ZWFiMWM1Yzg4MjIyZDBjZmViYjYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AL, AS, AD, AO, AI, AQ, AG, AR, AW, AU, AT, AZ, BS, BH, BD, BE, BZ, BJ, BM, BO, BA, BW, BV, BR, IO, BN, BG, KH, CM, CV, CL, CN, CX, CC, CO, CK, CR, HR, CU, CY, CZ, DK, DO, TL, EC, EG, SV, EE, FK, FJ, FI, FR, GF, PF, TF, GA, GE, DE, GH, GI, GR, GL, GP, GU, GT, GN, GW, GY, HT, HM, HN, HK, HU, IS, IN, IR, IE, IL, IT, CI, JM, JP, JO, KZ, KE, KI, KP, KR, XK, KW, KG, LA, LV, LB, LS, LR, LY, LT, LU, MK, MW, MY, MV, MT, MQ, MR, MU, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NZ, NI, NU, NF, MP, NO, OM, PW, PA, PG, PY, PE, PH, PN, PL, PT, PR, QA, RE, RO, RW, KN, LC, VC, WS, SM, ST, SA, SN, RS, SC, SG, SK, SI, SB, SO, ZA, GS, ES, LK, SH, PM, SD, SR, SJ, SZ, SE, CH, SY, TW, TJ, TZ, TK, TO, TN, TR, TM, TV, UG, UA, AE, GB, UM, UY, UZ, VA, VE, VN, VG, VI, WF, EH, YE, CS, CD, ZM, ZW, AX, BL, BQ, CW, GG, IM, JE, MF, PS, SS, SX', '[{\"id\":\"edce63ee-52e4-11ef-8edc-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"edce6e20-52e4-11ef-a657-069eb31df495\",\"name\":\"Level 3\",\"payout\":0},{\"id\":\"edce769a-52e4-11ef-9580-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.032},{\"id\":\"edce7f14-52e4-11ef-9140-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.064},{\"id\":\"edce878e-52e4-11ef-bfad-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.16},{\"id\":\"edce904e-52e4-11ef-a724-069eb31df495\",\"name\":\"Level 20\",\"payout\":0.224},{\"id\":\"edce994a-52e4-11ef-840f-069eb31df495\",\"name\":\"Level 25\",\"payout\":0.32},{\"id\":\"edcea296-52e4-11ef-9444-069eb31df495\",\"name\":\"Level 30\",\"payout\":0.96},{\"id\":\"edceac1e-52e4-11ef-82ce-069eb31df495\",\"name\":\"Level 40\",\"payout\":1.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(787, '1341621-lZ2kToJFfVYWxuk6', 'Super Tiles!', '', NULL, 0.48, 'https://notik.me/api-redirect?token=eyJpdiI6Im8rTm5Ga2tzSG1LMVZ6MFlWVk5rYWc9PSIsInZhbHVlIjoiVmxIOGUzVW42b1h6dVR3WHhYWjUyQmFja1FYOFZHQWt2ZlBkbGFMSVBJUjIvaWdHeGtjTjJXUEkzNnFGR2liVCtNekc4NFZqWW9DUEE2ZmptaURHeUZLc080VXJkTFIyS0FabzlMUHhzUDRCQzUrT0pjZUFlSFNyTGF5ZlN0UDdtTGlFZkl3K3pxT1RpZDVhVHFTcmR0ZVFGeW4zRU9yQXM3cm84N1JqVVB3SG13Ump2Z0VkTmhhR09rOTkwVkFrRmlWRWd5aWxDQVp2OEZteDRndjVZNmx1bEtoZVU4VHZTK3MraDlzaDJnNXgyVlFMYTdKZllqNmMwZGlLL1ZHcHJZYXA3ZmxtQTNWcTJsU0RnRVJHeWc9PSIsIm1hYyI6IjNkNGQyNjlkYjJiZmE0ZDA0YzQ1OWZmODUwNDgxYzk1N2M1OGU1MjAzNGViNmJkNWE3NGFjZGE0ODVkYjUxOWQiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"53da049b-f3b4-4348-84a4-fe7908fcf202\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"b802300a-9237-4689-9835-deb0e0d26e06\",\"name\":\"Complete Level 10\",\"payout\":0.02},{\"id\":\"a4cc5144-fd23-4b24-8b9b-4bc70d34fb44\",\"name\":\"Complete Level 50\",\"payout\":0.06},{\"id\":\"92a84acd-f7cc-4e35-81fc-943e93aa3147\",\"name\":\"Complete Level 200\",\"payout\":0.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(788, '1341622-lZ2kToJFfVYWxuk6', 'Super Tiles!', '', NULL, 1.48, 'https://notik.me/api-redirect?token=eyJpdiI6IkVJL3BhbTdEMGJ3MlJOQmJnWFVmU1E9PSIsInZhbHVlIjoia3dzeVRrVWZlNjRsaFdBT1pBeVRpV2FFMHcvdFFiQXRIRm4wV0RiTkg4V3NuQURyS2xSanZBK2RvS3NMNFlNTEdyL2RGR2QvZmxtcWRpQzB4dnlTalZXUVo4VUlGcWgrQlJqN0NSZlBVaWpnNU1IN1BoREpPcG9DdWVPaE1jN1l6Z0ovN0dyTmZqOUJWL3doTGxmZ2N5eWpYMTRTeGluK0dEUHVMOXhURjE5ZU1FWUZPWjhnNWM2NU9nMlFhL0lnL0RRdEFrcGRCSFNtNXBBejY0SjhieVhsTjRiRjVMQVEzaHEvL3ZBMUJnM3BvMEpPM3g5TUNpWWk4ckxCVlRwNnpZQ3BGTU40TFBybUFVRU84c04rSHc9PSIsIm1hYyI6ImRjZDE2OTczZWE4MDIyYTAzMzMxNzEwMTc5MjM1OGY1YWNhZmQzOTBmZjhhZjBjNjMyYjNiYWI2OGY0YWY5ZmMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AU, DE, HK, IS, JP, KR, NL, NZ, NO, CH, TW, GB', '[{\"id\":\"a14c8070-b819-4f75-8783-fd668704f185\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"0cf8cad2-db50-47a5-a3a7-aa34550c25b0\",\"name\":\"Complete Level 10\",\"payout\":0.2},{\"id\":\"6eed671f-6390-426c-84ff-c677618de3cd\",\"name\":\"Complete Level 50\",\"payout\":0.28},{\"id\":\"2ba29806-eedf-4408-abeb-7c220c6a939e\",\"name\":\"Complete Level 200\",\"payout\":1}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(789, '1341623-lZ2kToJFfVYWxuk6', 'Super Tiles!', '', NULL, 0.94, 'https://notik.me/api-redirect?token=eyJpdiI6IjNWem9tSXd5dk02bUdhYjdudlg2bmc9PSIsInZhbHVlIjoiV25PSlNIWkZkeFJTdXVBQTEzZTFWMEFwOUlQSTJjM3hXcjluVW9sTUtRb05XeWNhL1dwSnVwUUxKWUJTVWxwaXRmeWtwSUJCYjNXSmxoM2xuOWxSc1ZwQWZaWGw3Z3d3Z1h2ak9aS1ZJWFNpS1lXVWFvL0k1R0tyQVBkMGxyMFBLRURCWEg0N0h4QTB4d2VRcTVmdFViUkpKR0I3emxYZnhnQ1Y4NWFESTc0aStLOFIwbnRlNlpISFhaK0paanltOXpoSlNHSDJBcVh1MUlodXRVUjlsWTNhckZERjViU3Y5aCtZeHFOSVVhaDM1SEsyUkl2T3ZrQUdFWWNKWldnc0xuVnB1bFBkVTdWeXFEd0g0Z3pKeWc9PSIsIm1hYyI6Ijc4M2Y4NzBjY2VhMTg1M2I2ZTg0ZmE2MzdhYTIwYTAzODA4MDBiZjM3Yjk4YWYwNjdhMWEyNzA3ZWM1NmZmZGIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, CY, CZ, DK, EE, FI, FR, IE, IL, IT, LV, PT, SA, SG, ES, AE', '[{\"id\":\"3b398f0d-3b86-42b6-9fa4-adca5e0814c1\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"813ecf32-1e8b-4850-a633-1f90fad59350\",\"name\":\"Complete Level 10\",\"payout\":0.1},{\"id\":\"2896b761-bc64-4708-8c45-838eb9ce1b48\",\"name\":\"Complete Level 50\",\"payout\":0.24},{\"id\":\"f61136e0-209c-40d2-9370-1d967092f05f\",\"name\":\"Complete Level 200\",\"payout\":0.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(790, 'vr5mdxe85g', 'BingeSports', '', NULL, 0.78, 'https://notik.me/api-redirect?token=eyJpdiI6InZGV1ZVQnMxZXdZcnp0K09UZ0VSa2c9PSIsInZhbHVlIjoieUVsYi8yWW5IeERUZTdrYnRHbnRxT3RzWU1JbThVZGpuQVBVNWo2MTNjVWUrS0NSZ1FRdVhZWWt5b0p4dUFNYStVbE5jK1MvRmM4enM4QWhnaHBWd215a2xiSXBrR3dRZXlBaVpSUlRGR3g5d2hSTUJ2RWQ3cjBJZHBTSmQ4VE9vRStVaFJWYVRIVFB4c3lnUXBobFY2UzlCb3BHTkdmd3p6TTVXWWs2N09PN3Z1ZEtibUFJc2N0RVRZSjRIKzVwOThDcWcvU2lNNnA2T0Z5K0lJK1Y1bGZ1Q0VRRjI1aysvMTJpSEZPaFFpcjBlZDJZQkF2S0UvdzB2N09Nc0ptZXE4b1c1RlpWcUpueXY5U1VvMEo0N2duemg1amJlTTc5Rk9wSXA0MGt4Vy9qYVp4QXRETGZyRk13NGRpRjRKUCs0NkM1N2hQbjRMTGF1SlR2bXljZlFBPT0iLCJtYWMiOiIzNjAzZWM0YjYwYjA3OTA4Njg0YWFkZTk0OGUzODdjMTliNjZmM2JlNjlhYTNjZDY4NGYzZTdhYmViZjY3MTQzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AE', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(791, 'vywxe7r45q', 'Content Barbie Blue', '', NULL, 0.58, 'https://notik.me/api-redirect?token=eyJpdiI6IkdKWG9FR2Q5OXFBTlQ1N2VTUzJyU2c9PSIsInZhbHVlIjoiQjZCdTRtTzEzYndhclNkZzhLd3RzUW01T3hDWDliVVB1c05LVmt5MDRiR2hqOXVCQUxsRmRocnd5cHgvc2JsWSt4TFFsTENnQ05sYlp4QmUxcFczZzlQdURsYXlMUDJkNzB5akVDaTRsV2xOZnhLa2ZhNkNGZExGZ1g0WEQ2UzJLMXZYbXBsMXpteHdmR3pTVUFLMWkzdlpEMmNZYlBpdTJDN3RNelg2TWxNZ1pET3lyTWlGOUVvTGtuNHhYR2pORWlKY2hVOStDMjNwemRXMk5kVVJZa29IdUVxcEk3a1ZJWnJnRFEzWDlJTlFpWXdYc2RoMGd5ZW9odVJCWnFKdkF0emVZd01LbHFoV01mYnRPNThIbTJtZ2s0bFVqT1NuUVlvWVFrQ0tlZjdxR3ordGVZcmxpZ0daZVQrRTNRODd3TjAwZDN2aGxpMGJhMlBFYVpsQk5nPT0iLCJtYWMiOiIyZmNkZjlhYTkzMmRiMDFiM2EyMTk2M2E0YzE5M2U2Yjc5MjU1N2QwMDQxYWMwZjgyNzlhZjY5MmQ4YjZmODBhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'TR', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(792, '1332901-lZ2kToJFfVYWxuk6', 'Sea Block 1010', '', NULL, 52.38, 'https://notik.me/api-redirect?token=eyJpdiI6IjRyNytWN2ZQaWRxUytZdzNRd0lvR0E9PSIsInZhbHVlIjoiQzdhZEE2MG1zaTFWT1phMDBVL2dPTk14MUk0RTFoUUcyOEEvMjcrWC8rSWtoQnFyOGtrVU5DcXVFeWRPeE13VDlpS29oS1lneENzMjFJOHVmRGkwQ1NvQkVXckRyZGlqZHZ2bktRQnY2cy9PQlRleURNbTJSQWVnTVUxYkMwc0JjMzlVRmh5dEVOTmZlSTlyaWZKOVZZU2JBbWZnQzc3bjhXL2t4RTczc3l6cnowa3hiUXpWeWh5NmR0Z013aitGaEIvZXFKUHRTcVRFckcrbDhEZG9RaXMwNHpyRFZNY0JDNXNHb05TZTV2bnlTWFBVSEFFRWc0MkZ5d3paNGFiUnMvdnZCNGtwVFhtYnFPWDcwOWNYN3IwYUUxQkU2ZUJKY2FFOTU0TjVqZkk9IiwibWFjIjoiYmIwN2IwY2Q0NTY3OTk2MTRjZDYwYmNmYWE1YmY0NzEwMTQ4NTQwMTk0NTNmNDRkNDY4M2U0OTE5MzU3Zjg2NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, FR, DE, NL', '[{\"id\":\"b0846ce2-52e2-11ef-b009-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b08494ba-52e2-11ef-9abd-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.032},{\"id\":\"b0849f46-52e2-11ef-a618-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.128},{\"id\":\"b084a7de-52e2-11ef-965e-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.384},{\"id\":\"b084b102-52e2-11ef-8c20-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.64},{\"id\":\"b084ba26-52e2-11ef-b426-069eb31df495\",\"name\":\"Level 20\",\"payout\":3.2},{\"id\":\"b084c3c2-52e2-11ef-a192-069eb31df495\",\"name\":\"Level 25\",\"payout\":6.4},{\"id\":\"b084cd04-52e2-11ef-9543-069eb31df495\",\"name\":\"Level 30\",\"payout\":16},{\"id\":\"b084d678-52e2-11ef-978b-069eb31df495\",\"name\":\"Level 40\",\"payout\":25.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(793, '3811_0-tRWsYX6ZmTJNcgXp', 'US - Dailybreak: Stok (CPR) [Android]', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6Ijc0Vndja1VMYndMZWxZQURxUGtjZlE9PSIsInZhbHVlIjoiVjVCZzQrL0J2YTZQbUJFR1NtR1ZMR04vNnBINWl2Y012cjZ6anBuV1F3UGJNaVNVUGxTcmZrTjZTY0VaWkhYV0YwVEZTS3loVWFDTTJNbnQrVTdoeHpkdUVzdjU0M0R6TytqcExCTzVwemF4Uy9jQVRiMU1aQ0FPRld5bVVyMzZBdnV2TWNwdkxpMFphNG9NQ1A3Qlp6MEhkK2VvZHVpVHlkU0NkV0FjNk82N2VkN3lHT0ZCS1pkOWhNeGlEOEJMVjVhcVVZQmo4WGcrVUYxaDk0Q1pubFJ4NVJxUnZlSUw5L3FGeFdCZ25oZFkzUkJyRU84b0QzbW15KzhWbXdoYVVtZHc3aWdoUzlGcFczc3ptOHFtK2FEWWhQcUo3YVNwV2ZIOGlKUUNhWXAyZEMxZlg4S00vdnpBZmlRaFJnTGwrakhxdHkzL2x3eTJvcXJ3dWd3eSt2Y09CUXJQTk0xM3FPQVNsZzNwSHlibm5LTlN3YW5oTERuNzcybkEzLzlubk9QOHFaVGFISTBBVGdKT2xmdWlkeW55ZDloWEZuUmhZdExYcHN4bWIrdUp1Q0NvZVRiR3g2MXBZcHl1d3BFZzR5bWVBODkySGZrQVNzalZPeUZpZ2t0YTBtWFk2clptc3NLSk1uSk0xaytNMmhDbGtvK3pqMmpnTWFJU1FHOXEiLCJtYWMiOiI5ZjkzZWExNTgxMDQ4MzljNzNhNDIxNmZhNmJhMGFlYmQyNmQ0YzhmNmZlNWYyODg0MjUxODY1YWUyNWNmMTFmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(794, '1327190-lZ2kToJFfVYWxuk6', 'Wood Match - Wood Block', '', NULL, 15.87, 'https://notik.me/api-redirect?token=eyJpdiI6IjhVbSs1Z091d2tFMGwweG9jemZtYVE9PSIsInZhbHVlIjoibWJYTVVGRnN3WEhiUXpnK1VPc0w5SHcwdlVXRnlocVlwZkFIN1NWdE5za1FvSm5waVI1bThzRkhKM1lzd0R2NE5LUG1UMzdmeCtaeGpoVlRhZTRKSWZyZ3BtdFd1VTFNNlF4Mkp3bmJaaFBwNnhCWEFjNFZteUdSZ1VHNzM1d0xQTk1xQW8vY09CREsyVTFNMkhNN3FsSUU0VGlaZHlrcDl5VG9RZlJVcHpnNlpYYm1hTVdLemxjbnFva1k1VS93ZDBHSlVva21WaHlSRzFTUWJrNmJXdFBmdHJybjJIUGM3UXVhUFovMlpZNHdHQ3VFa1BDT3lNVWc1Y0MyeFc1Zkc0RVU0RGZWdU10NmlWQm9LS1FHRjVhbG5BUCtPd3R6c1M2YS9lZmdkdzg9IiwibWFjIjoiY2E5N2M2ZjhhY2IwNWJmNzA1OGEyMTMwMWRhODJjMmU5MWRkODRkMWYwZDU4NTBlNjVhMTU1ZTJjZTE1YjVmMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"8656da68-5116-11ef-af68-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"865702a4-5116-11ef-be03-069eb31df495\",\"name\":\"Complete Level 15\",\"payout\":0.096},{\"id\":\"86570c22-5116-11ef-8e28-069eb31df495\",\"name\":\"Complete Level 30\",\"payout\":0.192},{\"id\":\"865714c4-5116-11ef-b13a-069eb31df495\",\"name\":\"Complete Level 50\",\"payout\":0.384},{\"id\":\"86571dca-5116-11ef-9a8c-069eb31df495\",\"name\":\"Complete Level 80\",\"payout\":0.64},{\"id\":\"86572694-5116-11ef-8268-069eb31df495\",\"name\":\"Complete Level 125\",\"payout\":1.12},{\"id\":\"86572fd6-5116-11ef-ae97-069eb31df495\",\"name\":\"Complete Level 250\",\"payout\":1.92},{\"id\":\"86573918-5116-11ef-80b4-069eb31df495\",\"name\":\"Complete Level 500\",\"payout\":3.84},{\"id\":\"8657428c-5116-11ef-af41-069eb31df495\",\"name\":\"Complete Level 1000\",\"payout\":7.68}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(795, 'kp5nnm885m', 'Lords Mobile: Kingdom Wars', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6IlVvZEVjd1NFNFltVjB1L0tNcUd1RVE9PSIsInZhbHVlIjoiYmNRc1JNNUFNS1hycGJUZHorM1o0UndPajdYZk5pY3BXRlJKajdaK1pPNys3TGpTcW5TZUZtemdiNmtVdUVoTHNieUhnZm1DUTB3VmxlblY0RWRTY2psdEpoTm9KQ293OTlDNUkycWtXYllmT0RiRm9KSGo5VjVWVjFjWGF5YURiTGcrbXdrQWhlRFoxMVA1NGtjeTlMLzZvWEQ2Vm5OOEhXT0ErNGVLMkY4cHBac0V1S1JzTGJCWDd1aG05WTdOa2J0SHRXelJvcHJoczg0SWdxL0syNGQrb0grMm9UYlUzKzVqVzNveExHcXJ5VnU4Vk1qNHB5eG52WndSeFoySWhQTnpDRkd6UE1pSi9ZVXk3UkJKY3p1ZDRFY2cyWnloUlNIRnU4MUI3UXhrYlVudVVuSE5HcnZmNENmNkY3alNQU0NhOW80N1RvS0F2NHQvYlFxY0svWFdWNHhlUEhXQVBvdlR3Z3dCdElFPSIsIm1hYyI6IjEyZmYzMjg3YWY5ZGM0MmYxNjRkMGQwMWI2OWVmZmI2MTAzNjYzY2ExNDY3NzM0ZmIwMDQzODM2MjE1ZGJkMjciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PH', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(796, 'vm20rqxz27', 'Download Ready', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6Ikd1TGVwc2xsd0xGWER5Um1kU1Nic1E9PSIsInZhbHVlIjoiUW8zK1pXdnprMmhWSURxQjRNb0NRMWI1OEJBVjhrNlJlRGlyT0VkcFN5T2pyMGhqQTZIcFQyL21RS0cwY3V2OWVEUjhHclFDeU0rSiszb2hPNkJXOC9EL0VJT1MzbWJHUlZwdFlKNHZnYzV1YjBGbTFTTDVoRzc5OFRZSFRRRlZEdDhCWWdyNjNFM1A2ZlFoRFp0a0NWM3pUUUxqT0UzaDVlS1JVdlFtaWZNWi9uMkVNdStZd2tjRHVEbGF5YktVSnJ1TkhCa2hrdTRXZWJTNmdVQTB6bDBxNUtLT2hYb2JwZ1JKcStkS01ldXR2LzF6VHRGaWtyRWZ5NG9wckltelFWZkhESnFJWFM3N1V3OWgzZ2l4ZytGVTRkNnluYmp5UlJDejFzenBhYnZwUW1TTEtuL1RrZ3Y1REtZaGxONWo4LzR6ZnRLT0V4M3hhK1g2NVFpOFBRPT0iLCJtYWMiOiIyZjRlMDA2YTFmYzRjZTA5NDM2MDI3YjJlNDlkOGRmOWQzZGIzMjFlMmIzOTRkYzlkY2NjYTYxNmRlZTlmNzM5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'VG', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(797, 'vr5mdxm85g', 'Download Ready', '', NULL, 0.36, 'https://notik.me/api-redirect?token=eyJpdiI6IlVjcFdPMUFTVk81UENzRkJjcUNiMHc9PSIsInZhbHVlIjoibWFxcEJSQXhOd0crMUhGMWpyUTA5a2tLVHUyRDZjclIvRVRGd24zOU8wb2h0ZHBxL0NXN3d4RUs5c3FDOSszTThlbVgyRUMyTElzaUs4WFNZZUF2UzA1R0VCN21hQW0rS3d1cm9XS0RXYzluUWNZZDNLTkg0d1cxQlk2MUJyWnlocnBmN0tQZ3Y3dVdnMnEyS0VMRVliaFQ2QXErd1Uxc2xyYTlXRWlGTmpjVnBDN1UzSWlqNURVbSs1U0RZc2tNYmxzNVk4cDhDaExvSmNRTmlHZ0tyeVdrNmh2ekF3NllDcHdINE9oY2dYRVUvWkpKRHFud2JYc3hiQ3hTbG9tek5wODV6ZGVPaVdzbS9tWnFvSUdVbENYWFJUQ1Q4bDNpWGpnVW9qTzF1RjBLVE9VZlJwK3o0MXpwVDBsQ3NqelZQcXdMWDUzemJtZ0kyaTBiN1V1M2xBPT0iLCJtYWMiOiI2YTNlNmU4NTc3MDlhOWMxYTliNjE0NjgxZGIwMmFiNTQ3ZTE0MDU2MWMwYjE0NTExMDU5N2NlYWUxOGFiZWVjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(798, '6pwjd80pwn', 'Download Ready', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IkExUnVLQlMrVUF6eUtkVzAra2F5OGc9PSIsInZhbHVlIjoiRW9ndlJpU21yOEtva1BZcHVuaHU5TXRpZTJ4c0pSOE44VWF5bjc3QlVmQUlLdFUvYUhoNXlBMVVVVTZBdC9KU1VoUVYxL0tjQ1hoUXNIKzd0YmZaUnpCSVlWdVhJVk5URENsNkpqME5wcmF3ZW9vNVhNWUZjZ3M0ZWJZM3NSRnFiU3RvN0JuS3N6dzZtNUsrdFhYSkdRaGZOcEMxNE14Sit2b2gxWngwQjJFTy9DOWV5QWZFa2dSRi9qeDIwendjVXl5L3lJQWNDczdwU1N0UXBJY1lsRTVWVXBqMFVlMm0rYk9IdUY3eG40aEwzallKOVZtMDhES2JlTXRYb1U0Y3dZclQ1eGNla2s5cWoyNUNkd25RclduTjFBVTZRYzE5R1NTQWtrQzA4SDQ5akxPM2xjTEJEQzVuL0EwZnl1a0l6YTFRYUdpaUxGR1BnbmtDTWcrUnZRPT0iLCJtYWMiOiI0YjhjZThmZDI0MjU0YThjMzM4YzUyNjRkNzk5YzFiODQ3YTVhYjcxMDc4ZGM3ZWI3ZTljYzQ1NWVjYjcyOGNmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ES', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(799, 'zm2d3knrwq', 'Download Ready', '', NULL, 0.05, 'https://notik.me/api-redirect?token=eyJpdiI6IlJpRmwybkM0Qkw4YUx5QUkxTm9ycnc9PSIsInZhbHVlIjoia0FzSWtPdjBnNFlnNUpWSzBLdFVuUDB1eGpNUHZFVDcxd0hvbjJocjB6clZhVG1pNW5Hc0xRdWd6cDViNXNaeWQ1bVZVQkYyWVVkQys2Q08zdXozRGdoTCs1aXNMdlo1bDZIZGJWd2ZkOE5zSmNlSFViT2NmRTdGaUJGaGNkbEtrYU83bitVL0hvaVg1RHFzZzljaU1jWFlReFIyYWVkZkpnNVk4Q1FUb0JncmxvaUEyRlZKbU1KdUVxUTUxOGJGUER4ZFZlUjJrbHJYSEdXZzVoS3NLSElCa0p1cjJxdHoxa01HVlB1Tzk5d3FhRFJCeTdmRmJGY3ZsN0F6R3lCL1hMdUVJbS8wb2FyT3U3dGJIeUY0TlB5ek52ejdINjJMQUdNQm5qc3ZmdHMxTXJwQ1hPeU5mdERSUTlBOVdUSWJDSklIOGdrcGRiSitGVS9oTXRyRGFRPT0iLCJtYWMiOiIyMjg5YzI5OWEwNjkyMDdkYTljY2Q5Yjc4OTI3NjA2MDRkZWJhMWU3M2UyZDNiYTFlNDU3NTliYzE1MmVjZmViIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IT', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(800, 'j05p3dpl24', 'Download Ready', '', NULL, 0.14, 'https://notik.me/api-redirect?token=eyJpdiI6IjR1djM5TmFod0hFRENEdEdMZ2JUM3c9PSIsInZhbHVlIjoiSHJubHlPeEVuZGVqU0l3TU1wRzVCQ3N4V2xBSENZOUxqdFQ1MUlwclhoZERoR0puZXV6L1hXMjBIamdNUlhPOEhKSWtzTHUyV2txRkJrUFFndy9IOWFDTElzTVFQZzh4S2s4d2VoVmNVd1dVMXBlZXplYlMyK1BSTFhoK1NNYXJFOVNrcmxMZFkvRmZLVWN5K3BES0lZVzlLZDN3OE41UXJnUy9HVDl3Z2RyRnhwd1NnZU02QzBpTUl1cnM2SzhmcHloU0crRVZjc3k1WldsVHA3SzF3OHhMVFoxY1UzR1pLNnFmdCtFTlpaRU1CTzIxaXBzOC9KOTNHNFdmZzQ5M1pwb21QT0V2RDlWeXFJVTJIajltb2VKTkFNSmcrckpTMGs0N0RWYmh1V0hQS09wWU0vTFZ4WDc1blNVcWpobTVkUU95ZGozVTNIekF3RDRockxBSXNRPT0iLCJtYWMiOiI4YzBhOTY3NWZjYTBkN2FjZmE3Nzc3YmExNDg0ODA2MGEwNjZkMTdjYzAzMDc0ZGFiYzkzZGY1NWQzOGJlZjBiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(801, 'vz5ldvx1wp', 'Download Ready', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IlJ4RThKOG1ybGZtb21aV3ROd3A2ckE9PSIsInZhbHVlIjoieithQThXbWJwa2MxMWwyZ3FzQjQxa3V6eklDUmxQN1IyNm5aVCtxclpOc0F0K0xGZ1VZaWV4aGk2OVMzUzIyc3EzaFVsb3VzaVozczdodGx1YXlGUkxtTk5aeTJOaU5qSTV5US9RTkFldmFuSHBlN0lVSTl1UloxeDRrM3AxTGlmVjArYTFEcEhMbHhxaXRhdEthMGpyY0JjT21ZNk9xaDhsQWd6TDJFUExPWDZVam1VY1pmbW5HQU5jTFVaZ1h4UkZtRG1sc3VROHVFczV5N1ZyaTRJT3I4Y3BrZHpEZmVDa04wVGNrd0V5T1NOWVhyNDkwMXpLdnl0VjZyb1ROc1dWYXRkR2JvK1dWT09wSWoyZXZ6eFNzUGVqMmwxZ1dnK1VDWU13M1NLbXNjNVNWU3AvTDl5bUZsdi9GUFpYek8yVW16WG9FdFpKTERYeWVER0VWZzVnPT0iLCJtYWMiOiJhYjNkMjM0YzQ2YjhkODJkMzJkMmRkZDI0Njg3MDlkYjAwOGI4MWZlZDI1NGVkYzY4ZDA4ZTYyOTQxZWMzOThjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ZA', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(802, 'oq5zv1ox2v', 'Download Ready', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IjVaMHdFcXdmTzQ5Vi8yTDRJUGZ6ZUE9PSIsInZhbHVlIjoiNndxSG15VmNwVkhEVklDQ0JDb2dEeFZYUSs4VDJSWTdSS21tSFltNUJCUllhR2N6ai9TV0d1MXlNcmpSbzg4eGJJUnN3TDBSbml2RW85bmF4S1dHZ3Vnc2VYNE5iN2YvZ2Z2c2QzTWtsWjE1VTRId3dNTnFoYVFPeWxHeWN2bGNhT2lFUUNWMER1YkxTMnZEVWZzT0RTZk16cTYyYnRuWngzUjdqUWJCc0VJcFkzbTEzbTYwak1OTUZtelJjSi81T2lJQ3Y0d2lMUEpORWN5UE5HeER2UTZLYjRCYldscitmZGVRWWdTeHhyR29jbDBiTzFNNjJRZm5Zem9PYjIyemNRcU9oajczUk96QWVLWHZ1SS96dnI5OFUrUW1hMXN1empVVHRLNTFzNFpZWHJSc3RJV1dTcm81UW4xZmtrMW9JUURob3BBL3NYQ1RZT3R6YjF4TDF3PT0iLCJtYWMiOiI3M2UxMzgyMDFjMDI2ODc5NTVlYTkwMzM5N2IyMTVkODE1NDZkYTc1NTRkZjczYWM3NzUxMzA3MGUyNWJkMjRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NO', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(803, 'xj5gq1r4wm', 'Download Ready', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6Ik85NEY3YWh3bkdqMTlHRDVZSytkS2c9PSIsInZhbHVlIjoiSDgxdXd2ZVZVQmlLVlVMUXNDSEJ2SVhGb3E3YjJ5bGxwQk1TbS9CYzVQQi96eEE1SVhIOThTWXBsRXVvbDYybmsrbVZiNFcxQUVhNUhHalA5TGtKZ3Y1d3JXYzNZUGVvbjlVRE52VGpnRCs0TERobTl4SFhxRnZsQVFnUFY0aTBVRjkwamZ0bi9GSktvMmF6aUo2TUEvOUVWRDdWVXh0ZDU1SEpIaXBOaDNja1FYOWNJcC8ybWYyODV2a3pMSkY2UHFPUkZRaEI4OWl5aDlzbHhOOERiRkpSaGlWcytSSGo4NG1Tcjd2WERSOFQ4anlrV1hBNlNoR1BKbmJMNlNGRDd6SG1ITTVNZFhFWlErd09qV21zekhOck1IbGRHYzc1VkVTenVlbDB1cC9MOTArMjFGRXZOSmxuL2tiS0VTQXEzVUVHUGdCb2V3SmJ4S2J5aWFMUmpnPT0iLCJtYWMiOiJkZTlhNmIzMmJjNjk5NDUwZTExZjg0MzYxNzYxNDZiNGI0NDRjZTM2MWQ2MDgxODIzMzBkY2ZhN2NlYmI3YzZiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(804, 'y4w47xp6w0', 'Download Ready', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6InFhSXZKdmtFaXF5cEVPMmo3N3piZmc9PSIsInZhbHVlIjoidlVXUHZhOCs4QkNuKzNKamNDQVhoSktDRlNlRlVsOFJHWG80anVKNHpjNHZ1STRQMkg5K3NERzJRZHRiR0Q0K25wM2Q1U1dYLzlWbmR4bTZ6N2hxWWdIWUVRc0hTcnJCOENGWU83QmhJVlUzU2dERkpoWFQxdVpUdnF6VTRxYjNJbmlsK3ZiUFZGYzl2czRTbENXY0RYVlF3U1pTa1JYcDNPZThMSE9MQUhyR0tnVEMxMVRnbDFoOGxDSEt0ZkZCZEpaZEVHa1IvdzhTRktjYzZVKzY0M3VjckVod3lrWXpMZUNkRUQxVnJNSW5nNEdOQndaUXB4REYxeWhjT05GRDlLRjJ2d1lPZ09UNEdyUEVkMURQeTlUREptK0dkNWFrM3BxMlVLMTBybnZBZm5vbWFneWVUVG1LUmVGNGRSdm4rcGRkR3FUbVpYd29CNmNHd0xwL0tnPT0iLCJtYWMiOiJmYWEzYzMzM2E3MTYyYWZiNzUwNjhiMWYxMDU0ODM0MDY1OWMwNDMyY2I0NmRjMzE1MGJjZmYyNTg3Mzc4OWU4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(805, '6k2yon1dwz', 'Download Ready', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6InJyQXF2bkFmNFFjaTFsMjN2S2s3dFE9PSIsInZhbHVlIjoiaXQwOXhqUkY4c2FsRVVGMEp0b1N5TTUweVZ3cngzc29RRXRROERFMnZMcmpsOUpZbzBJbTJlZnNvN1dZNEh0M1JJYzJZNmNOZmRIclFkaE15TkRQNWh5bjlFRTkyNVAwNlRQWmhEK2l3aTRqU08wOXJxODlyWmxRZFdHUm80MTVhLzcvVzhCK0xtejRCLzhZd2J2OEs4T2NJVEVCS2NGZWpHd3p1NC9XUFgrcXJzbGxKWFpJU2c4S2VCTDlFaVNNd0M3RVc5enNmc1lvNUtYdFBSaUtNS25talF0a0hqUVQzNXpjS0hXVnk2NGJyb3Vna1k3NFpqVzJFSStLRVFnc3dVeDRrMk1FMWJtOWdvaTVHdWF6eTNvUW1aQVVIR213a2NFbWJ0ZlVFQUJMcFBVKys4cS9ReXlWTUwxR1p2dzlHRlQ1eEVoK2tzVGVxeTRjekNlRnhnPT0iLCJtYWMiOiIwN2Y1NWUwYTNjMDY4OTcwYjQwODZhNTM5ZmUzMTBiYWVmM2Q1Y2FiYjZhZTllN2Q0MGFkYjhhNjc2MjMyMzFiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(806, '8dwkx0v42e', 'Download Ready', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IjI3YWZyNEtHY0hWVlFQSEtZNGRJelE9PSIsInZhbHVlIjoiMWlDVHhMWFozWEZpOVNFUWh0ZUNuMmtFdE9UcFBlWjhhcGhzZjVlWG9JeURyTVBrL2xwY3JQWURISWdUMkNnOHhKWnlNWVRmVFFtMFpzdlVySXdxeng0SUViOFo4NWpCd3EyaWNPc1hVT29CeGxqdm16RkdQSC90OFZVZUNoT1NiMmtZbVdFQW4rS015SFdZMXgxWGZ0dXNscm5TOEpRNHlzemJ1S2kzbG0zRzJpSy85MmwraktOMHYycUlVNHpvckR5SDBsNkZ1b29RalF0VDllUTVlUWwwZG1SQVgvTGlUNmNzK3dXaDJOM09BWThOdWtXdGd0aytDOXdob2VBNE5IRXJER3RCekNQTVZZOE9OVFp4WW9BSmExKzJiUTM2c0xrbE1kS3prSGtoTzFhRU1GTm9UUHN5bDBibUNaeG91QWJOTlhrUjM5VWVhK3hMRXROWEF3PT0iLCJtYWMiOiIzYmQ0YzU1OGRiYjYxYTA1N2EzMzNiOTZkMzIzZGZjOTU4MTY4OWZjZTk0MWIxZDRmMDkyNDJlNzNhYmVmNDY5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'LU', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:11'),
(807, 'k3w7qdgz2o', 'Download Ready', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6InR1ZDNVbWs3bHJmNGR0Uy9hZFVVRUE9PSIsInZhbHVlIjoiR0NKUnFrNEV2RUNOVVFvSitBdFY2bThxYkZOMDAycG8vZ0U4YzNERVA1TWlHUlFDS1ZWckFCTWNtMlFjNFYvcG5DYlA2aFlqcVVRZ0dzQ1hHcEgxREZWbWZDbllURmlCd0FUd0dENHJVR3E0YSswQW9wSWExVEdlY3JBVzFZYkhRYTZFUmVsWUJEMFM0S1JLZTNhTStaVE9UYzNPdnowUGRhYTBFZUg1SmJxQnVURXBpam5YN2poVjlwTTR4b2xjeHREWU9rcXFvR2FPQmN3TmkycHpWUi9pSlBBVkhTUlNGVG1iemJ1K1JVSE9pSU8xNzlvS05zTzFBeUtVVzJ2NVpPZ05CT0RsLzRIS0dtaE13azg2ZmJoYkZHdHY5MVRzV2NUdE0ybFVIRVFtMXNCM3hVN042ZjB5bm5HZEtMdEE1YmJ3SUR1N2VXQ0hYS0hMWlhjN1pBPT0iLCJtYWMiOiI0MGEyOWM1NTdkODMxNGFjZTVhMzk2YjY0NTU5NWY3MTAxNTY2ODMxNWU1ZjE5YTg5Yjc4MmU4Y2Y5MzcxM2VjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(808, 'kp5nnmje5m', 'Download Ready', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6ImtUVVkyRWErRGRYeWZwN2FUUFNXY0E9PSIsInZhbHVlIjoiZ0Y0dy9xUXVLZ3hFMjFIVHNZN1VKSENKc2MySldZNTZ1czNtMWVEcFo3TS91cGRMYzUyMG9VVGhMZm9iSzA5UElTcDFMaXFHNHA5RmtUdERPdTBNaVdZNThQWUNtZVZoQXZNSHBUczdWUyt3SXVrV0hLZVBycGpLNmRuTWhtRjVyYldKZndHaDUxVEVscFRhMXRDQ3hmZ3R4QzV0VkVqY0dHRDEzRENPU1lhVTI4OVNpblREU0FleGZXVVBwMnZac3pWUWdRUjNSVG5jVkdMaHZxcy9ZUi9DNjI0WE5OVFJqOXdkMXhHaENmVllERlNvcjZjeTJDWmptejNWNm9rL3h0RE5HY01CTm9RWHhpY0FPc2E2MHZacDF1UTZuWTdUaXdjcnV1TUNTN3NQRlQ4OThMMHRIV2ZZcE56ZWlZK1VBNTU4dkRyS2NHcUl1b0JHWldwQXd3PT0iLCJtYWMiOiIzY2Q3ZmY5YTMzODgxMjg4NWMyZGYwNjkxZWI4MzE5NGQxYjE2ZDQ5MmEyMTlkNTVjYzBlNDM1ZWVhZDc2OWNlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'PL', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(809, 'rx51q836w6', 'Download Ready', '', NULL, 0.12, 'https://notik.me/api-redirect?token=eyJpdiI6InRhTGdUTjVtZjlSTkp1ay9Ic2YzUnc9PSIsInZhbHVlIjoidFA4SWRjTFQ0NHFjM1dnSmtZZHhoRjhRVWVLLzhYQzRTMk5jR0Z5ejdnbVNoTHlCbnFpQU85NWo4ajJLQ2FkSWlzMTg0bUFGVnNFeURLKzV5Nnp0bUF6SysrakV2L1lqbU84Z1lUMGFzZXo5Q0wxdExlK2VlNGFDNlVVZklPV0s2a0ZJRFdTQlhFZ0RRaC9WMytFRi8xc2tHMCswMlo5d0pwQXdGTXRwbk1ZRysvdG5nL0hVaUc4RnNDN3NTVFgvNVM0RThSd1c0dEZhcHRKZEhHejJzWUdXNkg1WXAycHQrRGY3d25tc0FqUEsvdVZCM0dJY1hyeUxYalJjcTZVQkZrdGw5ZWxQSGRpdWI1ZTZGc0Q2eXRwYllVRXVxQVpOaE9SR2dvZ1JnL2FSWjNXTXg2M00vWjRrMXNBdWtPTlAyRWdEOUUvbWpJY2NtUXdaUFZhaGV3PT0iLCJtYWMiOiI2Y2NkNDY3Y2UyYWM3NDliMzhhYzI1YTE2NzI1ODY0NjU4ZTY5ZWU3NWZjZmU4ZWY4ZGI2ZTM2ZDAzNTMwZTRiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(810, 'k15onjdj2q', 'Download Ready', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IjJSR0Uza2pNcXdoajZOTDNLTGY0UWc9PSIsInZhbHVlIjoiZTNlNXhCUC92MktCUGF1V0VuaTE5d2phTEt3OXJBMmppdUkreHJERE0yOWY2cGt0ZVBWdVhPMjFkRmcyTk8zb0lNc21XS1pJZmsyTDVLZmE2ODdCUUUwbkpBZ1lCVEhRcVVrMnNDNHhtZUxxa2FuZytkZEFwVG9OanVCakJTbjlvd3B6VTNWM01uc0hHZ3Y0V2tHSnN3Qy9JWUs3TDdWajB1bThXY0RBNUtLemlhT2ZLL3RLazM1VW91MTdQVmZxOFNHK3pzNDNCVTBKSHBUK3pXb1pMRnRuUWR6SnA2VmlLQnJzU2NTTk5MNGZ0SzN2WFNad2dxRG0wLzkxRDIyZFhoeDJCSFhqZGFIOFB1UEpCWU8yVm0xeVRwK0NJRDg2SW1sVm9xcnl0STBzYnF4QkhKOGZKcFY0MURBc3BGeFc2bkwxek9qcXJoWkxtaFVGc1NwTnBRPT0iLCJtYWMiOiIyYjk0M2JmMmI2NjQwZWE2NjQ1NTg0NTg0MmZhODVjOTJhZmE2YWZlMTA3MzBkM2FjM2EyMGYyNTc2OGI4N2E3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(811, 'xr5ed7332n', 'Download Ready', '', NULL, 0.04, 'https://notik.me/api-redirect?token=eyJpdiI6IjRLcGpoTFBNcXdLUGNWQkVqRkxZZWc9PSIsInZhbHVlIjoibnZBMHFaeTdoZ0RCeWpJMTFSU3F3YkpGYjdUQnBjNzJKWnFpcWxOSmgrOWMrWjU2T2NFYkN1dFF3eVVic2ZINEtlZ21SOHdLOE44ejYzTkpjSjhFZ3VWckxMYmJMbEpTRWJlMjFWMVJCTUpaYmVFYVhIVzFubG5iMlhXVDFZeVQrdjlIY1VoUmVnMHBVTnFlbHp0R09vR0hNeFZWaEpYQUdmTEJuNzNLaFpsdzFsN3pjZnQ5RUJQUFVublU3aUp6OHc0eXI1bXM3VUtrdWcvYlozM29zK0VNaENkVnp1QWVIejBCYy9Gb1JwanQyOFg2c3pVY1pCYlhxSzVsWGdPdXJtQVgyV28vWVFIakxVdldvaVZHRDhTUitJZ21tQk91TUJpOWU0a2NYRkhYNUFGQXc2YzJNM01TZGZWTlhzQjBCSDdVelFQZzNBOEl0N3dtemV5RGVnPT0iLCJtYWMiOiI2YjIyYjZhM2E3Y2QxYjVjODljOTNjNjZmZWNkZWYyZTk0MTJhZjVhNDg4OWVmYzg3NjMzMDVmNDM1ZmUwOTNiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CH', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(812, '826197-lZ2kToJFfVYWxuk6', 'Clone Evolution', '', NULL, 43.68, 'https://notik.me/api-redirect?token=eyJpdiI6IkZONlozcS9YdkpWR0hER0JSeDRqUkE9PSIsInZhbHVlIjoiYnlwYVhJbVlpVkJ5Rmdoa2NmREo3L25CaWlNUzFkaUdXM2tVTUJLZXh1VTBIcW05ekZaOEZaWVZQcUQwQ2lBYXNUT05PeGtERTBGWGJTdUE5bE50Y1U0VlovV3Z4djJKWjg3OTJrTlZick5YSzZrckJWbEhNMTRMU05vTmpxN0J4WDRHQk5hZGkva3krK2NYbU01VmFSZHlFQmVpRmZFaDhWdERwZ0RIMFAwTXZOL2pFS2RLUHAvUUMydUZhY0ljV0VaSWJHemZRZ3NIcW5oajVTTTlEQW1SbXp5RHhFTXlUQndvOUt4ZlRtOTNlL29qYWQ2ZjYrbG5RRW82NWFqanBMYW5BVnMrRElLZFp1cnBXcE12ZjQwUmt4a0ZtaEtmbFFHRHhTZTJMOWs9IiwibWFjIjoiODFkODA3N2E3ZGQ3NmM2MDNiYzZmNTIzM2JiYmU1YmFkOThhZjZiYzBiMTNiYjRlNGExMTZjNGU5YTY3YjAzYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, FR, DE, NZ, GB', '[{\"id\":\"bddcd2e8-7f26-11ee-97f5-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"bddcf372-7f26-11ee-bde3-069eb31df495\",\"name\":\"Collect 10 Purple Heroes\",\"payout\":0.96},{\"id\":\"bddcfbce-7f26-11ee-b628-069eb31df495\",\"name\":\"Collect 3 Orange Heroes\",\"payout\":6},{\"id\":\"bddd0a56-7f26-11ee-b849-069eb31df495\",\"name\":\"Collect 1 Red Hero\",\"payout\":18},{\"id\":\"bddd0326-7f26-11ee-a270-069eb31df495\",\"name\":\"VIP5\",\"payout\":12},{\"id\":\"bddd1172-7f26-11ee-9375-069eb31df495\",\"name\":\"Purchase Monthly Card\",\"payout\":1.92},{\"id\":\"bddd18e8-7f26-11ee-baa4-069eb31df495\",\"name\":\"Purchase Growth Package\",\"payout\":4.8},{\"id\":\"dbb5e558-e2fc-11ef-ac2c-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(813, 'qx290lyg2y', 'Download Ready', '', NULL, 0.03, 'https://notik.me/api-redirect?token=eyJpdiI6IlpyZTR2dXIvU2Rwb1hPNGY1S2hndHc9PSIsInZhbHVlIjoidW8wNVF5c1BDMlhFc2QvaXYyS0U2elZneDArSWFyN09FVDdOMVFvU04rT1V6V2tYK01td0wrbGlaZkVabTRTdGp5UWd0Z2RGY1BncFlUc0JRa1YzNmxXZTRBSkJBazBoRFZLWGd4dDNnZ1AzaWZWaXVrWHVySlVFWkIrVElWQ3NicGZVYkE5aFpMajc2YitJci9nNlJwZEFXaFprbW56NkxxeDFaVkh4aHZvYVUvMjBFdWRGM3RsRlpvTTlhYnVOQk9KdnlXM0lIRys0eE84VGcwVUJGanlZZUx6dmhob3BrcGFBdURoaitGa3JDV1haQmF3QjlBa2l1SFQ5eWVac2I5VWxkMFlpZGt5N2hDUFlURWdiSFdUY2xtTlB0dDNsWmg3ak5zMktZNHgrT1Yxd3JHYVJwY2Z3SXp4QndBTGNYOWIrSzZtTVpxdlFvZDJmSkVvVTZBPT0iLCJtYWMiOiI0MzY3NzQxNDFmNjRiYWE5YmZjMDE2MDcxOTFiYjk5ODUyNTdhNzViYjQ0YjY5MzY5NjU5MmZhOGJiNTVkNDk2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'MX', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(814, 'gq56rjz95l', 'Download Ready', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6IlQxWjBYa3hKL0s0dzgzRnhRdHptT0E9PSIsInZhbHVlIjoiZGU0UDBEWEYxeGFBVzlFL0RZd1FrOEhJajJjcnk0TTFCZjB5YnZ2Y3YrR09hODZZZlY5d0ZQVm10NHVQeU9QMW8rVWQ4UGcydkIxWkVDRG9VVkdVWmY5U2hxSWRUT21Ednd2MzJFMnR1bmxMN1FHaVE1Zm5ocFMrWUJKY0tVSjV4MmU4MFVIQ1Q1b0RFcmRESitzbHprUmVESllFZkEydFFyQUNRRVZBSnNxU0tGa0NXeThSMXVXM05Wa2g1S2wrTkpzYUxtNTFOU3YrMm1iMkFWTE1VMWx5dXQyUHl4VVlnc0hjZjBKY3V0WkViV3k0aXl0T0xwcE9jN2RLekdpMkkyYVVhTG9RTjYvU0liWUQ5U3VCZWhJNkdmMy94TUNqOTd5eDZPTFVvbmNBWmxCbkwzc3JxVFRBTVExd3dkUlYzUFg3N0pIekY2eHUzYlFGNWNxUWtBPT0iLCJtYWMiOiI0MDdjZjg1ZDU2MDAwNzdiYmRhZTdlMDEwZDMwMzhkYjk3ZWVlZjM5YWM5YjA5OTE0ZTE5NDAzYzkxYjRjMWJmIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(815, 'jy2rolmv2q', 'Download Ready', '', NULL, 0.06, 'https://notik.me/api-redirect?token=eyJpdiI6InRFZFlaVWdCdDd6LzdmUWlYaTBRZ0E9PSIsInZhbHVlIjoiZ092K2Y4WmU0OVQzS3BKU2c3cTZSc1V3TGVPNXc5VHZrNUE0Tjl5bnBzM2NuTGcxMzh0bGVMelpmMGEvQngwemZKZHdQUjE4K1MvcU9iVjdmeVBHbDFsTkVjVUk4SE9Td0RYa3NpQnlBS2cwNm5nKzNFcXhMcW0wTlVXUnlOZWhJeUJnYjJ2WVNqK3hlYjQ2azB6THJUYUFNUi83RjI1WlNLNGd0SFY5NGtJWDVydDF4ZDljdzFoU1QxQk9pRkY2UC9tZ3VESlpLNHVEaEVJOUxKN0RVVVp1Y3RPc1FpVTlZaXVTTGc5YlQ1VzlZbzZZSjk2SFhwdkN6eXNnYjB4enpheGpjUFVTOVNVb21GeEhzQ2ZFdmdxaml2em8zclZkQ1pna1VXRklBOFBmcnZmZUx0Y2J1eHpzajRLWkhkZnp4WHJ4UFFuM3FXc3VHNnZCcWVOd0NnPT0iLCJtYWMiOiJkZGYwNDIyYWRmZTExNjU5YjRhYWQzMjdkOWIyN2RhMGI2MDNlZDQxMTdlNzkzZWE4MTFkN2EyZjExNGQ5MjMyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(816, '642qzpx021', 'Download Ready', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6Ii8wR0FERnJGc2JJTTVVNVFqTURSTWc9PSIsInZhbHVlIjoiRFBYYWpLV1ZYSjltbHBUZlViZE41UWFUQzgyMDR2MDhsUHcvRjN3Q0w3c2JqektoMlNjdGtXSVdualpxK2huZ1pXdXJMR0FHUVVXbTFXNXNDNjZ6aDBFcTFORk9kTnMzOGZuS1ZJNDVMVWthMEpSdEVQRzNUYWNaaGNDdVVzemNPcndRY2l4UmJnQ2kvUzRJdWhHd3dhdE5MY3NoZmNqQVZTamNScTBDK3dLazNzeEZwT0EzWlF0d0IvcWZBRmFzZHprMnA5ZVBIZU1GWlhXZWU5aUpyMDJ4bm5WQkdoWEF6c1JVQXg4OUI3VnpyTWJiclBLWHdmN0dKMWRDdHVNZDQyY09ZYS9rTzFwWDlZeVhxV2ZEQ3UzZTBoWTNNbGYwVGZsRVMrVmUrSXU4QlhBa3ZVOTFwMk56MXMvRUwwTzZhQkg0V0ZUQkdmaE14N0xEUGhBcEJBPT0iLCJtYWMiOiJjNDBkZTg5MTk2YTJjMzY0YmExMzQyZGNlNzY0MWFmZDc0MWJmNTk0ODcyMWRiYmZiOWE1YzliNmZjNWU3Njg1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(817, 'jg58mpzm2r', 'Download Ready', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6InJpQkZLYlRXZkdMSC9JT0dwdnR3VHc9PSIsInZhbHVlIjoicHlPMS8ySGlSVGZ3cUgvK1QzR0Qvem9McUM1d3lmTGd3UGl2Y2RJeVB0Um5QQ0IwWEliTHhHRitvcXZiZXA1ODhOVE8rcXdaK1BuS0t3cE1CMlhIbTNpR0RsSWRnRjIwWjcxdHBjb2tjODZCQ2RRdzdSbEttOEYvOVdyRHo0eE9jK2QzWThvQzQ1MDJoZjFNRnhGME1sZjFOTGlIbGZkM0g2MmhYbGpFenpscEhWSUgwdENpVC92TzhSZkJGSnZ0NksvbDgvUFdaNkJmQU54b1p5Z2VlSVBlNnZxTE9wQ1hYK29yKzVpVExWQ2xUVUVLRm40SmU4T0RqcFIrcDlCTDh5d3oydy9Tb2c0K2RsNU9seGhpN3ZqbnB4RTBtZXNLcnNvQmRCZ1pQMVNYS0RNcFJtMytiOGJUL1k1TVEzY2Z3aGF1MTNtOGl0dzQrZXpvWEZYTXdRPT0iLCJtYWMiOiJlOTFmNzA3NzJiMTBiNTc2ZGQ0MGIzNjY5YzVkYTNmMTE2MDllMjRjZDEwOThhMTEzZWRjY2FkOGEzNTQzMmRhIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(818, 'vm20rq0z27', 'Download Ready', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6IllTN3kwQ3hFZmVNUmw2MVdaaTBCZ1E9PSIsInZhbHVlIjoibkQ0TFNqbmI1TjFLQTA4UFNmcVZDTk9vYVVlVGxBVjhGZnpGQlFHTUpMZUdXT2lLcmVjMlJKeHRKanBjQmtoY2lsaTZyN0YyczljY1FXUkFJeWt4SG1VTi96WkNpUzYxdEMraFJvMjJuQkp3S3BNQXVFakZ0T1dYRmFlVmJtWWxpamlVMUZCY0gyTmRjWmhaR1VZQ3MzZVFzZXhLUHEwaEpBVWxkcGdWaFdOYTc5bUp2UE5SMmZsMHpISmo0b0VoTFUya2ZKcXFVWEdJdyswK0xxTGpnU3B6Mkl6NlFKaGhHOUtyU0NkY0xSTVFGM1pidmNpTDkyREM0LzFqSmJjZWpPQmhiSzNGR1lQTTZSeGJqMzF3ZzRtbjhMaHVvWE5iOUpzT1E5bVRGSVhCTFVab1U5QVlUL3ZWRUlhemV0d2dieFhDR24wSlRFcDlxRjBIbWdUTkl3PT0iLCJtYWMiOiJhZWI1OTNkYjgyZDcxYjhiNjMzNTI1MDA1ZjBkYWIwMTY4OWNlNzQ2N2RmMmYxNmExZjg5YTMxY2EwMDUzODI4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'SE', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(819, 'jy2rolm62q', 'Download Ready', '', NULL, 0.07, 'https://notik.me/api-redirect?token=eyJpdiI6Ikh1SS8yT0VQM2J6VXpNaVRYNGFMR3c9PSIsInZhbHVlIjoiOWpaQ2U5ZEc1Qm0wK1ZGYys1UDRXVWpiY09Kd2dPZS9Nbkc5dGFSTGZERUpqZkxWTTZoaUcybzM3SkEybXNKTExIRDQ3azB2TTNvRU04M3VHK3hwTzRGaDdhSXRBTzRsMGxXeldyMG9Qays0K3owOVViTzU5bU1sdk4xbi9UWW5DaUU4VFoyZnN4YWZFNDVSUWsybm40TDh1QkZoZVhBKy80VE5aTzJpb0NZM1NFWDlLa0FQcmh2VVpoajEveEFYdnJNclduY054TnVoT1cyT01DK2NtZ2dDV3lVQTIzcFdKM2I5RWVtM1lPT1lsQU8rOHpuZytQVGRCeXRsNkxvMlVlc0hzQlZhcTllbml1QUUxQkhLQWxUQ1A4YlcxOVFmUXUxeDZYWHhFdXZWc3ZXYWIxejJkRzFleDI4SENESEFWSXd5VVh1ZGluRGJ2ditNRGFidEJnPT0iLCJtYWMiOiIwYWY2OWJjNzY0NjQxYzVkNDZhY2RiZGQwZGQyZDI5ZGI3NjQ3NTdjOGNjZjU3N2ZmNzkzODRmMjI1Yzg2Yzk1IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NL', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(820, '475786-sgU25EBv6KpXYpHB', 'Nutella - DE desktop', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6ImlXR3Q2QjBxL0x4TzI5L0J0cTEzTUE9PSIsInZhbHVlIjoiN0RmemtWMXNkSHlGNkVwR1FjWGwxcnVXUlFIQjFkMHpOZ3BhVVBXczQ3M1doUTM4cVY3K0l5VmU0czZsd1QwVkNSSmhPenFCdFZmSzVlaWF0VFNMSzNNV2h4a0JIbTlRZjVvTkpUTTNDaDBJdzA5K0t6a0wrV0pxSFY2U1E5R0VOeWFYN1JhbUZZVy9IMzFSclkyZTRlNDlzQUpNQ3Zuc005ZE9jUjZWa3ZwUnVFR3VZQ2FCTEROZVZ6TFBYU1YzVjljQkVVSzkzNVF5ZVB1Z29PK05KQUJuTGhTV1dQeTZVc1BibDZJU1dNQUdxZUlQNGxEVFdSTytBeW12QUJ1cW5yRHBndXRMZ0RXdFduRUdGdmJSM3EvQVozd3pNMnRyNnQ0M3FjZ3NjSm1SSjE4MDJHUmlWVVZMd2RMWG8wY0huOUdHZENIL1NuMW1YVjA2bVpBNWtWNkU1Nkd1M3JiakRFTEw3QzVXOVlLVHZwTURObUhWWTRHYXZkZDNXVUdJaXFwenJTODNtZUlIbERlYjBUaGVXUT09IiwibWFjIjoiNDg0MzFhMjA1MWViOTJmZTUyYmRiZWZlYmY5Mzk2OWVkYTJlNDgyMGZiYmNmOGJiMzdmNmZiZWFlYzkyMWJiMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(821, '475957-sgU25EBv6KpXYpHB', 'Audible - Free Trial - AT, DE, CH - incent', '', NULL, 0.55, 'https://notik.me/api-redirect?token=eyJpdiI6IlRGOGUya21Wa1dqT0VDQS9uN3BKV0E9PSIsInZhbHVlIjoiOEFoZm42RW1TMDkwUTVOMmpXUWFkMDgwcE01aEVYS1FFckNVV1FyeFR0TFJXYjg1Q3pZZGJiZVc5dWZEVmt6ckY3djIyc0ZQL2tqOFlZL1lVM1V1emF0ZmxMbDBNd24rZTlQUXJxRlk5c2FPNEZyRXZXeGtwN09BenQzd0pKTlFCbUY3K0dQTlNzKzhHWnZDRmxXVG5ycHBSVTVQSTF2ZWkwTFpEYVU3Y1BXNjRGQUhpU0hWaVEvalYvNjN1Tk5nSVRmNTBoek5TRXR4ZjE5dUxLZG1IS1ZNSGFONy9lUDVlVmU3elhSVnMzR2ZDMW95UlR4ZjlkcjVvanJoT3lwRzRvSFNETlVjdE0vOHdwWFlRUm9sd3pQWjlzOWNjZ1dYOHlyNjdYeXFvMi9MaDVXejNGeE5SclVDRU4zSmg4REhWQkV2akt6c3Exb0ptcVRhYXdRL09yMldCY3RKT2Y0WnEyM294RmFHVU9Wb0h4Zi95WHliTmZJVmFyZ28wQThWaGkwSGdFUEZ5ZFFRVzJLWTFjVzN3bm4wbUh2dkNteUxmY3gxMjdublU4TT0iLCJtYWMiOiI0NzY5YmQ0NDU4ZjgxMjBiMmEyNTM2MzZjZDY0Mjc5ODA0YzY3MThkZTdkMjQzMmQ5ODRjOTI5NDAxODg5MzBlIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12');
INSERT INTO `offers` VALUES
(822, '475967-sgU25EBv6KpXYpHB', 'Amazon Voucher 100€ -  Complete the form - DE - incent', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6IndLbEJUSHp6QnVsbCs3OStvOEhmRnc9PSIsInZhbHVlIjoid0N2UHNmV0xhRlNZTHpQeTBWeFZoQ2I5QXRSL0p1anlQc2xqczlKWS80R2p1N0dRSXVZMDFNTzQvVDBhUVg2dzJvcm0wYnp0Y1lrVmpjL3FqL0lXeWh2YVhVZVBwb0ZvRzlBYnM5ZkQ4MTlla0FBdXhPNHRQTThSR3lHeHJOZmNkRWhCSWEreHphL0pmOEhFYUVtWVRRS0NjNHJNeTdWSEdzZzcwc0ZieHRQcVBHbzhLUld5VW5FVGpFVUF3azY4ZFlQdWw5SDlzVHZRY0llVVRvcEV2OHBKcnFhQmtxR1NjOG11bkNYM242bzJtWjdURS9tV0ozMUVxL2pzSThWaE1wNGQxblVPelQwUDFDVG9IaElGRmZIeC9RVHVRZ0pRbjkybkNVSmVjc0I4N1hVWjJWRWF4RDU1dS8wMWdiaTFXbzI0SnFUSEozSUVIT0FrUGlRRXJxTC9Ob1dCdmlxUFI1TDlxT3E2WEw0QjhzZy83RVBhNWZiTWhIT0dHQ25nR1BpeW5VWldMSmFXeXRkcGtCaVphU3hNUmtDWXdBaE1hQUkwcjBxYTA4bkdoSnA4SEErQzcwMUVBWGFPRGFIZiIsIm1hYyI6ImNlYzE1MmJkYWEyZGZhMGZlZTliMjM3NDdlNjMyNGE5ZjllY2U1MzkyZGY5OGJjN2IyM2RjNmE4Zjc5NDBlYmYiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(823, '475969-sgU25EBv6KpXYpHB', 'Media Markt Voucher 750€ - DE - incent', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6ImNvQ1ZuSWc2K3JISnRMcEQwaDJqL1E9PSIsInZhbHVlIjoiTEdlSDRZamM3Y1Q4dG9hTzZBa3dJeWtrUHhLODhGdG5ramNYQndtVjBDcDRvUFlPUjNRbmpNRytiTnBMcmVUUU9teEVNOXlrMUpCNFNDcTlpb29LbVUwU2hVT0ZTQUdBSGN5MG5yYlFRVDltVENWWE1aSWxBNFNoVHdQaVZlQUs5dkJpWkdGZ2dIdVA4bFNaZEdMRW9lZUxYZ1h3Vk13Tm50MDYzZitMcXNXOC9rVWplMXBYdFQ2U2F3Z0JrVzVzdHFiNUpRbEhqMEZ4b2NFUzNpMVo0YWx4a2NUZFhkbWR4aWRoRzRyVGpIanhGRnZrYkxWdGNXYjMrRTVJUy92QXhYZlo2Y0IyLzh6Y2ptQ3NXZ05ycSsxNWRsYng3K251ZTB0aUZxSjFDOUFOOGZuQ3h0ZllaTGt3emZuMUh1ZFlDTnJmWHJhTFQvNjQ3dXgwMXc2NXJaRUxLTkZLMW9DY1UyODBiYWQ5alh6c1B1M2p6cDgvY0R6aEtwLzFLazhTQnY5V3I5aGxQOUp4c3JZQk9hSG1tUFE3SGo5S0VYaE9zcEljMW1qSFE5UT0iLCJtYWMiOiJjMTc0MWUzZWQ4YTQ3YTBmMzVhMmE5OTcyYzliNDJjMmU0YWZkYzg2ZWE1YzNmN2E1YmE2OGVjNGRlM2QwMGM5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(824, '475970-sgU25EBv6KpXYpHB', 'Gillette Product Tester - DE - incent', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6IjFzOHNObUtuUjV0NHFiT01kVEsrOWc9PSIsInZhbHVlIjoiQmhUVzhyR0dDWnNZQVdDY0FBVFFLa0FjQVlHRFB5akhDZG9UUkg0MUUwTXJMZEh5VUNTNHpDS2dEYXJVRmlZWUYvM2JMRk0yRERUa1FvNngvSDJxUzYzcjVvWHlJZ0Q3M1B2a2FCV3BzY0UwdFowMlRHV2dnY2dmbDVOYjJYM28zTWZDb3FBczN6STh2Z1VhaS9vL0RpZEZTMjQyQUF6OExVQzhZcjFMN1EzNTNBVDgyUHROaEN0SHZuK1pVQXhQdTlHd3JxUHAzTGFDRHF2bWRsbjNDK1RQT2F5cVFHWEcyYUcwTUZrT0MxdTBXbjJqOE9mMmo2UU1DbFBIaE9mazIzcGJJREJPNDJYSUhRQ0pFdWRlNHJZTXBYdzZJUVZpdEgxMWVETDFQNHA4NS9aYkpJUGFRSnJ2NXJIcnp5QnoreTVnaUtVUDVQWENjQmVaU0dpajQzTy80SGxKc0h1U1pibzJlOFphRlppSlVvTTFmV0xiWjlFdEN6Y0hmTkI1WjE5WVQvc0hxaEJMbHlRQ0V2T0pQT1VvUlpOU05qbEQ0bnIxaGpaTmtncz0iLCJtYWMiOiJjYmNjODZhMGNmMzEwZTRmNTI2NGUzM2QxYzhkYTBlNjhhMjE4YzZjM2M1ZmFmMDcwNGU3OWY4ODY4ZmMyZDIzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(825, '475971-sgU25EBv6KpXYpHB', 'Edeka Supermarket Voucher 500€ - DE - incent', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6IktMa3Zob2VNbUJ6aDkrVFNWcHJ6dVE9PSIsInZhbHVlIjoiamduTFAwUkpKU2NpNUtRdlZyWDZpWG16VUpudER1RkEzdkRINzVYR3daczZqNlFuR0xYR0VsTFh6UnNFZHhJMG5CTE1rL1hkM3lwamFmVTJ2UElQc2NyVEU1b2p1cmFUUHJ3Y0w4TDhGSU5vZzNWRFgvaVdUNjBqdFdzTm9PUE9HaGoxYkdsUXM5azRHTDFTV1Q3cEo1OWtFVTE1U2V2N2hxZnY1WElQRGVmNjFMREc5ZjhZVSt2M3g5SXZJc3NTSnRDMjA3NTdLNW55NXZ1NklaU3FQbVE0MnZEMXlhM2lwK1d2RWZxRUdzcXBVZlBJUXh3WjcyakVkTmFRT1A1YnFIc1JLMitpVnBaRTFnanVaa0g3cllsaXpLUGZHRmhKMG85RUdOa0NISkU3R0dHUzRiVGJDZmZ0YjRKM0JKSVBvZjFmYzE1R2l3cHJOSmNOZ3cvRktTU3Rvd2tVaXp0S3F4NE9XK0E4aDUxSXRtS2hxamJnRUdqMUFDOHoxMlJYR0F1czV2UXcvTUVsNmVKeXkvd0R6ODhGZFJTb3dGOWtjeUd0dGpYZ3JONVJwVXIwZEl4UnNVaG1xZTVnRzBxQyIsIm1hYyI6IjE2NTBlNGU2NDFkM2JmNGZhZjkwNjY1MTE0MDViYzk2NTc5OWEzYTk2YjU0YWU4MTQ5ZTVhMzQxNTNlNGE5MDciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(826, '475972-sgU25EBv6KpXYpHB', 'Amazon Voucher 500€ - DE - incent', '', NULL, 0.79, 'https://notik.me/api-redirect?token=eyJpdiI6IkRLeXpyckNQOEdGemRZNjhHcGlnNVE9PSIsInZhbHVlIjoiQXNVSmlmb3UyQ1g4emRRVVdRRjZuWlVMRFNZUC9CZnYrMW85MFRxNWptVnNTYzM2Z3VaUnh1T2lNMjd6QUhnVjhmcW1KTU5oVmE2VVEvQzJOUjlEb3h6ZHFFaXBaS1RxMXFyM2E3WW10VVVKazBncHA0TkdRMFJ6eEduM2tMenlmNWxvSXMrYWpyUEVDTEhnZDBkalRReVQySFRXeXhhZTlCZllXY0V5c0pqSllRS1RzSEpQRSs4TEFUVG5KOUxCVHBFMmZ5dXZZYjFMQ05TRitadUFoTkx2OHdjaDZSbkFtUFEza0g5aXhETW9MZGMzdTJCRmRQT0pUa21SSEJyQlFCWVpTODNGaW4zVkxCUTdScTQzUnVyOFV5NnJTNWY4ZzVqS1BXSG05Y2JpV3JFWG5oQmFzeVVvUW53UjlQMFBuQ3Zvbm1oZTEvUVZZWGtVRUg0TU4xYnB6d1lwV3dyMVRsRDFJRHROeUhoL1pOMExVakhVRjliOVlUbHlPSDkyMUd6TDZUSytQYUhWaThBdERMd1BDQkpFVGxBRW9aOVZ6WTdGTHJIaFpBMD0iLCJtYWMiOiIzOTRkNDg1ZDBlOGVlODg3YmZhYzdhMjE2MzYyNzEwMjdjYTFlN2M3M2Y0MWNhM2IzMzg0MmQzZWNiMmZkY2JiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(827, '1365401-lZ2kToJFfVYWxuk6', 'Bingo Vacation', '', NULL, 44.48, 'https://notik.me/api-redirect?token=eyJpdiI6IkJRckxnSXNKVHJEZVlQRFE4akgrS3c9PSIsInZhbHVlIjoiQlJ5bnkzWjNhODc4TENpT0xibTVWYkJJOVhWM0puQm9rTldKT3dINHNSWTFITmNGZGRTT2NmOThGOUR0WlZjT0xUeXlKRzdFaVFvODgzaCtqN0VaY2sxbkpGeEZyc21zeEJpRTRtQzFueUxXVVlURDF3MmV4UVdGOTk1czJ4bWNoWlVXajIvTXhvb2hpWU5sUU9HaGJ4aWJqY2F3QXlXS2R0RnZBeFZQRGVoZkU4UlFPTWZJNVlDQzhmM2VlZitVcWFadkFib1hLRHpCYVo3K0FaOFAyQjFMNjlNeFo0ZVlzYkhLekN1UEtuTit1a3pBMnljQkFFZkJ2RnVTQUJ2WGFuendtelBzUjRjbzBWZ0o0blZSdlBKQytmOFNOUEdvMVJqRUlHb2d5MlE9IiwibWFjIjoiNThhNDk4YjQ5Y2Y0ZWFlYWU3NzMzYTE1MzgxMDY4ZjI4OTVlNDllMTljYzEyZTQ1ZmY2MTM0YmRmZDFhODcyNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"b7eaf722-58ae-11ef-82a4-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b7eb0fd2-58ae-11ef-8093-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.064},{\"id\":\"b7eb1900-58ae-11ef-9423-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.256},{\"id\":\"b7eb218e-58ae-11ef-b6a5-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":1.92},{\"id\":\"b7eb2a4e-58ae-11ef-b96b-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":8.32},{\"id\":\"b7eb33ea-58ae-11ef-893c-069eb31df495\",\"name\":\"Reach Level 70\",\"payout\":32},{\"id\":\"b7eb3d0e-58ae-11ef-bd59-069eb31df495\",\"name\":\"Purchase Any $4.99 Package (Optional)\",\"payout\":1.92},{\"id\":\"b7eb4664-58ae-11ef-84e9-069eb31df495\",\"name\":\"Purchase\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(828, '1365402-lZ2kToJFfVYWxuk6', 'Bingo Vacation', '', NULL, 44.48, 'https://notik.me/api-redirect?token=eyJpdiI6ImlFekhrRTZSbHUrOFRZVE50anV2dVE9PSIsInZhbHVlIjoiUmRhUlozR0hNM0N3bjhtK1FGcERNb1ZkalY5WFR0MUZ4bzI0ejlCSkJmandBcVdxRFVRUy9iWUNVcFhWbk9YRytKbjlBaGk0d1BJZmo0L2NuWDJ6bEkzOTQ5SWpOam95cFJBbDZiOEQ0dldqeE1QR0UwNlhTbUtGUmprQm9rR2grc056NmxVMzNCZ1M2T1hpRVlIYTBtLzZFRUFBNGlOb3FhRE15RFlkeVg3YnBWQ0N4SE1JN1RSWC9JeHRQaW1hZTlxekJpYlRNVHRiMU13UTAzenQzSzJMWUJ2Qm1waWRBZ1BOcitmT2pqVDJjK29DeU5kZFhlM2JuT0RDVUMrV2kyTkdmc0k4bmRuVTFKWkg4WWg0MGkzWHhPeEN3NXUvR1IwVnR5SWQ3MTA9IiwibWFjIjoiNWIwYjlkYzg2ZjVmYjIwMTc5NmRiMjY5NjE4MzA4NjAwODU3MTExZTBhNDE1YjYxNjUzN2ZiOWE2MGQ5YmNmYyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"b83803be-58ae-11ef-a368-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"b8380e5e-58ae-11ef-bd9d-069eb31df495\",\"name\":\"Reach Level 10\",\"payout\":0.064},{\"id\":\"b8381778-58ae-11ef-9d1f-069eb31df495\",\"name\":\"Reach Level 20\",\"payout\":0.256},{\"id\":\"b8381ff2-58ae-11ef-bcba-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":1.92},{\"id\":\"b838288a-58ae-11ef-93ae-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":8.32},{\"id\":\"b838315e-58ae-11ef-97f6-069eb31df495\",\"name\":\"Reach Level 70\",\"payout\":32},{\"id\":\"b8383b9a-58ae-11ef-91c7-069eb31df495\",\"name\":\"Purchase Any $4.99 Package (Optional)\",\"payout\":1.92},{\"id\":\"b8384518-58ae-11ef-9ac8-069eb31df495\",\"name\":\"Purchase\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(829, '1143135-lZ2kToJFfVYWxuk6', 'Crazy Farm: Farming & Building', '', NULL, 22.32, 'https://notik.me/api-redirect?token=eyJpdiI6IklYVUlJRWxldE1ibWlMcXpiU1FWMGc9PSIsInZhbHVlIjoidHBNY2ZFK0Y3NXBoZlBRWXVHVHV0K0RzTGhUQ1VINDQ3MGVNYWhhakFWMVViK3RVNjBGbFpPNk5CRnRWRTIzSk9iWklPOHlVQjk2c0ZJVTNXT3Z4TFhoaVZJUXoyTmZxaXdYamhuZ1NTOTdiL1l6RTVrTjVjdTljamhKYVdZQWFpODNmYitPbkRGNlR0OWRRc0tiSXVDcWpDUFdEcVc4SVJDUnB4VlNUL1o1REF0dERVblhtQXM5M2JGRkZNaUlsdzYvaHoxckQ0QS9DZTBCbkFKcFRkamNXN0JtU1dnK0V2Q25jcHp0ekIrMG9MWnE0ZnFZWXQ1T0M1WXpENE4vekNYUzdsaW50R2c4OGs0V0hwZXNYMHBBOU84NlFSQVkwamMxY2tma0xmUmxCK09ocnR4UjN5MU9yYmlKSXdsaWciLCJtYWMiOiI5YTBlNjk1ZjA5MDgxZGNhMGI1ODYyMzlhNDc5OTBlZjA3YWNjYjVhYTEzMzQ3YzZkN2ZjNjAwNDBjMDcxY2Q2IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, BR, CL, CR, CY, CZ, EE, FR, GM, HU, IL, LV, LT, LU, MK, MX, OM, PL, PT, RO, SA, ES, AE', '[{\"id\":\"8cce00ed-7964-4317-b331-3a19722cefdc\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"5e0e714f-7b64-4209-b6d2-7b65ac3b7ddc\",\"name\":\"Reach Level 7\",\"payout\":0.12},{\"id\":\"6f77ee65-da3f-4c58-bc76-9624d30792b0\",\"name\":\"Reach Level 13\",\"payout\":0.2},{\"id\":\"dcbd69fc-2ab9-4c59-bfa4-e956f0026c72\",\"name\":\"Reach Level 18\",\"payout\":6},{\"id\":\"6826d882-5613-4ca7-91a6-81e1fa839a93\",\"name\":\"Reach Level 50\",\"payout\":16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(830, '1252465-lZ2kToJFfVYWxuk6', 'Coin Party Pusher', '', NULL, 0.91, 'https://notik.me/api-redirect?token=eyJpdiI6IlNBaUtlL1BNZ3o0amJmZ0FGcHJ0NXc9PSIsInZhbHVlIjoiVVdzVTRwM1psRDV6b1hzNGdTdXM1T0tMdnlDdnc5WVoyNDV6Z0FkY1RwbDR4Z1VwMXBKbzh6dTM4ZE5vbUhzNzVzUWpNRTVla0xBTXVCWlBJYk9RNnk4TE5wQmNvekRkTjhwN0Z5ODRjcWlRSUkxUjBLNlhkajJ3d3VEcitYOTY4VlVZMkRUWFZuZEJxQ0pQMGJkTFhIZUV3QW95Ty9SaWt6ang0eE8wSHFHNDVDQVRPL2ZleFVGeDM4clF4M0hsOHoyRlJTbWNhQmlPMlY5OUpibTZsaDdKMGFyVnVuRUN6eTVSMzFlbTdTN3F0S0cxQjVBaWQzT3ZqeFNYVTU5T2NBMExwbEtiVnV0c0g1K25Fdmh0MVZjOWxXMWFkU05GSkxRSTMzenB2aDg9IiwibWFjIjoiNzNmZDI4Zjg0ZDUxODY1MjJlNDFhNmM5OWFmN2EzY2I2MzQ4M2YxZjhlNDZmZmIwMTVjYmQ4Y2IyYjM5NjFiMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BH, BR, HR, EE, HU, LT, MT, MX, PL, RO, SK, SI, ZA, SE, TR', '[{\"id\":\"2d98208c-3e77-4dc4-a55f-a2e6f041bf38\",\"name\":\"Play the game!\",\"payout\":0},{\"id\":\"3f65cec2-722d-49e9-8a3e-f685f752c6d5\",\"name\":\"Complete Level 10\",\"payout\":0.028},{\"id\":\"8b4c9443-914e-48f1-a1df-fc9b16e7e901\",\"name\":\"Complete NOOB achievement\",\"payout\":0.08},{\"id\":\"6db8499b-4bc2-48ec-b75b-4b9c1950cda4\",\"name\":\"Complete PRO achievement\",\"payout\":0.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(831, '5gLbCaDMC4f46T8EGef7S-ZPwVWfTSwLIJu0B9', 'Crossout', '', NULL, 0.35, 'https://notik.me/api-redirect?token=eyJpdiI6IkZoUXBqYWhwK1RsMjZaaG1sY2RWbUE9PSIsInZhbHVlIjoiQy8yL2RETG1YYmF3TW9JZlkxK2V1bXlkSFBKVlpHMDhIVC92T21UaEMxYjduUGl2aWZCYUZreXpGRTUrSGtGVnZjdEwwd0VZcGd3Y0FoejllWXBHZDhOcThuN212UVFKUTliQVF6dkRuTUJ3V3hDY0djcVJlVFVOMUtCamZKUVFmWHBTQWxtZUJ6ZGlkM2FKOTBDbk5lOWFmczFwazVpNjN4NlQ0bVNFQUl0ei9RakxqVEFUWUNwQ3JqZFp4V0t0RTdvbFJ4YWptNTZCTDV4SDRKcXZGT2x0N0h6cnBRWFBxOFBybFlSRXVDV3JHVjRXVDFxRWFQM09YdUQyZnQ1bXBQcVB3NUM4YXdzZkdja3pxT3pZUUkwUWp6eGx1NXZmRDBoTllxTDZ2b0hoZy9UUE0rTWNIYk8zYjQvVnBIVlpDYm95YUw5Y254UFZMa2NDeTJ5V3M0ZlRDUll1TzgrakI0TXlsMjdSV2NXcjJTRUhJWHllNTNFUVU5b05udEdoYmlXUFUxOVFIZ1ZldlZNZzgrQ01mS0tOOFF1NmxON2toMjl0RUczeUF2L3UvemVyMWs4R2x2NFlGaC9McnlSbGJLSjBxU3orYUdSMEFhVStpQ0lDZW5lZUh3OWJOM2d6YTZ2bXdtWjBKa0k9IiwibWFjIjoiYzAzZWNmNmFiOWY2YWIxYWJhNjg1ZThhOGMzOGFjMDJjNTAzMDdhYzIyNjVhZjJhY2Q0NWNjNWIyYzAyNTEwZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BY, KZ, RU, UZ, AM, UA, MD, AZ, TJ, KG', '[]', 'desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(832, '56665-jj8oFgHP3Fbq8oqf', 'AppKarma Rewards & Gift Cards', '', NULL, 2.80, 'https://notik.me/api-redirect?token=eyJpdiI6ImdqU1MvTzhSSE1GSy9tWGZreTlmTnc9PSIsInZhbHVlIjoiT0xwYjRBbm5uVmxicGZ2RUYzbG9uTTZMNVptVG4yZTN5UHZhZk1ack12c0JEWmgwSjZKbEhOK3VadGhSdW5DVXRuVUZVenBkNkRtNC9MTFJKdVBpTEVvZ2piWk12R3ljMWswaXVDRXNhTUJUL29xaDZONFNFSW44dGNEVEM0YVVDZXcwb0g5N1BRZHNJaWNqZ3dVOG56QlVXNUhGN1o1QnZrZ2loQkNVeWRTdkJ1MnJoS3F4L3UyVHJaQTByYlEvRmFlOXMvNFNFeHN6dUQ2cFhvRzZZUzc1M1ZQbVVhUjJsWkRoaE15YXN0MnBJK3pXRmUrTEw4M3pIZG5MSmdMdGMreDROcVhnaVF2UEZ1S0hxNmE1ZHg4M0JYR1JzanEvcFYvZGFqM2VNbFZNNzRhbWtSdXQwVSsybmtqcWtONmlMVmsrY202dXZGeWhGeHZkSlp0ZUZNL1FadE9JMXhRTjBwSTFJMkV1a20wPSIsIm1hYyI6Ijg4Zjc1NjdmZTE1NmQ4ZGIyNDJlZjE3ODJmZDhiNzBiOTIwZDNiNjVmNTRkODEyOWFiZDM0NjM4ODZkMDg0MWIiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(833, '56667-jj8oFgHP3Fbq8oqf', 'AppKarma Rewards & Gift Cards', '', NULL, 3.36, 'https://notik.me/api-redirect?token=eyJpdiI6IjFIeWVqTFlTM3dJdU5jZG5jTUlJYkE9PSIsInZhbHVlIjoia1ptNU1PWXlvUHJzdzdVRkxxc3l4Q0lOcVJsSkdpbWxIS0kzUFRON1h1anFvOGNWRU9ZOVlkMjVzTlc5YllCMFduTVpiaGdMdmhCd3RZd3Q4Q0EzN1BpekpnRHlnVldVOENQU3E2M0dUWDBxTkRXVGt6T0NPQ2NBd21HVzBHLzhFUmhOdFMzNy8rY2MxQWwxemlpUlROYmVsZitkMVhpT1NJZGU0cEw5dkF2ZHRvVW1zMHpWTm52UmJDUFJtekZ3SkdoRkN3QjdlWFJNallGVHZsVUl2c1dUNmNmNDJLbS90Si9NTEI2SVk0VmEzN21xVFhmVnNkcndGQ2hBTmZNb3pjUmllQjZ5UDVMWWVwZW5GUGpuOFl1TEZvOWJBek02UWVES3VFK1FYWHhiYUZ6NG9EQmh0QllSZG1IcFdyeEVXVVBpZG9hUWRlUThHOCtzL3liRjU3bDhoRmo1M0RwcGZieFdUNEdTZ2FNPSIsIm1hYyI6ImE4OWNhMGNmMTA3MGJmY2FjZjg0NTg5NmIzYWQ2ZjQ0Y2RjNGJkZDg5NzAxMzBiZDJhMmQ4NzNkZTVkODliZDgiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(834, '22749-Q0Fm7OXUFNcX72x6', 'Ipsos iSay US', '', NULL, 0.30, 'https://notik.me/api-redirect?token=eyJpdiI6IlNzcGJjWkppWlQyNW1HcENPR2FMdUE9PSIsInZhbHVlIjoiWEptaC9nRzlnZjJCTGV2RmlNMHRkM2Y5MVZtaFV4dGd2czFKL0RIREkrSGpoQW13R2FNSloxQnJZZExrOTZkOGU3NTFOdVVOVGlSY1FybnVheHN3VW1vSzkyNGtIMUhNc2RKWnZkM2NOTlZwems4MzMvYnpvSkxaNmF3K1ZDakZMRXJNR3hWUVNpTzlqUFQyK2NhWHpTR0NFMEFPU1Vyc28xQ3hjRkJ2eUJob25tUkFaaGk5VUVYcDNBZ2EyWHhtQmt2Zm1SK1oyUEc2OEpqNndqNjliMjNjMDhrdGNySXBzdE1QTTVnSWY3dm40OXhMR2h5WWJGZWpuQklMQy84RnZJM3IvTjVzS1lTVmI0S01rWWI5cHBOZ2xoanN2T3FUcG5JTHFGeUVWOWxxQ2NmMTAyNVZpNnppV3VzTU96ZXRsdFlLenNzL2ZXZ1luSjdzVW1wOEZTK21oNDNRK0QzWXFSRHhqeVBYSUUvbjN0dWJJaWtDeWViRWtXK0RRYzdGSDdzMUcyK0FKclE0ZGpwUHJTVnorTnNSeElhaWpZc3NPeDNFeXpCaWl0a014QTBxL25XcVZBYURHaERvWFhPeWV1VDczVHI3Y1B6NW5rd09RTG52alcyb3FKWXJLdHM4SjlZaUJGZU1ia3RlU3BuaEVxZityTk91ekhMRkx3Sm4iLCJtYWMiOiI1YmZhOWRmNTQxZGI0MmEzODY5ZjI3YTdkYTg1YTQ4NTRmNGVjOTkzMDA1ZmJjMTMyOTE2MDdhNTNlZTYxMDg5IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(835, '22626-Q0Fm7OXUFNcX72x6', 'GfK / YouGov DE', '', NULL, 1.59, 'https://notik.me/api-redirect?token=eyJpdiI6IlRZWWRhaHpwb1JiSXc3blJLb0dVUGc9PSIsInZhbHVlIjoiWnBpTXV5a3FIL3lJM094anZ5UlZKMFNveXZ4REZIbWxiSnlwM2diTnhjR2c3M0xrTnB6UWx3YnArTFBGZHRuTVhsd3EyekF6REd4cU5jR2Y0WUZYYlRwQ1RpT2lPMXBvb3YwSGg2SUJNSU0ybDZ1SEplK2taV3BHOVB3NDB1aEl2TnhsRnc4VStNQkdKVmhtQ3AxZkswV2Y5VFFuY2FHTVowdnd1N291MzRYVzV1Z01NU1I3WWV0MkRVamN2VS8xSlkzMyt2QVF2dHZ6ZUxmeTd3VDVlellZYkE3OGxGSXhwaWNrK0JnamVPb1orRXFEb09lamNRNS90WlZJVmZQcldCb2x3ZFJrVHhOZS9YV201dmRDYlQ1cjhzbU5aR2JONWlRQnZVUm5RcWlmSGFMOWtobmFRY3I1MHdJQXN5ajRxM29sVnF2VWJqcVRPWEswWHhLc2FXeGttbWY4eGo0alhLcS9QYmZjKzRJVHBpM2JXNWcxOHdaL0s4VWtldjlLQnUvL3J3OGsrWFJUQ3FrNGJaQUlMQUYwenFkTmlTY3ZYQVd3ampZQ0loaDc0Mm01T3cvbGErZ2NvOVo1c1pBd3MzZkd5eE9jRDFiZmtabFdZWklGVWJ3ekVMWVJCaENvUWxZNkJab2JXRW9RNDdxOHg2U2MyYlhuSWg3dWNFTCsiLCJtYWMiOiJiZDM1OTZlNjdjYmI1Mzk0NWRmNzkxODNiMGYzM2E4YmVjMmVkOTVjYzUxYzQyM2M5OWQ2MTIzYzg0MWYxYTQwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[]', 'all', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(836, '3xwvrkd958', 'FatPirate', '', NULL, 26.46, 'https://notik.me/api-redirect?token=eyJpdiI6InJuemErSkhHdFBmZnE2Nmk3UUFyN3c9PSIsInZhbHVlIjoiTURGTThJR1FXZ2tSZ1U4N0JMNFkrcmFlOFJYVmpma1A5bUN5b2VqVGIyNWVzaWNObEdaUHVRM0NRRDRoazVsMWZ4RFhRdGFUSHV3ZUswMFhYNWc5MzkyQ3FmcjNHQlI0UkpBVFRjcGVLV3Q0WG5GQ1Btd0JOZ1JmSkZMcnJYQWs1WndId2xwb3M1RHNDV0tpYkRQNmVrckxzZTB3OVhMRFo3TlVkUnBEYzUyN3FNY0NjWXUwNzJ6d0hNSkpGRmdQVVpWdi9mZUNTN0pkMlk5REpPUlJFbkJ1ZDRsUE9QbUlaeFovQ2tyaFFmbElmTkkzZGlnTXNSVFNISU1zbDVidjlHeENzcCs4VTBCMTd6Z3VYT3lza2JTRlVnbDNWR1FaNE03b252TDh3WG1nZkN4cFhPNTBIZmxLWUlxbW9jOEdZRktQeGNKcHBVY0RMSkYvNzh2Rmp3PT0iLCJtYWMiOiI0OGI3ZWQxNGJiMTE4ZjM0YzZjZTFiZDJmZWU5ZmQ4M2U0OTllOTE4MDNlNjU1NTc5ZmVlMTg3M2FmOWNmNGQwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, DE, ES, FR, GB, IT', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(837, '1366027-lZ2kToJFfVYWxuk6', 'Blossom Block Blast', '', NULL, 17.92, 'https://notik.me/api-redirect?token=eyJpdiI6ImQzdnRCa1Nsei92Z0VLektTNEJKcXc9PSIsInZhbHVlIjoiZW1mb3NDYmhjWkZKdjBjNjhKWDlWdkc1azZKMlpXZnFMam5PenRpdjBkNVdtellaa3lLSTkxWUorTUltSXN0UjV1SzBic0k0TnZOK0RrdUJGb00waVF6RGRPNnpjWWpjd3Z1S2JmRklsMDFWdSs1WW0wWW40KzRNeEc0RnNjZ3ZJVUtrdzNIRDVLQ0R5ays3cjU5dzVYWGVISkw5dWYxVWlmZ3Q5eXk0VnJTa1dqcXJuQWpxR0VpYitBU3gxQjVGSHBkdTdCVEhIcXFpNlU1RWJsbm4xeFhtUDh1MEZwL29KYmJQM0xrYjdwaUdLUWRYSnAxZ05Semg2Y1owN3F1UkRsZyt5bkk1YnZwdWYzREJQd0tKY2h0WWpTU1hHWVcyZ0swMnB6NXFEdXM9IiwibWFjIjoiYWUzZTc1YmEyYjBlNjUxZTgyMmEzYzJkZTIwZWRlM2Q1NGM5YTcxOTc2YTViOTY4ZjgzMDA1YjYwYzYwMjYxNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, JP, KR, NZ, NO, CH, GB', '[{\"id\":\"25f8b276-5a72-11ef-9aa2-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"25f8bce4-5a72-11ef-bf98-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.096},{\"id\":\"25f8c55e-5a72-11ef-9b05-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.224},{\"id\":\"25f8ce46-5a72-11ef-85cc-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.48},{\"id\":\"25f8d6de-5a72-11ef-9c2e-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.8},{\"id\":\"25f8df94-5a72-11ef-8129-069eb31df495\",\"name\":\"Level 20\",\"payout\":1.28},{\"id\":\"25f8e886-5a72-11ef-8722-069eb31df495\",\"name\":\"Level 25\",\"payout\":2.24},{\"id\":\"25f8f1c8-5a72-11ef-9448-069eb31df495\",\"name\":\"Level 30\",\"payout\":3.2},{\"id\":\"25f8fbf0-5a72-11ef-9fbf-069eb31df495\",\"name\":\"Level 40\",\"payout\":9.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(838, '1370899-lZ2kToJFfVYWxuk6', 'Wood Match - Wood Block', '', NULL, 8.32, 'https://notik.me/api-redirect?token=eyJpdiI6IkZlSVhoOFMyb0xQUmdzVkltVjlQZEE9PSIsInZhbHVlIjoiY3IwUGYyRHh3aFJnWjFhTnEvRE10M1FFRE5kVlpBY05XYmhjYTdKajZ2MzFPS0RPYytxS0Y3c0dZVFE2bTA0TkdBUVJNbG00dnV3NXREVW0xWTFlVjhtVTJqNnZDVURYZ2l2S2JIUVBMY2JiSk03L1VnRlJUcGpBd3ZLZlVTeFN1djhqalUxWjYzRWhqZXZWMkxHdVhxTXFXeGVRMkdiSXhQcFVyUUFkdzlaNVBMWlhUZ0tnanRqL3NCWG0wMDR5SDhmYXdIOEdSbFJPdFg3SXVSVkFWeDFmV25aVHYwTFZITm1UY2ZvOW4yQ2tNRy9ocEV0a1ljWk8yWk8xcEFYNjdXZzlvaHNEbzBPM2VVTnRjMlVoRFNvTjdkRHJkWVRuTUUvKy9tRml5QWc9IiwibWFjIjoiNWIyZDdiNTQ4MmMzZWVjNjNjYTFkODU1YTZmMjVmMjUyNmZlYTkzNDgwZWEwMTJhNjY5Njg1ZTJmYWFmNDljNCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, DE, NL, GB', '[{\"id\":\"31a9afaa-5b3d-11ef-aa82-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"31a9d7f0-5b3d-11ef-a41a-069eb31df495\",\"name\":\"Complete Level 15\",\"payout\":0.064},{\"id\":\"31a9e1a0-5b3d-11ef-a78d-069eb31df495\",\"name\":\"Complete Level 30\",\"payout\":0.128},{\"id\":\"31a9ea2e-5b3d-11ef-bd0f-069eb31df495\",\"name\":\"Complete Level 50\",\"payout\":0.32},{\"id\":\"31a9f2d0-5b3d-11ef-8455-069eb31df495\",\"name\":\"Complete Level 80\",\"payout\":0.448},{\"id\":\"31a9fba4-5b3d-11ef-8934-069eb31df495\",\"name\":\"Complete Level 125\",\"payout\":0.64},{\"id\":\"31aa04b4-5b3d-11ef-940d-069eb31df495\",\"name\":\"Complete Level 250\",\"payout\":0.96},{\"id\":\"31aa0e00-5b3d-11ef-8237-069eb31df495\",\"name\":\"Complete Level 500\",\"payout\":1.92},{\"id\":\"31aa1792-5b3d-11ef-9a4d-069eb31df495\",\"name\":\"Complete Level 1000\",\"payout\":3.84}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(839, '1157742-lZ2kToJFfVYWxuk6', 'Raid Shadow Legends', '', NULL, 111.80, 'https://notik.me/api-redirect?token=eyJpdiI6IkwrdFltb2E4dkJGRWlXQXZWMitIc2c9PSIsInZhbHVlIjoicVR0aktuMUNvcGRMcSs3V1lieC9xYzJtVG1VT2xUYlNTV3hpNnh6K3BSczB1czMvQkV2N2laK2w1RG5PMnlkNUJqVUNVV2Q4NFM1bHFlV3d6QVRySHAyWDYvQUZrakE4M0FOUmRJeXRyRGtVc2I3cEtuS3dPUU9lczJNSkpLakt5ZkJzRXdNd1JiV2xOc0ZsOVd5WFVpVldsMmtnRjNMNHhMM3RhcG1nZXplSnhuTUUxNUQ4SjFHKytvMG9RazZQa0Q2UnNZZEFBaU9CcDRQSlBLT2lZdEM4MU5obTFHQWFVRC9oU0lWdXZZTnh3eXVLNDdVdGtMbGVZdmM0TWlYeUNPTkQrd1NBYnkwTFBxbENHdlR1ZjFZS1B6VHFDZzNzdUhrZ05PQkVnN289IiwibWFjIjoiNDcxMTExYWFhMTlkYTZjOGRlZDViNmM4NDQ4MDhmMDAzZDc1ZjEyYzg5ZWUzM2JkMjRhYjMzMTQ0MDZkYjhlOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[{\"id\":\"8cf2c1d6-2450-11ef-a1b7-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"ed3fe344-a398-11ef-8a10-069eb31df495\",\"name\":\"Reach Level 5\",\"payout\":0.1},{\"id\":\"8cf2ea4e-2450-11ef-b49b-069eb31df495\",\"name\":\"Reach Level 12\",\"payout\":0.1},{\"id\":\"8cf2f214-2450-11ef-97ca-069eb31df495\",\"name\":\"Reach Level 15\",\"payout\":0.2},{\"id\":\"8cf2f9bc-2450-11ef-9abc-069eb31df495\",\"name\":\"Reach Campaign Scene Tilshire\",\"payout\":0.2},{\"id\":\"8cf30970-2450-11ef-adde-069eb31df495\",\"name\":\"Upgrade 2 Heroes to 5 Stars\",\"payout\":0.4},{\"id\":\"8cf3117c-2450-11ef-ab08-069eb31df495\",\"name\":\"Open 2 Sacred Shards in 30 Days\",\"payout\":2},{\"id\":\"8cf319b0-2450-11ef-8a85-069eb31df495\",\"name\":\"Reach Level 40 in 35 Days\",\"payout\":4},{\"id\":\"8cf32b80-2450-11ef-95ca-069eb31df495\",\"name\":\"Reach Gold 2 in Arena\",\"payout\":20},{\"id\":\"8cf33440-2450-11ef-aa68-069eb31df495\",\"name\":\"Upgrade 2 Heroes to 6 Stars\",\"payout\":8},{\"id\":\"8cf34638-2450-11ef-8933-069eb31df495\",\"name\":\"Open 6 Sacred Shards\",\"payout\":20},{\"id\":\"8cf35006-2450-11ef-b560-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":20},{\"id\":\"39e84c46-df52-11ef-a81c-069eb31df495\",\"name\":\"Purchase Daily Gem Pack\",\"payout\":4.8},{\"id\":\"8cf322f2-2450-11ef-8141-069eb31df495\",\"name\":\"Purchase Sacred Daily Pack\",\"payout\":12},{\"id\":\"ed4045e6-a398-11ef-a28b-069eb31df495\",\"name\":\"Purchase Begninner Progress PAck\",\"payout\":20}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(840, '6k2yoq17wz', 'Easy Surveys XLong', '', NULL, 0.72, 'https://notik.me/api-redirect?token=eyJpdiI6IkVBOUpLN01hbFJOaWhPcWVBSzZjblE9PSIsInZhbHVlIjoibFc3NDhaMWwrT05DdGdtYWx5R2ZNb3B2WWN5QWx6R0U0M2tqajB6anI4MlYyZENPVlpCSUxoUHk3Y3BOVkY3M3hmOW55aEFUNWdVaFNOVmloYnNjdzI2eE4yREs2bldJc0x1NmFBU2Qva0Z1WE1TbVpueFNTbXROQVRIK2JHMVNxMG5rc1lOY0pJbWp5ZlpBbWZhKzFKYUNBcGZhS1M5YXp0SDRUUmlKV1NJSURXUlJpbmlrYTJreDVPa1IyK09OT3ByUkVwRkxJYzFLcUhGYjVkTW1JZlJDUGRQVmllZjhrZHZKTkFhZDc1eDBqWHA0MjVha3I5a2F2cDFCYTA3VThGb0hKN2RJaTM3cWJiZFhVNlhwSTF5djdId2ZCTko4Y2t3ZzZ1VHk1TGtRUlo3OEozQm5LcXJQOEo1a1d5RHdJRXMrM0Z6anpnTWdCYzI4aXBmN0xRPT0iLCJtYWMiOiJiYjFhM2RlNTQxYmMxMzg4MDY4ODY0Zjk2OGY1NjYyZmMzM2MxZDMzMzEwNDU2MzY0OWE4YTI2NjY0ODI0YmQwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AU, CA, GB, US', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:56', '2025-02-26 13:11:12'),
(841, 'xj5gqj80wm', 'AstraPay', '', NULL, 0.23, 'https://notik.me/api-redirect?token=eyJpdiI6IlQ2Ym1lRE5TcWs5V1pkbHdlOEZFRFE9PSIsInZhbHVlIjoiVUp4UCtoVjdKTE9oOG5XaSswQndEeHM1WFZIS3ZyUlQrL2sxRkN4ZEFZaG9VMVJ4S2M0b3VrKzdUa2NlYUp6K1NRS21NU3Q5WVBIUE5naG0wTGppbFEybEkrYjNmNVBoLzI4TUxRWC9YQjJ4ZnJNVmE2UkRKR2k5U3JTOTJ3K3I3Tlp0TWw0cmZpdEo1QmZ4VUxZYy9qVCtkSktXY0l2Q0IxZ0h0Vy9UQTlwWTlqRlJROFBSMzNYMmNyRSs3V2xVdzZ4Y3RrbTN1bmVWdEhVVkVBaC9MUVphdGFvdEpKUEJLb09GVElMN3I3NFd6RS9pZTczYXdRUkx0S2x1WHd2dmVaZENTYlBwT3RDcGtBcTRnSy9lSTU0K0lNRDZJemUzWDUxRXdFbTVhbzhGSXloMEZMdkp0c1JvYmVrMzJlWXAiLCJtYWMiOiI0NTY4MTNjZDBkMDFmZjcwZDNiZDAyNWVlNjY4YjFkOGI3Zjc4ODkzNWQ1NGJkMGRlMWQ3YzRhZTQyYjg3NGRiIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'ID', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(842, 'xj5gqerzwm', 'Easy Surveys', '', NULL, 0.36, 'https://notik.me/api-redirect?token=eyJpdiI6ImFQaWVrU2thU1dDWXI3ZnRiZ3NVU3c9PSIsInZhbHVlIjoiV3RqT2RVYW15NzUrODQ5eS9PTHA4WmVvQjYxMjhwTjNKZjVYWGswZHF0bmI3alJNZmtIZC93NTRrbzB3RjF3VnhwZnNOYU5xMnppZ0Y4cHpNSGNuejBOVlAwclFRaVNjNHczNlJwY3BiclJEbWVvKzdCRkdZSy9PelJ2YU9KMGVsSWpXQmFmZFQzZlVTRW1UajQ4QzY3ZXRxdWpSRnRNWngvUkVXVWtxSVlxdkw1SHI0WG0zZXpUUWVMdUtqbDB5a0hSd2pTTnYrSHhOMy9UVGRPUHJhKysrdXUva2RqZnZ5eXZpWndUNUFjVkNpUTVHTlBBK0dvckZ3czZsUE1lamg0TWIvZkIrM3VRbnZKN1JkdnlrK3h2K2hmRXVJNEc2bXNaR2ZMMmM1RGQybW5RSHlWaVoveGxsS0NDc2lFei9tMmU2T1lmRytEMTdkMXlvb2xsZURnPT0iLCJtYWMiOiI4MjFjOGZkZDBhNTJjM2M0MDQxZTkzMjljODBmN2I5NWQ5NjIxNjZlNzY5OWY2ZjI1NDA5YWM0YWMzNDE0NTc3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, AU, BE, BG, CA, CH, CZ, DE, DK, FI, FR, GB, GR, HR, HU, IE, IS, IT, LT, LV, MT', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(843, '1374614-lZ2kToJFfVYWxuk6', 'Merge Blast Number', '', NULL, 246.96, 'https://notik.me/api-redirect?token=eyJpdiI6IlNaZzBoUFA4eFhxV0JGU1JDQzhhRkE9PSIsInZhbHVlIjoiUHpBTWlxaXJTSTZ3U0dWSGFlaUtHc1JoamIzMjNrSm1mRzh5VUFNakFkb2dsRk5NUmZXcGpsdWJEZFRMa1Z3NGEwZ3ZUV01zeC90WG1kV3JqallqalB0dVZDbEtQdHFpLzhRQzQyZXE5QUVtL1VUSlNWcVhSMzlCN0tLcjhsSHZjS04rdm5ZeUI2RFV1Mjh2QUluOW9rcmFZWDQ0WEdUUExrQzh5MHR6MU1WRFFEaVFSZ3Z3YkxxWTZhM3ZlWHBHKzh0ZDlWbnc2bis5L25LL1RPT1NhMXhScU1UaVdLOFVJSHNEVDJNNi83Ri91aVcvU1RNUUs4Z3pEQitVNzFwSUplRVA4YzZtMmRFMVA5U0NUYlp5c29tVjcycmthNVh1ajJUOEd3d2trMzg9IiwibWFjIjoiMTkyYjU4MGNiMGFjZGI4M2QzMjdmZmFkNTI2NmIzOWUzNWVjNWIxYzNhYWZiMjZlMWE5MjQ0OTM1YTJkZWEwYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"dc3f4fae-5be9-11ef-ae32-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"dc3f77e0-5be9-11ef-9c0a-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.32},{\"id\":\"dc3f823a-5be9-11ef-b936-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.64},{\"id\":\"dc3f8adc-5be9-11ef-ba9f-069eb31df495\",\"name\":\"Level 10\",\"payout\":2.56},{\"id\":\"dc3f9374-5be9-11ef-a074-069eb31df495\",\"name\":\"Level 15\",\"payout\":6.4},{\"id\":\"dc3f9c48-5be9-11ef-9587-069eb31df495\",\"name\":\"Level 20\",\"payout\":12.8},{\"id\":\"dc3fa54e-5be9-11ef-a45c-069eb31df495\",\"name\":\"Level 25\",\"payout\":32},{\"id\":\"dc3fae7c-5be9-11ef-bb16-069eb31df495\",\"name\":\"Level 30\",\"payout\":64},{\"id\":\"dc3fb80e-5be9-11ef-b4b3-069eb31df495\",\"name\":\"Level 40\",\"payout\":128},{\"id\":\"f66d3878-b0fd-11ef-b9c0-069eb31df495\",\"name\":\"Purchase\",\"payout\":0.24},{\"id\":\"8abc11d0-b75b-11ef-a443-069eb31df495\",\"name\":\"Play 15 minutes to earn\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(844, 'kp5nnjvl5m', 'Credit Karma', '', NULL, 0.84, 'https://notik.me/api-redirect?token=eyJpdiI6InI2ZlpaQ24zZWQ3K1hxS1FNdEVOM1E9PSIsInZhbHVlIjoickViUmtZak05cGlSLy8yTjVYNFRxRGtyY2FwQlZSSmJ6bnlSTEcrMGpTL2xkZ1dWaGRncDQ4bi9UTnorZTZnemxMRk5CUkV0OFkxMHIxZGNCczh2WlA0dUhGZFJ6aVM4eldaN0w0RzBmaWF4STZ6UlF5ZXlCc3RUZHZSVDhyWXNTN09HdFFWZ2N4djBwQjQwMHJiSWxHQjJrbUNURGhmdmlSWXliNUxwMW5JTDFDRC9iYXc1a256V2FIakFRWVZGbVMwaW9JcGhwdGdxbXZ4WmpKbHIrelhaaXNvb2REYU5RM0JlRGZSNFIxSTg2bFJFWkYrT1hXd2xKTXhWR0NkT1Rob0hMcVBoeUxjYSsxaXg2VzZGUllId2NGVlBQeDVOaExRT2NOZWpxekgyNU9VYTdVdnMzRXUwKytzREE3TWtucFd5RVlqUndzNmM4ZnZSN29FV2hBPT0iLCJtYWMiOiI5Njg2ZmViNDU4MTEzOGQ1YTE1ZDYwZGMzNDU2NjY3MTVkMjhjNDY2ZTNkNjljYzk2MWRhOGVlZWZiZjdlNTUwIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(845, '1320575-lZ2kToJFfVYWxuk6', 'Laundry Rush', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6IjdDOUIrL01MdjJvV0w4UDRTWU91bXc9PSIsInZhbHVlIjoiMjh5REJQUENmVGhnbWN4aFdoVzZtR2hyYVVITm5YVzZzNWYrRXN1YmVDTkZ3cWM5RFdOTGZKM3o2S29zSHZvWmdtU3owb3JMWmI1RVRLRnk5TkcyL3EzRzZKMStPSHgrbDhzRUg1YWw3bGtISjgzQkkvNWcvRytpTG1wYmVDbjV5N0x2SlcwQ2ZMMFlVTjc2MCtXaTZVaVZobEUydStzdGxhWWxOVkl3UFE2My9IRmI4Nkg3dG9peFowY29lV2ZrOTEzSkY1S0o4eWkxQWlSMEUxZVpYbVAvOWhwczBHaFo2ZExKbVBOZ1FneWh2L0kyL2owa3JZRlVhYmp5V1JXb1pJMnlOVFhCUTF0YWFWVEYwVEIxMVE9PSIsIm1hYyI6IjRiN2UyYTM1NjExY2QwNTJmMThjNWMwZmQ2MGZhMmMyMTUwYzA0Mzk4ZTdjYjMyYTA3ZjI1YmIxMThiYzcxOTciLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, GB', '[{\"id\":\"ee8c0726-4eb8-11ef-9774-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"ee8c2d6e-4eb8-11ef-9aa8-069eb31df495\",\"name\":\"Shoe HR Unlocked\",\"payout\":0.004},{\"id\":\"ee8c8160-4eb8-11ef-bd73-069eb31df495\",\"name\":\"All Carpet Areas Unlocked\",\"payout\":0.08},{\"id\":\"d1a81cc4-6616-11ef-852f-069eb31df495\",\"name\":\"Crocs 2 Unlocked\",\"payout\":0},{\"id\":\"a8695fa2-6617-11ef-8b2a-069eb31df495\",\"name\":\"Sneaker 2 Unlocked\",\"payout\":0},{\"id\":\"a869a3e0-6617-11ef-ba52-069eb31df495\",\"name\":\"Heels 2 Unlocked\",\"payout\":0},{\"id\":\"37df6d2a-6618-11ef-a5dd-069eb31df495\",\"name\":\"Shoe Floor 3 Complete\",\"payout\":0},{\"id\":\"37dfb37a-6618-11ef-ae30-069eb31df495\",\"name\":\"All Self Machine Unlocked\",\"payout\":0},{\"id\":\"c6f7fb4e-6618-11ef-9559-069eb31df495\",\"name\":\"Shoe HR All Upgraded\",\"payout\":0},{\"id\":\"0de069ba-6619-11ef-bf91-069eb31df495\",\"name\":\"Dry HR All Upgraded\",\"payout\":0},{\"id\":\"e4f58f2a-6619-11ef-a8ea-069eb31df495\",\"name\":\"Dry Player All Upgraded\",\"payout\":0},{\"id\":\"575f8b3c-e249-11ef-8430-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0.004}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(846, '1157658-lZ2kToJFfVYWxuk6', 'Fitness Club Tycoon', '', NULL, 0.98, 'https://notik.me/api-redirect?token=eyJpdiI6IlE1amoyQ0xRQUVpQnRHWWl2QzRPUHc9PSIsInZhbHVlIjoiaTBkV204cGc0eTdPb2hMemJpSzdJeEk3K29JR2FESEphcXJJQVdSTkloV2lTcDhrQ0RzbFdRaGdDYThOT0ZzajJVNTY0U1UzWVhLVmtKQnhnVGF5by9RUXh4UUJuaU1TWnJReit2cFVyOXpod1M2NUE4WVhzRHcxcEtBYTBJb2d5cnB1S1lPMGdRUFVnSThHczNSY1FwSlhmRFZ0K1gvL0FURmcyMXdlWnNSYXRpT1lsTExjKzkvc04rMCs0Vk1yN1NpN08vNlNoTFZTbnRKeU00em9KSUR2dDRkU3BFUnp1c3NiVU13UHJzUGpWZnRIMGNTdE1CcmswRzZFTFJHaDRpY0hhUEQ0QkloQkdYQjBQS1pOb0FMYVJXM0ZQY0x2OFMvQ25HR21Kc1k9IiwibWFjIjoiYzNkNDhiMDZiMzI1YWRlYTJmY2I5NDllM2I3ZDBjNDRhZGUwNTJlY2FhN2FmN2EwZjE0YWJiMmNlZjhkNGM3OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DE', '[{\"id\":\"da6fd13c-22c1-11ef-af60-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"da6fdace-22c1-11ef-9bee-069eb31df495\",\"name\":\"Unlock Bench Gym - Cinema\",\"payout\":0.04},{\"id\":\"da6fe280-22c1-11ef-841e-069eb31df495\",\"name\":\"Unlock Bench Gym - Ring Fit\",\"payout\":0.06},{\"id\":\"da6fea0a-22c1-11ef-b79d-069eb31df495\",\"name\":\"Unlock Bench Gym - Spinning\",\"payout\":0.06},{\"id\":\"da6ff1b2-22c1-11ef-816c-069eb31df495\",\"name\":\"Unlock Forest Gym - Cycling gym\",\"payout\":0.1},{\"id\":\"da6ff978-22c1-11ef-8b07-069eb31df495\",\"name\":\"Unlock Forest Gym - Boxing gym\",\"payout\":0.24},{\"id\":\"da700256-22c1-11ef-be13-069eb31df495\",\"name\":\"Unlock Ice and Snow Gym - Elliptical Hall\",\"payout\":0.48},{\"id\":\"83c81b10-e318-11ef-a56e-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(847, '1320287-lZ2kToJFfVYWxuk6', 'Laundry Rush', '', NULL, 0.08, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9wcVpBMHBncDg0emYvQzhVWWJ5aHc9PSIsInZhbHVlIjoiMWxwdG5semsyLzJkWENrTW0vZnRveGFNbmc5OCt3ODgrQ1lrZnRsMkV6eWl4UjhFU0VvLzZTc2NyMVFyZytha0ZuV2l5Y2d4OTc0NllYYmNRVEJ1Um1Tb0VYVS9lVzZoWXp0amRyTEJaWEpIY3FTUGxnRXJ4RllaNXlBMkh1NEc1ZnppQkJWdDZOQlJvaTNSQmk2UUpoTi8zb3o1ZzUxZnlYZTF3cStJK1l6c2FYMVFxdG4rQ0o3eUpNbExoSEgvMmpkWWo1YWhsOWdSWlNZTmhmbUt1U2MyQTFnY00zMjIzVzJLMzB4Wk9YNVBEeW8yejYwWnNaa2hUZlhBd0JYMHJQb1RzRmgrKzEzbHRUME50ZDJ2RGc9PSIsIm1hYyI6IjIxYzQ4ZjNmNmYxMTJlZTY5MjkzN2VhNDAzOWUyZmNlMDRiNzU0M2Q2NWFmNzc4N2FmNGJjYWE3YjNmY2I1MjEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, GB', '[{\"id\":\"0550173e-4ea2-11ef-8d72-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"05503f84-4ea2-11ef-845e-069eb31df495\",\"name\":\"Shoe HR Unlocked\",\"payout\":0.004},{\"id\":\"05509290-4ea2-11ef-bbbc-069eb31df495\",\"name\":\"All Carpet Areas Unlocked\",\"payout\":0.08},{\"id\":\"73d7ad22-661a-11ef-a0b7-069eb31df495\",\"name\":\"Crocs 2 Unlocked\",\"payout\":0},{\"id\":\"bb5fdf5c-661a-11ef-8dff-069eb31df495\",\"name\":\"Sneaker 2 Unlocked\",\"payout\":0},{\"id\":\"4abc408c-661b-11ef-a622-069eb31df495\",\"name\":\"Heels 2 Unlocked\",\"payout\":0},{\"id\":\"af8dbeb8-661c-11ef-a45d-069eb31df495\",\"name\":\"Shoe Floor 3 Complete\",\"payout\":0},{\"id\":\"af8e006c-661c-11ef-a239-069eb31df495\",\"name\":\"All Self Machine -  Unlocked\",\"payout\":0},{\"id\":\"af8e2f38-661c-11ef-9269-069eb31df495\",\"name\":\"Shoe HR - All Upgraded\",\"payout\":0},{\"id\":\"af8e5d14-661c-11ef-aac7-069eb31df495\",\"name\":\"Dry HR - All Upgraded\",\"payout\":0},{\"id\":\"af8e8aaa-661c-11ef-80dd-069eb31df495\",\"name\":\"Dry Player All Upgraded\",\"payout\":0},{\"id\":\"0fd48b0a-e249-11ef-a588-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(848, '1156214-lZ2kToJFfVYWxuk6', 'Slots of Vegas', '', NULL, 17.48, 'https://notik.me/api-redirect?token=eyJpdiI6Ikx1MytkOW44bmtmM3oyQXFnUWdsblE9PSIsInZhbHVlIjoiRDlwTy9iT0xLN3FuNldkY0tPek9ZdWVUZHM4dmwvNXpVdFBvblMvV1N4OWNLcHhjTHNPb1grbk9TVDE2ZlRqaWh1NVBqNkEyTzQ1aUwwMmNuUThUckx3Z0lPaXZnUkMyc0JvS2V0MUcraEwweE9neXYvenJ4Nyt5aFM5RFRQSzc5M1JSaE5md0ZpWVRDVTlvOTc0S1ZUaVhVYVR4NFQ3Vm8wWjdGK0VocnZqYXdpRE53THVNT2xIcS9YYWhjUVg4SUxqaFJTaHJHbTNkYjJDUithUy9HekJrNU5sd2hvUXNiY29pTFBhSHpkQ1BWVktWQmo1eDZqZEIrdm5TNmpMSTZjZDhIcjZRWnkvRWFnZktNbnFUbU1UcERMVzVtV1ZrTUs3RGN2dGEwZzg9IiwibWFjIjoiZDAwYWU0MTdhMjRhMWJmZTM0Yjc0NmI0N2NmZDU2ZjhhMmFjNDljMjJhZmMwNGNmOWZjODJjNjdlMDliMjEwYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FR, DE, IE, IT, MO, NL, NZ, SG, SE, CH, TW, GB', '[{\"id\":\"4b6f4ed8-fdbc-11ee-a3b1-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"4b6f58b0-fdbc-11ee-8b5a-069eb31df495\",\"name\":\"Reach Level 16\",\"payout\":0.08},{\"id\":\"4b6f6076-fdbc-11ee-897a-069eb31df495\",\"name\":\"Reach Level 30\",\"payout\":0.2},{\"id\":\"4b6f680a-fdbc-11ee-86e6-069eb31df495\",\"name\":\"Reach Level 38\",\"payout\":0.8},{\"id\":\"4b6f6fb2-fdbc-11ee-a506-069eb31df495\",\"name\":\"Reach Level 44\",\"payout\":2},{\"id\":\"4b6f77f0-fdbc-11ee-83e1-069eb31df495\",\"name\":\"Reach Level 50\",\"payout\":3.2},{\"id\":\"4b6f815a-fdbc-11ee-8755-069eb31df495\",\"name\":\"Reach Level 56\",\"payout\":4},{\"id\":\"4b6f8970-fdbc-11ee-bc3c-069eb31df495\",\"name\":\"Reach Level 62\",\"payout\":6},{\"id\":\"4b6f919a-fdbc-11ee-ab2f-069eb31df495\",\"name\":\"Purchase Any $4.99 Package\",\"payout\":1.2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(849, '1374688-lZ2kToJFfVYWxuk6', 'Merge Blast Number', '', NULL, 32.38, 'https://notik.me/api-redirect?token=eyJpdiI6InVoazRCdkg0cCt1aFpzMmdlM09HVkE9PSIsInZhbHVlIjoiSGpXR2JsTFdBQ2Q1Uk84d1g0WHQzZFIvQkhqa1JwYUVzTnFRSGZjc0pIVnlxSlZFQTNDYnFWZmNlVG1ic0pxMmhOQ1BqVFBlanZPR1lEeTU0RzM2OElOV1dIK1hwRlhDTEMyNXFNZUorTUlyZHVFMm85RHBLOWVKZmtOd0VrSXNjNFZjaThDM3RPb1FTYVNyMUxmTVF6M2tLLzI1QSs1ZHJueVByMFQ3eXRIN0pPNXVuOEcrbzI0Sm5zRzAzTzlCY3I4WExBay8xZEhkZUM2YlU0QTVIcTV6QndOcDBFdjNFT0Q4c1U1UjdLWUEzSWtvaSttZzZ5L0FZSkpsNWtkSzFza2EvWmVGeHRzVlNWYXlIZ0JQU2Y1azdvRjJSY1RPaUdEczdpQjErR2M9IiwibWFjIjoiNWEzOTVkNThlYTIxYzE1ZjliYzNhYjEwNzRmYWU1OGFjNzk3MzMxMTUzZGM2NGE5ODhkMmZlZTgwMWNmOTRmYSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, JP, KR, NZ, NO, CH, GB', '[{\"id\":\"38d76c26-5bed-11ef-b249-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"38d786ca-5bed-11ef-ad46-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.072},{\"id\":\"38d79002-5bed-11ef-9dd3-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.144},{\"id\":\"38d7989a-5bed-11ef-9340-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.48},{\"id\":\"38d7a150-5bed-11ef-9036-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.96},{\"id\":\"38d7aa24-5bed-11ef-9a1f-069eb31df495\",\"name\":\"Level 20\",\"payout\":1.92},{\"id\":\"38d7b348-5bed-11ef-a5e3-069eb31df495\",\"name\":\"Level 25\",\"payout\":4.8},{\"id\":\"38d7bc9e-5bed-11ef-b8cb-069eb31df495\",\"name\":\"Level 30\",\"payout\":8},{\"id\":\"38d7c630-5bed-11ef-a410-069eb31df495\",\"name\":\"Level 40\",\"payout\":16}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(850, '1374695-lZ2kToJFfVYWxuk6', 'Merge Blast Number', '', NULL, 30.27, 'https://notik.me/api-redirect?token=eyJpdiI6Im9sTTFNbmRXTDdCVVJvcUtrYjFYM0E9PSIsInZhbHVlIjoiWHRSY3ZwdXpyQ1U1QWhsZzNHdVdUOWlXak1BMTZqVjh4bUczMUlicFZZYm5sMGpiUVVrWDUrOUk3UkhFazQxcXBUak1VdXNoL1pZbEVhVDZod2VmZEVRZkRsRFdPUjJsL0VFdm4xL2xoOWNlelBTR1JLc1NPUHdId0ZRWmh4bWxaYkc1T1gvRmppZThCQWxJblN2V2hlWDEwcHQ4L0dJYm9IdGhsb1BCdW9iNGRjNnRVMHpkbHpzeHBYem95VU1lTituTzk0WWZNck9uYUo1NURXYXJZbUR6VVovU1BvOWwzbytkUTBwOWNaWWFVNG9TekVKL09obEdyZDVXK3QvdkVjNXhQWFdnVW5EWXVkQjNtT2RMRVpZR0M2c1M4dkcyWkFqaTBybWZCSDA9IiwibWFjIjoiNDhkYzA0NDlmMTVlZGUyYzZkYmFmYWM2ZjQwNWJhODlmMzY2NWVkNzI3OGE0YTg3MmNlNzVjMmExZmQ4NjZiMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, FR, DE, NL', '[{\"id\":\"7f432880-5bed-11ef-9adf-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"7f43509e-5bed-11ef-b4f0-069eb31df495\",\"name\":\"Level 3\",\"payout\":0.048},{\"id\":\"7f435a44-5bed-11ef-b3f8-069eb31df495\",\"name\":\"Level 5\",\"payout\":0.144},{\"id\":\"7f436372-5bed-11ef-8c39-069eb31df495\",\"name\":\"Level 10\",\"payout\":0.48},{\"id\":\"7f436c14-5bed-11ef-8b0b-069eb31df495\",\"name\":\"Level 15\",\"payout\":0.8},{\"id\":\"7f4374ca-5bed-11ef-9093-069eb31df495\",\"name\":\"Level 20\",\"payout\":1.6},{\"id\":\"7f437dbc-5bed-11ef-8409-069eb31df495\",\"name\":\"Level 25\",\"payout\":4.8},{\"id\":\"7f4386f4-5bed-11ef-8d97-069eb31df495\",\"name\":\"Level 30\",\"payout\":8},{\"id\":\"7f43905e-5bed-11ef-8823-069eb31df495\",\"name\":\"Level 40\",\"payout\":14.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(851, '1375645-lZ2kToJFfVYWxuk6', 'Deluxe Block Jewel', '', NULL, 11.62, 'https://notik.me/api-redirect?token=eyJpdiI6ImtMaGpLdG5Vak9CMDh6YlhCdXo1QUE9PSIsInZhbHVlIjoidVZtOVd1QVhMdUdNWEgwWmsvQnNJVW5scWxkU09vc3A1N0FVQm42RldkYTE0SEFJRi83dFl5ZWZnaERPbW12MndoUWF3N09wU1dYdWt5SnpTODBsOGJjTzN0NCtkNEluSHpVL1RKaXJ3TU1hWVhQL0hCM2JiS3d1VWV5ZktVNXE3a3Rsa2VQRm9NREhneGJxQzBuWDMvOVNxMmw0QS9qT0l4WTk1cXREOXlIcXZ1dFdkYnBZTzdETDlvdGx2a1JyWnBhbFpQWk42YWVFOStScDZDRnRlR0ZzTEMxazlwM1JkTG1PeXBmKzB0UFIraGFjQVE2YjZWMzlsMENFMlE3Wjl2WHR6TTJ0SG5BMktxdG4zUFNLL1NDanpHVW5CeURCcnc1bFlSNW5rOFU9IiwibWFjIjoiMzkyZmJhMjI2MWE0YjZlOGQ2MWQ5M2FlZDNkYjhhMjMxMTYwZTAwZmY2NjY4NzQxNDJmMTYzZmRkYmM0ZDc5MSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, FR, DE, NL', '[{\"id\":\"5bd89c3c-5c19-11ef-b55e-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"5bd8c3b0-5c19-11ef-8e03-069eb31df495\",\"name\":\"Reach level 5\",\"payout\":0.16},{\"id\":\"5bd8cd2e-5c19-11ef-bfe9-069eb31df495\",\"name\":\"Reach level 10\",\"payout\":0.384},{\"id\":\"5bd8d5bc-5c19-11ef-ab76-069eb31df495\",\"name\":\"Reach level 15\",\"payout\":0.64},{\"id\":\"5bd8de54-5c19-11ef-a7af-069eb31df495\",\"name\":\"Reach level 20\",\"payout\":0.768},{\"id\":\"5bd8e778-5c19-11ef-8e14-069eb31df495\",\"name\":\"Reach level 25\",\"payout\":1.344},{\"id\":\"5bd8f074-5c19-11ef-bf9f-069eb31df495\",\"name\":\"Reach level 30\",\"payout\":2.56},{\"id\":\"5bd8f9b6-5c19-11ef-9cdf-069eb31df495\",\"name\":\"Reach level 40\",\"payout\":5.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(852, '1375646-lZ2kToJFfVYWxuk6', 'Deluxe Block Jewel', '', NULL, 4.45, 'https://notik.me/api-redirect?token=eyJpdiI6IkJ1eTRUeXl3dGxqdU5RdTdnRzNqMGc9PSIsInZhbHVlIjoiUkljaWN4L2xhV29zenZtNzMzZjNaOFQzUkVJY0V2S0Y3R2FUdGFxRk44SzMvK3p0S3lWZS9UWVBXRFAvRkt6d1BVMVc0OGc4a3d4TmVKVDJXcmFUNWJaMVhLZHdFd0p0Q1NsaElwSUpFY0J0OFBkVXE1Q1JZNjF3NXlGNEs3ZXYzSWFET0UrV3g4YjBZYlpJQ04zVnlNQmtkdHAwNmgvY0REcytpZ0JDT3dQVEF6VHVsRHFqTDQ4dGhUMG03cFpCcFMzK2V0OTZhL0ZPUHdTMVRZbE1lbW5HOFZocEZUVFAxbUZkWFRrNHZId1dQdktxMm9xM3JMSGZIVUhTSjV4K3Y0RmhJUzlQTjR6MWdRaVZRN3QyMzgreUdGMWNmQkp3MS9DYTVhMXBWaTg9IiwibWFjIjoiNjFkNmM0MzkzMjcwZWQ1NDhmYjlhOGE0ZDZkN2QwZGM2OGM1YTUxOTQ2ZWJiMmQyNjc1NDVkZTdiMjU2MzdmZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AL, AS, AD, AO, AI, AG, AR, AW, AU, AT, AZ, BS, BH, BD, BE, BZ, BJ, BM, BO, BA, BW, BV, BR, IO, BN, BG, KH, CM, CV, CL, CN, CX, CC, CO, CK, CR, HR, CU, CY, CZ, DK, DO, TL, EC, EG, SV, EE, FK, FJ, FI, FR, GF, PF, TF, GA, GE, DE, GH, GI, GR, GL, GP, GU, GT, GN, GW, GY, HM, HN, HK, HU, IS, IE, IL, IT, JM, JP, JO, KZ, KE, KI, KR, XK, KW, KG, LA, LV, LB, LS, LR, LY, LT, LU, MK, MW, MY, MV, MT, MQ, MR, MU, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NZ, NI, NU, NF, MP, NO, PW, PA, PG, PY, PE, PN, PL, PT, PR, QA, RE, RO, KN, LC, VC, WS, SM, ST, SA, SN, RS, SC, SG, SK, SI, SB, ZA, GS, ES, SH, PM, SD, SR, SJ, SZ, SE, CH, TW, TJ, TZ, TK, TO, TN, TR, TM, TV, UG, UA, AE, GB, UM, UY, UZ, VA, VE, VN, VG, VI, WF, EH, YE, CS, ZM, ZW, AX, BL, BQ, CW, GG, IM, JE, MF, SX', '[{\"id\":\"5c5992c4-5c19-11ef-af90-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"5c599d14-5c19-11ef-80fe-069eb31df495\",\"name\":\"Reach level 5\",\"payout\":0.064},{\"id\":\"5c59a584-5c19-11ef-a1b4-069eb31df495\",\"name\":\"Reach level 10\",\"payout\":0.16},{\"id\":\"5c59adea-5c19-11ef-90a9-069eb31df495\",\"name\":\"Reach level 15\",\"payout\":0.224},{\"id\":\"5c59b678-5c19-11ef-9de5-069eb31df495\",\"name\":\"Reach level 20\",\"payout\":0.32},{\"id\":\"5c59bf38-5c19-11ef-809f-069eb31df495\",\"name\":\"Reach level 25\",\"payout\":0.48},{\"id\":\"5c59c83e-5c19-11ef-a98a-069eb31df495\",\"name\":\"Reach level 30\",\"payout\":0.96},{\"id\":\"5c59d284-5c19-11ef-8387-069eb31df495\",\"name\":\"Reach level 40\",\"payout\":2.24}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(853, '1375653-lZ2kToJFfVYWxuk6', 'Deluxe Block Jewel', '', NULL, 3.36, 'https://notik.me/api-redirect?token=eyJpdiI6IlRSd085SFlXcW0yTHhuYXJIeEF0NGc9PSIsInZhbHVlIjoiSDZYNWdrWGZGbEpVc1ZXSWQ5bWdNai9ldEY4SWFtY1hZZzNsVEZPOEM0dHRXRHAzcTdNMWs2REQ0VVN3TFRtcFRpbEcrNHJ0UGdiTzJHUkpsSEgvaWhPQXY4V3hpbEVGWEdsdVNYZFcxaWJUL0tUOGVoSmtJNEVZcFNXM05ZZGE1Ulh3bTJKbXM0UTZMOFB5UDgvOXU1a3Q2aUY4TlZsbW8vQ1JOUFJjaEZsQUpwQ2lNYkdvT21vaWJQS29CZUlFVDNWSEM1RzQ2ME5RTld6K0I3VERPR1BWY3NrM3NjSzVSQnFZSUNoVjg0bE1sWDIvdUtPcHZUejA4c1NUOE9lOGkrd2Fyb2drREZKam5VOHUydTNPa3lvS1hnZXpFVTVWNnJEQlVaNmNCOG89IiwibWFjIjoiYjFmZGFkMmQ1M2RlOTkyMmRlNjBiYjRiNDgwNTFjYjM3ZWRhNjllMGI2MzExZTRkMmM2MjhkMmViZjkwMWRkZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, CA, AL, AS, AD, AO, AI, AQ, AG, AR, AW, AU, AT, AZ, BS, BH, BD, BE, BZ, BJ, BM, BO, BA, BW, BV, BR, IO, BN, BG, KH, CM, CV, CL, CN, CX, CC, CO, CK, CR, HR, CU, CY, CZ, DK, DO, TL, EC, EG, SV, EE, FK, FJ, FI, FR, GF, PF, TF, GA, GE, DE, GH, GI, GR, GL, GP, GU, GT, GN, GW, GY, HT, HM, HN, HK, HU, IS, IN, IR, IE, IL, IT, CI, JM, JP, JO, KZ, KE, KI, KP, KR, XK, KW, KG, LA, LV, LB, LS, LR, LY, LT, LU, MK, MW, MY, MV, MT, MQ, MR, MU, MX, FM, MD, MC, MN, ME, MS, MA, MZ, MM, NA, NR, NP, NL, AN, NZ, NI, NU, NF, MP, NO, OM, PW, PA, PG, PY, PE, PH, PN, PL, PT, PR, QA, RE, RO, RW, KN, LC, VC, WS, SM, ST, SA, SN, RS, SC, SG, SK, SI, SB, SO, ZA, GS, ES, LK, SH, PM, SD, SR, SJ, SZ, SE, CH, SY, TW, TJ, TZ, TK, TO, TN, TR, TM, TV, UG, UA, AE, GB, UM, UY, UZ, VA, VE, VN, VG, VI, WF, EH, YE, CS, CD, ZM, ZW, AX, BL, BQ, CW, GG, IM, JE, MF, PS, SS, SX', '[{\"id\":\"a3bca00c-5c19-11ef-8b3a-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"a3bcc816-5c19-11ef-93f9-069eb31df495\",\"name\":\"Reach level 5\",\"payout\":0.032},{\"id\":\"a3bcd1a8-5c19-11ef-b86b-069eb31df495\",\"name\":\"Reach level 10\",\"payout\":0.064},{\"id\":\"a3bcda9a-5c19-11ef-91ff-069eb31df495\",\"name\":\"Reach level 15\",\"payout\":0.16},{\"id\":\"a3bce350-5c19-11ef-a43b-069eb31df495\",\"name\":\"Reach level 20\",\"payout\":0.224},{\"id\":\"a3bcec2e-5c19-11ef-bd57-069eb31df495\",\"name\":\"Reach level 25\",\"payout\":0.32},{\"id\":\"a3bcf688-5c19-11ef-a441-069eb31df495\",\"name\":\"Reach level 30\",\"payout\":0.96},{\"id\":\"a3bcfffc-5c19-11ef-b13a-069eb31df495\",\"name\":\"Reach level 40\",\"payout\":1.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(854, 'k3w7qg3n2o', '888 Casino: Real Money Games', '', NULL, 9.80, 'https://notik.me/api-redirect?token=eyJpdiI6InB6VUFHOVoza0dhYWNNS2F2SzVSVWc9PSIsInZhbHVlIjoiOVkvV0F6bXl0WmlqRVFlTnFXWnk2aEFDTEpvcUEyYkJFNUEzb1hGWE9JVU9pMWtRTC9NL3hJWEFSSk5XRDNTSzNOVjZjYm1uTjRsRVpFNFZ3dERRaHNtZUhrNzFXWnhvbHR0MGpSS3BjcUpwcGViWVYzenhoYjcrT2FKYW5kRE12Skp3YVJISlVtRXhIelQ0UUdOUGp5djU4OFBxMCt0ZTByd1RmMHErbm44TmwyQjBONXB2L1lTVHk0UlI0VU1qQ2V0dE9Gc1BBTVRRa21SU284Tkh0WjVuZGlvVnBzN3RMV0ZmU0RyZ2tBeFJ5Z0lqYUowZmF5aTFCWk91OEtzenBJYlNLLy9pQk4wbldmL3lrQUNQM0hKczhHQktwUEM4dm94a1psUVc5Q0NoZFVENWNjWWpwRGdxZXFIbTQ0V3hOZE5yTSttdjhPSC9VNWlEMkcvcVRwajFGK0tzSFJ4MnAycGIwd3kwRjlrPSIsIm1hYyI6ImIxNDVlZTIwZDRkNjU4NTk3NGIzZjJlNmU5MzQ3Y2NlZTQxYWFmNWQ1MmI2MWZjN2Q3NjYwZWExMDI1ODRkNWMiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'GB', '[]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(855, '1302565-lZ2kToJFfVYWxuk6', 'Match Collector', '', NULL, 3.52, 'https://notik.me/api-redirect?token=eyJpdiI6IkhTQWdzb1Q3aXdaQ2lMR0FvY0F5N3c9PSIsInZhbHVlIjoickpXbWRUblZITWwvb3g4dTUvaWh3eVlxak5PendUcENqUmxwZHhpbms0VFk2cmRDbnhpcjMxSXhESmUrY2Npb1VYTG5RNXBVV1pzcW1nMWJFZCtvRHNpdUZVKzloSTRhSWF0UVkxWHdjT0xCYzNSakx2RFd5ZWhYa01td2xHeisxQlE5Z3BnaHZ5MlVvTC9OV0JyTFBJdmFIM29JSGljSzBONm9zUDF2VzA3QzViS1hlR1h2K2dYRURkSUwxOUZBV3BvTDJxNUQ0NjZFWTUzK3ZOZE5YWk93TmtXZTEwaGpZMkxTaDIrMWl0b2doc2JLeVIyd1JBYXZmc3F6bzVybWZJNnFWV2JmVC9RdzJlc0dYTzBxYmQvYWsyM0tjM3hSL1hEaUluU1RNb2c9IiwibWFjIjoiYjViNzQ1Y2E5ODA3YzU1NmE5Y2U4YTMzYjljZDIwMDZiN2YwZGZmMTMwMjI4MjJiOGI3NTJlYTZhZDg3MTE3NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ', '[{\"id\":\"2d2441e4-4921-11ef-847d-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"2d244ae0-4921-11ef-a092-069eb31df495\",\"name\":\"Complete Level 1\",\"payout\":0.02},{\"id\":\"2d24531e-4921-11ef-819c-069eb31df495\",\"name\":\"Complete Level 5\",\"payout\":0.02},{\"id\":\"2d245bb6-4921-11ef-83e4-069eb31df495\",\"name\":\"Complete Level 10\",\"payout\":0.02},{\"id\":\"2d24641c-4921-11ef-8b9e-069eb31df495\",\"name\":\"Complete Level 25\",\"payout\":0.04},{\"id\":\"2d246cbe-4921-11ef-b4e5-069eb31df495\",\"name\":\"Complete Level 50\",\"payout\":0.08},{\"id\":\"2d247646-4921-11ef-a9bf-069eb31df495\",\"name\":\"Complete Level 100\",\"payout\":0.14},{\"id\":\"2d247f92-4921-11ef-a4e3-069eb31df495\",\"name\":\"Complete Level 500\",\"payout\":0.4},{\"id\":\"2d2488fc-4921-11ef-a3eb-069eb31df495\",\"name\":\"Complete Level 1000\",\"payout\":0.8},{\"id\":\"2d2492ac-4921-11ef-86c5-069eb31df495\",\"name\":\"Complete Level 2000\",\"payout\":2}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(856, '1396268-lZ2kToJFfVYWxuk6', 'Crypto Miner', '', NULL, 11.80, 'https://notik.me/api-redirect?token=eyJpdiI6IncxeW9Fa0kyeHlnVytqbFBTaUt6eVE9PSIsInZhbHVlIjoiRDhUYTlpTlU1c0dmclRDc0tSZktTY0NSeGlMVG9waGNaK3pYZWVMZFZ2Qmpocnk0TVZzUVlFQ3dFRldrYXFBS2ZwL3dsa3NyeUZBdnBhZDYrdWpVMzdYUlV2WGk0NEYwbkk0U0VCQ0lPSW5QSktsaXJtRHNRMzZEakcybkVHZFhBZXdwS2NyUENKdjdEZ1Z3RGRTZEdXbU0xN1hZM1I4bWgvUmRTdHQ1U0lGdjJrZ04wN1BvclJHeXpQekxRTmozc25DNlR1b2phWTg1VmVLKzdwUkdGdk1mcFlVM0tHRVhVZDVSRG9mT2NaMVhGQnF5RzdHN3BuZm5WeWVlbzNndWRucDl4WWRiSGFleUtPdDNjOVh0TUE9PSIsIm1hYyI6IjkyMTMwMzZmNzM2ZWI1NzVjMmFiNzI2OGQxZThiMTFiM2Q1MmIwNDg1YmYzZjY5MzEyNmRkY2JhNmUwM2VhOWEiLCJ0YWciOiIifQ==&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, BE, DK, FI, FR, IE, LU, NL, NO, SE, TW', '[{\"id\":\"8a726c90-5fd8-11ef-a075-069eb31df495\",\"name\":\"Install\",\"payout\":0},{\"id\":\"8a7294ea-5fd8-11ef-baff-069eb31df495\",\"name\":\"Own ICO\",\"payout\":0.02},{\"id\":\"8a729e72-5fd8-11ef-82a1-069eb31df495\",\"name\":\"Buy Akatzuki\",\"payout\":0.04},{\"id\":\"8a72a71e-5fd8-11ef-a990-069eb31df495\",\"name\":\"Collects NFTs\",\"payout\":0.04},{\"id\":\"8a72af84-5fd8-11ef-8699-069eb31df495\",\"name\":\"Buy Bloxverse\",\"payout\":0.4},{\"id\":\"8a72b826-5fd8-11ef-b7eb-069eb31df495\",\"name\":\"Expand the game to web\",\"payout\":0.1},{\"id\":\"8a72c12c-5fd8-11ef-9e13-069eb31df495\",\"name\":\"Hire Jeremy Palmer Manager\",\"payout\":0.4},{\"id\":\"8a72ca5a-5fd8-11ef-b906-069eb31df495\",\"name\":\"Achieve 5000 lvl for all businesses Crypto World!\",\"payout\":0.8},{\"id\":\"8a72e7ec-5fd8-11ef-b0f1-069eb31df495\",\"name\":\"Buy a Chest of Gold - $49.00\",\"payout\":10},{\"id\":\"28c41744-dfe6-11ef-9f9f-069eb31df495\",\"name\":\"Earn every day you play\",\"payout\":0}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(857, 'kp5nnxnd5m', 'XMC', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6ImtTSE53ZVQyR3gxWTQzYUYxb0xpc2c9PSIsInZhbHVlIjoieUFQTk1ZcEhUVnBFMlBNcW50TGF6cytSSEE2TnBRZVJJQlN4WjAwY0p6b0phVTkrc2pOMGQ4N2xGYm9oMjc4UnVjOWttb2FJMWNRQmg2QW81SGdZMk41YUp3bkFmR0JCMHpXdmhQdmFiTW9KN2NrQng2UEFWdTEvMUVMNUNINEI1OGs1cDVHMDlmWWtzeU5JUjRRZEhhT1ByZE5aM1EzN2I5TUlNUDlsd1hUZG10ZWt5Rkpac1RJTkdMZEpwUnNUZXdtMTVtNHJIVmxjMzczYUZtN3htNXBOR3lOaXZDUHR1K25vMUJ4N0M2SEErZGlvd1Jad2FyZFZxZHFDRjBMVG55dkZ1d01Jb21kWWh2NkFwNVNtdGd2QW51MHJyWDV3NHVjMjZxeGVYYW9XUGlFc2JZWVVOZUxTR0JGK2FqQWgiLCJtYWMiOiIzNTFkMWQ3YjVmYmEzN2ZmYzgxMDkyYTBkZDQyOWRjNjVmYTVjODFiMDc4YzcwMjI1Njc2ZGZkZWFhNDllZTliIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12');
INSERT INTO `offers` VALUES
(858, 'k3w7qvq42o', 'XMC', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IkRPUmZVNHM0dTYyc01ZRWVlWE9tbWc9PSIsInZhbHVlIjoiVGxvMGVjdmxRYlM2Vml1VnA3TWc5aTMrbnZ5L2ZremE2RGh3VzhRbmI5VndlcFNneGZXVUlmY2J1Q2FkSzA2LzN5ME9aQktxQ1dUVjZVNFZoQVJDcnR3V3hobHpDTHBlM3F2ZSsrM1ZGZkFncTdYUTlwdVRoQzV3K3k5ZWxuelgwUnZXeEhGbUo5c1BiSWlRdVFQOXRPcE1mcHdGcjZMQW83V0NzS09TeFg2QTZTVlBVTjVlbWt3TVpWeWY4MVZZRTFRMUtZdHRFcTJiRzM2QndYbythRjZJdzJGdXMvK0hxSTFuS1dHeGJLWlFNT09KVjVXRFNVTkcxNTVYblR4eXRUMUc5c25VRnJPNGllNzc3blpQQSsyajlHRXR2aXZueU9TTVZxNnp0eEcyNDJqUzliTER0RWUyRDRlSjgrYU8iLCJtYWMiOiI0MjJhNjAxMWVhMDcwNWQ2MmIxZWZiMGZlYmY1ODE5NDZlMGExYzkxNGYzNjNkYjRkYjFhYjczMTg1Y2E3YTMyIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(859, '8dwkx8oj2e', 'XMC', '', NULL, 1.12, 'https://notik.me/api-redirect?token=eyJpdiI6IjdUNkdPbGhnTVBNcjZ4YTR0MTI1V2c9PSIsInZhbHVlIjoicVBNcEY2Yk9odFpSdGx1RlhDdi9JUUJ0UkxNc1lTMExGK2hHZXJ2Q1BZb3pGdytyK282dVdlRTMwVXdWMmJVdkp4WGNob3FnR295SHRJUElDUk5HalFXYkdMaGJ4OTRDd3BhalkxUUFPNFlKcGhTL1pXTWlXbnNEYlQyT3FtNkpKSlJuWG5lY01rUEJjZ2tqcHArbzhrekxqMUZ6Z1UwTE5FdWhyOE5rb3hSVW5DTVJIRytnNGFaekxmb2xVZFlpZ0xkdFZod1F3a2NMNnMxSHVMSU5Wa09VM2dHcHJPLzgyb21XU0NQUG8yb3huWXd6NFhwWktmME5QU3dMNEplUkU2Y1RSK2VVN2xTbkZPNE42aGp2Q0I3cnVjZEZmb1pvNTVrbFBGeE9IUXIwbGdqK2dtY09UTzV3YUpEVDJDV3IiLCJtYWMiOiJhNWU5NzRkNzYyMzI0ZGE2OTcxNThmOWYzMzgxNjZiNmMwZjNhMjBjNGRkZDFhODM4NjJkNDM1MmJjYmE4Y2E3IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE', '[]', 'mobile, tablet, desktop', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(860, '642qzlrx21', 'GG3', '', NULL, 0.17, 'https://notik.me/api-redirect?token=eyJpdiI6IlRmSW5iS21Vc1dxdm9EbXNUcEVuWkE9PSIsInZhbHVlIjoid1V1VmZHUE8xdkxJSmJNZ2dhaEhqbGNxN041aHZ1bGFOdVpYQkY1VEZXSVZLSUt4eGp6U2JqM0w1czIxTW4ydTlTMkhrQ2F6bXdGeFlDREswWTdZTm8yZzQ1RjlyY1pTWmFIejBvS0t4bGF5QUl6ZG8xNWkvQ3BjTmgvTklJNFlhU240ckt0TmdHbmNBWHR3c2F5bmEvQTJEQW4yQW1IbmhHYktSK0VmK3F4akhTdit5U0ZsZmYxWVhmOUdrUWJPZGtqNXRoY1lNSlYzdzlSZVVIRUd0WGg0eHBjTEowRWNsNGV6YzYyaFdaeFM2NGRYSHhiMkQySi9wT0dIbm9rR0V4TDFJbW9QRnVyMmZFN2dnL3ZDL2JKdmltSlAydWhjWWNHZjJ6MG9GdWtMQlNPQ2RrdTI1a09neU41MU9PNEciLCJtYWMiOiI2M2NlOTMyMjNiMzUwY2Y4YmRiNzFlMjUyYmZkMjZkYzMzODgxY2M1NTEyOGMwYTY4NjJkOGE4YWZkODRiMzYzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BR, CL, CO, IL, IN, PE, PT, TR', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(861, 'jg58m43q2r', 'Nova Jackpot', '', NULL, 14.40, 'https://notik.me/api-redirect?token=eyJpdiI6IlZNYWE1YnpJVlpYaFpMUU5YUFlDR1E9PSIsInZhbHVlIjoiRFFqWU5TQyttOC9pcEhHVnVOY2dBanp5OGVRRzBMbXZ6dU9RWVNXeVE1R2ZIYUFNZVoza1NVaE1UTFMxQ0JINTRIelcyM2N6L3A5TDZnc1QwL2FzOXY5N2NuazRNSjZSU0RrRHVFYlZRVnNVSmIzaHNVSHFyS20xMDdGRWg4dFFSMzJudkdMbjhMaVRLQzA0eWVsZ3E2YU9oeTd4UW5zelRHbWM0bFZockNLUkxqUzBaWTJXelpZQjRtUlFiYTNRK3lYdlJFMlBoZ3JlV1FxOW9CWG52djdLcHVaSjRmd0NEVUVBU2g2Y1BBSitmVWhrWXY0VkpKVURKcGRxOWlCVlRQQ2dqYzZ3anJrSWMrMkZ3d1Y5RUlHL1B5RG1teVhHYjBhdmw3QkhrejB0VmJFWHV2UEhrVThHR0x3Y2JEbVFDQTB5K1JYNE1OOXoxR2NxdE5WNDh3PT0iLCJtYWMiOiJiOGI4Njg3MjA4NTJjZmYzMWRlYjRmY2UwNWQ5MDk2ZjdhNTIxYzA2NTlhZTk1NDliZTUzMjJhOTM0Y2MxYjgzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, ES, HU', '[]', 'desktop, mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(862, 'xkCrq4GzKFXpyUfgm2H6Z-ZPwVWfTSwLIJu0B9', 'Night Hunter: Stealth Assassin', '', NULL, 1.40, 'https://notik.me/api-redirect?token=eyJpdiI6InhxbTl3N2d6N3MvUUF2M2t0VEFXZnc9PSIsInZhbHVlIjoiL2hYWXc5SmsxaXkreUIzWGVjZkwwSm82aHFFWW5Td1U5NVJlazEwL2loRlRnZWE3SEF2QmtXZ0c5M3JtUW53QTM1b3pPNllLQk0rVzJGU0xxYSswVXpFWm9SS0g4TlhIeUhYVmtreFBZeVN5TU5iMENwUnJ1TFZjclIweFdCWGZmMXN6YWJVWlUveGY2RWRuaU9zdjBITkdMb0Q1K1owcXpWVWJaTmtyRWMyeVdaS3R4RE5YSGtlVHA1QmdORDMvM1diRVVtZGx3bW9NWnZEMXlYbnExU1p0ZlppcVZXaEhQT2ZRdWJ2QjRkOC80QVJTU1JjRWdnNkxYK1h0M2t4RWJnc1IzL1dNTnZvS1dJYkErYlRCU2pOUGNySXMyd1UvcmdZS2xiUmdHUkJkcmZCekJZUGVxdTlvRWZIQWw2bXRHdHRINHFOK1ZjM0ZVcVRlbHhWcXdiZU1LZlYyUll3Wmc2VE1wZ0VBT0p3K0ZjQzZNem1lZUV0YWkxcG9OZ0xhOWFDV3U0Q2QzS3d3bTd4cUFpUC8yUWJNc2l4RWh1Nk53UHZyMlREQU9wbzlUbXNCY0VyMXFUbUJhaUJ0N0d6cW5uck5LYVhRMjF4WGtpbisvQVJoY1VDZWNhd3JGWFRpSmoxd2h3TzVsVTJLUkk0V1ZrMWo0LzRQME40aHpsTU4iLCJtYWMiOiI0NWI4NzkzNmYzMGFiYzIwNDJjZGQ3M2EyNDMzZmIxOTI3NWY5Y2YxYWM0NjIwYjQ2ZDc1OWEyOWI5NDk4NTAzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US, GB, DE, CA', '[{\"id\":\"20\",\"name\":\"Reach Level 20\",\"payout\":0.035},{\"id\":\"skin2\",\"name\":\"Unlock 2 New Skin\",\"payout\":0.07},{\"id\":\"skin5\",\"name\":\"Unlock Skeleton Skin\",\"payout\":0.175},{\"id\":\"credits100000\",\"name\":\"Collect 100k Brains\",\"payout\":0.35},{\"id\":\"purchase_no_ads\",\"name\":\"Subscribe to Remove Ads (optional)\",\"payout\":0.42},{\"id\":\"day14\",\"name\":\"Play the Game actively for 14 days\",\"payout\":0.35}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(863, '672331-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 7.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjV1QncvalFlNTJsQWJlRnlBcDBvSXc9PSIsInZhbHVlIjoidVBpTUxmMGl6eDI1QUlEMk1ZSmRFTEZrWFg0TVdsb3RLSExaeDZJeGxTOXZ3ajJ6RXRCbFFDNldTVlBULy9xT0JKUnZXVzczYm4xT1FCWWpUemt6OW04QXdlSnVmeHpacTZvbUpnRDBJOGROOXJUNWtBOHJvQkJZNGNDc1hUUzlFNEFBY1MyL0xVc3A1VCtFNEdSUHpPMXlkU3RreERHL0JlTmk0cFd4R3VTM05PRzl3VWlpd3RJaXJSejZqTXhpdWRWQ1hRbFlIL1FBNWN6TnRKWDl1NndZOTVKWGV4ZTZ0dFY2RGljUDVRU1dOUXViVnBhRnppQXFidUtXKzR2Ukw2RXJWME15b2trR0ErSGt1YzBQeUY0RnFCWncwVExYZjEweS91QU44T3M9IiwibWFjIjoiZmU4YjJkYTkyZWE3Y2YzYTYyYjg4M2U1ZTA5ZDAyOWM5N2QyZDFiNzc4MDU2ZmEzZjNjZWI1NDc4NDE2ODdkNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"2a25be3d-f09b-4d69-a667-337d9c67731a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"0c4dc8a6-3f76-4d8e-88be-7b9ddf1559e3\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.5},{\"id\":\"b0ed63b0-684a-4a0c-81e9-68b973ecc5f4\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.7},{\"id\":\"0c6ebb43-d6dc-40c9-bdb4-b8a24f325e76\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":2},{\"id\":\"42015960-e021-4be2-9a3e-e6eec7e0a81c\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(864, '672332-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 3.56, 'https://notik.me/api-redirect?token=eyJpdiI6IkpCY2dzYnVZZm5WUUhtMlR6Q1g4c3c9PSIsInZhbHVlIjoiMHBYMTVKS1Y4ZDZlYngvK3lUWmZrYmdpejRrS1ovMlliRUYvQ0Y2SkZRU3VNU09RZXZ2b1lMbXcvUXZ6azZ5cWpWRHFjTVl1enJkZXNYQitNTTgrdWlZYWgxNC9vb2lMNU5QS2RuNDhxRFczR2ZyVDRFT2tHVnZBdHIrWFAxdytwY29CK0ZkeUtSSzA3TDVYY1pDbDhFR3pDcWttLzRBWC93UWk2WGhzR0EyUVllN2VYQ0lsWS9BQktPQkh2dFhPd3F1Rlc1TDJ6aXY3Q0NNT0d6NlhSbEJOTGlaamxiRDdhdC9vTjFLQ2E3YS82d2hzMVRoS3doNDRFNHlRNlM1SnplK0lJamV6ZXZVOU1qNWxIdEhGYmgwZEpONGdlaUhPdk8vWGJBQkFRcFE9IiwibWFjIjoiYzljNmI2MjY1NzFiMTk4ZmU5OTZjMzQ2YmU1NDZkYjc0ODA4YmU5MDdlMjIyMDdlMGM4ZDBlNzIzMjE2MTQ3MCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"aaab8303-8f01-45d0-9392-33feeccb478e\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"2b6b5aeb-9a34-4130-b333-4dbe1d1cf13c\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.28},{\"id\":\"0c6630ba-f10f-45c1-a86e-9c0f0cd70fda\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.34},{\"id\":\"442ab363-d911-48c5-a858-97e43d394a58\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.86},{\"id\":\"3649511c-14e2-43a8-9a17-f63dcd0d8ebb\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":2.08}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(865, '672334-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.84, 'https://notik.me/api-redirect?token=eyJpdiI6IlQwNlFtcnhXZEdlYWRpb3NLTHhsMGc9PSIsInZhbHVlIjoiUjNXbUZoOGlhNkxCTXRyMW1CVWlMZkg5MmZseVJ2dkJGWFhGMEVQVDlvak0xbVdEWExpTkg0RTRZdlJkd3VlSzlyYmFSQmZSc2syM05Ha0VkZlY3YTFtdGZxbGRRYXF3TFozeExZUDJZYlRtWmhOQU9UM2VWSldtWC9yTDR4SHBBdHNwNE9FaGJGcnlJaWYwYzNjSUorVXZ6blQ2dU5JSnp5SjdSK3NtckpqTlRuT3pZZ3BKakJmeE00N1FYQnNGSGk5bVp5OTNDeDM0STNEK2dlVi9MMWV0MzBEbE9IRTVUTGljbzRkTC9UYTJNd25oYWRzZzVQdHJWcElpakhSbzNrR25ac2RBMVdpUU1oeE9SeVdjblI3L1lENUdsVm9iT3JPSkdhVU9WZFk9IiwibWFjIjoiMzQzMGNhMjZhZjdhN2M2MjczZjMyMTMyNjA1NjFmZDA1M2IyNmJlNmQyMTBiMThiZmM2OTgxYjlmNTI4NTBkZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"bacf2982-1837-447b-97fc-19a0e50d6def\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"577bd7c5-6a8c-40b9-9b2f-bf5c3548d7f2\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.1},{\"id\":\"fdfe474a-906f-4f8f-b074-d96c6eceb809\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.2},{\"id\":\"ac02dfe7-71ca-42b5-887e-68d5303f63d5\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.56},{\"id\":\"b4de43f3-4603-4d10-b9ba-a361460e00f3\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.98}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(866, '672336-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.35, 'https://notik.me/api-redirect?token=eyJpdiI6Imt1VVlDNThiVlpRK1BuNUJHRFlqREE9PSIsInZhbHVlIjoiTm05bjV2RU9lM1hGQnJiMTlkaVV0UURDMld5MjdoSk1WTC94cEczNnIrbFdCT3hlYTFGamc1SDNkYnl0WmtSZThnZHJMb2ZYZW16bzFqbllkM0hyVCtkbGxEcWRaeFJWM1VHK3UxeFVQVFlERHk4T1pnbnRJdy9sK3VqRFJWWkx1TmlCZTRyd3hQNnhITVVOd2doU1hwWUdPa3g5aGlxQkpHTzBMM2tyeVNJMWFzWnRZQTBidm5nYUtjaVRiMHBSeXRNQ1d0d0FVaHdZYVhNNG4ranhaRnZBQkNoT0FUSi9qNEs3Qi8wUzlLNUdlbGxxZ2pHVU5taVROZ3JHb0Q2SUFhYXpEcjRyNWdHam5MRmpPNU94T21zQ3RQQithQm9nS2RQcHEway9oWDQ9IiwibWFjIjoiMjU5MjY2Y2RhODJmMWUwMzA3M2Q5ZjVjZTFlOGU4ZDU5NzFiMzQzNDM0ZDBlMzQyNGVlNmU2MThhM2VlMjNmMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"685a3605-f86e-4694-bbd3-f8ce42b7553c\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"afcde23d-2273-4f74-b426-97b6ffe60fb3\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.112},{\"id\":\"091d3a3e-c4bd-453a-bee1-62abe9b1bb96\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.14},{\"id\":\"bb071cc2-23aa-490a-8260-cbe6fb4ee9c2\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.4},{\"id\":\"ee663b60-ab8b-44f0-bd5a-a0d18ed1fe0f\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(867, '672337-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.70, 'https://notik.me/api-redirect?token=eyJpdiI6IkxhWlZrem5rODd2Z3pDeFVhdkVIb2c9PSIsInZhbHVlIjoidVlueTkvcHdONDZzTklpc3doazBxSG0rT3g5L0RUdXk3dlFRSDlvWFZGdlpLZE5kUERMVmk5M1l3ZVZFaWJIWlhyTHBsdXp3aGlpd1ZkRDV0ZkpPbDU0c1RyVHhuUmRBK3g0d2xlVHFyMUxjeXEvNjBiV3lOZmI1UkZ1UlhzbklHV1d3TlRPcjNONGQwU1dmTmxTZHNISnp3YWdVdUNYd0V6OWxxRFNIeE8yY1I4NlEvaTg2Mnk4QlhnQW5vVU80YU5LNTRVT1JCZGJxdDBFNnhUR3RWWFA0b1EwNmJzOVBwTzVjMUJkTDFURHFROXZvVGxSM3lyb3BxeVR5V1VUMEE5SDVWZnNaTHhOYm9tUG5TK0xWTGoreXVHS3luRGZMUFNJWUE3WHdpaXM9IiwibWFjIjoiYWQzYThjZDAxZTE2YWRkZTI4MjY1YTMzYTQ0ODgxNDhlODBlZWI0YThhMDNlOGM0ZGQzMTUwODIyOTBkMzBiMiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI, IS, IL, IT, KW, QA, ZA, ES', '[{\"id\":\"940af6c9-885b-4491-b628-be28ea06132a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"42b4c56f-449e-4bb3-9d11-b925047675cd\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.056},{\"id\":\"8f38e8f6-ff75-49ea-ac06-0723c1b6bc78\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.08},{\"id\":\"14eaab98-c026-41a5-b307-197a9dd80f4d\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.224},{\"id\":\"304b6ece-bdbc-418a-8c81-cacb23c613b3\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.34}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(868, '672339-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.40, 'https://notik.me/api-redirect?token=eyJpdiI6Im9Ram4wZTQzY2d0NEtaNThoSExKY2c9PSIsInZhbHVlIjoiOGsvYnBQRUtabUI5SitGZUg3NjdveEc1aE1JanJrdlJWRDJZbWJIZnFEMFR2Y3o1c0FPbHJjWXp3T2d1RmpZU2IyQkI0TnNXRTBzZjArV0M0VkJGYitETW9oeFMxMHgybzJObWNDMDZLLzc5TEFyZXZwV2lKU2dhRkJqWTg4aDdwVUg5RlNkSjhyVEZsZ0U1L1Jwd215UFZjSmpFZUpJaUxIbWxZY2c2K3VLcUpTK0d1VnNzbWtlRG01SDZUcFBnRWltY3Jmanl0S0psZlc4aDJ1MWVhNVBSTmQ1SkpUL2xiMWxEbnd5SW41cXcxTVNibGNVSDBMMTlNN0lYdUtQNDZ4NW1ESmdZRkhuVzFwS3hZUk5uYmdJY0FNc1VWemxlbmFrejRhY0FYbmc9IiwibWFjIjoiZjgwODkwMmU0NDM2ZGU4NDQ5M2I2NDk2OTUxM2QxMGY5Y2Q1ZWFiNzlkNDZmM2VjYTNkOGU3NDEzMzViNTQ0YyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, MY, PT', '[{\"id\":\"7ebcb81b-6a97-4c2a-b89a-2d9242c6e0dc\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"6cfd5b97-769e-4bd0-9a57-9d71b51bc859\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.02},{\"id\":\"fc0c1f51-ccb9-456f-8646-d058c1863a67\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.04},{\"id\":\"f9062494-1000-48ad-8d8f-a8d6e0195a8d\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.112},{\"id\":\"7b6013e3-710c-4556-b408-a2c8330e31c8\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.224}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(869, '672340-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.11, 'https://notik.me/api-redirect?token=eyJpdiI6IlhmSE10UGdrU2hsZEsydHh5TENoOEE9PSIsInZhbHVlIjoiUVhWTFJHU2RKUjU2NE5hZVJjeVJ4c2ZWZCtQd3BpMG1Sb01STjBYS2pSditUeGdudUpZWGI1WmFqNTBla25xeU52MnU0QVpCRW9BN3NBd0l6UXl2NG1ramFSUnhuREhnVTFsL1VNY1lRZXhvUXo3T3hxTXhNeGhVRnh6ZlkvV3hkb2RiZGJvUDZ5ck1xQXlPYmNJakpLMGVDejZ1OWVrRWRkc3RCV1Vybk1uWTE2a2FiNlNsZUNDd0RCYTh6cnZmZkc5djRJZEUvWmJHUStqVmVWY3JvUXVyblJVWTdTZ2ZaZ2NtTmVIVVoyVnRzb3Y4YnFwc0ZmR1BJZnNJdU1RQ0ZUUDdQbStmRUlLRjk2cGJyRFlPQm1Eb2NrMnVZRU5UNHVzWjRsZnRid009IiwibWFjIjoiZWM0NmI1YmJjYjE0N2Y5NWI3ZWM2NmYxOTkwMTAyM2E4NTg1MzUxYTBmZWI5MjgzYmU2YjhmNzI1ODk2N2E2ZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, PL, TH', '[{\"id\":\"ce4a030f-a1ae-48f3-8f35-0c5269f0d4da\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"bf22c676-deda-4237-8e92-332bf4772ef1\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.048},{\"id\":\"521c8512-3b4f-4ed7-bfa4-761e698c6ecc\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(870, '672342-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.10, 'https://notik.me/api-redirect?token=eyJpdiI6IkZiSjJKa1BQTmd4ejJ5ZndJdEJhVnc9PSIsInZhbHVlIjoiNlNFVlVTdzhXd2UzREQ0a0Z4eGMwNjIxdXhtamgzTFBYMzl2Ty9vYk1WWEdtOTl3L0MvOUdJV0xZVGFkVktYalJzV0ZWSXJlWWkyRjQ0UzlZVGRMb1J1cTR1eGROV3BySHFybDNtQjJib0NIQkVPdTdHc2tDZnJCMXdQdHNBS0tqUmNmazJXaFZzT29hdGNxOWVzblE2N3Rvc3dMdTA2TnM0Rk9LN0g0TkIwWWJzWWVjT21wQTRWa01zUmtVcGw2Q0Y1OUZXUys4eFMrVi9odHRhOWZLbkpyME9YajBOdDloTkV4eDVWRUg4MkxaejFzcmxRa1NnRkVWSmpkUUZQVFRXdDhtZm44UXMvMTVOY2lvRGRVL1FIV0dNRTVkbldaQnVkZ1ZZcFg1TzQ9IiwibWFjIjoiNTc3ZjUzMDZhM2Y5N2E4MzZjNGNmMDI2YmIwMDQwZjZiZjVhMGNhNTQ1NmE4NjVmN2U0YmRjODFhZGE0N2YxOSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC, EG, GR, HU, SI, TR, VE, VN', '[{\"id\":\"f5cd3764-b704-4330-bf8b-c87592b152b4\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"801ae642-05ba-47a9-a9cf-90d317bcc8d7\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.012},{\"id\":\"4a9a00f1-129c-49c3-8289-b7512e124513\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.032},{\"id\":\"18c0f34e-bd7c-48ff-a317-60fe74b4dce3\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(871, '529046-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 7.16, 'https://notik.me/api-redirect?token=eyJpdiI6InVESjh1ZHllZ1J1bStVYmRVb1YyR0E9PSIsInZhbHVlIjoielptcEVXVks4NGFYL0lJSzBnbXRxZWFXQy9xOGJOYTBBYkdGU2VTdXhlWkhya1VTcjU5dmNDMCtacHRYaHRJTlhwTW9mbmkrbGNSL3RCYmNGVDNPa2U1SHpvTDdaK00wY1pRSFppeW9IRHlINlJEWFF0VzlMNkhheXNPb1pQVWpkQ2NobVFsaWsvNFRRVW4vZzVlNFpoTHF1Q2xKc25yN1JrSW5JVk4vQXZSYnhYTEsxd1JBMWNjSVZsTGszWmpVQkNLNVhGSXdTZFdua29TRXZBTHVPQzVZUGUrQ3JNYjZhNHpEb3V0Tm84YmRWWnpWbzNpMUx2YktNeVdEbi9OTnBqQ2I5emxiZ1JGNTQxMGVTL1g5MVRENWEzSEJ5RUViNGhiNkplbDhHUnM9IiwibWFjIjoiMjA4OWRiMTY2M2U5N2IyYTViYjEyMzgxMWIwNmE5YTgxZjQ2OTQ2YjFkMjFiZGU2ZmFiYWQwMGUzN2QxNDkzMSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"9e8ac4ec-f23c-4ef2-ba56-49e611329661\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"acc9046f-b026-481c-a158-98365f5247a4\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.5},{\"id\":\"ae1320de-75b2-45dd-a2f8-a2d53b9a9940\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.7},{\"id\":\"c5eeb27d-ae21-4197-acb6-d3d6da77590c\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":1.96},{\"id\":\"3934e6e9-548a-4ba9-85c8-dc3fc5775a4b\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(872, '1418967-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 3.54, 'https://notik.me/api-redirect?token=eyJpdiI6ImxuU2hIMmhMM05JRUFoZ1BXY3liR3c9PSIsInZhbHVlIjoiQTFYRXA1eEtETXRrNjNJRXgxVFkvYnNaM3luRFljS3BtVnA0N0MrTlBRWGRxaGlBT0kzRDY1dDN6QkR1QktkZlZuUzBtOUJNVlhka0R5MWZUU21DNTB4UUFIYnBEZTU5Sm9SRkZTMXVyd2F2UDB4dThqaUFMaGt3bjl2QVJVYXY5K1N2ZUJVb21yWWJNbVAzYUFkQlpGb3Z4Qk1OaXVTcTJhYVdiQjg3SDJEUHVjNUFLcFduTGM2dFZVY3M4Tm1tMUViVXVQcHBjNDJKOHBJMEx1Y1JVTkc0Y2VJVTNJVUtVZTZma2dmZWY1VDFidDdzd1BGRmlZK2RiRmxoV2MwakVGZUNhblhuN20zUzFoUUpJTTQ4S0RNbFo3WVEvNGdTdGljeVg1dEFxSHM9IiwibWFjIjoiMmQ3ODY1MTU0ZmE3Y2E5NmNlOWJjMzdhZDJhMzg2ZmQwMmZlOTA4YzM4ODkzOTg4ZTU1ZDhlN2YwOWE3ZmI4NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU, NZ, GB', '[{\"id\":\"a16f19ef-f2cc-4aa4-af2d-9ad4d6d9077b\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"77dd4128-402e-47b0-b74d-ca37cc4e016c\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.22},{\"id\":\"b3386a11-3182-409e-a208-fd68849e59eb\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.34},{\"id\":\"ee60a055-5add-4435-a825-23df15804d70\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.9},{\"id\":\"f8da8ebc-75e0-4cf0-9dda-71eb24fb3bf1\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":2.08}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(873, '1418968-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 3.54, 'https://notik.me/api-redirect?token=eyJpdiI6IlRKelYrUUUvaGpFL2FUYjFjSmxYR2c9PSIsInZhbHVlIjoidzA0eisxMU05SVVUZDIzVmtFSk8xU05qdmVuQU1aeHpPbkxXSkNwL3hadzVFVnRBeU9nTjdzaEszRWN0c0c2eWpLdXJGOVRQRkNiL2N5RzA0YzR3SkhZcy81Tk5JYWJRa1JLV0s4cDJnbkNLbmQ3VmtpWHk1TzQyYllxYzd0akI1WStNZFEvTFBsc0daa1FDTE1nRkI2N3YzYXUxZ0FtaFp1SDdpQjZBdEVJVW4xTkloZzBpUHZsanhlQTlScjFVSHBxVHhYcUQ0RjFXWGhsOUR3NjZPNERkckVTZ3IzZDh3YjlvMkpra2NsY083QkRxanB0VitKd2FsMzRDcVdVVUlKYllMZktYMVF1WnIwVjdTSjc3QVdnRmo2dEN1T1BwUUVCblVDOC94cFk9IiwibWFjIjoiMzAyOGMyMjBhNTc1M2Q2MDI1YmZkN2M5MGI5MzNkNGU5NWYzODQxYjg3ZGJjNDkyY2E2OTFiZDJjNDRmNTc3NiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KR, SG', '[{\"id\":\"e3cea564-1084-4c48-aaf0-18d0c4ceff63\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"329e5afc-e20a-441e-bdec-14fb1d3bfbe3\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.22},{\"id\":\"539a6b92-73bd-47f5-a9dd-973338d9ae98\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.34},{\"id\":\"d203ae1c-9dab-4e50-b29b-d953676ed0be\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.9},{\"id\":\"bab10cc1-9e46-4a52-9f4f-68037a3b7a38\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":2.08}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(874, '1418969-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.82, 'https://notik.me/api-redirect?token=eyJpdiI6Ii8ySnNXbGd4dk5UcWFCbVh6UzZySWc9PSIsInZhbHVlIjoibHZXT1M1YUJvZmpCVDFxUTFLMDEvWnlPU0Z5UFdWaWNGcTdJbnZKbnlHcEl5aVFvSXdxaWRyVTFSeGRWTzQ1dzd3UXBDZHdhWnZtc25FR3hMSSs1WHRhdSszNDhYZG02NmJOcUtRZHRnOWFOeDRLUG5VSjAwU2J2N0hYWWg2V3lMOEk4citZZG5kWFIrNEYyMDB5RzhoU3AwNEp4ZEdMU3Y5US9HLzB1cXViTnZXdlJoUjdxb1lwcGRIN1paRk85S0E5cHZudlRrOEtwdVV5N3ZTc3lFa1FSYVRMRitGK1lsakFuOGtvcm9LMTU2dUpGSVIxZHREMGhJb0Q1MGxUekE1TEtIbmw3d3h6TzRVUTJaRjdpeE5hSVBFK28zVHVWVXdML25DWDF3azQ5WXBtMzZyYk5nRDlhUnpMempNa2ciLCJtYWMiOiI4MmVhYzUzMjQxZDY3YzE0Y2M3ZTNlODZkNTg4YjlhODMyNDNlOWJhMmZhMDBjMDE4ZTllZjUyNmMyY2UxOGFkIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"de7abe29-60c2-46cc-8981-9196d1ff85de\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"b763c3e0-45fc-4292-9392-a8fe943caac9\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.14},{\"id\":\"f2dcfe6e-5938-4f97-b874-7791c73867b0\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.236},{\"id\":\"93157041-238b-46c0-beaa-19ac90fcba3b\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.56},{\"id\":\"8fd4c020-0e72-4f28-98e0-7e50864c645f\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(875, '1418984-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.82, 'https://notik.me/api-redirect?token=eyJpdiI6Ilk0bVpXUUhSSkdnT3M1ZWFnYWJHTUE9PSIsInZhbHVlIjoiQTNuQ1ZKeW1BRlVORTlsQk8xVWJJR29JbkJycjBNODd3SGpKS2U2UUEzUGtXU0xDTE03OGFxWklQQlFZL25YMjdEZ243alhacjZMMWFYaDIzS2gzVlpLS2hXQm5waFIxbUZSYXlxVE9TSzg2YjcrU05TWFJ0Qmo5UzhDYlJCYzloMDcxd21LamtOTG9sQXJpb29uajE3d3pqWFFibnBUc2ZYcGlwT2o1K2hHL0w0NnBINVoyMFNSYUwzaGxMREJDYXBSVFVoeTRlSXVGdEhkZGlBdXdBSG5TZTBOTG9zQVB5d1d0cW1iY0YxTUlVcFNSaVNYTmJFOUthakNiVDhGMU9pNzVRbDUxT0huajg1ZllvOXdKUzFOYW1xTEx0WlUxWHkvYktlamVaN2R4aDJ5bmhzd3Nid2pPRGgwNkNyR24iLCJtYWMiOiIwMWVmOTkzNzc3YmY5OThjZDFmY2QxMzhiZmQ3NjFlNTM3MmFhOGRmNWJkNTkwYjZmNGRhYzEwNWFkYWVjZmMzIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, JP', '[{\"id\":\"d0699ce9-1165-4208-a317-4c2934f53d95\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"efb30461-4866-4833-9746-09a1304118ff\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.14},{\"id\":\"a40505ea-f7df-4509-ab0c-356a794c159b\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.236},{\"id\":\"f13b57e5-3a6e-44be-b170-87c1c133c8ca\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.56},{\"id\":\"18e21961-85e0-41a9-a8e7-876448f0e384\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.88}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:12'),
(876, '1418985-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.44, 'https://notik.me/api-redirect?token=eyJpdiI6InI1VHRPZDFwRTBJNStXSTdoRFNFTUE9PSIsInZhbHVlIjoiMmh4N0RROTBmNS9MTk5IWjZ3QWRTcDdNdzZBRFpwRWhvMVFYNDFIWGJWSHNUQnJlSEdQRjVENHVyOGhzbWFnL0Q3bENEMnZHMytQNStpUHk3c2UwS2NGb05mNWZkQzQrTTFhMUdQTVc3azc2RzRoYUMydEdqdjlRZ3ZsWTFqYjdXWUZYLzIyNEo4cDRxWHIxVWFzYk1rWFoyQVlUSjhsclhlQVdkdmtxTzAybHZacW9lcWRJV1BBZHc5WVRvWldWNUpLRzM4RlNRU01KSStxalQ4NCtoVlZCb2hDY1M5Uml6enR0L0k4Zm5PL3ZPYU5Xd1grRTNReHNCWm1lUklkM2xmZGNSWXlwbjc2czBlcUt0Z2p0RXh4dnQyWm9ybjEreUlLblFqbWkrVGs9IiwibWFjIjoiYjc5NmM0NDFlOGUyMGQwODY0OGU2ZTMyNTdjY2FmMmY1MTc1ZTVjNDQyZmY1Y2VlYmU5M2M4ZmE4OGMxN2IwZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BE, FR', '[{\"id\":\"d083bb31-c706-4977-a58e-ff1858ab66a0\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"bc0ff796-afc6-4b7c-958e-5dc824363e89\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.1},{\"id\":\"035478b3-b78c-40d3-b326-bece3d5725cf\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.14},{\"id\":\"bed58017-0e27-4f5c-86e5-d351f9711c75\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.44},{\"id\":\"c38eae05-633f-4ec1-8b00-61cea7636326\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(877, '1418986-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 1.44, 'https://notik.me/api-redirect?token=eyJpdiI6IkNFZHB2MXVkczZyQ0lOU1FJZEdsdnc9PSIsInZhbHVlIjoiQWJmNFZsSHpyUmoxb05DeE5sS2pUQkxucVZxbGlyR2xuRjJrT2VKOWxuSWRQcEpsakV4enlSL0kzaFpzakNnejNuSXQ2RW1zU09wMFdiV1BCRmJZYzZ2WUhuUVF0UjIwL1FhTUc3dXZrTlBpeGd2dTZ3NnVuVDNBTld3ZENKNzhPSDRNWHlKQnQ4d1Uxazl4d3B4b0RpazdMWXdmbnVKVGpkY09GbjJxSjFLdjc2Y1hjSWxEWlB0ZWNHSUkzaEFwanU2em43ZlRjN0JDSzhUU1JwN3Nmbm96cXVkNDFEU2FSUmZmb0U3VHNaNDZwb1YvM3g3dDdkMWtBT0JCaWR6RE1KWjlqZkVTYXdHMUtBWTNLa1hqWTB6Unl4YUpQZGYrSlErNk9XZGZKUkk9IiwibWFjIjoiNzdjYTUzZWEyZjkxMjZlY2UwMjZiZDlhYjQ3MzcyNjU2N2JmZThiZWE4YTRhZjgyM2VkOGMyNTU3ZDQ2ZWY1NCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, IE, NL, NO, SA, SE, AE', '[{\"id\":\"864efdb1-0578-490c-bf1e-39d1cf68370a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"0b3e6087-3397-40d4-847d-2492c12100e2\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.1},{\"id\":\"8e4462d0-0cfe-4b06-9687-596f66722cc6\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.14},{\"id\":\"2f77afea-d2a4-4304-9840-78c2a0d68174\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.44},{\"id\":\"4a0ed594-058b-4ca6-bee5-4a31f79f0880\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.76}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(878, '1418993-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.72, 'https://notik.me/api-redirect?token=eyJpdiI6IjdOU3V4Q2dzZjFNdFNkQmxOUkZNaFE9PSIsInZhbHVlIjoia0J6L0pCTjVhNy8rUDgzNExpeUF6OSswUUxCbmoweE5MY09pdU9EcTFGL0l3NE5zK25zSmVMQWx0K2pGcjZ4MzhIMHpiT3FSd1FVWnI2ZHpSZnFrTnJsdmZoTFBmdEFnYmJPSWRJbDRNbW55TGFBNGlLVUhKZXRjMXByV0QvdXJxdVBEVEFjYTRObnl1cU1zL2J4WUdWN0o1bDQrYUhjYjdrYnRVMjVZcFYrNGQxc2lDYWhkVDNSeHloYmFXR3FyY2lZUGdOd1oxS09GQjZFUG55azMzTWcwTE96eGpaczkvZ2llT0RGem5GNU8zUGQ2RytlOXVFeEdQb2Faa296b05VNGdCanpvenpGcjlRYTBETmkrbklxcyt1Y2E1WHluMERMVTh2YmVIVDg9IiwibWFjIjoiNjBlZmY5OTZkZjZkYjgxYWUyOGQ4NTU5YTIwZTU3ZGJhY2Q3MWQxYjUxNzA2NjE3ODQxY2QwY2Q4MTIwMjNiNyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'FI, IS, IE, IT, KW, QA, ZA, ES', '[{\"id\":\"15e74231-ee45-41e8-a85f-6d49ed192492\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"e3dfe5d2-a451-407f-a879-ab776f1c1e2a\",\"name\":\"Reach Level 50 in 5x5 board.\",\"payout\":0.056},{\"id\":\"8954ec87-87a4-4bcf-80d6-48ebdbd27638\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.06},{\"id\":\"4ddc8571-8b1c-4bbb-b0c8-3fef4b674f4e\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.224},{\"id\":\"0d4ad28b-33cf-4a91-b0ba-bc7b1a5f8aff\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.38}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(879, '1419007-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.54, 'https://notik.me/api-redirect?token=eyJpdiI6InNQQjJZNWU5Z1c4UWF2ZHZydlFFUGc9PSIsInZhbHVlIjoiQ25nNWNCN29DMWtCazhMalNHMCtnVmVVVmtNYTBqUmhkbWhGd2NuOFk3TzRQVHFNSVk3TWxXT0xSaFV1bXA4cWN1WjJZMzlmUGpDS3lRcERsZ0hiU1Yvd2RocVk1ajNYZ3NyRGNuMWlJMW8vaW1NS0dlMkR5Ky9iR3VGZGpsaUZVRC8wQmdmTGdKc3BBUHQ3MkFIVXpnYmJ1MStIckU0Y0R6NS82TE8xMUViQW5qL09kWEV6amFqUVliWHhWU3FUNGJsN2JEWWxZYzRja0Jadk5RUlVHeDdpQ0txdWtzVEFJV05FVFkvVkNWczBaeFViQnZ5RmdiUlY2NGpzTG1JOW5VYXpoQTREYmR3dVpSSDZjVDg0NlUwZG1sdm9lVWdTbkxsYjdPZENaSUU9IiwibWFjIjoiYTg1YjNiZjZhMzkzNTRhYTkwMTlkNjEwNzZhYzI2OTBhMzBhMmVjODI0ZGViOTliNjUxZGYxNWI4ODU0NWExMyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, MX', '[{\"id\":\"3356152c-dddf-4a13-97f8-3ed583ea4be7\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"e1f9e516-abf9-4e4c-8aa7-84979f1d5ca8\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.06},{\"id\":\"6ae03525-2f6e-48a0-9094-bb8cd385e33f\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.168},{\"id\":\"b1b85a91-717d-41e4-b349-76113dd2ef2a\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.308}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(880, '1419008-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.36, 'https://notik.me/api-redirect?token=eyJpdiI6ImZPQ3VaaVBtcldSaUxIa01hS3BnaVE9PSIsInZhbHVlIjoiaW5LVE4ybUwrdW9zTzIxdnM5N1pLdjVCSXNsajR1WnR0ZHRkVDdJaGNJU2NvLzBHdzhGQ2RDaDEzbUFzYzJZMFdaekd2aGlzMkVSSUNwNjlhUSt3WUpmTW5tVzY4S3lsOFRKU1F4anVaT2hEUDRJczdtRVhVaFBnU2tqL2pqZGdrOGI0U1lUbyt1Q1p6YkVrZVNBaXpsMFJPQWk2SjJOUFFPd2xWYWxWbytGSjJEN0pqRDljMlNETGp5dHp3eWsxK1lkUTRjTzhQYjZ4eUNSd3pVZTJEaXFPeDdnb1dVMFRLWTRya2J1aU4xNTVuNnFyYXo1eitKOVFLaW9hb1EwS042VWx5VmxPK3R0aUpYVFpmN251SmNSMXBzS1UyYVIvZVY1MVFkVkFabms9IiwibWFjIjoiODVkYWU5NTA0MmIwZWMxNjkyMTk0Nzc4OWM0OTNjMDM4MDk2ODVmOGY0NmMxNmYyZjQ3MzA1YzJiZDI2YTM4NSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, MY, PT', '[{\"id\":\"94ff6619-7bb9-438e-985c-ede791d6e8b8\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"0ddc8e17-49d1-42ba-8068-52ee6601f1c3\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.04},{\"id\":\"6720fe69-6fa1-46d7-8bd5-237b068ffc2c\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.112},{\"id\":\"eab98167-353d-4041-88b6-0f07ecb3d441\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.208}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(881, '1419021-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.22, 'https://notik.me/api-redirect?token=eyJpdiI6Ilh3RmFLWkpDMlB1aHFHR0hyeWUwQ2c9PSIsInZhbHVlIjoibFZZbk44QVJLVHg4UXNjNWdDbHFsTFNheWhGMWhpUkU4L3p6N3Q1UmFPMFo2TzVtWlgwQWwyRWFqTE9VaVpldWxQNWZsUm1VaCtQSXU0MjMxYjYzWVdTZUN5YlFpd3B5dzhQdHhJVnNVZitSMEM3RUlzY04vb2F2T1RudnJ5eVh1TkxtR01wWmRUVWJ1aWNOVGs2VVRkMlA3azY1cXg5aVVHZzNBNzdFSHRTMlI3cjBuTy9jUDJMVDcvS1FvdTBnckFaT3QrTmVjN3dWQW11V2N5N3ZDVit4MTZXbzZMVzBMRVNsQ2ZETm5jQ2U1QkgwSmlXZFlhbE5ndWRncy9DOVlFT3NSd2tGUTZDdG1VZmplS20rN2ZiVll5YnZNOENyVnZCdkkyT2hIS0RGbUh2NkllcVRicHN4ODN5Wi9JS0wiLCJtYWMiOiI2ZGZmM2IyNTI0Y2JiMDRiMmEzNGMyNDNiNzIzNTllMjcxMzI0MmUyMzIxNmJmYjUyMGQxMjMxMTg3NTI4YjU0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AR, BG, CO, DO, EG, SV, ID, KE, PA, PE, PH, RO', '[{\"id\":\"f0b07ebe-d7e5-4feb-b7a8-1355fc495887\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"b441aad2-e507-4fd9-b4e0-32ac0c27d454\",\"name\":\"Reach Level 100 in 5x5 board.\",\"payout\":0.024},{\"id\":\"a78391f7-1457-48c1-b563-a4cde1d1a5d1\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.06},{\"id\":\"84bed7d1-0b62-4fad-9bee-5ebc8d55d1fd\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(882, '1419028-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6Ik9jenpTZ3hiMUVJTUtJbVJmcjF1aUE9PSIsInZhbHVlIjoiSk9peSt1TXJTdFlJVnduRk5LUmFmRnEvcEFzN2trRFh1K2tGRUFjTEdqTUZLNnVQc3FJNlFpV3hCbzRXQnlyOG5BRVdna3lZY0ttUklvZkRKMVZtR1NVc2dZL0Z6WFVaMzE3QW9HTDJKOGlUWHZXRjBKZ0FLTkhyQlFNR0FxdXhFSjBNRDEyUU10MnNRRG11dHZQTTFVWHpFSjZaQkcwOGRDTVArSnJFdnBjc1pWRlRoelk2T3F3NVJZM1FGZXdRU0I4UTVMRjFXRUZvQVdzaUFkUlllZHpZTnU0WjkxQjg4WmFvemRyakVsclA1V21MREVLS0Y0MDhyUVlhMEtoU3lrZ1VVNjl0VXYxZUNscmlFVGprY2doS2YwczFRQUgweHB1S016WW82TjlNSXdPWTZSNHdZd2gvNE1ZWkxPeDciLCJtYWMiOiIzYWM3MGI3YzgwNTEwNGUzYzdkNGU1YTZhOTQ0ODI2NmEzYTllMDQ5ODAyYzRkYTZmOTIzYWMwNmVhNDgyNzQ0IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'EC, EG, GR, HU, SI, TR, VE, VN', '[{\"id\":\"b9593633-49eb-4ef1-8917-8526b66ee3a1\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f7be0513-9f48-4267-a2e8-a3ecf624ce28\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.032},{\"id\":\"b864345e-3c40-440c-9775-fde6abb2a418\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(883, '1419035-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6IkdSWjJkeG4xSEVHdHNvMElzM0N0NXc9PSIsInZhbHVlIjoieEVucFpZM0YyODJTMkdpeGllanQzYkJoSUVDMWxpbzl5dUFyZUFaenZ2eHhLckdiVjlEMWF4OVpVbWZUbE10cWYwb1RkT2Y4dWhWTnpGdFdYZXZWYkxFbllpQi9teGgwN3VONDZYWGVuYlNEYmU4MGV6WUg5b0xOdzBvdk0wK3Y5M2RUeEJPZnYvQlNoSkxLVG5Pc0l0UnFrYjhnTWFpZzJ3eHVGcWxZbWpHY0pTREpxU1hUQWs4NGJic2NXRjQzOUhxZGpRVFNrWU5JeG9WS0l0RW95QzRReUJnUEJpRHRpaFlsT0NISFo3dEZvZlRpdUpmQjJpYWc3RXB5cjFYUGo5QVUrbTRQY2k5T3JhTzl1Nndkc296ZHJoK3pRckVOamNIenlIdzlWYkt1ZWl1Y0VuZjI4WnBmc1k3eUdpMUsiLCJtYWMiOiIzZGE4OWQwZmRiMGIxMjRhNmM0MjFhMmE5MGNkN2M2NGFiMWNhMmJmZTc3MGZkMGI2M2VjZTViYzI5NjY3YmZjIiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CZ, PL, TH', '[{\"id\":\"9c7c6be3-60bb-4dce-aadd-7b5d63072a09\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"4d9cfb40-73d0-4480-be3e-e35edb4f130a\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.032},{\"id\":\"280e86ee-6b38-4bb0-8169-5ce8cacac7e3\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(884, '1419036-lZ2kToJFfVYWxuk6', '248: Connect Dots Pops Numbers', '', NULL, 0.09, 'https://notik.me/api-redirect?token=eyJpdiI6ImQ2TmhST0svNmpGK2dXU24ydHRkSFE9PSIsInZhbHVlIjoiMkNoeHh1a0tEMXBCbEZ3L2RLUzlCRkZSTTF3YnJyZDF3RFp3NFI3R1FZMlh6cHhadEJlZ2lubnFTL2drSkMwWmExYkREWEZ3TEt4eFNUS2tpRGhmR2kxU1hPVitUWlB0NGFoN1pac2k4bTNQWnpkWVMrVGVtSUZYYzh3cG1yV1l4WDE4VU8yUU5US0cxYXVtZmo5R0puQThpa01HUmRFa3c3SjlIbHhYUmdRUTNybU41SlcxTGZZNy90Y25RT2phenVZVGlRbmVJMnNqeWI1aElJREZqSUZMS0pjYXRUTEt1T2YvUzM3RTl4ZlFJL1VpWXJqa1JyT282MTk4dGpYTVRqWVcrQ1A4QVFXZnZTR3NGTEJpYm1zRXpQMFpsWkRmUWhtR1BQNVFyY1pJdTMyWHdkbUJMVEg2cXVjeDErRzgiLCJtYWMiOiI3M2NkOTQ1MzRlZTNjOTQ1MTlmN2ZjYzhmNGY2NDE0Y2EzMWZmZmRkZTRjZGU0Zjc0ZmVjZWRlNjU4NzY2NmQ4IiwidGFnIjoiIn0=&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'IN', '[{\"id\":\"288e2a37-b685-478d-a9b7-bf76fefca4e4\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"1b9155a5-11a5-46e4-a033-c6b700cfdf9a\",\"name\":\"Reach Level 250 in 5x5 board.\",\"payout\":0.032},{\"id\":\"65ab03d8-b70c-4508-80cd-9ffe4d38861a\",\"name\":\"Reach Level 500 in 5x5 board.\",\"payout\":0.06}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(885, '1419205-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 10.32, 'https://notik.me/api-redirect?token=eyJpdiI6InFNdmhVTXV1ZTcvTUZ4QllyRXNlTkE9PSIsInZhbHVlIjoibE00T09malI0TWk2UmJ6elQvMlYwSlRPQjNtYTZWTG9FeUgwMzhBNVZIdHV2Qzkxc1g4U3R6WGNwVnBLQVczaW9na0MxdzFCMFpwbzJJQjlWai9DejJ3aG9Ud0FSeFdIUWx6aFhnR1FoRUhiKzg4a1NtUkUzYTZhbm1SRnFOQStGWjZLY0FtL2hQRWYzSVkwZVFFOVIyRlk3K1dLK1N6RnRrUUdVdFo5Z1VHaUpiQ3RMaHZ0MTFheEJ2RzhHWkpCT3drQXQyUW1neTdRdG80Rk1QVU9ranA4VG1Oak1TMkdYd29jaDRuVTRxdEhuU1ZCbGR6UGJkRmJXZFZYNnVReExTMGtEMXpiaE4xZDRUVG1yNWJWd0xGZzVUK20wM21STjVyWGh6aVc3b2M9IiwibWFjIjoiNTY2MDM4MGE5NzgxNjIzYjEyMWY4NjJiMDE5YzA1ODY0YzJkZGMxZmYxZTk4ZTZiNDM5N2FiOWI2YjQxZWJiZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"b1de4ffb-115f-43c0-b234-62ba1dc307f4\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"36b0b8b4-ee92-49c8-b2f8-75bb72c0e336\",\"name\":\"Reach Level 50\",\"payout\":0.22},{\"id\":\"64473923-7e57-4804-9cb0-7aa7564f8068\",\"name\":\"Reach Level 100\",\"payout\":0.5},{\"id\":\"bebc9def-ab2b-4a6d-91c2-b604ff0d2404\",\"name\":\"Reach Level 250\",\"payout\":1.2},{\"id\":\"d269847d-c6c2-4016-aedf-0d20f3c728db\",\"name\":\"Reach Level 500\",\"payout\":2.4},{\"id\":\"d4d7ae20-4cd3-4b8d-ad7b-c371af00bab5\",\"name\":\"Reach Level 1,000\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(886, '1419208-lZ2kToJFfVYWxuk6', 'Gemdoku: Wood Block Puzzle', '', NULL, 10.72, 'https://notik.me/api-redirect?token=eyJpdiI6IlBUNWhMN2U0aUsySS9JWGNSdmY1RGc9PSIsInZhbHVlIjoibUczNm5VQXZjMzdnY0xsSWx2eTh6OEFabitBQXdiMEpBcFhRaHIwdGpwMFV1QU1NdFI1Z0Y1aUtBQ3AvY2RCb0g4Z2NRdWRMblA3QTFPMkY0eXE1enc4TzYwZkNKMWpudHhuRGErbkU1L3h2Z3IzdkhWUk1hN0FjRk85L25Gck0yUk9oR0VnTzNSV0NTTFBhZkIrRDdtQTRneHFSRFk0bGJiNldvK3cwclVLZFRWd2dnZHdGa0hVK2hZR2srOUdzODArUU94eVFhc1NIazRRcnk4Q3hDYm1scGd1SjFuWDBqb3hZQS9ScGdKdW5kK2RLQlRVU1NIeDd6N2NCWlpEODFwVHNUNE1rVnNKVDhOMXF2MmZGMC9FNGtwdllObFRvUFFjd1d4dnh1ckk9IiwibWFjIjoiZmQyOWJkNTA4NTY5MWY1NjAyNjQ2MTliNGIyODQ3NTQzNTBlNDEwMTJhYmJiNDRhZjFhMmVmZTk3MTliMzFjMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'NZ, SG, GB', '[{\"id\":\"65750950-2f8b-4075-8cad-c1eb9f112e21\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"408da060-0a66-42cc-a888-b9e4521d7f5f\",\"name\":\"Reach Level 50\",\"payout\":0.32},{\"id\":\"b59c8bd8-87cc-4ce6-890c-cc0abf77ddb5\",\"name\":\"Reach Level 100\",\"payout\":0.6},{\"id\":\"70b654b1-6c7c-4ed8-98f6-218a1a3ff252\",\"name\":\"Reach Level 250\",\"payout\":1.4},{\"id\":\"4a160348-a42c-4931-b61c-70bc69cc0803\",\"name\":\"Reach Level 500\",\"payout\":2.8},{\"id\":\"fc87c525-8c39-4091-874d-b241a3673926\",\"name\":\"Reach Level 1,000\",\"payout\":5.6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(887, '675253-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 1.08, 'https://notik.me/api-redirect?token=eyJpdiI6IkthQVZUS0d2K0NSUnErQkUzQ01DSGc9PSIsInZhbHVlIjoiT09jdC81V0w2WHZFOG05VXdkNXlLQ1lBNkNuVWFvSFVmYUxLRklqNTFEQjVXZFdLYXdlY002NVBNdkFYdktwQytram5WRkxkVjVVUXpQMUY3RHk5Z1pmMVdXWThyVDJYU3hXUmo3QWhjc2FXMVI1NFloc0FKNVVsOTFYSmRHS3lGNkNBNXg0Z1VNZXc2NERheDAyMXdzQVVsWDN1NU50VCtocFNnTlJxTWM5UnZ1b3RWZlRabXpYQnZqd0RPdlFSRVNIRTQ3MUlCQXZiM28zTHFkTHhKUFVsM3FUMlZLM0pQQ1A2elNXc2pGVmw4UVBtcXBrWWxiU3JMZHF0VU1ZaHRJbCs0WmVRYzJiU0tPQ3dyRmloNzJ1Y3h1by91T0wyOUhwelJuL24wYWM9IiwibWFjIjoiYzljYjM1NzZmMzhiZDcwYmQ5N2Y3MGU3ZDMyMjQ1YzNkOWIwZWIzNTQyZTVjM2M5OWVlOTliZTdjZTU3MWY2OCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CO, CR, DM, GT, PA, PE, UY', '[{\"id\":\"89b37061-d84f-4b2f-a522-4653a3019990\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"79f42610-7383-44ee-948b-03b8915286d5\",\"name\":\"Collect 25 Stars!\",\"payout\":0.036},{\"id\":\"1ed389ae-c6c4-452d-86bd-5e45a774ec68\",\"name\":\"Collect 50 Stars!\",\"payout\":0.048},{\"id\":\"1ec285f5-8638-4711-8739-4d2d41bdf5c4\",\"name\":\"Collect 100 Stars!\",\"payout\":0.1},{\"id\":\"ae2ac2db-4c4e-4c87-9cc5-efa5347ab516\",\"name\":\"Collect 250 Stars!\",\"payout\":0.336},{\"id\":\"cf5e260d-2252-4bd9-a430-8029a494e7cd\",\"name\":\"Collect 500 Stars!\",\"payout\":0.56}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(888, '675243-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 30.20, 'https://notik.me/api-redirect?token=eyJpdiI6IjMyekFwZlBTVnlqL2Jubi8xRlNHWGc9PSIsInZhbHVlIjoiYXdWM25HcG1OUDE5cWNNckg0NUVkR3hYNUcyZDJ3ZW5VS0oyQXI0VmNROENNVzJSbDJpek9ESXhLdDAvYzNWaTBXZmYxYlJUVkdudHRLNTI2MHVhOUg1RnQwQ2oyODNTRE1YNmx0TEtpVUdFa3VVTUF5OC9FdGluSzBzV0RNUGt0Nkc2VW8rbTJmZnp0TVBKNGZzOVNnUnhYNThURi82VU4yU3RDNWV5dEUxUDkvOWZ1V0E4L2hQT1RiaEZGNHJWSDlBRmlmWnExbEFKNzhlQ1ZRUHVFdHlIME9nMGVxZTRyYWxyeHhyR2NCV25ET2JIUHB0MmxVMVQyYXZoUUJCaGlMZzlzalZIRGJKVTRxZ1BHaCs1Tkx4WlVlTW11YlZYbmh0d2RYa0l5bDQ9IiwibWFjIjoiMjRkYmY1ZGM3YjhjNjE0YTg5OGQwN2Q4YmNjMDcyNWJiZDBkN2ZmZDliYWFiNjQwNGQxY2RmNDQ0ODJkYzlmZSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'US', '[{\"id\":\"13d214db-a4ee-4ee7-a67c-3be2d8f9c334\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"36d80508-b132-4831-b186-ec884f5d22d4\",\"name\":\"Collect 25 Stars!\",\"payout\":1},{\"id\":\"3dee824e-4d29-4b54-8363-b5d4b2313271\",\"name\":\"Collect 50 Stars!\",\"payout\":1.4},{\"id\":\"0bc45e94-1be1-4f9e-a65b-74b012c69013\",\"name\":\"Collect 100 Stars!\",\"payout\":3.8},{\"id\":\"af0ba845-6ff7-4e60-9f21-434c85676c87\",\"name\":\"Collect 250 Stars!\",\"payout\":10},{\"id\":\"0628d89a-bd54-4c12-851e-d20b209da187\",\"name\":\"Collect 500 Stars!\",\"payout\":14}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(889, '675244-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 17.74, 'https://notik.me/api-redirect?token=eyJpdiI6InVDWU9jUDZpemdlMURBd3h0SVNpT2c9PSIsInZhbHVlIjoibDZXc2JhUmViMW1VaDNhVUlkaC9DSitpbEFvUkZBRnRwZUhGbjdVZTJMZjI4STFzN3YycDh5NWNwVzAyOXVIVU1mZmlObGI4Y2VVa2l5QjdTTWVvaCt2cEVNa2JXaThzWW1EQzBCMWNnRXZ2SkJsNDJlSFBkNkFSUC85cTh5S2dza3VhbmU3SnpXZllRbkk4OXJzMjZFZ05WUEZEK2UzVkZ1V0JGN2lNaFI2ZGpkRnhZVUZVREJtL0w2U0gyNno3SWZXNFEvYTdFOElXdnBzOFFLQTBtRStRaFVrS2Q0NHhwOUZPOFZwLzhPOWtCdXJUN21oanhUTGNoZmRaU3IwVVl3aHRCUnpZNW1pREQrellFV0dqcHgxUitxWnNSbG1ydXQ3MnpiU1NJSTg9IiwibWFjIjoiNTQ3N2Y1MWNlY2JhZDRiNjY3OTk0YjMxNzUyNDdhMDc5M2E2OTBkY2M3NzYxYTQxZmY5ZmIyOWYxZTU3MDMzZCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA, AU', '[{\"id\":\"b566da79-65ed-4d3a-b5ce-214ef4622f24\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f21c861a-35a9-45f2-8b8e-ad23f1ada92b\",\"name\":\"Collect 25 Stars!\",\"payout\":0.56},{\"id\":\"94fc9beb-a383-433e-822f-3d26ca438415\",\"name\":\"Collect 50 Stars!\",\"payout\":0.7},{\"id\":\"4734b59b-2f91-4a76-a3d4-e502bd5ba963\",\"name\":\"Collect 100 Stars!\",\"payout\":2.08},{\"id\":\"ab69b677-ee62-4309-b0d1-ac212d5fc15d\",\"name\":\"Collect 250 Stars!\",\"payout\":6},{\"id\":\"443f1863-c73c-4de7-8c51-edbcff8119a3\",\"name\":\"Collect 500 Stars!\",\"payout\":8.4}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(890, '675245-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 19.54, 'https://notik.me/api-redirect?token=eyJpdiI6Im5IYkdYM0FHcU5iTzhZWTlxelVDcEE9PSIsInZhbHVlIjoiWFU2eGlwWGY0WlNJRzJRQndXb3lidkJiZ2Y3bmtXT3YyYy9mcmlmaXEyTGxIdWlMMXJlK1J2UEgxZ0E1bWV3ejRseUFib294SVpyN1Jua01MTFRjUC84cjZUd0JPUTl3MzIrekU3aTlMWWQxNHV6M2ppSUkrWWhZWjN6eFk1VllLWWdDajg5UEdEUW5EeXBtalI5R2Jqd3BuUXh6MmdRTkRhc3Ztb1ZyYW5oWkozTTFqekk1QmU1eDhsdXZFb1VYOVVJbEs1TGZ4bm1aMDVBcktWWDF3U3cvK3hYZ1F5TThZWXovbkh2aEdMcDYveGJKdFB0cm9zUkhoZ1Q0eUlXdjkyZEc1Y0RTYjlaUVpVZkNURWVGMFl4RzZEelVBYytKNitFTjN2SjI3eTg9IiwibWFjIjoiMjc1M2M4Y2MyMDA5NmQwNGIxYmY2ZDcyODE3NzM2Nzk5OGJjNmFhYTFmMjQ3NzA2Njg0Mjk1MTU1MGJkMzhjYiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[{\"id\":\"9a16ec95-f031-495e-8e53-3b287df0221b\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"d031b012-6530-4c2f-8e47-4c1a631ffd93\",\"name\":\"Collect 25 Stars!\",\"payout\":0.7},{\"id\":\"0becf259-3cb7-42ee-919b-d783f7e73276\",\"name\":\"Collect 50 Stars!\",\"payout\":1},{\"id\":\"15215793-9697-4727-a858-82ec6133eb12\",\"name\":\"Collect 100 Stars!\",\"payout\":2.24},{\"id\":\"8f620661-714f-47b7-b7d0-11d2fdfde5ec\",\"name\":\"Collect 250 Stars!\",\"payout\":6.8},{\"id\":\"b9f99690-4379-448a-b881-57ac8fcb25d2\",\"name\":\"Collect 500 Stars!\",\"payout\":8.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(891, '675246-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 14.60, 'https://notik.me/api-redirect?token=eyJpdiI6InIyYkYvak96TWt6Zlpob1VGZkRiVVE9PSIsInZhbHVlIjoiSjJxNlhMVXZja25NMlVnaTh3ellpQVByRDhLbTIvVzh4bFJveVpQTGp6aElaREs5WGpXR0NGaVo0NnZzc2ZtSGdocjdwTVZyZjgwVEpDVy9yYm4xb2VLTVk1bmp2YW9ETTg2SDdYazhnS2hxeHJ4MWpLWCs1NEhNZy9Ydmo1T3QxRldTTVN1UDdRKzFJZkU1ZnMzcG50bUc4T2lNcWxjalBsaGxUeXZvcWxLL0dNSVArMTYzMTZTOVVKeFRiQ1Q0dmpXQ2EwdHVzZEVBWGN3VWw1WGp6QzlQMXZDY0hNWUR3K2VrUm9hck8wa05WOHhHZDBHd1VCZ1RjVjVXL0RzOFR3UXdJamp5VWpDWFVVaW50QkVnc2tTR0luUzBBOEJGMkJaOWlHVWtNOHc9IiwibWFjIjoiYjA3ODY3M2MwZjBjYzVkMjQ5ZDkwM2U5MjZiOTRkYmNiMjg4YmU4MDBhZjMxNDcwNTkwYTY0MmJiNjZiMTk3MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'KR, NZ, SG, GB', '[{\"id\":\"f230c499-7069-4347-9ad8-844c1dc068f0\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"424cd543-48a7-4c0b-b508-fe92d51519e0\",\"name\":\"Collect 25 Stars!\",\"payout\":0.6},{\"id\":\"3fd8fa56-0ebd-4a7d-ba5e-0a355fd0c25d\",\"name\":\"Collect 50 Stars!\",\"payout\":0.66},{\"id\":\"e87a695d-6f03-4555-9bc6-a4c2b8c49859\",\"name\":\"Collect 100 Stars!\",\"payout\":1.54},{\"id\":\"e7a97e31-2848-4a47-9ef5-c414c103b081\",\"name\":\"Collect 250 Stars!\",\"payout\":4.8},{\"id\":\"1bcf1725-268c-43dc-9da3-31c74cc772c2\",\"name\":\"Collect 500 Stars!\",\"payout\":7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(892, '675247-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 12.94, 'https://notik.me/api-redirect?token=eyJpdiI6IlRWM0RIVnFhbW9LQzB2LzJHOVcxUFE9PSIsInZhbHVlIjoiZGJ1anpUbHpCRnlQdDdYL1N5VllRVllKTVd4OUxJREZSRlZZdWg1V0Q0aDQ5OVNXelpUcmtCUHdkNmNiaGZSdEJmcjZHQ2t1QktPQWtYcFNyWTRjWFFicm80RkkyTjBSbjVXUEJUMnpXUHJsek5NOXJJYUlrZTJpUTBuQlowUjFzRDg5V3Bjc253RzFWcWQrVVVKalJIWW0ydTMwd3lFWUt3YXUzc0w0eDFGSy9SL3F1RHZLeXNNb20yd2pHTjAvdHJ6SXdNVlU4SFJmSDBxMVFPYkNSNmVLN3hNNnlRUmdCT2tzWWwwcFI1NU9Hb2FMaHlpSWpnUDl0YjlrZGlLem9OSXdYVGNMSWVRc3JGd3g3bUtVZGJJTEU4bTFTWk1NekJtZkFoM0dRMk09IiwibWFjIjoiOTQ3NTY1MGIyOWI1NTcxODM3ZTQxODQ0NWMxNzczNTY4MWVlZjkxYzRiZDNmMmFjNzUxYjkzNzEwYmRmMjk4NyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'AT, DE, CH', '[{\"id\":\"708ec2b3-dd73-4f81-9a8c-69cccbbdb0f9\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"f0ed15f2-80a8-463c-ad35-82c71ad2f2eb\",\"name\":\"Collect 25 Stars!\",\"payout\":0.48},{\"id\":\"996137a5-93e6-4a54-9a56-373149e1a343\",\"name\":\"Collect 50 Stars!\",\"payout\":0.66},{\"id\":\"a97a4e35-d353-4e1c-9885-ce20ab22b049\",\"name\":\"Collect 100 Stars!\",\"payout\":1.4},{\"id\":\"a983426d-5a9c-4604-a3eb-fa17c1d1f2d8\",\"name\":\"Collect 250 Stars!\",\"payout\":4.4},{\"id\":\"0bbe8740-084c-415a-8aac-c03269daa24a\",\"name\":\"Collect 500 Stars!\",\"payout\":6}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(893, '675248-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 14.46, 'https://notik.me/api-redirect?token=eyJpdiI6InVmSlozbXhTVGNCSXROL2pFejNxZnc9PSIsInZhbHVlIjoiUks1TWFvTm9WaGNMK2wwVE8zQ0xwRGJyd3N5elFTU2V2QzQ4UStCalgwcjV3eThNYldoNUR1SWxPdlUrU1JaeCtremdRcVFHRjNJeDQvYkFkSTh1OVp4UG4yZ1NXbXNVby9lbEZ1SEdTRi9LdVdJVkJqVVBTMjhaVnZjall2T3gvWkRMZzNBNjVtNXNmLzJDdERLUVhLc21zelBaNDAyc3hVTlI2SjFLSXBYWnlKbW1lbzNMcXpmZ3pQbXJvRFpRUkY0WmdhZzJ1YldtdGNSRlJSSTdiOGZpb1U2REFaOWFFbHVITmYydGxjcXNkUEorMHVLdFNXa0ROWnBKYVpqdVhkbEJwT3I5L0dMRkJLbUVhUXFra0FsbWE4bjQ0OEJtL1dhNXRhTkg2RzQ9IiwibWFjIjoiNTk2YThjZjcyNGM5ODY0Yjg5YTA3OTE1M2U0MTIwMjNlYjUzNTZjODE4OGIzNzQxYTNlMTM3ZTZlYzdiYWI0MyIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'DK, NL, NO, SE', '[{\"id\":\"b2706d56-b467-4f16-8763-3dd739f1d2ff\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ac635cc5-834c-45fc-80aa-45cbbdcd69d3\",\"name\":\"Collect 25 Stars!\",\"payout\":0.6},{\"id\":\"7358185c-e0f8-4d91-97bd-c22f78b1bfe7\",\"name\":\"Collect 50 Stars!\",\"payout\":0.66},{\"id\":\"bdffd4b6-a73d-4daa-941d-8a9e9690700f\",\"name\":\"Collect 100 Stars!\",\"payout\":1.4},{\"id\":\"7c0b7f1a-b71e-4123-aad0-f94235c2ba67\",\"name\":\"Collect 250 Stars!\",\"payout\":4.8},{\"id\":\"212cf5f2-80f3-4dcd-a854-060a76db6cd9\",\"name\":\"Collect 500 Stars!\",\"payout\":7}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(894, '675249-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 10.34, 'https://notik.me/api-redirect?token=eyJpdiI6IjBUWFVBZVZmaWtOSlpzYmdQUnNGd3c9PSIsInZhbHVlIjoia0FFRU00T1IrOEpVcHJiR0hkSnJJQytFc2dBRlVHQUxXZU83a2hoVnpEblVPR3d6SG9JQnhodWNVb1RoMFVtOFJhNGdQQ1AvWHZXZ2R4VFBoT01sOTNJd2pPQitpeFRZVW1nZ3pUY0tuTXFaNzltSlg2MStMZWJ4UXdkdGJGVjVDWFZDRlRiVzBOaVlob1oyd0drbGJSUmE3TDNROHNHbVZrLzc2N1c2OHAzUWpoSHhqWVNvUlBCTHpNWkkwQlRWcUJpSXIycEFMdXA4V3Q3bElhVDc0bldTMGdzenVwVXRzaTZnT2k5TzV1aXl2REZyM2g0ci9pNFlpSmlxLzZocCt0ZzV6Y0JMdWtMYmtiNDBVeDBGaHBETzRXSk1WVjMveGNucHVUSjRhN0E9IiwibWFjIjoiZGUzZGJhYWFhYmEwZWM4NzY3YzExNzRiYmQyYmUxOWE1YjU3ZDk1OGRmY2U5NzI4ZjkxY2YyYmM1NmM5YzVkZiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'HK, KW, QA, SA, TW, AE', '[{\"id\":\"29e93226-c2a9-4c1f-bc37-a05940735b52\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"30961df3-edc4-4d0c-947b-883f1034b4e7\",\"name\":\"Collect 25 Stars!\",\"payout\":0.5},{\"id\":\"bcf2bbc1-9dd5-4f63-b620-f4e1d00fc03a\",\"name\":\"Collect 50 Stars!\",\"payout\":0.56},{\"id\":\"e2174f12-a871-4330-87b0-915c262ce068\",\"name\":\"Collect 100 Stars!\",\"payout\":1.12},{\"id\":\"be63f0f9-784c-4a24-bd5c-6039588b62b1\",\"name\":\"Collect 250 Stars!\",\"payout\":3.36},{\"id\":\"815b8ff5-8e20-45e4-8956-670d17da730d\",\"name\":\"Collect 500 Stars!\",\"payout\":4.8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(895, '675251-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 3.95, 'https://notik.me/api-redirect?token=eyJpdiI6IjVrUmZGUnBMRFdRWERxVGFtY2h5MGc9PSIsInZhbHVlIjoiWUtobTZuTHdNQ3BoMTErYkZXYi92RXdDWEgwUTkrbDJPM2Ruc2dZRmp6ZVUwTE5tQXo1K3FoREJiZ0M0S2lTbXJBTk9EQjVOdDljQUt4aGMrQ2xSV2xOOFZDUW5XQzgxMG4yOXlHekIxT0hBeVp2ZGNiUFJuWW5KTE5STnEwM09Wc2NkNmVSU1p3a056OE03SGMrTWFzdTI3N1RuU0gzYnRkRnpuQko3ZFV4dFlydU0xUUY4YVN2dnBSeFVmR0RWNkZkMlMyb0dyL2gyNjZNSFlxRmF2b0s3dmVVeFF5WkUweHJvS3VuYm9kMTJzYWdrQUU2Z1lyNUhCeXVQSThiMTdGYjVwSkVhcXdOdXIwSDBVRXRGMHFFMm9tM0xwaGhJSkJSK2hhZ1dXU2c9IiwibWFjIjoiNzExMjA1Y2E1YTNjYTRjMDkzMmU0Nzg2NmY1Y2RhMTc1NjlmMmZhNDc5ODFmYTE0NjgxYWExMzY2MmM3ZmNlMCIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CL, EC, IT, MX, ES', '[{\"id\":\"efec9c95-e1db-47b4-8b04-5521756d4bcd\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"ee38b948-1ccf-407b-ab82-3e71dbe0e023\",\"name\":\"Collect 25 Stars!\",\"payout\":0.168},{\"id\":\"44ea7049-0413-4cbb-b22c-312f7eea549c\",\"name\":\"Collect 50 Stars!\",\"payout\":0.224},{\"id\":\"d1b8fd09-9388-4547-adc3-8e052605213a\",\"name\":\"Collect 100 Stars!\",\"payout\":0.48},{\"id\":\"6f8ed20c-0496-4e8f-a32e-000d416798a7\",\"name\":\"Collect 250 Stars!\",\"payout\":1.12},{\"id\":\"49554189-cd85-4914-b01f-e03ba192d3f8\",\"name\":\"Collect 500 Stars!\",\"payout\":1.96}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13');
INSERT INTO `offers` VALUES
(896, '675252-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 2.26, 'https://notik.me/api-redirect?token=eyJpdiI6IlhUcWdSTTB6WHFPc3lENktMR3ZuZVE9PSIsInZhbHVlIjoiYXFsUlFxS1p6TDhmMVpRYjJ3YmhZY0RFYWJkVzllRUNJSzVxeStSeFlWZ0xlN09abTRjU1BwSlhhcWdDSWNNWk9neGthY0xGLzU1SGYvTVA5cEU1VTR6eWpyampDeExuYTV1ZGZiVzFnU0tnRjgvRFlMRkpOTXV2MnlKR2dUWS9vZDF4aC9IcTJYbHlDUmlRYng2OVlRKytvK2pNazkvdjlkdTQ2TlM1T2E2ZmM5anlhakkvK1o2Um9KUStVWDZ4MGltNFJ2QUVwUXllaVJ4TktnRFBWSjIvamVnOXlmT01rdXBqcDRiRFpzL2RzWDhNZXo4NloxTGpYb1Jkb0hlcE43SUZtZWZwc1RFL252L2dhcGR1QjZQWWxwUHkrWTFJUitwanhFMStudXc9IiwibWFjIjoiY2YzMjQzZDM3NDc3YWMyMTY4YjNlNjY0NmQxMjc1ODQ1YTkxNjM2ZmU3MmRkY2RiZDhiYWU2NDUwZGMxMDIxNSIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'BR, PT', '[{\"id\":\"81af619d-b779-4401-bb21-554c0db4264a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"5d32c501-db9c-40d1-89b9-fb516efcc793\",\"name\":\"Collect 25 Stars!\",\"payout\":0.088},{\"id\":\"3ca176ef-79c6-43ae-a9fb-06c42a281bda\",\"name\":\"Collect 50 Stars!\",\"payout\":0.112},{\"id\":\"a3c5b39f-ef55-4ad9-86fb-baa6a7964446\",\"name\":\"Collect 100 Stars!\",\"payout\":0.236},{\"id\":\"e87ff52c-9a9b-46e5-83c3-908125c4832f\",\"name\":\"Collect 250 Stars!\",\"payout\":0.7},{\"id\":\"456de34f-59e8-4cec-ae08-279dc7101260\",\"name\":\"Collect 500 Stars!\",\"payout\":1.12}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(897, '675212-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 17.34, 'https://notik.me/api-redirect?token=eyJpdiI6IkxlZnQ3R3lOMTh0d0hTN3R3VWdhcVE9PSIsInZhbHVlIjoiWUpVVU5MTFJGZ1F4SWYwa0tvK2VHWDB3UGduY1BYbUlWWFlYTFZQWGFYcStxWUNVSDJZaFBRWDlYb1B6Tk1Fbit0YXBsL3dESHpETzhyeWtjR0xtYVdJWlZReG5GRUk2eVpWL3VGa2hndjFsWGFoY01CeUNxRUJaLzBYMWZ6dTQzS3hnSU8yeWFucVZXVW42R3dwTGV1aG5kdXZYU1J5T3U2cG8xK2VkaU5VUEk4bThRUFBhNkV6TXhxSUhJZUp3MDRVdzJzQlFMcEQzNjRDUnBpSlF2V2w5VS95TXB1RFVkUUxIVDJtNjNmZHJFSmVBNG1mRWlMUGcvam9tZ1MxSkQ5eWtPQUR2aENKMWlhQ0FzZlhMcnE3RTdLM0JsL1NwWmhLWW5odkw1ZVk9IiwibWFjIjoiNzcwNmI3ZWE3ZDAxMWI0YmYwYWIwMDllNmIzMDk0ZjFjYThlZGRiODE1OGUyMTdhZWY2OTdlYjkxMDdhODk2YiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'CA', '[{\"id\":\"43645af3-6815-49db-82a3-592b2d3b3e0a\",\"name\":\"Get the game!\",\"payout\":0},{\"id\":\"5ba92ea8-75c3-4ced-91ad-6c12ae387d33\",\"name\":\"Collect 25 Stars!\",\"payout\":0.56},{\"id\":\"951f6a8f-fa95-47a4-8c68-e84cd28fc585\",\"name\":\"Collect 50 Stars!\",\"payout\":0.7},{\"id\":\"d50a5d0e-343c-4502-8d88-248f0d254d4f\",\"name\":\"Collect 100 Stars!\",\"payout\":2.08},{\"id\":\"96518b23-d9d3-4fdf-89f7-4429d99e40e6\",\"name\":\"Collect 250 Stars!\",\"payout\":6},{\"id\":\"2def728f-6b23-4263-9850-ac2ff1eb7f57\",\"name\":\"Collect 250 Stars!\",\"payout\":8}]', 'mobile, tablet', 'notik', '2025-02-26 13:09:57', '2025-02-26 13:11:13'),
(898, '675213-lZ2kToJFfVYWxuk6', 'Zen Life: Tile Match Puzzles', '', NULL, 18.62, 'https://notik.me/api-redirect?token=eyJpdiI6IjJpSFJXSXUwNW1qWUlEUy9jMjIzZFE9PSIsInZhbHVlIjoiN1dCTkgycTJ6eEZqVDFmTWlZcURmRzJPMFhUT1o5VnNHTkQvR2lvNC8rcXJFMlNNKzJVVGZicWtKeEt4c01NYm14MTVJdFhDdG1NRExEOU50TkFRdEs4SHUva0RsYWliOWptclI2bEpadDlTVFRPaXlVMXdPemFZdWdpbWdhVHE2V2VTaURiL0ptSG4rMDN1Q3BBNmJ3RkIySEdRZEVpSW80T3dmc25YVkQxMDZWaTByN2YrcElkeXhzQVNQOWZxck9uYjkwVStUNXhoTVpiVTNBMjllVFdKM3RPcHBGOEhTMGJtQWxqa2J0MnppV3l2cnk1b0ROQ1B0ZlNEdDdrMHd3S3MyWWZ6OElsSW81bXRNdmdpbFhkV1ZsNGhXeWJGem5SRGtoZ3o1aTg9IiwibWFjIjoiYTJjY2FiZjA4YzJjMDdkOGQ3OGE1M2E0ZmNmYjI0MzA4MjAxNzA0YzM3NDEzYWFjYzE4N2UwNDU4YWE0ODNlNiIsInRhZyI6IiJ9&user_id=ZkGzCi_HSwTgDFOA6_[user_id]', NULL, 'JP', '[{\